/********************************************************************/
/*          AgbMacro.h                                              */
/*            AGBW}N֐                                     */
/*                                                                  */
/*          Copyright (C) 1999-2000 NINTENDO Co.,Ltd.               */
/********************************************************************/
#ifndef _AGB_MACRO_H
#define _AGB_MACRO_H

#ifdef __cplusplus
extern "C" {
#endif

#include <AgbTypes.h>
#include <AgbSystemCall.h>


/*------------------------------------------------------------------*/
/*                      f[^ǂݍ                              */
/*------------------------------------------------------------------*/

#define DataRead(Readp, Bit)    (*(vu##Bit *)(Readp))

/*------------------------------------------------------------------*/
/*                      f[^                              */
/*------------------------------------------------------------------*/

#define DataWrite(Writep, Data, Bit)                    \
                                                        \
    *(vu##Bit *)(Writep) = (Data)

/*------------------------------------------------------------------*/
/*                      f[^ Rs[                               */
/*------------------------------------------------------------------*/

#define DataCopy(Readp, Writep, Bit)                    \
                                                        \
    *(vu##Bit *)(Writep) = *(vu##Bit *)(Readp)


/*------------------------------------------------------------------*/
/*                  荞݃AhX Zbg                         */
/*------------------------------------------------------------------*/

#define IntrAddrSet(Intrp)                              \
                                                        \
    *(vu32 *)INTR_VECTOR_BUF = (vu32 )Intrp

//E荞ݏ̃AhXZbg܂B

/*------------------------------------------------------------------*/
/*                      cl` Zbg                               */
/*------------------------------------------------------------------*/

//#define SIMULATOR
#ifndef SIMULATOR
#ifndef CODE32
#define DmaSet(DmaNo, Srcp, Destp, DmaCntData)          \
{                                                       \
    vu32 *(DmaCntp) = (vu32 *)REG_DMA##DmaNo;           \
    DmaCntp[0] = (vu32 )(Srcp);                         \
    DmaCntp[1] = (vu32 )(Destp);                        \
    DmaCntp[2] = (vu32 )(DmaCntData);                   \
}
#else
#define DmaSet(DmaNo, Srcp, Destp, DmaCntData)                   \
{                                                                \
    vu32 *(RegBasep) = (vu32 *)REG_BASE;                         \
    RegBasep[OFFSET_REG_DMA##DmaNo##SAD/4] = (vu32 )(Srcp);      \
    RegBasep[OFFSET_REG_DMA##DmaNo##DAD/4] = (vu32 )(Destp);     \
    RegBasep[OFFSET_REG_DMA##DmaNo##CNT/4] = (vu32 )(DmaCntData);\
}

#endif
#else
#define DmaSet(DmaNo, Srcp, Destp, DmaCntData)                   \
{                                                                \
    int    i;                                                    \
    for (i=0; i<(DmaCntData & 0x1ffff); i++)                     \
        if ((DmaCntData) & DMA_SRC_FIX) {                        \
            if ((DmaCntData) & DMA_32BIT_BUS)                    \
                    ((vu32 *)(Destp))[i] = ((vu32 *)(Srcp))[0];  \
            else    ((vu16 *)(Destp))[i] = ((vu16 *)(Srcp))[0];  \
         } else {                                                \
            if ((DmaCntData) & DMA_32BIT_BUS)                    \
                ((vu32 *)(Destp))[i] = ((vu32 *)(Srcp))[i];      \
            else    ((vu16 *)(Destp))[i] = ((vu16 *)(Srcp))[i];  \
        }                                                        \
}
#endif

//EDMARg[Ƀp[^Zbg܂B
//ESIMULATER`CPUŃV~[g܂B
//  GDBŃfobOꍇȂǂɗLłB
//
//EF
//  DmaNo       DMAԍ
//  Srcp        \[XAhX
//  Destp       fXeBl[VAhX
//  DmaCntData  p[^f[^
//
//CPURAM̃vOɂDMAN
//  ̖̎߂Ɏs܂B
//  āADMAɓ]CPUɂĕύX悤ƂꍇA
//  ǂݍ݁^߂̊ԂDMANĂ܂܂̂ŁA
//  DMA̓]̃f[^Ӑ}ĂȂlɂȂꍇ܂B
//  ̏ꍇɂDmaWait()𒼌ɑ}āADMAI
//  ǂ`FbNƑR[hւ̉emɉł܂B


/*------------------------------------------------------------------*/
/*                      cl` NA                               */
/*------------------------------------------------------------------*/

#define DmaClear(DmaNo, Data, Destp, Size, Bit)             \
{                                                           \
    vu##Bit Tmp = (vu##Bit )(Data);                         \
    DmaSet(DmaNo, &Tmp, Destp, (                            \
        DMA_ENABLE         | DMA_TIMMING_IMM |              \
        DMA_SRC_FIX        | DMA_DEST_INC    |              \
        DMA_##Bit##BIT_BUS | ((Size)/(Bit/8))));            \
}

#define DmaClearIf(DmaNo, Data, Destp, Size, Bit)           \
{                                                           \
    vu##Bit Tmp = (vu##Bit )(Data);                         \
    DmaSet(DmaNo, &Tmp, Destp, (                            \
        DMA_ENABLE         | DMA_TIMMING_IMM |              \
        DMA_IF_ENABLE      |                                \
        DMA_SRC_FIX        | DMA_DEST_INC    |              \
        DMA_##Bit##BIT_BUS | ((Size)/(Bit/8))));            \
}

#define DmaArrayClear(  DmaNo, Data, Destp, Bit)            \
        DmaClear(       DmaNo, Data, Destp, sizeof(Destp), Bit)

#define DmaArrayClearIf(DmaNo, Data, Destp, Bit)            \
        DmaClearIf(     DmaNo, Data, Destp, sizeof(Destp), Bit)

//EDMARAMNA܂B
//ENAf[^̓X^bNɒuAfXeBl[VփRs[܂B
//EDmaClearIf^DmaArrayClearIf͏IɊ荞ݗv𔭐܂B
//EDmaArrayClear^DmaArrayClearIf̓fXeBl[VzŜNA܂B
//
//EF
//  DmaNo       DMAԍ
//  Data        NAf[^
//  Destp       fXeBl[VAhX
//  Size        NAoCg
//  Bit         ]rbgi16|32j
//
//
//CPURAM̃vOɂDMAN
//  ̖̎߂Ɏs܂B
//  āADMAɓ]CPUɂĕύX悤ƂꍇA
//  ǂݍ݁^߂̊ԂDMANĂ܂܂̂ŁA
//  DMA̓]̃f[^Ӑ}ĂȂlɂȂꍇ܂B
//  ̏ꍇɂDmaWait()𒼌ɑ}āADMAI
//  ǂ`FbNƑR[hւ̉emɉł܂B

/*------------------------------------------------------------------*/
/*                      cl` Rs[                               */
/*------------------------------------------------------------------*/

#define DmaCopy(DmaNo, Srcp, Destp, Size, Bit)              \
                                                            \
    DmaSet(DmaNo, Srcp, Destp,  (                           \
        DMA_ENABLE         | DMA_TIMMING_IMM |              \
        DMA_SRC_INC        | DMA_DEST_INC    |              \
        DMA_##Bit##BIT_BUS | ((Size)/((Bit)/8))))

#define DmaCopyIf(DmaNo, Srcp, Destp, Size, Bit)            \
                                                            \
    DmaSet(DmaNo, Srcp, Destp,  (                           \
        DMA_ENABLE         | DMA_TIMMING_IMM |              \
        DMA_IF_ENABLE      |                                \
        DMA_SRC_INC        | DMA_DEST_INC    |              \
        DMA_##Bit##BIT_BUS | ((Size)/(Bit/8))))

#define DmaArrayCopy(  DmaNo, Srcp, Destp, Bit)             \
        DmaCopy(       DmaNo, Srcp, Destp, sizeof(Srcp), Bit)

#define DmaArrayCopyIf(DmaNo, Srcp, Destp, Bit)             \
        DmaCopyIf(     DmaNo, Srcp, Destp, sizeof(Srcp), Bit)

//EDMAŃRs[܂B
//EDmaCopyIf^DmaArrayCopyIf͏IɊ荞ݗv𔭐܂B
//EDmaArrayCopy^DmaArrayCopyIf̓\[XzŜRs[܂B
//
//EF
//  DmaNo       DMAԍ
//  Srcp        \[XAhX
//  Destp       fXeBl[VAhX
//  Size        ]oCg
//  Bit         ]rbgi16|32j
//
//
//CPURAM̃vOɂDMAN
//  ̖̎߂Ɏs܂B
//  āADMAɓ]CPUɂĕύX悤ƂꍇA
//  ǂݍ݁^߂̊ԂDMANĂ܂܂̂ŁA
//  DMA̓]̃f[^Ӑ}ĂȂlɂȂꍇ܂B
//  ̏ꍇɂDmaWait()𒼌ɑ}āADMAI
//  ǂ`FbNƑR[hւ̉emɉł܂B

/*------------------------------------------------------------------*/
/*                  guNcl` Rs[                         */
/*------------------------------------------------------------------*/

#define H_DmaCopy(DmaNo, Srcp, Destp, Size, Bit)            \
                                                            \
    DmaSet(DmaNo, Srcp, Destp,  (                           \
        DMA_ENABLE         | DMA_TIMMING_H_BLANK |          \
        DMA_SRC_INC        | DMA_DEST_RELOAD     |          \
        DMA_CONTINUOUS_ON  |                                \
        DMA_##Bit##BIT_BUS | ((Size)/((Bit)/8))))

#define H_DmaCopyIf(DmaNo, Srcp, Destp, Size, Bit)          \
                                                            \
    DmaSet(DmaNo, Srcp, Destp,  (                           \
        DMA_ENABLE         | DMA_TIMMING_H_BLANK |          \
        DMA_IF_ENABLE      |                                \
        DMA_SRC_INC        | DMA_DEST_RELOAD     |          \
        DMA_CONTINUOUS_ON  |                                \
        DMA_##Bit##BIT_BUS | ((Size)/(Bit/8))))

#define H_DmaArrayCopy(  DmaNo, Srcp, Destp, Bit)           \
        H_DmaCopy(       DmaNo, Srcp, Destp, sizeof(Srcp), Bit)

#define H_DmaArrayCopyIf(DmaNo, Srcp, Destp, Bit)           \
        H_DmaCopyIf(     DmaNo, Srcp, Destp, sizeof(Srcp), Bit)

//EHuNɓDMAŃRs[܂B
//EH_DmaCopyIf^H_DmaArrayCopyIf͏IɊ荞ݗv𔭐܂B
//EH_DmaArrayCopy^H_DmaArrayCopyIf̓\[XzŜRs[܂B
//
//EF
//  DmaNo       DMAԍ
//  Srcp        \[XAhX
//  Destp       fXeBl[VAhX
//  Size        ]oCg
//  Bit         ]rbgi16|32j

/*------------------------------------------------------------------*/
/*                  uuNcl` Rs[                         */
/*------------------------------------------------------------------*/

#define V_DmaCopy(DmaNo, Srcp, Destp, Size, Bit)            \
                                                            \
    DmaSet(DmaNo, Srcp, Destp,  (                           \
        DMA_ENABLE         | DMA_TIMMING_V_BLANK |          \
        DMA_SRC_INC        | DMA_DEST_INC        |          \
        DMA_##Bit##BIT_BUS | ((Size)/(Bit/8))))

#define V_DmaCopyIf(DmaNo, Srcp, Destp, Size, Bit)          \
                                                            \
    DmaSet(DmaNo, Srcp, Destp,  (                           \
        DMA_ENABLE         | DMA_TIMMING_V_BLANK |          \
        DMA_IF_ENABLE      |                                \
        DMA_SRC_INC        | DMA_DEST_INC        |          \
        DMA_##Bit##BIT_BUS | ((Size)/(Bit/8))))

#define V_DmaArrayCopy(  DmaNo, Srcp, Destp, Bit)           \
        V_DmaCopy(       DmaNo, Srcp, Destp, sizeof(Srcp), Bit)

#define V_DmaArrayCopyIf(DmaNo, Srcp, Destp, Bit)           \
        V_DmaCopyIf(     DmaNo, Srcp, Destp, sizeof(Srcp), Bit)

//EVuNɓDMAŃRs[܂B
//EV_DmaCopyIf^V_DmaArrayCopyIf͏IɊ荞ݗv𔭐܂B
//EV_DmaArrayCopy^V_DmaArrayCopyIf̓\[XzŜRs[܂B
//
//EF
//  DmaNo       DMAԍ
//  Srcp        \[XAhX
//  Destp       fXeBl[VAhX
//  Size        ]oCg
//  Bit         ]rbgi16|32j

/*------------------------------------------------------------------*/
/*                  cl` TEhehen]                     */
/*------------------------------------------------------------------*/

#if 1
#define DmaSound(DmaNo, Srcp, FifoName)                             \
{                                                                   \
    u8    i;                                                        \
    *((u8 *)(REG_SOUNDCNT + 3)) |= SOUND_##FifoName##_FIFO_RESET;   \
    for (i=0; i<8; i++)                                             \
        *(u32 *)REG_FIFO_##FifoName = ((u32 *)Srcp)[i];             \
    DmaSet( DmaNo, (u32 *)Srcp + 8, REG_FIFO_##FifoName, (          \
        DMA_ENABLE         | DMA_TIMMING_SOUND |                    \
        DMA_CONTINUOUS_ON  |                                        \
        DMA_SRC_INC        |                                        \
        DMA_32BIT_BUS      | (4*4)/(32/8)))                         \
}

#define DmaSoundIf(DmaNo, Srcp, FifoName)                           \
{                                                                   \
    u8    i;                                                        \
    *((u8 *)(REG_SOUNDCNT + 3)) |= SOUND_##FifoName##_FIFO_RESET;   \
    for (i=0; i<8; i++)                                             \
        *(u32 *)REG_FIFO_##FifoName = ((u32 *)Srcp)[i];             \
    DmaSet( DmaNo, (u32 *)Srcp + 8, REG_FIFO_##FifoName, (          \
        DMA_ENABLE         | DMA_TIMMING_SOUND |                    \
        DMA_IF_ENABLE      |                                        \
        DMA_CONTINUOUS_ON  |                                        \
        DMA_SRC_INC        |                                        \
        DMA_32BIT_BUS      | (4*4)/(32/8)))                         \
}
#else
#define DmaSound(DmaNo, Srcp, FifoName)                             \
                                                                    \
    DmaSet( DmaNo, Srcp, REG_FIFO_##FifoName, (                     \
        DMA_ENABLE         | DMA_TIMMING_SOUND |                    \
        DMA_CONTINUOUS_ON  |                                        \
        DMA_SRC_INC        |                                        \
        DMA_32BIT_BUS      | (4*4)/(32/8)))

#define DmaSoundIf(DmaNo, Srcp, FifoName)                           \
                                                                    \
    DmaSet(DmaNo, Srcp, REG_FIFO_##FifoName, (                      \
        DMA_ENABLE         | DMA_TIMMING_SOUND |                    \
        DMA_IF_ENABLE      |                                        \
        DMA_CONTINUOUS_ON  |                                        \
        DMA_SRC_INC        |                                        \
        DMA_32BIT_BUS      | (4*4)/(32/8)))
#endif

//E_CNgTEhpDMAZbg܂B
//EDmaSoundIf͏IɊ荞ݗv𔭐܂B
//
//EF
//  DmaNo       DMAԍ
//  Srcp        \[XAhX
//  FifoName    fXeBl[VAhX


/*------------------------------------------------------------------*/
/*                      cl` I҂                             */
/*------------------------------------------------------------------*/

#define DmaWait(DmaNo)                                      \
{                                                           \
    vu32 *(DmaCntp) = (vu32 *)REG_DMA##DmaNo;               \
    while (DmaCntp[2] & DMA_ENABLE) ;                       \
}

//EDMȀI҂܂B
//
//EF
//  DmaNo       DMAԍ


/*------------------------------------------------------------------*/
/*                      cl` Xgbv                             */
/*------------------------------------------------------------------*/

#define DmaStop(DmaNo)                                      \
{                                                           \
    vDmaCnt *(DmaCntp) = (vDmaCnt *)REG_DMA##DmaNo;         \
    DmaCntp[2].Enable = 0;                                  \
}

//EDMA~܂B
//
//EF
//  DmaNo       DMAԍ


/*------------------------------------------------------------------*/
/*                      bot NA                               */
/*------------------------------------------------------------------*/

#define CpuClear(Data, Destp, Size, Bit)                    \
{                                                           \
    vu##Bit Tmp = (vu##Bit )(Data);                         \
    CpuSet((u8 *)&(Tmp), (u8 *)(Destp), (                   \
        DMA_SRC_FIX        |                                \
        DMA_##Bit##BIT_BUS | ((Size)/(Bit/8) & 0x1fffff))); \
}

#define CpuArrayClear(Data, Destp, Bit)                     \
        CpuClear(     Data, Destp, sizeof(Destp), Bit)

//ECPURAMNAVXeR[Ăяo܂B
//ENAf[^̓X^bNɒuAfXeBl[VփRs[܂B
//ECpuArrayClear̓fXeBl[VzŜNA܂B
//
//EF
//  Data        NAf[^
//  Destp       fXeBl[VAhX
//  Size        NAoCg
//  Bit         ]rbgi16|32j

/*------------------------------------------------------------------*/
/*                      bot Rs[                               */
/*------------------------------------------------------------------*/

#define CpuCopy(Srcp, Destp, Size, Bit)                     \
                                                            \
    CpuSet((u8 *)(Srcp), (u8 *)(Destp),  (                  \
        DMA_SRC_INC        |                                \
        DMA_##Bit##BIT_BUS | ((Size)/(Bit/8) & 0x1fffff)))

#define CpuArrayCopy(Srcp, Destp, Bit)                      \
        CpuCopy(     Srcp, Destp, sizeof(Srcp), Bit)

//ECPUŃRs[VXeR[Ăяo܂B
//ECpuArrayCopy̓\[XzŜRs[܂B
//
//EF
//  Srcp        \[XAhX
//  Destp       fXeBl[VAhX
//  Size        ]oCg
//  Bit         ]rbgi16|32j

/*------------------------------------------------------------------*/
/*                  bot NA(32ByteP)                   */
/*------------------------------------------------------------------*/

#define CpuFastClear(Data, Destp, Size)                     \
{                                                           \
    vu32 Tmp = (vu32 )(Data);                               \
    CpuFastSet((u8 *)&(Tmp), (u8 *)(Destp), (               \
        DMA_SRC_FIX        | ((Size)/(32/8) & 0x1fffff)));  \
}

#define CpuFastArrayClear(Data, Destp)                      \
        CpuFastClear(     Data, Destp, sizeof(Destp))

//ECPUōRAMNAVXeR[Ăяo܂B
//ENAf[^̓X^bNɒuAfXeBl[VփRs[܂B
//ECpuFastArrayClear̓fXeBl[VzŜNA܂B
//E32bit]8Wordi32BytejPʂŃNA܂B
//
//EF
//  Data        NAf[^
//  Destp       fXeBl[VAhX
//  Size        NAoCg

/*------------------------------------------------------------------*/
/*                  bot Rs[(32ByteP)                   */
/*------------------------------------------------------------------*/

#define CpuFastCopy(Srcp, Destp, Size)                      \
                                                            \
    CpuFastSet((u8 *)(Srcp), (u8 *)(Destp),  (              \
        DMA_SRC_INC           | ((Size)/(32/8) & 0x1fffff)))

#define CpuFastArrayCopy(Srcp, Destp)                       \
        CpuFastCopy(     Srcp, Destp, sizeof(Srcp))

//ECPUōɃRs[VXeR[Ăяo܂B
//ECpuFastArrayCopy̓\[XzŜRs[܂B
//E32bit]8Wordi32BytejPʂŃRs[܂B
//
//EF
//  Srcp        \[XAhX
//  Destp       fXeBl[VAhX
//  Size        ]oCg


#ifdef __cplusplus
}      /* extern "C" */
#endif

#endif /* _AGB_MACRO_H */
