@********************************************************************
@*          AgbMemoryMap.s                                          *
@*            AGB}bv萔iGASpj                          *
@*                                                                  *
@*          Copyright (C) 1999-2000 NINTENDO Co.,Ltd.               *
@********************************************************************


@--------------------------------------------------------------------
@-                      E}bv                              -
@--------------------------------------------------------------------

BOOT_ROM                =   0x00000000          @ u[gqnl
BOOT_ROM_END            =   (BOOT_ROM + 0x4000)
EX_WRAM                 =   0x02000000          @ botO[Nq`l
EX_WRAM_END             =   (EX_WRAM + 0x40000)
CPU_WRAM                =   0x03000000          @ bot[Nq`l
CPU_WRAM_END            =   (CPU_WRAM + 0x8000)
WRAM                    =    EX_WRAM            @ [Nq`lS
WRAM_END                =    CPU_WRAM_END
USR_BUF                 =    EX_WRAM            @ [Ü
USR_BUF_END             =   (CPU_WRAM_END - 0x60)
SYS_BUF                 =   (CPU_WRAM_END - 0x60)@VXë
SYS_BUF_END             =    CPU_WRAM_END
SOUND_AREA_ADR_BUF      =   (CPU_WRAM_END - 0x10)@TEhhCo [NAhX
INTR_CHECK_BUF          =   (CPU_WRAM_END - 0x8)@ 荞݃`FbN
INTR_VECTOR_BUF         =   (CPU_WRAM_END - 0x4)@ 荞ݕAhX
REG_BASE                =   0x04000000          @ WX^Q
REG_END                 =   (REG_BASE +  0x300)
PLTT                    =   0x05000000          @ pbgq`l
PLTT_END                =   (PLTT +      0x400)
BG_PLTT                 =   (PLTT +        0x0) @   afpbgq`l
BG_PLTT_END             =   (PLTT +      0x200)
OBJ_PLTT                =   (PLTT +      0x200) @ naipbgq`l
OBJ_PLTT_END            =   (PLTT +      0x400)
VRAM                    =   0x06000000          @ uq`l
VRAM_END                =   (VRAM +    0x18000)
BG_VRAM                 =   (VRAM +        0x0) @ afLN^/XN[q`l
BG_BITMAP0_VRAM         =   (VRAM +        0x0) @ afrbg}bvOq`l
BG_BITMAP1_VRAM         =   (VRAM +     0xa000) @ afrbg}bvPq`l
OBJ_MODE0_VRAM          =   (VRAM +    0x10000) @ naiLN^q`l
OBJ_MODE1_VRAM          =   (VRAM +    0x10000)
OBJ_MODE2_VRAM          =   (VRAM +    0x10000)
OBJ_MODE3_VRAM          =   (VRAM +    0x14000)
OBJ_MODE4_VRAM          =   (VRAM +    0x14000)
OBJ_MODE5_VRAM          =   (VRAM +    0x14000)
OBJ_VRAM_END            =   (VRAM +    0x18000)
OAM                     =   0x07000000          @ n`l
OAM_END                 =   (OAM +       0x400)

ROM_BANK0               =   0x08000000          @ qnl oNO
ROM_BANK0_END           =   0x0a000000
ROM_BANK1               =   0x0a000000          @ qnl oNP
ROM_BANK1_END           =   0x0c000000
ROM_BANK2               =   0x0c000000          @ qnl oNQ
ROM_BANK2_END           =   0x0e000000
RAM_BANK                =   0x0c000000          @ q`l oN
RAM_BANK_END            =   0x10000000

FLASH_1M                =   0x09fe0000          @ PltbV
FLASH_1M_END            =   0x0a000000

@--------------------------------------------------------------------
@-                      ETCY                              -
@--------------------------------------------------------------------

BOOT_ROM_SIZE           =   0x4000              @ u[gqnl
EX_WRAM_SIZE            =   0x40000             @ botO[Nq`l
CPU_WRAM_SIZE           =   0x8000              @ bot[Nq`l
WRAM_SIZE               =   0x48000             @ [Nq`lS
USR_BUF_SIZE            =   0x47fa0             @ [Ü
SYS_BUF_SIZE            =   0x80                @ VXë
PLTT_SIZE               =   (2*256*2)           @ pbgq`l
BG_PLTT_SIZE            =   (2*256)             @   afpbgq`l
OBJ_PLTT_SIZE           =   (2*256)             @ naipbgq`l
VRAM_SIZE               =   0x18000             @ uq`l
BG_MODE0_VRAM_SIZE      =   0x10000             @ afLN^/XN[
BG_MODE1_VRAM_SIZE      =   0x10000
BG_MODE2_VRAM_SIZE      =   0x10000
BG_MODE3_VRAM_SIZE      =   0x14000             @ afrbg}bv
BG_MODE4_VRAM_SIZE      =   0x0a000
BG_MODE5_VRAM_SIZE      =   0x0a000
OBJ_MODE0_VRAM_SIZE     =   0x08000             @ naiLN^
OBJ_MODE1_VRAM_SIZE     =   0x08000
OBJ_MODE2_VRAM_SIZE     =   0x08000
OBJ_MODE3_VRAM_SIZE     =   0x04000
OBJ_MODE4_VRAM_SIZE     =   0x04000
OBJ_MODE5_VRAM_SIZE     =   0x04000
OAM_SIZE                =   (8*128)             @ n`l

ROM_BANK_SIZE           =   0x02000000          @ qnl oN
ROM_BANK0_SIZE          =   0x02000000          @ qnl oNO
ROM_BANK1_SIZE          =   0x02000000          @ qnl oNP
ROM_BANK2_SIZE          =   0x02000000          @ qnl oNQ
RAM_BANK_SIZE           =   0x02000000          @ q`l oN

FLASH_1M_SIZE           =   0x20000             @ PltbV

@--------------------------------------------------------------------
@-                      WX^EAhX                          -
@--------------------------------------------------------------------

REG_PAUSE       =   (REG_BASE + 0x300)  @ o`trd

REG_IME         =   (REG_BASE + 0x208)  @ 荞݃}X^Cl[u
REG_IE          =   (REG_BASE + 0x200)  @ 荞݋
REG_IF          =   (REG_BASE + 0x202)  @ 荞ݗv

REG_WAITCNT     =   (REG_BASE + 0x204)  @ JZbgEFCgRg[

REG_DISPCNT     =   (REG_BASE + 0x0)    @ \Rg[

REG_STAT        =   (REG_BASE + 0x4)    @ Xe[^X
REG_VCOUNT      =   (REG_BASE + 0x6)    @ uJE^

REG_MOSAIC      =   (REG_BASE + 0x4c)   @ UCN TCY

REG_BLDCNT      =   (REG_BASE + 0x50)   @ uh[h Rg[
REG_BLDALPHA    =   (REG_BASE + 0x52)   @    p[^
REG_BLDY        =   (REG_BASE + 0x54)   @ PxύX p[^

REG_WINCNT      =   (REG_BASE + 0x40)   @ EChE  Rg[
REG_WIN0H       =   (REG_BASE + 0x40)   @ EChEÖ
REG_WIN1H       =   (REG_BASE + 0x42)   @ EChEP̈
REG_WIN0V       =   (REG_BASE + 0x44)   @ EChEÖ
REG_WIN1V       =   (REG_BASE + 0x46)   @ EChEP̈
REG_WININ       =   (REG_BASE + 0x48)   @ EChERg[
REG_WIN0        =   (REG_BASE + 0x48)   @ EChEORg[
REG_WIN1        =   (REG_BASE + 0x49)   @ EChEPRg[
REG_WINOUT      =   (REG_BASE + 0x4a)   @ EChEORg[
REG_OBJWIN      =   (REG_BASE + 0x4b)   @ naiEChERg[


REG_BGCNT       =   (REG_BASE + 0x8)    @ afRg[
REG_BG0CNT      =   (REG_BASE + 0x8)    @ afORg[
REG_BG1CNT      =   (REG_BASE + 0xa)    @ afPRg[
REG_BG2CNT      =   (REG_BASE + 0xc)    @ afQRg[
REG_BG3CNT      =   (REG_BASE + 0xe)    @ afRRg[
REG_BGOFS       =   (REG_BASE + 0x10)   @ afItZbg
REG_BG0HOFS     =   (REG_BASE + 0x10)   @ afOgItZbg
REG_BG0VOFS     =   (REG_BASE + 0x12)   @ afOuItZbg
REG_BG1HOFS     =   (REG_BASE + 0x14)   @ afPgItZbg
REG_BG1VOFS     =   (REG_BASE + 0x16)   @ afPuItZbg
REG_BG2HOFS     =   (REG_BASE + 0x18)   @ afQgItZbg
REG_BG2VOFS     =   (REG_BASE + 0x1a)   @ afQuItZbg
REG_BG3HOFS     =   (REG_BASE + 0x1c)   @ afRgItZbg
REG_BG3VOFS     =   (REG_BASE + 0x1e)   @ afRuItZbg
REG_BG2AFFINE   =   (REG_BASE + 0x20)   @ afQAtBϊp[^Q
REG_BG2PA       =   (REG_BASE + 0x20)   @ afQCwW
REG_BG2PB       =   (REG_BASE + 0x22)   @ afQ  wW
REG_BG2PC       =   (REG_BASE + 0x24)   @ afQCxW
REG_BG2PD       =   (REG_BASE + 0x26)   @ afQ  xW
REG_BG2X        =   (REG_BASE + 0x28)   @ afQX^[gwW
REG_BG2X_L      =   (REG_BASE + 0x28)
REG_BG2X_H      =   (REG_BASE + 0x2a)
REG_BG2Y        =   (REG_BASE + 0x2c)   @ afQX^[gxW
REG_BG2Y_L      =   (REG_BASE + 0x2c)
REG_BG2Y_H      =   (REG_BASE + 0x2e)
REG_BG3AFFINE   =   (REG_BASE + 0x30)   @ afRAtBϊp[^Q
REG_BG3PA       =   (REG_BASE + 0x30)   @ afRCwW
REG_BG3PB       =   (REG_BASE + 0x32)   @ afR  wW
REG_BG3PC       =   (REG_BASE + 0x34)   @ afRCxW
REG_BG3PD       =   (REG_BASE + 0x36)   @ afR  xW
REG_BG3X        =   (REG_BASE + 0x38)   @ afRX^[gwW
REG_BG3X_L      =   (REG_BASE + 0x38)
REG_BG3X_H      =   (REG_BASE + 0x3a)
REG_BG3Y        =   (REG_BASE + 0x3c)   @ afRX^[gxW
REG_BG3Y_L      =   (REG_BASE + 0x3c)
REG_BG3Y_H      =   (REG_BASE + 0x3e)


REG_SOUNDCNT    =   (REG_BASE + 0x80)   @ TEhRg[
REG_SOUNDCNT_L  =   (REG_BASE + 0x80)
REG_SOUNDCNT_H  =   (REG_BASE + 0x82)
REG_SOUNDCNT_X  =   (REG_BASE + 0x84)

REG_SOUNDBIAS   =   (REG_BASE + 0x88)   @ TEhah`r

REG_SOUND1CNT   =   (REG_BASE + 0x60)   @ TEhPRg[
REG_SOUND1CNT_L =   (REG_BASE + 0x60)
REG_SOUND1CNT_H =   (REG_BASE + 0x62)
REG_SOUND1CNT_X =   (REG_BASE + 0x64)
REG_SOUND2CNT   =   (REG_BASE + 0x68)   @ TEhQRg[
REG_SOUND2CNT_L =   (REG_BASE + 0x68)
REG_SOUND2CNT_H =   (REG_BASE + 0x6c)
REG_SOUND3CNT   =   (REG_BASE + 0x70)   @ TEhRRg[
REG_SOUND3CNT_L =   (REG_BASE + 0x70)
REG_SOUND3CNT_H =   (REG_BASE + 0x72)
REG_SOUND3CNT_X =   (REG_BASE + 0x74)
REG_SOUND4CNT   =   (REG_BASE + 0x78)   @ TEhSRg[
REG_SOUND4CNT_L =   (REG_BASE + 0x78)
REG_SOUND4CNT_H =   (REG_BASE + 0x7c)

REG_WAVE_RAM    =   (REG_BASE + 0x90)   @ TEhR g`q`l
REG_WAVE_RAM0   =   (REG_BASE + 0x90)
REG_WAVE_RAM0_L =   (REG_BASE + 0x90)
REG_WAVE_RAM0_H =   (REG_BASE + 0x92)
REG_WAVE_RAM1   =   (REG_BASE + 0x94)
REG_WAVE_RAM1_L =   (REG_BASE + 0x94)
REG_WAVE_RAM1_H =   (REG_BASE + 0x96)
REG_WAVE_RAM2   =   (REG_BASE + 0x98)
REG_WAVE_RAM2_L =   (REG_BASE + 0x98)
REG_WAVE_RAM2_H =   (REG_BASE + 0x9a)
REG_WAVE_RAM3   =   (REG_BASE + 0x9c)
REG_WAVE_RAM3_L =   (REG_BASE + 0x9c)
REG_WAVE_RAM3_H =   (REG_BASE + 0x9e)

REG_FIFO        =   (REG_BASE + 0xa0)   @ TEh ehen
REG_FIFO_A      =   (REG_BASE + 0xa0)
REG_FIFO_A_L    =   (REG_BASE + 0xa0)
REG_FIFO_A_H    =   (REG_BASE + 0xa2)
REG_FIFO_B      =   (REG_BASE + 0xa4)
REG_FIFO_B_L    =   (REG_BASE + 0xa4)
REG_FIFO_B_H    =   (REG_BASE + 0xa6)


REG_DMA0        =   (REG_BASE + 0xb0)   @ cl`O
REG_DMA0SAD     =   (REG_BASE + 0xb0)   @ ij
REG_DMA0SAD_L   =   (REG_BASE + 0xb0)
REG_DMA0SAD_H   =   (REG_BASE + 0xb2)
REG_DMA0DAD     =   (REG_BASE + 0xb4)
REG_DMA0DAD_L   =   (REG_BASE + 0xb4)
REG_DMA0DAD_H   =   (REG_BASE + 0xb6)
REG_DMA0CNT     =   (REG_BASE + 0xb8)
REG_DMA0CNT_L   =   (REG_BASE + 0xb8)
REG_DMA0CNT_H   =   (REG_BASE + 0xba)
REG_DMA1        =   (REG_BASE + 0xbc)   @ cl`P
REG_DMA1SAD     =   (REG_BASE + 0xbc)   @ iTEhFIFO^j
REG_DMA1SAD_L   =   (REG_BASE + 0xbc)
REG_DMA1SAD_H   =   (REG_BASE + 0xbe)
REG_DMA1DAD     =   (REG_BASE + 0xc0)
REG_DMA1DAD_L   =   (REG_BASE + 0xc0)
REG_DMA1DAD_H   =   (REG_BASE + 0xc2)
REG_DMA1CNT     =   (REG_BASE + 0xc4)
REG_DMA1CNT_L   =   (REG_BASE + 0xc4)
REG_DMA1CNT_H   =   (REG_BASE + 0xc6)
REG_DMA2        =   (REG_BASE + 0xc8)   @ cl`Q
REG_DMA2SAD     =   (REG_BASE + 0xc8)   @ iTEhFIFO^j
REG_DMA2SAD_L   =   (REG_BASE + 0xc8)
REG_DMA2SAD_H   =   (REG_BASE + 0xca)
REG_DMA2DAD     =   (REG_BASE + 0xcc)
REG_DMA2DAD_L   =   (REG_BASE + 0xcc)
REG_DMA2DAD_H   =   (REG_BASE + 0xce)
REG_DMA2CNT     =   (REG_BASE + 0xd0)
REG_DMA2CNT_L   =   (REG_BASE + 0xd0)
REG_DMA2CNT_H   =   (REG_BASE + 0xd2)
REG_DMA3        =   (REG_BASE + 0xd4)   @ cl`R
REG_DMA3SAD     =   (REG_BASE + 0xd4)   @ iJZbg^j
REG_DMA3SAD_L   =   (REG_BASE + 0xd4)
REG_DMA3SAD_H   =   (REG_BASE + 0xd6)
REG_DMA3DAD     =   (REG_BASE + 0xd8)
REG_DMA3DAD_L   =   (REG_BASE + 0xd8)
REG_DMA3DAD_H   =   (REG_BASE + 0xda)
REG_DMA3CNT     =   (REG_BASE + 0xdc)
REG_DMA3CNT_L   =   (REG_BASE + 0xdc)
REG_DMA3CNT_H   =   (REG_BASE + 0xde)


REG_TM0CNT      =   (REG_BASE + 0x100)  @ ^C}[O
REG_TM0CNT_L    =   (REG_BASE + 0x100)
REG_TM0CNT_H    =   (REG_BASE + 0x102)
REG_TM1CNT      =   (REG_BASE + 0x104)  @ ^C}[P
REG_TM1CNT_L    =   (REG_BASE + 0x104)
REG_TM1CNT_H    =   (REG_BASE + 0x106)
REG_TM2CNT      =   (REG_BASE + 0x108)  @ ^C}[Q
REG_TM2CNT_L    =   (REG_BASE + 0x108)
REG_TM2CNT_H    =   (REG_BASE + 0x10a)
REG_TM3CNT      =   (REG_BASE + 0x10c)  @ ^C}[R
REG_TM3CNT_L    =   (REG_BASE + 0x10c)
REG_TM3CNT_H    =   (REG_BASE + 0x10e)


REG_RCNT		=	(REG_BASE + 0x134)	@ ėpo̓Rg[

REG_SIOCNT      =   (REG_BASE + 0x128)  @ VAʐMRg[
REG_SIODATA8    =	(REG_BASE + 0x12a)  @  8bitVAʐMf[^
REG_SIODATA32   =	(REG_BASE + 0x120)  @ 32bitVAʐMf[^
REG_SIOMLT_RECV =	(REG_BASE + 0x120)  @ }`vCrhn Mf[^
REG_SIOMULTI0   =   (REG_BASE + 0x120)
REG_SIOMULTI1   =   (REG_BASE + 0x122)
REG_SIOMULTI2   =   (REG_BASE + 0x124)
REG_SIOMULTI3   =   (REG_BASE + 0x126)

REG_JOYCNT      =   (REG_BASE + 0x140)  @ inxoXʐMRg[
REG_JOYSTAT     =   (REG_BASE + 0x158)  @ inxoX@Xe[^X
REG_JOY_RECV    =   (REG_BASE + 0x150)  @ inxoX@Mf[^
REG_JOY_RECV_L  =   (REG_BASE + 0x150)
REG_JOY_RECV_H  =   (REG_BASE + 0x152)
REG_JOY_TRANS   =   (REG_BASE + 0x154)  @ inxoX@Mf[^
REG_JOY_TRANS_L =   (REG_BASE + 0x154)
REG_JOY_TRANS_H =   (REG_BASE + 0x156)


REG_KEYINPUT    =   (REG_BASE + 0x130)  @ L[
REG_KEYCNT      =   (REG_BASE + 0x132)  @ L[Rg[


@--------------------------------------------------------------------
@-                      WX^EItZbg                        -
@--------------------------------------------------------------------

OFFSET_REG_PAUSE        =   0x300       @ o`trd

OFFSET_REG_IE           =   0x200       @ 荞݋
OFFSET_REG_IF           =   0x202       @ 荞ݗv

OFFSET_REG_WAITCNT      =   0x204       @ JZbgEFCgRg[

OFFSET_REG_DISPCNT      =   0x0         @ \Rg[

OFFSET_REG_STAT         =   0x4         @ Xe[^X
OFFSET_REG_VCOUNT       =   0x6         @ uJE^

OFFSET_REG_MOSAIC       =   0x4c        @ UCN TCY

OFFSET_REG_BLDCNT       =   0x50        @ uh[h Rg[
OFFSET_REG_BLDALPHA     =   0x52        @    p[^
OFFSET_REG_BLDY         =   0x54        @ PxύX p[^

OFFSET_REG_WINCNT       =   0x40        @ EChE  Rg[
OFFSET_REG_WIN0H        =   0x40        @ EChEÖ
OFFSET_REG_WIN1H        =   0x42        @ EChEP̈
OFFSET_REG_WIN0V        =   0x44        @ EChEÖ
OFFSET_REG_WIN1V        =   0x46        @ EChEP̈
OFFSET_REG_WININ        =   0x48        @ EChERg[
OFFSET_REG_WIN0         =   0x48        @ EChEORg[
OFFSET_REG_WIN1         =   0x49        @ EChEPRg[
OFFSET_REG_WINOUT       =   0x4a        @ EChEORg[
OFFSET_REG_OBJWIN       =   0x4b        @ naiEChERg[


OFFSET_REG_BGCNT        =   0x8         @ afRg[
OFFSET_REG_BG0CNT       =   0x8         @ afORg[
OFFSET_REG_BG1CNT       =   0xa         @ afPRg[
OFFSET_REG_BG2CNT       =   0xc         @ afQRg[
OFFSET_REG_BG3CNT       =   0xe         @ afRRg[
OFFSET_REG_BGOFS        =   0x10        @ afItZbg
OFFSET_REG_BG0HOFS      =   0x10        @ afOgItZbg
OFFSET_REG_BG0VOFS      =   0x12        @ afOuItZbg
OFFSET_REG_BG1HOFS      =   0x14        @ afPgItZbg
OFFSET_REG_BG1VOFS      =   0x16        @ afPuItZbg
OFFSET_REG_BG2HOFS      =   0x18        @ afQgItZbg
OFFSET_REG_BG2VOFS      =   0x1a        @ afQuItZbg
OFFSET_REG_BG3HOFS      =   0x1c        @ afRgItZbg
OFFSET_REG_BG3VOFS      =   0x1e        @ afRuItZbg
OFFSET_REG_BG2AFFINE    =   0x20        @ afQAtBϊp[^Q
OFFSET_REG_BG2PA        =   0x20        @ afQCwW
OFFSET_REG_BG2PB        =   0x22        @ afQ  wW
OFFSET_REG_BG2PC        =   0x24        @ afQCxW
OFFSET_REG_BG2PD        =   0x26        @ afQ  xW
OFFSET_REG_BG2X         =   0x28        @ afQX^[gwW
OFFSET_REG_BG2X_L       =   0x28
OFFSET_REG_BG2X_H       =   0x2a
OFFSET_REG_BG2Y         =   0x2c        @ afQX^[gxW
OFFSET_REG_BG2Y_L       =   0x2c
OFFSET_REG_BG2Y_H       =   0x2e
OFFSET_REG_BG3AFFINE    =   0x30        @ afRAtBϊp[^Q
OFFSET_REG_BG3PA        =   0x30        @ afRCwW
OFFSET_REG_BG3PB        =   0x32        @ afR  wW
OFFSET_REG_BG3PC        =   0x34        @ afRCxW
OFFSET_REG_BG3PD        =   0x36        @ afR  xW
OFFSET_REG_BG3X         =   0x38        @ afRX^[gwW
OFFSET_REG_BG3X_L       =   0x38
OFFSET_REG_BG3X_H       =   0x3a
OFFSET_REG_BG3Y         =   0x3c        @ afRX^[gxW
OFFSET_REG_BG3Y_L       =   0x3c
OFFSET_REG_BG3Y_H       =   0x3e


OFFSET_REG_SOUNDCNT     =   0x80        @ TEhRg[
OFFSET_REG_SOUNDCNT_L   =   0x80
OFFSET_REG_SOUNDCNT_H   =   0x82
OFFSET_REG_SOUNDCNT_X   =   0x84

OFFSET_REG_SOUNDBIAS    =   0x88        @ TEhah`r

OFFSET_REG_SOUND1CNT    =   0x60        @ TEhPRg[
OFFSET_REG_SOUND1CNT_L  =   0x60
OFFSET_REG_SOUND1CNT_H  =   0x62
OFFSET_REG_SOUND1CNT_X  =   0x64
OFFSET_REG_SOUND2CNT    =   0x68        @ TEhQRg[
OFFSET_REG_SOUND2CNT_L  =   0x68
OFFSET_REG_SOUND2CNT_H  =   0x6c
OFFSET_REG_SOUND3CNT    =   0x70        @ TEhRRg[
OFFSET_REG_SOUND3CNT_L  =   0x70
OFFSET_REG_SOUND3CNT_H  =   0x72
OFFSET_REG_SOUND3CNT_X  =   0x74
OFFSET_REG_SOUND4CNT    =   0x78        @ TEhSRg[
OFFSET_REG_SOUND4CNT_L  =   0x78
OFFSET_REG_SOUND4CNT_H  =   0x7c

OFFSET_REG_WAVE_RAM     =   0x90        @ TEhR g`q`l
OFFSET_REG_WAVE_RAM0    =   0x90
OFFSET_REG_WAVE_RAM0_L  =   0x90
OFFSET_REG_WAVE_RAM0_H  =   0x92
OFFSET_REG_WAVE_RAM1    =   0x94
OFFSET_REG_WAVE_RAM1_L  =   0x94
OFFSET_REG_WAVE_RAM1_H  =   0x96
OFFSET_REG_WAVE_RAM2    =   0x98
OFFSET_REG_WAVE_RAM2_L  =   0x98
OFFSET_REG_WAVE_RAM2_H  =   0x9a
OFFSET_REG_WAVE_RAM3    =   0x9c
OFFSET_REG_WAVE_RAM3_L  =   0x9c
OFFSET_REG_WAVE_RAM3_H  =   0x9e

OFFSET_REG_FIFO         =   0xa0        @ TEh ehen
OFFSET_REG_FIFO_A       =   0xa0
OFFSET_REG_FIFO_A_L     =   0xa0
OFFSET_REG_FIFO_A_H     =   0xa2
OFFSET_REG_FIFO_B       =   0xa4
OFFSET_REG_FIFO_B_L     =   0xa4
OFFSET_REG_FIFO_B_H     =   0xa6


OFFSET_REG_DMA0         =   0xb0        @ cl`O
OFFSET_REG_DMA0SAD      =   0xb0        @ ij
OFFSET_REG_DMA0SAD_L    =   0xb0
OFFSET_REG_DMA0SAD_H    =   0xb2
OFFSET_REG_DMA0DAD      =   0xb4
OFFSET_REG_DMA0DAD_L    =   0xb4
OFFSET_REG_DMA0DAD_H    =   0xb6
OFFSET_REG_DMA0CNT      =   0xb8
OFFSET_REG_DMA0CNT_L    =   0xb8
OFFSET_REG_DMA0CNT_H    =   0xba
OFFSET_REG_DMA1         =   0xbc        @ cl`P
OFFSET_REG_DMA1SAD      =   0xbc        @ iTEhFIFO^j
OFFSET_REG_DMA1SAD_L    =   0xbc
OFFSET_REG_DMA1SAD_H    =   0xbe
OFFSET_REG_DMA1DAD      =   0xc0
OFFSET_REG_DMA1DAD_L    =   0xc0
OFFSET_REG_DMA1DAD_H    =   0xc2
OFFSET_REG_DMA1CNT      =   0xc4
OFFSET_REG_DMA1CNT_L    =   0xc4
OFFSET_REG_DMA1CNT_H    =   0xc6
OFFSET_REG_DMA2         =   0xc8        @ cl`Q
OFFSET_REG_DMA2SAD      =   0xc8        @ iTEhFIFO^j
OFFSET_REG_DMA2SAD_L    =   0xc8
OFFSET_REG_DMA2SAD_H    =   0xca
OFFSET_REG_DMA2DAD      =   0xcc
OFFSET_REG_DMA2DAD_L    =   0xcc
OFFSET_REG_DMA2DAD_H    =   0xce
OFFSET_REG_DMA2CNT      =   0xd0
OFFSET_REG_DMA2CNT_L    =   0xd0
OFFSET_REG_DMA2CNT_H    =   0xd2
OFFSET_REG_DMA3         =   0xd4        @ cl`R
OFFSET_REG_DMA3SAD      =   0xd4        @ iJZbg^j
OFFSET_REG_DMA3SAD_L    =   0xd4
OFFSET_REG_DMA3SAD_H    =   0xd6
OFFSET_REG_DMA3DAD      =   0xd8
OFFSET_REG_DMA3DAD_L    =   0xd8
OFFSET_REG_DMA3DAD_H    =   0xda
OFFSET_REG_DMA3CNT      =   0xdc
OFFSET_REG_DMA3CNT_L    =   0xdc
OFFSET_REG_DMA3CNT_H    =   0xde


OFFSET_REG_TM0CNT       =   0x100       @ ^C}[O
OFFSET_REG_TM0CNT_L     =   0x100
OFFSET_REG_TM0CNT_H     =   0x102
OFFSET_REG_TM1CNT       =   0x104       @ ^C}[P
OFFSET_REG_TM1CNT_L     =   0x104
OFFSET_REG_TM1CNT_H     =   0x106
OFFSET_REG_TM2CNT       =   0x108       @ ^C}[Q
OFFSET_REG_TM2CNT_L     =   0x108
OFFSET_REG_TM2CNT_H     =   0x10a
OFFSET_REG_TM3CNT       =   0x10c       @ ^C}[R
OFFSET_REG_TM3CNT_L     =   0x10c
OFFSET_REG_TM3CNT_H     =   0x10e


OFFSET_REG_RCNT         =	0x134       @ ėpo̓Rg[

OFFSET_REG_SIOCNT       =   0x128       @ VAʐMRg[
OFFSET_REG_SIODATA8     =	0x12a       @  8bitVAʐMf[^
OFFSET_REG_SIODATA32    =	0x120       @ 32bitVAʐMf[^
OFFSET_REG_SIOMLT_RECV  =	0x120       @ }`vCrhn Mf[^
OFFSET_REG_SIOMULTI0    =   0x120
OFFSET_REG_SIOMULTI1    =   0x122
OFFSET_REG_SIOMULTI2    =   0x124
OFFSET_REG_SIOMULTI3    =   0x126

OFFSET_REG_JOYCNT       =   0x140       @ inxoXʐMRg[
OFFSET_REG_JOYSTAT      =   0x158       @ inxoX@Xe[^X
OFFSET_REG_JOY_RECV     =   0x150       @ inxoX@Mf[^
OFFSET_REG_JOY_RECV_L   =   0x150
OFFSET_REG_JOY_RECV_H   =   0x152
OFFSET_REG_JOY_TRANS    =   0x154       @ inxoX@Mf[^
OFFSET_REG_JOY_TRANS_L  =   0x154
OFFSET_REG_JOY_TRANS_H  =   0x156


OFFSET_REG_KEYINPUT     =   0x130       @ L[
OFFSET_REG_KEYCNT       =   0x132       @ L[Rg[


