/********************************************************************/
/*          AgbMultiBoot.h                                          */
/*            AGB}`vCu[gCup錾                 */
/*                                                                  */
/*          Copyright (C) 2000 NINTENDO Co.,Ltd.                    */
/********************************************************************/
#ifndef _AGB_MULTIBOOT_H
#define _AGB_MULTIBOOT_H

#ifdef __cplusplus
extern "C" {
#endif

#include <AgbTypes.h>


/* ȉ̒萔͕ύXȂł */
#define MULTIBOOT_NCHILD 3              // q@̍ő
#define MULTIBOOT_HEADER_SIZE 0xc0      // wb_TCY
#define MULTIBOOT_SEND_SIZE_MIN 0x100   // ŏMTCY
#define MULTIBOOT_SEND_SIZE_MAX 0x40000 // ő呗MTCY
						
typedef struct {
  u32 system_work[5];   // VXeR[ŏ
  u8 handshake_data;
  u8 padding[3];
  u8 probe_count;       // 0 łȂ client, slave F 邢 u[gvO]
  u8 client_data[MULTIBOOT_NCHILD]; // NCAgAX[ũnhVFCNpf[^
  u8 palette_data;      // NCAǵA[hpbg_Ńp^
  u8 response_bit;      // q@ڑĂ\ꍇA4P-2P: d3-d1  1 ɂȂ
  u8 client_bit;        // NCAgƔ肳ꂽq@́A 4P-2P: d3-d1  1 ɂȂ
  u8 slave_bit;         // X[uT[oƔ肳ꂽq@ 4P-2P: d3-d1  1 ɂȂ
  u8 *boot_srcp;        // u[gvOJn (wb_̌w)
  u8 *boot_endp;        // u[gvO I|C^
  u8 *masterp;          // }X^QƂďo͂wb_ւ̃|C^
  u8 *headerp[MULTIBOOT_NCHILD]; // X[uT[oǂݎwb_ւ̃|C^
  u32 system_work2[4];  // VXeR[ŏ
  u8 sendflag;          // SC7=1 ɂđMȂ 0 łȂ
  u8 probe_target_bit;  // sss 0 ccc 0 ŁAslave, client FΏۂɂȂĂȂ 1
  u8 check_wait;        // client, slave Fs܂ł̑҂t[
  u8 server_type;       // T[o^Cv
} MultiBootParam;

/* G[R[h
 * MultiBoot_Frame() ԂlA0łȂƂ́Aȉ̉炩̃G[B
 * AׂẴG[R[h̎ނɉAʂ̃G[bZ[W
 * pӂKv͂ȂB
 * uʐMG[AڑmFĂAX^[g{^ŃgCv
 * ̂悤ȃbZ[WŗǂƎvB
 * NO_PROBE_TARGET: client, slave FɂׂẴ}Vُȃf[^
 * ԂĂāAFΏۂȂȂ
 * Aُȃf[^ƒfł̂́Aclient ̂݁B
 * NO_DLREADY: client, slave _E[h\ƂԎȂB
 * BOOT_FAILURE: MultiBoot() VXeR[G[ԂĂB
 */
#define MULTIBOOT_ERROR_04              0x04
#define MULTIBOOT_ERROR_08              0x08
#define MULTIBOOT_ERROR_0c              0x0c
#define MULTIBOOT_ERROR_80              0x80
#define MULTIBOOT_ERROR_84              0x84
#define MULTIBOOT_ERROR_88              0x88
#define MULTIBOOT_ERROR_8c              0x8c
#define MULTIBOOT_ERROR_NO_PROBE_TARGET 0x40
#define MULTIBOOT_ERROR_NO_DLREADY      0x50
#define MULTIBOOT_ERROR_BOOT_FAILURE    0x60

/* G[A邢 0xffff ȊO̒lԂĂāAڑ`FbN
 * 蒼܂ł̃`^OEGCg (t[)
 * NCAg̃^CAEg  11 t[̂ŁA
 * \lɂĂB
 * ʏÅԂ MASTER_INFO 𑗏o邪AVXeR[
 * G[ɂȂƂ́ÅԁAMȂő҂B
 * ꂩA̓ MASTER_INFO 𑗏oB
 */
#define MULTIBOOT_CONNECTION_CHECK_WAIT 15


#ifdef __cplusplus
}      /* extern "C" */
#endif

#endif    /* _AGB_MULTIBOOT_H */
/* End of AgbMultiBoot.h */
