/********************************************************************/
/*          AgbSystemCall.h                                         */
/*            AGBVXeR[                                     */
/*                                                                  */
/*          Copyright (C) 1999-2000 NINTENDO Co.,Ltd.               */
/********************************************************************/
#ifndef _AGB_SYSTEM_CALL_H
#define _AGB_SYSTEM_CALL_H

#ifdef __cplusplus
extern "C" {
#endif

#include <AgbTypes.h>
#include <AgbSound.h>
#include <AgbMultiBoot.h>


#ifdef  __GNUC__
#ifndef CODE32
#define SystemCall(No)   asm ("SWI    "#No)
#else
#define SystemCall(No)   asm ("SWI    "#No" << 16")
#endif
#else
#ifndef CODE32
#define SystemCall(No) __asm { SWI    No}
#else
#define SystemCall(No) __asm { SWI    No << 16}
#endif
#endif


/*------------------------------------------------------------------*/
/*               \tg Zbg                                    */
/*------------------------------------------------------------------*/

extern void SoftReset(u32 ResetFlags);

//EResetFlagsŎw肵WX^RAMZbgA0x8000000Ԓn֕A܂B
//ECPURAWX^CPURAM0x3007e00`0x3007fff̗̈
//  IɃNA܂B
//
//EF
//    u32 ResetFlags      Zbg郌WX^RAM̎wiAgbDefine.hQƁj

/*------------------------------------------------------------------*/
/*               WX^q`l Zbg                          */
/*------------------------------------------------------------------*/

extern void RegisterRamReset(u32 ResetFlags);

//EResetFlagsŎw肵WX^RAMZbg܂B
//EAACPURAM0x3007e00`0x3007fff̗̈̓NA܂B
//
//EF
//    u32 ResetFlags      Zbg郌WX^RAM̎wiAgbDefine.hQƁj

/*------------------------------------------------------------------*/
/*                   g`ks                                       */
/*------------------------------------------------------------------*/

#define Halt()                   SystemCall(2)

//ECPÛݒ~܂B
//EY銄荞݂iIEɃZbgjĂ
//  荞ݗviIFZbgjɂĕA܂B

/*------------------------------------------------------------------*/
/*                   rsno                                       */
/*------------------------------------------------------------------*/

#define Stop()                                               \
{                                                            \
    SoundBiasReset();                                        \
    SystemCall(3);                                           \
    SoundBiasSet();                                          \
}

//EU~܂B
//EY銄荞݂iIEɃZbgjĂꍇ
//  L[܂̓JZbg܂SIO̊荞ݗv̔ɂĕA܂B
//EU~Ă܂̂IFtO̓Zbg܂B
//EKLCDCOFFɂĎsĉB

/*------------------------------------------------------------------*/
/*               荞݃EFCg                                   */
/*------------------------------------------------------------------*/

extern void IntrWait(u8 InitCheckClear, u16 IntrFlags);

//EIntrFlagsŎw肵荞݂܂HaltԂő҂܂B
//E荞ݏɂINTR_CHECK_BUF(0x3007ff8)֊YtOZbgĉB
//E̊荞݂𕹗pꍇAHalt()JԂĂ΂邱Ƃɂ
//  VXeR[̃I[o[wbhy邱Ƃł܂B
//
//EF
//    u8  InitCheckClear  ɊYtOZbgĂꍇɃNA邩ǂ̎w
//    u16 IntrFlags       EFCg銄荞݂̎wiAgbDefine.hQƁj

/*------------------------------------------------------------------*/
/*               uuN荞݃EFCg                         */
/*------------------------------------------------------------------*/

#define VBlankIntrWait()               SystemCall(5)

//EuuN荞݂܂HaltԂő҂܂B
//E荞ݏɂINTR_CHECK_BUF(0x3007ff8)֊YtOZbgĉB
//E̊荞݂𕹗pꍇAHalt()JԂĂ΂邱Ƃɂ
//  VXeR[̃I[o[wbhy邱Ƃł܂B
//EIntrWait(1, V_BLANK_INTR_FLAG)ƓłB

/*------------------------------------------------------------------*/
/*                   tZij                           */
/*------------------------------------------------------------------*/

extern s32 Div(s32 Number, s32 Denom);      // CygnusЃCuΉ
extern s32 DivArm(s32 Denom, s32 Number);   // ARMЃCuΉ

//ENumber/DenomZo܂B
//EWX^̒ĺAr0=Number/Denom, r1=Number%Denom, 
//  r3=|Number/Denom|ŕA܂B
//
//EF
//    s32 Number          q
//    s32 Denom           

/*------------------------------------------------------------------*/
/*                   tZi]j                         */
/*------------------------------------------------------------------*/

extern s32 DivRem(s32 Number, s32 Denom);   // CygnusЃCuΉ
extern s32 DivRemArm(s32 Denom, s32 Number);// ARMЃCuΉ

//ENumber%DenomZo܂B
//EWX^̒ĺAr0=Number%Denom, r1=Number%Denom, 
//  r3=|Number/Denom|ŕA܂B
//
//EF
//    s32 Number          q
//    s32 Denom           

/*------------------------------------------------------------------*/
/*                                                            */
/*------------------------------------------------------------------*/

extern u16 Sqrt(u32 X);

//EZo܂B
//Exǂ邽߂ɈX2̔{VtgēnA
//  ߂lVtgČ킹sȂĉB

/*------------------------------------------------------------------*/
/*                   t                                         */
/*------------------------------------------------------------------*/

extern s16 ArcTan(s16 Tan);

//EtڒlZo܂B
//E߂l-/2Ɓ/20xc000`0x4000͈̔͂ŕԂ܂B
//EAAƁ-/4,/4Ƃ͈̔͂͐xɖ肪܂B
//
//EF
//    s16 Tan
//        :1
//        :1
//        :14

/*------------------------------------------------------------------*/
/*                   tڂQ                                       */
/*------------------------------------------------------------------*/

extern u16 ArcTan2(s16 X, s16 Y);

//E␳̋tڒlZo܂B
//Eʏ͂gpĉB
//E߂l0Ɓ2΂0`0xffff͈̔͂ŕԂ܂B
//
//EF
//    s16 X, Y
//        :1
//        :1
//        :14

/*------------------------------------------------------------------*/
/*                   botZbg                                   */
/*------------------------------------------------------------------*/

extern void CpuSet(void *Srcp, void *Destp, u32 DmaCntData);

//EDmaSet}N݊̃p[^RAMNA܂̓Rs[܂B
//
//EF
//    void *Srcp          \[XAhX
//    void *Destp         fXeBl[VAhX
//    u32 DmaCntData      DMA_SRC_FIX^DMA_32BIT_BUS^DMA_COUNT_MASK̂ݗL
//          DMA_SRC_FIX(  0, 1) = (\[XAhXECNg, \[XAhXŒ)
//          DMA_32BIT_BUS(0, 1) = (16bit], 32bit])
//          DMA_COUNT_MASK & DmaCntData = ]
//
//Eʃ}NF
//  CpuClear, CpuArrayClear, CpuCopy, CpuArrayCopy

/*------------------------------------------------------------------*/
/*                   botZbg                               */
/*------------------------------------------------------------------*/

extern void CpuFastSet(void *Srcp, void *Destp, u32 DmaCntData);

//EDmaSet}N݊̃p[^ōRAMNA܂̓Rs[܂B
//EA32Bytei8WordjPʂ32bit]łB
//
//EF
//    void *Srcp          \[XAhX
//    void *Destp         fXeBl[VAhX
//    u32 DmaCntData      DMA_SRC_FIX^DMA_COUNT_MASK̂ݗL
//          DMA_SRC_FIX(0, 1) = (\[XAhXECNg, \[XAhXŒ)
//          DMA_COUNT_MASK & DmaCntData = ]
//
//Eʃ}NF
//  CpuFastClear, CpuFastArrayClear, CpuFastCopy, CpuFastArrayCopy

/*------------------------------------------------------------------*/
/*                   afAtBϊ Zbg                        */
/*------------------------------------------------------------------*/

extern void BgAffineSet(BgAffineSrcData *Srcp, BgAffineDestData *Destp, s32 Num);

//EBG̃AtBp[^ZoAZbg܂B
//
//EF
//  BgAffineSrcData  *Srcp      \[XAhX
//  BgAffineDestData *Destp     fXeBl[VAhX
//              s32   Num       vZ
//
//EBgAffineSrcData\
//    s32 SrcCenterX            f[^SWi_ȉ8bitj
//    s32 SrcCenterY
//    s16 DispCenterX           \SW
//    s16 DispCenterY
//    s16 RatioX                gki_ȉ8bitj
//    s16 RatioY
//    u16 Theta                 ]pi_ȉ8bitj
//                                  L͈    0 - 0xffff
//EBgAffineDestData\
//    s16 H_DiffX               CwW
//    s16 V_DiffX                 wW
//    s16 H_DiffY               CxW
//    s16 V_DiffY                 xW
//    s32 StartX                X^[gwW
//    s32 StartY                X^[gxW

/*------------------------------------------------------------------*/
/*                   naiAtBϊ Zbg                      */
/*------------------------------------------------------------------*/

extern void ObjAffineSet(ObjAffineSrcData *Srcp, void *Destp, s32 Num, s32 Offset);

//EOBJ̃AtBp[^ZoAZbg܂B
//
//EF
//  ObjAffineSrcData *Srcp      \[XAhX
//              void *Destp     fXeBl[VAhX
//              s32   Num       vZ
//              s32   Offset    p[^AhX̃ItZbgEoCgiʏ 2|8j
//                              OAMɒڃZbgꍇ"8"w
//
//EObjAffineSrcData\
//    s16 RatioX                gki_ȉ8bitj
//    s16 RatioY
//    u16 Theta                 ]pi_ȉ8bitj
//                                  L͈    0 - 0xffff
//EObjAffineDestData\
//    s16 H_DiffX               CwW
//    s16 V_DiffX                 wW
//    s16 H_DiffY               CxW
//    s16 V_DiffY                 xW

/*------------------------------------------------------------------*/
/*                       Bitkf[^WJ                          */
/*------------------------------------------------------------------*/

extern void BitUnPack(void  *Srcp, void *Destp, BitUnPackParam *BitUnPackParamp);

//E0Œbitl߂f[^WJ܂B
//EfXeBl[VAhX4ByteEɍ킹ĉB
//
//EF
//            void *Srcp    \[XAhX
//            void *Destp   fXeBl[VAhX
//  BitUnPackParam *Paramp  BitUnPackParam\̃f[^̃AhX
//
//EBitUnPackParam\
//    u16 SrcNum              \[Xf[^EoCg
//    u8  SrcBitNum           P\[Xf[^Erbg
//    u8  DestBitNum          PfXeBl[Vf[^Erbg
//    u32 DestOffset:31       \[Xf[^ɉZItZbg
//        DestOffset0_On:1    Õf[^ɃItZbgZ邩ۂ̃tO

/*------------------------------------------------------------------*/
/*                   kyVVkf[^WJi[Nq`lj       */
/*------------------------------------------------------------------*/

extern void LZ77UnCompWram(void *Srcp, void *Destp);

//ELZ77kf[^WJA8bitPʂŏ݂܂B
//EVRAMɒړWJ邱Ƃ͂ł܂B
//Ekf[^̃TCY4̔{ɂȂȂꍇ
//  o邾0ŋl߂ĒĉB
//E\[XAhX4ByteEɍ킹ĉB
//
//EF
//    void *Srcp              \[XAhX
//    void *Destp             fXeBl[VAhX
//
//Ef[^wb_
//    u32 :4                  \
//        CompType:4          k^Cvi = 1j
//        DestSize:24         WJ̃f[^TCY
//
//EtOf[^tH[}bg
//    u8  Flags               k^ktO
//                            i0, 1j = ikf[^, kf[^j
//ER[hf[^tH[}bg
//    u16 Length:4            WJf[^ - 3iv3Byteȏ㎞݈̂kj
//        Offset:12           vf[^ItZbg - 1

/*------------------------------------------------------------------*/
/*                   kyVVkf[^WJiuq`lj           */
/*------------------------------------------------------------------*/

extern void LZ77UnCompVram(void *Srcp, void *Destp);

//ELZ77kf[^WJA16bitPʂŏ݂܂B
//E[NRAMɂWJł܂ALZ77UnCompWram()ᑬłB
//Ekf[^͈v2ByteȑO茟̂ɂĉB
//Ekf[^̃TCY4̔{ɂȂȂꍇ
//  o邾0ŋl߂ĒĉB
//E\[XAhX4ByteEɍ킹ĉB
//
//EF
//    void *Srcp              \[XAhX
//    void *Destp             fXeBl[VAhX
//
//Ef[^wb_
//    u32 :4                  \
//        CompType:4          k^Cvi = 1j
//        DestSize:24         WJ̃f[^TCY
//
//EtOf[^tH[}bg
//    u8  Flags               k^ktO
//                            i0, 1j = ikf[^, kf[^j
//ER[hf[^tH[}bg
//    u16 Length:4            WJf[^ - 3iv3Byteȏ㎞݈̂kj
//        Offset:12           vf[^ItZbgi >= 2j - 1

/*------------------------------------------------------------------*/
/*                   nt}kf[^WJ                         */
/*------------------------------------------------------------------*/

extern void HuffUnComp(void *Srcp, void *Destp);

//Ent}kf[^WJA32bitPʂŏ݂܂B
//Ekf[^̃TCY4̔{ɂȂȂꍇ
//  o邾0ŋl߂ĒĉB
//E\[XAhX4ByteEɍ킹ĉB
//
//EF
//    void *Srcp              \[XAhX
//    void *Destp             fXeBl[VAhX
//
//Ef[^wb_
//    u32 BitSize:4           Pf[^ErbgTCYiʏ 4|8j
//        CompType:4          k^Cvi = 2j
//        DestSize:24         WJ̃f[^TCY
//
//Ec[e[u
//    u8           TreeSize        c[e[uTCY/2 - 1
//    TreeNodeData RootNode        [gm[h
//
//    TreeNodeData LeftNode        [gm[h
//    TreeNodeData RightNode       [gEm[h
//
//    TreeNodeData LeftleftNode    m[h
//    TreeNodeData leftRightNode   Em[h
//
//    TreeNodeData RightLeftNode   Em[h
//    TreeNodeData RightRightNode  EEm[h
//
//            E
//            E
//
//  ̌Ɉkf[^{
//
//ETreeNodeData\
//    u8  NextNodeOffset:6    m[hf[^ւ̃ItZbg - 1i2BytePʁj
//        RightEndFlag:1      Em[hItO
//        LeftEndFlag:1       m[hItO
//                            ItOZbgĂꍇ
//                            m[hɃf[^

/*------------------------------------------------------------------*/
/*                   OXkf[^WJi[Nq`lj   */
/*------------------------------------------------------------------*/

extern void RLUnCompWram(void *Srcp, void *Destp);

//EOXkf[^WJA8bitPʂŏ݂܂B
//EVRAMɒړWJ邱Ƃ͂ł܂B
//Ekf[^̃TCY4̔{ɂȂȂꍇ
//  o邾0ŋl߂ĒĉB
//E\[XAhX4ByteEɍ킹ĉB
//
//EF
//    void *Srcp              \[XAhX
//    void *Destp             fXeBl[VAhX
//
//Ef[^wb_
//    u32 :4                  \
//        CompType:4          k^Cvi = 3j
//        DestSize:24         WJ̃f[^TCY
//
//EtOf[^tH[}bg
//    u8  Length:7            WJf[^ - 1ikj
//                            WJf[^ - 3iA3Byteȏ㎞݈̂kj
//        Flag:1              i0, 1j = ikf[^, kf[^j

/*------------------------------------------------------------------*/
/*                   OXkf[^WJiuq`lj       */
/*------------------------------------------------------------------*/

extern void RLUnCompVram(void *Srcp, void *Destp);

//EOXkf[^WJA16bitPʂŏ݂܂B
//E[NRAMɂWJł܂ARLUnCompWram()ᑬłB
//Ekf[^̃TCY4̔{ɂȂȂꍇ
//  o邾0ŋl߂ĒĉB
//E\[XAhX4ByteEɍ킹ĉB
//
//EF
//    void *Srcp              \[XAhX
//    void *Destp             fXeBl[VAhX
//
//Ef[^wb_
//    u32 :4                  \
//        CompType:4          k^Cvi = 3j
//        DestSize:24         WJ̃f[^TCY
//
//EtOf[^tH[}bg
//    u8  Length:7            WJf[^ - 1ikj
//                            WJf[^ - 3iA3Byteȏ㎞݈̂kj
//        Flag:1              i0, 1j = ikf[^, kf[^j

/*------------------------------------------------------------------*/
/*                   tB^WJi8Bit[Nq`lj         */
/*------------------------------------------------------------------*/

extern void Diff8bitUnFilterWram(void *Srcp, void *Destp);

//E8bittB^Hf[^WJA8bitPʂŏ݂܂B
//EVRAMɒړWJ邱Ƃ͂ł܂B
//E\[XAhX4ByteEɍ킹ĉB
//
//EF
//    void *Srcp              \[XAhX
//    void *Destp             fXeBl[VAhX
//
//Ef[^wb_
//    u32 ByteSize:4          Pf[^EoCgTCYi = 1j
//        FiltType:4          tB^^Cvi = 8j
//        DestSize:24         WJ̃f[^TCY
//
//Ef[^tH[}bg
//    u8  Origin              f[^
//    u8  Diff                f[^
//         E
//         E

/*------------------------------------------------------------------*/
/*                   tB^WJi8Bituq`lj             */
/*------------------------------------------------------------------*/

extern void Diff8bitUnFilterVram(void *Srcp, void *Destp);

//E8bittB^Hf[^WJA16bitPʂŏ݂܂B
//E[NRAMɂWJł܂ADiff8bitUnFilterVram()ᑬłB
//E\[XAhX4ByteEɍ킹ĉB
//
//EF
//    void *Srcp              \[XAhX
//    void *Destp             fXeBl[VAhX
//
//Ef[^wb_
//    u32 ByteSize:4          Pf[^EoCgTCYi = 1j
//        FilterType:4        tB^^Cvi = 8j
//        DestSize:24         WJ̃f[^TCY
//
//Ef[^tH[}bg
//    u8  Origin              f[^
//    u8  Diff                f[^
//         E
//         E

/*------------------------------------------------------------------*/
/*                   tB^WJi16Bitj                      */
/*------------------------------------------------------------------*/

extern void Diff16bitUnFilter(void *Srcp, void *Destp);

//E16bittB^Hf[^WJA16bitPʂŏ݂܂B
//E\[XAhX4ByteEɍ킹ĉB
//
//EF
//    void *Srcp              \[XAhX
//    void *Destp             fXeBl[VAhX
//
//Ef[^wb_
//    u32 ByteSize:4          Pf[^EoCgTCYi = 2j
//        FilterType:4        tB^^Cvi = 8j
//        DestSize:24         WJ̃f[^TCY
//
//Ef[^tH[}bg
//    u16 Origin              f[^
//    u16 Diff                f[^
//         E
//         E

/*------------------------------------------------------------------*/
/*              TEhah`r Zbg                             */
/*------------------------------------------------------------------*/

extern void SoundBiasSet(void);

//ETEhBIAS0璆Ԓli0x200jֈڍs܂B

/*------------------------------------------------------------------*/
/*              TEhah`r Zbg                           */
/*------------------------------------------------------------------*/

extern void SoundBiasReset(void);

//ETEhBIAS𒆊Ԓli0x200j0ֈڍs܂B

/*------------------------------------------------------------------*/
/*              TEhhCo                              */
/*------------------------------------------------------------------*/

extern void SoundDriverInit(SoundArea *sa);

//  TEhhCo܂B
//  Q[̋NɈxĂłB
//  ̍ہAƗ̈ł sa ́A炩ߊmۂĂ
//  Kv܂BAƂƗ̈ʂɗpӂĂA
//  {hCo𑽏dɎs邱Ƃ͏o܂B

/*------------------------------------------------------------------*/
/*              TEhhCo 샂[h                         */
/*------------------------------------------------------------------*/

extern void SoundDriverMode(u32 mode);

//  TEhhCo̓샂[hݒ肵܂B
//  
//  _CNgTEh̃o[u (l 0)
//      mode = SOUND_MODE_REVERB_SET + (o[ul 0`127);
//  
//  _CNgTEh̓ (l 8)
//      mode = ( 1`12) << SOUND_MODE_MAXCHN_SHIFT;
//  
//  _CNgTEh̃}X^[{[ (l 15)
//      mode = ({[ 1`15) << SOUND_MODE_MASVOL_SHIFT;
//  
//  _CNgTEh̍Đg (l 13379Hz)
//      mode = SOUND_MODE_FREQ_?????;
//              AgbSound.h Œ`ĂlB(PQ)
//  
//  ŏIIȂc^`Ro[^̃rbg (l 8bit)
//      mode = SOUND_MODE_BIT_?;
//                             9`6
//  
//  ȏ̒ĺAOR Ĉxɐݒ肷邱Ƃł܂B

/*------------------------------------------------------------------*/
/*              TEhhCo C                             */
/*------------------------------------------------------------------*/

extern void SoundDriverMain(void);

//  TEhhCõCB
//  1/60bɌĂłB̗ƂẮA
//  V-Blank݂̒Ɍq SoundDriverVSync() ĂсA
//  ̌ BG  OBJ ̏sĂ{[`
//  ĂԂƂɂȂ܂B

/*------------------------------------------------------------------*/
/*              TEhhCo cl`ăZbg                     */
/*------------------------------------------------------------------*/

extern void SoundDriverVSync(void);

//  TEhcl`ăZbgɒZVXeR[łB
//  ^C~OVrAł̂ŁA1/60b V-Blank 
//  ݂wxɌĂłB

/*------------------------------------------------------------------*/
/*              TEh`l NA                           */
/*------------------------------------------------------------------*/

extern void SoundChannelClear(void);

//  TEh̑S`lNAA~߂܂B
//  AAq̃~[WbNvC[Ȃt̏ꍇ́A
//  ꎞIɉ~܂邾ŁAɉtĊJł傤B

/*------------------------------------------------------------------*/
/*                 TEhcl`̒~                             */
/*------------------------------------------------------------------*/

extern void SoundDriverVSyncOff(void);

//  CvO̓s V-Blank݂~铙A
//  1/60b SoundDriverVSync() ĂׂȂȂꍇɂ́A
//  ̊֐găTEhcl`~Kv܂B
//  ȂƁAobt@I[o[Ăcl`~܂炸ɁA
//  ЂǂmCY܂B

/*------------------------------------------------------------------*/
/*                 TEhcl`̍ĊJ                             */
/*------------------------------------------------------------------*/

extern void SoundDriverVSyncOn(void);

//  L SoundDriverVSyncOff() ɂĒ~TEhcl`
//  ĊJ֐łB̊֐R[A2/60bȓ
//  V-Blank ݂ SoundDriverVSync() Ă΂悤
//  ĂB

/*------------------------------------------------------------------*/
/*               lhchL[ɂ鉹vZ                         */
/*------------------------------------------------------------------*/

extern u32  MidiKey2Freq(WaveData *wa, u8 mk, u8 fp);

//  g`f[^ wa A(MIDI KEY) mk єl fp Ŗ炷A
//  ((SoundArea)sa).vchn[x].fr ɑlvZ܂B

/*------------------------------------------------------------------*/
/*            ~[WbNvC[̃I[v                      */
/*------------------------------------------------------------------*/

extern void MusicPlayerOpen(MusicPlayerArea *ma, MusicPlayerTrack *ta, u8 tn);

//  ~[WbNvC[I[v܂B
//  ma ͍Ɨ̈Ata ̓gbN̍Ɨ̈Atn ̓gbN(ő16)łB
//  ma, ta[tn] ʂɗpӂΕ̃vC[I[vłA
//  Ȃ̓t\ƂȂ܂BƂ΂aflpɂPArdp
//  SI[vƂ悤Ȏgp@l܂B
//  
//  ~[WbNvC[֐Q́ATEhhCo֐Q
//  @ʊ֐łB

/*------------------------------------------------------------------*/
/*                       Ȃ̉tJn                             */
/*------------------------------------------------------------------*/

extern void MusicPlayerStart(MusicPlayerArea *ma, SongHeader *so);

//  Ɨ̈ ma ̃~[WbNvC[gċ so t܂B

/*------------------------------------------------------------------*/
/*                     Ȃ̉tiꎞj~                       */
/*------------------------------------------------------------------*/

extern void MusicPlayerStop(MusicPlayerArea *ma);

//  Ɨ̈ ma ̃~[WbNvC[ŉt̋Ȃ~܂B

/*------------------------------------------------------------------*/
/*                        Ȃ̉tĊJ                            */
/*------------------------------------------------------------------*/

extern void MusicPlayerContinue(MusicPlayerArea *ma);

//  Ɨ̈ ma ̃~[WbNvC[Œ~̋ȂĊJ܂B

/*------------------------------------------------------------------*/
/*                       ȂtFChAEg                         */
/*------------------------------------------------------------------*/

extern void MusicPlayerFadeOut(MusicPlayerArea *ma, u16 sp);

//  Ɨ̈ ma ŉt̋Ȃ𑬓x sp ŃtFChAEgA~܂B


/*------------------------------------------------------------------*/
/*                   }`vCu[g                             */
/*------------------------------------------------------------------*/

extern int MultiBoot(MultiBootParam *mp);

//E}`vCu[g̃T[opCłB
//E炩߁AڑĂ邷ׂẴNCAgAGBƂ̊ԂŁA
//  ̔F葱sĂȂ΂Ȃ܂B


#ifdef __cplusplus
}      /* extern "C" */
#endif

#endif /* _AGB_SYSTEM_CALL_H */
