/********************************************************************/
/*          AgbTypes.h                                              */
/*            AGBW^錾                                         */
/*                                                                  */
/*          Copyright (C) 1999-2000 NINTENDO Co.,Ltd.               */
/********************************************************************/
#ifndef _AGB_TYPES_H
#define _AGB_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif


/*------------------------------------------------------------------*/
/*                      f[^TCYĒ`                          */
/*------------------------------------------------------------------*/

typedef     unsigned char           u8;
typedef     unsigned short int      u16;
typedef     unsigned int            u32;
typedef     unsigned long long int  u64;

typedef     signed char             s8;
typedef     signed short int        s16;
typedef     signed int              s32;
typedef     signed long long int    s64;

typedef     float                   f32;
typedef     double                  f64;


#define     vl                      volatile

typedef     vl u8                   vu8;
typedef     vl u16                  vu16;
typedef     vl u32                  vu32;
typedef     vl u64                  vu64;

typedef     vl s8                   vs8;
typedef     vl s16                  vs16;
typedef     vl s32                  vs32;
typedef     vl s64                  vs64;

typedef     vl f32                  vf32;
typedef     vl f64                  vf64;


/*------------------------------------------------------------------*/
/*                          \                                  */
/*------------------------------------------------------------------*/

// vOXe[^XWX^\
typedef struct {
    u32 CpuMode:5;          // bot[h
    u32 Thumb_State:1;      // sgtlaXe[g
    u32 Fiq_Disable:1;      // ehps
    u32 Irq_Disable:1;      // hqps
    u32 Dummy_27_8:20;
    u32 V_Flag:1;           // I[o[t[
    u32 C_Flag:1;           // L[^{[^g
    u32 Z_Flag:1;           // [
    u32 N_Flag:1;           // ^
} PsrData;
typedef  vl PsrData    vPsrData;


// 荞ݗv^tO\
typedef struct {
    u16 V_Blank:1;          // uuN
    u16 H_Blank:1;          // guN
    u16 V_Count:1;          // uJE^v
    u16 Timer0:1;           // ^C}[O
    u16 Timer1:1;           // ^C}[P
    u16 Timer2:1;           // ^C}[Q
    u16 Timer3:1;           // ^C}[R
    u16 Sio:1;              // VAʐM
    u16 Dma0:1;             // cl`O
    u16 Dma1:1;             // cl`P
    u16 Dma2:1;             // cl`Q
    u16 Dma3:1;             // cl`R
    u16 Key:1;              // L[
    u16 Cassette:1;         // JZbg
    u16 Dummy_15_14:2;
} IntrFlags;
typedef  vl IntrFlags    vIntrFlags;


// \Rg[\
typedef struct {
    u16 BgMode:3;           //   af[hI
    u16 CgbMode:1;          // bfa[hI
    u16 Bmp_FrameNo:1;      // rbg}bv[h \t[ I
    u16 Obj_H_Off:1;        // guNnai nee
    u16 ObjCharMapType:1;   // naiLN^f[^ }bsO^Cv
    u16 Lcdc_Off:1;         // kbcb nee
    u16 Bg0_On:1;           // afO nm
    u16 Bg1_On:1;           // afP nm
    u16 Bg2_On:1;           // afQ nm
    u16 Bg3_On:1;           // afR nm
    u16 Obj_On:1;           // nai nm
    u16 Win0_On:1;          // EChEO nm
    u16 Win1_On:1;          // EChEP nm
    u16 ObjWin_On:1;        // naiEChE nm
} DispCnt;
typedef  vl DispCnt   vDispCnt;


// Xe[^XRg[\
typedef struct {
    u16 V_Blank_Flag:1;     // uuNԒ
    u16 H_Blank_Flag:1;     // guNԒ
    u16 V_Count_Flag:1;     // uJE^v
    u16 V_Blank_IF_Enable:1;// uuN荞ݗv 
    u16 H_Blank_IF_Enable:1;// guN荞ݗv 
    u16 V_Count_IF_Enable:1;// uJE^v荞ݗv 
    u16 Dummy_7_6:2;
    u8  V_Count_Cmp;        // uJE^rl
    u8  V_Count;            // uJE^l
    u8  Dummy_31_24;
} StatCnt;
typedef  vl StatCnt   vStatCnt;


// UCNRg[\
typedef struct {
    u16 Bg_HSize:4;         //   afUCN gTCY
    u16 Bg_VSize:4;         //   afUCN uTCY
    u16 Obj_HSize:4;        // naiUCN gTCY
    u16 Obj_VSize:4;        // naiUCN uTCY
} MosCnt;
typedef  vl MosCnt    vMosCnt;


// uhRg[\
typedef struct {
    u16 Pixel_1st_Bg0_On:1; // PsNZ
    u16 Pixel_1st_Bg1_On:1;
    u16 Pixel_1st_Bg2_On:1;
    u16 Pixel_1st_Bg3_On:1;
    u16 Pixel_1st_Obj_On:1;
    u16 Pixel_1st_Bd_On:1;
    u16 BlendMode:2;        // uh[h
    u16 Pixel_2nd_Bg0_On:1; // QsNZ
    u16 Pixel_2nd_Bg1_On:1;
    u16 Pixel_2nd_Bg2_On:1;
    u16 Pixel_2nd_Bg3_On:1;
    u16 Pixel_2nd_Obj_On:1;
    u16 Pixel_2nd_Bd_On:1;
    u16 Dummy_15_14:2;
    u16 Value_A:5;          // p[^ `
    u16 Dummy_23_21:3;
    u16 Value_B:5;          // p[^ a
    u16 Dummy_31_29:3;
    u16 Value_Y:5;          // p[^ x
    u16 Dummy_39_37:3;
} BlendCnt;
typedef  vl BlendCnt    vBlendCnt;


// afRg[\
typedef struct {
    u16 Priority:2;         // \D
    u16 CharBasep:2;        // LN^ x[XAhX
    u16 Dummy_5_4:2;
    u16 Mosaic:1;           // UCN
    u16 ColorMode:1;        // PUF^QTUF I
    u16 ScBasep:5;          // XN[ x[XAhX
    u16 Loop:1;             // [v
    u16 Size:2;             // XN[TCY
} BgCnt;
typedef  vl BgCnt    vBgCnt;


// afItZbgRg[\
typedef struct {
    u16 H;
    u16 V;
} BgOffsetCnt;
typedef  vl BgOffsetCnt    vBgOffsetCnt;


// afXN[\
typedef struct {
    u16 CharNo:10;          // LN^m
    u16 HFlip:1;            // gtbv
    u16 VFlip:1;            // utbv
    u16 Pltt:4;             // pbgm
} BgScData;
typedef  vl BgScData       vBgScData;


// afAtBϊ\[Xf[^\
typedef struct {
    s32 SrcCenterX;         // f[^SW << 8
    s32 SrcCenterY;
    s16 DispCenterX;        // \SW
    s16 DispCenterY;
    s16 RatioX;             // gk << 8
    s16 RatioY;
    u16 Theta;              // ]pi0 - 255j<< 8
} BgAffineSrcData;
typedef  vl BgAffineSrcData    vBgAffineSrcData;

// afAtBϊfXeBl[Vf[^\
typedef struct {
    s16 H_DiffX;            // CwW
    s16 V_DiffX;            //   wW
    s16 H_DiffY;            // CxW
    s16 V_DiffY;            //   xW
    s32 StartX;             // X^[gwW
    s32 StartY;             // X^[gxW
} BgAffineDestData;
typedef  vl BgAffineDestData   vBgAffineDestData;


// n`l\
typedef struct {
    u32 VPos:8;             // xW
    u32 AffineMode:2;       // AtB[h
    u32 ObjMode:2;          // nai[h
    u32 Mosaic:1;           // UCN
    u32 ColorMode:1;        // PUF/QTUF I
    u32 Shape:2;            // nai`

    u32 HPos:9;             // wW
    u32 AffineParamNo_L:3;  // AtBϊp[^m ʂRrbg
    u32 HFlip:1;            // gtbv
    u32 VFlip:1;            // utbv
    u32 Size:2;             // naiTCY

    u16 CharNo:10;          // LN^m
    u16 Priority:2;         // \D
    u16 Pltt:4;             // pbgm
    u16 AffineParam;        // AtBϊp[^
} OamData;
typedef  vl OamData    vOamData;

// n`l\[gZbg֐p[^\
typedef struct {
    s8    SortUpDown;       // ~\[gItO
    u8    SrcPadSize:4;     // \[Xf[^EpfBOETCY
    u8    DestPadSize:4;    // fXeBl[Vf[^EpfBOETCY
    u8    SetNum;           // zZbg
    u8    CheckOffset;      // D`FbNf[^EItZbg
    void *CheckStartp;      // D`FbNf[^EX^[gAhX
    u32   CheckMask;        // D`FbNf[^p}XN
} OamSortSetParam;
typedef  vl OamSortSetParam    vOamSortSetParam;


// naiAtBϊ\[Xf[^\
typedef struct {
    s16 RatioX;             // gk
    s16 RatioY;
    u16 Theta;              // ]pi0 - 255j<< 8
} ObjAffineSrcData;
typedef  vl ObjAffineSrcData   vObjAffineSrcData;

// naiAtBϊfXeBl[Vf[^\
typedef struct {
    s16 H_DiffX;            // CwW
    s16 V_DiffX;            //   wW
    s16 H_DiffY;            // CxW
    s16 V_DiffY;            //   xW
} ObjAffineDestData;
typedef  vl ObjAffineDestData  vObjAffineDestData;


// J[pbg\
typedef struct {
    u16 Red:5;              // 
    u16 Green:5;            // 
    u16 Blue:5;             // 
    u16 Dummy_15:1;
} PlttData;
typedef  vl PlttData    vPlttData;


// EChERg[\
typedef struct {
    u8  Bg0_On:1;           // afO nm
    u8  Bg1_On:1;           // afP nm
    u8  Bg2_On:1;           // afQ nm
    u8  Bg3_On:1;           // afR nm
    u8  Obj_On:1;           // nai nm
    u8  Blend_On:1;         // J[ nm
    u8  Dummy_7_6:2;
} WindCnt;
typedef  vl WindCnt     vWindCnt;


// TEhRg[\
typedef struct {
    u8  So1_Level:3;        // rnPo̓x
    u8  So1_Vin_On:1;       // urnP nm
    u8  So2_Level:3;        // rnQo̓x
    u8  So2_Vin_On:1;       // urnQ nm
    u8  So1_Sound1_On:1;    // TEhPrnP nm
    u8  So1_Sound2_On:1;    // TEhQrnP nm
    u8  So1_Sound3_On:1;    // TEhRrnP nm
    u8  So1_Sound4_On:1;    // TEhSrnP nm
    u8  So2_Sound1_On:1;    // TEhPrnQ nm
    u8  So2_Sound2_On:1;    // TEhQrnQ nm
    u8  So2_Sound3_On:1;    // TEhRrnQ nm
    u8  So2_Sound4_On:1;    // TEhSrnQ nm
    u8  Sound_1_4_Mix:2;    // clf݊TEh 
    u8  DirectA_Mix:1;      // _CNgTEh` 
    u8  DirectB_Mix:1;      // _CNgTEha 
    u8  Dummy_23_20:4;
    u8  So1_DirectA_On:1;   // _CNgTEh`rnP nm
    u8  So2_DirectA_On:1;   // _CNgTEh`rnQ nm
    u8  DirectA_Timer:1;    // _CNgTEh`p^C}[I
    u8  FifoA_Reset:1;      // _CNgTEh`pehen Zbg
    u8  So1_DirectB_On:1;   // _CNgTEharnP nm
    u8  So2_DirectB_On:1;   // _CNgTEharnQ nm
    u8  DirectB_Timer:1;    // _CNgTEhap^C}[I
    u8  FifoB_Reset:1;      // _CNgTEhapehen Zbg
    u8  Sound1_On:1;        // TEhP nm
    u8  Sound2_On:1;        // TEhQ nm
    u8  Sound3_On:1;        // TEhR nm
    u8  Sound4_On:1;        // TEhS nm
    u8  Dummy_38_36:3;
    u8  Sound_1_4_On:1;     // clf݊TEh nm
    u8  Dummy_47_40;
    u16 Dummy_63_48;
    u16 BiasLevel:10;       // ah`rx
    u16 Dummy_77_74:4;
    u16 OutFrequency:2;     // Đg
} SoundCnt;
typedef  vl SoundCnt     vSoundCnt;

// TEhPRg[\
typedef struct {
    u8  SweepShift:3;       // XC[v Vtg
    u8  SweepUpDownt:1;     // XC[v 
    u8  SweepTime:3;        // XC[v 
    u8  Dummy_7:1;
    u8  Dummy_15_8;
    u8  Counts:6;           // ̒(JEg)
    u8  Duty:2;             // g`̃f[eB
    u8  EnvSteps:3;         // Gx[v Xebv
    u8  EnvUp_Down:1;       // Gx[v to^cnvm
    u8  EnvInitData:4;      // Gx[v l
    u16 Frequency:11;       // g
    u16 Dummy_45_43:3;
    u16 Counter_On:1;       // JE^[ nm
    u16 Start:1;            // X^[g
} Sound1Cnt;
typedef  vl Sound1Cnt    vSound1Cnt;

// TEhQRg[\
typedef struct {
    u8  Counts:6;           // ̒(JEg)
    u8  Duty:2;             // g`̃f[eB
    u8  EnvSteps:3;         // Gx[v Xebv
    u8  EnvUp_Down:1;       // Gx[v to^cnvm
    u8  EnvInitData:4;      // Gx[v l
    u16 Dummy_31_16;
    u16 Frequency:11;       // g
    u16 Dummy_45_43:3;
    u16 Counter_On:1;       // JE^[ nm
    u16 Start:1;            // X^[g
} Sound2Cnt;
typedef  vl Sound2Cnt    vSound2Cnt;

// TEhRRg[\
typedef struct {
    u8  Dummy_6_0:5;
    u8  Connect:1;          // g`q`l
    u8  Bank:1;             // g`q`loN
    u8  On:1;               // TEhR nm
    u8  Dummy_15_8;
    u8  Counts;             // ̒(JEg)
    u8  Dummy_28_24:5;
    u8  OutputLevel:3;      // o̓x
    u16 Frequency:11;       // g
    u16 Dummy_45_43:3;
    u16 Counter_On:1;       // JE^[ nm
    u16 Start:1;            // X^[g
} Sound3Cnt;
typedef  vl Sound3Cnt    vSound3Cnt;

// TEhSRg[\
typedef struct {
    u8  Counts:6;           // ̒(JEg)
    u8  Dummy_15_14:2;
    u8  EnvSteps:3;         // Gx[v Xebv
    u8  EnvUp_Down:1;       // Gx[v to^cnvm
    u8  EnvInitData:4;      // Gx[v l
    u16 Dummy_31_16;
    u8  PreScaler:3;        // vXP[I
    u8  PolySteps:1;        // |m~JEJE^̒iI
    u8  PolyShift:4;        // |m~JEJE^ Vtg
    u8  Dummy45_40:6;
    u8  Counter_On:1;       // JE^[ nm
    u8  Start:1;            // X^[g
} Sound4Cnt;
typedef  vl Sound4Cnt    vSound4Cnt;


// m[}rhnRg[\
typedef struct {
    u16 Sck_I_O:1;          // NbNh/nI
    u16 Sck:1;              // NbNI
    u16 AckRecv:1;          // ]tOM
    u16 AckSend:1;          // ]tOM
    u16 Dummy_6_4:3;
    u16 Enable:1;           // rhn
    u16 Dummy_11_8:4;
    u16 Mode:2;             // ʐM[hI
    u16 IF_Enable:1;        // 荞ݗv 
    u16 Dammy_15:1;
    u8  Data;               // f[^
    u8  Dummy_31_24;
} SioNormalCnt;
typedef  vl SioNormalCnt    vSioNormalCnt;

// }`vCrhnRg[\
typedef struct {
    u16 BaudRate:2;         // {[[g
    u16 SI:1;               // rh[q
    u16 SD:1;               // rc[q
    u16 ID:2;               // hc
    u16 Error:1;            // G[o
    u16 Enable:1;           // rhn
    u16 Dummy_11_8:4;
    u16 Mode:2;             // ʐM[hI
    u16 IF_Enable:1;        // 荞ݗv 
    u16 Dammy_15:1;
    u16 Data;               // f[^
} SioMultiCnt;
typedef  vl SioMultiCnt     vSioMultiCnt;

// t`qs|rhnRg[\
typedef struct {
    u16 BaudRate:2;         // {[[g
    u16 Cts_Enable:1;       // M\M Cl[u
    u16 ParitySelect:1;     // peB ^
    u16 TransDataFull:1;    // gX~bgf[^ t
    u16 RecvDataEmpty:1;    // V[uf[^ GveB
    u16 Error:1;            // G[o
    u16 Length:1;           // f[^
    u16 Fifo_Enable:1;      // ehen Cl[u
    u16 Parity_Enable:1;    // peB Cl[u
    u16 Trans_Enable:1;     // gX~b^ Cl[u
    u16 Recv_Enable:1;      // V[o Cl[u
    u16 Mode:2;             // ʐM[hI
    u16 IF_Enable:1;        // 荞ݗv 
    u16 Dammy_15:1;
    u8  Data;               // f[^
    u8  Dummy_31_24;
} SioUartCnt;
typedef  vl SioUartCnt		vSioUartCnt;


// inxoXʐMRg[\
typedef struct {
    u8  IF_Reset:1;         // inxoXEZbg 荞ݗv
    u8  IF_Recv:1;          // inxoXM   荞ݗv
    u8  IF_Send:1;          // inxoXM   荞ݗv
    u8  Dummy_5_3:3;
    u8  IF_Enable:1;        // 荞ݗv 
    u8  Dummy_7:1;
} JoyCnt;
typedef  vl JoyCnt     vJoyCnt;

// inxoXʐMXe[^X\
typedef struct {
    u8  Dummy_0:1;
    u8  Recv:1;             // MXe[^X
    u8  Dummy_2:1;
    u8  Send:1;             // MXe[^X
    u8  Flags:2;            // ėptO
    u8  Dummy_7_6:2;
} JoyStat;
typedef  vl JoyStat    vJoyStat;


// ėpo̓Rg[\
typedef struct {
    u8  SC:1;               // f[^
    u8  SD:1;
    u8  SI:1;
    u8  SO:1;
    u8  SC_I_O:1;           // h/nI
    u8  SD_I_O:1;
    u8  SI_I_O:1;
    u8  SO_I_O:1;
    u8  IF_Enable:1;        // 荞ݗv 
    u8  Dummy_13_9:5;
    u8  SioModeMaster:2;   	// rhn[hE}X^
} RCnt;
typedef  vl RCnt      vRCnt;


// cl`Rg[\
typedef struct {
    u16 Count;              // ]
    u16 Dummy_21_16:5;
    u16 DestpCnt:2;         // ]AhX Rg[
    u16 SrcpCnt:2;          // ]AhX Rg[
    u16 ContinuousON:1;     // ReBjAX[h
    u16 BusSize:1;          // oXTCY PU/RQaI
    u16 DataRequest:1;      // f[^v[h
    u16 Timming:2;          // ^C~OI
    u16 IF_Enable:1;        // 荞ݗv 
    u16 Enable:1;           // cl`
} DmaCnt;
typedef  vl DmaCnt    vDmaCnt;


// ^C}[Rg[\
typedef struct {
    u16 Count;              // JEg
    u16 PreScaler:2;        // vXP[I
    u16 Connect:1;          // ʃ^C}[ڑ
    u16 Dummy_5_3:3;
    u16 IF_Enable:1;        // 荞ݗv 
    u16 Enable:1;           // ^C}[
    u16 Dummy_15_8:8;
} TimerCnt;
typedef  vl TimerCnt    vTimerCnt;


// L[f[^\
typedef struct {
    u16 A:1;                // `
    u16 B:1;                // a
    u16 Select:1;           // ZNg
    u16 Start:1;            // X^[g
    u16 Plus_R:1;           // E
    u16 Plus_L:1;           // 
    u16 Plus_U:1;           // 
    u16 Plus_D:1;           // 
    u16 R:1;                // q
    u16 L:1;                // k
    u16 Dummy_15_10:6;
} KeyData;
typedef  vl KeyData    vKeyData;

// L[Rg[\
typedef struct {
    u16 Sel_A:1;            //       `{^ I
    u16 Sel_B:1;            //       a{^ I
    u16 Sel_Select:1;       // ZNg{^ I
    u16 Sel_Start:1;        // X^[g{^ I
    u16 Sel_Plus_R:1;       //         EL[ I
    u16 Sel_Plus_L:1;       //         L[ I
    u16 Sel_Plus_U:1;       //         L[ I
    u16 Sel_Plus_D:1;       //         L[ I
    u16 Sel_R:1;            //       q{^ I
    u16 Sel_L:1;            //       k{^ I
    u16 Dummy_13_10:4;
    u16 IF_Enable:1;        // 荞ݗv 
    u16 IntrType:1;         // 荞݃^Cv I
} KeyCnt;
typedef  vl KeyCnt    vKeyCnt;


// JZbgEFCgRg[\
typedef struct {
    u16 Sram:2;             // rq`lEFCg
    u16 Rom0_1st:2;         // qnlO PEFCg
    u16 Rom0_2nd:1;         //          QEFCg
    u16 Rom1_1st:2;         // qnlP PEFCg
    u16 Rom1_2nd:1;         //          QEFCg
    u16 Rom2_1st:2;         // qnlQ PEFCg
    u16 Rom2_2nd:1;         //          QEFCg
    u16 OutClock:2;         // o̓NbN I
    u16 Dummy_13:1;
    u16 PrefetchEnale:1;    // vtFb`obt@ 
    u16 CassetteType:1;     // JZbg^Cv
} CstWaitCnt;
typedef  vl CstWaitCnt    vCstWaitCnt;


// Bitkf[^WJpp[^
typedef struct {
    u16 SrcNum;             // \[Xf[^EoCg
    u8  SrcBitNum;          // P\[Xf[^Erbg
    u8  DestBitNum;         // PfXeBl[Vf[^Erbg
    u32 DestOffset:31;      // \[Xf[^ɉZ鐔
    u32 DestOffset0_On:1;   // Õf[^ɃItZbgZ邩ۂ̃tO
} BitUnPackParam;
typedef  vl BitUnPackParam    vBitUnPackParam;


#ifdef __cplusplus
}      /* extern "C" */
#endif

#endif /* _AGB_TYPES_H */
