/********************************************************************/
/*					`faj^vOp`				    */
/********************************************************************/
#ifndef	_AGB_MON_DEFINE_H
#define	_AGB_MON_DEFINE_H


/*------------------------------------------------------------------*/
/*                      E}bv                              */
/*------------------------------------------------------------------*/

#define MON_CPU_WRAM            0x03000000                  // bot[Nq`l
#define MON_CPU_WRAM_END        (MON_CPU_WRAM + 0x01000000)
#define MON_WRAM                 EX_WRAM                    // [Nq`lS
#define MON_WRAM_END             MON_CPU_WRAM_END
#define MON_USR_BUF              EX_WRAM                    // [Ü
#define MON_USR_BUF_END         (MON_CPU_WRAM_END - 4*32)
#define MON_SYS_BUF             (MON_CPU_WRAM_END - 4*32)   //VXë
#define MON_SYS_BUF_END          MON_CPU_WRAM_END
#define MON_FIQ_VECTOR_BUF      (MON_CPU_WRAM_END - 4*6 )   // FIQ荞ݕAhX
#define MON_INTR_VECTOR_BUF     (MON_CPU_WRAM_END - 4*1 )   // 荞ݕAhX

#define ROM_HEADER              0x08000004                  // ROMo^f[^

#define MON_NINLOGO             (ROM_HEADER + 0x0     )     // NINTENDOSEf[^
#define MON_FIQ_FLAG            (ROM_HEADER + 0x9c - 4)     // ehptO
#define MON_KEY_GROUP_NO        (ROM_HEADER + 0x9e - 4)     // L[O[vm
#define MON_SOFT_NAME           (ROM_HEADER + 0xa0 - 4)     // \tg
#define MON_COMPLEMENT          (ROM_HEADER + 0xbd - 4)     // ␔`FbNEf[^

#define ICE_ROM0                0x09fe2000                  // hbd qnl
#define ICE_ROM0_END            0x09fe4000
#define ICE_ROM1                0x09ffc000
#define ICE_ROM1_END            0x09ffe000

#define DACS_KEY_REG0           0x0bfe2000 - 32             // c`brL[WX^
#define DACS_KEY_REG1           0x0c000000 - 32

#define REG_PAUSE               (REG_BASE + 0x300)          // o`trd
#define REG_OBJ_CENTER          (REG_BASE + 0x410)          // naiSʒu

/*------------------------------------------------------------------*/
/*                      o^f[^EItZbg                      */
/*------------------------------------------------------------------*/

#define OFFSET_MON_NINLOGO      (MON_NINLOGO      - MON_NINLOGO)  // NINTENDOSEf[^
#define OFFSET_MON_FIQ_FLAG     (MON_FIQ_FLAG     - MON_NINLOGO)  // ehptO
#define OFFSET_MON_KEY_GROUP_NO (MON_KEY_GROUP_NO - MON_NINLOGO)  // L[O[vm
#define OFFSET_MON_SOFT_NAME    (MON_SOFT_NAME    - MON_NINLOGO)  // \tg
#define OFFSET_MON_COMPLEMENT   (MON_COMPLEMENT   - MON_NINLOGO)  // ␔`FbNEf[^

#define OFFSET_REG_PAUSE        0x300                             // o`trd
#define OFFSET_REG_OBJ_CENTER   0x410                             // naiSʒu

/*------------------------------------------------------------------*/
/*                      ETCY                              */
/*------------------------------------------------------------------*/

#define ROM_HEADER_SIZE         (0xc0 - 4 + OFFSET_MON_NINLOGO) // ROMo^f[^
#define MON_NINLOGO_SIZE        (MON_SOFT_NAME - MON_NINLOGO)   // NINTENDOSEf[^

#define ICE_ROM_SIZE            0x2000                          // hbd qnl

/*------------------------------------------------------------------*/
/*						f ^C~O							    */
/*------------------------------------------------------------------*/

#define LOGO_SOUND_START		 16
#define LOGO_PIRON_START		(0x70 + 0x32)

#define NINLOGO_PERIOD			(32+18)
#define GBLOGO_JUMP_START		 8
#define GBLOGO_JUMP_PERIOD		(63-16)
//#define GBLOGO_JUMP_PERIOD	(64-GBLOGO_BOUND_PERIOD)
//#define GBLOGO_JUMP_PERIOD	 63
//#define GBLOGO_BOUND_PERIOD	((7+5+3)*2+3)
#define GBLOGO_BOUND_PERIOD		((9+5+3)*2)
//#define GBLOGO_BOUND_PERIOD	((11+7+5)*2)
//#define GBLOGO_BOUND_PERIOD	((15+9+5+3)*2)
#define GBLOGO_FLUSH_START		 (63+GBLOGO_BOUND_PERIOD-1)
#define GBLOGO_HILITE_START		 0x6c
//#define GBLOGO_HILITE_START		 0x70
#define GBLOGO_HILITE_END		(GBLOGO_HILITE_START + 0x48)

#define SIO_BOOT_CHECK_START	 56
#define SIO_BOOT_CHECK_END		(LOGO_PIRON_START - 0x12)

/*------------------------------------------------------------------*/
/*						AtBϊ							    */
/*------------------------------------------------------------------*/
#if 0
#define SIN_SHIFT			14
#define AFFINE_DIV_SHIFT	8
#define AFFINE_REG_SHIFT	8
#define AFFINE_CAL_SHIFT	(SIN_SHIFT + AFFINE_DIV_SHIFT - AFFINE_REG_SHIFT)
#endif

#endif	/* _AGB_MON_DEFINE_H */
