#ifndef	_AGB_SOUND_PRV_H
#define	_AGB_SOUND_PRV_H

#include <Agb.h>
#include <AgbSound.h>

#define WITH_ASM
//#define USE_SYSCALL



//z`l̍\
typedef struct {
	u8 sf;		//Xe[^XtO
	u8 ty;		//^Cv
	u8 rv;		//E
	u8 lv;		//
	u8 at;		//A^bN
	u8 de;		//fBPC
	u8 su;		//TXeB
	u8 re;		//[X
	u8 ky;		//ۂ̉
	u8 ev;		//dmux
	u8 er;		//dmuE
	u8 el;		//dmu
	u8 iev;		//^GR[
	u8 iel;		//^GR[
	u8 d1;		// (reserved)
	u8 d2;		// (reserved)
	u8 gt;		//GATEJE^
	u8 mk;		//(MIDI KEY)
	u8 ve;		//xVeB
	u8 pr;		//vCIeB
	u8 d3[4];	// (reserved)
	u32 ct;		//ĐJE^
	u32 fw;		//DDAƕϐ
	u32 fr;		//gvZl
	WaveData *wp;	//g`|C^
	s8 *cp;		//Đ|C^
	void *tp;	//TRACK|C^
	void *pp;	//OSoundChannel|C^
	void *np;	//SoundChannel|C^
	u32 d4[2];	// (reserved)
} SoundChannelPrv;

#define SOUND_CHANNEL_SF_ENV_AT 0x03
#define SOUND_CHANNEL_SF_ENV_DE 0x02
#define SOUND_CHANNEL_SF_ENV_SU 0x01
#define SOUND_CHANNEL_SF_ENV_SB 0x01


//bfa݊`l̍\
typedef struct {
	u8 sf;		//Xe[^XtO
	u8 ty;		//^Cv
	u8 rv;		//E
	u8 lv;		//
	u8 at;		//A^bN
	u8 de;		//fBPC
	u8 su;		//TXeB
	u8 re;		//[X
	u8 ky;		//ۂ̉
	u8 ev;		//dmux
	u8 eg;		//dmuڕW
	u8 ec;		//dmuJE^
	u8 iev;		//^GR[
	u8 iel;		//^GR[
	u8 d1;		// (reserved)
	u8 d2;		// (reserved)
	u8 gt;		//GATEJE^
	u8 mk;		//(MIDI KEY)
	u8 ve;		//xVeB
	u8 pr;		//vCIeB
	u8 d3[4];	// (reserved)
	u8 d5;		// (reserved)
	u8 sg;		//TXeBڕW
	u8 n4;		//NRx4WX^
	u8 pa;		//p|bg
	u8 pb;		//p̃rbg
	u8 mo;		//fBt@C
	u8 le;		//̒
	u8 sw;		//XC[v
	u32 fr;		//gvZl
	u32 *wp;	//g`|C^
	u32 *cp;	//oNg`
	void *tp;	//TRACK|C^
	void *pp;	//OSoundChannel|C^
	void *np;	//SoundChannel|C^
	u32 d4[2];	// (reserved)
} CgbChannelPrv;

#define CGB_CHANNEL_MO_PIT  0x02
#define CGB_CHANNEL_MO_VOL  0x01


#define MTRACK_PATSIZ 3

typedef struct {
	u8 flg;
	u8 wai;
	u8 patP;
	u8 repN;

	u8 gat, key, vel;
	u8 run;

	s8 keyM; u8 pitM;
	s8 ksh; s8 kshX;
	s8 tun; u8 pitX;
	s8 bnd; u8 bndR;

	u8 volMR, volML;
	u8 vol, volX;
	s8 pam, pamX;

	s8 modM;
	u8 mod, modT;
	u8 lfo, lfoC;
	u8 ldl, ldlC;

	u8 prio;
	u8 iev, iel;

	SoundChannelPrv *chn;

	u8 typ, _key, len, p_s;
	WaveData *wav;
	u8 att, dec, sus, rel;

	u8 dmy2[16];

	u8 *adr;
	u8 *patS[MTRACK_PATSIZ];
} MPlayTrkPrv;

#define MPT_FLG_EXIST   0x80
#define MPT_FLG_START   0x40
#define MPT_FLG_PITCHG  0x0c
#define MPT_FLG_PITSET  0x04
#define MPT_FLG_VOLCHG  0x03
#define MPT_FLG_VOLSET  0x01


typedef struct {
	SongHeader *song;	//\Of[^AhX
	u32 stat;			//Xe[^X

	u8 mtrk;			//gbN
	u8 prio;			//vCIeB
	u8 cmd;
	u8 dmy1[5];
	u8 dmy2[12];

	u16 TempoD;
	u16 TempoU;
	u16 TempoI;
	u16 TempoC;

	u16 FadeOI;
	u16 FadeOC;
	u16 FadeOV;
	u16 dmy3;

	MPlayTrkPrv *PlyTrk;
	ToneData *tone;

	u32 ident;
	void (*func)();
	u32 intp;
} MPlayAreaPrv;


#define W00     0x80
#define W96     (W00+48)
#define RUNSTT  0xBD
#define TIE     0xCF
#define CENTER  0x40
#define MOD_VIB 0
#define MOD_TRE 1
#define MOD_PAM 2
#define TEMPOBASE 150
#define MA(PRM)  (((MPlayAreaPrv *)ma)->PRM)
#define SA(PRM)  ((*(SoundAreaPrv **)SOUND_AREA_ADR)->PRM)

#define MPLYJMPTBLSIZ 36


//VXeƗ̈
#define SOUND_AREA_ADR 0x03007FF0
//#define SOUND_AREA_ADR 0x0200BFEC
#define ID_NUMBER 0x68736D53 //"Smsh"


//TEhE[NGA̍\
typedef struct {
	u32 ident;
	vu8 DmaCount;
	u8 reverb;
	u8 maxchn;
	u8 masvol;
	u8 freq;
	u8 mode;
	u8 c15;
	u8 pcmDT;
	u8 r3[4];	// (reserved)
	u32 pcmVB;
	u32 pcmFQ;	// (pcmVB * 59.7275)
	u32 divFQ;	// (0x1000000/pcmFQ)
	CgbChannelPrv *vcgb;
	void (*func)();
	u32 intp;
	void (*CgbSound)();
	void (*CgbOscOff)(u8);
	u32 (*MK2CgbFr)(u8, u8, u8);
	void (**MPlyJmpTbl)();
	void (*plynote)(u8, MPlayAreaPrv*, MPlayTrkPrv*);
	void (*ExtVolPit)(MPlayAreaPrv*, MPlayTrkPrv*);
	u32 r9[4];		// (reserved)
	SoundChannelPrv vchn[MAX_DIRECTSOUND_CHANNEL];
	s8 pcmbuf[PCM_DMA_BUF*2];
} SoundAreaPrv;

//#define SOUND_AREA_MODE_MONO    0x01
//#define SOUND_AREA_MODE_CGB_ON  0x02

//#define SOUND_MODE_STEREO       0x00002000
//#define SOUND_MODE_MONORAL      0x00003000
//#define SOUND_MODE_CGB_OFF      0x00008000
//#define SOUND_MODE_CGB_ON       0x0000c000
#define SOUND_MODE_FREQ_VALUE   0x000f0000
#define SOUND_MODE_DA_BIT_VAL   0x00300000
#define SOUND_MODE_DA_BIT_SET   0x00800000


//Global Functions

#undef USE_SYSCALL
#ifndef USE_SYSCALL

extern void SoundInit(SoundArea *sa);
extern void SoundMode(u32 mode);
extern void SoundMain(void);
extern void SoundVSync(void);
extern void SoundClearAll(void);
extern void SoundVSyncOff(void);
extern void SoundVSyncOn(void);
extern u32  MidiKey2fr(WaveData *wa, u8 mk, u8 fp);

extern void MPlayOpen(MusicPlayerArea *ma, MusicPlayerTrack *ta, u8 tn);
extern void MPlayStart(MusicPlayerArea *ma, SongHeader *so);
extern void MPlayStop(MusicPlayerArea *ma);
extern void MPlayContinue(MusicPlayerArea *ma);
extern void MPlayFadeOut(MusicPlayerArea *ma, u16 sp);
extern void MPlyJmpTblCopy(void (**tbl)());

#else

#define SoundInit(P1)           SoundDriverInit(P1)
#define SoundMode(P1)           SoundDriverMode(P1)
#define SoundMain()             SoundDriverMain()
#define SoundVSync()            SoundDriverVSync()
#define SoundClearAll()         SoundChannelClear()
#define SoundVSyncOff()         SoundDriverVSyncOff()
#define SoundVSyncOn()          SoundDriverVSyncOn()
#define MidiKey2fr(P1,P2,P3)    MidiKey2Freq(P1,P2,P3)

#define MPlayOpen(P1,P2,P3)     MusicPlayerOpen(P1,P2,P3)
#define MPlayStart(P1,P2)       MusicPlayerStart(P1,P2)
#define MPlayStop(P1)           MusicPlayerStop(P1)
#define MPlayContinue(P1)       MusicPlayerContinue(P1)
#define MPlayFadeOut(P1,P2)     MusicPlayerFadeOut(P1,P2)

extern void MusicPlayerJumpTableCopy(void (**tbl)()); // J
#define MPlyJmpTblCopy(P1)      MusicPlayerJumpTableCopy(P1)

#endif // USE_SYSCALL

#endif // _AGB_SOUND_PRV_H
