//---------------------------------------------------------------------------
#include <vcl\condefs.h>
#include <fcntl.h>
#include <io.h>
#include <sys\stat.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "AgbComp.h"

#pragma hdrstop
//---------------------------------------------------------------------------
//USERES("AgbComp.res");
//---------------------------------------------------------------------------

void usage(void);

/*-------------------- O[oϐ ----------------------*/

FILE    *fpi, *fpo;			/* t@CE|C^ */
char    *outfileNamep;		/* o̓t@CE|C^ */
char    *labelNamep;		/* z񖼁E|C^ */
char     labelName[512];
char     infileName[512];
char     outfileName[512];
int		outType = 0;
int		outFileType = 0;
int		outFileCustomFlag = 0;
int		smallDotID = 1;
int		shortSymbol = 0;
int		rawHeaderFlag;
int		noHeaderFlag;
int		lzSearchOffset = 1;
u32		huffBitSize = 8;
u32		diffBitSize = 8;
u8		*CompBufp[2];
s32		 CompBufNo = 1;
char	 CompTypeBuf[256];
char	*CompTypeBufp;

u32	inPaletteNum;			/* ̓C[WEpbg */
u16	inIndexSize = 0;   		/* ̓C[WECfbNXETCY */
u16	inIndexSizeB = 0;  		/* ̓C[WECfbNXEoCgTCY */
s32	inImageOffset;			/* ̓C[WEItZbg */
u32	inHSize, inVSize;  		/* ̓C[WETCY */


u32	outDotSize = 0;			/* o̓hbgETCY */
u32	outDotSizeB = 0;   		/* o̓hbgEoCgTCY */
u32	outHSize, outVSize;		/* o̓C[WETCY */
u8	outIndexOffset = 0;   	/* o̓C[WECfbNXEItZbg */
u32	outBitSize;				/* o͔zrbg */

/************************************************************/
/*                                                          */
/*                    CE[`                      */
/*                                                          */
/*             (:  A[Mg        )            */
/*             (       A[MgE|C^)            */
/*                                                          */
/************************************************************/
void argCheck(int argc, char *argv[]);
void infileOpen(int argc, char *argv[]);
void outfileOpen(void);
void headerWrite(void);
void palletteReadWrite(FILE *fpi);
void imageReadWrite(   FILE *fpi);
void infileClose(FILE *fpi);
void outfileClose(void);
#define OUT_FILE_C		0
#define OUT_FILE_BIN	1

main (int argc, char *argv[])
{
	argCheck(argc, argv);			/* A[Mg */

	infileOpen(argc, argv);			/* ̓t@CEI[v */

	imageReadWrite(fpi);			/* C[W̓Ǎ݂Ə */

	outfileClose();					/* o̓t@CEN[Y */
	infileClose(fpi);	 			/* ̓t@CEN[Y */

	return 0;
}


/*==========================================================*/
/*                                                          */
/*                      to                      */
/*                                                          */
/*==========================================================*/

void usage(void)
{
#ifdef IRIS
	fprintf(stderr, "Usage:	iriscomp");
#else
	fprintf(stderr, "Usage:	AgbComp");
#endif
	fprintf(stderr, " [-b] [-f] [-h] [-d 8|16] [-r] [-l search] [-h 4|8] [-s] [-O outputFile] inputFile\n");
	fprintf(stderr, "       -b              Binary file output.\n");
	fprintf(stderr, "       -h              Raw data header.\n");
#ifdef IRIS
//	fprintf(stderr, "       -n              No header.\n");
#endif
	fprintf(stderr, "       -d bitSize      Differential filter.\n");
	fprintf(stderr, "       -r              Runlength encode.\n");
	fprintf(stderr, "       -l search       LZ77      encode.\n");
	fprintf(stderr, "       -h bitSize      Huffman   encode.\n");
	fprintf(stderr, "       -s              Short symbol deleted path.\n");
	fprintf(stderr, "       -O outputFile   Change of output file.\n");
	exit(1);
}


/*==========================================================*/
/*                                                          */
/*                    A[Mg                    */
/*                                                          */
/*==========================================================*/
int optionCheck(int argc, char *argv[]);
int	stepArgvNum;

void argCheck(int argc, char *argv[])
{
    stepArgvNum = optionCheck(argc, argv);
    if (argc-stepArgvNum < 2)	usage();		/* A[Mg`FbN */
}

/*----------------------------------------------------------*/
/*                IvVE`FbN						*/
/*----------------------------------------------------------*/
int	argvTmp;

int optionCheck(int argc, char *argv[])
{
	char	*optionp;
	int		stepArgvNum = 0;

	while (--argc > 1)
		if (**(++argv) == '-') {
			optionp = *argv;
			stepArgvNum++;
			while (*(++optionp))
				switch (*optionp) {
					case 'b':	outFileType = OUT_FILE_BIN;	break;
					case 's':	shortSymbol = 1;			break;
					case 'r':	strcat(CompTypeBuf, "r");
								break;                    
					case 'd':	strcat(CompTypeBuf, "d");
 								diffBitSize = atoi(*(++argv));
								if (diffBitSize != 8 && diffBitSize != 16) {
									diffBitSize = 8;
									argv--;
								} else {
									stepArgvNum++;
	        						argc--;
								}
								break;
					case 'n':	noHeaderFlag = 1;			break;
					case 'h':	argvTmp = atoi(*(++argv));
								if (argvTmp != 4 && argvTmp != 8) {
									rawHeaderFlag = 1;
									argv--;
								} else {
									strcat(CompTypeBuf, "h");
									huffBitSize = argvTmp;
									stepArgvNum++;
	        						argc--;
								}
								break;
					case 'l':	strcat(CompTypeBuf, "l");
								if ((lzSearchOffset = atoi(*(++argv))) == 0) {
									lzSearchOffset = 1;
									argv--;
								} else {
									stepArgvNum++;
	        						argc--;
								}
								break;
					case 'O':	strcpy(outfileName, *(++argv));
								outFileCustomFlag = 1;
								stepArgvNum++;
        						argc--;
								break;
				}
		} else
			usage();

	return stepArgvNum;
}


/*==========================================================*/
/*                  ̓t@CEI[v                  */
/*==========================================================*/
void infileOverWriteCheck(void);
void argv2labelName(char *argv[]);

void infileOpen(int argc, char *argv[])
{
	char *fileNamep = argv[1+stepArgvNum];

	strcpy(infileName, argv[1+stepArgvNum]);

    if (((char *)strrchr(infileName, '.')) == NULL)	// ̓t@C gq`FbN
		usage();

    if ((fpi = fopen(fileNamep, "rb")) == NULL) {	// ̓t@C I[v
        fprintf(stderr, "Can't open: %s (No such file or directory)\n", fileNamep);
        exit(1);
    }

	infileOverWriteCheck();		// ̓t@C ㏑`FbN

    argv2labelName(argv);
}

/*----------------------------------------------------------*/
/*               ̓t@C㏑`FbN                 */
/*----------------------------------------------------------*/

void infileOverWriteCheck(void)
{
    if (!strcmp(outfileName, infileName)) {
        fprintf(stderr, "OutputFile equal InputFile: %s\n", outfileName);
        exit(1);
    }
}

/*----------------------------------------------------------*/
/*                    xϊ		                    */
/*----------------------------------------------------------*/

void argv2labelName(char *argv[])
{
    char	*periodp;

	if (!outFileCustomFlag)
		strcpy(outfileName, infileName);			// ԏo̓t@C 

	strcpy(labelName, outfileName);					// ԃx 
    if ((periodp = strrchr(labelName, '.')) != NULL)
       *periodp = '\0';

	if (!outFileCustomFlag)
		strcpy(outfileName, labelName);				// ԏo̓t@C 

    if (shortSymbol) {								// ԃx pX폜
        if ((periodp = strrchr(labelName, '/')) != NULL)
	        strcpy(labelName, ++periodp);
        if ((periodp = strrchr(labelName, '\\')) != NULL)
	        strcpy(labelName, ++periodp);
    }
}


/*==========================================================*/
/*                                                          */
/*                  o̓t@CEI[v                  */
/*                                                          */
/*==========================================================*/
void argv2outfileName(void);
int		BinOutHandle;

void outfileOpen(void)
{
    argv2outfileName();

	if (!strcmp(outfileName, infileName)) {
	        fprintf(stderr, "OutputFile equal InputFile: %s\n", outfileName);
			outfileClose();				/* o̓t@CEN[Y */
			infileClose(fpi);	 		/* ̓t@CEN[Y */
	 		exit(1);
    }

	if (outFileType == OUT_FILE_C) {
	    if ((fpo = fopen(outfileName, "w+")) == NULL) {
	        fprintf(stderr, "Can't open: %s\n", outfileName);
	        exit(1);
	    }
	} else {
		if ((BinOutHandle = open(outfileName, O_CREAT|O_WRONLY|O_BINARY|O_TRUNC,
    										   S_IWRITE)) == -1) {

	        fprintf(stderr, "Can't open: %s\n", outfileName);
	        exit(1);
	    }
	}
}


/*----------------------------------------------------------*/
/*                    o̓t@Cϊ                    */
/*----------------------------------------------------------*/

void argv2outfileName(void)
{
	if (!outFileCustomFlag)
		if (outFileType == OUT_FILE_C)
    						strcat(outfileName, ".c");
		else			    strcat(outfileName, ".bin");
}


/*==========================================================*/
/*                                                          */
/*                       malloc `FbN                    */
/*                                                          */
/*==========================================================*/

void mallocCheck(void)
{
    if (CompBufp[0] == NULL || CompBufp[1] == NULL) {
        fprintf(stderr, "Error:	Memory is not enough.\n");
        exit(1);
    }
}


/*==========================================================*/
/*                                                          */
/*                       wb_                       */
/*                                                          */
/*==========================================================*/

void typesHeaderWrite(void)
{
#ifdef IRIS
    fprintf(fpo, "#include <IrisTypes.h>\n");
#else
    fprintf(fpo, "#include <AgbTypes.h>\n");
#endif
    fprintf(fpo, "\n\n");
}


/*==========================================================*/
/*                                                          */
/*                 C[W̓Ǎ݂Ə                 */
/*                                                          */
/*==========================================================*/
void RawWrite(   u8 **Srcpp, u32 SrcNum);
void RawWriteBin(u8 **Srcpp, u32 SrcNum);
void RLCompWrite(    u8 **Srcpp, u32 SrcNum, u8 **Destpp);
void LZCompWrite(    u8 **Srcpp, u32 SrcNum, u8 **Destpp);
void HuffCompWrite(  u8 **Srcpp, u32 SrcNum, u8 **Destpp);
void DiffFiltWrite(  u8 **Srcpp, u32 SrcNum, u8 **Destpp);
u8	*readBufp;
s32	 readCount;

void imageReadWrite(FILE *fpi)
{
	fseek(fpi, 0, SEEK_END);						// t@CTCYl
	readCount = ftell(fpi);
	fseek(fpi, 0, SEEK_SET);

	(void *)CompBufp[0] = malloc(readCount*2 + 4 + 256*2);
	(void *)CompBufp[1] = malloc(readCount*2 + 4 + 256*2);
	(void *)readBufp    = CompBufp[0];

	mallocCheck();									// malloc `FbN

	readCount = 0;
	if (rawHeaderFlag)	readCount = 4;

	while (!feof(fpi))											// t@Cǂݍ
		fread(&readBufp[readCount++],1,1,fpi);
	readCount--;
//	while (readCount & 0x3)	readBufp[readCount++] = 0;

	if (rawHeaderFlag)	*(u32 *)readBufp = readCount << 8 | 0;	// wb_

	CompTypeBufp = CompTypeBuf;
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&readBufp, readCount, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite(  &readBufp, readCount, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &readBufp, readCount, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&readBufp, readCount, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();					/* o̓t@CEI[v */
        			if (outFileType == OUT_FILE_C)
							RawWrite(   &readBufp, readCount);
					else	RawWriteBin(&readBufp, readCount);
					break;
	}
}

/*----------------------------------------------------------*/
/*			  	[ELN^EC[Wo			*/
/*----------------------------------------------------------*/

void RawWriteBin(u8 **Srcpp, u32 SrcNum)
{
	u8	*Srcp = *Srcpp;
    int	outCountTmp = 0;
	int	i;

	if (rawHeaderFlag & noHeaderFlag)	outCountTmp = 4;

	while (outCountTmp < readCount)			// f[^
			_rtl_write(BinOutHandle, &Srcp[outCountTmp++], 1);
}

void RawWrite(u8 **Srcpp, u32 SrcNum)
{
	u8	*Srcp = *Srcpp;
	int	outCountTmp = 0;
	int	i, ii, iii;

    typesHeaderWrite();

	fprintf(fpo, "const u8 %s[0x%x] =  {\n",
			labelName,  readCount);

	if (rawHeaderFlag) {
		if (noHeaderFlag)	outCountTmp = 4;
		else {
			for (i=0; i<4; i++)				  	// wb_
					fprintf(fpo, "0x%02x,", Srcp[outCountTmp++]);
			fprintf(fpo, "\n");
			fprintf(fpo, "\n");
		}
	}

	while (outCountTmp < readCount) {	  	// f[^
		for (i=0; i<16 && outCountTmp < readCount; i++) {
			fprintf(fpo, "0x%02x,", Srcp[outCountTmp++]);
		}
		fprintf(fpo, "\n");
	}

    fprintf(fpo, "};\n");
}


/*----------------------------------------------------------*/
/*			   		tB^							*/
/*----------------------------------------------------------*/
void DiffWrite(   u8 *Destp);
void DiffWriteBin(u8 *Destp);
int  DiffOutBufCount,   DiffCount;

void DiffFiltWrite(u8 **Srcpp, u32 SrcNum, u8 **Destpp)
{
	u8	*Srcp   = (u8  *)*Srcpp, *Destp   = (u8  *)*Destpp;
	u16	*Src16p = (u16 *)*Srcpp, *Dest16p = (u16 *)*Destpp;
    u32	i;

	strcat(labelName, "_Diff");
	if (!outFileCustomFlag)		strcat(outfileName, "_Diff");

	*(u32 *)Destp = SrcNum << 8 | 0x80 | diffBitSize/8;	// f[^Ewb_
    DiffCount = 4;

	if (diffBitSize == 8) {
		Destp[DiffCount++] = Srcp[0];
		for (i=1; i<SrcNum; i++)
			Destp[DiffCount++] = Srcp[i] - Srcp[i-1];
	} else {
		Dest16p[DiffCount/2] = Src16p[0];
		DiffCount += 2;
		for (i=1; i<SrcNum/2; i++, DiffCount += 2)
			Dest16p[DiffCount/2] = Src16p[i] - Src16p[i-1];
	}
	while (DiffCount & 0x3)	Destp[DiffCount++] = 0;


	CompBufNo ^= 1;							// dk or f[^
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&Destp, DiffCount, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite(  &Destp, DiffCount, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &Destp, DiffCount, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&Destp, DiffCount, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();			// o̓t@CEI[v
					if (outFileType == 0)	DiffWrite(   Destp);
					else					DiffWriteBin(Destp);
					break;
	}
}

/*----------------------------------------------------------*/
/*			   		C[Wo						*/
/*----------------------------------------------------------*/

void DiffWriteBin(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i;

	if (noHeaderFlag)	outCountTmp = 4;

	while (outCountTmp < DiffCount)
	 	_rtl_write(BinOutHandle, &Destp[outCountTmp++], 1);
}

void DiffWrite(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i;

    typesHeaderWrite();

	fprintf(fpo, "const u8 %s[0x%x] = {\n", labelName, DiffCount);

	if (noHeaderFlag)	outCountTmp = 4;
	else {
		for (i=0; i<4; i++)							 	// WJ
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		fprintf(fpo, "\n");
		fprintf(fpo, "\n");
	}

	while (outCountTmp < DiffCount) {	   			// f[^
		for (i=0; i<16 && outCountTmp < DiffCount; i++) {
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		}
		fprintf(fpo, "\n");
	}

    fprintf(fpo, "};\n");
}


/*----------------------------------------------------------*/
/*			   		OXk						*/
/*----------------------------------------------------------*/
void RLWrite(   u8 *Destp);
void RLWriteBin(u8 *Destp);
u32	 RLOutBufCount,   RLCount;

void RLCompWrite(u8 **Srcpp, u32 SrcNum, u8 **Destpp)
{
	u8	*Srcp   = *Srcpp, *Destp   = *Destpp;
	u8	*Startp;
	u8	CompFlag;
	u32	Length;
    u32	i;

	strcat(labelName, "_RL");
	if (!outFileCustomFlag)		strcat(outfileName, "_RL");

	*(u32 *)Destp = SrcNum << 8 | 0x30;	// f[^Ewb_
    RLCount = 4;

	RLOutBufCount = 0;
	while (RLOutBufCount < SrcNum) {
		Startp = &Srcp[RLOutBufCount];
 		Length = 0;
		CompFlag = 0;
		for (i=0; i<128; i++) {         // f[^E`FbN
 			if (RLOutBufCount + Length + 2 >= SrcNum) {
				Length = SrcNum - RLOutBufCount;
				break;
			}
 			if (Startp[i] == Startp[i+1] && Startp[i] == Startp[i+2]) {
				CompFlag = 1;
				break;
			}
			Length++;
		}
		if (Length) {
			Destp[RLCount++] = Length - 1;
			for (i=0; i<Length; i++)
				Destp[RLCount++] =  Srcp[RLOutBufCount++];
		}
                if (CompFlag) {
	 		Length = 3;
			for (i=3; i<128+2; i++){
     			if (RLOutBufCount + Length  >= SrcNum)	break;
				if (Srcp[RLOutBufCount] != Srcp[RLOutBufCount + Length])	break;
				Length++;
			}
			if (RLOutBufCount + Length >= SrcNum)	Length = SrcNum - RLOutBufCount;

			Destp[RLCount++] = 0x80 | (Length - 3);
			Destp[RLCount++] = Srcp[RLOutBufCount];
			RLOutBufCount += Length;
		}
	}
	while (RLCount & 0x3)	Destp[RLCount++] = 0;


	CompBufNo ^= 1;							// dk or f[^
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&Destp, RLCount, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite( &Destp,  RLCount, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &Destp, RLCount, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&Destp, RLCount, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();			// o̓t@CEI[v
					if (outFileType == 0)	RLWrite(   Destp);
					else					RLWriteBin(Destp);
					break;
	}
}

/*----------------------------------------------------------*/
/*			   	OXEC[Wo				*/
/*----------------------------------------------------------*/

void RLWriteBin(u8 *Destp)
{
    u32	outCountTmp = 0;

	if (noHeaderFlag)	outCountTmp = 4;

	while (outCountTmp < RLCount)
	 	_rtl_write(BinOutHandle, &Destp[outCountTmp++], 1);
}

void RLWrite(u8 *Destp)
{
    u32	outCountTmp = 0;
	int	i;

    typesHeaderWrite();

	fprintf(fpo, "const u8 %s[0x%x] = {\n", labelName, RLCount);

	if (noHeaderFlag)	outCountTmp = 4;
	else {
		for (i=0; i<4; i++)							 	// WJ
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		fprintf(fpo, "\n");
		fprintf(fpo, "\n");
	}

	while (outCountTmp < RLCount) {	 	  			// f[^
		for (i=0; i<16 && outCountTmp < RLCount; i++) {
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		}
		fprintf(fpo, "\n");
	}

    fprintf(fpo, "};\n");
}


/*----------------------------------------------------------*/
/*			   		LZk									*/
/*----------------------------------------------------------*/
void LZWrite(   u8 *Destp);
void LZWriteBin(u8 *Destp);
u32  LZoutBufCount,   LZCount;

void LZCompWrite(u8 **Srcpp, u32 SrcNum, u8 **Destpp)
{
	u8	*Srcp = *Srcpp, *Destp = *Destpp;
	u8	*Searchp = NULL, *Lastp = NULL, *Currentp = NULL;
	u8	LastLength;
	u16	LastOffset;
	u8	LZFlags, *LZFlagsp;
	u32	LZTmp;
    u32	i, ii, iii;

	strcat(labelName, "_LZ");
	if (!outFileCustomFlag)		strcat(outfileName, "_LZ");

	*(u32 *)Destp = SrcNum << 8 | 0x10;		// f[^Ewb_
    LZCount = 4;

	LZoutBufCount = 0;
	while (LZoutBufCount < SrcNum) {
		LZFlags = 0;
		LZFlagsp = &Destp[LZCount++];
		for (i=0; i<8; i++) {
			LZFlags <<= 1;
			LastOffset = 0;
			LastLength = 0;
			Currentp = &Srcp[LZoutBufCount];
			for (ii=lzSearchOffset; ii<=LZoutBufCount && ii<=4096 && LZoutBufCount < SrcNum; ii++) {
				Searchp = &Srcp[LZoutBufCount-ii];
				if (*Searchp == *Currentp) {
					for (iii=1; iii<=16+2; iii++)
						if (Searchp[iii] != Currentp[iii])	break;
					if (iii > 16+2)							iii = 18;
					if (LZoutBufCount + iii >= SrcNum)		iii = SrcNum - LZoutBufCount;
					if (iii >= 3 && iii > (u32 )LastLength) {
						Lastp = Searchp;
						LastOffset = ii;
						LastLength = iii;
						LZFlags |= 1;
					}
				}
			}
			if (LZoutBufCount < SrcNum)
				if ((LZFlags & 1) == 0)	Destp[LZCount++] = Srcp[LZoutBufCount++];
				else {					Destp[LZCount++] = (LastLength-3) << 4 | (LastOffset-1) >> 8;
										Destp[LZCount++] = (LastOffset-1) & 0xff;
										LZoutBufCount += LastLength;
				}
		}
		*LZFlagsp = LZFlags;
	}
	while (LZCount & 0x3)	Destp[LZCount++] = 0;


	CompBufNo ^= 1;							// dk or f[^
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&Destp, LZCount, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite(  &Destp, LZCount, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &Destp, LZCount, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&Destp, LZCount, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();			// o̓t@CEI[v
					if (outFileType == 0)		LZWrite(   Destp);
					else						LZWriteBin(Destp);
					break;
	}
}

/*----------------------------------------------------------*/
/*			   		LZC[Wo						*/
/*----------------------------------------------------------*/

void LZWriteBin(u8 *Destp)
{
    u32	outCountTmp = 0;

	if (noHeaderFlag)	outCountTmp = 4;

	while (outCountTmp < LZCount)
		_rtl_write(BinOutHandle, &Destp[outCountTmp++], 1);
}

void LZWrite(u8 *Destp)
{
    u32	outCountTmp = 0;
	int	i;

    typesHeaderWrite();

	fprintf(fpo, "const u8 %s[0x%x] = {\n", labelName, LZCount);

	if (noHeaderFlag)	outCountTmp = 4;
	else {
		for (i=0; i<4; i++)							 	// WJ
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		fprintf(fpo, "\n");
		fprintf(fpo, "\n");
	}

	while (outCountTmp < LZCount) {					// f[^
		for (i=0; i<16 && outCountTmp < LZCount; i++) {
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		}
		fprintf(fpo, "\n");
	}

    fprintf(fpo, "};\n");
}


/*----------------------------------------------------------*/
/*			   		nt}k							*/
/*----------------------------------------------------------*/
void MakeBinTree(u32 TableNo, u32 Bit, u32 CheckNodes);
void HuffWrite(   u8 *Destp);
void HuffWriteBin(u8 *Destp);
#define	HUFF_END_L	0x80
#define	HUFF_END_R	0x40
typedef	struct {
	u32	No;				// f[^m
	u32	Frequency;		// opx
	s16	ParentNo;		// em
	s16	ChildNo[2];		// qm
	u16	ParentNodes;	// em[h̐[
	u16	ChildNodesMax;	// qm[h̍ő[
	u32	BitColumn;		// rbg
	u8	Bit;			// rbgEf[^
} HuffData;
HuffData	HuffTable[512];
HuffData	HuffTableInitData = {0, 0, 0,{0, 0}, 0,0, 0, 0};
HuffData	HuffTableTmp;
u8			HuffTree[256][2];
s32			HuffCurrentNo, HuffNextNo, HuffOffset;
u32	HuffoutBufCount, HuffCount, HuffArrayInitNum;

void HuffCompWrite(u8 **Srcpp, u32 SrcNum, u8 **Destpp)
{
	u8	*Srcp = *Srcpp, *Destp = *Destpp;
	u32	CheckCount = 0, ArrayNum = 1 << huffBitSize;
	s32	MinIndex[2], MinFrequency[2], MaxFrequency = 0, MaxCount = 0, CountTmp;
	u16	ParentNoMax;
	u16 ChildNoTmp;
	u16	ChildNodesMaxTmp;
	u8	ChildNodeFlag;
	u8	SrcTmp, DestTmp;
	u32 BitColumnTmp = 0;
	int	BitCount = 0;
	u32	i, ii, iii, Lastii;

	strcat( labelName, "_Huff");
	if (!outFileCustomFlag)		strcat(outfileName, "_Huff");

	HuffArrayInitNum = 1 << huffBitSize;
	for (i=0; i<HuffArrayInitNum*2; i++) {	// e[u
		HuffTable[i]    = HuffTableInitData;
		HuffTable[i].No = i;
	}

	for (i=0; i<HuffArrayInitNum; i++)		// opx`FbN
		for (ii=0; ii<SrcNum; ii++)
			for (iii=0; iii<8/huffBitSize; iii++)
				if (i == (((u32 )Srcp[ii] >> iii*4) & (0xff >> 4*(1 - huffBitSize/8))))
					HuffTable[i].Frequency++;

#if 0
	for (i=0; i<HuffArrayInitNum-1; i++)	// opx \[g
		for (ii=i+1; ii<HuffArrayInitNum; ii++)
			if (HuffTable[ii].Frequency > HuffTable[i].Frequency) {
				HuffTableTmp = HuffTable[i];
				HuffTable[i] = HuffTable[ii];
				HuffTable[ii] = HuffTableTmp;
			}
	ArrayNum = 0;
	while (HuffTable[ArrayNum].Frequency != 0)	// of[^ JEg
		ArrayNum++;
	for (i=0; i<HuffArrayInitNum; i++) 		// ǉm[hm
		HuffTable[ArrayNum+i].No = HuffArrayInitNum+i;
#endif
	for (i=0; i<ArrayNum; i++)				// of[^ qm[h
		for (ii=0; ii<2; ii++)
			HuffTable[i].ChildNo[ii] = -1;

	while (CheckCount < ArrayNum - 1) {	   	// c[e[u
		for (i=0; i<2; i++, CheckCount++) {
			for (ii=0, MinFrequency[i]=0x0fffffff; ii<ArrayNum; ii++)
				if (HuffTable[ii].Frequency < MinFrequency[i] && !HuffTable[ii].ParentNo) {
					MinIndex[i] = ii;
					MinFrequency[i] = HuffTable[ii].Frequency;
					HuffTable[ArrayNum].ChildNo[i] = ii;
				}
			HuffTable[MinIndex[i]].ParentNo = ArrayNum;
			if (HuffTable[ArrayNum].ChildNodesMax < HuffTable[MinIndex[i]].ChildNodesMax)
				HuffTable[ArrayNum].ChildNodesMax = HuffTable[MinIndex[i]].ChildNodesMax;
		}
#if 0
		if (HuffTable[MinIndex[0]].ChildNodesMax > HuffTable[MinIndex[1]].ChildNodesMax) {
#else
		if (MinFrequency[1] > MinFrequency[0]) {
#endif
									ChildNoTmp = HuffTable[ArrayNum].ChildNo[0];
				HuffTable[ArrayNum].ChildNo[0] = HuffTable[ArrayNum].ChildNo[1];
				HuffTable[ArrayNum].ChildNo[1] = ChildNoTmp;
		}
		for (i=0; i<2; i++)
			HuffTable[HuffTable[ArrayNum].ChildNo[i]].Bit = i;
		HuffTable[ArrayNum].Frequency = MinFrequency[0] + MinFrequency[1];
		HuffTable[ArrayNum].ChildNodesMax++;
		ArrayNum++;
	}

	for (i=0; i<ArrayNum-1; i++) {	  		// em[h̐[^rbg񐶐
		HuffTable[i].ParentNodes = 0;
		ii = i;
		while (HuffTable[ii].ParentNo) {
			HuffTable[i].BitColumn >>= 1;
			HuffTable[i].BitColumn |= HuffTable[ii].Bit << 31;
			HuffTable[i].ParentNodes++;
			ii = HuffTable[ii].ParentNo;
		}
	}

	HuffCurrentNo = 0; 					  	// oCic[
	HuffNextNo = 1;
	for (i=0; i<=HuffTable[ArrayNum-1].ChildNodesMax; i++)
		MakeBinTree(ArrayNum-1, 1, i);
	if (HuffCurrentNo & 0x1)  HuffCurrentNo++;
	HuffTree[0][0] = HuffCurrentNo - 1;


	*(u32 *)Destp = SrcNum << 8 | 0x20 | huffBitSize; // f[^Ewb_
    HuffCount = 4;

	for (i=0; i<HuffCurrentNo*2; i++)		// c[e[u
		Destp[HuffCount++] = ((u8 *)HuffTree)[i];

	for (i=0; i<SrcNum; i++)				// f[^k
		for (ii=0; ii<8/huffBitSize; ii++) {
				SrcTmp = (Srcp[i] >> ii*4) & (0xff >> 4*(1 - huffBitSize/8));
    			BitColumnTmp |= HuffTable[SrcTmp].BitColumn >> BitCount;
			BitCount     += HuffTable[SrcTmp].ParentNodes;
			for (iii=0; iii<BitCount/8; iii++) {
				Destp[HuffCount++] = (u8 )(BitColumnTmp >> 24);
				BitColumnTmp <<= 8;
			}
			BitCount %= 8;
		}
	if (BitCount != 0)		Destp[HuffCount++] = (u8 )(BitColumnTmp >> 24);
	while (HuffCount & 0x3)	Destp[HuffCount++] = 0;

	for (i=1+HuffCurrentNo*2/4; i<HuffCount/4; i++)	{		// gGfBAϊ
		Swap(u8, Destp[i*4+0], Destp[i*4+3]);
		Swap(u8, Destp[i*4+1], Destp[i*4+2]);
	}

	CompBufNo ^= 1;							// dk or f[^
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&Destp, HuffCount, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite(  &Destp, HuffCount, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &Destp, HuffCount, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&Destp, HuffCount, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();			// o̓t@CEI[v
					if (outFileType == 0)	HuffWrite(   Destp);
					else					HuffWriteBin(Destp);
					break;
	}
}

/*----------------------------------------------------------*/
/*			   		oCic[						*/
/*----------------------------------------------------------*/

void MakeBinTree(u32 TableNo, u32 Bit, u32 CheckNodes)
{
	int	i;

	if (HuffTable[TableNo].Frequency == 0 && Bit == 0)	return;

	if (HuffTable[TableNo].ParentNodes < CheckNodes) {
		for (i=0; i<2; i++)
			if (HuffTable[TableNo].ChildNo[i] != -1)
				MakeBinTree(HuffTable[TableNo].ChildNo[i], i, CheckNodes);
	} else {
		if (HuffTable[TableNo].No < HuffArrayInitNum)	// f[^
			HuffTree[HuffCurrentNo][Bit] = HuffTable[TableNo].No;
		else {
			for (i=0; i<2; i++)							// m[h
				if (HuffTable[HuffTable[TableNo].ChildNo[i]].No >= 0
				 && HuffTable[HuffTable[TableNo].ChildNo[i]].No < HuffArrayInitNum)
					HuffTree[HuffCurrentNo][Bit] |= HUFF_END_L >> i;
			HuffOffset = HuffNextNo - HuffCurrentNo - 1;
			if (HuffOffset >= 0x40) {				// ItZbgG[
		        fprintf(stderr, "Can't make a TreeTable from %s.\n", infileName);
				infileClose(fpi);				 	// ̓t@CEN[Y
		 		exit(1);
			}
			HuffTree[HuffCurrentNo][Bit] |= HuffOffset;
			HuffNextNo++;;
		}
		if (Bit == 1)	HuffCurrentNo++;
	}
}

/*----------------------------------------------------------*/
/*			  	nt}EC[Wo					*/
/*----------------------------------------------------------*/

void HuffWriteBin(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i, ii;

	if (noHeaderFlag)	outCountTmp = 4;

	while (outCountTmp < HuffCount)
		_rtl_write(BinOutHandle, &Destp[outCountTmp++], 1);
}

void HuffWrite(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i, ii;

    typesHeaderWrite();

	fprintf(fpo, "const u8 %s[0x%x] = {\n", labelName, HuffCount);

	if (noHeaderFlag)	outCountTmp = 4;
	else {
		for (i=0; i<4; i++)							   	// WJ
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		fprintf(fpo, "\n");
	}

	for (i=0; i<(HuffCurrentNo*2+15)/16; i++) {	 	// c[e[u
		for (ii=0; ii<16 && outCountTmp < HuffCurrentNo*2 + 4; ii++)
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		fprintf(fpo, "\n");
	}
	fprintf(fpo, "\n");

	while (outCountTmp < HuffCount) {			   	// f[^
		for (i=0; i<16 && outCountTmp < HuffCount; i++) {
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		}
		fprintf(fpo, "\n");
	}

    fprintf(fpo, "};\n");
}


/*==========================================================*/
/*                                                          */
/*                  ̓t@CEN[Y                  */
/*                                                          */
/*==========================================================*/

void infileClose(FILE *fpi)
{
    if (fclose(fpi) == EOF) {
        fprintf(stderr, "Can't close: %s\n", infileName);
        exit(1);
    }
}


/*==========================================================*/
/*                                                          */
/*                  o̓t@CEN[Y                  */
/*                                                          */
/*==========================================================*/

void outfileClose(void)
{
	if (outFileType == OUT_FILE_C) {
	    if (fclose(fpo) == EOF) {
			fprintf(stderr, "Can't close: %s\n", outfileName);
			exit(1);
		}
	} else {
		if (close(BinOutHandle) == -1) {
			fprintf(stderr, "Can't close: %s\n", outfileName);
			exit(1);
		}
	}
}


//---------------------------------------------------------------------------



