//---------------------------------------------------------------------------
#include <vcl\condefs.h>
#include <fcntl.h>
#include <io.h>
#include <sys\stat.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "Bmp2Agb.h"

#pragma hdrstop
//---------------------------------------------------------------------------

void usage(void);

/*-------------------- O[oϐ ----------------------*/

FILE    *fpi, *fpo;			/* t@CE|C^ */
char    labelName[512];		/* C[Wz */
char    paletteName[512];	/* pbgz */
char    infileName[512];	/* ̓t@C */
char    outfileName[512];	/* o̓t@C */
int		outType = 0;
int		outFileType = 0;
int		outFileCustomFlag = 0;
int		indexFlipFlag = 0;
int		paletteWriteFlag = 1;
int		smallDotID = 1;
int		shortSymbol = 0;
int		rawHeaderFlag;
int		lzSearchOffset = 1;
int		huffBitSize = 8;
int		diffBitSize = 8;
u8		*CompBufp[2];
s32		 CompBufNo = 1;
char	 CompTypeBuf[256];
char	*CompTypeBufp;

u32	inPaletteNum;			/* ̓C[WEpbg */
u16	inIndexSize = 0;   		/* ̓C[WECfbNXETCY */
u16	inIndexSizeB = 0;  		/* ̓C[WECfbNXEoCgTCY */
s32	inImageOffset;			/* ̓C[WEItZbg */
u32	inHSize, inVSize;  		/* ̓C[WETCY */


u32	outDotSize = 0;			/* o̓hbgETCY */
u32	outDotSizeB = 0;   		/* o̓hbgEoCgTCY */
u32	outHSize, outVSize;		/* o̓C[WETCY */
u8	outIndexOffset = 0;   	/* o̓C[WECfbNXEItZbg */
u32	outBitSize;				/* o͔zrbg */

/************************************************************/
/*                                                          */
/*                    CE[`                      */
/*                                                          */
/*             (:  A[Mg        )            */
/*             (       A[MgE|C^)            */
/*                                                          */
/************************************************************/
void argCheck(int argc, char *argv[]);
void infileOpen(int argc, char *argv[]);
void outfileOpen(void);
void headerWrite(void);
void paletteReadWrite(void);
void imageReadWrite(FILE *fpi);
void infileClose(FILE *fpi);
void outfileClose(void);

main (int argc, char *argv[])
{
	argCheck(argc, argv);		/* A[Mg */

	infileOpen(argc, argv);		/* ̓t@CEI[v */

	imageReadWrite(fpi);		/* C[W̓Ǎ݂Ə */

	outfileClose();				/* o̓t@CEN[Y */
	infileClose(fpi);

	return 0;
}


/*==========================================================*/
/*                                                          */
/*                      to                      */
/*                                                          */
/*==========================================================*/

void usage(void)
{
#ifdef IRIS
	fprintf(stderr, "Usage:	bmp2iris");
#else
	fprintf(stderr, "Usage:	Bmp2Agb");
#endif
	fprintf(stderr, " [-bi] [-bm|c] [-f] [-h] [-d 8|16] [-r] [-l search] [-h 4|8] [-np] [-s] [-o offset] [-O outputFile] inputFile.bmp\n");
	fprintf(stderr, "       -bi             Binary    file   output.\n");
	fprintf(stderr, "       -bm             Bitmap    format output.\n");
	fprintf(stderr, "       -c              Character format output (Default).\n");
	fprintf(stderr, "       -f              Flip.\n");
	fprintf(stderr, "       -h              Raw data header.\n");
	fprintf(stderr, "       -d bitSize      Differential filter.\n");
	fprintf(stderr, "       -r              Runlength encode.\n");
	fprintf(stderr, "       -l search       LZ77      encode.\n");
	fprintf(stderr, "       -h bitSize      Huffman   encode.\n");
	fprintf(stderr, "       -np             No palette.\n");
	fprintf(stderr, "       -s              Short symbol deleted path.\n");
	fprintf(stderr, "       -o offset       Image shifted by offset.\n");
	fprintf(stderr, "       -O outputFile   Change of output file.\n");
	exit(1);
}


/*==========================================================*/
/*                                                          */
/*                    A[Mg                    */
/*                                                          */
/*==========================================================*/
int optionCheck(int argc, char *argv[]);
int	stepArgvNum;

void argCheck(int argc, char *argv[])
{
    stepArgvNum = optionCheck(argc, argv);
    if (argc-stepArgvNum < 2)	usage();		/* A[Mg`FbN */
}

/*----------------------------------------------------------*/
/*                IvVE`FbN						*/
/*----------------------------------------------------------*/
#define OUT_CHR	0
#define OUT_BMP	1

#define OUT_FILE_C		0
#define OUT_FILE_BIN	1
int	argvTmp;

int optionCheck(int argc, char *argv[])
{
	char	*optionp;
	int		stepArgvNum = 0;

	while (--argc > 1)
		if (**(++argv) == '-') {
			optionp = *argv;
			stepArgvNum++;
			while (*(++optionp))
				switch (*optionp) {
					case '2':	smallDotID = 2;			break;
					case 'c':	outType = OUT_CHR;		break;
					case 'b':	if (!strncmp(optionp, "bm", 2))	outType = OUT_BMP;
								if (!strncmp(optionp, "bi", 2))	outFileType = OUT_FILE_BIN;
								break;
					case 's':	shortSymbol = 1;		break;
					case 'f':	indexFlipFlag = 1;		break;
					case 'n':	paletteWriteFlag = 0;	break;
					case 'r':	strcat(CompTypeBuf, "r");
								break;                    
					case 'd':	strcat(CompTypeBuf, "d");
 								diffBitSize = atoi(*(++argv));
								if (diffBitSize != 8 && diffBitSize != 16) {
									diffBitSize = 8;
									argv--;
								} else {
									stepArgvNum++;
	        						argc--;
								}
								break;
					case 'h':	argvTmp = atoi(*(++argv));
								if (argvTmp != 4 && argvTmp != 8) {
									rawHeaderFlag = 1;
									argv--;
								} else {
									strcat(CompTypeBuf, "h");
									huffBitSize = argvTmp;
									stepArgvNum++;
	        						argc--;
								}
								break;
					case 'l':	strcat(CompTypeBuf, "l");
								if ((lzSearchOffset = atoi(*(++argv))) == 0) {
									lzSearchOffset = 1;
									argv--;
								} else {
									stepArgvNum++;
	        						argc--;
								}
								break;
					case 'o':
								if (!strncmp(optionp, "o3", 2)) {
									outBitSize = 32;
								}
								outIndexOffset = atoi(*(++argv));
								stepArgvNum++;
        						argc--;
								break;
					case 'O':
								strcpy(outfileName, *(++argv));
								outFileCustomFlag = 1;
								stepArgvNum++;
        						argc--;
								break;
				}
		} else
			usage();

	return stepArgvNum;
}


/*==========================================================*/
/*                  ̓t@CEI[v                  */
/*==========================================================*/
void infileOverWriteCheck(void);
void argv2labelName(char *argv[]);
void infileParamsRead(void);

void infileOpen(int argc, char *argv[])
{
	char *fileNamep = argv[1+stepArgvNum];

	strcpy(infileName, argv[1+stepArgvNum]);

    if (((char *)strrchr(infileName, '.')) == NULL)	// ̓t@C gq`FbN
		usage();

    if ((fpi = fopen(fileNamep, "rb")) == NULL) {	// ̓t@C I[v
        fprintf(stderr, "Can't open: %s (No such file or directory)\n", fileNamep);
        exit(1);
    }

	infileOverWriteCheck();		// ̓t@C ㏑`FbN

    argv2labelName(argv);

	infileParamsRead();			// ̓t@C p[^Ǎ
}


/*----------------------------------------------------------*/
/*                    xϊ		                    */
/*----------------------------------------------------------*/

void argv2labelName(char *argv[])
{
    char	*periodp;

	if (!outFileCustomFlag)
		strcpy(outfileName, infileName);			// ԏo̓t@C 

	strcpy(labelName, outfileName);					// ԃx 
    if ((periodp = strrchr(labelName, '.')) != NULL)
       *periodp = '\0';

	if (!outFileCustomFlag)
		strcpy(outfileName, labelName);				// ԏo̓t@C 

    if (shortSymbol) {								// ԃx pX폜
        if ((periodp = strrchr(labelName, '/')) != NULL)
	        strcpy(labelName, ++periodp);
        if ((periodp = strrchr(labelName, '\\')) != NULL)
	        strcpy(labelName, ++periodp);
    }

	strcpy(paletteName, labelName);
}


/*----------------------------------------------------------*/
/*               ̓t@Cp[^Ǎ               */
/*----------------------------------------------------------*/
void infileCheck(FILE *fpi);
void bmpParamRead(FILE *fp, s32 offset, int whence, void *ptr, size_t size);

void infileParamsRead(void)
{
    infileCheck(fpi);			/* ̓t@C^CvE`FbN */

								/* ̓t@Cp[^Ǎ */
    bmpParamRead(fpi, 0xa,  SEEK_SET, &inImageOffset,sizeof(inImageOffset));
    bmpParamRead(fpi, 0x12, SEEK_SET, &inHSize,		sizeof(inHSize));
    bmpParamRead(fpi, 0x16, SEEK_SET, &inVSize,		sizeof(inVSize));
    bmpParamRead(fpi, 0x1c, SEEK_SET, &inIndexSize,	sizeof(inIndexSize));
//    bmpParamRead(fpi, 0x32, SEEK_SET, &inPaletteNum,	sizeof(inPaletteNum));
	inPaletteNum = 1 << inIndexSize;
    inIndexSizeB = (u32)ceil((double)inIndexSize/8);

    printf("%d Palettes, %dx%d Image  ->  ",		 inPaletteNum, inHSize, inVSize);
	switch (inIndexSize) {
		case 1:
		case 4:
//				 	printf("Palettes & Characters\n");	break;
		case 8:     if (outType == OUT_CHR) 	printf("Palettes & Characters\n");
					else					 	printf("Palettes & Index Bitmap Screen\n");
					break;
		case 24:	printf("Raw Bitmap Screen\n");	break;
	}
}

/*----------------------------------------------------------*/
/*               ̓t@C^CvE`FbN               */
/*----------------------------------------------------------*/

void infileCheck(FILE *fpi)
{
    char	fileType[3];

    fseek(fpi, 0x0, SEEK_SET);
    fread(fileType, 1, 2, fpi);
    fileType[2] = '\0';
    if (strncmp(fileType, "BM", 2)) {
        fprintf(stderr, "InputFile isn't BMP file\n");
        exit(1);
    }
}

/*----------------------------------------------------------*/
/*               ̓t@C㏑`FbN                 */
/*----------------------------------------------------------*/

void infileOverWriteCheck(void)
{
    if (!strcmp(outfileName, infileName)) {
        fprintf(stderr, "OutputFile equal InputFile: %s\n", outfileName);
        exit(1);
    }
}

/*----------------------------------------------------------*/
/*               ̓t@Cp[^Ǎ               */
/*----------------------------------------------------------*/

void bmpParamRead(FILE *fp, s32 offset, int whence, void *ptr, size_t size)
{
    fseek(fp, offset, whence);
    fread(ptr, 1, size, fp);
}


/*==========================================================*/
/*                                                          */
/*                  o̓t@CEI[v                  */
/*                                                          */
/*==========================================================*/
void argv2outfileName(void);
int		BinOutHandle;

void outfileOpen(void)
{
    argv2outfileName();

	if (!strcmp(outfileName, infileName)) {
	        fprintf(stderr, "OutputFile equal InputFile: %s\n", outfileName);
			outfileClose();				/* o̓t@CEN[Y */
			infileClose(fpi);	 		/* ̓t@CEN[Y */
	 		exit(1);
    }

	if (outFileType == OUT_FILE_C) {
	    if ((fpo = fopen(outfileName, "w+")) == NULL) {
	        fprintf(stderr, "Can't open: %s\n", outfileName);
	        exit(1);
	    }
	} else {
		if ((BinOutHandle = open(outfileName, O_CREAT|O_WRONLY|O_BINARY|O_TRUNC,
    										   S_IWRITE)) == -1) {

	        fprintf(stderr, "Can't open: %s\n", outfileName);
	        exit(1);
	    }
	}
}


/*----------------------------------------------------------*/
/*                    o̓t@Cϊ                    */
/*----------------------------------------------------------*/

void argv2outfileName(void)
{
	if (!outFileCustomFlag)
		if (outFileType == OUT_FILE_C)
    						strcat(outfileName, ".c");
		else			    strcat(outfileName, ".bin");
}


/*==========================================================*/
/*                                                          */
/*                       malloc `FbN                    */
/*                                                          */
/*==========================================================*/

void mallocCheck(void)
{
    if (CompBufp[0] == NULL || CompBufp[1] == NULL) {
        fprintf(stderr, "Error:	Memory is not enough.\n");
        exit(1);
    }
}


/*==========================================================*/
/*                                                          */
/*                       wb_                       */
/*                                                          */
/*==========================================================*/

void headerWrite(void)
{
	if (outFileType != OUT_FILE_C)	return;

#ifdef IRIS
    fprintf(fpo, "#include <IrisTypes.h>\n");
#else
    fprintf(fpo, "#include <AgbTypes.h>\n");
#endif
    fprintf(fpo, "\n\n");
}


/*==========================================================*/
/*                                                          */
/*                 pbg̓Ǎ݂Ə                 */
/*                                                          */
/*==========================================================*/
void bmp24bto16b(FILE *fpi);
void paletteWrite(void);
u16  plttBuf[256];

void paletteReadWrite(void)
{
    if (inIndexSize == 24)        return;

	if (paletteWriteFlag) {
		fseek(fpi, 0x36, SEEK_SET);
		bmp24bto16b(fpi);

		paletteWrite();
	}
}


/*----------------------------------------------------------*/
/*              24bit16bitւ̃pbgϊ              */
/*----------------------------------------------------------*/

void bmp24bto16b(FILE *fpi)
{
	int			plttBufCount = outIndexOffset;
    AgbPlttData	AgbPltt = {0, 0, 0};		/* pbg */
    u8			Red8, Green8, Blue8, Alpha8;
    int			i, ii;

	for (i = 0; i < inPaletteNum/8; i++) {
		for (ii = 0; ii < 8; ii++) {
			fread(&Blue8,  1, 1, fpi);
			fread(&Green8, 1, 1, fpi);
			fread(&Red8,   1, 1, fpi);
			fread(&Alpha8, 1, 1, fpi);
			AgbPltt.Red5   = Red8 	>> 3;
			AgbPltt.Green5 = Green8 >> 3;
			AgbPltt.Blue5  = Blue8 	>> 3;

			plttBuf[plttBufCount++] = *(u16 *)&AgbPltt;

			if (plttBufCount == inPaletteNum)	plttBufCount = 0;
		}
	}
}


/*----------------------------------------------------------*/
/*                      pbg                      */
/*----------------------------------------------------------*/

void paletteWrite(void)
{
	int  outCountTmp = 0;
	int  i, ii;

	if (outFileType == OUT_FILE_BIN) {
		for (i = 0; i < inPaletteNum; i++)	_rtl_write(BinOutHandle, &plttBuf[i], 2);

	} else {
		if (outBitSize != 32) {
			fprintf(fpo, "const u16 %s_Palette[%d] = {\n", paletteName, inPaletteNum);

			for (i = 0; i < inPaletteNum/8; i++) {
				for (ii = 0; ii < 8; ii++)
					fprintf(fpo, "0x%04x,", plttBuf[outCountTmp++]);
				fprintf(fpo, "\n");
			}
		    fprintf(fpo, "};\n");
		    fprintf(fpo, "\n\n");

		} else {
			u32  *pltt32Bufp = (u32 *)plttBuf;

			fprintf(fpo, "const u32 %s_Palette[%d/2] = {\n", paletteName, inPaletteNum);

			for (i = 0; i < inPaletteNum/8; i++) {
				for (ii = 0; ii < 8/2; ii++)
					fprintf(fpo, "0x%08x,", pltt32Bufp[outCountTmp++]);
				fprintf(fpo, "\n");
			}

		    fprintf(fpo, "};\n");
		    fprintf(fpo, "\n\n");
		}
	}
}


/*==========================================================*/
/*                                                          */
/*                 C[W̓Ǎ݂Ə                 */
/*                                                          */
/*==========================================================*/
void outSize(void);
void IndexImage2Char(FILE *fpi);
void IndexImage2Screen(FILE *fpi);
void RGBImage2RawScreen(FILE *fpi);

void imageReadWrite(FILE *fpi)
{
    outSize();

	switch (inIndexSize) {
		case 1:
		case 4:
//			   	IndexImage2Char(fpi);
// 					break;
		case 8:		if (outType == OUT_CHR) 	IndexImage2Char(fpi);
					else						IndexImage2Screen(fpi);
					break;
		case 24:   	RGBImage2RawScreen(fpi);
 					break;
	}
}

/*----------------------------------------------------------*/
/*                  zTCY̎Zo		                */
/*----------------------------------------------------------*/

void outSize(void)
{
    outVSize = inVSize;

    if (inIndexSize == 1)		outHSize = inHSize/8;
    else if (inIndexSize == 4)	outHSize = inHSize/2;
    else						outHSize = inHSize;
}

/*----------------------------------------------------------*/
/*			   		C[WLN^֕ϊ				*/
/*----------------------------------------------------------*/
u8   outData2SmallDot(u8 outData);
void RawCharWrite(   u8 **Srcpp, u32 SrcNum);
void RawCharWriteBin(u8 **Srcpp, u32 SrcNum);
void RLCompWrite(    u8 **Srcpp, u32 SrcNum, u8 **Destpp);
void LZCompWrite(    u8 **Srcpp, u32 SrcNum, u8 **Destpp);
void HuffCompWrite(  u8 **Srcpp, u32 SrcNum, u8 **Destpp);
void DiffFiltWrite(  u8 **Srcpp, u32 SrcNum, u8 **Destpp);
u8	*outBufp;
s32  outCount;

void IndexImage2Char(FILE *fpi)
{
    int	outDotLine;
    u8	outData, outDataTmp;
	int	VCount = 0, VCountBak;
	int	HCount = 0, HCountBak;
	s64	SeekCount;
    int	i, ii;

	strcat(labelName,   "_Char");
	if (rawHeaderFlag)	strcat(labelName, "_Head");

	(void *)CompBufp[0] = malloc(inHSize*inVSize*inIndexSize/smallDotID/8*2 + 4 + 256*2);
	(void *)CompBufp[1] = malloc(inHSize*inVSize*inIndexSize/smallDotID/8*2 + 4 + 256*2);
	(void *)outBufp     = CompBufp[0];

	mallocCheck();										// malloc `FbN

	if (rawHeaderFlag)	outCount = 4;

	while (VCount < outVSize) {
		VCountBak = VCount;
       	for (i = 0; i < 8; i++) {
			if (VCount >= outVSize)		break;
 			HCountBak = HCount;
			SeekCount = inImageOffset + (outVSize-VCount-1)*outHSize + HCount;
//			SeekCount = inImageOffset + (outVSize-VCount-1)*(outHSize/4+1)*4 + HCount;
	        fseek(fpi, SeekCount, SEEK_SET);
   	        for (ii = 0; ii < 8/(8/inIndexSize)/smallDotID; ii++) {
				if (HCount >= outHSize)		break;
//         	    outDotNo = outHSize*VCount+HCount+ii;
				fread(&outData,  1, 1, fpi);					// f[^ǂݍ
				if (inIndexSize == 1)
                	outData = (outData & 0x80) >> 7 | (outData & 0x40) >> 5
							| (outData & 0x20) >> 3 | (outData & 0x10) >> 1
							| (outData & 0x08) << 1 | (outData & 0x04) << 3
							| (outData & 0x02) << 5 | (outData & 0x01) << 7;
				else
                if (inIndexSize == 4)
                	outData = (outData >> 4) | (outData << 4);
				if (indexFlipFlag)	outData ^= 0xff;
				if (inIndexSize == 1) {
					if (outIndexOffset)		outData ^= 0xff;
				} else if (inIndexSize == 4) {
					outData = (((outData >> 4)  + outIndexOffset) << 4
							|  ((outData & 0x0f)+ outIndexOffset) & 0x0f) & 0xff;
					if (smallDotID == 2) {
						outDataTmp  = outData2SmallDot(outData >> 4) << 2;
						outDataTmp |= outData2SmallDot(outData & 0x0f);
						outData = outDataTmp;
						HCount++;

						fread(&outData,  1, 1, fpi);		   	// f[^ǂݍ
		                outData = (outData >> 4) | (outData << 4);
						if (indexFlipFlag)	outData ^= 0xff;
						outData = (((outData >> 4)  + outIndexOffset) << 4
								|  ((outData & 0x0f)+ outIndexOffset) & 0x0f) & 0xff;
						outDataTmp |= outData2SmallDot(outData >> 4) << (2+4);
						outDataTmp |= outData2SmallDot(outData & 0x0f) <<  4;
						outData = outDataTmp;
					}
				} else
					outData = (outData + outIndexOffset) & 0xff;
				outBufp[outCount++] = outData;
				HCount++;
            }
			HCount = HCountBak;
			VCount++;
        }
		if (HCount < outHSize) {
									VCount = VCountBak;
									HCount += 8/(8/inIndexSize);
		} else
									HCount = 0;
	}

	if (rawHeaderFlag)	*(u32 *)outBufp = outCount << 8			// wb_
										| 0;
//										| 0 | inIndexSize/smallDotID;

	CompTypeBufp = CompTypeBuf;
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&outBufp, outCount, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite(  &outBufp, outCount, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &outBufp, outCount, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&outBufp, outCount, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();			// o̓t@CEI[v
					headerWrite();		 	// wb_
					paletteReadWrite();		// pbg̓Ǎ݂Ə
					if (outFileType == 0)
							RawCharWrite(    &outBufp, outCount);
					else	RawCharWriteBin( &outBufp, outCount);
					break;
	}

	free(CompBufp[1]);
	free(CompBufp[0]);
}

/*----------------------------------------------------------*/
/*			   		4bitf[^2bitf[^֕ϊ			*/
/*----------------------------------------------------------*/

u8 outData2SmallDot(u8 outData)
{
	u8	outDataTmp = (outData - outIndexOffset) & 0x0f;

    	 if (outDataTmp >= 0  && outDataTmp <= 2 )	return 1;
	else if (outDataTmp >= 3  && outDataTmp <= 7 )	return 2;
	else if (outDataTmp >= 8  && outDataTmp <= 12)	return 3;
	else if (outDataTmp >= 13 && outDataTmp <= 15)	return 0;
}

/*----------------------------------------------------------*/
/*			  	[ELN^EC[Wo			*/
/*----------------------------------------------------------*/

void RawCharWriteBin(u8 **Srcpp, u32 SrcNum)
{
	u8	*Srcp = *Srcpp;
    int	outCountTmp = 0;
	int	i;

	if (rawHeaderFlag) {
//		*(u32 *)Srcp = 0;
		for (i=0; i<4; i++)								 	// wb_
			_rtl_write(BinOutHandle, &Srcp[outCountTmp++], 1);
	}

	while (outCountTmp < outCount)							 // f[^
			_rtl_write(BinOutHandle, &Srcp[outCountTmp++], 1);
}

void RawCharWrite(u8 **Srcpp, u32 SrcNum)
{
	u8	*Srcp = *Srcpp;
	u32	*Src32p = (u32 *)*Srcpp;
    int	outCountTmp = 0;
    int	CharCount = 0;
	int	VCount = 0, VCountBak;
	int	HCount = 0, HCountBak;
	int	i, ii;

if (outBitSize != 32) {
	fprintf(fpo, "const u%d %s[%d*%d/8*%d/8 + %d] = {\n",
		inIndexSizeB*8, labelName,	8*8*inIndexSize/8/smallDotID, inHSize,inVSize, rawHeaderFlag*4);
//	fprintf(fpo, "const u%d %s[8*8*(%d/8/%d/%d)*(%d/8) + %d] = {\n",
//		inIndexSizeB*8, labelName,	inHSize, 8/inIndexSize, smallDotID, inVSize, rawHeaderFlag*4);

	if (rawHeaderFlag) {
		for (i=0; i<4; i++)									 	// wb_
				fprintf(fpo, "0x%02x,", Srcp[outCountTmp++]);
		fprintf(fpo, "\n");
		fprintf(fpo, "\n");
	}

	while (VCount < outVSize) {
		VCountBak = VCount;
       	for (i = 0; i < 8; i++) {
			if (VCount >= outVSize)		break;
 			HCountBak = HCount;
   	        for (ii = 0; ii < 8/(8/inIndexSize)/smallDotID; ii++) {
				if (HCount >= outHSize)		break;
				if (inIndexSize == 4 && smallDotID == 2)	HCount++;
				HCount++;
				fprintf(fpo, "0x%02x,", Srcp[outCountTmp++]);	// f[^
			}
			if (ii != 0) {
				if (i == 0){	fprintf(fpo, " // %d", CharCount++);
					if (HCount == 8/(8/inIndexSize)/smallDotID)	fprintf(fpo, "  %d", VCount/8);
				}
    	       	fprintf(fpo, "\n");
			}
			HCount = HCountBak;
			VCount++;
        }
		if (ii != 0)		fprintf(fpo, "\n");
		if (HCount < outHSize) {
									VCount = VCountBak;
									HCount += 8/(8/inIndexSize);
		} else
									HCount = 0;
	}

    fprintf(fpo, "};\n");

} else {

	fprintf(fpo, "const u32 %s[%d*%d/8*%d/8 + %d] = {\n",
		labelName,	8*8*inIndexSize/32/smallDotID, inHSize,inVSize, rawHeaderFlag*1);

	if (rawHeaderFlag) {									 	// wb_
		fprintf(fpo, "0x%08x,", Src32p[outCountTmp++]);
		fprintf(fpo, "\n");
		fprintf(fpo, "\n");
	}

	while (VCount < outVSize) {
		VCountBak = VCount;
       	for (i = 0; i < 8; i++) {
			if (VCount >= outVSize)		break;
 			HCountBak = HCount;
   	        for (ii = 0; ii < 8/(8/inIndexSize)/smallDotID; ii+=4) {
				if (HCount >= outHSize)		break;
				if (inIndexSize == 4 && smallDotID == 2)	HCount+=4;
				HCount+=4;
				fprintf(fpo, "0x%08x,", Src32p[outCountTmp++]);	// f[^
			}
			if (ii != 0) {
				if (i == 0){	fprintf(fpo, " // %d", CharCount++);
					if (HCount == 8/(8/inIndexSize)/smallDotID)	fprintf(fpo, "  %d", VCount/8);
				}
    	       	fprintf(fpo, "\n");
			}
			HCount = HCountBak;
			VCount++;
        }
		if (ii != 0)		fprintf(fpo, "\n");
		if (HCount < outHSize) {
									VCount = VCountBak;
									HCount += 8/(8/inIndexSize);
		} else
									HCount = 0;
	}

    fprintf(fpo, "};\n");
}
}



/*----------------------------------------------------------*/
/*			CfbNXEC[WXN[փRs[		*/
/*----------------------------------------------------------*/
void RawIndexScreenWrite(   u8 **Srcpp, u32 SrcNum);
void RawIndexScreenWriteBin(u8 **Srcpp, u32 SrcNum);

void IndexImage2Screen(FILE *fpi)
{
//  int	outDotNo;
    u8	outData, outDataTmp;
    int	i, ii, iii;

	strcat(labelName,   "_IndexBitmap");
	if (rawHeaderFlag)	strcat(labelName, "_Head");

	(void *)CompBufp[0] = malloc(inHSize*inVSize*inIndexSize/8*2 + 4 + 256*2);
	(void *)CompBufp[1] = malloc(inHSize*inVSize*inIndexSize/8*2 + 4 + 256*2);
	(void *)outBufp   = CompBufp[0];

	mallocCheck();										// malloc `FbN

	if (rawHeaderFlag)	outCount = 4;

    for (i = 0; i < outVSize; i++)  {
        fseek(fpi, inImageOffset, SEEK_SET);
        fseek(fpi, (outVSize-1-i)*outHSize, SEEK_CUR);
        for (ii = 0; ii < outHSize/8; ii++) {
            for (iii = 0; iii < 8; iii++) {
//              outDotNo = i*outHSize+ii*8+iii;
				fread(&outData,  1, 1, fpi);			   // f[^ǂݍ
                if (inIndexSize == 4)
                	outData = (outData >> 4) | (outData << 4);
				if (indexFlipFlag)	outData ^= 0xff;
				if (inIndexSize == 1) {
					if (outIndexOffset)		outData ^= 0xff;
				} else if (inIndexSize == 4) {
					outData = (((outData >> 4)  + outIndexOffset) << 4
							|  ((outData & 0x0f)+ outIndexOffset) & 0x0f) & 0xff;
					if (smallDotID == 2) {
						outDataTmp  = outData2SmallDot(outData >> 4) << 2;
						outDataTmp |= outData2SmallDot(outData & 0x0f);
						outData = outDataTmp;

						fread(&outData,  1, 1, fpi);		   	// f[^ǂݍ
		                outData = (outData >> 4) | (outData << 4);
						if (indexFlipFlag)	outData ^= 0xff;
						outData = (((outData >> 4)  + outIndexOffset) << 4
								|  ((outData & 0x0f)+ outIndexOffset) & 0x0f) & 0xff;
						outDataTmp |= outData2SmallDot(outData >> 4) << (2+4);
						outDataTmp |= outData2SmallDot(outData & 0x0f) <<  4;
						outData = outDataTmp;
					}
				} else
					outData = (outData + outIndexOffset) & 0xff;
				outBufp[outCount++] = outData;
            }
        }
    }

	if (rawHeaderFlag)	*(u32 *)outBufp = outCount << 8			// wb_
										| 0;
//										| 0 | inIndexSize;

	CompTypeBufp = CompTypeBuf;
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&outBufp, outCount, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite(  &outBufp, outCount, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &outBufp, outCount, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&outBufp, outCount, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();			// o̓t@CEI[v
					headerWrite();		 	// wb_
					paletteReadWrite();		// pbg̓Ǎ݂Ə
					if (outFileType == 0)
							RawIndexScreenWrite(    &outBufp, outCount);
					else	RawIndexScreenWriteBin( &outBufp, outCount);
					break;
	}

	free(CompBufp[1]);
	free(CompBufp[0]);
}

/*----------------------------------------------------------*/
/*				[ECfbNXEXN[o		*/
/*----------------------------------------------------------*/

void RawIndexScreenWriteBin(u8 **Srcppp, u32 SrcNump)
{
	u8	*Srcp = *Srcppp;
	int	outCountTmp = 0;
	int	i, ii, iii;

	if (rawHeaderFlag) {
//		*(u32 *)Srcp = 0;
		for (i=0; i<4; i++)						 	// wb_
			_rtl_write(BinOutHandle, &Srcp[outCountTmp++], 1);
	}

	while (outCountTmp < outCount)					 // f[^
			_rtl_write(BinOutHandle, &Srcp[outCountTmp++], 1);
}

void RawIndexScreenWrite(u8 **Srcppp, u32 SrcNump)
{
	u8	*Srcp = *Srcppp;
	int	outCountTmp = 0;
	int	i, ii, iii;

	fprintf(fpo, "const u%d %s[%d*%d + %d] =  {\n",
			inIndexSizeB*8, labelName,  inHSize*inIndexSize/8,inVSize, rawHeaderFlag*4);

	if (rawHeaderFlag) {
		for (i=0; i<4; i++)				   		 	// wb_
				fprintf(fpo, "0x%02x,", Srcp[outCountTmp++]);
		fprintf(fpo, "\n");
		fprintf(fpo, "\n");
	}

    for (i = 0; i < outVSize; i++)  {
        for (ii = 0; ii < outHSize/8; ii++) {
            for (iii = 0; iii < 8; iii++)			// f[^
				fprintf(fpo, "0x%02x,", Srcp[outCountTmp++]);
 			if (ii == 0)	fprintf(fpo, " // %d", i);
            fprintf(fpo, "\n");
        }
        fprintf(fpo, "\n");
    }
    fprintf(fpo, "};\n");
}


/*----------------------------------------------------------*/
/*                  16bitXN[֕ϊ                   */
/*----------------------------------------------------------*/
void RawRGBScreenWrite(   u16 **Srcpp, u32 SrcNump);
void RawRGBScreenWriteBin(u16 **Srcpp, u32 SrcNump);
u16	*outBuf16p;

void RGBImage2RawScreen(FILE *fpi)
{
    u8			Red8, Green8, Blue8;
//	int			outDotNo;
    AgbPlttData	outData;
    int			i, ii, iii;

	strcat(labelName,   "_RawBitmap");
	if (rawHeaderFlag)	strcat(labelName, "_Head");

	(void *)CompBufp[0] = malloc(inHSize*inVSize*inIndexSize/8*2 + 4 + 256*2);
	(void *)CompBufp[1] = malloc(inHSize*inVSize*inIndexSize/8*2 + 4 + 256*2);
	(void *)outBuf16p   = CompBufp[0];

	mallocCheck();										// malloc `FbN

	if (rawHeaderFlag)	outCount = 2;

    for (i = 0; i < outVSize; i++)  {
        fseek(fpi, inImageOffset, SEEK_SET);
        fseek(fpi, (outVSize-1-i)*inHSize*inIndexSizeB, SEEK_CUR);
        for (ii = 0; ii < outHSize/8; ii++) {
			for (iii = 0; iii < 8; iii++) {
//				outDotNo = i*outHSize+ii*8+iii;
				fread(&Blue8,  1, 1, fpi);
				fread(&Green8, 1, 1, fpi);
				fread(&Red8,   1, 1, fpi);
				outData.Red5   = Red8  >> 3;
				outData.Green5 = Green8 >> 3;
				outData.Blue5  = Blue8  >> 3;
				outData.Alpha1 = 1;
				outBuf16p[outCount++] = *(u16 *)&outData;
			}
        }
    }

	if (rawHeaderFlag)	*(u32 *)outBuf16p = outCount << 8 		// wb_
										  | 0;
//										  | 0 | inIndexSize;

	CompTypeBufp = CompTypeBuf;
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&(u8 *)outBuf16p, outCount*2, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite(  &(u8 *)outBuf16p, outCount*2, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &(u8 *)outBuf16p, outCount*2, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&(u8 *)outBuf16p, outCount*2, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();			// o̓t@CEI[v
					headerWrite();		 	// wb_
					paletteReadWrite();		// pbg̓Ǎ݂Ə
					if (outFileType == 0)
							RawRGBScreenWrite(     &outBuf16p, outCount);
					else	RawRGBScreenWriteBin(  &outBuf16p, outCount);
					break;
	}

	free(CompBufp[1]);
	free(CompBufp[0]);
}

/*----------------------------------------------------------*/
/*					[E16BitXN[o				*/
/*----------------------------------------------------------*/

void RawRGBScreenWriteBin(u16 **Srcpp, u32 SrcNump)
{
	u16	*Srcp = *Srcpp;
	int	outCountTmp = 0;
    int	i, ii, iii;

	if (rawHeaderFlag) {
//		*(u32 *)Srcp = 0;
		for (i=0; i<2; i++)					  	 	// wb_
			_rtl_write(BinOutHandle, &Srcp[outCountTmp++], 2);
	}

	while (outCountTmp < outCount)					 // f[^
			_rtl_write(BinOutHandle, &Srcp[outCountTmp++], 2);
}

void RawRGBScreenWrite(u16 **Srcpp, u32 SrcNump)
{
	u16	*Srcp = *Srcpp;
	int	outCountTmp = 0;
    int	i, ii, iii;

	fprintf(fpo, "const u16 %s[%d*%d + %d] =  {\n",
							labelName,  inHSize,inVSize, rawHeaderFlag*2);

	if (rawHeaderFlag) {
		for (i=0; i<2; i++)			  			 	// wb_
			fprintf(fpo, "0x%04x,", Srcp[outCountTmp++]);
		fprintf(fpo, "\n");
		fprintf(fpo, "\n");
	}

    for (i = 0; i < outVSize; i++)  {
        for (ii = 0; ii < outHSize/8; ii++) {
			for (iii = 0; iii < 8; iii++)			// f[^
				fprintf(fpo, "0x%04x,", Srcp[outCountTmp++]);
			if (ii == 0)	fprintf(fpo, " // %d", i);
            fprintf(fpo, "\n");
        }
        fprintf(fpo, "\n");
    }
    fprintf(fpo, "};\n");
}



/*----------------------------------------------------------*/
/*			   		tB^							*/
/*----------------------------------------------------------*/
void DiffWrite(   u8 *Destp);
void DiffWriteBin(u8 *Destp);
int	DiffOutBufCount,   DiffCount;

void DiffFiltWrite(u8 **Srcpp, u32 SrcNum, u8 **Destpp)
{
	u8	*Srcp   = (u8  *)*Srcpp, *Destp   = (u8  *)*Destpp;
	u16	*Src16p = (u16 *)*Srcpp, *Dest16p = (u16 *)*Destpp;
    int	i;

	strcat(labelName,   "_Diff");
	if (!outFileCustomFlag)		strcat(outfileName, "_Diff");

	*(u32 *)Destp = SrcNum << 8 | 0x80 | diffBitSize/8;	// f[^Ewb_
    DiffCount = 4;

	if (diffBitSize == 8) {
		Destp[DiffCount++] = Srcp[0];
		for (i=1; i<SrcNum; i++)
			Destp[DiffCount++] = Srcp[i] - Srcp[i-1];
	} else {
		Dest16p[DiffCount/2] = Src16p[0];
		DiffCount += 2;
		for (i=1; i<SrcNum/2; i++, DiffCount += 2)
			Dest16p[DiffCount/2] = Src16p[i] - Src16p[i-1];
	}
	while (DiffCount & 0x3)	Destp[DiffCount++] = 0;


	CompBufNo ^= 1;							// dk or f[^
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&Destp, DiffCount, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite(  &Destp, DiffCount, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &Destp, DiffCount, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&Destp, DiffCount, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();			// o̓t@CEI[v
					headerWrite();		 	// wb_
					paletteReadWrite();		// pbg̓Ǎ݂Ə
					if (outFileType == 0)	DiffWrite(   Destp);
					else					DiffWriteBin(Destp);
					break;
	}
}

/*----------------------------------------------------------*/
/*			   		C[Wo						*/
/*----------------------------------------------------------*/

void DiffWriteBin(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i;

	while (outCountTmp < DiffCount)
	 	_rtl_write(BinOutHandle, &Destp[outCountTmp++], 1);
}

void DiffWrite(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i;

	fprintf(fpo, "const u8 %s[0x%x] = {\n", labelName, DiffCount);

	for (i=0; i<4; i++)							 	// WJ
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
	fprintf(fpo, "\n");
	fprintf(fpo, "\n");

	while (outCountTmp < DiffCount) {	   			// f[^
		for (i=0; i<16 && outCountTmp < DiffCount; i++) {
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		}
		fprintf(fpo, "\n");
	}

    fprintf(fpo, "};\n");
}


/*----------------------------------------------------------*/
/*			   		OXk						*/
/*----------------------------------------------------------*/
void RLWrite(   u8 *Destp);
void RLWriteBin(u8 *Destp);
int	 RLOutBufCount,   RLCount;

void RLCompWrite(u8 **Srcpp, u32 SrcNum, u8 **Destpp)
{
	u8	*Srcp   = *Srcpp, *Destp   = *Destpp;
	u8	*Startp;
	u8	CompFlag;
	u32	Length;
    int	i;

	strcat(labelName,   "_RL");
	if (!outFileCustomFlag)		strcat(outfileName, "_RL");

	*(u32 *)Destp = SrcNum << 8 | 0x30;	// f[^Ewb_
    RLCount = 4;

	RLOutBufCount = 0;
	while (RLOutBufCount < SrcNum) {
		Startp = &Srcp[RLOutBufCount];
 		Length = 0;
		CompFlag = 0;
		for (i=0; i<128; i++) {
 			if (RLOutBufCount + Length + 2 >= SrcNum) {
				Length = SrcNum - RLOutBufCount;
				break;
			}
 			if (Startp[i] == Startp[i+1] && Startp[i] == Startp[i+2]) {
				CompFlag = 1;
				break;
			}
			Length++;
		}
		if (Length) {
			Destp[RLCount++] = Length - 1;
			for (i=0; i<Length; i++)
				Destp[RLCount++] =  Srcp[RLOutBufCount++];
		}
		if (CompFlag) {
	 		Length = 3;
			for (i=3; i<128+2; i++){
				if (Srcp[RLOutBufCount] != Srcp[RLOutBufCount + Length])	break;
				Length++;
			} 	
			if (RLOutBufCount + Length >= SrcNum)	Length = SrcNum - RLOutBufCount;

			Destp[RLCount++] = 0x80 | (Length - 3);
			Destp[RLCount++] = Srcp[RLOutBufCount];
			RLOutBufCount += Length;
		}
	}
	while (RLCount & 0x3)	Destp[RLCount++] = 0;


	CompBufNo ^= 1;							// dk or f[^
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&Destp, RLCount, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite( &Destp,  RLCount, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &Destp, RLCount, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&Destp, RLCount, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();			// o̓t@CEI[v
					headerWrite();		 	// wb_
					paletteReadWrite();		// pbg̓Ǎ݂Ə
					if (outFileType == 0)	RLWrite(   Destp);
					else					RLWriteBin(Destp);
					break;
	}
}

/*----------------------------------------------------------*/
/*			   	OXEC[Wo				*/
/*----------------------------------------------------------*/

void RLWriteBin(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i;

	while (outCountTmp < RLCount)
	 	_rtl_write(BinOutHandle, &Destp[outCountTmp++], 1);
}

void RLWrite(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i;

	fprintf(fpo, "const u8 %s[0x%x] = {\n", labelName, RLCount);

	for (i=0; i<4; i++)							 	// WJ
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
	fprintf(fpo, "\n");
	fprintf(fpo, "\n");

	while (outCountTmp < RLCount) {	 	  			// f[^
		for (i=0; i<16 && outCountTmp < RLCount; i++) {
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		}
		fprintf(fpo, "\n");
	}

    fprintf(fpo, "};\n");
}


/*----------------------------------------------------------*/
/*			   		LZk									*/
/*----------------------------------------------------------*/
void LZWrite(   u8 *Destp);
void LZWriteBin(u8 *Destp);
int	LZoutBufCount,   LZCount;

void LZCompWrite(u8 **Srcpp, u32 SrcNum, u8 **Destpp)
{
	u8	*Srcp = *Srcpp, *Destp = *Destpp;
	u8	*Searchp = NULL, *Lastp = NULL, *Currentp = NULL;
	u8	LastLength;
	u16	LastOffset;
	u8	LZFlags, *LZFlagsp;
	u32	LZTmp;
    int	i, ii, iii;

	strcat(labelName,   "_LZ");
	if (!outFileCustomFlag)		strcat(outfileName, "_LZ");

	*(u32 *)Destp = SrcNum << 8 | 0x10;		// f[^Ewb_
    LZCount = 4;

	LZoutBufCount = 0;
	while (LZoutBufCount < SrcNum) {
		LZFlags = 0;
		LZFlagsp = &Destp[LZCount++];
		for (i=0; i<8; i++) {
			LZFlags <<= 1;
			LastOffset = 0;
			LastLength = 0;
			Currentp = &Srcp[LZoutBufCount];
			for (ii=lzSearchOffset; ii<=LZoutBufCount && ii<=4096 && LZoutBufCount < SrcNum; ii++) {
				Searchp = &Srcp[LZoutBufCount-ii];
				if (*Searchp == *Currentp) {
					for (iii=1; iii<=16+2; iii++)
						if (Searchp[iii] != Currentp[iii])	break;
					if (iii > 16+2)							iii = 18;
					if (LZoutBufCount + iii >= SrcNum)		iii = SrcNum - LZoutBufCount;
					if (iii >= 3 && iii > LastLength) {
						Lastp = Searchp;
						LastOffset = ii;
						LastLength = iii;
						LZFlags |= 1;
					}
				}
			}
			if (LZoutBufCount < SrcNum)
				if ((LZFlags & 1) == 0)	Destp[LZCount++] = Srcp[LZoutBufCount++];
				else {					Destp[LZCount++] = (LastLength-3) << 4 | (LastOffset-1) >> 8;
										Destp[LZCount++] = (LastOffset-1) & 0xff;
										LZoutBufCount += LastLength;
				}
		}
		*LZFlagsp = LZFlags;
	}
	while (LZCount & 0x3)	Destp[LZCount++] = 0;


	CompBufNo ^= 1;							// dk or f[^
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&Destp, LZCount, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite(  &Destp, LZCount, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &Destp, LZCount, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&Destp, LZCount, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();			// o̓t@CEI[v
					headerWrite();		 	// wb_
					paletteReadWrite();		// pbg̓Ǎ݂Ə
					if (outFileType == 0)		LZWrite(   Destp);
					else						LZWriteBin(Destp);
					break;
	}
}

/*----------------------------------------------------------*/
/*			   		LZC[Wo						*/
/*----------------------------------------------------------*/

void LZWriteBin(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i;

	while (outCountTmp < LZCount)
		_rtl_write(BinOutHandle, &Destp[outCountTmp++], 1);
}

void LZWrite(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i;

	fprintf(fpo, "const u8 %s[0x%x] = {\n", labelName, LZCount);

	for (i=0; i<4; i++)							 	// WJ
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
	fprintf(fpo, "\n");
	fprintf(fpo, "\n");

	while (outCountTmp < LZCount) {					// f[^
		for (i=0; i<16 && outCountTmp < LZCount; i++) {
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		}
		fprintf(fpo, "\n");
	}

    fprintf(fpo, "};\n");
}


/*----------------------------------------------------------*/
/*			   		nt}k							*/
/*----------------------------------------------------------*/
void MakeBinTree(u32 TableNo, u32 Bit, u32 CheckNodes);
void HuffWrite(   u8 *Destp);
void HuffWriteBin(u8 *Destp);
#define	HUFF_END_L	0x80
#define	HUFF_END_R	0x40
typedef	struct {
	u32	No;				// f[^m
	u32	Frequency;		// opx
	s16	ParentNo;		// em
	s16	ChildNo[2];		// qm
	u16	ParentNodes;	// em[h̐[
	u16	ChildNodesMax;	// qm[h̍ő[
	u32	BitColumn;		// rbg
	u8	Bit;			// rbgEf[^
} HuffData;
HuffData	HuffTable[512];
HuffData	HuffTableInitData = {0, 0, 0,{0, 0}, 0,0, 0, 0};
HuffData	HuffTableTmp;
u8			HuffTree[256][2];
s32			HuffCurrentNo, HuffNextNo, HuffOffset;
int	HuffoutBufCount, HuffCount, HuffArrayInitNum;

void HuffCompWrite(u8 **Srcpp, u32 SrcNum, u8 **Destpp)
{
	u8	*Srcp = *Srcpp, *Destp = *Destpp;
	int	CheckCount = 0, ArrayNum = 1 << huffBitSize;
	s32	MinIndex[2], MinFrequency[2], MaxFrequency = 0, MaxCount = 0, CountTmp;
	u16	ParentNoMax;
	u16 ChildNoTmp;
	u16	ChildNodesMaxTmp;
	u8	ChildNodeFlag;
	u8	SrcTmp, DestTmp;
	u32 BitColumnTmp = 0;
	int	BitCount = 0;
	int	i, ii, iii, Lastii;

	strcat(labelName,   "_Huff");
	if (!outFileCustomFlag)		strcat(outfileName, "_Huff");

	HuffArrayInitNum = 1 << huffBitSize;
	for (i=0; i<HuffArrayInitNum*2; i++) {	// e[u
		HuffTable[i]    = HuffTableInitData;
		HuffTable[i].No = i;
	}

	for (i=0; i<HuffArrayInitNum; i++)		// opx`FbN
		for (ii=0; ii<SrcNum; ii++)
			for (iii=0; iii<8/huffBitSize; iii++)
				if (i == ((Srcp[ii] >> iii*4) & (0xff >> 4*(1 - huffBitSize/8))))
					HuffTable[i].Frequency++;

#if 0
	for (i=0; i<HuffArrayInitNum-1; i++)	// opx \[g
		for (ii=i+1; ii<HuffArrayInitNum; ii++)
			if (HuffTable[ii].Frequency > HuffTable[i].Frequency) {
				HuffTableTmp = HuffTable[i];
				HuffTable[i] = HuffTable[ii];
				HuffTable[ii] = HuffTableTmp;
			}
	ArrayNum = 0;
	while (HuffTable[ArrayNum].Frequency != 0)	// of[^ JEg
		ArrayNum++;
	for (i=0; i<HuffArrayInitNum; i++) 		// ǉm[hm
		HuffTable[ArrayNum+i].No = HuffArrayInitNum+i;
#endif
	for (i=0; i<ArrayNum; i++)				// of[^ qm[h
		for (ii=0; ii<2; ii++)
			HuffTable[i].ChildNo[ii] = -1;

	while (CheckCount < ArrayNum - 1) {	   	// c[e[u
		for (i=0; i<2; i++, CheckCount++) {
			for (ii=0, MinFrequency[i]=0x0fffffff; ii<ArrayNum; ii++)
				if (HuffTable[ii].Frequency < MinFrequency[i] && !HuffTable[ii].ParentNo) {
					MinIndex[i] = ii;
					MinFrequency[i] = HuffTable[ii].Frequency;
					HuffTable[ArrayNum].ChildNo[i] = ii;
				}
			HuffTable[MinIndex[i]].ParentNo = ArrayNum;
			if (HuffTable[ArrayNum].ChildNodesMax < HuffTable[MinIndex[i]].ChildNodesMax)
				HuffTable[ArrayNum].ChildNodesMax = HuffTable[MinIndex[i]].ChildNodesMax;
		}
		if (MinFrequency[1] > MinFrequency[0]) {
									ChildNoTmp = HuffTable[ArrayNum].ChildNo[0];
				HuffTable[ArrayNum].ChildNo[0] = HuffTable[ArrayNum].ChildNo[1];
				HuffTable[ArrayNum].ChildNo[1] = ChildNoTmp;
		}
		for (i=0; i<2; i++)
			HuffTable[HuffTable[ArrayNum].ChildNo[i]].Bit = i;
		HuffTable[ArrayNum].Frequency = MinFrequency[0] + MinFrequency[1];
		HuffTable[ArrayNum].ChildNodesMax++;
		ArrayNum++;
	}

	for (i=0; i<ArrayNum-1; i++) {	  		// em[h̐[^rbg񐶐
		HuffTable[i].ParentNodes = 0;
		ii = i;
		while (HuffTable[ii].ParentNo) {
			HuffTable[i].BitColumn >>= 1;
			HuffTable[i].BitColumn |= HuffTable[ii].Bit << 31;
			HuffTable[i].ParentNodes++;
			ii = HuffTable[ii].ParentNo;
		}
	}

	HuffCurrentNo = 0; 					  	// oCic[
	HuffNextNo = 1;
	for (i=0; i<=HuffTable[ArrayNum-1].ChildNodesMax; i++)
		MakeBinTree(ArrayNum-1, 1, i);
	if (HuffCurrentNo & 0x1)  HuffCurrentNo++;
	HuffTree[0][0] = HuffCurrentNo - 1;


	*(u32 *)Destp = SrcNum << 8 | 0x20 | huffBitSize; // f[^Ewb_
    HuffCount = 4;

	for (i=0; i<HuffCurrentNo*2; i++)		// c[e[u
		Destp[HuffCount++] = ((u8 *)HuffTree)[i];

	for (i=0; i<SrcNum; i++)				// f[^k
		for (ii=0; ii<8/huffBitSize; ii++) {
				SrcTmp = (Srcp[i] >> ii*4) & (0xff >> 4*(1 - huffBitSize/8));
    			BitColumnTmp |= HuffTable[SrcTmp].BitColumn >> BitCount;
			BitCount     += HuffTable[SrcTmp].ParentNodes;
			for (iii=0; iii<BitCount/8; iii++) {
				Destp[HuffCount++] = (u8 )(BitColumnTmp >> 24);
				BitColumnTmp <<= 8;
			}
			BitCount %= 8;
		}
	if (BitCount != 0)		Destp[HuffCount++] = (u8 )(BitColumnTmp >> 24);
	while (HuffCount & 0x3)	Destp[HuffCount++] = 0;

	for (i=1+HuffCurrentNo*2/4; i<HuffCount/4; i++)	{		// gGfBAϊ
		Swap(u8, Destp[i*4+0], Destp[i*4+3]);
		Swap(u8, Destp[i*4+1], Destp[i*4+2]);
	}

	CompBufNo ^= 1;							// dk or f[^
	switch (*CompTypeBufp++) {
		case 'd':	DiffFiltWrite(&Destp, HuffCount, &CompBufp[CompBufNo]);
					break;
		case 'r':	RLCompWrite(  &Destp, HuffCount, &CompBufp[CompBufNo]);
					break;
		case 'l':	LZCompWrite(  &Destp, HuffCount, &CompBufp[CompBufNo]);
					break;
		case 'h':	HuffCompWrite(&Destp, HuffCount, &CompBufp[CompBufNo]);
					break;
		default:	outfileOpen();			// o̓t@CEI[v
					headerWrite();		 	// wb_
					paletteReadWrite();		// pbg̓Ǎ݂Ə
					if (outFileType == 0)	HuffWrite(   Destp);
					else					HuffWriteBin(Destp);
					break;
	}
}

/*----------------------------------------------------------*/
/*			   		oCic[						*/
/*----------------------------------------------------------*/

void MakeBinTree(u32 TableNo, u32 Bit, u32 CheckNodes)
{
	int	i;

	if (HuffTable[TableNo].Frequency == 0 && Bit == 0)	return;

	if (HuffTable[TableNo].ParentNodes < CheckNodes) {
		for (i=0; i<2; i++)
			if (HuffTable[TableNo].ChildNo[i] != -1)
				MakeBinTree(HuffTable[TableNo].ChildNo[i], i, CheckNodes);
	} else {
		if (HuffTable[TableNo].No < HuffArrayInitNum)	// f[^
			HuffTree[HuffCurrentNo][Bit] = HuffTable[TableNo].No;
		else {
			for (i=0; i<2; i++)							// m[h
				if (HuffTable[HuffTable[TableNo].ChildNo[i]].No >= 0
				 && HuffTable[HuffTable[TableNo].ChildNo[i]].No < HuffArrayInitNum)
					HuffTree[HuffCurrentNo][Bit] |= HUFF_END_L >> i;
			HuffOffset = HuffNextNo - HuffCurrentNo - 1;
			if (HuffOffset >= 0x40) {				// ItZbgG[
		        fprintf(stderr, "Can't make a TreeTable from %s.\n", infileName);
				infileClose(fpi);				 	// ̓t@CEN[Y
		 		exit(1);
			}
			HuffTree[HuffCurrentNo][Bit] |= HuffOffset;
			HuffNextNo++;;
		}
		if (Bit == 1)	HuffCurrentNo++;
	}
}

/*----------------------------------------------------------*/
/*			  	nt}EC[Wo					*/
/*----------------------------------------------------------*/

void HuffWriteBin(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i, ii;

	while (outCountTmp < HuffCount)
		_rtl_write(BinOutHandle, &Destp[outCountTmp++], 1);
}

void HuffWrite(u8 *Destp)
{
    int	outCountTmp = 0;
	int	i, ii;

	fprintf(fpo, "const u8 %s[0x%x] = {\n", labelName, HuffCount);

	for (i=0; i<4; i++)							   	// WJ
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
	fprintf(fpo, "\n");

	for (i=0; i<(HuffCurrentNo*2+15)/16; i++) {	 	// c[e[u
		for (ii=0; ii<16 && outCountTmp < HuffCurrentNo*2 + 4; ii++)
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		fprintf(fpo, "\n");
	}
	fprintf(fpo, "\n");

	while (outCountTmp < HuffCount) {			   	// f[^
		for (i=0; i<16 && outCountTmp < HuffCount; i++) {
			fprintf(fpo, "0x%02x,", Destp[outCountTmp++]);
		}
		fprintf(fpo, "\n");
	}

    fprintf(fpo, "};\n");
}


/*==========================================================*/
/*                                                          */
/*                  ̓t@CEN[Y                  */
/*                                                          */
/*==========================================================*/

void infileClose(FILE *fpi)
{
    if (fclose(fpi) == EOF) {
        fprintf(stderr, "Can't close: %s\n", infileName);
        exit(1);
    }
}


/*==========================================================*/
/*                                                          */
/*                  o̓t@CEN[Y                  */
/*                                                          */
/*==========================================================*/

void outfileClose(void)
{
	if (outFileType == OUT_FILE_C) {
	    if (fclose(fpo) == EOF) {
			fprintf(stderr, "Can't close: %s\n", outfileName);
			exit(1);
		}
	} else {
		if (close(BinOutHandle) == -1) {
			fprintf(stderr, "Can't close: %s\n", outfileName);
			exit(1);
		}
	}
}


//---------------------------------------------------------------------------


