/*
 * $Id: audioMgr.h,v 1.9 2001-02-03 17:24:03+09 hayakawa Exp $
 *
 * ǥޥ͡
 *
 */

#ifndef __AUDIOMGR_H_
#define __AUDIOMGR_H_

#include "u64basic.h"
#include "irqmgr.h"		/* irqmgr_t */
#include "m_debug.h"		/* SREG */

/*
 * 
 */

#ifdef _LANGUAGE_C_PLUS_PLUS
extern "C" {
#endif
#if 0
}
#endif

/*
 * ǥ¹
 */
#define IS_DISABLE_AUDIO_TASK()		(GETSREG(20) == 1)
#define SET_DISABLE_AUDIO_TASK()	SETSREG(20, 1)
#define IS_DISABLE_AUDIO_MAIN()		(GETSREG(20) >= 2)
#define SET_DISABLE_AUDIO_MAIN()	SETSREG(20, 2)
#define CLEAR_DISABLE_AUDIO_MAIN_AND_TASK()	SETSREG(20, 0)

#define AUDIO_STACKSIZE 	0x800 /* å  0x560 */
#define AUDIO_MAX_MESGS         8 /* åХåե */

typedef union {    

    struct {
        short     type;
    } gen;

    irqmgr_msg_t  app;
    
} AudioMsg;

typedef enum audio_doing_point_e {
    AUDIO_DOING_POINT_ZERO,
    AUDIO_DOING_POINT_CT,                      /* 󥹥ȥ饯ȴλ */
    AUDIO_DOING_POINT_WAIT_MESSAGE,            /* åԤ */
    AUDIO_DOING_POINT_FRAME_MSG,               /* ȥ졼ϥɥ󥰥 */
    AUDIO_DOING_POINT_FRAME_MSG_DONE,          /* ȥ졼ϥɥ󥰥Ƚλ*/
    AUDIO_DOING_POINT_SADO_VIDEOFRAME,         /* sAdo_VideoFrame */
    AUDIO_DOING_POINT_SADO_VIDEOFRAME_DONE,    /* sAdo_VideoFrameλ */
    AUDIO_DOING_POINT_WAIT_TASK, /* ǥλԤ */
    AUDIO_DOING_POINT_WAIT_TASK_DONE,/* ǥλԤλ */
    AUDIO_DOING_POINT_DT,                      /* ǥȥ饯ȳ */
    AUDIO_DOING_POINT_MAX
} audio_doing_point_e;

#define SET_AUDIO_DOING_POINT(g, e)     ((g)->doing_point = (u8)((e) - AUDIO_DOING_POINT_ZERO))
#define SET_AUDIO_DOING_POINT2(g, e2)   SET_AUDIO_DOING_POINT(g, AUDIO_DOING_POINT_##e2)
#define GET_AUDIO_DOING_POINT(g)        ((audio_doing_point_e)(g)->doing_point)

/*
 * ңã 
 */
typedef volatile struct {
    OSTask		ostask;	/* ǥ */
    OSMesgQueue		*osmsgQ; /* λ˥å */
} RCPTask;

/*
 * ǥޥ͡㥳ƥ
 */
typedef struct {
    irqmgr_t	*irqmgr;
    OSScTask    task;		/* 塼饿¤ */
    RCPTask     *audiomainp;	/* Nas_AudioMain() */
    OSMesgQueue audioFrameMsgQ; /* ȥ졼Υåʤ */
    OSMesg      audioFrameMsgBuf[AUDIO_MAX_MESGS];
    OSMesgQueue audioReplyMsgQ; /* ǥңãдλå */
    OSMesg      audioReplyMsgBuf[1];
    OSMesgQueue InitSyncMsgQ; /* ǥңãдλå */
    OSMesg      InitSyncMsgBuf[1];
    OSThread    audioThread;
    u8		__padding1;
    u8		__padding2;
    u8		doing_point;
    u8		audio_sleeped;	/* !0:audiomain, audio sp ưƤʤ */
} AMAudioMgr;

extern AMAudioMgr amAudioMgr; /* §Ȥľܥ϶ػ */
extern u32 audio_sp_retry_cnt;

/*
 * ǥޥ͡
 */
extern void
amInit(
    void *stack,		/* åΰ(AUDIO_STACKSIZEХ) */
    OSPri pri,			/* ǥޥ͡Υåͥ */
    OSId id			/* ǥޥ͡Υåɣɣ */
);

#if 0
/*
 * ǥޥ͡
 */
extern void amCleanup(void);
#endif

/*
 * ǥޥ͡λԤ
 */
extern void amInitSync(void);
    
/*
 * ǥޥ͡
 */
extern void amStop(void);
	
/*
 * ǥޥ͡Ƴ
 */
extern void amContinue(void);

#if 0
{
#endif
#ifdef _LANGUAGE_C_PLUS_PLUS
} /* extern "C" */
#endif

#endif /* __AUDIOMGR_H_ */
