/*
 * $Id: famicom_check.c,v 1.7 2000-12-27 22:28:33+09 hayakawa Exp $
 *
 * եߥ󥨥ߥ졼
 */

#include "famicom_check.h"
#include "m_cpak_lib.h"         /* m_osPfsFindFile_Alt */
#include "padmgr.h"		/* padmgr_LockSerialMesgQ */
#include <ultra64.h>
#include <debug.h>              /* disp */

#define nesinfo_cpak_company_code    M_CPAK_COMPANY_CODE
#define nesinfo_cpak_game_code       M_CPAK_GAME_CODE

/*
 * եߥ󥲡ǡȥѥåˤ뤫ɤå
 *
 * ҥ  :1
 * ॳ:NSGJ
 * ̾    :NESROMIMAGE
 */
extern int
contpak_exist_check( void )
{
    int status = -1;		/* return value */
    static u8 ext_name[PFS_FILE_EXT_LEN];
    s32 file_no;
    s32 r;
    OSPfs pfs;
    OSMesgQueue *Q = NULL;	/* SI Q */
    int cont_no;

    PRINTF(ESC_YELLOW "ȥѥå˥եߥǡ뤫ʥå\n" ESC_NORMAL);
    
    /*
     * SI¾ѥå
     */
    Q = padmgr_LockSerialMesgQ();

    for (cont_no = 0; cont_no < 2; cont_no++) {
        /*
         * ȥѥå
         * 顼̵
         */
        r = osPfsInitPak(Q, &pfs, cont_no);
        if (r == 0) {
            /*
             * եõ
             * ĤХ롼פȴ
             */
            r = m_osPfsFindFile_Alt(&pfs, nesinfo_cpak_company_code, nesinfo_cpak_game_code, (u8 *)M_CPAK_GAME_NAME, ext_name, &file_no);
            if (r == 0) {
                PRINTF0(ESC_YELLOW "եߥǡĤޤ\n" ESC_NORMAL);
                break;
            } else if (r == PFS_ERR_INVALID) {
                PRINTF0(ESC_WARNING "եߥǡĤޤ\n" ESC_NORMAL);
            } else {
                PRINTF0(ESC_WARNING "ȥѥåΥ顼Ǥ\n" ESC_NORMAL);
            }
        } else if (r == PFS_ERR_NOPACK) {
            PRINTF1(ESC_WARNING "ȥѥå %d Ϥޤ\n" ESC_NORMAL, cont_no);
        } else {
            PRINTF2(ESC_WARNING "ȥѥå %d ν˼(%d)ޤ\n" ESC_NORMAL, cont_no, r);
        }
    }

    if (cont_no >= 2)
        goto error_exit;
    
    /*
     * 
     */
    status = 0;
    
error_exit:

    if (r != 0) {
	disp(d, r);
    }
    
    /*
     * SI¾ѥå
     */
    if (Q != NULL) {
	padmgr_UnlockSerialMesgQ( Q );
	Q = NULL;
    }

    return status;
}
