/*
 ******************************************************************************
 *
 * ȥѥåϢ饤֥
 *
 * $Id: m_cpak_lib.c,v 1.7 2001-01-17 22:39:37+09 hayakawa Exp $
 *
 ******************************************************************************
 */

#include "m_cpak_lib.h"
#include "debug.h"              /* PRINTF */

/*
 * ȥѥåѥॿȥ
 * `DOUBUTSUNOMORI'
 *  Makefile  NRDC_GAME_TITLE Ʊľ
 */
#define _XX \
    _X('D'), _X('O'), _X('U'), _X('B'), _X('U'), _X('T'), _X('S'), _X('U'), \
    _X('N'), _X('O'), _X('M'), _X('O'), _X('R'), _X('I'), _X('\0'), _X('\0'),

#if 0
char m_cpak_game_name_ascii[] = {
#define _X(x) (x)
    _XX
#undef _X
};
#endif

char m_cpak_game_name_a_n64font[PFS_FILE_NAME_LEN] = {
#define _X(x) M_CPAK_A2N(x)
    _XX
#undef _X
};
#undef _XX

#if 0
char m_cpak_game_name_k_n64font[PFS_FILE_NAME_LEN] = {
    0x8a,                       /*  */
    0x52,                       /*  */
    0x8d,                       /*  */
    0x61,                       /*  */
    0x68,                       /*  */
    0x72,                       /*  */
    0x77,                       /*  */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
#endif

/*
 * ɤΣեȥɤѴ
 * ե٥åȡΤ
 */
static const u8
n64font_cvttbl[] = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ!\"#'*+,-./:=?@";
extern u8 *
ascii_to_n64font(char *ascii, u8 *n64font, size_t size)
{
    size_t i, j;
    
    for (i = 0; i < size && ascii[i] != 0; i++) {
        int a = (int)ascii[i];
        int n;

        n = 0x41;               /* @ */
        for (j = 0; j < sizeof(n64font_cvttbl) - 1; j++) {
            if (a == n64font_cvttbl[j]) {
                n = (int)(j + 0x0f);
                break;
            }
        }
	n64font[i] = (u8)n;
    }
    for ( ; i < size; i++) {
	n64font[i] = 0;
    }

    return n64font;
}

/*
 * Σեȥɤ˥Ѵ
 * ե٥åȡΤ
 */
extern char *
n64font_to_ascii(u8 *n64font, char *ascii, size_t size)
{
    size_t i;
    
    for (i = 0; i < size; i++) {
        size_t n = (size_t)n64font[i];

        if (n == 0) {
            ascii[i] = 0;
        } else if (n - 0x0f < sizeof(n64font_cvttbl)) {
            ascii[i] = n64font_cvttbl[n - 0x0f];
        }
    }

    return ascii;
}

/*
 * osPfsFindFile ̥С
 * ҥɡॳɡĥҤפĥ̾פʤ
 * ΡȤ򸡺
 * ʤݥ󥿤NULLξϤιܤñ̵뤷ޤ
 */
extern s32
m_osPfsFindFile_Alt(
    OSPfs *pfs,
    u16 company_code,
    u32 game_code,
    u8 *game_name,              /* פʤ̾ */
    u8 *ext_name,
    s32 *file_no )
{
    OSPfsState state;
    s32 r;
    s32 idx;
    char aw[PFS_FILE_NAME_LEN + 1];

    if (pfs != NULL) {
        PRINTF2("%.4s %.2s", &game_code, &company_code);
        PRINTF1(" %.16s", game_name ? n64font_to_ascii(game_name, aw, PFS_FILE_NAME_LEN) : "*");
        PRINTF1(" %.4s\n", ext_name ? n64font_to_ascii(ext_name, aw, PFS_FILE_EXT_LEN) : "*");
        for (idx = 0; idx < 16; idx++) {
            disp(d, idx);
            r = osPfsFileState(pfs, idx, &state);
            if (r == PFS_ERR_INVALID)
                continue;
            if (r != 0)
                return r;
            PRINTF2("%.4s %.2s", &state.game_code, &state.company_code);
            PRINTF1(" %.16s", n64font_to_ascii((u8 *)state.game_name, aw, PFS_FILE_NAME_LEN));
            PRINTF1(" %.4s\n", n64font_to_ascii((u8 *)state.ext_name, aw, PFS_FILE_EXT_LEN));
            if (game_code == state.game_code && company_code == state.company_code &&
                (game_name == NULL || bcmp(game_name, state.game_name, PFS_FILE_NAME_LEN) != 0) &&
                (ext_name == NULL || bcmp(ext_name, state.ext_name, PFS_FILE_EXT_LEN) == 0) ) {
                if (file_no != NULL) {
                    *file_no = idx;
                }
                return 0;
            }
        }
    }
    return PFS_ERR_INVALID;     /* ΡȤĤʤȤosPfsFindFile֤ͤƱ */
}

#if 0
/*
 * 
 */
extern void
m_cpak_lib_init(void)
{
    /*
     * game_name򥢥ɤϿʸɤѴ
     */
    ascii_to_n64font(m_cpak_game_name_ascii, m_cpak_game_name_n64font, PFS_FILE_NAME_LEN);
}
#endif
