/*
 ******************************************************************************
 *	File :		m_immig.h
 * 	Programer :	Gentaro Takaki
 *
 *	$Id: m_immig.h,v 1.18 2000-12-21 23:30:31+09 gen Exp $
 ******************************************************************************
 */

#ifndef	M_IMMIG_H_INCLUDED
#define M_IMMIG_H_INCLUDED

#if	defined(LANGUAGE_C) || defined(_LANGUAGE_C_PLUS_PLUS)

#ifdef	_LANGUAGE_C_PLUS_PLUS
extern "C" {
#endif

#include "ultra64.h"
#include "m_types.h"
#include "os.h"
#include "lb_rtc.h"
#include "m_private_id.h"

/*
 *	֡ɥ⡼ɥƥ꡼
 */
enum	save_load_mode_category {
    mImm_SAVE_LOAD_MODE_CATEGORY_START_e,
    
    mImm_SVLD_CT_NOT_e = mImm_SAVE_LOAD_MODE_CATEGORY_START_e,	/** 顼 */
    mImm_SVLD_CT_FLASH_e,	/** եå˥ */
    mImm_SVLD_CT_GB_e,		/** GBѥå˥(եåˤ) */
    mImm_SVLD_CT_CPAK_e,	/** ȥѥå(  ) */
    
    mImm_SAVE_LOAD_MODE_CATEGORY_END_e
};

/*
 *	֡ɥ⡼
 */
enum	save_load_mode_kind {
    mImm_SAVE_LOAD_MODE_KIND_START_e,

    mImm_SVLDMD_NOT_e = mImm_SAVE_LOAD_MODE_KIND_START_e,	/** 顼 */
    mImm_SVLDMD_PLAYER_e,		/** ץ졼䡼ΥǡΤ */
    mImm_SVLDMD_LAND_e,		/** ¼Υǡޤ */

    mImm_SAVE_LOAD_MODE_KIND_END_e
};

/*
 *	ǡȤ߹碌ơ֥
 */
enum	start_data_combination {
    mImm_START_DATA_COMBINATION_START_e,
    
    mImm_DATA_COMB_0_e = mImm_START_DATA_COMBINATION_START_e,
    mImm_DATA_COMB_1_e,
    mImm_DATA_COMB_2_e,
    mImm_DATA_COMB_3_e,
    mImm_DATA_COMB_4_e,
    mImm_DATA_COMB_5_e,
    mImm_DATA_COMB_6_e,
    
    mImm_START_DATA_COMBINATION_END_e
};

/** GBѥåǡξ */
enum	gbpak_data_status {
    mImm_GB_DATA_STATUS_START_e,

    mImm_GB_SAME_e = mImm_GB_DATA_STATUS_START_e,	/* ϻ GBƱ */
    mImm_GB_OTHER_e,					/* ϻ GBȰ㤦 */
    mImm_NO_GB_e,					/* GBѥå̵ */
    
    mImm_GB_DATA_STATUS_END_e
};

/*
 *	GBѥå¼ȥȥå¼
 */
enum	gb_rom_comp_status {
    mImm_GB_ROM_COMP_STATUS_START_e,
    
    mImm_GBROM_CMP_SAME_e = mImm_GB_ROM_COMP_STATUS_START_e,	/** ȥå¼ GB¼ */
    mImm_GBROM_CMP_OTHER_e,	/** ۤ¼ */
    mImm_GB_NO_LAND_DATA_e,	/** GBѥå¼Υǡ̵ */
    
    mImm_GB_ROM_COMP_STATUS_END_e
};

/*
 ****************************************************************
 *
 *		GBѥåط
 *
 ****************************************************************
 */
/*
 ******************************************************************************
 *	GBѥåξּ
 *
 *	in	:	ʤ
 *
 *	out	:	ơ (unchar *)
 *
 *	֤	:	顼	ｪλ	-1
 *					۾ｪλ	ʲ
 *---------------------------------------------------------------
 *	
 *
 *	ơ, 顼ϰʲΤ褦ˤʤäƤޤ
 *	줾 os_bgpak.h, os_psf.hƤޤ
 *	ߤϥơ⥨顼ͤѤƤ
 *			      ~~~~~~~~~~~~~~~~~~~~~~~~~~
 *	ڥơ
 *	OS_GBPAK_POWER          0x01	GBȥåŸ򼨤ޤ
 *					POWER ONΤȤPOWER OFFΤȤǤ
 *
 *	OS_GBPAK_RSTB_DETECTION 0x04	Ѥޤ
 *
 *	OS_GBPAK_RSTB_STATUS    0x08	Ѥޤ
 *
 *	OS_GBPAK_GBCART_PULL    0x40	GBȥåȴФ򼨤ӥå
 *					ǤGBȥåöȴ줿
 *					ˤϡΥӥåȤΩޤ
 *					GBȥåޤ줿֤
 *					osGbpakGetStatus()ޤosGbpakReadId()
 *					ƤӽФȡΥӥåȤϣˤʤޤ
 *
 *	OS_GBPAK_GBCART_ON      0x80	GBȥåޤƤ뤫
 *					ӥå 64GBѥå GBȥå
 *					ޤƤ磱ˤʤޤ
 *
 *
 *	ڥ顼
 *	PFS_ERR_NOPACK          1	ꤷȥ˲⺹ޤ
 *					ޤ
 *
 *	PFS_ERR_NEW_PACK        2
 *
 *	PFS_ERR_INCONSISTENT    3
 *
 *	PFS_ERR_CONTRFAIL       CONT_OVERRUN_ERROR              
 *					ȥȤΥǡžμԤǤ
 *					ȥ餬³Ƥʤ
 *					64GBѥåȥ饳ͥ
 *					۾郎ǽޤ
 *
 *	PFS_ERR_INVALID         5
 *
 *	PFS_ERR_BAD_DATA        6
 *
 *	PFS_DATA_FULL           7
 *
 *	PFS_DIR_FULL            8
 *
 *	PFS_ERR_EXIST           9
 *
 *	PFS_ERR_ID_FATAL        10
 *
 *	PFS_ERR_DEVICE          11	64GBѥåʳΥǥХȥ
 *					˺ޤƤޤ
 *
 *	PFS_ERR_NO_GBCART       12	64GBѥåGBȥåޤ
 *					Ƥޤ
 *
 *	PFS_ERR_NEW_GBCART      13	GBȥåȴԤޤ
 *
 ******************************************************************************
 */
#if 0
/** GBѥåбʤ */
extern int mImm_GetGBPakStatus(
    unchar	*status		/** GBѥåΥơ */
    );
#endif	/** #if 0 end */

/*
 ******************************************************************************
 *	GBѥåǡ˥ץ졼䡼ǡ뤫ɤå
 *
 *	in	:	ʤ
 *
 *	out	:	ʤ
 *
 *	֤	:	GBѥå˥ץ졼䡼ǡ	TRUE
 *			GBѥå˥ץ졼䡼ǡʤ	FALSE
 *-----------------------------------------------------------------------------
 *		ߤϥǥХåѤ FALSE֤ޤ
 ******************************************************************************
 */
#if 0
/** BGѥåбʤ */
extern int mImm_CheckGBPlayerExist( void );
#endif	/** #if 0 end */

/*
 ****************************************************************
 *	GBѥåǡΥץ졼䡼Ŀ;μ( ԡ )
 *
 *	in	:	ʤ
 *
 *	out	:	ץ졼䡼Ŀ;
 *			PersonalID_c ΰϤƤ
 *
 *	֤	:	ʤ
 *--------------------------------------------------------------
 *		ߤϥǥХåѤŬͤ򥳥ԡƤޤ
 ****************************************************************
 */
#if 0
/** GBѥåбʤ */
extern void mImm_GetGBPlayerPersonalID(
    PersonalID_c	*dst_p
    );
#endif

/*
 ****************************************************************
 *	GBѥåΥץ졼䡼ǡ¼νͤå
 *
 *	in	:	ʤ
 *
 *	out	:	ʤ
 *
 *	֤	:	Ʊο	TRUE
 *			۹ο	FALSE
 ****************************************************************
 */
#if 0
/** GBѥåбʤ */
extern int mImm_CheckGBPlayerThisCountryman( void );
#endif	/** #if 0 end */

/*
 ******************************************************************************
 *	GBѥåǡΥå
 *
 *	in	:	ʤ
 *
 *	out	:	GBǡξ		mImm_GB_SAME_e
 *					۾	¾(gbpak_data_status)
 *
 *	֤	:	mImm_GetGBPakStatus( )֤
 *---------------------------------------------------------------
 *	
 *
 *	GBǡξ֤ m_immig.h gbpak_data_status򻲾
 ******************************************************************************
 */
#if 0
/** GBѥåбʤ */
extern int mImm_GetGBSaveDataStatus(
    unchar	*data_status	/** GBѥåǡΥơ */
    );
#endif

/*
 ****************************************************************
 *	GBѥåΥǡֵѲǽ¼ǡ뤫å
 *
 *	(ֵѲǽ)				TRUE
 *	ʤ(ֵԲǽ or ¼ǡʤ)	FALSE
 *---------------------------------------------------------------
 *		ߤϥǥХåѤɬ FALSE֤ޤ
 ****************************************************************
 */
#if 0
/** GBѥåбʤ */
extern int mImm_CheckGBPakReturnLand( void );
#endif	/** #if 0 end */

/*
 ****************************************************************
 *	GBѥå¾¼Υǡ뤫ɤå
 *
 *		TRUE
 *	ʤ	FALSE
 *---------------------------------------------------------------
 *		ߤϥǥХåѤɬ FALSE֤ޤ
 ****************************************************************
 */
#if 0
/** GBѥåбʤ */
extern int mImm_CheckGBPakOtherLand( void );
#endif	/** #if 0 end */

/*
 ******************************************************************************
 *	GBѥå¼ȥȥå¼å
 *
 *	in	:	ʤ
 *
 *	out	:	ʤ
 *
 *	֤	:	GBѥå¼ȥȥå¼
 *						mImm_GBROM_CMP_SAME_e
 *			԰			mImm_GBROM_CMP_OTHER_e
 *			GB¼ǡ̵	mImm_GB_NO_LAND_DATA_e
 *						(gb_rom_comp_status)
 *-----------------------------------------------------------------------------
 *		ߤϥǥХåѤ mImm_GB_NO_LAND_DATA_e֤ޤ
 ******************************************************************************
 */
#if 0
/** GBѥåбʤ */
extern int mImm_CheckCompGBtoFlashRom( void );
#endif	/** #if 0 end */

/*
 ****************************************************************
 *	ΥåȤ¼εϿפФͤ̾
 *
 *	in	:	ʤ
 *
 *	out	:	Ǹ˼ڤꤿץ졼䡼̾
 *			PERSON_NAME_NUMʬΥɬ
 *
 *	֤	:	ʤ
 ****************************************************************
 */
#if 0
/** GBѥåбʤ */
extern void mImm_GetLastLoanPlayerName(
    unchar	*player_name_p	/** PERSON_NAME_NUMʬΥɬ */
    );
#endif	/** #if 0 end */

/*
 ****************************************************************
 *	ǸϿץ졼䡼̾
 *
 *	in	:	ʤ
 *
 *	out	:	ǸϿץ졼䡼̾
 *			PERSON_NAME_NUMʬΥɬ
 *
 *	֤	:	ʤ
 ****************************************************************
 */
extern void mImm_GetLastRegistPlayerName(
    unchar	*last_player_name_p
    );

/*
 ****************************************************************
 *	ֵѴ¤ޤǤλּ	ȡ
 *
 *	in	:	ʤ
 *
 *	out	:	ֵѴ¤ޤǤλ
 *			unintΰϤƤ
 *
 *	֤	:	ʤ
 ****************************************************************
 */
#if 0
extern void mImm_GetLoanedLandLimitHour(
    unint	*hour_p
    );
#endif	/** #if 0 end */

/*
 ******************************************************************************
 *	ߤФ¼ֵѴ¤μ
 *
 *	in	:	ʤ
 *
 *	out	:	ֵѴ
 *			limit_pˤ lbRTC_time_cΰϤƲ
 *
 *	֤	:	ʤ
 ******************************************************************************
 */
#if 0
extern void mImm_GetLandLoanLimit(
    lbRTC_time_c *limit_p	/** ֵѴ( lbRTC_time_cΰϤ ) */
    );
#endif	/** #if 0 end */

/*
 ****************************************************************
 *	¼ߤФĥå
 *
 *		TRUE
 *	Ѳ	FALSE
 *---------------------------------------------------------------
 *		ߤϥǥХåѤɬ FALSE֤ޤ
 ****************************************************************
 */
#if 0
extern int mImm_CheckLandLoanPermission( void );
#endif	/** #if 0 end */

/*
 ****************************************************************
 *	¼ǡߤФ
 *
 *	in	:	ʤ
 *
 *	out	:	ʤ
 *
 *	֤	:	ߤФ	TRUE
 *					FALSE
 *---------------------------------------------------------------
 *		ߤ TRUE֤ޤ
 ****************************************************************
 */
#if 0
extern int mImm_LoanThisLand( void );
#endif	/** #if 0 end */

/*
 ******************************************************************************
 *	ߤ¼ȥå¼ GBѥå¼å
 *
 *	ȥå¼	mImm_SVLD_CT_FLASH_e
 *	GB¼			mImm_SVLD_CT_GB_e
 *	顼			mImm_SVLD_CT_NOT_e
 *---------------------------------------------------------------
 *		ߤϥǥХåѤɬ mImm_SVLD_CT_FLASH_e֤ޤ
 ******************************************************************************
 */
#if 0
extern int mImm_GetLandDataMode( void );
#endif	/** #if 0 end */

/*
 ****************************************************************
 *	GBѥå¼̾μ(ԡ)
 *
 *	in	:	ʤ
 *
 *	out	:	¼̾
 *			COUNTRY_NAME_NUMʬΰ褬ɬפǤ
 *
 *	֤	:	ʤ
 ****************************************************************
 */
#if 0
extern int mImm_GetGBPakLandName(
    unchar	*land_name_p	/** ¼̾Ǽΰ */
    );
#endif	/** #if 0 end */

/*
 ******************************************************************************
 *	ߤΥǡȤ߹碌
 *
 *	in	:	ʤ
 *	
 *	out	:	ʤ
 *	
 *	֤	:	ǡȤ߹碌ֹ
 *			(start_data_combination)
 *-----------------------------------------------------------------------------
 *		ߤϥǥХåѤɬ mImm_DATA_COMB_0_e֤ޤ
 ******************************************************************************
 */
#if 0
extern int mImm_GetLandDataCombination( void );
#endif	/** #if 0 end */

/*
 ****************************************************************
 *	GBѥå¼δ¥å
 *
 *	in	:	ʤ
 *
 *	out	:	ʤ
 *
 *	֤	:	¥åη
 *						TRUE
 *				ڤ	FALSE
 *--------------------------------------------------------------
 *		ߤϥǥХåѤɬ FALSE֤ޤ
 ****************************************************************
 */
#if 0
extern int mImm_CheckGBLandLimit( void );
#endif	/** #if 0 end */

/*
 ****************************************************************
 *	GBѥå¼õ
 *
 *	in	:	ʤ
 *
 *	out	:	ʤ
 *
 *	֤	:	õ	TRUE
 *			õ	FALSE
 *--------------------------------------------------------------
 *		ߤϥǥХåѤɬ TRUE֤ޤ
 ****************************************************************
 */
#if 0
extern int mImm_EraceGBLand( void );
#endif	/** #if 0 end */

/*
 ****************************************************************
 *	ϻΥǡΥ &  & ֥⡼ɽ
 ****************************************************************
 */
extern void mImm_InitGameStart_init( void );

/*
 ******************************************************************************
 *	೫ϻΥǡΥ & 
 *
 *	in	:	ɥƥ꡼ (save_load_mode_category)
 *			ɥ⡼ (save_load_mode_kind)
 *			Ȥ߹碌ѥ(start_data_combination)
 *			ץ졼䡼ֹ( 0  5 )
 *
 *	out	:	ʤ
 *
 *	֤	:	ɽ	TRUE
 *						FALSE
 *			۾ｪλ		-1
 *-----------------------------------------------------------------------------
 *		ޤ player_select.cǽƤ
 *		ޤ
 *
 *		Ϥץ졼䡼ֹϥץ졼䡼̤ä
 *		Ф줿ֹϤƤ. ʳξ
 *		ɬ 0ϤƤ.
 ******************************************************************************
 */
extern int mImm_InitGameStart(
    int		mode_category,	/** ɥƥ꡼ */
    int		mode,		/** ɥ⡼ */
    int		start_comb,	/** Ȥ߹碌ѥ */
    int		player_no	/** ץ졼䡼ֹ */
    );

/*
 ****************************************************************
 *	ֽΥ⡼ɽ
 ****************************************************************
 */
extern void mImm_SaveMode_init( void );

/*
 ******************************************************************************
 *	
 *	
 *	in	:	֥⡼ɥƥ꡼(save_load_mode_category)
 *			֥⡼ (save_load_mode_kind)
 *			ƥ˥塼ե饰(  OFF / ³ ON )
 *
 *	out	:	ʤ
 *
 *	֤	:	ｪλ	1
 *				0
 *			۾ｪλ	-1
 ******************************************************************************
 */
extern int mImm_Save_common(
    int		mode_category,
    int		mode,
    int		continue_flag
    );

#define mImm_Save( mc, md )	mImm_Save_common((mc), (md), OFF)















/*
 ******************************************************************************
 *	δؿ ȥѥå, Flashromּ¸ѤǤ
 *	ֲ̤λͤޤ꼡褽˰ܤޤ.
 ******************************************************************************
 */
extern void mImm_SaveTest( void );



/*
 ------------------------------------------------------------------------------
 *		ȥѥåˤ
 ------------------------------------------------------------------------------
 */
/*
 ****************************************************************
 *	೫ϤΤȥѥå餫å
 *
 *	ѥåǥ೫	TRUE
 *	ȥåǳ	FALSE
 ****************************************************************
 */
extern int mImm_CheckStartDataCategory( void );

#ifdef	_LANGUAGE_C_PLUS_PLUS
}
#endif

#endif	/** defined(LANGUAGE_C) || defined(_LANGUAGE_C_PLUS_PLUS) */
#endif	/** M_IMMIG_H_INCLUDED */
