/*
 ******************************************************************************
 *  	File		: s_cpak.c
 *	Programer	: Gentaro Takaki
 *
 *	$Id: s_cpak.c,v 3.1 2001-03-13 18:19:23+09 forest Exp $
 ******************************************************************************
 */

#include "m_basic.h"
#include "padmgr.h"
#include "m_cpak.h"
#include <u64uty.h>             /* utGetTime_ms */



/*
 ****************************************************************
 *	ҥɤȥॳؿ
 ****************************************************************
 */
extern void sCPk_SetCode(
    OSPfsState	*pakstate,
    const u8	*co_code,
    const u8	*game_code
    ){

    bcopy( co_code, (u8*)&(pakstate->company_code), 2);
    bcopy( game_code, (u8*)&(pakstate->game_code), 4);
    
}

/*
 ****************************************************************
 *	ѥåäƤ뤫åؿ
 ****************************************************************
 */
extern int sCPk_PakOpen(
    sCPk_pkf_c	*pakf,
    int		pakno
    ){
    
    OSMesgQueue	*Q;
    int		err;
    int		ret = 0;

    /** ꥢåθ */
    Q = padmgr_LockSerialMesgQ( );

    err = (int)( osPfsInitPak( Q, &(pakf->pfs), pakno ));

    if( !err ){	/** ｪλʤ 1֤ */
	ret = 1;
    }

    /* ȥѥåʳˡϡŪ˲줿ȥѥå
       ޤޤΤǡξϣɣ˲֤ */
    if (err == PFS_ERR_DEVICE) {
	/* ưѥåǣ¥ѥåǤʤΤ
	   ϡŪ˲줿ȥѥåȤߤʤ */
	if (osMotorInit(Q, &(pakf->pfs), pakno) &&
	    osGbpakInit(Q, &(pakf->pfs), pakno)) {
	    err = PFS_ERR_ID_FATAL;
	}
    }
    pakf->error = (s32)err;
    /** ꥢåθ */
    padmgr_UnlockSerialMesgQ( Q );

    return  ret;
}

/*
 ****************************************************************
 *	ѥåζΰåؿ
 ****************************************************************
 */
extern s32 sCPk_PakFreeArea(
    sCPk_pkf_c	*pakf
    ){

    s32              rest_s;

    pakf->error = osPfsFreeBlocks( &(pakf->pfs), &rest_s ); 
    
    return  (s32)(rest_s);
    
}

/*
 ******************************************************************************
 *
 ******************************************************************************
 */
#if 0
/*
** Τɤ줫뤫 ** */
int  findFileMemPakExtAlfa( OSMesgQueue *serialLockMsgQ, int pakno,
			    u8 start, u8 end ){

    OSMesgQueue	*Q;
    int		err, ret = 0, msk = 1;
    u8          /*pat,*/ c;

    (void)pakno;
    Q = mPd_LockSerialMesgQ();
    for(c = start; c <= end; c++){
	ext_name[0] = (unchar)(ABC(c));
	err = (int)osPfsFindFile(&pfs_y, company_code, game_code,
			(u8 *)game_name, (u8 *)ext_name, &(fileno[c - 'A']));
	if(!err)     ret |= msk;
	else         fileno[c - 'A'] = NOTSET;
	msk <<= 1;

    }
    padmgr_UnlockSerialMesgQ( Q);

    return  ret;
}
#endif

/*
 ****************************************************************
 *	ѥå񤭹ߴؿ
 ****************************************************************
 */
extern int sCPk_Save(
    sCPk_pkf_c	*pakf,
    int		offset_byt,
    int		size,
    u8		*data
    ){
    
    int		err;
    int		w_size;
    int		ret = 0;	/** 顼åѥե饰 1:ｪλ */

#if 0
    /** ֥ 32Хȥ饤 */
    w_size = ( int )(( size + 31 ) & ((int)0xffffffe0));
#endif

#if 0
    err = (int)( osPfsReadWriteFile( &(pakf->pfs), pakf->file_no, PFS_WRITE, offset_byt, w_size, data ));
#else
    if (GETHREG(17) == 0) {
        w_size = 280 * 32;
    } else {
        w_size = GETHREG(17) * 32;
    }
    do {
        if (w_size > size)
            w_size = size;
        PRINTF5("sCPk_Load %08x %08x %08x %08x %lu\n", offset_byt, data, size, w_size, graph_live_ms);
        err = (int)( osPfsReadWriteFile( &(pakf->pfs), pakf->file_no, PFS_WRITE, offset_byt, w_size, data ));
        offset_byt += w_size;
        data +=  w_size;
        size -= w_size;
        graph_live_ms = utGetTime_ms(); /* Ƥ */
    } while (size > 0 && err == 0);
#endif
    
    if(!err)    ret = 1;
    pakf->error = (s32)err;

    return  ret;
}

/*
 ****************************************************************
 *	ѥåɤ߹ߴؿ
 ****************************************************************
 */
extern int sCPk_Load(
    sCPk_pkf_c	*pakf,
    int		offset_byt,
    int		size,
    u8		*data
    ){
    
    int		err;
    int		w_size;
    int		ret = 0;	/** 顼åѥե饰 1: ｪλ */
    
#if 0
    /** ֥Υ饤 */
    w_size = ( int )(( size + 31 ) & ((int)0xffffffe0));
#endif
    
#if 0
    err = (int)( osPfsReadWriteFile( &(pakf->pfs), pakf->file_no, PFS_READ, offset_byt, w_size, data));
#else
    if (GETHREG(17) == 0) {
        w_size = 280 * 32;
    } else {
        w_size = GETHREG(17) * 32;
    }
    do {
        if (w_size > size)
            w_size = size;
        PRINTF5("sCPk_Load %08x %08x %08x %08x %lu\n", offset_byt, data, size, w_size, graph_live_ms);
        err = (int)( osPfsReadWriteFile( &(pakf->pfs), pakf->file_no, PFS_READ, offset_byt, w_size, data));
        offset_byt += w_size;
        data +=  w_size;
        size -= w_size;
        graph_live_ms = utGetTime_ms(); /* Ƥ */
    } while (size > 0 && err == 0);
#endif
    if(!err)    ret = 1;
    pakf->error = (s32)err;

    return  ret;
}


/*
 ****************************************************************
 *	ΡȤκؿ
 ****************************************************************
 */
extern int sCPk_MakeFile(
    sCPk_pkf_c	*pakf,
    OSPfsState	*pak_state,
    int		size
    ){
    
    int		err;
    int		ret = 0;
    s32		rest_size;
    int		all_size;

    /** Υ饤 */
    all_size = ( int )(( size + 255 ) & ((int)0xffffff00) );

    /** ΰμ */
    rest_size = sCPk_PakFreeArea( pakf );
    if(( int )rest_size < all_size ){
	return ret;
    }

    err = (int)osPfsAllocateFile( &(pakf->pfs),
				  pak_state->company_code,
				  pak_state->game_code,
				  (u8 *)( pak_state->game_name ),
				  (u8 *)( pak_state->ext_name ),
				  all_size,
				  &(pakf->file_no));
    if(!err)  ret = 1;
    pakf->error = (s32)err;
    
    return  ret;
}

/*
 ****************************************************************
 *	ΡȤΥץؿ
 *
 *  	in	: 
 *	out	:
 *	֤	: 0 ۾ｪλ
 *		  1 ｪλ
 ****************************************************************
 */
extern int sCPk_FileOpen(
    sCPk_pkf_c	*pakf,
    OSPfsState	*pak_state
    ){

    s32		err;
    int		ret = 0;

    err = osPfsFindFile( &(pakf->pfs),
			 pak_state->company_code,
			 pak_state->game_code,
			 (u8 *)( pak_state->game_name ),
			 (u8 *)( pak_state->ext_name ), &pakf->file_no );
    pakf->error = err;
    if( !err ) ret = 1;

    return ret;
}

/*
 ****************************************************************
 *	ΡȤξõؿ
 ****************************************************************
 */
extern int sCPk_DeleteFile(
    sCPk_pkf_c	*pakf, 
    OSPfsState	*pak_state
    ){
    
    s32		err;
    int		ret = 0;

    err = osPfsDeleteFile( &(pakf->pfs), pak_state->company_code,
			   pak_state->game_code,
			   (u8 *)( pak_state->game_name ),
			   (u8 *)( pak_state->ext_name ));
    if(!err)    ret = 1;
    pakf->error = err;

    return  ret;
}

/*
 ****************************************************************
 *	ΡȤΥơ֤ؿ
 ****************************************************************
 */
extern u32 sCPk_FileState(
    sCPk_pkf_c	*pakf,
    OSPfsState	*pak_state
    ){

    s32		err;

    err = osPfsFileState( &(pakf->pfs), pakf->file_no, pak_state );
    pakf->error = err;
    
    if( err )   return  0;
    return  pak_state->file_size;
}

/*
 ****************************************************************
 *	ȥѥåκΡȿȻѥΡȿμؿ
 ****************************************************************
 */
extern int sCPk_FileNum(
    sCPk_pkf_c	*pakf,
    s32		*max_files,
    s32		*files_used
    ){

    s32		err;
    int		ret = 0;

    err = osPfsNumFiles( &(pakf->pfs), max_files, files_used );

    if( !err ) ret = 1;
    pakf->error = err;

    return ret;
}

/*
 ****************************************************************
 *	ѥåΥե륷ƥνؿ
 ****************************************************************
 */
extern int sCPk_RepairID(
    sCPk_pkf_c	*pakf
    ){

    s32		err;
    int		ret = 0;

    err = osPfsRepairId( &(pakf->pfs) );
    if( !err ) ret = 1;
    pakf->error = err;

    return ret;
}


/*
 ------------------------------------------------------------------------------
 *			ѥåХå饦ɽ
 ------------------------------------------------------------------------------
 */
#if 0
#include "stackcheck.h"
#include "ThreadID.h"
#include "ThreadPriority.h"

/** ѥååѥå */
/** ΤȤ ( Ŭ )ȤäƤޤ */
#define sCPk_PAK_STACKSIZE (4096)

static u64      sCPk_pakStack[sCPk_PAK_STACKSIZE / sizeof(u64)];
StackCheckDecl(sCPk_pak);
OSThread	sCPk_pak_thread; /* åɹ¤ */

typedef enum cpak_thread_command{
    PAK_CMD_NOP,
    PAK_CMD_WRITE,
    PAK_CMD_READ,
    PAK_CMD_MAX
} pak_cmd_e;

typedef struct {
    pak_cmd_e	cmd;
    s32		status;
    sCPk_pkf_c	*pakf_p;
    unchar	*buf_p;
    int		offset_byt;
    int		size;
    OSMesgQueue statusQ;
    OSMesg	statusBuf;
    void	*stackP;
} sCPk_cmd_c;

static sCPk_cmd_c	l_pak_cmd;

/*
 ****************************************************************
 *	ѥååɥᥤؿ
 ****************************************************************
 */
static void sCPk_pak_main_proc(
    sCPk_cmd_c	*cmd_p
    ){

#if	DEBUG
    PRINTF("ѥååɳ\n");
#endif	/** DEBUG end */

    switch( cmd_p->cmd ){
	case PAK_CMD_WRITE :	/** 񤭹 */
	    
	    cmd_p->status = (s32)sCPk_Save( cmd_p->pakf_p,
					    cmd_p->offset_byt,
					    cmd_p->size,
					    cmd_p->buf_p );
	    osSendMesg( &cmd_p->statusQ,
			(OSMesg)cmd_p->status,
			OS_MESG_BLOCK );
	    break;
	case PAK_CMD_READ :	/** ɤ߹ */
	    cmd_p->status = (s32)sCPk_Load( cmd_p->pakf_p,
					    cmd_p->offset_byt,
					    cmd_p->size,
					    cmd_p->buf_p );
	    osSendMesg( &cmd_p->statusQ,
			(OSMesg)cmd_p->status,
			OS_MESG_BLOCK );
	    break;
	default :
	    break;
    }
}

/*
 ****************************************************************
 *	̥åɤǽ񤭹߳
 ****************************************************************
 */
extern void sCPk_Save_bg(
    sCPk_pkf_c *const	pakf_p,
    int const		offset_byt,
    int const		size,
    u8 *const		data_p
    ){

    sCPk_cmd_c	*cmd_p = &l_pak_cmd;

    cmd_p->cmd = PAK_CMD_WRITE;
    cmd_p->pakf_p = pakf_p;
    cmd_p->buf_p = data_p;
    cmd_p->size = size;
    cmd_p->offset_byt = offset_byt;
    
    osCreateMesgQueue( &cmd_p->statusQ, &cmd_p->statusBuf, 1 );
    
    StackCheckInit(sCPk_pak);
    osCreateThread(
	&sCPk_pak_thread,
	THREAD_ID_SYS_CPAK,
	(void (*)(void *))sCPk_pak_main_proc,
	(void *)cmd_p,
	(void *)(sCPk_pakStack + sCPk_PAK_STACKSIZE / sizeof(u64)),
	PRIORITY_SYS_CPAK
	);
    osStartThread(&sCPk_pak_thread);
}

/*
 ****************************************************************
 *	񤭹߽λå
 *
 *	λ		1
 *			0
 *	ѥåʤ	-1
 ****************************************************************
 */
extern s32 sCPk_PakWrite_isFinished( void ){
    
    sCPk_cmd_c *cmd_p = &l_pak_cmd;

    /** ѥåޤäƤʤ */
    if( padmgr_CheckConectPak(0) == 0 ){
	return -1;
    }
    return (s32)MQ_IS_FULL(&cmd_p->statusQ);
}

/*
 ****************************************************************
 *	̥åɸ
 ****************************************************************
 */
extern s32 sCPk_Pak_sync( void ){
    
    sCPk_cmd_c *cmd_p = &l_pak_cmd;
    
    osRecvMesg(&cmd_p->statusQ, NULL, OS_MESG_BLOCK);

    osDestroyThread(&sCPk_pak_thread);
    StackCheckCheckStack(sCPk_pak);
    StackCheckCleanup(sCPk_pak);

    return cmd_p->status;
}

/*
 ******************************************
 *	FGǽ񤭹 ( ϡλ )
 ******************************************
 */
extern s32 sCPk_Save_fg(
    sCPk_pkf_c *const	pakf_p,
    int const		offset_byt,
    int const		size,
    u8 *const		data_p
    ){
    
    sCPk_Save_bg( pakf_p, offset_byt, size, data_p );
    while( sCPk_PakWrite_isFinished( ) == 0 );
    return sCPk_Pak_sync( );
}

/*
 ****************************************************************
 *	ѥåХåɥơ
 ****************************************************************
 */
extern s32 mCPk_GetPakCommandStatus( void ){
    
    return l_pak_cmd.status;
}
#endif
