/*
  *****************************************************************************
  
  	File :		s_flashrom.h
  	Programer :	Gentaro Takaki
  
	$Id: s_flashrom.h,v 3.1 2001-03-13 18:19:23+09 forest Exp $
	
  *****************************************************************************
*/

#ifndef	S_FLASHROM_H_INCLUDED
#define	S_FLASHROM_H_INCLUDED

#if	defined(LANGUAGE_C) || defined(_LANGUAGE_C_PLUS_PLUS)

#ifdef	_LANGUAGE_C_PLUS_PLUS
extern "C" {
#endif


/** 1ڡ(  )ʬΥХȿ */
#define	sFRm_PAGE_BYTE		(128)
    
/*
  *****************************************************************************
  	 FlashRomؿ

  	   in	: ʤ

	   out	: ʤ

	   ֤	: ʤ
  ----------------------------------------------------------------------------
	() ... FlashromѤɬ٤δؿ¹ԤƤ.
  *****************************************************************************
  */
extern int sFRm_FlashRomInit( void );

/*
  *****************************************************************************
	 եåबͭɤ
	
	   ֤	: !0 ͭ / 0 ̵
  *****************************************************************************
 */
extern s32 sFRm_FlashisAvailable( void );


/*
  *****************************************************************************
  	 ꤷޤ 16KХȥХΰΥǡõؿ
  
  	   in	: ֹ (u32)

	   out	: ʤ

	   ֤	: 0 ｪλ / -1 ۾ｪλ
  ----------------------------------------------------------------------------
	() ... FlashRomǤϥñ( = 128Х )ǤξõϤǤޤ.
		     ɬ, ꤷޤ 16KХȥХΰ褹٤Ƥ
		     ǡõޤ. ( 㤨,  0x003ꤷ
		     ,  0x000  0x07fΥǡ٤Ƥõޤ )

		     FlashRomؤΥν񤭹ߤԤݤˤ, ɬδؿ
		     ,  ( 񤭹ߤԤ )ΰΥǡõƤ
		     ɬפޤ. ɤ߹ߤκݤˤɬפޤ.
  *****************************************************************************
 */
extern s32 sFRm_FlashArrayErase(
    u32	sector_num	/** ֹ */
    );

/*
  *****************************************************************************
  	 ꤷޤ 16KХȥХΰΥǡõؿ
  
  	   in	: ʤ

	   out	: ʤ

	   ֤	: 0 ｪλ / -1 ۾ｪλ
  ----------------------------------------------------------------------------
  *****************************************************************************
 */
extern s32 sFRm_FlashAllErase(
    void
    );

/*
  *****************************************************************************
  	 1M FLASHROMλꤷؤ 128ХȤΥǡν񤭹ߴؿ
  
  	   in	: 񤭹ѥХåե (u32 *) ... 128Х
	   	  ֹ (u32)

	   out	: ʤ

	   ֤	: 0 ｪλ / -1 ۾ｪλ
  ----------------------------------------------------------------------------
	() ... δؿǥؤΥǡν񤭹ߤԤ, ɬ
		     ˳ΰΥǡξõԤäƤ.
		     ǡξõˤ sFRm_FlashArrayEraseѤƤ.

		     񤭹ߥ 1 = 128ХȤǤ.
		      0x1ff 0x3ff, Ⱦ 64ХȤΥǡɤ߹
		     ߤޤΤ, ΰɬפʥǡ
		     񤭹ळȤ϶ػߤޤ.
  *****************************************************************************
 */
extern s32 sFRm_FlashWriteSector(
    u32 *buf,		/** 񤭹ѥХåե (  128Х ) */
    u32 sector_num	/** ֹ */
    );


/*
  *****************************************************************************
  	 ꤷޤ 16KХȤΰξõǡν񤭹ߴؿ

  	   in	: 񤭹ѥХåե (u32 *) ... 16KХ
	   	  ֹ (u32) ... 128ܿ
		  񤭹ڡ(32) ... 1  128
		  
	   out	: ʤ

	   ֤	: 0 ｪλ / -1 ۾ｪλ / 1 ֹ
  ----------------------------------------------------------------------------
	() ... FlashRomϥǡν񤭹߻, 񤭹ߤԤ
		      16KХȤΰõɬפޤ. Τ,
		     FlashRomؤν񤭹ߤ 16KХñ̤ǹԤޤ.
		     
		     ֹˤ, 128ܿ ( 0ޤ )ꤷƤ.
		     ꤷֹޤ 16KХȥХΥǡ
		     õ񤭹ߤԤޤ.
		     
		     񤭹ߥ 16KХȤǤ.
		     ֤ͤȤ -1֤ä, PIޥ͡㤬¹Ԥ
		     ʤ, 񤭹ߤ˼ԤƤޤ. ɬ, 
		     PIޥ͡¹ԤƤ.
		     񤭹ߤ˼Ԥ, Ʊǡν񤭹ߤ 4
		     ƽ񤭹ߤƤޤ.
		     1֤ä, ֹλְ꤬äƤޤ.
		     128ܿǻꤷƤ.
  *****************************************************************************
  */
extern s32 sFRm_FlashWriteArray(
    u32 *buf,		/** 񤭹ѥХåե (  16KХ ) */
    u32 sector_num,	/** ֹ ( 128ܿǻ ) */
    u32	page_n		/** 񤭹ڡ( 1  128 ) */
    );

/*
  *****************************************************************************
  	 ꤷΥǡɤ߹ߴؿ

  	   in	: ֹ (u32)

	   out	: ɤ߹ѥХåե (u32 *) ...  128Х

	   ֤	: 0 ｪλ / -1 ۾ｪλ
  ----------------------------------------------------------------------------
	() ... ֤ͤȤ -1֤ä, PIޥ͡㤬¹Ԥ
		     ޤ. ɬ,  PIޥ͡¹ԤƤ.
		     ʳǤ, osSendMesg osJamMesgΤɤ餫Υơ
		     ֤ޤ.
		     
		     ɤ߹ߥ 1 = 128ХȤǤ.
		     ֹ 0x1ff 0x3ff˴ؤƤΤ, ǡȾʬ
		     (64Х) ɤ߹߽ޤΤդƤ
		     .
  *****************************************************************************
  */
extern s32 sFRm_FlashReadSector(
    u32 *buf,		/** ɤ߹ѥХåե (  128Х ) */
    u32 sector_num	/** ֹ */
    );

/*
  *****************************************************************************
  	 ꤷ 16KХʬΥǡɤ߹ؿ
	
  	   in	: ֹ (u32)
		  ɤ߹ڡ(32) ... 1  128

	   out	: ɤ߹ѥХåե (u32 *) ...  16KХ

	   ֤	: 0 ｪλ / -1 ۾ｪλ
  ----------------------------------------------------------------------------
	() ... ֤ͤȤ -1֤ä, PIޥ͡㤬¹Ԥ
		     ޤ. ɬ,  PIޥ͡¹ԤƤ.
		     ʳǤ, osSendMesg osJamMesgΤɤ餫Υơ
		     ֤ޤ.
		     
		     ɤ߹ߥ 1 = 16KХȤǤ.
  *****************************************************************************
 */
extern s32 sFRm_FlashReadArray(
    u32 *buf,		/** ɤ߹ѥХåե (  16KХ ) */
    u32 sector_num,	/** ֹ */
    u32	page_n		/** ɤ߹ڡ */
    );

/*
 ------------------------------------------------------------------------------
 *	եåХåɽ
 ------------------------------------------------------------------------------
 */
/*
 *******************************
 *	̥åɤǽ񤭹߳
 *******************************
 */
extern void sFRm_FlashWriteArray_bg(
    u32		*const buf,
    u32		const sector_num,
    u32		const page_n
    );
/*
 *******************************
 *	񤭹߽λɤ
 *******************************
 */
extern s32 sFRm_FlashWriteArray_isFinished( void );
/*
 ***********************************
 *	̥åɤǽ񤭹߽λ
 ***********************************
 */
extern s32 sFRm_FlashWriteArray_sync( void );
/*
 ******************************************
 *	̥åɤǽ񤭹 ( ϡλ )
 ******************************************
 */
extern s32 sFRm_FlashWriteArray_fg(
    u32	*const buf,
    u32	const sector_num,
    u32	const page_n
    );
 
/*
 ****************************************************************
 *	եåॹơ
 ****************************************************************
 */
extern s32 sFRm_GetFlashStatus( void );

#ifdef	_LANGUAGE_C_PLUS_PLUS
}
#endif

#endif	/** defined(LANGUAGE_C) || defined(_LANGUAGE_C_PLUS_PLUS) */
#endif	/** S_FLASHROM_H_INCLUDED */

    
