;******************* BGunit_set.asm *************************
;
			extend
;-----------------------------------------------------
			include		../../kimura/join/rp5c77
			include		../../kimura/join/buffer.def
			include		../../kimura/join/rp5a22
			include     ../join/work.def
;-----------------------------------------------------
			ext		Set_debugmap
			glb		Set_BG_item
;-----------------------------------------------------
			COMN
s.l_bup		DS		2
yakidat		DS		2
witcnt		DS		2
lthcnt		DS		2
vradd		DS		2
vradd1		DS		2
pt_cnt		DS		2	
addr		DS		3
addr1		DS		3		
witcnt1		DS		2
;-----------------------------------------------------
bank84			sect	rel			;(PBR=81)
;-----------------------------------------------------
BG_chra				equ		1800h
;;;;;;screen_buffer		EQU		7F0000H 
BGunit_buffer		EQU		307000H
;;;;;;;;;rom data ;;;;;;;;;;;;;
ROM_data		equ		85d000h
;-----------------------------------------------------
Set_BG_item		lda		<game_selecta			;editer race check.
				cmp		#10h
				bcc		start				;edit?:yes-->start.
				RTL
;-----------------------------------------------------
start			PHB	
				PHK
				PLB
;------------------------------------------------------
;(BANK & ADDRESS SET)			
				lda		<game_status
				cmp		#0004
				bne		vramset
				PLB
				RTL
;
vramset			mem16							;mapnumber check.
				rep		#00100000b
				lda     map_number
				xba
				lsr		a
				sta		<addr1
;
				lda		rom_checker
				beq		read_rom
				lda		#BGunit_buffer&0ffffh	;backup ram LOW set.
				jmp		Set_addr1
;
read_rom		lda     #ROM_data&0ffffh
Set_addr1		clc
				adc		<addr1
				sta		<addr1
;
buffer_setl		lda		#screen_buffer&0ffffh	;buffer LOW set.
				sta		<addr
;-------------------------------------------------
				mem8
				sep		#00100000b
;
				lda		#screen_buffer/65536	;buffer HI set.
				sta		<addr+2
;
				lda		rom_checker
				beq		read_rom11
;
				lda		#BGunit_buffer/65536	;;backup ram HI set.
				jmp		Set_addr2
read_rom11		lda     #ROM_data/65536
Set_addr2		sta		<addr1+2
;<<<<<<<<<<<<<<<<<< CjV@Zbg >>>>>>>>>>>>>>>>
set_initial		stz		<s.l_bup			
				stz		<s.l_bup+1
				stz		<yakidat
				stz		<yakidat+1
				ldx		#0
loop_Z_chra		stz		BG_chra,x
				inx
				cpx		#0020h
				bne		loop_Z_chra
setvram			mem16
				rep		#00100000b
				stz		<witcnt1
				stz		<pt_cnt
				stz		<witcnt
				stz		<lthcnt
;<<<<<<<<<<<<<< ubt@[ AhXZbg >>>>>>>>>>>>>>
				ldy		<s.l_bup				;back up ram counter.		
				iny
				lda		[<addr1],y
				cmp		#0ffffh
				beq		owari_M8
				sta		vradd					;address set.
				iny
;<<<<<<<<<<<<<<< jbgf[^[Zbg >>>>>>>>>>>>>>>
				mem8
				sep		#00100000b
				dey
				dey		
				lda     [<addr1],y
				sta		<yakidat				;yakidata set.
				iny
				iny
				iny
				sty		<s.l_bup
;<<<<<<<<<<<<<< jbgf[^[Zbg >>>>>>>>>>>>>>>>
;(BG CHARACTER DATA SET)
				mem16
				idx16
				rep		#00110000b
;
				ldx		#0				
				lda		<yakidat		
				and		#00111111b				;yaki number set.
				asl		a
				tay
;
				lda		YAKI_NO,y
				tay
				mem8
				sep		#00100000b
loop_M5			lda		!0,y					;character number set.
				sta		BG_chra,x				;set to 0page.
				iny								;character number inc.
				inx
				cpx		#0020h					;5?:no-->loop_M5
				bne		loop_M5
;<<<<<<<<<<<<<<<< p^[f[^[Zbg >>>>>>>>>>>>>>>
;(PATERN SET)
ptaset			mem16
				rep		#00100000b
				lda		<yakidat		
				and		#11000000b				;patern data set.
				lsr		a
				lsr		a
				lsr		a
				lsr		a
				lsr		a
				tay
				mem8
				sep		#00100000b
				lda		PTADAT,y
				sta		<witcnt					;width counter set.
				iny
				lda     PTADAT,y				;length countr set.
				sta		<lthcnt
;<<<<<<<<<<<< jbgf[^[obt@[Zbg >>>>>>>>>>>
				ldx		#0
set_buffer		ldy		<vradd					;address set.
loop_850		lda		BG_chra,x				;character set.
				cmp		#0ffh
				beq		No_unit_set
				sta		[<addr],y				;to 7f0000h.
No_unit_set		iny
				inx		
				lda		<witcnt1
				inc		a
				sta		<witcnt1						
				cmp     <witcnt					;width?:no-->loop_850
				bne		loop_850
;
				stz		<witcnt1					;widcnt add.
;
				lda		<pt_cnt					;length counter check.
				inc		a
				cmp		<lthcnt					;length?:yes-->setvram
				beq		setvram
				sta		<pt_cnt
;
				mem16
				rep		#00100000b
				lda		<vradd					;address add.
				clc
				adc		#80h
				sta		<vradd
				mem8
				sep		#00100000b
				jmp		set_buffer
;
owari_M8		idx16
				mem16
				rep		#00110000b
				plb
;
				JSL		>Set_debugmap
				RTL
	
;--------------------------------------------------------------------
;
YAKI_NO		DW		Hatena_0,Hatena_1,Hatena_2,Hatena_3
			DW		Niko_0,Niko_1,Niko_2,Niko_3
			DW		Arow_0,Arow_1,Arow_2,Arow_3
			DW		Kabe_0,Kabe_0,Kabe_0,Kabe_0
			DW		Oil_0,Oil_0,Oil_0,Oil_0
			DW		JmpW_0,JmpW_0,JmpW_0,JmpW_0
			DW		JmpL_0,JmpL_0,JmpL_0,JmpL_0
			DW		Coin_0,Coin_0,Coin_0,Coin_0
			DW      Coin_1,Coin_1,Coin_1,Coin_1
			DW      Coin_2,Coin_2,Coin_2,Coin_2
			DW      Coin_3,Coin_3,Coin_3,Coin_3
			DW      Coin_4,Coin_4,Coin_4,Coin_4
			DW      Coin_5,Coin_5,Coin_5,Coin_5
			DW      Coin_6,Coin_6,Coin_6,Coin_6
;
Hatena_0	DB		0c0h,0c1h,0c2h,0c3h
Hatena_1    DB      0c4h,0c5h,0c6h,0c7h
Hatena_2    DB      0c8h,0c9h,0cah,0cbh
Hatena_3    DB      0cch,0cdh,0ceh,0cfh
;
Niko_0		DB		0d0h,0d1h,0d2h,0d3h
Niko_1      DB      0d4h,0d5h,0d6h,0d7h
Niko_2      DB      0d8h,0d9h,0dah,0dbh
Niko_3      DB      0dch,0ddh,0deh,0dfh
;
Arow_0		DB		0e0h,0e1h,0e2h,0e3h
Arow_1      DB      0e4h,0e5h,0e6h,0e7h
Arow_2      DB      0e8h,0e9h,0eah,0ebh
Arow_3      DB      0ech,0edh,0eeh,0efh
;
Kabe_0		DB		0f0h,0f1h,0f2h,0f3h
;
Oil_0		DB		0fah,0fbh,0fch,0fdh
;
JmpW_0		DB		0f4h,0f5h,0f6h
;
JmpL_0		DB		0f7h,0f8h,0f9h
;
Coin_0		DB		0ffh,0ffh,0feh,0ffh,0ffh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0feh,0ffh,0feh,0ffh,0feh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0ffh,0ffh,0feh,0ffh,0ffh
;
Coin_1		DB		0feh,0ffh,0ffh,0ffh,0feh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0ffh,0ffh,0feh,0ffh,0ffh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0feh,0ffh,0ffh,0ffh,0feh
;
Coin_2		DB		0ffh,0ffh,0ffh,0ffh,0feh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0ffh,0ffh,0feh,0ffh,0ffh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0feh,0ffh,0ffh,0ffh,0ffh
;
Coin_3		DB		0feh,0ffh,0ffh,0ffh,0ffh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0ffh,0ffh,0feh,0ffh,0ffh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0ffh,0ffh,0ffh,0ffh,0feh
;
Coin_4		DB		0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0feh,0ffh,0feh,0ffh,0feh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
;
Coin_5		DB		0ffh,0ffh,0feh,0ffh,0ffh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0ffh,0ffh,0feh,0ffh,0ffh
			DB      0ffh,0ffh,0ffh,0ffh,0ffh
			DB      0ffh,0ffh,0feh,0ffh,0ffh
;
Coin_6		DB		0feh,0ffh,0ffh
;
PTADAT		byte	02h,02h,03h,01h,01h,03h,05h,05h								;patern counter.


				END
