DEBUG_CURSOR	EQU	0B0H		; n`l̃ItZbg
;*********************************************************************
;	MARIO KART << DEBUG RAM EDITER >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
;----------------------------------------------------------------------
		GLB	RAM_editer_A,RAM_editer_B
		GLB	First_debug,Main_debug
		GLB	debug_FLAG,debug_powON
;----------------------------------------------------------------------
		COMN
temporary	DS	1
work		DS	2
addr		DS	4
temp		DS	4
offset_Vpos	DS	2
offset_addr	DS	2
turbo		DS	1
;----------------------------------------------------------------------
;		ORG	Debug_value
;repeat		DS	1	;1F00H
;debug_cursor	DS	1	;1F01H	
;debug_address	DS	4	;1F02H	
;debug_FLAG	DS	1	;1F06H	
;debug_powON	DS	2	;1F07H
;edit_h		DS	1	;1F09H	
;edit_v		DS	1	;1F0AH
;edit_write	DS	1	;1F0BH
;repeat2	DS	1	;1F0CH
;debug_frame	DS	1	;1F0DH
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
repeat		EQU	Debug_value+00h		;1F00H
debug_cursor	EQU	Debug_value+01h		;1F01H	
debug_address	EQU	Debug_value+02h		;1F02H	
debug_FLAG	EQU	Debug_value+06h		;1F06H	
debug_powON	EQU	Debug_value+07h		;1F07H
edit_h		EQU	Debug_value+09h		;1F09H	
edit_v		EQU	Debug_value+0Ah		;1F0AH
edit_write	EQU	Debug_value+0Bh		;1F0BH
repeat2		EQU	Debug_value+0Ch		;1F0CH
debug_frame	EQU	Debug_value+0Dh		;1F0DH
;######################################################################
;		RAM EDITER
;######################################################################
;**********************************************************************
;		INITIAL
;**********************************************************************
debug_work	EQU	meter_screen_A+4	; meter buffer
number_clear	EQU	09AH			; number character CLEAR
number_char_BG	EQU	0A0H			; number character SET
;-----------------------------------------------------------------------
;	debug FLAG	YXZP QRBA	X = 1	debug ON
;					Y = 1	[^[ ON
;					Z = 1	RAM EDITER MODE
;					A = 1	RAM read enable
;					B = 1	RAM write enable
;					P = 1	ITEM DEBUG
;					Q = 1	realtime RAMedit
;					R = 1 	goalin edit mode
;-----------------------------------------------------------------------
ON_usemeter	EQU	10000000B
ON_debugmode	EQU	01000000B
ON_ramedit	EQU	00100000B
ON_debugitem	EQU	00010000B
ON_realtime	EQU	00001000B
ON_goaldebug	EQU	00000100B
;-----------------------------------------------------------------------
	
		EXTEND
objdata	SECT	REL
		mem16
		idx16
	
First_debug	
	;;;	LDA	#6917H			;W
	;;;	CMP	!debug_powON		;W
	;;;	BEQ	exit_debug		;W
	;;;	STA	!debug_powON		;W

		STZ	!edit_h			;W	h,v
		SEP	#00100000B
		MEM8
		STZ	!debug_address+0	;B	address reset
		STZ	!debug_address+1	;B
		STZ	!debug_address+2	;B
		STZ	!repeat			;B
		LDA	#5			;B
		STA	!debug_cursor		;B	cursor reset
		STZ	!debug_FLAG		;B	flag reset
		REP	#00100000B
		MEM16
exit_debug	RTL

Main_debug
Field_debug	
		lda	!rom_checker
		beq	exit$

	;	lda	<SEQ_register
	;	cmp	#8
	;	beq	exit$

		jsl	>main_entry

exit$		rtl

		EXTEND
editer		SECT	REL
		mem16
		idx16
;**********************************************************************
;		MAIN
;**********************************************************************
debug_sprite	DW	debug_work+20		; data(word)
		DW	debug_work+18
		DW	debug_work+16
		DW	debug_work+14
		DW	debug_work+10		; bank
		DW	debug_work+8
		DW	debug_work+6		; address H
		DW	debug_work+4
		DW	debug_work+2		; address L
		DW	debug_work+0
;-----------------------------------------------------------------------
debug_mask	DB	00FH,00FH,0F0H,0F0H
;-----------------------------------------------------------------------
debug_data	DB	00FH,001H,0F0H,010H
;-----------------------------------------------------------------------
debug_check	DW	1,1			
		DW	0,0,0,0
debug_load	DW	Load_data,Load_data
		DW	Load_address,Load_address,Load_address
debug_store	DW	Store_data,Store_data
		DW	Store_address,Store_address,Store_address
;-----------------------------------------------------------------------
system_button	DB	0	; GP
		DB	0	; GP-1p
		DB	2	; GP-2p
		DB	0	; VS
		DB	0	; TM-1p
		DB	2	; TM-2p
		DB	0	; battle
;=======================================================================
main_entry	PHB
		PHK
		PLB
		LDA	!debug_address+0	;
		STA	<addr+0			;
		LDA	!debug_address+2	;W(B)
		AND	#00FFH
		STA	<addr+2			;W(B)
		SEP	#00110000B
		MEM8
		IDX8
		INC	!debug_frame
		LDY	<SEQ_register
		LDX	!system_button,Y
		LDY	!debug_FLAG
;-----------------------------------------------------------------------
;====== goalin debug mode ========
		LDA	<button_status+0	;<< AXB.Y >>
		ORA	<button_status+2
		LSR	A
		LSR	A
		LSR	A
		AND	#00011000B
		STA	<0
		LDA	<button_status+1
		ORA	<button_status+3
		ASL	A
		LDA	<button_trigger+1
		ORA	<button_trigger+3
		ROR	A
		AND	#10100000B
		ORA	<0
		CMP	#10111000B
		BNE	skip_1$
		TYA
		EOR	#ON_goaldebug
		TAY
;====== process meter ===========
						; [^
skip_1$
		LDA	<button_status+0	;<< LR.down.select >>
		ORA	<button_status+2
		AND	#00110000B
		BEQ	skip_2$
		LDA	<button_status+1
		ORA	<button_status+3
		AND	#00001000B		; check <down>
		BEQ	skip_2$
		LDA	<button_trigger+1	; check <select>
		ORA	<button_trigger+3
		AND	#00100000B
		BEQ	skip_2$
		TYA
		EOR	#ON_usemeter
		TAY

;====== realtime RAM edit ========

skip_2$		LDA	<button_status+0		
		AND	#00110000B		; <<LR.select>>
		CMP	#00110000B
		BNE	skip$
		LDA	<button_trigger+1	; <<
		AND	#00100000B
		BEQ	skip$
		TYA
		EOR	#ON_realtime
		TAY
skip$

;====== ITEM DEBUG MODE ======
		LDA	<button_status+0		
		ORA	<button_status+2
		AND	#01110000B		; << AXLR >>
		CMP	#01110000B
		BNE	debug_1_skip	
		LDA	<button_trigger+0
		ORA	<button_trigger+2
		BPL	debug_1_skip	
		TYA
		EOR	#ON_debugitem
		TAY
debug_1_skip
		TYA

;=============================
		BIT	#ON_debugitem
		BEQ	debug_1_clear
		LDA	#0C1H
		BRA	debug_1_exit
debug_1_clear	LDA	#number_clear
debug_1_exit	
		STA	!meter_screen_A+48H
		TYA
		BIT	#ON_goaldebug
		BEQ	clear$
		LDA	#0C2H
		BRA	exit$
clear$		LDA	#number_clear
exit$		
		STA	!meter_screen_A+4AH
;=============================
;-----------------------------------------------------------------------
		LDA	<button_status+0	;B check < L or R >
		ORA	<button_status+2
		AND	#00110000B		;B
		BEQ	debug_entry
		LDA	<button_status+1	;B check <down>
		ORA	<button_status+3
		AND	#00000100B		;B
		BEQ	debug_entry
		LDA	<button_trigger+1	;B check <select>
		ORA	<button_trigger+3
		AND	#00100000B
		BEQ	debug_entry
		TYA
		EOR	#ON_debugmode		;B switch ON/OFF
		TAY
;-----------------------------------------------------------------------
debug_entry	TYA
		STA	!debug_FLAG		;B
		AND	#ON_debugmode
		BNE	debug_position
		LDA	#number_clear		;B clear character
		LDX	#16H			;B
clear_loop	STA	!debug_work+0,X		;B
		DEX				;B
		DEX
		BPL	clear_loop
		JMP	debug_exit
;-----------------------------------------------------------------------
debug_position	TYA
		AND	#ON_ramedit
		BEQ	debug_1000
		CLC
		LDA	!edit_write		;B
		BEQ	debug_2000
		SEC
		BRA	debug_2000
;-----------------------------------------------------------------------
debug_1000	LDA	<button_status+0	;B AXLR****
		ORA	<button_status+2
		LDY	!debug_cursor
		CPY	#4			; C flag = write OK
		BCS	debug_1500
		TAY
		LDA	<button_status+1	;B
		ORA	<button_status+3	;B
		ASL	A
		ASL	A
		ASL	A				; C flag = select key
		TYA
		BCS	debug_1500		
		AND	#00110000B
debug_1500	JSR	Repeat
debug_2000	BCC	debug_disp
		BIT	#00110000B		;B --LR****
		BEQ	debug_modify
;
		LDX	!debug_cursor		;B ---R****
		BIT	#00010000B		;B
		BEQ	debug_left
		DEX				;B
		DEX				;B
debug_left	INX				;B
		CPX	#10			;B limit 
		BCS	debug_disp
		STX	!debug_cursor		;B
		BRA	debug_disp
;-----------------------------------------------------------------------
debug_modify	TAX
		TXA
		ASL	A			;B <A> button 
		LDA	!debug_cursor		;B
		ROL	A			;B
		AND	#00000011B		;B
		TAY				;BB
		LDA	!debug_cursor		;B 
		AND	#00001110B		;B 
		TAX				;BB
;		
		LDA	!debug_check,X		;B
		BEQ	pass_modify
		LDA	!debug_FLAG		;B
		AND	#00000010B		;B modify OK ?
		BEQ	debug_disp		;  NO-> exit
pass_modify
		JSR	(!debug_load,X)
		CLC
		STA	<temporary		;B
		ADC	!debug_data,Y		;B
		EOR	<temporary		;B
		AND	!debug_mask,Y		;B
		EOR	<temporary		;B
		JSR	(!debug_store,X)	;
;-------------------------------------------------------------
debug_disp	REP	#00110000B
		MEM16
		IDX16
		JSR	mount_check
		LDY	#0
		LDA	!debug_FLAG
		LSR	A		; read only check
		BCS	debug_mount
debug_nomount	LDA	#1111H		; <- nomount data
		BRA	debug_read	;
debug_mount	LDA	[<addr],Y	;W
debug_read	JSR	Emit_word
		REP	#00110000B
		MEM16
		IDX16
		LDY	#8			;W
		LDA	<addr+0			;W
		JSR	Emit_word
		LDA	<addr+2			;W(B)
		JSR	Emit_byte
		SEP	#00110000B
		MEM8
		IDX8
		LDA	!debug_frame
		AND	#00000110B		;B
		BNE	debug_exit
		LDA	!debug_cursor		;B
		AND	#00001111B		;B
		ASL	A			;B
		TAY				;BB
		REP	#00010000B
		IDX16
		LDX	!debug_sprite,Y		;W
		LDA	#number_clear		;B
		STA	<0,X			;B <- set BG3 buffer
;-----------------------------------------------------------------------
debug_exit	SEP	#00110000B
		MEM8
		IDX8
;-----------------------------------------------------------------------
		LDA	!debug_FLAG
		BIT	#ON_ramedit
		BEQ	debug_end
		LDA	#0AEH
		STA	!debug_work+14
		LDA	#0ADH
		STA	!debug_work+16
		LDA	#0B2H
		STA	!debug_work+18
		LDA	#0BDH
		STA	!debug_work+20
;-----------------------------------------------------------------------
debug_end	REP	#00110000B
		MEM16
		IDX16
		LDA	<addr+0			;W
		STA	!debug_address+0	;W
		LDA	<addr+2			;W(B)
		STA	!debug_address+2	;W(B)
		PLB		;<
		RTL
;**********************************************************************
;		UTILITY
;**********************************************************************
mount_check	REP	#00010000B
		SEP	#00100000B
		MEM8
		IDX16
		LDA	!debug_FLAG	;B
		LDX	<addr+0		;W address
		LDY	<addr+2		;W bank
		BEQ	bank_0_check
		CPY	#30H		; BACKUP RAM
		BEQ	backup_ram
		CPY	#7EH		; BANK 7E
		BEQ	extra_ram7E
		CPY	#7FH		; BANK 7F
		BEQ	extra_ram7F
		CPY	#10H		; ROM LIMIT
		BCS	nomount
;-----------------------------------------------------------------------
bank_X_check	INX			; FFFF		nomount	
		CPX	#8000H+1	; 0000-7FFF	nomount
		BCC	nomount		; 8000-FFFE	read only
		BRA	read_only
;-----------------------------------------------------------------------
bank_0_check	CPX	#44FEH		; 0000-44FF	read write
		BCC	read_write
		CPX	#8000H		; 4500-7FFF	nomount
		BCC	nomount
		BCS	read_only	; 8000-FFFF	read only
;-----------------------------------------------------------------------
extra_ram7F	INX			; (7F)FFFF	nomount
		BEQ	nomount
extra_ram7E	BRA	read_write	; 0000-FFFE	read write
;-----------------------------------------------------------------------
backup_ram	CPX	#5FFFH		; (30) bank
		BCC	nomount
		CPX	#7FFFH		; 6000-7FFE	read only
		BCC	read_only
		BRA	nomount
;-----------------------------------------------------------------------
read_only	AND	#11111100B	;B	
		ORA	#00000001B	;B
		BRA	set_FLAG
read_write	ORA	#00000011B	;B
		BRA	set_FLAG
nomount		AND	#11111100B	;B
set_FLAG	STA	!debug_FLAG	;B
		REP	#00110000B
		MEM16
		IDX16
		RTS
;-----------------------------------------------------------------------
		mem8
		idx8
Repeat		CLC
		TAX				;BB
		BEQ	repeat_store
		SEC
		LDX	!repeat			;B
		BEQ	repeat_step
		CPX	#18			;B
		BCC	repeat_step
		LDX	#15			;B
repeat_step	INX				;B
repeat_store	STX	!repeat			;B
		RTS
;-----------------------------------------------------------------------
Repeat2		CLC
		TAX				;BB
		BEQ	repeat_store2
		SEC
		LDX	!repeat2		;B
		BEQ	repeat_step2
		CPX	#17			;B
		BCC	repeat_step2
		LDX	#15			;B
repeat_step2	INX				;B
repeat_store2	STX	!repeat2		;B
		RTS
;-----------------------------------------------------------------------
		mem16
		idx16
Emit_word	PHA				;>>
		JSR	Emit_byte
		PLA				;<<
		XBA
Emit_byte	PHA				;>>
		JSR	Emit_digit
		PLA				;<<
		LSR	A			;W
		LSR	A			;W
		LSR	A			;W
		LSR	A			;W
Emit_digit	LDX	!debug_sprite,Y		;W
		SEP	#00100000B
		MEM8
		AND	#0FH
		ORA	#number_char_BG
		STA	<0,X			;W
		REP	#00100000B
		MEM16
		INY				;W
		INY				;W
		RTS
;-----------------------------------------------------------------------
		mem8
		idx8
Load_address	PHX				;>
		TXA				;BB
		LSR	A			;B
		TAX				;BB
		LDA	<addr-2,X		;B
		PLX				;<
		RTS
;-----------------------------------------------------------------------
Store_address	PHA				;>
		TXA				;BB
		LSR	A			;B
		TAX				;BB
		PLA				;<
		STA	<addr-2,X		;B
		RTS
;-----------------------------------------------------------------------
Load_data	PHY				;>
		TXA				;BB
		LSR	A			;B
		AND	#00000001B		;B
		TAY				;BB
		LDA	[<addr],Y		;B
		PLY				;<
		RTS
;-----------------------------------------------------------------------
Store_data	PHA			;>
		TXA			;BB
		LSR	A		;B
		AND	#00000001B	;B
		TAY			;BB
		PLA			;<
		STA	[<addr],Y	;B
store_exit	RTS
;-----------------------------------------------------------------------
		mem16
		idx16
;######################################################################
;		RAM WATCH
;######################################################################
;*********************************************************************
;		RAM edit cursol
;*********************************************************************
move_cursol
		SEP	#00110000B
		MEM8
		IDX8
		STZ	!edit_write+0	;B
		LDA	!debug_FLAG
		AND	#ON_ramedit
		BNE	move_entry
		REP	#00110000B
		MEM16
		IDX16
		RTS
;
		mem8
		idx8
move_entry	
		LDY	<SEQ_register
		LDX	!system_button,Y
		PHX				;>
		LDA	<button_status+1
		ORA	<button_status+3
		STA	<turbo
		AND	#00001111B		
		JSR	Repeat
		REP	#00010000B
		IDX16
		LDX	#0
		BCC	skip_move
		LSR	A
		BCC	left_move
;------------------------------------------------
right_move	LDA	!edit_h
		INC	A
		CMP	#10H
		BCS	skip_move
		STA	!edit_h
		AND	#011B
		BNE	skip_move
		LDX	#2		
		BRA	skip_move
;------------------------------------------------
left_move	LSR	A
		BCC	down_move
		LDA	!edit_h
		DEC	A
		BMI	check_00
		STA	!edit_h
		AND	#011B
		CMP	#011B
		BNE	skip_move
		LDX	#-2		
		BRA	skip_move
check_00	LDA	!debug_address+0
		BIT	#0111B
		BEQ	skip_move
		AND	#0F8H
		STA	!debug_address+0
		BRA	skip_move
;------------------------------------------------
down_move	LSR	A
		BCC	up_move
		LDX	#8
		LDA	!edit_v
		INC	A
		CMP	#4
		BCS	down_next
		STA	!edit_v		
		BRA	skip_move
down_next	BIT	<turbo
		BVC	skip_move
		LDX	#108H		
		BRA	skip_move
;------------------------------------------------
up_move		LSR	A
		BCC	skip_move
		LDX	#-8
		LDA	!edit_v
		DEC	A
		BMI	up_next
		STA	!edit_v		
		BRA	skip_move
up_next		BIT	<turbo
		BVC	skip_move
		LDX	#-108H
;------------------------------------------------
skip_move	REP	#00100001B
		MEM16
		TXA
		ADC	!debug_address
		STA	!debug_address
;------------------------------------------------
		SEP	#00110000B
		MEM8
		IDX8
		LDA	!edit_h
		AND	#03H			
		EOR	#03H
		STA	!debug_cursor
		PLX				;<
;;
		LDA	<button_status+0
		ORA	<button_status+2
		AND	#11000000B
		JSR	Repeat2
		BCS	skip$
		LDA	#0
skip$		AND	#11000000B
		STA	!edit_write
		REP	#00110000B
		MEM16
		IDX16
		RTS
;----------------------------------------------------------------------
set_cursol
		SEP	#00100000B
		MEM8
		LDA	!edit_v
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	!edit_h
		ASL	A
		ASL	A
		REP	#00100001B
		MEM16
		AND	#00FFH
		ADC	#DEBUG_CURSOR
		ADC	<screen_oam
		TAX
;
		LDA	!debug_frame
		AND	#01000B
		BEQ	no_flash
		LDA	#0E0E0H
		STA	<sprite_H,X
;
no_flash	RTS
;*********************************************************************
;		Screen RAM watch editer
;*********************************************************************
VP	EQU	09000H-7000H
;----------------------------------------------------------------------
position_data0	DW	VP+00020H
		DW	VP+00920H
		DW	VP+01220H
		DW	VP+01B20H,0
position_data1	DW	VP+0004EH,VP+00074H,VP+0009AH,VP+000C0H
		DW	VP+0094EH,VP+00974H,VP+0099AH,VP+009C0H
		DW	VP+0124EH,VP+01274H,VP+0129AH,VP+012C0H
		DW	VP+01B4EH,VP+01B74H,VP+01B9AH,VP+01BC0H,0
;======================================================================
	;	LDA	#6			; 1p ONLY
	;	BRA	RAM_edit_entry
	;	LDA	#5			; 2p ONLY


RAM_editer_A
RAM_editer_B	
RAM_edit_entry	
	;;	CMP	!system_no
	;;	BNE	RAM_edit_exit
;-------------------------------------------------------
		PHB
		PHK
		PLB		;>
		JSR	move_cursol
		LDA	<sprite_count
		JSR	set_editer
		STA	<sprite_count
		JSR	set_cursol
		PLB			;<
RAM_edit_exit	RTL
;----------------------------------------------------------------------
set_editer
		TAX			; sprite buffer parameter
		SEP	#00100000B
		MEM8
		LDA	!edit_v
		ASL	A
		ASL	A
		ASL	A
		STA	<work
		LDA	!edit_h
		LSR	A
		AND	#0110B
		ORA	<work
		REP	#00100000B
		MEM16
		AND	#00FFH
		STA	<offset_addr
;
		LDA	!debug_address+0
		SEC
		SBC	<offset_addr
		STA	<offset_addr
		STA	<temp
		LDY	#0
;----------------------------------------------------------------------
d1_loop		LDA	!position_data0,Y
		BEQ	next_editer
		CLC
		ADC	<screen_obj_V
		STA	<work			;>>
		LDA	<temp
		INY
		INY
		PHY				
		TAY
		CLC
		ADC	#8
		STA	<temp			; next data
		LDA	<work			;<<
		JSR	Disp_number
		PLY
		BRA	d1_loop
;----------------------------------------------------------------------
next_editer
		LDY	!debug_address+2	; bank
		CPY	#007FH			; 7F bank ?
		BEQ	set_7F			; yes -> skip
set_7E		LDY	#007EH			; 7E BANK
set_7F		STY	<temp+2			;
	;;;	LDA	!debug_address+0	; address
		LDA	<offset_addr
		STA	<temp+0			;
;----------------------------------------------------------------------
		LDY	#0
d2_loop		LDA	!position_data1,Y
		BEQ	exit_editer
		CLC
		ADC	<screen_obj_V
		STA	<work
		INY
		INY
		PHY			; >>
;
		LDA	[<temp]		;W RAM read
		TAY
		INC	<temp		;W next RAM
		INC	<temp		;W
		LDA	<work		; VH position
		JSR	Disp_number
;
		PLY			; <<
		BRA	d2_loop
;----------------------------------------------------------------------
exit_editer	TXA
		RTS
;*********************************************************************
;		Display number
;*********************************************************************
number_char	EQU	3980H	
;----------------------------------------------------------------------
;<<example>>	;	X sprite count
;		;	Y number
;		;	A position
;----------------------------------------------------------------------
		mem16
		idx16
Disp_number	CLC
		STA	<sprite_H+0,X		; X***
		ADC	#0008H
		STA	<sprite_H+4,X		; *X**
		ADC	#0008H
		STA	<sprite_H+8,X		; **X*
		ADC	#0008H
		STA	<sprite_H+12,X		; ***X
;
		TYA
		AND	#0F000H
		XBA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#number_char
		STA	<sprite_C+0,X		; X*** 
		TYA
		AND	#00F00H
		XBA
		ORA	#number_char
		STA	<sprite_C+4,X		; *X**
;
		TYA
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#number_char
		STA	<sprite_C+8,X		; **X*
		TYA
		AND	#0000FH
		ORA	#number_char
		STA	<sprite_C+12,X		; ***X
;
		TXA				; pointer INC
		CLC
		ADC	#10H
		TAX	
;			
		RTS
;----------------------------------------------------------------------
		EXTEND
objextra	SECT	REL
		mem16
		idx16
		dw	100	
;----------------------------------------------------------------------
		END
