;*********************************************************************
;	mario kart << hbv[ >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def

	glb	Doppler_A,Doppler_B,Doppler_GP

;*********************************************************************
;	hbv[pJ[g CfbNX
;*********************************************************************
dop_wk		equ	0
dop_for		equ	2
dop_back	equ	4
;- - - - - - - - - - - - - - - - - - - - - 
		EXTEND
bank84		SECT	REL
		mem16
		idx16
;*********************************************************************
;	Ji}CJ[gjɍł߂J[g`FbN
;*********************************************************************
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;		GP 1P 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Doppler_A	
		ldx	!doppler_process
		jsr	(!processA,x)
next_doppler	lda	!doppler_process
		inc	a
		inc	a
		and	#0110b
		sta	!doppler_process
		rtl
;- - - - - - - - - - - - - - - - - - - - -
processA	dw	search_kart_1p		; 0
		dw	calc_forward_1p		; 2
		dw	calc_back_1p		; 4
		dw	set_doppler_1p		; 6
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	GP 1P 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Doppler_B	
		ldx	!doppler_process
		jsr	(!process$,x)
		bra	next_doppler
;- - - - - - - - - - - - - - - - - - - - -
process$	dw	search_kart_2p		; 0
		dw	calc_forward_2p		; 2
		dw	calc_back_2p		; 4
		dw	set_doppler_2p		; 6
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	GP 2P
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Doppler_GP	ldx	!doppler_process
		lda	!player_count+0		; 1P ̃`FbN
		beq	doppler_2ponly
		lda	!player_count+2		; 2P ̃`FbN
		beq	doppler_1ponly
		jsr	(!process_n,x)
gp_skip		lda	!doppler_process
		inc	a
		inc	a
		and	#01110B
		sta	!doppler_process
gp_exit		rtl
;- - - - - - - - - - - - - - - - - - - - -
doppler_1ponly	jsr	(!process_1p,x)
		bra	gp_skip
doppler_2ponly	lda	!player_count+2		; 2P ̃`FbN
		beq	gp_exit
		jsr	(!process_2p,x)
		bra	gp_skip
;- - - - - - - - - - - - - - - - - - - - -
process_n	dw	search_kart_1p		; 0
		dw	calc_forward_1p		; 2
		dw	calc_back_1p		; 4
		dw	search_kart_2p		; 6
		dw	calc_forward_2p		; 8
		dw	calc_back_2p		; A
		dw	tes			; C
		dw	tes			; E
;- - - - - - - - - - - - - - - - - - - - -
process_1p	dw	search_kart_1p		; 0
		dw	calc_forward_1p		; 2
		dw	calc_back_1p		; 4
		dw	tes			; 6
		dw	tes			; 8
		dw	tes			; A
		dw	tes			; C
		dw	tes			; E
;- - - - - - - - - - - - - - - - - - - - -
process_2p	dw	tes			; 0
		dw	tes			; 2
		dw	tes			; 4
		dw	search_kart_2p		; 6
		dw	calc_forward_2p		; 8
		dw	calc_back_2p		; A
		dw	tes			; C
		dw	tes			; E
;- - - - - - - - - - - - - - - - - - - - -
tes		rts


;######################################################################
;######	hbv[ (TEhp) p[^Zbg		#######
;######################################################################
;*********************************************************************
;	Jɋ߂ index 
;*********************************************************************
;--------------------------------------------------------------------
;	Jhbv[̃f[^ZbgI
;--------------------------------------------------------------------
set_doppler_2p	ldx	#player_r1
		bra	set_doppler
set_doppler_1p	ldx	#player_r0
set_doppler	
;- - - - - - - - - - - - - - - - - - - - - 
		lda	!doppler_switch
		bmi	return$
		bit	!goal_flag
		bvc	entry$
return$		stz	!doppler_index
		lda	#0ffffh
		sta	!doppler_dist
		rts
;- - - - - - - - - - - - - - - - - - - - - 
entry$		lda	<_forward_dist,x
		cmp	<_backward_dist,x
		bcs	backward$
;- - - - - - - - - - - - - - - - - - - - - 
forward$					; OɌ
		sta	!doppler_dist+0
		ldy	<_forward_kart,x
		sty	!doppler_index+0	; y ڕW index
		jmp	doppler_rotate		; x }CJ[g
;- - - - - - - - - - - - - - - - - - - - - 
backward$					; Ɍ
		lda	<_backward_dist,x
		cmp	#0ffffh
		beq	over$
		sta	!doppler_dist+0
		ldy	<_backward_kart,x
		sty	!doppler_index+0	; y ڕW index
		jmp	doppler_rotate		; x }CJ[g

;- - - - - - - - - - - - - - - - - - - - - 
over$		sta	!doppler_dist+0		; 
		stz	!doppler_index+0	; OJ[gȂI
		rts
;- - - - - - - - - - - - - - - - - - - - - 





;*********************************************************************
;	UTILITY
;*********************************************************************
;--------------------------------------------------------------------
;	OÃJ[gT (  j/ (  j
;--------------------------------------------------------------------
search_kart_GP	jsr	search_kart_2p
search_kart_1p	ldy	#0
		ldx	#player_r0
		jsr	init_work
loop1$		txy
		ldx	<_forward_A,y		; OJ[g
		cpx	#A_root
		beq	over1$
		lda	<_status,X
		bmi	loop1$
		bpl	set1$
over1$		ldx	#0
set1$		stx	!_forward_kart+player_r0
;- - - - - - - - - - - - - - - - - - - - - 
		ldx	#player_r0
loop2$		txy
		ldx	<_backward_A,y		; J[g
		cpx	#A_root
		beq	over2$
		lda	<_status,x
		bmi	loop2$
		bpl	set2$
over2$		ldx	#0
set2$		stx	!_backward_kart+player_r0
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
search_kart_2p	ldy	#2
		ldx	#player_r1
		jsr	init_work
loop1$		txy
		ldx	<_forward_B,y		; OJ[g
		cpx	#B_root
		beq	over1$
		lda	<_status,x
		bmi	loop1$
		bpl	set1$
over1$		ldx	#0
set1$		stx	!_forward_kart+player_r1
;- - - - - - - - - - - - - - - - - - - - - 
		ldx	#player_r1
loop2$		txy
		ldx	<_backward_B,y		; J[g
		cpx	#B_root
		beq	over2$
		lda	<_status,x
		bmi	loop2$
		bpl	set2$
over2$		ldx	#0
set2$		stx	!_backward_kart+player_r1
		rts
;--------------------------------------------------------------------
;	ܰƼ
;--------------------------------------------------------------------
init_work	lda	!camera_x,y	; camera position X
		lsr	a
		lsr	a
		sta	<_kart_X,x
		lda	!camera_y,y	; camera position Y
		lsr	a
		lsr	a
		sta	<_kart_Y,x
		lda	!A_pose_Q,y	; camera angle
		sta	<_kart_P,x
		stz	<_forward_kart,x
		stz	<_backward_kart,x
		rts
;--------------------------------------------------------------------
;	OJ[gvZ
;--------------------------------------------------------------------
calc_forward_2p	ldx	#player_r1
		bra	calc_forward
calc_forward_1p	ldx	#player_r0
calc_forward	ldy	<_forward_kart,x
		beq	over$
		jsr	dsp_multi
exit$		sta	<_forward_dist,x
		rts
over$		dey
		tya
		bra	exit$
;--------------------------------------------------------------------
;	J[gvZ
;--------------------------------------------------------------------
calc_back_2p	ldx	#player_r1
		bra	calc_back
calc_back_1p	ldx	#player_r0
calc_back	ldy	<_backward_kart,x
		beq	over$
		jsr	dsp_multi
exit$		sta	<_backward_dist,x
		rts
over$		dey
		tya
		bra	exit$
;--------------------------------------------------------------------
;	hbv[̌vZ
;--------------------------------------------------------------------
;		ix ... J[g(Jj
;		iy ... ڕWJ[g
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
doppler_rotate	
		SEP	#00100001B
		MEM8
		lda	#dsp_rotate
		sta	!DSP_data
		REP	#00100000B
		MEM16
		lda	<_kart_P,x
		sta	!DSP_data
		lda	!_situationXH,y
		sbc	<_kart_X,x
		sta	!DSP_data
		lda	!_situationYH,y
		sec
		sbc	<_kart_Y,x
		sta	!DSP_data
		LDA	>DSP_status
		BPL	$-4
		lda	!DSP_data
		sta	!doppler_x+0
		lda	!DSP_data
		sta	!doppler_y+0
		rts
;--------------------------------------------------------------------
;	̌vZ
;--------------------------------------------------------------------
;		ix ... J[g(Jj
;		iy ... ڕWJ[g
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
dsp_multi	SEP	#00100001B
		MEM8
		LDA	#dsp_distance
		STA	!DSP_data
		REP	#00100000B
		MEM16
		LDA	!_situationXH,Y
		SBC	<_kart_X,X
		STA	!DSP_data
		LDA	!_situationYH,Y
		SEC
		SBC	<_kart_Y,X
		STA	!DSP_data
		LDA	#0
		LDA	#0
		STA	!DSP_data
		LDA	>DSP_status
		BPL	$-4
		LDA	!DSP_data
		RTS
;#--#--#--#--# MAIN #--#--#--#--#--#--#--#--#--#--#--#--#--#--#--#
			

;--------------------------------------------------------------------
;	J~Ƃ̃hbv[
;--------------------------------------------------------------------
	if	0
		bit	<camera_control+0	; camera check
		bmi	move_camera
stop_camera
		ldx	#A_root
loop$		txy
		ldx	<_forward_A,y
		cpx	#A_root
		beq	exit$
		lda	<_status,x
		bmi	loop$
		lda	<_distance_A,x
		cmp	#100h		;J{|WV
		bcc	set$
		stx	<dop_back
		bra	loop$
set$		stx	<dop_for
exit$		ldy	#player_r0
		bra	set_index
	endif

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		END
