;******************* Driver-point.asm *************************
;
			extend
;-----------------------------------------------------
			include		../join/rp5c77
			include		../join/buffer.def
			include		../join/rp5a22
			include     ../join/work.def
			include		../join/label.def
			include		../join/object.def
;-----------------------------------------------------
			glb		DP_init,DP_main,DP_nmi
;
			ext		PPU_INT_SET,Set_DMA
			ext		Init_demokart,Set_demokart
			ext		DMA_demokart,KEY_CHECK
			ext		BGM_fade_out,OBJ_ERASE,Color_Set_sub
			ext		X_inx,Y_iny,Trigger_sound_1,Rank_Check
			ext		Zero_clear,Set_4bit_mode1
;---------------------------------------------------
address			equ		60h			;2byte
address1		equ		62h			;2byte
name_address	equ		64h			;2byte
Rank_counter	equ		66h			;2byte
Display_counter	equ		68h			;2byte
button_TG       equ     6ah         ;4byte
Move_counter	equ		6eh			;2byte
;
Revolve_counter	equ		70h			;2byte
Xmove_counter	equ		72h			;2byte
Swing_counter	equ		74h			;2byte
Swing_flag		equ		76h			;2byte
Rank_number		equ		78h			;2byte
Check_rank		equ		7ah			;2byte
Scroll_2h		equ		7ch			;3byte
;
Driver_flag		equ		80h			;2byte
Flag_counter	equ		82h			;2byte
Flag_timer		equ		84h			;2byte
flag_speed		equ		86h			;2byte
Flash_timer		equ		88h
Player_1_rank	equ		8ah
Player_2_rank	equ		8ch
NO_display_flag	equ		8eh
;
Rank_index		equ		90h
Kart_Rank		equ		92h
OBJ_check_flag  equ     96h
No_count_flag	equ		98h
Point_counter 	equ     9ah
Point_up_timer	equ		9ch
Ranking_select	equ		9eh
;-----------------------------------------------------
kart_set		equ		180h		;Oobt@[
oamdat			equ		200h
msbdat			equ		400h
;
Flash_buffer_1p	equ		1800h		;tbVobt@[
Flash_buffer_2p	equ		1840h
;
NEW_rank_buffer	equ		18c0h		;J[gobt@[
Ranking_number	equ		18d0h		;io[obt@[
kart_point		equ		1902h
Fiash_flag		equ		1904h
New_rank_count	equ		1906h
Max_point		equ		1908h
NOW_rank		equ		190ah
Kart_index_set	equ		190ch
All_end_counter	equ		1980h
;-----------------------------------------------------
bank85      		sect    rel         ;(PBR=85)
;==================================================
;**************************************************
;			INITIAL ROUTINE
;**************************************************
;==================================================
DP_init			equ		$
				phb
				phk
				plb
;
				ldy		#OBJ_data1
				JSL		>Init_demokart
;
				mem8
				idx8
				sep		#00110000b
;
				JSL		>PPU_INT_SET			;ppu&oam initial set.
				JSR		DRIVER_PPU
				JSR		Driver_tensou
;
				mem16
				idx16
				rep		#00110000b
;
				plb
				RTL
;=============================================================
;************************************************************
;					MAINE ROUNTINE
;************************************************************
;=============================================================
DP_main		equ		$
				phb
				phk
				plb
;
				JSR     KEY_CHECK
				JSR		Driver_SCROLL
;<<<<<<<<<<<< UgLÕ`FbN >>>>>>>>>>>>
				lda		<Driver_flag
				beq		Result_Set
;<<<<<<<<<<<<<<<< LOC >>>>>>>>>>>>>>>>>>>>>
New_rank_select	lda		<Ranking_select
				asl		a
				tax
				jmp		(!Select_rank,x)
;
Old_rank_disp	JSR		Driver_set
				jmp		owari_point

Set_UP_point	JSR		Point_Up_set
				jmp		owari_point
;
Rank_erase_set	JSR		Erase_Rank
				jmp     owari_point
;
NEW_rank_app	JSR		NEW_rank_disply
				JSR		Rank_End
;
				lda		#200h
				sta		<sprite_count
				JSR		Kart_move
				JSL		>Set_demokart
				jmp		owari_point
;<<<<<<<<<<<<<<<< UgC >>>>>>>>>>>>>>>>>>>>>>
Result_Set		lda		#200h
				sta		<sprite_count
				JSR		Result_move
				JSL		>Set_demokart
;
				JSR		Result_set
				JSR		Result_end
owari_point		plb
				RTL
;
Select_rank		DW		Old_rank_disp,Set_UP_point
				DW		Rank_erase_set,NEW_rank_app
Select_rank_NMI	DW		Set_old_rank,Point_UP_nmi
				DW		RANK_erase_nmi,Rank_Change_nmi
;===========================================================
;**********************************************************
;					NMI wari komi.			  
;**********************************************************
;===========================================================
DP_nmi			equ		$
				phb
				phk
				plb

;<<<<<<<< UgLÕ`FbN >>>>>
				lda		<Driver_flag
				bne		Ranking_Set
;<<<<<<<<<< ʗptbVOZbg >>>>>>>>
				lda		<NO_display_flag
				bne		Set_Flash_Nmi
				JSR		Name_tensou
				jmp		Set_Scroll
;
Set_Flash_Nmi	JSR		Result_Flashing
				jmp		Set_Scroll
;<<<<<<<<< LOptbVOZbg >>>>>
Ranking_Set		lda		<Driver_flag
				cmp		#0001
				bne		NO_init
;
				inc		<Driver_flag
;
				mem8
				sep		#00100000b
				lda		#00010000b			;SC_2oN؂ւ
				sta     Screen_bank+2
;-----------------------------------------
NO_init			mem16
				idx16
				rep		#00110000b
				lda		<Ranking_select
				asl		a
				tax
				jmp		(!Select_rank_NMI,x)
;
Set_old_rank	JSR     Name_tensou
				jmp     Set_Scroll
;
Point_UP_nmi	JSR     Name_tensou
				JSR		Rank_Flashing
				jmp		Set_Scroll
;
RANK_erase_nmi;	stz		<Flash_timer
			;	JSR		Rank_Flashing
				JSR     Name_tensou
				jmp     Set_Scroll
;
Rank_Change_nmi	JSR     Name_tensou		
				lda		Fiash_flag
				beq		Set_Scroll
				JSR     Rank_Flashing
;
Set_Scroll		mem8
				sep		#00100000b	
				lda     <Scroll_2h+1
				sta		Scroll_1H
				lda		<Scroll_2h+2
				sta		Scroll_1H
				mem16
				rep		#00100000b
				JSL		>DMA_demokart
;
				plb
				rtl
;===========================================================
;**********************************************************
;					INITIAL SET ROUTINE
;**********************************************************
;===========================================================
;**************************************************
;					PPU&WORK INITIAL SET
;**************************************************
DRIVER_PPU		equ		$
;<<<<<<<<<<<< [y[WNA[ >>>>>>>>>>>>>>
				mem16
				idx16
				rep		#00110000b
;
				JSR		Nuki_set
				lda     #1d23h
				sta     <name_address
				lda		#1a8h
				sta		<flag_speed
				lda		#0027h
				sta		<Xmove_counter
;
				mem8
				idx8
				sep		#00110000b
;<<<<<<<<<<<<<<<<<< PPU SET >>>>>>>>>>>>>>>>>>>>
				mem8
				sep		#00100000b
				lda		#00001001b
				sta		Screen_size			;BG mode1 set.
;
				lda		#00010110b
				sta		Through_screen		;TM
;
				lda		#00010101b
				sta		Screen_bank+1
;
				lda		#00011100b
				sta		Screen_bank+2
;
				lda		#00100010b
				sta		Screen_segment
				lda		#00000000b
				sta     Screen_segment+1
;
				lda     #10000000b
				sta     Screen_step
;
				lda		#00000010b
				sta		Sprite_size
				rts
;********************************************************
;					TENSOU SET
;********************************************************
Driver_tensou	equ		$
;<<<<<<<<<<<<<<<<<< SC_3 >>>>>>>>>>>>>>>>>>>>>>>
				ldx		#18h
				jsr		Set_DMA
;
				ldx		#10h
				jsr		Set_DMA
;<<<<<<<<<<<<<<<<<<< SC_2 >>>>>>>>>>>>>>>>>>>>>>
				ldx		#04
				jsr     Set_DMA
;<<<<<<<<<<<<<<<<< SC_3.CGX >>>>>>>>>>>>>>>>>>>>
				ldx		#12h
				jsr     Set_DMA
;
				ldx		#14h
				jsr     Set_DMA
;<<<<<<<<<<<<<<<<<< SC_2.CGX >>>>>>>>>>>>>>>>>>>
				ldx		#16h
				jsr		Set_DMA
;<<<<<<<<<<<<<< kL@Zbg@>>>>>>>>>>>>>>>>>>
				mem16
				idx16
				rep		#00110000b

				lda		#1c62h
				sta		Screen_address
;
				ldx		#0
				lda		#202fh
loop_nuki_set	sta     Screen_write
				inx
				cpx		#0013h
				bne		loop_nuki_set
;
				lda		#1c82h
				sta		Screen_address
;
				ldx		#0
				lda		#202fh
loop_nuki_set1	sta     Screen_write
				inx
				cpx		#0013h
				bne		loop_nuki_set1
;<<<<<<<<< [Xʕ̏㑤Zbg >>>>>>>>>>
				lda		#1c6dh
				sta     Screen_address
;
				ldx		#0
Set_vram		lda		Race_result,x
				cmp		#0ffffh
				beq		Set_low
				sta		Screen_write
				inx
				inx
				jmp		Set_vram
;<<<<<<<< [Xʕ̉Zbg >>>>>>>>>>>
Set_low			lda		#1c8dh
				sta     Screen_address
;
				ldx		#0
Set_vram1		lda		Race_result1,x
				cmp		#0ffffh
				beq		Red_line_set
Set_screen		sta		Screen_write
				inx
				inx
				jmp		Set_vram1
;<<<<<<<<<<<<<< CԃZbg >>>>>>>>>>>>>>>>>
Red_line_set	lda		#1cc2h
				sta     Screen_address
				JSR		Set_red
;
				lda		#1d02h
				sta		Screen_address
				JSR     Set_red
;<<<<<<< NX,Jbv,Eh@Zbg >>>>>>>>>
;-------(-ʗp)----------
				ldy		#0008
				lda		#1ce8h
				sta     Screen_address
				JSR		Cup_set
;
Round_set		lda		#1cf6h
				sta     Screen_address
				JSR		Set_Round
;
				lda		#1ce3h
				sta     Screen_address
				JSR		Class_set
;-------(LOp)-----
Ranking_cup		ldy		#0014h
				lda		#10e8h
				sta     Screen_address
				JSR     Cup_set
;
Round_set_1		lda		#10f6h
				sta     Screen_address
				JSR     Set_Round
;
				lda		#10e3h
				sta     Screen_address
				JSR		Class_set
;<<<<<<<<<<<<<<< LN^[Zbg >>>>>>>>>>>>
				lda		#5000h
				sta     Screen_address
;
				ldx		#0400h
				JSL		>Set_4bit_mode1
;<<<<<<<<<<<<<< LN^[OAMZbg >>>>>>>>>>
				ldy		#0
				JSR		Cup_character_set
;<<<<<<<<<<<<<<<< ̃Zbg >>>>>>>>>>>>>>>>>>>
Hata_set		ldx		#0
				lda		#00ffh
				sta		msbdat+10h
;
				ldy		#0
				ldx		#0
position_set	lda		Position_data,x
				cmp		#0ffffh
				beq		Set_character
				sta		oamdat+100h,y
				inx
				inx
				JSR		Y_iny
				jmp		position_set
;
Set_character	ldx		#0
				JSR		Flag_move
;<<<<<<<<<<<<<<<< CG_SET >>>>>>>>>>>>>>>>>>>>>>>
CG_set			mem8
				sep		#00100000b		
				lda		#0			
				sta		Color_address
;
      		 	ldy		#0
				ldx		#4200h
Drive_color		JSR		Color_Set_sub
			 	cpy		#200h
			 	bne		Drive_color
;
			    idx8
				mem8
			 	sep		#00110000b
				rts
;<<<<< ̃LN^[ZbgTu[` >>>>>>
Flag_move		equ		$
				mem16
				idx16
				ldy		#0
				lda		Flag_name,x
				tax
Flag_set		lda		!0,x
				cmp		#0ffffh
				beq		Flag_owari
				sta		oamdat+102h,y
				inx
				inx
				JSR		Y_iny
				jmp		Flag_set
Flag_owari		rts		
;<<<<<<<<<<<<<<<<<< CTu >>>>>>>>>>>>>>>
Set_red			equ		$
				ldx		#0
				lda		#289eh
Set_vram2		sta		Screen_write
				inx		
				cpx		#001ch
				bne		Set_vram2
				rts
;<<<<<<<<<<<<< JbvZNgTu >>>>>>>>>>>
Cup_set			equ		$
				lda		world_number
				asl		a
				tax
				lda		Cup_select,x
				tax
				JSR		Set_V_ram
				rts
;<<<<<<<<<<<< EhZNgTu >>>>>>>>>>>
Set_Round		equ		$
				lda		map_pointer
				dec		a
				asl		a
				tax
				lda		Round_select,x
				tax
				JSR		Set_V_ram
				rts
;<<<<<<<<<<<<<< NXZbgTu >>>>>>>>>>>>>>
Class_set		equ		$
					lda		game_level
				tax
				lda		Select_class,x
				tax
				JSR		Set_V_ram
				rts
;
Set_V_ram		equ		$
loop_round		lda		!0,x
				ora		Color_data,y
				cmp		#0ffffh
				beq		owari_round
				sta		Screen_write
				inx		
				inx
				jmp		loop_round
owari_round		rts
;<<<<<<<<<<< LIuWFTuZbg >>>>>>>>>
Cup_character_set
				lda		#0aaaah
				sta		msbdat+12h
;
				ldx		#0
loop_position	lda		OAM_position,y
				sta		oamdat+120h,x
				JSR		X_inx
				iny
				iny
				cpx		#0018h
				bne		loop_position
;
				ldy		#0
				lda		world_number
				cmp		#0003h
				beq		Special_set
				asl		a
				tax
				lda		OBJ_select,x
loop_obj		sta		oamdat+122h,y
				JSR		Y_iny
				cpy		#0018h
				bne		loop_obj
				rts
;
Special_set		ldx		#0
				ldy		#0
loop_special	lda		OBJ_select,x
				sta		oamdat+122h,y
				inx
				inx
				JSR		Y_iny
				cpy		#0018h
				bne		loop_special
				rts
;------------------------------------------------
Race_result		DW		3462h,3448h,3464h,3468h
				DW		347ch,3466h,3464h,0ffffh
;
Race_result1	DW		3463h,3449h
				DW		3465h,3469h,3457h,3467h
				DW		3465h,0ffffh
;
Flag_name		DW		Flag_data_1,Flag_data_2,Flag_data_3
;
Flag_data_1		DW		2000h,2004h,2002h,2006h,0ffffh
;
Flag_data_2		DW		2008h,200ch,200ah,200eh,0ffffh
;
Flag_data_3		DW		2020h,2024h,2022h,2026h,0ffffh
;
Position_data	DW		9830h,0a830h,9840h,0a840h,0ffffh
;(obj data set)
OBJ_data1		DW		player_r0,0130h,00c0h,0c000h
				DW		player_r1,0130h,00c1h,0c000h
				DW		player_r2,0130h,00c0h,0c000h
				DW		player_r3,0130h,00c1h,0c000h
				DW		player_r4,0130h,00c0h,0c000h
				DW		player_r5,0130h,00c1h,0c000h
				DW		player_r6,0130h,00c0h,0c000h
				DW		player_r7,0130h,00c1h,0c000h
				DW		0				
;
Point_inc		DW		0009h,0006h,0003h,0001h
				DW		0000h,0000h,0000h,0000h				
;
Cup_select		DW		Kinoko_cup,flawer_cup
				DW		star_cup,special_cup
;
Kinoko_cup		DW		2016h,201eh,201ch,2011h,201bh
				DW		2018h,2018h,2016h,202fh,200ch
				DW		201eh,2019h,0ffffh
;
flawer_cup		DW		200fh,2015h,2018h,2020h,200eh
				DW		201bh,202fh,200ch,201eh,2019h,0ffffh
;
star_cup		DW		201ch,201dh,200ah,201bh
				DW		202fh,200ch,201eh,2019h,0ffffh
;
special_cup		DW		201ch,2019h,200eh,200ch,2012h,200ah
				DW		2015h,202fh,200ch,201eh,2019h,0ffffh
;
Round_select	DW		Round_1,Round_2,Round_3,Round_4,Final
;
Round_1			DW		201bh,2018h,201eh,2017h,200dh,202fh,2001h,0ffffh
Round_2			DW		201bh,2018h,201eh,2017h,200dh,202fh,2002h,0ffffh
Round_3			DW		201bh,2018h,201eh,2017h,200dh,202fh,2003h,0ffffh
Round_4			DW		201bh,2018h,201eh,2017h,200dh,202fh,2004h,0ffffh
Final			DW		200fh,2012h,2017h,200ah,2015h,0ffffh
;
OAM_position	DW		1830h,1840h,1850h,18a8h,18b8h,18c8h
				DW		1820h,1830h,1840h,18a8h,18b8h,18c8h
OBJ_select		DW		2b06h,290ah,2908h,2908h,290ah,2b06h
;
Select_class	DW		Small_class,Big_class,special_class
Small_class		DW		2005h,2000h,202ah,0ffffh
Big_class		DW		2001h,2000h,2000h,202ah,0ffffh
special_class	DW		2001h,2005h,2000h,202ah,0ffffh
;=============================================================
;************************************************************
;					MAINE ROUTINE
;************************************************************
;=============================================================
;*********************************************************
;					LOpOZbg
;*********************************************************
Driver_set		equ		$
Set_rank		mem16
				idx16
				lda		<Rank_counter
				cmp		#0010h
				beq		point_set
;
				JSR		Display_timer
				cmp		#0003h
				bne		owari_old_rank						;display?:no-->no_setrank
				stz     <Display_counter
;
				JSR		Set_result
				JSR		GET_point_set
				lda		<Rank_counter
				clc
				adc		#0002h
				sta		<Rank_counter
owari_old_rank	rts
;
point_set		inc		<Ranking_select
				lda		#0010h
				sta		<Rank_counter
				JSR		Point_Up_set
				jmp		owari_old_rank				
;<<<<<<<<<<<<<<<<< ʂZbg >>>>>>>>>>>>>>>>>>>>>>>>>>
Set_result		JSR     Nuki_set
;<<<<<<<<<<<<<<<< V_RAM AhXZbg >>>>>>>>>>>>>>>>>
				ldx		<Rank_counter
				JSR		V_ramset
				lda		<name_address
				sec
				sbc		#0bfeh
				sta		<name_address
;<<<<<<<<<<<<< Nio[Zbg >>>>>>>>>>>>>>>>>>>>
Point_UP_set	ldx		<Rank_counter
				ldy		#0
				lda		Ranking_number,x
				tax
				lda		Rank_data,x
Set_number		sta		kart_set,y
;<<<<<<<<<<<<<<<<<<<< OZbg >>>>>>>>>>>>>>>>>>>>>>
				ldy		#0004
				ldx     <Rank_counter
				lda		point_rank,x
				tax
				lda		<driver_number,x
				tax
;-----(Op)----
name_set		JSR     Name_set
;---(jZbg)---
loop_hasen		JSR     Hasen_set
				cpy		#0028h
				bne		loop_hasen
;<<<<<<<<<<<<<<<<< |CgZbg >>>>>>>>>>>>>>>>>>>>>
;---(ZZbg)------
				ldx     <Rank_counter
				lda		point_rank,x
				tax
				lda		<driver_point,x
				sta		Dividend					;4204h
				lda		#0ah
				sta		Divisor						;4206h
				nop
				nop
				nop
				nop
				nop
				nop
				nop
				nop
;---(̌fBXvCZbg)--------				
				lda		Quotient					;4214h
				asl		a
				tax
				lda		Point_data,x
				sta		kart_set,y
;---(̌fBXvCZbg)------
				iny
				iny
				lda     Residue						;4216h
				asl		a
				tax
				lda     Point_data,x
				sta     kart_set,y
;<<<<<<<<<<<< PAQvC[pJ[Zbg >>>>>>>>>>>>
Color_set_player
				lda     <game_mode
				cmp		#04
				beq		Check_2con
;---(1player set)---
				ldx     <Rank_counter
				lda		point_rank,x
				cmp		#1000h
				bne		rank_2player				;1player?:no-->rank_2player
				jmp		Set_1p.color
;
Check_2con		ldx     <Rank_counter				;QRg[p
				lda		point_rank,x
				cmp		#1100h
				bne		rank_2player				;1player?:no-->rank_2player
;
Set_1p.color	ldx		#10h							;color change set.
				jsr		Player_color
				ldx     <Rank_counter
				JSR     Set_buffer_1p
;----(2player set)----
rank_2player	lda		<game_mode
				bne		owari_rank_set					;2player mode?:no-->rank_set
;
				ldx		<Rank_counter				;color change set.
				lda		point_rank,x
				cmp		#1100h
				bne		owari_rank_set					;2player?:no-->rank_set
;
				ldx		#12h
				jsr		Player_color
				ldx     <Rank_counter
				JSR     Set_buffer_2p
;
;;<<<<<<<<<<<<<< tbVOpobt@[Zbg >>>>>>>>>
;rank_set		ldx     <Rank_counter
;				lda		point_rank,x
;				cmp		#1000h
;				beq		Player_1_set1
;;
;				cmp		#1100h
;				beq		Player_2_set1
;<<<<<<<<<<<<< N`FbNJE^[Zbg >>>>>>>>>>>
owari_rank_set;	JSR		Rank_set
				rts

;
;Player_1_set1	JSR		Set_buffer_1p
;				jmp		owari_rank_set
;
;Player_2_set1	JSR		Set_buffer_2p
;				jmp     owari_rank_set
;<<<<<<<<<<<<< J[pTu[` >>>>>>>>>>>>>
Player_color	equ		$
				ldy		#0							;low side color change.
loop_color		lda		kart_set,y
				ora		Color_data,x
				sta		kart_set,y
				iny
				iny
				cpy		#0034h
				bne		loop_color
				rts
;<<<<<<<<<<<<<<<<<< l|Cg\Tu >>>>>>>>>>>>>>>
GET_point_set	equ		$
;-------( ^C`FbN)----------
				ldx		<Rank_counter
				lda		point_rank,x
				tax
				lda     <kart_area,x	
				beq		Set_out_1
				lda		<driver_time+4,x
				cmp		#0ffffh
				bne		Get_point_set
Set_out_1		lda		#000eh
				sta		<Kart_Rank
				jmp      owari_get_point
;-------(|CgZbg)-----------
Get_point_set	ldy		#0
				ldx     <Rank_counter
Check_add		lda		point_rank,x
				cmp     rank_index,y
				beq		Set_add_point
				iny
				iny
				jmp		Check_add
;
Set_add_point	cpy		#0008h
				bcs		owari_get_point
				lda		Point_inc,y
				asl		a
				tax
				ldy		#0030h
				lda		Point_data,x
				sta		kart_set,y
;-------(JbRA{\)----------
				ldy		#002ch
				lda		#207dh
				sta		kart_set,y
;		
				ldy		#002eh
				lda		#207eh
				sta     kart_set,y
;
				ldy		#0032h
				lda		#607dh
				sta     kart_set,y
;
				JSR		Color_set_player
owari_get_point	rts
;********************************************************
;			 |CgCNgZbg
;********************************************************
Point_Up_set	equ		$
;<<<<<<<<<< |CgCNg`FbN >>>>>>>>>>
				lda		<No_count_flag
				bne		Set_point_inc
;<<<<<<<<<<<<<<<<<<<  ʂZbg >>>>>>>>>>>>>>>>>>>>
				JSR     Nuki_set
;<<<<<<<<<<<<<<<<< \JEgZbg >>>>>>>>>>>>>>>
				lda		<Rank_counter
				beq		Erase_set
				sec
				sbc		#0002h
				sta     <Rank_counter
;<<<<<<<<<<< J[gCfbNXZbg >>>>>>>>>>>>>>>
				tax
				lda		point_rank,x
				sta     <Rank_index
;<<<<<<<<<<<<< uQq`lAhX >>>>>>>>>>>>>>>>>>>
				ldx		<Rank_counter
				JSR		V_ramset
				lda		<name_address
				sec
				sbc		#0bfeh
				sta		<name_address
;<<<<<<<<<<<<<<<<< ^C`FbN >>>>>>>>>>>>>>>>>>
				ldx		<Rank_index
				lda     <kart_area,x	
				beq		Set_out
				lda		<driver_time+4,x
				cmp		#0ffffh
				bne		Result_check
Set_out			lda		#000eh
				sta		<Kart_Rank
				stz     <Flash_timer
				jmp      NO_up_point
;<<<<<<<<<<<<<<<<<< ʃ`FbN >>>>>>>>>>>>>>>>>>>>>
Result_check	ldy		#0
loop_result		lda		rank_index,y
				cmp		<Rank_index
				beq		Set_kart_rank
				iny
				iny
				jmp		loop_result
Set_kart_rank	sty		<Kart_Rank
				inc		<No_count_flag
				jmp		 NO_up_point
;<<<<<<<<<<<<<<< |CgAbv^C}[ >>>>>>>>>>>>>
Set_point_inc	inc     <Point_up_timer
				lda		<Point_up_timer
				cmp		#0005
				bne		owari_up_set		
				stz		<Point_up_timer
;<<<<<<<<<<<<<< |CgGh`FbN >>>>>>>>>>>>>>
Set_up			ldx		<Kart_Rank
				lda		<Point_counter
				cmp		Point_inc,x
				bne		Pointup_display
;<<<<<<<<<<<<<<< |CgAbvGh >>>>>>>>>>>>>>>
				stz		<No_count_flag
				stz     <Point_counter
				lda     <Rank_counter				;C[X̎
				bne		NO_up_point					;ɐFt
				stz		<Flash_timer
				jmp		NO_up_point
;<<<<<<<<<<<<<<<<<< C[XZbg >>>>>>>>>>>>>>>>>>
Erase_set		inc		<Ranking_select
				stz		<Rank_counter
				JSR		Erase_Rank_1
Owari_sos		rts
;<<<<<<<<<<<<<<< |CgAbvZbg >>>>>>>>>>>>>>>
Pointup_display	lda     <Rank_counter
				ldx		<Rank_index
				lda		<driver_point,x
				inc		a
				sta		<driver_point,x
				inc     <Point_counter
;<<<<<<<<<<<<<<< TEh`FbN >>>>>>>>>>>>>>>>>>>
				lda		game_mode
				cmp		#0004
				bne		SE_1con
;
				lda		<Rank_index
				cmp		#1100h
				beq		Set_Up_se
				jmp		NO_up_point
;				
SE_1con			lda		<Rank_index
				cmp		#1000h
				beq		Set_Up_se
;
				lda		game_mode
				bne		NO_up_point
				lda		<Rank_index
				cmp		#1100h
				bne		NO_up_point
;		
Set_Up_se		lda		#0020h
				JSL		>Trigger_sound_1
;<<<<<<<<<<<<< |Cg\@>>>>>>>>>>>>>>>>>>>	
NO_up_point		JSR		Point_UP_set
				JSR		GET_point_set				
owari_up_set	rts
;*******************************************************
;				 LOC[XZbg 
;*******************************************************
Erase_Rank		equ		$
				lda		<Rank_counter
				cmp		#0010h
				beq		NEW_rank_set
;
				JSR		Display_timer
				cmp		#0005h
				bne		owari_erase_set
				stz		<Display_counter				
;
Erase_Rank_1	ldx     <Rank_counter
;--------( ʂZbg )----------
				JSR     Nuki_set
;-------(V_RAM AhXZbg)---
				ldx		<Rank_counter
				JSR		V_ramset
				lda		<name_address
				sec
				sbc		#0bfeh
				sta		<name_address
;
				lda		<Rank_counter
				clc		
				adc		#0002
				sta		<Rank_counter
owari_erase_set	rts
;
NEW_rank_set	JSR		RANKING_set
				JSR		New_rank_set
;
				stz		<Display_counter
				inc		<Ranking_select
				lda		#000eh
				sta		<Rank_counter
				rts
;*********************************************************
;				 VLOfBXv[ 
;*********************************************************
NEW_rank_disply	equ		$
				JSR		Display_timer
				cmp		#0005h
				bne		owari_erase_set
				stz		<Display_counter
;
				lda		All_end_counter
				cmp		#000fh
				beq		Set_Ranking_point
				inc		All_end_counter
;
Set_Ranking_point
				JSR		Set_result
				lda		<Rank_counter
				beq		Flash_set
				sec
				sbc		#0002
				sta		<Rank_counter
owarei_New_rank	rts	
;
Flash_set		inc		Fiash_flag
				jmp		owarei_New_rank
;--------------------------------------------------------
Point_data		DW		2000h,2001h,2002h,2003h,2004h
				DW		2005h,2006h,2007h,2008h,2009h
;
Rank_data		DW		2001h,2002h,2003h,2004h
				DW		2005h,2006h,2007h,2008h
;
Address_data	DW		1d43h,1d83h,1dc3h,1e03h
				DW		1e43h,1e83h,1ec3h,1f03h
;
Kart_data		DW		MARIO,LUIZI,KUPPA,PEACH
				DW		KONG,NOKO,KINOP,YOSSY
;
RETIRE			DW		202fh,202fh,2018h,201eh,201dh,0ffffh
;
MARIO			DW		2016h,200ah,201bh,2012h,2018h,0ffffh
;
LUIZI			DW		2015h,201eh,2012h,2010h,2012h,0ffffh
;
KUPPA			DW		200bh,2018h,2020h,201ch,200eh,201bh,0ffffh			
;
PEACH			DW		2019h,201bh,2012h,2017h,200ch
				DW		200eh,201ch,201ch,0ffffh
;
KONG			DW		200dh,2018h,2017h,2014h,200eh,2022h,202fh,2014h
				DW		2018h,2017h,2010h,202fh,2013h,201bh,0ffffh
;
NOKO			DW		2014h,2018h,2018h,2019h,200ah
				DW		202fh,201dh,201bh,2018h,2018h
				DW		2019h,200ah,0ffffh
;
KINOP			DW		201dh,2018h,200ah,200dh,0ffffh
;
YOSSY			DW		2022h,2018h,201ch,2011h,2012h,0ffffh
;
Color_data		DW		0c00h,1000h,1800h,1400h
				DW		0800h,0800h,0800h,0800h
				DW		0400h,0800h,0000h,0c00h
				DW		0e3ffh,0ffffh
;
Kart_select     DW      player_r0,player_r1,player_r2,player_r3
				DW      player_r4,player_r5,player_r6,player_r7
;******************************************************
;				[XʗpAOZbg
;******************************************************
Result_set		equ		$
;<<<<<<<<<<<< tF[h͎󂯕tȂ >>>>>>>>>>>>>
				mem16
				idx16
				lda		fade_control			;fade in check.
				beq		Result_timer
no_result		rts
;<<<<<<<<<<<<<<< fBXv[^C}[ >>>>>>>>>>>>>>
Result_timer	JSR		Display_timer
				cmp		#0008h
				bne		no_result
				stz		<Display_counter
;<<<<<<<<<<<<< J[gio[`FbN >>>>>>>>>>>>>>
				lda		<NO_display_flag
				bne		no_result
;
				lda		<Rank_counter
				cmp		#0010h
				bne		Result_flag_chk
				inc		<NO_display_flag
;
Result_flag_chk	lda		<NO_display_flag
				bne		no_result
;<<<<<<<<<<<<<<<< ʂZbg >>>>>>>>>>>>>>>>>>>>>>>
Flash_result	JSR		Nuki_set
;<<<<<<<<<<<<<<<< V_RAM AhXZbg >>>>>>>>>>>>>
				ldx		<Rank_counter
				JSR		V_ramset
;<<<<<<<<<<<<<<< Nio[Zbg >>>>>>>>>>>>>>
				ldx		<Rank_counter
				ldy		#0
				lda		Rank_data,x
				sta		kart_set,y
				JSR		Y_iny
				phy
;<<<<<<<<<<<<<<<<< OZbg >>>>>>>>>>>>>>>>>>>>>>
				ldx     <Rank_counter
				lda		rank_index,x
				tax
				lda		<driver_number,x
				tax
;-----(Op)----
name_set_1		ply
				JSR		Name_set
;-----(jZbg)-------
Hasen_set_1		JSR		Hasen_set
				cpy		#0022h
				bne		Hasen_set_1
				iny
				iny
;-----(^CZbg)------------
				ldx     <Rank_counter			;J[gZbg
				lda		rank_index,x			;NZbg
				tax
				lda		<kart_area,x
				beq		Retire_kart
;
				lda		<driver_time+4,x		;^C`FbN
				cmp		#0ffffh
				beq		Retire_kart
;
				iny
				iny
				JSR		Set_timer
;
				lda		#2028h
				JSR     Set_timer
;
				lda		<driver_time+2,x		;bʑZbg
				and		#00f0h
				lsr		a
				lsr     a
				lsr     a
				lsr     a
				JSR     Set_timer
;
				lda		<driver_time+2,x		;bʑZbg
				and		#000fh
				JSR     Set_timer
;
				lda		#2029h					;R}Zbg
				JSR     Set_timer
;
				lda     <driver_time+1,x		;R}bʑZbg
				and		#00f0h
				lsr		a
				lsr     a
				lsr     a
				lsr     a
				JSR     Set_timer
;
				lda		<driver_time+1,x		;R}bʑZbg
				and		#000fh
				JSR     Set_timer
				jmp		Color_set
;
Set_timer		equ		$
				ora		#2000h
				sta		kart_set,y			;Zbg
				iny
				iny
				rts
;<<<<<<<<<<<<<< ^CZbg >>>>>>>>>>>>>>>>>>>>
Retire_kart		ldx		#0
Retire_set		iny
				iny
				lda		RETIRE,x
				cmp		#0ffffh
				beq		Color_set
				sta		kart_set,y
				inx
				inx
				jmp		Retire_set
;<<<<<<<<<<<<<<<<< J[Zbg >>>>>>>>>>>>>>>>>>>
Color_set		ldx		<Rank_counter
				JSR		Player_color
;<<<<<<<<< tbVOpobt@[Zbg >>>>>>>>>
				lda		game_mode
				cmp		#0004
				bne		Flash_1con
;
				ldx     <Rank_counter
				lda		rank_index,x
				cmp		#1100h
				beq		Player_1_set
				jmp		owari_resultset
;				
Flash_1con		ldx     <Rank_counter
				lda		rank_index,x
				cmp		#1000h
				beq		Player_1_set
;
				lda		game_mode
				bne		owari_resultset
				ldx     <Rank_counter
				lda		rank_index,x
				cmp		#1100h
				beq		Player_2_set
;<<<<<<<<<<<<<< JE^[Zbg >>>>>>>>>>>>>>>>>>
owari_resultset	JSR     Rank_set
				rts
;
Player_1_set	JSR		Set_buffer_1p
				jmp     owari_resultset
;
Player_2_set	JSR		Set_buffer_2p
				jmp     owari_resultset
;
;******************************************************
;				Tu[`W
;******************************************************
;<<<<<<<<<<<< fBXv[^C}[ >>>>>>>>>>>>>
Display_timer	equ		$
				inc		<Display_counter		;display flag set.
				lda		<Display_counter
				rts	
;<<<<<<<<<<<<<<<<< kL@Zbg >>>>>>>>>>>>>>>>>
Nuki_set		equ		$
				ldy		#0
				lda		#202fh
loop_nuki		sta		kart_set,y			;buffer set.
				iny
				iny
				cpy		#0080h
				bne		loop_nuki
				rts
;<<<<<<<<<< uQq`lAhXZbg >>>>>>>>>>>>
V_ramset		equ		$
				lda		Address_data,x
				sta		name_address			;v_ram address set.
				rts
;<<<<<<<<<<<<<<<<<< OZbg >>>>>>>>>>>>>>>>>>
Name_set		equ		$
				lda		Kart_data,x
				tax
set_name		lda		!0,x
				cmp		#0ffffh
				beq		name_owari
				sta		kart_set,y
				inx
				inx
				iny
				iny
				jmp		set_name
name_owari		rts
;<<<<<<<<<<<<<<<<<< j@Zbg >>>>>>>>>>>>>>>>>
Hasen_set		equ		$
				iny
				iny
				lda		#20a4h
				sta		kart_set,y
				rts
;<<<<<<<<<<<<<< NJE^[ >>>>>>>>>>>>>>>>>>
Rank_set		equ		$
				inc     <Rank_counter
				inc		<Rank_counter
				rts
;<<<<<<<<<< tbVO@oct@[ >>>>>>>>>>>>>
Set_buffer_1p	equ		$
				lda     Address_data,x
				sta     Player_1_rank			
;						
				ldx		#0
loop_flash_ram	lda		kart_set,x
				sta		Flash_buffer_1p,x
				inx
				inx
				cpx		#0034h
				bne		loop_flash_ram		
				rts
;
Set_buffer_2p	equ		$
				lda     Address_data,x
				sta     Player_2_rank			
				ldx		#0
loop_flash_ram1	lda		kart_set,x
				sta		Flash_buffer_2p,x
				inx
				inx
				cpx		#0034h
				bne		loop_flash_ram1
				rts
;<<<<<<<<<<<<< LOZbgTu >>>>>>>>>>>>>>>>
RANKING_set		equ		$
;------(CjVZbg)---------
				stz		New_rank_count
				stz		<Rank_counter
				stz		NOW_rank
;-------(_`FbN)------------
				lda		#002dh
				sta		Max_point
loop_max		ldx		<Rank_counter
				lda		point_rank,x
				tax
				lda		<driver_point,x
				cmp		Max_point
				beq		Max_point_set
;-------(J[gZbg)------------
Next_max		lda		<Rank_counter
				inc		a
				inc		a
				cmp		#0010h
				beq		next_max
				sta		<Rank_counter
				jmp		loop_max
;-------------(̍Zbg)----------
next_max		dec		Max_point
				stz		<Rank_counter
				jmp		loop_max
;--(_J[gCfbNXZbg)--
Max_point_set	ldx		<Rank_counter
				lda		point_rank,x
				ldx		New_rank_count
				sta		NEW_rank_buffer,x
;------(Nio[Zbg)---------
				ldx     New_rank_count
				dex		
				dex		
				bmi		same_rank
				lda		NEW_rank_buffer,x
				tax
				lda		<driver_point,x
				cmp		Max_point
				beq		same_rank
;
				ldx     New_rank_count		;N_EZbg
				lda		New_rank_count
				sta		NOW_rank
				sta     Ranking_number,x
				jmp		Count_up_set
;
same_rank		ldx		New_rank_count		;̂܂܃NZbg
				lda     NOW_rank
				sta		Ranking_number,x
;-------(̃obt@[Zbg)-------
Count_up_set	lda		New_rank_count
				clc
				adc		#0002
				cmp		#0010h
				beq		owari_new_rank
				sta		New_rank_count
				jmp		Next_max
owari_new_rank	JSR		Set_point_rank
				rts
;------(_̗DZbg)------------
New_rank_set	equ		$
				ldx		#0
				lda		game_mode			;lp`FbN
				beq		Check_1.2player
				cmp		#0004
				beq		Check_1player_1
;
Check_1player	lda		NEW_rank_buffer,x
				cmp		#1000h
				beq		Check_same_rank
				inx
				inx
				jmp		Check_1player		
;
Check_1player_1	lda		NEW_rank_buffer,x
				cmp		#1100h
				beq		Check_same_rank
				inx
				inx
				jmp		Check_1player_1
;
Check_1.2player	lda		NEW_rank_buffer,x	;lp`FbN
				cmp		#1000h
				beq		Check_same_rank
				cmp		#1100h
				beq		Check_same_rank
				inx
				inx
				jmp		Check_1.2player		
Check_same_rank	sta		Kart_index_set
				stx		NOW_rank			;ʃZbg
;
				lda		Ranking_number,x	;ʃio[Zbg
				sta		Max_point
;
				ldx		#0					;ʃ`FbN
loop_number		lda		Ranking_number,x
				cmp		Max_point
				beq		Set_priority
				inx
				inx		
				cpx		#0010h
				bne		loop_number
				jmp		owari_pri_rank			
;
Set_priority	lda		NEW_rank_buffer,x	;obt@[ւ
				pha
				lda		Kart_index_set
				sta		NEW_rank_buffer,x
				ldx		NOW_rank
				pla
				sta		NEW_rank_buffer,x
owari_pri_rank	JSR		Set_point_rank
				rts
;--------(QփZbg)-----
Set_point_rank	equ		$
				ldx		#0					;ŏIZbg
loop_new_rank	lda		NEW_rank_buffer,x
				sta		point_rank,x
				inx
				inx
				cpx		#0010h
				bne		loop_new_rank
				rts
;********************************************************
;				UgpJ[g[uZbg
;********************************************************
Result_move		equ		$
				mem16
				idx16
;<<<<<<<<<<<<<<<<<<< ]Zbg >>>>>>>>>>>>>>>>>>>
				lda		#0008
				sta		<Revolve_counter
Revolve_loop1	ldx     <Revolve_counter
				lda     rank_index,x
				tax
				lda     <driver_number,x
				JSR		Revolve_set
;<<<<<<<<<<<<<< Pt[WJ[gZbg >>>>>>>>>>
revolve_count1	ldx		<Revolve_counter				
				inx
				inx
				cpx		#0010h
				beq		stop_revolve2				;owatri?:yes-->stop_revolve1
				stx		<Revolve_counter
				jmp		Revolve_loop1
stop_revolve2	stz		<Revolve_counter
;-------(UZbg)-----------
				ldx		<Swing_counter
				lda     rank_index,x
				tax
				JSR		SWING_SET
;-------(ړZbg)------------
Set_move1		inc		<Xmove_counter		;J[g̊ԂJ邽߂̃JE^[
				lda		<Xmove_counter
				cmp		#0028h
				bne		Flag_move_set
				stz		<Xmove_counter
;
				ldx     <Move_counter			
				lda		rank_index,x
				tax
				JSR		MOVE_SET
;-------(`rZbg)-------------
				ldx		#1000h
				JSR		Chibi_set_sub
				ldx		#1100h
				JSR		Chibi_set_sub
;-------(̗hZbg)---------
Flag_move_set	inc		<Flag_timer			;̗hԊu^C}[ƃ`FbN
				lda		<Flag_timer
				cmp		#0004
				bne		Flag_speed_set
;
				stz		<Flag_timer			;̃LN^[Zbg
				ldx		<Flag_counter
				JSR     Flag_move
;
				ldx		<Flag_counter		;̎ރZbg
				inx	
				inx
				stx		<Flag_counter
				cpx		#0006
				bne		Flag_speed_set
				stz		<Flag_counter
;
Flag_speed_set	lda		#0001
				sta		<OBJ_check_flag 
				ldx		#0100h
				mem8
				sep		#00100000b
loop_flag		dec		oamdat,x
				lda		oamdat,x
				cmp		#0ffh
				bne		loop_flag_set
				JSR		OBJ_ERASE
loop_flag_set	JSR		X_inx
				cpx		#0110h
				bne		loop_flag
				mem16
				rep		#00100000b
				rts
;*********************************************************
;					|CgpJ[g[uZbg
;*********************************************************
Kart_move		equ		$
				mem16
				idx16
;----(UZbg)----
				ldx		<Swing_counter
				lda     point_rank,x
				tax
				JSR		SWING_SET
;-----(ړZbg)----
Set_move		inc		<Xmove_counter		;J[g̊ԂJ邽߂̃JE^[
				lda		<Xmove_counter
				cmp		#28h
				bne		owari_Rank_move
				stz		<Xmove_counter
;
				ldx     <Move_counter			
				lda		point_rank,x
				tax
				JSR		MOVE_SET
;-----(`rZbg)-----
				ldx		#1000h
				JSR		Chibi_set_sub
				ldx		#1100h
				JSR		Chibi_set_sub
owari_Rank_move	rts
;**********************************************************
;					J[gpTu[`W
;**********************************************************
Revolve_set		equ		$
;<<<<<<<<<<<<<<<< ]Zbg >>>>>>>>>>>>>>>>>>>>>
				idx16
				mem16
				tax
				lda     Kart_select,x
				tax
				lda		#0800h						;revolve speed set.		
				clc
				adc		<_poseQ,X
				sta		<_poseQ,X
				rts
;<<<<<<<<<<<<<<<<< spU >>>>>>>>>>>>>>>>>>>
SWING_SET		equ		$
				lda		<_situationYH,x
				cmp		#00c0h
				bne		Set_down
				inc		a
				jmp		Set_Yposition
Set_down		dec		a
Set_Yposition	sta		<_situationYH,x				
;-------(JEgAbv)---------
				inc		<Swing_counter
				inc		<Swing_counter
				lda		<Swing_counter
				cmp		#0010h
				bne		owari_swing
reset_swing		stz		<Swing_counter
owari_swing		rts
;<<<<<<<<<<<<<<< J[gsZbg >>>>>>>>>>>>>>>>>>
MOVE_SET		equ		$
				lda     <driver_number,x
				tax	
				lda     Kart_select,x
				tax
;
				lda		#-100h				;sZbg
				sta		<_velocityX,x
;-------(JEgAbv)---------
				ldx     <Move_counter
				inx
				inx
				cpx		#0010h
				beq		Kart_reset				;owari?:yes-->Kart_reset
				stx		<Move_counter
				jmp		Kart_owari
Kart_reset		stz		<Move_counter
Kart_owari		rts
;
;<<<<<<<<<<<<<<< `rZbg[` >>>>>>>>>>>>>>>>>>
Chibi_set_sub	lda		kart_status,x
				and		#4000h
				beq		end_Chibi_set_sub
;
				lda		driver_number,x
				tax
				lda     Kart_select,x
				tax
				lda		#0002
				sta		<_demokart_size,x
end_Chibi_set_sub
				rts

;******************************************************
;					XN[Zbg
;******************************************************
Driver_SCROLL	equ		$
				mem16
				idx16
				lda		<Scroll_2h			;scroll set.
				sec
				sbc		#0140h
				sta		<Scroll_2h
				mem8
				sep		#00100000b
				lda		<Scroll_2h+2
				sbc		#0
				sta		<Scroll_2h+2
				mem16
				rep		#00100000b
				rts
;******************************************************
;				LOAŏI`FbN
;******************************************************
Rank_End		equ		$
				mem16
				idx16						
				lda     All_end_counter
				cmp		#000fh
				bne		owari_rank_end
;<<<<<<<<<<<<<<<<<< {^`FbN >>>>>>>>>>>>>>>>
				lda		<button_TG
				ora		<button_TG+2
				and		#9000h
				bne		Check_final_set
owari_rank_end	rts
;<<<<<<<<<<<<<<<<< ŏIR[X`FbN >>>>>>>>>>>>>
Check_final_set	lda		map_pointer			
				cmp		#0005
				bne		Set_race
;<<<<<<<<<<<<<< lLXg Zbg >>>>>>>>>>>>>>>>>>>>
Set_final		JSR		Rank_Check
				cpx		#0006h
				bcc		Set_award
				lda		#0001
				sta		Player_rank_flag
Set_award		lda		#0018h				;t@CiZbg
				jmp		Set_selecta
;
Set_world		lda		#0008h				;[hZbg
				jmp     Set_selecta
;		
Set_race		lda     #0002h				;̃[XZbg
Set_selecta		sta     <game_selecta
;
				lda     #8f00h
				sta     <fade_control
;
				JSL		>BGM_fade_out
;
				rts
;
;********************************************************
;					ʁAŏI`FbN
;********************************************************
Result_end		equ		$
;<<<<<<<<<<<<<< tO@`FbN >>>>>>>>>>>>>>>>>
				mem16
				idx16
				lda		<NO_display_flag
				cmp		#0001h
				bne		owari_result
;<<<<<<<<<<<<<<<<<< {^`FbN >>>>>>>>>>>>>>>>
				lda		<button_TG
				ora		<button_TG+2
				and		#9000h
				bne		Set_point
owari_result	rts
;<<<<<<<<<<<<<< lLXg Zbg >>>>>>>>>>>>>>>>>>>>
Set_point		JSL     >Zero_clear			;[y[WNA[
				mem16
				idx16
				rep		#00110000b
				ldy		#OBJ_data1			;J[gIuWFăZbg
				JSL		>Init_demokart
;
				lda		#0027h
				sta		<Xmove_counter
;
				lda		#1125h				;AhXZbg
				sta		<name_address
;
				lda		#0001				;LOZbgtO
				sta		<Driver_flag
;
				ldy		#000ch				;LN^[naiZbg
				JSR		Cup_character_set
;
				JSR     RANKING_set
				stz     <Rank_counter
				rts
;===============================================================
;***************************************************************
;						NMI	ROUTINE
;***************************************************************
;===============================================================
;******************************************************
;					TENSOU SET
;******************************************************
Name_tensou		equ		$
				mem16
				idx16
				lda		fade_control
				bne		owari_nmi
;<<<<<<<<<<<<<<<< OA VRAM set >>>>>>>>>>>>>>
;---(AhXZbg)----
				lda     <name_address			
				sta     Screen_address
;----(])-------
				ldx		#0
loop_Z2			lda		kart_set,x	
				sta		Screen_write
				inx
				inx
				cpx		#0034h
				bne		loop_Z2	
owari_nmi		rts
;<<<<<<<<<<<<<< ʗptbVO >>>>>>>>>>>>>>
Result_Flashing	equ		$
;-------(^C}[`FbN)--------
Flash_tensou	inc		<Flash_timer
				lda		<Flash_timer
				cmp		#0005
				bcs		Color_flash
				ldy		#0018h
				jmp		Flash_tensouset
Color_flash		ldy		#001ah
				cmp		#0009h
				bne		Flash_tensouset		
				stz		<Flash_timer
;-------(PvC[p)----------
Flash_tensouset	lda		<Player_1_rank
				sta     Screen_address
;
				ldx		#0
loop_flash		lda		Flash_buffer_1p,x
				and		Color_data,y
				sta		Screen_write
				inx
				inx
				cpx		#0034h
				bne		loop_flash	
;------(vC[`FbN)-----
				lda		<game_mode
				bne		owari_flash_nmi
;------(2vC[p)----------
				lda		<Player_2_rank
				sta     Screen_address
;
				ldx		#0
loop_flash_1	lda		Flash_buffer_2p,x
				and		Color_data,y
				sta		Screen_write
				inx
				inx
				cpx		#0034h
				bne		loop_flash_1	
owari_flash_nmi	rts
;<<<<<<<<<<<<<< LOptbVO >>>>>>>>>>>>>>
Rank_Flashing	equ		$
;-------(^C}[`FbN)--------
Flash_tensou1	inc		<Flash_timer
				lda		<Flash_timer
				cmp		#0005
				bcs		Color_flash1
				ldy		#0014h
				jmp		Flash_Address
Color_flash1	ldy		#0016h
				cmp		#0009h
				bne		Flash_Address
				stz		<Flash_timer
;-------(PvC[p)----------
Flash_Address	lda		<Player_1_rank
				sec
				sbc     #0bfeh
				sta     Screen_address
;
				ldx		#0
loop_flash1		lda		Flash_buffer_1p,x
				ora		Color_data,y
				sta		Screen_write
				inx
				inx
				cpx		#0034h
				bne		loop_flash1	
;------(vC[`FbN)-----
				lda		<game_mode
				bne		End_flash_nmi
;------(2vC[p)----------
				lda		<Player_2_rank
				sec
				sbc		#0bfeh
				sta     Screen_address
;----(])-------
				ldx		#0
loop_flash_11	lda		Flash_buffer_2p,x
				ora		Color_data,y
				sta		Screen_write
				inx
				inx
				cpx		#0034h
				bne		loop_flash_11	
End_flash_nmi	rts

				END

