;*********************************************************************
;	mario kart << sprite car >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		include	../DEF/sound.def
		include	../DEF/effect.def
;-----------------------------------------------
		glb	fire_check
		glb	mykart_state,enemy_state
;-----------------------------------------------
		ext	debug_FLAG
		ext	Mount_fire
		ext	Trigger_sound_1
		ext	End_muteki_status
;-----------------------------------------------
		COMN
work	ds	2
		EXTEND
objprog	SECT	REL
		mem16
		idx16
;####################################################################
;		J[geRg[
;####################################################################
;*********************************************************************
;		}CJ[ACeg`FbN
;*********************************************************************
;-----------------------fedcba9876543210-----------------------------
speed_up	EQU	1000000000000000B
jump		EQU	0100000000000000B
star		EQU	0010000000000000B
fire_kame	EQU	0001000000000000B
fire_banana	EQU	0000100000000000B
fire_missile	EQU	0000010000000000B
fire_all	EQU	fire_kame+fire_banana+fire_missile
fire_obake	EQU	0000001000000000B
fire_coin	EQU	0000000100000000B
;XXXX		EQU	0000000010000000B	; G̃WvgKI
fire_sunder	EQU	0000000001000000B	; T_[gKI	
;--------------------------------------------------------------------
;
fire_check	PHX			;>>
;--------------------------------------------------------------------
;	}CJ[̃nh
;--------------------------------------------------------------------
		ldx	<register
		ldy	<screen_register
		lda	!button_status+1,y
		ldy	<_kart_handle,x
		lsr	a
		bcs	right$
		lsr	a
		bcs	left$
;- - - - - - - - - - - - - - - - - - - - - - - 
		tya				; L[͖
		beq	skip2$
		bmi	right$
		bpl	left$

;- - - - - - - - - - - - - - - - - - - - - - - 
left$		tya				; ɃL[ꂽ
		cmp	#-7
		beq	skip$
		dec	a
		bra	skip$
;- - - - - - - - - - - - - - - - - - - - - - - 
right$		tya				; EɃL[ꂽ
		cmp	#7
		beq	skip$
		inc	a
skip$		sta	<_kart_handle,x
;- - - - - - - - - - - - - - - - - - - - - - - 
skip2$
;--------------------------------------------------------------------
;	fobOpXyVgK
;--------------------------------------------------------------------

		LDA	!debug_FLAG
		AND	#00010000B		; debug ITEM
		BEQ	item_entry
		LDY	<screen_register
		LDA	!button_trigger+0,Y
		LDY	#speed_up
		BIT	#A_button
		BNE	fire_019
		LDY	#star
		BIT	#X_button
		BNE	fire_019
		BIT	#Y_button
		BEQ	fire_018

;- - - - - - - - - - - - - - - - - - - - - 
		LDY	#jump
		bit	#UP_button	; Y + UP
		BEQ	fire_017
		ldy	#fire_sunder
		BRA	fire_019
fire_017	bit	#DW_button	
		BEQ	fire_019	; Y + DW
		ldy	#fire_obake
		BRA	fire_019
;- - - - - - - - - - - - - - - - - - - - - 

fire_018	LDY	#fire_banana
		BIT	#SL_button
		BNE	fire_019
		LDY	#fire_kame
		BIT	#button_L
		BNE	fire_019
		LDY	#fire_missile
		BIT	#button_R
		BEQ	item_entry
fire_019	TYA
		ORA	<special_trigger,X
		STA	<special_trigger,X
;--------------------------------------------------------------------
;	UACe̎gp`FbN
;--------------------------------------------------------------------
item_entry	LDA	<special_trigger,X
		BIT	#fire_all
		BEQ	obake_entry
		LDY	#0		; 0 = fire banana  (oiij
		BIT	#fire_banana
		BNE	banana_special
		INY			; 1 = fire kame (΃K)
		BIT	#fire_kame
		BNE	kame_special
		INY			; 2 = fire missile  (ԃKj
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
fire_entry	AND	#(fire_all^0ffffh)
		STA	<special_trigger,X
		JSR	Mount_fire
		jmp	fire_exit
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
banana_special	ldx	<screen_register
		lda	<button_status,x
		and	#UP_button+LF_button+RT_button	
		cmp	#UP_button
		bne	skip$
		ldy	#6
skip$		ldx	<register
		lda	<special_trigger,x
		bra	fire_entry
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
kame_special	ldx	<screen_register
		lda	<button_status,x
		and	#DW_button+LF_button+RT_button	
		cmp	#DW_button
		bne	skip$
		ldy	#7
skip$		ldx	<register
		lda	<special_trigger,x
		bra	fire_entry
;--------------------------------------------------------------------
;	IoP̎gp`FbN
;--------------------------------------------------------------------
obake_entry	bit	#fire_obake
		beq	coin_entry
		and	#(fire_obake^0ffffh)
		sta	<special_trigger,x
;
;- - - - - - - - - - - - - - - - - - - - - - 
; 	}CJ[
;- - - - - - - - - - - - - - - - - - - - - - 

		lda	#D_obake_timer
		sta	<_obake_timer,x

;- - - - - - - - - - - - - - - - - - - - - - 
		lda	<screen_register
		tay
		eor	#02h
		tax
		lda	!slot_flag,x
		bpl	exit$
;- - - - - - - - - - - - - - - - - - - - - - 
; tỎ OK I
;- - - - - - - - - - - - - - - - - - - - - - 
		sta	!slot_flag,y
		and	#0a000h
		cmp	#0a000h
		beq	skip$
;
		lda	!slot_flag,y
		and	#0fh
		ora	#8000h
		sta	!slot_flag,y
;
		lda	#40H			; stop timer
		bra	over$
;- - - - - - - - - - - - - - - - - - - - - - 
skip$		lda	!slot_timer,x
over$		sta	!slot_timer,y
		lda	!slot_pointer,x
		sta	!slot_pointer,y
		lda	!slot_result,x
		sta	!slot_result,y
;
		lda	#40H
		sta	!slot_timer,x
		lda	#1001000000000000b	; (xoZbgj
		sta	!slot_flag,x
;
		lda	#SE_obake_1		; 萬 sound
		jsl	>sound_entry
		bra	obake_exit$
;- - - - - - - - - - - - - - - - - - - - - - 
; tỎ莸s
;- - - - - - - - - - - - - - - - - - - - - - 
exit$		lda	#40H
		sta	!slot_timer,y
		lda	#1001000000000000b	; ŁixoZbg)
		sta	!slot_flag,y
		lda	#SE_obake_2
		jsl	>sound_entry
obake_exit$	jmp	fire_exit
;- - - - - - - - - - - - - - - - - - - - - - - - - -
sound_entry	jml	(!screen_sound)
;--------------------------------------------------------------------
;	RC̎gp`FbN
;--------------------------------------------------------------------
coin_entry	bit	#fire_coin
		beq	sunder_entry
		and	#(fire_coin^0ffffh)
		sta	<special_trigger,x
		ldy	<screen_register
		lda	#13			; RCfZbg
		sta	!coin_flag,y
		lda	!player_coin,y		; RCQǉ
		inc	a
		inc	a
		sta	!player_coin,y
		bra	fire_exit
;--------------------------------------------------------------------
;	T_[̎gp`FbN
;--------------------------------------------------------------------
sunder_entry	bit	#fire_sunder
		beq	muteki_entry
		and	#(fire_sunder^0ffffh)
		sta	<special_trigger,x
		phx
		jsr	Set_sunder
		plx
		bra	fire_exit
;--------------------------------------------------------------------
;	G̎gp`FbN
;--------------------------------------------------------------------
					; G^C}[Zbg
muteki_entry	BIT	#star
		BEQ	muteki_150
		LDA	#8000H		; difence up!
		ORA	<_HP,X
		STA	<_HP,X
		LDA	#200h		; G TIME
		BRA	muteki_160
;-----------------------------------------------------------------
;					; G^C}[ DEC
muteki_150	LDA	<_muteki_timer,X
		BEQ	fire_exit
		DEC	A
		BEQ	muteki_end
		LDY	<_BGcheck_status,X
		CPY	#52H
		BCC	muteki_160	
		DEC	A
		BEQ	muteki_end	; 0 ̂Ƃ GhgK
		BPL	muteki_160	
		LDA	#0		; 0 ȉ  GhgK
;- - - - - - - - - - - - - - - - - - - - -
; = = ^C}[ɂ閳GI = = 
muteki_end	PHA			; >>
		lda	#4000h
		and	<kart_status,x
		sta	<kart_status,x	; status clear
		LDA	<_HP,X
		AND	#7FFFH		; difence nomalg
		STA	<_HP,X
		jsl	>End_muteki_status
		PLA			; <<
;- - - - - - - - - - - - - - - - - - - - -

muteki_160	STA	<_muteki_timer,X
;-----------------------------------------------------------------
;	ACeI
;-----------------------------------------------------------------
fire_exit	PLX			;<<
		INX
		INX
		JMP	(!0,X)


;*********************************************************************
;	ȊÕJ[g`rɂ鏈
;*********************************************************************
		ext	sound_sunder

Set_sunder	stx	<work

	;;;	jsl	>sound_sunder

		lda	#0800h
		tsb	<sound_size


		ldy	#D_window_index
		lda	!window_index+0
		bne	skip_0$
		sty	!window_index+0
skip_0$		lda	!window_index+2
		bne	skip_1$
		sty	!window_index+2
	
skip_1$
		lda	#40H
		sta	!window_timer+0
		sta	!window_timer+2


		ldy	<screen_register
		ldy	#rank_index

;- - - - - - - - - - - - - - - - - - - - - - - -
		ldx	<0,y
loop$		cpx	<work		 ; vC[ɂ̓Zbg
		beq	skip_4$
;
		lda	#spin_right
		ora	<kart_status,x
		sta	<kart_status,x
		lda	#spin_power
		sta	<spin_counter,x
		lda	<_effect_flag,x		;XsgKI
		ora	#effect_spin+effect_spin_c
		sta	<_effect_flag,x
;
		lda	<_sunder_timer,x
		bmi	skip_4$
		beq	skip_2$
		cmp	#D_sunder_nomal
		bcs	skip_4$
		lda	#D_sunder_nomal-1
		bra	skip_3$
skip_2$		bit	<_flag,x
		bpl	skip_21$
		lda	#00040h		; }CJ[`r
		cpx	#player_r0
		beq	skip_22$
		lsr	a		; 
skip_22$	tsb	<sound_size
skip_21$	lda	#D_sunder_timer
skip_3$		sta	<_sunder_timer,x
skip_4$		iny
		iny
skip$		ldx	<0,y
		bne	loop$
;- - - - - - - - - - - - - - - - - - - - - - - -
		rts




;*********************************************************************
;	}CJ[[`
;*********************************************************************
mykart_state
		phx
		ldx	<register
;- - - - - - - - - - - - - - - - - - - - - - -  ; }CJ[_bV
		lda	<_HP,x
		ldy	<move_status,x
		cpy	#10h
		bne	dash_exit$
		ora	#0020h
		bra	dash_set$
dash_exit$	and	#(020h^0ffffh)
dash_set$	sta	<_HP,x
;- - - - - - - - - - - - - - - - - - - - - - -  ; 
		lda	<_poo_status,x
		bpl	obake$
		lda	<spin_counter,x		; XsƂ !
		cmp	#100h
		bcs	poodown$
		lda	<_muteki_timer,x	; GłƂ I
		beq	obake$
poodown$	lda	#7fffh
		and	<_poo_status,x
		sta	<_poo_status,x
obake$
;- - - - - - - - - - - - - - - - - - - - - - -  ; }CJ[H
		lda	<_obake_timer,x
		beq	coin$
		dec	a
		sta	<_obake_timer,x	
;- - - - - - - - - - - - - - - - - - - - - - - -; }CJ[RCO
coin$		lda	<game_status
		cmp	#06
		beq	exit$
		ldy	<screen_register
		lda	!player_coin,y
		bne	coinskip$
		lda	<_HP,x
		and	#(008h^0ffffh)		; ( power down ! )
		bra	coinset$
;- - - - - - - - - - - - - - - - - -
coinskip$	lda	<_HP,x
		ora	#008h			; ( power up ! )
coinset$	sta	<_HP,x
;- - - - - - - - - - - - - - - - - - - - - - - -; }CJ[`r
sunder$		lda	<_sunder_timer,x
		cmp	#40h
		bne	skip$
		lda	#2000h
		cpx	#player_r0
		beq	sound$
		lsr	a
sound$		tsb	<sound_size
skip$		
;- - - - - - - - - - - - - - - - - - - - - - - -;
		lda	<_sunder_timer,x
		beq	exit$
		bmi	exit$
		dec	a
		sta	<_sunder_timer,x
		beq	clear$
;- - - - - - - - - - - - - - - - - - - - - - -
		lda	<_HP,x		; `rZbg
		and	#(0010h^0ffffh)
		sta	<_HP,x
		bra	exit$
clear$		lda	<_HP,x		; `r
		ora	#0010h
		sta	<_HP,x
exit$		plx
		INX
		INX
		JMP	(!0,X)
;- - - - - - - - - - - - - - - - - - - - - - -


;*********************************************************************
;	Gԗp[`
;*********************************************************************
enemy_state	phx

		lda	<frame_counter-1
		and	#0700h
		ora	#1000h
		cmp	<register
		bne	exit$
		tax

;- - - - - - - - - - - - - - - - - - - - - - -  ; Gӂނ - - - 
		lda	<_kart_pose,x
		bpl	pose$
		clc
		adc	#8
		bit	#0100h		
		beq	skip$
		lda	#0
skip$		sta	<_kart_pose,x
pose$
;- - - - - - - - - - - - - - - - - - - - - - -  ; GG - - - 
		lda	<_muteki_timer,x	
		beq	sunder$
		sec
		sbc	#8
		bpl	m100$
		lda	#0
m100$		sta	<_muteki_timer,x
		beq	clear$
		lda	<_HP,x		; GZbg
		ora	#8000h
		sta	<_HP,x
		bra	sunder$
clear$		lda	<_HP,x		; G
		and	#0fffh
		sta	<_HP,x
;- - - - - - - - - - - - - - - - - - - - - - -  ; G`r - - - 
;
sunder$		lda	<_sunder_timer,x
		beq	exit$
		bmi	exit$
		sec
		sbc	#8
		bpl	skip2$
		lda	#0
skip2$		sta	<_sunder_timer,x
		beq	clear2$
;- - - - - - - - - - - - - - - - - - - - - - -
		lda	<_HP,x		; `rZbg
		and	#(0010h^0ffffh)
		sta	<_HP,x
		bra	exit$

clear2$		lda	#400h
		tsb	<sound_size
		lda	<_HP,x		; `r
		ora	#0010h
		sta	<_HP,x
;- - - - - - - - - - - - - - - - - - - - - - -
exit$		plx
		INX
		INX
		JMP	(!0,X)
;- - - - - - - - - - - - - - - - - - - - - - -
