;******************* Final.asm *************************
			extend
;-----------------------------------------------------
			include		../join/rp5c77
			include		../join/buffer.def
			include		../join/rp5a22
			include     ../join/work.def
			include		../join/label.def
			include		../join/object.def
;-----------------------------------------------------
			ext		Set_DMA,PPU_INT_SET,Rotate_mode7
			ext		KEY_CHECK
;
			glb		Final_init,Final_main,Final_nmi
			glb		OBJ_ERASE,X_inx,Y_iny
;-----------------------------------------------------
addr			equ		60h			;3byte
Pose_counter	equ		63h
Pose_timer		equ		65h
Pose_flag		equ		67h
button_TG       equ     6ah  		;4byte
Fight_counter	equ		6eh
;
Set_address		equ		70h
Scroll_X		equ		72h			;3byte
Center_X		equ		75h
Move_flag		equ		77h
Patern_counter	equ		79h
Cmp_check		equ		7bh
Angle_set		equ		7dh
Zoom_set		equ		7fh
;
Center_Y		equ		81h			;3byte
Scroll_Y		equ		84h
revolve_flag	equ		86h
Scroll_speed	equ		88h
MAKU_counter	equ		8ah
maku_flag		equ		8ch
Champgne_timer	equ		8eh
;
kage_flag		equ		90h
Maku_position	equ		92h
OBJ_check_flag	equ		96h
MAKU_move_flag	equ		98h
MAKU_speed_cmp	equ		9ah
V_pos_dec		equ		9ch
Patapata_speed	equ		9eh
;
X_cmp			equ		198h
Rom_offset		equ		19ah
Zannen_counter	equ		19ch
Zannen_timer	equ		19eh
;
Fight_timer		equ		1a0h
Explosion_count	equ		1a2h
Explosion_timer	equ		1a4h
Cork_place		equ		1a6h
Award_counter	equ		1a8h
KAO_counter		equ		1aah
Shock_flag		equ		1ach
kumo_flag		equ		1aeh
;
Message_counter	equ		1b0h
Message_timer	equ		1b2h
Message_position equ	1b4h
yossy_flag		equ		1b6h
Color_timer		equ		1b8h
Paragraph_cmp	equ		1bah
Start_position	equ		1bch
Zannen_V_ram	equ		1beh
;
Set_color		equ		1f0h
Turu_counter	equ		1f2h
;-----------------------------------------------------
Hdma_data		equ		180h
oamdat			equ		200h
msbdat			equ		400h
Color_buffer	equ		1c0h
;
rotate_A		equ		190h
rotate_B        equ     192h
rotate_C        equ     194h
rotate_D        equ     196h
;
;-----------------------------------------------------
bankf      		sect    rel         ;(PBR=0f)
;===================================================================
;*******************************************************************
;					INITIAL ROUTINE
;*******************************************************************
;===================================================================
Final_init		equ		$
				phb
				phk
				plb
				mem8
				idx8
				sep		#00110000b
;
				stz		<trans_counter
				JSR     PPU_INT_SET         ;ppu&oam initial
				JSR		Final_PPU
				JSR		Final_tensou
;
				mem16
				idx16
				rep		#00110000b
				plb
				RTL
;
;=================================================================
;*****************************************************************
;					MAINE ROUNTINE
;*****************************************************************
;=================================================================
Final_main		equ		$
				phb
				phk
				plb
;<<<<<<<<<<<<<<<< {^`FbN >>>>>>>>>>>>>>>>>
				JSR     KEY_CHECK
;<<<<<<<<<<<<<<<< \Zbg >>>>>>>>>>>>>>>>>>>>>
				JSR		AWARD_SET
;<<<<<<<<<<<<<<<< Sʈȏ`FbN >>>>>>>>>>>>>>
				JSR		Rank_Check
				cpx		#0006h
				bcc		AWARD_routine
;<<<<<<<<<<<<<<<<< cOZbg >>>>>>>>>>>>>>>>>>>>
				JSR		Message_set
				JSR		Zannen_pose
				jmp		owari_main
;<<<<<<<<<<<< ^C}[`FbN >>>>>>>>>>>>>
AWARD_routine	lda		<Champgne_timer
				cmp		#0250h
				bcc		Check_rank_set		
				JSR		MAKU_zoom
				jmp		owari_main
;<<<<<<<<<<<<<< N`FbN >>>>>>>>>>>>>>>>>>>
Check_rank_set	JSR		Rank_Check				
				jmp		(!Select_rank,x)				;NCfbNXWv
;<<<<<<<<<<<<<<< NP >>>>>>>>>>>>>>>>>>>>>>>>
Rank_1			JSR     Scroll_set
				JSR		KAGE_move
				JMP		owari_main
;<<<<<<<<<<<<<<< N2 >>>>>>>>>>>>>>>>>>>>>>>>>
Rank_2			equ		$
				JSR		Scroll_set1
				JMP     owari_main
;<<<<<<<<<<<<<<< N3 >>>>>>>>>>>>>>>>>>>>>>>>>
Rank_3			equ		$
				JSR		Patapata_walk
;<<<<<<<<<<<<<<< _XN[Zbg >>>>>>>>>>>>>>
owari_main		JSR		KUMO_move
;				JSR		Final_end_set
				plb
				RTL
;================================================================
;***************************************************************
;					NMI wari komi.			  
;***************************************************************
;================================================================
Final_nmi			equ		$
				phb
				phk
				plb
;
				mem8
				idx8
				sep		#00110000b
;<<<<<<<<<<<<<< XN[Zbg >>>>>>>>>>>>>>>>>>
				lda		<Scroll_X+1
				sta     Scroll_0H
				lda		<Scroll_X+2
				sta     Scroll_0H
;
				lda     <Scroll_Y
				sta     Scroll_0V
				lda     <Scroll_Y+1
				sta     Scroll_0V
;<<<<<<<<<<<<<<< gkA]Zbg >>>>>>>>>>>>>>
				lda		rotate_A
				sta		Rotation_A
				lda		rotate_A+1
				sta		Rotation_A
;
				lda		rotate_B
				sta		Rotation_B
				lda		rotate_B+1
				sta		Rotation_B
;
				lda		rotate_C
				sta		Rotation_C
				lda		rotate_C+1
				sta		Rotation_C
;
				lda		rotate_D
				sta		Rotation_D
				lda		rotate_D+1
				sta		Rotation_D
;<<<<<<<<<<<<<<<< Z^[Zbg >>>>>>>>>>>>>>>>>>>>
				lda		<Center_X
				sta		Rotation_X
				lda		<Center_X+1
				sta     Rotation_X
;
				lda		<Center_Y
				sta     Rotation_Y
				lda     <Center_Y+1
				sta		Rotation_Y
;<<<<<<<<<<<<<<<<< g|cl`Zbg >>>>>>>>>>>>>>>>>
				lda		#06
				sta     DMA_synchronic
;<<<<<<<<<<<<<<<< Sʈȏ`FbN >>>>>>>>>>>>>>
				mem16
				idx16
				JSR		Rank_Check
				cpx		#0006
				bcs		owari_nmi_set
				mem8
				idx8
				sep		#00110000b
;<<<<<<<<<<<<<<<< J[Zbg >>>>>>>>>>>>>>
				lda		#20h
				sta		Color_address
;
				ldx		#0h
color_change	lda		Color_buffer,x
				sta     Color_write
				inx
				lda		Color_buffer,x
				sta     Color_write
				inx
				cpx		#20h
				bne		color_change		
;<<<<<<<<<<<<< oA^C}[`FbN >>>>>>>>>>>>>
				mem16
				idx16
				rep		#00110000b
				lda		<Champgne_timer
				cmp		#0250h
				bcs		maku_nmi
;<<<<<<<<<<<<<<< ʃ`FbN >>>>>>>>>>>>>>>>>>>>>>>
				JSR		Rank_Check
				JMP		(!Select_kakikae,x)
;<<<<<<<<<<<<<<<< p >>>>>>>>>>>>>>>>>>>>>>>>
Pukupuku_nmi	JSR		Pukupuku_tensou		;P
				jmp		owari_nmi_set
;
Mant_nmi		JSR     Mant_tensou			;Q
				jmp     owari_nmi_set
;
maku_nmi		JSR		MAKU_tensou			;R
owari_nmi_set	plb
				rtl
;<<<<<<<<<< N`FbNTu[` >>>>>>>>>>>>>>
Rank_Check		equ		$
				mem16
				idx16
				rep		#00110000b
				ldx		#0
				lda		game_mode			;vC[`FbN
				beq		Check_rank1
;
Check_rank		lda		point_rank,x		;lpNZbg
				cmp		#1000h
				beq		owari_rank_chk
				inx
				inx
				jmp		Check_rank
;
Check_rank1		lda		point_rank,x		;lpNZbg
				cmp		#1000h
				beq		owari_rank_chk
				cmp		#1100h
				beq		owari_rank_chk
				inx
				inx
				jmp		Check_rank1
owari_rank_chk	rts
;===================================================================
;******************************************************************
;						INITIAL SET ROUTINE
;******************************************************************
;==================================================================
;******************************************************
;					PPU&WORK INITIAL SET
;******************************************************
Final_PPU		equ		$
;<<<<<<<<<<<<<<< [y[WNA[ >>>>>>>>>>>>>>>>
				mem8
				idx8
;
				ldx		#0
				lda		#0
loop_GPZX		sta		<addr,x
				inx
				cpx		#40h
				bne		loop_GPZX
;
				mem16
				rep		#00100000b
				lda		#0180h
				sta		<Center_X
				lda		#0160h
				sta		<Center_Y
;
				lda		#0080h
				sta		<Scroll_X+1
				lda		#0100h
				sta		<Scroll_Y
;
				sta		rotate_A
				sta     rotate_D
				stz		rotate_B
				stz		rotate_C
;
				ldx		#0
				lda		#0
loop_Zero		sta		Fight_timer,x
				inx
				inx
				cpx		#20h
				bne		loop_Zero
;
				lda		#0c00h
				sta		MAKU_counter
				lda		#0002h
				sta		Explosion_timer
				lda		#0001
				sta		yossy_flag
				lda		#6040h
				sta		Message_position
				stz		Zannen_timer
;
				mem8
				sep		#00100000b
;<<<<<<<<<<<<<<<<< PPU SET >>>>>>>>>>>>>>>>>>>>>>>>>>
Set_PPU			lda		#0
				sta		Screen_bank
;
				lda		#01100100b
				sta		Screen_bank+1
;
				lda		#01100000b
				sta		Screen_segment
;
				lda     #10000000b
				sta     Screen_step
;
				lda		#00000010b
				sta		Sprite_size
;
				lda		#80h
				sta		Screen_flip
;  
				stz		Rotation_A
				stz     Rotation_B
				stz     Rotation_C
				stz		Rotation_D
				lda		#01
				sta		Rotation_A
				sta		Rotation_D
				stz     Rotation_B
				stz     Rotation_C
;
				lda		#80h
				sta		Rotation_X
				lda		#01
				sta     Rotation_X
				sta		Rotation_Y
				lda		#60h
				sta     Rotation_Y
				rts
;**********************************************************
;					TENSOU SET
;**********************************************************
Final_tensou	equ		$
;<<<<<<<<<<<<<<<<<<<<< OBJ >>>>>>>>>>>>>>>>>>>>>>>>>>
				ldx		#1ch
				jsr     Set_DMA
;<<<<<<<<<<<<<<<<<<<< bfw >>>>>>>>>>>>>>>>>>>>
 				ldx		#22h
				jsr		Set_DMA
;
				mem16
				rep		#00100000b
				lda		#5800h
				sta		Screen_address
;
				ldx		#0
loop_number		lda		>7fa080h,x
				sta		Screen_write
				inx
				inx
				cpx		#00a0h
				bne		loop_number
;
				ldx     #0
				lda		#58b0h
				sta     Screen_address
loop_J			lda		>7fa260h,x
				sta		Screen_write
				inx
				inx
				cpx		#0020h
				bne		loop_J
;
				ldx     #0
				lda		#58c0h
				sta     Screen_address
loop_R			lda		>7fa360h,x
				sta		Screen_write
				inx
				inx
				cpx		#0020h
				bne		loop_R
;
				mem8
				sep		#00100000b
;<<<<<<<<<<<<<<<<<<<<<< SC_2.CGX >>>>>>>>>>>>>>>>>>>>
				ldx		#1eh
				jsr     Set_DMA
;<<<<<<<<<<<<<<<<<<<<<< SC_2 >>>>>>>>>>>>>>>>>>>>>>>>
				ldx		#20h
				jsr		Set_DMA
;<<<<<<<<<< 㔼gnaiLN^[Zbg >>>>>>>>>>
				idx16
				mem16
				rep		#00110000b
;
				lda		#5400h					;}IZbg
				ldx		#0
				JSR		Kart_set
;
				lda		#5600h					;C[WZbg
				ldx		#0003h
				JSR		Kart_set

				lda		#5440h					;NbpZbg
				ldx		#0006h
				JSR     Kart_set
;
				lda		#5480h					;s[`Zbg
				ldx		#0009h
				JSR		Kart_set
;
				lda		#54c0h					;ROZbg
				ldx		#000ch
				JSR		Kart_set
;
				lda		#5640h					;mRmRZbg
				ldx		#000fh
				JSR		Kart_set
;
				lda		#5680h					;LmsZbg
				ldx		#0012h
				JSR		Kart_set
;
				lda		#56c0h					;bV[
				ldx		#0015h
   				JSR		Kart_set
				jmp		CG_set
;<<<<<<<<< 㔼gLN^[ZbgTu[` >>>>>>
Kart_set		equ		$
				pha
				sta		Screen_address
;
				JSR		Rom_Set
;
				mem16			
				rep		#00100000b
				ldy		#0040h					;m[}|[Y㑤
loop_kart		JSR		Set_Vram
				cpy		#0080h
				bne		loop_kart
;
				ldy		#5900h					;u|[Y㑤
loop_kart1		JSR     Set_Vram
				cpy		#5940h
				bne		loop_kart1
;
				pla								;uq`lAhXZb
				clc
				adc		#100h
				sta		Screen_address
;
				ldy		#0240h
loop_kart2		JSR     Set_Vram				;m[}|[Y
				cpy		#0280h
				bne		loop_kart2
;
				ldy		#5b00h					;u|[Y
loop_kart3		JSR		Set_Vram
				cpy		#5b40h
				bne		loop_kart3
				rts
;
Set_Vram		equ		$						;uq`lZbg
				mem16
				idx16
loop_kao		lda		[<addr],y
				sta		Screen_write
				iny
				iny
				rts
;
Rom_Set			mem16
				idx16
				lda		OBJ_kart,x				;qnlAhXZbg
				sta		<addr
				mem8
				sep		#00100000b
				inx
				inx
				lda		OBJ_kart,x
				sta		<addr+2
				rts
;<<<<<<<<<<<<<< J[] >>>>>>>>>>>>>>>>>>>>>>>>
CG_set			mem8
				sep		#00100000b
			 	lda		#00000000b			
				sta		Color_address
;			
      		 	ldx		#0
loop_color	 	lda		>7f4800h,x   
			 	sta		Color_write
			 	inx
        	 	lda     >7f4800h,x
			 	sta     Color_write
			 	inx
			 	cpx		#200h
			 	bne		loop_color
;<<<<<<<<<<<<<<<<< ʃ`FbN >>>>>>>>>>>>>>>>>>>
				JSR		Rank_Check
				cpx		#0006
				bcs		Set_mode7
;<<<<<<<<<<<<<<<< J[Zbg >>>>>>>>>>>>
				mem8
				sep		#00100000b
				lda		#20h
				sta		Color_address
;
				mem16
				rep		#00100000b
				ldy		#0000
				lda		CG_Address,x
				tax
				mem8
				sep		#00100000b
loop_change		lda		>7f0000h,x
				sta     Color_write
				sta		Color_buffer,y
				inx
				iny
				lda		>7f0000h,x
				sta     Color_write
				sta		Color_buffer,y
				inx
				iny
				cpy		#0020h
				bne		loop_change		
;<<<<<<<<<<<<< [hVLN^[] >>>>>>>>>>>
Set_mode7		mem8
				sep		#00100000b
				stz     Screen_address
				stz     Screen_address+1
;
				ldx		#0
loop_chra		lda		>7fc000h,x
				sta     Screen_write+1
				inx
				cpx		#4000h
				bne		loop_chra
;<<<<<<<<<<<<<< afPʂZbg >>>>>>>>>>>>>>>>>
				stz     Screen_address
				stz     Screen_address+1
;
				lda     #00000000b
				sta     Screen_step
;
				ldx		#0
				lda		#06fh
loop_nuki		sta		Screen_write
				inx
				cpx		#4000h
				bne		loop_nuki
;;<<<<<<<<<<<<<<<< n`lZbg >>>>>>>>>>>>>>>>>>>
				idx16
				mem16
				rep		#00110000b
;--------(r Zbg)------------
				lda		#0b872h
				sta		oamdat+28h
				lda		#3ce0h
				sta		oamdat+2ah
;----------(\p)------------
				JSR     Banzai_award		
;----------(p^p^Ae)-----------
				ldx		#0							
Set_obj_1		lda		OBJ_DATA,x
				cmp		#0ffffh
				beq		SET_MSB
				sta		oamdat+158h,x
				inx
				inx
				jmp		Set_obj_1
;<<<<<<<<<<<<<<< lraZbg >>>>>>>>>>>>>>>>>>>>>
SET_MSB			ldx		#0
loop_msb		lda		MSB_DATA,x
				sta		msbdat,x
				inx
				cpx		#0020h
				bne		loop_msb
;<<<<<<<<<<<<<<<<< ʃ`FbN >>>>>>>>>>>>>>>>>>>
				JSR		Rank_Check
				cpx		#0006
				bcs		Zannen_kart
				JMP		(!Select_screen,x)
;<<<<<<<<<<<< vNvNpXN[Zbg >>>>>>>>>>
Pukupuku_screen	mem16
				idx16
				lda		#0100h						;vNvNp
				sta		<Zoom_set
;
				lda		#12abh
				sta		<Set_address
;
				lda		#000ch						;񐔃Zbg
				sta		<Cmp_check
				ldx		#0004						;p^[Zbg
				lda		PATERN_DATA,x
;
				mem8
				sep		#00100000b
;
				JSR		KAKIKAE_set					;Zbg
;
				mem16
				rep		#00100000b
				lda		#14b3h						;AhXăZbg
				sta		<Set_address
;
				JSR		Pukupuku_tensou
;
				mem8
				idx8
				sep		#00110000b
;
				lda		#0aah						;eAlraZbg
				sta		msbdat+18h
;
				mem16
				idx16
				rep		#00110000b				
				jmp		Erase_pata
;<<<<<<<<<<<< }gKpXN[Zbg >>>>>>>>>
Mant_screen		mem16
				idx16
				lda		#0070h						;}gKp
				sta		<Zoom_set
;
				lda		#15aeh
				sta		<Set_address
;
				JSR		Mant_tensou
				jmp		Erase_pata
;<<<<<<<<<< cOpLuQq`lZbg >>>>>>>>>>>>
Zannen_kart		lda		point_rank,x
				tax
				lda		<driver_number,x
				pha
				tax
				lda		Zannen_color,x
				sta		Set_color
				pla		
				lsr		a
				mem8
				sep		#00100000b
				sta		Multiplicand
				lda		#0003
				sta		Multiplier
				nop
				nop
				nop
				nop
				mem16
				rep		#00100000b
				lda		Product
				tax
				phx
;---------(uQq`lZbg)----------
				lda		#4ae0h
				sta		Screen_address
				sta		Zannen_V_ram		
				lda		#0020h
				sta		X_cmp
				ldy		#0
				sty		Rom_offset
				JSR		Zannen_tensou
;
				plx
				lda		#4a00h
				sta		Screen_address
				sta		Zannen_V_ram		
				lda		#00c0h
				sta		X_cmp
				ldy		#5800h
				sty		Rom_offset
				JSR		Zannen_tensou
;----------(n`lZbg)--------------
				ldx		#0
				ldy		#0
loop_zannen_set	lda		Zannen_position,x
				sta		oamdat,y
				inx
				inx
				JSR		Y_iny
				cpx		#0008
				bne		loop_zannen_set
;
				ldy		#0
				lda		Zannen_counter
				JSR		Zannen_oam_set
				jmp		Erase_pata
;---------(cO]Tu[`)---------
Zannen_tensou	equ		$
				stz		Zannen_counter
;
				JSR		Rom_Set
;
				mem8
				lda     #80h
				sta     Screen_step
;
				mem16			
				rep		#00100000b
loop_zannen		ldx		#0
loop_zannen_1	JSR		Set_Vram
				inx
				cpx		X_cmp
				bne		loop_zannen_1
;
				lda		Zannen_V_ram
				clc
				adc		#0100h
				sta		Zannen_V_ram
				sta		Screen_address
;
				lda		Rom_offset
				clc
				adc		#0200h
				sta		Rom_offset
				tay
				inc		Zannen_counter
				lda		Zannen_counter
				cmp		#0004
				bne		loop_zannen
				stz		Zannen_counter
				rts
;
Zannen_oam_set	asl		a
				tax
				lda		Zannen_pose_data,x
				tax	
loop_pose_set	lda		!0,x
				ora		Set_color
				cmp		#0ffffh
				beq		owari_set_oam
				sta		oamdat+2h,y
				JSR		Y_iny
				inx
				inx
				jmp		loop_pose_set
owari_set_oam	rts		
;<<<<<<<<<<<< p^p^naiC[XZbg >>>>>>>>>>
Erase_pata		ldx		#0158h				
				lda		#0e0f8h
loop_erase_set	sta		oamdat,x
				inx
				inx
				cpx		#0188h
				bne		loop_erase_set
				mem8
				idx8
				sep		#00110000b
;<<<<<<<<<<<<<<<< g|cl`Zbg >>>>>>>>>>>>>>>>>>>
Set_Hdma		mem8
				idx8
				sep		#00110000b
				ldx		#0
loop_hdma		lda		TENSOU_DATA,x
				sta		Hdma_data,x
				inx
				cpx		#0eh
				bne		loop_hdma
;----(H_DMA SET)--------
				lda		#0							;1address set.
				sta		DMA_1
;
				lda		#00000101b					;to 2105h
				sta		DMA_1+1
;
				lda		#10000000b					;from 180h
				sta		DMA_1+2
;
				lda		#00000001b
				sta		DMA_1+3
;
				lda		#0
				sta		DMA_1+4
;
				lda		#0
				sta		DMA_1+5
				sta		DMA_1+6
				lda		#0fh
				sta		DMA_1+7
;;- - - - - - - - - - - - - - - - - - - - - - - -
				lda		#0						;1address set.
				sta		DMA_2
;
				lda		#00101100b				;to 212ch
				sta		DMA_2+1
;
				lda		#10000101b				;from 187h
				sta		DMA_2+2
;
				lda		#00000001b
				sta		DMA_2+3
;
				lda		#0
				sta		DMA_2+4
;
				lda		#0
				sta		DMA_2+5
				sta		DMA_2+6
				lda		#0fh
				sta		DMA_2+7
owari_tensou	rts
;<<<<<<<<<<<<<<<<<	bZ[WZbg Tu[` >>>>>>>>>>>
Message_data_set
				mem16
				idx16
loop_moji		lda		!0,x
				cmp		#0ffffh
				beq		message_owari
				sta		oamdat+8ah,y
				JSR		Y_iny
				inx
				inx
				jmp		loop_moji
message_owari	rts
;===================================================================
;*******************************************************************
;						f[^[
;*******************************************************************
;===================================================================
;
;<<<<<<<<<<<<< C[`ZNgf[^[ >>>>>>>>>>>>>
Select_rank		DW		Rank_1,Rank_2,Rank_3
;<<<<<<<<<<<<< ZNgf[^[ >>>>>>>>>>>>>>>>>>>
Select_kakikae	DW		Pukupuku_nmi,Mant_nmi,owari_nmi_set
;<<<<<<<<<<<<<< XN[ZNgf[^[ >>>>>>>>>>>>>>>>
Select_screen	DW		Pukupuku_screen,Mant_screen,Set_Hdma
;<<<<<<<<<<<<<<<<< gcl`pf[^[ >>>>>>>>>>>>>>>>>>>>>
TENSOU_DATA		DB		80h,07h,21h,07h,60h,01h,00h
				DB		80h,11h,20h,11h,60h,12h,00h
;<<<<<<<<<<<<<<<<< 㔼gpqnlf[^[ >>>>>>>>>>>>>>>>>
OBJ_kart		DL		04a000h,08a000h,05a000h,06a000h
				DL		07a000h,09a000h,0aa000h,0ba000h
;<<<<<<<<<<<<<<<< J[AhX >>>>>>>>>>>>>>>>>>
CG_Address		DW		4840h,4860h,4880h
;********************************************************
;					BG	f[^[
;********************************************************
PATERN_DATA		DW		PUKUPUKU_DATA1,PUKUPUKU_DATA2,PUKUPUKU_DATA
;
PATERN_DATA1	DW		MANT_DATA,MANT_DATA1,MANT_DATA2
;<<<<<<<<<<<<<<<<<<< vNvNpf[^[ .>>>>>>>>>>>>>>>>>>>
PUKUPUKU_DATA	DB		88h,88h,00h,01h,02h,03h,04h,05h,06h,07h,0ffh
				DB		88h,88h,10h,11h,12h,13h,14h,15h,16h,17h,0ffh
				DB		08h,09h,0ah,0bh,0ch,0dh,0eh,0fh,20h,21h,0ffh
				DB		18h,19h,1ah,1bh,1ch,1dh,1eh,1fh,30h,31h,0ffh
				DB		22h,23h,24h,25h,26h,27h,28h,29h,0ffh
				DB		32h,33h,34h,35h,36h,37h,38h,39h,0ffh
				DB		2eh,2fh,40h,41h,42h,43h,44h,45h,0ffh
				DB		3eh,3fh,50h,51h,52h,53h,54h,55h,0ffh
				DB		4ah,4bh,4ch,4dh,4eh,4fh,60h,61h,0ffh
				DB		5ah,5bh,5ch,5dh,5eh,5fh,70h,71h,0ffh
				DB		88h,66h,67h,68h,69h,6ah,6bh,6ch,6dh,88h,0ffh
				DB		88h,76h,77h,78h,79h,7ah,7bh,7ch,7dh,88h,0ffh
;
PUKUPUKU_DATA1	DB		2ah,2bh,2ch,2dh,0ffh
				DB		3ah,3bh,3ch,3dh,0ffh
				DB		46h,47h,48h,49h,0ffh
				DB		56h,57h,58h,59h,0ffh
				DB		62h,63h,64h,65h,0ffh
				DB		72h,73h,74h,75h,0ffh
;
PUKUPUKU_DATA2	DB		2ah,2bh,6eh,6fh,0ffh
				DB		3ah,3bh,7eh,7fh,0ffh
				DB		80h,81h,82h,83h,0ffh
				DB		90h,91h,92h,93h,0ffh
				DB		84h,85h,86h,87h,0ffh
				DB		94h,95h,96h,97h,0ffh
;<<<<<<<<<<<<<<<<<< }gKpf[^[ >>>>>>>>>>>>>>>>>>>>>>>
MANT_DATA		DB		0e4h,0e5h,0e6h,0e7h,0ffh
				DB		0f4h,0f5h,0f6h,0f7h,0ffh
;
MANT_DATA1		DB      0e4h,0e5h,0e8h,0e9h,0ffh
				DB      0f4h,0f5h,0f8h,0f9h,0ffh
;
MANT_DATA2		DB		0e0h,0ffh
;<<<<<<<<<<<<<<<<<<<<< pf[^[ >>>>>>>>>>>>>>>>>>>>>>>>>>>>
MAKU_Set		DW		MAKU_data,MAKU_data1,MAKU_data2,MAKU_data3
;
MAKU_data		DB		0a0h,0a1h,0ffh
				DB      0b0h,0b1h,0ffh
;
MAKU_data1		DB		0a2h,0a3h,0ffh
				DB      0b2h,0b3h,0ffh
;
MAKU_data2		DB		0a4h,0a5h,0ffh
				DB      0b4h,0b5h,0ffh
;
MAKU_data3		DB		0a6h,0a7h,0a8h,0a9h,0aah,0abh,0ach,0ffh
				DB		0b6h,0b7h,0b8h,0b9h,0bah,0bbh,0bch,0ffh
;
;***********************************************************
;					OBJ	f[^[
;***********************************************************
;
;<<<<<<<<<<<<<<<<<<<< p^p^f[^[ >>>>>>>>>>>>>>>>>>>>>>>>
OBJ_DATA		DW		64fch,3ac2h,70f4h,3ac8h,60f4h,3ac6h
				DW		64ach,3ac2h,70a4h,3ac8h,60a4h,3ac6h		
				DW		4484h,3ac2h,507ch,3ac8h,407ch,3ac6h
				DW		44d4h,3ac2h,50cch,3ac8h,40cch,3ac6h
;<<<<<<<<<<<<<<<<<<<<< ef[^[ >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
				DW		0b0e0h,304ah,0b0f0h,304ch,0b000h,304eh
				DW		0b010h,704eh,0b020h,704ch,0b030h,704ah
;<<<<<<<<<<<<<<<<<<<<<< Xf[^[ >>>>>>>>>>>>>>>>>>>>>>>>>>>>>
				DW		8180h,3d00h,8190h,7d00h,9110h,3d02h,9140h,3d04h
				DW		9150h,3d06h,9160h,3d08h,9170h,3d0ah,9180h,3d0ch
				DW		9190h,3d0eh,91a0h,3d20h,91b0h,3d22h,91d0h,3d24h
				DW		91e0h,3d26h,91f0h,3d28h
;<<<<<<<<<<<<<<<<<<<<<<< _f[^[ >>>>>>>>>>>>>>>>>>>>>>>>>>>>
				DW		2020h,08cch,2030h,48cch,7010h,08cch,7020h,48cch
				DW		7060h,082ah,5070h,082ah,50a0h,08cch,50b0h,48cch
				DW		20a0h,083eh,40e8h,083eh,0ffffh
;<<<<<<<<<<<<<<< p^p^悤f[^[ >>>>>>>>>>>>>>>>>>
PATAPATA_PATERN	DW		PATAPATA_DATA1,PATAPATA_DATA2
;
PATAPATA_DATA1	DW		3ac2h,3ac8h,0ffffh
PATAPATA_DATA2	DW		3ac4h,3acah,0ffffh
;<<<<<<<<<<<<<<<<<<<<<<<< f[^[ >>>>>>>>>>>>>>>>>>>>>>>>>>
Explosion_set	DW		Explosion_data,Explosion_data1,Explosion_data2
;
Explosion_data	DW		6034h,38aah,6044h,38ach
				DW		7034h,0f8ach,7044h,0f8aah
				DW		0ffffh
;
Explosion_data1	DW		6034h,78ach,6044h,78aah
				DW      7034h,0b8aah,7044h,0b8ach
				DW		0ffffh
;
Explosion_data2	DW		0f0e0h,78ach,0f0e0h,78aah
				DW      0f0e0h,0b8aah,0f0e0h,0b8ach
				DW		0ffffh
;<<<<<<<<<<<<<<<<<<< cO|[Yf[^[ >>>>>>>>>>>>>>>>>>>>>>>>>>
Zannen_position	DW		0b0b8h,0b0c8h
				DW		0c0b8h,0c0c8h
;
Zannen_pose_data	DW	Zannen_0,Zannen_1,Zannen_2,Zannen_3
;
Zannen_0		DW		30aeh,70aeh
				DW		30ceh,70ceh,0ffffh
;
Zannen_1		DW		70c2h,70c0h
				DW		30ceh,70ceh,0ffffh
;
Zannen_2		DW		70c6h,70c4h
				DW		30ceh,70ceh,0ffffh
;
Zannen_3		DW		30aah,70aah
				DW		30cah,70cah,0ffffh
;
Zannen_color	DW		0200h,0400h,0000h,0600h
				DW		0600h,0400h,0200h,0000h
;<<<<<<<<<<<<<<<<<<<<<<< f[^[ >>>>>>>>>>>>>>>>>>>>>>>>>>>
;----------(|WVp)---------
Position_select	DW		6054h,6050h,6054h,604ch
;
Usual_Start		DW		703ch,703ch,703ch,703ch
				DW		7030h,703ch,703ch,703ch
;
Usual_Paragraph	DW		00c4h,00cch,00c4h,00c4h
				DW		00d8h,00cch,00cch,00cch
;
Less_Start		DW		5034h,5030h,5034h,5034h
				DW		5028h,5030h,5030h,5030h
;
Less_Paragraph	DW		00cch,00d0h,00cch,00cch
				DW		00d8h,00d0h,00d0h,00d0h
;------------([hp)-----------
World_select	DW		World_0,World_1,World_2,World_3,World_cup
;
World_0			DW		0ffch,0fc6h,0fd8h,0fc9h,0ffffh
World_1			DW      0ffch,0fdbh,0fe6h,0febh,0ffch,0ffffh
World_2			DW      0ffch,0fcch,0fcfh,0ffch,0ffffh
World_3			DW		0ffch,0fcch,0fdch,0f8fh,0fcbh,0ff8h,0fe8h,0ffffh
World_cup		DW		0fc5h,0ff7h,0fdbh,0f8fh,0fe9h,0ffch,0fcch,0ffch
				DW		0f8dh,0ffffh
;------------(Op)------------
NAME_select		DW		MARIO_name,LUIZI_name,KUPPA_name,PEACH_name
				DW		KONG_name,NOKO_name,KINOP_name,YOSSY_name
;
MARIO_name		DW		0fdeh,0fe7h,0fc4h,0ffffh
LUIZI_name		DW      0fe8h,0fc1h,0ffch,0fcbh,0f8eh,0ffffh
KUPPA_name		DW      0fc7h,0ff7h,0fd9h,0f8fh,0ffffh
PEACH_name		DW      0fdah,0f8fh,0ffch,0fd0h,0ffffh
KONG_name		DW      0fd3h,0f8eh,0fedh,0fc6h,0ffch,0fc9h,0fedh
				DW		0fc7h,0f8eh,0f8bh,0f8ch,0ffffh
NOKO_name		DW      0fd8h,0fc9h,0fd8h,0fc9h,0ffffh
KINOP_name		DW      0fc6h,0fd8h,0fdah,0f8fh,0fc4h,0ffffh
YOSSY_name		DW      0fe5h,0ff7h,0fcbh,0ffch,0ffffh
;------------(gtB[p,ʏ탁bZ[W)------------
Cup_select		DW		Gold_cup,Silver_cup,Copper_cup,Cup_set
;
Gold_cup		DW		0fffh,0fc9h,0f8eh,0ffch,0fe8h,0fd3h,0f8eh,0ffffh
Silver_cup		DW		0fffh,0fcbh,0fe8h,0fd9h,0f8eh,0ffch,0ffffh
Copper_cup		DW		0fffh,0fdbh,0f8eh,0feah,0fedh,0fcch,0f8eh,0ffffh
Cup_set			DW		0fc5h,0ff7h,0fdbh,0f8fh,0f95h,0f8eh,0fffh
				DW		0f94h,0f97h,0fb6h,0fb9h,0faeh,0f9ch,0feeh
				DW		0fa1h,0f96h,0f8eh,0fa8h,0fe9h,0ffch,0fcch
				DW		0fb2h,0f95h,0f8eh,0fbdh,0fa9h,0f8eh,0ff1h
				DW		0fa2h,0f87h,0000h,0ffffh
;------------(ʗpAcObZ[W)-------------------
Rank_select		DW		Rank_4,Rank_5,Rank_6,Rank_7,Rank_8,Rank_message
				DW		zannen_message
;
Rank_4			DW		0f80h,0ffffh
Rank_5			DW      0f81h,0ffffh
Rank_6          DW      0f82h,0ffffh
Rank_7          DW      0f83h,0ffffh
Rank_8          DW      0f84h,0ffffh
Rank_message	DW		0f91h,0fffh,0fa5h,0fa4h,0ff1h,0fa2h,0f9bh,0faeh,0f91h
				DW		0faeh,0f9bh,0f9fh,0feeh,0fa1h,0f96h,0f8eh,0fa8h
				DW		0fe9h,0ffch,0fcch,0fa2h,0f8eh,0fffh,0f95h,0f8eh,0fbdh
				DW		0fa9h,0f8eh,0ff1h,0fa2h,0f87h,0000h,0ffffh
zannen_message	DW		0f9ah,0f8eh,0fbdh,0fa7h,0fbdh,0f87h,0fffh,0ffffh
;-------------(XyVbZ[W)-------------------	
Special_data	DW		0fafh,0f99h,0f8eh,0fa3h,0fffh,0f9ch,0fach,0f8eh
				DW		0fa2h,0fa8h,0fc5h,0ff7h,0fdbh,0f8fh,0fbch,0fffh
				DW		0f9dh,0f91h,0fa9h,0f9bh,0faeh,0f9bh,0f9fh
				DW		0f87h,0fffh,0f90h,0fa4h,0f9fh,0fa9h,0fffh,0fcch
				DW		0ffch,0fd9h,0f8fh,0ffch,0fdeh,0fe7h,0fc4h,0fc5h
				DW		0ffch,0fd3h,0fa8h,0fd0h,0ff8h,0fedh,0fdah
				DW		0f8fh,0fc4h,0fedh,0fa2h,0f8eh,0f9ch,0f87h,0000h,0ffffh
;<<<<<<<<<<<<<<<<<<<<<< lraf[^[ >>>>>>>>>>>>>>>>>>>>>>>>>>
MSB_DATA		DB		0aah,000h,0a0h,000h,0aah,0aah,0aah,0aah
				DB		00ah,000h,000h,000h,000h,000h,000h,000h
				DB		0aah,0aah,0aah,0aah,0aah,0aah,0aah,0aah
				DB		0fah,0ffh,0aah,0aah,0aah,0aah,0aah,00ah
;<<<<<<<<<<<<<<<<<<<<< }I|[Y >>>>>>>>>>>>>>>>>>>>>>>>>>>>>
MARIO_POSE		DW		Mario_1,Mario_2
;
Mario_1			DW		0a770h,3340h,0a780h,7340h
				DW		0b770h,3200h,0b780h,7200h
				DW		0e0e0h,3248h,0ffffh
;
Mario_2			DW      0a370h,3342h,0a380h,7342h
				DW		0b370h,3202h,0b380h,7202h
				DW		0b778h,3248h,0ffffh
;
MARIO_Champgne	DW      Champgne_mario2,Champgne_mario3,Champgne_mario1
Champgne_mario1	DW      0b675h,03ce2h,0ffffh
;
Champgne_mario2	DW		0b173h,03ce0h,0ffffh
Champgne_mario3 DW      0a96eh,03ce6h,0ffffh
;
MARIO_Shawer	DW		Shawer_mario1,Shawer_mario2,Shawer_mario3
				DW		Shawer_mario4,Shawer_mario5,Shawer_mario6
				DW		Shawer_mario7
Shawer_mario1	DW		0a06eh,03aaeh,0ffffh
Shawer_mario2	DW		0926eh,07aaeh
				DW		0a16eh,03aeeh,0ffffh
Shawer_mario3	DW		0996eh,03aeah
				DW		0a272h,03aebh
				DW		0a972h,0faebh,0ffffh
Shawer_mario4   DW		0996eh,0bafah,09976h,0fafah
				DW		0a16fh,0bafbh,0a177h,0fafbh
				DW		0a96fh,0fafah,0a974h,0bafah,0ffffh
Shawer_mario5   DW		09b6eh,0bafah,09b76h,0fafah
				DW		0a16fh,0bafbh,0a177h,0fafbh
				DW		0aa6fh,0fafah,0aa74h,0bafah,0ffffh
Shawer_mario6   DW		09b6ch,0bafbh,09b77h,0fafbh
				DW		0a36dh,0bafbh,0a374h,0fafbh
				DW		0aa6eh,0fafbh,0aa74h,0bafbh,0ffffh
Shawer_mario7   DW		0a56dh,07afbh,0a574h,03afbh
				DW		0ab6eh,0fafbh,0ab74h,07afbh,0ffffh
;<<<<<<<<<<<<<<<<<<<<<< Nbp|[Y >>>>>>>>>>>>>>>>>>>>>>>>>>>
KUPPA_POSE		DW		KUPPA_1,KUPPA_2
KUPPA_POSE1		DW		KUPPA_2,KUPPA_3
;	
KUPPA_1			DW		0a370h,3144h,0a380h,7144h
				DW		0b370h,300ch,0b380h,700ch
				DW		0c370h,302ch,0c380h,702ch,0ffffh
;
KUPPA_2			DW		0a370h,3146h,0a380h,7146h
				DW      0b370h,300eh,0b380h,700eh
				DW		0c370h,302ch,0c380h,702ch,0ffffh
;
KUPPA_3			DW		0a470h,3146h,0a480h,7146h
				DW      0b470h,300eh,0b480h,700eh
				DW		0c370h,302ch,0c380h,702ch,0ffffh
;
KUPPA_Champgne  DW      Champgne_kuppa1,Champgne_kuppa2,Champgne_kuppa3
Champgne_kuppa1	DW		0a080h,0bce2h,0ffffh
Champgne_kuppa2	DW		0a180h,0bce2h,0ffffh
Champgne_kuppa3	DW		0ab78h,3ce2h,0ffffh
;
KUPPA_shower    DW      Shower_kuppa_1,Shower_kuppa_2
Shower_kuppa_1  DW      0ad78h,3ac0h,0ffffh
Shower_kuppa_2  DW      0ae78h,7ac0h,0ffffh
;<<<<<<<<<<<<<<<<<<<<<<<< s[`|[Y >>>>>>>>>>>>>>>>>>>>>>>>>
PEACH_POSE		DW		PEACH_1,PEACH_2,PEACH_3
;
PEACH_1			DW		0a370h,3748h,0a380h,7748h
				DW      0b370h,3608h,0b380h,7608h
				DW		0c370h,3628h,0c380h,7628h,0ffffh
;
PEACH_2			DW		0a370h,374ah,0a380h,774ah
				DW      0b370h,360ah,0b380h,760ah
				DW      0c370h,3628h,0c380h,7628h,0ffffh
;
PEACH_3			DW		0a87ch,36ceh,0ffffh
;
PEACH_Champgne  DW      Champgne_peach1,Champgne_peach2
PEACH_Champgne1 DW      Champgne_peach2,Champgne_peach3
;
Champgne_peach1	DW		0b077h,03ce2h,0ffffh
Champgne_peach2	DW		0b078h,03ce4h,0ffffh
Champgne_peach3	DW		0a478h,0bce6h,0ffffh
;<<<<<<<<<<<<<<<<<<<<<<<< RO|[Y >>>>>>>>>>>>>>>>>>>>>>>>>
KONG_POSE		DW		KONG_1,KONG_2,KONG_3,KONG_4
				DW		KONG_5,KONG_6
;
KONG_1			DW		0a770h,374eh,0a780h,774eh
				DW      0b770h,3640h,0b780h,7640h,0ffffh
;
KONG_2			DW		0a770h,374ch,0a780h,774ch
				DW      0b770h,3642h,0b780h,7642h,0ffffh
;
KONG_3			DW      0a770h,374ch,0a680h,774eh
				DW      0b770h,3642h,0b780h,7640h,0ffffh
;
KONG_4          DW      0a770h,374eh,0a880h,774ch
				DW      0b770h,3640h,0b780h,7642h,0ffffh
;
KONG_5			DW		0ae7ch,36dfh,0ffffh
;
KONG_6			DW      0b07ch,36cfh,0ffffh
;
KONG_Champgne 	DW      Champgne_kong1,Champgne_kong2
				DW		Champgne_kong3,Champgne_kong4
				DW      Champgne_kong5,Champgne_kong6
Champgne_kong1	DW		0b375h,03ce2h,0ffffh
;
Champgne_kong2	DW		0a070h,0bce2h,0ffffh
;
Champgne_kong3  DW      0a078h,0fce4h
				DW		0a070h,0bce2h,0ffffh
;
Champgne_kong4  DW      0a080h,0fce2h
				DW		0a074h,0bce2h,0ffffh
;
Champgne_kong5 	DW      0a070h,0bce2h
				DW		0a880h,0bce4h,0ffffh
;
Champgne_kong6 	DW      0a870h,0bce4h
				DW		0a080h,0fce2h,0ffffh
;<<<<<<<<<<<<<<<<<<<<< CW|[Y >>>>>>>>>>>>>>>>>>>>>>>>>>>
LUIZI_POSE		DW		LUIZI_1,LUIZI_2
;
LUIZI_1			DW		0a770h,3560h,0a780h,7560h
				DW		0b770h,3420h,0b780h,7420h
				DW		0e0e0h,3248h,0ffffh
;
LUIZI_2			DW      0a370h,3562h,0a380h,7562h
				DW		0b370h,3422h,0b380h,7422h
				DW		0b778h,3248h,0ffffh
;
LUIZI_Champgne  DW      Champgne_luizi1,Champgne_luizi2
				DW		Champgne_luizi3,Champgne_luizi4
				DW		Champgne_luizi5,Champgne_luizi6
				DW		Champgne_luizi7
Champgne_luizi1	DW      0b375h,03ce2h,0ffffh
;
Champgne_luizi2	DW      0b270h,03ce4h
				DW      0b280h,03ce4h,0ffffh
Champgne_luizi3 DW      0b270h,03ce2h
				DW      0b280h,07ce2h,0ffffh
Champgne_luizi4	DW      0b370h,0bce2h
				DW      0b380h,0fce2h,0ffffh
Champgne_luizi5	DW      0b270h,0bce4h
				DW      0b280h,0bce4h,0ffffh
Champgne_luizi6 DW      0b270h,0fce2h
				DW      0b280h,0bce2h,0ffffh
Champgne_luizi7 DW      0b370h,07ce2h
				DW      0b380h,03ce2h,0ffffh
;
LUIZI_shower	DW		Shower_luizi_1
				DW		Shower_luizi_2,Shower_luizi_3
				DW		Shower_luizi_4,Shower_luizi_5
;
Shower_luizi_1	DW		0a370h,3aaeh
				DW		0a380h,3aaeh,0ffffh
;
Shower_luizi_2	DW		0aa68h,3aeah
				DW		0aa88h,7aeah,0ffffh
;
Shower_luizi_3	DW		0ac68h,3aebh,0ac6eh,3afah,0b368h,3afbh
				DW		0ac90h,7aebh,0ac8ah,7afah,0b392h,7afbh
				DW		0ffffh
;
Shower_luizi_4	DW		0f0e0h,3aebh,0ac68h,3afah,0ac6eh,3afbh
				DW		0f0e0h,7aebh,0ac90h,7afah,0ac8ah,7afbh
				DW		0ffffh
;
Shower_luizi_5	DW		0f0e0h,3aebh,0f0e0h,3afah,0b068h,3afbh
				DW		0f0e0h,7aebh,0f0e0h,7afah,0b08eh,7afbh
				DW		0ffffh
;<<<<<<<<<<<<<<<<<<<<<<< mRmR|[Y >>>>>>>>>>>>>>>>>>>>>>>>
NOKO_POSE		DW		NOKONOKO_1,NOKONOKO_2,NOKONOKO_3,NOKONOKO_4
;
NOKONOKO_1		DW		0a870h,3564h,0a880h,7564h
				DW		0b870h,3424h,0b880h,7424h
				DW		0e0e0h,3248h,0ffffh
;
NOKONOKO_2		DW      0a470h,3566h,0a480h,7566h
				DW		0b470h,3426h,0b480h,7426h
				DW		0b778h,3248h,0ffffh
;
NOKONOKO_3		DW		0a86fh,3564h,0a87fh,7564h
				DW		0b870h,3424h,0b880h,7424h
				DW		0e0e0h,3248h,0ffffh
;
NOKONOKO_4		DW		0a871h,3564h,0a881h,7564h
				DW		0b870h,3424h,0b880h,7424h
				DW		0e0e0h,3248h,0ffffh
;
NOKO_Champgne	DW      Champgne_noko1,Champgne_noko2
				DW		Champgne_noko3,Champgne_noko4
				DW		Champgne_noko5,Champgne_noko6
				DW		Champgne_noko7,Champgne_noko8
				DW		Champgne_noko9,Champgne_noko10
				DW		Champgne_noko11,Champgne_noko12
Champgne_noko1	DW      0b375h,03ce2h,0ffffh
;
Champgne_noko2	DW		0bc76h,03ce2h,0ffffh
Champgne_noko3  DW      0bc76h,03ce2h
				DW      0bc83h,03ce2h,0ffffh
Champgne_noko4  DW      0bc78h,03ce0h
				DW      0bc85h,03ce2h,0ffffh
Champgne_noko5  DW      0bc76h,03ce0h
				DW      0bc83h,03ce2h,0ffffh
Champgne_noko6  DW      0bc72h,03ce4h
				DW      0bc7fh,03ce4h,0ffffh
Champgne_noko7  DW      0bc78h,07ce2h
				DW      0bc72h,03ce4h,0ffffh
Champgne_noko8  DW      0bc6eh,07ce2h
				DW      0bc7fh,03ce4h,0ffffh
Champgne_noko9  DW      0bc6ch,07ce2h
				DW      0bc7dh,03ce4h,0ffffh
Champgne_noko10 DW      0bc78h,03ce2h
				DW      0bc7dh,03ce4h,0ffffh
;
Champgne_noko11	DW      0c476h,038fch,0ffffh
Champgne_noko12 DW      0c481h,038fch,0ffffh
;<<<<<<<<<<<<<<<<<<<<< Lms|[Y >>>>>>>>>>>>>>>>>>>>>>
KINOP_POSE		DW		KINOPYO_1,KINOPYO_2
;
KINOPYO_1		DW		0a970h,3368h,0a980h,7368h
				DW		0b970h,3204h,0b980h,7204h
				DW		0e0e0h,3248h,0ffffh
;
KINOPYO_2		DW      0a570h,336ah,0a580h,736ah
				DW		0b570h,3206h,0b580h,7206h
				DW		0b778h,3248h,0ffffh
;
KINOP_Champgne	DW		Champgne_kinop1,Champgne_kinop2
;
Champgne_kinop1	DW		0b375h,3ce2h,0ffffh
Champgne_kinop2	DW		0b372h,3ce4h,0ffffh
;
;<<<<<<<<<<<<<<<<<<<<<<<< bV[|[Y >>>>>>>>>>>>>>>>>>>>>>
YOSSY_POSE			DW		YOSSY_1,YOSSY_2
;
YOSSY_1				DW		0a770h,316ch,0a780h,716ch
					DW		0b770h,3044h,0b780h,7044h,0ffffh
;
YOSSY_2				DW      0a770h,316eh,0a780h,716eh
					DW		0b770h,3046h,0b780h,7046h,0ffffh
;
YOSSY_Champgne		DW      Champgne_yossy1,Champgne_yossy2,Champgne_yossy3
					DW		Champgne_yossy4,Champgne_yossy5,Champgne_yossy6
					DW		Champgne_yossy7,Champgne_yossy8,Champgne_yossy9
					DW		Champgne_yossy10,Champgne_yossy11,Champgne_yossy12
					DW		Champgne_yossy13,Champgne_yossy14,Champgne_yossy15
					DW		Champgne_yossy16,Champgne_yossy17,Champgne_yossy18
Champgne_yossy1		DW      0b375h,03ce2h,0ffffh
;
Champgne_yossy2		DW		0b070h,03ce4h,0ffffh
Champgne_yossy3 	DW      0af71h,03ce6h,0ffffh
Champgne_yossy4 	DW      0ae72h,03ce8h,0ffffh
Champgne_yossy5 	DW      0ad73h,0bce6h,0ffffh
Champgne_yossy6 	DW      0ac74h,0bce4h,0ffffh
Champgne_yossy7 	DW      0ab75h,0bce6h,0ffffh
Champgne_yossy8 	DW      0aa76h,03ce8h,0ffffh
Champgne_yossy9 	DW      0a977h,03ce6h,0ffffh
Champgne_yossy10	DW      0a878h,03ce4h,0ffffh
Champgne_yossy11    DW      0a979h,03ce6h,0ffffh
Champgne_yossy12    DW      0aa7ah,03ce8h,0ffffh
Champgne_yossy13    DW      0ab7bh,0bce6h,0ffffh
Champgne_yossy14    DW      0ac7ch,0bce4h,0ffffh
Champgne_yossy15    DW      0ad7dh,0bce6h,0ffffh
Champgne_yossy16    DW      0ae7eh,03ce8h,0ffffh
Champgne_yossy17    DW      0af7fh,03ce6h,0ffffh
Champgne_yossy18    DW      0b080h,03ce4h,0ffffh
;=========================================================================
;***********************************************************************
;						MAIN ROUTINE
;***********************************************************************
;========================================================================
;------------(PʗpC[`)-----------
;**************************************************************
;				vNvNXN[,gk,]Zbg
;**************************************************************
Scroll_set		equ		$
				mem16
				idx16
;<<<<<<<<<<<<<<< XN[ƃZ^[Zbg >>>>>>>>>>>>>>>
Set_pukupuku	lda     <Champgne_timer
				cmp		#017ch
				beq		Reset_move
				cmp		#017ch
				bcs		Set_burst
				jmp		Set_flying
Reset_move		stz		<MAKU_move_flag
				jmp		Set_burst
;
Set_flying		lda		#0080h					;XN[Xs[hZbg
				sta		<Scroll_speed
				JSR		Scroll_routine
;<<<<<<<<<<<<<<< gkA]Zbg >>>>>>>>>>>>>>>>>>>>>>
Set_revolv		jmp		Set_angle
;<<<<<<<<<<<<<<< vNvNꂽƂ̏ >>>>>>>>>>>>>>>>
Set_burst		JSR		Set_explosion
;
				lda		<V_pos_dec				;̂u|WVZbg
				clc
				adc		#0010h
				sta		<V_pos_dec
;
				lda     <Scroll_Y				;XN[`FbN
				cmp		#0100h
				bcc		Stop_set
;
				lda     <Angle_set				;E]Zbg
				clc
				adc		#0600h
				sta		<Angle_set
;
				lda		<Center_X				;wZ^[Zbg
				clc
				adc		#0001h
				cmp		#0220h
				beq		Stop_set
				sta		<Center_X
;
				lda		<Zoom_set				;Y[Zbg
				clc
				adc		#0010h
				cmp		#0800h
				beq		Set_angle
				sta		<Zoom_set
;- - - - - - - - - - - -- - - - - - - - - - -
Set_angle		JSR		Revolve_routine			;],kgZbg
owari_pukupuku	rts
;- - - - - - - - - - - - - - - - - - - - - - -
Stop_set		lda		<Scroll_Y
				dec		a
				cmp		#0fff0h
				beq		owari_pukupuku
				sta		<Scroll_Y
				jmp		Set_angle
;<<<<<<<<<<<<<<< pTu[` >>>>>>>>>>>>>>>>>>>
Set_explosion	equ		$
				inc		Explosion_timer
				lda		Explosion_timer
				cmp		#0003h
				bne		owari_explosion
				stz		Explosion_timer
;
				ldy		#0
				ldx		Explosion_count
				lda		Explosion_set,x
				tax
loop_explosion	lda		!0,x
				cmp		#0ffffh
				beq		explosion_Count
				sta		oamdat+148h,y
				iny
				iny
				inx
				inx
				jmp		loop_explosion
;
explosion_Count	lda		Explosion_count
				cmp		#0004
				beq		owari_explosion
				inc		Explosion_count
				inc		Explosion_count
owari_explosion	rts
;********************************************************
;					_AZbg
;********************************************************
KUMO_move		equ		$
				inc		kumo_flag					;tOZbg
				lda		kumo_flag
				cmp		#0005
				bne		owari_kumo
;
				stz		<OBJ_check_flag				;C[XtOZbg
				stz		kumo_flag					;tOZbgZbg
				mem8
				sep		#00100000b
				ldx		#01d8h
loop_kumo		inc		oamdat,x					;g|WVZbg
				lda		oamdat,x
				beq		Set_MSB
				jmp		Set_inx
;
Set_MSB			JSR		OBJ_ERASE
;	
Set_inx			JSR		X_inx						;f[^[CN
				cpx		#0200h
				bne		loop_kumo
owari_kumo		mem16
				rep		#00100000b
				rts
;*******************************************************
;					eAZbg
;*******************************************************
KAGE_move		equ		$
				ldx		#0188h
				lda     <Champgne_timer
				cmp		#017ch
				bcc		Set_kage
;<<<<<<<<<<<<<<<<< eZbg >>>>>>>>>>>>>>>>>>>
				lda		#0e0f8h
loop_erase_kage	sta     oamdat,x
				JSR		X_inx
				cpx		#01a0h
				bne		loop_erase_kage
				jmp		owari_kage
;- - - - - - - -- - - - - -- - - - - - -- - -
Set_kage		inc		<kage_flag					;tOZbg
				lda		<kage_flag
				cmp		#0002
				bne		owari_kage
				stz		<kage_flag
;
				mem8
				sep		#00100000b
loop_kage		dec		oamdat,x					;g|WVZbg
				lda		oamdat,x
				cmp		#0ffh
				beq		kage_erase
				jmp		kage_set
;
kage_erase		JSR		OBJ_ERASE
;
kage_set		JSR     X_inx						;f[^[CN
				cpx		#01a0h
				bne		loop_kage
;
owari_kage		mem16
				rep		#00100000b
				rts
;*******************************************************
;					AY[Zbg
;*******************************************************
MAKU_zoom		equ		$
;<<<<<<<<<<<<<<< J[Zbg >>>>>>>>>>>
				inc		Color_timer
				lda		Color_timer
				cmp		#0003
				bne		Center_set
				stz		Color_timer
;
				ldx		#0010h
				lda		Color_buffer,x
				pha
;
loop_color_set	inx
				inx
				lda		Color_buffer,x
				dex
				dex
				sta		Color_buffer,x
				inx
				inx
				cpx		#001eh
				bne		loop_color_set
;
				pla
				sta		Color_buffer,x
;<<<<<<<<<<<<<<< Z^[Zbg >>>>>>>>>>>>>>>>>
Center_set		lda		#0084h					
				sta		<Center_X
				lda		#0080h
				sta		<Center_Y
;<<<<<<<<<<<<<<< XN[Zbg >>>>>>>>>>>>>>>
				lda		#0004
				sta		<Scroll_X+1				
				lda		#0040h
				sta		<Scroll_Y
;<<<<<<<<<<<<<<< AOZbg >>>>>>>>>>>>>>>>>
				stz		<Angle_set
;<<<<<<<<<<<<<<< Y[Zbg >>>>>>>>>>>>>>>>>>>
				lda		<MAKU_counter			
				cmp		#0060h
				beq		owari_maku
				lda		<MAKU_counter
				sec
				sbc		#0020h
				sta		<MAKU_counter
				sta		<Zoom_set
;
				JSR     Revolve_routine         
				rts
owari_maku		JSR		Message_set
				rts
;
;******************************************************
;					bZ[W Zbg
;******************************************************
Message_set		equ		$
				lda		Message_timer
				and		#8000h
				bne		Set_position
;<<<<<<<<<<<<<<<<< lra@Zbg >>>>>>>>>>>>>>>>
				mem8
				sep		#00100000b
				ldx		#0
Loop_msb		stz		msbdat+09h,x
				inx
				cpx		#0011h
				bne		Loop_msb
				mem16	
				rep		#00100000b
;<<<<<<<<<<<<< CjVZbgʒu >>>>>>>>>>>>>>
				lda		world_number
				asl		a
				tax
				lda		Position_select,x
				sta		Message_position
;<<<<<<<<<<< n`lubt@[NA[ >>>>>>>>>>>>
				ldx		#0
				lda		#0e0f8h
loop_clare		sta		oamdat+90h,x
				inx
				inx
				cpx		#0110h
				bne		loop_clare
;
				lda		#8000h
				sta		Message_timer
;
				JSR		MOJI_set
;<<<<<<<<<<<<<<<< ^C}[Zbg >>>>>>>>>>>>>>>>
Set_position	inc		Message_timer
				lda		Message_timer
				and		#00ffh
				cmp		#0003h
				bne		owari_message
				lda		#8000h
				sta		Message_timer
;<<<<<<<<<<<<<<<< |WVZbg >>>>>>>>>>>>>
				ldx		Message_counter
				lda		oamdat+8ah,x
				beq		owari_message
				cmp		#0f8fh
				beq		Dakuten_set
				cmp		#0f8eh
				beq		Dakuten_set
				cmp		#0f8dh
				beq		Set_V_pos1
				cmp		#0fffh
				beq		Space_set
				cmp		#0feeh
				beq		No_Paragraph
				cmp		#0f87h
				beq		No_Paragraph
;
Set_Paragraph	lda		Message_position
				sta		oamdat+88h,x
;
Space_set		lda     Message_position
				clc		
				adc		#0008h
				sta		Message_position
;-----(s`FbN)------
				and		#00ffh						
				cmp		Paragraph_cmp
				beq		Set_V_pos
;
Set_oam			JSR		X_inx
				stx		Message_counter
owari_message	rts	
;<<<<<<<<<<<<<<<<< sZbg >>>>>>>>>>>>>>>>>>
Set_V_pos		lda		Message_position
				and		#0ff00h
				clc
				adc		#1000h
				clc
				adc		Start_position
				sta		Message_position		
				jmp		Set_oam
;
Set_V_pos1		lda		Start_position
				sta     Message_position		
				and		#00ffh
				sta		Start_position
				jmp		Set_oam
;
No_Paragraph	lda		Message_position
				and		#00ffh
				cmp		Start_position
				bne		Set_Paragraph
;
				ldx		Message_counter
				dex
				dex
				dex
				dex
				lda		oamdat+88h,x
				clc
				adc		#0008
				JSR		X_inx
				sta		oamdat+88h,x
				jmp		Set_oam				
;<<<<<<<<<<<<<<<< _Zbg >>>>>>>>>>>>>>>>>>
Dakuten_set		lda		Message_position
				sec
				sbc		#0808h
				sta		oamdat+88h,x
				jmp		Set_oam
;<<<<<<<<<<<<<< Zbg Tu >>>>>>>>>>>>>>>
MOJI_set		ldy		#0
;-----------([hZbg)----------
				lda		world_number
				asl		a
				tax
				lda		World_select,x
				tax
				JSR     Message_data_set
;
				ldx		#0008
				lda		World_select,x
				tax
				JSR     Message_data_set
;-----------(ʃ`FbN)------------
				JSR     Rank_Check
				cpx		#0006
				bcs		Set_zannen
;---------(XyV`FbN)--------
				lda		world_number
				cmp		#0003
				bne		Set_usual
				cpx		#0000
				beq		Special_set
;----------(ʏ탁bZ[W)-----------
Set_usual		phx
				JSR		NAME_set
;
				lda		#0fa5h
				sta		oamdat+8ah,y
				JSR		Y_iny
				lda		#0fa9h
				sta		oamdat+8ah,y
				JSR		Y_iny
;
				plx
				lda		Cup_select,x
				tax
				JSR     Message_data_set
;
				ldx		#0006
				lda		Cup_select,x
				tax
				JSR     Message_data_set
;
				JSR     Rank_Check
				lda		point_rank,x
				tax
				lda		<driver_number,x
				tax		
				lda		Usual_Start,x
				sta		Start_position
				lda		Usual_Paragraph,x
				sta		Paragraph_cmp
				jmp		owari_moji_set
;---------(XyVbZ[W)-------
Special_set		lda		#7020h
				sta		Start_position
				lda		#00e0h
				sta		Paragraph_cmp
;
				ldx		#0
loop_special	lda		Special_data,x
				cmp		#0ffffh
				beq		owari_moji_set
				sta		oamdat+8ah,y
				JSR		Y_iny
				inx
				inx
				jmp		loop_special
;--------(cObZ[W)-------
Set_zannen		phx
				ldx		#000ch
				lda     Rank_select,x
				tax		
				JSR     Message_data_set
;
				plx
				phx
				JSR		NAME_set
;
				lda		#0fa9h
				sta		oamdat+8ah,y
				JSR		Y_iny
				lda		#0fffh
				sta		oamdat+8ah,y
				JSR		Y_iny
;
				plx
				txa
				sec		
				sbc		#0006
				tax
				lda		Rank_select,x
				tax	
				JSR     Message_data_set		
;
				ldx		#000ah		
				lda     Rank_select,x
				tax		
				JSR     Message_data_set
;
				lda     Message_position
				sec
				sbc		#2000h
				sta		Message_position
;
				JSR     Rank_Check
				lda		point_rank,x
				tax
				lda		<driver_number,x
				tax		
				lda		Less_Start,x
				sta		Start_position
				lda		Less_Paragraph,x
				sta		Paragraph_cmp
owari_moji_set	rts
;
NAME_set		lda		point_rank,x
				tax
				lda		<driver_number,x
				tax
				lda		NAME_select,x
				tax
				JSR		Message_data_set
				rts
;
;

;***********************************************************
;						cOZbg
;***********************************************************
Zannen_pose		equ		$
				mem16
				idx16
;-----------(^C}[`FbN)---------
				inc		Zannen_timer
				lda		Zannen_timer
				cmp		#0012h
				bne		owari_back_face
				stz		Zannen_timer
;-------------(Ȃ`FbN)-----------
				lda		Zannen_counter
				and		#0f00h
				cmp		#0600h
				bcc		Furimuki_set
				ldy		#0
				lda		#0003
				jmp		Naki_set
;---------(U`FbN)-----------
Furimuki_set	lda     Zannen_counter
				and		#0f000h
				bne		Set_forward
;---------(UZbg)-------------
				inc		Zannen_counter
				lda		Zannen_counter
				and		#000fh
				cmp		#0002
				beq		Reset_Zannen
				jmp		Set_zannen_pose
;---------(UԂZbg)-------------
Set_forward		dec		Zannen_counter
				lda		Zannen_counter
				and		#0f000h
				cmp		#8000h
				beq		back_Zannen
;----------(f[^[Zbg)------------
Set_zannen_pose	ldy		#0
				lda		Zannen_counter
				and		#000fh
Naki_set		JSR		Zannen_oam_set
				lda		Zannen_counter
				clc
				adc		#0100h
				cmp		#0900h
				beq		Allreset_zannen
				sta		Zannen_counter
owari_back_face	rts
;----------(tO`FWZbg)------
Reset_Zannen	lda		Zannen_counter
				ora		#8000h
				sta		Zannen_counter
				jmp		Set_zannen_pose
;
back_Zannen		lda     Zannen_counter
				and		#0f00h
				sta		Zannen_counter
				jmp     Set_zannen_pose
;
Allreset_zannen	stz		Zannen_counter
				jmp		owari_back_face
;--------------(2ʗpC[`)-------------
;*****************************************************************
;			}gKXN[,gk,]Zbg
;*****************************************************************
Scroll_set1		equ		$
				mem16
				idx16
;
				lda		<kage_flag					;tOZbg
				cmp		#0004
				beq		MAKU_start
;<<<<<<<<<<<<<< XN[ZbgAtOZbg >>>>>>>>>>>>>
;
				lda		#00e8h
				sta		<Scroll_Y
;
				lda		<Champgne_timer
				cmp		#0004h
				bne		Check_revolve
				lda		#0001h
				sta		<kage_flag					;Y[tOZbg
;
Check_revolve	lda		<Champgne_timer
				cmp		#0040h
				bne		Check_mant
				lda		#0002
				sta     <kage_flag					;]tOZbg
;
				lda		#0138h						;xZ^[Zbg
				sta		<Center_Y
;<<<<<<<<<<<<<<<< tO`FbN >>>>>>>>>>>>>>>>>>>>>>>>>>>>
Check_mant		lda		<kage_flag
				cmp		#0001
				beq		Zoom_mant					;Y[tO`FbN
;
				cmp		#0002
				beq		revolve_mant				;]tO`FbN
;
				lda     #0160h
				sta     <Scroll_speed
				jmp		NO_set_zoom
;
MAKU_start		lda		#0120h						;]̃Xs[h
				sta     <Scroll_speed
				lda		<Champgne_timer				;RN`FbN
				cmp		#178h
				bne		Check_Atari_set
				lda		<Scroll_Y					;RN̏
				clc
				adc		#0008
				sta		<Scroll_Y
;
				lda		#160h						;Z^[xZbg
				sta		<Center_Y
				lda		#0080h
				sta		<Scroll_speed
;
Check_Atari_set	lda     <Champgne_timer				;`FbN
				cmp		#178h
				bcc		NO_set_zoom
				lda		#7838h
				sta		oamdat+0148h
				JSR		Set_explosion2				;Zbg
				lda		<Angle_set
				clc
				adc		#0600h
				sta		<Angle_set
				jmp     NO_set_zoom
;<<<<<<<<<<<<<<<<<<<< Y[Zbg >>>>>>>>>>>>>>>>>>>>>>>>>>>
Zoom_mant		lda		<Zoom_set					;Y[Zbg
				cmp		#00f4h
				beq		NO_set_zoom
				clc		
				adc		#0004
				sta		<Zoom_set
				jmp		NO_set_zoom
;<<<<<<<<<<<<<<<<<<<< ]Zbg >>>>>>>>>>>>>>>>>>>>>>>>>>>>>
revolve_mant	lda		<Angle_set					;]Zbg
				clc
				adc		#0120h
				cmp		#0080h
				beq		Stop_revolve
				sta		<Angle_set
;
				stz		<Scroll_speed				;XN[Xgbv
				jmp     NO_set_zoom
;<<<<<<<<<<<<<<<<<<<<< ]̃Zbg >>>>>>>>>>>>>>>>>>>>>>>>
Stop_revolve	lda		#0004h						;tOZbg
				sta		<kage_flag
				stz		<Angle_set
;
NO_set_zoom		JSR     Scroll_routine
Stop_Scroll		JSR     Revolve_routine
				rts
;-----------------(3ʗpC[`)---------
;**************************************************************
;					p^p^Zbg
;**************************************************************
Patapata_walk	equ		$
				lda     <Champgne_timer
				cmp		#0179h
				bne		Set_scroll
No_scroll		ldx		#0158h						;HZbg
				lda		#0e0e0h
				sta		oamdat,x
;
Set_scroll		JSR		Flag_set					;^C}[Zbg
				cmp     #0002h
				beq		patapata_fly
				cmp		#0004h
				beq		patapata_fly1
				cmp		#0006h
				beq		patapata_fly2
				cmp		#0008h
				beq		patapata_fly3
				jmp		patapata_walk
;<<<<<<<<<<<<<<<<<< LN^[ >>>>>>>>>>>>>>>>>>>>>>
patapata_fly	ldy		#015ah						;p^p^Zbg
				lda		#0162h
				sta		<Cmp_check
				JSR		PATAPATA_fly
				jmp		patapata_walk
;
patapata_fly1	ldy		#0166h
				lda		#016eh
				sta		<Cmp_check
				JSR		PATAPATA_fly
				jmp		patapata_walk
;
patapata_fly2	ldy		#0172h
				lda		#017ah
				sta		<Cmp_check
				JSR		PATAPATA_fly
				jmp		patapata_walk
;
patapata_fly3	ldy		#017eh
				lda		#0186h
				sta		<Cmp_check
				JSR		PATAPATA_fly
				stz		<Move_flag
				jmp		patapata_count
;<<<<<<<<<<<<< LN^[Tu[` >>>>>>>>>>>>>>
PATAPATA_fly	equ		$
				ldx		<Patern_counter
				lda		PATAPATA_PATERN,x
				tax
loop_patapata	lda		!0,x
				sta		oamdat,y
				inx
				inx
				JSR		Y_iny
				cpy		<Cmp_check
				bne		loop_patapata
				rts
;
patapata_count	JSR		Counter_set	
;<<<<<<<<<<<<<<<<<< g|WVZbg >>>>>>>>>>>>>>>>>>>>>>>>
patapata_walk	lda		#0001
				sta		<OBJ_check_flag				;naiptO
;
				ldx		#015dh						;nʒn`FbN
				mem8								;Zbg
				sep		#00100000b
				lda		oamdat,x
				cmp		#0a8h
				mem16
				rep		#00100000b
				bcs		run_patapata
;
				lda		<Champgne_timer				;ړ`FbN
				cmp		#0179h
				bcs		NO_fly
;
run_patapata	ldx		#0158h						;SJړZbg
				jmp		Set_all
;
NO_fly			ldx		#0164h						;J3CړZbg
;
Set_all			inc		<Patapata_speed				;JXs[h`FbN
				lda		<Patapata_speed
				cmp		#0002
				bne		patapata_swing
				stz		<Patapata_speed
;
				mem8
				sep		#00100000b
patapata_Hpos	dec		oamdat,x
				lda		oamdat,x
				cmp		#0ffh
				bne		NO_erase
				JSR     OBJ_ERASE
NO_erase		JSR		X_inx
				cpx		#0188h
				bne		patapata_Hpos
				mem16
				rep		#00100000b
;<<<<<<<<<<<<<<<<<<<< u|WVZbg >>>>>>>>>>>>>>>>>>>>>>>
patapata_swing	lda		<Champgne_timer				;XCOXgbv`FbN
				cmp		#0179h
				bcs		NO_swing
;
				ldx		#0159h						;XCOZbg
				jmp		Set_timer
;
NO_swing		lda		#7838h
				sta		oamdat+0148h
				JSR		Set_explosion2				;Zbg
;
				lda		#3aa2h
				sta		oamdat+0162h				;珑Zbg
;
				ldx		#015dh						;XCOXgbvZbg
Set_down		mem8							
				sep		#00100000b
				lda		oamdat,x					;nʒn`FbN
				cmp		#0a8h
				bcs		No_down
				inc		oamdat,x					;nʒnZbg
				inc		oamdat,x
				JSR		X_inx
				cpx		#0165h
				bne		Set_down
No_down			mem16
				rep		#00100000b
				ldx		#0165h
;
Set_timer		inc		<kage_flag					;Zbg^C}[
				lda		<kage_flag
				cmp		#0002h
				bne		owari_patapata
				stz		<kage_flag
;-- - - - - - - - - - - - - - - - - - - -
Set_swing		lda		#0171h
				sta		<Cmp_check
				lda		<revolve_flag				;㉺Zbg`FbN
				and		#1000h
				beq		patapata_down
				jsr		patapata_Vpos
				jmp		Set_swing1
patapata_down	jsr		patapata_Vpos1
;- -- - - - - - - - - - - - - - - - - - - 
Set_swing1		lda		#0189h
				sta		<Cmp_check
				lda		<revolve_flag				;㉺Zbg`FbN
				and		#1000h
				bne		patapata_up
				jsr		patapata_Vpos
				jmp		patapata_flag
patapata_up		jsr		patapata_Vpos1
;- - - - - - - - - - - - - - - - - - - - -
patapata_flag	lda		<revolve_flag				;㉺tO`FbN
				and     #1000h
				beq		Down_set
;
				dec		<revolve_flag				;tOZbg
				lda		<revolve_flag
				and		#01111111b
				beq		No_flag
				jmp		owari_patapata
;
Down_set		inc		<revolve_flag				;tOZbg
				lda     <revolve_flag
				and		#01111111b
				cmp		#0020h						;ړʃZbg
				beq		Set_flag
				jmp     owari_patapata
;	
Set_flag		lda		<revolve_flag				;`FcNtOZbg
				ora		#1000h
				sta		<revolve_flag
				jmp     owari_patapata
;
No_flag			stz		<revolve_flag				;`FbNtOZbg
owari_patapata	rts	
;- - - - - - - - - - - - - - - - - - - - - 
patapata_Vpos	mem8								;Zbg
				sep		#00100000b
				inc		oamdat,x
				mem16
				rep		#00100000b
				JSR		X_inx
				cpx		<Cmp_check
				bne		patapata_Vpos
				rts
;- - - - - - - - - - - - - - - - - - - - - -
patapata_Vpos1	mem8								;Zbg
				sep		#00100000b
				dec		oamdat,x
				mem16
				rep		#00100000b
				JSR		X_inx
				cpx		<Cmp_check
				bne		patapata_Vpos1
				rts
;<<<<<<<<<<<<<<< QʁARʗpTu[` >>>>>>>>>>>>>>>>
Set_explosion2	equ		$
				lda		Explosion_count
				cmp		#0006h
				beq		owari_bakuhatu
				ldx		Explosion_count
				lda		Atari_set,x
				sta		oamdat+014ah
				inc		Explosion_count
				inc		Explosion_count
owari_bakuhatu	rts
;
Atari_set		DW		386eh,786eh,3838h
;---------------------(\ZbgC[`)-------------
;
;************************************************************
;					\Zbg
;************************************************************
AWARD_SET		equ		$
				mem16
				idx16
;
				inc		<Champgne_timer						;Pʂ̐lp^C}[
;<<<<<<<<<<<<<<< oUC^C}[ >>>>>>>>>>>>>>>>>>>>>
				inc		<Pose_timer						
				lda		<Pose_timer
				cmp		#0010h
				bne		owari_award
				stz		<Pose_timer
;<<<<<<<<<<<<<<<< oUCZbg >>>>>>>>>>>>>>>>>>>>>>
				JSR		Banzai_award
				jmp		Set_pose
;
Banzai_award	equ		$
				ldy		#0040h								;n`lAhXZbg
Set_Award		ldx		Award_counter						;ʃJE^[
				cpx		#0006
				beq		Banzai_owari
				lda		point_rank,x
				tax
				lda		<driver_number,x
				tax
				JSR		(!select_award,x)
				inc		Award_counter
				inc		Award_counter
				jmp		Set_Award
;
Award_mario		JSR		Set_MARIO
				rts
;
Award_luizi		JSR		Set_LUIZI
				rts
;
Award_kuppa		JSR		Set_KUPPA
				rts
;
Award_peach		JSR		Set_PEACH
				rts
;
Award_kong		JSR		Set_KONG
				rts
;
Award_noko		JSR		Set_NOKONOKO
				rts
;
Award_kinop		JSR		Set_KINOPIYO
				rts
;
Award_yossy		JSR		Set_YOSSY
				rts
;
Banzai_owari	stz		Award_counter
				rts
;<<<<<<<<<<<<<<<< |[YZbgJEg >>>>>>>>>>>>>>>>>>
Set_pose		stz		Award_counter
				inc		<Pose_counter
				inc		<Pose_counter
				lda		<Pose_counter						;|[Y`FWJE^[
				cmp		#0004
				beq		Reset_pose
;<<<<<<<<<<<<<<<<< Vpt@Cg >>>>>>>>>>>>>>>>>>>
owari_award		JSR		Rank_Check
				cpx		#0006h
				bcc		Set_Fight
				rts
;
Set_Fight		ldy		#0040h
				ldx		#0
				lda		point_rank,x
				tax
				lda		<driver_number,x
				tax
				JMP		(!Select_NO.1,x)
;
NO.1_mario		JSR		MARIO_Champgne_set
				rts
;
NO.1_luizi		JSR		LUIZI_Champgne_set
				rts
;
NO.1_kuppa		JSR		KUPPA_Champgne_set
				rts
;
NO.1_peach		JSR		PEACH_Champgne_set
				rts
;
NO.1_kong		JSR		KONG_Champgne_set
				rts
;
NO.1_noko		JSR		NOKONOKO_Champgne_set
				rts
;
NO.1_kinop		JSR		KINOPIYO_Champgne_set
				rts
;
NO.1_yossy		JSR		YOSSY_Champgne_set
				rts
;<<<<<<<<<<<<<<<<< |[YJE^[Zbg >>>>>>>>>>>>>
Reset_pose		stz		<Pose_counter
				jmp		owari_award	
;
select_award	DW		Award_mario,Award_luizi,Award_kuppa
				DW		Award_peach,Award_kong,Award_noko
				DW		Award_kinop,Award_yossy
;
Select_NO.1		DW		NO.1_mario,NO.1_luizi,NO.1_kuppa
				DW		NO.1_peach,NO.1_kong,NO.1_noko
				DW		NO.1_kinop,NO.1_yossy
;**********************************************************
;					}I|[YZbg
;**********************************************************
Set_MARIO		equ		$
;<<<<<<<<<<<<<<< oUC >>>>>>>>>>>>>>>>>>>>>>>>>>
				phy
				ldx		<Pose_counter
				lda		MARIO_POSE,x
				tax
				phx
				JSR		AWARD_OAM_SET			
;<<<<<<<<<<<<<<<<< \ʒuZbg >>>>>>>>>>>>>>>>>>>>>>
				ldx		Award_counter
				lda		MARIO_offset,x
				sta		<addr
;
				plx
				ply
				phy
				phx
				mem8
				sep		#00100000b
				JSR		SET_Hposition
;
				plx
				ply
				JSR		SET_Vposition
				mem16
				rep		#00100000b
				rts
;
MARIO_offset	DW		0000h,0f81dh,0f0e1h
;***********************************************************
;					}I VyZbg
;***********************************************************
MARIO_Champgne_set	equ		$
;<<<<<<<<<<<<<<<<< ^C}[`FbN >>>>>>>>>>>>>>>>>>>
				lda		<Champgne_timer
				cmp		#0140h
				beq		Champne_mario
				cmp		#015ch
				beq		Champne_mario
				cmp		#0178h
				beq		Champne_mario
;
				lda		<Pose_flag
				jmp		SET_mario
;<<<<<<<<<<<<<<<< CfbNXWv >>>>>>>>>>>>>>>>
Champne_mario	lda		<Pose_flag
				inc		a
				sta		<Pose_flag
SET_mario		asl		a
				tax		
				jmp		(!Select_mario,x)
;<<<<<<<<<<<<<<<<< |[YZbg >>>>>>>>>>>>>>>>>>>>>>>
MARIO_1			ldx		#0
				JSR		Banz_stop_mario
				ldx		#0004
				JSR     Set_up_mario
				JMP		owari_mario
;			
MARIO_2			lda		#0b273h
				sta		oamdat+10h
				ldx		#0
				JSR		Banz_stop_mario
				JSR		Cork_set
				JMP		owari_mario
;
MARIO_count		JSR     Set_ERASE
				inc		Fight_timer
				lda		Fight_timer
				cmp		#0004h
				beq		MARIO_fight_set
				lda		<Fight_counter
				asl		a
				tax
				jmp		Set_fight
;
MARIO_fight_set	stz		Fight_timer
;
MARIO_reset		lda		<Fight_counter
				cmp		#000dh
				beq		reset_kin_fight
				asl		a
				tax
				inc		<Fight_counter
Set_fight		jmp		(!MARIO_fight,x)
;
reset_kin_fight	stz		<Fight_counter
				jmp		MARIO_reset
;--------------------------------------------------
MARIO_3			ldx		#0
				JSR		Banz_stop_mario
				ldx		#0
				JSR		Set_up_mario
				JMP     owari_mario
;
MARIO_4 		ldy		#0008h						;n`lAhX
				ldx		#0
				JMP     Jump_set
;
MARIO_5			ldy		#0008h						;n`lAhX
				ldx		#0002h
				JMP     Jump_set
;
MARIO_6			ldy		#000ch						;n`lAhX
				ldx		#0004
				JMP     Jump_set
;
MARIO_7			ldy		#0010h						;n`lAhX
				ldx		#0006
				JMP     Jump_set
;
MARIO_8			ldy		#0010h						;n`lAhX
				ldx		#0008
				JMP     Jump_set
;
MARIO_9			ldy		#0010h						;n`lAhX
				ldx		#000ah
				JMP     Jump_set
;
MARIO_10		ldy		#0010h						;n`lAhX
				ldx		#000ch
				JMP     Jump_set
;
Jump_set		JSR     Set_MARIO_Shaw
;
				ldx		#0002
				JSR		Banz_stop_mario
				ldx		#0002
				JSR		Set_up_mario
owari_mario		rts
;<<<<<<<<<<<<<< CfbNXf[^[ >>>>>>>>>>>>>>>>>>
Select_mario	DW		owari_mario,MARIO_1,MARIO_2
				DW		MARIO_count
MARIO_fight		DW		MARIO_3,MARIO_4,MARIO_5
				DW		MARIO_6,MARIO_7,MARIO_8
				DW		MARIO_9,MARIO_10,MARIO_3
				DW		MARIO_3,MARIO_3,MARIO_3
				DW		MARIO_3,MARIO_3
;<<<<<<<<<<<<<<< oUCXgbv >>>>>>>>>>>>>>>>>>>>>
Banz_stop_mario	ldy		#0040h						;n`lAhX
				JSR     Set_MARIO_POSE
				rts
;<<<<<<<<<<<<<<< VyXZbg >>>>>>>>>>>>>>>>>
Set_up_mario	ldy		#0028h						;n`lAhX
				JSR     Set_MARIO_Cham
				rts
;<<<<<<<<<<<<<<<<<< Tu[` >>>>>>>>>>>>>>>>>>>>>>
Set_MARIO_Cham	equ		$
				lda		MARIO_Champgne,x
				tax
				JSR		AWARD_OAM_SET
				rts
;
Set_MARIO_POSE	equ		$
				lda		MARIO_POSE,x
				tax
				JSR		AWARD_OAM_SET
				rts
;
Set_MARIO_Shaw	equ		$
				lda		MARIO_Shawer,x
				tax
				JSR		AWARD_OAM_SET
				rts
;***********************************************************
;						Nbp
;***********************************************************
Set_KUPPA		equ		$		
				phy
				ldx		<Pose_counter
				lda		KUPPA_POSE,x
				tax
				phx
				JSR		AWARD_OAM_SET
;
				ldx		Award_counter
				lda		KUPPA_offset,x
				sta		<addr
;
				plx
				ply
				phy
				phx
				mem8
				sep		#00100000b
				JSR		SET_Hposition
;
				plx
				ply
				JSR		SET_Vposition
				mem16
				rep		#00100000b
				rts
;
KUPPA_offset	DW		0000h,0f81eh,0f0e0h
;*********************************************************
;				Nbp VyZbg
;*********************************************************
KUPPA_Champgne_set	equ		$
;<<<<<<<<<<<<<<< ^C}[`FbN >>>>>>>>>>>>>>>>>
				lda		<Champgne_timer
				cmp		#0140h
				beq		Champne_kuppa
				cmp		#0160h
				beq		Champne_kuppa
				cmp		#0178h
				beq		Champne_kuppa
;
				lda		<Pose_flag
				jmp		SET_kuppa
;<<<<<<<<<<<<<<< CfbNXWv >>>>>>>>>>>>>>
Champne_kuppa	lda		<Pose_flag
				inc		a
				sta		<Pose_flag
SET_kuppa		asl		a
				tax		
				jmp		(!Select_kuppa,x)
;<<<<<<<<<<<<<<<< tOZbg >>>>>>>>>>>>>>>>>>>>>
Chap_kuppa_1	JSR		Set_lean_kuppa
				jmp		Stop_kuppa
;
Chap_kuppa_2	lda		#0a874h
				sta		oamdat+10h
				JSR		Cork_set
				jmp     Stop_kuppa
;
Chap_kuppa_3	JSR		Set_ERASE
				JSR		Set_drink_kuppa
				jmp		owari_kuppa
Stop_kuppa		JSR     Banz_stop_kuppa
owari_kuppa		rts
;
Select_kuppa	DW		owari_kuppa,Chap_kuppa_1
				DW		Chap_kuppa_2,Chap_kuppa_3
;<<<<<<<<<<<<<<<<< oUCXgbv >>>>>>>>>>>>>>>>
Banz_stop_kuppa	ldy		#0040h
				ldx		#0
				lda		KUPPA_POSE,x
				tax
				JSR		AWARD_OAM_SET			
				rts
;<<<<<<<<<<<<<<<<<< VyXZbg >>>>>>>>>>>
Set_lean_kuppa	ldy		#0028h						;n`lAhX
				ldx		#0004
				JSR		Set_KUPPA_Cham
				rts
;<<<<<<<<<<<<<<<< Vy݃Zbg >>>>>>>>>>>>>
Set_drink_kuppa	equ		$
;--------VyZbg
				ldy		#0028h						;n`lAhX
				ldx		<Pose_counter
				JSR     Set_KUPPA_Cham
;-------LZbg
				ldy		#0040h						;n`lAhX
				ldx		<Pose_counter
				lda		KUPPA_POSE1,x
				tax
				JSR		AWARD_OAM_SET			
;--------V[Zbg
				ldy		#0008h						;n`lAhX
				ldx		<Pose_counter
				lda		KUPPA_shower,x
				tax
				JSR		AWARD_OAM_SET			
				rts
;<<<<<<<<<<<<<<<<< Tu[` >>>>>>>>>>>>>>>>>>>>
Set_KUPPA_Cham	equ		$
				lda		KUPPA_Champgne,x
				tax
				JSR		AWARD_OAM_SET
				rts			
;*************************************************************
;						s[`
;*************************************************************
Set_PEACH		equ		$		
				phy
				ldx		<Pose_counter
				lda		PEACH_POSE,x
				tax
				phx
				JSR		AWARD_OAM_SET
;
				ldx		Award_counter
				lda		PEACH_offset,x
				sta		<addr
;
				plx
				ply
				phy
				phx
				mem8
				sep		#00100000b
				JSR		SET_Hposition
;
				plx
				ply
				JSR		SET_Vposition
				mem16
				rep		#00100000b
				rts
;
PEACH_offset	DW		0000h,0f81dh,0f0e1h
;************************************************************
;					s[` VyZbg
;************************************************************
PEACH_Champgne_set	equ		$
;<<<<<<<<<<<<<<<< ^C}[`FbN >>>>>>>>>>>>>>>>>>>
				lda		<Champgne_timer
				cmp		#0140h
				beq		Champne_peach
				cmp		#0160h
				beq		Champne_peach
				cmp		#0178h
				beq     Champne_peach
				cmp		#01c0h
				beq		Champne_peach
;	
				lda		<Pose_flag
				jmp		SET_peach
;<<<<<<<<<<<<<<<< CfbNXWv >>>>>>>>>>>>>>>>
Champne_peach	lda		<Pose_flag
				inc		a
				sta		<Pose_flag
SET_peach		asl		a
				tax		
				jmp		(!Select_peach,x)
;<<<<<<<<<<<<<<<<<<< tOZbg >>>>>>>>>>>>>>>>>>>>>
Chap_peach_1	JSR		Set_lean_peach
				jmp		Stop_peach
;
Chap_peach_2	lda		#0a874h
				sta		oamdat+10h
				JSR		Cork_set
				jmp     Stop_peach
;
Chap_peach_3	JSR		Set_ERASE
				JSR     Set_lean_peach
				jmp		Stop_peach
;
Chap_peach_4	JSR		Set_drink_peach
				jmp		owari_peach
;
Stop_peach		JSR     Banz_stop_peach
owari_peach		rts
;
Select_peach	DW		owari_peach,Chap_peach_1
				DW		Chap_peach_2,Chap_peach_3		
				DW		Chap_peach_4
;<<<<<<<<<<<<<<<<<< oUCXgbv >>>>>>>>>>>>>>>>>>
Banz_stop_peach	ldy		#0040h						;n`lAhX
				ldx		#0
				JSR		Set_PEACH_Pose
				rts
;<<<<<<<<<<<<<<<<< VyXZbg >>>>>>>>>>>>>>>
Set_lean_peach	ldy		#0028h						;n`lAhX
				ldx		#0000
				lda		PEACH_Champgne,x
				tax
				JSR		AWARD_OAM_SET			
				rts
;<<<<<<<<<<<<<<<<<< Vy݃Zbg >>>>>>>>>>>>>
Set_drink_peach	equ		$
				inc		Fight_timer
				lda		Fight_timer
				cmp		#0020h
				bne		Set_drink
				stz		Fight_timer
;
				inc		<Fight_counter
				inc		<Fight_counter
				lda		<Fight_counter
				cmp		#0004h
				beq		reset_drink
;----VyZbg
Set_drink		ldy		#0028h						;n`lAhX
				ldx		<Fight_counter
				lda		PEACH_Champgne1,x
				tax
				JSR		AWARD_OAM_SET			
;----|[YZbg
				ldy		#0040h						;n`lAhX
				ldx		<Fight_counter
				JSR     Set_PEACH_Pose
;----Zbg
				lda		<Fight_counter
				beq		owari_drink
				ldy		#0030h						;n`lAhX
				ldx		#0004
				JSR     Set_PEACH_Pose
owari_drink		rts
;
reset_drink		stz		<Fight_counter
				jmp		Set_drink
;<<<<<<<<<<<<<<<<< Tu[` >>>>>>>>>>>>>>>>>>>>>>>>
Set_PEACH_Pose	equ		$
				lda		PEACH_POSE,x
				tax
				JSR		AWARD_OAM_SET			
				rts
;*********************************************************
;					RO
;*********************************************************
Set_KONG		equ		$		
				phy
				ldx		<Pose_counter
				lda		KONG_POSE,x
				tax
				phx
				JSR		AWARD_OAM_SET
;
				ldx		Award_counter
				lda		KONG_offset,x
				sta		<addr
;
				plx
				ply
				phy
				phx
				mem8
				sep		#00100000b
				JSR		SET_Hposition
;
				plx
				ply
				JSR		SET_Vposition
				mem16
				rep		#00100000b
				rts
;
KONG_offset		DW		0000h,0f81eh,0f0e1h
;********************************************************
;					RO VyZbg
;********************************************************
KONG_Champgne_set	equ		$
;<<<<<<<<<<<<<<<<< ^C}[`FbN >>>>>>>>>>>>>>>>>
				lda		<Champgne_timer
				cmp		#0140h
				beq		Champne_kong
				cmp		#015ch
				beq		Champne_kong
				cmp		#0178h
				beq     Champne_kong
;
				lda		<Pose_flag
				jmp		SET_kong
;<<<<<<<<<<<<<<<<<< CfbNXWv >>>>>>>>>>>>>
Champne_kong	lda		<Pose_flag
				inc		a
				sta		<Pose_flag
SET_kong		asl		a
				tax		
				jmp		(!Select_kong,x)
;<<<<<<<<<<<<<<<<<<< tOZbg >>>>>>>>>>>>>>>>>>>>
Chap_kong_1		ldy		#0028h						;n`lAhX
				ldx		#0000
				JSR     Set_KONG_Cham
				jmp		Kong_pose_set	
;
Chap_kong_2		lda		#0b273h
				sta		oamdat+10h
				JSR		Cork_set
;
Kong_pose_set	ldx		#0						
				ldy		#0040h						;n`lAhX
				JSR     Set_KONG_POSE
				jmp		owari_kong
;------------------------------------------------
KONG_count		JSR     Set_ERASE
				inc		Fight_timer
				lda		Fight_timer
				cmp		#000ch
				beq		KONG_fight_set
;
KONG_fight_set1	lda     <Fight_counter
				cmp		#0005h
				beq		reset_kon_fight
				asl		a
				tax
				jmp     (!KONG_fight,x)
;
KONG_fight_set	stz		Fight_timer
;
				lda		<Fight_counter
				asl		a
				tax
				inc		<Fight_counter
				jmp		(!KONG_fight,x)
;
reset_kon_fight	lda		#0001
				sta		<Fight_counter
				jmp		KONG_fight_set1
;------------------------------------------------
Chap_kong_3		ldy     #0028h						;n`lAhX
				ldx		#0002
				jmp     Kong_banzai
;
Chap_kong_4		ldy     #0028h						;n`lAhX
				ldx		#0004
				jmp     Kong_banzai
;
Chap_kong_5		ldy     #0028h						;n`lAhX
				ldx		#0006
Kong_banzai		JSR		Set_KONG_Cham
				ldy		#0040h
				ldx		#0002
				JSR     Set_KONG_POSE
				jmp     owari_kong
;
Chap_kong_6		
;----_X|[Y
				ldy		#0040h						;n`lAhX
				ldx		#0004
				JSR		Set_KONG_POSE
;----Zbg
				ldy		#0010h						;n`lAhX
				ldx		#0008
				JSR		Set_KONG_POSE
;
				ldy     #0028h						;n`lAhX
				ldx		#0008
				jmp     Set_KONG_cham
;
Chap_kong_7		
;----_X|[Y
				ldy     #0040h						;n`lAhX
				ldx		#0006
				JSR		Set_KONG_POSE
;----Zbg
				ldy     #0010h						;n`lAhX
				ldx		#000ah
				JSR		Set_KONG_POSE
;
				ldy     #0028h						;n`lAhX
				ldx		#000ah
Set_KONG_cham	JSR		Set_KONG_Cham
owari_kong		rts	
;- - - - - - - - - -- - - - - - - - - - - - - - - - - - - -
Select_kong		DW		owari_kong, Chap_kong_1,Chap_kong_2
				DW		KONG_count
;
KONG_fight		DW		Chap_kong_3,Chap_kong_4,Chap_kong_5
				DW		Chap_kong_6,Chap_kong_7
;<<<<<<<<<<<<<<<<< Tu[` >>>>>>>>>>>>>>>>
Set_KONG_Cham	equ		$
				lda		KONG_Champgne,x
				tax
				JSR		AWARD_OAM_SET			
				rts
;
Set_KONG_POSE	equ		$
				lda		KONG_POSE,x
				tax
				JSR		AWARD_OAM_SET
				rts
;********************************************************
;						CW
;********************************************************
Set_LUIZI		equ		$		
				phy
				ldx		<Pose_counter
				lda		LUIZI_POSE,x
				tax
				phx
				JSR		AWARD_OAM_SET
;
				ldx		Award_counter
				lda		LUIZI_offset,x
				sta		<addr

				plx
				ply
				phy
				phx
				mem8
				sep		#00100000b
				JSR		SET_Hposition
;
				plx
				ply
				JSR		SET_Vposition
				mem16
				rep		#00100000b
				rts
;
LUIZI_offset	 DW      0000h,0f81dh,0f0e1h
;********************************************************
;					CW VyZbg
;********************************************************
LUIZI_Champgne_set	equ		$
;<<<<<<<<<<<<<<<<< ^C}[`FbN >>>>>>>>>>>>>>>
				lda		<Champgne_timer
				cmp		#0140h
				beq		Champne_luizi
				cmp		#015ch
				beq		Champne_luizi
				cmp		#0178h
				beq     Champne_luizi
				cmp		#0188h
				beq		Champne_luizi
				cmp		#0198h
;
				lda		<Pose_flag
				jmp		SET_luizi
;<<<<<<<<<<<<<<<<< CfbNXWv >>>>>>>>>>>
Champne_luizi	lda		<Pose_flag
				inc		a
				sta		<Pose_flag
SET_luizi		asl		a
				tax		
				jmp		(!Select_luizi,x)
;<<<<<<<<<<<<<<<<<< tOZbg >>>>>>>>>>>>>>>>>>
Chap_luizi_1	ldy		#0028h						;n`lAhX
				ldx		#0000
				jmp		Luizi_cham_set
;	
Chap_luizi_2	lda		#0b273h
				sta		oamdat+10h
				JSR		Cork_set
				jmp     Luizi_cham_set
;
Chap_luizi_3	JSR		Set_ERASE
				ldy		#0028h						;n`lAhX
				ldx		#0002
				jmp     Luizi_cham_set
;
Luizi_count		inc		Fight_timer
				lda		Fight_timer
				cmp		#0008h
				beq		Luizi_fight_set
				lda		<Fight_counter
				asl		a
				tax
				jmp		Luizi_jump
;
Luizi_fight_set	stz		Fight_timer
				JSR     Set_ERASE
;
				lda		<Fight_counter
				cmp		#0005
				beq		Loop_luizi
				asl		a
				tax
				inc		<Fight_counter
Luizi_jump		jmp		(!LUIZI_fight,x)
;
Loop_luizi		stz		<Fight_counter
				rts
;------------------------------------------
Chap_luizi_4	ldy		#0008h						;n`lAhX
				ldx		#0002
				JSR     Set_LUIZI_shaw
;
				ldy		#0028h						;n`lAhX
				ldx		#0004
				jmp		Luizi_cham_set
;
Chap_luizi_5	JSR		Set_ERASE					;n`lZbg
				ldy		#0010h						;n`lAhX
				ldx		#0004
				JSR     Set_LUIZI_shaw
;
				ldy		#0028h						;n`lAhX
				ldx		#0006h
				jmp     Luizi_cham_set
;
Chap_luizi_6	ldy		#0010h						;n`lAhX
				ldx		#0006
				JSR     Set_LUIZI_shaw
;
				ldy		#0028h						;n`lAhX
				ldx		#0008h
				jmp     Luizi_cham_set
;
Chap_luizi_7	ldy		#0010h						;n`lAhX
				ldx		#0008h
				JSR     Set_LUIZI_shaw
;
				ldy		#0028h						;n`lAhX
				ldx		#000ah
				jmp     Luizi_cham_set
;
Chap_luizi_8	JSR		Set_ERASE					;n`lZbg
				ldy		#0028h						;n`lAhX
				ldx		#000ch
				jmp     Luizi_cham_set
;
Chap_luizi_9	ldy		#0028h						;n`lAhX
				ldx		#0000
				JSR		Set_LUIZI_shaw		
;
				ldy		#0028h						;n`lAhX
				ldx		#0002h
Luizi_cham_set	JSR     Set_LUIZI_Cham
;
Stop_luizi		ldx		#0						
				ldy		#0040h						;n`lAhX
				JSR     Set_LUIZI_POSE
owari_luizi		rts
;--------------------------------------------------------------
Select_luizi	DW		owari_luizi,Chap_luizi_1,Chap_luizi_2
				DW		Chap_luizi_3,Luizi_count
LUIZI_fight		DW		Chap_luizi_4,Chap_luizi_5,Chap_luizi_6
				DW		Chap_luizi_7,Chap_luizi_8,Chap_luizi_9
;<<<<<<<<<<<<<<<< |[YTu[` >>>>>>>>>>>>>>>>
Set_LUIZI_POSE	equ		$
				lda		LUIZI_POSE,x
				tax
				JSR		AWARD_OAM_SET
				rts
;<<<<<<<<<<<<<<<< VyTu[` >>>>>>>>>>>>>
Set_LUIZI_Cham	equ		$
				lda		LUIZI_Champgne,x
				tax
				JSR		AWARD_OAM_SET
				rts
;<<<<<<<<<<< VyV[Tu[` >>>>>>>>>
Set_LUIZI_shaw	equ		$
				lda		LUIZI_shower,x
				tax
				JSR		AWARD_OAM_SET
				rts
;<<<<<<<<<<<< n`lZbgTu[` >>>>>>>>>>>>
Set_ERASE		equ		$
				ldx		#0
				lda		#0e0f8h
loop_erase		sta		oamdat,x
				inx
				inx
				cpx		#0040h
				bne		loop_erase
				rts
;********************************************************
;			  		mRmR
;********************************************************
Set_NOKONOKO	equ		$		
				phy
				ldx		<Pose_counter
				lda		NOKO_POSE,x
				tax
				phx
				JSR		AWARD_OAM_SET
;
				ldx		Award_counter
				lda		NOKONOKO_offset,x
				sta		<addr
;
				plx
				ply
				phy
				phx
				mem8
				sep		#00100000b
				JSR		SET_Hposition
;
				plx
				ply
				JSR		SET_Vposition
				mem16
				rep		#00100000b
				rts
;
NOKONOKO_offset	DW      0000h,0f81eh,0f0e1h		
;**********************************************************
;					mRmR VyZbg
;***********************************************************
NOKONOKO_Champgne_set	equ		$
;<<<<<<<<<<<<<<<< ^C}[`FbN >>>>>>>>>>>>>>>>>>>>>
				lda		<Champgne_timer
				cmp		#0140h
				beq		Champne_noko
				cmp		#015ch
				beq		Champne_noko
				cmp		#0178h
				beq     Champne_noko
				jmp		SET_noko
;- - - - - - - - - - - -- - - - -- - - - -- - -
Champne_noko	lda		<Pose_flag
				inc		a
				sta		<Pose_flag
SET_noko		lda     <Pose_flag
				asl		a
				tax		
				jmp		(!Select_noko,x)
;- - - - - - - - - - - - - - - - - - - - - - - 
NOKO_1			ldy		#0028h						;n`lAhX
				ldx		#0000
				JMP		NOKO_cham_set
;
NOKO_2			lda		#0b273h
				sta		oamdat+10h
				JSR		Cork_set
				JMP		NOKO_12
;
NOKO_count		JSR     Set_ERASE
				inc		Fight_timer
				lda		Fight_timer
				cmp		#0008h
				beq		NOKO_fight_set
;
NOKO_fight_set1	lda     <Fight_counter
				cmp		#000dh
				beq		reset_nok_fight
				asl		a
				tax
				jmp     (!NOKO_fight,x)
;
NOKO_fight_set	stz		Fight_timer
;
				lda		<Fight_counter
				asl		a
				tax
				inc		<Fight_counter
				jmp		(!NOKO_fight,x)
;
reset_nok_fight	lda		#0001
				sta		<Fight_counter
				jmp		NOKO_fight_set1
;
;- - - - - - - - - - - - - - - - - - - - - - - -
;
NOKO_3			ldy		#0028h						;n`lAhX
				ldx		#0002
				jmp		NOKO_cham_set
;
NOKO_4			ldy		#0028h						;n`lAhX
				ldx		#0004
				jmp     NOKO_cham_set
;
NOKO_5			ldy		#0028h						;n`lAhX
				ldx		#0006
				JSR     Set_NOKO_Cham
;
				ldx		#0004						
				ldy		#0040h						;n`lAhX
				JSR     Set_NOKO_POSE
				jmp		owari_noko
;
NOKO_6			ldy		#0028h						;n`lAhX
				ldx		#0008
				jmp     NOKO_cham_set
;
NOKO_7			ldy		#0028h						;n`lAhX
				ldx		#000ah
				jmp     NOKO_cham_set
;
NOKO_8			ldy		#0028h						;n`lAhX
				ldx		#000ch
				JSR     Set_NOKO_Cham
;
				ldy		#0010h						;n`lAhX
				ldx		#0014h
				jmp     NOKO_cham_set
;
NOKO_9			JSR		Set_ERASE					;n`lZbg
				ldy		#0028h						;n`lAhX
				ldx		#000eh
				jmp     NOKO_cham_set
;
NOKO_10			ldy		#0028h					;n`lAhX
				ldx		#0010h
				JSR     Set_NOKO_Cham
;
				ldx		#0006						
				ldy		#0040h					;n`lAhX
				JSR     Set_NOKO_POSE
				jmp		owari_noko
;
NOKO_11			ldy		#0028h					;n`lAhX
				ldx		#0012h
				JSR     Set_NOKO_Cham
;
				ldy		#0010h					;n`lAhX
				ldx		#0016h
NOKO_cham_set	JSR     Set_NOKO_Cham
;
NOKO_12			ldx		#0						
				ldy		#0040h						;n`lAhX
				JSR     Set_NOKO_POSE
owari_noko		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Select_noko		DW		owari_noko,NOKO_1,NOKO_2,NOKO_count
;
NOKO_fight		DW		NOKO_3,NOKO_4,NOKO_5,NOKO_5,NOKO_5,NOKO_6,NOKO_7
				DW		NOKO_8,NOKO_9,NOKO_10,NOKO_10,NOKO_10,NOKO_11
;<<<<<<<<<<<<<<<<< Tu[` >>>>>>>>>>>>>>>>>>
Set_NOKO_Cham	equ		$
				lda		NOKO_Champgne,x
				tax
				JSR		AWARD_OAM_SET
				rts
;
Set_NOKO_POSE	equ		$
				lda		NOKO_POSE,x
				tax
				JSR		AWARD_OAM_SET
				rts
;***********************************************************
;						Lms
;***********************************************************
Set_KINOPIYO	equ		$		
				phy
				ldx		<Pose_counter
				lda		KINOP_POSE,x
				tax
				phx
				JSR		AWARD_OAM_SET
;
				ldx		Award_counter
				lda		KINOPIYO_offset,x
				sta		<addr
;
				plx
				ply
				phy
				phx
				mem8
				sep		#00100000b
				JSR		SET_Hposition
;
				plx
				ply
				JSR		SET_Vposition
				mem16
				rep		#00100000b
				rts
;
KINOPIYO_offset DW      0000h,0f81eh,0f0e1h				
;***********************************************************
;					Lms VyZbg
;***********************************************************
KINOPIYO_Champgne_set	equ		$
;<<<<<<<<<<<<<<<<< ^C}[`FbN >>>>>>>>>>>>>>>>>>>> 
				lda		<Champgne_timer
				cmp		#0140h
				beq		Champne_kinop
				cmp		#015ch
				beq		Champne_kinop
				cmp		#0178h
				beq		Champne_kinop
				cmp		#0180h
				beq     Champne_kinop
;
				lda		<Pose_flag
				jmp		SET_kinop
;<<<<<<<<<<<<<<<<<< CfbNXWv >>>>>>>>>>>>>>>
Champne_kinop	lda		<Pose_flag
				inc		a
				sta		<Pose_flag
SET_kinop		asl		a
				tax		
				jmp		(!Select_kinop,x)
;<<<<<<<<<<<<<<<<<<<< tOZbg >>>>>>>>>>>>>>>>>>>>>
Chap_kinop_1	JSR		Set_lean_kinop
				jmp		banzai_stop
;
Chap_kinop_2	lda		#0b273h
				sta		oamdat+10h
				JSR     Cork_set
				jmp		banzai_stop

Chap_kinop_3	JSR		Set_turu_0
				JSR     Set_up_kinop
				jmp     banzai_stop
;
Chap_kinop_4	JSR     Set_turu_1
;
banzai_stop		JSR		Banz_stop_kinop
owari_kinop     rts
;<<<<<<<<<<<<<<<<<<<< ZNgf[^[ >>>>>>>>>>>>>>>>>>
Select_kinop	DW		owari_kinop,Chap_kinop_1,Chap_kinop_2
				DW		Chap_kinop_3,Chap_kinop_4
;<<<<<<<<<<<<<<<<<<<< oUCXgbv >>>>>>>>>>>>>>>>>>
Banz_stop_kinop	ldy		#0040h
				ldx		#0
				lda		KINOP_POSE,x
				tax
				JSR		AWARD_OAM_SET			
				rts
;<<<<<<<<<<<<<<<<<<< VyXZbg >>>>>>>>>>>>>>>>
Set_lean_kinop	ldy		#0028h							;n`lAhX
				ldx		#0
				JSR		Set_KINOP_Cham
				rts
;<<<<<<<<<<<<<<<<<< VyZbg >>>>>>>>>>>>>>>>>
Set_up_kinop	ldy		#0028h							;n`lAhX
				ldx		#0002					
				JSR		Set_KINOP_Cham
				rts
;<<<<<<<<<<<<<<<<<< Zbg >>>>>>>>>>>>>>>>>>>>>>>>
Set_turu_0		JSR		Set_ERASE
;-------(@̐Zbg)--------
				lda		#0a472h
				sta     oamdat+1c0h
				lda		#3d2ah
				sta		oamdat+1c2h
;-------(̗tZbg)----------
				ldx		#0
				lda		#3d2ch
loop_turu		sta		oamdat+1c6h,x
				JSR		X_inx
				cpx		#0014h
				bne		loop_turu
;
				lda		#0aaaah
				sta		msbdat
				stz		Turu_counter
				rts
;<<<<<<<<<<<<<<<<<< Zbg_1 >>>>>>>>>>>>>>>>>>>>>>>>
Set_turu_1		equ		$
;-------(̐JE^[)-----------
Set_counter		lda		<Fight_counter
				beq		Set_tutr
				cmp		#0010h
				beq		reset_count_fit
Set_count_inc	inc		<Fight_counter
;--------(̐A΂Zbg)------
				lda		oamdat+1c0h
				sec
				sbc		#0100h
				sta		oamdat+1c0h
;---------(]Zbg)-----------------
owari_turu		inc		Fight_timer
				lda		Fight_timer
				cmp		#000ah
				bne		owari_hanten
				stz		Fight_timer
;		
				ldx		#0
loop_hanten		lda		oamdat+1c2h,x
				eor		#4000h
				sta		oamdat+1c2h,x
				JSR		X_inx
				cpx		#0018h
				bne		loop_hanten
owari_hanten	rts
;--------(̗tZbg)--------------
Set_tutr		ldx		Turu_counter
				cpx		#0014h
				beq		owari_turu
				lda		oamdat+1c0h
				and		#0ff00h
				clc
				adc		#0072h
				sta		oamdat+1c4h,x
				JSR		X_inx
				stx		Turu_counter
				jmp		Set_count_inc
;-------(JE^[Zbg)------------
reset_count_fit	stz		<Fight_counter
				jmp		Set_counter
;<<<<<<<<<<<<<<<< VypTu[` >>>>>>>>>>>>>>>>
Set_KINOP_Cham	equ		$
				lda		KINOP_Champgne,x
				tax
				JSR		AWARD_OAM_SET			
				rts
;<<<<<<<<<<<<<<<<< RNpTu[` >>>>>>>>>>>>>>>>>>>
Cork_set		equ		$
				lda		Cork_place						;RNOZbg
				clc
				adc		#0202h
				sta		Cork_place
				lda		oamdat+10h
				sec
				sbc		Cork_place
				sta		oamdat+10h
;
				lda		#38deh							;RÑLN^[Zbg
				sta		oamdat+12h
;- - - - - - - - - - - - - - - - - - - - - -
				lda		Shock_flag
				cmp		#000ah
				beq		owari_cork
;
				ldx		Shock_flag
				lda		Cork_data,x						;tVRNZbg
				sta		oamdat+12h
;
				lda		Shock_flag						;ŏ̃RN˃`FbN
				bne		cork_jump
;
				lda		oamdat+28h						;rVbNZbg
				clc
				adc		#0202h
				sta		oamdat+28h
cork_jump		inc		Shock_flag
				inc		Shock_flag
owari_cork		rts
;
Cork_data		DW		38ech,3aedh,3aeah,3aebh,3afah,3afbh

;**********************************************************
;						bV[
;**********************************************************
Set_YOSSY		equ		$		
				phy
				ldx		<Pose_counter
				lda		YOSSY_POSE,x
				tax
				phx
				JSR		AWARD_OAM_SET
;
				ldx		Award_counter
				lda		YOSSY_offset,x
				sta		<addr

				plx
				ply
				phy
				phx
				mem8
				sep		#00100000b
				JSR		SET_Hposition
;
				plx
				ply
				JSR		SET_Vposition
				mem16
				rep		#00100000b
				rts
;
YOSSY_offset	 DW      0000h,0f81eh,0f0e1h
;************************************************************
;					bV[ VyZbg
;************************************************************
YOSSY_Champgne_set	equ		$
;<<<<<<<<<<<<<<<<< ^C}[`FbN >>>>>>>>>>>>>>>>>
				lda		<Champgne_timer
				cmp		#0140h
				beq		Champne_yossy
				cmp		#015ch
				beq		Champne_yossy
				cmp		#0178h
				beq		Champne_yossy		
;
				lda		<Pose_flag
				jmp		SET_yossy
;<<<<<<<<<<<<<< CfbNXWv >>>>>>>>>>>>>>>>
Champne_yossy	lda		<Pose_flag
				inc		a
				sta		<Pose_flag
SET_yossy		asl		a
				tax		
				jmp		(!Select_yossy,x)
;<<<<<<<<<<<<<<<<<< |[YZbg >>>>>>>>>>>>>>>>>>>>>
YOSSY_set1		JSR		Banz_stop_yossy
				JSR     Set_up_yossy
				JMP		owari_yossy
;			
YOSSY_set2		lda		#0b273h
				sta		oamdat+10h
				JSR		Banz_stop_yossy
				JSR     Cork_set
				JMP		owari_yossy
;
YOSSY_set3		JSR		Set_fit_yossy
owari_yossy		rts
;<<<<<<<<<<<<<<<<<< CfbNXf[^[ >>>>>>>>>>>>>>>
Select_yossy	DW		owari_yossy,YOSSY_set1,YOSSY_set2
				DW		YOSSY_set3
;<<<<<<<<<<<<<<<<<< oUCXgbv >>>>>>>>>>>>>>>>>>>
Banz_stop_yossy	ldx		#0						
				ldy		#0040h							;n`lAhX
				JSR     Set_YOSSY_POSE
				rts
;<<<<<<<<<<<<<<<<<< VyXZbg >>>>>>>>>>>>>>>
Set_up_yossy	ldy		#0028h							;n`lAhX
				ldx		#0
				JSR     Set_YOSSY_Cham
				rts
;<<<<<<<<<<<<<<< Vpt@CgZbg >>>>>>>>>>>>>>
Set_fit_yossy	equ		$
;--------(|[YZbgp)--------------
				ldx		#0000
				lda		yossy_flag
				beq		Set_yossy_pose
;
				ldx		#0002
Set_yossy_pose	ldy		#0040h							;n`lAhX
				JSR     Set_YOSSY_POSE
;---------(Vyp)----------------
				inc		Fight_timer						;^C}[`FbN
				lda		Fight_timer
				and		#000fh
				cmp		#0004h
				bne		owari_yossy_set
;
				lda		Fight_timer						;Xgbv`FbN
				and		#0800h
				beq		Fight_check
;
				lda     Fight_timer						;Xgbv^C}[JEg
				and		#8f00h
				sta		Fight_timer
				lda		Fight_timer
				clc
				adc		#0100h
				sta		Fight_timer
;
				and		#0f00h							;Xgbv^C}[JEg`FbN	
				cmp		#0900h
				bne		owari_yossy_set
;
				inc		yossy_flag
;
				lda		Fight_timer						;Xgbv^C}[Zbg
				and		#8000h
				sta		Fight_timer
				jmp		All_reset
;
Fight_check		lda		Fight_timer						;`FbN
				and		#8000h
				sta		Fight_timer
				bne		back_set
;
				inc		<Fight_counter					;st@CgZbg
				inc		<Fight_counter
				lda		<Fight_counter
				cmp		#0022h
				beq		reset_fight
				cmp		#0012h
				bcc		All_reset
				stz		yossy_flag
				jmp		All_reset
;
back_set		dec		<Fight_counter					;tt@CgZbg
				dec		<Fight_counter
				lda		<Fight_counter
				cmp		#0002
				beq		reset_fight
				cmp		#0010h
				bcs		All_reset
				stz		yossy_flag
;
All_reset		JSR		Set_ERASE
;
Fight_yossy		JSR		Set_fight_yossy
;
owari_yossy_set	rts
;
reset_fight		lda		Fight_timer
				and		#8000h
				bne		Set_loop
				ora		#8800h
				sta		Fight_timer
				jmp		Fight_yossy
Set_loop		lda		#0800h
				sta		Fight_timer
				jmp		Fight_yossy
;<<<<<<<<<<<<<<<<<<<<< Tu[` >>>>>>>>>>>>>>>>>>>>>>>>>>
Set_YOSSY_Cham	equ		$
				lda		YOSSY_Champgne,x
				tax
				JSR		AWARD_OAM_SET
				rts
;
Set_YOSSY_POSE	equ		$
				lda		YOSSY_POSE,x
				tax
				JSR		AWARD_OAM_SET
				rts
;
Set_fight_yossy	ldy		#0028h							;n`lAhX
				ldx		<Fight_counter		
				JSR     Set_YOSSY_Cham

;***********************************************************
;					ŏI`FbN
;***********************************************************
Final_end_set	equ		$
				lda		<Champgne_timer					;^C}[`FbN
				cmp		#0500h
				beq		Set_reset
;
				lda		<button_TG						;{^`FbN
				ora     <button_TG+2
				and     #9000h
				beq		owari_final
;
Set_reset		lda		#0008							;[hZbg
				sta		<game_selecta
;
				lda		#8f00h							;tF[hCZbg
				sta		<fade_control
;
				lda		#0040h							;tF[hXs[hZbg
				sta		fade_speed
owari_final		rts		
;************************************************************
;					Cp Tu[`W
;************************************************************
;<<<<<<<<<<<<<<<<<<<< XN[ >>>>>>>>>>>>>>>>
Scroll_routine	equ		$
				mem16
				idx16
				lda		<Scroll_X
				clc
				adc		<Scroll_speed
				sta		<Scroll_X
 				mem8
				sep		#00100000b
				lda		<Scroll_X+2
				adc		#0
				sta		<Scroll_X+2
				mem16
				rep		#00100000b
				rts
;<<<<<<<<<<<<<<<<<< ]Agk >>>>>>>>>>>>>>>>
Revolve_routine	equ		$
				mem16
				idx16
				lda		<Zoom_set
				ldy		<Angle_set
				ldx		#rotate_A
				JSL		>Rotate_mode7
				rts
;<<<<<<<<<<<<<<<<<<< Zbg >>>>>>>>>>>>>>>>>>>>>
X_inx			equ		$
				inx
				inx
				inx
				inx
				rts							
;<<<<<<<<<<<<<<<<<<< YZbg >>>>>>>>>>>>>>>>>>>>>>
Y_iny			equ		$
				iny
				iny
				iny
				iny
				rts
;<<<<<<<<<<<<< IuWFMSBpTu[` >>>>>>>>>>>
OBJ_ERASE		equ		$
				mem16
				idx16
				rep		#00100000b
				phx
				txa
				and		#000ch					;ڂ̃IuWF`FbN
				lsr		a
				lsr		a
				tay
;
				txa								;ڂMSB`FbN
				lsr		a
				lsr     a
				lsr     a
				lsr     a
				tax
;
				mem8
				sep		#00100000b
				lda		msbdat,x				;MSBZbg`FbN
				and		MSB_data,y
				bne		Set_MSB1
;
				lda     msbdat,x				;MSBʃZbg
				ora		MSB_data,y
				sta		msbdat,x
				plx
;
				lda		<OBJ_check_flag			;op^[`FbN
				beq		right_erase
;		
				lda		#0ffh					;ɏ
				sta		oamdat,x
				jmp		owari_erase
;
right_erase		lda		#0f0h					;o鎞
				sta		oamdat,x
owari_erase		rts
;
Set_MSB1		idx16							;lraĉʂ̎
				mem8
				lda     msbdat,x
				and		MSB_data1,y
				sta		msbdat,x
				plx
				jmp		owari_erase
;<<<<<<<<<<<<< \naiCn`lZbg >>>>>>>>>>>>>>>>>>>>
AWARD_OAM_SET	equ		$
				mem16
				idx16
loop_OAM_set	lda		!0,x
				cmp		#0ffffh
				beq		owari_Set
				sta		oamdat,y
				inx
				inx
				iny
				iny
				jmp		loop_OAM_set
owari_Set		rts
;<<<<<<<<<<<<<<<<< \g|WVZbg >>>>>>>>>>>>>>>>>>
SET_Hposition	equ		$
				mem8
loop_Hpos		lda		!0,x
				cmp		#0ffh
				beq		owari_Hpos
				sec
				sbc		<addr
				sta		oamdat,y
				JSR		X_inx
				JSR		Y_iny
				jmp		loop_Hpos
owari_Hpos		rts
;<<<<<<<<<<<<<<<<<< \V|WVZbg >>>>>>>>>>>>>>>>>>>
SET_Vposition   equ     $
loop_Vpos		lda		!1,x
				cmp		#0ffh
				beq		owari_Vpos
				sec
				sbc		<addr+1
				sta		oamdat+1,y
				JSR		X_inx
				JSR		Y_iny
				jmp		loop_Vpos
owari_Vpos		rts

MSB_data		DB		01h,04h,10h,40h
MSB_data1		DB		0feh,0fbh,0efh,0bfh
;=====================================================================
;********************************************************************
;					NMI ROUTINE
;********************************************************************
;=====================================================================
;**********************************************************
;					vNvN[uZbg
;**********************************************************
Pukupuku_tensou	equ		$
				mem16
				idx16
				JSR		Flag_set					;^C}[Zbg
				cmp     #0008h
				bne		owari_move
				stz		<Move_flag
;
				lda		#0006h						;񐔃Zbg
				sta		<Cmp_check
				ldx		<Patern_counter				;p^[Zbg
				lda		PATERN_DATA,x
;
				mem8
				sep		#00100000b
;
				JSR		KAKIKAE_set					;Zbg
;
				mem16
				rep		#00100000b
				lda		#14b3h						;AhXăZbg
				sta		<Set_address
;
				JSR		Counter_set					;p^[JE^[Zbg
owari_move		rts
;		
;*************************************************************
;					}gK[uZbg
;*************************************************************
Mant_tensou		equ		$
Mant_kakikae	JSR     Flag_set					;^C}[Zbg
				cmp     #0004h
				bne		owari_move1
				stz		<Move_flag
;
				lda		#0002h						;񐔃Zbg
				sta		<Cmp_check
				ldx     <Patern_counter				;p^[Zbg
				lda		PATERN_DATA1,x			
				mem8
				sep		#00100000b
;			
				JSR		KAKIKAE_set					;Zbg
;
				mem16
				rep		#00100000b
				lda		#15aeh
				sta		<Set_address				;AhXăZbg
;
				JSR     Counter_set					;p^[JE^[Zbg
;<<<<<<<<<<<<< RN̊̏ >>>>>>>>>>>>>
				lda		<Champgne_timer
				cmp		#0178h
				bcc		owari_move1
;
				lda		#0001h						;񐔃Zbg
				sta		<Cmp_check
				ldx     #0004						;p^[Zbg
				lda		PATERN_DATA1,x			
				mem8
				sep		#00100000b
;			
				JSR		KAKIKAE_set					;Zbg
;
				mem16
				rep		#00100000b
				lda		#15aeh
				sta		<Set_address				;AhXăZbg
owari_move1		rts
;**********************************************************
;					A]Zbg
;**********************************************************
MAKU_tensou		equ		$
;<<<<<<<<<<<<<<<<<<<<<< ʂZbg >>>>>>>>>>>>>>>>>>
				mem16
				rep		#00100000b
				lda		#12abh						;AhXZbg
				sta		<Set_address
				mem8
				sep		#00100000b
;
				ldy		#0
Loop_NUKI_set	ldx		#0
				lda		<Set_address				;AhXZbg
				sta     Screen_address
				lda		<Set_address+1
				sta		Screen_address+1
;
				stz     Screen_step
;	
Loop_NUKI		lda		#6fh						;f[^[Zbg
				sta		Screen_write
				inx		
				cpx		#000ch
				beq		Reset_address
				jmp		Loop_NUKI
;
Reset_address	mem16
				rep		#00100000b
				lda		<Set_address				;AhXJグZbg
				clc
				adc		#80h
				sta		<Set_address
				mem8
				sep		#00100000b
				iny
				cpy		#000ch						;ǂݎ񐔃`FbN
				bne		Loop_NUKI_set
				mem16
				rep		#00100000b
;<<<<<<<<<<<<<<<<<< AZbg >>>>>>>>>>>>>>>>>>>>>>>>>>>>
				lda		#0002						;񐔃Zbg
				sta		<Cmp_check
				lda		#078ch						;AhXZbg
				sta		<Set_address
;
				JSR		Rank_Check					;NZbg
;
				lda		MAKU_Set,x					;Zbg
				mem8
				sep		#00100000b
				JSR		KAKIKAE_set
				mem16
				rep		#00100000b
;
				lda		#0002						;񐔃Zbg
				sta		<Cmp_check
				lda		#078eh						;AhXZbg
				sta		<Set_address
;
				lda		MAKU_Set+6
				mem8
				sep		#00100000b
				JSR		KAKIKAE_set
				mem16
				rep		#00100000b
				rts
				rts
;************************************************************
;					pTu[`
;************************************************************
Flag_set		equ		$
;<<<<<<<<<<<<<<<<<< ^C}[Zbg >>>>>>>>>>>>>>>>>>>>>
				inc		<Move_flag				
				lda		<Move_flag
				rts
;<<<<<<<<<<<<<< p^[JE^[Zbg >>>>>>>>>>>>>>>
Counter_set		equ		$			
				ldx     <Patern_counter			
				inx
				inx
				stx		<Patern_counter
				cpx		#0004
				beq		reset_count
owari_count		rts
;
reset_count		stz		<Patern_counter
				jmp		owari_count
;<<<<<<<<<<<<<<<<<<< ]pTu[` >>>>>>>>>>>>>>>>>
KAKIKAE_set		mem8
				idx16
				tax
;
				ldy		#0
loop_character	lda		<Set_address				;AhXZbg
				sta     Screen_address
				lda		<Set_address+1
				sta     Screen_address+1
;
				lda     #00000000b
				sta     Screen_step
;	
loop_puku		lda		!0,x						;f[^[Zbg
				cmp		#0ffh
				beq		owari_set
				sta		Screen_write
				inx		
				jmp		loop_puku
;
owari_set		mem16
				rep		#00100000b
				lda		Set_address					;AhXJグZbg
				clc
				adc		#80h
				sta		Set_address
				mem8
				sep		#00100000b
				inx		
				iny
				cpy		<Cmp_check					;ǂݎ񐔃`FbN
				bne		loop_character
				rts
				END
