
;*********************************************************************
;
;	ISPK WJ[`
;
;*********************************************************************
;@-DEL
;@-DEL
;@-DEL
;@-DEL
;
;
;---------------------------------------------------------------------
		glb	Decode_7E_X,Decode_7F_X	
;---------------------------------------------------------------------
		comn
read_addr	ds	2
write_addr	ds	3
ref_addr	ds	3
read_data	ds	2
data_count	ds	2
;---------------------------------------------------------------------
		EXTEND
bank84		SECT	REL
		mem16
		idx16
;*********************************************************************
;		ISPK ENTRY
;*********************************************************************
;		mem ? , idx16
;		Y(ROM address)
;		A(ROM bank)
;		X(address)
;---------------------------------------------------------------------
Decode_7E_X	php			;>
		phb			; >
		SEP	#00100000B
		MEM8
		pha			;  >
		lda	#7eh
		bra	Decode_common
;- - - - - - - - - - - - - - - - - - - - - - - - 
Decode_7F_X	php			;>
		phb			; >
		SEP	#00100000B
		MEM8
		pha			;  >
		lda	#7fh
Decode_common	plb			; set read ROM bank
		sty	<read_addr	; set read ROM address
		sta	<write_addr+2	; set RAM bank
		stx	<write_addr+0	; set RAM address
		ldy	#0		; set RAM start offset
		jsr	Main_ispk
		plb			; <
		plp			;<
		rtl
;---------------------------------------------------------------------
;*********************************************************************
;		ISPK MAIN
;*********************************************************************
		mem8
ispk_exit	rts			; data end
;- - - - - - - - - - - - - - - - - - - - 
Main_ispk	ldx	<read_addr	;W
		lda	!0,x
		inx
		bne	$+5
		jsr	over_bank
		sta	<read_data	;B
		cmp	#0ffh		;B
		beq	ispk_exit
;- - - - - - - - - - - - - - - - - - - - 
		and	#11100000b	;B 2byte code ?
		cmp	#11100000b	;B
		bne	code_1byte
;- - - - - - - - - - - - - - - - - - - - 
code_2byte	lda	<read_data	;B
		asl	a		;B
		asl	a		;B
		asl	a		;B
		pha			; ->
		lda	<read_data	;B
		and	#00000011b	;B
		xba			;
		lda	!0,x
		inx
		bne	$+5
		jsr	over_bank
		REP	#00100000B
		MEM16
		inc	a		;W
		sta	<data_count+0	;W
		SEP	#00100000B
		MEM8
		pla
		bra	code_common
;- - - - - - - - - - - - - - - - - - - - 
code_1byte	stz	<data_count+1
		lda	<read_data
		and	#00011111b
		inc	a
		sta	<data_count+0
		lda	<read_data
code_common	asl	a
		bcs	ref_data	; Ԑڃf[^
;- - - - - - - - - - - - - - - - - - - - 
direct_data	asl	a		; ڃf[^
		bcc	skip$
		bmi	c1_same3	; 010 or 011
		bpl	c1_same2
skip$		bmi	c1_same1	; 000 or 001
;--------------------------------------------------------------------
;- - - - - - - - - - - - - - - - - - - - ; code 000
c1_nomal	lda	!0,x
		inx
		bne	$+5
		jsr	over_bank
		sta	[<write_addr],y	; == ISPK ==
		iny
		dec	<data_count+0
		bne	c1_nomal
		dec	<data_count+1	
		bpl	c1_nomal
		stx	<read_addr
		jmp	Main_ispk
;- - - - - - - - - - - - - - - - - - - - ; code 001
c1_same1	lda	!0,x
		inx
		bne	$+5
		jsr	over_bank
		stx	<read_addr
		ldx	<data_count+0
loop$		sta	[<write_addr],y	; == ISPK ==
		iny
		dex
		bne	loop$
		jmp	Main_ispk
;- - - - - - - - - - - - - - - - - - - - ; code 010
c1_same2	lda	!0,x
		inx
		bne	$+5
		jsr	over_bank
		xba
		lda	!0,x
		inx
		bne	$+5
		jsr	over_bank
		xba
		stx	<read_addr
		ldx	<data_count+0
loop$		sta	[<write_addr],y	; == ISPK ==
		iny
		dex
		beq	exit$
		xba
		sta	[<write_addr],y	; == ISPK ==
		xba
		iny
		dex
		bne	loop$
exit$		jmp	Main_ispk
;- - - - - - - - - - - - - - - - - - - - ; code 011
c1_same3	lda	!0,x
		inx
		bne	$+5
		jsr	over_bank
		stx	<read_addr
		ldx	<data_count+0
loop$		sta	[<write_addr],y	; == ISPK ==
		inc	a
		iny
		dex
		bne	loop$
		jmp	Main_ispk
;--------------------------------------------------------------------
ref_data	asl	a
		bcc	skip$
		bpl	ref_nomal_S	; 110
		bmi	ref_flip_S	; 111
skip$		bmi	ref_flip	; 101 or 3001
;
;- - - - - - - - - - - - - - - - - - - - ; code 100
ref_nomal	jsr	ref_load
ref_nomal_entry	phy
		ldy	<ref_addr
		lda	[<write_addr],y	; == ISPK ==
		iny
		sty	<ref_addr
		ply
		sta	[<write_addr],y	; == ISPK ==
		iny
		dex
		bne	ref_nomal_entry
		jmp	Main_ispk
;- - - - - - - - - - - - - - - - - - - - ; code 101
ref_flip	jsr	ref_load
ref_flip_entry	phy
		ldy	<ref_addr
		lda	[<write_addr],y	; == ISPK ==
		iny
		sty	<ref_addr
		ply
		eor	#0ffh
		sta	[<write_addr],y	; == ISPK ==
		iny
		dex
		bne	ref_flip_entry
		jmp	Main_ispk
;- - - - - - - - - - - - - - - - - - - - ; code 110
ref_nomal_S	jsr	ref_load_S
		bra	ref_nomal_entry
;- - - - - - - - - - - - - - - - - - - - ; code 111
ref_flip_S	jsr	ref_load_S
		bra	ref_flip_entry
;- - - - - - - - - - - - - - - - - - - - 






;*********************************************************************
ref_load	lda	!0,x
		inx
		bne	$+5
		jsr	over_bank
		sta	<ref_addr+0
		lda	!0,x
		inx
		bne	$+5
		jsr	over_bank
		sta	<ref_addr+1
		stx	<read_addr
		ldx	<data_count
		rts
;*********************************************************************
ref_load_S	lda	!0,x
		inx
		bne	$+5
		jsr	over_bank
		sta	<ref_addr+0
		stz	<ref_addr+1
		REP	#00100000B
		MEM16
		tya
		sec
		sbc	<ref_addr+0
		sta	<ref_addr+0
		SEP	#00100000B
		MEM8
		stx	<read_addr
		ldx	<data_count
		rts
;*********************************************************************
over_bank	pha		; >
		phb		;  >
		pla		;  <
		inc	a	; +1
		pha		;  >
		plb		;  <
		pla		; <
		rts
;*********************************************************************
