;*********************************************************************
;	mario kart << TIMER/ITEM-WINDOW >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		include ../DEF/Alphabet.def
;----------------------------------------------------------------------
		GLB	Set_ABC,Set_objmeter
		GLB	Init_meter,DMA_meter,DMA_meter_init
		GLB	Set_watch_1p,Set_watch_2p,Set_watch_VS
		GLB	Write_M7screen
		GLB	Player_slot,Set_my_item
		GLB	Random
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		EXT	Clear_RAM
;----------------------------------------------------------------------
		COMN
work		DS	2
addr		DS	2
;----------------------------------------------------------------------
;	ORG	BGwrite_value
;	
;BGwrite_addr	DS	2
;BGwrite_poin	DS	2
;----------------------------------------------------------------------
BGwrite_addr	EQU	BGwrite_value+0
BGwrite_poin	EQU	BGwrite_value+2
;----------------------------------------------------------------------
		EXTEND
objdata	SECT	REL
		mem16
		idx16
;#####################################################################
;		ACeh
;#####################################################################
;-----------------------fedcba9876543210------------------------------
ON_disp		EQU	1000000000000000B
OFF_disp	EQU	ON_disp^0fffh
ON_use		EQU	0100000000000000B
OFF_use		EQU	ON_use^0ffffh
ON_slot		EQU	0010000000000000B
OFF_slot	EQU	ON_slot^0ffffh
ON_yokodori	EQU	0001000000000000B
;----------------------------------------------------------------------
_waku_start	EQU	24H	; meter_screenA+_waku_start
screen_select	DW	meter_screen_A+(_waku_start+2)
		DW	meter_screen_B+(_waku_start+2)
;*********************************************************************
;		hf[^
;*********************************************************************
item_data	DW	034D4H	; 0 (LmRj
		DW	034D8H	; 1 (nl)
		DW	038DCH	; 2 (X^[)
		DW	038E4H	; 3 (oii)
		DW	030E0H	; 4 (J)
		DW	034E0H	; 5 (ԃK)
		DW	034C0H	; 6 (IoP)
		DW	038C4H	; 7 (RCj
		DW	038C8H	; 8 (T_[)
		DW	034B0H	; 9 (͂IoP)
		DW	03CD4H	; A ( 1UP LmR )
;---------------------------------------------------------------------
bit_flag	DW	8000H	; 0 kinoko dash
		DW	4000H	; 1 hane
		DW	2000H	; 2 star
		DW	0800H	; 3 banana
		DW	1000H	; 4 kame
		DW	0400H	; 5 red kame ( missile )
;- - - - - - - - - - - - - - - - - - - - - - - -
		DW	0200H	; 6 obake
		DW	0100H	; 7 coin
		DW	0040H	; 8 sunder ( T_[ j

;*********************************************************************
;		S[Xbg
;*********************************************************************
		glb	Init_goalslot

Init_goalslot	lda	#Last_lucky
		sta	!slot_pointer,x

		lda	<frame_counter
		lsr	a
		lsr	a
		lsr	a
		lda	#0
		adc	#09h			; 9 / A
		sta	!slot_result,x
		lda	#ON_disp+ON_slot
		sta	!slot_flag,x
		lda	#0e1h
		sta	!slot_timer,x
		rtl



;*********************************************************************
;		h̕\
;*********************************************************************




;----------------------------------------------------------------------
;= = = ()= = = = =
;----------------------------------------------------------------------
Obake_slot	lda	!slot_timer,x
		beq	skip$
		dec	a
		sta	!slot_timer,x
		and	#01000B		; _Œ
		beq	exit$
		ldy	#9*2		; O\
		jmp	disp_common
skip$		lda	#0
		sta	!slot_flag,x
exit$		jmp	disp_clear
;--------------------------------------------------------------------
disp_exit2	RTL
;--------------------------------------------------------------------
Player_slot
;- - - - - - - - - - - - - - - - - - - - -
		LDX	<screen_register
		LDA	!slot_flag,X
		BPL	disp_exit2		; no
;- - - - - - - - - - - - - - - - - - - - -
		BIT	#ON_slot		; slot ON ?
		BNE	ENTRY_slot		; yes
		BIT	#ON_use			; use ON ?
		BNE	ENTRY_use		; yes
		BIT	#ON_yokodori
		BNE	Obake_slot
;----------------------------------------------------------------------
;= = = ~̃EGCg= = = =	
;----------------------------------------------------------------------
Stop_slot	TAY
		LDA	!slot_timer,X		; timer = 0 ?
		BEQ	stop_exit		; yes
		DEC	A			; ^C}[
		STA	!slot_timer,X
		AND	#01000B			; _Œ
		BNE	disp_clear
		JMP	disp_item
stop_exit	TYA
		ORA	#ON_use			; use ON set
		STA	!slot_flag,X
		BRA	disp_exit2
;----------------------------------------------------------------------
;= = = = ] = = = = 
;----------------------------------------------------------------------
ENTRY_slot	
		LDA	!slot_timer,X		; ^C}[	
		DEC	A
		STA	!slot_timer,X
		BMI	stop$
		BIT	!button_trigger-1,X	; STOP BUTTON ON ?
		BPL	skip$			; yes
		ORA	#0FFF0H
		STA	!slot_timer,X
;- - - - - - - - - - - - - - - - - - - - - - - - - 
stop$		CMP	#0FFC0H			;G[`FbN
		BCC	stop10$
		SEP	#00100000B
		MEM8
		LDA	!slot_flag,X		;~GH	
		CMP	!slot_result,X
		REP	#00100000B
		MEM16
		BNE	skip$			; no.
stop10$		LDA	!slot_flag,X
		AND	#OFF_slot		; slot exit 
		STA	!slot_flag,X
		LDA	#40H			; stop timer
		STA	!slot_timer,X
		BRA	disp_exit2
;- - - - - - - - - - - - - - - - - - - - - - - - - 
skip$		LDA	!slot_timer,X
		AND	#0011B
		BNE	disp_exit		; ω
		INC	!slot_pointer,X
		BRA	disp_item
;----------------------------------------------------------------------
;= = = = ACegp`FbN = = = =
;----------------------------------------------------------------------
ENTRY_use
;- - - - - - - - - - - - - - - - - - - - - - - - - 
		LDX	<register
		LDY	<screen_register
;- - - - - - - - - - - - - - - - - - - - - - - - - 
		LDA	<_flag,X		; flag ON ?
		AND	#STOP_item+ON_goal
		BNE	disp_exit		
		LDA	<_dmprocess,x
		BNE	disp_exit

		LDA	!button_trigger-1,Y	; push A ?
		BPL	disp_exit
;- - - - - - - - - - - - - - - - - - - - - - - - - 
		LDA	!slot_flag,Y	
		PHA				;>>
		LDA	#0			; flag clear
		STA	!slot_flag,Y
		PLA				;<<
		ASL	A
		AND	#0FFH
		TAY
		LDA	<special_trigger,X
		ORA	!bit_flag,Y
		STA	<special_trigger,X
;----------------------------------------------------------------------
;= = = = ACe\NA= = = = 
disp_clear	LDX	<screen_register
		LDA	!screen_select,X
		TAX
		LDA	#beta_char
		STA	<0,X
		STA	<2H,X
		LDA	#bar_char
		STA	<40H,X
		STA	<42H,X
		BRA	disp_exit
;----------------------------------------------------------------------
;= = = = ACe\Zbg = = = = 
disp_item
;- - - - - - - - - - - - - - - - - - - - - -
		SEP	#00100000B
		MEM8			; ʏ̃[bg\
next$		LDY	!slot_pointer,X
		LDA	!0,Y
		BPL	skip$		; end code ?
		REP	#00100000B
		MEM16
		LDA	!1,Y
		STA	!slot_pointer,X
		SEP	#00100000B
		MEM8
		BRA	next$
skip$		STA	!slot_flag,X
		REP	#00100000B
		MEM16
		ASL	A
		AND	#1FH
		TAY
;- - - - - - - - - - - - - - - - - - - - - -
disp_common	LDX	<screen_register
		LDA	!screen_select,X
		TAX
		LDA	!item_data+0,Y
		STA	<0,X
		INC	A
		STA	<2H,X
		INC	A
		STA	<40H,X
		INC	A
		STA	<42H,X
disp_exit	RTL
;*********************************************************************
;		Xbgݒl̃Zbg
;*********************************************************************
;	settei 1	nomal	table
;	settei 2	1winner	table
;	settei 3	lost	table
;---------------------------------------------------------------------
dash		EQU	0	; dash		̂
jump		EQU	1	; jump		͂
star		EQU	2	; star		X^[
bana		EQU	3	; banana	oii
kame		EQU	4	; kame		K
miss		EQU	5	; missile	ԃK
obak		EQU	6	; 		悱ǂIoP
coin		EQU	7	; coin		RC
spec		EQU	8	; 		T_[
over		EQU	9	;		͂ꂨ΂
up1p		EQU	0AH	;		1 up 
;----------------------------------------------------------------------
slotdata_select	
		dw	drum_obake	;00 
		dw	drum_circuit	;02
		dw	drum_grass	;04
		dw	drum_dart	;06
		dw	drum_ice	;08
		dw	drum_sand	;0a
		dw	drum_castle	;0c
		dw	drum_battle	;0e
;- - - - - - - - - - - - - - - - - - - - - - - -
slotVS_select	dw	drum_obake2	;00 
		dw	drum_circuit2	;02
 		dw	drum_grass2	;04
		dw	drum_dart2	;06
		dw	drum_ice2	;08
		dw	drum_sand2	;0a
		dw	drum_castle2	;0c
		dw	drum_battle	;0e
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -- - - -
;ԍŌ̃f[^̉ʂSrbg( drum_0 -  drum_1 )
;					|
;drum_circuit				|
;		db	08,00,00,18,26,80h	;ʏ
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -- - - -
drum_select	dw	VS_all		; 0 ׂĂI
		dw	VS_circuit	; 1 nlȂ
		dw	BT_drum		; 2 T_[,RCȂI
		dw	GP_all		; 3 IoPȂ
		dw	GP_circuit	; 4 nl,IoPȂI
		dw	GP_obake	; 5 ΂J
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
all_drum
VS_all		db	dash,jump,star,bana,kame,miss,obak,coin,spec,80h
		dw	VS_all
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
VS_circuit	db	dash,star,bana,kame,miss,obak,coin,spec,80h
		dw	VS_circuit
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
BT_drum		db	dash,jump,star,bana,kame,miss,obak,80h
		dw	BT_drum
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
GP_all		db	dash,jump,star,bana,kame,miss,coin,spec,80h
		dw	GP_all
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
GP_circuit	db	dash,star,bana,kame,miss,coin,spec,80h
		dw	GP_circuit
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
GP_obake	db	dash,jump,star,coin,spec,80h
		dw	GP_obake
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Last_lucky	db	up1p,star,miss,spec,over,80h
		dw	Last_lucky
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;f[^e[u
		include	slot.src

		;--------1,-2,-3,-4,-5,-6,-7,-8----
GP_table	db	09,09,09,09,09,09,09,09	; 1 lap
		db	09,00,00,00,18,18,18,18 ; 2 lap
		db	09,00,00,00,18,18,18,18	; 3 lap
		db	09,00,00,00,18,18,18,18	; 4 lap
		db	09,00,00,00,18,18,18,18 ; 5 lap
		;--------1,-2
VS_table	db	00,00	; 1 lap
		db	09,18	; 2 lap
		db	09,18	; 3 lap
		db	09,18	; 4 lap
		db	09,18	; 5 lap
;---------------------------------------------------------------------
;
;	X = slot index 0,2
;	Y = 
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Set_settei
					;vC[h`FbN
		txa
		ldx	<game_status
		jmp	(!slot_mode,x)
slot_mode	dw	slot_GP
		dw	slot_VS
		dw	slot_TM
		dw	slot_BT
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
slot_BT		
		ldy	#0eh		; battle slot
		lda	#0
		clc
		bra	settei_10
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
slot_VS		TAX
					;`FbN
		lda	#0		; ʃNA
		SEP	#00100001B
		MEM8
		lda	<_lap+1,x
		sbc	#80h
		bpl	skip$
		lda	#0
skip$		asl	a
		asl	a
		ora	rank_number,x
		lsr	a
		tay
		lda	!VS_table,y
		REP	#00100001B
		MEM16
		ldy	!course_type
		adc	!slotVS_select,y
		bra	settei_1000
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
slot_TM
slot_GP
		TAX			; `FbN

		lda	#0		; ʃNA
		SEP	#00100001B
		MEM8
		lda	<_lap+1,x
		sbc	#80h
		bpl	skip$
		lda	#0
skip$		asl	a
		asl	a
		asl	a
		asl	a
		ora	<rank_number,x
		lsr	a
		tay	
		lda	!GP_table,y
		REP	#00100001B
		MEM16
		ldy	!course_type
settei_10	adc	!slotdata_select,Y
settei_1000	sta	<work		; f[^̌
;- - - - - - - - - - - - - - - - - - - - - - - 
		TAY
		LDA	!8,Y		; <- \he[u胊[h
		AND	#0FH
		ASL	A
		TAY
		LDA	!drum_select,Y	; \ȟ
		LDX	!frame_part
		STA	!slot_pointer,X
		STA	<addr
;- - - - - - - - - - - - - - - - - - - - - - - 
		SEP	#00100000B
		MEM8
		LDA	!random		; 
		AND	#1FH		;B
		STA	!random_number
		LDY	#-1
loop$		INY
		CMP	(<work),Y	;B
		BCS	loop$
		LDA	!all_drum,Y
		STA	!slot_result,X	; ACe
		REP	#00100000B
		MEM16
;- - - - - - - - - - - - - - - - - - - - - - - 
		RTS
;*********************************************************************
;		af̏iobt@Zbgj
;*********************************************************************
write_data	DW	0,-1,-80H,-81H	
write_char	DB	0D0H,0D1H,0D2H,0D3H
		DB	0D4H,0D5H,0D6H,0D7H
		DB	0D8H,0D9H,0DAH,0DBH
		DB	0DCH,0DDH,0DEH,0DFH
;----------------------------------------------------------------------
write_exit2	plb
		rtl

Set_my_item	PHB
		PHK
		PLB
;- - - - - - - - - - - - - - - - - - - - - - -  ; check index set - - - 
;
		JSL	>Random			; ̈ڍs
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		ldy	!frame_part		; 0 or 2
		ldx	<player_index,y
		bmi	write_exit2
		lda	<_flag,x		;S[CH
		and	#ON_goal
		bne	write_exit2
		lda	<_situationZL+1,x
		bne	write_exit2
;- - - - - - - - - - - - - - - - - - - - - - -  ; block check - - - - -

		LDA	<_BGcheck_status,X
		CMP	#14H			; ? block
		BNE	write_skip
;- - - - - - - - - - - - - - - - - - - - - - - 
		LDA	!slot_flag,Y		; now not use ?
		BMI	write_exit
;- - - - - - - - - - - - - - - - - - - - - - - 
;
		inc	!question_flag		;P񓥂񂾂Pinc
;
;----------------------------------------------------------------------
		LDA	#ON_disp+ON_slot
		STA	!slot_flag,Y		; set flag
		LDA	#0C1H
		STA	!slot_timer,Y		; set timer
		PHX				;>>
		JSR	Set_settei
		PLY				;<<
;- - - - - - - - - - - - - - - - - - - - - - - -
		LDX	<_BGcheck_back,Y	; READ BG character
		LDA	>BGcheck_buffer,X	; READ BG character
		PHA				;>>
		AND	#00011B
		ASL	A		
		TAX
		LDA	!write_data,X
		ADC	!_BGcheck_back,Y	;clc
		STA	!BGwrite_addr
		TAX
		PLA				;<<
		AND	#01100B
		TAY
		STA	!BGwrite_poin
		LDA	!write_char+0,Y		; Set buffer
		STA	>BGcheck_buffer+00H,X
		LDA	!write_char+2,Y
		STA	>BGcheck_buffer+80H,X
		PLB
		RTL
;----------------------------------------------------------------------
write_skip	CMP	#1AH
		BNE	write_exit

		LDA	<_BGcheck_back,X
		TAX
		ORA	#8000H
		STA	!BGwrite_addr
		STZ	!BGwrite_poin
		SEP	#00100000B
		MEM8
		LDA	!coin_erase_char	; set character number
		STA	>BGcheck_buffer+00H,X
;- - - - 
		REP	#00100001B
		MEM16
		tyx
		lda	#1
		sta	!coin_flag,x		;RC\naigK
		adc	!player_coin,x
		cmp	#100
		bcc	skip$
		lda	#0
skip$		sta	!player_coin,x		; 100 RC
;- - - - 
;;
write_exit	PLB
		RTL
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;*********************************************************************
;		af̏(uq`lZbgj
;*********************************************************************
Write_M7screen	PHB
		PHK
		PLB
		SEP	#00010001B
		IDX8
		STZ	!Screen_step		
		LDA	!BGwrite_addr		;݃AhX
		BEQ	M7write_exit		;	`FbN
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		STZ	!BGwrite_addr		; clear
		BMI	coin_write
		LDX	!BGwrite_poin
		STA	!Screen_address+0
		LDY	!write_char+0,X		;
		STY	!Screen_write+0
		LDY	!write_char+1,X		;
		STY	!Screen_write+0
		ADC	#0080H-1		; SEC
		STA	!Screen_address+0
		LDY	!write_char+2,X		;
		STY	!Screen_write+0
		LDY	!write_char+3,X		;
		STY	!Screen_write+0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
M7write_exit	REP	#00010000B
		IDX16
		PLB
		RTL
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		idx8
coin_write	AND	#7FFFH
		STA	!Screen_address+0
		LDX	!BGwrite_poin
		LDY	!coin_erase_char
		STY	!Screen_write+0
		BRA	M7write_exit
		idx16
;----------------------------------------------------------------------
;
;
;
;
;
;
;
;
;*********************************************************************
;		afACȅZbg
;*********************************************************************
beta_char	EQU	03CE9H
bar_char	EQU	03CE8H
same_code	EQU	1
diff_code	EQU	0
;---------------------------------------------- ; VRAM data ----------
vram_black	DB	20H*2+same_code
		DW	3CCFH
		DB	0
vram_waku	DB	12H*2+same_code
		DW	3CCFH
		DB	04H*2+diff_code
		DW	3CD0H,3CD1H,3CD1H,7CD0H
		DB	0AH*2+same_code
		DW	3CCFH
		DB	0			; end code
;---------------------------------------------- ; BUFFER data --------
waku_1p		DW	3CD2H,3CCCH,3CCDH,7CD2H
		DW	8000H+38H		; next code
		DW	3CD3H,3CEAH,3CEBH,7CD3H
		DW	8000H			; end code
waku_2p		DW	3CD2H,3CECH,3CEDH,7CD2H
		DW	8000H+38H		; next code
		DW	3CD3H,3CEEH,3CEFH,7CD3H
		DW	8000H			; end code
;----------------------------------------------------------------------
item_init_sel	DW	_VS,_1p,_2p	; GP
		DW	_VS		; VS
		DW	_1p,_2p		; TM
		DW	_VS		; BT
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_VS		DW	item_meter_A,item_meter_B,init_ret
_1p		DW	item_meter_A,clear_meter_B,init_ret
_2p		DW	clear_meter_A,item_meter_B,init_ret
;======================================================================
Init_my_item	LDA	<SEQ_register
		LDX	#item_init_sel
		JMP	init_select
;----------------------------------------------------------------------
clear_meter_A	LDY	#meter_vram+00H
		BRA	common_clear
clear_meter_B	LDY	#meter_vram+80H
common_clear	LDX	#vram_black
		JMP	set_black
;- - - - - - - - - - - - - - - - - - - - - - - -
item_meter_A	LDX	#meter_screen_A
		LDY	#waku_1p
		JSR	set_waku
		LDY	#meter_vram
		LDX	#vram_waku
		JMP	set_black
;- - - - - - - - - - - - - - - - - - - - - - - -
item_meter_B	LDX	#meter_screen_B
		LDY	#waku_2p
		JSR	set_waku
		LDY	#meter_vram+80H
		LDX	#vram_waku
		JMP	set_black
;-----------------------------------------------------
; Y = data pointer
; X = write buffer pointer
; data = 8000H = special code
;	00H = exit
;	**H = X add **H
;-----------------------------------------------------
set_waku
waku_init_loop	LDA	!0,Y
		BMI	waku_exit
		STA	<_waku_start,X
		INX
		INX
		INY
		INY
		BRA	waku_init_loop
waku_exit	AND	#0FFH
		BEQ	next_init
		STA	<work
		TXA
		CLC
		ADC	<work
		TAX
		INY
		INY
		BRA	waku_init_loop
next_init	RTS
;-----------------------------------------------------
; Y = vram address
; X = data pointer
;-----------------------------------------------------
set_black	LDA	#80H
		STA	!Screen_step
		STY	!Screen_address
data_next	LDA	!0,X
		INX
		AND	#00FFH
		BEQ	waku_end
		LSR	A			; carry 1 = same data
		TAY
		BCS	same_entry
diff_loop	LDA	!0,X
		INX
		INX
		STA	!Screen_write
		DEY
		BNE	diff_loop		
		BEQ	data_next
same_entry	LDA	!0,X
		INX
		INX
same_loop	STA	!Screen_write
		DEY
		BNE	same_loop
		BEQ	data_next
waku_end	RTS
;--------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;######################################################################
;######		C^C}
;######################################################################
;**********************************************************************
;		C^C}̏ݒ
;**********************************************************************
watch		EQU	16H*2		; char+attr
watch_number	EQU	080H		; number character 80H=0
watch_clear	EQU	7*400H+1*2000H+08FH
watch_point1	EQU	08AH
watch_point2	EQU	08BH
;--------------------------------------------------------------------
watch_init_sel	DW	VS_watch,p1_watch,p2_watch
		DW	VS_watch
		DW	p1_watch,p2_watch
		DW	BT_watch
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - -
VS_watch	DW	p1_init,p2_init,init_ret
p1_watch	DW	p1_init,init_ret
p2_watch	DW	p2_init
BT_watch	DW	init_ret
;--------------------------------------------------------------------
disp_select	DW	meter_screen_A,meter_screen_B
;--------------------------------------------------------------------
Init_watch
		lda	#101h+3		
		sta	!time_index
		LDA	<SEQ_register
		LDX	#watch_init_sel
		JMP	init_select
;--------------------------------------------------------------------
p1_init		LDY	#0
		BRA	init_watch
p2_init		LDY	#2
;--------------------------------------------------------------------
init_watch	SEP	#00100000B
		MEM8
		LDX	!disp_select,Y
		LDA	#watch_point1
		STA	<watch+02H*2,X		; char + attr
		LDA	#watch_point2
		STA	<watch+05H*2,X
		REP	#00100000B
		MEM16
		RTS  
;--------------------------------------------------------------------
Set_ABC		RTL
;**********************************************************************
;		C^C}̕\
;**********************************************************************
laptime_offset	dw	1ch,3ah
;- - - - - - - - - - - - - - - - - - - - - - - - - -
Set_watch_VS	
		lda	!goal_flag		; Q[H
		bne	exit$			; 
		ldy	#0  
		jsr	watch_entry
		ldy	#2
		jsr	watch_entry
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - -
Set_watch_1p	
		ldy	#0
		jmp	set_watch
;- - - - - - - - - - - - - - - - - - - - - - - - - -
Set_watch_2p	ldy	#2
;- - - - - - - - - - - - - - - - - - - - - - - - - -
set_watch	ldx	<player_index,y
		lda	<_flag,X
		and	#ON_goal
		beq	watch_entry
		lda	!goal_wait,y		;S[Ă
		beq	goal$			;Pt[҂I
;- - - - - - - - - - - - - - - - - - - - - - - -
	;;	txa
	;;	clc
		adc	#driver_time+4
;- - - - - - - - - - - - - - - - - - - - - - - -
		lda	!laptime_offset,y
		clc
		adc	#laptime_buffer
		ldx	!disp_select,y		; ǂ̃XN[
		tay
		bra	watch_goal		
;- - - - - - - - - - - - - - - - - - - - - - - -

goal$		ora	#8000h
		sta	!goal_wait,y
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
watch_entry
		LDX	!disp_select,Y		; ǂ̃XN[
						;  ɏނ ?
		LDY	!time_index		;  index
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
watch_goal
skip_1$		SEP	#00100000B
		MEM8
		JSR	disp_watch
		DEY
		DEY
		JSR	disp_watch
		DEY
		JSR	disp_watch
		REP	#00100000B
		MEM16
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		mem8
disp_watch	LDA	!0,Y			; ̈
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#watch_number
		STA	<watch+00H,X
		ORA	#010H
		STA	<watch+40H,X
		INX
		INX
		LDA	!0,Y			; ̈
		AND	#00FH
		ORA	#watch_number
		STA	<watch+00H,X
		ORA	#010H
		STA	<watch+40H,X
		INX
		INX
		INX
		INX
		RTS
		mem16
;--------------------------------------------------------------------
;			--- b ----  ---
;
limit_time	db	99h,59h,00h,09h,00h
;
;**********************************************************************
;		^C~bg̕\
;**********************************************************************
		GLB	Limit_time
;- - - - - - - - - - - - - - - - - - - - - 
Limit_time	
	;;	lda	!104h
	;;	cmp	#10
	;;	bcc	exit$
	;;	ldx	#limit_time+3
	;;	stx	!time_index
;- - - 
	;;	lda	#9		; ^C~bg
	;;	sta	!104h
	;;	lda	#59h
	;;	sta	!102h
	;;	lda	#9999h
	;;	sta	!100h
;- - - 
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - 
;
;
;
;
;
;
;
;
;
;#####################################################################
;######		af[^[					######
;#####################################################################
;*********************************************************************
;		af[^[̏ݒ	
;*********************************************************************
meter		DW	watch_clear		; clear data
		DL	meter_screen_A		; buffer adderss
		DW	100H			; byte count
meter_clear	DW	watch_clear
		DL	clear_screen_A
		DW	100H
;--------------------------------------------------------------------
Init_meter	LDX	#meter
		JSL	>Clear_RAM		; BUFFER CLEAR
		LDX	#meter_clear
		JSL	>Clear_RAM
;- - - - - - - - - - - - - - - - - - - - - - - 
entry$		LDA	#80H
		STA	!Screen_step
		LDA	#meter_vram
		STA	!Screen_address
		LDX	#100H
		LDA	#watch_clear 
init_meter_loop	STA	!Screen_write+0		; VRAM CLEAR
		DEX
		BNE	init_meter_loop
;- - - - -
		LDA	#meter_screen_A
		STA	!meter_address+0
		LDA	#meter_screen_B
		STA	!meter_address+2
		STZ	!meter_bank+0
		STZ	!meter_bank+2

		lda	!ending_flag
		bpl	exit$
;- - - - - 
		lda	#clear_screen_A		; BG 3  NA
		sta	!meter_address+0
		lda	#clear_screen_B
		sta	!meter_address+2
		lda	#07fh
		sta	!meter_bank+0
		sta	!meter_bank+2
		rts
;- - - - - 
exit$
		JSR	Init_watch
		JSR	Init_my_item
		JMP	Init_objmeter		
;*********************************************************************
;		af[^[̃XN[]
;*********************************************************************
meter_char	EQU	7400H
meter_vram	EQU	7B00H
vram_waku_A	EQU	meter_vram+12H
vram_screen_A	EQU	meter_vram+20H
vram_waku_B	EQU	meter_vram+12H+80H
vram_screen_B	EQU	meter_vram+20H+80H
trans_byte	EQU	080H
;----------------------------------------------------------------------
DMA_meter_init	SEP	#00100000B
		MEM8			
		LDA	#80H			;B
		STA	!Screen_step		;B hi inc
		LDX	#1801H			;W low,high 2byte
		STX	!DMA_0+0		;W
		BRA	call_meter

DMA_meter	SEP	#00100000B
		MEM8			
		LDA	#80H			;B
		STA	!Screen_step		;B hi inc
		LDX	#1801H			;W low,high 2byte
		STX	!DMA_0+0		;W

		LDA	<nmi_counter
		LSR	a
		BCC	skip_meter
;
call_meter	LDY	!meter_address+0	:W << A screen >>
		STY	!DMA_0+2		;W
		LDA	!meter_bank+0		;B
		BEQ	skip_1$
		LDY	#vram_waku_A
		JSR	clear_waku
skip_1$		STA	!DMA_0+4		;B
;
		LDX	#trans_byte		;W data byte count
		STX	!DMA_0+5		;W
		LDY	#vram_screen_A		;W
		STY	!Screen_address		;W
		LDA	#00000001B		;B
		STA	!DMA_burst		;B
		REP	#00100000B
		MEM16
		RTL
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


		mem8
skip_meter
		LDY	!meter_address+2	:W
		STY	!DMA_0+2		;W
		LDA	!meter_bank+2		;B
		BEQ	skip_2$
		LDY	#vram_waku_B
		JSR	clear_waku
skip_2$		STA	!DMA_0+4		;B
		LDX	#trans_byte		;W data byte count
		STX	!DMA_0+5		;W
		LDY	#vram_screen_B		;W << B screen >>
		STY	!Screen_address		;W
		LDA	#00000001B		;B
		STA	!DMA_burst		;B
		REP	#00100000B
		MEM16
		RTL
;----------------------------------------------------------------------
clear_waku	STY	!Screen_address
		LDY	#3ccfH
		STY	!Screen_write
		STY	!Screen_write
		STY	!Screen_write
		STY	!Screen_write
		RTS
;----------------------------------------------------------------------
;
;
;
;
;
;
;
;
;######################################################################
;######		OBJ [^[					#######
;######################################################################
;[^pLio[
number_data	db	0a7h,0a8h,0a9h,0aah,0abh
		db	0b7h,0b8h,0b9h,0bah,0bbh
;- - - - - - - - - - - - - - - - - - - - - - - - -



;- - - - - - - - - - - - - - - - - - - - - - - - -
Set_objmeter	ldy	<screen_register
;- - - - - - - - - - - - - - - - - - - - - - - - -
		SEP	#00100000B
		MEM8
;- - - - - - - - - - - - - - - - - - - - - - - - -
;	display player count	vC[JE^[
		ldx	!player_count,y
		beq	skip$
		dex
skip$		lda	!number_data,x
		ldx	<screen_oam
		sta	!player_oam,x
;- - - - - - - - - - - - - - - - - - - - - - - - -
;	display coin count	RCJE^[
		lda	!player_coin,y
		sta	!Dividend+0
		stz	!Dividend+1
		lda	#10
		sta	!Divisor
;- - - - - - - - - - - - - - - - - - - - - - - - -
		lda	!player_coin,y
		bne	skip_1$
		lda	<frame_counter
		and	#01000b
		beq	skip_1$
		lda	#2ah
		bra	skip_2$
skip_1$		lda	#28h		
skip_2$		ldy	<screen_oam
		sta	!coin_oam+1,y
		sta	!coin_oam+5,y
;- - - - - - - - - - - - - - - - - - - - - - - - -
		ldx	!Quotient
		lda	!number_data,x		; '10' ̈
		sta	!coin_oam+0,y
		ldx	!Residue
		lda	!number_data,x		; '1'  ̈
		sta	!coin_oam+4,y
		REP	#00100000B
		MEM16
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - -


;
;
;
;
;********************************************************************
;		OBJ [^[̏ݒ	
;********************************************************************
		EXT	Sprite_set
		EXT	param_screenA,param_screenB
		GLB	Erase_objmeter,Set_objmask,Clear_objmeter
;- - - - - - - - - - - - - - - - - - - - - - - - 
player_oam	EQU	40H+3*4+2
coin_oam	EQU	40H+6*4+2
mask_oam	EQU	40H
;- - - - - - - - - - - - - - - - - - - - - - - - -
Init_objmeter	JSR	param_screenA		; Ascreen sprite
		JSR	mount_objmeter
		JSR	param_screenB		; Bscreen sprite
		JMP	mount_objmeter
;- - - - - - - - - - - - - - - - - - - - - - - - -
mount_objmeter
		ldx	<screen_register
		lda	<player_index,x
		bmi	map$
		ldx	<game_status
		ldy	!data_objmeter,x
		beq	clear$
		lda	!objmeter_oam,x
		clc
		adc	<screen_oam
		sta	<sprite_count
		lda	#54b6h
		jsr	Sprite_set
		ldx	<screen_oam
		stz	!sprite_E+(mask_oam/16),x
clear$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
map$		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_objmask	LDA	#0AAAAH
		BRA	skip100
Erase_objmeter	LDY	<screen_oam
Clear_objmeter	LDA	#05555H
skip100		STA	!sprite_E+(mask_oam/16),Y
		RTL
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
objmeter_oam	dw	40h,50h				; OAM gpAhX
data_objmeter	dw	race_objmeter,VS_objmeter,0,0	;

race_objmeter	db	4,28h
		dw	0000h
		db	05eh,05fh,04eh,0aah
VS_objmeter	db	4,28h
		dw	0808h
		db	04fh,04eh,0a7h,0a7h
		db	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
;######################################################################
;######		UTILITY						#######
;######################################################################
;**********************************************************************
;		ln ^
;**********************************************************************
		GLB	Random
;- - - - - - - - - - - - - - - - - - - - - 
		mem16
Random		LDA	!random			;W
		AND	#0000000011111111B	;W
		XBA
		EOR	!random			;W
		XBA
		STA	!random		;W
		XBA
		AND	#0000000011111111B	;W
		ASL	A			;W
		EOR	!random		
		LSR	A			;W
		EOR	#1111111110000000B	;W
		BCC	random_skip
		EOR	#1000000110000000B	;W
random_store	STA	!random			
		RTL
random_skip	CMP	#1010101001010101B	;W
		BNE	random_store
		STZ	!random			;W
		RTL
;-----------------------------------------------------------------------
;*********************************************************************
;		Zbg
;*********************************************************************
;		X <- select address
;		A <- select no		
;		in 16/out 16
;----------------------------------------------------------------------
		glb	init_select,init_ret
;----------------------------------------------------------------------
init_select	TAY
		STX	<addr
		LDA	(<addr),Y
		TAX
initial_loop	PHX			;>>
		JSR	(!0,X)
		PLX			;<<
		INX
		INX
		BRA	initial_loop
init_ret	PLA			;<< del 'PHX'
		PLA			;<< del 'RTS'
		RTS
;----------------------------------------------------------------------
		END		
