;*********************************************************************
;	mario kart << WAKIDASI SET >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
;----------------------------------------------------------------------
	GLB	Init_net,Main_net
;----------------------------------------------------------------------
		COMN
work		ds	2
pointer		ds	2
netdata_addr	ds	4
position_addr	ds	4
index_offset	ds	2
map_selecter	ds	2
;- - - - - - - - - - - -  - - -
x_netcenter	ds	2
y_netcenter	ds	2
check_root	ds	2
area_check	ds	2
;####################################################################
;		lbg[N RAM
;####################################################################
;		org	network_value
;;- - - - - - - - - - - - - - - - - - - - - - 
;net_root	ds	2
;net_distance	ds	2
;net_before	ds	4
;- - - - - - - - - - - - - - - - - - - - - - 
net_root	equ	network_value+0
net_distance	equ	network_value+2
net_before	equ	network_value+4
;- - - - - - - - - - - - - - - - - - - - - - 
		EXTEND
bank84		SECT	REL
		mem16
		idx16
;####################################################################
;		lbg[N CjV
;####################################################################
Init_net	lda	#0ffffh
		sta	!net_distance+6
		sta	!net_distance+4
		sta	!net_distance+2
		stz	!net_distance+0
		lda	#0ffh
		sta	!net_before+0
		sta	!net_before+2
		rtl
;####################################################################
;		lbg[N C
;####################################################################
course_index	dw	net_obake	; 00 ΂ type
		dw	net_nomal	; 02 T[Lbg type
		dw	net_nomal	; 04  type
		dw	net_nomal	; 06 _[g type
		dw	net_nomal	; 08 X type
		dw	net_fish	; 0a C type
		dw	net_nomal	; 0c Nbp type
		dw	no_net		; 0e og type
;----------------------------------------------------------------------
Main_net	PHB
		PHK
		PLB
		ldx	!course_type
		jsr	(!course_index,x)
		plb
		rtl
;----------------------------------------------------------------------


;***********************************************************************
;	lbg[NȂ
;***********************************************************************
no_net		rts

;***********************************************************************
;		킫hbX
;		킫pbNt[
;		킫ubNy
;		킫vNvN
;***********************************************************************
pointer_data	dw	00,08h,10h,18h,00h
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;ǂiT[Lbgj
c1_net		db	0ch,17h,0ffh,0,0
		db	0fh,0ffh,0ffh,0,0

c2_net		db	08h,14h,1ch,21h,0ffh
		db	0bh,15h,1eh,0ffh,0ffh	

c3_net		db	0ch,11h,1ah,24h,0ffh
		db	0eh,14h,1ch,0ffh,0ffh

c4_net		db	0ch,11h,1dh,2ch,0ffh
		db	0eh,14h,21h,0ffh,0ffh	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;pbNt[
f1_net		db	0ch,14h,0ffh,0,0
		db	0fh,0ffh,0ffh,0,0

f2_net		db	08h,0dh,13h,1ch,0ffh
		db	09h,11h,15h,0ffh,0ffh

f3_net		db	0eh,17h,1ch,26h,0ffh
		db	0eh,17h,1ch,26h,0ffh

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;hbX
d1_net		db	09h,10h,17h,20h,0ffh
		db	0ch,13h,22h,0ffh,0ffh

d2_net		db	0eh,20h,32h,3fh,0ffh
		db	0eh,28h,35h,0ffh,0ffh

d3_net		db	08h,16h,1dh,38h,0ffh
		db	08h,16h,1dh,0ffh,0ffh

d4_net		db	09h,01ah,27h,02ch,0ffh
		db	0ah,01ch,2ah,0ffh,0ffh
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;`v[
p1_net		db	09h,0fh,1eh,24h,0ffh
		db	0bh,12h,20h,0ffh,0ffh
  
p2_net		db	0eh,15h,1dh,24h,0ffh
		db	11h,18h,20h,0ffh,0ffh

p3_net		db	08h,12h,19h,22h,0ffh
		db	0ah,16h,1eh,0ffh,0ffh
		
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;ǂiACXj
i1_net		db	00ch,01fh,0ffh,0,0
		db	010h,0ffh,0ffh,0,0
i2_net		db      010h,01fh,0ffh,0,0
		db      010h,0ffh,0ffh,0,0

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;
fish1_net	db	044h,0ffh,0ffh,0,0
		db	044h,0ffh,0ffh,0,0
fish2_net	db	044h,0ffh,0ffh,0,0
		db	044h,0ffh,0ffh,0,0

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
data_type	dw	0
		dw	data_circuit
		dw	data_poo
		dw	data_flower
		dw	data_ice
		dw	data_fish
		dw	data_dossun
		dw	data_circuit
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
data_circuit	dw	c1_net,c2_net,c3_net,c4_net
data_flower	dw	f1_net,f2_net,f3_net
data_dossun	dw	d1_net,d2_net,d3_net,d4_net
data_poo	dw	p1_net,p2_net,p3_net
data_ice	dw	i1_net,i2_net
data_fish	dw	fish1_net,fish2_net
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


;***********************************************************
;	킫 4 SYSTEM 
;***********************************************************
;
;
;- - - - - - - - - - - - - - - - - - - - -
net_fish	jsr	net_nomal
		bcc	exit$
;- - - - - - - - - - - - - - - - - - - - -
		ldy	#network_index
		bra	entry$
loop$		clc
		adc	<index_offset
		tax
		lda	<_situationXH,x
		sta	<_initposX,x		; W̃Zbg
		lda	<_situationYH,x
		sta	<_initposY,x
		iny
		iny
entry$		lda	!0,y
		bne	loop$	
exit$		rts
;- - - - - - - - - - - - - - - - - - - - -
;
;
;***********************************************************
;	킫 4 SYSTEM 
;***********************************************************
net_nomal	lda	!data_type,x
		sta	<work
		ldy	!course_level
		lda	(<work),y
		bne	start$
test$		rts

;***********************************************************
;
;***********************************************************
start$		sta	<area_check
					; <- f[^AhX[h
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		ldy	!frame_part
		ldx	<player_index,y
		bpl	forward_set
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		clc
		adc	#5		;t ̃`FbN
		sta	<area_check
		tya
		eor	#2
		tay
		ldx	<player_index,y
		bmi	test$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
forward_set				; ̃`FbN
		ldy	#0
		SEP	#00100000B
		MEM8
		lda	<_lap,x
		cmp	#0ffh
		beq	data_skip$
		dey
data_loop$	iny
		cmp	(<area_check),y	; <- 킫GA`FbN
		bcs	data_loop$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
data_skip$	REP	#00100000B
		MEM16
		tya
		asl	a
		ldy	!frame_part		; t[ !
		cmp	!net_before,y
		beq	exit$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
write$		sta	!net_before,y		; ݂̃|C^I
		tax				; >>
		lda	!screen_offset_data,y	; register 00h/40h
		sta	<index_offset

;- - - - - - - - - - - - - - - - - - - - ;f[^AhX - - - - -
		lda	!map_number
		xba
		lsr	a
		lsr	a			; clc
		adc	#OFFSET	polenet_ROM
		sta	<position_addr+0
		lda	#BANK	polenet_ROM
		sta	<position_addr+2
;- - - - - - - - - - - - - - - - - - - - -
		ldy	!pointer_data,x		; f[^|C^I
		lda	[<position_addr],y
		bne	pointskip$
		ldy	#0
pointskip$	sty	<pointer
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		ldy	#network_index
		bra	entry$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
loop$		clc
		adc	<index_offset
		tax
		phy				;>>
		ldy	<pointer
		lda	[<position_addr],y
skip$		pha
		and	#0007fh
		ASL	A
		ASL	A
		ASL	A
		adc	!netdata_offset		; clc
		sta	<_situationXH,x
		pla
		and	#0ff80h
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		adc	!netdata_offset		; clc
		sta	<_situationYH,x
		lda	#0fe00h
		sta	<_posV_A,x
		sta	<_posV_B,x
		stz	<_pole_status,x		
		iny
		iny
		sty	<pointer
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		ply				;<<
		iny
		iny
entry$		lda	!0,y			; OBJwork  INDEX
		bne	loop$
		sec		; V|WVɈȍ~
		rts

exit$		clc		;
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;
;
;
;
;
;
;
;***********************************************************************
;		lbg[Npf[^
;***********************************************************************
screen_offset_data
		dw	000h,040h
;***********************************************************************
;	΂₵p	킫lbg[N
;***********************************************************************
net_obake	
		ldy	!course_level
		lda	!data_obake,y
		sta	<position_addr
		ldy	!frame_part
		ldx	<player_index,y
		bmi	exit$
		lda	!screen_offset_data,y
		sta	<index_offset
		jsr	Set_net
exit$		rts
;***********************************************************************
;	킫lbg[NZbg[`
;***********************************************************************
;	x = player index
;- - - - - - - - - - - - - - - - - - - - 
Set_net		
;- - - - - - - - - - - - - - - - - - - - 
		ldy	<position_addr
		lda	!0,y
		sta	<netdata_addr
		iny
		iny
		sty	<position_addr				
;- - - - - - - - - - - - - - - - - - - - 
		lda	<_lap,x
		and	#0ffh
		tay
		lda	(<netdata_addr),y
		and	#0ffh
		asl	a
		sta	<pointer
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		ldy	#network_index
		bra	entry$
loop$		clc
		adc	<index_offset
		tax
		phy
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		ldy	<pointer
		lda	(<position_addr),y
		bne	skip$
		tay
		lda	(<position_addr),y		
skip$		pha
		and	#000ffh
		ASL	A
		ASL	A
		ASL	A
		adc	#4
		sta	<_situationXH,x
		pla
		and	#0ff00h
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		adc	#4
		sta	<_situationYH,x
		iny
		iny
		sty	<pointer
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		ply
		iny
		iny
entry$		lda	!0,y
		bne	loop$		
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		rts
;####################################################################
;		ėp[`
;####################################################################
;***********************************************************************
;		̌vZ
;***********************************************************************
;
;	input	ix....{ƂȂindex
;		iy....ڕWƂȂ y W@
;		a.....ڕWƂȂ x W
;
;	output	a.....f[^
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Calc_distance	pha
		SEP	#00100001B
		MEM8
		lda	#dsp_distance
		sta	!DSP_data	
		REP	#00100000B
		MEM16
		pla
		sbc	<_situationXH,x
		sta	!DSP_data
		tya	
		sec
		sbc	<_situationYH,x
		sta	!DSP_data
		lda	#0
		lda	#0
		sta	!DSP_data
		LDA	>DSP_status
		BPL	$-4
		lda	!DSP_data
		rts

;####################################################################
;	킫lbg[Nf[^
;####################################################################
	if	1
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
data_obake	dw	obake_c0,obake_c1,obake_c2
;--------------------------------------------------------------------
;	΂₵	P
;--------------------------------------------------------------------
obake_c0
	dw	obake_p0
	word	01573H,01270H,0116CH,01168H,01164H,01160H,0115CH,01158H
	word	01353H,01650H,0194DH,00E4AH,00E46H,00E42H,00E3EH,00B39H
	word	00836H,00533H,01130H,0112CH,01128H,01124H,01312H,0160FH
	word	01A0FH,01E0FH,0220FH,0260FH,02A0FH,02E0FH,05510H,05813H
	word	05917H,0591BH,0591FH,05923H,05927H,0592BH,06240H,06543H
	word	06A45H,06E45H,07245H,07053H,07257H,0725BH,0725FH,07263H
	word	07267H,0726BH,07170H,06E73H,06874H,06474H,06074H,05C74H
	word	05874H,0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
obake_p0
	;--------00---01---02---03---04---05---06---07-
	db	000h,000h,000h,000h,001h,003h,008h,00bh	
	;--------08---09---0a---0b---0c---0d---0e---0f-
	db	00bh,00fh,016h,016h,016h,017h,01eh,01eh	
	;--------10---11---12---13---14---15---16---17-
	db	01eh,01fh,020h,026h,026h,027h,02bh,02ch	
	;--------18---19---1a---1b---1c---1d---1e---1f-
	db	02ch,032h,032h,034h,034h,034h,000h,000h,000h
;--------------------------------------------------------------------
;	΂₵	Q
;--------------------------------------------------------------------
obake_c1
	dw	obake_p1
	word	01412H,01216H,0121AH,0121EH,01222H,01426H,01729H,01B29H
	word	01F29H,02535H,02739H,0273DH,02741H,02745H,02749H,02553H
	word	02156H,01D56H,01956H,01556H,02868H,0286CH,0296FH,02D6FH
	word	0316FH,0356FH,0396FH,03D6FH,0416FH,04C6DH,04F69H,04F65H
	word	04F61H,04F5DH,05954H,05C51H,05749H,06050H,06450H,06850H
	word	06D47H,07044H,07240H,0723CH,07434H,07230H,0712CH,06E29H
	word	06B26H,07122H,0711EH,0711AH,07116H,06410H,0600FH,05C0FH
	word	0580FH,0540FH,0500FH,04C0FH,0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
obake_p1
	;--------00---01---02---03---04---05---06---07-
	db	000h,000h,000h,001h,005h,005h,006h,009h
	;--------08---09---0a---0b---0c---0d---0e---0f-
	db	009h,00ah,00ah,00fh,00fh,00fh,010h,014h
	;--------10---11---12---13---14---15---16---17-
	db	014h,016h,01dh,01dh,01dh,01dh,01dh,01eh
	;--------18---19---1a---1b---1c---1d---1e---1f-
	db	022h,022h,023h,025h,028h,028h,02bh,02ch
	;--------20---21---22---23---24---25---26---27-
	db	02ch,031h,031h,031h,035h,035h,036h,036h
	;--------28---29---2a---2b---2c---2d---2e---2f-
	db	000h,000h,000h,000h,000h,000h,000h,000h
;--------------------------------------------------------------------
;	΂₵	R
;--------------------------------------------------------------------
obake_c2
	dw	obake_p2
	word	01212H,01216H,0121AH,0121EH,01222H,01226H,0122AH,0122EH
	word	01232H,01236H,00854H,00859H,0136FH,0176FH,01B6FH,01D6CH
	word	01D68H,01D64H,01D60H,01D5CH,02764H,02B64H,02F64H,0275AH
	word	02756H,02752H,0315AH,0355AH,0395AH,03150H,0314CH,03148H
	word	03144H,03140H,0313CH,03C34H,03F32H,04332H,04634H,04838H
	word	0483CH,04840H,05443H,05746H,05A49H,05D4CH,05250H,05254H
	word	05258H,05B5AH,05B5EH,05F6FH,0636FH,0676FH,06B6FH,06F6FH
	word	0726CH,07268H,07764H,07760H,07952H,07546H,07542H,07237H
	word	06F34H,06C31H,0712CH,07128H,07124H,06621H,0631EH,0601BH
	word	06717H,06713H,0670FH,05A0FH,0560FH,0520FH,04E0FH,04A0FH
	word	0460FH,0420FH,03E0FH,0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
obake_p2
	;--------00---01---02---03---04---05---06---07-
	db	000h,000h,006h,006h,006h,00ah,00ah,00ah
	;--------08---09---0a---0b---0c---0d---0e---0f-
	db	00ch,00ch,00fh,00fh,00fh,014h,014h,01ah
	;--------10---11---12---13---14---15---16---17-
	db	01eh,023h,024h,026h,027h,02ah,02eh,02eh
	;--------18---19---1a---1b---1c---1d---1e---1f-
	db	031h,033h,033h,033h,038h,038h,038h,03ah
	;--------20---21---22---23---24---25---26---27-
	db	03ch,03ch,03dh,03dh,03fh,042h,045h,048h
	;--------28---29---2a---2b---2c---2d---2e---2f-
	db	04bh,04bh,04bh,000h,000h,000h,000h,000h
;--------------------------------------------------------------------
	endif
		END
