	
DEBUG	EQU	0
;*********************************************************************
;	mario kart object initial scene
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		include	../DEF/arch.def
;----------------------------------------------------------------------
	ext	sand_select
;----------------------------------------------------------------------
	GLB	Scene
;;	GLB	Set_BG_item
	GLB	Set_VRAMextra
	GLB	Copy_buffer,CLEAR_RAM,Clear_RAM,Execute_VRAM
	GLB	Clear_VRAM
	GLB	DMA_trans
	GLB	CLEAR_SPRITE,Execute_TRANS
	GLB	Set_DBnumber_B,Buffer_pause
	GLB	Set_debugmap
;----------------------------------------------------------------------
	EXT	SE_trigger_1
	EXT	car_A,car_B,car_Ab,car_Ba
	EXT	enemycar_A,enemycar_B,endcar_A,endcar_B
	EXT	playercar_A,playercar_B
;- - - - - - - - - - - - - - - - - - - - - - - -
	EXT	Mount_object
	EXT	Mount_pipe,Mount_A,Mount_B
	EXT	kart_Z
;----------------------------------------------------------------------
	EXT	pole,poleX
	EXT	arch,archX
	EXT	rogo,rogoX
	EXT	tire,tireX
;	EXT	point,pointX			;(debug)
;	EXT	test_spriteA,test_spriteB	;(target point)
;----------------------------------------------------------------------
	EXT	item0,item0X
	EXT	fire,fireX
;----------------------------------------------------------------------	
	EXT	hammer,hammerX			;(BATTLE HUMMER)
	EXT	option,optionX			;(BATTLE FUSEN)
	EXT	ball,ballX			;(BATTLE FIRE)
	EXT	gate				;(ARCH GATE)
;----------------------------------------------------------------------
	EXT	dokan,dokanX			;(CIRCUIT,SNOW)
	EXT	bubble,bubbleX			;(CASTLE)
	EXT	dossun,dossunX			;
	EXT	wood,woodX			;(WOOD)
	EXT	flower,flowerX			;(FLOWER)
	EXT	poo,pooX			;(GRASS)
	EXT	fish,fishX,move_fish		;(SAND)
;----------------------------------------------------------------------
	EXT	Decode_7F_X,Decode_7E_X
;----------------------------------------------------------------------
		COMN
work		DS	2
addr		DS	4
start_X
work_addr	DS	2
start_XADD
counter		DS	2
start_Y
obj_A		DS	2
start_YADD
obj_B		DS	2
data_pointer	DS	2
data_XADD	DS	2
;----------------------------------------------------------------------
A_flag		EQU	1CH	; = Ascreen sprite set ON/OFF flag
B_flag		EQU	1EH	; = Bscreen sprite set ON/OFF flag
;----------------------------------------------------------------------
		EXTEND
objdata	SECT	REL
		mem16
		idx16
;#####################################################################
;		SPRITE SCENE 
;#####################################################################
;*********************************************************************
;	}bvʃCjVf[^C
;*********************************************************************
scene_select	DW	circuit0	; map 00
		DW	obake0		; map 01
		DW	grass0		; map 02
		DW	castle0		; map 03
		DW	ice0		; map 04
;- - -
		DW	rainbow		; map 05
		DW	sand0		; map 06
		DW	circuit1	; map 07 circuit 1
		DW	obake1		; map 08 obake 1
		DW	castle1		; map 09
;- - - 
		DW	dart1		; map 0A
		DW	grass1		; map 0B
		DW	ice1		; map 0C
		DW	sand1		; map 0D
		DW	circuit2	; map 0E
;- - -
		DW	circuit3	; map 0F
		DW	obake2		; map 10
		DW	castle2		; map 11
		DW	dart2		; map 12
		DW	grass2		; map 13
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		DW	battle0		; map 14
		DW	battle1		; map 15
		DW	battle2		; map 16
		DW	battle3		; map 17
		DW	battle4		; map 18
;---------------------------------------------------------------------
;		;LmRJbv
;---------------------------------------------------------------------
grass2		DW	grid_grass2			; MAP 13
		DW	set_kart,set_dokan,0
;---------------------------------------------------------------------
dart2		DW	grid_dart2			; MAP 12
		DW	set_kart,set_flower,0
;---------------------------------------------------------------------
obake2		DW	grid_obake2			; MAP 10
		DW	set_kart,set_wood,0
;---------------------------------------------------------------------
castle2		DW	grid_castle2			; MAP 11
		DW	set_kart,set_bubble,0
;---------------------------------------------------------------------
circuit1	DW	grid_circuit1			; MAP 7
		DW	set_kart,set_dokan,0
;---------------------------------------------------------------------
;		;t[Jbv
;---------------------------------------------------------------------
sand1		DW	grid_sand1			; MAP D
		DW	set_kart,set_fish,0
;---------------------------------------------------------------------
dart1		DW	grid_dart1			; MAP A
		DW	set_kart,set_flower,0
;---------------------------------------------------------------------
grass0		DW	grid_grass0			; MAP 2	
		DW	set_kart,set_poo,0
;---------------------------------------------------------------------
castle0		DW	grid_castle0			; MAP 3
		DW	set_kart,set_bubble,0
;---------------------------------------------------------------------
circuit3	DW	grid_circuit3			; MAP F
		DW	set_kart,set_dokan,0
;---------------------------------------------------------------------
;		;X^[Jbv
;---------------------------------------------------------------------
obake0		DW	grid_obake0			; MAP 1
		DW	set_kart,set_wood,0
;---------------------------------------------------------------------
ice1		DW	grid_ice1			; MAP C
		DW	set_kart,set_icedokan,0
;---------------------------------------------------------------------
grass1		DW	grid_grass1			; MAP B
		DW	set_kart,set_poo,0
;---------------------------------------------------------------------
castle1		DW	grid_castle1			; MAP 9
		DW	set_kart,set_bubble,0
;---------------------------------------------------------------------
circuit0	DW	grid_circuit0			; MAP 0
		DW	set_kart,set_dokan,0
;---------------------------------------------------------------------
;		XyVJbv
;---------------------------------------------------------------------
ice0		DW	grid_ice0			; MAP 4
		DW	set_kart,set_icedokan,0
;---------------------------------------------------------------------
sand0		DW	grid_sand0			; MAP 6
		DW	set_kart,set_fish,0
;---------------------------------------------------------------------
;dart0		DW	grid_dart0			; MAP 5
;		DW	set_kart,set_flower,0
;---------------------------------------------------------------------
rainbow		DW	grid_rainbow			; MAP 5
		DW	set_kart,set_rdossun,0
;---------------------------------------------------------------------
obake1		DW	grid_obake1			; MAP 8
		DW	set_kart,set_wood,0
;---------------------------------------------------------------------
circuit2	DW	grid_circuit2			; MAP E
		DW	set_kart,set_dokan,0
;---------------------------------------------------------------------




;---------------------------------------------------------------------
;		ogQ[
;---------------------------------------------------------------------
battle0		DW	grid_battle0
		DW	set_kart,set_ball,0
battle1		DW	grid_battle1
		DW	set_kart,set_ball,0
battle2		DW	grid_battle2
		DW	set_kart,set_ball,0
battle3		DW	grid_battle3
		DW	set_kart,set_ball,0
battle4		DW	grid_battle4
		DW	set_kart,set_ball,0
;*********************************************************************
;		R[X^Cvf[^
;*********************************************************************
;	00 ... ΂ type
;	02 ... T[Lbg type
;	04 ...  type
;	06 ... _[g type
;	08 ... X type
;	0A ... C type
;	0C ... Nbp type
;	0E ... og type
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
type_data	db	02h,00h,04h,0ch,08h	
		db	0ch,0ah,02h,00h,0ch
		db	06h,04h,08h,0ah,02h
		db	02h,00h,0ch,06h,04h
		db	0eh,0eh,0eh,0eh,0eh
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;
;	00 ... R[XP
;	02 ... R[XQ 
;	04 ... R[XR
;	06 ... R[XS
;		
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
level_data	db	04h,02h,02h,02h,02h
		db	06h,02h,00h,04h,04h
		db	02h,04h,00h,02h,06h
		db	02h,00h,00h,00h,00h
		db	00h,00h,00h,00h,00h
;*********************************************************************
;	
;*********************************************************************
pole_attr	
		db	00h,00h,00h,06h
		db	00h,00h,00h,00h
		db	00h,06h,00h,00h
		db	00h,00h,00h,00h

		db	00h,06h,00h,04h
		db	00h,00h,00h,00h
		

;*********************************************************************
;		^CvʃRC߂f[^
;*********************************************************************
coin_erase_data	db	05h,01h,01h,10h,08h,17h,04h,09h
block_erase_data
		db	00h,08h,08h,08h,08h,08h,08h,09h
;*********************************************************************
;		^Cv yW `FbNf[^
;*********************************************************************
;					Q
;	data1	000h	data2	400h	Z= 0.00 - 4.00h œ
;	data1	001h	data2	1000h	Z=0 ȊOœ	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

polehit_data1	dw	000h		; ΂
		dw	000h		; T[Lbg ( ǂ )
		dw	001h		; 	( `v[ )
		dw	000h		; _[g ( pbN j
		dw	000h		; X ( ǂ j
		dw	000h		; C ( vNvN )
		dw	000h		; Nbp ( hV )
		dw	000h		; C{[

polehit_data2	dw	100h		; ΂
		dw	100h		; T[Lbg
		dw	1000h		; 
		dw	100h		; _[g
		dw	100h		; X
		dw	1000h		; C
		dw	0400h		; Nbp
		dw	100h		; C{[

;*********************************************************************
;		^CvʃlbgQItZbg position
;*********************************************************************
netdata_data	db	04h,04h,0ah,04h,04h,04h,04h,04h
;*********************************************************************
;		^CvʐFZvOindex
;*********************************************************************
maptype_cgdata	db	00h,00h,00h,00h,02h,04h,00h,00h

;*********************************************************************
;		X^[gObhZbg
;*********************************************************************
;;		DW	*program
;;		DW	pole position X, pole positionY
;;		DW	pole addition X, pole additionY
;--------------------------------------------------------------------
grid_battle4
grid_battle3	
grid_battle2
grid_battle1
		dw	Battle_grid
		dw	0200h,0188h
		dw	0200h,0278h
grid_battle0	
		dw	Battle_grid
		dw	0200h,018Ah
		dw	0200h,0278h
;---------------------------------------------------------------------
;		;LmRJbv
;---------------------------------------------------------------------
grid_grass2	DW	init_grid
		DW	0090H,0224H-8	; map 13
		DW	-020H
grid_dart2	DW	init_grid
		DW	0370H,0244H+8	; map 12
		DW	0020H
grid_obake2	DW	init_grid
		DW	03B8H,0268H-8	; map 10
		DW	0020H
grid_castle2	DW	init_grid
		DW	0390H,02ACH	; map 11
		DW	0020H
grid_circuit1	DW	init_grid
		DW	0398H,024CH	; map 7
		DW	0020H
;---------------------------------------------------------------------
;		;t[Jbv
;---------------------------------------------------------------------
grid_sand1	DW	init_grid
		DW	00B8H,0120H	; map D
		DW	-020H
grid_dart1	DW	init_grid
		DW	006CH,02A4H+8	; map A
		DW	-018H
grid_grass0	DW	init_grid
		DW	0390H,0268H-8	; map 2
		DW	 020H
grid_castle0	DW	init_grid
		DW	0050H,0180H	; map 3
		DW	-020H
grid_circuit3	DW	init_grid
		DW	0388H,01C4H	; map F
		DW	0020H
;---------------------------------------------------------------------
;		;X^[Jbv
;---------------------------------------------------------------------
grid_obake0	DW	init_grid
		DW	0068H,0150H-10h	; map 1
		DW	-020H
grid_ice1	DW	init_grid
		DW	00C0H,0224H+8	; map C
		DW	-020H
grid_grass1	DW	init_grid
		DW	0070H,0240H-10h	; map B
		DW	0028H
grid_castle1	DW	init_grid
		DW	0390H,0150H	; map 9
		DW	0020H
grid_0
grid_circuit0	DW	init_grid
		DW	0060H,01CCH	; map 0
		DW	-020H
;---------------------------------------------------------------------
;		XyVJbv
;---------------------------------------------------------------------
grid_ice0	DW	init_grid
		DW	0368H,021CH-8	; map 4
		DW	0020H
grid_sand0	DW	init_grid
		DW	02B8H,0150H-8	; map 6
		DW	0020H
;grid_dart0	DW	init_grid
;		DW	006CH,0294H+8	; map 5
;		DW	-018H
grid_obake1	DW	init_grid
		DW	0068H,0150H-10h	; map 8
		DW	-020H
grid_circuit2	DW	init_grid
		DW	0398H,024CH	; map E
		DW	0020H


grid_rainbow	DW	init_grid
		DW	004CH,01D0H	; map 5
		DW	-018H
;*********************************************************************
;		}bvʏQZbg
;*********************************************************************
;--------------------------------------------------------------------
;		QȂI
;--------------------------------------------------------------------
XX_XX		dw	mount_entry
		dw	0
;--------------------------------------------------------------------
;		h[icւR[X 
;--------------------------------------------------------------------
set_poo		dw	mount_main
		dw	poo_01		; QZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
poo_01		dw	mount_obake
		db	4,4
		dw	init_poo
		dw	poo,pooX
;--------------------------------------------------------------------
;		`R[ƂR[X
;--------------------------------------------------------------------
set_flower	dw	mount_main
		dw	flower_01	; QZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
flower_01	dw	mount_obake
		db	4,4
		dw	init_dokan
		dw	flower,flowerX
;--------------------------------------------------------------------
;		΂ɃR[X
;--------------------------------------------------------------------
set_wood	dw	mount_main
		dw	wood_01		; QZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
wood_01		dw	mount_obake
		db	4,4
		dw	init_dokan
		dw	wood,woodX
;--------------------------------------------------------------------
;		Nbp傤R[X
;--------------------------------------------------------------------
set_bubble	dw	mount_main
		dw	bubble_01	; QZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
bubble_01	dw	mount_obake
		db	4,4
		dw	init_dokan
		dw	dossun,dossunX
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
set_rdossun	dw	mount_main
		dw	rd_01		; QZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
rd_01		dw	mount_obake
		db	4,4
		dw	init_dokan
		dw	rainbow_dossun,rainbow_dossunX		
		ext	rainbow_dossun,rainbow_dossunX
;--------------------------------------------------------------------
;		ojR[X
;--------------------------------------------------------------------
set_icedokan	dw	mount_main
		dw	icedokan_01	; QZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
icedokan_01	dw	mount_obake
		db	4,4
		dw	init_dokan
		dw	dokan,dokanX	
;--------------------------------------------------------------------
;		mRmRR[X
;--------------------------------------------------------------------
set_fish	dw	mount_main
		dw	fish_01		; QZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
fish_01		dw	mount_obake
		db	4,4
		dw	init_fish
		dw	fish,fishX
;--------------------------------------------------------------------
;		}IT[Lbg
;--------------------------------------------------------------------
set_dokan	dw	mount_main
		dw	dokan_01	; QZbg
;- - - - - - - - - - - - - - - - - - - - - - - -
dokan_01	dw	mount_obake
		db	4,4
		dw	init_dokan
		dw	dokan,dokanX
;--------------------------------------------------------------------
;		ogR[X
;--------------------------------------------------------------------
set_ball	dw	mount_main
		dw	ball_00
		dw	ball_00
		dw	ball_00

ball_00		dw	mount_entry

;- - - - - - - - - - - - - - - - - - - - -
;=== DAgr[g ===
;		0000	
;		0200	F
;		0e00	
;- - - - - - - - - - - - - - - - - - - - -
		dw	clear_ball

		dw	pole_r0		; 1P ̃oAIvV
		dw	0A000h,0
		dw	player_r0,0
		dw	ball,ballX
		dw	pole_r1		; 1P ̃oAIvV
		dw	0A000h,0
		dw	player_r0,05000h
		dw	ball,ballX
		dw	pole_r2		; 1P ̃oAIvV
		dw	0A000h,0
		dw	player_r0,0a000h
		dw	ball,ballX

		dw	pole_r3		; 2P ̃oAIvV
		dw	0A000h,0e00h
		dw	player_r1,0
		dw	ball,ballX
		dw	pole_r4		; 2P ̃oAIvV
		dw	0A000h,0e00h
		dw	player_r1,05000h
		dw	ball,ballX
		dw	pole_r5		; 2P ̃oAIvV
		dw	0A000h,0e00h
		dw	player_r1,0a000h
		dw	ball,ballX

		dw	0
;- - - - - - - - - - - - - - - - - - - - -
clear_ball	tax
						; data set
		lda	!2,y
		sta	<_status,x
		lda	!4,y
		sta	<_attribute,x
		lda	!6,y
		sta	<_option_owner,x
		lda	!8,y
		sta	<_option_Q,x

		tya				; counter inc
		clc
		adc	#8
		tay
		rts
;*********************************************************************
;		kart data
;*********************************************************************
set_kart	DW	mount_kart,SEQ_register
		DW	nomal_kart	;(0)GP
		DW	p1_kart		;(1)GP_1
		DW	p2_kart		;(2)GP_2
		DW	nomal_kart	;(3)VS
		DW	p1_kart		;(4)TM_1
		DW	p2_kart		;(5)TM_2
		DW	nomal_kart	;(6)BT
		DW	ending_kart1	;(7)
		DW	ending_kart2	;(8)
;--------------------------------------------------------------------
p1_kart		DW	playercar_A,car_Ba	; player 1
		DW	enemycar_A,enemycar_B	; player 2 (enemy)
		DW	enemycar_A,enemycar_B	; enemy	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
p2_kart		DW	enemycar_A,enemycar_B	; player 1 (enemy)
		DW	car_Ab,playercar_B	; player 2
		DW	enemycar_A,enemycar_B	; enemy
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
nomal_kart	DW	playercar_A,car_B	; player 1
		DW	car_A,playercar_B	; player 2
		DW	enemycar_A,enemycar_B	; enemy	
;--------------------------------------------------------------------
ending_kart1
ending_kart2
		DW	endcar_A,endcar_B	; enemy	
		DW	endcar_A,endcar_B	; enemy	
		DW	endcar_A,endcar_B	; enemy	
;- - - - - - - - - - - - - - - - - - - - - - - - - - -  - -
;playercar_A	; vC[삷郁CJ[g
;car_Ba		; 	CJ[ǧŒ\
;		;	CJ[ǧvZ\	( }bvp@j
;car_B		;	CJ[ǧvZ\
;enemycar_A	;	GJ[g(vZ\)
;*********************************************************************
;		FLAG DATA
;*********************************************************************
_on	EQU	0FFH
_off	EQU	000H
;----------------------------------------------------------------------
camera_1p	DW	5,1,1,3,3,3,3
camera_2p	DW	6,2,2,4,4,4,4
;----------------------------------------------------------------------
A_flag_data	DB	_on	;(0) VS
		DB	_on	;(1) only 1p
		DB	_on	;(2) only 2p
		DB	_on	;(3) map 1p
		DB	_off	;(4) map 2p
		DB	_on	;(5) nothing_1p	
		DB	_off	;(6) nothing_2p
B_flag_data	DB	_on	;(0) VS
		DB	_on	;(1) only 1p
		DB	_on	;(2) only 2p
		DB	_off	;(3) map 1p
		DB	_on	;(4) map 2p
		DB	_off	;(5) nothing_1p	
		DB	_on	;(6) nothing_2p
;#####################################################################
;*********************************************************************
;		SCENE INITIAL PROGRAM
;*********************************************************************
UPscreen_player	DW	player_r0,player_r0,0C000H
		DW	player_r0,player_r0,player_r0
DWscreen_player	DW	player_r1,0C000H,player_r1
		DW	player_r1,player_r1,player_r1
player_goal	DW	0,1,1,0,0,0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
system_data	dw	0	; GP 
		dw	1	; GP-1P
		dw	2	; GP-2P
		dw	0	; VS
		dw	1	; TM-1P
		dw	2	; TM-2P
		dw	0	; BATTLE
;---------------------------------------------------------------------
Scene	
;<< set system >>
;- - - - - - - - - - - - - - - - - - - - - - - - -
		lda	#sand_select
		sta	!sand_camera
;- - - - - - - - - - - - - - - - - - - - - - - - -
		LDX	<SEQ_register
		LDA	!system_data,X		
		STA	!system_no
;- - - - - - - - - - - - - - - - - - - - - - - - -
		LDX	<game_mode
		LDA	!UPscreen_player,X
		STA	<player_index+0
		LDA	!DWscreen_player,X
		STA	<player_index+2
		LDA	!player_goal,X
		STA	!goal_flag
;- - - - - - - - - - - - - - - - - - - - - - - - -
;<< set flag >>
		STZ	!battle_flag
		SEP	#00100000B
		MEM8
		LDA	!A_flag_data,Y
		STA	<A_flag+1
		LDA	!B_flag_data,Y
		STA	<B_flag+1
;- - - - - - - - - - - - - - - - - - - - - - - - -
;<< TEh̃oNZbg >>
		lda	#BANK	SE_trigger_1
		sta	!screen_sound+2
;- - - - - - - - - - - - - - - - - - - - - - - - -
;<< R[Xx̃Zbg >>
		SEP	#00110000B
		MEM8
		IDX8
		LDY	!map_number
		LDA	!level_data,Y
		STA	!course_level+0
		STZ	!course_level+1
;<< QAgr[g̃Zbg >>
		LDA	!pole_attr,y
		STA	!pole_attribute+1
;<< R[X^CṽZbg >>
		LDA	!type_data,Y
		STA	!course_type+0
		STZ	!course_type+1
;<< _[N}bṽZbg >>
		lda	!map_type
		sta	!dark_map
		lda	!map_number
		cmp	#5			; C{[[hH
		bne	dark_skip$
		stz	!dark_map
dark_skip$
;<< XsAgr[g̃Zbg >>

		lda	!map_type
		LSR	A
		TAY				; Y= course type
		LDA	!map_attr,Y
		STA	!spin_attribute+0

;<< RCNAL̃Zbg >>
		LDA	!coin_erase_data,Y
		STA	!coin_erase_char
		LDA	!block_erase_data,Y
		STA	!block_erase_char
		LDA	!netdata_data,Y
		STA	!netdata_offset+0
		STZ	!netdata_offset+1
;<<}bvɂFZf[^index>>
		LDA	!maptype_cgdata,Y
		STA	!maptype_color+0
		STZ	!maptype_color+1
		REP	#00110000B
		MEM16
		IDX16
;<<Q yW `FbNpobt@ >>
		ldy	#2
		lda	!map_number
		cmp	#13h		; 1-1 ̓hJŃ`FbN
		beq	skip$
		ldy	!course_type
skip$		lda	!polehit_data1,y
		sta	!polehit_1
		lda	!polehit_data2,y
		sta	!polehit_2
;- - - - - - - - - - - - - - - - - - - - - - - - -
;<< n`lf[^̓WJ >>
		ldy	#OFFSET		ROM_oamdata
		lda	#BANK		ROM_oamdata
		ldx	#OFFSET		OAM_databuffer
		jsl	>Decode_7E_X

		lda	#0f000h
		sta	>7e2d73h
		lda	#00000h
		sta	>7e2d96h

		SEP	#00100000B
		MEM8
		lda	#00h
		sta	>7e2dbdh
		sta	>7e2daah
		REP	#00100000B
		MEM16

;---------------------------------------------------------------------
;		}bvɂ鏉Zbg
;---------------------------------------------------------------------
scene_main	LDA	!map_number
		ASL	A
		TAX
		LDY	!scene_select,X
scene_loop	LDX	!0,Y
		BEQ	scene_exit
		PHY			;>>
		JSR	(!0,X)		; << INITIAL SPRITE >>
		PLY			;<<
		INY
		INY
		BRA	scene_loop
scene_exit
;---------------------------------------------------------------------
;		[hɂ鏉Zbg
;---------------------------------------------------------------------
		LDX	<SEQ_register		
		JMP	(!mode_initial,X)
							; I

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
mode_initial	dw	GP_initial,GP_initial,GP_initial
		dw	VS_initial
		dw	TM_initial,TM_initial
		dw	BT_initial
VS_initial
GP_initial
TM_initial
BT_initial	RTS
;*********************************************************************
;	ur[h ACeZbgCjV
;*********************************************************************
;---------------------------------------------------------------------
;		[N̏ݒ
;---------------------------------------------------------------------
work_loop	STZ	<_status,X
		STZ	<_velocityZ,X
		STZ	<_situationZL,X
		STZ	<_situationZH,X
		INY
		INY
Init_objwork	LDX	!0,Y
		BNE	work_loop
		RTS
;---------------------------------------------------------------------
;		[N̏ݒ
;---------------------------------------------------------------------
Clear_object	LDX	!0,Y			;W
clear_loop	INY				;W
		INY				;W
		LDA	!0,Y			;W
		STA	<_backward_A,X		;W = 0,X
		TAX				;WW
		BNE	clear_loop
		RTS
;*********************************************************************
;		map attribute data(sand/spin)
;*********************************************************************
map_attr	DB	-1	; ΂
		DB	0	; T[Lbg
		DB	-1	; 
		DB	-1	; _[g
		DB	-1	; X
		DB	-1	; C
		DB	0	; Nbp
		DB	0	; C{[
		DB	0	; 
;*********************************************************************
;		XXXX
;*********************************************************************
VS_index	DW	player_r0,player_r1,0
;- - - - - - - - - - - - - - - - - - -
;test_index	DW	player_r0,player_r1,player_r2,player_r3
;		DW	player_r4,player_r5,player_r6,player_r7
;		DW	0
;- - - - - - - - - - - - - - - - - - -
grid_format	dw	grid_GP,grid_GP,grid_GP
		dw	grid_VS,grid_TM,grid_TM
		dw	grid_BT
;---------------------------------------------------------------------
init_grid	TXA
		LDX	<SEQ_register
		JMP	(!grid_format,X)
;---------------------------------------------------------------------
;	^CA^bÑObh
;- - - - - - - - - - - - - - - - - - - - - - - - - 
grid_TM		JSR	grid_GP
		LDA	<data_XADD
		CMP	#1000000000000000B
		ROR	A
		CMP	#1000000000000000B
		ROR	A
		STA	<data_XADD	 ; X 
;- - - - - - - - - - - - - - - - - - - - - - - - -
		LDY	#rank_index
		LDA	#-10H
		JSR	set_pole
		LDA	<game_mode	 ; Q[[h
		CMP	#2
		BNE	exit$
		BIT	!g_kart_flag
		BPL	skip$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		BIT	!timeattack_flag
		BPL	ghost$
;- - - - - - - - - - - - - - - - - - - -
		LDA	#-28H
		JSR	set_second
		LDY	!rank_index+4	 ; GJ[gObhZbg
		BEQ	ghost$
		LDA	<_situationYH,X	 ; ObhRs[
		STA	!_situationYH,Y  ; GJ[g( RԖڂ̃Obh )
		LDA	<_situationXH,X	 ;
		STA	!_situationXH,Y  ; GJ[g( RԖڂ̃Obh )
;- - - - - - - - - - - - - - - - - - - -
ghost$		LDY	!rank_index+2	 ; S[XgJ[gObhZbg
		BEQ	exit$
		LDX	!rank_index+0
		LDA	<_situationYH,X	 ; |[̃Obh
		STA	!_situationYH,Y  ; ( RԖڂ̃Obh )
		LDA	<_situationXH,X	 ; |[̃Obh
		STA	!_situationXH,Y	 ; ( RԖڂ̃Obh )
exit$		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
skip$		BIT	!timeattack_flag
		BPL	exit$
		LDA	#-28H
		JMP	set_second
;---------------------------------------------------------------------
;	VS }b` ̃Obh
;- - - - - - - - - - - - - - - - - - - - - - - - - 
grid_VS
grid_BT		JSR	grid_GP
		LDA	<start_XADD		
		CMP	#1000000000000000B
		ROR	A
		CMP	#1000000000000000B
		ROR	A
		STA	<data_XADD
		LDY	#rank_index
		LDA	#-10H
		JSR	set_pole
		LDA	#-28H
		JMP	set_second
;---------------------------------------------------------------------
set_second	PHA				; >> QԃObh
		LDA	<data_XADD
		EOR	#1111111111111111B
		INC	A
		STA	<data_XADD
		PLA				; << |[|WV
set_pole	LDX	<0,Y
		BEQ	exit$
		CLC
		ADC	<_situationYH,X
		STA	<_situationYH,X
		LDA	<_situationXH,X		; X 
		CLC
		ADC	<data_XADD
		STA	<_situationXH,X
		INY
		INY
exit$		RTS
;---------------------------------------------------------------------
;	og[h̃Obh
;- - - - - - - - - - - - - - - - - - - - - - - - - 
Battle_grid	inx
		inx
		stx	<work
		ldy	#rank_index
loop$		ldx	<0,y
		beq	exit$
		phy			;>>
		ldy	<work
		lda	!0,y
		sta	<_situationXH,x
		lda	!2,y
		sta	<_situationYH,x
		stz	<_situationZH,x
		iny
		iny
		iny
		iny
		sty	<work
		ply			;<<
		iny
		iny
		bra	loop$
exit$		rts
;---------------------------------------------------------------------
;	fo [h̃Obh
;- - - - - - - - - - - - - - - - - - - - - - - - - 
grid_GP		TAX
		LDY	#rank_index	; grid work address
grid_10		INX
		INX
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		LDA	!0,X		; X = grid pointer
		STA	<start_X
		LDA	!4,X		; X = grid pointer
		STA	<start_XADD
		STA	<data_XADD
		LDA	!2,X		; X = grid pointer
		STA	<start_Y
	;;;	LDA	!6,X		; X = grid pointer
		LDA	#0018H					
		STA	<start_YADD
;- - - - - - - - - - - - - - - - - - - - - -
grid_loop	LDX	!0,Y
		BEQ	grid_exit
		LDA	#player_r0
		CPX	#player_r0		; player r0 ?
		BNE	grid_1000
		LDA	#player_r1
grid_1000	
	;;;;;	STA	<_rival,X		; rival car
;;
		LDA	<start_X
		STA	<_situationXH,X		; Set X
		CLC
		ADC	<start_XADD
		STA	<start_X		; next X
		LDA	<start_XADD
		EOR	#1111111111111111B
		INC	A
		STA	<start_XADD		; reverse XADD
;
		LDA	<start_Y		; Y position
		STA	<_situationYH,X
		CLC
		ADC	<start_YADD
		STA	<start_Y		; next Y
;
		LDA	>kart_Z			; Z position initial
		STA	<_situationZH,X
		INY
		INY
		BRA	grid_loop
;- - - - - - - - - - - - - - - - - - - - - -
grid_exit
		RTS
;*********************************************************************
;	J[gnaiRg[ubNCjV
;*********************************************************************
;	player_r0	Pop[N
;	player_r1	Qop[N
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
mount_kart	STX	<work
		LDY	!2,X		; ̃f[^i[NAhXj
		lda	!ending_flag
		beq	entry$
		lda	#10h
		bra	skip$
entry$		LDA	!0,Y		; 0,2,4,6,8.. = SEQ_register
skip$		CLC
		ADC	#4		; = address + 4
		ADC	<work
		TAX			; X = mount entry address
		LDY	!0,X		; Y = mount dara address
		STY	<data_pointer
		LDY	#rank_index
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
kart_loop	LDX	<0,Y		; kart index
		BEQ	kart_exit
		PHY			;>>
		LDY	<data_pointer
		JSR	initial_kart	;  [NNA
		CPX	#player_r0
		BEQ	set_player_r0	;vC[P
		CPX	#player_r1
		BEQ	set_player_r1	;vC[Q
		LDA	!8,Y
		JSL	>Mount_A
		LDA	!10,Y
common_skip	JSL	>Mount_B
next_data	PLY			;<<
		INY
		INY
		BRA	kart_loop
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
kart_exit	RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
set_player_r0	
		lda	<_flag,x
		beq	next_data
		LDA	!0,Y
		JSL	>Mount_A
		LDA	!2,Y
		BRA	common_skip
set_player_r1	
		lda	<_flag,x
		beq	next_data
		LDA	!4,Y
		JSL	>Mount_A
		LDA	!6,Y
		BRA	common_skip
;*********************************************************************
;	QZbgC
;*********************************************************************
;	QZbg
;		dw	mount_main
;		dw	*data_pointer	:2
;		dw	*xxxxx
;- - - - - - - - - - - - - - - - - -
mount_main	STX	<work
		LDA	#2		; f[^I
		CLC
		ADC	<work
		TAX
		LDY	!0,X		; Y = mount data address
		TYX
		INY
		INY
		JMP	(!0,X)
;*********************************************************************
;		mount routine
;*********************************************************************
mount_sprite	LDY	!2,X
		BEQ	mount_exit
;-----------------------------------------------------------------------
mount_entry	LDA	!0,Y			; Set clear address
		BEQ	mount_exit
		STA	<addr
mount_loop	LDA	!2,Y		; Set register address
		BEQ	mount_exit
		INY
		INY
		LDX	#0
		JSR	(!addr,X)		
		LDA	!2,Y		; Set screen A vector
		JSL	>Mount_A
		INY
		INY
		LDA	!2,Y		; Set screen B vector
		JSL	>Mount_B
		INY
		INY
		BRA	mount_loop		
mount_exit	RTS
;
;*********************************************************************
;	Œnai (Q) ̃}Eg
;*********************************************************************
sos		equ	00
mount_index	equ	04
mount_init	equ	06
mount_objA	equ	08
mount_objB	equ	10
mount_posdata	equ	12	; 4byte
mount_counter	equ	16
mount_offsetX	equ	18
mount_offsetY	equ	20
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	IF	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
mount_12obj	JSR	Set_counter
;- - - - - - - - - - - - - - - - - - - - - - - 
		LDA	!map_number	; position backup address
		XBA
		LSR	A
		LSR	A
		TAY
		LDA	#ROM_posdata
		STA	<mount_posdata+0
		LDA	#ROM_posdata/65536
		STA	<mount_posdata+2
;- - - - - - - - - - - - - - - - - - - - - - - 
		LDX	#0
;- - - - - - - - - - - - - - - - - - - - - - - 
loop$		LDA	!index_12obj,X		; object index
		STA	!network_index,X
		PHX			; >>
		LDX	#0		
		JSR	(!mount_init,X)
		LDA	<mount_objA
		JSL	>Mount_A
		LDA	<mount_objB
		JSL	>Mount_B
		PLX			; <<
		INX
		INX
		DEC	<mount_counter
		BNE	loop$
		STZ	!network_index,X
exit$		RTS
;- - - - - - - - - - - - - - - - - - - - - - - 
	ENDIF
;= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
;*********************************************************************
;	킫Q̃}Eg
;*********************************************************************
mount_obake
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
		lda	#4			; parameter set
		ldx	<SEQ_register		
		bne	skip$	
		dec	a
		dec	a
skip$		sta	<mount_counter		; ( !0,y = counter )
		lda	!2,Y
		sta	<mount_init		; clear program
		lda	!4,Y		
		sta	!pole_object_A
		sta	<mount_objA		; sprite index
		lda	!6,Y
		sta	!pole_object_B
		sta	<mount_objB		; sprite index
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
		LDX	#0	
;- - - - - - - - - - - - - -
loop$		LDA	!index_12obj,X		; object index
		STA	!network_index,X
		PHX
		TAX
;- - - - - - - - - - - - - - 
		LDA	<mount_objA
		STA	<_object_A,X
		LDY	<pipe_A_forward
		JSL	>Mount_pipe
;- - - - - - 
		jsr	clear_velocity
		stz	<_situationZH,x
		stz	<_attribute,x
;- - - - - - - - - - - - - - 
		TXA
		CLC
		ADC	#40H
		TAX
;- - - - - - - - - - - - - - 
		LDA	<mount_objB
		STA	<_object_A,X
		LDY	<pipe_B_forward
		JSL	>Mount_pipe
;- - - - - - 
		jsr	clear_velocity
		stz	<_situationZH,x
		stz	<_attribute,x

;- - - - - - - - - - - - - - 
		PLX			; <<
		INX
		INX
		DEC	<mount_counter
		BNE	loop$
;- - - - - - - - - - - - - -
		STZ	!network_index,X
exit$		RTS
;*********************************************************************
;	}Egʃ[`
;*********************************************************************
index_12obj
	dw	pole_r0,pole_r1,pole_r2,pole_r3
	dw	0

;	dw	kame_r0,kame_r1,kame_r2,kame_r3
;	dw	kame_r4,kame_r5,pole_r0,pole_r1
;	dw	pole_r2,pole_r3,pole_r4,pole_r5
;	dw	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_counter	

		lda	!0,y
		ldx	<game_status
		cpx	#2			; VS mode ?
		bne	skip$			; no.
		xba
skip$		and	#00ffh
		sta	<mount_counter
		iny
		iny
		lda	!0,Y
		sta	<mount_init
		lda	!2,Y		
		sta	<mount_objA
		lda	!4,Y
		sta	<mount_objB
		rts
;*********************************************************************
;	Œnai (Qj̋ʃCjV
;*********************************************************************

init_fish	jsr	init_dokan

		lda	<_situationXH,x		; WZbg
		sta	<_initposX+0,x
		sta	<_initposX+40h,x
		lda	<_situationYH,x
		sta	<_initposY+0,x
		sta	<_initposY+40h,x
		rts

init_dokan	tax
		lda	#0c000h
		sta	<_status,x
		stz	<_poseP,x
		stz	<_poseP+40h,x
		stz	<_poseQ,x
		stz	<_poseQ+40h,x
		lda	#0404h
		jmp	read_position	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
init_poo	TAX				; set index
		LDA	#0C000H
		STA	<_status,X
		stz	<_poseP,x
		stz	<_poseP+40h,x
		stz	<_poseQ,x
		stz	<_poseQ+40h,x
		STZ	<_BGcheck_flag,X
		lda	#0a0ah
		jmp	read_position
;*********************************************************************
;	naiCjVGfB^[W[h
;*********************************************************************
; Zbgʒuif[^Oj
;- - - - - - - - - - - - - - - - - - - - - - - - -
read_position	SEP	#00100000B
		MEM8
		sta	<mount_offsetX+0	
		stz	<mount_offsetX+1
		xba
		sta	<mount_offsetY+0
		stz	<mount_offsetY+1
		REP	#00100000B
		MEM16
		LDA	[<mount_posdata],Y
		PHA				;>>
		AND	#0007FH
		ASL	A
		ASL	A
		ASL	A
		ADC	<mount_offsetX
		STA	<_situationXH,X
		PLA				;<<
		AND    	#03F80H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ADC	<mount_offsetY
		STA	<_situationYH,x
		STZ	<_situationZH,x
		STZ	<_situationZL,x
;- - - - - - - - - - - - - - - - - - - - - - - - -
		STZ	<_attribute,X
;- - - - - - - - - - - - - - - - - - - - - - - - -
		INY
		INY
		JMP	clear_velocity		
;*********************************************************************
;		sprite clear routine
;*********************************************************************
;============================================== ; clear rutine ======
;
clear_stop	PLA		;<<
		RTS
;
;clear_kart
initial_kart	
		phy		; >>
;- - - - - - - - - - - - - - - - - - - - 
		phx		;   >>	
		ldy	#030h		; [N 0 NA
loop$		stz	<40h,x	;  40h,50h,60h,70h,80h,90h
		inx
		inx
		dey
		bne	loop$
		plx		;   <<
;- - - - - - - - - - - - - - - - - - - - 
		ldy	<_status,x	; Zbg
		lda	!HP_data,y
		sta	<_HP,x

	;;;	stz	<_muteki_timer,x
		stz	<_kart_handle,x	; nhNA

		lda	<rank_number,x
		sta	<_rank_back,x

		lda	#min_patern	; ]TCYŏZbg
		sta	<_ptn_A,X	
		sta	<_ptn_B,X	
	;;;	stz	<_poseQ,x	; Zbg

					; ނinitial
		STZ	!_anime_start+smorke_r0
		STZ	!_anime_start+smorke_r1
		STZ	!_anime_register+smorke_r0
		STZ	!_anime_register+smorke_r1

		lda	<kart_status,x
		and	#ON_chibi
		beq	skip$
		lda	#0ffffh
		sta	<_sunder_timer,x
		lda	<_HP,x
		and	#(10h^0ffffh)		; `rZbg
		sta	<_HP,x

skip$		SEP	#00100000B
		MEM8
		stz	<_situationZH+1,x
		REP	#00100000B
		MEM16
;;
		ply		; <<
		jmp	clear_velocity
;-----------------------------------------------------------------------
HP_data		DW	2+18h	; mario	
		DW	2+18h	; luige
		DW	3+18h	; koopa	
		DW	1+18h	; peach	
		DW	3+18h	; cong
		DW	1+18h	; kame
		DW	1+18h	; kinopio
		DW	1+18h	; yossy
;-----------------------------------------------------------------------
;	slp Q naiCjV
;-----------------------------------------------------------------------
clear_poo	TAX
		LDA	#0C000H
		STA	<_status,X
		LDA	!2,Y
		INY
		INY
		STA	<_anime_pointer,X
		STZ	<_anime_number,X
		STZ	<_BGcheck_flag,X
		jsr	set_xyz
;
		stz	<_situationZH,x
		stz	<_situationZL,x
;
		rts
;-----------------------------------------------------------------------
;	asp }CJ[gnaiCjV
;-----------------------------------------------------------------------


;*********************************************************************
;		|WṼCjV
;*********************************************************************
set_xyz		LDA	!2,Y
		STA	<_situationXH,X
		LDA	!4,Y
		STA	<_situationYH,X
		LDA	!6,Y
		STA	<_situationZH,X
		LDA	!8,Y
		STA	<_attribute,X
		LDA	!10,Y
		STA	<_item_workA,X
		STA	<_item_workB,X
		TYA
		CLC
		ADC	#10
		TAY
		JMP	clear_velocity
;*********************************************************************
;		|WVƃxNg̃NA
;*********************************************************************
clear_allposition
		STZ	<_situationXH,X
		STZ	<_situationYH,X
		STZ	<_situationZH,X
clear_velocity	STZ	<_situationXL,X		; situation off
		STZ	<_situationYL,X
		STZ	<_situationZL,X
		STZ	<_velocityX,X		; initial speed
		STZ	<_velocityY,X
		STZ	<_velocityZ,X
		RTS
;#####################################################################
;		uq`l̃Zbg
;#####################################################################
;*********************************************************************
;		Set test character
;*********************************************************************
;		SET DEBUG OBJ NUMBER SET
;---------------------------------------------------------------------
ROM_alpha	EQU	48000H		; 4bit mode
ISPK_buffer	EQU	7FA000H		
VRAM_alpha	EQU	5800H		
COUNT_alpha	EQU	200H		; data byte count (16char 4bit)
VRAM_BTalpha	EQU	4800H
COUNT_BTalpha	EQU	0800H
;---------------------------------------------------------------------
Set_DBnumber_B	PHB
		PHK
		PLB
		LDX	#alpha_p2
		JSL	>Execute_VRAM		
		PLB	
		RTL
;---------------------------------------------------------------------
alpha_p1	DB	80H			; 1 Screen step
		DW	VRAM_alpha		; 2 VRAM address
		DW	1801H			; 4 DMA parameter
		DL	ISPK_buffer		; 6 A bus address
		DW	COUNT_alpha		; 9 byte count
alpha_p2	DB	80H			; 1 Screen step
		DW	VRAM_alpha+1000H	; 2 VRAM address
		DW	1801H			; 4 DMA parameter
		DL	ISPK_buffer		; 6 A bus address
		DW	COUNT_alpha		; 9 byte count
alpha_battle	DB	80H			; 1 Screen step
		DW	VRAM_BTalpha		; 2 VRAM address
		DW	1801H			; 4 DMA parameter
		DL	ISPK_buffer		; 6 A bus address
		DW	COUNT_BTalpha		; 9 byte count
;---------------------------------------------------------------------
win_lost_1	DB	80H
		DW	5200H
		DW	1801H
		DL	MOJI_buffer+1600H
		DW	800H
win_lost_2	DB	80H
		DW	6200H
		DW	1801H
		DL	MOJI_buffer+1600H
		DW	800H
;---------------------------------------------------------------------
pc_data		
	;	db	062h,048h,066h,050h,074h,0e5h,018h,01dh
	;	db	012h,01eh,016h,019h,014h,01bh,01ch,00ch
	;	db	063h,049h,067h,051h,075h,011h,00ah,017h
	;	db	010h,00eh,00dh,022h,01fh
	;	db	0

		db	04ch,050h,06ah,048h,074h,0e5h,018h,01dh
		db	012h,01eh,068h,069h,015h,01bh,01ch,00ch
		db	04dh,051h,06bh,049h,075h,011h,00ah,017h
		db	010h,00eh,00dh,022h,01fh,05eh,05fh,019h
		db	0



wl_data_1	db	06ch,06dh,05ch,05dh,05ah,05bh,056h,057h
		db	05ch,05dh,064h,065h,066h,067h,09ch,078h,0

wl_data_2	db	79h,20h,15h,0
;---------------------------------------------------------------------
		ext	Init_round
Set_VRAMextra	
;
		jsr	Init_round

;- - - - - - - - - - - - - - - - - - - - - - - 
;ENG-VER	p version initial
;- - - - - - - - - - - - - - - - - - - - - - - 
;|[YLN^obt@Z[u	
;- - - - - - - - - - - - - - - - - - - 
		ldy	#pc_data
		ldx	#MOJI_buffer+1c00h
		jsr	Buffer_pause
;- - - - - - - - - - - - - - - - - - - 
;LN^obt@Z[u
;- - - - - - - - - - - - - - - - - - - 
		ldy	#wl_data_1
		ldx	#MOJI_buffer+1700h
		jsr	Buffer_pause
		ldy	#wl_data_2

		ldx	#MOJI_buffer+1b80h
		jsr	Buffer_pause
;- - - - - - - - - - - - - - - - - - - 
;LN^@VRAM WRITE
;- - - - - - - - - - - - - - - - - - - 
		LDA	<game_status
		CMP	#2
		BNE	skip$
		LDX	#win_lost_1
		JSL	>Execute_VRAM
		LDX	#win_lost_2
		JSL	>Execute_VRAM
skip$		
;- - - - - - - - - - - - - - - - - - -
;fobO[hpAt@xbgZbg
; - - - - - - - - - - - - - - - - - - - - - - - ; alphabet(debug)- - - 
	;	LDX	#alpha_p1
	;	JSL	>Execute_VRAM
	;	LDX	#alpha_p2
	;	JSL	>Execute_VRAM
; - - - - - - - - - - - - - - - - - - - - - - - ; alphabet(battle) - -
	;	LDA	!battle_flag
	;	BEQ	test_exit
	;	LDX	#alpha_battle		
	;	JSL	>Execute_VRAM
test_exit
;- - - - - - - - - - - - - - - - - - -
;WQx^LN^Zbg
;- - - - - - - - - - - - - - - - - - - 
		ldx	#0
		lda	#56e0h
		jsr	Set_beta
		ldx	#0
		lda	#66e0h
		jsr	Set_beta
;- - - - - - - - - - - - - - - - - - - 
;Q[I[o[`FbN
;- - - - - - - - - - - - - - - - - - - 
		ldx	#0
		lda	!erase_kart,x
		bpl	skip$
		jsr	init_over
skip$		ldx	#2
		lda	!erase_kart,x
		bpl	exit$
		jsr	init_over
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
exit$		rts
;**********************************************************************
;	2P Q[I[o[Ƃ
;**********************************************************************
init_over	stx	<screen_register
		lda	#0ffffh
		sta	!gameover_1lost,x	; PQ[I[o[ 
		lda	#1			; PS[C
		sta	!goal_flag
		jsl	>Set_over_char
		jsl	>Open_gameover
		ldx	#DMA_character
		jsl	>Call_bank0
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 	
		ext	Set_over_char,Open_gameover
		ext	DMA_character,Call_bank0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 	
;
;
;
;
;
;
;
;
;
;
;
;#####################################################################
;		UTILITY
;#####################################################################
;*********************************************************************
;	|[YLobt@փZbg
;*********************************************************************
;	y = f[^|C^
;	x = VeoNRs[AhX
;	
;- - - - - - - - - - - - - - - - - - -
Buffer_pause
		lda	#BANK		MOJI_buffer
		sta	<addr+2
		lda	#OFFSET		MOJI_buffer
		sta	<addr+0

loop$		lda	!0,y
		and	#00ffh
		beq	exit$			
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		phy			; >>
		tay
		jsr	copy_data
		ply			; <<
		iny
		bra	loop$

exit$		rts
;= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = 
copy_data	lda	#10h
		sta	<counter
loop$		lda	[<addr],y
		sta	>7f0000h,x
		iny
		iny
		inx
		inx
		dec	<counter
		bne	loop$	
		rts
;---------------------------------------------------------------------
;**********************************************************************
;	]pȂтuq`lȂт֕ϊ
;**********************************************************************
;
;	A register = VRAM address
;	X register = Buffer address
; - - - - - - - - - - - - - - - - - - - - - - -
		GLB	Set_coin,Set_upcoin
; - - - - - - - - - - - - - - - - - - - - - - -
Set_coin	LDY	#80H
		STY	!Screen_step
		PHA
		JSR	set_big
		PLA
		CLC
		ADC	#0100H		
Set_upcoin
set_big		STA	!Screen_address+0
		LDY	#20H		; 2 character
loop1$		LDA	>7F0000H,X	; read data
		STA	!Screen_write+0
		INX
		INX
		DEY
		BNE	loop1$
		RTS
;**********************************************************************
;	PUi --> POi ϊe[u
;**********************************************************************
;**********************************************************************
;	ACe쐬c[
;**********************************************************************
Set_debugmap

		lda	!rom_checker
		beq	rom$

ram$		lda	!map_number
		xba
		lsr	a
		adc	#BGunit_buffer
		tax
		ldy	#Question_buffer
		lda	#80h-1
		phb
		mvn	#BGunit_buffer/65536,#Question_buffer/65536
		plb
		rtl

rom$		lda	!map_number
		xba
		lsr	a
		adc	#BGunit_ROM
		tax
		ldy	#Question_buffer
		lda	#80h-1
		phb
		mvn	#BGunit_ROM/65536,#Question_buffer/65536
		plb
		rtl

;--------------------------------------------------------------------
;
	if	0

loop$		lda	>7f0000h+0h,x		; plI
		cmp	#0101h
		bne	over$
		lda	>7f0000h+80h,x
		cmp	#0101h
		bne	over$
;
		lda	#0c1c0h			;"H"
		sta	>7f0000h+0h,x
		lda	#0c3c2h
		sta	>7f0000h+80h,x
;
over$		
		clc
		txa
		adc	#4
		bit	#0080h			; clc
		beq	skip$
		adc	#0080h			; clc
skip$		tax
		cpx	#4000h
		bne	loop$

		rtl


	endif

;**********************************************************************
;		x^LN^[
;**********************************************************************
;			|
;		LDX	#0EH*4		;x^pbg(*4)
;		LDA	#5200H		;uq`lAhX
;		JSR	Set_beta
;			|
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_beta	JSR	set_beta		; 4x4 size beta
		ADC	#10H
		JSR	set_beta
		ADC	#0F0H
		JSR	set_beta
		ADC	#10H
;- - - - - - - - - - - - - - - - - - - - - - - 			
set_beta	PHA				; 1x1 size beta
		LDY	#80H
		STY	!Screen_step
		STA	!Screen_address
		LDY	#8
		LDA	!beta_data+0,X
loop1$		STA	!Screen_write
		DEY
		BNE	loop1$
		LDY	#8
		LDA	!beta_data+2,X
loop2$		STA	!Screen_write
		DEY
		BNE	loop2$
		PLA
		CLC
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
beta_data	DW	00000h,00000h	; 0
		DW	000ffh,00000h	; 1
		DW	0ff00h,00000h	; 2
		DW	0ffffh,00000h	; 3
		DW	00000h,000ffh	; 4
		DW	000ffh,000ffh	; 5
		DW	0ff00h,000ffh	; 6
		DW	0ffffh,000ffh	; 7
		DW	00000h,0ff00h	; 8
		DW	000ffh,0ff00h	; 9
		DW	0ff00h,0ff00h	; A
		DW	0ffffh,0ff00h	; B
		DW	00000h,0ffffh	; C
		DW	000ffh,0ffffh	; D
		DW	0ff00h,0ffffh	; E
		DW	0ffffh,0ffffh	; F
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;**********************************************************************
;		sprite buffer clear
;**********************************************************************
CLEAR_SPRITE	PHB
		PHK
		PLB
		LDX	#clear_sprite
		JSL	>CLEAR_RAM
		PLB
		RTL
;-----------------------------------------------------------------------
clear_sprite	DW	sprite_main,sprite_sub,oam_main,oam_sub,0
sprite_main	DW	0F080H
		DL	sprite_Abuffer+0
		DW	200H
sprite_sub	DW	0
		DL	sprite_Abuffer+sprite_E
		DW	20H	
oam_main	DW	0F080H
		DL	sprite_Bbuffer+0
		DW	200H
oam_sub		DW	0
		DL	sprite_Bbuffer+sprite_E
		DW	20H
;**********************************************************************
;		Execute DMA
;**********************************************************************
;<<example>>	LDX	#DP
;		JSL	>Execute_VRAM
;DP		DB	80H		; 1 Screen step
;		DW	7000H		; 2 VRAM address
;		DW	1801H		; 4 DMA parameter	
;		DL	000000H		; 6 A bus address	
;		DW	0000H		; 9 byte count
;----------------------------------------------------------------------
Execute_VRAM	LDA	!3,X		;W	DMA parameter
		STA	!DMA_0+0	;W
		LDA	!5,X		;W	DMA Abus address
		STA	!DMA_0+2	;W
		LDA	!7,X		;W(B)	DMA Abus bank
		STA	!DMA_0+4	;W(B)
		LDA	!8,X		;W	DMA byte count
		STA	!DMA_0+5	;W
		LDA	!0,X		;W(B)
		STA	!Screen_step	;W(B)	VRAM inc 
		LDA	!1,X		;W
		STA	!Screen_address	;W	VRAM address
		SEP	#00110000B
		MEM8
		IDX8
		LDA	#00000001B	;B	DMA channel 0 start
		STA	!DMA_burst	;B
		REP	#00110000B
		MEM16
		IDX16
		RTL
;----------------------------------------------------------------------
;		LDX	#DP
;		LDA	#address
;		JSL	>Execute_TRANS
;DP		DB	80H		; 0 Screen step
;		DW	7000H		; 1 VRAM address
;		DW	1801H		; 3 DMA parameter	
;		DB	00H		; 5 A bus bank
;		DW	0000H		; 6 byte count
;----------------------------------------------------------------------
Execute_TRANS	STA	!DMA_0+2	;W
		LDA	!3,X		;W	DMA parameter
		STA	!DMA_0+0	;W
		LDA	!6,X		;W	DMA byte count
		STA	!DMA_0+5	;W
		LDA	!0,X		;W(B)
		STA	!Screen_step	;W(B)	VRAM inc 
		LDA	!1,X		;W
		STA	!Screen_address	;W	VRAM address
		SEP	#00100000B
		MEM8
		LDA	!5,X		;B	DMA Abus bank
		STA	!DMA_0+4	;B
		LDA	#00000001B	;B	DMA channel 0 start
		STA	!DMA_burst	;B
		REP	#00100000B
		MEM16
		RTL
;----------------------------------------------------------------------
;			|
;		LDX	#ROMaddress
;		LDA	#data_count+ROMbank*100H
;		LDY	#vram_address
;		JSL	DMA_trans
;			|
;		data_count 1 	= 10H
;			10H	= 100H
;----------------------------------------------------------------------
DMA_trans	PHA
		STX	!DMA_0+DMA_address+0	;W
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	!DMA_0+DMA_count+0	;W
		PLA
		SEP	#00100000B
		MEM8
		XBA
		STA	!DMA_0+DMA_address+2	;B	bank
		LDX	#1801H			;W	low,high 2byte
		STX	!DMA_0+DMA_control	;W
		LDA	#80H			;B
		STA	!Screen_step		;B	hi inc
		STY	!Screen_address		;W
		LDA	#00000001B		;B
		STA	!DMA_burst		;B
		REP	#00100000B
		MEM16
		RTL
;*********************************************************************
;		RAM clear
;*********************************************************************
;example
;		LDX	#PP
;		JSL	>CLEAR_RAM
;PP		DW	DP,DP,DP,0	
;------
;		LDX	#DP
;		JSL	>Clear_RAM
;DP		DW	0000H 	( 2 byte clear patern )
;		DL	7F0000H ( RAM start address )
;		DW	4000H	( RAM clear count )
;
;		ldx	#address
;		lda	#bank
;		ldy	#clear_count
;		jsl	>zero_ram
;---------------------------------------------------------------------
zero_ram


CLEAR_RAM	TXY
loop_RAM	LDX	!0,Y		; read data
		BEQ	exit_RAM
		JSL	>Clear_RAM
		INY
		INY
		BRA	loop_RAM
exit_RAM	RTL
;---------------------------------------------------------------------
Clear_RAM	PHY			;>>
		SEP	#00100000B
		MEM8
		LDA	!0,X		; Low ( Clear parameter )
		STA	!211BH
		LDA	!1,X		; High
		STA	!211BH
		LDA	#1
		STA	!211CH
		STA	!211CH
;----------------------------------------------------------------
		LDY	#3481H		; DMA parameter
		STY	!DMA_0+0
		LDY	!2,X		; DMA Abus address
		STY	!DMA_0+2
		LDA	!4,X		; DMA Abus bank
		STA	!DMA_0+4
		LDY	!5,X		; DMA byte count
		STY	!DMA_0+5
		LDA	#00000001B	; DMA channel 0 start
		STA	!DMA_burst
		REP	#00100000B
		MEM16
		PLY			;<<
		RTL
;**********************************************************************
;		VRAM clear ( DMA VRAM clear )
;**********************************************************************
;example	LDX	#DP
;		JSL	>Clear_VRAM
;DP		DW	0000H ( 2 byte clear patern )
;		DW	0000H ( VRAM start address )
;		DW	4000H ( VRAM clear count )
;--------------------------------------------------------------------
Clear_VRAMlow	PHY			;>>
		LDY	!4,X		;W	X=(low data)pointer
		JSR	low_clear
		BRA	VRAM_exit
Clear_VRAM	PHY			;>>
		LDY	!4,X		;W	X=(low_data)pointer
		JSR	low_clear
		INX			;W 	X=(high_data)pointer 
		JSR	high_clear
VRAM_exit	PLY			;<<
		RTL
;----------------------------------------------------------------------
low_clear	LDA	!2,X			; write VRAM address
low_clear_entry	STZ	!Screen_step 		; low inc
		STA	!Screen_address+0
		LDA	#1808H			; 2118H / 1 byte
		BRA	VRAM_clear		;
;----------------------------------------------------------------------
high_clear	LDA	#80H			; hi inc
		STA	!Screen_step
		LDA	!1,X			; write VRAM address
		STA	!Screen_address+0
		LDA	#1908H			; 2119H / 1 byte
		BRA	VRAM_clear		;
;----------------------------------------------------------------------
VRAM_clear	STA	!DMA_0+0
		STX	!DMA_0+2		; ROM address
		STY	!DMA_0+5		; byte	count
;----------------------------------------------------------------------
		SEP	#00100000B
		MEM8
		PHB				;> data bank read
		PLA				;<
		STA	!DMA_0+4		; ROM bank
		LDA	#00000001B		; DMA start
		STA	!DMA_burst
		REP	#00100000B
		MEM16
		RTS
;**********************************************************************
;		ROM -> RAM ( nomal copy )
;**********************************************************************
;<<example>>
;		LDX	#DP
;		JSR	Copy_buffer
;<<format>>
;		DW	1000H ( data byte count )
;		DL	048000H ( input data address )
;		DL	001000H ( output data address )
;		DW	0	( end code )
;----------------------------------------------------------------------
input_addr	EQU	0
output_addr	EQU	4
;----------------------------------------------------------------------
Copy_buffer	LDY	!0,X
		BEQ	copy_exit
		LDA	!2,X			;W address
		STA	<input_addr+0		;W 
		LDA	!4,X			;W bank
		STA	<input_addr+2		;W 
		LDA	!5,X			;W address
		STA	<output_addr+0		;W 
		LDA	!7,X			;W bank
		STA	<output_addr+2		;W 
		DEY				;W -2
		DEY				;W
buffer_copy	LDA	[<input_addr],Y		;W
		STA	[<output_addr],Y	;W
		DEY				;W
		DEY				;W
		BPL	buffer_copy				
		TXA
		CLC
		ADC	#8
		TAX
		BRA	Copy_buffer
copy_exit	RTS
;**********************************************************************
;	naiLN^[[hVɕϊ
;		Convert_m1m7		
;**********************************************************************
;<<format>>
;
;		X	= Read RAM address ( 7F bank )
;				( naiL )
;		Y 	= Write RAM address ( 7F bank )
;				( [hVL )
;		A(low)	= character count ( 1 - 255 ) 
;		 (high)	= attribute ( 0 - F )
;
;		mem=16,idx=16
;
;			|
;		JSL	>Convert_m1m7
;			|
;
;		mem=16,idx=16
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
workX		EQU	0
work0		EQU	workX+02
work1		EQU	workX+04
work2		EQU	workX+06
work3		EQU	workX+08
buff_pointer	EQU	workX+10
loop_counter	EQU	workX+12
line_counter	EQU	workX+14
char_counter	EQU	workX+16
palet		EQU	workX+18
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		GLB	Convert_m1m7		
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Convert_m1m7	PHB
;- - - - - - - - - - - - - - 
		PHA			;>>
		TXA
		TYX			; X = write address
		TAY			; Y = read address
;- - - - - - - - - - - - - - 
		PLA			;<<
		SEP	#00100000B
		MEM8
		STA	<loop_counter
		XBA
		STA	<palet
;- - - - - - - - - - - - - - 
		LDA	#7FH
	;;;;	LDA	#4
		PHA
		PLB			;<- data data bank
;
;------------------------------------- ; 1 character buffer set ------
next$
		LDA	#8
		STA	<char_counter
;
char_loop$	LDA	#8
		STA	<line_counter
		LDA	!00H,Y
		STA	<work0
		LDA	!01H,Y
		STA	<work1
		LDA	!10H,Y
		STA	<work2
		LDA	!11H,Y
		STA	<work3
line_loop$
		LDA	<palet		 ; palet number
		ASL	<work3
		ROL	A
		ASL	<work2
		ROL	A
		ASL	<work1
		ROL	A
		ASL	<work0
		ROL	A
		BIT	#00001111B	; NUKI check
		BNE	skip$
		LDA	#0
skip$		STA	>7f0000H,X
		INX
		DEC	<line_counter
		BNE	line_loop$
		INY
		INY
		DEC	<char_counter
		BNE	char_loop$
;========================
		REP	#00100001B
		MEM16
		TYA
		ADC	#10H
		TAY
		SEP	#00100000B
		MEM8
;========================
		DEC	<loop_counter
		BNE	next$
;========================
		REP	#00100000B
		MEM16
		PLB			;<-
		RTL
;========================
		END
