;*********************************************************************
;	mario kart << editer >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		include	../DEF/editer.def
;---------------------------------------------------------------------
		GLB	ED_init_3,ED_main_3,ED_nmi_3
		EXT	Convert_m1m7
		EXT	Decode_mode3
		EXT	Execute_VRAM
		EXT	Decode_7F_X,CLEAR_SPRITE,Clear_RAM
		EXT	Execute_TRANS
;---------------------------------------------------------------------
		EXT	DMA_demokart
		EXT	Init_demokart,Set_demokart
;---------------------------------------------------------------------
		EXT	conv_data0,set_m7scr
		EXT	select_data,title_data,sound_data
		EXT	conv_mario
;---------------------------------------------------------------------
		EXT	map_init,map_main
		GLB	OBJ_byte,OBJ_word,OBJ_message
		GLB	Init_mode7,ON_screen,Set_M7register
		GLB	Scroll_cursor,Init_PPU
;---------------------------------------------------------------------
title_screen	EQU	7FC000H
sound_screen	EQU	7FC800H
select_screen	EQU	7FD000H
;---------------------------------------------------------------------
		COMN
temp		DS	2	; =work
addr		DS	4
data_limit	DS	2
data_offset	DS	2
obj_attr	DS	2
trigger_work	DS	2
;---------------------------------------------------------------------
edit_select	EQU	0
m7test		EQU	2
cgtest		EQU	4
bigtest		EQU	6
maptest		EQU	8
edit_title	EQU	10
objtest		EQU	12
soundtest	EQU	14
;---------------------------------------------------------------------
		mem16
		idx16
		EXTEND
editer		sect	rel
;=====================================================================
cursor_UD	EQU	0
cursor_LR	EQU	1
cursor_BY	EQU	2
;---------------------------------------------------------------------
battle_data	EQU	3*100H+cursor_BY
;#####################################################################
;		MAIN SYSTEM
;#####################################################################
;*********************************************************************
;		initial editer
;*********************************************************************
;
;	moji character VRAM set
;	sprite buffer clear
;	work RAM clerar
;
;---------------------------------------------------------------------
ED_init_3	PHB
		PHK
		PLB
		JSR	Set_alpha
		LDA	#200H			; sprite count reset
		STA	<sprite_count
		JSL	>CLEAR_SPRITE
;- - - - - - - - - - - 
		PHB
		STZ	!1800H
		LDX	#1800H		; 1800H - 18FFH clear
		TXY
		INY
		LDA	#100H-2
		MVN	#00H,#00H
		PLB
;- - - - - - - - - - - 
		STZ	<edit_status
		STZ	<system_SEQ	; sestem SEQ
		PLB
		RTL
;- - - - - - - - - - -
;clear_edit_work
;		DW	0000H 	( 2 byte clear patern )
;		DL	1800H	( RAM start address )
;		DW	1000H	( RAM clear count )
;*********************************************************************
;		main editer 
;*********************************************************************
ED_main_3	PHB
		PHK
		PLB
		JSR	Repeat_trigger		; NMI

		lda	#1
		sta	!debug_rom_flag

	if	0
		SEP	#00100000B
		MEM8				;
		LDA	<ppu_control		; NMI
		STA	!PPU_control		; NMI
		REP	#00100000B
		MEM16				;
	endif
		LDA	#200H			; sprite count reset
		STA	<sprite_count		;
		LDA	<edit_status
		ASL	A
		TAX
		JSR	(!editer_select,X)
		PLB
		RTL
;---------------------------------------------------------------------
editer_select
		DW	select_init	;0 mario kart
		DW	select_main	;	debug mode !
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		DW	m7test_init	;2 m7test
		DW	m7test_main
		DW	cgtest_init	;4 cgtest
		DW	cgtest_main
		DW	bigtest_init	;6 bigtest
		DW	bigtest_main
		DW	map_init	;8 maptest
		DW	map_main
		DW	title_init	;10 title
		DW	title_main
		DW	objtest_init	;12 obj demo
		DW	objtest_main
		DW	soundtest_init	;14 sound test
		DW	soundtest_main	
;*********************************************************************
;		NMI editer
;*********************************************************************
ED_nmi_3	PHB
		PHK
		PLB
		INC	<edit_frame
		LDA	<edit_status
		ASL	A
		TAX
		JSR	(!nmi_select,X)
		PLB
		RTL
;--------------------------------------------------------------------
nmi_select	DW	no_nmi,select_nmi	;0
		DW	no_nmi,no_nmi		;2
		DW	no_nmi,no_nmi		;4
		DW	no_nmi,no_nmi		;6
		DW	no_nmi,no_nmi		;8
		DW	no_nmi,no_nmi		;10
		DW	no_nmi,no_nmi		;12
		DW	no_nmi,sound_nmi	;14
		DW	no_nmi,no_nmi		;16
		DW	no_nmi,no_nmi		;18
;--------------------------------------------------------------------
no_nmi		RTS
;--------------------------------------------------------------------
select_nmi	LDX	#dma_select		; (NMI)
		JSL	>Execute_VRAM
		RTS
;- - - - - - - - - - - - - - - - - - - - - -
dma_select	DB	80H
		DW	7000H		; VRAM address
		DW	1801H
		DL	select_screen
		DW	0800H
;--------------------------------------------------------------------
sound_nmi	LDX	#dma_sound		; (NMI)
		JSL	>Execute_VRAM
		JSL	>DMA_demokart
		RTS
;- - - - - - - - - - - - - - - - - - - - - -
dma_sound	DB	80H
		DW	7000H		; VRAM address
		DW	1801H
		DL	sound_screen
		DW	0800H
;--------------------------------------------------------------------
;
;
;
;
;
;#####################################################################
;		TITLE SYSTEM
;#####################################################################
;*********************************************************************
;		fobOp}bvZNg	( INITIAL )
;*********************************************************************
select_init	JSR	Init_PPU		; PPU initial
		JSR	Init_EDcolor		; moji color
		SEP	#00100000B
		MEM8
		LDA	#select_screen/65536	; moji buffer
		LDX	#select_screen
		STA	<disp_addr+2
		STX	<disp_addr+0		
		REP	#00100000B
		MEM16
	;	LDA	#14H
		LDA	#0
		STA	!battlemap
		STZ	<edit_point
		JSR	mode_select		; BG mode/bank set
		JSR	clear_buffer
		JSR	select_nmi		; TRANS 
		JSR	ON_screen
		DB	001H
		RTS
;---------------------------------------------------------------------
;*********************************************************************
;		fobOp}bvZNg	( MAIN )
;*********************************************************************
DBmode_count	EQU	100H*13
;- - - - - - - - - - - - - - - - - - - - - -
select_main	
		JSR	clear_buffer		; 
		LDX	#select_data		
		JSR	Set_text
;- - - - - - - - - - - - - - - - - - - - - -
		LDX	#edit_point
		LDA	#0000H+DBmode_count
		JSR	Calc_cursor
;- - - - - - - - - - - - - - - - - - - - - -
		LDA	<edit_frame
		AND	#008H
		BEQ	frash$
		LDA	<edit_point
		INC	A			; 0 = debug mode message
		ASL	A
		ASL	A
		TAX
		LDY	!select_data+2,X
		LDX	#clear_line
		JSR	Call_text
frash$
;- - - - - - - - - - - - - - - - - - - - - -
		LDA	<edit_point
		ASL	A
		TAX	
		JSR	(!select_edit,X)
;- - - - - - - - - - - - - - - - - - - - - -
		LDY	#0B7H*2
		LDA	!world_number
		JSR	Emit_byte
		LDY	#0D7H*2
		LDA	!map_pointer
		JSR	Emit_byte
;- - - - - - - - - - - - - - - - - - - - - -
		LDY	#157H*2
		LDA	#0		; !battle_select
		JSR	Emit_byte
		LDY	#177H*2
		LDA	!battlemap
		JSR	Emit_byte
;- - - - - - - - - - - - - - - - - - - - - -
		RTS
;---------------------------------------------------------------------
select_edit	DW	select_world		; 0
		DW	select_course		; 1
		DW	start_rase		; 2
		DW	select_battleobj	; 3
		DW	select_battlemap	; 4
		DW	start_battle		; 5
		DW	edit1			; 6
		DW	edit2			; 7
		DW	m7_char			; 8
		DW	cg_map			; 9
		DW	map_check		; 10
		DW	demo2			; 11
		DW	sound_test		; 12
		DW	select_exit		; 13
;---------------------------------------------------------------------
map_check	BIT	<button_trigger+0
		BPL	state_exit
		LDA	#maptest
		BRA	state_next
;---------------------------------------------------------------------
sound_test	BIT	<button_trigger+0
		BPL	state_exit
		LDA	#soundtest
		BRA	state_next
;---------------------------------------------------------------------
cg_map		BIT	<button_trigger+0
		BPL	state_exit
		LDA	#cgtest
		BRA	state_next
;---------------------------------------------------------------------
m7_char		BIT	<button_trigger+0
		BPL	state_exit	
		LDA	#m7test
		BRA	state_next
;---------------------------------------------------------------------
demo1		BIT	<button_trigger+0
		BPL	state_exit
		LDA	#bigtest
		BRA	state_next
;---------------------------------------------------------------------
demo2		BIT	<button_trigger+0
		BPL	state_exit
		LDA	#objtest
		BRA	state_next
;---------------------------------------------------------------------
state_next	STA	<edit_status
state_exit	RTS
;---------------------------------------------------------------------
select_exit
		RTS
;---------------------------------------------------------------------
select_battlemap
		LDX	#battlemap
		LDA	#1FH*100H+cursor_BY
		JMP	Calc_cursor
;---------------------------------------------------------------------
select_battleobj			
		LDX	#0			; #battle_select
		LDA	#0			; #3H*100H+cursor_BY
		JMP	Calc_cursor
;---------------------------------------------------------------------
start_battle	LDA	<button_trigger+0
		AND	#1111000000000000B
		BEQ	exit$
;- - - - 
		LDA	!battlemap
		STA	!map_number
;;
		LDA	#8
		STA	!race_init
		LDA	#0eh     
		STA	<game_selecta
		LDA	#08F00H
		STA	<fade_control
		LDA	#0100H
		STA	!fade_speed
exit$		RTS
;---------------------------------------------------------------------
start_rase	LDA	<button_trigger+0
		AND	#1111000000000000B
		BEQ	exit$
		LDA	#8
		STA	!race_init
		LDA	#2
		STA	<game_selecta
		LDA	#08F00H
		STA	<fade_control
		LDA	#0100H
		STA	!fade_speed
		LDA	#99
		STA	!player_count+0
		STA	!player_count+2
exit$		RTS
;---------------------------------------------------------------------
edit1		LDA	<button_trigger+0
		AND	#1111000000000000B
		BEQ	exit$
		LDA	!battlemap
		STA	!map_number
		LDA	#10H
		STA	<game_selecta
		LDA	#08F00H
		STA	<fade_control
		LDA	#0100H
		STA	!fade_speed
exit$		RTS
;---------------------------------------------------------------------
edit2		LDA	<button_trigger+0
		AND	#1111000000000000B
		BEQ	exit$
		LDA	!battlemap
		STA	!map_number
		LDA	#12H
		STA	<game_selecta
		LDA	#08F00H
		STA	<fade_control
		LDA	#0100H
		STA	!fade_speed
exit$		RTS
;---------------------------------------------------------------------
select_world	LDX	#world_number
		LDA	#4*100H+cursor_BY
		JMP	Calc_cursor
;---------------------------------------------------------------------
select_course	LDX	#map_pointer
		LDA	#4*100H+cursor_BY
		JMP	Calc_cursor
;*********************************************************************
;		SOUND TEST
;*********************************************************************
soundtest_init	
		JSR	Init_PPU
		SEP	#00100000B
		MEM8
		STZ	!4200H
		REP	#00100000B
		MEM16
		LDA	#sound_screen
		STA	<disp_addr+0
		JSR	clear_buffer
		LDY	#sound_sprite
		JSL	>Init_demokart
		SEP	#00100000B
		MEM8
		LDA	#81H
		STA	!4200H
		REP	#00100000B
		MEM16
;
		STZ	!sound_cursor		;W memory clear
		LDA	#0FFFFH
		STA	!trigger_p0
		STZ	!port_w0
		STZ	!port_w2
;
		JSR	ON_screen
		DB	11H
		RTS
;---------------------------------------------------------------------
soundtest_main	
;- - - - - - - - - - - - - - - - - - - - - - - -
		SEP	#00100000B
		MEM8			; port address write
		LDA	<button_status+0
		AND	#A_button
		BEQ	skip_0$
;- - - - - - - -- - - - - - - - - - - - ; port 0
		LDA	!port_no
		BNE	p1_skip$
		LDA	!port_w0	; |[g̃[N
		AND	!trigger_p0
		STA	!2140H
		STA	!damy_port0	;z|[g
;- - - - - - - -- - - - - - - - - - - - ; port 1
p1_skip$	LDA	!port_no
		CMP	#1
		BNE	p2_skip$
		LDA	!port_w1
		AND	!trigger_p1
		STA	!2141H
		STA	!damy_port1	
;- - - - - - - -- - - - - - - - - - - - ; port 2,3
p2_skip$
		LDX	!port_w2
		STX	!2142H
		STX	!damy_port2
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;`{^Ƃ			; t[gK͖
	;;	LDA	#00001111B	; ʂSrbggK
		LDA	#00000000B	; ʂWrbggK
		STA	!trigger_p0
		LDA	#11000000B	; ʂUrbggK
		STA	!trigger_p1
		BRA	skip_1$
;- - - - - - - - - - - - - - - - - - - - - - - -
;`{^ȂƂ
skip_0$		LDA	#0FFH		; gKLɂ
		STA	!trigger_p0
		STA	!trigger_p1
skip_1$
;- - - - - - - - - - - - - - - - - - - - - - - -
		REP	#00100000B
		MEM16			; ZNg烏[N͂ONA
		LDA	<button_trigger+0
		AND	#SL_button
		BEQ	skip_2$
		STZ	!port_w0
		STZ	!port_w2
skip_2$
;- - - - - - - - - - - - - - - - - - - - - - - -
		JSR	clear_buffer		; 
		LDX	#sound_data		
		JSR	Set_text
;
		LDY	#cursor_data
		LDX	#sound_cursor
		JSR	Box_cursor
;;
		LDY	!sound_cursor
		LDA	#0AH
		JSR	Div
		STA	!port_no	; 0,1,2,3
		STY	!bit_no
;- - - - - - - - - - - - - - - - - - - - - - - -
		CLC
		ADC	#port_w0
		TAX			; address
		DEY
		DEY	
		BPL	format_bit
;- - - - - - - - - - - - - 
format_byte	LDA	#cursor_BY	; cursol check
		INY
		BNE	skip$
		JSR	Digit_L_cursor
		BRA	common_skip
skip$		JSR	Digit_H_cursor
		BRA	common_skip
;- - - - - - - - - - - - - 
format_bit	LDA	#cursor_BY	; cursor check
		JSR	Bit_cursor	; Y = bit number
common_skip
;- - - - - - - - - - - - - - - - - - - - - - - -
	;;	LDY	#0c7H*2
	;;	LDA	!sound_cursor
	;;	JSR	Emit_byte
;
		LDY	#0eeh*2
		LDA	!port_w0
		AND	#00FFH
		JSR	Emit_byte
		LDY	#0f7h*2
		LDA	!port_w0
		AND	#00FFH
		JSR	Emit_bit
;
		LDY	#10eh*2
		LDA	!port_w1
		AND	#00FFH
		JSR	Emit_byte
		LDY	#117h*2
		LDA	!port_w1
		AND	#00FFH
		JSR	Emit_bit
;
		LDY	#12eh*2
		LDA	!port_w2
		AND	#00FFH
		JSR	Emit_byte
		LDY	#137h*2
		LDA	!port_w2
		AND	#00FFH
		JSR	Emit_bit
;
		LDY	#14eh*2
		LDA	!port_w3
		AND	#00FFH
		JSR	Emit_byte
		LDY	#157h*2
		LDA	!port_w3
		AND	#00FFH
		JSR	Emit_bit
;
		LDY	#2ebh*2
		LDA	!damy_port0
		AND	#00FFH
		JSR	Emit_byte
		LDY	#2eeh*2
		LDA	!damy_port1
		AND	#00FFH
		JSR	Emit_byte
		LDY	#2f1h*2
		LDA	!damy_port2
		AND	#00FFH
		JSR	Emit_byte
		LDY	#2f4h*2
		LDA	!damy_port3
		AND	#00FFH
		JSR	Emit_byte
;
		LDA	!port_no
		ASL	A
		TAX
		LDY	!bit_no
		LDA	!sound_position,Y
		AND	#00FFH	
		CLC
		ADC	!sound_offset,X
		ASL	A			; *2
		TAY
;;
		LDA	<edit_frame
		AND	#008H
		BEQ	frash$
		LDA	#1c00H+(sp&00FFH)
		STA	[<disp_addr],Y
frash$
;
	;;	LDA	!1F30H
	;;	LDY	!1F32H
	;;	STA	[<disp_addr],Y
;

		LDY	#0CH
loop$		
		LDX	!rotate_data+2,Y
		LDA	<0,X
		LDX	!rotate_data+0,Y
		AND	#00FFH
		BEQ	s1$
		JSR	rotate_kart
		BRA	s2$
s1$		JSR	stop_kart	
s2$		DEY
		DEY
		DEY
		DEY
		BPL	loop$
;	
		LDA	#200H
		STA	<sprite_count
		JSL	>Set_demokart
;
		RTS
;---------------------------------------------------------------------
rotate_data	dw	player_r2,damy_port0
		dw	player_r3,damy_port1
		dw	player_r4,damy_port2
		dw	player_r5,damy_port3
;- - - - - - - - - - - - - - - - - - - - - - - - 
rotate_kart	LDA	<_poseQ,X
		BRA	skip_kart
stop_kart	LDA	<_poseQ,X
		CMP	#8000H
		BEQ	exit_kart
skip_kart	CLC
		ADC	#0400H
		STA	<_poseQ,X
exit_kart	RTS
;---------------------------------------------------------------------
sound_position	DB	0dh,0eh
		DB	10h,11h,12h,13h,14h,15h,16h,17h
sound_offset	DW	0e0h,0100h,0120h,0140h
;---------------------------------------------------------------------
sound_sprite	DW	player_r0,0010H,00b0H,08000H
		DW	player_r1,0030H,00b0H,08000H
		DW	player_r2,0050H,00b0H,08000H
		DW	player_r3,0070H,00b0H,08000H
		DW	player_r4,0090H,00b0H,08000H
		DW	player_r5,00b0H,00b0H,08000H
		DW	player_r6,00d0H,00b0H,08000H
		DW	player_r7,00f0H,00b0H,08000H
		DW	0
;*********************************************************************
;		J[\t[ړ ( BOX TYPE )
;*********************************************************************
;		X = J[\̃[N index
;		Y = J[\̃f[^ index
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Box_cursor	STY	<work
		LDY	<0,X
		LDA	<repeat_trigger+0
;- - - - - - - - - - - - - - - - - 
up$		BIT	#UP_button
		BEQ	down$
		LDA	(<work),Y
		AND	#Uon
		BEQ	exit$
		LDA	#-0AH		; addition data
		BRA	set$
;- - - - - - - - - - - - - - - - - 
down$		BIT	#DW_button
		BEQ	left$
		LDA	(<work),Y
		AND	#Don
		BEQ	exit$
		LDA	#0ah		; addition data
		BRA	set$
;- - - - - - - - - - - - - - - - - 
left$		BIT	#LF_button
		BEQ	right$
		LDA	(<work),Y
		AND	#Lon
		BEQ	exit$
		LDA	#-1
		BRA	set$
;- - - - - - - - - - - - - - - - - 
right$		BIT	#RT_button
		BEQ	exit$
		LDA	(<work),Y
		AND	#Ron
		BEQ	exit$
		LDA	#1
;- - - - - - - - - - - - - - - - - 
set$		CLC
		ADC	<0,X
		STA	<0,X
exit$		LDA	(<work),Y
		AND	#000FH
		ASL	A
		RTS
;=====================================================================
Uon	EQU	10000000B
Don	EQU	01000000B
Lon	EQU	00100000B
Ron	EQU	00010000B
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
ar0	EQU	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
cursor_data
	DB	Don+Ron+ar0		;(00)	HEX	2140
	DB	Don+Lon+Ron+ar0		;(01)
	DB	Don+Lon+Ron+ar0		;(02)	BIN
	DB	Don+Lon+Ron+ar0		;(03)
	DB	Don+Lon+Ron+ar0		;(04)
	DB	Don+Lon+Ron+ar0		;(05)
	DB	Don+Lon+Ron+ar0		;(06)
	DB	Don+Lon+Ron+ar0		;(07)
	DB	Don+Lon+Ron+ar0		;(08)
	DB	Don+Lon+ar0		;(09)

	DB	Uon+Don+Ron+ar0		;(0a)	HEX	2141
	DB	Uon+Don+Lon+Ron+ar0	;(0b)
	DB	Uon+Don+Lon+Ron+ar0	;(0c)	BIN
	DB	Uon+Don+Lon+Ron+ar0	;(0d)
	DB	Uon+Don+Lon+Ron+ar0	;(0e)
	DB	Uon+Don+Lon+Ron+ar0	;(0f)
	DB	Uon+Don+Lon+Ron+ar0	;(10)
	DB	Uon+Don+Lon+Ron+ar0	;(11)
	DB	Uon+Don+Lon+Ron+ar0	;(12)
	DB	Uon+Don+Lon+ar0		;(13)

	DB	Uon+Don+Ron+ar0		;(14)	HEX	2141
	DB	Uon+Don+Lon+Ron+ar0	;(15)
	DB	Uon+Don+Lon+Ron+ar0	;(16)	BIN
	DB	Uon+Don+Lon+Ron+ar0	;(17)
	DB	Uon+Don+Lon+Ron+ar0	;(18)
	DB	Uon+Don+Lon+Ron+ar0	;(19)
	DB	Uon+Don+Lon+Ron+ar0	;(1a)
	DB	Uon+Don+Lon+Ron+ar0	;(1b)
	DB	Uon+Don+Lon+Ron+ar0	;(1c)
	DB	Uon+Don+Lon+ar0		;(1d)

	DB	Uon+Ron+ar0		;(1e)	HEX	2143
	DB	Uon+Lon+Ron+ar0		;(1f)
	DB	Uon+Lon+Ron+ar0		;(20)	BIN
	DB	Uon+Lon+Ron+ar0		;(21)
	DB	Uon+Lon+Ron+ar0		;(22)
	DB	Uon+Lon+Ron+ar0		;(23)
	DB	Uon+Lon+Ron+ar0		;(24)
	DB	Uon+Lon+Ron+ar0		;(25)
	DB	Uon+Lon+Ron+ar0		;(26)
	DB	Uon+Lon+ar0		;(27)

;*********************************************************************
;		OBJ LOOP TEST
;*********************************************************************
objtest_init	JSR	Init_PPU
		SEP	#00100000B
		MEM8
		STZ	!4200H
		REP	#00100000B
		MEM16
		LDX	#clear_test
		JSL	>Clear_VRAM
		LDY	#test_data
		JSL	>Init_demokart
		JSR	ON_screen
		DB	010H
		SEP	#00100000B
		MEM8
		LDA	#81H
		STA	!4200H
		REP	#00100000B
		MEM16
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - -
test_data	DW	player_r0,0020H,0030H,00000H
		DW	player_r1,0030H,0040H,00000H
		DW	player_r2,0040H,0050H,08000H
		DW	player_r3,0050H,0060H,04000H
		DW	player_r4,0060H,0070H,0C000H
		DW	player_r5,0070H,0080H,09000H
		DW	player_r6,0080H,0090H,0a000H
		DW	player_r7,0090H,00a0H,0b000H
		DW	0
;- - - - - - - - - - - - - - - - - - - - - - - - - -
objtest_main
		JSL	>DMA_demokart
;
		LDX	#player_r0
		CLC
		LDA	<_poseQ,X
		ADC	#0400H	
		STA	<_poseQ,X
;
		LDX	#player_r1
		CLC
		LDA	<_poseQ,X
		ADC	#0400H	
		STA	<_poseQ,X
;
		LDX	#player_r2
		CLC
		LDA	<_poseQ,X
		ADC	#0400H	
		STA	<_poseQ,X
;
		LDX	#player_r3
		CLC
		LDA	<_poseQ,X
		ADC	#0400H	
		STA	<_poseQ,X
;


		LDX	#200H
		LDY	#kame_data
		JSR	Test_sprite
		LDA	#0AAAAH
		STA	!400H

		LDA	#300H
		STA	<sprite_count
		JSL	>Set_demokart
;
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - -
kame_data	DB	4
		DW	08040H
		DW	3100H+6*200H
		DW	09040H
		DW	3102H+6*200H
		DW	0A040H
		DW	3104H+6*200H
		DW	0B040H
		DW	3106H+6*200H
;- - - - - - - - - - - - - - - - - - - - - - - - - -
clear_test	DW	0
		DW	5800H
		DW	0800H
;*********************************************************************
;		TITLE CONTROL
;*********************************************************************
clear_line	DB	1CH,sp,sp,sp,sp,sp,sp,sp,sp,sp,sp,sp,sp,ed

mode_select
mode_title	JSR	Set_mode
		DB	01H		; BG mode1
		DB	02H		; OBJ   character 4000H
		DB	44H		; BG1,2 character 4000H
		DB	77H		; BG3,4 character 7000H
		DB	70H		; BG1 screen address 7000H
;*********************************************************************
;		all_exit
;*********************************************************************
title_main
title_init	RTS
all_exit	RTS
battle_obj	LDX	#0		; #battle_select
		LDA	#battle_data
		JMP	Calc_cursor
bound_power	LDX	#0		; #mirror_param
		LDA	#cursor_BY
		JMP	Byte_cursor
big_mario	RTS
Xchenge		STA	<edit_status
Xexit		RTS
;####################################################################
;		ėp[`
;####################################################################
;*********************************************************************
;		eLXgq`l̃NA
;*********************************************************************
clear_buffer	LDA	#sp		; clear character
init_buffer	AND	#00FFH
		ORA	#1C00H		; attribute
		LDY	#07FEH
clear_loop	STA	[<disp_addr],Y
		DEY
		DEY
		BPL	clear_loop
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;####################################################################
;		BIG MARIO
;####################################################################
;*********************************************************************
;		big character 
;*********************************************************************
pose_0		EQU	buffer_char+2300H
;
pose_1		EQU	buffer_char+0100H
pose_2		EQU	buffer_char+0200H
pose_3		EQU	buffer_char+0300H
pose_4		EQU	buffer_char+1000H
pose_5		EQU	buffer_char+1100H
pose_6		EQU	buffer_char+1200H
pose_7		EQU	buffer_char+1300H
pose_8		EQU	buffer_char+2000H
pose_9		EQU	buffer_char+2100H
pose_A		EQU	buffer_char+2200H
;;
pose_B		EQU	buffer_char+5300H
;;
pose_1x		EQU	buffer_char+0100H+3000H
pose_2x		EQU	buffer_char+0200H+3000H
pose_3x		EQU	buffer_char+0300H+3000H
pose_4x		EQU	buffer_char+1000H+3000H
pose_5x		EQU	buffer_char+1100H+3000H
pose_6x		EQU	buffer_char+1200H+3000H
pose_7x		EQU	buffer_char+1300H+3000H
pose_8x		EQU	buffer_char+2000H+3000H
pose_9x		EQU	buffer_char+2100H+3000H
pose_Ax		EQU	buffer_char+2200H+3000H

;- - - - - - - - - - - - - - - - - - - - - - - - - - -
pose_data	
;
	DW	pose_0,screen_mario3
	DW	pose_1,screen_mario1
	DW	pose_2,screen_mario1
	DW	pose_3,screen_mario1
	DW	pose_4,screen_mario1
	DW	pose_5,screen_mario1
	DW	pose_6,screen_mario1
	DW	pose_7,screen_mario1
;
	DW	pose_8,screen_mario1
	DW	pose_8,screen_mario1
	DW	pose_9,screen_mario1
	DW	pose_9,screen_mario1
	DW	pose_A,screen_mario1
	DW	pose_A,screen_mario1
	DW	pose_B,screen_mario3
	DW	pose_B,screen_mario3
;
	DW	pose_B,screen_mario3
	DW	pose_B,screen_mario3
	DW	pose_Ax,screen_mario2
	DW	pose_Ax,screen_mario2
	DW	pose_9x,screen_mario2
	DW	pose_9x,screen_mario2
	DW	pose_8x,screen_mario2
	DW	pose_8x,screen_mario2
;
	DW	pose_7x,screen_mario2
	DW	pose_6x,screen_mario2
	DW	pose_5x,screen_mario2
	DW	pose_4x,screen_mario2
	DW	pose_3x,screen_mario2
	DW	pose_2x,screen_mario2
	DW	pose_1x,screen_mario2
	DW	pose_0,screen_mario3
;
;*********************************************************************
;		big character test main module
;*********************************************************************
bigtest_main	LDA	<system_SEQ
		ASL	A
		TAX
		JSR	(!bigtest_select,X)
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
bigtest_select	
;;
		DW	set_champ		; 0
		DW	next_trans		; 1

		DW	trans_character		; 2
		DW	next_trans		; 3
		DW	trans_character		; 4
		DW	next_trans		; 5
		DW	trans_character		; 6
		DW	next_trans		; 7
		DW	trans_character		; 8
		DW	next_trans		; 9
;;
		DW	trans_character		; a
		DW	next_trans		; b
		DW	trans_character		; c
		DW	next_trans		; d
		DW	trans_character		; e
		DW	next_trans		; f
		DW	trans_character		; 10
		DW	next_trans		; 11
;;
		DW	set_champ		; 12
;*********************************************************************
;		
;*********************************************************************

set_champ
;;;
		STZ	<system_SEQ
;;
		SEP	#00100000B
		MEM8
		LDA	#10H		; OBJ ON screen
		STA	!212CH
		REP	#00100000B
		MEM16
;;
		LDY	#6058H
		LDX	#MES_X
		JSR	OBJ_message
		LDY	#7038H
		LDX	#MES_Y
		JSR	OBJ_message
;;;
		LDA	!state_timer
		INC	A
		STA	!state_timer
		CMP	#240
		BNE	exit$
;;;
		INC	<system_SEQ
		STZ	!state_timer
exit$		RTS
;*********************************************************************
;		big character test initial module
;*********************************************************************
cv_data		DW	cv_mario
		DW	cv_mario
		DW	cv_luige
		DW	cv_koopa
		DW	cv_peach
		DW	cv_cong
		DW	cv_noko
		DW	cv_kino
		DW	cv_yossy
		DW	cv_mario
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
next_trans	SEP	#00100000B
		MEM8
		LDA	#80H
		STA	<ppu_control
		STA	!PPU_control
;;
		STZ	!NMI_control
;;
		LDA	#11H		; BG/OBJ ON screen
		STA	!212cH		
		REP	#00100000B
		MEM16
		LDY	<system_SEQ
		INY
		LDX	!cv_data,Y
		JSR	Buffer_write
		JSL	>CLEAR_SPRITE
		STZ	!message_ef
		STZ	!message_count
		STZ	!message_init
		SEP	#00100000B
		MEM8
;;
		LDA	#081H
		STA	!NMI_control
;;
		LDA	#0FH
		STA	<ppu_control
		INC	<system_SEQ		; +1
		REP	#00100000B
		MEM16
		RTS
;*********************************************************************
;		big character test main module
;*********************************************************************
trans_character
		JSR	Set_M7register
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
loop$		LDA	!roll_Q+1
		AND	#11111000B
		LSR	A
		TAX
		PHX			; >>
		LDY	!pose_data+0,X
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
		TYA
		LDX	#trans_1
		JSL	>Execute_TRANS
		TYA
		CLC
		ADC	#0400H
		LDX	#trans_2
		JSL	>Execute_TRANS
		TYA
		CLC
		ADC	#0800H
		LDX	#trans_3
		JSL	>Execute_TRANS
		TYA
		CLC
		ADC	#0C00H
		LDX	#trans_4
		JSL	>Execute_TRANS
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
trans_screen
		PLY			; <<
		LDX	!pose_data+2,Y
		JSR	Write_VRAM
;- - - - - - - - - - - - - - - - - - - - - - - - - - -

		INC	!roll_Q+1
		INC	!roll_Q+1

		LDA	<button_status
		AND	#A_button+X_button
		BEQ	skip$
		INC	!zoom_param
		AND	#X_button
		BEQ	skip$
		DEC	!zoom_param
		DEC	!zoom_param
skip$	
		LDA	<button_status
		AND	#SL_button
		BEQ	skip_1$
		LDA	#0100H
		STA	!zoom_param
skip_1$
		LDA	!zoom_param
		STA	!rotation_a
		STA	!rotation_d
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
		LDA	#08000H		; flag ON !!
		TSB	!message_ef	
		LDA	!message_init+1
		AND	#00FFH
		STA	!message_count	; counter SET !!
		LDA	#00080H
		CLC
		ADC	!message_init
		STA	!message_init	; counter INC !!
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
		LDY	#1010H
		LDX	#MES_A
		JSR	Set_mes
		LDY	#1810H
		LDX	#MES_B
		JSR	Set_mes
		LDY	#2010H
		LDX	#MES_C
		JSR	Set_mes
		LDY	#3010H
		LDX	#MES_D
		JSR	Set_mes
		LDY	#3810H
		LDX	#MES_E
		JSR	Set_mes
		LDY	#4010H
		LDX	#MES_F
		JSR	Set_mes
		LDY	#4810H
		LDX	#MES_G
		JSR	Set_mes
		LDY	#5010H
		LDX	#MES_H
		JSR	Set_mes
		LDY	#5810H
		LDX	#MES_I
		JSR	Set_mes
		LDY	#6010H
		LDX	#MES_J
		JSR	Set_mes
		LDY	#6810H
		LDX	#MES_K
		JSR	Set_mes
		INC	<system_SEQ
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
bigmario_1000	RTS
;---------------------------------------------------------------------
Set_mes		JSR	OBJ_message
		LDA	#04000H
		TRB	!message_ef
		BNE	skip$
		RTS
skip$		PLA			;<< del return value	
		JMP	bigmario_1000
;---------------------------------------------------------------------

MES_X	DB	28H,_m,_a,_r,_i,_o,sp,_k,_a,_r,_t,ed
MES_Y	DB	28H,_w,_o,_r,_l,_d,sp,_c,_h,_a,_m,_p,_i,_o,_n,_s,_h,_i,_p,ed

MES_A	DB	28H,_b,_e,_n,_e,_t,_o,_n,sp,_b,_1,_9,_1,ed
MES_B	DB	28H,_e,_n,_g,_i,_n,_e,sp,_f,_o,_r,_d,sp,_h,_b,sp,_s,_e,_r,_i,_e,_s,sp,_v,ed
MES_C	DB	28H,_7,_5,_d,_e,_b,sp,_v,_8,sp,_3,_4,_9,_4,_c,_c,ed
MES_D	DB	28H,_f,_e,_a,_t,_u,_r,_i,_n,_g,ed
MES_E	DB	28H,_g,_e,_a,_r,sp,_b,_o,_x,ed
MES_F	DB	28H,sp,_b,_e,_n,_e,_t,_t,_o,_n,ed
MES_G	DB	28H,_t,_i,_r,_e,ed
MES_H	DB	28H,sp,_p,_i,_r,_e,_l,_l,_i,ed
MES_I	DB	28H,_g,_a,_s,_o,_l,_i,_n,_e,ed
MES_J	DB	28H,sp,_m,_o,_b,_i,_l,ed
MES_K	DB	28H,sp,sp,sp,sp,ed

;---------------------------------------------------------------------
bigtest_init	JSR	Init_PPU
		LDX	#mario_clear
		JSL	>Clear_VRAM
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; convert mario character
		LDX	#cv_mario
		JSR	Buffer_write
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		JSR	Init_mode7
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		LDA	#0100H
		STA	!zoom_param
		STZ	<system_SEQ
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		JSR	ON_screen
		DB	11H
		RTS
;---------------------------------------------------------------------
OBJ_mario	EQU	04A000H
OBJ_koopa	EQU	05A000H
OBJ_peach	EQU	06A000H
OBJ_cong	EQU	07A000H
OBJ_luige	EQU	08A000H
OBJ_noko	EQU	09A000H
OBJ_kino	EQU	0AA000H
OBJ_yossy	EQU	0BA000H
cg_mario	EQU	1
cg_luige	EQU	2
cg_koopa	EQU	0
cg_peach	EQU	3
cg_cong		EQU	3
cg_noko		EQU	2
cg_kino		EQU	1
cg_yossy	EQU	0
;----------------------------------------------------------------------
cv_mario	DW	0
		DB	0C0H	
		DL	OBJ_mario
		DB	08H+cg_mario
		DB	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
cv_luige	DW	0
		DB	0C0H	
		DL	OBJ_luige
		DB	08H+cg_luige
		DB	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
cv_koopa	DW	0
		DB	0C0H	
		DL	OBJ_koopa
		DB	08H+cg_koopa
		DB	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
cv_peach	DW	0
		DB	0C0H	
		DL	OBJ_peach
		DB	08H+cg_peach
		DB	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
cv_cong		DW	0
		DB	0C0H	
		DL	OBJ_cong
		DB	08H+cg_cong
		DB	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
cv_noko		DW	0
		DB	0C0H	
		DL	OBJ_noko
		DB	08H+cg_noko
		DB	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
cv_kino		DW	0
		DB	0C0H	
		DL	OBJ_kino
		DB	08H+cg_kino
		DB	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
cv_yossy	DW	0
		DB	0C0H	
		DL	OBJ_yossy
		DB	08H+cg_yossy
		DB	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;*********************************************************************
;		MODE7 BUFFER FLIP
;*********************************************************************
Buffer_write	JSR	Conv_m1m7		; set character data
		LDX	#buffer_char+0
		LDY	#buffer_char+3000H
		LDA	#3000H
		JSR	M7flip
		JSR	sp_mode
		RTS
;*********************************************************************
;		initial data
;*********************************************************************
cy_offset_init	EQU	98H
start_scr	EQU	80EH
screen_mario1	DW	start_scr+000H
		DB	4
		DB	040h,041h,042h,043h
		DW	start_scr+080H
		DB	4
		DB	044h,045h,046h,047h
		DW	start_scr+100H
		DB	4
		DB	048h,049h,04ah,04bh
		DW	start_scr+180H
		DB	4
		DB	04ch,04dh,04eh,04fh
		DW	0ffffH		
;---------------------------------------------------------------------
screen_mario2	
		DW	start_scr+000H
		DB	4
		DB	043h,042h,041h,040h
		DW	start_scr+080H
		DB	4
		DB	047h,046h,045h,044h
		DW	start_scr+100H
		DB	4
		DB	04bh,04ah,049h,048h
		DW	start_scr+180H
		DB	4
		DB	04fh,04eh,04dh,04ch
		DW	0ffffH
;--------------------------------------------------------------------
screen_mario3	
		DW	start_scr+000H
		DB	4
		DB	040h,041h,043h,042h
		DW	start_scr+080H
		DB	4
		DB	044h,045h,047h,046h
		DW	start_scr+100H
		DB	4
		DB	048h,049h,04bh,04ah
		DW	start_scr+180H
		DB	4
		DB	04ch,04dh,04fh,04eh
		DW	0ffffH		
;---------------------------------------------------------------------
trans_1		DB	80H
		DW	1000H
		DW	1900H
		DB	buffer_char/65536
		DW	100H
trans_2		DB	80H
		DW	1100H
		DW	1900H
		DB	buffer_char/65536
		DW	100H
trans_3		DB	80H
		DW	1200H
		DW	1900H
		DB	buffer_char/65536
		DW	100H
trans_4		DB	80H
		DW	1300H
		DW	1900H
		DB	buffer_char/65536
		DW	100H
;--------------------------------------------------------------------
mario_clear	DW	0000H ( 2 byte clear patern )
		DW	0000H ( VRAM start address )
		DW	4000H ( VRAM clear count )
;--------------------------------------------------------------------
set_m7char	DB	80H
		DW	0000H
		DW	1900H
		DL	buffer_char
		DW	3000H
;--------------------------------------------------------------------
;
;
;
;
;
;*********************************************************************
;		MODE7 BUFFER FLIP
;*********************************************************************
;		LDX	#read_address		; nomal char 
;		LDY	#write_address		; Hflip char
;		LDA	#byte_count
;		JSR	M7flip
;--------------------------------------------------------------------
M7flip		PHB
		PEA	7F7FH
		PLB
		PLB
		LSR	A		
		LSR	A
		LSR	A
		STA	<0		; 1/8 count
;- - - - - - - - - - - - - - - - - - -  ; H flip mode7
loop$		LDA	!0,X		;
		XBA		
		STA	!6,Y
		LDA	!2,X
		XBA
		STA	!4,Y
		LDA	!4,X
		XBA
		STA	!2,Y
		LDA	!6,X
		XBA
		STA	!0,Y
		TXA
		ADC	#8
		TAX
		TYA
		ADC	#8
		TAY
		DEC	<0
		BNE	loop$
;- - - - - - - - - - - - - - - - - - - - 
		PLB
		RTS
;--------------------------------------------------------------------

sp_mode		PHB

		LDX	#buffer_char+0+0000H
		LDY	#buffer_char+2300H+0000H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+0400H
		LDY	#buffer_char+2300H+0400H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+0800H
		LDY	#buffer_char+2300H+0800H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+0C00H
		LDY	#buffer_char+2300H+0C00H
		LDA	#80H-1
		MVN	#7FH,#7FH
				
		LDX	#buffer_char+0+3000H
		LDY	#buffer_char+2380H+0000H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+3400H
		LDY	#buffer_char+2380H+0400H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+3800H
		LDY	#buffer_char+2380H+0800H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+3C00H
		LDY	#buffer_char+2380H+0C00H
		LDA	#80H-1
		MVN	#7FH,#7FH

		LDX	#buffer_char+0+0080H
		LDY	#buffer_char+5300H+0000H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+0480H
		LDY	#buffer_char+5300H+0400H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+0880H
		LDY	#buffer_char+5300H+0800H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+0C80H
		LDY	#buffer_char+5300H+0C00H
		LDA	#80H-1
		MVN	#7FH,#7FH

		LDX	#buffer_char+0+03080H
		LDY	#buffer_char+5380H+0000H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+03480H
		LDY	#buffer_char+5380H+0400H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+03880H
		LDY	#buffer_char+5380H+0800H
		LDA	#80H-1
		MVN	#7FH,#7FH
		LDX	#buffer_char+0+03C80H
		LDY	#buffer_char+5380H+0C00H
		LDA	#80H-1
		MVN	#7FH,#7FH
		
		PLB
		RTS

;####################################################################
;		mode7 character test system 
;####################################################################
;*********************************************************************
;		mode 7 charcter test
;*********************************************************************
m7test_init	JSR	Init_PPU
		JSR	Clear_M7screen
		JSR	Init_mode7
		JSR	test_M7screen
		JSR	ON_screen
		DB	01H
		RTS
;--------------------------------------------------------------------
m7test_main	RTS
;---------------------------------------------------------------------
;
;
;
;####################################################################
;		color data test system 
;####################################################################
;*********************************************************************
;		color test system
;*********************************************************************
cgtest_init	JSR	Init_PPU
		JSR	Clear_M7screen
		JSR	Init_mode7
		JSR	test_M7CGchar
		JSR	test_M7screen
		JSR	ON_screen
		DB	01H
;--------------------------------------------------------------------
cgtest_main	RTS
;---------------------------------------------------------------------
;
;
;
;####################################################################
;		INITIALIZE
;####################################################################
;*********************************************************************
;		CG character data(mode7) set
;*********************************************************************
test_M7CGchar	SEP	#00110000B
		MEM8
		IDX8
		LDA	#80H			;B	hi inc
		STA	!Screen_step		;B
		STZ	!Screen_address+0	;B
		STZ	!Screen_address+1	;B
		LDA	#0			;B
loop_256char	LDX	#64			;B	1 character
loop_1char	STA	!Screen_write+1		;B	2119H
		DEX				;B
		BNE	loop_1char		;B
		INC	A			;B
		BNE	loop_256char		;
		REP	#00110000B
		MEM16
		IDX16
		RTS
;*********************************************************************
;		mode7 screen data set
;*********************************************************************
M7start		EQU	308H
;--------------------------------------------------------------------
test_M7screen	SEP	#00100000B
		MEM8
		STZ	!Screen_step
		LDX	#M7start
		STX	!Screen_address
		LDX	#10H
		LDA	#0
;------------------------------------------------
test_M7_0	LDY	#10H
test_M7_100	STA	!Screen_write
		INC	A
		DEY
		BNE	test_M7_100
		LDY	#70H
test_M7_200	STZ	!Screen_write
		DEY
		BNE	test_M7_200
		DEX
		BNE	test_M7_0
;------------------------------------------------
		REP	#00100000B
		MEM16
		RTS
;*********************************************************************
;		mode initial
;*********************************************************************
mode_3_init	JSR	test_write
		JSR	Set_mode
		DB	03	; mode 3 
		DB	02H	; 4000H OBJ character 
		DB	06H	; 6000H BG1 character
		DB	00H	; 
		DB	50H	; 5000H BG1 screen
;--------------------------------------------------------------------
test_write	LDA	#80H
		STA	!Screen_step
		LDA	#5000H
		STA	!Screen_address
		LDA	#0
test_loop	STA	!Screen_write
		INC	A
		CMP	#0100H
		BNE	test_loop
		RTS
;--------------------------------------------------------------------
Clear_M7screen	LDX	#clear_m7
		JSL	>Clear_VRAMlow
		RTS
;--------------------------------------------------------------------
clear_m7	DW	0000H
		DW	0000H
		DW	4000H
;**********************************************************************
;		DISPLAY BIG MARIO
;**********************************************************************
Disp_mario	SEP	#00100000B
		MEM8
		STZ	!Screen_step
;
disp_next	LDY	!0,X			; address
		BMI	disp_exit
		STY	!Screen_address
		INX
		INX
		LDA	!0,X			; counter
		INX
		STA	<work
;
disp_loop	LDA	!0,X			; data
		STA	!Screen_write
		INX
		DEC	<work
		BNE	disp_loop
		BRA	disp_next
;
disp_exit	REP	#00100000B
		MEM16
		RTS
;####################################################################
;		TEST PROGRAM
;####################################################################
;*********************************************************************
;		Set test character
;*********************************************************************
;		SET DEBUG OBJ CHARACTER SET
;---------------------------------------------------------------------
moji_buffer	EQU	7FA000H		;
VRAM_alpha	EQU	4000H		; 4000H - 4BFFH
VRAM_nuki		
COUNT_alpha	EQU	1800H		; 256 char
;---------------------------------------------------------------------
alpha		DB	80H			; 1 Screen step
		DW	VRAM_alpha		; 2 VRAM address
		DW	1801H			; 4 DMA parameter
		DL	moji_buffer		; 6 A bus address
		DW	COUNT_alpha		; 9 byte count
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
nuki_data	DW	0000H
		DW	4C00H
		DW	0400H
;---------------------------------------------------------------------
Set_alpha	LDX	#alpha
		JSL	>Execute_VRAM
		LDX	#nuki_data
		JSL	>Clear_VRAM
		RTS
;####################################################################
;		LIBRARY
;####################################################################
;**********************************************************************
;		data modify
;**********************************************************************
debug_mask	DB	00FH,00FH,0F0H,0F0H
debug_data	DB	00FH,001H,0F0H,010H
;----------------------------------------------------------------------
		SEP	#00110000B
		MEM8
		IDX8
		;JSR				; read
		STA	<work			;B
		CLC
		ADC	!debug_data,Y		;B
		EOR	<work
		AND	!debug_mask,Y		;B
		EOR	<work
		;JSR				; write
		REP	#00110000B
		MEM16
		IDX16
		RTS
;**********************************************************************
;		cursol move
;**********************************************************************
;		A = low(max_data) high(keypatern)
;		X = point register
;		Y = data register
;----------------------------------------------------------------------
cursor_check	DB	UP_button/256,DW_button/256
		DB	LF_button/256,RT_button/256
		DB	Y_button/256,B_button/256
;----------------------------------------------------------------------
Calc_cursor	STA	<work			; A data 
		AND	#00FFH
		ASL	A
		TAY
		SEP	#00100000B
		MEM8
		LDA	<repeat_trigger+1	; (-)
		AND	!cursor_check+0,Y
		BEQ	cursor_skip
		LDA	<0,X
		BEQ	cursor_skip
		DEC	<0,X
cursor_skip	LDA	<repeat_trigger+1	; (+)
		AND	!cursor_check+1,Y
		BEQ	cursor_exit
		LDA	<0,X
		CMP	<work+1
		BCS	cursor_exit
		INC	<0,X
cursor_exit	REP	#00100000B
		MEM16
		RTS
;----------------------------------------------------------------------
Word_cursor	TAY
		LDA	#1			; nomal 
		STA	<work
		LDA	<button_status+0
		AND	#L_button+R_button
		BEQ	word_skip
		LDA	#20H			; high speed
		STA	<work
word_skip	TYA
		AND	#00FFH
		ASL	A
		TAY
		SEP	#00100000B
		MEM8
		LDA	<repeat_trigger+1	; (-)
		AND	!cursor_check+0,Y
		BEQ	word_skip2
		REP	#00100000B
		MEM16
		LDA	<0,X			; read chenge data
		SEC
		SBC	<work
		STA	<0,X
word_skip2	SEP	#00100000B
		MEM8
		LDA	<repeat_trigger+1	; (+)
		AND	!cursor_check+1,Y
		REP	#00100000B
		MEM16
		BEQ	word_exit
		LDA	<0,X			; read chenge data
		CLC
		ADC	<work
		STA	<0,X
word_exit	RTS
;--------------------------------------------------------------------
Byte_cursor	AND	#00FFH
		ASL	A
		TAY
		SEP	#00100000B
		MEM8
		LDA	<repeat_trigger+1	; (-)
		AND	!cursor_check+0,Y
		BEQ	byte_skip
		DEC	<0,X
byte_skip	LDA	<repeat_trigger+1	; (+)
		AND	!cursor_check+1,Y
		BEQ	byte_exit
		INC	<0,X
byte_exit	REP	#00100000B
		MEM16
		RTS
;--------------------------------------------------------------------
bit_data	DB	80h,40h,20h,10h,8h,4h,2h,1h
;--------------------------------------------------------------------
Bit_cursor	STY	<0
		AND	#000FH
		ASL	A
		TAY
		SEP	#00100000B
		MEM8
		LDA	!cursor_check+0,Y
		ORA	!cursor_check+1,Y
		AND	<repeat_trigger+1	; (+)
		BEQ	exit$
		LDY	<0
		LDA	!bit_data,Y
		EOR	<0,X
		STA	<0,X
exit$		REP	#00100000B
		MEM16
		RTS
;--------------------------------------------------------------------
Digit_L_cursor	AND	#000FH
		ASL	A
		TAY
		SEP	#00100000B
		MEM8
		LDA	<repeat_trigger+1	; (-)
		AND	!cursor_check+0,Y
		BEQ	skip$		
		LDA	#-1
		BRA	set$
skip$		LDA	<repeat_trigger+1	; (+)
		AND	!cursor_check+1,Y
		BEQ	exit$
		LDA	#01H
set$		CLC
		ADC	<0,X
		EOR	<0,X
		AND	#0FH
		EOR	<0,X
		STA	<0,X
exit$		REP	#00100000B
		MEM16
		RTS
;--------------------------------------------------------------------
Digit_H_cursor	AND	#000FH
		ASL	A
		TAY
		SEP	#00100000B
		MEM8
		LDA	<repeat_trigger+1	; (-)
		AND	!cursor_check+0,Y
		BEQ	skip$		
		LDA	#-10H
		BRA	set$
skip$		LDA	<repeat_trigger+1	; (+)
		AND	!cursor_check+1,Y
		BEQ	exit$
		LDA	#010H
set$		CLC
		ADC	<0,X
		EOR	<0,X
		AND	#0F0H
		EOR	<0,X
		STA	<0,X
exit$		REP	#00100000B
		MEM16
		RTS
;--------------------------------------------------------------------
;		cont,inc,-limit,+limit
;--------------------------------------------------------------------
Scroll_cursor	

;- - - - - 
		LDA	<button_status+0
		AND	#L_button
		BNE	skip$
		LDA	#repeat_trigger+1
		BRA	set$
skip$		LDA	#button_status+1
set$		STA	<trigger_work
;- - - - - 
		LDA	!1,Y		; read 
		AND	#00FFH
		STA	<work
		LDA	!2,Y
		STA	<data_limit
		LDA	!4,Y
		STA	<data_offset
		LDA	<0,X
		SEC
		SBC	<data_offset
		STA	<0,X
		LDA	!0,Y			
		ASL	A
		AND	#00FFH
		TAY
;;
		SEP	#00100000B
		MEM8
		LDA	(<trigger_work)
		AND	!cursor_check+0,Y
		BEQ	scroll_skip
		REP	#00100000B
		MEM16
		LDA	<0,X			; read chenge data
		SEC
		SBC	<work
		BMI	scroll_skip
		STA	<0,X
scroll_skip	SEP	#00100000B
		MEM8
;- - - - - - - - - - 
		LDA	(<trigger_work)
		AND	!cursor_check+1,Y
		REP	#00100000B
		MEM16
		BEQ	scroll_exit
		LDA	<0,X			; read chenge data
		CLC
		ADC	<work
		CMP	<data_limit
		BCS	scroll_exit
		STA	<0,X
scroll_exit	
		LDA	<0,X
		CLC
		ADC	<data_offset
		STA	<0,X
		RTS
;**********************************************************************
;		hex number ON screen
;**********************************************************************
;		Y = display address offset
;		A = work 
;----------------------------------------------------------------------
Emit_bit	LDX	#8		
		STX	<work
loop$		LDX	#0
		LSR	A		; bit ON ?
		BCC	skip$		; no
		INX
skip$		PHA			;>>
		TXA
		JSR	Emit_digit
		PLA			;<<
		DEC	<work
		BNE	loop$
;
		RTS
;----------------------------------------------------------------------
Emit_word	PHA				;>>
		JSR	Emit_byte
		PLA				;<<
		XBA
Emit_byte	PHA				;>>
		JSR	Emit_digit
		PLA				;<<
		LSR	A			;W
		LSR	A			;W
		LSR	A			;W
		LSR	A			;W
Emit_digit	SEP	#00100000B
		MEM8
		AND	#0FH
	;;;	ORA	#number_char_BG
		STA	[<disp_addr],Y		;W
		REP	#00100000B
		MEM16
		DEY				;W
		DEY				;W
		RTS
;----------------------------------------------------------------------
;		Y = display position
;		A = work 
;----------------------------------------------------------------------
OBJ_word	PHA				;>>
		JSR	OBJ_byte
		PLA				;<<
		XBA
OBJ_byte	PHA				;>>
		JSR	OBJ_digit
		PLA				;<<
		LSR	A			;W
		LSR	A			;W
		LSR	A			;W
		LSR	A			;W
OBJ_digit	AND	#0FH
OBJ_set		ORA	#2800H
		LDX	<sprite_count
		STA	<sprite_C,X
		STY	<sprite_H,X
		TYA
		SEC
		SBC	#8			; position dec
		TAY
		INX
		INX
		INX
		INX
		STX	<sprite_count		
		RTS
;----------------------------------------------------------------------
;		Y = display position
;		X = data work 
;----------------------------------------------------------------------
OBJ_message	LDA	!0,X
		AND	#00FFH
		XBA
		STA	<obj_attr
		BRA	entry$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
loop$		PHX
		ORA	<obj_attr		; attribute check
		LDX	<sprite_count
		STA	<sprite_C,X
		STY	<sprite_H,X
		TYA
		CLC
		ADC	#8			; position inc
		TAY
		INX
		INX
		INX
		INX
		STX	<sprite_count		
		PLX
		INX				; param inc
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
entry$		LDA	!message_ef		; flag check!!!!
		BPL	skip_1$
		DEC	!message_count
		BPL	skip_1$
		ORA	#04000H
		STA	!message_ef
		BRA	exit$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
skip_1$		LDA	!1,X			; data read
		AND	#0FFH
		CMP	#0FFH			; end code ?
		BNE	loop$
exit$		RTS
;**********************************************************************
;		text message ON screen
;**********************************************************************
;		LDX	#PP
;		JSR	 Set_text
;PP		DW	DP,ADR
;		DW	DP,ADR,.....,0
;DP		DB	attr		;(format patern)
;		DB	data,data,data,data,0FFH
;----------------------------------------------------------------------
;		LDY	#BG_POSITION
;		LDX	#DP
;		JSR	Call_text
;----------------------------------------------------------------------
Set_text	LDA	!0,X		;(X=PP)
		BEQ	exit_text
		INX
		INX
		LDY	!0,X		;(Y=BG address)
		INX
		INX
		PHX
		TAX			;(X=DP)
		JSR	Call_text
		PLX
		BRA	Set_text
;----------------------------------------------------------------------
Call_text	SEP	#00100000B
		MEM8
		LDA	!0,X
		INX
		STA	<temp		; attribute or flag
loop_text	LDA	!0,X
		INX
		CMP	#0FEH		; FE or FF ?
		BCS	escape_text	; yes
		STA	[<disp_addr],Y
		INY
		LDA	<temp
		STA	[<disp_addr],Y
		INY
		BRA	loop_text
escape_text	INC	A		; FF=END ?
		BNE	Call_text	; no
		REP	#00100000B
		MEM16
exit_text	RTS
;**********************************************************************
;	convert mode1 character -> mode7 character
;**********************************************************************
buffer_char	EQU	7F8000H
;----------------------------------------------------------------------
;<<exsample>>
;		LDX	#DP
;		JSR	Conv_m1m7
;<<format>>
;		DW	1000H		;(0) buffer pointer
;
;		DB	2		; character loop counter
;		DL	48000H		; ROM(RAM) data address
;		DB	0		; palet number
;		DB	2		; character loop counter
;		DL	48000H		; ROM(RAM) data address
;		DB	0		; palet number
;		DB	0		; end code
;----------------------------------------------------------------------
work		EQU	0
work0		EQU	work+02
work1		EQU	work+04
work2		EQU	work+06
work3		EQU	work+08
buff_pointer	EQU	work+10
loop_counter	EQU	work+12
line_counter	EQU	work+14
char_counter	EQU	work+16
palet		EQU	work+18
;----------------------------------------------------------------------
Conv_m1m7	SEP	#00100000B
		MEM8
		LDY	!0,X
		STY	<buff_pointer
;========================
next_data	PHB			;> push data bank
		LDA	!2,X
		BEQ	exit_m1m7
		STA	<loop_counter
		LDY	!3,X		; mode1 data address
		LDA	!6,X		; palet number
		STA	<palet
		LDA	!5,X		; bank
		PHA
		PLB			;<- data data bank
;========================
		PHX
;------------------------------------- ; 1 character buffer set ------
		LDX	<buff_pointer
next_char
		LDA	#8
		STA	<char_counter
;
char_loop	LDA	#8
		STA	<line_counter
		LDA	!00H,Y
		STA	<work0
		LDA	!01H,Y
		STA	<work1
		LDA	!10H,Y
		STA	<work2
		LDA	!11H,Y
		STA	<work3
line_loop
		LDA	<palet		 ; palet number
		ASL	<work3
		ROL	A
		ASL	<work2
		ROL	A
		ASL	<work1
		ROL	A
		ASL	<work0
		ROL	A
		BIT	#00001111B	; NUKI check
		BNE	skip$
		LDA	#0
skip$		STA	>buffer_char,X
		INX
		DEC	<line_counter
		BNE	line_loop
		INY
		INY
		DEC	<char_counter
		BNE	char_loop
;========================
		REP	#00100001B
		MEM16
		TYA
		ADC	#10H
		TAY
		SEP	#00100000B
		MEM8
;========================
		DEC	<loop_counter
		BNE	next_char
;========================
		STX	<buff_pointer
		PLX
		INX
		INX
		INX
		INX
		INX
		PLB			;<
		JMP	next_data
;========================
exit_m1m7	PLB			;<-
		REP	#00100000B
		MEM16
		RTS
;======================================================================
;####################################################################
;		UTILITY
;####################################################################
;********************************************************************
;		REPEAT TRIGGER
;********************************************************************
;====================================================================
Repeat_trigger	SEP	#00110000B
		MEM8
		IDX8
		LDX	#0
		LDA	<button_status+1,X	;B
		AND	#11001111B		;B ( up/down/left/right 
		LDY	!repeat1		;B
		JSR	main_repeat		
		STY	!repeat1		;B
		STA	<repeat_trigger+1,X	;B
		REP	#00110000B
		MEM16
		IDX16
		RTS
;====================================================================
		mem8
		idx8
main_repeat	STY	<work
		CLC				;(auto repeat)
		TAY				;
		BEQ	repeat_store		;
		SEC				;
		LDY	<work
		BEQ	repeat_step		;
		CPY	#18			;B
		BCC	repeat_step		;
		LDY	#15			;B
repeat_step	INY				;B
repeat_store	BCS	set_repeat		;
		LDA	#0			;B
set_repeat	RTS
		mem16
		idx16
;********************************************************************
;		ON screen
;********************************************************************
;example
;		JSR	ON_screen
;		DB	00H 	( 212CH )
;----------------------------------------------------------------------
ON_screen	PLX
		INX
		SEP	#00100000B
		MEM8
		LDA	!0,X
		STA	!212CH
		LDA	#0FH
		STA	<ppu_control
		INC	<edit_status
		REP	#00100000B
		MEM16
		PHX
		RTS		
;********************************************************************
;		mode(0-6) BG segment set
;********************************************************************
;example
;		JSR	Set_mode
;		DB	00H 	( BG mode )
;		DB	80H	( Sprite segment )
;		DB	00H	( Character bank BG1,2 )
;		DB	00H	( Character bank BG3,4 )
;		DB	00H	( Screen bank BG1 )
;		DB	00H	( Screen bank BG2 )
;		DB	00H	( Screen bank BG3 )
;		DB	00H	( Screen bank BG4 )
;
;----------------------------------------------------------------------
Set_mode	SEP	#00100000B
		MEM8
		PLX				; <<
		LDA	!1,X			;B
		STA	!Screen_mode		;B Set BG mode
		LDA	!2,X			;B
		STA	!Sprite_segment		;B
		REP	#00100000B
		MEM16
		LDA	!3,X			;W character BANK
		STA	!Character_bank+0	;W ( bg 1/2/3/4 )
		LDA	!5,X			;W screen BANK		
		STA	!Screen_bank+0		;W ( bg 1/2 )
		LDA	!7,X			;W
		STA	!Screen_bank+2		;W ( bg 3/4 )
		RTS
;*********************************************************************
;		PPU initialze
;*********************************************************************
Init_PPU	SEP	#00110000B
		MEM8
		IDX8
;---------------------------------------------- ; blanking -----------
		SEI				;	IRQ disable
	;;;;;	STZ	!NMI_control		;B	NMI disable
		STZ	!DMA_synchronic 	;B	HDMA off 
		STZ	!DMA_burst		;B	VDMA off
		LDA	#80H			;
		STA	<ppu_control		;B
		STA	!PPU_control		;B	screen blanking
;---------------------------------------------- ; reset window -------
		STZ	!Through_window+0	;B
		STZ	!Through_window+1	;B
		STZ	!Window_control+0	;B
		STZ	!Window_control+1	;B
		STZ	!Window_control+2	;B
;---------------------------------------------- ; reset CG ------------
		STZ	!Color_control		;B
		STZ	!Color_brend		;B
		LDA	#0E0H			;B
		STA	!Color_bias		;B
;-----------------------------------------------; reset scroll --------
		LDX	#7			;B
clr_scrl	STZ	!Scroll_,X		;B
		STZ	!Scroll_,X		;B
		DEX				;B
		BPL	clr_scrl		;B
;--------------------------------------------------------------------
		STZ	!Screen_mosaic		;B mosaic off
		STZ	!PPU_option		;B nomal mode
		STZ	!Through_screen+1	;B through sub
		REP	#00110000B
		MEM16
		IDX16
		RTS
;====================================================================
;**********************************************************************
;		parameter initial
;**********************************************************************
Init_mode7	LDA	#0080H
		STA	!rotation_x
		LDA	#cy_offset_init
		STA	!cy_offset
		STA	!rotation_y		
		LDA	#0100H
		STA	!rotation_a
		STZ	!rotation_b
		STZ	!rotation_c
		STA	!rotation_d
		JSR	Set_M7register
		SEP	#00100000B
		MEM8
		LDA	#0C0H
		STA	!211aH		; Screen_flip?
		REP	#00100000B
		MEM16
		JSR	Set_mode
		DB	07H		; BG mode7
		DB	02H		; OBJ   character 4000H
		DB	44H		; BG1,2 character 4000H
		DB	77H		; BG3,4 character 7000H
		DB	70H+1		; BG1 screen address 7000H
		DB	70H+1		; BG2 screen address 7000H
		DB	7CH+0		; BG3 screen address 7C00H
;********************************************************************
;		Set mode7 register
;********************************************************************
Set_M7register			
		LDA	!rotation_x+0	; center calc
		SEC
		SBC	#80H
		STA	!scroll_x
		LDA	!rotation_y+0
		SEC
		SBC	!cy_offset
		STA	!scroll_y
		SEP	#00110000B
		MEM8
		IDX8
		LDA	!rotation_a+0	; rotation parameter
		STA	!Rotation_A	
		LDA	!rotation_a+1
		STA	!Rotation_A
		LDA	!rotation_b+0
		STA	!Rotation_B	
		LDA	!rotation_b+1
		STA	!Rotation_B
		LDA	!rotation_c+0
		STA	!Rotation_C	
		LDA	!rotation_c+1
		STA	!Rotation_C
		LDA	!rotation_d+0
		STA	!Rotation_D	
		LDA	!rotation_d+1
		STA	!Rotation_D
;
		LDA	!rotation_x+0	; rotation center
		STA	!Rotation_X
		LDA	!rotation_x+1
		STA	!Rotation_X
		LDA	!rotation_y+0
		STA	!Rotation_Y
		LDA	!rotation_y+1
		STA	!Rotation_Y
;
		LDA	!scroll_x+0
		STA	!Scroll_+0	; rotation scroll
		LDA	!scroll_x+1
		STA	!Scroll_+0
		LDA	!scroll_y+0
		STA	!Scroll_+1
		LDA	!scroll_y+1
		STA	!Scroll_+1
;
		REP	#00110000B
		MEM16
		IDX16
		RTS
;**********************************************************************
;		VRAM clear ( DMA VRAM clear )
;**********************************************************************
;example	LDX	#DP
;		JSL	>Clear_VRAM
;DP		DW	0000H ( 2 byte clear patern )
;		DW	0000H ( VRAM start address )
;		DW	4000H ( VRAM clear count )
;--------------------------------------------------------------------
Clear_VRAMlow	PHY			;>>
		LDY	!4,X		;W	X=(low data)pointer
		JSR	low_clear
		BRA	VRAM_exit
Clear_VRAM	PHY			;>>
		LDY	!4,X		;W	X=(low_data)pointer
		JSR	low_clear
		INX			;W 	X=(high_data)pointer 
		JSR	high_clear
VRAM_exit	PLY			;<<
		RTL
;----------------------------------------------------------------------
low_clear	LDA	!2,X			; write VRAM address
low_clear_entry	STZ	!Screen_step 		; low inc
		STA	!Screen_address+0
		LDA	#1808H			; 2118H / 1 byte
		BRA	VRAM_clear		;
;----------------------------------------------------------------------
high_clear	LDA	#80H			; hi inc
		STA	!Screen_step
		LDA	!1,X			; write VRAM address
		STA	!Screen_address+0
		LDA	#1908H			; 2119H / 1 byte
		BRA	VRAM_clear		;
;----------------------------------------------------------------------
VRAM_clear	STA	!DMA_0+0
		STX	!DMA_0+2		; ROM address
		STY	!DMA_0+5		; byte	count
;----------------------------------------------------------------------
		SEP	#00100000B
		MEM8
		PHB				;> data bank read
		PLA				;<
		STA	!DMA_0+4		; ROM bank
		LDA	#00000001B		; DMA start
		STA	!DMA_burst
		REP	#00100000B
		MEM16
		RTS
;======================================================================
;**********************************************************************
;		Write COLOR
;**********************************************************************
;
;		LDX	# data address
;		LDY	# data counter ( word count )
;		LDA	# start address
;		JSR	Write_color
;
;----------------------------------------------------------------------
		mem8
Write_color	STA	!Color_address
loop$		LDA	!0,X
		STA	!Color_write
		LDA	!1,X
		STA	!Color_write
		INX
		INX
		DEY
		BNE	loop$
		RTS
		mem16
;**********************************************************************
;		Write VRAM
;**********************************************************************
;		LDX	#DP
;		JSR	>Write_VRAM
;DP		DW	2000H		; VRAM address
;		DB	4		; char count
;		DB	0,1,2,3		; char number
;		DW	0ffffh		; end code
;----------------------------------------------------------------------
Write_VRAM	LDA	#0
		SEP	#00100000B
		MEM8
		STZ	!Screen_step
next$		LDY	!0,X			; read VRAM address
		BMI	exit$
		STY	!Screen_address+0
		INX
		INX
		LDA	!0,X			;B read CHAR count
		TAY				;BW
		INX
loop$		LDA	!0,X			;  read data
		STA	!Screen_write+0
		INX
		DEY
		BNE	loop$
		BRA	next$
exit$		REP	#00100000B
		MEM16
		RTS
;**********************************************************************
;		XvCgeXgZbg
;**********************************************************************
Test_sprite	LDA	!0,Y
		AND	#00FFH
		STA	<0
		INY
loop$		LDA	!0,Y
		STA	<sprite_H,X
		LDA	!2,Y
		STA	<sprite_C,X
		INY
		INY
		INY
		INY
		INX
		INX
		INX
		INX
		DEC	<0
		BNE	loop$
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - 
;**********************************************************************
;		Z
;**********************************************************************
Div		SEP	#00100000B
		MEM8
		STY	!4204H
		STA	!4206H
		NOP
		NOP
		NOP
		NOP	
		NOP
		NOP
		NOP
		NOP	
		REP	#00100000B
		MEM16
		LDA	!4214H
		LDY	!4216H
		RTS
;**********************************************************************
;		editer color initilal
;**********************************************************************
Init_EDcolor	SEP	#00100000B
		MEM8
		LDA	#0			; color address
		LDX	#nuki_colorX		; data address
		LDY	#1			; color count
		JSR	Write_color
		LDA	#071H			; color address
		LDX	#moji_color
		LDY	#3
		JSR	Write_color
		REP	#00100000B
		MEM16
		RTS
;- - - - - - - - - - - -(B)- - - -(G)- - - -(R)- - - 
nuki_colorX	DW	06H*0400H+00H*0020H+00H	
moji_color	DW	1FH*0400H+1FH*0020H+1FH		; MAIN BIT
		DW	1FH*0400H+1FH*0020H+1FH		; NO BIT
		DW	00H*0400H+00H*0020H+00H		; OPTION BIT
;---------------------------------------------------------------------
		END
