;*********************************************************************
;	mario kart << editer (data) >>
;					Programed by H.Yajima
;*********************************************************************
		GLB	select_data,title_data,sound_data
		GLB	conv_data0,set_m7scr
		GLB	conv_mario
		include	../DEF/editer.def
;--------------------------------------------------------------------
		mem16
		idx16
		EXTEND
editer		sect	rel
;####################################################################
;		TITLE MESSAGE DATA
;####################################################################
;*********************************************************************
;		select message
;*********************************************************************
sound_data	DW	mes_debugsound,48H*2
		DW	mes_port,0a8h*2
		DW	mes_2140,0e8h*2
		DW	mes_2141,108h*2
		DW	mes_2142,128h*2
		DW	mes_2143,148h*2
		DW	0
;- - - 
select_data	DW	mes_debugmode,48H*2
		DW	mes_world,0A8H*2
		DW	mes_course,0C8H*2
		DW	mes_start,108H*2
		DW	mes_battle,148H*2
		DW	mes_battle_mp,168H*2
		DW	mes_battle_st,1A8H*2
		DW	mes_edit1,1E8H*2
		DW	mes_edit2,208H*2
		DW	mes_m7_char,228H*2
		DW	mes_cg_map,248H*2
		DW	mes_demo1,268H*2
		DW	mes_demo2,288H*2
		DW	mes_sound,2e8H*2
		DW	mes_exit,328H*2
		DW	0
;---------------------------------------------------------------------
mes_debugsound	DB	1ch
		DB	_ma,_ri,_oo,_ka,_xx,_to,sp
		DB	_sa,_uu,_nn,_to,sp,_te,_su,_to,ed
;- - - 
mes_port	DB	1ch,_ho,_xx,_to,ed
mes_2140	DB	1ch,_2,_1,_4,_0,ed
mes_2141	DB	1ch,_2,_1,_4,_1,ed
mes_2142	DB	1ch,_2,_1,_4,_2,ed
mes_2143	DB	1ch,_2,_1,_4,_3,ed
;- - - 
;---------------------------------------------------------------------
mes_debugmode	DB	1ch
		DB	_ma,_ri,_oo,_ka,_xx,_to,sp
		DB	_te,_ha,ttu,_ku,_mo,_xx,_to,ed

mes_world	DB	1ch,_wa,_xx,_ru,_to,ed

mes_course	DB	1ch,_ko,_xx,_su,ed

mes_start	DB	1ch,_re,_xx,_su,_sp,_su,_ta,_xx,_to,ed

mes_battle	DB	1ch,_ha,_to,_ru,ed
mes_battle_mp	DB	1ch,_ma,ttu,_hu,ed
mes_battle_st	DB	1ch,_ha,_to,_ru,_su,_ta,_xx,_to,ed
mes_param	DB	1ch,_p,_a,_r,_a,_m,_e,_t,_e,_r,ed
;
mes_edit1	DB	1ch,_e,_d,_i,_t,_1,ed
mes_edit2	DB	1ch,_e,_d,_i,_t,_2,ed
mes_m7_char	DB	1ch,_mo,_xx,_to,_7,_sp,_ki,yya,_ra,ed
mes_cg_map	DB	1ch,_c,_o,_l,_o,_r,sp,_m,_a,_p,ed
mes_demo1	DB	1ch,_d,_e,_m,_o,_1,ed
mes_demo2	DB	1ch,_d,_e,_m,_o,_2,ed

mes_sound	DB	1ch,_sa,_uu,_nn,_to,sp,_te,_su,_to,ed

mes_exit	DB	1ch,_e,_x,_i,_t,ed

;*********************************************************************
;		title message
;*********************************************************************
title_data	DW	mes_m7_char,pos_m7_char
		DW	mes_cg_map,pos_cg_map
		DW	mes_mario,pos_mario
		DW	mes_map,pos_map
		DW	mes_hit_dist,pos_hit_dist
		DW	mes_battle_obj,pos_battle_obj
		DW	mes_bound_power,pos_bound_power
		DW	mes_muteki_init,pos_muteki_init
		DW	mes_muteki_down,pos_muteki_down
		DW	mes_exit,pos_exit
		DW	0
;---------------------------------------------------------------------
mes_mario	DB	1ch,_m,_a,_r,_i,_o,ed
mes_map		DB	1ch,_m,_a,_p,ed
mes_hit_dist	DB	1ch,_h,_i,_t,sp,_d,_i,_s,_t,_a,_n,_c,_e,ed
mes_battle_obj	DB	1ch,_b,_a,_t,_t,_l,_e,sp,_o,_b,_j,ed
mes_bound_power	DB	1ch,_b,_o,_u,_n,_d,sp,_p,_o,_w,_e,_r,ed
mes_muteki_init	DB	1ch,_m,_u,_t,_e,_k,_i,sp,_i,_n,_i,_t,ed
mes_muteki_down	DB	1ch,_m,_u,_t,_e,_k,_i,sp,_d,_o,_w,_n,ed
;####################################################################
;		CONVERT DATA
;####################################################################
;*********************************************************************
;		CONVERT DATA (OBJ char -> mode7 char)
;*********************************************************************
;		*DW	buffer_offset
;		*DS	loop_count(1),char_address(3),attribute(1)
;--------------------------------------------------------------------
OBJ_mario	EQU	04A000H
OBJ_koopa	EQU	05A000H
OBJ_peach	EQU	06A000H
OBJ_cong	EQU	07A000H
OBJ_luige	EQU	08A000H
OBJ_noko	EQU	09A000H
OBJ_kino	EQU	0AA000H
OBJ_yossy	EQU	0BA000H
cg_mario	EQU	1
cg_luige	EQU	2
cg_koopa	EQU	0
cg_peach	EQU	3
cg_cong		EQU	3
cg_noko		EQU	2
cg_kino		EQU	1
cg_yossy	EQU	0
;----------------------------------------------------------------------
conv_mario	DW	0
		DB	0C0H		; character count
		DL	OBJ_noko
		DB	08H+cg_noko
		DB	0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
conv_data0	DW	0
	IF	0
		DW	0		; buffer offset
;
		DB	4		; loop counter ; *** MARIO ***
		DL	OBJ_mario+1100H
		DB	08H+cg_mario	; palet number
		DB	4		; loop counter
		DL	OBJ_mario+1300H
		DB	08H+cg_mario	; palet number
		DB	4		; loop counter
		DL	OBJ_mario+1500H
		DB	08H+cg_mario	; palet number
		DB	4		; loop counter
		DL	OBJ_mario+1700H
		DB	08H+cg_mario	; palet number
;
		DB	4		; loop counter ; *** LUIGI ***
		DL	OBJ_luige+1100H
		DB	08H+cg_luige	; palet number
		DB	4		; loop counter
		DL	OBJ_luige+1300H
		DB	08H+cg_luige	; palet number
		DB	4		; loop counter
		DL	OBJ_luige+1500H
		DB	08H+cg_luige	; palet number
		DB	4		; loop counter
		DL	OBJ_luige+1700H
		DB	08H+cg_luige	; palet number
;
		DB	4		; loop counter ; *** KUPPA ***
		DL	OBJ_koopa+1100H
		DB	08H+cg_kuppa	; palet number
		DB	4		; loop counter
		DL	OBJ_koopa+1300H
		DB	08H+cg_kuppa	; palet number
		DB	4		; loop counter
		DL	OBJ_koopa+1500H
		DB	08H+cg_kuppa	; palet number
		DB	4		; loop counter
		DL	OBJ_koopa+1700H
		DB	08H+cg_kuppa	; palet number
;
		DB	4		; loop counter ; *** PEACH ***
		DL	OBJ_peach+1100H
		DB	08H+cg_peach	; palet number
		DB	4		; loop counter
		DL	OBJ_peach+1300H
		DB	08H+cg_peach	; palet number
		DB	4		; loop counter
		DL	OBJ_peach+1500H
		DB	08H+cg_peach	; palet number
		DB	4		; loop counter
		DL	OBJ_peach+1700H
		DB	08H+cg_peach	; palet number
;
		DB	4		; loop counter ; *** CONG ***
		DL	OBJ_cong+1100H
		DB	08H+cg_cong	; palet number
		DB	4		; loop counter
		DL	OBJ_cong+1300H
		DB	08H+cg_cong	; palet number
		DB	4		; loop counter
		DL	OBJ_cong+1500H
		DB	08H+cg_cong	; palet number
		DB	4		; loop counter
		DL	OBJ_cong+1700H
		DB	08H+cg_cong	; palet number
;
		DB	4		; loop counter ; *** NOKO ***
		DL	OBJ_noko+1100H
		DB	08H+cg_noko	; palet number
		DB	4		; loop counter
		DL	OBJ_noko+1300H
		DB	08H+cg_noko	; palet number
		DB	4		; loop counter
		DL	OBJ_noko+1500H
		DB	08H+cg_noko	; palet number
		DB	4		; loop counter
		DL	OBJ_noko+1700H
		DB	08H+cg_noko	; palet number
;
		DB	4		; loop counter ; *** KINO ***
		DL	OBJ_kino+1100H
		DB	08H+cg_kino	; palet number
		DB	4		; loop counter
		DL	OBJ_kino+1300H
		DB	08H+cg_kino	; palet number
		DB	4		; loop counter
		DL	OBJ_kino+1500H
		DB	08H+cg_kino	; palet number
		DB	4		; loop counter
		DL	OBJ_kino+1700H
		DB	08H+cg_kino	; palet number
;
		DB	4		; loop counter ; *** YOSSY ***
		DL	OBJ_yossy+1100H
		DB	08H+cg_yossy	; palet number
		DB	4		; loop counter
		DL	OBJ_yossy+1300H
		DB	08H+cg_yossy	; palet number
		DB	4		; loop counter
		DL	OBJ_yossy+1500H
		DB	08H+cg_yossy	; palet number
		DB	4		; loop counter
		DL	OBJ_yossy+1700H
		DB	08H+cg_yossy	; palet number
;
		DB	0
		ENDIF

;*********************************************************************
;		CONVERT SET ( mode7 screen )
;*********************************************************************



scr_start	EQU	800H
set_m7scr	DW	scr_start+000H
		DB	20H	
		DB	00H,01H,02H,03H
		DB	10H,11H,12H,13H
		DB	20H,21H,22H,23H
		DB	30H,31H,32H,33H
		DB	40H,41H,42H,43H
		DB	50H,51H,52H,53H
		DB	60H,61H,62H,63H
		DB	70H,71H,72H,73H
		DW	scr_start+080H
		DB	20H
		DB	04H,05H,06H,07H
		DB	14H,15H,16H,17H
		DB	24H,25H,26H,27H
		DB	34H,35H,36H,37H
		DB	44H,45H,46H,47H
		DB	54H,55H,56H,57H
		DB	64H,65H,66H,67H
		DB	74H,75H,76H,77H
		DW	scr_start+100H
		DB	20H	
		DB	08H,09H,0AH,0BH
		DB	18H,19H,1AH,1BH
		DB	28H,29H,2AH,2BH
		DB	38H,39H,3AH,3BH
		DB	48H,49H,4AH,4BH
		DB	58H,59H,5AH,5BH
		DB	68H,69H,6AH,6BH
		DB	78H,79H,7AH,7BH
		DW	scr_start+180H
		DB	20H
		DB	0CH,0DH,0EH,0FH
		DB	1CH,1DH,1EH,1FH
		DB	2CH,2DH,2EH,2FH
		DB	3CH,3DH,3EH,3FH
		DB	4CH,4DH,4EH,4FH
		DB	5CH,5DH,5EH,5FH
		DB	6CH,6DH,6EH,6FH
		DB	7CH,7DH,7EH,7FH
		DW	8000H
;--------------------------------------------------------------------
		END
