;****************************************************************************
;*	Mario Kart							    *
;*			APU control module			 	    *
;*							1992.07.13          *
;****************************************************************************
		glb	Sound_set,Set_race_BGM,Call_bgm,Set_BGM
		glb	Sound_control,Count_down_sound,Call_BGM
		glb	Sound_initialize,APU_initialize,Call_fanfare
		glb	BGM_fade_out,Cut_SE,Clear_engine
		glb	Engine_sound,Goal_in_sound,Race_sound_init
		glb	Sound_buffer_clear,Sound_resister_clear
		glb	Trigger_sound_1,Trigger_sound_2,Sound_set_trigger
		glb	Check_trigger_SE,SE_trigger_1,SE_trigger_2
		glb	Coin_sound,Jump_sound,Spin_jump_sound
		glb	Landing_sound,Dash_sound,Crash_sound
		glb	Falling_sound,Splash_sound,Balloon_sound
		glb	Lost_sound,Kame_sound,Cursor_sound
		glb	Start_ultra_BGM,End_ultra_BGM,Set_battle_BGM
;----------------------------------------------------------------------------
		ext	Decode_7F_X
;----------------------------------------------------------------------------
		include	rp5a22
		include rp5c77
		include work.def
		include buffer.def
		include	label.def
		include ../join/object.def
;---------------------------------------------------------------------------
tempolary	equ	0000h
button_check	equ	0002h
max_coin_effect equ	0004h
address		equ	0010h
pan_data	equ	0014h
jump_effect	equ	0016h
;---------------------------------------------------------------------------
bank80		sect	rel
;---------------------------------------------------------------------------
		mem16
		idx16
Sound_control
		lda	!o_demo_flag
		bne	Skip_S_control
		lda	<frame_counter
		ror	a
		bcs	Skip_S_control
		jsr	!BGM_control
		jsr	!Engine_sound
Skip_S_control
		rts
Demo_sound_cont
		rts
;---------------------------------------------------------------------------
Count_down_sound
		lda	<frame_counter
		ror	a
		bcs	Skip_S_control
		lda	!o_demo_flag
		bne	Skip_S_control
		jsr     !BGM_control
		jsr	!Count_down_engine
		rts		
;---------------------------------------------------------------------------
Count_down_engine
		ldx	!trigger_pointer
		beq	Goto_countdown		
		rep	#00100000b
		lda	<sound_02
		and	#1000000010000000b
		sta	<sound_02
		rts
Goto_countdown
		mem16
		ldx	<game_mode
		jmp	(!Conutdown_sub,x)
Conutdown_sub
		word	Play_2,Play_U,Play_D
Play_2
		ldy	#0002h
		ldx	#1100h
		lda	#0000000001111111b
		trb	<sound_03
		lda	!1100h+kart_flag
		beq	Check_1000h
		jsr     !Check_countdown_engine
		tsb     <sound_03
		jsr	!Check_button_DOWN
		bra	Check_1000h
Play_U
		lda	!g_kart_flag
		beq	Check_1000h
		ldy	#0002h
		ldx	#1100h
		jsr     !Check_countdown_engine
Check_1000h
		ldy	#0000h
		ldx	#1000h
		lda	!1000h+kart_flag
		beq	Skip_1000h_kart
Ckeck_sound
		lda	#0000000001111111b
		trb	<sound_02
		jsr	!Check_countdown_engine
		tsb	<sound_02
		jsr	!Check_button_UP	
Skip_1000h_kart
		rts
Play_D
		ldy	#0002h
		ldx	#1100h
		bra	Ckeck_sound
;---------------------------------------------------------------------------
Check_button_UP
		lda	#10000000b
		ldx	<button_check
		bpl	Accel_off
Accel_on
		trb	<sound_port+01h
		rts
Check_button_DOWN
		lda	#01000000b
		ldx	<button_check
		bmi	Accel_on
Accel_off
		tsb	<sound_port+01h
		rts
;---------------------------------------------------------------------------
		mem16
Check_countdown_engine
		stz	<button_check
		lda	!button_status+00h,y
		bpl	Accel_off_countdown
		dec	<button_check
Accel_off_countdown
		lda	<game_status
		beq	Check_grandprix
		cmp	#04h
		bcc	Hard_start
Easy_start
		lda	<engine_power,x
		cmp	#3000h+0c0h*1
		bcs     Over_3000h
		cmp	#3000h-0c0h*3
		bcs	Super_dash
		bra	Not_super_dash
Check_grandprix
		lda	<rank_number,x
		cmp	#04h
		bcs	Easy_start
Hard_start
		lda	<engine_power,x
		cmp	#3000h
		bcs	Over_3000h
		cmp	#3000h-0c0h*2
		bcs	Super_dash
Not_super_dash
		lda	<special_trigger,x
		and	#1111111111111110b
		sta	<special_trigger,x
		bra	Clear_wheelspin_flag
Super_dash
		lda	<button_check
		bpl	Not_super_dash
		lda	<special_trigger,x
		ora	#0000000000000001b
		sta	<special_trigger,x
Clear_wheelspin_flag
		lda	<kart_status,x
		and	#1111111111111110b
		bra	Set_kart_status
Over_3000h
		lda	<special_trigger,x
		and	#1111111111111110b
		sta	<special_trigger,x
		lda	<kart_status,x
		ora	#00001h
Set_kart_status
		sta	<kart_status,x
Check_button
		lda	<button_check
		bmi	Accel_on_engine
;Accel_off_engine
		lda     !engine_control,x
		bne	Over_engine
		lda	!engine_power,x
		sec
		sbc	#180h
		bmi	Minimum_engine
		cmp	#0100h
		bcs	Set_countdown_engine
Minimum_engine
		lda	#0100h
		bra	Set_countdown_engine
Accel_on_engine
		lda	!engine_control,x
		beq	Nomal_engine
Over_engine
		lda	!engine_power,x
		sec
		sbc	#0280h
		cmp	#03f00h
		bcs	Set_countdown_engine
		stz	!engine_control,x
		bra	Set_countdown_engine
Nomal_engine
		lda	!engine_power,x
		clc
		adc	#0c0h
		cmp	#04f00h
		bcc	Set_countdown_engine
		dec	!engine_control,x
Set_countdown_engine
		sta	!engine_power,x
		xba
		and	#07fh
		rts
;---------------------------------------------------------------------------
		mem8
		idx8
Ending_sound
		lda	!bgm_pointer
		beq	Check_ending_trigger
		stz	!bgm_pointer
		lda	#16h
		bra	Set_sound_demo
Check_ending_trigger
		lda	!se_pointer
		beq	Set_sound_demo
		tax
		dex
		dex
		stx	!se_pointer
		lda	!se_buffer,x
		bra	Set_sound_demo	
;---------------------------------------------------------------------------
		mem8
		idx8
Demo_sound_set
		lda	!bgm_pointer
		beq	Set_sound_demo
		dec	a
		tax
		sta	!bgm_pointer	
		lda	!bgm_buffer,x
		cmp	#1eh
		bne	Skip_demo_sound
Set_sound_demo
		sta	!Sound0
Skip_demo_sound
Skip_set
		rep	#00110000b
		rts
;---------------------------------------------------------------------------
Sound_set_trigger
		mem8
		idx16
		sep	#00100000b
		lda	<nmi_counter
		ror	a
		bcs	Skip_set
		lda	!se_pointer
		beq	Set_sound_demo
		dec	a
		dec	a
		sta	!se_pointer
		tax
		lda	!se_buffer,x
		bra	Set_sound_demo
;---------------------------------------------------------------------------
Sound_set
;						;input mem16 idx16!!!
		mem8
		idx8
		sep	#00110000b
		lda	<nmi_counter
		ror	a   
		bcs	Skip_set
		lda	!o_demo_flag
		bne	Demo_sound_set
		lda	!ending_flag
		bne	Ending_sound
		lda	<sound_02
		sta	!Sound2
		lda	<sound_03
		sta	!Sound3
;----------------------------------------------------------------------------
		lda	<game_mode
		cmp	#02h
		beq	Check_02
		bcs	Check_04
Check_00
		lda	!1000h+kart_flag
		bit	#00100000b
		beq	Not_player_goal
Check_04
		lda	!1100h+kart_flag
		bit	#00100000b
		beq	Not_player_goal
		bra	No_size_check
Check_02
		lda	!1000h+kart_flag
		bit	#00100000b
		beq	Not_player_goal
No_size_check
		stz	!sound_size+00h
		stz	!sound_size+01h
		jmp     !Check_bgm	
Not_player_goal
Check_engine_size
		lda	<sound_size+00h
		beq	Not_init_size
		pha
		lda	<nmi_counter
		ror	a
		ror	a
		bcc	OK_set_size_low
		pla
		stz	!Sound0
		rep	#00110000b
		rts
OK_set_size_low
		pla
		bit	#10000000b
		bne	Enemy_init
		bit	#01000000b
		bne	Mini_init_1p
		bit	#00100000b
		bne	Mini_init_2p
		bit	#00010000b
		bne	Big_init_1p
Big_init_2p
		lda	#7fh
		pha
		lda	#00001000b
		bra	Init_2p
Mini_init_2p
		lda	#5eh
		pha
		lda	#00100000b
Init_2p
		pha
		lda	<sound_02
		ora	#10000000b
		sta	<sound_02
		sta	!Sound2
		pla
		bra	Set_size_init
Big_init_1p
		lda	#07eh
		pha
		lda	#00010000b
		bra	Init_1p
Mini_init_1p
		lda	#5eh
		pha
		lda	#01000000b
Init_1p
		pha
		lda	<sound_02
		and	#01111111b
		sta	<sound_02
		sta	!Sound2
		pla
Set_size_init
		trb	!sound_size+00h
		pla
		sta	!Sound0
		rep	#00110000b
		rts
Enemy_init
		lda	#063h
		pha
		lda	#10000000b
		bra	Set_size_init
;----------------------------------------------------------------------------
Not_init_size
		lda	!sound_size+01h
		beq	Check_bgm
		pha
		lda	<nmi_counter
		ror	a
		ror	a
		bcc	OK_set_size_high
		pla
		stz	!Sound0
		rep	#00110000b
		rts
OK_set_size_high
		pla
		bmi	P1_mini
		bit	#01000000b
		bne	P2_mini
		bit	#00100000b
		bne	P1_big
		bit	#00010000b
		bne	P2_big
		bit	#00001000b
		bne	Start_thunder
		bit	#00000100b
End_thunder
		lda	#62h
		pha
		lda	#00000100b
		bra	Set_size_data
Start_thunder
		lda	#61h
		pha
		lda	#00001000b
		bra	Set_size_data
P1_mini
		lda	#5dh
		pha
		lda	#10000000b
		bra	Set_1P
P1_big
		lda	#5fh
		pha
		lda	#00100000b
Set_1P
		pha
		lda	<sound_02
		and	#01111111b
		sta	<sound_02
		sta	!Sound2
		pla
		bra	Set_size_data
P2_mini
		lda	#5dh
		pha
		lda	#01000000b
		bra	Set_2P
P2_big
		lda	#5fh
		pha
		lda	#00010000b
Set_2P
		pha
		lda	<sound_02
		ora	#10000000b
		sta	<sound_02
		sta	!Sound2
		pla
Set_size_data
		trb	!sound_size+01h
		pla
		sta	!Sound0
		rep	#00110000b
		rts
;----------------------------------------------------------------------------
Check_bgm
		lda	<sound_01
		sta	!Sound1
		ldx	!bgm_pointer
		beq	Check_trigger
		dex
		stx	!bgm_pointer	
		lda	!bgm_buffer,x
		bra	Set_sound_resister
;----------------------------------------------------------------------------
Check_trigger
		ldx	!trigger_pointer
		beq	Check_trigger_sound
		dex	
		stx	!trigger_pointer
		lda	!trigger_buffer,x	
		bra	Set_sound_resister
;----------------------------------------------------------------------------
Check_trigger_sound
		ldx	!se_pointer
		beq	Check_doppler
		dex
		dex
		stx	!se_pointer
		lda	#10000000b
		ldy	!pan_buffer,x
		bpl	Left_pan
;Right_pan
		lda	<sound_02
		ora	#10000000b
		bra	Set_sound_02
Left_pan
		lda	<sound_02
		and	#01111111b
Set_sound_02
		sta	<sound_02
		sta	!Sound2
		lda	!se_buffer,x
		bra	Set_sound_resister
;----------------------------------------------------------------------------
Check_doppler
		lda	!doppler_driver
		cmp	!old_doppler_driver
		sta	!old_doppler_driver
		bne	Set_sound_resister
Not_change_doppler
		lda	#0000h
Set_sound_resister
		cmp	#14h
		beq	Gameover_sound
  		ora	<sound_00
Gameover_sound
		sta	!Sound0
		rep	#00110000b
		rts
;---------------------------------------------------------------------------
		mem16
		idx16
BGM_control
		lda	!signal_counter
		bmi	Skip_signal
		dec	a
		beq	End_signal_BGM
		sta	!signal_counter
		rts
End_signal_BGM
		dec	a
		sta	!signal_counter		;counter=minus
		lda	#0ah
		sta	!pause_wait
		lda	#04h
		jmp	!Call_bgm		;start main BGM!!!!!
Skip_signal
		lda	!finallap_counter
		beq	Not_finallap
		dec	a
		sta	!finallap_counter
		bne	Cont_finallap
						;end finallap sound
		lda	<game_status
		cmp	#02h			;VS mode???
		bne	End_finallap_BGM
		lda	!1000h+kart_flag
		bit	#0000000000100000b
		bne	VS_mode_end
		lda     !1100h+kart_flag
		bit     #0000000000100000b
		beq	End_finallap_BGM
VS_mode_end
		rts
End_finallap_BGM
		lda	!ultra_index
		bmi	Not_ultra_bgm
		lda	#08h
		bra	Call_bgm
Not_ultra_bgm
		lda	!map_type
		beq	Obake_set
		cmp	#00ch
		beq	Castle_set
		lda	#07h
		bra	Call_bgm
Obake_set
		lda	#15h
		bra	Call_bgm
Castle_set
		lda	#06h
		bra     Call_bgm
Not_finallap
		lda	!fanfare_counter		
		beq	Not_fanfare
		dec	a
		sta     !fanfare_counter
		bne	Cont_fanfare
Call_theme
		lda	#10h
		sta	!pause_wait
		lda	!clear_driver
		cmp	#010h
		bcs	Not_clear_BGM
		lsr	a
		clc
		adc	#0ch
		bra	Call_bgm
Cont_finallap
Cont_fanfare
Not_clear_BGM
Not_fanfare
		rts
;---------------------------------------------------------------------------
		mem16
		idx16
Goal_in_sound
		lda	<game_status
		beq	Grandprix_goal
		cmp	#04h
		beq	Time_attack_mode
;Battle & VS
		lda	!clear_driver
		bpl	Skip_gaol_sound
		lda	<driver_number,x
		sta	!clear_driver
		bra	Call_theme		
Grandprix_goal
		lda	!clear_driver
		bpl	Skip_gaol_sound
		lda	!goalin_number
		cmp	#008h
		bcc	Win_fanfare
;Lost_fanfare
		lda	#0bh
		jsl     >Call_fanfare
		lda	#010h
		sta     !clear_driver
		rts
Win_fanfare
		lda	#09h
		jsl	>Call_fanfare
		lda	<driver_number,x
		sta	!clear_driver
Skip_gaol_sound
Time_attack_mode
		rts	
;---------------------------------------------------------------------------
Call_bgm
		ldy	!bgm_pointer
		sta	!bgm_buffer,y
		inc	!bgm_pointer
		rts
;---------------------------------------------------------------------------
Call_BGM
		jsr	!Call_bgm
		rtl
;---------------------------------------------------------------------------
Call_fanfare
		jsr	!Call_bgm
		lda	#0b0h			;about 6 second timer
		sta	!fanfare_counter
		lda	#0ffffh
		sta	!bgm_status			;goalin bgm status!!
		lda	<game_mode
		cmp	#04h
		bcs	Kart_1100h
		lda	!1000h+driver_number
		bra	Set_clear_driver
Kart_1100h
		lda	!1100h+driver_number
Set_clear_driver
		sta	!clear_driver
		rtl
;---------------------------------------------------------------------------
		mem16
		idx16
Start_ultra_BGM
		phx
		jsr	!Check_player_goalin
		plx
		bcs	Not_set_ultra
		stx	!ultra_index
		lda	!bgm_status
		bmi	Not_set_ultra
		lda	#08h
		bra	Call_bgm
Not_set_ultra
		rts
End_ultra_BGM
		cpx	!ultra_index
		bne	Not_set_ultra
		phx
		jsr	!Check_player_goalin
		plx
		bcs	Not_set_ultra
		lda	#0ffffh
		sta	!ultra_index
		lda	!bgm_status
		beq	Nomal_urtra
		bmi	Not_set_ultra
		lda	!map_type
		cmp	#0ch
		beq	Castle_type
		lda	#07h
		bra	Call_bgm
Castle_type
		lda	#06h
		bra     Call_bgm
Nomal_urtra		
		lda	#04h
		bra	Call_bgm
;---------------------------------------------------------------------------
Check_player_goalin
		ldx	<game_mode
		jmp	(!Check_gaolin_sub,x)
Check_gaolin_sub
		word	Goal_00,Goal_02,Goal_04
Goal_00
		jsr	!Goal_04
		bcs	Goal_player
Goal_02
		lda	!1000h+kart_flag
		bra	Check_goalin_bit
Goal_04
		lda     !1100h+kart_flag
Check_goalin_bit
		bit	#0000000000100000b
		bne	Goal_player
Not_galin_player
		clc
		rts	
Goal_player
		sec
		rts
;-----------------------------------------------------------------------------
Engine_sound
		mem16
		ldx	<game_mode
						;00=up&down--engine
						;02=up--engine down--doppler
						;04=up--doppler down--engine
						;06=up&down--doppler
		jmp	(!Engine_set_address,x)
Engine_set_address
		word	Mode_00,Mode_02,Mode_04,Mode_06
;---------------------------------------------------------------------------
Mode_00
		lda	<frame_counter
		bit	#00010b
		bne	Check_lower
Check_higher
		jsr     !Mykart_sound100
		rts
Check_lower
		jsr	!Mykart_sound200
		rts				;return mem16 idx16
;---------------------------------------------------------------------------
Mode_02
		lda	<frame_counter
		bit	#0010b
		bne	Check_low_enemy
		jsr	!Mykart_sound100
		rts
Check_low_enemy	
		jsr	!Enemy_sound
		rts				;return mem16 idx16
;---------------------------------------------------------------------------
Mode_04
		lda	<frame_counter
		bit	#0010b
		bne	Check_high_enemy
		jsr     !Mykart_sound300
		rts
Check_high_enemy
		jsr     !Enemy_sound
		rts
Not_set_enemy_se
		lda	#0000000001111111b
		trb	<sound_02
		rts				;return mem16 idx16
;----------------------------------------------------------------------------
Mode_06
		lda	#01000000b
		tsb	<sound_01		;set 1P mode
		lda	<frame_counter
		bit	#0010b
		bne	Not_set_enemy_se
;----------------------------------------------------------------------------
Enemy_sound
		lda	!doppler_dist
		cmp	#0100h
		bcs	 No_enemy_doppler
		ldx	!doppler_index
		ldy	<driver_number,x
		lda	!Doppler_sound_data,y
		sta	!doppler_driver
		ldx	!old_doppler_dist
		bmi	Renew_old_dist
		lda	!doppler_x
		clc
		adc	#020h
		bmi	No_enemy_doppler
		cmp	#040h
		bcs	No_enemy_doppler
		asl	a
		and	#0000000001110000b
		sta	<pan_data
;
		lda	!doppler_dist
		lsr	a
		lsr	a
		lsr	a
		cmp	#07h
		bcs	No_enemy_doppler
		tay
		lda	!doppler_dist
		sec
		sbc	!old_doppler_dist
		beq	Dont_change_dist
		bcc	Come_closer
Go_faraway
		lda	!Faraway_sound,y
		bra	Set_dopler_effect
Come_closer
		lda	!Closer_sound,y
		bra	Set_dopler_effect
Dont_change_dist
		cpy	#02h
		bcs	Not_set_doppler
		lda	#08h
Set_dopler_effect
		and	#0fh
		ora	<pan_data
		tsb	<sound_03
		eor	#0000000001111111b
		trb	<sound_03
Renew_old_dist
		lda	!doppler_dist
		sta	!old_doppler_dist
Not_set_doppler
		rts
No_enemy_doppler
		lda	<sound_03
		and	#1111111110000000b
		sta	<sound_03
		lda	#0ffffh
		sta	!old_doppler_dist
		rts
;----------------------------------------------------------------------------
Faraway_sound
		byte	09h,0ah,0bh,0ch,0dh,0eh,0fh
Closer_sound
		byte	07h,06h,05h,04h,03h,02h,01h
Doppler_sound_data
		word	078h,078h,079h,07bh,079h,07ah,07ah,07bh
;----------------------------------------------------------------------------
Engine_sound_control
		mem16
		lda	<vector_velocity,x
		cmp	#01ffh
		bcc	Not_over_200
		lda	#1ffh
Not_over_200
		asl	a
		asl	a
		asl	a
		and	#01f00h	
		sta	<max_coin_effect
		mem8
		sep	#00100000b
		lda	<drift_index,x
		cmp	#12h			;drift dash???
		bne	Not_drift_dash
		lda	#03h
		bra	Set_coin_effect
Not_drift_dash
		lda	#00h
Set_coin_effect
		sta	<tempolary
		lda	!player_coin,y
		cmp	#0ah
		bcc	Not_over_coin
		lda	#0ah
Not_over_coin
		clc
		adc	<tempolary
		sta	<tempolary
		asl	a
		clc
		adc	<tempolary
		cmp	<max_coin_effect+01h
		bcc	Not_over_max_coin
		lda	<max_coin_effect+01h
Not_over_max_coin
		clc
		adc	<engine_power+01h,x
		cmp	#7fh
		bcc	Not_over_engine
		lda	#7fh
Not_over_engine
		rts
;----------------------------------------------------------------------------
		mem16
Mykart_sound100
		rep	#00100000b
		lda	!1000h+kart_flag
		beq	Not_exist_kart100
		bit	#0000000001000000b	;engine cut flag
		bne	Not_exist_kart100
		stz	<button_check
		lda	!button_status+00h
		bpl	B_off_100
		dec	<button_check
B_off_100
		jsr	!Check_button_UP
Check_e_100
		lda	#0000000001111111b
		trb	<sound_port+02h
		ldx	#1000h
		ldy	#0000h
		jsr	!Engine_sound_control
		mem8
		tsb	<sound_port+02h
		bra	Check_100
;---------------------------------------------------------------------------
Not_exist_kart100
		mem16
		lda	<sound_port+01h
		and	#1000000011000000b
		ora	#0000000000101111b
		sta	<sound_port+01h
		rts
;---------------------------------------------------------------------------
Not_exist_kart200
		mem8
		sep	#00100000b
		lda	#01111111b
		trb	<sound_port+03h
		lda	<sound_port+01h
		and	#11000000b
		ora	#00011111b
		sta	<sound_port+01h
		rep	#00100000b
		rts
;---------------------------------------------------------------------------
		mem16
Mykart_sound200
		rep	#00100000b
		lda	!1100h+kart_flag
		beq	Not_exist_kart200
		bit	#0000000001000000b
		bne	Not_exist_kart200
		stz	<button_check
		lda	!button_status+02h
		bpl	B_off_200
		dec	<button_check
B_off_200
		jsr	!Check_button_DOWN
		lda	#0000000001111111b
		trb	<sound_port+03h 
		ldx	#1100h
		ldy	#0002h
		jsr	!Engine_sound_control
		mem8
		tsb	<sound_port+03h
		bra	Check_200
;---------------------------------------------------------------------------
		mem16
Mykart_sound300
		rep	#00100000b
		lda	!1100h+kart_flag
		beq	Not_exist_kart100
		bit	#0000000001000000b
		bne	Not_exist_kart100
		stz	<button_check
		lda	!button_status+2h
		bpl	B_off_300
		dec	<button_check
B_off_300
		jsr	!Check_button_UP
Check_e_300
		lda	#0000000001111111b
		trb	<sound_port+02h 
		ldx	#1100h
		ldy	#0002h
		jsr     !Engine_sound_control
		mem8
		tsb	<sound_port+02h
		bra	Check_300
;----------------------------------------------------------------------------
Check_100
		ldx	#1000h
		ldy	#0000h
		jsr	!Check_sound
		cmp	!se_level+00h
		beq	Not_se_level_01
		sta	!se_level+00h
Set_level_01
		ora	#00100000b
		tsb	<sound_01
Return_se_check
		rep	#00100000b
		rts
Not_se_level_01
		cmp	#0fh
		bne	Return_se_check
		lda	<frame_counter
		bit	#00100b
		bne	Return_se_check
		lda	#0fh
		bra	Set_level_01
Check_200
		ldx	#1100h
		ldy	#0002h
		jsr     !Check_sound
		cmp	!se_level+02h
		beq	Not_se_level_02
		sta     !se_level+02h
Set_level_02
		ora	#00010000b
		tsb	<sound_01
Not_se_level_02
		cmp	#0fh
		bne	Return_se_check
		lda	<frame_counter
		bit	#00100b
		bne	Return_se_check
		lda	#0fh
		bra	Set_level_02
Check_300
		ldx	#1100h
		ldy	#0002h
		jsr     !Check_sound
		cmp	!se_level+02h
		beq	Not_se_level_01
		sta     !se_level+02h
		ora	#00100000b
		tsb	<sound_01
		rep	#00100000b
		rts
;----------------------------------------------------------------------------
		mem8
Check_sound
		lda	<kart_flag+00h,x
		bit	#01000000b
		bne	Cut_se
;
		lda	#00111111b
		trb	<sound_01
		lda	<choropoo_flag+01,x
		beq	Not_choropoo_status
		lda	#00h
		sta	!slot_sound_counter,y		;clear slot!!!
		lda	#00001110b
		rts
Not_choropoo_status
		lda	!slot_sound_counter,y
		beq	Check_slot_start
		lda	!slot_flag+01h,y
		bit	#00100000b
		bne	Slot_sound_on
End_slot
		lda	#00h
		sta	!slot_sound_counter,y
		mem16
		rep	#00100000b
		lda	#55h
		jsl	>Check_trigger_SE
		mem8
		sep	#00100000b
		bra	Check_level_sound
Check_slot_start
		lda	!slot_flag+01h,y
		and	#10100000b
	 	cmp	#10100000b
		bne	Check_level_sound
Start_slot_sound
		lda	#0ffh
		sta	!slot_sound_counter,y
Slot_sound_on
		lda	#00001011b		;slot sound level1
		rts		
Check_level_sound
		lda	<kart_status,x
		bit	#01h
		beq	Not_wheel_spin
		lda	#01b
		rts
Not_wheel_spin
		lda	<kart_flag+01h,x
		bit	#00000001b
		beq	Not_warning_sound
		lda	#01101b
		rts
Not_warning_sound
		lda	#0000h
		xba
		lda	<event_index,x
		phx
		tax
		jmp	(!Event_sound_address,x)
Event_sound_address
		word	Nomal_event,Jump_event,Obake_fall,Maguma_fall
		word	Water_fall,Out_of_barns,Move_by_force,Lift_down
Maguma_fall
Out_of_barns
		plx
		stz	<engine_power,x
Kart_reverse_sound
		lda	#1101b
		rts
Obake_fall
		plx
		stz     <engine_power,x
Cut_se
		lda	#1111b			;cut sound
		rts
Water_fall
		plx
		lda	#0011b
		rts
Move_by_force
Lift_down
		plx
		stz	<engine_power,x
		lda	#1010b				;jugem lift down
;----------------------------------------------------------------------------
		rts
Nomal_event
		plx
		lda	#00h
		xba
		lda	<drift_index,x
		phx
		tax
		jmp	(!Check_drift_sound,x)
Check_drift_sound
		word	No_drift_effect
		word	Dlift_L1,Dlift_L1
		word	Dlift_L2,Dlift_L2
		word	Spin,Spin
		word	Spin,Spin
		word	Dash,Dash
		word	After_crash
		word	Spin_jump
		word	Spin_crash
		word	Corect_drift
;----------------------------------------------------------------------------
Spin
Spin_crash
		plx	
		stz	!engine_power+00h,x
		stz	!engine_power+01h,x
Spin_sound
		lda	#1001b
		rts
Set_resist_sound
		ldy	<vector_velocity+01h,x
		beq	Check_warning_sound
		rts
;----------------------------------------------------------------------------
Jump_event
Spin_jump
		plx
		bra	Check_warning_sound
;----------------------------------------------------------------------------
Dash
No_drift_effect
Corect_drift
		plx
Check_another_SE
		lda	<vector_velocity+01h,x
		beq	Check_warning_sound
		ldy	<resist_status,x
		lda     !Resist_area_sound,y
		bpl	Set_resist_sound
		lda	<kart_control+01h,x
		bit	#01000000b			;brake y button
		bne	Set_brake
Check_warning_sound
		lda	<kart_flag+01h,x
		bit	#00000100b
		bne	Kart_reverse_sound
;
		lda	<game_status
		bne	Not_gramprix
		lda	<kart_lap,x
		cmp	#084h
		bcc	Not_final_lap
		lda	<rank_number,x
		cmp	#08h
		bcc	Not_final_lap
		lda	#1101b
		rts
Not_final_lap
Not_gramprix
		lda	#1111b			;clear SE
		rts
Dlift_L1
Dlift_L2
Dlift_L3
		plx
		lda	<kart_status+00h,x
		bit	#00000100b
		beq	Check_another_SE
Slip_sound
		lda	<vector_velocity+01h,x
		beq	Check_warning_sound
		ldy     <resist_status,x
		lda     !Resist_area_sound,y
		bpl	Set_resist_sound
		lda	!map_type
		lsr	a
		tay
		lda	!Slip_sound_data,y
		rts
;----------------------------------------------------------------------------
After_crash
		plx
		bra	Slip_sound
Set_brake
		lda	#0000b
		rts	
;----------------------------------------------------------------------------
Slip_sound_data	
		byte	0ch,01h,01h,01h,01h,01h,02h,01h	
Resist_area_sound
		word	Road,Road,Road,Road,Road,Road,Road,Road
		word	Bridge_sound,Road
		word	Dart_sound,Dart_sound
		word	Snow_sound,Grass_sound
		word	Water_sound,Water_sound
Road		equ	0ffffh
Dart_sound	equ	0100b
Snow_sound	equ	0111b
Grass_sound	equ	0101b
Water_sound	equ	1000b
Bridge_sound	equ	0110b
;----------------------------------------------------------------------------
bank81		sect	rel
;----------------------------------------------------------------------------
		mem16
Race_sound_init
		lda	!ending_flag
		beq	Nomal_race_init
		rts
Nomal_race_init
		stz     !se_pointer
		stz	!bgm_pointer
		stz	!doppler_driver
		stz	<sound_00
		ldx	!map_type
		lda	!Echo_data,x
		sta	<sound_02
		lda	#0000000010000000b	;clear enemy mini!!!
						;b0.b1.b2=dummy!!!!
		sta	<sound_size
;
		lda	#01h
		sta	!trigger_pointer
		ldx	<game_mode
		jmp	(!Init_sound_sub,x)
Init_sound_sub
		word	Play02_mode,Control_1,Control_2
Control_1
		jsr	!Check_size1000
		lda	#07ch
		sta	!trigger_buffer
		ldx	#1000h
		jmp	!Set_engine_sub100
Control_2
		jsr     !Check_size1100
		lda	#07ch
		sta	!trigger_buffer
		ldx	#1100h
		bra	Set_engine_sub100
Play02_mode
		jsr	!Check_size1000
		jsr	!Check_size1100
		lda	#7dh
		sta	!trigger_buffer
		ldx	#1000h
		jsr	!Set_engine_sub100
		ldx	#1100h
		bra	Set_engine_sub200
;----------------------------------------------------------------------------
Check_size1000
		lda	!1000h+thunder_timer
		beq	Big_1000
Mini_1000
		lda	#0000000001000000b
		bra	Set_sound_size
Big_1000
		lda	#0000000000010000b	
		bra     Set_sound_size
Check_size1100
		lda	!1100h+thunder_timer
		beq	Big_1100
Mini_1100
		lda	#0000000000100000b
		bra	Set_sound_size
Big_1100
		lda	#0000000000001000b		
Set_sound_size
		tsb	<sound_size
		rts		
;----------------------------------------------------------------------------
Other_RAM
		lda	#01h
		sta	!bgm_pointer
		lda	#04h
		sta	!bgm_buffer
Drivers_point
		lda	#0111111100000000b
		sta	<sound_00
		stz	<sound_02
		lda	#01h
		sta	!trigger_pointer
		lda	#7ch			;1p mode trigger
		sta	!trigger_buffer
		rts
;---------------------------------------------------------------------------
;						X=index
;						Y=trigger-pointer
Set_engine_sub100
		ldy	<driver_number,x
		lda	!Engine_sound_data,y
		bra	Set_engine_to_buffer
Set_engine_sub200
		ldy	<driver_number,x
		lda	!Engine_sound_data,y
		clc
		adc	#04h
Set_engine_to_buffer
		ldy	!trigger_pointer
		sta	!trigger_buffer,y
		inc	!trigger_pointer
		rts
;---------------------------------------------------------------------------
Not_trans_BGM
		ldx	<game_selecta
		cpx	#0ah
		beq	Drivers_point
		rts
;---------------------------------------------------------------------------
Engine_sound_data
		word	070h,070h,071h,073h,071h,072h,072h,073h
;---------------------------------------------------------------------------
Echo_data
		word	On_echo,Off_echo,Off_echo
		word	Off_echo,On_echo,Off_echo,On_echo
		word	Off_echo;(battle)
		word	On_echo
On_echo		equ	1000000000000000b
Off_echo	equ	0000000000000000b
;----------------------------------------------------------------------------
		mem16
		idx16
Sound_initialize
		lda	!bgm_flag
		bne	Not_trans_BGM
		dec     !bgm_flag
		stz	!bgm_pointer
		stz	!se_pointer
		lda	#0011111100000000b
		sta	!Sound0
		stz	!Sound2
		jsl	>Sound_wait
		ldx	<game_selecta
		jmp	(!Sound_init_address,x)
;---------------------------------------------------------------------------
Sound_init_address
		word	No_game,Race,Title,Kart_select,World_select
		word	Drivers_point,Ending,Battle
		word	Edit1,Edit2,Edit3,Cource_select,Final,No_game
		word	No_game
;---------------------------------------------------------------------------
Title
		jsr	!Other_RAM
		ldx	#opening
		bra	BGM_transport
;---------------------------------------------------------------------------
Ending
		jsr	!Other_RAM
		ldx     #ending
		bra	BGM_transport
;---------------------------------------------------------------------------
Final
		jsr	!Other_RAM
		lda	!Player_rank_flag
		beq	Win_granprix
;Losr granprix
		ldx	#final02
		bra	BGM_transport
Win_granprix
		ldx	#final01
		bra     BGM_transport
Kart_select
World_select
Cource_select
		jsr	!Other_RAM
		ldx	#select
		bra	BGM_transport
Race
Battle
No_game
Edit1
Edit2
Edit3
		rts
;---------------------------------------------------------------------------
		mem16
Set_battle_BGM
		ldx	#battle
		bra	BGM_transport
Set_race_BGM
Set_BGM
		lda	!ending_flag
		bne	Not_trans
		ldx	!map_type
		lda	!BGM_data,x
		and	#00ffh
		tax
BGM_transport
		lda	!o_demo_flag
		bne	Not_trans
						;X----set BGM address
		ldy	!BGM_address+00h,x
		lda	!BGM_address+02h,x
		and	#00ffh
		ldx	#0c000h
		jsl	>Decode_7F_X
		mem8
		sep	#00100000b
		stz	!Sound3
		stz	!Sound2
		stz	!Sound1
		stz	!Sound0
;
		jsl     >Sound_wait
;
		lda	#01fh
		sta	!Sound0		;set sound trans
		jsl     >Sound_wait
		ldy	#0c000h
		lda	#007fh
		jsl	>Boot_APU
		mem16
		rep	#00110000b
		stz	!Sound0
		stz	!Sound2
		jsl	>Sound_wait
Not_trans
		rts
;---------------------------------------------------------------------------
opening		equ	0000h*03h
select		equ	0001h*03h
circuit		equ	0002h*03h
grass		equ	0003h*03h
dart		equ	0004h*03h
sand		equ	0005h*03h
ice		equ	0006h*03h
obake		equ	0007h*03h
castle		equ	0008h*03h
battle		equ	0009h*03h
final01		equ	000ah*03h
final02		equ	000bh*03h
star		equ	000dh*03h	
ending		equ	000ch*03h	
;---------------------------------------------------------------------------
BGM_data					;depend on map number
;race
		word	obake,circuit,grass,dart
		word	ice,sand,castle,star
;battle
		byte	battle
;---------------------------------------------------------------------------
BGM_address
		lword	Title_BGM,Select_BGM
		lword	Circuit_BGM,Grass_BGM,Dart_BGM
		lword	Sand_BGM,Ice_BGM,Obake_BGM,Castle_BGM
		lword	Battle_BGM,Final01_BGM,Final02_BGM
		lword	Ending_BGM,Star_BGM
;---------------------------------------------------------------------------
		mem16
Sound_resister_clear
		stz	!Sound0
		stz	!Sound1
		rts
;---------------------------------------------------------------------------
		mem16
Sound_buffer_clear
		stz	<sound_02
		rts
;---------------------------------------------------------------------------
BGM_fade_out
		stz	!bgm_flag
					;next trans enable!!!
		lda	#01eh
		sta	!bgm_buffer
		lda	#01h
		sta	!bgm_pointer
		lda	#003fh
		sta	<sound_01
		stz	<sound_02
		rtl
;---------------------------------------------------------------------------
Cut_SE
		lda	#0fh
		sta	<sound_01
		stz	<sound_02
		rtl
;---------------------------------------------------------------------------
Clear_engine
		lda	<sound_02
		and	#1000000010000000b
		sta	<sound_02
		rtl
;---------------------------------------------------------------------------
stop_BGM	equ	0000h
game_BGM	equ	0001h
signal		equ	0002h
urtra_status	equ	0003h
first_prise	equ	0004h
second_prise	equ	0005h
third_prise	equ	0006h
;
mario_BGM	equ	0007h
luigi_BGM	equ	0008h
koopa_BGM	equ	0009h
peach_BGM	equ	000ah
kong_BGM	equ	000bh
nokonoko_BGM	equ	000ch
kinopio_BGM	equ	000dh
yossy_BGM	equ	000eh
;
fadeout_BGM	equ	000fh
;---------------------------------------------------------------------------
APU_initialize
		mem16
		idx16
		lda	#00082h
						;set sound data address
		ldy	#08000h
						;828000h---------
		jsl	>Boot_APU
						;return mam8,idx16
		mem16
		rep	#00110000b
		jsl	>Sound_wait
		lda	#04020h			;pirorirorin!!!!!
		sta	!Sound0
		jsl     >Sound_wait
		lda     #04000h
		sta	!Sound0			;clear trigger!!!!
		stz	!bgm_pointer
		rts
;---------------------------------------------------------------------------
		mem16
		idx16
Sound_wait
		ldx	#04000h
Wait_loop
		dex
		bne	Wait_loop
		rtl
;---------------------------------------------------------------------------
Boot_APU
		mem8
		SEP	#00100000B
		STY	<address+0	;W
		STA	<address+2	;B
		LDY	#0		;W	data pointer
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		LDX	#0BBAAH		;W
boot_initial	CPX	!Sound0		;W
		BNE	boot_initial
		LDA	#0CCH		;B
		BRA	boot_entry1
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
boot_repeat	JSR	!Get_data
		XBA
		LDA	#0		;B
		BRA	boot_entry2
boot_loop	XBA				;2 cycle=36+7n
		JSR	!Get_data	;B	
		XBA				;2
boot_wait1	CMP	!Sound0		;B	;4 maximam responce=17
		BNE	boot_wait1		;2/3
		INC	A		;B	;2
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
boot_entry2	REP	#00100000B		;2
		STA	!Sound0		;W	;5
		SEP	#00100000B		;2
		DEX			;W	;2
		BNE	boot_loop		;3/2
boot_wait2	CMP	!Sound0		;W
		BNE	boot_wait2
boot_zero	ADC	#3		;B
		BEQ	boot_zero
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
boot_entry1	PHA			;>
;- - - - - - - - - - - - 
		JSR	!Get_data
		XBA
		JSR	!Get_data
		XBA
		TAX			;WW	counter
		JSR	!Get_data
		STA	!Sound2		
		JSR	!Get_data
		STA	!Sound3		;W	address
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		CPX	#1		;W
		LDA	#0		;B
		ROL	A		;B
		STA	!Sound1		;B (1)or(0)
		ADC	#07FH		;B CLC
		PLA			;<
		STA	!Sound0		;B
boot_wait3	CMP	!Sound0		;B
		BNE	boot_wait3
		BVS	boot_repeat	
		RTL
;-----------------------------------------------------------------------
Get_data	LDA	[<address],Y	;W	; data count
		INY			;W
		CPY	#08000H
		BNE	get_exit
		INC	<address+2	;B (bank)
		LDY	#0		;W
get_exit	RTS
;----------------------------------------------------------------------------
		mem16
Check_trigger_SE
		phx
		pha
		cpx	#1100h
		beq	Trigger_2
		bcc	Trigger_1
		pla
		plx
		rtl
SE_trigger_1
		phx
		pha
Trigger_1
		lda	!1000h+kart_flag
		bpl	Return_check_trigger
		bit	#0000000000100000b
		bne	Return_check_trigger
		pla
		bra	Check_sound_1
SE_trigger_2	
		phx
		pha
Trigger_2
		lda	!1100h+kart_flag
		bpl     Return_check_trigger
		bit     #0000000000100000b
		bne	Return_check_trigger
		pla
		bra	Check_sound_2	
Return_check_trigger
		pla
		plx
		rtl	
;----------------------------------------------------------------------------
						;A=20h,21h........7fh
Trigger_sound_1
		phx
Check_sound_1
		phy
		php
		rep	#00110000b
		ldx	!o_demo_flag
		bne	Skip_trigger
Set_1p_trigger
		ldy	#00000h
		jsr	!Set_se_buffer
		plp
		ply
		plx
		rtl
Skip_trigger
		stz	!se_pointer
Not_set_trigger
		plp
		ply
		plx
		rtl
Trigger_sound_2
		phx
Check_sound_2
		phy
		php
		rep	#00110000b
		ldx	<game_mode
		cpx	#04h
		beq	Set_1p_trigger
		ldx     !o_demo_flag
		bne     Skip_trigger
		ldx	!g_kart_flag
		bne	Not_set_trigger
		ldy	#0ffffh
		jsr     !Set_se_buffer	
		plp
		ply
		plx
		rtl
Set_se_buffer
		ldx	!se_pointer
		cpx	#06h
		bcs	Over_se
		sta	!se_buffer,x
		tya
		sta	!pan_buffer,x
		inx
		inx
		stx	!se_pointer
Over_se
		rts
Coin_sound
Jump_sound
Spin_jump_sound
Landing_sound
Dash_sound
Crash_sound
Falling_sound
Splash_sound
Balloon_sound
Lost_sound
Kame_sound
Cursor_sound
		rtl
		end
