;****************************************************************************
;*	Mario Kart							    *
;*			Caluclation & Check Subroutins			    *
;*						1992.07.13		    *
;****************************************************************************
		glb	Tan,Ending_control			;bank81
		glb	Calc_move_direction,Calc_target		;bank81
		glb	Calc_timer,Check_drift_data
		glb	All_check_rank,ALL_check_rank
		glb	Mykart_check,Ending_selecta
		glb	Set_rank_address,Goalin_control
		glb	Game_control,Race_checker
		glb	Clear_RAM_7F,Clear_RAM_00		;bank81
		glb	Start_final_count,Correct_times
		glb	Pause_off_sound,Rank_subroutin
		glb	Check_crash_mykart,Check_crash_enemy
		glb	Clear_clear_rank			;bank84
;----------------------------------------------------------------------------
		ext	Character_palet,Start_ending_02
		ext	Sec_data,Tan_data,Check_target_direction
		ext	Mark_animation,Set_ROM_to_buffer
		ext     Start_title,Ending_race,Set_rank_mark
		ext	Init_character,Set_HDMA_data
		ext	BGM_fade_out,Calc_vector_velocity
		ext	Start_title,Set_mark_point,Check_trigger_SE
		ext	Retry_race,Next_race,Open_BG_data,Another_initial
;----------------------------------------------------------------------------
		include work.def
		include buffer.def
		include label.def
		include ../join/object.def
		include rp5a22
		include rp5c77
		include D77C25
;****************************************************************************
up_counter	equ	000h
;
vector_x	equ	000h		;from -01h to +02h(00h-03h) 
vector_y	equ	002h		;       ;         (04h-07h)
sign_data	equ	004h		;sign checker  2byte
bigger		equ	006h
smaller		equ	00ah		;4byte need
tempolary	equ	00ch
;
angle_data	equ	000h		;4byte
kasuu		equ	004h
;
decimal_data	equ	000h
second_data	equ	002h
minute_data	equ	004h
area_def	equ	006h
area_data	equ	008h
;
first_count	equ	000h
second_count	equ	001h
third_count	equ	002h
fourth_count	equ	003h
;****************************************************************************
bank80		sect	rel
;----------------------------------------------------------------------------
		mem16
		idx16
Ending_control
		lda	!ending_counter
		bne	Counter_decrece
		lda	!trans_map
		bne	Now_transporting
		lda	#0ffffh  
		sta	!ending_status
		jsl	>Another_initial
		stz	!ending_status
		lda	#ending_time		;5 second
		sta	!ending_counter
		rts		
Counter_decrece
		dec	!ending_counter
		bne	Continue_ending
;Counter-ZERO
		lda	!ending_pattern
		inc	a
		inc	a
		cmp	#10h
		bcc	Next_ending
		lda	#1200h
		sta	!ending_counter
		jmp	>Start_ending_02
Next_ending
		sta	!ending_pattern
		jsl	>Ending_selecta
		jsl	>Open_BG_data
		lda	#8000h
		sta	!trans_map
		rts
Continue_ending		
		jsr	!Ending_race
Now_transporting
		rts
;----------------------------------------------------------------------------
Select_world
	word	Star,Special,Special,Star,Star,Special,Special,Special
Select_pointer	
	word	004h,000h,002h,003h,001h,001h,003h,004h
;---------------------------------------------------------------------------
Star		equ	02h
Special		equ	03h
;----------------------------------------------------------------------------
Ending_selecta
		phb
		phk
		plb
		ldx	!ending_pattern
		txa
		and	#010b
		inc	a
		inc	a
		sta	<game_mode
		stz	<game_status
		stz	!game_level
		lda	!Select_world,x
		sta	!world_number
		lda	!Select_pointer,x
		sta	!map_pointer
		plb
		rtl
;----------------------------------------------------------------------------
		mem16
		idx16
Calc_area_def
		lda	<kart_area,x
		sta	<area_data
		sed
		phx
		ldx	!rank_index-02h,y
		lda	!random
		and	#09900h
		bcc	Not_over_random
		lda	#0000h
Not_over_random
		clc
		adc	<driver_time+00h,x
		sta	<decimal_data
		lda	<driver_time+02h,x
		sta	<second_data
		lda	<driver_time+04h,x
		sta	<minute_data
		cld
		lda	<kart_area,x
		mem8
		sep	#00100000b
		xba
		cmp	<area_data+01h	;lap!!!
		beq	Same_lap
		sta	<area_data+01h
		xba
		mem16
		rep	#00100000b
		clc
		adc	!area_number
		bra	Calc_def
Same_lap
		xba
Calc_def
		mem16
		rep	#00100000b
		sec
		plx
		sbc	<kart_area,x
		lsr	a
		lsr	a
		lsr	a
		lsr	a
		inc	a
		sta	<area_def
End_correct_times
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Correct_times
		ldy	#02h
Correct_times_loop
		ldx	!rank_index,y
		beq	End_correct_times
		lda	<driver_time+04h,x
		bpl	Next_correct
		lda	<kart_flag,x
		beq	Next_correct
		bmi	Next_correct
		jsr	!Calc_area_def
Cont_time_correct
		sed
		lda	<second_data
		clc
		adc	#01h
		sta	<second_data
		cmp	#0060h
		bne	Not_over_second
		stz	<second_data
		inc	<minute_data
Not_over_second		
		dec	<area_def
		bne	Cont_time_correct
		lda	<second_data
		sta     <driver_time+02h,x
		lda	<minute_data
		sta	<driver_time+04h,x
		lda	!Corect_decimal_data,y
		clc
		adc	<decimal_data
Not_over_99h
		sta	<driver_time+00h,x
		cld		
Next_correct
		iny
		iny
		bra	Correct_times_loop
Not_goalin_kart
		rts
;----------------------------------------------------------------------------
Corect_decimal_data
		word	0123h,1234h,2345h,3456h,4567h,5678h,6789h,7890h
;----------------------------------------------------------------------------
		mem16
		idx16
Goalin_control
		ldy	!goalin_pointer
		beq	Not_goalin_kart
		jsr	!All_check_rank
		cpy	#04h
		bne	Goalin_set
Same_time_goalin
		ldx	!goalin_buffer+00h
		ldy	!goalin_buffer+02h
		lda	!obj_pos_yh,y
		cmp	<obj_pos_yh,x
		beq	Same_pos_y
		bcc	Win_y
		bra	Win_x
		lda	!rank_number,x
		cmp	!rank_number,y
		bcs	Goalin_set
Same_pos_y
		lda	!vector_velocity,y
		cmp	<vector_velocity,x
		beq	Same_velocity
		bcs	Win_x
		bra	Win_y
		lda	!rank_number,x
		cmp	!rank_number,y
		bcs	Goalin_set
Same_velocity
		lda	<kart_flag,x
		bmi	Win_x
Win_y
		stx	!goalin_buffer+02h
		sty	!goalin_buffer+00h
		phy
		txy
		plx
Win_x
Corect_time
		sed
		lda	<driver_time+00h,x
		sec	
		sbc	#100h
		sta	<driver_time+00h,x
		bcs	End_correct
		lda	<driver_time+00h,x
		sec
		sbc	#01h
		sta	<driver_time+02h,x
		bcs	End_correct
		lda	#59h
		sta	<driver_time+02h,x
		dec	<driver_time+04h,x
End_correct
		cld
		lda	<rank_number,x
		cmp	!rank_number,y
		bcc	Goalin_set
		pha
		lda	!rank_number,y
		sta	<rank_number,x
		pla
		sta	!rank_number,y
		tax
		lda	!goalin_buffer+02h
		sta	!rank_index+00h,x
		lda	!goalin_buffer+00h
		sta	!rank_index-02h,x
Goalin_set
		ldy	#00h
Goalin_set_loop
		ldx	!goalin_buffer,y
		phy
		lda     <kart_flag,x
		bpl	Skip_1up_check
		jsr	!Set_final_lap
		jsl	>Check_1_up
Skip_1up_check
		jsr	!Set_rank_mark
		ply
		iny
		iny
		cpy	!goalin_pointer
		bcc	Goalin_set_loop
		stz	!goalin_pointer
		rts
;----------------------------------------------------------------------------
Set_final_lap
		cpx	#1000h
		bne	Set_lap_1100
		ldy	#00h+04h*06h
		bra	Set_driver_time
Set_lap_1100
		ldy	#01eh+04h*06
Set_driver_time
		lda	<driver_time+00h,x
		sta	!laptime_buffer+00h,y
		lda	<driver_time+02h,x
		sta     !laptime_buffer+02h,y
		lda	<driver_time+04h,x
		sta     !laptime_buffer+04h,y
		rts
;----------------------------------------------------------------------------
Check_drift_data			;Check
					; super dash enable 
					;reverse check enable
		word    OK,OK,OK,OK,OK
		word    NO,NO,NO,NO
		word    OK,OK,OK,OK,NO,OK
OK              equ     00000h
NO              equ     0ffffh
;----------------------------------------------------------------------------
		mem16
		idx16
Mykart_check
		lda	<frame_counter
		and	#11111000b
		cmp	#11111000b
		beq	Engine_size_check
		lda	<event_index,x
		bne	Engine_size_check
		ldy	!drift_index,x
		lda	!Check_drift_data,y
		bne	Engine_size_check
		jsr	!Check_target_direction
;						;A=mark_direction
		sec
		sbc	<body_direction,x
		bpl	Plus_def
		eor	#0ffffh
		inc	a
Plus_def
		sta	<tempolary
		lda	<game_status
		cmp	#06h
		bcs	Return_check	;battle?
;
		lda	<kart_flag,x
		bit	#0000010000000000b
		bne	Reverse_status
		lda	<tempolary
		cmp	#07000h
		bcs	Set_reverse
		rts
Reverse_status
		lda	<tempolary
		cmp	#03000h
		bcc	Clear_reverse
Return_check
		rts
;--------------------------------------------------------------------------
Engine_size_check
		lda	!sound_size
		bne	Return_check
		ldy	!se_pointer
		cpy	#04h
		bcs	Return_check
		lda	<thunder_timer,x
		bne	Return_check
		inc	!se_pointer
		inc	!se_pointer
		cpx	#1100h
		beq	Check_size_1100
		lda	#7eh
		sta	!se_buffer,y
		rts
Check_size_1100
		lda	#7fh
		sta	!se_buffer,y
		rts
;--------------------------------------------------------------------------
Set_reverse
		lda	<kart_flag,x
		ora	#0000010000000000b
		sta	<kart_flag,x
		lda     <official_control,x
		ora	#0001000000000000b
		bra	Set_official_flag
Clear_reverse
		lda     <kart_flag,x
		and	#1111101111111111b
		sta	<kart_flag,x
		lda	<official_control,x
		ora	#0000100000000000b
Set_official_flag
		sta	<official_control,x
		rts		
;----------------------------------------------------------------------------
		mem16
		idx16
Game_control
		lda	!rom_checker
		beq	Skip_software_reset
		lda	<game_selecta
		bne	Skip_software_reset
		ldx	#0000h
		jsr     !Reset_check
		ldx	#0002h
		jsr     !Reset_check
Skip_software_reset
		rts
;----------------------------------------------------------------------------
Race_checker
		ldx	<game_mode
		jmp	(!Game_control_address,x)
Game_control_address
		word	Play12,Play01,Play02
Play12
		ldx	#0002h
		jsl	>Pause_check
		ldx	#0000h
		jsl	>Pause_check
		rts		
Play01
		ldx	#0000h
		jsl	>Pause_check
		ldy	#0000h
		ldx	#0002h
		bra	Display_check
Play02
		ldx	#0002h
		jsl	>Pause_check
		ldy	#0002h
		ldx	#0000h
;---------------------------------------------------------------------------
Display_check
		lda	!o_demo_flag
		bne	Disable_change_mode
		lda     !replay_flag
		bmi     Disable_change_mode
		lda     !goalin_number
		beq	Not_yet_goalin
		lda     !camera_counter
		bne     Now_changing_mode	;now changing mode
		lda	<camera_mode,x
		cmp	#0002h			;back milar ?
		beq     Change_long_pers
		rts
Not_yet_goalin
		lda     !camera_counter     
		bne	Now_changing_mode       ;now changing mode
		lda	!pause_status
		bmi	Disable_change_mode
		lda	!camera_control,y
		bit	#0000000001000000b
		bne	Disable_change_mode
		bit	#0000000000100000b
		beq	Not_auto_dips_change
		and	#1111111111011111b
		sta	!camera_control,y
		bra	Change_disp_mode
Not_auto_dips_change
		lda	!button_trigger,y
		bit	#0010000001000000b
		beq	Disable_change_mode
Change_disp_mode
		lda	<camera_mode,x
		cmp	#02h
		beq	Change_long_pers
Change_back_milar
		lda	#0002h
		bra	Set_change_mode
Change_long_pers
		lda	#0006h
Set_change_mode
		sta	!camera_mode_stock
;
		ldy	<game_mode
		lda	!Camera_count_data-02,y		
		sta	!camera_counter
		rts
Now_changing_mode
		dec	!camera_counter
Disable_change_mode
		rts
;---------------------------------------------------------------------------
Camera_count_data
		word	05h,06h
;---------------------------------------------------------------------------
Pause_check
		lda	!pause_wait
		beq	Pause_wait_off
		dec	!pause_wait
		rtl
Pause_wait_off
		lda	!signal_counter
		bpl	Disable_pause
		lda	!fanfare_counter
		bne	Disable_pause
		lda	!pause_status
		bmi	Cont_pause
		lda	<camera_control-01h,x
		bmi	Disable_pause
		lda	<button_trigger,x
		bit	#0001000000000000b
		beq	Disable_pause
Start_pause
		lda     !camera_counter
		bne     Disable_pause			;now changing mode
		stx	!pause_index
		ldy	!camera_index,x
		lda	!kart_flag,y
		bit	#0010000000000000b
		bne	Disable_pause
		lda	#1100000000000000b		;set pose flag
		sta	!pause_status
Pause_on_sound
		lda	#10000000b
		tsb	<sound_00
Disable_pause
Cont_pause
		rtl
Pause_off_sound
		lda	#10000000b
		trb	<sound_00		
		rtl
;----------------------------------------------------------------------------
Reset_check
		lda	<button_status,x
		and	#1101000000000000b
		cmp	#1101000000000000b
		bcc	Not_reset
		lda	<button_trigger,x
		bit	#0010000000000000b
		beq	Not_reset
		jsl	>BGM_fade_out
		jsr	!Start_title
		lda	<game_index
		cmp	#10h
		beq	Edit_reset
		cmp	#12h
		bne	Goto_reset
Edit_reset
		jsl	>Init_character
Goto_reset
Not_reset
		rts
;----------------------------------------------------------------------------
Start_final_count
		phb
		phk
		plb
		lda	#-0f0h-20h-40h			;(0f0h+020h+40h)
		sta	!game_counter
		lda	#08000h
		ldx	<game_mode
		jmp	(!Set_count_address,x)
Set_count_address
		word	Mode_00_set,Mode_02_set,Mode_04_set
Mode_00_set
		sta	!1000h+official_control
Mode_04_set
		sta	!1100h+official_control
		plb
		rtl
Mode_02_set
		sta	!1000h+official_control
		plb
		rtl
;----------------------------------------------------------------------------
ALL_check_rank
		phb
		phk
		plb
		jsr	!All_check_rank
		plb
		rtl
;----------------------------------------------------------------------------
All_check_rank
		phx
		phy
		ldy	#002h
All_check_loop
		phy
		jsr	!Check_rank_sub
		ply
Next_check_index
		iny
		iny
		cpy	#10h
		bcc	All_check_loop
		ply
		plx
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Rank_subroutin
		phx
		ldy	<rank_number,x
;						;entry 00h-0ch
		jsr	!Check_rank_sub
		plx
		rts
;---------------------------------------------------------------------------
Check_rank_sub
Set_rank_loop
		cpy	#0000h
		beq	Skip_rank_checker
		ldx	!rank_index+00h,y
		beq	Skip_rank_checker
		lda	<kart_area,x
		phx
		ldx	!rank_index-02h,y
		beq	Not_change_rank
		cmp	<kart_area,x
		beq	Not_change_rank
		bcc	Not_change_rank
;excahnge rank data
		lda	<kart_flag,x
		bit	#0000000000100000b	;goalin flag
		bne	Not_change_rank
		txa	
		sta	!rank_index+00h,y	;>>>>rank down!!!
		tya
		sta	<rank_number,x
;
		plx
		txa
		sta	!rank_index-02h,y	;>>>>rank up!!!
		tya
		dec	a	
		dec	a
		sta	<rank_number,x
		tay
		bra	Set_rank_loop
Not_change_rank
		plx
Skip_rank_checker
		rts
;----------------------------------------------------------------------------
Set_rank_address
		word	202h+00h*04h,202h+02h*04h,202h+04h*04h,202h+06h*04h
		word	422h+00h*04h,422h+02h*04h,422h+04h*04h,422h+06h*04h
;----------------------------------------------------------------------------
		mem16
		idx16
Calc_timer
		sed				;set decimal bit
		lda	!decimal_timer
		clc
		adc	#166h
		sta	!decimal_timer
		bcs	Inc_second
		cld
		rts
Inc_second
		lda	!second_timer
		clc
		adc	#01h
		cmp	#0060h
		beq	Inc_minute
		sta	!second_timer
		cld
		rts
Inc_minute
		stz	!second_timer
		lda	!minute_timer
		clc
		adc	#0001h
		cmp	#010h
		bcc	Not_over_time
		lda	#09999h
		sta	!decimal_timer
		lda	#059h
		sta	!second_timer
		lda	#09h
Not_over_time
		sta	!minute_timer
		cld
		rts
;--------------------------------------------------------------------------
Check_crash_enemy					;A=kart_flag
		and	#1110111111111111b
		sta	<kart_flag,x
		phy
		phx
		lda	<obj_velocity_y,x
		tay
		lda	<obj_velocity_x,x
		tax
		jsl	>Calc_move_direction
		plx
		ply
		bcc	Cant_calc_direc
		sta	<move_direction,x
Cant_calc_direc
		rts
;-------------------------------------------------------------------------
Check_crash_mykart				;A=kart flag
		and	#1110111111111111b
		sta	<kart_flag,x		;clear vacter change flag
Not_04_st
		phy
		phx
		lda	<obj_velocity_y,x
		tay
		lda	<obj_velocity_x,x
		tax
		jsl     >Calc_move_direction
		plx
		ply
		bcc	Cant_calc_direc_crash
						;x&y=too small
		lda	<kart_direction,x
		sta	<move_direction,x
		stz	<drift_angle,x
		bra	Correction_engine		
Cant_calc_direc_crash
		sta	<tempolary
		sec
		sbc	<kart_direction,x
		bmi	Minus_check_angle
		cmp	#02000h
		bcs	Level_02_crash
Level_01_crash
		sta	<drift_angle,x
		lda	<kart_control,x
		bpl	Level_02_crash
		lda	<tempolary
		sta     <move_direction,x
		lda	#01ch
		sta	<drift_index,x		;ajust drift
		bra	Correction_engine
Minus_check_angle
		cmp     #-2000h
		bcs	Level_01_crash
Level_02_crash
		sta	<drift_angle,x
		lda	#016h
		sta	<move_status,x
		sta	<drift_index,x		;start special drift
Correction_engine
		lda	<engine_power,x
		lsr	a
		cmp	#0100h
		bcs	Not_minimum_engine
		lda	#0100h
Not_minimum_engine	
		sta	<engine_power,x	
		jsr     !Calc_vector_velocity
						;A resister=vector velocity
		rts
;----------------------------------------------------------------------------
bank81		sect	rel
;----------------------------------------------------------------------------
		mem16
		idx16
;							;X=RAM address
;							;A=RAM bank
;							;Y=counter
Clear_RAM_7F
		pha
		lda	!ending_flag
		bne	Ending_clear
		pla
		sty	!DMA_0+05h
		ldy	#offset Clear_7F
		sty	!DMA_0+02h
		bra	Set_address_bank
Clear_RAM_00
		sty	!DMA_0+05h			;trans data
		ldy	#offset Clear_00
		sty	!DMA_0+02h
Set_address_bank
		stx	!2181h				;set RAM address
		mem8
		sep	#00100000b
		and	#00000001b			;00 or 7e bank=00
							;7f bank=01h
		sta	!2183h				;set RAM bank
		lda	#bank Clear_00
		sta     !DMA_0+04h                      ;data bank=01h
		lda	#00001000b
		sta	!DMA_0+00h
						; b3=adress fixed
		lda	#080h
		sta	!DMA_0+01h
						;B-address80h(set 2180h)
						;from 0000h address
;
		lda	#01h
		sta	!DMA_burst		;DMA switch
;		
		rep	#00100000b
		rtl
		mem16
Ending_clear
		pla
		rtl
;----------------------------------------------------------------------------
Clear_7F	byte	007fh
Clear_00	byte	0000h
;----------------------------------------------------------------------------
		mem16
		idx16
						;x=obj_velocityx
						;y=obj_velocityy
Calc_move_direction
Calc_target
		txa
		ldx	#0000h
		cmp	#0000h
		beq	Vect_x_0
		bpl	Velotict_x_plus
		eor	#0ffffh
		inc	a
		ldx	#04h
Velotict_x_plus
		sta	<vector_x
		tya
		beq	Vect_y_0
		bpl	Velotict_y_plus
		eor	#0ffffh
		inc	a
		inx
		inx	
Velotict_y_plus
		sta	<vector_y
		cmp	<vector_x
		bcs	Vect_y_bigger
Vect_x_bigger
		lda	#003fh
Cont_loop_x
		cmp	<vector_x
		bcs	End_loop_x
		lsr	<vector_x
		lsr	<vector_y
		bra	Cont_loop_x	
End_loop_x;------------------------------------------------------------------
		lda	<vector_y
		xba
		lsr	a
		lsr	a
		clc
		adc	<vector_x
		jsr	(!Lookup_VX,x)
		and	#0ff00h
		clc
		rtl
Vect_y_bigger;---------------------------------------------------------------
		lda	#003fh
Cont_loop_y
		cmp	<vector_y
		bcs	End_loop_y
		lsr	<vector_x
		lsr	<vector_y
		bra	Cont_loop_y
End_loop_y;------------------------------------------------------------------
		lda	<vector_x
		xba
		lsr	a
		lsr	a
		clc
		adc	<vector_y
		jsr	(!Lookup_VY,x)
		and	#0ff00h
		clc
		rtl
Lookup_VX;-------------------------------------------------------------------
		word	Table_x0,Table_x1,Table_x2,Table_x3
Lookup_VY;-------------------------------------------------------------------
		word	Table_y0,Table_y1,Table_y2,Table_y3
Vect_x_0;--------------------------------------------------------------------
		tya
		beq	Vect_xy_0
		bpl	Velo_y_plus
		lda	#0000h
		clc
		rtl
Velo_y_plus
		lda	#08000h
		clc
		rtl
Vect_y_0;--------------------------------------------------------------------
		cpx	#0000h
		beq	Velo_x_plus
		lda	#0c000h
		clc
		rtl
Velo_x_plus
		lda	#04000h
		clc
		rtl
Vect_xy_0;-------------------------------------------------------------------
		sec
		rtl
Table_x0;--------------------------------------------------------------------
		tax
		clc
		lda	#04000h
		adc	>direc_buffer-01h,x
		clc
		rts
Table_x1;--------------------------------------------------------------------
		tax
		lda	#040ffh
		sec
		sbc	>direc_buffer-01h,x
		clc
		rts
Table_x2;--------------------------------------------------------------------
		tax
		lda	#0c0ffh
		sec
		sbc	>direc_buffer-01h,x
		clc
		rts
Table_x3;--------------------------------------------------------------------
		tax
		clc
		lda	#0c000h
		adc	>direc_buffer-01h,x
		clc
		rts
Table_y0;--------------------------------------------------------------------
		tax
		sec
		lda	#080ffh
		sbc	>direc_buffer-01h,x
		clc
		rts
Table_y1;--------------------------------------------------------------------
		tax
		lda	>direc_buffer-01h,x
		clc
		rts
Table_y2;--------------------------------------------------------------------
		tax
		clc
		lda	#08000h
		adc	>direc_buffer-01h,x
		clc
		rts
Table_y3;--------------------------------------------------------------------
		tax
		lda	>direc_buffer-01h,x
		and	#0ff00h
		eor	#0ffffh
		inc	a
		clc
		rts
;----------------------------------------------------------------------------
Ofset_direc
		byte	040h,080h,000h,0c0h
;----------------------------------------------------------------------------
		mem16
		idx16
				;entry     
				;	x=vector x (signd)
				;       y=vector y (  ;  )
Tan
		stz	<sign_data
		tya
		beq	Y_vect_zero
		bpl	Y_vector_plus
		eor	#0ffffh
		inc	a
		inc	<sign_data
Y_vector_plus
		sta	<bigger
		tay
;
		txa
		beq	X_vect_zero
		bpl	X_vector_plus
		eor	#0ffffh
		inc	a
		inc	<sign_data
		inc	<sign_data
X_vector_plus
		cmp	<bigger
		bcc	Y_bigger_than_X
		sta	<bigger
		sty	<smaller
		bra	Calc_tangent
Y_bigger_than_X
		sta	<smaller
		lda	#0000000000000100b
		tsb	<sign_data
;----------------------------------------------------------------------------
Calc_tangent
		stz	<smaller-02h
		lda	#0100h
Check_y_100h
		cmp	<bigger
		bcs	Go_to_devide
		lsr	<bigger
		lsr	<smaller+00h
		ror	<smaller-02h
		bra	Check_y_100h
		mem16
		idx16
Go_to_devide
		lda	<smaller-01h
		sta	!Dividend
		lda	<bigger+00h
		sta	!Divisor+00h
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		ldx	!Quotient+00h
		cpx     #100h
		bcc     Not_over_qu
		ldx	#0ffh
Not_over_qu
		mem8
		idx8
		sep	#00110000b
;;;		lda	>Tan_data,x
		lda	>tan_table,x
		ldx	<sign_data
		pha
		lda	>Phase_sign,x
		beq	Not_minus_phase
		pla
		eor	#0ffh
		inc	a
		clc
		adc	>Phase_offset,x
		rts
Not_minus_phase
		pla
		clc
		adc	>Phase_offset,x
		rts
;----------------------------------------------------------------------------
Y_vect_zero
		txa
		beq	XY_vect_zero
		mem8
		idx8
		sep	#00110000b
		bpl	X_vect_PL
		lda	#0c0h
		rts
X_vect_PL
		lda	#040h
		rts
;----------------------------------------------------------------------------
X_vect_zero
		mem8
		idx8
		sep	#00110000b
		lda	<sign_data
		bne	Y_vect_MI
		lda	#00h
		rts
Y_vect_MI
		lda	#080h
		rts		
;----------------------------------------------------------------------------
XY_vect_zero
		sep	#00110000b
		lda	#00h
		rts
;----------------------------------------------------------------------------
Y_axis_data
		byte	00h,080h,00h,080h
X_axis_data
		byte	040h,040h,0c0h,0c0h
;
Phase_sign
		byte	0ffh,000h,000h,0ffh,000h,0ffh,0ffh,000h
Phase_offset
		byte	040h,040h,0c0h,0c0h,000h,080h,000h,080h
;----------------------------------------------------------------------------
bank84		sect	rel
;----------------------------------------------------------------------------
		mem16
		idx16
Clear_clear_rank
		ldx	#0eh
		lda	#0ffffh
Clear_CR_loop
		sta	!clear_rank,x
		dex
		bpl	Clear_CR_loop
		rtl		
;----------------------------------------------------------------------------
Check_1_up
;						X=index
		lda	<game_status
		bne	NO_GRANDPRIX
		phx
		mem16
		idx16
		ldy	#0eh
		lda	#00h
Clear_check_work
		sta	!up_counter,y
		dey
		bpl	Clear_check_work
		ldy	!map_pointer
		cpx	#1100h
		beq	UP_1100
UP_1000
		lda     !1000h+rank_number
		bra	Set_clear_rank
UP_1100
		tya
		clc
		adc	#08h
		tay
		lda	!1100h+rank_number
Set_clear_rank
		sta	!clear_rank,y
Check_up_loop
		mem8
		idx8
		sep	#00110000b
		lda	!clear_rank,y
		bmi	Next_up_loop
		tax
		inc	<up_counter,x
Next_up_loop
		cpy	#00h
		beq	End_up_loop
		cpy	#08h
		beq	End_up_loop
		dey
		bra	Check_up_loop
End_up_loop
		ldx	#000eh
		lda	#02h
Check_1up_loop
		cmp	<up_counter,x
		bcc	Set_1up_flag
		dex
		dex
		bpl	Check_1up_loop
		rep	#00110000b
		plx
		stz	<one_up_flag,x
		rtl
Set_1up_flag
		lda	#0ffh
		sta	!clear_rank+00h,y
		sta	!clear_rank+01h,y
		sta	!clear_rank+02h,y
		rep	#00110000b
		plx
		dec	<one_up_flag,x	
NO_GRANDPRIX
		rtl
		end

