;****************************************************************************
;*	Mario Kart							    *
;*			Initiarize control module			    *
;*							1992.07.13	    *
;****************************************************************************
		glb	Initialize_process
		glb	Selection_process
		glb	Character_palet
		glb	Init_character,Open_BG_data,Another_initial
		glb	VRAM_address,Character_palet,Obj_num_data
		glb	Set_ROM_to_buffer,Set_map_number
		glb	World_map_data,Set_map_address
;----------------------------------------------------------------------------
		glb	Title_sub		
		glb	Start_title,Start_ending_02
		glb	Start_K_select,Start_C_select
		glb	Retry_race,Next_race,Result_race
		glb	Set_back_01,Set_back_02
;----------------------------------------------------------------------------
		ext	Set_sound,Set_BGM,Set_battle_BGM
		ext	Pers_init,Set_pers_data
		ext	Cos_data,Sin_data,ROM_checker_8
		ext	Tan,Clear_RAM_00,Ending_objinit
		ext	Display_select,Ending_selecta
		ext	Initial_pers_param,Initial_camera
		ext	Initial_enemy,Init_enemy_perform
		ext	Initial_OBJ_trans,Correct_times
		ext	Performance_data,Max_speed_perform
		ext	Resist_perform,Steering_perform
		ext	Drift_perform,Accel_perform
		ext	Sound_resister_clear,BGM_fade_out
		ext	Sound_initialize,APU_initialize
		ext	All_check_rank,ALL_check_rank
		ext	Start_fainal_count,Init_ghostkart
		ext	Regular_IRQ_init,Race_sound_init
;----------------------------------------------------------------------------
		ext	Init_ranker,Rank_number_data,Clear_clear_rank
		ext	BG_attribute_data_offset,BG_attribute_data_bank
		ext	Common_BG,Set_race_BGM,BG_CHECK_DATA
		ext	Driver_init_posx,Driver_init_posy,Driver_init_direc
		ext	Set_ABC,Set_nintendo,Ending2_init
;----------------------------------------------------------------------------
		ext	OBJ_initial,Battle_objinit,Free_objinit
		ext	Decode_7E_X,Decode_M7,Decode_7F_X
		ext	Decode_mode3,Decode_M7_BF,Convert_m1m7
		ext	Set_BG_item,Set_changeBG
		ext	Clear_sprite
		ext	WINDOW_INIT,Init_powerON
		ext	ED_init_1,ED_init_2,ED_init_3,DP_init,Final_init
		ext	TITL_init,NAME_init,K_SL_init,W_SL_init,C_SL_init
		ext	DOS_INI,DOS_INI_1
;----------------------------------------------------------------------------
		include rp5a22
		include rp5c77
		include work.def
		include buffer.def
		include label.def
		include label-j.def
		include ../join/object.def
		include D77C25
;----------------------------------------------------------------------------
disable_rank	equ	0000h		;(4byte)
;
read_address	equ	0000h
write_address	equ	0004h
read_address_dash equ	0008h
tempolary	equ	010h
pointer		equ	018h
address		equ	01ah
counter		equ	01ch
prio_data	equ	01eh
;
x_counter	equ	010h
y_counter	equ	012h
screen_address	equ	014h
;
dist_data	equ	012h
;
h_pos_data	equ	000h
v_pos_data	equ	002h
;----------------------------------------------------------------------------
bank81		sect 	rel
;----------------------------------------------------------------------------
		mem16
		idx16
Initialize_process			;input mem8 idx8
		phb
		phk
		plb
		rep	#00110000b
		jsr	!RAM_initialize
					;blanking on!!!
					;this process will carry out before 
					;the main routine starts 
		jsl	>Set_nintendo
					;blanking off!!!
		jsr	!APU_initialize
		jsr	!DSP_init
		jsr	!Set_pers_data
		jsl	>Init_character
		jsl	>Direction_init
		jsl	>DOS_INI
		lda	#00f00h
		sta	!fade_control
		lda	#001ah		;dummy game index
		sta	!game_index
		mem8
		sep	#00100000b
		cli
		lda	#10110001b
		sta	!NMI_control	;NMI enable
		mem16
		idx16
		rep	#00110000b
		lda	#04h
		sta	<game_selecta
		lda	#08f00h
		sta	<fade_control
		lda	#0060h
		sta	!fade_speed
		plb
		rtl
;----------------------------------------------------------------------------
Selection_address
	word	Not_select,Race_initial
	word	Title_initial
	word	Kart_select_initial,World_select_initial
	word	DP_initial,Ending1_initialize
	word	Battle_initial,Edit1_initial,Edit2_initial,Edit3_initial
	word	Course_select_initial,Final_initialize,Not_select
	word	Ending2_initialize
;----------------------------------------------------------------------------
		mem16
		idx16
						;x=game_selecta
Selection_process
		lda	<game_selecta
		beq	Not_select
		lda	!fade_data
		cmp	#8000h
		bne	Not_select
		mem8
		idx8
		sep	#00110000b
		phb
		phk
		plb
		stz	!DMA_burst
		stz	!DMA_syncro
		lda	<game_index
		sta	!old_game_index
		stz	<game_index	;initial NMI &main index
		stz	<irq_index
		sei			;Interupt disable
		stz	!NMI_control	;NMI disable
		mem16
		idx16
		rep	#00110000b
		jsr	!Sound_initialize
;
		ldx	<game_selecta
		jsr	(!Selection_address,x)	
;
		lda	#0001h
		sta	<fade_control
		lda	<game_selecta
		sta	<game_index
		stz	<game_selecta
		mem8
		idx8
		sep	#00110000b
   		cli
		lda	#10110001b
		sta	>NMI_control	;NMI eneble
		rep	#00110000b
		plb
Not_select
		rtl
;----------------------------------------------------------------------------
		mem16
		idx16
Title_initial
		jsl	>DOS_INI_1
		jsr     !Resister_clear		;mem8  idex8
		jsr	!Set_title_data
		jsr	!Set_item_OBJ
Check_title_init
		stz	!rom_checker
		ldx	#06h
Check_8M_mode
		lda	>ROM_checker_8,x
		cmp	!Rom_checker_4,x
		bne	Not_8M_mode
		dex
		bpl	Check_8M_mode
		dec	!rom_checker
Not_8M_mode
		lda	!o_demo_flag
		beq	Not_return_demo
		stz	!o_demo_flag
		lda	!mode_stock
		sta	<game_mode
		lda	!status_stock
		sta	<game_status
		lda	!level_stock
		sta	!game_level
		lda	!world_stock
		sta	!world_number
		lda	!driver1_stock
		sta	!1000h+driver_number
		lda	!driver2_stock
		sta	!1100h+driver_number
Not_return_demo
		jsl	>TITL_init		
		stz	!race_init		;fast_initial
		stz	!ending_flag
		jsr	!Set_spark
		rts
;----------------------------------------------------------------------------
Set_title_data
		ldy	#offset Title_data
		lda	#bank Title_data	;Title_data=ROM address
		ldx	#0000h			;RAM address
		jsl	>Decode_7F_X		;set data to 7f0000h
Set_select_data
		ldy	#offset Select_data
		lda	#bank Select_data	;Title_data=ROM address
		ldx	#0c000h			;RAM address
		jsl	>Decode_7F_X		;set data to 7fc000h
		rts
;----------------------------------------------------------------------------
Kart_select_initial
		jsr	!Set_select_data
		jsl	>K_SL_init
		rts
;---------------------------------------------------------------------------
World_select_initial
		jsr	!Set_select_data
		jsl	>W_SL_init
		rts
;----------------------------------------------------------------------------
Ending2_initialize
		jsr     !Open_ending_col
		jsl	>Ending2_init
		rts
;---------------------------------------------------------------------------
Ending1_initialize
		lda	#mario
		sta	!1000h+driver_number
		dec	!ending_flag
		stz	!ending_pattern
		lda	#06h
		sta	<race_status
		stz	!1d0ch			;---trans map
		lda	#ending_time
		sta	!ending_counter
		jsl	>Ending_selecta
		jsr	!Ending_initial
		jsr	!Open_ending_col
		mem16
;open alphabet
		ldy	#offset MOJI_ENDING
		lda	#bank MOJI_ENDING
		ldx	#0a000h			;RAM address
		jsl	>Decode_7F_X		;set data to 7f0000h
;;;
		lda	#04600h
		sta     !Screen_address
		lda	#1801h
		sta     !DMA_0+00h
		lda	#0a000h
		sta	!DMA_0+02h
		lda	#20h*060h
		sta     !DMA_0+05h
		mem8
		sep	#00100000b
		lda	#07fh
		sta	!DMA_0+04h
		lda	#80h
		sta	!Screen_step
		lda	#01h
		sta	!DMA_burst		
		mem16
		rep	#00100000b
		ldx	#1700h
Prio_clear_loop
		stz	<driver_priority,x
		txa
		sec
		sbc	#100h
		tax
		cpx	#1000h
		bcs	Prio_clear_loop
		rts
;---------------------------------------------------------------------------
		mem16
		idx16
Race_initial
		ldx	!race_init
		lda	!Initial_race_status,x
		sta	<race_status
		jmp	(!Race_initial_address,x)
;----------------------------------------------------------------------------
Initial_race_status
		word	00h,00h,02h,02h,08h,02h,02h,00h
;----------------------------------------------------------------------------
Race_initial_address				;race init=
		word	World_initial				;00h
		word	Map_initial				;02h
		word	Retry_initial				;04h
		word	Map_initial;(skip opening demo&retry)	;06h
		word	Debug_initial				;08h
		word	Free_initial				;0ah
		word	Retry_free				;0ch
		word	Demo_initial				;0eh
;----------------------------------------------------------------------------
World_initial
		stz	!map_pointer
		jsl	>Clear_clear_rank
Demo_initial
Debug_initial
Ending_initial
		jsr	!Initial_granprix
		jsr	!Init_package_100
Map_initial
		jsr	!Set_map_number		;m-pointer&world-num>>map-num
		jsr	!Init_package_200
		jsr	!Set_BGM
Every_initial
		jsr	!Init_package_300
		jsr	!Kart_flag_init
		jsl	>OBJ_initial
		jsr	!Race_RAM_init
		jsr	!Set_priority
  	        jsr     !Init_ranker		;rank display obj set
		jsr	!Init_package_400
		rts
Retry_initial
		jsl     >ALL_check_rank
		bra	Every_initial
;--------------------------------------------------------------------------
Free_initial
		lda	#02h
		sta	<race_status
		lda	!game_mode_stock
		sta	<game_mode
		jsr	!Init_package_100
		jsr	!Init_package_200
		jsr	!Set_race_BGM
Retry_free
		jsl	>Init_ghostkart
		jsr	!Set_kart_perform
		jsr	!Free_RAM_init_100
		jsr	!Init_package_300
		jsl     >Free_objinit
		jsr	!Free_RAM_init_200
		jsr	!Init_package_400
		rts
;---------------------------------------------------------------------------
		mem16
		idx16
Battle_initial
		lda	#02h
		sta	<race_status
		lda	!game_mode_stock
		sta	<game_mode
		jsr	!Set_kart_perform
		jsr	!Init_package_100
		jsr	!Init_package_200
		jsr	!Set_battle_BGM
		jsr	!Battle_RAM_init
		jsr	!More_battle
		jsr	!Init_package_300
		jsl     >Battle_objinit
		jsr	!Init_package_400
		jsr	!Set_battle_OBJ
		jsr	!Set_OBJ_400
		rts
;-----------------------------------------------------------------------------
Course_select_initial
		lda	<game_mode
		sta	!game_mode_stock
		lda	#02h
		sta	<game_mode
		jsr	!Pers_init
		jsr	!Resister_clear
		jsr	!Free_RAM_init_100
		jsl	>C_SL_init
		jsr     !Set_map_type           ;map-num>>>map_type
		jsr	!Set_maps
		jsr	!Initial_camera_buffer
		jsr	!Initial_camera
		jsr	!Race_resister_init
		bra	Init_package_500
;----------------------------------------------------------------------------
Another_initial
		phb
		phk
		plb
		jsr     !Pers_init
		jsr	!Set_map_type		;map-num>>>map_type
		jsr     !Initial_enemy
		jsr     !Set_attribute
		jsr     !Initial_camera_buffer
		jsr     !Initial_camera
		jsr     !Race_resister_init
		jsl	>Ending_objinit
		jsr	!Race_RAM_init
		jsl     >WINDOW_INIT
		jsr     !Initial_opening_demo
		plb
		rtl
;----------------------------------------------------------------------------
Init_package_100
		jsr     !Pers_init
		jsr	!Set_OBJ_100
		lda	<game_status
		cmp	#04h
		beq	Skip_set_item
		jsr	!Set_item_OBJ
Skip_set_item
		rts
;----------------------------------------------------------------------------
Init_package_200
		jsr	!Resister_clear
		jsr	!Set_map_type		;map-num>>>map_type
		jsr	!BG_attribute_set
		jsr	!Set_map_character
		jsr	!Set_OBJ_200
		jsr     !Initial_enemy
		rts
;----------------------------------------------------------------------------
Init_package_300
		jsr     !Timer_init
		jsr     !Clear_coin
		jsr	!Set_attribute
		jsr	!Set_map_screen
		jsr     !Set_OBJ_300
Init_package_500
		jsr     !Initial_camera_buffer
		jsr	!Initial_camera
		jsr	!Race_resister_init
		jsr	!Open_color
		rts
;----------------------------------------------------------------------------
Init_package_400
		jsl	>WINDOW_INIT
		jsr     !Initial_opening_demo
		jsr	!Race_sound_init
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
DP_initial
		jsr     !Resister_clear
		ldy	#offset CHECKER
		lda	#bank   CHECKER
		ldx	#0000h
		jsl	>Decode_7F_X		;set checker flag character
;
		lda	#04000h
		sta	!Screen_address
		lda	#080h
		sta	!Screen_step
		lda	#0001h
		sta	!DMA_0+00h
		lda	#0018h
		sta	!DMA_0+01h
		lda	#07f00h
		sta	!DMA_0+03h
		lda	#040h*020h		;OBJ 20h character
		sta	!DMA_0+05h
		ldx	#0001h
		stx	!DMA_burst
		ldy	#offset Title_data
		lda	#bank   Title_data	;Title_data=ROM address
		ldx	#0000h			;RAM address
		jsl	>Decode_7F_X		;set data to 7f0000h
		ldy	#offset Select_data
		lda	#bank   Select_data	;Title_data=ROM address
		ldx	#0c000h			;RAM address
		jsl	>Decode_7F_X		;set data to 7fc000h
		jsr     !Set_2bit_moji
		jsl	>DP_init
		rts
;---------------------------------------------------------------------------
Final_initialize
		ldy	#offset	Final_data
		lda	#bank	Final_data	;final data ROM address
		ldx	#0c000h			;set ROM to 7fc000h
		jsl     >Decode_7F_X
		ldy	#0c000h
		lda	#0007fh
		ldx	#00000h
		jsl     >Decode_7F_X
;pukupuku OBJ to MODE7
		ldx	#02400h			;from 7f2800h
		ldy	#0c000h			;  to 7fc000h
		lda	#00c98h			;low counter=098h
						;high attlibute=0ch
		jsl	>Convert_m1m7
;manto GAME OBJ to MODE7
		ldx	#00000h+060h*020h	;kanban address
		ldy	#0e800h
		lda	#00240h			;low counter=040h
						;high attlibute=0ch
		jsl     >Convert_m1m7
		jsl	>Final_init
		rts
;----------------------------------------------------------------------------
Edit1_initial
		jsr	!Edit_package
		jsl	>ED_init_1
		rts
;----------------------------------------------------------------------------
Edit2_initial
		jsr	!Edit_package
		jsl	>ED_init_2
		rts
;----------------------------------------------------------------------------
Edit3_initial
		jsr	!Edit_package
		jsl	>ED_init_3
		rts
;----------------------------------------------------------------------------
Edit_package
		jsr	!Set_item_BG
		jsr	!Set_map_type		;map-num>>>map_type
		jsr	!Set_maps
		rts		
;----------------------------------------------------------------------------
Clear_coin
		ldx	!game_status
		jmp	(!Coin_sub,x)
Coin_sub
		word	Granprix_coin,VS_coin,Timeattack_coin,Battle_coin
Granprix_coin
		ldx	!1000h+rank_number
		lda	!Coin_num_data,x
		sta     !player_coin+00h
		ldx	!1100h+rank_number
		lda	!Coin_num_data,x
		sta     !player_coin+02h
		rts
Timeattack_coin
Battle_coin
		lda	#00h
		bra	Set_coin_num
VS_coin
		lda	#03h
Set_coin_num
		sta	!player_coin+00h
		sta	!player_coin+02h
		rts
;----------------------------------------------------------------------------
Coin_num_data
		word	0002h,0002h,0003h,0003h,0004h,0004h,0005h,0005h
;----------------------------------------------------------------------------
		mem8
		idx8
DSP_init
		sep	#00110000b
		ldx	#128
		lda	#dsp_reset
Reset_dsp_loop
		sta	!DSP_data
		dex
		bne	Reset_dsp_loop
		rep	#00110000b
		rts
;-----------------------------------------------------------------------------
		mem16
		idx16
Timer_init
		stz	!decimal_timer
		stz	!second_timer
		stz	!minute_timer
		rts
;-----------------------------------------------------------------------------
		mem16
		idx16
RAM_initialize						;bank 1 prog
		rep	#00110000b
		mem16
		idx16
;						;RAM clear
		lda	#00000h
		sta	>07fffffh		;clear 7fffffh
		lda	#0007eh
		ldx	#02000h
		ldy	#0e000h			;from 7e2000-7effff
		jsl     >Clear_RAM_00
		lda	#0007fh
		ldx	#00000h
		ldy	#0ffffh
		jsl     >Clear_RAM_00		;from 7f0000-7ffffe
;----------------------------------------------------------------------------
		lda	!1000h+driver_number
		and	#1111111111111110b
		cmp	#0fh
		bcc	Ok_1000_driver
		lda	#00h
Ok_1000_driver
		sta	<00h			;stock!!!
		lda     !1100h+driver_number
		and	#1111111111111110b
		cmp	#0fh
		bcc	Ok_1100_driver
		lda	#02h
Ok_1100_driver
		sta	<02h			;stock
		ldx	#00032h
		ldy	#01f30h-32h		;from 032h-1f00h
		jsl	>Clear_RAM_00
;----------------------------------------------------------------------------
		lda	<00h
		sta	!1000h+driver_number
		lda	<02h
		sta	!1100h+driver_number
;----------------------------------------------------------------------------
Power_on_RAM_init
		lda	<game_status
		and	#1111111111111110b
		cmp	#07h
		bcc	OK_game_status
		lda	#00h
OK_game_status
		sta	<game_status
		lda	<game_mode
		and	#1111111111111110b
		cmp	#05h
		bcc	OK_gaeme_mode
		lda	#02h
OK_gaeme_mode
		sta	<game_mode
		lda	<game_level
		and	#1111111111111110b
		cmp	#05h
		bcc	OK_game_level
		lda	#00h
OK_game_level
		sta	<game_level
;
		jsl	>Init_powerON
;
		lda	#0000h
		sta	!reset_status
;
		sed
		clc
		lda	!m_win_count+00h
		adc	!m_win_count+02h
		adc	!b_win_count+00h
		adc	!b_win_count+02h
		cmp	!win_sum
		beq	OK_win_count
		stz	!m_win_count+00h
		stz	!m_win_count+02h
		stz	!b_win_count+00h
		stz	!b_win_count+02h
OK_win_count
		cld
		rts
;----------------------------------------------------------------------------
Direction_init
		mem16
		idx16
		rep	#00110000b
;
		ldy	#offset TAN_DATA
		lda	#bank   TAN_DATA
		ldx	#offset tan_table
		jsl	>Decode_7F_X
;
		ldx	#00h
		stz	<x_counter
Set_direc_loop1
		stz	<y_counter
Set_direc_loop2
		phx
		ldy	<y_counter
		cpy	<x_counter
		bcc	X_bigger_Y
		ldx	<x_counter
		phy
		jsr	!Tan
		mem8
		idx16
		rep	#00010000b
		ply
		plx
		bra	Set_direc_buffer
X_bigger_Y
		mem16
		idx16
		ldx	<y_counter
		ldy	<x_counter
		phy
		jsr	!Tan
		mem8
		idx16
		rep	#00010000b
		ply
		plx
		sec
		sbc	#040h
		eor	#0ffh
		inc	a
Set_direc_buffer
		sta	>direc_buffer,x
		inx
		mem16
		rep	#00110000b
		lda	<y_counter
		cmp	#003fh
		beq	Next_x_angle
		inc	<y_counter
		bra	Set_direc_loop2
Next_x_angle
		lda	<x_counter
		inc	a
		cmp	#0040h
		beq	End_direc_loop
		sta	<x_counter
		bra	Set_direc_loop1
End_direc_loop
		rtl
;---------------------------------------------------------------------------
Resister_clear
		mem8
		idx8
		sep	#00110000b
		lda	#00000010b
		sta	!Sprite_size
					;sprite size=8or16 b567=00
					;OBJ bank use 0&1  b34=00
					;OBJ base addr=4000h b012=04
		stz	!Screen_bank+00h
					;mode7's screen addr=0000h
		lda	#01111011b
		sta	!Screen_bank+01h; BG 1
		sta	!Screen_bank+02h; BG 2
		sta	!Screen_bank+03h; BG 3
					;mode0's screen addr=078h(7800h)
					;screen size=03h
;		lda	#01100000b
		lda	#01110000b
		sta	!Screen_segment+00h
					;mode7's(BG1) char seg.=00
					;mode0's(BG2) char seg.=07(7000h)
		lda	#01110111b
		sta	!Screen_segment+01h
					;mode0's(BG3) char seg.=07
					;mode0's(BG4) char seg.=07(7000h)
		lda	#11000000b
		sta	!Screen_flip
					;out of screen=no.0 char b67=10
		lda	#01h
		lda	#00010000b
		sta	!Through_screen+00h
;						;through main
;						;main=BG12& OBJ
		sta	!Through_window+00h
;						;through main (windwo)
		stz	!Through_screen+01h
;						;through sub disable
;		
		stz	!Through_window+01h
;						;through sub (window)
		stz	!Color_brend 		;color add disable
		stz	!PPU_option
						;b7=0 not super inpose
						;b6=0 not ext input
						;b45  not use
						;b3=0 not 512 mode
						;b2=0 224 line/1 field
						;b1=0 OBJ V select
						;b0=0 non interless 
		stz	!Timer_H+00h
		stz	!Timer_H+01h
						;H count timer
		stz	!Timer_V+00h
		stz	!Timer_V+01h
						;V count timer
		stz	!Timer_control
						;disable timer
		stz	<irq_index
		stz	!DMA_burst
		stz	!DMA_syncro
						;DMA&H-DMA off
						;NMI disable
						;IRQ disable
						;controler disable
		rep	#00110000b
		rts
;----------------------------------------------------------------------------
Race_resister_init
		mem8
		sep	#00100000b
		lda	#080h
		sta	!Timer_H+00h
		stz	!Timer_H+01h
		stz	!Timer_V+01h		;set HV timer
		lda	#10110001b
		sta	!Timer_control		;HV timer enable
		rep	#00100000b
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
;----------------------------------------------------------------------------
Init_character
		phb
		phk
		plb
		jsr	!Set_2bit_moji
		jsr	!Set_4bit_moji
		jsr	!Set_item_OBJ
		plb
		rtl
;----------------------------------------------------------------------------
Set_item_OBJ
		ldy	#offset ITEM
		lda	#bank ITEM		;MARK & ITEM=ROM address
		ldx	#offset item_obj	;RAM address
		jsl	>Decode_7F_X		;set data to 7f8000h
		rts		
;----------------------------------------------------------------------------
Set_2bit_moji
		ldy	#offset MOJI
		lda	#bank MOJI		;moji character 2bit mode
		ldx	#04400h
		jsl	>Decode_7F_X
						;set 7f4400h
		rts
;----------------------------------------------------------------------------
Set_4bit_moji
		phb
		lda	#07fh
		pha
		plb
		ldy	#00000h			;from 7f4400h
		ldx	#00000h
T24_loop0
		lda	#0008h
		sta	<counter
T24_loop1
		lda	!04400h,y
		sta	!0A000h,x		;to 7f6000h
		inx
		inx
		iny
		iny	
		dec	<counter
		bne	T24_loop1	
		lda	#0008h
		sta	<counter		
T24_loop2
		stz	!0A000h,x
		inx
		inx
		dec	<counter
		bne	T24_loop2
		cpy	#02000h
		bne	T24_loop0
End_trans_loop
		plb
		plb
		rts
;----------------------------------------------------------------------------
Set_battle_OBJ
		rep	#00110000b
;Set ball
		lda	#080h
		sta	!Screen_step
;offset BALL
		lda	#bank BALL
		ldy	#offset BALL
		ldx	#0c000h
		jsl	>Decode_7F_X
;
		lda	#05200h
		sta	!Screen_address+00h
						;set VRAM
						;001=2 address(L&H)
		lda	#001h
		sta	!DMA_0+00h
		lda     #18h
		sta     !DMA_0+01h
						;set 2118h
		lda	#07fc0h
		sta	!DMA_0+03h
						;data address=7F0000h
		lda	#0400h
		sta	!DMA_0+05h
						;trans value=60h
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
		lda	#06200h
		sta	!Screen_address+00h
		lda	#07fc0h
		sta	!DMA_0+03h
						;data address=7F0000h
		lda	#0400h
		sta	!DMA_0+05h
						;trans value=60h
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
		rts
;----------------------------------------------------------------------------
Set_maps
		jsr	!Set_map_character
		jsr	!Set_map_screen
		jsr	!Open_color
		rts
;----------------------------------------------------------------------------
Set_map_character
		jsr     !Set_item_BG
		jsr	!Open_character
		jsr	!Set_character_data
		jsl     >Set_changeBG
		rts
;----------------------------------------------------------------------------
Set_map_screen
		jsr	!Open_screen
		jsl     >Set_BG_item
		jsr	!Set_screen_data
		rts
;----------------------------------------------------------------------------
Set_map_address
		lda	!map_number
		asl	a
		clc
		adc	!map_number
		tax
		rts
;----------------------------------------------------------------------------
Open_BG_data
		phb
		phk
		plb
		jsr	!Set_map_number		;m-pointer&world-num>>map-num
		jsr	!Set_map_type
		jsr	!BG_attribute_set
		jsr	!Set_ROM_to_buffer
		jsr	!Open_ending_col
		jsl     >Set_changeBG
		plb
		rtl
;----------------------------------------------------------------------------
Open_ending_col
		ldy	#offset ENDING_COL
		lda	#bank   ENDING_COL
		ldx	#offset color_buffer+100h
		jsl	>Decode_7E_X
		rts
;----------------------------------------------------------------------------
Set_ROM_to_buffer
		jsr	!Set_map_type
		jsr	!Open_screen
		jsr	!Open_character
		jsr	!Open_color
		rts
;----------------------------------------------------------------------------
Set_buffer_to_PPU
		jsr	!Set_character_data
		jsr	!Set_screen_data
		rts
;----------------------------------------------------------------------------
Set_item_BG
		jsr	!Set_item_BG_buffer
;set vram
		lda	#080h
		sta	!Screen_step		;High bit INC
;
		lda	#0c0h*040h
		sta	!Screen_address+00h
		stz	!DMA_0+00h
		lda	#0019h
		sta	!DMA_0+01h
		lda	#07f70h
		sta	!DMA_0+03h
						;set bank&highaddress
;						;from 7f4000h address
		lda	#040h*40h
		sta	!DMA_0+05h
;						;trans quantity=4000
		lda	#00001h
		sta	!DMA_burst
;
		rts		
;----------------------------------------------------------------------------
Set_item_BG_buffer
		ldy	#offset BG_ITEM
		lda	#bank  BG_ITEM
		ldx	#0000h
		jsl	>Decode_7F_X
		ldx	#0000h			;resd address
		ldy	#4000h+0c0h*040h	;wright address
		lda	#040h
		jsl     >Decode_M7_BF
		rts
;----------------------------------------------------------------------------
Open_character
		jsr	!Calc_index
		lda	>Mode7_character_address+00h,x
		tay
		lda	>Mode7_character_address+02h,x
		and	#00ffh
		ldx	#0c000h
		jsl	>Decode_7F_X
		ldx	#0c000h			;read address
		ldy	#04000h			;write address
		lda	#0c0h			;amount of character
		jsl	>Decode_M7_BF
;set mode0 character
		jsr	!Calc_index
		lda	>Back_character_address+00h,x
		tay
		lda	>Back_character_address+02h,x
		and	#00ffh
		ldx	#0c800h
		jsl	>Decode_7F_X
;
		lda	#bank ABC
		ldy	#offset ABC			;slot charcter(59262h)-abc.
		ldx	#0d000h
		jsl	>Decode_7F_X			;to 7fd000h(0800h)
;set mode 0 screen
		jsr	!Calc_index
		lda	>Back_screen_address+00h,x
		tay
		lda	>Back_screen_address+02h,x
		ldx	#0c000h				;set 7fc000h
		jsl	>Decode_7F_X
		rts
;----------------------------------------------------------------------------
Open_color
;						entry map type
		jsr	!Calc_index
		lda	>Color_data_address+00h,x
		tay
		lda	>Color_data_address+02h,x
		and	#00ffh
		ldx	#offset color_buffer
		jsl	>Decode_7E_X
		rts
;----------------------------------------------------------------------------
Open_screen
		jsr	!Set_map_address
		lda	>Mode7_screen_address+00h,x
		tay
		lda	>Mode7_screen_address+02h,x
		and	#00ffh
		ldx	#0c000h
		jsl	>Decode_7F_X		;first ROM to 7fc000h
		ldy	#0c000h
		lda	#07fh
		ldx	#0000h
		jsl	>Decode_7F_X            ;second 7fc000h to 7f0000h
		rts
;----------------------------------------------------------------------------
Set_character_data		
;Set_mode7_char
		lda	#080h
		sta	!Screen_step		;High bit INC
;
		stz	!Screen_address+00h
		stz	!DMA_0+00h
		lda	#0019h
		sta	!DMA_0+01h
		lda	#07f40h
		sta	!DMA_0+03h
						;set bank&highaddress
;						;from 7f4000h address
		lda	#04000h-040h*40h
		sta	!DMA_0+05h
;						;trans quantity=4000
		lda	#00001h
		sta	!DMA_burst
Set_back_char
		lda	#07000h
		sta	!Screen_address		;VRAM address
		lda	#01801h
		sta	!DMA_0+00h
						;    b0123=0000 INC step
						;01h=set 2118h(resister)
						;00h=data address low
		stz	!DMA_0+02h
		lda	#07fc8h
		sta	!DMA_0+03h
						;data address=7Fc800h
		lda	#1000h
		sta	!DMA_0+05h
						;trans value=400h(80h-chr)
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
Set_back_screen
		jsr	!Set_back_01
		jsr	!Set_back_02
		rts
;----------------------------------------------------------------------------
Set_screen_data
		stz	!DMA_0+00h
		lda	#000h
		sta	!Screen_step
;						;b7=0 L bit INC
;						;b0123=INC step(1)
		stz	!Screen_address+00h
		lda	#0018h
		sta	!DMA_0+01h
;						;set 2118h resister
						;set low address
		lda	#07f00h
		sta	!DMA_0+03h
						;set bank&highaddress
;						;from 7f0000h address
		lda	#04000h
		sta	!DMA_0+05h
;						;trans quantity=4000
		lda	#00001h
		sta	!DMA_burst
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Set_back_01
		lda	#080h
		sta	!Screen_step
;
		lda	#01801h
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
	

		stz	!DMA_0+02h		;data address
		ldx	#0600h			;counter
		lda	#07800h
		ldy	#00000h+0c000h
		jsr	!Set_DMA_param	
		rts
Set_back_02
		lda	#080h
		sta	!Screen_step
;
		lda	#01801h
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
	

		stz	!DMA_0+02h		;data address
;
		ldx	#0300h			;counter
		lda	#07c00h
		ldy	#00100h+0c000h
		jsr	!Set_DMA_param	
		ldx	#0100h			;counter
		lda	#07d80h
		ldy	#00000h+0c000h
		jsr	!Set_DMA_param	
		ldx	#0100h			;counter
		lda	#07e00h
		ldy	#00500h+0c000h
		jsr	!Set_DMA_param	
		ldx	#0100h			;counter
		lda	#07e80h
		ldy	#00400h+0c000h
		jsr	!Set_DMA_param	
		rts
;----------------------------------------------------------------------------
Set_DMA_param	
;	
		sty	!DMA_0+02h		;data address
		sta	!Screen_address
		lda	#07fh
		sta	!DMA_0+04h
						;data  address bank=07fh
		stx	!DMA_0+05h
						;trans quantity=40h
;
		lda	#00000001b
		sta	!DMA_burst
						;start channel 0_DMA
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Calc_index
		lda	!map_type
		lsr	a
		clc
		adc	!map_type
		tax
		rts
;----------------------------------------------------------------------------
Open_jugem
		lda	#080h
		sta	!Screen_step
		ldy	#offset JUGEM_SHADOW
		lda	#bank JUGEM_SHADOW
		ldx	#0c000h
		jsl	>Decode_7F_X		;set  7fc000h
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Set_OBJ_100
		jsr	!Open_jugem
;
		lda	#04400h
		sta	!Screen_address+00h
		lda	#00000001b
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
		lda	#001h
		sta	!DMA_0+00h
		lda     #18h
		sta     !DMA_0+01h
						;set 2118h
		lda	#07fc2h
		sta	!DMA_0+03h
						;data address=7Fc200h
		ldx     #0001h
;
		lda	!ending_flag
		bne	Set_shadow
;
		lda	#1000h
		sta	!DMA_0+05h
						;trans value=1200h
		stx	!DMA_burst
						;start channel 0_DMA
;Set jugem lamp
		lda	#05000h-05h*10h
		sta	!Screen_address+00h	;set chr 0fbh
		lda	#0c000h+0ch*020h
		sta	!DMA_0+02h
		lda	#20h*04h
		sta	!DMA_0+05h
						;trans value=4 character
		stx	!DMA_burst
						;start channel 0_DMA
Set_shadow
		lda	#05000h-015h*010h
		sta	!Screen_address+00h	;set chr 0fbh
		lda	#0c000h+09h*020h
		sta	!DMA_0+02h
		lda	#20h*03h
		sta	!DMA_0+05h
						;trans value=4 character
		stx	!DMA_burst
						;start channel 0_DMA
Spark_set
		lda     #05000h+068h*010h
		sta     !Screen_address+00h
		lda	#0c000h+90h*20h
		sta     !DMA_0+02h
		lda     #07fh
		sta     !DMA_0+04h
		lda	#06h*20h
		sta     !DMA_0+05h
		stx     !DMA_burst
		lda     #05000h+078h*010h
		sta     !Screen_address+00h
		lda	#0c000h+96h*20h
		sta     !DMA_0+02h
		lda     #07fh
		sta     !DMA_0+04h
		lda	#06h*20h
		sta     !DMA_0+05h
		stx     !DMA_burst
;		
		lda     #06000h+068h*010h
		sta     !Screen_address+00h
		lda	#0c000h+90h*20h
		sta     !DMA_0+02h
		lda     #07fh
		sta     !DMA_0+04h
		lda	#06h*20h
		sta     !DMA_0+05h
		stx     !DMA_burst
		lda     #06000h+078h*010h
		sta     !Screen_address+00h
		lda	#0c000h+96h*20h
		sta     !DMA_0+02h
		lda     #07fh
		sta     !DMA_0+04h
		lda	#06h*20h
		sta     !DMA_0+05h
		stx     !DMA_burst
		rts
;----------------------------------------------------------------------------
Set_spark
		jsr	!Open_jugem
		ldx	#01h
		lda     #05000h+006h*010h
		sta     !Screen_address+00h
		lda	#0c000h+90h*20h
		sta     !DMA_0+02h
		lda     #07fh
		sta     !DMA_0+04h
		lda	#02h*20h
		sta     !DMA_0+05h
		stx     !DMA_burst
		lda     #05000h+016h*010h
		sta     !Screen_address+00h
		lda	#0c000h+96h*20h
		sta     !DMA_0+02h
		lda     #07fh
		sta     !DMA_0+04h
		lda	#02h*20h
		sta     !DMA_0+05h
		stx     !DMA_burst
		rts
;----------------------------------------------------------------------------
Set_OBJ_200
;						;entry map_type!!!
		jsr	!Calc_index
		ldy	!map_type
		cpy	#0eh
		bne	Not_star
		ldy	#0ch
Not_star
		sty	!obj_type
		ldy	!map_number
		cpy	#13h
		bne	Nomal_set_OBJ
		ldy	#02h
		sty	!obj_type
		ldx	#03h
Nomal_set_OBJ
		ldy	!Obstruct_address+00h,x
		lda	!Obstruct_address+02h,x
		and	#00ffh
		ldx	#04000h			;set 7f4000h
		jsl	>Decode_7F_X
;
		lda	#080h
		sta	!Screen_step
		lda	#04c00h
		sta	!Screen_address+00h
						;set VRAM
						;001=2 address(L&H)
		ldx	#001h
		stx	!DMA_0+00h
		lda     #18h
		sta     !DMA_0+01h
						;set 2118h
		lda	#07f40h
		sta	!DMA_0+03h
						;data address=7F0000h
		lda	#02bh*020h
		sta	!DMA_0+05h
						;trans value=800h
		stx	!DMA_burst
						;start channel 0_DMA
		lda	#04c00h+030h*010h
		sta	!Screen_address+00h
		lda	#04000h+030h*20h
		sta	!DMA_0+02h
		lda	#0007fh
		sta	!DMA_0+04h
						;data address=7F0000h
		lda	#00bh*020h
		sta	!DMA_0+05h
						;trans value=800h
		stx	!DMA_burst
						;start channel 0_DMA
		rts
;----------------------------------------------------------------------------
Set_OBJ_300
		jsr     !Set_effect_OBJ
		jsr	!Set_mark
		rts
;----------------------------------------------------------------------------
Set_OBJ_400
		jsr	!Set_effect_OBJ
Skip_set_waterpole
		rts
;----------------------------------------------------------------------------
Set_waterpole
Set_effect_OBJ
		lda	!ending_flag
		bne	Skip_set_waterpole
		lda	#080h
		sta	!Screen_step
;
		ldy	#offset WATER
		lda	#bank WATER
		ldx	#0c000h			;set 7fc000h
		jsl	>Decode_7F_X
		lda	#04000h
		sta	!Screen_address		;VRAM address
		ldx	#00001h
		stx	!DMA_0+00h
						;00h b7=1 H bit INC
						;    b0123=0001 INC step
		lda	#0018h
		sta	!DMA_0+01h
						;01h=set 2118h(resister)
						;00h=data address low
		lda	#07fc0h
		sta	!DMA_0+03h
						;data address=7Fc000h
		lda	#00800h
		sta	!DMA_0+05h
						;trans value=1000h
		stx	!DMA_burst
						;start channel 0_DMA
Set_sand
		ldy     #offset SAND
		lda     #bank SAND
		ldx     #offset smoke_obj           ;set 7fa000h-0400h=9c00h
		jsl     >Decode_7F_X            ;buffer set
		ldx	#01h
		lda	#05000h
		sta	!Screen_address		;VRAM address
						;    b0123=0001 INC step
		lda     #offset smoke_obj
		sta     !DMA_0+02h
						;00h=data address low
		lda     #bank smoke_obj
		sta     !DMA_0+04
		lda	#00400h
		sta	!DMA_0+05h
						;trans value=0c00h
		stx	!DMA_burst
						;start channel 0_DMA
Set_sand_2
		lda	#06000h			;VRAM address=6000h
		sta	!Screen_address+00h	;			
						;from 69200h address
		lda	#offset smoke_obj
		sta	!DMA_0+02h
						;data address=7F9c00h
		lda	#bank smoke_obj
		sta	!DMA_0+04
		lda	#00400h
		sta	!DMA_0+05h
						;trans quantity=0c00h
		stx	!DMA_burst
						;start channel 0_DMA
		rts
;----------------------------------------------------------------------------
Set_mark
		ldy	#offset MARK
		lda	#bank MARK		;MARK & ITEM=ROM address
		ldx	#offset mark_obj	;RAM address
		jsl	>Decode_7F_X		;set data to 7e2000h

		lda	#05200h
		sta	!Screen_address+00h
		ldx	#01h
						;set VRAM
						;001=2 address(L&H)
		lda	#1801h
		sta	!DMA_0+00h
						;set 2118h
		lda	#offset mark_obj_2
		sta	!DMA_0+02h
		lda     #bank   mark_obj_2
		sta     !DMA_0+04h
		lda	#34h*20h
		sta	!DMA_0+05h
						;trans value=34h character
		stx	!DMA_burst
						;start channel 0_DMA
;set face more
		lda	#06200h
		sta	!Screen_address+00h
						;set VRAM
						;001=2 address(L&H)
		lda	#1801h
		sta	!DMA_0+00h
						;set 2118h
		lda	#offset mark_obj_2
		sta	!DMA_0+02h
		lda	#bank   mark_obj_2
		sta	!DMA_0+04h
		lda	#20h*20h
		sta	!DMA_0+05h
						;trans value=20h character
		stx	!DMA_burst
						;start channel 0_DMA
;
		lda	#06400h
		sta	!Screen_address+00h
		lda	#00000001b
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
						;set 2118h
		lda	#1801h
		sta	!DMA_0+00h
		lda	#0cc80h
		sta	!DMA_0+02h
		lda	#07fh
		sta     !DMA_0+04h
		lda	#14h*20h
		sta	!DMA_0+05h
						;trans value=20h character
		stx	!DMA_burst
						;start channel 0_DMA
;
		ldy	#offset	PERAPERA
		lda	#bank	PERAPERA
		ldx	#offset perapera_obj
		jsl	>Decode_7F_X
;
		ldy	#offset LOST
		lda	#bank LOST
		ldx	#offset lost_obj
		jsl     >Decode_7F_X		;set data to 7f9800h
;
		ldy	#offset KILLER
		lda	#bank   KILLER
		ldx	#offset killer_obj
		jsl     >Decode_7F_X
		rts
;---------------------------------------------------------------------------
		mem16
bg_check_data	equ	7f0000h				;open to 7f0000h
BG_attribute_set
		ldy     #offset BG_DATA
		lda     #bank   BG_DATA
		ldx     #offset bg_check_data
		jsl     >Decode_7F_X			;open BG table
		ldy	!map_type
		ldx	!BG_check_address,y
		ldy	#0000h
		mem8
		sep	#00100000b
Set_attribute_loop
		lda	>bg_check_data,x		;on 4M (comp to ROM)
		sta	!bg_check_table,y			;from 700h
		inx
		iny
		cpy	#0c0h
		bne	Set_attribute_loop
Common_attribute
		ldx	#Common_bg
Common_loop
		lda	>bg_check_data,x
		sta	!bg_check_table,y
		inx
		iny
		cpy	#100h
		bcc	Common_loop
		mem16
		rep	#00100000b
		rts
;----------------------------------------------------------------------------
BG_check_address
		word    Obake_bg,Circuit_bg,Grass_bg
		word    Dart_bg,Ice_bg,Sand_bg,Castle_bg
		word	Star_bg
Common_bg       equ     000h
Circuit_bg      equ     040h
Obake_bg        equ     100h
Grass_bg        equ     129h
Castle_bg       equ     1a9h
Ice_bg          equ     205h
Dart_bg         equ     283h
Sand_bg         equ     2e7h
Star_bg		equ	367h	
;----------------------------------------------------------------------------
Mode7_screen_address
		lword	MAP00_SCR,MAP01_SCR,MAP02_SCR,MAP03_SCR,MAP04_SCR
		lword	MAP05_SCR,MAP06_SCR,MAP07_SCR,MAP08_SCR,MAP09_SCR
		lword	MAP0A_SCR,MAP0B_SCR,MAP0C_SCR,MAP0D_SCR,MAP0E_SCR
		lword	MAP0F_SCR
		lword	MAP10_SCR,MAP11_SCR,MAP12_SCR,MAP13_SCR,MAP14_SCR
		lword	MAP15_SCR,MAP16_SCR,MAP17_SCR
Mode7_character_address
		lword	OBAKE_CHR
		lword	CIRCUIT_CHR
		lword	GRASS_CHR
		lword	DART_CHR
		lword	ICE_CHR
		lword	SAND_CHR
		lword	CASTLE_CHR
		lword	STAR_CHR
Color_data_address
		lword	OBAKE_COL
		lword	CIRCUIT_COL
		lword	GRASS_COL
		lword	DART_COL
		lword	ICE_COL
		lword	SAND_COL
		lword	CASTLE_COL
		lword	STAR_COL
Obstruct_address
		lword	OBAKE_OBJ
		lword	CIRCUIT_OBJ
		lword	GRASS_OBJ
		lword	DART_OBJ
		lword	ICE_OBJ
		lword	SAND_OBJ
		lword	CASTLE_OBJ
		lword	STAR_OBJ
Back_character_address
		lword	OBAKE_BCH
		lword	CIRCUIT_BCH
		lword	GRASS_BCH
		lword	DART_BCH
		lword	ICE_BCH
		lword	SAND_BCH
		lword	CASTLE_BCH
		lword	STAR_BCH
Back_screen_address
		lword	OBAKE_BSC
		lword	CIRCUIT_BSC
		lword	GRASS_BSC
		lword	DART_BSC
		lword	ICE_BSC
		lword	SAND_BSC
		lword	CASTLE_BSC
		lword	STAR_BSC
;---------------------------------------------------------------------------
World_map_data	
		byte	07h,13h,10h,11h,0fh		;kinoko  cup
		byte	12h,01h,02h,03h,00h		;flower  cup
		byte	0dh,0ah,0ch,09h,0eh		;star    cup
		byte	0bh,06h,08h,04h,05h		;special cup
Map_type_data;
		byte	circuit,obake,grass,castle,ice
		byte	star,sand,circuit,obake,castle
		byte	dart,grass,ice,sand,circuit
		byte	circuit,obake,castle,dart,grass ;race
;
		byte	ice,circuit,grass,sand		;battle;
obake		equ	0000h
circuit		equ	0002h
grass		equ	0004h
dart		equ	0006h
ice		equ	0008h
sand		equ	000ah
castle		equ	000ch
star		equ	000eh
;----------------------------------------------------------------------------
		mem16
		idx16
Set_map_number
		lda	!world_number
		asl	a
		asl	a
		clc
		adc	!world_number
		adc	!map_pointer
		tax
		lda	!World_map_data,x
		and	#00ffh
		sta	!map_number
		rts
Set_map_type
		ldx	!map_number
		lda	!Map_type_data,x
		and	#00ffh
		sta	!map_type
Dummy_set
Not_timeattack
		rts
;----------------------------------------------------------------------------
Free_RAM_init_200
		lda	<game_status
		cmp	#04h
		bne	Not_timeattack_200
		lda	!g_kart_flag
		beq	No_g_kart_200
		lda	#1000000000000000b
		sta	!1100h+kart_flag
		lda     !timeattack_flag
		beq     No_comp_kart
		lda     #0010000000000000b
		sta	!1200h+kart_flag
		rts
No_g_kart_200
		lda	!timeattack_flag
		beq	No_comp_kart
		lda	#0010000000000000b
		sta	!1100h+kart_flag
Not_timeattack_200
No_comp_kart
		rts
;----------------------------------------------------------------------------
Free_RAM_init_100
		lda	#02h
		sta	<game_level
		jsr	!Init_enemy_perform
		jsr     !Clear_kart_flag        ;1200h-1700h dont exist
		ldy	#00h
		lda	<game_mode
		beq	Player_02
		cmp	#04h
		beq	Player_L1
Player_H1
		lda	#1000h
		jsr	!Set_rank_sub
		lda	!g_kart_flag
		beq	No_g_kart
		lda	!ghost_kart
		sta	!1100h+driver_number
		lda	#1100h
		jsr     !Set_rank_sub
		bra	Clear_rank_index		
No_g_kart
		lda	!timeattack_flag
		beq	No_rival_kart
		lda	!timeattack_rival
		sta	!1100h+driver_number
		lda     #1100h
		jsr     !Set_rank_sub
		bra	Clear_rank_index
No_rival_kart
		stz	!1100h+kart_flag
		bra	Clear_rank_index
Battle_RAM_init
		jsr	!Clear_kart_flag	;1200h-1700h dont exist
Player_02
		ldy	#00h
		lda	#1000h
		jsr	!Set_rank_sub
		lda	#1100h
		jsr     !Set_rank_sub
		bra	Clear_rank_index
Player_L1
		stz	!1000h+kart_flag
		lda	#1100h
		jsr     !Set_rank_sub
Clear_rank_index
		lda	#0000h
Clear_rank_loop
		sta	!rank_index,y
		iny
		iny
		cpy	#012h
		bcc	Clear_rank_loop
Set_mykart_perform
		jsr	!Set_kart_perform
		bra	Commom_RAM_initial		
;----------------------------------------------------------------------------
Kart_flag_init
		mem16
		idx16
		rep	#00110000b
		ldx	#01700h
Set_RAM_loop
		cpx	#01200h
		bcc	Special_kart
Enemy_RAM_init
		lda	#0010000000000000b
		sta	<kart_flag,x		
		bra	Set_other_data
Special_kart
		cpx	#1000h
		beq	Kart_1000
;Kart_1100
		lda	<game_mode
		cmp	#02h
		beq	Enemy_RAM_init
		lda	!player_count+02h
		bne	Mykart_RAM_init
Clear_kart
		lda     #00h
		bra	Set_zero_data
Kart_1000
		lda	<game_mode
		cmp	#04h
		beq	Enemy_RAM_init
		lda	!player_count+00h
		beq	Clear_kart
Mykart_RAM_init
		lda	#1000000001000000b
Set_zero_data
		sta	<kart_flag,x
Set_other_data
		txa
		sec
		sbc	#0100h
		tax
		cmp	#1000h
		bcs	Set_RAM_loop
		rts
;----------------------------------------------------------------------------
Race_RAM_init
		mem16
		idx16
		ldx	#1700h
Ram_init_loop
		jsr	!Kart_RAM_init
		txa
		sec
		sbc	#100h
		tax
		cmp	#1000h
		bcs	Ram_init_loop
;----------------------------------------------------------------------------
Commom_RAM_initial
		mem16
		idx16
		stz	<nmi_counter
		stz	<frame_counter
		stz	<sprite_countA
		stz	<sprite_countB
		stz	!goalin_number
		stz	!goalin_pointer
		stz	!over_flag
		stz	!mark_index
		stz	!camera_counter
		stz	!game_counter
		stz	<trans_counter
		stz	!fanfare_counter
		stz	!finallap_counter
		stz	!bgm_status
		stz	!pause_wait
		lda	#0ffffh
		sta	!old_doppler_dist
		sta	!ultra_index
		sta	!color_trans_flag
		lda	#0500h+8000h		;08000h=00
		sta	!lap_number		;round =05h ...fixed
		sta	!clear_driver
		sta	!signal_counter
;----------------------------------------------------------------------------
;Clear lap buffer
		ldx	#01ch
		lda	#0ffffh
Clear_lap_buffer
		sta	>laptime_buffer+000h,x	;minute lap buffer
		sta	>laptime_buffer+01eh,x	;minute lap buffer
		dex
		dex
		bpl	Clear_lap_buffer
;----------------------------------------------------------------------------
		sep	#00110000b
		jsl	>Regular_IRQ_init
		rep	#00110000b
Init_trans
		ldx	#020h
Clear_trans_loop
		stz	<0deh,x
		dex
		dex
		bpl	Clear_trans_loop
		lda	#04h
Init_trans_loop
		sta	<frame_counter
		pha
		jsl	>Initial_OBJ_trans
		pla
		dec	a
		bpl	Init_trans_loop
		rts
;----------------------------------------------------------------------------
Clear_kart_flag
		ldx	#1200h
Clear_flag_loop
		stz	<kart_flag,x
		txa
		clc
		adc	#0100h
		tax
		cmp	#1800h
		bcc	Clear_flag_loop
		rts
;----------------------------------------------------------------------------
Set_rank_sub
		sta	!rank_index,y
		tax
		tya
		sta	<rank_number,x
		lda	#1000000001000000b		;b15 mykart bit
							;b6  cut engine sound
		sta	<kart_flag,x
		jsr	!Kart_RAM_init
		iny
		iny
		rts
;----------------------------------------------------------------------------
Set_kart_perform
;open mykart performance
		ldx	#1000h
		lda	#player01_table
		jsr	!Open_mycar
		ldx	#1100h
		lda	#player02_table
		jsr	!Open_mycar
;open engine sound data
		ldy	#000ah
		ldx	!game_level
		beq	Goto_loop		
Set_engine_100cc
		ldy	#0016h
Goto_loop
		ldx	#000ah
Set_engine_loop
		lda	!Engine_sound_data,y
		sta	!engine_sound_data,x
		dey
		dey
		dex
		dex
		bpl	Set_engine_loop
;
		lda	#04h
		sta	!player_count+00h
		sta	!player_count+02h
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Initial_granprix
		jsr	!Set_kart_perform
		jsr	!Init_enemy_perform
		ldx	<game_mode
		jsr	(!Set_driver_mode,x)
;Initial_enemy driver
		ldx	#01700h
Set_en_loop
		lda	!Kart_priority+00h,y
		cmp	!1000h+driver_number
		beq	Next_en_driver
		cmp	!1100h+driver_number
		beq	Next_en_driver
		sta	<driver_number,x
		iny
		iny
		txa
		sec
		sbc	#0100h
		cmp	#1200h
		bcc	End_en_driver
		tax
		bra	Set_en_loop
Next_en_driver		
		iny
		iny
		bra	Set_en_loop
End_en_driver
;Initial rank & point index
		lda	#1000h
		ldy	#000eh
Set_index_loop
		sta	!rank_index,y
		sta	!point_rank,y
		tax
		sty	<rank_number,x
		stz	<driver_point,x
		clc
		adc	#100h
		dey
		dey
		bpl	Set_index_loop
		rts
;----------------------------------------------------------------------------
Set_driver_mode
		word	Driver_00,Driver_02,Driver_04
Driver_02
		lda	!1000h+driver_number
		jsr	!Set_select
		sta	!1100h+driver_number
		rts				
Driver_04
		lda	!1100h+driver_number
		jsr	!Set_select
		sta	!1000h+driver_number
		rts		
Driver_00
		lda	!1100h+driver_number
;---------------------------------------------------------------------------
Set_select
		asl	a
		asl	a
		asl	a
		tay
		lda	!Kart_priority+0ch,y
		rts	
;---------------------------------------------------------------------------
Kart_priority
Type_mario
		word	kong,peach,yossy,luigi,kinopio,koopa,nokonoko,mario
Type_luigi
		word	yossy,mario,koopa,nokonoko,peach,kong,kinopio,luigi
Type_koopa
		word	mario,luigi,peach,yossy,kong,kinopio,nokonoko,koopa
Type_peach
		word	koopa,kinopio,mario,kong,luigi,yossy,nokonoko,peach
Type_kong
		word	kinopio,koopa,nokonoko,luigi,peach,mario,yossy,kong
Type_nokonoko
		word	luigi,yossy,peach,mario,koopa,kong,kinopio,nokonoko
Type_kinopio
		word	peach,kong,mario,yossy,luigi,nokonoko,koopa,kinopio
Type_yossy
		word	nokonoko,kong,peach,koopa,mario,kinopio,luigi,yossy
;----------------------------------------------------------------------------
Set_priority
		lda	!map_pointer
		beq	Initial_driver_priority
		lda	!ending_flag
		bne	Initial_driver_priority
		ldy	#00h
Init_prio_index
		ldx	!point_rank,y
		lda	<kart_flag,x
		bmi	Start_prio_loop
		iny
		iny
		bra	Init_prio_index
Start_prio_loop
		tya
		asl	a
		asl	a
		clc
		adc	#offset Set_prio_data
		sta	<read_address+00h
		lda	#bank Set_prio_data
		sta	<read_address+02h
		ldy	#00h
		ldx	#00h
Set_prio_loop
		lda	!point_rank,x
		phx
		tax
		lda	<kart_flag,x
		bmi	Skip_set_prio
		lda	[<read_address],y
		and	#00ffh
		sta	<driver_priority,x
		iny
Skip_set_prio
		plx
		inx
		inx
		cpx	#10h
		bcc	Set_prio_loop
		rts
;----------------------------------------------------------------------------
Initial_driver_priority
		lda	#08h
		sta	<prio_data
		ldy	#00h
Init_prio_loop
		ldx	!rank_index,y
		lda	<kart_flag,x
		bmi	Skip_init_prio
		lda	<prio_data
		sta	<driver_priority,x
		dec	a
		dec	a
		bpl	Not_data_minus
		lda	#00h
Not_data_minus
		sta	<prio_data
Skip_init_prio
		iny
		iny
		cpy	#010h
		bcc	Init_prio_loop
		rts
;----------------------------------------------------------------------------
Set_prio_data
		byte	08,06,04,02,00,00,00,00
		byte	08,06,04,02,00,00,00,00
		byte	08,04,06,02,00,00,00,00
		byte	08,04,02,06,00,00,00,00
		byte	08,06,04,02,00,00,00,00
		byte	08,06,04,02,00,00,00,00
		byte	08,06,04,02,00,00,00,00
		byte	08,06,04,02,00,00,00,00
;----------------------------------------------------------------------------
		mem16
		idx16
;						;x=000,002,004
						;y=1000,1100,1200....1700
Set_attribute
		ldy	#1700h
		ldx	#000eh
Obj_number_loop
		lda	>VRAM_address,x
		sta	!vram_addressA,y
		clc
		adc	#1000h
		sta	!vram_addressB,y
		lda	>Obj_num_data,x
		phx
		ldx	<driver_number,y
		ora	>Character_palet,x
		sta	!obj_attribute,y
		tya
		sec
		sbc	#0100h
		tay
		plx
		dex
		dex
		bpl	Obj_number_loop
		rts
;----------------------------------------------------------------------------
Engine_sound_data
;50cc
		word	3fffh
		word	0120h
		word	0080h
		word	-200h
		word	-300h
		word	-100h
;100cc
		word	5fffh
		word	0200h
		word	0040h
		word	-280h
		word	-380h
		word	-180h
;----------------------------------------------------------------------------
Class_effect
		pha
		lda	<game_level
		cmp	#04h
		bcc	Not_150cc
;Clacc150cc
		pla
		sta	<tempolary
		lsr	a
		clc
		adc	<tempolary
		cmp	#032h
		bcs	OK_150_accel
		lda	#0e0h
OK_150_accel
		rts
Not_150cc
		pla
		rts
;---------------------------------------------------------------------------
Class_effect_R
		pha
		lda	<game_level
		cmp	#04h
		bcc     Not_150cc
		pla
		clc
		adc	#030h
		rts
;----------------------------------------------------------------------------
Open_mycar
		sta	<write_address
		stz	<write_address+02h
		ldy	<driver_number,x
		phy
;Open_max speed
		lda	!Max_speed_perform,y
		ldy	<game_status
		bne	Class_100cc
		ldy	<game_level
		beq	Class_050cc
		cpy	#02h
		beq	Class_100cc
;Class150
		clc
		adc	#0a0h
		bra	Class_100cc
Class_050cc
		sec
		sbc	#080h
Class_100cc
		sta	!max_velocity,x
Open_accel
		ply
  		ldx	!Accel_perform,y
		phy
		ldy	#0000h
Open_accel_loop
		lda	!00h,x	
		and	#0ffh
		asl	a
		asl	a
		asl	a
		asl	a
		jsr	!Class_effect
		sta	[<write_address],y
		inx
		iny
		iny
		cpy	#020h
		bcc	 Open_accel_loop
		ply
;Open_resist
		ldx	!Resist_perform,y
		phy
		ldy	#020h
Open_resist_loop
		cpy	#34h
		bcs	Resist_area
		lda	#0ffffh
		bra	Set_resist_data
Resist_area
		lda	!00h,x
		and	#0ffh
		asl	a
		asl	a
		asl	a
		asl	a
		jsr	!Class_effect_R
		inx
Set_resist_data
		sta     [<write_address],y
		iny
		iny
		cpy	#040h
		bcc	Open_resist_loop
		ply
;Open_steering
		ldx	!Steering_perform,y
		ldy	#040h
Open_steering_loop
		lda	!00h,x
		sta	[<write_address],y
		iny
		iny
		lda	!02h,x
		and	#00ffh
		sta     [<write_address],y
		iny
		iny
		lda	!03h,x
		and	#00ffh
		sta     [<write_address],y
		iny
		iny
		lda	!04h,x
		and	#00ffh
		sta     [<write_address],y
		iny
		iny
		cpy	#058h
		beq	End_open_perform
		txa
		clc
		adc	#05h
		tax
		bra	Open_steering_loop
End_open_perform
		rts		
;----------------------------------------------------------------------------
		mem16
		idx16
;					entry X=1000,1100,1200....1700
Kart_RAM_init
		stz	<kart_direction,x
		stz	<move_direction,x
		stz	<body_direction,x
		stz	<mark_direction,x
		stz	<mark_pos_x,x
		stz	<mark_pos_y,x
		stz	<limmit_velocity,x
		stz	<obj_velocity_x,x
		stz	<obj_velocity_y,x
		stz	<obj_velocity_z,x
		stz	<kart_control,x		;>>>>>>>>>>engine_control
		stz	<engine_power,x
		stz	<special_trigger,x
		stz	<kart_counter,x
		stz	<dash_counter,x
		stz	<spin_counter,x
		lda	<kart_status,x
		and	#0100000000000000b
		sta	<kart_status,x
;
		lda     !obj_pos_xh,x
		lsr     a
		lsr     a
		lsr     a
		lsr     a
		sta	<tempolary
		lda     !obj_pos_yh,x
		asl     a
		asl     a
		and     #1111111111000000b
		ora     <tempolary
		phx
		tax
		lda     >area_buffer,x
		and     #00ffh
		ora     #7f00h
		plx
		sta	<kart_area,x			;low kart area
							;high kart lap
		sta	<old_area,x
		sta	<lap_counter,x
		stz	<event_index,x	
		stz	<drive_status,x
		stz	<move_status,x
		stz	<vector_velocity_l,x
		stz	<vector_velocity_h,x
		stz	<acceleration_l,x
		stz	<acceleration_h,x
		stz	<steering_angle,x
		stz	<drift_index,x
		stz	<drift_angle,x
		stz	<drift_pose,x
		stz	<drift_counter,x	;=point_direction(enmey use)
		stz	<mu_level,x	
		lda	#040h
		sta	<steering_level,x
		lda	#140h				;miminun patern
		sta	<obj_paternA,x
		sta	<obj_paternB,x
		sta	<obj_old_paternA,x
		sta	<obj_old_paternB,x
		stz	<tire_timer,x
		stz	<official_control,x
		stz	<choropoo_counter,x
;							;each driver's init
		lda	#0ffffh
		sta	<driver_time+04h,x
		rts
;----------------------------------------------------------------------------
More_battle
		lda	#8000h
		sta	!1100h+kart_direction
		sta	!1100h+move_direction
		sta	!1100h+body_direction
		rts
;----------------------------------------------------------------------------
Initial_camera_buffer
		ldx	<game_mode
		jmp	(!Set_camera_address,x)
Set_camera_address
		word	Game_mode00,Game_mode02,Game_mode04
Game_mode00
		lda	#1000h
		ldx	#00h
		jsr	!Nomal_camera
		lda	#1100h
		ldx	#02h
		jsr	!Nomal_camera
		rts
Game_mode02
		lda	#1000h
		ldx	#00h
		jsr	!Nomal_camera
		lda	#1000h
		ldy	#1100h
		ldx	#02h
		jsr	!Display_camera
		rts
Game_mode04
		lda	#1100h
		ldy	#1000h
		ldx	#00h
		jsr	!Display_camera
		lda	#1100h
		ldx	#02h
		jsr	!Nomal_camera
		rts
Nomal_camera
		sta	<camera_index,x
		tay
		txa
		sta	!control_index,y
		stz	<camera_mode,x
		lda	#1100000011000000b	;b15=1 scrool enable
						;b14=1 rotate enable
						;b13=0 not spin status
						;b07=1 pose disable
						;b06=1 monita change disable
						;b05=0 not back milar mode
		bra	Commom_camera
Display_camera
		sta	<camera_index,x
		lda	#0ffffh
		sta	!control_index,y
		lda	#06h
		sta	<camera_mode,x
		lda	#0000000011000000b	;b15=0 scrool disable
						;b14=0 rotate disable
						;b13=0 not spin status
						;b07=1 pose disable
						;b06=1 monita change disable
						;b05=0 not back milar mode
		
Commom_camera
		sta	<camera_control,x
		lda	#00c0h
		sta	<camera_flip,x
		sta	<camera_drift,x
		stz	<slot_sound_counter,x
		stz	!se_level,x
		rts
;----------------------------------------------------------------------------
Initial_opening_demo
		lda	!1f05h			;check_dedug_flag
		bit	#0100000000000000b
		bne	Now_debug_mode
		lda	<race_status
		beq	Init_demo_data
		rts
Now_debug_mode
		lda	#08h
		sta	<race_status
		rts
Init_demo_data
		ldx	<game_mode
		jmp	(!Set_demo_data,x)
Set_demo_data
		word	Demo_00,Demo_02,Demo_04
Demo_00
		ldx	#1000h
		ldy	#0000h
		jsr	!Set_demo_sub
Demo_04
		ldx	#1100h
		ldy	#0002h
		bra	Set_demo_sub
Demo_02
		ldx	#1000h
		ldy	#0000h
Set_demo_sub
		lda	<obj_pos_xh,x
		asl	a
		asl	a
		sta	!camera_x,y
		lda	<obj_pos_yh,x
		sec
		sbc	#0300h
		asl	a
		asl	a
		sta	!camera_y,y
		lda	#8000h
		sta	!camera_direction,y
		lda	!camera_control,y
		and	#0011111111111111b
		sta	!camera_control,y
		lda	#020h
		sta	!fade_speed
		rts
;----------------------------------------------------------------------------
Check_reset_data
		word	02f4h,8a36h,45e1h,9bc0h,52d7h,0fff0h,0c2b1h,0002h
;-----------------------------------------------------------------------------
Rom_checker_4
		byte   	01h,09h,06h,03h,00h,09h,00h,02h
;-----------------------------------------------------------------------------
bank80		sect	rel
;-----------------------------------------------------------------------------
VRAM_address
		word	5800h,5840h,5880h,58c0h,5c00h,5c40h,5c80h,5cc0h
;-------------(low) vram address & (high) b0=use obj higher bank-------------
Obj_num_data
		word	0180h,0184h,0188h,018ch,01c0h,01c4h,01c8h,01cch
;----------------------------------------------------------------------------
Character_palet
;                       mario,luigi,koopa,peach, cong, kame,kinop,yosshy
                word    0200h,0400h,0000h,0600h,0600h,0400h,0200h,0000h
;----------------------------------------------------------------------------
Status_data
		word	0000h,0000h,0004h,0006h,0002h
Map_data
;granprix=world umber
;VS,timeattack&battle=map_number
		word	0001h,0000h,0013h,0015h,0003h
Mode_data
		word	0002h,0000h,0002h,0000h,0000h
Driver1_data		
		word	peach,mario,kong,nokonoko,luigi
Driver2_data	
		word	00000,yossy,0000,kinopio,koopa
Status_init
		word	Granprix_init,VS_init,Timeattack_init,Battle_init
;----------------------------------------------------------------------------
Goto_demo
		lda	#080h
		sta	!fade_speed
		lda	!1000h+driver_number
		sta	!driver1_stock	
		lda	!1100h+driver_number
		sta	!driver2_stock
		lda	<game_mode
		sta	!mode_stock
		lda	<game_status
		sta	!status_stock
		lda	<game_level
		sta	!level_stock
		lda	!world_number
		sta	!world_stock
;
		lda	#020*60				;20 seconds
		sta	!o_demo_counter
		lda	#0ffffh
		sta	!o_demo_flag
;
		ldy	!o_demo_pattern
		iny
		iny
		cpy	#008h
		bcc	Cont_pattern_count
		ldy	#00h
Cont_pattern_count
		sty	!o_demo_pattern
		lda	!Mode_data,y
		sta	<game_mode
		sta	!game_mode_stock
		lda	#02h
		sta	!game_level
		lda	!Driver1_data,y
		sta	!1000h+driver_number
		lda	!Driver2_data,y
		sta	!1100h+driver_number
;
		ldx	!Status_data,y
		stx	<game_status
		jmp	(!Status_init,x)
;----------------------------------------------------------------------------
Title_sub
		lda	#0060h
		sta	!fade_speed
		lda	<game_selecta
		bne	Skip_title_sub
		lda	!1040h				;title demo timer
		cmp	#0652h-010h
		bcs	Goto_demo		
;check debug mode
		lda	!rom_checker
		beq	Skip_title_sub
		ldx	#002h
Select_loop
		lda	<button_status+00h,x
		bit	#0010000000000000b	;select button on!!!	
		beq	Continue_selection
		bmi	Quick_start		;select&B
		bit	#0001000000000000b
		bne	Start_edit_3
		bit	#0000000010000000b	;ending 01
		bne	Start_ending_01
Continue_selection
		dex
		dex
		bpl	Select_loop
Skip_title_sub
		rts
;----------------------------------------------------------------------------
Granprix_init
		stz	!map_pointer
		lda	!Map_data,y
		sta	!world_number
		lda	#0eh
		sta	!race_init
		bra	Goto_race
VS_init
Timeattack_init
		lda	!Map_data,y
		sta	!map_number
		lda	#0ah
		sta	!race_init
Goto_race
		lda	#02h
		bra	Goto_selecta
Battle_init
		lda	!Map_data,y
		sta	!map_number
		lda	#0eh
		bra	Goto_selecta		
;----------------------------------------------------------------------------
Quick_start
		ldx	<game_status
		jmp	(!Quick_sub,x)
Granpinx_start
		lda	!map_pointer
		beq	Set_race_init
		lda	#02h
		bra	Set_race_init
Start_ending_01
		lda	!rom_checker
		beq	Skip_title_sub
		jsl	>BGM_fade_out
		lda	#0ch
		bra	Goto_selecta
Start_edit_3
		lda	#14h
		bra	Goto_selecta
Next_race
Result_race
		jsr	!All_check_rank
		jsr	!Correct_times
		inc	!map_pointer		;clear & next race
		lda	#0002h		  	;goto DP display
		sta     !race_init
		lda	#000ah
		bra	Goto_selecta
Retry_race
		jsr	!All_check_rank
Start_race
		lda	#02h
Goto_selecta
		sta	<game_selecta
		lda	#0060h
		sta	!fade_speed
Set_fade_control
		lda	#08f00h
		sta	<fade_control
		rts
Start_ending_02
		lda	#01ch
		bra	Goto_selecta
VS_start
Timeatack_start
		lda	<game_mode
		sta	!game_mode_stock
		lda	#0ah
Set_race_init
		sta	!race_init
		bra	Start_race
Battle_start
		lda	#0eh
		bra	Goto_selecta
Start_title
		jsl	>BGM_fade_out
		lda	#04h
		bra     Goto_selecta
Start_K_select
		lda	#06h
		sta	<game_selecta
		bra     Set_fade_control
Start_C_select
		lda	#16h
		bra     Goto_selecta
Quick_sub
		word	Granpinx_start,VS_start,Timeatack_start,Battle_start
		end 
