;****************************************************************************
;*	Mario Kart							    *
;*			Initiarize control module			    *
;*							1992.04.20	    *
;****************************************************************************
		glb	Initialize_process
		glb	Selection_process
		glb	Character_palet
		glb	Init_character
		glb	VRAM_address,Character_palet,Obj_num_data
		glb	Set_ROM_to_buffer,Set_map_number
		glb	World_map_data,Set_map_address
;----------------------------------------------------------------------------
		glb	Title_sub		;--------------------debug mode
		glb	Start_title,Start_K_select,Start_C_select
		glb	Retry_race,Next_race,Result_race
		glb	Set_back_01,Set_back_02
;;--------------------------------------------------------------------------
		ext	Set_sound,Set_BGM,Set_battle_BGM
		ext	Pers_init,Set_pers_data
		ext	Cos_data,Sin_data
		ext	Tan,Clear_RAM_00,Color_transport_l
		ext	Display_select
		ext	Initial_pers_param,Initial_camera;Set_long_pers
		ext	Initial_enemy,Init_enemy_perform
		ext	Initial_OBJ_trans
		ext	Performance_data,Max_speed_perform
		ext	Resist_perform1,Resist_perform2,Steering_perform
		ext	Drift_perform,Accel_perform
		ext	Mycar_performance_bank,Mycar_performance_offset
		ext	Sound_resister_clear
		ext	Sound_initialize,APU_initialize
		ext	Set_driver_point,All_check_rank
		ext	Start_fainal_count
		ext	Regular_IRQ_init
;----------------------------------------------------------------------------
		ext	Init_ranker,Rank_number_data
		ext	BG_attribute_data_offset,BG_attribute_data_bank
		ext	Common_BG,Set_race_BGM
		ext	Driver_init_posx,Driver_init_posy,Driver_init_direc
		ext	Set_ABC,Set_nintendo
;----------------------------------------------------------------------------
		ext	OBJ_initial,Battle_objinit,Free_objinit
		ext	Decode_7E_X,Decode_M7,Decode_7F_X
		ext	Decode_mode3,Decode_M7_BF,Convert_m1m7
		ext	Set_BG_item,Set_changeBG
		ext	Clear_sprite
		ext	WINDOW_INIT
		ext	ED_init_1,ED_init_2,ED_init_3,DP_init,Final_init
		ext	TITL_init,NAME_init,K_SL_init,W_SL_init,C_SL_init
		ext	DOS_INI,DOS_INI_1
;----------------------------------------------------------------------------
		include rp5a22
		include rp5c77
		include work.def
		include buffer.def
		include label.def
		include ../join/object.def
		include D77C25
;----------------------------------------------------------------------------
disable_rank	equ	0000h		;(4byte)
;
read_address	equ	0000h
write_address	equ	0004h
read_address_dash equ	0008h
tempolary	equ	010h
pointer		equ	018h
address		equ	01ah
counter		equ	01ch
angle_data	equ	020h
multi_data	equ	020h
;
x_counter	equ	020h
y_counter	equ	022h
screen_address	equ	024h
;
;angle_data	equ	010h
dist_data	equ	012h
;
h_pos_data	equ	000h
v_pos_data	equ	002h
;----------------------------------------------------------------------------
bank1		sect 	rel
;----------------------------------------------------------------------------
		mem16
		idx16
Initialize_process			;input mem8 idx8
		phb
		phk
		plb
		rep	#00110000b
		jsr	!RAM_initialize
					;blanking on!!!
					;this process will carry out before 
					;the main routine starts 
		jsl	>Set_nintendo
					;blanking off!!!
		jsr	!APU_initialize
		jsr	!DSP_init
		jsr	!Set_pers_data
		jsl	>Init_character
		jsl	>Direction_init
		jsl	>DOS_INI
		lda	#00f00h
		sta	!fade_control
		lda	#001ah		;dummy game index
		sta	!game_index
		mem8
		sep	#00100000b
		cli
		lda	#10110001b
		sta	!NMI_control	;NMI enable
		mem16
		idx16
		rep	#00110000b
		lda	#04h
		sta	<game_selecta
		lda	#08f00h
		sta	<fade_control
;		lda	#0080h
		lda	#0060h
		sta	!fade_speed
		plb
		rtl
;----------------------------------------------------------------------------
Selection_address
	word	Not_select,Race_initial
	word	Title_initial
	word	Kart_select_initial,World_select_initial
	word	DP_initial,Record_initial
	word	Battle_initial,Edit1_initial,Edit2_initial,Edit3_initial
	word	Course_select_initial,Final_initialize
;----------------------------------------------------------------------------
		mem16
		idx16
						;x=game_selecta
Selection_process
		lda	<game_selecta
		beq	Not_select
		lda	!fade_data
		cmp	#8000h
		bne	Not_select
		mem8
		idx8
		sep	#00110000b
		phb
		phk
		plb
		stz	!DMA_burst
		stz	!DMA_syncro
		lda	<game_index
		sta	!old_game_index
		stz	<game_index	;initial NMI &main index
		stz	<irq_index
		sei			;Interupt disable
		stz	!NMI_control	;NMI disable
		mem16
		idx16
		rep	#00110000b
		jsr	!Sound_initialize
;
		ldx	<game_selecta
		jsr	(!Selection_address,x)	
;
		lda	#0001h
		sta	<fade_control
		lda	<game_selecta
		sta	<game_index
		stz	<game_selecta
		mem8
		idx8
		sep	#00110000b
   		cli
		lda	#10110001b
		sta	>NMI_control	;NMI eneble
		rep	#00110000b
		plb
Not_select
		rtl
;----------------------------------------------------------------------------
		mem16
		idx16
Title_initial
		jsl	>DOS_INI_1
		jsr     !Resister_clear		;mem8  idex8
		jsr	!Set_title_data
		jsr	!Set_select_data
		jsl	>TITL_init		
		stz	!race_init		;fast_initial
		rts
;----------------------------------------------------------------------------
Set_title_data
		ldy	#offset Title_data
		lda	#bank Title_data	;Title_data=ROM address
		ldx	#0000h			;RAM address
		jsl	>Decode_7F_X		;set data to 7f0000h
		rts
Set_select_data
		ldy	#offset Select_data
		lda	#bank Select_data	;Title_data=ROM address
		ldx	#0c000h			;RAM address
		jsl	>Decode_7F_X		;set data to 7fc000h
		rts
;----------------------------------------------------------------------------
Kart_select_initial
		jsr	!Set_select_data
		jsl	>K_SL_init
		rts
;---------------------------------------------------------------------------
World_select_initial
		jsr	!Set_select_data
		jsl	>W_SL_init
		rts
;---------------------------------------------------------------------------
Course_select_initial
		lda	<game_mode
		sta	!game_mode_stock
		lda	#02h
		sta	<game_mode
		jsr     !Clear_kart_data
		jsr	!Pers_init
		jsr	!Resister_clear
;;;;		jsr	!Set_long_pers
		jsr	!Race_RAM_init
		jsl	>C_SL_init
		jsr     !Set_map_type           ;map-num>>>map_type
		jsr	!Set_maps
		jsr	!Initial_camera_buffer
		jsr	!Initial_camera
		jsr	!Race_resister_init
;;;;;		jsr	!Open_color
		rts
;-----------------------------------------------------------------------------
		mem16
		idx16
Race_initial
		ldx	!race_init
		lda	!Initial_race_status,x
		sta	<race_status
		jmp	(!Race_initial_address,x)
;----------------------------------------------------------------------------
Initial_race_status
		word	00h,00h,02h,02h,08h,02h,02h
;----------------------------------------------------------------------------
Race_initial_address				;race init=
		word	World_initial				;00h
		word	Map_initial				;02h
		word	Retry_initial				;04h
		word	Map_initial;(skip opening demo&retry)	;06h
		word	Debug_initial				;08h
		word	Free_initial				;0ah
		word	Retry_free				;0ch
;----------------------------------------------------------------------------
Free_initial
		jsr	!Set_race_BGM
		lda	#02h
		sta	<race_status
		lda	!game_mode_stock
		sta	<game_mode
		jsr	!Set_driver
		jsr	!Init_enemy_perform
		jsr     !Pers_init
		jsr	!Set_OBJ_100
		jsr	!Set_OBJ_200
		jsr     !Set_map_type           ;map-num>>>map_type
		jsr     !BG_attribute_set
		jsr	!Set_race_BGM
Retry_free
		jsr	!Clear_coin
		jsr	!Free_RAM_init
		jsr     !Timer_init
		jsr	!Set_maps
		jsl     >Free_objinit
		jsr	!Initial_camera_buffer
		jsr	!Initial_camera
		jsr	!Initial_enemy
		jsr	!Initial_opening_demo
		jsr	!Window_color_init
		jsl	>WINDOW_INIT
		jsr	!Race_resister_init
		jsr     !Set_OBJ_300
		rts
;----------------------------------------------------------------------------
World_initial
		stz	!map_pointer
		jsr	!Init_enemy_perform
		jsr	!Clear_kart_data
Debug_initial
		jsr	!Clear_point_index
		jsr	!Pers_init
		jsr	!Set_OBJ_100
Map_initial
		jsr	!Resister_clear
		jsr	!Set_map_number		;m-pointer&world-num>>map-num
		jsr	!Set_map_type		;map-num>>>map_type
		jsr	!BG_attribute_set
		jsr	!Set_BGM
;
		jsr	!Set_OBJ_200
		jsr	!Set_map_character
		jsr	!Initial_enemy
Retry_initial
		jsr	!Set_driver
		jsr	!Initial_rank_index
		jsr	!Clear_coin
		jsr	!Set_map_screen
		jsr	!Race_RAM_init
		jsl	>OBJ_initial
		jsr	!Initial_camera_buffer
		jsr	!Initial_camera
		jsr	!Timer_init
                jsr     !Init_ranker		;rank display obj set
		jsr	!Initial_opening_demo
		jsr	!Window_color_init
		jsl	>WINDOW_INIT
		jsr	!Race_resister_init
		jsr     !Set_OBJ_300
Ending_initial
		rts
;--------------------------------------------------------------------------
		mem16
		idx16
DP_initial
		jsr     !Resister_clear
		ldy	#offset CHECKER
		lda	#bank   CHECKER
		ldx	#0000h
		jsl	>Decode_7F_X		;set checker flag character
;
		lda	#05600h
		sta	!Screen_address
		lda	#080h
		sta	!Screen_step
		lda	#0001h
		sta	!DMA_0+00h
		lda	#0018h
		sta	!DMA_0+01h
		lda	#07f00h
		sta	!DMA_0+03h
		lda	#020h*020h		;OBJ 20h character
		sta	!DMA_0+05h
		ldx	#0001h
		stx	!DMA_burst
		lda     #05480h
		sta     !Screen_address
		lda     #07f00h+04h
		sta     !DMA_0+03h
		lda	#008h*020h
		sta     !DMA_0+05h
		stx	!DMA_burst		;OBJ 08h character
		lda	#05580h
		sta     !Screen_address
		lda     #07f00h+06h
		sta	!DMA_0+03h
		lda	#008h*020h
		sta     !DMA_0+05h
		stx     !DMA_burst		;OBJ 08h character
;		
		ldy	#offset Title_data
		lda	#bank   Title_data	;Title_data=ROM address
		ldx	#0000h			;RAM address
		jsl	>Decode_7F_X		;set data to 7f0000h
		ldy	#offset Select_data
		lda	#bank   Select_data	;Title_data=ROM address
		ldx	#0c000h			;RAM address
		jsl	>Decode_7F_X		;set data to 7fc000h
		jsr     !Set_2bit_moji
		jsl	>DP_init
		rts
;---------------------------------------------------------------------------
Final_initialize
		ldy	#offset	Final_data
		lda	#bank	Final_data	;final data ROM address
		ldx	#0000h			;set 7f0000h
		jsl     >Decode_7F_X
;pukupuku OBJ to MODE7
		ldx	#02800h			;from 7f2800h
		ldy	#0c000h			;  to 7fc000h
		lda	#00c98h			;low counter=098h
						;high attlibute=0ch
		jsl	>Convert_m1m7
;manto GAME OBJ to MODE7
		ldx	#00000h+060h*020h	;kanban address
		ldy	#0e800h
		lda	#00240h			;low counter=040h
						;high attlibute=0ch
		jsl     >Convert_m1m7
		ldx     #00000h+0a0h*020h	;mantogame
		ldy     #0e800h+40h*40h
		lda     #00d20h			;low counter=020h
						;high attlibute=0dh
		jsl     >Convert_m1m7
		jsl	>Final_init
		rts
;---------------------------------------------------------------------------
		mem16
		idx16
Battle_initial
		lda	#02h
		sta	<race_status
		lda	!game_mode_stock
		sta	<game_mode
		jsr	!Resister_clear
		jsr	!Set_driver
		jsr	!Clear_coin
		jsr     !Pers_init
		jsr	!Set_OBJ_100
;;;		jsr	!Set_long_pers
		jsr	!Battle_RAM_init
		jsr     !Timer_init
		jsr     !Set_OBJ_200
		jsr	!Set_map_type		;map-num>>>map_type
		jsr     !BG_attribute_set	;befor set maps!!!
		jsr	!Set_maps
		jsr	!Initial_enemy
;
		jsr	!Set_battle_BGM
;
		jsl     >Battle_objinit
		jsr	!Initial_camera_buffer
		jsr	!Initial_camera
		jsr	!Initial_opening_demo
		jsr	!Window_color_init
		jsl	>WINDOW_INIT
		jsr	!Race_resister_init
		jsr	!Set_battle_OBJ
		jsr     !Set_OBJ_400
		rts
;----------------------------------------------------------------------------
Edit1_initial
		jsr	!Set_item_BG
		jsr	!Set_map_type		;map-num>>>map_type
;;;;		jsr	!Open_color
		jsr	!Set_maps
		jsl	>ED_init_1
Record_initial
		rts
;----------------------------------------------------------------------------
Edit2_initial
		jsr	!Set_item_BG
		jsr	!Set_map_type		;map-num>>>map_type
;;;;		jsr	!Open_color
		jsr	!Set_maps
		jsl	>ED_init_2
		rts
;----------------------------------------------------------------------------
Edit3_initial
		jsr	!Set_item_BG
		jsr	!Set_map_type		;map-num>>>map_type
;;;;		jsr	!Open_color
		jsr	!Set_maps
		jsl	>ED_init_3
		rts
;----------------------------------------------------------------------------
Clear_coin
		stz	!player_coin+00h
		stz	!player_coin+02h
		rts
;----------------------------------------------------------------------------
Clear_kart_data
		lda	#05h
		sta	!player_count+00h		;
		sta	!player_count+02h		;
		ldx	#1700h
Set_point_loop
		stz	<driver_point,x
		txa
		sec
		sbc	#0100h
		cmp	#1000h
		bcc	End_clear_point
		tax
		bra	Set_point_loop
End_clear_point
		rts
;----------------------------------------------------------------------------
		mem8
		idx8
DSP_init
		sep	#00110000b
		ldx	#128
		lda	#dsp_reset
Reset_dsp_loop
		sta	>DSP_data
		dex
		bne	Reset_dsp_loop
		rep	#00110000b
		rts
;-----------------------------------------------------------------------------
		mem16
		idx16
Timer_init
		stz	!decimal_timer
		stz	!second_timer
		stz	!minute_timer
		rts
;-----------------------------------------------------------------------------
		mem16
		idx16
RAM_initialize						;bank 1 prog
		rep	#00110000b
		mem16
		idx16
Reset_RAM_initialize
;Check reset;----------------------------------------------------------------
		ldx	#0eh
		ldy	#00h
Check_poweron_loop
		lda	>Check_reset_data,x
		cmp	!reset_checker,x
		beq	Next_checker
		sta	!reset_checker,x
		dey
Next_checker
		dex
		dex
		bpl	Check_poweron_loop
		cpy	#0000h
		beq	Not_power_on_status	
Poweron_status;--------------------------------------------------------------
;						;RAM clear
		lda	#00000h
		sta	>07fffffh		;clear 7fffffh
		ldx	#00000h
		ldy	#01f00h			;from 000h-1f00h
		jsl	>Clear_RAM_00
		lda	#0007eh
		ldx	#02000h
		ldy	#0e000h			;from 7e2000-7effff
		jsl     >Clear_RAM_00
		lda	#0007fh
		ldx	#00000h
		ldy	#0ffffh
		jsl     >Clear_RAM_00		;from 7f0000-7ffffe
;----------------------------------------------------------------------------
Power_on_RAM_init
		lda	#0002h
		sta	!1100h+driver_number		;2 con (luigi)
		sta	<game_mode			;1p mode
;
		jsr	!Other_RAM_set
		lda	#0000h
		sta	!reset_status
		rts
;----------------------------------------------------------------------------
Not_power_on_status
		jsr	!Other_RAM_set
		lda	#08000h
		sta	!reset_status
		rts
Hardware_reset;--------------------------------------------------------------
Other_RAM_set
		stz	<irq_index		;no interrupt
		stz	!pose_status		;00=non pose mode
		stz	<trans_counter
		stz	!bgm_flag
;;;;;;		stz	<game_selecta
		stz	<game_index
		lda	#0080h
		sta	!fade_speed
;;;;		lda	#8000h
;;;;		sta	!fade_data		;at first blanking!!
;;;;;  		stz	<fade_control
		rts
;----------------------------------------------------------------------------
Direction_init
		mem16
		idx16
		rep	#00110000b
;
		ldy	#offset TAN_DATA
		lda	#bank   TAN_DATA
		ldx	#offset tan_table
		jsl	>Decode_7F_X
;
		ldx	#00h
		stz	<x_counter
Set_direc_loop1
		stz	<y_counter
Set_direc_loop2
		phx
		ldy	<y_counter
		cpy	<x_counter
		bcc	X_bigger_Y
		ldx	<x_counter
		phy
		jsr	!Tan
		mem8
		idx16
		rep	#00010000b
		ply
		plx
		bra	Set_direc_buffer
X_bigger_Y
		mem16
		idx16
		ldx	<y_counter
		ldy	<x_counter
		phy
		jsr	!Tan
		mem8
		idx16
		rep	#00010000b
		ply
		plx
		sec
		sbc	#040h
		eor	#0ffh
		inc	a
Set_direc_buffer
		sta	>direc_buffer,x
		inx
		mem16
		rep	#00110000b
		lda	<y_counter
		cmp	#003fh
		beq	Next_x_angle
		inc	<y_counter
		bra	Set_direc_loop2
Next_x_angle
		lda	<x_counter
		inc	a
		cmp	#0040h
		beq	End_direc_loop
		sta	<x_counter
		bra	Set_direc_loop1
End_direc_loop
		rtl
;---------------------------------------------------------------------------
Resister_clear
		mem8
		idx8
		sep	#00110000b
		lda	#00000010b
		sta	!Sprite_size
					;sprite size=8or16 b567=00
					;OBJ bank use 0&1  b34=00
					;OBJ base addr=4000h b012=04
		stz	!Screen_bank+00h
					;mode7's screen addr=0000h
		lda	#01111011b
		sta	!Screen_bank+01h; BG 1
		sta	!Screen_bank+02h; BG 2
		sta	!Screen_bank+03h; BG 3
					;mode0's screen addr=078h(7800h)
					;screen size=03h
;		lda	#01100000b
		lda	#01110000b
		sta	!Screen_segment+00h
					;mode7's(BG1) char seg.=00
					;mode0's(BG2) char seg.=07(7000h)
		lda	#01110111b
		sta	!Screen_segment+01h
					;mode0's(BG3) char seg.=07
					;mode0's(BG4) char seg.=07(7000h)
		lda	#11000000b
		sta	!Screen_flip
					;out of screen=no.0 char b67=10
		lda	#01h
;;;;;		ldx	#0ffh
;
;		stz	!Rotation_A	;A parameter low 8 bit
;		sta	!Rotation_A	;            high
;		stz	!Rotation_B	;B parameter low 8 bit
;		stz	!Rotation_B	;            high
;		stz	!Rotation_C	;C parameter low 8 bit
;		stz	!Rotation_C	;            high
;		stz	!Rotation_D	;D parameter low 8 bit
;		sta	!Rotation_D	;            high
;
;		stz	!Rotation_center+00h	;x center
;		lda	#02h
;		sta	!Rotation_center+00h
;		stz	!Rotation_center+01h	;y center
;		sta	!Rotation_center+01h
;
;		lda	#80h
;		ldx	#01h
;		sta	!Scroll_0H
;		stx	!Scroll_0H
;		sta	!Scroll_0V
;		stx	!Scroll_0V
;
;		stz	!Window_control+00h
;		stz	!Window_control+02h
;						;winndow off
		lda	#00010000b
		sta	!Through_screen+00h
;						;through main
;						;main=BG12& OBJ
		sta	!Through_window+00h
;						;through main (windwo)
		stz	!Through_screen+01h
;						;through sub disable
;		
		stz	!Through_window+01h
;						;through sub (window)
;		lda	#00110000b
;		sta	!Color_control		 
;						;color window off
;		lda	#11100000b
;		sta	!Color_bias
;						;color bias data
		stz	!Color_brend 		;color add disable
		stz	!PPU_option
						;b7=0 not super inpose
						;b6=0 not ext input
						;b45  not use
						;b3=0 not 512 mode
						;b2=0 224 line/1 field
						;b1=0 OBJ V select
						;b0=0 non interless 
		stz	!Timer_H+00h
		stz	!Timer_H+01h
						;H count timer
		stz	!Timer_V+00h
		stz	!Timer_V+01h
						;V count timer
		stz	!Timer_control
						;disable timer
		stz	<irq_index
		stz	!DMA_burst
		stz	!DMA_syncro
						;DMA&H-DMA off
						;NMI disable
						;IRQ disable
						;controler disable
		rep	#00110000b
		rts
;----------------------------------------------------------------------------
Race_resister_init
		mem8
		sep	#00100000b
		lda	#080h
		sta	!Timer_H+00h
		stz	!Timer_H+01h
		stz	!Timer_V+01h		;set HV timer
		lda	#10110001b
		sta	!Timer_control		;HV timer enable
		rep	#00100000b
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
;----------------------------------------------------------------------------
Init_character
		phb
		phk
		plb
		jsr	!Set_2bit_moji
		jsr	!Set_4bit_moji
;;;
		ldy	#offset ITEM
		lda	#bank ITEM		;MARK & ITEM=ROM address
		ldx	#offset item_obj	;RAM address
		jsl	>Decode_7F_X		;set data to 7f8000h
;;;
;;;
;;;		ldy	#offset BG_DATA
;;		lda	#bank   BG_DATA
;;		ldx	#offset	bg_check_data
;;		jsl     >Decode_7E_X
;;;
		plb
		rtl
;----------------------------------------------------------------------------
Set_2bit_moji
		ldy	#offset MOJI
		lda	#bank MOJI		;moji character 2bit mode
		ldx	#04400h
		jsl	>Decode_7F_X
						;set 7f4400h
		rts
;----------------------------------------------------------------------------
Set_4bit_moji
		phb
		lda	#07fh
		pha
		plb
		ldy	#00000h			;from 7f4400h
		ldx	#00000h
T24_loop0
		lda	#0008h
		sta	<counter
T24_loop1
		lda	!04400h,y
		sta	!0A000h,x		;to 7f6000h
		inx
		inx
		iny
		iny	
		dec	<counter
		bne	T24_loop1	
		lda	#0008h
		sta	<counter		
T24_loop2
		stz	!0A000h,x
		inx
		inx
		dec	<counter
		bne	T24_loop2
		cpy	#02000h
		bne	T24_loop0
End_trans_loop
		plb
		plb
		rts
;----------------------------------------------------------------------------
Set_battle_OBJ
		rep	#00110000b
;Set ball
		lda	#080h
		sta	!Screen_step
;
		ldy	#offset BALL
		lda	#bank BALL
		ldx	#0c000h
		jsl	>Decode_7F_X
;
		lda	#05200h
		sta	!Screen_address+00h
						;set VRAM
						;001=2 address(L&H)
		lda	#001h
		sta	!DMA_0+00h
		lda     #18h
		sta     !DMA_0+01h
						;set 2118h
		lda	#07fc0h
		sta	!DMA_0+03h
						;data address=7F0000h
		lda	#0400h
		sta	!DMA_0+05h
						;trans value=60h
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
		lda	#06200h
		sta	!Screen_address+00h
		lda	#07fc0h
		sta	!DMA_0+03h
						;data address=7F0000h
		lda	#0400h
		sta	!DMA_0+05h
						;trans value=60h
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
		rts
;----------------------------------------------------------------------------
Set_maps
		jsr	!Set_map_character
		jsr	!Set_map_screen
		rts
;----------------------------------------------------------------------------
Set_map_character
		jsr     !Set_item_BG
		jsr	!Open_character
		jsr	!Set_character_data
		jsl     >Set_changeBG
		rts
;----------------------------------------------------------------------------
Set_map_screen
		jsr	!Open_screen
		jsl     >Set_BG_item
		jsr	!Set_screen_data
		rts
;----------------------------------------------------------------------------
Set_map_address
		lda	!map_number
		asl	a
		clc
		adc	!map_number
		tax
		rts
;----------------------------------------------------------------------------
Set_ROM_to_buffer
		jsr	!Set_map_type
		jsr	!Open_screen
		jsr	!Open_character
;;;;		jsr	!Open_color
		rts
;----------------------------------------------------------------------------
Set_buffer_to_PPU
		jsr	!Set_character_data
		jsr	!Set_screen_data
		rts
;----------------------------------------------------------------------------
Set_item_BG
		jsr	!Set_item_BG_buffer
;set vram
		lda	#080h
		sta	!Screen_step		;High bit INC
;
		lda	#0c0h*040h
		sta	!Screen_address+00h
		stz	!DMA_0+00h
		lda	#0019h
		sta	!DMA_0+01h
		lda	#07f70h
		sta	!DMA_0+03h
						;set bank&highaddress
;						;from 7f4000h address
		lda	#040h*40h
		sta	!DMA_0+05h
;						;trans quantity=4000
		lda	#00001h
		sta	!DMA_burst
;
		rts		
;----------------------------------------------------------------------------
Set_item_BG_buffer
		ldy	#offset BG_ITEM
		lda	#bank  BG_ITEM
		ldx	#0000h
		jsl	>Decode_7F_X
		ldx	#0000h			;resd address
		ldy	#4000h+0c0h*040h	;wright address
		lda	#040h
		jsl     >Decode_M7_BF
		rts
;----------------------------------------------------------------------------
Open_character
		jsr	!Calc_index
		lda	>Mode7_character_address+00h,x
		tay
		lda	>Mode7_character_address+02h,x
		and	#00ffh
		ldx	#0c000h
		jsl	>Decode_7F_X
		ldx	#0c000h			;read address
		ldy	#04000h			;write address
		lda	#0c0h			;amount of character
		jsl	>Decode_M7_BF
;set mode0 character
		jsr	!Calc_index
		lda	>Back_character_address+00h,x
		tay
		lda	>Back_character_address+02h,x
		and	#00ffh
		ldx	#0c800h
		jsl	>Decode_7F_X
;
		lda	#bank ABC
		ldy	#offset ABC			;slot charcter(59262h)-abc.
		ldx	#0d000h
		jsl	>Decode_7F_X			;to 7fd000h(0800h)
;set mode 0 screen
		jsr	!Calc_index
		lda	>Back_screen_address+00h,x
		tay
		lda	>Back_screen_address+02h,x
		ldx	#0c000h				;set 7fc000h
		jsl	>Decode_7F_X
Open_color
;						entry map type
		jsr	!Calc_index
		lda	>Color_data_address+00h,x
		tay
		lda	>Color_data_address+02h,x
		and	#00ffh
		ldx	#offset color_buffer
		jsl	>Decode_7E_X
;
		rts
;----------------------------------------------------------------------------
Open_screen
		jsr	!Set_map_address
		lda	>Mode7_screen_address+00h,x
		tay
		lda	>Mode7_screen_address+02h,x
		and	#00ffh
		ldx	#0c000h
		jsl	>Decode_7F_X		;first ROM to 7fc000h
		ldy	#0c000h
		lda	#07fh
		ldx	#0000h
		jsl	>Decode_7F_X            ;second 7fc000h to 7f0000h
		rts
;----------------------------------------------------------------------------
Set_character_data		
;Set_mode7_char
		lda	#080h
		sta	!Screen_step		;High bit INC
;
		stz	!Screen_address+00h
		stz	!DMA_0+00h
		lda	#0019h
		sta	!DMA_0+01h
		lda	#07f40h
		sta	!DMA_0+03h
						;set bank&highaddress
;						;from 7f4000h address
		lda	#04000h-040h*40h
		sta	!DMA_0+05h
;						;trans quantity=4000
		lda	#00001h
		sta	!DMA_burst
Set_back_char
		lda	#07000h
		sta	!Screen_address		;VRAM address
		lda	#01801h
		sta	!DMA_0+00h
						;    b0123=0000 INC step
						;01h=set 2118h(resister)
						;00h=data address low
		stz	!DMA_0+02h
		lda	#07fc8h
		sta	!DMA_0+03h
						;data address=7Fc800h
		lda	#1000h
		sta	!DMA_0+05h
						;trans value=400h(80h-chr)
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
Set_back_screen
		jsr	!Set_back_01
		jsr	!Set_back_02
		rts
;----------------------------------------------------------------------------
Set_screen_data
		stz	!DMA_0+00h
		lda	#000h
		sta	!Screen_step
;						;b7=0 L bit INC
;						;b0123=INC step(1)
		stz	!Screen_address+00h
		lda	#0018h
		sta	!DMA_0+01h
;						;set 2118h resister
						;set low address
		lda	#07f00h
		sta	!DMA_0+03h
						;set bank&highaddress
;						;from 7f0000h address
		lda	#04000h
		sta	!DMA_0+05h
;						;trans quantity=4000
		lda	#00001h
		sta	!DMA_burst
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Set_back_01
		lda	#080h
		sta	!Screen_step
;
		lda	#01801h
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
	

		stz	!DMA_0+02h		;data address
		ldx	#0600h			;counter
		lda	#07800h
		ldy	#00000h+0c000h
		jsr	!Set_DMA_param	
		rts
Set_back_02
		lda	#080h
		sta	!Screen_step
;
		lda	#01801h
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
	

		stz	!DMA_0+02h		;data address
;
		ldx	#0300h			;counter
		lda	#07c00h
		ldy	#00100h+0c000h
		jsr	!Set_DMA_param	
		ldx	#0100h			;counter
		lda	#07d80h
		ldy	#00000h+0c000h
		jsr	!Set_DMA_param	
		ldx	#0100h			;counter
		lda	#07e00h
		ldy	#00500h+0c000h
		jsr	!Set_DMA_param	
		ldx	#0100h			;counter
		lda	#07e80h
		ldy	#00400h+0c000h
		jsr	!Set_DMA_param	
		rts
;----------------------------------------------------------------------------
Set_DMA_param	
;	
		sty	!DMA_0+02h		;data address
		sta	!Screen_address
		lda	#07fh
		sta	!DMA_0+04h
						;data  address bank=07fh
		stx	!DMA_0+05h
						;trans quantity=40h
;
		lda	#00000001b
		sta	!DMA_burst
						;start channel 0_DMA
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Calc_index
		lda	!map_type
		lsr	a
		clc
		adc	!map_type
		tax
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Set_OBJ_100
;;Set_jugem;(& shadow)
		lda	#080h
		sta	!Screen_step
		ldy	#offset JUGEM_SHADOW
		lda	#bank JUGEM_SHADOW
		ldx	#0c000h
		jsl	>Decode_7F_X		;set  7fc000h
		lda	#04400h
		sta	!Screen_address+00h
		lda	#00000001b
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
		lda	#001h
		sta	!DMA_0+00h
		lda     #18h
		sta     !DMA_0+01h
						;set 2118h
		lda	#07fc2h
		sta	!DMA_0+03h
						;data address=7Fc200h
		lda	#1000h
		sta	!DMA_0+05h
						;trans value=1200h
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
;Set jugem lamp
		lda	#05000h-05h*10h
		sta	!Screen_address+00h	;set chr 0fbh
		lda	#1801h
		sta	!DMA_0+00h
		lda	#0c000h+0ch*020h
		sta	!DMA_0+02h
		lda	#07fh			;address 7fc000h+0bh chara
		sta	!DMA_0+04h
		lda	#20h*04h
		sta	!DMA_0+05h
						;trans value=4 character
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
;set shadow
		lda	#05000h-015h*010h
		sta	!Screen_address+00h	;set chr 0fbh
		lda	#1801h
		sta	!DMA_0+00h
		lda	#0c000h+09h*020h
		sta	!DMA_0+02h
		lda	#07fh			;address 7fc000h+0bh chara
		sta	!DMA_0+04h
		lda	#20h*03h
		sta	!DMA_0+05h
						;trans value=4 character
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
;set sand						Set_sand
;;
;		ldy	#offset SAND
;		lda	#bank SAND
;		ldx	#0a000h-0400h		;set 7fa000h-0400h=9c00h
;		jsl	>Decode_7F_X		;buffer set
		rts
;----------------------------------------------------------------------------
Set_OBJ_200
;						;entry map_type!!!
		jsr	!Calc_index
		ldy	!Obstruct_address+00h,x
		lda	!Obstruct_address+02h,x
		and	#00ffh
		ldx	#04000h			;set 7f4000h
		jsl	>Decode_7F_X
;
		lda	#080h
		sta	!Screen_step
		lda	#04c00h
		sta	!Screen_address+00h
						;set VRAM
						;001=2 address(L&H)
		lda	#001h
		sta	!DMA_0+00h
		lda     #18h
		sta     !DMA_0+01h
						;set 2118h
		lda	#07f40h
		sta	!DMA_0+03h
						;data address=7F0000h
		lda	#02bh*020h
		sta	!DMA_0+05h
						;trans value=800h
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
		lda	#04c00h+030h*010h
		sta	!Screen_address+00h
		lda	#04000h+030h*20h
		sta	!DMA_0+02h
		lda	#0007fh
		sta	!DMA_0+04h
						;data address=7F0000h
		lda	#00bh*020h
		sta	!DMA_0+05h
						;trans value=800h
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
		rts
;----------------------------------------------------------------------------
Set_OBJ_300
		jsr     !Set_effect_OBJ
		jsr	!Set_mark
		rts
;----------------------------------------------------------------------------
Set_OBJ_400
		jsr	!Set_effect_OBJ
		rts
;----------------------------------------------------------------------------
Set_waterpole
Set_effect_OBJ
		lda	#080h
		sta	!Screen_step
;
		ldy	#offset WATER
		lda	#bank WATER
		ldx	#0c000h			;set 7fc000h
		jsl	>Decode_7F_X
		lda	#04000h
		sta	!Screen_address		;VRAM address
		lda	#00001h
		sta	!DMA_0+00h
						;00h b7=1 H bit INC
						;    b0123=0001 INC step
		lda	#0018h
		sta	!DMA_0+01h
						;01h=set 2118h(resister)
						;00h=data address low
		lda	#07fc0h
		sta	!DMA_0+03h
						;data address=7Fc000h
		lda	#00800h
		sta	!DMA_0+05h
						;trans value=1000h
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
Set_sand
		ldy     #offset SAND
		lda     #bank SAND
		ldx     #offset smoke_obj           ;set 7fa000h-0400h=9c00h
		jsl     >Decode_7F_X            ;buffer set
;;;
		lda	#05000h
		sta	!Screen_address		;VRAM address
		lda	#1801h
		sta	!DMA_0+00h
						;    b0123=0001 INC step
		lda     #offset smoke_obj
		sta     !DMA_0+02h
						;00h=data address low
		lda     #bank smoke_obj
		sta     !DMA_0+04
		lda	#00400h
		sta	!DMA_0+05h
						;trans value=0c00h
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
Set_sand_2
		lda	#06000h			;VRAM address=6000h
		sta	!Screen_address+00h	;			
						;from 69200h address
		lda	#1801h
		sta	!DMA_0+00h
						;    b0123=0001 INC step
						;01h=set 2118h(resister)
		lda	#0018h
		sta	!DMA_0+01h
						;00h=data address low
		lda	#offset smoke_obj
		sta	!DMA_0+02h
						;data address=7F9c00h
		lda	#bank smoke_obj
		sta	!DMA_0+04
		lda	#00400h
		sta	!DMA_0+05h
						;trans quantity=0c00h
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
		rts
;----------------------------------------------------------------------------
Set_mark
		ldy	#offset MARK
		lda	#bank MARK		;MARK & ITEM=ROM address
		ldx	#offset mark_obj	;RAM address
		jsl	>Decode_7F_X		;set data to 7e2000h

		lda	#05200h
		sta	!Screen_address+00h
		lda	#00000001b
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
		lda	#1801h
		sta	!DMA_0+00h
						;set 2118h
		lda	#offset mark_obj_2
		sta	!DMA_0+02h
		lda     #bank   mark_obj_2
		sta     !DMA_0+04h
		lda	#34h*20h
		sta	!DMA_0+05h
						;trans value=34h character
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
;set face more
		lda	#06200h
		sta	!Screen_address+00h
		lda	#00000001b
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
		lda	#1801h
		sta	!DMA_0+00h
						;set 2118h
		lda	#offset mark_obj_2
		sta	!DMA_0+02h
		lda	#bank   mark_obj_2
		sta	!DMA_0+04h
		lda	#20h*20h
		sta	!DMA_0+05h
						;trans value=20h character
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
;
		lda	#06400h
		sta	!Screen_address+00h
		lda	#00000001b
		sta     !DMA_0+00h
						;set VRAM
						;001=2 address(L&H)
		lda	#001h
		sta	!DMA_0+00h
		lda     #8018h
		sta     !DMA_0+01h
						;set 2118h
		lda	#07fcch
		sta	!DMA_0+03h		;data address=7e2c80h
		lda	#14h*20h
		sta	!DMA_0+05h
						;trans value=20h character
		lda	#00001h
		sta	!DMA_burst
						;start channel 0_DMA
;
		ldy	#offset	PERAPERA
		lda	#bank	PERAPERA
		ldx	#offset perapera_obj
		jsl	>Decode_7F_X
;
		ldy	#offset LOST
		lda	#bank LOST
		ldx	#offset lost_obj
		jsl     >Decode_7F_X		;set data to 7f9800h
;
		rts
;---------------------------------------------------------------------------
		mem16
bg_check_data	equ	7f0000h				;open to 7f0000h
BG_attribute_set
		ldy     #offset BG_DATA
		lda     #bank   BG_DATA
		ldx     #offset bg_check_data
		jsl     >Decode_7F_X			;open BG table
		ldy	!map_type
		ldx	!BG_check_address,y
		ldy	#0000h
		mem8
		sep	#00100000b
Set_attribute_loop
		lda	>bg_check_data,x
		sta	!bg_check_table,y	;from 700h
		inx
		iny
		cpy	#0c0h
		bne	Set_attribute_loop
Common_attribute
		ldx	#Common_bg
Common_loop
		lda	>bg_check_data,x
		sta	!bg_check_table,y
		inx
		iny
		cpy	#100h
		bcc	Common_loop
		mem16
		rep	#00100000b
		rts
;----------------------------------------------------------------------------
BG_check_address
		word    Obake_bg,Circuit_bg,Grass_bg
		word    Dart_bg,Ice_bg,Sand_bg,Castle_bg
Common_bg       equ     000h
Circuit_bg      equ     040h
Obake_bg        equ     100h
Grass_bg        equ     120h
Castle_bg       equ     1a0h
Ice_bg          equ     20eh
Dart_bg         equ     289h
Sand_bg         equ     2e0h
;----------------------------------------------------------------------------
Mode7_screen_address
		lword	MAP00_SCR,MAP01_SCR,MAP02_SCR,MAP03_SCR,MAP04_SCR
		lword	MAP05_SCR,MAP06_SCR,MAP07_SCR,MAP08_SCR,MAP09_SCR
		lword	MAP0A_SCR,MAP0B_SCR,MAP0C_SCR,MAP0D_SCR,MAP0E_SCR
		lword	MAP0F_SCR
		lword	MAP10_SCR,MAP11_SCR,MAP12_SCR,MAP13_SCR,MAP14_SCR
		lword	MAP15_SCR,MAP16_SCR,MAP17_SCR
Mode7_character_address
		lword	OBAKE_CHR
		lword	CIRCUIT_CHR
		lword	GRASS_CHR
		lword	DART_CHR
		lword	ICE_CHR
		lword	SAND_CHR
		lword	CASTLE_CHR
;		lword	MAP00_CHR,MAP01_CHR,MAP02_CHR,MAP03_CHR,MAP04_CHR
;		lword	MAP05_CHR,MAP06_CHR,MAP07_CHR,MAP08_CHR,MAP09_CHR
;		lword	MAP0A_CHR,MAP0B_CHR,MAP0C_CHR,MAP0D_CHR,MAP0E_CHR
;		lword	MAP0F_CHR
;		lword	MAP10_CHR,MAP11_CHR,MAP12_CHR,MAP13_CHR,MAP14_CHR
;		lword	MAP15_CHR,MAP16_CHR,MAP17_CHR,MAP18_CHR,MAP19_CHR
;		lword	MAP1A_CHR,MAP1B_CHR,MAP1C_CHR,MAP1D_CHR,MAP1E_CHR
;		lword	MAP1F_CHR
Color_data_address
		lword	OBAKE_COL
		lword	CIRCUIT_COL
		lword	GRASS_COL
		lword	DART_COL
		lword	ICE_COL
		lword	SAND_COL
		lword	CASTLE_COL
;		lword	MAP00_COL,MAP01_COL,MAP02_COL,MAP03_COL,MAP04_COL
;		lword	MAP05_COL,MAP06_COL,MAP07_COL,MAP08_COL,MAP09_COL
;		lword	MAP0A_COL,MAP0B_COL,MAP0C_COL,MAP0D_COL,MAP0E_COL
;		lword	MAP0F_COL
;		lword	MAP10_COL,MAP11_COL,MAP12_COL,MAP13_COL,MAP14_COL
;		lword	MAP15_COL,MAP16_COL,MAP17_COL,MAP18_COL,MAP19_COL
;;		lword	MAP1A_COL,MAP1B_COL,MAP1C_COL,MAP1D_COL,MAP1E_COL
;		lword	MAP1F_COL
Obstruct_address
		lword	OBAKE_OBJ
		lword	CIRCUIT_OBJ
		lword	GRASS_OBJ
		lword	DART_OBJ
		lword	ICE_OBJ
		lword	SAND_OBJ
		lword	CASTLE_OBJ
;		lword	MAP00_OBJ,MAP01_OBJ,MAP02_OBJ,MAP03_OBJ,MAP04_OBJ
;		lword	MAP05_OBJ,MAP06_OBJ,MAP07_OBJ,MAP08_OBJ,MAP09_OBJ
;		lword	MAP0A_OBJ,MAP0B_OBJ,MAP0C_OBJ,MAP0D_OBJ,MAP0E_OBJ
;		lword	MAP0F_OBJ
;		lword	MAP10_OBJ,MAP11_OBJ,MAP12_OBJ,MAP13_OBJ,MAP14_OBJ
;		lword	MAP15_OBJ,MAP16_OBJ,MAP17_OBJ,MAP18_OBJ,MAP19_OBJ
;		lword	MAP1A_OBJ,MAP1B_OBJ,MAP1C_OBJ,MAP1D_OBJ,MAP1E_OBJ
;		lword	MAP1F_OBJ
Back_character_address
		lword	OBAKE_BCH
		lword	CIRCUIT_BCH
		lword	GRASS_BCH
		lword	DART_BCH
		lword	ICE_BCH
		lword	SAND_BCH
		lword	CASTLE_BCH
;		lword	MAP00_BCH,MAP01_BCH,MAP02_BCH,MAP03_BCH,MAP04_BCH
;		lword	MAP05_BCH,MAP06_BCH,MAP07_BCH,MAP08_BCH,MAP09_BCH
;		lword	MAP0A_BCH,MAP0B_BCH,MAP0C_BCH,MAP0D_BCH,MAP0E_BCH
;		lword	MAP0F_BCH
;		lword	MAP10_BCH,MAP11_BCH,MAP12_BCH,MAP13_BCH,MAP14_BCH
;		lword	MAP15_BCH,MAP16_BCH,MAP17_BCH,MAP18_BCH,MAP19_BCH
;		lword	MAP1A_BCH,MAP1B_BCH,MAP1C_BCH,MAP1D_BCH,MAP1E_BCH
;		lword	MAP1F_BCH
Back_screen_address
		lword	OBAKE_BSC
		lword	CIRCUIT_BSC
		lword	GRASS_BSC
		lword	DART_BSC
		lword	ICE_BSC
		lword	SAND_BSC
		lword	CASTLE_BSC
;		lword	MAP00_BSC,MAP01_BSC,MAP02_BSC,MAP03_BSC,MAP04_BSC
;		lword	MAP05_BSC,MAP06_BSC,MAP07_BSC,MAP08_BSC,MAP09_BSC
;		lword	MAP0A_BSC,MAP0B_BSC,MAP0C_BSC,MAP0D_BSC,MAP0E_BSC
;		lword	MAP0F_BSC
;		lword	MAP10_BSC,MAP11_BSC,MAP12_BSC,MAP13_BSC,MAP14_BSC
;		lword	MAP15_BSC,MAP16_BSC,MAP17_BSC,MAP18_BSC,MAP19_BSC
;		lword	MAP1A_BSC,MAP1B_BSC,MAP1C_BSC,MAP1D_BSC,MAP1E_BSC
;		lword	MAP1F_BSC
;---------------------------------------------------------------------------
World_map_data	
		byte	13h,12h,10h,11h,07h		;kinoko  cup
		byte	0dh,0ah,02h,03h,0fh		;flower  cup
		byte	01h,0ch,0bh,09h,00h		;star    cup
		byte	04h,06h,05h,08h,0eh		;special cup
Map_type_data;
		byte	circuit,obake,grass,castle,ice
		byte	dart,sand,circuit,obake,castle
		byte	dart,grass,ice,sand,circuit
		byte	circuit,obake,castle,dart,grass ;race
;
		byte	ice,grass,dart,sand		;battle
obake		equ	0000h
circuit		equ	0002h
grass		equ	0004h
dart		equ	0006h
ice		equ	0008h
sand		equ	000ah
castle		equ	000ch
;----------------------------------------------------------------------------
		mem16
		idx16
Set_map_number
		lda	!world_number
		asl	a
		asl	a
		clc
		adc	!world_number
		adc	!map_pointer
		tax
		lda	!World_map_data,x
		and	#00ffh
		sta	!map_number
		rts
Set_map_type
;		lda	!map_number
;		tax
;		asl	a
;		clc
;		adc	!map_number
;		tay
		ldx	!map_number
		lda	!Map_type_data,x
		and	#00ffh
		sta	!map_type
Dummy_set
		rts
;----------------------------------------------------------------------------
Free_RAM_init
Battle_RAM_init
		jsr	!Clear_kart_flag	;1200h-1700h dont exist
		ldy	#0000h
		ldx	<game_mode
		jmp	(!Set_free_rank,x)
Set_free_rank
		word	Player_02,Player_U1,Player_L1
Player_02
		lda	#1000h
		jsr	!Set_rank_sub
		lda	#1100h
		jsr     !Set_rank_sub
		bra	Clear_rank_index
Player_U1
		stz	!1100h+kart_flag	;1100h kart dont exist
		lda	#1000h
		bra	Set_rank_free
Player_L1
		stz	!1100h+kart_flag	;1000h kart dont exist
		lda     #1100h
Set_rank_free
		jsr     !Set_rank_sub
Clear_rank_index
		lda	#0000h
Clear_rank_loop
		sta	!rank_index,y
		iny
		iny
		cpy	#012h
		bcc	Clear_rank_loop
;		
		jmp	!Commom_RAM_initial		
;----------------------------------------------------------------------------
Clear_kart_flag
		ldx	#1200h
Clear_flag_loop
		stz	<kart_flag,x
		txa
		clc
		adc	#0100h
		tax
		cmp	#1800h
		bcc	Clear_flag_loop
		rts
;----------------------------------------------------------------------------
Set_rank_sub
		sta	!rank_index,y
		tax
		tya
		sta	<rank_number,x
		lda	#1000000001000000b		;b15 mykart bit
							;b6  cut engine sound
		sta	<kart_flag,x
		jsr	!Kart_RAM_init
		iny
		iny
		rts
;----------------------------------------------------------------------------
Race_RAM_init
		mem16
		idx16
		rep	#00110000b
;
		ldx	#01700h
Set_RAM_loop
		cpx	#01200h
		bcs	Enemy_RAM_init
Player_RAM_init
		lda	#1000000001000000b	
							;b15 mykart bit
							;b6 cut engine sound
		bra	Set_kart_flag
Enemy_RAM_init
		lda	#0010000000000000b
							;b13 comp control bit
Set_kart_flag
		sta	<kart_flag,x		
		jsr	!Kart_RAM_init
		txa
		sec
		sbc	#0100h
		tax
		cmp	#1000h
		bcs	Set_RAM_loop
;----------------------------------------------------------------------------
Commom_RAM_initial
		mem16
		idx16
;;
		stz	<frame_counter
		stz	<sprite_countA
		stz	<sprite_countB
		stz	!goalin_number
		stz	!over_flag
		stz	!mark_index
;;;;;		stz	<race_status
		stz	!pause_status
		stz	!camera_counter
		stz	!game_counter
;;;;;;		stz	!screenA_official
;;;;;;		stz	!screenB_official
		stz	<trans_counter
		lda	#0500h+8000h		;08000h=00
		sta	!lap_number		;round =05h ...fixed
		sta	!clear_driver
		sta	!signal_counter
		stz	!fanfare_counter
		stz	finallap_counter
		stz	!bgm_status
		lda	<game_mode
		sta	!se_status
		lda	#0ffffh
		sta	!old_doppler_dist
		sta	!ultra_index
;----------------------------------------------------------------------------
;Clear lap buffer
;;		lda	#0ffffh			;entry A=0ffffh
		ldx	#01ch
Clear_lap_buffer
		sta	>laptime_buffer+000h,x	;minute lap buffer
		sta	>laptime_buffer+01eh,x	;minute lap buffer
		dex
		dex
;		dex
;		dex
;		dex
;;;		dex
		bpl	Clear_lap_buffer
;----------------------------------------------------------------------------
		sep	#00110000b
		jsl	>Regular_IRQ_init
		rep	#00110000b
Init_trans
		ldx	#020h
Clear_trans_loop
		stz	<0deh,x
		dex
		dex
		bpl	Clear_trans_loop
;;;
		lda	#04h
Init_trans_loop
		sta	<frame_counter
		pha
;;		jsr	!Set_trans_bufferA
;;		jsr	!Set_trans_bufferB
;;		jsr	!OBJ_transport
		jsl	>Initial_OBJ_trans
		pla
		dec	a
		bpl	Init_trans_loop
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Set_driver
		ldy	#1700h
		ldx	#000eh
Obj_number_loop
		lda	>Obj_num_data,x
		sta	!obj_attribute,y		;
		lda	>VRAM_address,x
		sta	!vram_addressA,y
		clc
		adc	#1000h
		sta	!vram_addressB,y
		tya
		sec
		sbc	#0100h
		tay
		dex
		dex
		bpl	Obj_number_loop
;
		ldx	<game_mode
		jmp	(!Set_driver_mode,x)
Set_driver_mode
		word	Driver_00,Driver_02,Driver_04
;;;Driver_04
;		lda	!1100h+driver_number
;		pha
;		jsr	!Set_mycar_02
;		pla
;		inc	a
;		inc	a
;		and	#000fh
;		sta	!1000h+driver_number
;		bra	Driver_00
;;;Driver_02
;		lda	!1000h+driver_number
;		pha
;		jsr	!Set_mycar_01
;		pla
;		inc	a
;		inc	a
;		and	#000fh
;		sta	!1100h+driver_number
Driver_00
		jsr	!Set_mycar_01
		lda	#000eh
		sta	!1000h+rank_number			;last!!
		jsr     !Set_mycar_02
		lda	#000ch
		sta	!1100h+rank_number				;bubi
		lda	#00h
		jsr	!Set_enemy_rank
		bra	Set_drive_number
Driver_02
		jsr     !Set_mycar_01
		lda	#0eh
		sta     !1000h+rank_number			;last!!
		jsr	!Set_rival_02
		stz     !1100h+rank_number			;top!!!
		lda	#02h
		jsr     !Set_enemy_rank
		bra	Set_drive_number
Driver_04
		jsr     !Set_mycar_02
		lda	#000eh
		sta     !1100h+rank_number			;last
		jsr	!Set_rival_01
		stz     !1000h+rank_number			;top!!!
		jsr     !Set_enemy_rank
Set_drive_number
		ldy	#1000h
		lda	!driver_number,y
		jsr     !Set_attribute
		ldy	#1100h
		lda	!driver_number,y
;----------------------------------------------------------------------------
		mem16
		idx16
;		entry				;a=driver number
						;x=1000,1100,1200....1700
Set_attribute
		phx
		tax
		lda	>Character_palet,x
		ora	!obj_attribute,y
		sta	!obj_attribute,y
		plx
		rts
;----------------------------------------------------------------------------
Set_enemy_rank
		sta	<tempolary
		ldx	#0000h
		ldy	#1200h
Set_driver_loop
		lda	!Driver_priality,x
		cmp	!1000h+driver_number	;comp driber00
		beq	Next_driver
		cmp	!1100h+driver_number	;comp driver02
		beq	Next_driver
		sta	!driver_number,y
						;not control 01&02
		jsr	!Set_attribute
		lda	<tempolary
		sta	!rank_number,y
		tya
		clc
		adc	#0100h
		cmp	#1800h
		beq	End_set_driver
		tay
		inc	<tempolary
		inc	<tempolary
		inx
		inx
		bra	Set_driver_loop
Next_driver
		inx
		inx
		bra	Set_driver_loop
End_set_driver
		rts
;----------------------------------------------------------------------------
Driver_priality
		word	mario,luigi,koopa,cong,peach,yossy,kinopio,nokonoko
;----------------------------------------------------------------------------
Set_mycar_01
		ldy	#0000h
		ldx	#1000h
		lda	#player01_table
		jsr	!Open_mycar
		rts
Set_mycar_02
		ldy	#0000h
		ldx	#1100h
		lda	#player02_table
		jsr	!Open_mycar
		rts
Set_rival_01
		lda	!Driver_priality+00h
		cmp	!1100h+driver_number
		bne	Set_number_01
		lda	!Driver_priality+02h
Set_number_01
		sta	!1000h+driver_number
		rts
Set_rival_02
		lda	!Driver_priality+00h
		cmp	!1000h+driver_number
		bne	Set_number_02
		lda	!Driver_priality+02h
Set_number_02
		sta	!1100h+driver_number
		rts
;----------------------------------------------------------------------------
Open_mycar
		sta	<write_address
		stz	<write_address+02h
		lda	<driver_number,x
		phx				;>>>>>>>>>>>>phx
		idx8
		sep	#00010000b
		tax
		lda	!Mycar_performance_offset,x
		sta	<read_address+00h
		lda     !Mycar_performance_bank,x
		sta     <read_address+02h
		jsr	!Open_accel
		jsr     !Open_resist
		jsr	!Open_steering
		jsr	!Open_drift
;open max
		lda	[read_address]
		tax
		lda	!Max_speed_perform,x
		jsr	!Multi_10h
;
		idx16
		rep	#00010000b
		plx				;<<<<<<<<<plx
		sta	!max_velocity,x	
		rts
;----------------------------------------------------------------------------
		idx8
Open_accel
		lda	[<read_address]
		inc	<read_address
		tax
Open_accel_loop
		lda	!Accel_perform,x
		jsr	!Multi_10h
		sta	[<write_address],y
		iny
		iny
		inx
		cpy	#020h
		bne	Open_accel_loop
		rts
;----------------------------------------------------------------------------
Open_resist
		lda	<read_address
		sta	<read_address_dash
Resist_loop1
		lda	[<read_address]
		inc	<read_address
		tax
		lda	!Resist_perform1-01,x
		sta	[<write_address],y
		iny
		iny
		lda     !Resist_perform1+00,x
		sta     [<write_address],y
		iny
		iny
		cpy	#030h
		bne	Resist_loop1
		lda	<read_address_dash
		sta	<read_address
Resist_loop2
		lda     [<read_address]
		inc     <read_address
		tax
		lda	!Resist_perform2+00h,x
		jsr	!Multi_10h
		sta	[<write_address],y
		iny
		iny
		lda     !Resist_perform2+01h,x
		jsr     !Multi_10h
		sta     [<write_address],y
		iny
		iny
		cpy	#40h
		bcc	Resist_loop2
		rts
;----------------------------------------------------------------------------
Open_steering
		lda	[read_address]
		inc     <read_address
		tax
Open_steering_loop2
		jsr	!Open_steering_sub
		cpy	#058h
		bne	Open_steering_loop2
		rts
;----------------------------------------------------------------------------
Open_E_steering
		lda	[read_address]
		inc     <read_address
		tax
Open_steering_sub
		lda	!Steering_perform,x
		sta	[<write_address],y
		inx
		inx
		iny
		iny
		lda	#03
		sta	<counter
Open_steering_loop1
		lda	!Steering_perform,x
		and	#00ffh
		sta	[<write_address],y
		inx
		iny
		iny
		dec	<counter
		bne	Open_steering_loop1
		rts		
;----------------------------------------------------------------------------
Open_drift
		lda	[read_address]
		inc	<read_address
		tax
Open_drift_loop1
		lda	!Drift_perform+00h,x
		jsr	!Multi_10h
		sta	[write_address],y				;start velocity
		iny
		iny
		inx
		lda	!Drift_perform-01h,x
		sta	[<write_address],y
		iny
		iny
		inx
		lda	#04h
		sta	<counter
Open_drift_loop2
		lda	!Drift_perform,x
		jsr     !Multi_10h
		sta	[write_address],y
		inx
		iny
		iny
		dec	<counter
		bne	Open_drift_loop2
		cpy	#07ch
		bne	Open_drift_loop1
		rts
;----------------------------------------------------------------------------
Multi_10h
		and	#0ffh
		asl	a
		asl	a
		asl	a
		asl	a
		rts
;----------------------------------------------------------------------------
;Set_drive_sub
;		stx	<wright_address+00h
;		stz	<wright_address+02h
;		sty	<read_address+00h
;		sta	<read_address+02h
;		ldy	#0000h
;Set_drive_loop
;		lda	[<read_address],y
;		sta	[<wright_address],y
;		iny
;		iny
;		cpy	#058h
;		bcc	Set_drive_loop
;		lda	[<read_address],y;>>>>>>>mycar's max velocity
;		rts
;----------------------------------------------------------------------------
		mem16
		idx16
;					entry X=1000,1100,1200....1700
Kart_RAM_init
		stz	<kart_direction,x
		stz	<move_direction,x
		stz	<body_direction,x
		stz	<obj_velocity_x,x
		stz	<obj_velocity_y,x
		stz	<obj_velocity_z,x
		stz	<kart_control,x		;>>>>>>>>>>engine_control
		stz	<engine_power,x
		stz	<special_trigger,x
		stz	<kart_status,x
		stz	<kart_space,x
		stz	<kart_counter,x
		stz	<dash_counter,x
		stz	<spin_counter,x
		lda	#07f00h
		sta	<kart_area,x			;low kart area
							;high kart lap
		sta	<lap_counter,x
		stz	<event_index,x	
		stz	<drive_status,x
		stz	<move_status,x
		stz	<vector_velocity_l,x
		stz	<vector_velocity_h,x
		stz	<acceleration_l,x
		stz	<acceleration_h,x
		stz	<steering_angle,x
		stz	<drift_index,x
		stz	<drift_angle,x
		stz	<drift_pose,x
		stz	<drift_counter,x	;=point_direction(enmey use)
		lda	#058h
		sta	<drift_level,x	
		lda	#040h
		sta	<steering_level,x
		lda	#140h				;miminun patern
		sta	<obj_paternA,x
		sta	<obj_paternB,x
		sta	<obj_old_paternA,x
		sta	<obj_old_paternB,x
		stz	<tire_timer,x
		stz	<official_control,x
;							;each driver's init
		lda	#0ffffh
		sta	<driver_time+00h,x
		sta	<driver_time+02h,x
		sta	<driver_time+04h,x
		rts
;----------------------------------------------------------------------------
Initial_camera_buffer
		ldx	<game_mode
		jmp	(!Set_camera_address,x)
Set_camera_address
		word	Game_mode00,Game_mode02,Game_mode04
Game_mode00
		lda	#1000h
		ldx	#00h
		jsr	!Nomal_camera
		lda	#1100h
		ldx	#02h
		jsr	!Nomal_camera
		rts
Game_mode02
		lda	#1000h
		ldx	#00h
		jsr	!Nomal_camera
		lda	#1000h
		ldy	#1100h
		ldx	#02h
		jsr	!Display_camera
		rts
Game_mode04
		lda	#1100h
		ldy	#1000h
		ldx	#00h
		jsr	!Display_camera
		lda	#1100h
		ldx	#02h
		jsr	!Nomal_camera
		rts
Nomal_camera
		sta	<camera_index,x
		tay
		lda	#1000000001000000b
		sta	!kart_flag,y
		txa
		sta	!control_index,y
		stz	<camera_mode,x
		lda	#1100000011000000b	;b15=1 scrool enable
						;b14=1 rotate enable
						;b13=0 not spin status
						;b07=1 pose disable
						;b06=1 monita change disable
						;b05=0 not back milar mode
		bra	Commom_camera
Display_camera
		sta	<camera_index,x
		lda	#0010000000000000b
		sta	!kart_flag,y
		lda	#0ffffh
		sta	!control_index,y
		lda	#06h
		sta	<camera_mode,x
		lda	#0000000011000000b	;b15=0 scrool disable
						;b14=0 rotate disable
						;b13=0 not spin status
						;b07=1 pose disable
						;b06=1 monita change disable
						;b05=0 not back milar mode
		
Commom_camera
		sta	<camera_control,x
		lda	#00c0h
		sta	<camera_flip,x
		stz	<slot_sound_counter,x
		rts
;----------------------------------------------------------------------------
Initial_rank_index
		lda	!map_pointer
		beq	First_race
		jsr	!Set_next_rank
First_race
		ldx	#1700h
Set_rank_loop
		lda	<rank_number,x
		tay
		txa
		sta	!rank_index,y
		sec
		sbc	#0100h
		cmp	#1000h
		bcc	End_rank_init
		tax
		bra	Set_rank_loop
End_rank_init
		stz	!rank_index+010h
		rts
;----------------------------------------------------------------------------
Clear_point_index
		ldx	#000eh
		lda	#1000h
Clear_point_loop
		sta	!point_rank,x
		clc
		adc	#0100h
		dex
		dex
		bpl	Clear_point_loop
		rts
;----------------------------------------------------------------------------
Set_rank_address
		word	Rank_set_00,Rank_set_02,Rank_set_04
;----------------------------------------------------------------------------
		mem16
		idx16
Set_next_rank
		ldx	<game_mode
		jmp	(!Set_rank_address,x)
Rank_set_00
		ldx	#1000h
		jsr	!Gyaku_gurid
		sta	<disable_rank+00h
		ldx	#1100h
		jsr	!Gyaku_gurid
		sta     <disable_rank+02h
		bra	Set_next_enemy
Rank_set_02
		ldx	#1000h
		jsr	!Gyaku_gurid
		sta     <disable_rank+00h
		ldx	#1100h
		jsr	!Rival_rank
		bra	Set_next_enemy		
Rank_set_04
		ldx	#1100h
		jsr	!Gyaku_gurid
		sta     <disable_rank+00h
		ldx	#1000h
		jsr     !Rival_rank
Set_next_enemy
		ldx	#000h
		ldy	#000h
Set_rank_enemy_loop
		lda	!point_rank,x
		cmp	#1200h
		bcc	Next_rank_enemy
Check_rank_loop
		cpy	<disable_rank+00h
		bne	OK_00
		iny
		iny
		bra	Check_rank_loop
OK_00
		cpy     <disable_rank+02h
		bne	OK_02
		iny
		iny	
		bra	Check_rank_loop
OK_02
		phx
		tax
		sty	<rank_number,x
		iny
		iny
		plx
Next_rank_enemy
		inx
		inx
		cpx	#010h
		bne	Set_rank_enemy_loop
		rts
;----------------------------------------------------------------------------
Rival_rank
		lda	#0000h
		cmp	<disable_rank+00h
		bne	Top_rank
		lda	#0002h
Top_rank
		sta	<rank_number,x
		sta	<disable_rank+02h	
		rts
;----------------------------------------------------------------------------
Gyaku_gurid
		lda	<rank_number,x
		sec
		sbc	#0eh
		eor	#0ffffh
		inc	a
		sta	<rank_number,x
		rts
;----------------------------------------------------------------------------
;Initial_rank_index				;initial for each caps
;		ldy	#0000h
;		ldx	#0000h
;Set_rank_loop
;		lda	!Rank_data,y
;		sta	!rank_index,x
;		beq	End_rank_init
;		phx
;		ldx	!Set_index,y
;		lda	!Rank_number_data,y
;		sta	<rank_number,x
;		plx
;		inx
;		inx
;		iny
;		iny
;		bpl	Set_rank_loop
;End_rank_init
;		rts
;----------------------------------------------------------------------------
;Initial_rank_number				;initial for evry races
;		ldy	#0000h
;Set_rank_num_loop
;		ldx	!rank_index,y
;		beq	End_rank_number
;		tya
;		sta	<rank_number,x
;		iny
;		iny
;		bra	Set_rank_num_loop
;End_rank_number
;		rts
;----------------------------------------------------------------------------
Initial_opening_demo
		lda	!1f05h			;check_dedug_flag
		bit	#0100000000000000b
		bne	Now_debug_mode
		lda	<race_status
		beq	Init_demo_data
		rts
Now_debug_mode
		lda	#08h
		sta	<race_status
		rts
Init_demo_data
		ldx	<game_mode
		jmp	(!Set_demo_data,x)
Set_demo_data
		word	Demo_00,Demo_02,Demo_04
Demo_00
		ldx	#1000h
		ldy	#0000h
		jsr	!Set_demo_sub
Demo_04
		ldx	#1100h
		ldy	#0002h
		bra	Set_demo_sub
Demo_02
		ldx	#1000h
		ldy	#0000h
Set_demo_sub
		lda	<obj_pos_xh,x
		asl	a
		asl	a
		sta	!camera_x,y
		lda	<obj_pos_yh,x
		sec
		sbc	#0300h
		asl	a
		asl	a
		sta	!camera_y,y
		lda	#8000h
		sta	!camera_direction,y
		lda	!camera_control,y
		and	#0011111111111111b
		sta	!camera_control,y
		lda	#020h
		sta	!fade_speed
		rts
;----------------------------------------------------------------------------
Window_color_init
		lda	#03737h
		sta	!window_color
		lda	#02727h
		sta	!red_color
		lda	#04747h
		sta	!green_color
		lda	#08787h
		sta	!blue_color
		rts
;----------------------------------------------------------------------------
Driver_number;		mario luigi koopa peach  cong  kame kiopi yosshy
		word	0000h,0002h,0004h,0006h,0008h,000ah,000ch,000eh
;----------------------------------------------------------------------------
Set_index
		word	1700h,1600h,1500h,1400h,1300h,1200h,1100h,1000h
		word	1000h;(dummy)
;----------------------------------------------------------------------------
;;Rank_data
;;		word	1700h,1600h,1500h,1400h,1300h,1200h,1100h,1000h,000h
;;Set_rank_pointer
;	game index=	race ,battle
;;		word	0000h,000ch
;----------------------------------------------------------------------------
Check_reset_data
		word	02f4h,8a36h,45e1h,9bc0h,52d7h,0fff0h,0c2b1h,0002h
;-----------------------------------------------------------------------------
		prog
;-----------------------------------------------------------------------------
VRAM_address
		word	5800h,5840h,5880h,58c0h,5c00h,5c40h,5c80h,5cc0h
;-------------(low) vram address & (high) b0=use obj higher bank-------------
Obj_num_data
		word	0180h,0184h,0188h,018ch,01c0h,01c4h,01c8h,01cch
;----------------------------------------------------------------------------
Character_palet
;                       mario,luigi,koopa,peach, cong, kame,kinop,yosshy
                word    0200h,0400h,0000h,0600h,0600h,0400h,0200h,0000h
;----------------------------------------------------------------------------
Title_sub
		lda	<game_selecta
		bne	Skip_title
		ldx	#002h
Select_loop
		lda	<button_status+00h,x
		bit	#0010000000000000b	;select button on!!!	
		beq	Continue_selection
		bmi	Start_race		;select&B
		bit	#0100000000000000b
		bne	Start_battle		;select&Y
		bit	#0001000000000000b
		bne	Start_edit3		;select&start
		bit	#0000000010000000b
		bne	Start_edit1		;select&A
		bit	#0000000001000000b
		bne	Start_edit2
		bit	#0000000000010000b
		bne	Start_C_select		;select&R
Continue_selection
		dex
		dex
		bpl	Select_loop
Skip_title
		rts
;----------------------------------------------------------------------------
Start_title
		lda	#04h
		bra     Goto_selecta
Start_battle
		lda	#0eh
		bra	Goto_selecta
Start_edit1
		lda	#10h
		bra	Goto_selecta
Start_edit2
		lda	#12h
		bra	Goto_selecta
Start_edit3
		lda	#14h
		bra	Goto_selecta
Start_K_select
		lda	#06h
		bra     Goto_selecta
Start_C_select
		lda	#16h
		bra     Goto_selecta
Next_race
		inc	!map_pointer		;clear & next race
		jsr	!All_check_rank
		jsl	>Set_driver_point
;;;;		jsr	!Set_next_rank
		lda	#0002h		  	;goto DP display
		sta     !race_init
		lda	#000ah
		bra	Goto_selecta
Result_race
		jsr	!All_check_rank
		lda     #0006h			;result>>>>retry
		sta     !race_init
		lda     #000ah
		bra     Goto_selecta
Start_race
Retry_race
		lda	#02h
Goto_selecta
		sta	<game_selecta
		lda	#08f00h
		sta	<fade_control
		lda	#0080h
		sta	!fade_speed
		rts
		end 
