;****************************************************************************
;*      Mario Kart                                                          *
;*			PPU control module				    *
;*						1992.07.13		    *
;****************************************************************************
		glb	Set_OAM_screen1,Set_OAM_screen2
		glb 	OBJ_transport,Initial_OBJ_trans
		glb	Set_trans_bufferA,Set_trans_bufferB
		glb	Check_trans_A,Check_trans_B,Set_trans_data
		glb	Init_ranker
		glb	Set_rank_mark,Mark_animation 
		glb	Set_nintendo
;
		ext	Position_calc1,Position_calc2		
		ext	Obj_priority_screen1,Obj_priority_screen2
		ext	Character_palet
		ext	VRAM_address,Character_palet,Obj_num_data
		ext	Clear_sprite,Decode_7F_X
		ext	Decode_7E_X,Color_transport
;
		include	work.def
		include buffer.def
		include label.def
		include rp5a22
		include rp5c77
;****************************************************************************
byte_data		equ	00h
line_data		equ	02h
low_address		equ	04h
bank_data		equ	06h
tempolary		equ	08h
;
pos_data		equ	00h
counter			equ	02h
attribute_data		equ	04h
;
vram_address_data	equ	10h
trans_address		equ	12h	;4byte
trans_temp		equ	16h	;(3byte)
;
trans_num_counter	equ	1eh
;****************************************************************************
bank80		sect	rel
;----------------------------------------------------------------------------
		mem16
		idx16				;input mem16 idx16
Set_nintendo
		phb
		phk
		plb
		mem8
		idx8				;mem8 idx8

		sep	#00110000b
		lda	#00000010b
		sta	!Sprite_size
						;sprite size=8or16 b567=00
						;OBJ bank use 0&1  b34=00
						;OBJ base addr=4000h b012=04
		stz	!Screen_mosaic		;not use mosaic
		stz	!Window_control+00h
		stz	!Window_control+01h
		stz	!Window_control+02h
		lda     #00010000b
		sta     !Through_screen+00h	;only objct
		sta     !Through_screen+01h
		stz     !Through_window+00h
		stz     !Through_window+01h
                stz     !PPU_option
		stz	!Color_control
		stz	!Color_brend
		stz	!Color_bias
		mem16
		idx16
		rep	#00110000b
		lda	#0080h
		sta	!Screen_step
		lda	#04000h
		sta	!Screen_address
		ldx	#0001h
		lda	#1801h
		sta	!DMA_0+00h
		lda	#offset NINTENDO
		sta	!DMA_0+02h
		lda	#bank   NINTENDO
		sta	!DMA_0+04h
		lda	#020h*020h		;obj 20h character
		sta	!DMA_0+05h
						;;001=2 address(L&H)
		stx	!DMA_burst
		ldy	#offset OBAKE_COL
		lda	#bank OBAKE_COL
		ldx	#offset color_buffer
		jsl	>Decode_7E_X
		jsr	!Color_transport
		jsr	!Clear_sprite
		ldx	#0000h
Set_nintendo_loop
		lda	!Nintendo_data,x
		sta	!screen1_main,x
		inx
		inx
		cpx	#010h
		bcc	Set_nintendo_loop
		lda	#0101010110101010b
		sta	!screen1_sub+00h
;
		jsr	!Set_OAM_screen1
		mem8
		sep	#00100000b		
		lda	#00fh
		sta	!PPU_control		;blanking off
		rep	#00110000b
		plb
		rtl
;---------------------------------------------------------------------------
nintendo_h	equ	080h-04h*08h	
nintendo_v	equ	070h
Nintendo_data
		byte	nintendo_h+00h,nintendo_v,000h,00110000b
		byte	nintendo_h+10h,nintendo_v,002h,00110000b
		byte	nintendo_h+20h,nintendo_v,004h,00110000b
		byte	nintendo_h+30h,nintendo_v,006h,00110000b
;---------------------------------------------------------------------------
		mem16
		idx16
Mark_animation
		ldy	!mark_index
		beq	No_animation
		lda	<frame_counter
		and	#0000000000000110b
		tax
		lda	!Attribute_secence,x
		sta	<attribute_data
Amimation_loop
		lda	<frame_counter
		and	#00fh
		asl	a
		tax
		lda	!Animation_secence-02h,y
		bit	!Comp_data,x
		bne	Nomal_mark
Another_mark
		ldx	!rank_index-02h,y
		lda	<driver_number,x
		tax
		lda	!Character_name-02h,y
		ora	!Character_palet,x
		ldx	!Set_rank_address-02h,y
		sta	<00h,x
Palet_change
		cpy	#0ah
		bcs	Not_change_palet
		lda	<04h,x
		and	#1111000111111111b
		ora	<attribute_data
		sta	<04h,x
Not_change_palet
		dey
		dey
		bne	Amimation_loop
No_animation
		rts		
Nomal_mark
		ldx	!rank_index-02h,y
		lda	<driver_number,x
		tax
		ora	!Character_palet,x
		ora	#0011000100100000b
		ldx     !Set_rank_address-02h,y
		sta	<00h,x
		bra	Palet_change
;---------------------------------------------------------------------------
Attribute_secence
		word	0200h,0200h,0a00h,0c00h
Animation_secence
;No.1 car
		word	1111111100000000b
;No.2 car
		word	0011111111000000b
;No.3 car
		word	0000111111110000b
;No.4 car
		word	0000001111111100b
;No.5 car
		word	00h
;No.6 car
		word	00h
;No.7 car
		word	00h
;No.8 car
		word	00h
Comp_data
		word	0001h,0002h,0004h,0008h,0010h,0020h,0040h,0080h
		word	0100h,0200h,0400h,0800h,1000h,2000h,4000h,8000h
Character_name
		word	03144h,03146h,03148h,0314ah
		word	03144h,03146h,03148h,0314ah
;---------------------------------------------------------------------------
		
		mem16
		idx16
						;dont break x resister
						;y=OK!
						;faster than kart trans
Set_rank_mark
		ldy	!goalin_number
		inc	!goalin_number
		inc	!goalin_number
		lda	<game_status
		bne	Skip_set_mark
		phx
		lda	!rank_index+00h,y
		tax
		lda	<driver_number,x
		sta	!mark_buffer,y
		tax
		ora	!Character_palet,x
		ora	#0011000100100000b
		ldx     !Set_rank_address+00h,y
		sta     <00h,x
		cpy	#008h
		bcs	Lost_driver
Win_driver
		lda	!Set_sub_data,y	
		trb	!screen1_sub+00h
		plx
		rts				
Lost_driver
		lda     !Set_sub_data,y
		trb	!screen2_sub+00h
		plx
Skip_set_mark
		rts
Set_sub_data
		word	0000000000000101b
		word	0000000001010000b
		word	0000010100000000b
		word	0101000000000000b
		word	0000000000000101b
		word	0000000001010000b
		word	0000010100000000b
		word	0101000000000000b
Set_rank_address
		word    202h+00h*04h,202h+02h*04h,202h+04h*04h,202h+06h*04h
		word    422h+00h*04h,422h+02h*04h,422h+04h*04h,422h+06h*04h
Trans_mark;-----------------------------------------------------------------
						;y=trans counter
		mem16
		idx16
		lda	<game_status
		bne	Not_trans_mark
		ldx	!mark_index
		cpx	!goalin_number
		bcs	Not_trans_mark
		ldy	<trans_counter
		lda	!Mark_VRAM,x
		sta	!obj_trans_buffer+00h,y
		clc
		adc	#0100h
		sta	!obj_trans_buffer+06h,y
		lda	#0407fh			;40h=trans value
						;7fh=data bank
		sta	!obj_trans_buffer+04h,y
		sta	!obj_trans_buffer+0ah,y
		lda     !mark_buffer,x		;00hXXX 01h=OK
		cpx	#08h
		bcs	Lose_character
;Win_character
		tax
		lda	!Mark_win,x
		bra	Set_data_address
Lose_character
		tax
		lda	!Mark_lose,x
Set_data_address
		sta	!obj_trans_buffer+02h,y
		clc
		adc	#0200h
		sta     !obj_trans_buffer+08h,y
		tya
		clc
		adc	#0ch
		sta	<trans_counter
		inc	!mark_index
		inc	!mark_index
Not_trans_mark
		rts	
;---------------------------------------------------------------------------
Mark_VRAM
		;rank 01,02,03,04,05,06,07,08
		word	5440h,5460h,5480h,54a0h,6440h,6460h,6480h,64a0h
Mark_win
		;character mario,luigi,koopa,peach,cong.kame,kino,yossy
	word	0c000h,0c040h,0c080h,0c0c0h,0c100h,0c140h,0c180h,0c1c0h
Mark_lose
		;cha racter mario,luigi,koopa,peach,cong.kame,kino,yossy
	word	0c400h,0c440h,0c480h,0c4c0h,0c500h,0c540h,0c580h,0c5c0h
;---------------------------------------------------------------------------
		mem8
		idx8
OBJ_transport;-------------------------------------------V-blank operation
		php
		sep	#00110000b
;
		lda     #00000001b		;set VRAM
		sta     !DMA_0+00h		;001=2 address(L&H)
		lda	#18h
		sta	!DMA_0+01h		;set 2118h(VRAM write)
		lda	#10000000b
		sta	!2115h			;set H resister=addr inc
		ldy	#01h
		ldx	<trans_counter
		beq	End_trans_loop	
OBJ_trans_loop		
		lda	!obj_trans_buffer-06h,x
		sta	!Screen_address+00h		;VRAM address low
		lda	!obj_trans_buffer-05h,x
		sta	!Screen_address+01h		;VRAM address high
		lda	!obj_trans_buffer-04h,x
		sta	!DMA_0+02h			;ROM address low
		lda	!obj_trans_buffer-03h,x		
		sta	!DMA_0+03h			;ROM address high
		lda     !obj_trans_buffer-02h,x
		sta	!DMA_0+04h			;ROM address bank
		lda     !obj_trans_buffer-01h,x
		sta	!DMA_0+05h			;trans value
		stz	!DMA_0+06h
		sty     !DMA_burst
		dex
		dex
		dex
		dex	
		dex
		dex
		bne	OBJ_trans_loop
End_trans_loop
		stz	<trans_counter
		plp
		rts
;****************************************************************************
OBJ_character_bank
		byte	018h,018h,019h
;****************************************************************************
		mem16
		idx16
Initial_OBJ_trans
		phb
		phk
		plb
		jsr	!Set_trans_bufferA
		jsr	!Set_trans_bufferB
		jsr	!OBJ_transport
		plb
		rtl
;----------------------------------------------------------------------------
		mem16
		idx16
Set_trans_bufferA
		stz	<trans_num_counter
		lda	<frame_counter
		ror	a
		bcs	Odd_farme
		lda	#0000h
		jsr	!Check_trans_A
Odd_farme
		lda	!trans_A_counter
		inc	a
		and	#0111b
		sta	!trans_A_counter
		beq	Odd_farme
		jsr	!Check_trans_A
		cpx	#18h+01h		;x=trans counter
		bcs	Full_trans_A
		lda	<trans_num_counter
		cmp	#07h
		bcc	Odd_farme
Full_trans_A
		cpx	#24h+01h
		bcs	Not_set_trans
		jsr	!Trans_mark
		rts
;----------------------------------------------------------------------------
Set_trans_bufferB
		stz	<trans_num_counter
		lda	<frame_counter
		ror	a
		beq	Even_frame
		lda	#0001h
		jsr	!Check_trans_B
Even_frame
		lda	!trans_B_counter
		inc	a
		and	#0111b
		sta	!trans_B_counter
		cmp	#01h
		beq	Even_frame
		jsr	!Check_trans_B
		cpx	#48h+01h			;x=trans counter
		bcs	Full_trans_B
		lda	<trans_num_counter
		cmp	#07h
		bcc	Even_frame
Full_trans_B
		cpx	#54h+01h			;x=trans counter
		bcs	Not_set_trans
		jsr	!Trans_mark
Not_set_trans
		rts
;----------------------------------------------------------------------------
;						Y=trans kart's index
Set_trans_data
		ldx     !Kart_address,y
		lda	!Character_palet,y
		ora	!Obj_num_data,y
		sta	<obj_attribute,x
		lda     !VRAM_address,y	
		sta     <vram_address_data
		lda	!Drivers_bank,y
		sta	<trans_temp+00h
		lda	<obj_paternA,x
		cmp	<obj_old_paternA,x
		beq	Not_set_trans
		sta	<obj_old_paternA,x
		and	#0111111111111111b
		phy
		tay
		pla
		bra	Look_trans_data
;----------------------------------------------------------------------------
Not_trans_A
		ldx	<trans_counter
		rts
;----------------------------------------------------------------------------
Check_trans_A
		inc	<trans_num_counter
		xba
		ora	#01000h
		tax
Calc_trans_A
		lda	<kart_flag,x
		beq	Not_trans_A
		lda	<obj_paternA,x
		cmp	<obj_old_paternA,x
		beq	Not_trans_A
		sta	<obj_old_paternA,x
		and	#0111111111111111b
						;MSB=pose sign
		tay
		cmp	#16eh
		bcs	Not_trans_A
		cmp	#16ah
		bcc	Nomal_kart_A
							;16ah=perapera
							;16ch=no trans
		stz	<tempolary
		beq	Big_perapera
		lda	#0400h
		sta	<tempolary
Big_perapera
		lda	<vram_addressA,x		;compress A
		jmp	!Compress_kart
Nomal_kart_A
		lda	<vram_addressA,x
;----------------------------------------------------------------------------
Nomal_kart
		sta	<vram_address_data
;
		lda	<driver_number,x
Look_trans_data
		cmp	#luigi
		bne	Not_Luigi_kart
		lda	!Luigi_data,y
		bmi	Luigi_equ_mario
		jmp	!Luigi_kart
Luigi_equ_mario	
		lda	#mario
Not_Luigi_kart
		tax
		lda	!Drivers_bank,x
		sta	<trans_temp+00h
;Look_trans_data
		lda	!Trans_data,y
		pha
		and	#0ffh
		tax
		lda	!Address_data,x
		sta     <trans_address
		pla
		xba
		pha
		and	#0000000011110000b
		sta	<trans_temp+01h
		pla
		and	#0fh
		tay
;
;					trans_data	00=rom bank
;							01=trans value
;					y=trans line=counter
;
		ldx	<trans_counter
Set_trans_buffer_loop
		lda	<vram_address_data
		sta	!obj_trans_buffer,x	;VRAM address
		inx
		inx
		clc
		adc	#0100h
		sta	<vram_address_data
		lda	<trans_address
		sta	!obj_trans_buffer,x	;ROM address
		inx
		inx
		clc
		adc	#0200h
		sta	<trans_address
		lda	<trans_temp+00h		;ROM bank & trans value 
		sta	!obj_trans_buffer,x
		inx
		inx
;		
		dey
		bne	Set_trans_buffer_loop
		stx	<trans_counter
		rts
;----------------------------------------------------------------------------
Nomal_kart_B						;nomalB
		lda	<vram_addressB,x
		bra	Nomal_kart
;----------------------------------------------------------------------------
Not_trans_B
		ldx	<trans_counter
		rts
;----------------------------------------------------------------------------
Check_trans_B
		inc     <trans_num_counter
		xba
		ora	#01000h
		tax
		lda	<kart_flag,x
		beq	Not_trans_B
		lda	<obj_paternB,x
		cmp	<obj_old_paternB,x
		beq	Not_trans_B
		sta	<obj_old_paternB,x
		and	#0111111111111111b
		tay
		cmp	#16eh
		bcs	Not_trans_B
		cmp	#16ah				;16ah=perapera
							;16ch=no trans
		bcc	Nomal_kart_B
		stz	<tempolary
		beq	Not_nomal_kart_B
		lda	#400h
		sta	<tempolary
;----------------------------------------------------------------------------
Not_nomal_kart_B
		lda	<vram_addressB,x		;compress B
Compress_kart
		
		ldy	<trans_counter
		sta	!obj_trans_buffer+00h,y
		clc
		adc	#0100h
		sta	!obj_trans_buffer+06h,y		;VRAM address
		lda	<driver_number,x
		xba
		lsr	a
		lsr	a
		lsr	a
		clc
		adc	#offset perapera_obj
		adc	<tempolary
		sta	!obj_trans_buffer+02h,y
		clc
		adc	#0200h
		sta	!obj_trans_buffer+08h,y		;ROM address
		lda     #bank perapera_obj
		ora	#04000h
		sta	!obj_trans_buffer+04h,y
		sta	!obj_trans_buffer+0ah,y
		tya
		clc
		adc	#0ch
		sta	<trans_counter
		tax					;x=trans counter
		rts
;----------------------------------------------------------------------------
Luigi_kart
							;A=luigi data
		
		pha
		and	#0ffh
		tax
		lda	!Luigi_address,x
		sta	<trans_address+00h
		lda	!Trans_data,y
		and	#00ffh
		tay
		lda	!Address_data,y
		sta	<trans_address+02h
		ldx	<trans_counter
Set_vram_address
		lda	<vram_address_data
		sta     !obj_trans_buffer+00h,x
		clc
		adc	#100h
		sta     !obj_trans_buffer+06h,x
		adc	#100h
		sta     !obj_trans_buffer+0ch,x
		adc	#100h
		sta     !obj_trans_buffer+012h,x
Set_rom_address
		lda	<trans_address+00h		;LUIGI address
		sta	!obj_trans_buffer+02h,x
		adc	#0200h
		sta	!obj_trans_buffer+08h,x
		lda	<trans_address+02h		;MARIO address
		adc	#0400h
		sta	!obj_trans_buffer+0eh,x
		adc	#0200h
		sta	!obj_trans_buffer+014h,x
;
		pla
		bit	#0200h
		bne	YAKO_half
		bit	#0400h
		bne	TATE_half
NOMAL
		lda	#8084h			;trans 80h bank 88h(luigi)
		sta	!obj_trans_buffer+04h,x
		sta	!obj_trans_buffer+0ah,x
		lda	#80c0h			;trans 80h bank 84h(mario)
Set_luigi_buffer
		sta     !obj_trans_buffer+10h,x
		sta	!obj_trans_buffer+16h,x
		txa
		adc	#18h
		sta	<trans_counter
		rts
YAKO_half
		lda	#4084h			;trans 40h bank 88h(luigi)
		sta     !obj_trans_buffer+04h,x
		sta     !obj_trans_buffer+0ah,x
		lda     #40c0h
		bra	Set_luigi_buffer
TATE_half
		lda	#8084h
		sta     !obj_trans_buffer+04h,x
		sta     !obj_trans_buffer+0ah,x
		txa
		adc	#0ch
		sta	<trans_counter
		rts
;----------------------------------------------------------------------------
Kart_address
		word    1000h,1100h,1200h,1300h,1400h,1500h,1600h,1700h
;---------------------------------------------------------------------------
Drivers_bank
;			mario,luigi,koopa,peach, cong, kame,kinop yosshy
		word	00c0h,0084h,00c1h,00c2h,00c3h,00c5h,00c6h,00c4h
;----------------------------------------------------------------------------
Trans_data
;				low=trans byte & high=trans line
;4*4
	word	4400h,8402h,8404h,8406h,8408h,840ah,840ch,840eh
	word	840eh,8410h,8410h,8412h,8412h,8414h,8414h,4416h
;	
	word	4418h,841ah,841ch,841eh,8420h,8422h,8424h,8426h
	word	8426h,8428h,8428h,842ah,842ah,842ch,842ch,442eh
;	
	word	4430h,8432h,8434h,8436h,8438h,843ah,843ch,843eh
	word	843eh,8440h,8440h,8442h,8442h,8444h,8444h,4446h
;3*3	
	word	4348h,4348h,634ah,634ah,634ch,634ch,634eh,634eh
	word	6350h,6350h,6352h,6352h,6354h,6354h,4356h,4356h
;	
	word	4358h,4358h,635ah,635ah,635ch,635ch,635eh,635eh
	word	6360h,6360h,6362h,6362h,6364h,6364h,4366h,4366h
;2*2	
	word	4268h,4268h,4268h,4268h,426ah,426ah,426ah,426ah
	word	426ch,426ch,426ch,426ch,426eh,426eh,426eh,426eh
;	
	word	4270h,4270h,4270h,4270h,4272h,4272h,4272h,4272h
	word	4274h,4274h,4274h,4274h,4276h,4276h,4276h,4276h
;	
	word	4278h,4278h,4278h,4278h,427ah,427ah,427ah,427ah
	word	427ch,427ch,427ch,427ch,427eh,427eh,427eh,427eh
;2*1	
	word	4180h,4180h,4180h,4180h,4182h,4182h,4182h,4182h
	word	4182h,4182h,4182h,4182h,4184h,4184h,4184h,4184h
;1*1	
	word	2186h,2186h,2186h,2186h,2188h,2188h,2188h,2188h
	word	2188h,2188h,2188h,2188h,2186h,2186h,2186h,2186h
;	
	word	218ah,218ah,218ah,218ah,218ch,218ch,218ch,218ch
	word	218ch,218ch,218ch,218ch,218ah,218ah,218ah,218ah
;
	word	848eh			;naname
	word	8290h			;furimuki 1
	word	8292h			;furimuki 2
	word	8494h			;win pose
	word	8496h			;lost pose
;----------------------------------------------------------------------------
Address_data
	word	02000h,02080h,02100h,02180h,02800h,02880h,02900h,02980h
	word	03000h,03080h,03100h,02040h
;2
	word	03180h,03800h,03880h,03900h,03980h,04000h,04080h,04100h
	word	04180h,04800h,04880h,031c0h
;3
	word	04900h,04980h,05000h,05080h,05100h,05180h,05800h,05880h
	word	05900h,05980h,06000h,04940h
;4
	word	06800h,06080h,060e0h,06140h
	word	061a0h,06680h,066e0h,06840h
;5
	word	06e00h,06740h,067a0h,06c80h
	word	06ce0h,06d40h,06da0h,06e40h
;6
	word	07280h,072c0h
	word	07300h,07340h
;7
	word	07380h,073c0h
	word	07400h,07440h
;8
	word	07800h,07840h
	word	07880h,078c0h
;9
	word	07680h,07740h
	word	076c0h
;10
	word	07700h
	word	07780h
;11
	word	07720h
	word	077a0h
;12
	word	07980h		;kataire		160
	word	07c00h		;furimuki 1		162
	word	07c80h		;furimuki 2		164
	word	07900h		;win pose		168
	word	07940h		;lost pose		16a
;----------------------------------------------------------------------------
Luigi_data
	word	0200h,0004h,0006h,0008h,000ah,000ch,000eh,0010h
	word	0010h,0012h,0012h,0014h,0014h,0016h,0016h,0202h
;
	word	0218h,001ch,001eh,0020h,0022h,0024h,0026h,0028h
	word	0028h,002ah,002ah,002ch,002ch,002eh,002eh,021ah
;
	word	0230h,0034h,0036h,0038h,003ah,003ch,003eh,0040h
	word	0040h,0042h,0042h,0044h,0044h,0046h,0046h,0232h
;
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
;
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
;
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
;
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
;
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
;
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
;
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
;
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
	word	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
;
	word	004eh			;naname
	word	0450h			;furimuki 1
	word	0448h			;furimuki 2
	word	024ah			;win pose
	word	024ch			;lost pose
;----------------------------------------------------------------------------
Luigi_address
	word	0a000h,0a040h,0a080h,0a100h,0a180h
;
	word	0a400h,0a480h,0a500h,0a580h
;
	word	0a800h,0a880h,0a900h,0a980h,0a9c0h
;
	word	0ac00h,0ac80h,0ad00h,0ad80h
;
	word	0b000h,0b080h,0b100h,0b180h
;
	word	0b400h,0b480h,0b500h,0b540h,0b580h
;
	word	0b800h,0b880h,0b900h,0b980h
;
	word	0bc00h,0bc80h,0bd00h,0bd80h
;
	word	0c000h,0c080h,0c100h,0c140h,0c180h
;
	word	0c400h
;----------------------------------------------------------------------------
VRAM_address1
		word	5000h,5040h,5080h,50c0h,5400h,5440h,5480h,54c0h	
VRAM_address2
		word	5800h,5840h,5880h,58c0h,5c00h,5c40h,5c80h,5cc0h
;----------------------------------------------------------------------------
		mem8
		idx8
Set_OAM_screen1
		sep	#00110000b
		stz	!DMA_0+02h
		lda	#02h			;screen1 OAM bufeer address
		sta	!DMA_0+03h		;	    =0bc0h
		bra	Set_OAM_DMA
Set_OAM_screen2;-------------------------------------------------------------
		sep	#00110000b
		lda	#20h
		sta     !DMA_0+02h
		lda	#04h			;screen2 OAM buffer address
		sta	!DMA_0+03h		;	    =0de0h
Set_OAM_DMA;-----------------------------------------------------------------
		stz	!DMA_0+04h		;OAM buffer's bank=000h
		stz     !Sprite_address+00h     ;2102h
		stz     !Sprite_address+01h
		stz     !DMA_0+00h              ;DMA control
		lda     #04h
		sta     !DMA_0+01h
                                                 ;set 2104h resister
		lda	#20h
		sta	!DMA_0+05h
		lda	#002h
		sta	!DMA_0+06h		;data quantity=220h
		lda	#01h
		sta	!DMA_burst		;DMA switch on
		rep	#00110000b
						;return m16x16
		rts
;---------------------------------------------------------------------------
bank81		sect	rel
;---------------------------------------------------------------------------
		mem16
		idx16
Init_ranker
		lda	<game_status
		bne	Skip_ranker
		lda	!o_demo_flag
		bne	Skip_ranker
		ldy	#0000h			;OAM address
						;OAM main index
		ldx	#00h
Init_main_loop
		lda	!Init_rank_dataA-01,x
		and	#0ff00h
		ora	#00008h
		sta	!screen1_main+04h,y		;fase position
		clc
		adc	#00008h
		sta	!screen1_main+00h,y		;number position
;
		lda	!Init_rank_dataA+01h,x		;number character
		and	#00ffh
		ora	#0011001100000000b		;palet 01 use
		sta	!screen1_main+06h,y
;
		lda	!Init_rank_dataB-01,x
		and	#0ff00h
		ora	#00008h
		sta	!screen2_main+04h,y
		clc
		adc	#00008h
		sta	!screen2_main+00h,y
;
                lda     !Init_rank_dataB+01h,x          ;number character
		and	#00ffh
		ora	#0011001100000000b		;palet 01 use
		sta	!screen2_main+06h,y
;
		txa
		clc
		adc	#04h
		tax
		tya
		adc	#08h
		tay
		cpx	#10h
		bne	Init_main_loop
		lda	#1111111111111111b
		sta	!screen1_sub+00h		;initial not disp
		sta	!screen2_sub+00h
Skip_ranker
		rts
;---------------------------------------------------------------------------
Init_rank_dataA
		byte	027h			;v position
		byte	040h			;number data
		word	10eh			;rank_index+00h
		byte	038h
		byte	041h
		word	110h
		byte	049h
		byte	042h
		word	112h
		byte	05ah
		byte	043h
		word	114h
Init_rank_dataB
		byte	074h
		byte	040h
		word	116h
		byte	085h
		byte	041h
		word	118h
		byte	096h
		byte	042h
		word	11ah
		byte	0a7h
		byte	043h
		word	11ch
;---------------------------------------------------------------------------
		end
