;************************************************************************
;*	    Super Famicom PPI ( uPD71055 ) driver   Version 1.00		*
;*		      Programmed by Y.Nishida				*
;*						[ Aug.08, 1991 ]	*
;************************************************************************

		native
		extend

		include		PPUregs.h
		include		CPUregs.h
		include		sfxdos.h

PPI_Driver	sect		rel
SFXDOS		group		PPI_Driver

		dpage		DOS_variable

;=============== Cross Definition =======================================

		global		Init_PPI_Driver		; Initial SCC(Z8530) driver
		global		Sense_Printer		; Sense printer output
		global		Output_Printer		; Output printer

;************************************************************************
;*	Initialize PPI ( uPD71055 ) Driver routine			*
;*									*
;************************************************************************

		mem8
		idx8
Init_PPI_Driver
		lda		#10000010B		; mode 0
		sta		PPI_comm_reg		; port A out  ; port B in  ; port C out
		lda		#00000001B
		sta		PPI_port_C		; Disable IRQ, STB 
		rts

;************************************************************************
;*	Sense printer output						*
;*									*
;************************************************************************

		mem8
Sense_Printer
		lda		PPI_port_B
		and		#00000100B
		beq		Exit$
		lda		#11111111B
;------------------------------------------------------------------------
Exit$		eor		#11111111B
		rts

;************************************************************************
;*	Output Printer							*
;*									*
;************************************************************************

		mem8
Output_Printer
		pha
;------------------------------------------------------------------------
Repeat$		lda		PPI_port_B
		and		#00000100B
		bne		Repeat$
;------------------------------------------------------------------------
		pla
		sta		PPI_port_A
		stz		PPI_comm_reg
		nop
		nop
		lda		#00000001B
		sta		PPI_comm_reg
		rts

		end
