eng_record	equ	0CH
;*********************************************************************
;	mario kart  backup record program
;*********************************************************************
	GLB	REC_main,REC_init,REC_nmi
;----------------------------------------------------------------------	
	glb	Save_laptime
	glb	REC_test
	glb	Check_backupRAM,Erase_timeRAM
	ext	Message_sprite
;----------------------------------------------------------------------	
;
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
;----------------------------------------------------------------------	
Backup_time	equ	Backup_RAM+660H
;----------------------------------------------------------------------	
rec_buffer	equ	1b00h
backup_pointer	equ	1bc0h
;----------------------------------------------------------------------	
;
;	best_flag	A*** **** **** *BBB
;			A ... xXgR[hoƂ		
;			B ... xXgbv@ //
;			    	( l̓bv 1,2,3,4,5 )
;
;
;----------------------------------------------------------------------	
		comn
addr		ds	2
work		ds	2


		EXTEND
objdata	SECT	REL
		mem16
		idx16
;*********************************************************************
;	obNAbvq`lRg[
;*********************************************************************
REC_main
REC_init
REC_nmi		RTL




;#####################################################################
;
;	^CA^bN	
;	
;#####################################################################


;= INITIAL = = = =
;*********************************************************************
;	T`FbN[`
;*********************************************************************
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

Erase_timeRAM
		jsr	calc_mapaddr
		lda	>Backup_time+7,x
		and	#0fh  
		cmp	#0ah
		bne	skip$
;- - - - - - - - - - - - - - - - - - - -
		jsr	Init_backup	; ׂăCjV
		clc
		rtl
;- - - - - - - - - - - - - - - - - - - -
skip$		phx			; >>
		inx			; T`FbN
		inx
		inx			; Pʃf[^
		inx
		inx
		ldy	#4		; QʂTʂ܂ō폜
		jsr	SPinit_backup
		plx			;  <<
		jsr	Checksum_map
		sta	>Backup_time,x	; `FbNTZbg
		sec
		rtl
;- - - - - - - - - - - - - - - - - - - -

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;^CA^bÑf[^Lǂ`FbN
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Check_backupRAM	PHB
		PHK
		PLB
		lda	#0
loop$		pha			; >>
		jsr	check_timedata
		pla			; <<
		inc	a
		cmp	#20		; }bv  !
		bne	loop$
		plb
		rtl
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
check_timedata	
		ora	#1400h		;}bvɂobt@AhXZo
		jsr	ML_u8u8
		tax
		jsr	Checksum_map	;`FbNTnjH
		beq	Init_backup
		cmp	>Backup_time+0,x
		bne	Init_backup
		rts
;--------------------------------------------------------------------
;	R[X^C̃CjV
;--------------------------------------------------------------------
Init_backup	phx			; >>
		inx
		inx
		ldy	#6
		jsr	SPinit_backup
		plx			; <<
		jsr	Checksum_map
		sta	>Backup_time+0,x ;bv^Cg[^T!
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;bv^Cf[^Zbg!
;- - - - - - - - - - - - - - - - - - - - - - - - - -
SPinit_backup	SEP	#00100000B
		MEM8
loop$		lda	#099h
		sta	>Backup_time+0,x
		lda	#059h
		sta	>Backup_time+1,x
		lda	#00ah
		sta	>Backup_time+2,x
		inx
		inx
		inx
		dey
		bne	loop$
		REP	#00100000B
		MEM16
		rts
;--------------------------------------------------------------------
;	}bvɂobt@AhXZo
;--------------------------------------------------------------------
calc_mapaddr	lda	!map_number
		ora	#1400h
		jsr	ML_u8u8
		tax
		rts




;= = Display = = = = = = = =
;*********************************************************************
;	R[h^C\[`
;*********************************************************************
;R[h\
pos_record	equ	2020h-eng_record
record_1	equ	2068h-eng_record
record_2	equ	2068h+256*(0ch*1)-eng_record
record_3	equ	2068h+256*(0ch*2)-eng_record
record_4	equ	2068h+256*(0ch*3)-eng_record
record_5	equ	2068h+256*(0ch*4)-eng_record
pos_lap		equ	2020h+256*(0ch*5+03h)-eng_record
lap_1		equ	2068h+256*(0ch*5+03h)-eng_record
;--------------------------------------------------------------------
REC_test


;- - - obNAbṽAhX - - - - -
		lda	!map_number
		ora	#1400h
		jsr	ML_u8u8		
		sta	!backup_pointer

;- - - ʓ`FbN - - - - -

		jsr	Check_bestrank

;- - - ^Cg\ - - - - - - 
		lda	#pos_record
		ldy	#best_record
		ldx	#04h
		jsr	Message_sprite2
;- - - xXgR[h - - - -

		ldy	#rec_buffer+00h		; 1st
		jsr	Disp_best		
		ldx	#04h
		lda	!best_number
		cmp	#0
		bne	s1
		ldx	#02h
s1		lda	#record_1
		jsr	Message_sprite2

		ldy	#rec_buffer+20h		; 2nd
		jsr	Disp_best		
		ldx	#04h
		lda	!best_number
		cmp	#1
		bne	s2
		ldx	#02h
s2		lda	#record_2
		jsr	Message_sprite2

		ldy	#rec_buffer+40h		; 3rd
		jsr	Disp_best		
		ldx	#04h
		lda	!best_number
		cmp	#2
		bne	s3
		ldx	#02h
s3		lda	#record_3
		jsr	Message_sprite2

		ldy	#rec_buffer+60h		; 4th
		jsr	Disp_best		
		ldx	#04h
		lda	!best_number
		cmp	#3
		bne	s4
		ldx	#02h
s4		lda	#record_4
		jsr	Message_sprite2

		ldy	#rec_buffer+80h		; 5th
		jsr	Disp_best		
		ldx	#04h
		lda	!best_number
		cmp	#4
		bne	s5
		ldx	#02h
s5		lda	#record_5
		jsr	Message_sprite2

;- - - ^Cg\ - - - - - - 
		ldy	#best_lap
		lda	#pos_lap
		ldx	#06h
		jsr	Message_sprite2

;- - - xXgbv - - - -
		ldy	#rec_buffer+0a0h	; bestlap
		jsr	Disp_best
		ldx	#06h
		lda	!best_flag
		and	#0fh
		beq	s6
		ldx	#02h		
s6		
		lda	#lap_1
		jmp	Message_sprite2
;
		include	rec-e.src
;
Message_sprite2	clc
		adc	!best_Voffset
		jmp	Message_sprite
;*********************************************************************
;	ʓ`FbN
;*********************************************************************

Check_bestrank

		lda	#winner_data
		sta	<addr
		ldy	#rec_buffer+00h
		ldx	!backup_pointer	
		inx
		inx	
		bra	entry$
;- - - - - - - - - - - - - - - - - - - - - - - -
; `FbN
loop$		lda	>Backup_time+0,x
		cmp	>Backup_time+3,x
		bne	next$
		SEP	#00100000B
		MEM8
		lda	>Backup_time+2,x
		and	#0fh
		sta	<work
		lda	>Backup_time+5,x
		and	#0fh
		cmp	<work
		REP	#00100000B
		MEM16
		beq	skip$
;- - - - - - - - - - - - - - - - - - - - - - - -
next$		inc	<addr
		inc	<addr
skip$		inx
		inx
		inx
entry$		lda	(<addr)
		sta	!1,y			; laptime
		tya
		clc
		adc	#20h
		tay
		cmp	#rec_buffer+0a0h
		bne	loop$

		lda	#2b2bh			; total
		sta	!1,y
;- - - - - - - - - - - - - - - - - - - - - - - -		
		rts


winner_data	dw	9001h,9502h,9603h,9b04h,9b05h

;*********************************************************************
;	^C\[`
;*********************************************************************
;
;	obNAbv^C̕\
;
;
;
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Disp_best
		phy		;>>
;- - - - - - - - - - - - - - - - - - - - - - - 
; index
		tya
		and	#0f0h		; 00,20,40,60,80,a0
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ora	#0300h
		jsr	ML_u8u8
		clc
		adc	!backup_pointer
		tax				; buffer index
		inx				; sum check 
		inx
;- - - - - - - - - - - - - - - - - - - - - - - 

		SEP	#00100000B
		MEM8
		lda	#29h			; Agr[g
		sta	!0,y

;;; = = = = 1,y / 2,y = = = = ;;;

		lda	#2ch			;
		sta	!3,y

		lda	>Backup_time+2,x	; 1 
		and	#0fh
		cmp	#0ah
		bcc	skip$
		jmp	over_flow	

skip$		sta	!4,y
		lda	#28h
		sta	!5,y
		lda	>Backup_time+1,x	; 10 b
		pha
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		sta	!6,y
		pla
		and	#0fh			; 1 b
		sta	!7,y
		lda	#29h
		sta	!8,y
		
		lda	>Backup_time+0,x	; 1/10 b
		pha
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		sta	!9,y
		pla
		and	#0fh	
		sta	!10,y
;- - - - - - - - - - - - - - - - - - - - - - - 

		lda	#2ch			;Xy[X
		sta	!11,y

		REP	#00100000B
		MEM16
		lda	>Backup_time+2,x
		and	#0f0h
		LSR	A
		LSR	A
		LSR	A
		tax
		lda	!time_player,x
		tax
		SEP	#00100000B
		MEM8

loop$		lda	!0,x		; LNێ name
		sta	!12,y
		cmp	#0ffh
		beq	exit$
		inx
		iny
		bra	loop$		

exit$		REP	#00100000B
		MEM16
		ply		;<<
		rts	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		mem8
over_flow	ldx	#0
loop$		lda	!over_data,x
		sta	!1,y
		cmp	#0ffh
		beq	exit$
		iny
		inx
		bra	loop$
exit$		REP	#00100000B
		MEM16
		ply
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
over_data	db	2bh,2bh,2ch
		db	9ch,28h,9ch,9ch,29h,9ch,9ch
		db	2ch,9ch,9ch,9ch,9ch,0ffh
time_player
		dw	mario,luige,kuppa,peach
		dw	cong,kame,kinopio,yossy






;= = = = CALC ( data save ) = = = = =
;*********************************************************************
;	bv^C̃Z[u`FbN
;*********************************************************************

time_min	equ	0
time_sec	equ	2
backup_index	equ	4
temp		equ	6
backup_name	equ	8
backup_escape	equ	10
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
_round		equ	20h
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
Save_laptime	lda	<game_status
		cmp	#4		; time attack
		beq	backup_entry
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
backup_entry	phy	
		phx
		phb
		PEA	BC_70_00	;
		plb			; 0 bank
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
; 	obNAbv }bv index set
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
		phx
		lda	!map_number
		ora	#1400h
		jsr	ML_u8u8
		sta	<backup_index
		ldy	<screen_register
		ldx	<player_index,y
		lda	<_status,x		; 0,2,4
		ASL	A
		ASL	A
		ASL	A
		sta	<backup_name	
		plx
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;	t@XeXgbv̌v
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		ldy	#5
		bra	entry$
;- - - - - - - - - - - - - - - - - - 
loop$		lda	<time_min
		cmp	<_round+2,x
		bcc	skip$
		bne	entry$
;- - - 
		lda	<time_sec
		cmp	<_round+0,x
		beq	skip$
		bcc	skip$
entry$	
		sty	<temp			; t@XeXg
		lda	<_round+0,x		; lap time
		sta	<time_sec
		lda	<_round+2,x
		sta	<time_min
;- - - - - - - - - - - - - - - - - - 
skip$		inx
		inx
		inx
		inx
		dey
		bne	loop$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;	xXgbv̏
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		phx				; >>
		ldx	<backup_index
		lda	>Backup_time+13h,x	; best lap
		and	#0fh
		cmp	<time_min
		bcc	exit$
		bne	ok$

		lda	>Backup_time+11h,x	; best lap
		cmp	<time_sec
		bcc	exit$
		beq	exit$

ok$		lda	<time_sec
		sta	>Backup_time+11h,x
		SEP	#00100000B
		MEM8
		lda	<temp		;B
		sta	!best_flag+0	;B
		lda	<time_min
		and	#0fh
		ora	<backup_name
		sta	>Backup_time+13h,x
		REP	#00100000B
		MEM16
exit$		plx				; <<
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	R[hbṽeXg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
lap_record
		lda	<_round+0,x		; total time
		sta	<time_sec
		lda	<_round+2,x
		sta	<time_min
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	f[^Ҕ
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		lda	<backup_index		
		clc
		adc	#Backup_time&0ffffh
		tax
		ldy	#backup_escape	
		lda	#14h-1
		mvn	#dbank_SRAM,#0
		plb				; backup bank
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	f[^XV`FbN(R[h^C)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		lda	<backup_index
		clc
		adc	#0ch
		tay
		ldx	#5
loop$		lda	!Backup_time+4,y	; c+4 = 10
		and	#0fh
		cmp	<time_min
		bcc	exit$
		bne	ok$
;
		lda	!Backup_time+2,y	; c+2 = e
		cmp	<time_sec
		beq	exit$
		bcc	exit$
;
ok$		dey
		dey
		dey
		dex
		bne	loop$
;- - - - - - - - - - - - - - - 
exit$		txa
		sta	>best_number
		cpx	#5
		beq	return$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; 	R[h^C̏
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		iny
		iny
		iny

copy$		lda	<time_sec	;Vf[^
		sta	!Backup_time+2,y
		SEP	#00100000B
		MEM8
		lda	#80h		;R[h^CłI
		sta	>best_flag+1
		lda	<time_min
		and	#0fh
		ora	<backup_name
		sta	!Backup_time+4,y
		REP	#00100000B
		MEM16
		txa			; x*3+2
		sta	<temp
		asl	a
		adc	<temp
		tax

record_loop$	cpx	#12		;f[^̈ړ
		beq	return$
		lda	<backup_escape+2,x	; top dara
		sta	!Backup_time+2+3,y	; 2nd data
		lda	<backup_escape+3,x	; top data 
		sta	!Backup_time+3+3,y	; 2nd data
		inx
		inx
		inx
		iny
		iny
		iny
		bra	record_loop$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; 	T`FbNf[^Zbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
return$		ldx	<backup_index
		jsr	Checksum_map
		sta	!Backup_time,x
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		plb
		plx
		ply
		rts





;
;= UTILITY = = = = = = = = = =
;*********************************************************************
;	R[Xf[^̃`FbNTvZ
;*********************************************************************
Checksum_map	phx				;<<
		inx
		inx
		stz	<work+0
		ldy	#18
		SEP	#00100000B
		MEM8
loop$		clc
		lda	>Backup_time+0,x
		adc	<work+0
		sta	<work+0
		lda	#0
		adc	<work+1
		sta	<work+1
		inx
		dey
		bne	loop$
		REP	#00100000B
		MEM16
		plx				;>>
		lda	<work+0
		rts
;*********************************************************************
;	8bit * 8bit ȂZ
;*********************************************************************
ML_u8u8		SEP	#00100000B
		MEM8
		sta	!4202h
		xba
		sta	!4203h
		nop
		nop
		nop
		REP	#00100000B
		MEM16
		lda	!4216h		; result
		rts
;==================================================================


		END
