;******************* name.asm *************************
;
			extend
;-----------------------------------------------------
			include		../join/rp5c77
			include		../join/buffer.def
			include		../join/rp5a22
			include     ../join/work.def
			include		../join/label.def
;-----------------------------------------------------
			glb		W_SL_init,W_SL_main,W_SL_nmi
;
			ext		Set_DMA,PPU_INT_SET
			ext		KEY_CHECK,Trigger_sound_1
			ext		BGM_fade_out,X_inx,Y_iny
			ext		Set_DMA
;---------------------------------------------------
address			equ		60h			;3byte
Color_data		equ		63h			;2byte
move_counter	equ		65h			;2byte
waku_counter	equ		67h			;2byte
button_TG       equ     6ah         ;4byte
;----------------------------------------------------
msbdat			equ		400h
oamdat			equ		200h	
;-----------------------------------------------------
bankf      		sect    rel         ;(PBR=03)
;========================================================
;********************************************************
;				INITIAL ROUTINE
;********************************************************
;========================================================
W_SL_init		equ		$
				phb
				phk
				plb
				mem8
				idx8
				sep		#00110000b
;
				JSR		PPU_INT_SET			;ppu&oam initial set.
				JSR		WORLD_PPU
				JSR		WORLD_TENSOU
;
				mem16
				idx16
				rep		#00110000b
				plb
				RTL
;========================================================
;********************************************************
;				MAINE ROUNTINE
;********************************************************
;========================================================
W_SL_main		equ		$
				phb
				phk
				plb
;
				JSR     KEY_CHECK
				JSR		WAKU_MOVE.SET
				JSR		Cup_change.set
				JSR		NEXT_SET
;
				plb
				RTL
;========================================================
;********************************************************
;				NMI wari komi.			  
;********************************************************
;========================================================
W_SL_nmi		equ		$
				phb
				phk
				plb
;
				plb
				rtl
;========================================================
;********************************************************
;				INITIAL ROUTINE
;********************************************************
;========================================================
WORLD_TENSOU   	equ		$
				mem8
				idx8
;<<<<<<<<<<<<<< 4 BIT f[^[ɕϊ >>>>>>>>>>>>>>
				lda     #00000000b				;address set.
				sta     Screen_address
				lda     #00000000b
				sta     Screen_address+1
;
				lda		#W_select_chr/65536		;hibit set.
				sta		<address+2
;
				mem16
				idx16
				rep		#00110000b
				lda		#W_select_chr&0ffffh	;lowbit set.
				sta		<address
;------------------------------------------------
				ldy		#0						;hi2bit set.
loop_4bit3		ldx		#0						;(zero set).
loop_4bt1		lda		[<address],y
				sta		Screen_write
				iny
				iny
				inx
				cpx		#08
				bne		loop_4bt1
;------------------------------------------------ 

				ldx		#0						;low2bit set.
loop_4bit2		lda		#0
				sta		Screen_write
				inx
				cpx		#08
				bne		loop_4bit2
				cpy		#0600h
				bne		loop_4bit3
				mem16
				idx16
				rep		#00110000b
;<<<<<< TO̎XyVǂ̃`FbN >>>>>
				lda		game_level
				bne		MOJI_Set				;100ccNX?;yes-->Set_msb
				lda		world_number
				cmp		#0003
				bne		MOJI_Set
				stz		world_number
;<<<<<<<<<<<<<<< f[^[Zbg >>>>>>>>>>>>>>>>>
MOJI_Set		ldy		#0
				ldx		#0
				lda		Cup_select,x
				JSR		World_moji_set
;
				ldx		#0002
				lda		Cup_select,x
				JSR		World_moji_set
;
				ldx		#0004
				lda		Cup_select,x
				JSR		World_moji_set
;
;------(XyṼ`FbNAZbg)----
				lda		game_level
				beq		WAKU_set				;TOccNX?;yes-->Set_msb
;
				ldx		#0006					;special cup(gtB[Zbg)
				lda		Cup_select,x
				JSR     World_moji_set
;---------(̒グ)-----------------
				ldx		#0
loop_moji_up	lda		oamdat+0c0h,x
				sec
				sbc		#1000h
				sta		oamdat+0c0h,x
				JSR		X_inx
				cpx		#0040h
				bne		loop_moji_up
;<<<<<<<<<<<<<<<<< Nf[^[Zbg >>>>>>>>>>>>>>>>
WAKU_set		ldy		#0000
				ldx		#0000
loop_waku_0		lda		WAKU,x
				cmp		#0ffffh
				beq		Check_waku
				sta		oamdat,y
				JSR		Y_iny
				inx
				inx
				jmp		loop_waku_0
;
Check_waku		JSR		WAKU_change_set
;<<<<<<<<<<<<< gtB[f[^[Zbg >>>>>>>>>>>>>>>>
Trophy_setdata	ldy		#0090h
				ldx		#0
				jsr		Trophy_set				;kinoko cup
;
				ldy		#0094h				
				ldx		#02
				jsr     Trophy_set				;flawer cup
;
				ldy		#0098h
				ldx		#04
				jsr     Trophy_set				;star cup
;------(XyṼ`FbNAZbg)----
Set_special		lda		game_level
				beq		color_set				;TOccNX?;yes-->Set_msb
;
				ldy		#009ch					;special cup(gtB[Zbg)
				ldx		#06
				jsr     Trophy_set
;<<<<<<<<<<<<<<<<< @J[ >>>>>>>>>>>>>>>>
color_set		lda		#0fe00h
				sta		<Color_data
				lda     world_number
				asl		a
				tax
				JSR		Color_change
;
;<<<<<<<<<<<<<<<<<<< MSB DATA SET >>>>>>>>>>>>>>>>>>>>>>
Set_msb			ldx		#0		
loop_msb		lda		#0aaaah
				sta		msbdat,x
				inx
				inx
				cpx		#0020h
				bne		loop_msb
;<<<<<<<<<<<<<<<<<<<<<< SC_1 >>>>>>>>>>>>>>>>>>>>>>>>>>>
				lda     #2400h
				sta     Screen_address
;
				ldx		#0
				lda		#0010h	
loop_16V		sta		Screen_write
				inx
				inx
				cpx		#800h
				bne		loop_16V	
;<<<<<<<<<<<<<<<<<<<<<< CG_SET >>>>>>>>>>>>>>>>>>>>>>>>>
			 	idx16		        		;8bit mode.
			 	mem8
			 	rep		#00010000b
;
			 	lda		#00000000b			
				sta		Color_address
;
      		 	ldx		#0
loop_col	 	lda		>W_select_col,x
			 	sta		Color_write
			 	inx
        	 	lda     >W_select_col,x
			 	sta     Color_write
			 	inx
			 	cpx		#200h
			 	bne		loop_col
;
			    idx8
			 	sep		#00010000b
				rts
;============================================================
;************************************************************
;					Tu[`W
;************************************************************
;============================================================
;<<<<<<<<<<<<<<<<<<<< Zbg >>>>>>>>>>>>>>>>>>>>>
World_moji_set	equ		$
				mem16
				idx16
				tax
loop_moji		lda		!0,x
				cmp		#0ffffh
				beq		owari_moji
				sta		oamdat+0c0h,y
				inx
				inx
				iny
				iny
				jmp		loop_moji
owari_moji		rts
;<<<<<<<<<<<<< gtB[Zbg̃Tu[` >>>>>>>>>>
Trophy_set		equ		$
				mem16
				idx16
;---------(XyV`FbN)--------
				lda		game_level
				beq		norm_trophy					;TOccNXH:yes-->Kids_trophy
;
				lda		trophy_place1,x				;gtB[|WVZbg.
				sta		oamdat,y
				iny
				iny
				jmp		size_check
;
norm_trophy		lda		trophy_place,x				;gtB[|WVZbg.
				sta		oamdat,y
				iny
				iny
;----(gtB[̎ރZbg)---------
size_check		lda		game_level
				beq		Kids_trophy					;TOccNXH:yes-->Kids_trophy
;		
				ldx		#04
				lda		trophy_color,x
				sta		oamdat,y				;J[ƃLN^[Zbg.
				jmp		owari_trophy
;
Kids_trophy		ldx		#04
				lda		trophy_color1,x
				sta     oamdat,y
owari_trophy	rts
;<<<<<<<<<<<<<<< N Zbg[` >>>>>>>>>>>>>>>>
WAKU_change_set	lda		world_number
				cmp		#03
				beq		special_cup					;world number 3?:yes-->special_cup
;
Set_waku_data	lda		world_number
				asl		a
				tax
				lda		WAKU_select,x
				ldx		#0000
loop_waku_1		sta		oamdat+2,x
				JSR		X_inx
				cpx		#0090h
				bne		loop_waku_1
				jmp		owari_change_set
;-------(XyVZbg)-------------
special_cup		ldy		#0000
				ldx		#04							;waku change set.
				stx		<waku_counter
;
loop_special	ldx		<waku_counter
				lda		WAKU_select,x
				sta		oamdat+2,y
				dec		<waku_counter
				dec		<waku_counter
				lda		<waku_counter
				bmi		Reset_counter
Set_next_data	JSR		Y_iny
				cpy		#0090h
				beq		owari_change_set
				jmp		loop_special
Reset_counter	lda		#0004
				sta		<waku_counter
				jmp		Set_next_data
owari_change_set	rts
;<<<<<<<<<<<<< J[Zbg[` >>>>>>>>>>>
Color_change	equ		$
				lda		Color_offset,x			;oamdat address set.
				tay
				lda		Cup_select,x			;data address set.
				tax
loop_Col		lda		!2,x
				cmp		#0ffffh
				beq		Col_owari
				clc
				adc		<Color_data
				sta		oamdat+2,y
				JSR		X_inx
				JSR		Y_iny
				jmp		loop_Col
Col_owari		rts

;==============================================================
;**************************************************************
;					f[^[
;**************************************************************
;==============================================================
WAKU_select		DW		0646h,044ah,0448h
;
trophy_place	DW		4f4fh,674fh,7f4fh
trophy_place1   DW      3f44h,5844h,6f44h,8f44h
trophy_color	DW		0a44h,0c44h,0844h
trophy_color1	DW		0a4ch,0c4ch,084ch
;
Color_offset	DW		00c0h,00d4h,00ech,0100h
;- - - - - - - - - - - - - -- - - - -- - - - -- - - -- - -
;
Cup_select		DW		KINOKO_CUP,FLAWER_CUP,STAR_CUP
				DW		SPECIAL_CUP
;
KINOKO_CUP		DW		5056h,0200h
				DW		5066h,0202h
				DW		5076h,0204h
				DW		5086h,0206h
				DW		5096h,0208h
				DW		0ffffh,0ffffh
;
FLAWER_CUP		DW		6856h,020ah
				DW		685eh,020eh
				DW		686eh,0220h
				DW		687eh,0204h
				DW		688eh,0206h
				DW		689eh,0208h
				DW		0ffffh,0ffffh
;
STAR_CUP		DW		8056h,020ah
				DW		8066h,020ch
				DW		8076h,0204h
				DW		8086h,0206h
				DW		8096h,0208h
				DW		0ffffh,0ffffh
;
SPECIAL_CUP		DW		9056h,022eh
				DW		9066h,0240h
				DW		9076h,0242h
				DW		9086h,0204h
				DW		9096h,0206h
				DW		90a6h,0208h
				DW		0ffffh,0ffffh
;- - - - - - - - - - - - - - - - - - - - - - -
WAKU			DW		2828h,2838h,2848h,2858h,2868h
				DW		2878h,2888h,2898h,28a8h,28b8h
				DW		28c8h
;
				DW		3828h,38c8h,4828h,48c8h,5828h
				DW		58c8h,6828h,68c8h,7828h,78c8h
				DW		8828h,88c8h,9828h,98c8h
;
				DW		0a828h,0a838h,0a848h,0a858h
				DW		0a868h,0a878h,0a888h,0a898h
				DW		0a8a8h,0a8b8h,0a8c8h,0ffffh
;***********************************************************
;					PPU&WORK INITIAL SET
;***********************************************************
WORLD_PPU		equ		$
;<<<<<<<<<<<<<<< [y[WNA[ >>>>>>>>>>>>>>>>>>
				mem8	
				idx8
				ldx		#0
				lda		#0
loop_YZR		sta		<address,x
				inx
				cpx		#30h
				bne		loop_YZR
;
;<<<<<<<<<<<<<<<<<< PPU SET >>>>>>>>>>>>>>>>>>>>>>>>>
				lda		#00000001b
				sta		Screen_size		;BG mode1 set.
;
				lda		#00010001b
				sta		Through_screen		;TM
;
				stz     Sprite_size
;
				lda		#00100100b
				sta		Screen_bank
;
				lda		#00000000b
				sta		Screen_segment
;
				lda     #10000000b
				sta     Screen_step
				rts
;==========================================================
;**********************************************************
;				MAIN ROURATINE
;**********************************************************
;==========================================================
;
;*******************************************************
;					N]Zbg
;*******************************************************
WAKU_MOVE.SET	equ		$
				mem16	
				idx16
				inc		<move_counter
				lda		<move_counter
				cmp		#0002
				bne		owari_waku1				;counter 2?:no-->owari_waku1
;<<<<<<<<<<<<<<<<< ]`FbN >>>>>>>>>>>>>>>>>>
				stz		<move_counter
;
				ldx		#0
loop_waku		lda		oamdat,x
				cmp		#28c8h
				beq		down_move
;
				cmp		#0a828h
				beq		up_move
;
				and		#0ff00h
				cmp		#2800h
				beq		right_move
;
				cmp		#0a800h
				beq		left_move
;
				lda		oamdat,x
				and		#00ffh
				cmp		#0028h
				beq		up_move
;
				cmp		#000c8h
				beq		down_move
				jmp		next_set
;<<<<<<<<<<<<<<<< EZbg >>>>>>>>>>>>>>>>>>>>
right_move		lda     oamdat,x
				clc
				adc		#0001
				cmp		#28c8h
				beq		set_down		
				sta		oamdat,x
				jmp		next_set
;<<<<<<<<<<<<<<<< Zbg >>>>>>>>>>>>>>>>>>>>				
down_move		lda		oamdat,x
				clc
				adc		#0100h
				cmp		#0a8c8h
				bcs		set_left		
				sta		oamdat,x
				jmp		next_set
loop_waku1		jmp		loop_waku
owari_waku1		jmp		owari_waku
;<<<<<<<<<<<<<<<<< Zbg >>>>>>>>>>>>>>>>>>>>
left_move		lda		oamdat,x
				sec
				sbc		#0001h
				cmp		#0a828h
				bcc		set_up		
				sta		oamdat,x
				jmp		next_set
;<<<<<<<<<<<<<<<<< Zbg >>>>>>>>>>>>>>>>>>>
up_move		lda		oamdat,x
				sec
				sbc		#0100h
				cmp		#02828h
				bcc		set_right		
				sta		oamdat,x
;----------------------------------------------
next_set		JSR		X_inx
				cpx		#0090h
				bne		loop_waku1
owari_waku		rts
;----------------------------------------------
				mem16 
set_down		lda		#028c8h
				sta		oamdat,x
				jmp		next_set
;
set_left		lda		#0a8c8h
				sta		oamdat,x
				jmp		next_set
;
set_up			lda		#0a828h
				sta		oamdat,x
				jmp		next_set
;
set_right		lda		#02828h
				sta		oamdat,x
				jmp		next_set
;
;*****************************************************
;					[h񂽂
;*****************************************************
Cup_change.set	equ		$
				mem16
				idx16
				lda		<button_TG
				ora		<button_TG+2
				and		#0c00h
				cmp		#0400h
				beq		cup_inc
				cmp		#0800h
				beq		cup_dec
				rts
;;<<<<<<<<<<<< [h`FW@Zbg >>>>>>>>>>>>
cup_inc			lda		game_level
				beq		Set_50cc
;
				lda     world_number
				pha
				cmp		#03
				beq		change_waku
				inc		a
				sta     world_number
				jmp		change_waku
;
Set_50cc		lda     world_number
				pha
				cmp		#02
				beq		change_waku
				inc		a
				sta     world_number
				jmp     change_waku
;
cup_dec			lda		world_number
				pha
				beq		change_waku
				dec		a
				sta		world_number
;<<<<<<<<<<<<<<< N@Zbg >>>>>>>>>>>>>>>>>>>>
change_waku		JSR		WAKU_change_set
;<<<<<<<<<<<<<<<< F@ >>>>>>>>>>>>>>>>>>>
;----------(Fɖ߂)---------
				stz		<Color_data
				pla
				asl		a
				tax
				JSR		Color_change
;---------(Fς)-------------
				lda		#0fe00h
				sta		<Color_data
				lda     world_number
				asl		a
				tax
				JSR		Color_change
;
				lda		#002ch
				JSL		>Trigger_sound_1
				rts
;*******************************************************
;					̂߂Zbg
;*******************************************************
NEXT_SET		equ		$
				mem16
				idx16
				lda		<button_TG
				ora		<button_TG+2
				and		#9000h
				beq		owari_check
;<<<<<<<<<<<<<<< @Zbg >>>>>>>>>>>>>>>>>>>>>
				stz     race_init
;
				lda		#002eh
				JSL		>Trigger_sound_1
;
				lda     #02					;race mode set.
				sta     <game_selecta
;
				JSL		>BGM_fade_out
;
				lda     #8f00h
				sta     <fade_control		;fade set.
owari_check		rts
				END
