/****************************************************************/
/**                                                            **/
/**   Direct Communication Chat and Conferencing System        **/
/**   Created May 1993 out of complete boredom.                **/
/**   (c) 1993 Takoyaki Software Ltd.                          **/
/**                                                            **/
/**   Will only run in conjunction with Desqview/X.            **/
/**                                                            **/
/**   File:    CHATSERV.C                                      **/
/**   Purpose: Controls the communication between a terminal   **/
/**            and the chat host.                              **/
/**   Usage:   Should be run once per user.                    **/
/**                                                            **/
/****************************************************************/

#include	<sys/errno.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<ctype.h>
#include	<sys/stat.h>
#include	<io.h>
#include	<pc.h>
#include	<dvapie.h>
#include	<sys/dirent.h>
#include	<sys/time.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<sys/ioctl.h>
#include	<netdb.h>
#include	<dos.h>
#include	<unistd.h>
#include	<stdarg.h>

#include	"servcmds.h"

#ifdef TELNET
#include "sckstdio.h"
#endif

#define WHITESPACE '\xff'

#define CLK_TCK CLOCKS_PER_SEC

#define nextframe() apiPause()
#define locktask() apiBeginC()
#define unlocktask() apiEndC()
#define strcmpl(s,d) strcasecmp(s,d)

#define inccursor cursorp+=(msg[cursorp] == '\\' && toupper(msg[cursorp+1]) == 'N')?2:1
#define deccursor cursorp-=(cursorp>1)?((msg[cursorp-2]=='\\' && toupper(msg[cursorp-1]) == 'N')?2:1):1;

#define F_OK	0	/* does file exist?	*/
#define X_OK	1	/* execute permission?	*/
#define W_OK	2	/* write permission?	*/
#define R_OK	4	/* read permission?	*/

#define I_TIMEOUT 5


#define WAITING_TIME 50
#define WAITING_RETRIES 500

#define HOSTNAME "--CHATHOST--"
#define dpyname ":0"

char *moreprompt = "[1;31m<More>[0m[K";
char *displaybuf = NULL;
char displaytmp[10240];
int moreactive=0;
int morelines=0;
int morelinestime=0;
int moretime=0;

#define CURSOR_LEFT 0x014b
#define CURSOR_RIGHT 0x014d
#define CURSOR_UP 0x0148
#define CURSOR_DOWN 0x0150
#define DEL 0x0153
#define CTRL_LEFT 0x0173
#define CTRL_RIGHT 0x0174
#define CTRL_UP 0x018d
#define CTRL_DOWN 0x0191
#define ALT_LEFT 0x019b
#define ALT_RIGHT 0x019d
#define ALT_UP 0x0198
#define ALT_DOWN 0x01a0
#define HOME 0x0147
#define END 0x014f
#define PAGE_UP 0x0149
#define PAGE_DOWN 0x0151
#define LINEFEED 0x0a
#define CANCELMORE 0x400
#define CONTINUEMORE 0x401

#define F1 0x13b

int display(char *buffer);
int displayprompt();
int setpos(int x,int y);
int waitforinput(char *s,int timeout);
void processwaiting();

int noecho=0;

unsigned int ack_id=0;
unsigned int recvd_ack=0;
int msglines=0;
int oldcbrk;

long on=1;

unsigned long recvmsgid=0;

int hostsocket=DEFAULTHOSTSOCKET;

int DEFAULTLINE=13;
int MESSAGELINE=13;

#define WORDWRAP 78
#define MAXHEIGHT 256
#define LONGMSGLEN 512

char word[512];

char *directhost=NULL;
struct sockaddr_in directaddr;

char prompt[] = "-> ";
char longprompt[] = " > ";
char prefix[80]="";
int indent=0,firstline=0;
char *codes=NULL;
char *newinput=NULL;

char *histories[HISTORY];
int currenthistory=HISTORY-1;

int modem=0,smtp=0;
char *waitfor=NULL;
int waitfornum;
int wakeup=0;

unsigned long msgid = 0;

char longmsg[LONGMSGLEN] = "\0";
char msg[LONGMSGLEN] = "\0";
char username[32] = "\0";
char *mailname=username;

char *lines[MAXHEIGHT];

char tempmsg[10240];
char recvmsg[10240];

int outputline=0;

int pending=0;
char *pendstr=NULL;
char *recv_str = NULL;

char *waiting_line=NULL;
int time_out = 0;
int time_retries = 0;

int exitplease=0;

int cursorx,cursory,cursorp;

#ifdef TELNET

int ds;
FILE *sin;
FILE *sout;

#define TN_IAC 255
#define TN_DO 251
#define TN_RCTE 7
#define TN_SB 250
#define TN_SE 240

#endif

int autologin=0;
char autologin_name[32];
char autologin_pass[32];

int timeoutcount = 0;

unsigned long servmail,hostmail;


char *smtpfile_in;
char *smtpfile_out;





/*---------------------------------------------------------------*/
/*---------------------------------------------------------------*/
/*---------------------------------------------------------------*/
/*---------------------------------------------------------------*/


int uniquefileid=0;


/*******************************************************************/
#define SCANWAIT 250




/*******************************************************************/
/* get the length of the queue                                     */
int getwaitinglen()
	{
	int len=0;
	char *p=waiting_line;

	while (p && *p)
		{
		len += strlen(p)+1;
		p = waiting_line+len;
		}
	return len+1;
	}

/*******************************************************************/
/* add text to the serv->host outgoing queue                       */

void addtowaiting(char *s)
	{
	int len;

	len = getwaitinglen();

	if (strlen(s) == 0) s = " ";

	waiting_line = realloc(waiting_line,len+strlen(s)+1);
	strcpy(waiting_line+len-1,s);
	waiting_line[len+strlen(s)] = '\0';
	}

/*******************************************************************/
/* remove first string from serv->host outgoing queue              */

void remfromwaiting()
	{
	int len;
	int n,l;
	char *d=waiting_line,*s;

	if ((len = getwaitinglen()) <=1 ) return;

	s = waiting_line+strlen(waiting_line)+1;
	l = strlen(waiting_line)+1;
	for (n=0;n<len-l;n++)
		*d++ = *s++;
	
	}


/*******************************************************************/

void finduniquename(char *fn)
	{
	char *e = strchr(fn,'.')+1;

	while(1)
		{
		sprintf(e,"%d",uniquefileid);
		if (uniquefileid++>999) uniquefileid = 0;
		if (access(fn,F_OK)) break;
		}

	return;
	}

/*--------------------------------*/
/* get a character from the input */

int getkeychar()
	{
#ifdef TELNET
	return SOCKgetc(sin);
#else
	return getkey();
#endif
	}


/*-----------------------*/
/* printstring           */

void printstring(char *fmt,...)
	{
	va_list ap;

	va_start(ap,fmt);

#ifdef TELNET
	SOCKvfprintf(sout,fmt,ap);
#else
	vprintf(fmt,ap);
#endif
	}

/*-------------------------------*/
/* Check for pending key presses */

int keyhit()
	{
#ifdef TELNET
	int readbit, writebit, excludebit;
	struct timeval t;

	SOCKfflush(sout);

	if (sin->_cnt==0)
		{
		memset((void *)&t,0,sizeof(t));

		readbit = 1<<sin->_file;
		writebit = 0;
		excludebit = 0;
		if (select(sin->_file+1,(struct fd_set *)&readbit,(struct fd_set *)&writebit,(struct fd_set *)&excludebit,&t)<=0)
			{
			exitplease = 1;
			return 0;
			}
		return readbit;
		}
	return 1;
#else
	return kbhit();
#endif
	}
/*-----------------------*/
/* backspace a character */

void backspace()
	{
	printstring("\b \b");
	}

/*------------------------*/
/* Send a Carriage return */

void printcr()
	{
	printf("\n");
	fflush(stdout);
	}

char *getinput(char *s,int invis)
	{
	unsigned int c;
	char *p=s;

	*p = '\0';

	while (1)
		{
		fflush(stdout);
		while (!keyhit())
			nextframe();
		c = getkeychar();

		switch(c)
			{
			case '':
				if (*s != '\0')
					{
					p--;
					*p = '\0';
					backspace();
					}
				break;
			case 13:
				printcr();
				return s;
				break;
			default:
				if ((c>32) && (c<0x80) && (strlen(s)<31))
					{
					*p++ = c;
					*p = '\0';
					printstring("%c",(invis)?'*':c);
					}
				break;
			}

		}
	}

setup_autologin()
	{
	printstring("Auto-login initialisation procedure: \n\n");
	printstring("Please enter your login name: ");
	getinput(autologin_name,0);
	printstring("Please enter your login password: ");
	getinput(autologin_pass,1);

	autologin = 1;
	}



static int mysock;

closesocket()
	{
#ifdef BSD_43
	so_close(mysock);
	so_exit();
#else
	malFree(servmail);
#endif
	}

int mysockaddr;
struct sockaddr_in mysocket;


void SetupDirectHost()
	{
	struct hostent *he;

	if ((he = gethostbyname(directhost)))
		{
		directaddr.sin_family=he->h_addrtype;
		directaddr.sin_port = htons(HOSTSOCKET);
		memcpy(&directaddr.sin_addr,he->h_addr_list[0],he->h_length);
		}
	else
		{
		printf("Unable to find direct host %s.\n",directhost);
		exit(10);
		}
	}

initsocket()
	{

#ifdef BSD_43

	char hostname[128];
	int s;
	struct hostent *he;

	if (!so_init())
		{
		printstring("Socket interface unavailable.\n");
		exit(1);
		}

/* create a DATAGRAM socket (ie. sends asynchronous packets) */
	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
		{
		printstring("Error: %d\n",errno);
		exit(1);
		}

/* set up my socket's address */

	hostname[gethostname(hostname,sizeof(hostname))] = '\0';

	if (!(he = gethostbyname(hostname)))
		{
		printstring("Couldn't find host.\n");
		exit(1);
		}

	mysockaddr = HOSTSOCKET+1;					/* start at HOSTSOCKET+1 and go up */
	mysocket.sin_family = he->h_addrtype;	/* Internet addressing */
	memcpy((char *)&(mysocket).sin_addr,he->h_addr,he->h_length);

	while (1)
		{

/* convert address to something understandable by the system */

		mysocket.sin_port = htons(mysockaddr);	

/* now try and bind it.. if bind fails then increment mysockaddr and */
/* try again - bind attaches mysockaddr to the socket                */

		if (bind(s, (struct sockaddr *)&mysocket,sizeof(mysocket)) != -1) break;

		if (errno != EADDRINUSE && errno != EINVAL)
			{
			printstring("Error %d: Unable to bind socket.\n",errno);
			exit(1);
			}

		mysockaddr++;
		}


/* set socket NOT to block, ie. if there are no messages in the socket  */
/* then DON'T wait around, just exit with -1                            */

	if (ioctl(s, FIONBIO, (long *)&on) < 0)
		{
		printstring("Unable to unblock socket.\n");
		exit(1);
		}

	mysock = s;

	strcpy(username,inet_ntoa(mysocket.sin_addr));

#else

/* Create a unique mailbox name */
	int n = 1000;

	apiBeginC();

	do {
		sprintf(username,"USER%u",n++);
		} while (malFind(username,strlen(username)));

	if (malNew(&servmail))
		{
		printstring("Error: Unable to open mailbox.\n");
		apiEndC();
		exit(1);
		}

	malName(servmail,mailname,strlen(mailname));

	malOpen(servmail);

	apiEndC();

#endif
	}


waitdvx(int time)
	{

	while (time--);
		{
		nextframe();
		}

	}


/***********************************************************************/
addhistory(char *msg)
	{
	int n;

	for (n=1;n<HISTORY;n++)
		{
		histories[n-1] = histories[n];
		}
	histories[HISTORY-1] = strdup(msg);
	currenthistory = HISTORY-1;
	}

/***********************************************************************/
cls()
	{
	int n;

	ScreenClear();

	for (n=0;n<MESSAGELINE;n++)
		if (lines[n])
			{
			free(lines[n]);
			lines[n] = NULL;
			}

	fflush(stdout);
	}

scrollup(int n)
	{
	int m=0;

	if ((n<=0) || (n>DEFAULTLINE)) return;

	while (n<DEFAULTLINE)
		{

		if (lines[m]) free(lines[m]);
		lines[m++] = lines[n];
		lines[n++] = NULL;

		}


	n=0;
	while (lines[n])
		{
		setpos(0,n);
		printstring("%s[0m[K",lines[n++]);
		fflush(stdout);

		}

	outputline=n;

	while (n<MESSAGELINE-1)
		{
		setpos(0,n++);
		fflush(stdout);
		printstring("[K");
		fflush(stdout);
		}

	setpos(0,outputline);

	}


clearline()
	{
	fflush(stdout);
	printstring("[K");
	fflush(stdout);
	}

setpos(int x,int y)
	{
	fflush(stdout);
	printstring("[%d;%dH",y+1,x+1);
	fflush(stdout);
	}

/******************************************************************/

unsigned long getdisplaysize()
	{
	char *s=displaybuf;
	unsigned long totallen=0;

	if (strlen(s))
		{
		while (*s != '\0')
			{
			totallen += strlen(s)+1;
			s+= strlen(s)+1;
			}
		}
	return totallen;
	}

/******************************************************************/
/* if more is being displayed, buffer the output                  */

addtodisplay(char *s)
	{
	unsigned long n=getdisplaysize();

	if (*s == '\0') return;

	displaybuf = realloc(displaybuf,n+strlen(s)+3);
	strcpy(displaybuf+n,s);
	displaybuf[n+strlen(s)+1] = '\0';

	}


/******************************************************************/
/* if more is being displayed, buffer the output                  */
/* insert into beginning of list                                  */

instodisplay(char *s)
	{
	char *c,f[2]="\0\0";
	unsigned long n=getdisplaysize();

	if (*s == '\0') return;

	if (firstline) f[0] = FIRSTLINE;

	if (!(c=codes)) c = "";

	displaybuf = realloc(displaybuf,n+strlen(s)+strlen(c)+strlen(f)+3);

	memmove(displaybuf+strlen(c)+strlen(s)+strlen(f)+1,displaybuf,n+1);

	strcpy(displaybuf,c);
	strcpy(displaybuf+strlen(c),f);
	strcpy(displaybuf+strlen(c)+strlen(f),s);

	}

/******************************************************************/
/* get from the display buffer any queued output                  */
char *getfromdisplay()
	{
	unsigned int totallen=0;

	if (totallen = getdisplaysize())
		{
		strcpy(displaytmp,displaybuf);
		memmove(displaybuf,displaybuf+strlen(displaybuf)+1,totallen-strlen(displaybuf));
		return displaytmp;
		}

	return NULL;
	}


/******************************************************************/
clearmore()
	{
	if (moreactive) setpos(0,outputline); printstring("[K");
	morelines=0;
	moreactive=0;
	cursorpos();
	}

/******************************************************************/
cursorpos()
	{
	if (!moreactive) setpos(cursorx,MESSAGELINE+cursory);

	fflush(stdout);
	}

/* Display text in the incoming messages area */
/* Modified: word wrapping added (14/7/93)    */

display(char *buffer)
	{
	int done=0,cr=0;
	int numchars;
	char *s=buffer,*b=buffer;
	char *lastspace;
	int c,breakline,n;
	char indentage[80];

/* create indentation padding */
	for (n=0;n<indent;n++)
		indentage[n] = ' ';
	indentage[n] = '\0';

	setpos(0,outputline);

	while (!done)
		{
		numchars = strlen(prefix)+((firstline)?indent:0);
		breakline = 0;
		c = -1;
		lastspace = NULL;

		while (*s!= '\0' && *s!='\n')
			{
			if (s[-1] == '\\' && (s[0] == 'n' || s[0] == 'N'))
				break;

		if (morelines>(MESSAGELINE/2) && *s!='\0')
			{
			moreactive=1;
			if (outputline>MESSAGELINE-2)
				scrollup(MESSAGELINE/4);
			printstring(moreprompt);
			instodisplay(s);
			return;
			}

			if (*s == ' ' || *s == WHITESPACE) lastspace = s;
			if (*s == '') numchars-=5;

			if (numchars++ > WORDWRAP)
				{
				if (lastspace == NULL)
					{
					c = (*s)&0xff;
					*s++ = '\0';
					breakline = 1;
					}
				else
					{
					*lastspace = '\0';
					s = lastspace+1;
					breakline = 1;
					}
				break;
				}
			s++;
			}
		if (*s == '\0') done = 1;
		if ((*s == '\n' || *s == 'n') && !breakline)
			{
			cr = 1;
			if (s-b) if (s[-1] == '\r' || s[-1] == '\\') s[-1] = '\0';
			*s++ = '\0';
			}

		if (*b != '\0' || cr)
			{
			cr = 0;
			if (outputline>MESSAGELINE-2)
				scrollup(MESSAGELINE/4);
			printstring("%s%s%s[0m[K\n",prefix,(firstline)?indentage:"",b);

/* copy it into the screen buffer */
			if (lines[outputline]) free(lines[outputline]);
			strcpy((lines[outputline] = malloc(strlen(indentage)*firstline + strlen(prefix) + strlen(b) + 1)),prefix);
			if (firstline) strcat(lines[outputline],indentage);
			strcat(lines[outputline++],b);

			firstline = 1;

			}

		b = s;
		if (c != -1)
			*(--b) = c;

		morelines++;

		}


	if (newinput)
		{
		strcpy(msg,newinput);
		cursorp = strlen(msg);
		displayprompt();
		}

	if (wakeup)
		{
		printstring("");
		}

	cursorpos();
	}


/********************************************************************/

sendacknowledge(unsigned long id)
	{
	char buf[20];

	sprintf(buf,"%c%lu",ACKNOWLEDGE,id);
	sendmsg(buf);
	}

/********************************************************************/

checkincoming()
	{
	char *m,*p;

	int numbytes;
	struct sockaddr_in from;
	int fromlen;
	unsigned long recvdid;

	while (1)
		{
		fromlen = sizeof(from);

		numbytes = recvfrom(mysock,recvmsg,3071,0,(struct sockaddr *)&from,&fromlen);

		if ((!numbytes) || (numbytes == -1)) break;

		recvdid = *((unsigned long *)recvmsg);

/*
		sprintf(tempmsg,"[%d=%d]",recvdid,recvmsgid);
		display(tempmsg);
*/

		if (recvdid==0) recvmsgid=0;
		if ( ((recvdid&0xffffff00) > (recvmsgid&0xffffff00)) ||
			(((recvdid) > (recvmsgid)) && pending) )
				{
/*				sprintf(tempmsg,"Error: [%d.%d]",recvdid,recvmsgid); */
				display(tempmsg);
				display("\nHost connection lost.  Please wait for automatic reconnection.\n");
				recvmsgid=0;
				break;
				}

/* send acknowledge even if old (maybe an acknowledge was missed) */
		sendacknowledge(recvdid);

		if (recvdid<recvmsgid) break;

/*		printstring("incoming = [%s] [%d]\n\n",recvmsg+4,numbytes); */

		if (recvdid&0xff)
			{
			if (recvmsg[4] == ENDPEND)
				{
				recvmsgid = (recvdid+255) & 0xffffff00;

				addtodisplay(pendstr);
/*				dealwithinput(pendstr); */

				free(pendstr);	pendstr = NULL;

				pending = 0;
				}
			else
				{
				if (pending)
					pendstr = realloc(pendstr,strlen(pendstr)+strlen(recvmsg+4)+1);
				else
					pendstr = calloc(strlen(recvmsg+4)+1,1);

				pending = 1;
				strcat(pendstr,recvmsg+4);
				recvmsgid=recvdid+1;
				}
			}
		else
			{
			if (pendstr) { free(pendstr); pendstr = NULL; }
			pending=0;
			recvmsgid+=256;
			addtodisplay(recvmsg+4);
/*			dealwithinput(recvmsg+4);*/
			}
		}

	processwaiting();
	}

/*****************************************************************/
nextoutput()
	{
	char *s;

	if (moreactive) return;

	if (!(s = getfromdisplay()))
		{
		if (morelinestime++>I_TIMEOUT) morelines = 0;
		return;
		}
	else dealwithinput(s);
	morelinestime=0;
	}

/*****************************************************************/
dealwithinput(char *s)
	{
	char *m,*w,*c,*o=s;
	int ackmsg = 0;

	timeoutcount = 0;
	firstline=0;

	noecho = 0;
	if (strlen(prefix)) *prefix = '\0';
	indent = 0;

	if (codes) free(codes);
	codes = NULL;
	if (newinput) free(newinput);
	newinput = NULL;

	wakeup = 0;

	while (*s < '' && *s > '\0')
		{
		switch(*s)
			{
			case WAKEUP:	/* bell */
				wakeup=1;
				break;
			case SHUTDOWN:	/* close down terminal */
				exitplease = 1;
				break;
			case NEWINPUT:	/* new input line */
				
				s++;
				m = s;
				while (*s != '\0' && *s != NEWINPUT)
					{
					if (*s == '\r' || *s == '\n') *s++ = ' ';
					else s++;
					}

				if (newinput = malloc(s-m+1))
					{
					strncpy(newinput,m,s-m);
					newinput[s-m] = '\0';
					}
			
				break;
			case SETPREFIX:	/* new input line */
				m = prefix;
				s++;
				while (*s != '\0' && *s != SETPREFIX)
					{
					if (*s == '\r' || *s == '\n') s++;
					else *m++ = *s++;
					}

				*m = '\0';

				break;
			case SETINDENT:
				s++;
				indent = *s;
				break;
			case ECHOOFF:
				noecho = 1;
				break;
			case FIRSTLINE:
				firstline=1;
				break;
			case RETURNACK:
				ackmsg = 1;
				break;
			default:
				break;
			}
		s++;
		}

/* we have received an acknowledge for a previously sent input line */

	if (ackmsg)
		{
		if (strtol(s,NULL,10) == ack_id) recvd_ack = ack_id;
		return;
		}

	recv_str = s;

	if (waitfor)
		{
		w = waitfor;
		waitfornum = 0;
		while (w-waitfor<strlen(waitfor))
			{
			waitfornum++;
			if ( !(c = (strchr(w,','))) ) c = strlen(w)+w;
			(unsigned long) c -= (unsigned long) w;
			if (strnicmp(s,w,(unsigned long) c) == 0)
				{
				waitfor = NULL;
				break;
				}
			(unsigned long)w += (unsigned long)c+1;
			}
		if (!waitfor) return;
		}

	if (codes = malloc(s-o+1))
		{
		strncpy(codes,o,s-o);
		codes[s-o] = '\0';
		}

	if (!modem) display(s);

	fflush(stdout);

	}

/********************************************************************/

wordwrapmsg(char *s, char *b,char *prompt, char *longprompt, int cp,int *cx,int *cy, int mode)
	{
	char *lastspace,*append=NULL,*whichprompt,*o = s,*ls;
	int numchars,ml = 0,cr=0;


	do	{

/* copy the prompt or sub-prompt in */

		whichprompt = (ml)?longprompt:prompt;

		ls = b;

		if (cr) { s+=2; cr=0; }

		for (numchars=0;numchars<strlen(whichprompt);numchars++)
			*b++ = whichprompt[numchars];

		numchars = WORDWRAP-1-numchars;
		if (strlen(s) > numchars)
			{
			while (s[numchars] != ' ' && s[numchars] != WHITESPACE && s[numchars] != '\0')
				if (numchars-- < WORDWRAP/4) break;

			if (numchars == WORDWRAP/4)
				append = "-[K\n";
			else append = "[K\n";
			}

/* If we find a /n in the input convert it into a proper carriage return */

		if ((s-o) == cp && mode == 0)
			{
			*cx = (b-ls);		/* set the cursor's x position */
			*cy = ml;	/* set the cursor's y position */
			}

		while (numchars-->=0 && *s != '\0')
			{
			if (*s == '\\' && toupper(s[1]) == 'N')
					{
					cr = 1;
					append = "[K\n";
					break;
					}
			if (noecho) *b++ = '*';
			else *b++ = *s;

			s++;

			if ((s-o) == cp && mode == 0)
				{
				*cx = (b-ls);		/* set the cursor's x position */
				*cy = ml;	/* set the cursor's y position */
				}
			}

		if (mode == 1 && ml == *cy)
			{
			if (*cx > b-ls) *cx = b-ls-(*s=='\0')?1:0;
			if (*cx <strlen(whichprompt)) *cx = strlen(whichprompt);

			return (int)(s-o-((b-ls)-*cx));
			}


		if (*s != '\0')
			for (numchars=0;numchars<strlen(append);numchars++)
				*b++ = append[numchars];

		ml++;
		} while (*s != '\0');

	*b = '\0';

	return ml;
	}


displayprompt()
	{
	char tmp[80],*s,*p;
	int n,oldmessageline;

	oldmessageline = MESSAGELINE;

	msglines = wordwrapmsg(msg,longmsg,prompt,longprompt,cursorp,&cursorx,&cursory,0);

	if (MESSAGELINE < DEFAULTLINE-(msglines-1))
		{
		while (MESSAGELINE < DEFAULTLINE-(msglines-1))
			{
			setpos(0,MESSAGELINE-1);
			clearline();
			MESSAGELINE++;
			}
		}

	if (MESSAGELINE > DEFAULTLINE-(msglines-1))
		{
		if (outputline >= DEFAULTLINE-(msglines-1))
			scrollup(MESSAGELINE-(DEFAULTLINE-(msglines-1)));
		}

	MESSAGELINE = DEFAULTLINE-(msglines-1);

	if (oldmessageline != MESSAGELINE)
		{
		setpos(0,MESSAGELINE-1);
		printstring("[1;31m[0m[K\n");
		}

	setpos(0,MESSAGELINE);
	printstring("%s[K",longmsg);

	if (oldmessageline != MESSAGELINE)
		printstring("\n[1;31m[0m");
	
	cursorpos();
	}

/******************************************************************/

clearmsg()
	{
	msg[0] = '\0';
	cursorp = 0;
	}


/******************************************************************/
sendmsg(char *message)
	{
	if (message[0]<0x0a && message[0]!='\0') sendmsgtosocket(message);
	else addtowaiting(message);
	}

/******************************************************************/
sendmsgtosocket(char *message)
	{
	struct sockaddr_in to;

#ifdef BSD_43

	sprintf(tempmsg,"%d@%s: %s\n",mysockaddr,username,message);

	if (directhost)
		{
		memcpy(&to,&directaddr,sizeof(to));
		}
	else
		{
		setsockopt(mysock,SOL_SOCKET, SO_BROADCAST, (char *)&on,sizeof(on));

/* set destination to broadcast */

		to.sin_family = AF_INET;				/* internet */
		to.sin_addr.s_addr = BROAD_ADDR;		/* -1 means everyone */
		to.sin_port = htons(HOSTSOCKET);		/* socket number to send to (host's socket) */
		}

/* this will send the data to ALL opened sockets with the address HOSTSOCKET */
/* on ALL machines on the network                                            */

/*	display(tempmsg); */

	if (sendto(mysock,tempmsg,strlen(tempmsg)+1,0,(struct sockaddr *)&to,sizeof(to)) == -1)
		display("Error while sending to host.\n");


#else
	if (!(hostmail = malFind(HOSTNAME,strlen(HOSTNAME))))
		display("Error: Unable To Connect To Host.\n");
	else
		{
		sprintf(tempmsg,"%s: %s\n",username,message);
		malAddTo (hostmail, tempmsg, strlen(tempmsg)+1, 0, 0 );
		}
#endif
	
	}


/************************************************************/
/* process messages waiting to be sent to host              */

void processwaiting()
	{
	char *tmp;

	if (recvd_ack == ack_id)
		{
		remfromwaiting();
		time_out=0;
		time_retries = 0;
		ack_id++;
		}

	if (!waiting_line) return;
	if (!strlen(waiting_line)) return;

	if (time_out--<0)
		{

		if (time_retries ++ >WAITING_RETRIES)
			{
			display("Error: Host timed out, pending data cleared.\n");
			waiting_line[0]='\0';
			recvd_ack = ack_id;
			ack_id++;
			time_retries = 0;
			return;
			}

/* allocate a temporary string and insert the ack id into it */

		tmp = malloc(strlen(waiting_line)+1+32);
		sprintf(tmp,"%c%lu%c%s",SENDACK,ack_id,SENDACK,waiting_line);

		sendmsgtosocket(tmp);
		free(tmp);
		time_out = WAITING_TIME;
		return;
		}
	}

/************************************************************/

sendwait(char *s, char *w)
	{
	int n,r;
	for (n=0;n<3;n++)
		{
		sendmsg(s);
		if (r = waitforinput(w,SCANWAIT)) return r;
		}
	if (modem)
		{
		printstring("Failed while sending: [%s] and waiting for: [%s]\n",s,w);
		if (!recv_str) printstring("Due to timeout.\n");
		else printstring("Received [%s] instead.\n",recv_str);
		}
	return 0;
	}

/*******************************************************************/


waitforinput(char *s,int timeout)
	{
	int ret=0;
	recv_str = NULL;

	timeout = timeout;
	waitfor = s;
	while (timeout-- && waitfor)
		{
		nextframe();
		checkincoming();
		nextoutput();
		nextframe();
		}
	if (!waitfor) ret = waitfornum;
	waitfor = NULL;
	return ret;
	}


/********************************************************************/

int main(int argc,char *argv[])
	{
	unsigned int c;
	int numkeys,n;
	char *cr,*oldcr;
	int count;

	oldcbrk = getcbrk();
	setcbrk(0);

	for (n=0;n<MESSAGELINE;n++)
		lines[n] = NULL;

	for (n=0;n<HISTORY;n++)
		histories[n] = NULL;

	displaybuf = malloc(2);
	displaybuf[0] = '\0' ; displaybuf[1] = '\0';

	initsocket();
	
/***** Actually start the program rather than faffing around *****/

	MESSAGELINE = ScreenRows()-2-1;
	DEFAULTLINE = MESSAGELINE+1;

#ifndef TELNET

	if ( argc >= 2 )
		{
		exitplease = 1;
		if (strcmpl(argv[1],"MODEM")==0)
			{
			exitplease = 0;
			if (argc==4)
				{
				smtpfile_in = malloc(strlen(argv[2])+1+15);
				strcpy(smtpfile_in,argv[2]);
				strcat(smtpfile_in,"\\inmail.xxx");

				smtpfile_out = malloc(strlen(argv[3])+1+15);
				strcpy(smtpfile_out,argv[3]);
				strcat(smtpfile_out,"\\outmail.xxx");
				}
			else
				{
				smtpfile_in = strdup("inmail.xxx");
				smtpfile_out = strdup("outmail.xxx");
				}
			modemcontrol();
			}
		if (strcmpl(argv[1],"AUTO")==0)
			{
			exitplease = 0;
			ScreenClear();
			if (argc>=4)
				{
				strncpy(autologin_name,argv[2],sizeof(autologin_name)-1);
				strncpy(autologin_pass,argv[3],sizeof(autologin_name)-1);
				autologin = 1;
				}
			else setup_autologin();
			if (argc==6)
				{
				if (strcmpl(argv[4],"DIRECT")==0)
					{
					directhost = strdup(argv[5]);
					}
				}
			}
		if (strcmpl(argv[1],"SMTP")==0)
			{
			if (argc==4)
				{
				exitplease = 0;
				smtp = 1;
				smtpfile_in = malloc(strlen(argv[2])+1+15);
				strcpy(smtpfile_in,argv[2]);
				strcat(smtpfile_in,"\\inmail.xxx");

				smtpfile_out = malloc(strlen(argv[3])+1+15);
				strcpy(smtpfile_out,argv[3]);
				strcat(smtpfile_out,"\\outmail.xxx");

				modemcontrol();
				}
			else
				{
				printstring("CHATSERV SMTP <Directory\\mailfile>\n");
				}
			}
		if (strcmpl(argv[1],"DIRECT")==0 && argc==3)
			{
			exitplease = 0;
			directhost = strdup(argv[2]);
			}
		}

/* Check for direct host and set up destination address */

	if (directhost) SetupDirectHost();

#else

/* Set up the socket daemon */


	while ((ds = so_daemon(argv,1)) >= 0)
		{
		sin = SOCKfdopen(ds,"r");
		sout = SOCKfdopen(ds,"w");

		SOCKfprintf(sout,"%c%c%c",TN_IAC,TN_DO,TN_RCTE);
		SOCKfflush(sout);
		SOCKfprintf(sout,"%c%c%c%c%c%c",TN_IAC,TN_SB,TN_RCTE,7,TN_IAC,TN_SE);
		SOCKfflush(sout);

		SOCKgetc(sin);
		SOCKgetc(sin);
		SOCKgetc(sin);
#endif

	if (!exitplease)
		{
		cls();
		clearmsg();
		displayprompt();

		display("Waiting for connection.\n");
		display("Press F1 to quit to DOS.\n");
		}
		
	while (!exitplease)
		{
		for (numkeys=0;(numkeys<10) && (!exitplease);numkeys++)
			{
			cursorpos();
			fflush(stdout);
			count = 0;
			while (!keyhit() && !exitplease)
				{

/* if terminal needs resetting, reset it */
				if (!recvmsgid)
					{
					do {
						if (keyhit()) if (getkeychar()==F1) exitplease = 1;
						sendmsg("\x01");
						timeoutcount=0;
						}
						while (!waitforinput("Host Connection Established.",500) && !exitplease);
					if (autologin && !exitplease)
						{
						waitforinput("What is your name?",250);
						sendwait(autologin_name,"What is your password?");
						sendmsg(autologin_pass);
						}
					clearmore();
					}
				if (exitplease) break;

/* let other tasks get a foot in */
				nextframe();

				checkincoming();
/* every few frames do some housekeeping */
				if (count++ > I_TIMEOUT)
					{
					nextoutput();
					timeoutcount++;

/* let's make sure the host still exists */
					if (timeoutcount>10000)
						{
						timeoutcount = 0;
						if (!moreactive)
							{
#if 0
							int tc;
							while(1)
								{
								sendmsg("\x03");  /* Verify host's existance */
								if (!waitforinput("Connected.",1000))
									{
									if (tc>5)
										{
										display("Connection to host lost.  Retrying.");
										recvmsgid = 0;
										break;
										}
									}
								tc++;
								}
#endif
							}
						else
							{
							while (getfromdisplay()); ;
							clearmore();
							displayprompt();
							}
						}
					count = 0;
					}
				}

			if (exitplease) continue;

			timeoutcount = 0;

			c = getkeychar();

/*
			sprintf(tempmsg,"[%d]",c);
			display(tempmsg);
*/

			if (moreactive) c = (c==13)?CONTINUEMORE:((c=='')?CANCELMORE:0);

			switch(c)
				{
				case F1:
					exitplease = 1;
					break;
				case CANCELMORE:
					while (getfromdisplay()); ;
					clearmore();
					break;

				case CONTINUEMORE:
					clearmore();
					break;

				case DEL:
					if (msg[cursorp] != '\0')
						if (msg[cursorp] == '\\' && toupper(msg[cursorp+1]) == 'N')
							memmove(msg+cursorp,msg+cursorp+1,strlen(msg+cursorp));
						memmove(msg+cursorp,msg+cursorp+1,strlen(msg+cursorp));
					break;

				case CURSOR_UP:
					if (cursory)
						{
						cursory--;
						cursorp = wordwrapmsg(msg,longmsg,prompt,longprompt,cursorp,&cursorx,&cursory,1);
						}
					break;

				case CURSOR_DOWN:
					if (!strlen(msg)) break;
					if (cursory<msglines)
						{
						cursory++;
						cursorp = wordwrapmsg(msg,longmsg,prompt,longprompt,cursorp,&cursorx,&cursory,1);
						}
					break;

				case CTRL_LEFT:
					while (cursorp)
						{
						deccursor;
						if (msg[cursorp] != WHITESPACE && msg[cursorp] != ' ' && !(msg[cursorp] == '\\' && toupper(msg[cursorp+1]) == 'N'))
							break;
						}
					while (cursorp)
						{
						deccursor;
						if (msg[cursorp] == WHITESPACE || msg[cursorp] == ' ' || (msg[cursorp] == '\\' && toupper(msg[cursorp+1]) == 'N'))
							break;
						}
						if (msg[cursorp] == ' ' || msg[cursorp] == WHITESPACE || (msg[cursorp] == '\\' && toupper(msg[cursorp+1]) == 'N'))
							inccursor;
					break;

				case CTRL_RIGHT:
					while (cursorp<strlen(msg))
						{
						if (msg[cursorp] == WHITESPACE || msg[cursorp] == ' ' || (msg[cursorp] == '\\' && toupper(msg[cursorp+1]) == 'N'))
							break;
						inccursor;
						}
					while (cursorp<strlen(msg))
						{
						if (msg[cursorp] != WHITESPACE && msg[cursorp] != ' ' && !(msg[cursorp] == '\\' && toupper(msg[cursorp+1]) == 'N'))
							break;
						inccursor;
						}
					if (msg[cursorp] == ' ' || msg[cursorp] == WHITESPACE || (msg[cursorp] == '\\' && toupper(msg[cursorp+1]) == 'N'))
						inccursor;
					break;

				case PAGE_UP:
				case CTRL_UP:
					if (histories[currenthistory])
						{
						clearmsg();
						strcpy(msg,histories[currenthistory--]);
						if (currenthistory < 0) currenthistory = HISTORY-1;
						cursorp = strlen(msg);
						}
					break;

				case PAGE_DOWN:
				case CTRL_DOWN:
					if (++currenthistory>HISTORY-1) currenthistory = 0;
					if (histories[currenthistory])
						{
						clearmsg();
						strcpy(msg,histories[currenthistory]);
						cursorp = strlen(msg);
						}
					break;

				case HOME:
					cursorp = 0;
					break;
				case END:
					cursorp = strlen(msg);
					break;

				case CURSOR_LEFT:
					if (cursorp>0) deccursor;
					break;
				case CURSOR_RIGHT:
					if (cursorp<strlen(msg)) inccursor;
					break;

				case '':
					if (*msg == '\0')
						{
						*longmsg = '\0';
						msglines=0;
						}
					clearmsg();
					break;
				case '':
					if (cursorp)
						{
						if (cursorp>1)
							if (toupper(msg[cursorp-1]) == 'N' && msg[cursorp-2] == '\\')
								{
								memmove(msg+cursorp-1,msg+cursorp,strlen(msg+cursorp)+1);
								cursorp--;
								}
						memmove(msg+cursorp-1,msg+cursorp,strlen(msg+cursorp)+1);
						cursorp--;
						}
					break;
				case 13:
					if (!noecho) addhistory(msg);
					sendmsg(msg);
					clearmsg();
					break;
				case LINEFEED:
						memmove(msg+cursorp+2,msg+cursorp,strlen(msg+cursorp)+1);
						msg[cursorp++] = '\\';
						msg[cursorp++] = 'n';
					break;
				default:
					if (c>31 && c<0xff)
						{
						if (c==' ') c='';
						memmove(msg+cursorp+1,msg+cursorp,strlen(msg+cursorp)+1);
						msg[cursorp++] = c;

						}
					break;
				}
			if (!moreactive) displayprompt();
			}
		}

	closesocket();

#ifdef TELNET

	SOCKfclose(sin);
	SOCKfclose(sout);

	so_close(ds);

	}		/* loop around for another connection */

#endif

	setcbrk(oldcbrk);
	}




/*******************************************************************/

scanfor(char **f,char *s)
	{
	int n;
	char c;
	char *m = *f,*p,*q;

	while (*m != '\0')
		{
		q = s;
		n = 0;
		do {
			n++;
			if (!(p = strchr(q,','))) p = s+strlen(s);
			if (strnicmp(m,q,p-q) == 0)
				{
				*(unsigned long *)f = (unsigned long)m + (unsigned long)p-(unsigned long)q;
				return n;
				}
			q = p+1;
			} while (*p != '\0');
		m++;
		}

	return 0;
	}
/*******************************************************************/

char *getword(char **m)
	{
	char p,*s = word,*f=*m;

	word[0] = '\0';

	do	{
		p = *f++;
		} while ((p == ' ' || p == '\n' || p == '\r' || p == '\t') && p != '\0');

	if (p == '\0') return word;

	do {
		*s++ = p;
		p = *f++;
		} while (p != ' ' && p != '\n' && p != '\r' && p != '\t' && (s-word) < sizeof(word) && p != '\0');

	*s = '\0';

	*m = f;
	return word;
	}

/*******************************************************************/

char *getline(char **m)
	{
	char *p,*s = word;

	word[0] = '\0';

	if (!(p = strchr(*m,'\n'))) return word;

	if (p-*m > sizeof(word)) return word;
 
	strncpy(s,*m,p-*m);
	s[p-*m] = '\0';
	if (s[strlen(s)] == '\r') s[strlen(s)] = '\0';
	
	*m = p+1;

	return word;
	}


/*******************************************************************/

char *waitforline()
	{
	int n = 1000;

	recv_str = NULL;

	do {
		nextframe();
		checkincoming();
		nextoutput();
		} while (!recv_str && n-->0);

	if (!n) return NULL;

	for (n=0;n<strlen(recv_str);n++)
		if ((unsigned char)(recv_str[n])==0xff) recv_str[n] = ' ';

	return recv_str;
	}
/*******************************************************************/

batchmail()
	{
	FILE *fp;
	int n,success;
	unsigned char *s;
	char fname[80];
	int internet_mail;
	char username[80];

	if (!sendwait("Mail","Mail>")) return;

	while (1)
		{
		if (!(n = sendwait("any new?","Yes,No"))) return;
		if (n==2) break;

		if (!(n = sendwait("Ok, give us it.","Sending."))) return;

		if (!(s = waitforline())) return;

		strcpy(username,s);

		if (!(s = waitforline())) break;	/* get recipient's name */

		if (!strchr(s,'@'))
			{
			strcpy(fname,username);
			strcat(fname,".out");
			internet_mail = 0;
			}
		else
			{
			strcpy(fname,smtpfile_out);
			finduniquename(fname);
			internet_mail = 1;
			}

		success = 0;

		if (fp = fopen(fname,"a"))
			{

/* send receiver's name */
			if (!internet_mail) fprintf(fp,"%s\n",s);
			else fprintf(fp,"To: %s\n",s);

/* send sender's name */
			if (internet_mail) fprintf(fp,"From: %s\n",username);

/* send subject */
			if (!(s = waitforline())) break;
			if (!internet_mail) fprintf(fp,"%s\n",s);
			else fprintf(fp,"Subject: %s\n",s);

			fprintf(fp,"\n");
/* Now to send the body of the text */

			success = 1;

			while (1)
				{
				if (!(s = waitforline())) { success = 0; break; }
				if (strcmp(s,"QUIT")==0) break;

/* word wrap the line if need be */

				while (strlen(s)>70)
					{
					for (n=70;n>0;n--)
						if (s[n] == 0xff || s[n] == ' ')
							break;
					for (;n>0;n--)
						if (s[n] != 0xff && s[n] != ' ')
							{
							s[n+1] = '\0';
							break;
							}
					if (internet_mail && *s == '.') fputc('.',fp);
					fprintf(fp,"%s\n",s);
					s+=n+2;
					for (n=0;n<strlen(s);n++)
						if (s[n] != 0xff && s[n] != ' ')
							{
							s+=n;
							break;
							}
					}
				if (internet_mail && *s == '.') fputc('.',fp);
				fprintf(fp,"%s\n",s);
				}

			if (!internet_mail) fprintf(fp,"/s\n");
			else fprintf(fp,".\n");

			}
		else return;

		fclose(fp);

		if (success)
			{
			printstring("[Mail Received]\n");
			if (!sendwait("Received ok.","Mail>")) return;
			}
		}

	if (!sendwait("QUIT","Leaving")) return;
	}
/*******************************************************************/
/* Check for new smtp mail                                         */

char *CheckNewSmtpFiles(char *dir)
	{
	struct ffblk b;
	int done;
	char *e = strchr(dir,'.')+1;
	char *n;

	strcpy(e,"*");

	done = findfirst(dir,&b,0);

	while (!done)
		{
		if (!(b.ff_attrib&FA_DIREC))
			{
			if (strchr(b.ff_name,'.'))
				{
				strcpy(e,strchr(b.ff_name,'.')+1);
				if (!access(dir,R_OK)) return dir;
				else strcpy(e,"*");
				}
			}
		done = findnext(&b);
		}
	return NULL;
	}
/*******************************************************************/

scannewmail()
	{
	FILE *fp,*el;
	unsigned int n, total,ret,successful;
	char *s,*msgs,*m,*t;
	char *to,*subject,*from,*date;
	char *rto,*rfrom;
	int breakout;
	int newsmtps;

	if (!sendwait("Mail","Mail>")) return;

	if (smtp) newsmtps = (int)CheckNewSmtpFiles(smtpfile_in);

	if ((fp = fopen((smtp)?smtpfile_in:"argomail.cap","r")) && newsmtps)
		{
		printstring("[Processing mail - do not reset machine]\n");
		msgs = NULL; n = 1025; ret = 0; total = 0;
		while (!feof(fp))
			{
			msgs = realloc(msgs,n);
			ret=fread(&(msgs[n-1025]),1,1024,fp);
			if (ret>0) total+=ret;
			n+=1024;
			}

		fclose(fp);

		msgs[total] = '\0';
		m = msgs;

		while(1)
			{
			successful = 0;

/* who is it addressed to? */
			if (!smtp)
				{
				if (!scanfor(&m,"To:- "))
					{
					successful = 1;
					break;
					}
				to = strdup(getword(&m));
				}
			else
				{
				s = m;
				if (!scanfor(&s,"To: "))
					if (!scanfor(&s,"Apparently-To: "))
						{
						successful = 1;
						break;
						}
				to = strdup(getword(&s));
				}

			rto = to;

/* If mail is SMTP encoded, parse the route out and discard */
/* Format for to: is <name>@<host>:<route>                  */
/* Format for from: is <route>:<name>@<host>                */

			if (smtp)
				{
				int breakout=0;

				while (strchr(to,'@') == to)
					if (strchr(to,':')) to = strchr(to,':')+1;
					else { breakout=1; break; }

				if (breakout) break;

				*strchr(to,'@') = '\0';

				date = strdup("---");
				s = m;
				if (!scanfor(&s,"From: "))
					if (!scanfor(&s,"Apparently-From: "))
						{
						successful = 1;
						break;
						}

				from = strdup(getline(&s));
				rfrom = from;

				if (strrchr(from,':'))
					from = strrchr(from,':')+1;

/* If any spaces follow the internet address null terminate the string */
				if (strchr(from,'@'))
					if (strchr(strchr(from,'@'),' '))
						*strchr(strchr(from,'@'),' ') = '\0';

				s = m;
				if (scanfor(&s,"\nSubject: ,\n.\n")==1)
					{
					subject = strdup(getline(&s));
					m = s;
					}
				else subject = strdup("** no subject **");
				
				}
			else
				{
				for (n=0;n<3;n++)
					{
					switch(scanfor(&m,"Subject: ,From: ,Date: ,To:- "))
						{
						case 1:
							subject = strdup(getline(&m));
/*			printstring("Subject: %s\n",subject);*/
							break;
						case 2:
							from = strdup(getword(&m));
							rfrom = from;
/*			printstring("From: %s\n",from);*/
							break;
						case 3:
							date = strdup(getline(&m));
/*			printstring("date: %s\n",date);*/
							break;
						case 4:
							m -= 5;
							n = 100;
							break;
						default:
							if (n)
								{
								printstring("[Mail message invalid]\n");
								n = 10;
								}
							else n=100;
							break;
						}
					}
				if (n >= 100) continue;
				if (n >= 10) break;
				}

/*
			printstring("[To: %s]\n[From: %s]\n[Subject: %s]\n[Date: %s]\n",to,from,subject,date);
*/

			if (el = fopen("chatsmtp.log","a"))
				{
				fprintf(el,"[To: %s]\n[From: %s]\n[Subject: %s]\n[Date: %s]\n",to,from,subject,date);
				fclose(el);
				}

			if (!sendwait("new","To>")) break;

/* Who is it to? */
			if (!(n = sendwait(to,"Subject>,Unknown User!"))) break;
			free(rto);

/* Check for unknown user */
			if (n==2)
				{
				free(subject);
				free(rfrom);
				free(date);

				if (smtp)
					{
					scanfor(&m,"\n.\n");
					}
				else scanfor(&m,"\nNext/,\n(DONE)");
				continue;
				}

/* What is the subject? */
			if (!sendwait(subject,"From>")) break;
			free(subject);

/* Who is it from? */
			if (!sendwait(from,"Date>")) break;
			free(rfrom);

/* What date was it sent? */
			if (!sendwait(date,"Body>")) break;
			free(date);

/* Now send the body of the text */
			t = NULL;
			while (*m != '\0')
				{
				t = m;
				s = getline(&m);
				if (smtp)
					{
					if (strcmp(s,".")==0) break;
					if (*s == '.') s++;
					}
				else
					{
					if (strnicmp(s,"[more]",6) == 0) s+=6;
					if (strnicmp(s,"Next/",5) == 0) break;
					if (strnicmp(s,"(DONE)",6) == 0) break;
					}

				breakout = 0;
				if (!sendwait(s,"Body>"))
					{
					breakout = 1;
					break;
					}
				}
			if (breakout) break;
			if (t) m = t;
			if (!sendwait("QUIT","Finished.")) break;
			successful = 1;
			}
		free(msgs);
		if (successful)
			{
			printstring("[Deleting scratchpad file]\n");
			remove((smtp)?smtpfile_in:"argomail.cap");
			printstring("[Mailing finished]\n");
			}
		if (!sendwait("QUIT","Leaving")) return;
		}
	else sendwait("QUIT","Leaving");
	}

/*******************************************************************/
runtelix()
	{
	printstring("[Running Telix]\n");
	system("telixbbs");
	sendmsg("Successful.");
	printstring("[Telix executed successfully]\n");
	}

/*******************************************************************/

int checkfortelix()
	{
	if (!access("tlxreq.tmp",W_OK) && !smtp)
		{
		remove("tlxreq.tmp");
		return 1;
		}
	return 0;
	}

/*******************************************************************/

modemcontrol()
	{
	int connected,n,t,w, first;

	modem = 1;

	printstring("Incoming SMTP files are expected to be in <%s>.\n",smtpfile_in);
	printstring("Outgoing SMTP files will be written to <%s>.\n",smtpfile_out);

	while (!exitplease)
		{
		connected = 0;	
		t = 0;

		first = 0;
		while (!connected)
			{
			if (!smtp && first && checkfortelix()) runtelix();
			first = 1;
			printstring("[Resetting]\n");
			sendmsg("\x01");
			if (!waitforinput("What is your name?",1000)) continue;
			printstring("[Logging in]\n");
			sendmsg("modem");
			if (!waitforinput("What is your password?",1000)) continue;
			sendmsg("\xc0\xb1\xa2\x93\x84\x75");
			if (!waitforinput("Ok",1000)) continue;
			connected = 1;
			}

		if (!connected) printstring("[Connect failed]\n");
		if (connected) printstring("[Connected]\n");

		while (!exitplease && connected)
			{
			connected=0;
			printstring("[Q.Are you there? ");
			sendmsg("Are you there?");
			if (!waitforinput("Ready",1000))
				{
				printstring("A.No]\n");
				continue;
				}
			printstring("A.Yes]\n");

			printstring("[Q.Do you need anything? ");
			sendmsg("Do you need anything?");
			if (!(w = waitforinput("No,Yes - Telix please,Yes - Batch mail please",1000)))
				continue;

			if (w==1)
				{
				if (checkfortelix()) w = 2;
				}

			switch(w)
				{
				case 2:
					printstring("A.Yes - Telix please.]\n");
					runtelix();
					break;
				case 3:
					printstring("A.Yes - batch mail please]\n");
					batchmail();
					break;
				default:
					printstring("A.No]\n");
					break;
				}

			scannewmail();

			for (n=0;n<3000;n++)
				{
				nextframe();
				checkincoming();
				nextoutput();
				if (exitplease) continue;
				connected = 1;
				}
			}
		}
	}
