/****************************************************************/
/**                                                            **/
/**   Direct Communication Chat and Conferencing System        **/
/**   Created May 1993 out of complete boredom.                **/
/**   (c) 1993 Takoyaki Software Ltd.                          **/
/**                                                            **/
/**   Will only run in conjunction with Desqview/X.            **/
/**                                                            **/
/**   File:    CHATVARS.H                                      **/
/**                                                            **/
/****************************************************************/



#define WORDWRAP 60

#include	<pc.h>
#include	<dvapie.h>
#include	<sys/dirent.h>

#define CLK_TCK CLOCKS_PER_SEC

#define AUTOSAVE 300000

#define MAILPURGE 7   /* mail 14 days old is purged */

#define nextframe() apiPause()
#define locktask() apiBeginC()
#define unlocktask() apiEndC()
#define strcmpl(s,d) strcasecmp(s,d)
#define strncmpl(s,d,n) strncasecmp(s,d,n)

#define F_OK	0	/* does file exist?	*/
#define X_OK	1	/* execute permission?	*/
#define W_OK	2	/* write permission?	*/
#define R_OK	4	/* read permission?	*/

#define HOSTSPEED 1

struct cmd { char *name; int (*func)(char *); };

#define HOSTNAME "--CHATHOST--"
#define HOSTDATA "HOSTDATA.dat"
#define MALE 0
#define FEMALE U_SEX
#define STOPCHAR 0x07

struct staticuser
	{
	struct staticuser *next;
	struct staticuser *prev;
	char *username;
	unsigned char itemflags;

	struct user *user;
	char *password;
	char *description;
	unsigned int logins;
	unsigned int mail;
	unsigned int termwidth;
	unsigned int termheight;
	unsigned long flags;
	};

#define U_SYSOP   (1<<0)
#define U_SEX     (1<<1)
#define U_MODEM   (1<<2)

struct user
	{
	struct user *next;
	struct user *prev;
	char *mailbox;
	int type;
	unsigned char itemflags;

	char *username;
	int (*mode)(char *,char *);
	struct staticuser *staticuser;
	struct emote *emote;		/* emote that is currently being editted */
	struct mail *mail;		/* mail msg that is currently being editted */
	unsigned long mailid;	/* the last read mail's id (for replying)*/
	unsigned long ack;		/* current acknowledge id */
	char *inputline;
	int modestate;
	int ONLINE:1;
	int NOECHO:1;
	int BELL:1;
	int CLOSEDOWN:1;
	};

struct emote
	{
	struct emote *next;
	struct emote *prev;
	char *cmd;
	int type;
	unsigned char itemflags;

	char *emote;
	char *user;
	char *category;
	unsigned long usage;
	unsigned long flags;
	};

#define E_PRIVATE (1<<0)

struct category
	{
	struct category *next;
	struct category *prev;
	char *name;
	int type;
	char *itemflags;
	};

struct mail
	{
	struct mail *next;
	struct mail *prev;
	char *whoto;
	int type;
	unsigned char itemflags;

	unsigned long id;
	unsigned long nextmail;
	unsigned long prevmail;
	char *subject;
	char *body;
	char *whofrom;
	unsigned long time;
	unsigned long num;
	unsigned long flags;

	};

/* flags for mail structure */
#define M_UNREAD  (1<<0)
#define M_UNSENT  (1<<1)
#define M_MARKED  (1<<2)
#define M_EXTERNAL (1<<3)


struct message
	{
	struct message *next;
	struct message *prev;
	char *whoto;
	int type;
	unsigned char itemflags;

	unsigned long id;
	unsigned long nextthread;
	unsigned long prevthread;
	char *subject;
	char *body;
	char *whofrom;
	unsigned long time;
	unsigned long flags;
	};

struct conference
	{
	struct conference *next;
	struct conference *prev;
	char *name;
	int type;
	unsigned char itemflags;

	unsigned long currentmsg;
	char *creator;
	char *password;
	unsigned long time;
	unsigned long flags;
	};

/* flags for conference structure */
#define C_PRIVATE  (1<<0)
#define C_PASSWORD (1<<1)

struct item
	{
	struct item *next;
	struct item *prev;
	char *name;
	int type;
	unsigned char itemflags;
	};

/* flags which are standard for every object */
#define I_INVALID (1<<0)

struct flagdef
	{
	char *name;
	unsigned long mask;
	int flags;
	};

struct itemdef
	{
	char *name;
	int datatype;
	int offset;
	struct flagdef *flagdefs;
	int flags;
	};

/* item types currently available */
#define IT_EMOTE 1
#define IT_USER 2
#define IT_CATEGORY 3
#define IT_MAIL 4
#define IT_ONLINEUSER 5

struct items
	{
	char *name;
	struct itemdef *itemdef;
	struct item **header;
	int flags;
	int size;
	int offset;
	int type;
	char *filename;
	};


/* Types of variables in data structure */

#define T_STRING 0  /* ptr to string        */
#define T_FLAGS  1  /* flag (unsigned long) */
#define T_INT    2  /* signed word          */
#define T_UINT   3  /* unsigned word        */
#define T_LONG   4  /* signed long          */
#define T_ULONG  5  /* unsigned long        */
#define T_WORD   6  /* ptr to string        */

/* Types of flags in data structure */

#define F_SYSOP     (1<<0)  /* only the sysop can alter this member */
#define F_UNIQUE    (1<<1)  /* no other structures can have the same value in this field */
#define F_INVIS     (1<<2)  /* if data is displayed or editted it should be invisible */
#define F_PRIVATE   (1<<3)  /* can edit only if the current user name matches the user name in the field */
#define F_NOSAVE    (1<<4)  /* this list isn't saved out */


struct fcmd { char *name; int (*readfunc)(FILE *); int (*writefunc)(FILE *);};

/* number of categories for emote command */
#define NUMCATS 32

/* flags that can be set into the sysmsgflag for sending messages */

#define SYSMSG 1
#define INDENTMSG 2
#define MAILMSG 4
#define ACKINPUT 8

/*********************************************************************/
/** MACROS                                                           */

#define addemote() ((struct emote *)additem(IT_EMOTE))
#define rememote(e) (remitem((struct item *)(e)))

#define addstatic() ((struct staticuser *)additem(IT_USER))
#define remstatic(s) (remitem((struct item *)(s)))

#define addonlineuser() ((struct user *)additem(IT_ONLINEUSER))
#define remonlineuser(s) (remitem((struct item *)(s)))

#define addcat() ((struct category *)additem(IT_CATEGORY))
#define remcat(e) (remitem((struct item *)(e)))

#define addmail() ((struct mail *)additem(IT_MAIL))
#define remmail(m) (remitem((struct item *)(m)))

#define setinput(s) (currentuser->inputline = strdup(s))

#define sysmsg sysmsgflag |= SYSMSG;sendmsg
#define indentmsg(n) (sysmsgflag |= INDENTMSG); (indent = (n))

#define ISSYSOP (currentuser->staticuser->flags&U_SYSOP)

#define newsection() sendmsg(mailbox,"[01m-----------------------------------------------------------------------------")

#define geto_sptr(p,v) *((char **)(((unsigned long)(p))+((unsigned long)(v))))
#define geto_int(p,v) *(int *)(((unsigned long)(p))+((unsigned long)(v)))
#define geto_uint(p,v) *(unsigned int *)(((unsigned long)(p))+((unsigned long)(v)))
#define geto_long(p,v) *(long *)(((unsigned long)(p))+((unsigned long)(v)))
#define geto_ulong(p,v) *(unsigned long *)(((unsigned long)(p))+((unsigned long)(v)))


