; 94/6/28
; Author :kawaguchi

;=============================================================
;*		MARIO RAM CLEAR Sub Routine		*
;=============================================================
;R1 :MARIO RAM ADDRESS
;R2 :DATA COUNTER
MRAMClear_mc
	lm	r1,[m_x1]	;ram address
	lm	r2,[m_x2]	;counter

	mcache
.loop
	stw	[r1]	;RAM Clear
	inc	r1	; data pointer
	dec	r2	; data size /2
	bne	.loop
	inc	r1

	jmp	r11
	nop
;=============================================================
;*		Mario RAM Clear				*
;* Init: m_x1 = clear ram start address			*
;*     : m_x2 = length					*
;=============================================================
MRAMClear
	sub	r0
	ramb
	romb

	mcall	MRAMClear_mc
	nop

	stop
	nop

;=============================================================
;*		MAKE PLANET		[MISSION MAP]	*
;=============================================================
MMAKEPLANET
	sub	r0
	ramb
	romb
;********* Mario RAM Clear ************
	mcall	MRAMClear_mc
	nop

;********* Planet Draw ************
	miwt	r1,m_planetdrawbuf
.LOOP
	move	r11,r1
	ldw	[r1]
	sms	[m_xc],r0
	inc	r1
	inc	r1

	ldw	[r1]
	sms	[m_yc],r0
	inc	r1
	inc	r1

	ldw	[r1]
	sms	[m_radius],r0
	inc	r1
	inc	r1

	ldw	[r1]
	sms	[msprite],r0

	lm	r0,[m_planetlen]
	add	r11
	sm	[m_planetptr],r0

	mcall	mdrawsphere_mc
	nop

	lm	r1,[m_planetptr]
	lm	r0,[m_planetcnt]
	dec	r0
	bne	.LOOP
	sbk

	miwt	r15,mprint_mapmessage	; caution!! STOP - yajima
	nop

	stop
	nop
;=============================================================
;*		MAKE PLANET	[MISSION EXPLAIN]	*
;=============================================================
MMAKEPLANET2
	sub	r0
	ramb
	romb

	mcall	mdrawsphere_mc
	nop

	stop
	nop
;=============================================================
;*		MERGE PLANET Routine			*
;=============================================================
MMERGEPLANET
	sub	r0
	ramb
	romb

	mcall	MMERGEPLANET_mc
	nop

	stop
	nop
;=============================================================
;*		MERGE PLANET Sub Routine		*
;=============================================================
MMERGEPLANET_mc
;* init *
;(m_x1,m_y1)     = (source x,source y)
;(m_bigx,m_bigy) = (dest x,dest y)
;m_drawmap       = Mario RAM Base address
;m_screenhight   = (BitMapRAM hight)*8
;---------------------------------------------------------------------------
;r1 :bitmap mase
;r2 :screen hight
;r3 :source base address
;r4 :dest base address
;r5 :source address
;r6 :dest address
;r7 :next yoko slit address
;r8 :tmp
;r9 :yoko chara no kazu
;r10:tate chara no kazu
;r11:return address
;r12:loop counter
;r13:loop address
;---------------------------------------------------------------------------
	lms	r1,[m_drawmap]		;mario ram base address
	lm	r2,[m_screenheight]	;mario screen hight*8
;---------------------------------------------------------------------------
;* source address calc *
;* (xpos*Vhight+ypos)*32 *
	lms	r3,[m_x1]	;x postion

	with	r3
	umult	r2		;R3 <--- Xpos * (Vhight*8)

	lms	r0,[m_y1]
	umult	#8		;R0 <--- Y postion*8
	add	r3		;R0 <--- (Xpos*Vhight+Ypos)*8
	add	r0	;*2
	add	r0	;*4
	to	r3		;R3 <-- bitmapbase+(Xpos*Vhight+Ypos)*32
	add	r1
;---------------------------------------------------------------------------
;* dest address calc (ue 2bit ni tensou)*
;* (xpos*Vhight+ypos)*32+16 *
	lms	r4,[m_bigx]		;x postion

	with	r4
	umult	r2		;R4 <--- xpos*(Vhight*8)

	lms	r0,[m_bigy]
	umult	#8		;R0 <--- Y postion*8
	add	r4		;R0 <--- (Xpos*Vhight+Ypos)*8
	add	r0	;*2
	add	r0	;*4
	add	r1
	to	r4		;R4 <-- bitmapbase+(Xpos*Vhight+Ypos)*32+16
	add	#15
	inc	r4
;---------------------------------------------------------------------------
;* data merge main routine
	mcache
	move	r5,r3	;moto address copy
	move	r6,r4	;saki address copy
	from	r2
	umult	#4
	move	r7,r0	;tugino tate chara no addr (screen hight *8*4)
	move	r10,#5	;yoko chara no kazu
.mergebigloop
	move	r9,#4	;tate chara no kazu
.mergeloop
	move	r12,#8	;loop counter (1chara under 2 bit data)
	move	r13,pc	;loop start
	ldw	[r5]
	inc	r5
	inc	r5
	stw	[r6]
	inc	r6
	loop
	inc	r6

	move	r12,#16
	with	r5
	add	r12
	with	r6
	add	r12
	dec	r9		;tate chara check
	bne	.mergeloop
	nop

	with	r3
	add	r7
	move	r5,r3		;next slit source address

	with	r4
	add	r7
	move	r6,r4		;next slit dest address

	dec	r10		;yoko chara check
	bne	.mergebigloop
	nop
;---------------------------------------------------------------------------
	jmp	r11
	nop
