;Ŀ
;                                                                    
;                 STARFOX II - REVENGE OF PEPPY -                    
;                                                                    
;Ĵ
;                                                                    
; FILE:         PLAYER.ASM                                           
; AUTHOR:       Dylan Cuthbert & Takumi Kawagoe                      
; DESCRIPTION:  The Player's strategy                                
; DATE CREATED: 16-2-93                                              
;                                                                    
;

; usually using	:al_pbyte2  	transform flags (See talcs.inc)
;		:al_pbyte1	demo(roty buffer)
;		:al_sword1  	distance of view = 0
;		:al_sword2  	HEAP memory
;		:al_pword1	MACRO de tukatteiru!(See TMACROS.INC) time counter(DEMO)
;		:al_stratstate	player's mode
;		:al_ptr		view strat pointer(=viewblk1 or 2)
;		:al_sbyte2	(Robot no roty offset)
;		:sflag6		dragon ga kannda
;		:sflag5		ashioto flag (ROBOT)
;		:sflag4		(for special weapon limitter!)
;		:sflag3		in the sea flag

	INCPUB	player

;arenasize	equ	2000

;
;Ŀ
;LOCAL MACRO to make parts of ROBOT
;

makeRBleg	macro	[name,label]
	pla
	pha
	bit		#exal_jetstatus_{name}alive
	bne		{label}
	jsr		Onfield_robo2.generate{name}
	bcc		{label}
	pla
	ora		#exal_jetstatus_{name}alive
	pha
	endm

;---------------------------------------------------------------------------------------
;ͻ
;Player no inital
;ͼ
	strats_start

	SHORTA
	LONGI

player_init

;Ŀ
;HEAPmemory no initial
;

	s_freeall	x		; release all memory
	s_alloc		x,y,#tarwing_sizeof
	sty		al_sword2,x

;Ŀ
;Heap exalvar no initial
;

	jsr		tarwing_exalvar_init

;Ŀ
;set player's area
;

	pl_set_area	x,-1

;Ŀ
;clear transform flag
;

	pl_clr_transflag	x

;--------------------------------------------------------------------------------------

	s_jmp_alsflag	x,player2,.setplaypt2

;Ŀ
;Player 1 no RAM no initial
;

.setplaypt1	stx		playpt1
	sty		playhpt1

	s_set_alvar	B,y,exal_PILOTNo,p1_PILOTNo
	s_set_alvar	B,x,al_HP,#1
	s_set_alvar	B,y,exal_HP,p1_HP
	s_set_alvar	B,y,KHP,p1_HP

	a16

	lda	kw_totalscore1
	sta	kscore,y
	lda	kw_totalscore1+1
	sta	kscore+1,y

	lda	#0
	sta	p1_worldx_init
	sta	p1_worldy_init
	sta	p1_worldz_init
	a8
	sta	p1_roty_init
	jmp	.con

;Ŀ
;Player 2 no RAM no initial
;

.setplaypt2	stx		playpt2
	sty		playhpt2

	s_set_alvar	B,y,exal_PILOTNo,p2_PILOTNo
	s_set_alvar	B,x,al_HP,#1
	s_set_alvar	B,y,exal_HP,p2_HP
	s_set_alvar	B,y,KHP,p2_HP

	a16

	lda	kw_totalscore2
	sta	kscore,y
	lda	kw_totalscore2+1
	sta	kscore+1,y

	lda	#0
	sta	p2_worldx_init
	sta	p2_worldy_init
	sta	p2_worldz_init
	a8
	sta	p2_roty_init

;Ŀ
;alsflag nado no initial
;
.con
	stx	internalplaypt
	stx	viewpt
	stx	viewtoobj

	s_init_anim	x,#0
	s_set_alvar	B,x,al_ap,#playerAP

	s_setnoremove_behind	x
	s_set_alsflag	x,sameshapecollide
	s_set_alsflag	x,shadow
	s_set_alsflag	x,notslope
	s_set_alsflag	x,noviewcheck

;Ŀ
;DAMAGE METER no initial
;

	pl_DMGMETER_init	x,10

	rts


robotyofstab_Ff	equ	45
robotyofstab_SP	equ	50
robotyofstab_GG	equ	40

robotyofstab
	shapetab	B,robotyofstab_

;
;	PLAYER STRAT START
;
; local macro

BGinitdat	macro	[stratmode,demomode,name]
	dw	{stratmode}&WM
	dw	{name}_Hofs	; H scroll(one screen mode)
	dw	{name}_P1Hofs	; H scroll(two screen mode)
	dw	{name}_P2Hofs	; H scroll(two screen mode)
	dw	{name}_VofsMAX
	dw	{name}_VofsRATE

	IFC	"0","{demomode}"
	dw	0
	ELSEIF
	dw	{demomode}&WM	;strat(demo mode)
	ENDC

	endm

;
;	PLAYER 1&2 MAIN STRAT
;

EXplayer2_istrat

	s_start_strat

	a8i16


	s_set_alsflag	x,player2
	s_set_var	B,p2_gamestatus,#0
	s_set_alvar	W,x,al_ptr,#viewblk2
	s_set_alvar	B,x,al_tx,#2

	jsr		EXplayer_istrat.init

	jsl		initEalt_srou_l

	s_set_strat	x,player_istrat

	s_end_strat


EXplayer_istrat

	s_start_strat

	a8i16

	s_set_var	B,playerctlmode,#0	; clear player control mode

	s_clr_alsflag	x,player2
	s_set_var	B,p1_gamestatus,#0
	s_set_alvar	W,x,al_ptr,#viewblk1
	s_set_alvar	B,x,al_tx,#1

	jsr		EXplayer_istrat.init

	jsl		player_RAMinit_l	; (game)

	jsl		initEalt_srou_l

	s_set_strat	x,player_istrat

	s_end_strat


.init	LOCAL

	s_set_alsflag	x,colldisable
	s_set_aldata	x,#255,#1
	s_set_alptrs	x,player_istrat,hit_istrat,playerexplode_istrat
	jsr		player_init

	rts

;

player_istrat

	s_start_strat

	a8i16

;	lda	demomode
;	printh	demomode,kawagoe
;	lda	demoNo
;	printh	demoNo,kawagoe


; *********

	a16
	lda	#0
	sta	testx
	sta	testy
	sta	testz
	a8

; *********

	lda	demomode
	bne	.demostart

	toheap		y,x

	c_view_inbetween	x,offtrig

;	s_or_alvar	B,y,exal_VIEWflag2,#exal_VIEWflag2_inbetofftrig

	jmp		.start

;---------------------------------------------------------------------------------
; make domo director

.demostart



	jsl	makedirector_srou_l


	IFEQ	1

	s_make_obj	#nullshape,.demo
	s_set_strat	y,path_istrat

	PHY
	PHX

	toheap	y,x

	a16
	lda	demoNo
	and	#0ffh
	cmp	#demodirector_tab_max
	bmi	.ddok
	lda	#0
.ddok	asl	a
	asl	a
	asl	a
	tax

; set chart ptr    **

	lda.l	demodirector_tab+2,x
	sta	exal_chartptr+0,y


	lda.l	demodirector_tab+3,x
	sta	exal_chartptr+1,y
	lda	#0
	sta	exal_charttimer,y

; set path pointer **

	lda.l	demodirector_tab+0,x

	PLX
	PLY

	sta.w	al_sword2,y

	a8

	s_set_aldata	y,#1,#1

	ENDC


	s_set_strat	x,.waitdemoend

	toheap		y,x

	KM_PUSHSNDPLACE

.waitdemoend


	toheap	y,x

	lda	exal_translocktimer,y
	printb	translocktimer,kawagoe
	lda	exal_CTLtype,y
	printb	CTLtype,kawagoe

;	phy
;	ldy	#viewblk1
;	lda.w	al_roty+1,y
;	printh	Vry,kawagoe
;	ply

	km_clrgameflag		keydisable	;[for kawaguchi]

	IFNE	debuginfo

	s_playercontroller


	a16

	lda	#0
	sta	testx
	sta	testy
	sta	testz
	a8

.l	testjoypad	left,pcont
	beq		.r
	s_set_var	W,testx,#-5

.r	testjoypad	right,pcont
	beq		.u
	s_set_var	W,testx,#5

.u	testjoypad	up,pcont
	beq		.d
	s_set_var	W,testz,#5

.d	testjoypad	down,pcont
	beq		.x
	s_set_var	W,testz,#-5

.x	testjoypad	x,pcont
	beq		.b
	s_set_var	W,testy,#-5

.b	testjoypad	b,pcont
	beq		.nnn
	s_set_var	W,testy,#5
.nnn

	a16
	lda	testx
;	printh	testx,kawagoe
	lda	testy
;	printh	testy,kawagoe
	lda	testz
;	printh	testz,kawagoe
	a8

	ENDC


	lda	demomode
	rlbeq	.demoend
.demo
	s_playercontroller

	jsl	timechart_l

	testjoypad	A,ptrig
	beq		.ckrestart

;test	km_setmissionsyori	playerdown


.ckrestart
	pl_ifrestart	.skipdemo
	bra		.exit


.skipdemo	s_set_alvar	W,x,al_worldx,p1_worldx_init
	s_set_alvar	W,x,al_worldy,p1_worldy_init
	s_set_alvar	W,x,al_worldz,p1_worldz_init


	lda	#0
	sta	demomode

	lda	demomapbank
	sta	mapbank

	phx
	ldx	demomapptr
	stx	mapptr
	plx

	toheap		y,x
	c_view_inbetween	x,offtrig
;	s_or_alvar	B,y,exal_VIEWflag2,#exal_VIEWflag2_inbetofftrig
	bra		.demoend

.exit	s_end_strat




.demoend	toheap	y,x

	pl_control	x,on,y

;	pl_oldposrots	x,y

	jsl	set_inbet_l

	KM_PULLSNDPLACE


;

.start	a8i16

	toheap	y,x

	km_clrgameflag		keydisable	;[for kawaguchi]
	km_setmissionflag	parallel	;[for kawaguchi]

	toheap		y,x

	pl_control	x,on,y

	s_set_alsflag	x,active

	s_set_expstrat	x,playerexplode_istrat

	s_clr_alsflag	x,colldisable

	s_clr_alsflag	x,realobj

	s_set_strat	x,PLAYERMAIN.strat


	phy
	s_set_resource	L,x,start_hit,#hitplayer_start
	s_set_resource	L,x,while_hit,#hitplayer_while
	s_set_resource	L,x,end_hit,#hitplayer_end
	ply

	c_set_demoviewstrat	x,off,y

	set_bg_mode	player_ctl_mode,playerctlmode,x,9

;---------------------------------------------------------------------------------

; -- ARWING INIT -- on field

Onfield_Arwing_init

	s_start_strat

	s_clr_alsflag		x,ontheground

	toheap		y,x

	pl_planetmode		ground
	pl_jmpnot_ifexistSEA	.nosea
	lda	seatype
	cmp	#st_magma
	beq	.nosea
	pl_planetmode		marine
.nosea

.pmodeend


;.entry	LOCAL

	toheap		y,x

; umi kara tobidasutoki ha control ha OFF ni suru.

;	pl_jmpnot_ifinthesea	x,.onthesea
;	pl_control_tr		x,off,y

.onthesea

	pl_SHAPEandCTLNo	x,OF_ARWING

	jsr			Arwing0_exalvar_init
	pl_mode_change		x,of_Arwing
	s_clr_alsflag		x,ontheground


Onfield_Arwing

	s_start_strat

	a8i16

	toheap			y,x

.onthesea	c_jmp_viewstratEQ	x,ONFIELD_ARWING,.nosetofawv,y
	c_jmp_ifdemoview	x,.nosetofawv,y
	pl_jmp_iftransrising	x,.nosetofawv,y
	c_view_inbetween	x,on
	c_set_viewstrat		x,ONFIELD_ARWING

.nosetofawv	pl_clr_transflag	x

	s_set_alsflag		x,sflag8	; set permanently inside
	pl_playercontroller	x		; read controller
	pl_set_LASTLRkey


	c_jmp_viewstratEQ	x,ONFIELD_ARWING,.norcx,y
	jsl			RB_CAMROTX_l
.norcx	PL_DO_CTLandVIEW	x,ONFIELD_ARWING





; seadepth no limitter

	jsl	sealimit_view_srou_l

;--------------------------------------------------------------------------------
; limitter of sea(final)
;
;	c_jmp_viewstratNE	x,ONFIELD_ARWING,.los_end
;
;	phy
;	pl_ldy_viewblk	x
;
;	a16
;
;	lda	#-10
;	clc
;	adc	seadepth
;	cmp.w	al_worldy,y
;	bpl	.los
;	sta.w	al_worldy,y
;
;.los	ply
;
;	a8
;
;.los_end
;
;--------------------------------------------------------------------------------





	pl_check_inthesea	x
	pl_set_PILOTshape	x,x,shape_ARWING

.ofaw_entry	LOCAL

	toheap			y,x
	s_or_alvar		B,y,exal_transflag,#exal_transflag_armode_flag

.ofaw_entry_AM	LOCAL

	jsl		tp_checkshoot_l
	jsl		set_hudrot_srou_l

	pl_damage_meter	;arwing_HP,DMETERNUM
	pl_coll_damage	x
	pl_SE_engine	x
	pl_SE_trans	x

	jsl	battle_end_l

	pl_end_strat

;-----------------------------------------------------------------------
; -- ARWING STRAT -- in SPACE2

Cosmo_Arwing_init

	s_start_strat

;	jsl	makefriend_srou_l

	toheap		y,x

	pl_SHAPEandCTLNo	x,CS_ARWING

	jsr			Arwing0_exalvar_init

	pl_planetmode		space

	pl_mode_change		x,cs_Arwing
	c_view_inbetween	x,on

	jsr			cosmo_arwing.setcosmoview

	s_clr_alsflag		x,shadow
	s_clr_alsflag		x,ontheground


Cosmo_Arwing

	s_start_strat

	pl_clr_transflag	x

	s_set_alsflag		x,sflag8	; set permanently inside
	pl_playercontroller	x		; read controller
	pl_set_LASTLRkey
	PL_DO_CTLandVIEW	x,COSMO_ARWING

	pl_set_PILOTshape	x,x,shape_ARWING

	jmp			Onfield_Arwing.ofaw_entry



.setcosmoview	LOCAL
	s_start_strat

	pl_jmpnot_ifturn	x,.SF1view,y
.SF2view	c_set_viewstrat		x,COSMO_ARWING
	bra			.exitcosmoview
.SF1view	c_set_viewstrat		x,ONFIELD_ARWING
.exitcosmoview
	rts


;-----------------------------------------------------------------------
; -- ARMER INIT -- in SPACE
Inspace_Armer_init

	s_start_strat

	toheap		y,x
;CNTOFF	pl_control	x,on,y
	pl_SHAPEandCTLNo	x,ARMER
	jsr			Armer0_exalvar_init

	pl_planetmode		space

	pl_mode_change		x,is_Armer

	s_clr_alsflag		x,shadow
	s_clr_alsflag		x,ontheground


	c_view_inbetween	x,on

; -- ARMER STRAT -- in SPACE

Inspace_Armer

	s_start_strat

	pl_clr_transflag	x

	s_set_alsflag		x,sflag8	; set permanently inside

	jsl	ROBOgottun_srou_l

;---------------------------------------------------------------------------


	a16
	lda	#0
	sta	gd_gravity
	a8
	lda	#1

	jsl	generaldynamics_l


;	a16
;	lda	al_mx,x
;	clc
;	adc	al_worldx,x
;	sta	al_worldx,x
;	lda	al_my,x
;	clc
;	adc	al_worldy,x
;	sta	al_worldy,x
;	lda	al_mz,x
;	clc
;	adc	al_worldz,x
;	sta	al_worldz,x
;	a8




	jsr	set_worldxyz2exal_srou	; copy pos -> exal pos


;---------------------------------------------------------------------------


	pl_playercontroller	x		; read controller

	toheap			y,x

	s_and_alvar		B,y,exal_transflag,#exal_transflag_armode_flag^-1
	pl_set_LASTLRkey
	PL_DO_CTLandVIEW	x,INSPACE_ARMER

	jsl			makeLRarm_srou_l	;generatearm

	pl_set_PILOTshape	x,x,shape_ARMER_BODY

	jmp			Onfield_Arwing.ofaw_entry_AM


;
; -- ROBOT INIT --

Onfield_robo_init

;using	:sflag6	ashioto flag
;	:sflag5 shadow flag(1:shadow on 0:off)
;	:sbyte1 as state (see ROBOANIM_srou.animdriver)
;	:sbyte2 as motion counter (ROBOT no sokudo wo kaetarisuru tame)
;	:sbyte3 leg roty offset (up or down + left or right)

	s_start_strat

	toheap	y,x

	jsr		Robo0_exalvar_init

	pl_planetmode		ground
	pl_jmpnot_ifexistSEA	.nosea
	lda	seatype
	cmp	#st_magma
	beq	.nosea
	pl_planetmode		marine
.nosea

;Ŀ
;Robot no Yoffset no initial
;

	pl_get_shapeTAB	B,x,y1,robotyofstab

	ldy		al_sword2,x
	s_set_alvar	B,y,exal_bodyofsy,y1

	a16
	lda		y1
	sexa
	clc
	adc		exal_worldy,y
	sta		exal_worldy,y
	a8

	pl_SHAPEandCTLNo	x,ROBOT
	pl_mode_change		x,of_robo

	jsr			ROBOT_init_srou

.exitjmp

;	jmp			PLAYERMAIN.strat

;Ŀ
;clear rotz parameters
;

	toheap	y,x

;Ŀ
;clear vector
;

	a16
	lda	#0
	sta	al_vy,x

	sta	work_mx
	sta	work_mz

	a8

	s_clr_alsflag	x,ontheground

;-----------------------------------------------------------------------
; -- ROBOT STRAT --

Onfield_robo

	s_start_strat

	pl_clr_transflag	x

	s_set_alsflag		x,sflag8	; set permanently inside

.setview	toheap	y,x

	c_jmp_viewstratEQ	x,ONFIELD_ROBO,.noset,y
	c_view_inbetween	x,on
	c_set_viewstrat		x,ONFIELD_ROBO

.noset

	lda		exal_jetstatus,y
	and		#exal_jetstatus_ALL
	cmp		#exal_jetstatus_ALL
	beq		.make_OK

.domake	lda		exal_jetstatus,y
	pha


.makeLleg0	makeRBleg	legL0,.makeRleg0
.makeRleg0	makeRBleg	legR0,.makeLlegEND
.makeLlegEND


	ldy		al_sword2,x
	pla
	sta		exal_jetstatus,y

.make_OK

;CNTOFF	pl_control		x,on,y

;----------------------------------------------------------------------------

	toheap		y,x

	lda		exal_jetstatus,y
	and		#exal_jetstatus_ALL

	cmp		#exal_jetstatus_ALL
	rlbne		.nochangemode

	pl_set_PILOTshape	x,x,shape_ROBOT_HEAD

	pl_mode_change		x,of_robo2

.nochangemode
;----------------------------------------------------------------------------

onfield_robo2

	toheap	y,x

;	lda		exal_jetstatus,y
;	and		#exal_jetstatus_ALL
;	cmp		#exal_jetstatus_ALL
;	rlbne		.nosetshape
;
;	pl_set_PILOTshape	x,x,shape_ROBOT_HEAD
;.nosetshape
;----------------------------------------------------------------------------

	pl_playercontroller	x		; read controller

;----------------------------------------------------------------------------

;Ŀ
; GENERAL DYNAMICS   
;

	jsl	RB_generaldynamics_l

;----------------------------------------------------------------------------

	jsl	makeshadow_srou_l

;---------------------------------------------------------------------------------------------------
; shape ni notte itara shadow ha off ni suru..

	pl_jmpnot_ifinthesea	x,.scam
	pl_jmpnot_ifcaminthesea	x,.shadowoff,y
.scam
	pl_jmp_ZENBUinpool	x,.shadowon
	rb_jmp_ifonshape	x,.shadowoff

.shadowon	s_set_alsflag		x,shadow
	bra			.shadow
.shadowoff	s_clr_alsflag		x,shadow
.shadow

;----------------------------------------------------------------------------
;
;	pl_playercontroller	x		; read controller
;
;----------------------------------------------------------------------------

	pl_check_inthesea	x

;	pl_playercontroller	x		; read controller

;	pl_hpadd		x

	s_and_alvar		B,y,exal_transflag,#exal_transflag_armode_flag^-1

	pl_set_LASTLRkey
	jsl			RB_CAMROTX_l
	PL_DO_CTLandVIEW	x,ONFIELD_ROBO

;----------------------------------------------------------------------------
;camera angle

	jsl		tp_checkshoot_l

	jsl		set_hudrot_srou_l

	pl_damage_meter	;robot_HP,DMETERNUM

	pl_coll_damage	x

	pl_SE_engine	x
	pl_SE_trans	x

;;;	jsl	entersea_srou_l

	pl_end_strat

;-----------------------------------------------------------------------------------
; --- make legs ROBOT ---

.generatelegL0	LOCAL

	jsr	.generate_do
	rlbcc	.generatebodyNG

	s_set_strat		y,RBlegL_Istrat

	s_push_obj		y
	toheap	y,x
	s_set_alvar		W,y,exal_jetLobjptr,tpy
	s_pull_obj		y

	s_neg_alvar		W,y,al_childx

	jmp			.generateleg

.generatelegR0	LOCAL

	jsr	.generate_do
	bcc	.generatebodyNG

	s_set_strat		y,RBlegR_Istrat

	s_push_obj		y
	toheap	y,x
	s_set_alvar		W,y,exal_jetRobjptr,tpy
	s_pull_obj		y

	jmp			.generateleg

.generateleg

	s_set_colltype		y,FRIEND

	s_set_collstrat		y,hit_istrat
	s_set_expstrat		y,explode_istrat

	s_set_aldata		y,#ROBOTleg_HP,#ROBOTleg_AP

	s_jmp_alsflag	x,player2,.gbend

	s_set_alsflag	y,player2
	s_set_alsflag	y,sflag10
	s_set_alsflag	y,nohitaffect

.gbend	sec
	rts

.generatebodyNG

	clc
	rts

;-----------------------------------------------------------------------------------

.generate_do

	pl_get_shapeTAB_ST	W,x,x1,RBleg_xofstab
	pgst_END		W,x,y1,RBleg_yofstab

	s_make_childobjrotpos	#nullshape,childno_legLR,x1,y1,#0,#0,#0,#0,path_istrat
	cpy	#0
	beq	.failed
	sty	tpy
	sec
	rts

.failed	clc
	rts

;
;-----------------------------------------------------------------------
ROBOT_init_srou

	s_start_strat

	PHY

	ldy		al_sword2,x
	s_set_alvar	W,y,exal_animptr,#abt_RBstopping&WM
	s_set_alvar	W,y,exal_animptrNEXT,#abt_RBstopping&WM

	lda	#0
	sta	exal_motionNo,y
	rb_set_motioncounter	x,#0
;	s_init_anim		x,#3

;	s_clr_alsflag		x,shadow
	s_clr_alsflag		x,sflag6	;ashioto flag
	s_clr_alsflag		x,sflag5	;shadow flag

	lda		#0
	sta		al_sbyte1,x
	sta		al_sbyte2,x
	sta		al_sbyte3,x	; leg roty offset

	s_jmp_alsflag	x,player2,.okip2

.okip1	s_set_var	B,p1_legflag,#0
	bra		.okipp
.okip2	s_set_var	B,p2_legflag,#0
.okipp
	ldy		al_sword2,x
.exitjmp



	PLY

	rts

;    ͻ
;                                                              
;               STRATS FOR PLAYER'S TRANSFORMATIONS            
;                                                              
;    ͼ

; -- ARWING>>ROBO INIT --

Aw2Rb_init
	s_start_strat

	toheap		y,x
	jsr			TRANSFORM_srous.init

	t_tranim_init		x,TRanmAW2RB_TAB
	pl_mode_change		x,Tr_aw2rb

	pl_get_pilotTAB		B,x,x1,speed_tab
	s_jmp_alvarLESS		B,x,al_vel,x1,.nodown
	s_set_speed		x,x1

.nodown
	s_clr_alsflag		x,ontheground

;CNTOFF	pl_control		x,on,y

;-----------------------------------------------------------------------
;Ŀ
; umi no ue de robot ni henkei sitaka CHECK suru. 
;

	toheap	y,x

	pl_clr_transfalling	x,y
	pl_clr_transrising	x,y

	pl_test_planetmode	marine
	bne			.tf_g

.tf_m	pl_jmp_ifinthesea	x,Aw2Rb
	pl_set_transfalling	x,y
	bra			Aw2Rb
.tf_g	pl_set_transfalling_g	x,y

;-----------------------------------------------------------------------
; -- ARWING>>ROBO STRAT --

Aw2Rb
	s_start_strat


;	toheap	y,x
;	lda	exal_status,y
;	printb	EXAL_STATUS,kawagoe


;	vofsoff		1

	pl_set_transflag	x

	s_set_alsflag		x,sflag8	; set permanently inside
	pl_playercontroller	x		; read controller
;	pl_hpadd		x
	PL_DO_CTLandVIEW	x,Trans_AW2RB

	jsl	sealimit_view_srou_l

	s_achase_alvar		B,x,al_vel,#0,3

	jmp	TRANSFORM_pros

;
; -- ROBO>>ARWING INIT --
Rb2Aw_init
	s_start_strat

	jsr	RBlegbodynullshape
	jsr	TRANSFORM_srous.init
	jsr	Arwing0_exalvar_init

	t_tranim_init		x,TRanmRB2AW_TAB

	pl_mode_change		x,Tr_Rb2aw

	s_clr_alsflag		x,ontheground

;CNTOFF	pl_control		x,on

;-----------------------------------------------------------------------
;Ŀ
; umi no naka de arwing ni henkei sitaka CHECK suru.
;

	toheap			y,x

	pl_clr_transrising	x,y
	pl_clr_transfalling	x,y

	s_jmp_varZERO		W,SEADEPTH,Rb2Aw

	pl_jmpnot_ifinthesea	x,Rb2Aw

	pl_set_transrising	x,y

;-----------------------------------------------------------------------

; -- ROBO>>ARWING STRAT --
Rb2Aw	; Kawagoe's Arwing
	s_start_strat
	pl_set_transflag	x
	s_set_alsflag		x,sflag8	; set permanently inside

	pl_set_transflag	x

	pl_playercontroller	x
	PL_DO_CTLandVIEW	x,Trans_RB2AW
	pl_check_inthesea	x

	jmp	Am2Aw.enter

;
; -- ARWING>>ARMER INIT --

Aw2Am_init
	s_start_strat

	jsr			TRANSFORM_srous.init
	jsr			Armer0_exalvar_init

	t_tranim_init		x,TRanmAW2AM_TAB
	pl_mode_change		x,Tr_Aw2Am

	s_clr_alsflag		x,ontheground

;CNTOFF	pl_control		x,on

;-----------------------------------------------------------------------
; -- ARWING>>ROBO STRAT --
Aw2Am
	s_start_strat

	pl_set_transflag	x

	s_set_alsflag		x,sflag8	; set permanently inside

;	pl_hpadd		x
	PL_DO_CTLandVIEW	x,Trans_AW2AM

	jmp	TRANSFORM_pros

;
; -- ROBO>>ARWING INIT --
Am2Aw_init
	s_start_strat
	jsr			RBlegbodynullshape

;	km_setflag		exal_transflag,exal_transflag_transform_flag,x

	jsr	TRANSFORM_srous.init
	jsr	Arwing0_exalvar_init

	t_tranim_init		x,TRanmAM2AW_TAB

	pl_mode_change		x,Tr_Am2aw

	s_clr_alsflag		x,ontheground

;CNTOFF	pl_control		x,on

;-----------------------------------------------------------------------
; -- ROBO>>ARWING STRAT --
Am2Aw	; Kawagoe's Arwing

	s_start_strat

	pl_set_transflag	x

	s_set_alsflag		x,sflag8	; set permanently inside
;	pl_hpadd		x
	PL_DO_CTLandVIEW	x,TRANS_AM2AW



.enter	LOCAL

	toheap	y,x
	s_copy_alvar2alvar	W,y,exal_camYcenter,y,exal_worldy
	s_set_alvar		W,y,exal_camYofs,#0


	jmp	TRANSFORM_pros

;
TRANSFORM_srous

.init	LOCAL

	s_start_strat

	s_or_alvar		B,y,exal_transflag,#exal_transflag_transform_flag

;	lda		al_sbyte2,x
;	eor		#armode_flag
;	sta		al_sbyte2,x


;CNTOFF	pl_control		x,on
	c_view_inbetween	x,on
	s_set_alsflag		x,shadow
	pl_set_timer		x,#0

	rts
;
TRANSFORM_pros

	s_start_strat

	pl_check_inthesea	x
	pl_damage_meter	;armer_HP,DMETERNUM
	pl_coll_damage		x
	pl_SE_engine		x
	pl_SE_trans		x
	jsl	set_hudrot_srou_l
	jsr	set_worldxyz2exal_srou

	pl_end_strat

;
;Ŀ
;ROBOT no shape wo nullshape ni suru.
;

RBlegbodynullshape

	s_start_strat

	PUSHXYP
	a8i16

	ldy	al_sword2,x

	a16
	lda	#nullshape

.R	ldx	exal_jetRobjptr,y
	beq	.L
	sta	al_shape,x

.L	ldx	exal_jetLobjptr,y
	beq	.B
	sta	al_shape,x

.B	;ldx	exal_bodyobjptr,y
	;beq	.exit

	;sta	al_shape,x
.exit
	a8

	PULLXYP
	rts


;
;    ͻ
;                                                              
;               STRATS FOR PLAYER'S DEMONSTRASION              
;                                                              
;    ͼ


;
;DEMO_AWCLEAR_0_0_init
;
;	s_start_strat
;
;	toheap	y,x
;
;	jsr		DEMO_srou.istrat
;	sp_trans_do	x,OF_ARWING,y
;	pl_mode_change	x,DM_AWC_0_0
;
;-----------------------------------------------------------------------
;DEMO_AWCLEAR_0_0
;
;	s_start_strat
;	a8i16
;	PL_DO_CTLandVIEW	x,DEMO_AWCLEAR_0_0
;	pl_SE_engine	x
;	pl_SE_trans	x
;
;	pl_end_strat
;
;-----------------------------------------------------------------------
;DEMO_AWCLEAR_0_1
;
;	s_start_strat
;	a8i16
;	PL_DO_CTLandVIEW	x,DEMO_AWCLEAR_0_1
;	pl_SE_engine	x
;	pl_end_strat
;
;


	IFEQ	1
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
DEMO_BATTLESTART_0_1_init
	s_start_strat
	toheap	y,x
	jsr			Arwing0_exalvar_init
	jsr			DEMO_srou
	pl_SHAPEandCTLNo	x,CS_ARWING
	jsr			cosmo_arwing0.setcosmoview
	c_set_demoviewstrat	x,gamestart,y
	ct_set_chartptr		x,battlestart2
	bra			DEMO_BATTLESTART_0_0_init.enter
DEMO_BATTLESTART_0_0_init
	s_start_strat
	toheap	y,x
	jsr			Arwing0_exalvar_init
	jsr			DEMO_srou
	pl_SHAPEandCTLNo	x,OF_ARWING
	pl_planetmode		ground
	c_set_viewstrat		x,ONFIELD_ARWING
	c_set_demoviewstrat	x,gamestart,y
	ct_set_chartptr		x,battlestart
.enter	LOCAL
	pl_mode_change		x,DM_BS_0_0
	s_set_var		W,DDtest,#-250
;	pl_set_PILOTshape	x,x,shape_ARWING
;-----------------------------------------------------------------------------
; set pos
;	s_add_roffs2pos	B,x,x,x,#-05fH,#-063H,#-05fH,0,1,0,3,4,3
	s_add_roffs2pos	B,x,x,x,#-5fH,#-63H,#-5fH,0,1,0,3,4,3
	s_add_alvar	W,y,exal_roty,#-(deg90*256)
	s_add_alvar	B,x,al_roty,#-deg90
	s_set_alvar	W,y,exal_rotx,#(deg90*256)
	s_set_alvar	B,x,al_rotx,#deg90
	s_set_alvar	B,x,al_rotz,#deg45
DEMO_BATTLESTART_0_0
	s_start_strat
	a8i16
	toheap	y,x
	PL_DO_CTLandVIEW	x,DEMO_BATTLESTART_0_0
	pl_damage_meter	;arwing_HP,DMETERNUM
;	lda	al_roty,x
;	printh	ROTY,kawagoe
	pl_end_strat
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	ENDC


;

DEMO_srou
.istrat	LOCAL

	s_start_strat

	PHY

;CNTOFF	pl_control		x,off
	s_set_alsflag		x,nohitaffect
	s_set_alsflag		x,sflag8		; set permanently inside

	s_set_alvar		B,x,al_pbyte1,#0	; demo state
	pl_set_timer		x,#0		;macro	[obj,value]
;	s_set_alvar		B,x,al_pword1,#0	; demo time counter

	c_cockpitmode		x,off
	pl_Sboost		x,off

	pl_set_area		x,-1

	pl_ldy_viewblk		x
	s_set_state		y,#0		 ;state

	PLY

	rts

;

	ifeq	1

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

;kdmgflag	equ	$80
;kdmgwinflag	equ	$40
;kdmgallflag	equ	$c0
;DmgIntTm	equ	5

kawaguchi_hit

	PUSHXYP

	a8i16

;	pl_coll_damage	x	;,20,#scrshock

;	jsl	Check_KGWindow_l

;	ifeq	1

	ldy	al_sword2,x
	jmp	.noflag

;-------------------------------------------------------------

	ldy	al_sword2,x
	jmpnotflag	kgbyte5,#kBomShotflag,.NoBom,y

	lda	kgbyte5,y
;	and	#~kBomShotflag
	and	#~$80
	dec	a
	bpl	.Timerset
	beq	.Timerset
	lda	#0
	sta	kgbyte5,y
	bra	.NoBom
.Timerset
	ora	#kBomShotflag
	sta	kgbyte5,y
.NoBom
;-------------------------------------------------------------
;*	Wepon damage check
;-------------------------------------------------------------
;----- Damage window check --
	jmpnotflag	kgbyte6,#kdmgwinflag,.NoFlag,y
;----- Window timer set -----


	lda	kgbyte6,y
	and	#~kdmgallflag
	dec	a
	bmi	.DMGwinEnd
	ora	#kdmgwinflag
	sta	kgbyte6,y
	bra	.Noflag
.DMGwinEnd
	lda	#0
	sta	kgbyte6,y	;Timer Dec

;	endc
;--------------------------------------------------------------------
.NoFlag
	a8i16
;----- Hit check -----
	s_jmpNOT_alsflag x,collide,.exit

;	s_jmp_ifhitby	x,ENEMYWEAP,.hit
;	jmp	.exit

;----- hit damage ----
.hit

	lda	#DmgIntTm
	ora	#kdmgallflag
	sta	kgbyte6,y

;	c_shock_cam		x,#scrshock
;	pl_nohittimer		x,30

;-------------------------------------------------------------
.exit

	PULLXYP

	rts

;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	endc

;
;	Calcurate vector & add
;

gen3dvecs_add_l
	s_start_strat

	PHP
	s_gen_3Dvecs		x,al_roty,al_rotx,al_vel
	s_add_vecs2pos		x
	PLP

	rtl

;
;	Calcurate Robot's vector
;

	LONGI
	SHORTA

RB_gen3dvecs_l

;	in tpy : roty

	PUSHXYP

	s_start_strat

	a8i16

;Ŀ
;Calc vector
;

	ldy		dummyobj
	s_set_alvar	W,y,al_worldx,#0
	s_set_alvar	W,y,al_worldz,#0
	s_set_alvar	B,y,al_roty,tpy

	s_add_roffs2pos	B,y,y,y,x1,y1,z1,0,1,0

;Ŀ
;add al_mx,al_mz
;

	s_add_alvars	W,x,al_mx,y,al_worldx
	s_add_alvars	W,x,al_mz,y,al_worldz

	s_add_alvar	W,x,al_mx,work_mx
	s_add_alvar	W,x,al_mz,work_mz

.exit
	PULLXYP

	rtl

;
;	Sound routine (use macro!)
;
pl_SE_Robowalk_l

	s_start_strat

;	in	idx	:player pointer

	PUSHXYP

	s_jmpNOT_alsflag	x,ontheground,.exit

	pl_jmp_KAOinpool	x,.kaoinpool

	pl_jmp_ASHIinpool	x,.inthesea

	pl_jmpNOT_ifinthesea	x,.ontheground

;Ŀ
;walk in the sea
;
.inthesea
;	s_jmpNOT_alsflag	x,ontheground,.exit

	kplsound		x,waterwalk
	jmp	.exit

;Ŀ
;walk in the pool
;
.kaoinpool
	s_jmp_alsflag		x,player2,.kpp2
	kplsound		x,Robowalkinsea1
	jmp			.exit
.kpp2	kplsound		x,Robowalkinsea2
	jmp	.exit

;Ŀ
;walk on the ground
;
.ontheground
;	s_jmpNOT_alsflag	x,ontheground,.exit

	s_jmp_alsflag		x,player2,.ogp2
	kplsound		x,Robowalk1
	jmp			.exit
.ogp2	kplsound		x,Robowalk2

.exit
	PULLXYP

	rtl
;
;	Sound routine (use macro!)
;
pl_SE_Roboswim_l

	s_start_strat

;	in	idx	:player pointer

	PHP

	kplsound		x,Roboswim

	PLP

	rtl

;
;	Sound routine (use macro!)
;
pl_SE_transEND_l

	s_start_strat

	PUSHYP

	a8i16

	toheap	y,x

	lda	exal_transENDse,y
	bit	#exal_transENDse_mask
	rlbeq	.exit
	dec	a
	sta	exal_transENDse,y
.SE
	bit	#exal_transENDse_RB
	bne	.RBse

.AWse	and	#exal_transENDse_mask
	cmp	#exal_transENDse_mask-2
	bne	.exit

	lda	exal_transENDse,y
	and	#exal_transENDse_notEND^-1
	sta	exal_transENDse,y

	kplsound	x,transArwing2Roboend

	bra		.exit

.RBse	and		#exal_transENDse_mask
	cmp		#exal_transENDse_mask-2
	bne		.cksea
	kplsound	x,transRobo2Arwingend

	lda	exal_transENDse,y
	and	#exal_transENDse_notEND^-1
	sta	exal_transENDse,y

.cksea	pl_jmpnot_ifinthesea	x,.exit

	lda		exal_transENDse,y
	and		#exal_transENDse_mask
	cmp		#exal_transENDse_mask-8
	bne		.exit
	kplsound	x,ob_up_to_the_sky

.exit	PULLYP

	rtl


;
;	Set last L R key flag
;

setlastLRflag_srou_l

	strats_start

;exal_control exal_control_lastLR
;
	PHY

	ldy	al_sword2,x

.skip1	testjoypad	tright,ptrig
	beq	.skip
	lda	exal_lastLR,y
	ora	#exal_lastLR_lastLR
	bra	.exit0
.skip
	testjoypad	tleft,ptrig
	beq	.exit1
	lda	exal_lastLR,y
	and	#exal_lastLR_lastLR^-1
.exit0	sta	exal_lastLR,y
.exit1

; -- set LRtrig --



.LR	lda	exal_lastLR,y
	and	#(exal_lastLR_L!exal_lastLR_R)^-1
	sta	exal_lastLR,y


	lda	pcont
	and	#%00110000
	beq	.nokey
	cmp	#%00110000
	beq	.check
	bit	#%00100000	;l
	bne	.left
	bra	.right


.check	lda	exal_lastLR,y
	bit	#exal_lastLR_lastLR
	bne	.lastright

.lastleft	testjoypad	tleft,pcont
	beq	.nokey
.left	lda	exal_lastLR,y
	ora	#exal_lastLR_L
	bra	.setLR

.lastright	testjoypad	tright,pcont
	beq	.nokey
.right	lda	exal_lastLR,y
	ora	#exal_lastLR_R
.setLR	sta	exal_lastLR,y

.nokey
	PLY

	rtl

	strats_end


;
;	player HP add
;
	SHORTA
	LONGI

player_hpadd_l

	PUSHYP

	a8i16

	toheap	y,x

	s_jmp_alvarEQ	B,y,exal_HP,#player_HP,.exit

	s_jmp_alsflag	x,player2,.p2

.p1	lda	player1_hpadd
	stz	player1_hpadd
	bra	.add

.p2	lda	player2_hpadd
	stz	player2_hpadd
.add	beq	.exit

	clc
	adc	exal_hp,y
	cmp	#player_HP
	bcc	.set
	lda	#player_HP
.set	sta	exal_hp,y



.exit	PULLYP

	rtl

;
;
;
;	idX	:player's pointer
;	out	:idX pilotNo * 2

get_pilotNotoidx_B_l

	php

	ai16

	phy

	toheap	y,x

	lda	exal_pilotNo,y
	and	#exal_pilotNo_plmask
	cmp	#max_ep_PLAYER+1
	bcc	.skip0

	lda	#0

.skip0	ply

	tax

	plp

	rtl



get_pilotNotoidx_W_l	;This one! Check.

	php

	ai16

	jsl	get_pilotNotoidx_B_l

	txa
	asl	a
	tax

	plp

	rtl


get_shapeNotoidx_W_l

	php

	ai16

	jsl	get_pilotNotoidx_B_l

	txa
	and	#1^-1

	tax

	plp

	rtl


get_shapeNotoidx_B_l

	php

	ai16

	jsl	get_pilotNotoidx_B_l

	txa
	lsr	a

	tax

	plp

	rtl


;
;	SPECIAL WEAPON no kazu no SET
;
;	use macro "incspweapnum" See tmacro.inc

addspweapnum_srou_l

;	in	x1: add value

	s_start_strat

	PUSHXYP

	a8i16

	toheap	y,x

	lda	exal_spweap_LMT,y
	and	#pX_spweap_LMT_LMT	;mask
	cmp	#pX_spweap_LMT_num
	bcs	.full

	clc
	adc	x1
	cmp	#pX_spweap_LMT_num
	bcc	.set
	lda	#pX_spweap_LMT_num
.set	and	#pX_spweap_LMT_LMT	;mask
	sta	x2

	lda	exal_spweap_LMT,y
	and	#pX_spweap_LMT_LMT^-1	;mask
	ora	x2
	sta	exal_spweap_LMT,y


.ok	PULLXYP
	clc
	rtl

.full	PULLXYP
	sec
	rtl




;-----------------------------------------------------------------------------
incspweappnt_srou_l

;	out	x1:number of current counter

	PUSHXYP

	a8i16

	ldy	al_sword2,x
	lda	exal_spweap_LMT,y
	jsr	PXISW_SROU.setx1
	jsr	PXISW_SROU.add
	sta	exal_spweap_LMT,y

	PULLXYP

	rtl


PXISW_SROU
.setx1	LOCAL

	pha
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	and	#pX_spweap_LMT_PNT>>4	;mask
	sta	x1
	pla
	rts

.add	LOCAL
	pha
	and	#%00001111
	sta	x2
	pla
	and	#%11110000
	clc
	adc	#%10000
	cmp	#(pX_spweap_LMT_PNTmax+1)<<4
	bcc	.sta
	lda	#0
.sta	ora	x2
	rts

;-----------------------------------------------------------------------------
; SPWEAP pointer wo GET suru. use macro!

getspweappnt_srou_l

;	out	x1:pointer

	PUSHXYP

	a8i16

	ldy	al_sword2,x
	lda	exal_spweap_LMT,y
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	and	#%1111	;pX_spweap_LMT_PNT>>4	;mask
	sta	x1

	PULLXYP

	rtl

;
;syo-totsu sita tokino CAMERA no sindou,muteki FLAG wo SET suru.
;SOUND mo SET suru.
;

colldamage_srou_l

	phy

	ldy	al_sword2,x
	pl_nohittimer_dec	x
	s_achase_alvar	B,y,exal_rotzhit,#0,3

	ply

	rtl


;
;player no nohit counter wo decriment suru.....
;


decnohit_srou_l

	s_start_strat

	PUSHYP

	a8i16

	toheap	y,x

;---------------------------------------------------------------------
; nohit flag
	lda		exal_nohit,y
	and		#exal_nohit_mask
	beq		.skip

	s_jmpNOT_varAND	B,gameframe,#3,.noflash
	s_set_alsflag	x,hitflash

.noflash
	lda		exal_nohit,y
	pha
	and		#exal_nohit_mask^-1
	sta		exal_nohit,y
	pla
	dec		a
	ora		exal_nohit,y
	sta		exal_nohit,y
	beq		.skip

.skip3	s_set_alsflag	x,nohitaffect
	s_set_alsflag	x,colldisable
	bra		.skip1
.skip
	s_clr_alsflag	x,nohitaffect
	s_clr_alsflag	x,colldisable
.skip1

;---------------------------------------------------------------------
; trans rising no toki, nohitaffect wo set suru....

	km_jmpgameflag	freeze,.setals

	lda	exal_nohitRISE,y
	and	#exal_nohitRISE_mask
	beq	.ckrise

	dec	a
	sta	tpx
	lda	exal_nohitRISE,y
	and	#exal_nohitRISE_mask^-1
	ora	tpx
	sta	exal_nohitRISE,y

	bra	.setals

.ckrise	pl_jmpnot_iftransrising	x,.norise,y

	s_set_alvar	B,y,exal_nohitRISE,#exal_nohitRISE_mask

.setals	s_set_alsflag	x,nohitaffect

.norise
;---------------------------------------------------------------------


	PULLYP

	rtl



	IFEQ	1
;
;	screen flash wo set suru(use path macro).
;
addcol_path_srou_l

aps_playpt	equ	work9	; player pointer
aps_objpt	equ	work8	; corrent pointer
aps_viewpt	equ	work7	; view pointer

	s_start_strat

	PUSHXYP

	a8i16

.p1screen	ldx	playpt1

	jsr	.set

	sm_jmp_if1screen	.exit

;	test_screenmode	onescreen
;	beq		.exit

.p2screen	ldx	playpt2

	jsr	.set

.exit	PULLXYP


	rtl


.set

	IFEQ	1

	sty	aps_playpt	; player pointer
	pl_ldy_viewblk	y
	sty	aps_viewpt	; view pointer
	ldx	dummyobj
	a16
	lda.w	al_worldx,y
	sta	al_worldx,x
	lda.w	al_worldy,y
	sta	al_worldy,x
	lda.w	al_worldz,y
	sta	al_worldz,x
	a8
	ldy			aps_objpt
	s_obj2obj_3Dangle	x,y,al_roty,al_rotx,0
	ldx	aps_viewpt
	lda	al_roty+1,x
	nega
	sec
	sbc.w	al_roty,y
;	printh	APS_ROTY,kawagoe
	clc
	adc	#40h
	rlbpl	.noset
	lda	al_rotx+1,x
	nega
	sec
	sbc.w	al_rotx,y
;	printh	APS_ROTX,kawagoe
	ldy	aps_playpt

	ENDC

	toheap	y,x

	c_addcol_cam	x,explode,4,off,y

.noset
	rts

	ENDC

;
;	Sound routine(use macro!)
;

; FLAG LIST

RB_engine_MASK	equ	%01101100
RB_engine_echo	equ	%01000000
RB_engine_start	equ	%00100100
RB_engine_LV1	equ	%00101000
RB_engine_LV2	equ	%00101100
RB_engine_stop	equ	%10000000

AW_engine_MASK	equ	%01101100
AW_engine_start	equ	%00000100
AW_engine_speedup	equ	%00001000

AW_engine_speeddown	equ	%00001100
AW_engine_stop	equ	%10000000

AW_engine_horiMASK	equ	%00010011
AW_engine_horiLV0	equ	%00000000
AW_engine_horiLV1	equ	%00000001
AW_engine_horiLV2	equ	%00000010
AW_engine_horiLV3	equ	%00000011

AM_engine_MASK	equ	%00111100
AM_engine_start	equ	%00000000	;%00100100
AM_engine_stop	equ	%00000000
AM_engine_barner	equ	%00101100
AM_engine_armroll	equ	%00110100


	SHORTA
	LONGI

ps_engine_start_l

;	using	:work0
;		:work1

	phx
	phy
	php

	a8i16

; --- start ---
.startpros
	; mission mode or battle mode?

	s_jmp_alsflag	x,player2,.p2engine


.p1engine	s_set_var	B,work0,sdport1
	jsr		.mainpros

	s_set_var	B,sdport1,work0
	bra		.exitengine

.p2engine	sm_jmp_if1screen	.exitengine

	s_set_var	B,work0,sdport2
	jsr		.mainpros
	s_set_var	B,sdport2,work0

.exitengine

	plp
	ply
	plx
	rtl




.mainpros
;	In	:work0(=sdport1 or sdport2)
;	Out	:work0

;Ŀ
;player dead?
;

	;pl_jmp_ifplayerHP0	x,.AWstop

;Ŀ
;kisyu ni yoru bunki
;

	sp_jmp_playertype	x,UFO,.AM
	sp_jmp_playertype	x,ROBOT,.RB

.AW
	pl_jmp_iftransrising	x,.AWstop

	pl_jmpnot_iftransform	x,.AWdo

.AWstop	s_and_var	B,work0,#AW_engine_stop

	jmp		.AWexit

.AWdo

;-- engine level --


	toheap	y,x

	s_and_var	B,work0,#AW_engine_MASK^-1

.AWlv	;speed

	pl_jmp_ifboost	x,.AWlvUP
	pl_jmp_ifbrake	x,.AWlvDW,y

.AWlv1	s_or_var	B,work0,#AW_engine_start
	bra	.exitAWlv
.AWlvUP	s_or_var	B,work0,#AW_engine_speedup
	bra	.exitAWlv
.AWlvDW	s_or_var	B,work0,#AW_engine_speeddown

.exitAWlv

;--------------------------------------------------------------------------------
.AWhoriLV

	s_AND_var		B,work0,#AW_engine_horiMASK^-1

;-- sui-hei kasoku & jyo-syo ka-kou --

	s_copy_alvar2var	W,x,y1,al_vy

	pl_abs_var		W,y1

	s_set_var		B,x1+1,#0
	pl_get_pilotTAB		B,x,x1+0,speed_tab
	lsr	x1
	lsr	x1
	lsr	x1
	s_jmp_varLESS		W,y1,x1,.nnn

	s_or_var		B,work0,#%00010000

.nnn

;HORI-- -- -- -- --

.AWHORI
	s_copy_alvar2var	W,y,work1,exal_acclroty
	s_jmp_varPL		W,work1,.AWhorilvPL
	s_neg_var		W,work1

.AWhorilvPL
	pl_jmp_ifrollstart	x,.AWh3

	s_jmp_varMORE	W,work1,#rotyacclBRAKE,.AWh3
	s_jmp_varMORE	W,work1,#rotyacclLR,.AWh2
	s_jmp_varMORE	W,work1,#rotyaccl,.AWh1
	bra		.AWexit

.AWh1	s_or_var	B,work0,#AW_engine_horiLV1
	bra		.AWexit
.AWh2	s_or_var	B,work0,#AW_engine_horiLV2
	bra		.AWexit
.AWh3	s_or_var	B,work0,#AW_engine_horiLV3
	bra		.AWexit




.AWexit
	pl_jmpnot_iftransrising	x,.exitmainpros,y

	s_or_var	B,work0,#RB_engine_echo
	jmp		.exitmainpros

;--------------------------------------------------------------------------------

.RB

;;;	s_and_var		B,work0,#RB_engine_MASK^-1

	toheap		y,x


	IFEQ	1

;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	s_jmp_alvarAND		B,x,al_pbyte1,#roboTLTR_flag,.RBLV2
	pl_jmp_iftransform	x,.RBtrans
	s_copy_alvar2var	W,y,x2,exal_motionNo
	lda		x2
; walk F
	cmp	#m_walkF
	beq	.RBlv1
	cmp	#m_walkF1
	beq	.RBlv1
	cmp	#m_walkF2
	beq	.RBlv2
; walk B
	cmp	#m_walkB
	beq	.RBlv1
	cmp	#m_walkB1
	beq	.RBlv1
	cmp	#m_walkB2
	beq	.RBlv2
; walk L
	cmp	#m_walkL
	beq	.RBlv1
	cmp	#m_walkL1
	beq	.RBlv1
	cmp	#m_walkL2
	beq	.RBlv2
; walk R
	cmp	#m_walkR
	beq	.RBlv1
	cmp	#m_walkR1
	beq	.RBlv1
	cmp	#m_walkR2
	beq	.RBlv2
; turn L R
	cmp	#m_turnL
	beq	.RBlv1
	cmp	#m_turnR
	beq	.RBlv1



.RBlv0	lda	#RB_engine_start
	bra	.RBset
.RBlv1	lda	#RB_engine_LV1
	bra	.RBset
.RBlv2	lda	#RB_engine_LV2


.RBset	ora	work0
	sta	work0

	bra	.exitmainpros
.RBstop
.RBtrans
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	ENDC

	s_and_var		B,work0,#RB_engine_stop

	pl_jmpnot_ifinthesea	x,.exitmainpros
	s_or_var		B,work0,#RB_engine_echo
	bra			.exitmainpros


.AM
	pl_jmpNOT_iftransform	x,.AMdo
.AMstop	s_and_var	B,work0,#AM_engine_stop
	jmp		.exitmainpros

.AMdo	s_and_var	B,work0,#AM_engine_MASK^-1
	pl_jet		x,check
	bne		.AMb
.AMn	s_set_var	B,work0,#AM_engine_start
	bra		.AMr
.AMb	s_set_var	B,work0,#AM_engine_barner

.AMr	pl_jmpNOT_ifarmrollsound	x,.AMnoroll,y
	s_or_var	B,work0,#AM_engine_armroll

.AMnoroll

.exitmainpros

.exit

	rts

;
;	READ PLAYER CONTROLLER
;
;	set	ptrig&pcont

playercontroller_srou_l

	s_start_strat

	PUSHYP

	a8i16

	ldy			#0
	sty			pcont
	sty			ptrig

	toheap	y,x

	km_jmpgameflag	freeze,.skip0

	pl_jmp_iftransrising	x,.skip0,y

	s_playercontroller


;AUTOFIRE
;	a16
;	lda	gameframe
;	and	#3
;	bne	.lll
;	lda	pcont
;	ora	#pad_Y
;	sta	pcont
;	lda	ptrig
;	ora	#pad_Y
;	sta	ptrig
;.lll	a8



	sp_jmpnot_playertype	x,ARWING,.cntEND,y

	s_jmp_alsflag	x,player2,.p2
.p1	lda	#player_controltype_1B
	bra	.pp
.p2	lda	#player_controltype_2B
.pp	and	player_controltype
	beq	.cntEND

.cntB	a16
	lda	pcont
	jsr	.swap
	sta	pcont
	lda	ptrig
	jsr	.swap
	sta	ptrig
	a8
.cntEND

	a16
	lda	pcont
	sta	p_pcont
	lda	ptrig
	sta	p_ptrig
	a8

	s_jmp_alvarAND	B,y,exal_control,#exal_control_on,.keyon

.keyoff	a16
	lda	#0
	sta	pcont
	sta	ptrig

.keyon	a16

	lda	exal_key_trig,y
	ora	ptrig
	sta	ptrig

	lda	exal_key_cont,y
	ora	pcont
	sta	pcont

	lda	#0
	sta	exal_key_cont,y
	sta	exal_key_trig,y
	a8

.skip0	PULLYP


	rtl


.swap	LONGA
	LONGI

	pha
	and	#~(pad_up!pad_down)
	sta	x1
	pla
	pha
	and	#pad_down
	asl	a
	sta	x2
	pla
	and	#pad_up
	lsr	a
	ora	x2
	ora	x1
	rts


;
;	CHANGE PLAYER'S MODE
;
modechangesrou_l
	s_start_strat
	s_mode_change		x,x1
	rtl
;
;	RAM initial
;
	SHORTA
	LONGI

player_RAMinit_l	; (game)

	phx
	phy
	php
	a8i16

; key data clear

	s_playercontroller

	a16
	lda	#0
	sta	pcont
	sta	ptrig
	a8


;	lda	#0	;player_controltype_1B!player_controltype_2B
;	sta	player_controltype


; player remain


; 0 clear
;	lda	#3
;	sta	kw_rest


	lda	#0
	sta	demomode
;	sta	demowait

	sta	BOSSstatus

;	sta	exbosstest
;	lda	#1
;	sta	target_remain
;	sta	KEnemyNumber

	lda	#0
	sta	p1_markstatus

;	sta	plrseqflag

	sta	voffsetflag
	sta	player1_hpadd
	sta	player1_hpadd
	sta	p1_status
	sta	p2_status
;	sta	BOSSstatus
;	sta	EYEdis
;	sta	LOOKdis
	sta	sdport1
	sta	sdport2

;	lda	#0ffH
;	sta	groundfriction


	lda	#0
;	sta	p1addcol_r
;	sta	p1addcol_g
;	sta	p1addcol_b


;	lda	#20H+10H		;3fH
;	sta	p1addcol_r
;	lda	#40H+10H		;40H
;	sta	p1addcol_g
;	lda	#80H+1fH		;84H
;	sta	p1addcol_b



	a16

	lda	#0

	sta	demoshapeptr
	sta	clrdemoshapeptr

	sta	BOSSptr

	sta	calcbuf

	sta	player1_worldx
	sta	player1_worldy
	sta	player1_worldz
	sta	player2_worldx
	sta	player2_worldy
	sta	player2_worldz

	sta	player1_vx
	sta	player1_vy
	sta	player1_vz
	sta	player2_vx
	sta	player2_vy
	sta	player2_vz

;	sta	p1_ARENA_centerx
;	sta	p1_ARENA_centerz
;	sta	p2_ARENA_centerx
;	sta	p2_ARENA_centerz
	sta	player1hscroll_offset
	sta	player2hscroll_offset
	sta	player1vscroll_offset
	sta	player2vscroll_offset
	sta	player1_horizon
	sta	player2_horizon
	sta	player1_horizon_Wofs
	sta	player2_horizon_Wofs
	sta	player1_horizonbak
	sta	player2_horizonbak
	sta	p1_camrotzbuf
	sta	p2_camrotzbuf

	sta	SEADEPTH	; depth of sea

;	lda	#arenasize
;	sta	ARENA_sizex
;	sta	ARENA_sizez
;
;	sta	p1_ARENA_sizex
;	sta	p1_ARENA_sizez
;	sta	p2_ARENA_sizex
;	sta	p2_ARENA_sizez

	plp
	ply
	plx
	rtl



;
;	SET BOSS ROUTINE
;

	s_start_strat

	SHORTA
	LONGI
set_boss_l

bosswait00	equ	30

	phx
	phy
	php

	s_jmp_alsflag	x,player2,.p2

;------------------------------------------------------
.p1	test_playerdead	1
	rlbne		.exit
	bra		.pp
;------------------------------------------------------
.p2	test_playerdead	2
	rlbne		.exit
;------------------------------------------------------
.pp
	toheap	y,x

;------------------------------------------------------

;******************************************************

	IFNE	debuginfo

;	testjoypad	A,pcont
;	beq		.noboss
	testjoypad	B,pcont
	beq		.noboss
	testjoypad	X,pcont
	beq		.noboss
	testjoypad	Y,pcont
	beq		.noboss
	testjoypad	tright,pcont
	beq		.noboss

	lda	#0
	sta	KEnemyNumber
.noboss
	ENDC

;******************************************************
;-------------------------------------------------------
; BOSS appear?

	sm_jmp_if2screen	.exit

;	test_screenmode	onescreen
;	beq		.exit

; player is dead?

	lda	al_HP,x
	beq	.exit

; freezing?

	km_jmpgameflag		freeze,.notboss

	lda	KEnemyNumber
	rlbne	.notboss

	pl_jmp_iftransform	x,.notsetseq

	sp_trans_lock		x,y

	s_jmp_alvarnotZERO	W,y,exal_chartptr,.notsetseq

	jsl		setclearseq_l

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;;;;;* stage clear no toki *
;;;;	a16
;;;;	km_setgameflag		keydisable	;[for kawaguchi]
;;;;	km_clrgameflag		areaout		;[for kawaguchi]
;;;;(parallel off)
;;;;	km_clrmissionflag	parallel 	;[for kawaguchi]
;;;;	a8

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

.notsetseq

;	a16
;	IFNE	debuginfo
;	lda	BOSSptr
;	printh	BOSSptr,dylan
;	ENDC

;	lda	BOSSptr
;	a8
;	bne	.notboss
;
;	km_bitcheckmismapflag	extrasos
;	bne	.sos
;
;	ct_set_chartptr	x,boss00
;	bra	.exit

.sos
;	ct_set_chartptr	x,gameclear
.notboss	
;-------------------------------------------------------
; BOSS dead?
;	test_screenmode	onescreen
;	beq	.notdead
;
;	lda	BOSSstatus
;	bit	#BOSSstatus_dead
;	beq	.notdead
;
;	bit	#BOSSstatus_deadtrig
;	bne	.notdead
;	ora	#BOSSstatus_deadtrig^-1
;	sta	BOSSstatus

;	jsl	setclearseq_l

.notdead
;-------------------------------------------------------
.exit	plp
	ply
	plx


	rtl

;

	IFEQ	1

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	a8i16

	sm_jmp_if2screen	.exit0

;	test_screenmode		onescreen
;	rlbeq			.exit0

	s_jmp_alsflag	x,player2,.exit0

	debug_bossmode	;.bossappear

;	lda	target_remain
	lda	KEnemyNumber
	rlbne	.exit0
.bossappear
;-----------------------------------------------------------------
	pl_jmp_ifBOSSon	.start1
	s_jmp_varAND	B,BOSSstatus,#BOSSstatus_start,.start0
	s_or_var	B,BOSSstatus,#BOSSstatus_start
	pl_set_timer	x,#0	;macro	[obj,value]
;	s_set_alvar	W,x,al_pword1,#0
.start0
;TIMER	pl_inc_timer	x	;macro	[obj]
;	s_inc_alvar	W,x,al_pword1
	c_jmp_timerNE	x,#bosswait00,.exit0	;{value},{label}
;	s_jmp_alvarNE	W,x,al_pword1,#bosswait00,.exit0

;-----------------------------------------------------------------
; -- set boss --
.start1	pl_jmp_ifBOSSmode	.playergotoduel	; demo finished?
;CNTOFF	pl_control	x,off

	c_set_viewstrat		x,TEST_DUEL,demo

	pl_jmp_ifBOSSon		.exit0
	ora	#BOSSstatus_on
	sta	BOSSstatus

	km_setmissionflag	bossappear


	jsl	remove_map_l
;;;;	jsl	makeboss_l


	jmp	.exit0
;-----------------------------------------------------------------
; -- start duel --
.playergotoduel

	lda	BOSSstatus
	bit	#BOSSstatus_duelstart
	rlbne	.checkbossdeth
	ora	#BOSSstatus_duelstart
	sta	BOSSstatus

;CNTOFF	pl_control		x,on

	c_view_inbetween	x,on

	s_jmp_varNE		B,KGameMap,#0,.space
.field	c_set_viewstrat		x,ONFIELD_ARWING
	;pl_mode_change		x,of_arwing_init
	jmp			.finished
.space	c_set_viewstrat		x,INSPACE_ARWING
	pl_mode_change		x,cs_arwing_init
.finished
;-----------------------------------------------------------------
; -- start duel --
.checkbossdeth

	ldy		BOSSptr
	bne		.next
;	lda		BOSSstatus
;	bit		#BOSSstatus_dead
;	bne		.next
;	ora		#BOSSstatus_dead
;	sta		BOSSstatus
;CNTOFF	pl_control	x,off

	sp_jmp_playertype	x,ROBOT,.kkk

	lda		BOSSstatus
	bit		#BOSSstatus_dead
	bne		.next
	ora		#BOSSstatus_dead
	sta		BOSSstatus

	pl_mode_change	x,DM_AWC_0_0_init

.kkk
;-----------------------------------------------------------------

.next

.exit0

	plp
	ply
	plx
	rtl

;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	ENDC





;
;	BATTLE ga owattaka check suru.
;
battle_end_l
	s_start_strat

	IFEQ	1

	sm_jmp_if2screen	.exit

;	test_screenmode	onescreen
;	beq	.exit

;----------------------------------------------------------------------------------
	s_jmp_alsflag	x,player2,.p2
;----------------------------------------------------------------------------------
.p1	pl_jmp_ifplayer2dead	.win
	bra			.exit
.p2	pl_jmp_ifplayer1dead	.win
	bra			.exit
;----------------------------------------------------------------------------------
.win	pl_control	x,off
	pl_mode_change	x,DM_AWC_0_0_init
;----------------------------------------------------------------------------------
.exit
	ENDC

	rtl

;
;	TABLE of ARWING
;
shape_ARWING	; in space Armer

	DW	A_WING	; fox
	DW	C_WING	;
	DW	B_WING	;

shape_ROBOT_NULL	; walker

;	DW	nullROBOTA
;	DW	nullROBOTB
;	DW	nullROBOTB

shape_ROBOT_HEAD	; walker

	DW	A_ROBO	; fox
	DW	C_ROBO
	DW	B_ROBO

shape_ARMER_BODY	; in space Armer

	DW	MY_BODY	; fox
	DW	C_UFO_BO
	DW	B_UFO_BO

;
;	player no parts(ude toka ashi toka...)no initial
;
plobjinit_srou_l

	PHP
	s_start_strat
	a8i16
	s_start_strat

	s_set_alsflag		y,notslope
	s_set_alsflag		y,colldisable
	s_set_aldata		y,#1,#1
	s_set_alvartobeobj	y,al_ptr,x
	s_copy_pos		y,x
	s_copy_rots		y,x
	s_clr_alsflag		y,shadow

	PLP
	rtl

;
; worldx,y,z buffer <---> worldx,y,z
;
set_exal2worldxyz_srou

	PUSHYP

	s_start_strat

	a8i16

	ldy	al_sword2,x

	a16

	lda	exal_worldx,y
	sta	al_worldx,x

	lda	exal_worldy,y
	sta	al_worldy,x

	lda	exal_worldz,y
	sta	al_worldz,x

	PULLYP

	rts

set_worldxyz2exal_srou

	PUSHYP

	s_start_strat

	a8i16

	ldy	al_sword2,x

	a16

	lda	al_worldx,x
	sta	exal_worldx,y

	lda	al_worldy,x
	sta	exal_worldy,y

	lda	al_worldz,x
	sta	exal_worldz,y

	PULLYP

	rts

;
;	Copy head pos ---> other obj
;
;	idx: player's pointer
;	idy: other objct pointer

;copyrobopos_srou_l
;
;
;	PUSHXYP
;
;	s_start_strat
;
;	a8i16
;
;	pl_jmpnot_KAOinpool	x,.normal
;
;.pool	s_copy_pos	y,x
;
;	jmp		.exit
;
;.normal
;
;	s_push_obj	y
;	ldy		al_sword2,x
;	tyx
;	s_pull_obj	y
;
;	s_copy_alvar2alvar	W,y,al_worldx,x,exal_worldx
;	s_copy_alvar2alvar	W,y,al_worldy,x,exal_worldy
;	s_copy_alvar2alvar	W,y,al_worldz,x,exal_worldz
;
;	a16
;	lda		exal_bodyofsy,x
;	sexa
;	nega
;	clc
;	adc.w		al_worldy,y
;	sta.w		al_worldy,y
;
;	lda		exal_bodyfloatofsy,x
;	sexa
;	nega
;	clc
;	adc.w		al_worldy,y
;	sta.w		al_worldy,y
;	a8
;
;
;.exit	PULLXYP
;
;	rtl
;
;
;	hit strat
;

;playerhit_istrat
;
;
;	s_start_strat
;
;	s_jmpto_strat	x
;
;
;	hit strats
;	hit_hlptr	hit list pointer(16bit)
;	hit_ap		hitter's AP	(16bit)
;	hit_framecount	hit counter	(8bit)
;


;ͻ
;  HIT STRAT : FIRST  
;ͼ

hitplayer_start

	s_start_strat

	PUSHXYP
	a8i16


;------------------------------------------------------------------------------------
; SP arwing ha damage hanbun

	pl_lda_PILOTNoFSG	x
	cmp	#ep_SP
	bne	.noSP
	lda	hit_ap
	asr	a
	sta	hit_ap
.noSP
;------------------------------------------------------------------------------------

;DEBUG*********************
	ldy	hit_hlptr
	a16
	lda.w	hl_alptr,y
	tay
	a8
;**************************

; rolling dattara weapon dake hanekaesu.


	sm_jmp_if2screen	.nockKNUM
	lda	Kenemynumber
	rlbeq	.setAP1
.nockKNUM

;************
	IFEQ	PLAYERHIT

	s_jmp_colltype	y,LASER,.weapon
	s_jmp_colltype	y,ENEMYWEAP,.weapon
	s_set_var	B,hit_ap,#0
	jsl		shock_wave_srou_l
	bra		.sound
.weapon
	ENDC
;************

	pl_jmp_ifitemshield		x,.shieldon
	pl_jmpnot_ifrollingshield	x,.noshield

	s_jmpnot_colltype	y,LASER,.noshield
	bra			.setAP0

.shieldon
	s_push_obj	y
	toheap		y,x
	s_set_alvar	B,y,exal_scrflash,#1

	lda	exal_scrflash_flag,y
	ora	#exal_scrflash_flag_shield
	sta	exal_scrflash_flag,y

	s_pull_obj	y

.setAP0	kplsound	x,shieldreflect
.setAP1	s_set_var	B,hit_ap,#0
	bra		.exitsound

.noshield

	jsl		shock_wave_srou_l

;
;	hitter's =! then goto hit pros
;
;	s_jmp_varnotZERO	B,hit_ap,.hit
;.nohit	s_clr_alsflag	x,hitflash
;	bra		.object
;
;	effect of hitting
;
.hit	jsl		hit_effect_l
.sound	s_jmp_varless	B,hit_ap,#4,.ss
.sl	kplsound	x,damage_l
	bra		.exitsound
.ss	kplsound	x,damage_s
.exitsound
;
.object	;;;jsr	pushobjct_srou
;


	toheap		y,x

	lda	exal_HP,y
	sec
	sbc	hit_ap
	sta	exal_HP,y
	bpl	.notdead
	lda	#0
	sta	exal_HP,y

	lda	#1
	sta	hit_ap

	bra	.exit


.notdead	s_set_var	B,hit_ap,#0

.exit	PULLXYP

	s_end_strat




;ͻ
;  HIT STRAT : WHILE  
;ͼ

hitplayer_while

	s_start_strat

	PUSHXYP
	a8i16

	lda	#0
	sta	hit_ap

	ldy			al_sword2,x

	s_jmp_alsflag		x,nohitaffect_really,.ap0
	bra			.apnot0

.ap0	lda	#0
	sta.l	hit_ap

;	lda	gameframe
;	printh	FFFGGGG,kawagoe


.apnot0

;	jsr	pushobjct_srou

;	printh	< hit while >,kawagoe

;	lda	hit_framecount
;	printh	< obj hit count dayo >,kawagoe

	PULLXYP

	s_end_strat


;ͻ
;  HIT STRAT : END  
;ͼ

hitplayer_end

	s_start_strat


	PUSHXYP
	a8i16

;	printh	<hit end>,kawagoe

	PULLXYP

	s_end_strat



;************
shock_wave_srou_l

	s_start_strat

	PHP

	a8i16

	s_jmp_colltype	y,LASER,.noshock

	s_push_obj	y

	s_obj2obj_angle	x,y,al_pbyte1,0

	lda	al_roty,x
	cmp	al_pbyte1,x
	bmi	.mis
.pls	lda	#deg90
	bra	.sr
.mis	lda	#-deg90
.sr	ldy	dummyobj


	toheap	y,x

	sta	exal_rotyoffset+1,y
	sta	exal_shockvel,y

	s_pull_obj	y

.noshock

;	jsl	hit_effect_l
;	jsl	crash_effect_l

;************

	PLP

	rtl


;
;	if hitter's colltype = OBJECT then copy vector
;
;	in	idX		: player's pointer
;		hit_hlptr	: hitlist pointer
;
;

pushobjct_srou

	s_start_strat

;	sp_jmp_playertype	x,UFO,.do
;	sp_jmpnot_playertype	x,ROBOT,.notobject

.do	ldy	hit_hlptr
	a16
	lda.w	hl_alptr,y
	tay
	a8

	s_jmpnot_colltype	y,OBJECT,.notobject

	s_push_obj	y

	toheap	y,x

	a16

	lda	exal_vx,y
	bmi	.xmi
.xpl	bit	#0fffcH
	beq	.nox
	lda	#4
	bra	.setx
.xmi	bit	#0fffcH
	beq	.nox
	lda	#-4
.setx	sta	exal_vx,y

.nox

	lda	exal_vz,y
	bmi	.zmi
.zpl	bit	#0fffcH
	beq	.noz
	lda	#4
	bra	.setz
.zmi	bit	#0fffcH
	beq	.noz
	lda	#-4
.setz	sta	exal_vz,y

.noz

	a8

	s_pull_obj	y

	s_copy_alvar2alvar	W,y,al_vx,x,al_mx
	s_copy_alvar2alvar	W,y,al_vz,x,al_mz


;	s_copy_vecs		y,x
;	s_add_vecs2pos		y

;	ldy	al_sword2,x
;	lda	hit_framecount

;	printh	< obj hit count dayo>,kawagoe

;	nega
;	cmp	exal_hit_framecount,y
;	bcs	.notobject
;	sta	exal_hit_framecount,y
.notobject
	rts

;
;demotest_l
;
;	s_start_strat
;
;	PUSHXYP
;
;	a8i16
;
;	pl_control	x,off
;
;.exit
;	PULLXYP
;
;	rtl
;
;
;	Transform suru ka sinaika....
;
;	in	x1:next mode
;		idX:player pointer

settransform_srou_l

st_nexttype		equ	x1
st_nextctlmode	equ	y1
st_nexttransmode	equ	z1

	PUSHYP

	a8i16

	toheap	y,x

;-------------------------------------

	lda	exal_transENDse,y
	bit	#exal_transENDse_notEND
	rlbne	.noselect

.fall	pl_jmpnot_ifinthesea		x,.rise
	pl_jmpnot_ifcamintheseareally	x,.noselect,y

.rise	pl_jmp_ifinthesea		x,.start
	pl_jmp_ifcamintheseareally	x,.noselect,y

.start

	testjoypad	tleft,pcont
	beq		.cks
	testjoypad	tright,pcont
	bne		.noselect

.cks	testjoypad	select,ptrig
	beq		.noselect

	lda	exal_translocktimer,y	; Ring laser no effect.(See player_end_strat:player.asm)
	bne	.boo

	lda	exal_CTLtype,y
	and	#exal_CTLtype_notrans!exal_CTLtype_notransreally
	bne	.boo

;{ = sp_trans_d0

	lda	exal_shapeNoNEXT,y
	and	#exal_shapeNo_ctmask^-1
	ora	x1	;#ct_{type}
	sta	exal_shapeNoNEXT,y
;}

	bra	.noselect

.boo
	kplsound	x,trans_unable

.noselect

;-------------------------------------
; transform suru?


;[same control type?]

	a16

	lda	exal_shapeNoNEXT,y
	and	#exal_shapeNo_ctmask

	and	#exal_shapeNo_ctmask
	rlbeq	.notrans

	PHA

;clear
	lda	exal_shapeNo,y
	and	#exal_shapeNo_ctmask
	sta	tpx
	PLA
	cmp	tpx
	beq	.notrans

; read table data

	jsr	getctldat_srou

;[same type?]


	lda	exal_shapeNo,y
	and	#exal_shapeNo_stmask
	cmp	st_nexttype
	beq	.ctlmode


;[do transform]

.transmode

;[transform kinshi flag]

	lda	exal_CTLtype,y
	bit	#exal_CTLtype_notransreally
	bne	.notrans
	bit	#exal_CTLtype_notrans
	beq	.nolock
	and	#exal_CTLtype_notrans^-1
	ora	#exal_CTLtype_notransreally
	sta	exal_CTLtype,y
.nolock

	jsr	gettransdat_srou
	lda	st_nexttransmode
	beq	.notrans

	bra	.set


;[change control]

.ctlmode

	lda	exal_shapeNoNEXT,y
	and	#exal_shapeNo_ctmask^-1
	sta	exal_shapeNoNEXT,y

	lda	st_nextctlmode
	sta	x1

	a8
	s_mode_change	x,x1
	PULLYP
	clc
	rtl

.set	LONGA
	sta	x1
	a8
	s_mode_change	x,x1
	PULLYP
	sec
	rtl

.notrans	a8
	PULLYP
	clc
	rtl

;-----------------------------------------------------------------------------

getctldat_srou

;	in	:exal_shapeNoNEXT bit 0-3
;	out	:st_nexttype(next type)
;		:st_nextctlmode(next control mode)

	PUSHXYP

	ai16
	ldy	al_sword2,x
	lda	exal_shapeNoNEXT,y

	and	#exal_shapeNo_ctmask

;	printh	NEXTNo,kawagoe

	asl	a
	asl	a


	tax

	lda.l	ctltable,x
	sta	st_nexttype

	lda.l	ctltable+2,x
	sta	st_nextctlmode

	PULLXYP

	rts


gettransdat_srou

;	in	:exal_shapeNoNEXT bit 0-3
;	out	:z1(next trans mode)

	PUSHXYP

	a8i16

	toheap	y,x

	sp_jmp_playertype	x,ROBOT,.rb,y
	sp_jmp_playertype	x,UFO,.am,y

	lda	exal_shapeNoNEXT,y
	and	#exal_shapeNo_ctmask
	cmp	#ct_robot
	beq	.aw2rb

.aw2am	ldy	#pl_arwing2armer	; trans
	bra	.set
.aw2rb	ldy	#pl_arwing2robo		; trans
	bra	.set

.am	ldy	#pl_armer2arwing	; trans
	bra	.set
.rb	ldy	#pl_robo2arwing		; trans

.set	sty	st_nexttransmode

	PULLXYP

	rts


;--------------------------------------------------------------------------------
; player mode table

ctltable

;dummy
	dw	0
	dw	0	;dummy

;ct_OF_ARWING

	dw	st_OF_ARWING<<4
	dw	of_arwing_init	; control

;ct_CS_ARWING

	dw	st_CS_ARWING<<4
	dw	cs_arwing_init	; control

;ct_ARMER
	dw	st_ARMER<<4
	dw	is_armer_init	; control

;ct_ROBOT
	dw	st_ROBOT<<4
	dw	of_robo_init	; control



;transtable

;dummy
	dw	0
;
;ct_OF_ARWING

;	dw	pl_arwing2robo	; trans

;ct_CS_ARWING

;	dw	pl_arwing2armer	; trans

;ct_ARMER

;	dw	pl_armer2arwing	; trans

;ct_ROBOT

;	dw	pl_robo2arwing	; trans



;
;	PL_DO_CTLandVIEW de tsukau.
;
do_viewstrat_srou

	s_start_strat

	jsl	blockmap_srou_l

	c_do_viewstrat

	jsl	set_inbet_l

	rts

;
;	MAP ROUTINE
;

map_arwing_init_l

;Call from map files. use map macro "map_arwing_init"

;in	y1(1word):player move area high
;	y2(1word):player move area low
;	x1(1byte):player max rotx
;	x2(1byte):player min rotx

	PUSHXYPB

	a8i16

	lda	#7eH
	pha
	plb

	ldx	playpt1
	jsr	.set

	sm_jmp_if1screen	.exit

;	test_screenmode	onescreen
;	bne	.exit

	ldx	playpt2
	jsr	.set

.exit	jmp	maprou_end


.set	toheap	y,x
	a16
	lda		y1	;#-({high})
	sta		exal_maxPmoveY,y
	lda		y2	;#-({low})
	sta		exal_minPmoveY,y
	a8
	lda		x1	;#{rotxmax}
	sta		exal_maxProtX,y
	lda		x2	;#{rotxmin}
	sta		exal_minProtX,y

	rts

;-------------------------------------------------------------------------------------

; misiion mode no toki no camera no parameter no initial
; Call from map files. use map macro "map_camerainit_1screen"

;in	y1(1word):camera move center
;	y2(1byte):camera-player no y offset no max
;	y3(1byte):camera-player no y offset no hayasa
;	x1(1byte):camera max rotx
;	x2(1byte):camera min rotx

map_camerainit_1screen_l

	PUSHXYPB
	a8i16
	ldx		playpt1
	bra		map_camerainit_2screen_l.enter


map_camerainit_2screen_l

	PUSHXYPB
	a8i16
	ldx	playpt2

.enter	LOCAL

	beq	.exit

	toheap		y,x

	lda	#7eH
	pha
	plb

	a16
	lda	y1
	sta	exal_midCmoveY,y

	a8
	lda	y2
	sta	exal_camYofsMAX,y
	lda	x1
	sta	exal_maxCrotX,y
	lda	x2
	sta	exal_minCrotX,y
	lda	y3
	sta	exal_camYofsrate,y

.exit
	jmp	maprou_end


;-------------------------------------------------------------------------------------
; player position no initial

; Call from map files. use map macro "map_setplayerpos"

;in	p1_worldx_init(1word):worldx
;	p1_worldy_init(1word):worldy
;	p1_worldz_init(1word):worldz
;	p1_roty_init  (1byte):roty


map_setplayerpos_1_l

	PUSHXYPB
	a8i16
	ldx	playpt1
	beq	.exit
	lda	#7eH
	pha
	plb
	a16
	lda	p1_worldx_init
	sta	al_worldx,x
	lda	p1_worldy_init
	sta	al_worldy,x
	lda	p1_worldz_init
	sta	al_worldz,x
	a8
	toheap	y,x
	lda	p1_roty_init
	sta	exal_roty+1,y
	sta	al_roty,x
.exit
	jmp	maprou_end


map_setplayerpos_2_l

	PUSHXYPB
	a8i16
	ldx	playpt2
	beq	.exit
	lda	#7eH
	pha
	plb
	a16
	lda	p2_worldx_init
	sta	al_worldx,x
	lda	p2_worldy_init
	sta	al_worldy,x
	lda	p2_worldz_init
	sta	al_worldz,x
	a8
	toheap	y,x
	lda	p2_roty_init
	sta	exal_roty+1,y
	sta	al_roty,x
.exit
	jmp	maprou_end



;-------------------------------------------------------------------------------------
; player v scroll(offset) wo off ni suru.

; Call from map files. use map macro "map_vscrolloff"

map_vscroll_off_l

	PUSHXYPB

	a8i16

	BANK7E

	ldx	playpt1
	jsr	.set

	a16
	lda	screenvheight
	cmp	#24*8
	a8
	beq	.exit

	ldx	playpt2
	jsr	.set
	bra	.exit


.exit
	jmp	maprou_end


.set	toheap	y,x
	lda	exal_VIEWflag3,y
	ora	#exal_VIEWflag3_vscrloff
	sta	exal_VIEWflag3,y
	rts


;-------------------------------------------------------------------------------------
; player no TUTU mode wo on ni suru.

; Call from map files. use map macro "map_playerTUTUmode"

; in	:tpx direction flag (see talcs.inc)

map_playerTUTUmode_l

	PUSHXYPB

	a8i16

	BANK7E

;	ldx	playpt1
;	toheap	y,x
;
;	jsr	initTUTU_path_srou
;
;	lda	exal_control2,y
;	ora	#exal_control2_TUTU
;	sta	exal_control2,y
;	lda	tpx	;#exal_TUTUdir_{dir}
;	sta	exal_TUTUdir,y
;
;	a16
;	lda	tpy
;	sta	exal_TUTUheight,y
;	sta	exal_TUTUheightcurrent,y
;
;	dec	a
;	eor	#-1
;
;	and	al_worldy,x
;	sta	exal_TUTUlevel,y
;	sta	exal_TUTUlevelcurrent,y



;in	: x1 data address
;	: tpx direction flag (see talcs.inc)

	SHORTA
	LONGI

	ldy	playpt1
	toheap	y,y

	lda	tpx	;#exal_TUTUdir_{dir}
	sta	exal_TUTUdir,y

	lda	exal_control2,y
	ora	#exal_control2_TUTU
	sta	exal_control2,y
	lda	tpx	;#exal_TUTUdir_{dir}
	sta	exal_TUTUdir,y

	a16
	lda	x1+0
	sta	exal_TUTUptr+0,y
	lda	x1+1
	sta	exal_TUTUptr+1,y

	lda	[x1]
	sta	exal_TUTUheight,y
	sta	exal_TUTUheightcurrent,y
	dec	a
	eor	#-1
	and	al_worldy,x
	sta	exal_TUTUlevel,y
	sta	exal_TUTUlevelcurrent,y

	a8

	jmp	maprou_end

;-------------------------------------------------------------------------------------
; player no block map no check wo off ni suru.

; Call from map files. use map macro "map_playerblockmap_off"

map_playerblockmap_off_1_l

	PUSHXYPB

	a8i16

	ldx	playpt1

	bra	map_playerblockmap_off_2_l.enter


map_playerblockmap_off_2_l

	PUSHXYPB

	a8i16

	ldx	playpt2

.enter	LOCAL

	BANK7E

	toheap	y,x
	lda	exal_blockflag,y
	ora	#exal_blockflag_off
	sta	exal_blockflag,y

	jmp	maprou_end

;---------------------------------------------------------------------------------




;---------------------------------------------------------------------------------
maprou_end

	PULLXYPB

	rtl


;  ͻ
;                                                            
;                    STRATS FOR PLAYER                       
;                                                            
;  ͼ

;  -- PLAYER MODE TABLE --



PLAYERMAIN

.strat	LOCAL

	s_start_strat

;	a16
;	lda	al_worldx,x
;	printh	x,kawagoe
;	lda	al_worldz,x
;	printh	z,kawagoe
;	a8

;	a16
;	lda	#exal_start
;	printh	exal_start,kawagoe
;	a8

;	lda	al_ap,x
;	printh	al_ap,kawagoe


;	a16
;	lda	screenvheight
;	printh	screenvh,kawagoe
;	a8

	toheap	y,x


;	lda	al_vel,x
;	printh	AL_VELGGGGG,kawagoe
;	s_set_alvar	B,x,al_vel,#30



;	lda	exal_vel,y
;	printh	exal_vel,kawagoe
;	lda	al_vel,x
;	printh	al_vel,kawagoe


;	lda	exal_HP,y
;	printh	exaL_HP,kawagoe


;	lda	Kringouttimer,y
;	printh	kring,kawagoe

;------------------------------------------------------------------------------
	km_jmpnotgameflag	freeze,.notfreeze
	s_set_alvar		B,y,exal_laser_LMT,#0
.notfreeze
;------------------------------------------------------------------------------

	jsl		cc_copy2buffer_l

;	s_count_childs	x,x1
;	lda	x1
;	printh	CHILD_NUMBER,kawagoe

	toheap	y,x

;	lda	planet_mode
;	printh	planet_mode,kawagoe


;	lda	exal_control2,y
;	printh	CONTROL2,kawagoe

;	lda	exal_tutudir,y
;	printh	DIRDIR,kawagoe

;	a16
;	lda	al_worldy,x
;	printh	WORLDY,kawagoe
;	a8


;	jsl	Check_KGWindow_l

;	jsr	kawaguchi_hit


.up

;HHHH	km_jmpgameflag	freeze,freeze_end_strat


;	testjoypad	Y,ptrig
;	rlbeq		.noburn

;	pl_burn		x,on,ALL

.noburn
	toheap	y,x

;	lda	exal_laser_LMT,y
;	printh	LMT,kawagoe


	lda	exal_spweap_LMT,y
	and	#0fH
;	printh	spweapnum,kawagoe



;;;	s_set_colltype	x,FRIEND

	a8

;-----------------------------------------------------------------------------
; call time chart routine

	jsl	timechart_l

;-----------------------------------------------------------------------------

	toheap	y,x

	a8

;	lda	#tarwing_sizeof
;	printh	<HEAP SIZE>,kawagoe

;Ŀ
;set pilot No
;

	s_jmp_alsflag	x,player2,.p2PN
.p1PN
	s_copy_alvar2var	B,y,p1_HP,exal_HP
	s_copy_alvar2var	B,y,p1_spweap_type,exal_spweap_TYPE
	s_copy_alvar2var	B,y,p1_spweap_LMT,exal_spweap_LMT
	s_copy_alvar2var	B,y,p1_weap_level,exal_weap_level

	bra		.staPN
.p2PN
	s_copy_alvar2var	B,y,p2_HP,exal_HP
	s_copy_alvar2var	B,y,p2_spweap_type,exal_spweap_TYPE
	s_copy_alvar2var	B,y,p2_spweap_LMT,exal_spweap_LMT
	s_copy_alvar2var	B,y,p2_weap_level,exal_weap_level
.staPN


;Ŀ
;tell player's position to enemy
;

; set player1(2)_worldx,y,z
; set player1(2)_vx,y,z

	jsl	cp_playervecspos_l


;inc general timer

	pl_inc_timer	x


;	lda	demomode
;	rlbeq	.active
;
;	pl_end_strat

;---------------------------------------------------------------------------------------------------------------

.active	s_mode_table

; main control mode......

	s_mode_entry	Onfield_robo_init,of_robo_init
	s_mode_entry	Onfield_robo,of_robo
	s_mode_entry	Onfield_robo2,of_robo2

	s_mode_entry	Inspace_Armer_init,is_Armer_init
	s_mode_entry	Inspace_Armer,is_Armer

	s_mode_entry	Onfield_Arwing_init,of_Arwing_init
	s_mode_entry	Onfield_Arwing,of_Arwing

	s_mode_entry	Cosmo_Arwing_init,cs_Arwing_init
	s_mode_entry	Cosmo_Arwing,cs_Arwing

; transform mode.......

	s_mode_entry	Aw2Rb_init,pl_Arwing2Robo
	s_mode_entry	Aw2Rb,Tr_Aw2Rb

	s_mode_entry	Rb2Aw_init,pl_Robo2Arwing
	s_mode_entry	Rb2Aw,Tr_Rb2Aw

	s_mode_entry	Aw2Am_init,pl_Arwing2Armer
	s_mode_entry	Aw2Am,Tr_Aw2Am

	s_mode_entry	Am2Aw_init,pl_Armer2Arwing
	s_mode_entry	Am2Aw,Tr_Am2Aw

; demonstration mode ....

;	( clear demo )

;	s_mode_entry	DEMO_AWCLEAR_0_0_init,DM_AWC_0_0_init
;	s_mode_entry	DEMO_AWCLEAR_0_0,DM_AWC_0_0
;	s_mode_entry	DEMO_AWCLEAR_0_1,DM_AWC_0_1

;	( game start demo )

;	s_mode_entry	DEMO_BATTLESTART_0_0_init,DM_BS_0_0_init
;	s_mode_entry	DEMO_BATTLESTART_0_1_init,DM_BS_0_1_init
;	s_mode_entry	DEMO_BATTLESTART_0_0,DM_BS_0_0
;	s_mode_entry	DEMO_BATTLESTART_0_0,DM_BS_0_0

	s_mode_table_end

;
;freeze!
;

;freeze_end_strat	LOCAL
;
;	s_start_strat
;
;	sp_jmpnot_playertype	x,ROBOT,player_end_strat.addchild
;
;	toheap	y,x
;
;	jsl	RB_setbodypos_srou_l
;
;	s_set_alvar		B,y,exal_laser_LMT,#0
;
;	s_copy_alvar2alvar	W,x,al_worldy,y,exal_bodyworldy
;
;	jmp	player_end_strat.addchild

;
;	initial data table
;
player_ctl_mode

	dw	.gnd&WM		;0
	dw	.mrn&WM		;1
	dw	.dst&WM		;2
	dw	.cms&WM		;3
	dw	.cms2&WM	;4
	dw	.gnd2&WM	;5
	dw	.tnl&WM		;6
	dw	.sun&WM		;7
	dw	.gnd&WM		;8
	dw	.room&WM	;9

.gnd	BGinitdat	of_Arwing_init,of_Arwing_init,ground
.mrn	BGinitdat	of_Arwing_init,of_Arwing_init,marine
.dst	BGinitdat	of_Arwing_init,of_Arwing_init,desert
.cms	BGinitdat	cs_Arwing_init,cs_Arwing_init,cosmos
.cms2	BGinitdat	cs_Arwing_init,cs_Arwing_init,cosmos
.gnd2	BGinitdat	cs_Arwing_init,of_Arwing_init,ground2
.tnl	BGinitdat	of_Arwing_init,0,tunnel
.sun	BGinitdat	cs_Arwing_init,of_Arwing_init,sun
.room	BGinitdat	of_Arwing_init,0,tunnel


;.gnd	BGinitdat	of_Arwing0_init,DM_BS_0_0_init,ground
;.mrn	BGinitdat	of_Arwing0_init,DM_BS_0_0_init,marine
;.dst	BGinitdat	of_Arwing0_init,DM_BS_0_0_init,desert
;.cms	BGinitdat	cs_Arwing0_init,DM_BS_0_1_init,cosmos
;.cms2	BGinitdat	cs_Arwing0_init,DM_BS_0_1_init,cosmos
;.gnd2	BGinitdat	cs_Arwing0_init,DM_BS_0_0_init,ground2
;.tnl	BGinitdat	of_Arwing0_init,0,tunnel
;.sun	BGinitdat	cs_Arwing0_init,DM_BS_0_0_init,sun
;.room	BGinitdat	of_Arwing0_init,0,tunnel



;
;	player no saigo no syori
;
player_end_strat

	s_start_strat

	a8i16

;----------------------------------------------------------------------------------
;enemy has gone?
	a16
	km_bitcheckmissionflag	enemyrunaway
	a8
	beq		.notgone
	pl_control	x,off,y
.notgone
;----------------------------------------------------------------------------------

	jsl	battle_judge_srou_l

;----------------------------------------------------------------------------------
; debug command

	IFNE	debuginfo
	testjoypad	tright,pcont
	beq		.noup
	testjoypad	tleft,pcont
	beq		.noup
	testjoypad	X,ptrig
	beq		.noup
	wm_weaplevelup	x

.noup	testjoypad	A,pcont
	beq		.nodead
	testjoypad	Y,ptrig
	beq		.nodead
	testjoypad	tleft,pcont
	beq		.nodead
	testjoypad	tright,pcont
	beq		.nodead
	s_set_alvar	B,x,al_HP,#0
.nodead
	ENDC

;----------------------------------------------------------------------------------
; When battle mode then set marker

;	s_jmpnot_alsflag	x,player2,.markP2
;
;.markP1	ldy	playpt1
;	toheap	y,y
;	s_jmp_alvarnotZERO	W,y,exal_enemyaltmeter_objptr,.nomark
;	jsl	addEaltlist_p1_l
;	bra	.nomark
;
;.markP2	ldy	playpt2
;	toheap	y,y
;	s_jmp_alvarnotZERO	W,y,exal_enemyaltmeter_objptr,.nomark
;	jsl	addEaltlist_p2_l
;.nomark
;
;----------------------------------------------------------------------------------
	toheap		y,x
;----------------------------------------------------------------------------------
; HEAL ITEM

	lda		exal_roty+1,y
	sta		y1
	s_set_objtobechild	y,x,#childno_heal
	cpy		#0
	beq		.noHEAL
	s_copy_pos	y,x
	lda		#0
	sta.w		al_rotx,y
	sta.w		al_rotz,y
	s_set_alvar	B,y,al_roty,y1
.noHEAL
;----------------------------------------------------------------------------------
; decno translock timer

	toheap	y,x

	lda	exal_translocktimer,y
	beq	.nolock
	dec	a
	sta	exal_translocktimer,y

	jsl	makedamagespark_srou_l

;	jsl	maketranslockspark_srou_l

.nolock

;----------------------------------------------------------------------------------

	toheap	y,x

	lda	exal_paletteflag,y
	and	#~exal_paletteflag_alart
	bra	.addd

.add	lda	exal_paletteflag,y
	ora	#exal_paletteflag_alart!exal_paletteflag_normal
.addd	sta	exal_paletteflag,y

	jsl	cc_alart_l

;---------------------------------------------------------------------------------
; copy old pos

	ai16
	lda	al_worldx,x
	sta	exal_worldxold,y
	lda	al_worldy,x
	sta	exal_worldyold,y
	lda	al_worldz,x
	sta	exal_worldzold,y
	a8

;---------------------------------------------------------------------------------

	jsl	set_boss_l

	jsl	makeburnning_l

	jsl	set_shield_srou_l

	pl_p2_coltab		x,id_1_c

;---------------------------------------------------------------------------------
; set depth

	phx
	a16
	lda	exal_depthno,y
	and	#3
	asl	a
	tax
	lda.l	.depthtab,x
	plx
	sta	al_depthoffset,x
	a8

;---------------------------------------------------------------------------------

	pl_hpadd		x

;---------------------------------------------------------------------------------

	sp_jmp_playertype	x,ROBOT,.RB

.addchild	LOCAL

.AW	s_rotpos_allchildren	x
	bra			.childend

.RB	toheap	y,x
	a16
	lda	al_worldy,x
	sta	work0
	a8
	lda	al_roty,x
	sta	work1+1

	s_copy_alvar2alvar	W,x,al_worldy,y,exal_bodyworldy

	s_add_alvars		B,x,al_roty,y,exal_jetroty

	s_rotpos_allchildren	x

	a16
	lda	work0
	sta	al_worldy,x
	a8
	lda	work1+1
	sta	al_roty,x

.childend
;---------------------------------------------------------------------------------

	s_end_strat




.depthtab

	dw	depth_1
	dw	depth_2
	dw	depth_3
	dw	depth_4

;
;	player's status init
;
playerstatus_init_l

	PHP

	a8i16


	lda	#0
	sta	p1_status
	sta	p2_status

	lda	#pX_spweap_LMT_init
	sta	p1_spweap_LMT
	sta	p2_spweap_LMT

;	lda	#spweap_dummy
	lda	#spweap_smartplasma
;	lda	#spweap_heal
;	lda	#spweap_missile1

	sta	p1_spweap_type
	sta	p2_spweap_type

	lda	#exal_weap_level_1
	sta	p1_weap_level
	sta	p2_weap_level

	lda	#40
	sta	p1_HP
	lda	#40
	sta	p2_HP

	PLP

	rtl

;
;	end of file
;

	strats_end

	end


