;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: raster.asm				*
;* 	Description	: RAM message				*
;*	Date		: 1994.9.30				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;---------------------------------------------------------------------
	INCPUB	rammes
;---------------------------------------------------------------------
;
;
;
;
;
;*********************************************************************
;	parameter's
;*********************************************************************
code_sosoverline	equ	0010b	;
code_sosattack	equ	0100b	;
code_HPoverline	equ	30	; 70%
code_HPattack_1	equ	15	; 85%
code_HPattack_2	equ	50	; 50%
;---------------------------------------------------------------------
redmessage_cmp	equ	4
;---------------------------------------------------------------------
PPkx_CorneriaHP	equ	kx_CorneriaHP
PPmmx_message_sos	equ	mmx_message_sos
;---------------------------------------------------------------------






;*********************************************************************
;
;	game cyu no pepper message
;	
;*********************************************************************
Mmessagecheck macro	[count,addr]
	ldy	#{count}
	lda	#1
.\@p1	trb	{addr}&WM
	bne	.exitcheck
	asl	a
	inx
	dey
	bne	.\@p1
	endm

;---------------------------------------------------------------------

MessageTrigger_l
	Mbank7e
	php
	ai8

;----------------------------------------------------
	lda	pepper_message	; 1byte messagedata
	bne	.exit
	ldx	#0		; pepper trigger message number
;----------------------------------------------------
	jsr	redmessage_check
	bcs	.exitcheck
;----------------------------------------------------
	Mmessagecheck	5,mmx_message_guard
	Mmessagecheck	5,mmx_message_stepup
	Mmessagecheck	5,mmx_planet_stepup
	Mmessagecheck	6,mmx_sosappear
	bra	.exit
.exitcheck	
	a16
	lda.l	xxmessage_select,x
	and	#00ffh
	sta	pepper_message		; Message-Number
	lda	#mapmessage_blackcolor
	sta.l	mapmessage_setcolor	; Color
	cpx	#redmessage_cmp
	bcs	.exit
	lda	#mapmessage_redcolor
	sta.l	mapmessage_setcolor

;----------------------------------------------------

.exit	plp
	Mbankrtl

;*********************************************************************
;;
;; red message check 8bitmode
;;
;*********************************************************************
	shorta
	shorti
;---------------------------------------------------------------------
redmessage_check
	ldy	PPkx_CorneriaHP

	lda	#code_sosattack
	trb	PPmmx_message_sos
	beq	.skip
	cpy	#code_HPattack_1
	bcc	.set
	inx
	cpy	#code_HPattack_2
	bcc	.set
	inx
.set	sec
	rts

.skip	inx
	inx
	inx
	lda	#code_sosoverline
	trb	PPmmx_message_sos
	beq	.exit
	cpy	#code_HPoverline	 ;;; if damage 70% 
	bcc	.set
.exit	inx
	clc
	rts


;=====================================================================
xxmessage_select
	db	23			;  yarare 00 - 50 
	db	22			;  yarare 51 - 84
	db	30			;  yarare 85 - 99

	db	31			; "kinkyu jitai"

	db	32,33,34,35,36		; "guard"
	db	32,33,34,35,36		; "stepup"
	db	32,33,34,35,36		; "planet stepup"
	db	113,113			; appear data 1
	db	114,114			; appear data 2
	db	112,112			; appear data 3

;=====================================================================




