;*****************************************************************************
;*									*
;*			MISSION MAP RAM PROGRAM				*
;*									*
;*****************************************************************************
	INCPUB	rammismap

;=====================================================================
;*		Label Definition				*
;=====================================================================
mm_sx	=	kz_x1		;2 byte
mm_sy	=	kz_x2		;2 byte
mm_ex	=	kz_y1		;2 byte
mm_ey	=	kz_y2		;2 byte

mm_mx	=	kz_x3		;2 byte
mm_my	=	kz_y3		;2 byte

mm_dx	=	kz_z1		;2 byte
mm_dy	=	kz_z2		;2 byte
mm_dxdy	=	kz_tempaddrl	;2 byte

mm_sp	=	kz_tpa		;2 byte
mm_spx	=	kz_tpx		;2 byte
mm_spy	=	kz_tpy		;2 byte

mm_flag	=	kz_textpt	;2 byte
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;----------------------------------------------------------------------
;=====================================================================
;*			Flag Definition				*
;=====================================================================
;--------------------------------------------------------------------
;* mmx_arwingflag (2 byte)*
	km_flagstart
mmf_all	equ	-1

	km_flag	mmf_initmove	;0/1 ... initial move parameters
	km_flag	mmf_go		;0/1 ... stop / arwing go
	km_flag	mmf_arvx	;0/1 ... arrived X zahyou
	km_flag	mmf_arvy	;0/1 ... arrived Y zahyou
	km_flag	mmf_finish	;0/1 ... arwing arrived (X,Y)
	km_flag	mmf_nocoll	;0/1 ... arwing collison ON/OFF
	km_flag	mmf_boost	;0/1 ... boost OFF/ON
	km_flag	mmf_asteroid	;0/1 ... Asteroid Hit Check 
;=====================================================================
;*								*
;*		Macro Definition				*
;=====================================================================
km_ramcpudivu16uf8	macro	[output,divisor]
;init	:a16i16
;	Acc(16 bit) / #divisor (8 bit)
;exit	:a16i16
;	syou(work),amari(work)
;	syou (x),amari(y)

MYNARG	=	NARG
	CHK_NARG	2

_cc_{output} =	2
_cc_xy	=	0
_cc_work	=	1

	km_memchecka16i16

	IFEQ	_cc_{output}-_cc_xy
	ldx	#{divisor}
	km_jsr	ramdivu16u8_sub
	ELSEIF

		IFEQ	_cc_{output}-_cc_work
		phx
		phy
		ldx	#{divisor}
		km_jsr	ramdivu16u8_sub
		stx	ksyou
		sty   	kamari
		ply
		plx
		ELSEIF

		printf	"Error:(xy,work) needed\n"
		error+
		ENDC
	ENDC
	endm

;--------------------------------------------------------------------
km_MMSetSpriteSizeDouble	macro
;Init	Yregister... sprites pointer
	km_jsr	mm_SetSprSize_double_sub
	endm
;--------------------------------------------------------------------
;--------------------------------------------------------------------
;*********************************************************************
;*								*
;*								*
;*			On RAM PROGRAM 	[Main Routine ]		*
;* Data Bank 7e				[1 Frame Running]	*
;*								*
;*********************************************************************
;*  MEMO *
;   This Program is running 1 frame
;---------------------------------------------------------------------
heap_runmariostart_l
	shorta
	longi
	php
	phb
;=====================================================================
;*			 RAM Program Start [1 frame routine]	*
;* data bank 7e							*
;=====================================================================
;;;;	km_SyoriOverCheckStart
;---------------------------------------------
;*		Data Bank 7e		*
;---------------------------------------------
	db7e
	ai16
;---------------------------------------------
;*	Itumo ugoku routine	  	*
;---------------------------------------------
;* Key Enable Check *
	km_bitcheckgameflag	keydisable
	km_bne	.display
;* Replay Demo Check *
	km_bitcheckmismapfzflag	demofreeze
	bne	.demostratage

;* Bug Mode Check *
	km_jsr	mm_bugcheck
;* Button Check *
	km_jsr	mm_pausecheck

;* Syori Freeze *
	km_bitcheckmismapfzflag	syorifreeze
	km_bne	.display

;* Explain Demo Check *
	km_bitcheckmismapflag	explain1
	bne	.demostratage
;* check pause *
	km_bitcheckgameflag	PAUSE
	bne	.display
;----------------------------------------------------------------------
;*** flag clear ****
;'94/10/12 :kono basyo ga good !! (for yajima) :Pause notoki wa val keep
	LONGA
	km_clrflag16	mmx_mapcursor,1		;(For Message)

	km_bitcheckmismapfzflag	cursorfreeze
	bne	.skip_cursor
;* Normal button Check*
	km_jsr	mm_checkbutton
;* cursor *
	a8
	km_jsr	mm_movecursor		;[move cursor]
	km_jsr	mm_CollisionCursor	;[collision check]
.skip_cursor
;---------------------------------------------
;*	Time Stop notokiwa ugokanai	*
;---------------------------------------------
;-------------------------------------
;*	Demo Stratage		*
;-------------------------------------
.demostratage
	a8
	km_jsr	mm_DemoStepUpAppear		;[for explain demo]
;-------------------------------------
;*	Player Stratage		*
;-------------------------------------
.playerstratage
	shorta
	km_bitcheckmismapfzflag	playerfreeze
	bne	.skip_playerstratage

	km_jsr	mm_checkplayerdestpos	;[player dest postion check]
	km_jsr	mm_calcplayerangle	;[player angle]
	km_jsr	mm_calcplayercgxptr	;[player cgx ptr]
	km_jsr	mm_HitAsteroid		;[asteroid hit check]
	km_jsr	mm_moveplayer		;[player move]
	km_jsr	mm_CheckNearPlanet	;[collision check]
;* mother ship *
	km_jsr	mm_recoverHP
.skip_playerstratage
;-------------------------------------
;*	Enemy Stratage		*
;-------------------------------------
.enemystratage
	shorta
	km_bitcheckmismapfzflag	enemyfreeze	;kono check wa player check to tomoni hituyou !!
	bne	.stratage_skip
	jsl	mm_GameFrameRAMRoutine_l
	jsl	mm_OneFrameRAMRoutine_l
.stratage_skip
;---------------------------------------------
;*	Dsiplay Routine			*
;---------------------------------------------
.display
	a8
;* Set screen (screen kakikae) *
	km_jsr	mm_dispgametotaltm
	km_jsr	mm_dispenemytotal

	km_bitcheckgameflag	pause
	beq	.skip_screen

	km_jsr	mm_dispItem
;;;;	km_jsr	mm_dispCrystal
	km_jsr	mm_dispDamage
	km_jsr	mm_dispScore
.skip_screen

;* Set Colour *
	km_jsr	mm_changecolpal

;* h-v scroll *
;;;	km_jsr	mm_StepUpScroll
	km_jsr	mm_PauseScroll

;* Set Sprites *
	km_jsr	mm_dosprites

;* Set Sound *
	km_jsr	mm_soundBGM

;---------------------------------------------
;*	     End			*
;---------------------------------------------
.end
	a16
	km_bitcheckmismapstflag	gmframesyori
	beq	.noclearflag
	km_clrgmjoypad
	km_clrgmkeydown
	km_clrmismapstflag	gmframesyori
	km_clrflag16	mmx_cursorflag,curf_gospup
.noclearflag
;---------------------------------------------
;* syori over check *
	a8
;;;;	km_SyoriOverCheckEnd

	plb
	plp
	rtl
;=====================================================================
;*			Debug Mode				*
;=====================================================================
pad_CorneriaHP1	equ	pad_Tleft!pad_Tright!pad_A
padl_CorneriaHP1	equ	padl_Tleft!padl_Tright!padl_A
pad_CorneriaHP0	equ	pad_Tleft!pad_Tright!pad_X
padl_CorneriaHP0	equ	padl_Tleft!padl_Tright!padl_X
pad_FinalBoss	equ	pad_Tleft!pad_Tright!pad_Y
padl_FinalBoss	equ	padl_Tleft!padl_Tright!padl_Y
;---------------------------------------------------------------------
mm_bugcheck
	longa
	longi
	ifne	kbugsw
;---------------------------------------------------------------------
;* Corneria Hit Point <-- 0 *
.check1
	km_acmpkeydown	CorneriaHP1
	bne	.check2
	km_setval	kx_corneriaHP,1
	km_setval	kx_corneriaDamage,99
;;;	km_setmissionsyori	gameover
;;;	km_setmismapsyori	missiongameover
;---------------------------------------------------------------------
.check2
	km_acmpkeydown	CorneriaHP0
	bne	.check3
	km_setval	kx_corneriaHP,0
	km_setval	kx_corneriaDamage,100
	km_setmissionsyori	gameover
	km_setmismapsyori	missiongameover
;---------------------------------------------------------------------
.CHECK3
	km_testkeydown	select
	beq	.check4
	km_bitcheckflag16	mmx_cursorflag,curf_hitplanet
	beq	.check4

	ldy	kx_tmpplanetptr	;Planet List Pointer
	km_testjoypad	Tright
	beq	.skip3_1
	a8
	lda.w	mmx_planetskill,y
	inc	a
	sta.w	mmx_planetskill,y
	a16
	bra	.skip3_end
.skip3_1
	km_testjoypad	Tleft
	beq	.skip3_end
	a8
	lda.w	mmx_planetskill,y
	dec	a
	a16
	sta.w	mmx_planetskill,y
.skip3_end
;---------------------------------------------------------------------
.CHECK4
	km_testkeydown	select
	beq	.check5
	km_bitcheckflag16	mmx_cursorflag,curf_hitenemy
	beq	.check5
	ldy	kx_enarrivetmptr
	km_testjoypad	Tright
	beq	.skip4_1
	a8
	lda.w	mmx_enskill,y
	inc	a
	sta.w	mmx_enskill,y
	a16
	bra	.skip4_end
.skip4_1
	km_testjoypad	Tleft
	beq	.skip4_end
	a8
	lda.w	mmx_enskill,y
	dec	a
	sta.w	mmx_enskill,y
	a16
.skip4_end
;---------------------------------------------------------------------
.check5
	km_acmpkeydown	FinalBoss
	bne	.check6

	km_setval	KGameMapPtr,stg_ext2
	km_setval	currentlevel,0
	km_setval	kw_MisMapSyori,mmsy_finalboss
	km_setmismapflag	finalboss


;---------------------------------------------------------------------
.check6
;---------------------------------------------------------------------
	endc
	rts

;=====================================================================
;*			Recover Hit Point			*
;*								*
;=====================================================================
mm_recoverHP
	shorta
	longi
	km_bitcheckmismapstflag	gmframesyori
	beq	.end
;* Collision Check
	a16
	km_loblda	mmx_arwingposx+1
	sta	kz_x1
	km_loblda	mmx_arwingposy+1
	sta	kz_y1
	km_loblda	kx_mshipx
	sta	kz_x2
	km_loblda	kx_mshipy
	sta	kz_y2
	lda	#mshipcoll
	sta	kz_z1
	km_jsr	mm_checkcollision
	a8
	bcc	.end
;* Time Check *
	a16
	lda	#1
	jsl	kspeedupA_l
	a8
	clc
	adc	kx_mshiprecovertm
	sta	kx_mshiprecovertm
	cmp	#recovertm
	bcc	.end
	sec
	sbc	#recovertm
	sta	kx_mshiprecovertm
;* Recover Hit Point *
	lda	p1_hp
	cmp	#player_HP
	beq	.end
	and	#%11111100
	clc
	adc	#4
	sta	p1_hp

	ksound	recoverHP

.end
	rts
;=====================================================================
;*		Trigger Routine (For Demo Enemy Appear)		*
;=====================================================================
mm_DemoStepUpAppear
	a16
	longi
	km_bitcheckmismapflag	explain1
	beq	.end
	km_cmpcheck	kx_demonumber,demo_enemyappeartrig
	bne	.end

	ldx	#stup_easytmbase
	lda	kdifficulty
	beq	.skip	;easy
	ldx	#stup_normaltmbase
	dec	a
	beq	.skip	;normal
	ldx	#stup_hardtmbase
.skip
	ldy	kx_planetlistptr
	a8
	romnastyoff
	a16
.loop
;* step up states *
;* step up wo 6 game fram okini appear !
.stupappear
	km_setstepupmode	wait,y
	lda.l	StepupAppTmTbl,x		;wait time
	sta.w	mmx_stupwaittm,y
.nextplanet
	inx
	inx

	lda.w	mmx_planetnext,y
	tay
	dec	mmx_stepupsetcnt
;	cpy	kx_corneriaptr	;check suru planet = corneria 
	bne	.loop
	km_setval	kx_demonumber,demo_enemyappear

	a8
	romnastyon
.end
	a8
	rts

StepupAppTmTbl
	dw	stup_initappeartmE1
	dw	stup_initappeartmE2
	dw	stup_initappeartmE3
	dw	stup_initappeartmE4
	dw	stup_initappeartmE5
	dw	stup_initappeartmE6

	dw	stup_initappeartmN1
	dw	stup_initappeartmN2
	dw	stup_initappeartmN3
	dw	stup_initappeartmN4
	dw	stup_initappeartmN5
	dw	stup_initappeartmN6

	dw	stup_initappeartmH1
	dw	stup_initappeartmH2
	dw	stup_initappeartmH3
	dw	stup_initappeartmH4
	dw	stup_initappeartmH5
	dw	stup_initappeartmH6
;=====================================================================
;*								*
;*			Mission Map Sound			*
;*								*
;=====================================================================
mm_soundBGM
	a16
	longi

	ldx	kx_CorneriaHP
	lda	kw_mmBGMPtr
	beq	.Attention
	dec	a
	beq	.Danger
	bra	.NoTChangeBGM
.Attention
	cpx	#corneriaAttentionHP+1
	bcs	.NotChangeBGM
	inc	kw_mmBGMPtr
	lda	#kbgm_attention
	bra	.SetBGM
.Danger
	cpx	#corneriaDangerHP+1
	bcs	.NotChangeBGM
	inc	kw_mmBGMPtr
	lda	#kbgm_danger
	bra	.SetBGM
.SetBGM
	a8
	sta	kw_mmBGM
	KBGM_a
	a16
.NoTChangeBGM

;	ldy	kx_enlistptr
;	km_beq	.enemyend	;No Enemy
;.loop
;
;	km_bitcheckflag.w	mmx_enflags,enfl_defence2,y
;	beq	.nextenemycheck
;	km_setval	kw_mmBGM,mmbgm_danger
;	bra	.enemyend
;.nextenemycheck
;	lda.w	mmx_ennext,y
;	tay
;	bne	.loop
;.enemyend
;----------------------------------------------------------
;Arwing Boost
	km_bitcheckflag16	mmx_arwingflag,mmf_go
	beq	.stop
	km_bitcheckflag16	mmx_cursorflag,curf_gospup
	bne	.speedup

	lda	#sport1_eng
	bra	.ArwingSndEnd
.speedup
	lda	#sport1_boost
	bra	.ArwingSndEnd
.stop
	lda	#sport1_stop
.ArwingSndEnd
	a8
	km_setsoundport1
	a16
;----------------------------------------------------------
;SOS Appear
	km_bitcheckflag	kw_mmsoundflag,mmsndf_sosappear
	beq	.skip3
	ksound	en_sos_appear
.skip3
;----------------------------------------------------------
;Step Up Appear
	km_bitcheckflag	kw_mmsoundflag,mmsndf_stupappear
	beq	.skip4
	ksound	en_step_appear
.skip4
;----------------------------------------------------------
	km_bitcheckflag16	kw_mmsoundflag,mmsndf_corneriaexplode
	beq	.skip5
	ksound	corneria_explode
.skip5
;----------------------------------------------------------
	km_bitcheckflag16	kw_mmsoundflag,mmsndf_stupin
	beq	.skip6
	ksound	en_star_senryou
.skip6
;----------------------------------------------------------
.end
	km_clrflag16	kw_mmsoundflag,mmsndf_all
	rts

;*********************************************************************
;*								*
;*		On RAM PROGRAM (Sub Routine)			*
;*								*
;*********************************************************************
;=====================================================================
;*								*
;*	Mission Map Demo Scroll (StepUp Go !!)			*
;*								*
;=====================================================================
mm_pausecheck
	LONGA
	LONGI
	km_bitcheckmismapfzflag	pausefreeze
	bne	.end
;---------------------------------------------------------------------
;*			 Demo Ver Check				*
;---------------------------------------------------------------------
.Demo
	IFEQ	1
	km_testgmjoypad	A
	bne	.A
	km_testgmjoypad	B
	bne	.B
	km_testgmjoypad	X
	bne	.X
	km_testgmjoypad	Y
	bne	.Y
	bra	.skip1
.A
	km_setval	kx_demonumber,demo_scrollopentrig
	bra	.skip1
.B
	km_setval	kx_demonumber,demo_scrollclosetrig
	bra	.skip1
.X
	km_setval	kx_demonumber,demo_explainstart
	bra	.skip1
.Y
	km_setval	kx_demonumber,demo_explainfinish
.skip1
	ENDC
;---------------------------------------------------------------------
;*			Check Start				*
;---------------------------------------------------------------------
	km_bitcheckmismapstflag	gmframesyori
	beq	.end
;---------------------------------------------------------------------
	km_bitcheckmismapfzflag	bossfreeze
	bne	.final_boss
	km_bitcheckmismapflag	explain1
	bne	.explain_demo
	bra	.Scroll_check
;---------------------------------------------------------------------
;* final boss *
.final_boss
	bra	.Scroll_check
;---------------------------------------------------------------------
;* explain demo totyuu cancel check *
.Explain_Demo
	km_testgmjoypad	start
	beq	.Scroll_check
.Explain_DemoFinish	;(If Start Button Push !!)
	km_setmismapflag	expcancel
	km_clrmistotalflag	initialmap
	km_setmismapsyori	explainfinish
	bra	.end
;---------------------------------------------------------------------
;* Scroll Wait Finish Check *
.Scroll_check
	lda	mmx_scrollwaittm
	beq	.nowait			;wait timer = 0
	dec	a
	sta	mmx_scrollwaittm
	bne	.END		;waiting timer

	lda	mmx_pausescroll
	cmp	#scrl_openscrollwait
	beq	.openscroll
	cmp	#scrl_closescrollwait
	beq	.closescroll
	cmp	#scrl_pausekeywait
	beq	.pauseenable
	jml	mim_blink
;-------------------------------------------
.pauseenable
	lda	#scrl_pause
	bra	.SetScrollTrigger
.openscroll
	lda	#scrl_openscroll
	bra	.SetScrollTrigger
.closescroll
	lda	#scrl_closescroll
.SetScrollTrigger
	sta	mmx_pausescroll
;-------------------------------------------
.END
	rts
;=====================================================================
;*		Demo Ver / Normal Game Map Ver 			*
;=====================================================================
.nowait
	km_bitcheckmismapflag	finalboss
	bne	.FinalBossDemoCheck
	km_bitcheckmismapflag	explain1
	bne	.ExplainDemoCheck
	brl	.NormalGame
;---------------------------------------------------------------------
;*			Final Boss Demo				*
;---------------------------------------------------------------------
.FinalBossDemoCheck

;---------------------------------------------------------------------
;*			Explain Demo				*
;---------------------------------------------------------------------
.ExplainDemoCheck
	lda	mmx_pausescroll
	beq	.Noscroll_democheck
	cmp	#scrl_pause
	beq	.Noscroll_democheck
	cmp	#scrl_closefinish
	beq	.closescroll_finish
	bra	.END
.Noscroll_Democheck
	km_cmpcheck	kx_demonumber,demo_scrollopentrig
	beq	.opendemo_start
	km_cmpcheck	kx_demonumber,demo_scrollclosetrig
	beq	.closedemo_start
	km_cmpcheck	kx_demonumber,demo_explainfinish
	km_beq	.Explain_DemoFinish
	brl	.END

;	km_cmpcheck	kx_demonumber,demo_explainstart
;	beq	.END
;	km_cmpcheck	kx_demonumber,demo_enemyappeartrig
;	km_beq	.END

.opendemo_start
	km_setval	kx_demonumber,demo_scrollopen
	km_setval	mmx_pausescroll,scrl_openscrollwait
	km_setval	mmx_scrollwaittm,3
	km_setmismapstflag	bg1scrtrans
	brl	.END

.closedemo_start
	km_setval	kx_demonumber,demo_scrollclose
	km_setval	mmx_pausescroll,scrl_closescrollwait
	km_setval	mmx_scrollwaittm,5
	stz	faceshutter_count
	brl	.END

.closescroll_finish
	lda	#scrl_normal
	sta	mmx_pausescroll
	km_clrmismapstflag	bg1scrtrans

	km_bitcheckmismapflag	finalboss
	bne	..finalboss
..explain
	km_setval	kx_demonumber,demo_enemyappeartrig
	brl	.END
..finalboss
	km_setval	kw_FinalBossSeq,fbseq_bossappeartrig
	brl	.END
;---------------------------------------------------------------------
;*			Normal Game Check			*
;---------------------------------------------------------------------
;* Pause Key Enable Check *
.NormalGame
	lda	mmx_pausescroll
	beq	.pausekeycheck
	cmp	#scrl_pause
	beq	.pausekeycheck
	cmp	#scrl_closefinish
	beq	.closefinish
	brl	.END
;* pause check *
.pausekeycheck
	km_bitcheckflag16	kw_mismapfreezeflag,(kfz_syorifreeze!kfz_bossfreeze)
	km_bne	.END

	km_testgmjoypad	Pause
	km_beq	.END
	km_eorflag16	mmx_cursorflag,curf_pausecheck
	km_bitcheckflag16	mmx_cursorflag,curf_pausecheck
	beq	.pauseoff
	bra	.pauseon
.pauseon
	km_setgameflag	pause		;[pause on]
	km_setmismapstflag	bg1scrtrans
	km_setmismapfzflag	timefreeze
	ksound	pauseon
	km_setval	mmx_pausescroll,scrl_openscrollwait
	km_setval	mmx_scrollwaittm,3
	brl	.END
;------------------------------------------------
.pauseoff
	ksound	pauseoff
	km_setval	mmx_pausescroll,scrl_closescrollwait
	km_setval	mmx_scrollwaittm,5
	stz	faceshutter_count
	brl	.END
;------------------------------------------------
.closefinish
	lda	#scrl_normal
	sta	mmx_pausescroll
	km_clrgameflag		pause		;[pause off]
	km_clrmismapfzflag	timefreeze	;[timer start]
	km_clrmismapstflag	bg1scrtrans
	brl	.END

;=====================================================================
;*			Pause Scroll				*
;* data bank 7e							*
;=====================================================================
mm_PauseScroll
	a16
	longi
;* Pause Scroll Type Check *
	lda	mmx_pausescroll
	cmp	#scrl_openscroll
	beq	.open_scroll
	cmp	#scrl_closescroll
	beq	.close_scroll
	bra	.end
;---------------------------------------------------------------------
.open_scroll
;* andorof screen *
	lda	kx_hscrollp2
	cmp	#$100
	beq	.scrollfinish_pauseon
	clc
	adc	#$10
	sta	kx_hscrollp2
	sta	kw_bg3hofs

;* pepper screen *
	lda	kx_hscrollp1
	sec
	sbc	#$10
	and	#$1ff
	sta	kx_hscrollp1
	bra	.end
.scrollfinish_pauseon
	km_setval	mmx_pausescroll,scrl_pausekeywait
	km_setval	mmx_scrollwaittm,3
	bra	.end
;---------------------------------------------------------------------
.close_scroll
;* andorof screen *
	lda	kx_hscrollp2
	beq	.scrollfinish_pauseoff
	sec
	sbc	#$10
	sta	kx_hscrollp2
	sta	kw_bg3hofs

;* pepper screen *
	lda	kx_hscrollp1
	clc
	adc	#$10
	and	#$1ff
	sta	kx_hscrollp1
	bra	.end
.scrollfinish_pauseoff

	km_setval	mmx_pausescroll,scrl_closefinish
;---------------------------------------------------------------------
.end
	a8
	rts

;=====================================================================
;*								*
;*			Check Button & Key			*
;*								*
;=====================================================================
mm_checkbutton
	longa
 	longi
;* flag clear *
	km_clrflag16	mmx_cursorflag,(curf_pushA!curf_hitplanet!curf_samearwing)
;---------------------------------------------------------------------
;* cancel ready speed up *
	km_testjoypad	UDLR
	beq	.CancelReadySpeedUp
	km_clrflag16	mmx_cursorflag,curf_readyspup
.CancelReadySpeedUp
;---------------------------------------------------------------------
;* arwing ga cursor postion to onaji dattra !! *
	a8
	lda	mmx_curposx
	cmp	mmx_arwingposx+1
	bne	.CheckArwingMove
	lda	mmx_curposy
	cmp	mmx_arwingposy+1
	bne	.CheckArwingMove
.SamePostion
	a16
	km_setflag16	mmx_cursorflag,curf_samearwing
.CheckArwingMove
;---------------------------------------------------------------------
	a16
;* ketei button check *
	km_testkeydown	kettei
	km_beq	.NoPushOK

;* Random Pointer *
	jsl	KGetRandomPtr_l
;* moshi cursor to arwing ga onaji zahyou ni itara !! *
	km_bitcheckflag16	mmx_cursorflag,curf_samearwing
         	bne	.SpeedUp

;* ketei button check (trigge) *
	km_testjoypad	kettei
	beq	.SpeedUpTimerCheck	
	km_bitcheckflag16	mmx_cursorflag,curf_readyspup
	bne	.Force_Timer0

	km_clrflag16	mmx_arwingflag,(mmf_arvx!mmf_arvy!mmf_boost)
	km_setflag16	mmx_arwingflag,(mmf_initmove!mmf_go)
	km_setflag16	mmx_cursorflag,(curf_destdisp!curf_pushA!curf_readyspup)
	km_setval	mmx_curwaittm,15

	km_setvar	kx_currentplanetptr,kx_tmpplanetptr

	ksound	map_place_set
	bra	.SpeedUpTimerCheck	
;-----------------------------------------------------------------------
.Force_Timer0
	km_setval	mmx_curwaittm,0
;-----------------------------------------------------------------------
.SpeedUpTimerCheck
	lda	mmx_curwaittm
	beq	.SpeedUp
	dec	a
	sta	mmx_curwaittm
	bne	.NoPushOK
;-----------------------------------------------------------------------
.SpeedUp
	km_setflag16	mmx_cursorflag,curf_gospup

	km_bitcheckflag16	mmx_arwingflag,mmf_boost
	bne	.nosnd_boost
	km_bitcheckflag16	mmx_arwingflag,mmf_go
	beq	.nosnd_boost

	km_setflag16	mmx_arwingflag,mmf_boost
	ksound	boost
.nosnd_boost
;-----------------------------------------------------------------------
.NoPushOK
;---------------------------------------------------------------------
;* arwing stop *
	km_testjoypad	Cancel
	beq	.NotCancel
	km_bitcheckflag16	mmx_cursorflag,curf_destdisp
	beq	.NotCancel
	km_clrflag16	mmx_arwingflag,mmf_go
	km_clrflag16	mmx_cursorflag,(curf_destdisp!curf_goplanet!curf_readyspup)
	ksound	cancel
.NotCancel
;------------------------------------------------------------
	km_testjoypad	TLeft
	beq	.NoPushTleft
.NoPushTleft
;---------------------------------------------------------------------
	km_testjoypad	TRight
	beq	.NoPushTRight
.NoPushTRight
;---------------------------------------------------------------------
.CheckSpeedUp
	km_bitcheckmismapstflag	gmframesyori
	beq	.Skip_SpeedUp

	km_bitcheckflag16	mmx_cursorflag,curf_gospup
	beq	.NormalSpeed

	km_setmismapstflag	speedup
;;;;	km_setval	mmw_speedup,8
	bra	.Skip_SpeedUp
.NormalSpeed
	km_clrmismapstflag	speedup
;;;;	km_setval	mmw_speedup,1
.Skip_SpeedUp
;---------------------------------------------------------------------
.end
	rts


	IFEQ	1
;---------------------------------------------------------------------
;* speed up *
	km_testjoypad	kettei
	beq	.NotPush_SpeedUP
;* 2 kaime ikou *
	km_bitcheckflag16	mmx_cursorflag,curf_readyspup
	bne	.speedupStart
.readyspeedup
;1 kai dake kuru (trigger)
	km_clrmismapstflag	speedup
	km_setflag16	mmx_cursorflag,curf_readyspup
	km_clrflag16	mmx_cursorflag,curf_gospup
	km_setval	mmx_curwaittm,15
	ksound	map_place_set
.NotPush_SpeedUP
;------------------------------------------------------------
;* kettei button wo zutto oshiteiruto arwing kasoku !! *
	km_testkeydown	kettei
	beq	.CancellSpeedUp

	dec	mmx_curwaittm
	bne	.NotTimerSpeedUp
;------------------------------------------------------------
.SpeedUPStart
	km_bitcheckflag16	mmx_cursorflag,curf_gospup
	bne	.NotPush_SpeedUP
	km_setflag16	mmx_cursorflag,curf_gospup
	ksound	boost
	bra	.NotTimerSpeedUp
.cancellSpeedUp
	km_clrflag16	mmx_cursorflag,curf_gospup
.NotTimerSpeedUp
	ENDC
;=====================================================================
;*			Set Cursor Postion			*
;* db 7e								*
;=====================================================================
mm_movecursor
	a16
	longi
;----------------------
;* moshi arwing no idoutyuu dattara cursor wa ugokanai *
;	km_bitcheckflag	mmx_arwingflag,mmf_go
;	km_bne	.end
;---------------------------------------------------------------------
;* key push check *
.check_tenkey
	km_readkeydown
	bit	#(pad_up!pad_down!pad_left!pad_right)
	bne	.push_tenkey
;----------------------
.nopush_tenkey
	km_clrflag16	mmx_cursorflag,curf_keypush
	km_stxval	mmx_curaccel,0
	km_stxval	mmx_curaccelx,0
	km_stxval	mmx_curaccely,0
	brl	.end
;----------------------
.push_tenkey
	longa
;* Inc Random Pointer *
	jsl	KGetRandomPtr_l
;* cursor speed *
	km_addgtumax	mmx_curaccel,$80,$400

;* cursor ga PLANET ni HIT shiteite sono cursor no idou check *
	km_andcmpcheckflag	mmx_cursorflag,(curf_keypush!curf_hitplanet)
	km_beq	.end

	km_setflag16	mmx_cursorflag,curf_keypush ;REPEAT FLAG ON

	km_bitcheckflag16	mmx_cursorflag,curf_hitplanet
	km_bne	.specialmove
;******** cursor Move **********
.checkmove
	a8
	km_readkeydown_h
	bit	#padl_up
	bne	.up
	bit	#padl_down
	bne	.down
	km_stxval	mmx_curaccely,0
	bra	.check_lr
;-----------------------------------
.up
	km_negstavar	mmx_curspeedy,mmx_curspeed
	bra	.check_lr
;-----------------------------------
.down
	km_setvar	mmx_curspeedy,mmx_curspeed
;-----------------------------------
.check_lr
	km_readkeydown_h
	bit	#padl_left
	bne	.left
	bit	#padl_right
	bne	.right
	km_stxval	mmx_curaccelx,0
	bra	.set_postion
;-----------------------------------
.left
	km_negstavar	mmx_curspeedx,mmx_curspeed
	bra	.set_postion
;-----------------------------------
.right
	km_setvar	mmx_curspeedx,mmx_curspeed
;*************** cursor zahyou set **************
.set_postion
	km_jsr	mm_setcurpos_sub
	BRA	.end
;---------------------------------------------------------------------
;*		Planet wo kakomu cursor no cancell		*
;---------------------------------------------------------------------
.specialmove
	a8
	LONGI
	km_readkeydown_h
	bit	#padl_up
	bne	.sp_up
	bit	#padl_down
	bne	.sp_down
	bra	.check_lrsp
;-----------------------------------
.sp_up
	km_stxval	mmx_curspeedy,-32-1
	bra	.check_lrsp
;-----------------------------------
.sp_down
	km_setval	mmx_curspeedy,16+1
;-----------------------------------
.check_lrsp
	km_readkeydown_h
	bit	#padl_left
	bne	.sp_left
	bit	#padl_right
	bne	.sp_right
	bra	.set_postion2
;-----------------------------------
.sp_left
	km_setval	mmx_curspeedx,-32-1
	bra	.set_postion2
;-----------------------------------
.sp_right
	km_setval	mmx_curspeedx,16+1
;-----------------------------------
.set_postion2
	km_jsr	mm_setcurpos_sub

	a16
	km_setflag16	mmx_cursorflag,curf_wkcancel
	km_stxval	mmx_curaccel,0
	km_stxval	mmx_curaccelx,0
	km_stxval	mmx_curaccely,0
.end
	a8
	rts
;-------------------------------------------------------------------------
;*
;-------------------------------------------------------------------------
mm_setcurpos_sub
	shorta
	longi
;* cursor X zahyou *
	lda	mmx_curposx
	clc
	adc	mmx_curspeedx
	cmp	#16		;Left edge
	bcc	.nosetx
	cmp	#$100-16	;Right edge
	bcs	.nosetx
	sta	mmx_curposx
.nosetx
;* cursor Y zahyou *
	lda	mmx_curposy
	clc
	adc	mmx_curspeedy
	cmp	#$34		;Top edge
	bcc	.nosety
	cmp	#$d8		;Bottom edge
	bcs	.nosety
	sta	mmx_curposy
.nosety
	rts

;=====================================================================
;*			Cursor Collision Check 			*
;* data bank :7e							*
;=====================================================================
mm_CollisionCursor
	shorta
	longi
;---------------------------------------------------------------------
;*		Cursor Hit Check To Planet			*
;---------------------------------------------------------------------
	lda	mmx_curposx
	sta	kz_x1			;X postion
	lda	mmx_curposy
	sta	kz_y1			;Y postion
	lda	#16
	sta	kz_z1			;Collision Area
	km_styvar	kz_textpt,0	;Planet List Check End Pointer
	km_jsr	PlanetCollisionCheck
	bcc	.SOSEnemy		;(No Hit)
;--------------------------------------
.HitPlanet
	shorta
	sty	kx_tmpplanetptr		;Kari Planet List Pointer

	lda.w	mmx_planetcx,y
	sta	mmx_bigcurposX
	sta	mmx_mapcursorX	;(For Message)
	lda.w	mmx_planetcy,y
	sta	mmx_bigcurposY
	sta	mmx_mapcursory	;(For Message)
	lda.w	mmx_stage,y
	sta	mmx_planetname
	lda.w	mmx_planetskill,y
	sta	mmx_planetstep
	lda.w	mmx_stage,y
	sta	kx_currentplanetnum	;Planet List Number

	stz	mmx_planetstatus
	km_cmpcheck.w	mmx_pstepup,stup_attackplanet,y
	bne	.notbattle
	inc	mmx_planetstatus
.notbattle

	a16
	km_setflag16	mmx_mapcursor,1			;(For Message)
	km_setflag16	mmx_cursorflag,curf_hitplanet
	km_clrflag16	mmx_cursorflag,curf_corneria	;(For Message)
	km_bitcheckflag.w	mmx_planetflag,mmpnf_corneria,y
	beq	.skip
	km_setflag16	mmx_cursorflag,curf_corneria	;(For Message)
.skip
	a8
;---------------------------------------------------------------------
;*		Cursor Hit Check To SOS Enemy			*
;---------------------------------------------------------------------
.SOSEnemy
	km_clrflag16	mmx_cursorflag,curf_hitenemy
	lda	mmx_curposx
	sta	kz_x1			;X postion
	lda	mmx_curposy
	sta	kz_y1			;Y postion
	lda	#16
	sta	kz_z1			;Collision Area
	km_jsr	SOSCollisionCheck
	bcc	.End			;(No Hit)
;---------------------------------------------------------------------
.HitEnemy
	km_setflag16	mmx_cursorflag,curf_hitenemy
	sty	kx_enarrivetmptr
;---------------------------------------------------------------------
.End
	RTS


;=====================================================================
;*		Cursor Hit Check To SOS Enemy			*
;* data bank :7e							*
;* InPut	:(kz_x1,kz_y1) = (x,y) postion				*
;*	:kz_z1 = collision area					*
;* OutPut	:clc/sec  :No Hit / Hit					*
;*	:Yreg :Enemy List Pointer				*
;=====================================================================
SOSCollisionCheck
	shorta
	longi
	ldy	kx_enlistptr
;--------------------------------------
.CollisionCheck
	lda.w	mmx_enposx+1,y
	sta	kz_x2
	lda.w	mmx_enposy+1,y
	sta	kz_y2
	km_jsr	mm_checkcollision
	bcs	.End	;(Hit Planet)
;--------------------------------------
.NextCheck
	ldx.w	mmx_ennext,y
	txy
	bne	.CollisionCheck
	clc
;--------------------------------------
.End
	rts


;=====================================================================
;*		Collision Check Player to Planet		*
;* data bank :7e							*
;* Yreg	:Planet List Pointer					*
;* OutPut	:							*
;*	:kx_NearPlanetPtr :0... Near Planet Nashi		*
;=====================================================================
mm_CheckNearPlanet
	shorta
	longi

	km_setvar	kz_x1,mmx_arwingposx+1
	km_setvar	kz_y1,mmx_arwingposy+1
	km_setval	kz_z1,nearplanetarea
	km_styval	kz_textpt,0
	km_setval	kx_NearPlanetNum,planet_nothing

	km_jsr	PlanetCollisionCheck
	bcc	.end
	sty	kx_NearPlanetPtr
	lda.w	mmx_stage,y
	sta	kx_NearPlanetNum
.end
	rts

;=====================================================================
;*		Cursor Hit Check To Planet			*
;* data bank :7e							*
;* InPut	:(kz_x1,kz_y1) = (x,y) postion				*
;*	:kz_z1 = collision area					*
;*	:kz_textpt = check end pointer				*
;* OutPut	:clc/sec  :No Hit / Hit					*
;*	:(0~5):stage1~6, 6= corneria,7 = no near planbet	*
;*	:Yreg :Planet Pointer					*
;=====================================================================
PlanetCollisionCheck
	shorta
	longi
	ldy	kx_planetlistptr
;--------------------------------------
.CollisionCheck
	lda.w	mmx_planetcx,y
	sta	kz_x2
	lda.w	mmx_planetcy,y
	sta	kz_y2
	km_jsr	mm_checkcollision
	bcs	.End	;(Hit Planet)
;--------------------------------------
.NextCheck
	ldx.w	mmx_planetnext,y
	txy
	cpy	kz_textpt
	bne	.CollisionCheck
	clc
;--------------------------------------
.End
	rts

;=====================================================================
;*								*
;*		Collision Check Routine				*
;* Inppt  :2 zahyou (kz_x1,kz_y1),(kz_x2,kz_y2)			*
;*        :collision Area kz_z1					*
;* OutPut :Hit    :sec						*
;*        :No Hit :clc						*
;=====================================================================
mm_checkcollision
	shorta
	longi
;* X collision check *
	lda	kz_x2
	clc
	adc	kz_z1
	cmp	kz_x1
	bcc	.nohit
	lda	kz_x2
	sec
	sbc	kz_z1
	cmp	kz_x1
	bcs	.nohit
;* Y collision check *
	lda	kz_y2
	clc
	adc	kz_z1
	cmp	kz_y1
	bcc	.nohit
	lda	kz_y2
	sec
	sbc	kz_z1
	cmp	kz_y1
	bcs	.nohit
.hit
	sec
	rts
.nohit
	clc
	rts


;=====================================================================
;*		Check Arwing Destination Postion		*
;* data bank :7e							*
;=====================================================================
mm_checkplayerdestpos
	a16
	longi
;=========== Final Boss Demo Check ==============
	km_cmpcheck	kw_FinalBossSeq,fbseq_playerstart
	bne	.Normal
.FinalBoss
	ldy	kx_FinalBossPtr
	a8
	lda.w	mmx_enposx+1,y
	sta	mmx_arwingdestposx
	lda.w	mmx_enposy+1,y
	sta	mmx_arwingdestposy
	bra	.end
;-------------------------------------------------------------------
;* dest postion set *
.Normal
	LONGA
	km_bitcheckflag16	mmx_cursorflag,curf_pushA
	beq	.end		;If not Push Start or A button
	km_bitcheckflag16	mmx_cursorflag,curf_hitplanet
	beq	.notplanet	;Not Big Cursor

	a8
	ldy	kx_currentplanetptr	;Planet List Pointer
	lda.w	mmx_planetcx,y	;planet center Y
	sta	mmx_arwingdestposx
	lda.w	mmx_planetcy,y	;planet center X
	sta	mmx_arwingdestposy
	a16

	km_bitcheckflag.w	mmx_planetflag,(mmpnf_neutral!mmpnf_complete!mmpnf_corneria),y
	bne	.end
	sty	mmx_arwingdestptr	;Planet Destnition Pointer
	km_setflag16	mmx_cursorflag,curf_goplanet
	bra	.end
.notplanet
	km_clrflag16	mmx_cursorflag,curf_goplanet
	a8
	km_setvar	mmx_arwingdestposX,mmx_curposx
	km_setvar	mmx_arwingdestposY,mmx_curposy
.end
	a8
	rts
;=====================================================================
;*		Calculate Arwing Angle	(16 pattern)		*
;* data bank :7e							*
;=====================================================================
mm_calcplayerangle
	shorta
	longi

	IFEQ	1
;* cursor hit check *
	km_bitcheckflag16	mmx_cursorflag,curf_hitplanet
	bne	.go_planet
;* key push check *
	km_bitcheckflag16	mmx_cursorflag,curf_keypush
	bne	.go_planet
;* 360 kuru kuru turn *
	km_subltsmintomax	mmx_arwinganmtm,1,0,8
	cmp	#8
	bne	.end
	km_addgeumaxtomin	mmx_arwinganmptr,1,$10,0
	bra	.end

	km_testjoypad	TLeft
	beq	.skip1
	km_addgeumaxtomin	mmx_arwinganmptr,1,$10,0
.skip1

	km_testjoypad	TRight
	beq	.skip2
	km_subltsmintomax	mmx_arwinganmptr,1,0,$0f
.skip2
	bra	.end
	ENDC
;--------------------------------------------------------------------
.go_planet
	a16
	km_cmpcheck	kw_FinalBossSeq,fbseq_playerstart
	beq	.Set_dest

;* moshi kttei button ga osaretara *
	km_bitcheckflag16	mmx_cursorflag,curf_pushA
	km_bne	.Set_dest

;* moshi arwing ga idou tyu dattra !! *
	km_bitcheckflag16	mmx_arwingflag,mmf_go
	km_bne	.end

	km_lobstavar	x2,mmx_curposx
	km_lobstavar	y2,mmx_curposy
	bra	.CalcAngle
.Set_dest
	km_lobstavar	x2,mmx_arwingdestposx
	km_lobstavar	y2,mmx_arwingdestposy

.CalcAngle
	km_lobstavar	x1,mmx_arwingposx+1
	km_lobstavar	y1,mmx_arwingposy+1
	jsl	calobjangle_l

; 0 to 359 degrees is $0000 to $ffff
;----------------------------
; 4 sya 5 nyuu
	bit	#$0080
	beq	.nostepup
	inc	a
.nostepup
;----------------------------
	xba
	a8
	clc
	adc	#8
	km_divu16
	sta	mmx_arwinganmptr	;angle pointer (16 pattern) 0,1,2,3,...15
.end
	a8
	rts

;=====================================================================
;*		Calculate Arwing CGX Pointer			*
;* data bank :7e							*
;=====================================================================
mm_calcplayercgxptr
;* kuru kuru Arwing Chara CGXAddress Calc *
	a16
	longi
	lda	p1_pilotNo
	lsr	a
	and	#3
	tay
	lda	mmx_arwinganmptr
	km_loba
	cpy	#0
	beq	.setaddr1
	clc
	adc	#16	;GGarwing
	dey
	beq	.setaddr1
	clc
	adc	#16	;SParwing
.setaddr1
;* ue 2chra tensou *
	clc
	adc	mmx_sprarwingaddr
	tax

	lda.w	heap,x
	and	#$ff
	km_multa32
	clc
	adc	mmx_objcgxaddr
	sta	mmx_arwingcgxptr1
;* shita 2 chr tensou *
	clc
	adc	#$200
	sta	mmx_arwingcgxptr2
	a8
	rts
;=====================================================================
;*			 Asteroid Hit Check			*
;* data bank :7e							*
;=====================================================================
mm_HitAsteroid
	a16
	longi
	km_clrflag16	mmx_arwingflag,mmf_asteroid

	LONGA
	km_loblda.w	mmx_arwingposx+1,y
	sta	kz_x1
	km_loblda.w	mmx_arwingposy+1,y
	sta	kz_y1
	km_convVRAMSCRaddr_256	kz_x1,kz_y1
	PHX
	tax
	km_loblda.l	BGCheckBuffer,x
	PLX
.Asteroid_Check
	cmp	#$70
	bcs	.NoHitAsteroid
	cmp	#$6a
	bcc	.NoHitAsteroid
	km_setflag16.w	mmx_arwingflag,mmf_asteroid
.NoHitAsteroid
.end
	A8
	rts
;=====================================================================
;*			Set Player Postion			*
;* data bank :7e							*
;=====================================================================
mm_moveplayer
	php
	a16
	longi
	km_bitcheckmismapflag	playernocoll	;[player collision off]
	km_bne	.end

	km_bitcheckflag16	mmx_arwingflag,mmf_initmove
	bne	.initial
	km_bitcheckflag16	mmx_arwingflag,mmf_go
	bne	.playermove
	brl	.end
;---------------------------------------------------------------------
.initial
	longa
	km_clrflag16	mmx_arwingflag,mmf_initmove
	km_lobstavar	mm_sx,mmx_arwingposx+1
	km_lobstavar	mm_sy,mmx_arwingposy+1
	km_stavar	mm_sp,mmx_arwingsp
	km_lobstavar	mm_ex,mmx_arwingdestposX
	km_lobstavar	mm_ey,mmx_arwingdestposY

	km_jsr	mm_calcdxdy
	
	longa
	km_stavar	mmx_arwingspx,mm_spx
	km_stavar	mmx_arwingspy,mm_spy
	a8
	km_stavar	mmx_arwingdx,mm_dx
	km_stavar	mmx_arwingdy,mm_dy
	km_stavar	mmx_arwingdxdy,mm_dxdy
	a16
;---------------------------------------------------------------------
.playermove
	longa
	km_stavar	mm_sx,mmx_arwingposx
	km_stavar	mm_sy,mmx_arwingposy
	km_lobstavar	mm_ex,mmx_arwingdestposX
	km_lobstavar	mm_ey,mmx_arwingdestposY

	km_stavar	mm_sp,mmx_arwingsp
	km_stavar	mm_spx,mmx_arwingspx
	km_stavar	mm_spy,mmx_arwingspy

	km_lobstavar	mm_dx,mmx_arwingdx
	km_lobstavar	mm_dy,mmx_arwingdy
	km_lobstavar	mm_dxdy,mmx_arwingdxdy
	km_stavar	mm_flag,mmx_arwingflag

;------------------------------------------
	km_jsr	mm_speedupmode
;------------------------------------------

	longa
	km_jsr	mm_2pointmove
	km_stavar	mmx_arwingposx,mm_sx
	km_stavar	mmx_arwingposy,mm_sy
	km_stavar	mmx_arwingflag,mm_flag
	a8
	km_stavar	mmx_arwingdxdy,mm_dxdy
	a16
;94/11/11 :kono check wa postion (x,y) wo set shitekara okonau !!
	km_bitcheckflag16	mm_flag,mmf_finish
	beq	.end
.finish
	longa
	km_clrflag16	mmx_cursorflag,(curf_destdisp!curf_readyspup)
	km_clrflag16	mmx_arwingflag,mmf_all

	km_bitcheckflag16	mmx_cursorflag,curf_goplanet
	km_beq	.end
	km_bitcheckflag16	mmx_cursorflag,curf_corneria
	km_bne	.end

;* Mission Start *
	km_setvar	mmx_wipeposX,mmx_arwingdestposX
	km_setvar	mmx_wipeposY,mmx_arwingdestposY
	km_setmismapsyori	missionstart
	km_clrflag16	mmx_cursorflag,curf_goplanet
	km_clrmismapflag	enemy
	km_setflag16	kw_mismapflag,(kmimpf_battleplayer!kmimpf_playernocoll)
	km_setflag16	kw_mismapfreezeflag,(kfz_playerfreeze!kfz_enemyfreeze)	;[stratage off]

;* Y reg = Planet Pointer *
	ldy	mmx_arwingdestptr
	lda.w	mmx_stage,y
	km_loba
	sta	KGameMapPtr	;stage pointer
	lda.w	mmx_planetskill,y
	sta	currentlevel
	lda.w	mmx_plstackptr,y
	sta	kstacknumber

	km_setflag16.w	mmx_planetflag,mmpnf_freeze,y

;;;;	km_setmismapstflag	missionstart
;---------------------------------------------------------------------
.end
	plp
	rts
;=====================================================================
;*			Speed UP CHECK				*
;=====================================================================
mm_speedupmode
	longa
	lda	mm_spx
	jsl	kspeedupA_l
;;;	km_jsr	kasteroidA
	sta	mm_spx

	lda	mm_spy
	jsl	kspeedupA_l
;;;	km_jsr	kasteroidA
	sta	mm_spy
.end
	rts

;------------------------------------------------------------------------
kasteroidA
	longa
	longi
	pha
	km_bitcheckflag	mmx_arwingflag,mmf_asteroid
	beq	.end

	pla
	km_asra
	km_asra
	km_asra
	rts
.end
	pla
	rts
;------------------------------------------------------------------------

	ifeq	1
	km_setval	mm_sp,$0100
	lda	mm_spx
	bmi	.minusspx
.plasspx
	lda	#$0100
	bra	.staspx
.minusspx
	lda	#-$100
.staspx
	sta	mm_spx

	lda	mm_spy
	bmi	.minusspy
.plasspy
	lda	#$100
	bra	.staspy
.minusspy
	lda	#-$100
.staspy
	sta	mm_spy

	endc
;=====================================================================
;*		2 tenkan no idou				*
;* data bank :7e							*
;=====================================================================
;=====================================================================
;*		Calculation (DY/DX)				*
;=====================================================================
mm_calcdxdy
	php

	a16
;* calc DX *
	km_subvar	mm_ex,mm_sx
	sta	mm_dx
	bpl	.incx
.decx
	km_negstavar	mm_spx,mm_sp	;speed x
	bra	.skip_dx
.incx
	km_setvar	mm_spx,mm_sp	;speed x
.skip_dx
;--------------------------------------------------------
;* calc DY *
	km_subvar	mm_ey,mm_sy
	sta	mm_dy
	bpl	.incy
.decy
	km_negstavar	mm_spy,mm_sp	;speed y
	bra	.skip_dy
.incy
	km_setvar	mm_spy,mm_sp	;speed y
.skip_dy
;--------------------------------------------------------
	km_absstavar	mm_dx		;mm_dx
	km_absstavar	mm_dy		;mm_dy
	stz	mm_dxdy
	plp
	rts
;=====================================================================
;*		2 tenkan no idou				*
;* out:clc/sei ... continue / end					* 
;=====================================================================
mm_2pointmove
	php
;---------------------------------------------
;* If (sx,sy) = (ex,ey) Then Not Move Player *
	a8
	lda	mm_sx+1
	cmp	mm_ex
	bne	.skip1
	lda	mm_sy+1
	cmp	mm_ey
	bne	.skip1
	a16
	brl	.finish_move
.skip1
;--------------------------------------------
;* special move *
	a16
	lda	mm_dx
	beq	.dx0
	lda	mm_dy
	beq	.dy0
;-----------------------------------------
	lda	mm_dx
	sec
	sbc	mm_dy
	bmi	.addy
;-----------------------------------------
;dx > dy
.addx
;* ikisugi boushi flag check *
	km_bitcheckflag16	mm_flag,mmf_arvx
	bne	.skipaddx1
	km_addstavarvar	mm_sx,mm_spx
;;;	km_substavarltsmin	mm_cntx,mm_sp,0
.skipaddx1
	km_bitcheckflag16	mm_flag,mmf_arvy
	bne	.skipaddy1

	lda	mm_dxdy
	clc
	adc	mm_dy
	cmp	mm_dx
	bmi	.noaddy
	pha
	km_addstavarvar	mm_sy,mm_spy
;;;	km_substavarltsmin	mm_cnty,mm_sp,0
	pla
	sec
	sbc	mm_dx
.noaddy
	sta	mm_dxdy
.skipaddy1
	bra	.endcheck
;-----------------------------------------
;dy > dx
.addy
	km_bitcheckflag16	mm_flag,mmf_arvy
	bne	.skipaddy2
	km_addstavarvar	mm_sy,mm_spy
;;;	km_substavarltsmin	mm_cnty,mm_sp,0
.skipaddy2
	km_bitcheckflag16	mm_flag,mmf_arvx
	bne	.skipaddx2
	lda	mm_dxdy
	clc
	adc	mm_dx
	cmp	mm_dy
	bmi	.noaddx

	pha
	km_addstavarvar	mm_sx,mm_spx
;;;	km_substavarltsmin	mm_cntx,mm_sp,0
	pla
	sec
	sbc	mm_dy
.noaddx
	sta	mm_dxdy
.skipaddx2
	bra	.endcheck
;---------------------------------------------------------------------
;*		Special Move	(suityoku,myoko no idou)	*
;---------------------------------------------------------------------
.dx0	;suityoku houkou ni idou
	km_addstavarvar	mm_sy,mm_spy
	bra	.endcheck
;-----------------------------------------
.dy0	;myoko ni idou
	km_addstavarvar	mm_sx,mm_spx
;-----------------------------------------
.endcheck
	a8
	lda	mm_sx+1
	cmp	mm_ex
	a16
	bne	.nohitx
	km_setflag16	mm_flag,mmf_arvx
.nohitx
	a8
	lda	mm_sy+1
	cmp	mm_ey
	a16
	bne	.nohity
	km_setflag16	mm_flag,mmf_arvy
.nohity
	km_andcmpcheckflag	mm_flag,(mmf_arvy!mmf_arvx)
	bne	.exit
.finish_move
	km_setflag16	mm_flag,mmf_finish
	plp
	rts
.exit
	plp
	rts
;=====================================================================
;*		Move Ball ( From Arwing To Planet )		*
;=====================================================================
	IFEQ	1
moveball
	shorta
	longi
	php

;* ball set timer *
	km_submin	mmx_ballsettm,1,0

;* ball set check *
	ldx	mmx_sprballaddr
.LOOP
	shorta
	lda.w	mmx_ballflags,x		;ball buffer ari ?
	km_bne	.moveball

	lda	mmx_ballsettm		;ball set enable ?
	km_bne	.end
;---------------------------------------------------------------------
.initial
	shorta
;* flag on *
	km_setflag16.w	mmx_ballflags,1,x	;ball set flag ON
	km_setval	mmx_ballsettm,8		;timer Set
	km_setval	mmx_ballsp,8,x		;ball speed

	a16
	km_lobstavar	mm_sx,mmx_arwingposx
	km_lobstavar	mm_sy,mmx_arwingposy
	km_lobstavar	mm_ex,mmx_curposX
	km_lobstavar	mm_ey,mmx_curposY

	lda	mmx_ballsp,x
	and	#$ff
	sta	mm_sp

	km_jsr	mm_calcdxdy

	a8
	lda	mm_sx
	sta	mmx_ballsx,x
	lda	mm_sy
	sta	mmx_ballsy,x
	lda	mm_ex
	sta	mmx_ballex,x
	lda	mm_ey
	sta	mmx_balley,x
	lda	mm_spx
	sta	mmx_ballspx,x
	lda	mm_spy
	sta	mmx_ballspy,x
	lda	mm_dx
	sta	mmx_balldx,x
	sta	mmx_ballcntx,x
	lda	mm_dy
	sta	mmx_balldy,x
	sta	mmx_ballcnty,x
	lda	mm_dxdy
	sta	mmx_balldxdy,x
;---------------------------------------------------------------------
.moveball
	a16
	km_loblda	mmx_ballsx,x
	sta	mm_sx
	km_loblda	mmx_ballsy,x
	sta	mm_sy
	km_loblda	mmx_ballex,x
	sta	mm_ex
	km_loblda	mmx_balley,x
	sta	mm_ey
	km_loblda	mmx_ballsp,x
	sta	mm_sp
	km_sexvar	mmx_ballspx,x
	sta	mm_spx
	km_sexvar	mmx_ballspy,x
	sta	mm_spy
	km_loblda	mmx_balldx,x
	sta	mm_dx
	km_loblda	mmx_balldy,x
	sta	mm_dy
	km_loblda	mmx_balldxdy,x
	sta	mm_dxdy
	km_loblda	mmx_balldxdy,x
	sta	mm_dxdy
	km_loblda	mmx_ballcntx,x
;;	sta	mm_cntx
	km_loblda	mmx_ballcnty,x
;;;	sta	mm_cnty
	a8
	km_jsr	mm_2pointmove
	bcc	.skip
	km_clrflag16.w	mmx_ballflags,1,x
.skip
	lda	mm_sx
	sta	mmx_ballsx,x
	lda	mm_sy
	sta	mmx_ballsy,x
	lda	mm_dxdy
	sta	mmx_balldxdy,x
;;;	lda	mm_cntx
	sta	mmx_ballcntx,x
;;	lda	mm_cnty
	sta	mmx_ballcnty,x
.end
	a16
	txa
	clc
	adc	#mmx_balllen
	tax
	sec
	sbc	mmx_sprballaddr
	a8
	cmp	#mmx_balllen*3
	km_bne	.LOOP
	plp
	rts

	ENDC
;*********************************************************************
;*								*
;*		BG CGX & SCREEN SET				*
;*								*
;*********************************************************************
;---------------------------------------------------------------------
;*			Game Total Timer 	[Mission Map]	*
;* Data Bank :7e							*
;---------------------------------------------------------------------
	shorta
	longi
mm_dispgametotaltm
	a16
	lda	kx_TOTALTIME
	ldx	#4
	km_jsr	convHextoDecimal
;* Set Screen *
	a8
	km_setval	kz_x1,$0e	;[top x zahyou]
	km_setval	kz_y1,$3	;[top y zahyou]
	km_setval	kz_z1,0		;[character hosei]
	km_setval	kz_tpx,4	;[ketasuu]
	km_jsr	setscrbuf_sub
	rts
;---------------------------------------------------------------------
;*			Enemy Total Number 	[Mission Map]	*
;* Data Bank :7e							*
;---------------------------------------------------------------------
	shorta
	longi
mm_dispenemytotal
	a16
;	lda	kx_enemytotal
;	lda	checkirq2
;	lda	checkirq3
	lda	kx_clrenemytotal
	ldx	#2			;[ketasuu]
	km_jsr	convHextoDecimal
;* Set Screen *
	a8
	km_setval	kz_x1,$1c	;[top x zahyou]
	km_setval	kz_y1,$3	;[top y zahyou]
	km_setval	kz_z1,$20	;[character hosei]
	km_setval	kz_tpx,2	;[ketasuu]
	km_jsr	setscrbuf_sub
	rts
;---------------------------------------------------------------------
;*		Display Score 		 	[Mission Map]	*
;* Data Bank :7e							*
;---------------------------------------------------------------------
	shorta
	longi
mm_dispScore
	a16
	lda	kw_totalscore1
	ldx	#5			;[ketasuu]
	km_jsr	convHextoDecimal
;* Set Screen *
	a8
	km_setval	kz_x1,$08	;[top x zahyou]
	km_setval	kz_y1,$19	;[top y zahyou]
	km_setval	kz_z1,$20	;[character hosei]
	km_setval	kz_tpx,5	;[ketasuu]
	km_jsr	setscrbuf_sub
	rts
;---------------------------------------------------------------------
;*			Display Item Number 	[Mission Map]	*
;* Data Bank :7e							*
;---------------------------------------------------------------------
	shorta
	longi
mm_dispItem
	a16
	km_loblda	p1_spweap_LMT	;kx_weaponnum1
	ldx	#1			;[ketasuu]
	km_jsr	convHextoDecimal
;* Set Screen *
	a8
	km_setval	kz_x1,$0c	;[top x zahyou]
	km_setval	kz_y1,$17	;[top y zahyou]
	km_setval	kz_z1,$20	;[character hosei]
	km_setval	kz_tpx,1	;[ketasuu]
	km_jsr	setscrbuf_sub
	rts
;---------------------------------------------------------------------
;*			Display Crystal Number 	[Mission Map]	*
;* Data Bank :7e							*
;---------------------------------------------------------------------
	shorta
	longi
	IFEQ	1
mm_dispCrystal
	a16
	km_loblda	KCrystalNumber
	ldx	#2			;[ketasuu]
	km_jsr	convHextoDecimal
;* Set Screen *
	a8
	km_setval	kz_x1,$0b	;[top x zahyou]
	km_setval	kz_y1,$0a	;[top y zahyou]
	km_setval	kz_z1,$20	;[character hosei]
	km_setval	kz_tpx,2	;[ketasuu]
	km_jsr	setscrbuf_sub
	rts
	ENDC
;---------------------------------------------------------------------
;*		Display Corneria Damage Number 	[Mission Map]	*
;* Data Bank :7e							*
;---------------------------------------------------------------------
	shorta
	longi
mm_dispDamage
	a16
	lda	kx_CorneriaDamage
	ldx	#2			;[ketasuu]
	km_jsr	convHextoDecimal
;* Set Screen *
	a8
	km_setval	kz_x1,$07	;[top x zahyou]
	km_setval	kz_y1,$13	;[top y zahyou]
	km_setval	kz_z1,$20	;[character hosei]
	km_setval	kz_tpx,2	;[ketasuu]
	km_jsr	setscrbuf_sub
	rts

;---------------------------------------------------------------------
;*		Convert Hex Value to Decimal			*
;* Input	:Acc :Source Value					*
;*	:Xreg :ketasuu						*
;* OutPut	:kx_DecimalBuffer (...,1000,100,10,1 no jyunban)	*
;* Temp Work :kz_x1							*
;---------------------------------------------------------------------
convHextoDecimal
	longa
	longi
	PHY
	dex
.loop
	phx
	km_ramcpudivu16uf8	xy,10
	stx	kz_x1
	plx
	a8
	tya
	sta	kx_DecimalBuffer,x
	a16
	lda	kz_x1
	dex
	bpl	.loop
	PLY
	rts

;---------------------------------------------
;* 	Sub Routine 			*
;* Set Order: (...,1000,100,10,1 no jyunban)	*
;* Init :kz_x1 :x zahyou			*
;*      :kz_y1 :y zahyou			*
;*      :kz_z1 :character hosei		*
;*      :kz_tpx:ketasuu			*
;---------------------------------------------
	shorta
	longi
setscrbuf_sub
	km_convSCRaddr_32X	kz_x1,kz_y1
	ldy	#0
.loop
	lda	kx_DecimalBuffer,y
	clc
	adc	kz_z1
	sta.l	mmxx_screenbuffer+0,x	;hidari ue chara
	clc
	adc	#$10
	sta.l	mmxx_screenbuffer+64,x	;hidari shita chara
	iny
	inx
	inx
	dec	kz_tpx
	bne	.loop

	rts
;---------------------------------------------------------------------
;*		DIVISION [unsign 16bit/unsign 8bit]		*
;* Init :Acc (warareru kazu), Xreg (waru kazu)			*
;* Exit :Xreg (syou) ,Yreg(amari)					*
;* a16,i16								*
;---------------------------------------------------------------------
ramdivu16u8_sub
	longa
	longi
	sta.l	wrdivl	;warareru kazu
	txa
	a8
	sta.l	wrdivb	;waru kazu
	a16
;* 16 cycle wait *
	nop	;2
	nop	;4
	nop	;6
	nop	;8
	nop	;10
	nop	;12
	nop	;14
	nop	;16

	lda.l	rddivlr		;syou
	tax
	lda.l	rdmpylr		;amari
	tay
	rts
;=====================================================================
;*			Palette Change				*
;* mem8 idx16							*
;*colptr_0	:color table pointer (step 32)				*
;*coladr_0	:color table address					*
;=====================================================================
mm_changecolpal
	shorta
	longi
	a16
	km_bitcheckgameflag	pause
	km_bne	.end
	km_bitcheckscreenflag	bgcolpal	;[SCREEN FLAG]
	km_beq	.end
;--------------------------------------------------
	a8
;* colour timer set *
;* 10 Flame ni 1 kai colour change *
	km_setval	kz_x1,1
	km_bitcheckmismapstflag	speedup
	beq	.nomalspeed
	km_setval	kz_x1,5
.nomalspeed
	lda	coltimer_0
	sec
	sbc	kz_x1
	bpl	.NoColChange
	km_addstaval	colptr_0,32	;Pointer +32 add

	lda	#10			;Timer Reset
.NoColChange
	sta	coltimer_0
;--------------------------------------------------
	a16
	lda	colptr_0
	and	#$ff
	clc
	adc	#kx_palette2&WM
	sta	coladr_0	;address
.set_bank
	a8
	lda	#kx_palette2>>16
	sta	coladr_0+2	;bank
;--------------------------------------------------
.end
	a8
	rts

;*********************************************************************
;*								*
;*			Set Sprites				*
;* data bank :7e							*
;*********************************************************************
mm_dosprites
	shorta
	longi
	ldy	sprpointer
;=====================================================================
;*			Frame Timer Set				*
;=====================================================================
	lda	mmx_8frameTm
	inc	a
	and	#$7
	sta	mmx_8frameTm
	and	#$3
	sta	mmx_4frameTm
	and	#$1
	sta	mmx_2frameTm
;=====================================================================
;*		Pause tyuu mo deteiru				*
;=====================================================================
;***** Pause Sprite (for yajima) ****
	lda	mmx_pausescroll
	cmp	#scrl_pausekeywait
	beq	.pauseobj
	cmp	#scrl_closescrollwait
	beq	.pauseobj
	cmp	#scrl_pause
	beq	.pauseobj
	bra	.skip
.pauseobj
	km_jsr	mappause_objset
.skip
;-----------------------------------------------------------------------
;**** yajirushi (for mission map explain :yajima's) *****
	km_jsr	yajirushi_animation	; demo yajirushi animetion

;***** Player HP *********
	a16
	lda	p1_hp
	and	#$3f
	sta	kz_x1	;HP

	lda	#$1728
	sta	kz_x2	;(X,Y) offset postion
	a8
	jsl	SetSprDamageMeter_l

;***** player character *****
	a16
	km_SetSpriteImXY	$2*8,$3*8
	km_mmsetspritesizedouble

	km_lldasla	p1_pilotNo
	km_SetSpriteChrA	$20,colpal0,pri2,noflip,mm_obj_offset

;***** Enemy Mark ******
	longa
	lda	mmx_2frameTm
	bne	.DisplayDokuroMark

	lda	mmx_DokuroMark
	inc	a
	inc	a
	and	#7
	sta	mmx_DokuroMark
.DisplayDokuroMark
	lda	#($18*8+3*8<<8)
	km_jsr	dokuro_enemy

	lda	mmx_8frameTm
	bne	.DisplaySOSMark
	lda	mmx_SOSMark
	inc	a
	and	#7
	sta	mmx_SOSMark
.DisplaySOSMark
	km_setval	kz_tpx,$17*8
	km_setval	kz_tpy,4*8
	km_setvar	kz_x1,mmx_SOSMark
	km_setval	kz_x2,spr_stepup
	km_jsr	kurukuru_enemy

;=====================================================================
;*		Pause tyuu wa denai				*
;=====================================================================
;* pause check *
	a8
	lda	mmx_pausescroll
	beq	.disp_obj
	cmp	#scrl_openscrollwait
	beq	.disp_obj
	cmp	#scrl_closefinish
	beq	.disp_obj
	brl	.end
.disp_obj
;***** Corneria HP Meter *****
;* HP Meter (yajima's)
	km_jsr	corneria_HPmeter


	km_bitcheckmismapflag	explain1
	km_bne	.demosprite
	km_bitcheckmismapflag	battleplayer
	km_bne	.ArwingDisplay

;***** cursor *****
	km_bitcheckmismapfzflag	cursorfreeze
	km_bne	.notdisplay_cursor

	km_bitcheckflag16	mmx_cursorflag,curf_hitplanet
	bne	.hit
;------------------------------------------------------------------------
.nohit
	shorta
	lda	mmx_curposX
	sta	oam_centerX	; <- position X
	lda	mmx_curposY
	sta	oam_centerY	; <- position Y
	lda	#cd_objanime_smallcursor
	sta	oam_animeNo	; animation No
	lda	mmx_curanmtm
	sta	oam_tcount	; animation Timer
	a16
	km_jsr	set_kawaobj
	a8
	brl	.skipcursor

	ifeq	1
;* normal cursor Animation *
	lda	mmx_4frameTm
	bne	.NotChangeChr
	km_eorflag	mmx_curchar,2
.NotChangeChr

	km_setspriteC4X	mmx_curposx
	km_setspriteC4Y	mmx_curposy

	km_mmsetspritesizedouble
	lda	mmx_curchar
	km_SetSpriteChrA	$48,colpal0,pri2,noflip,mm_obj_offset
	endc
;------------------------------------------------------------------------
.hit
	shorta
	lda	mmx_bigcurposX
	sta	oam_centerX	; <- position X
	lda	mmx_bigcurposY
	sta	oam_centerY	; <- position Y
	lda	#cd_objanime_bigcursor
	sta	oam_animeNo	; animation No
	lda	mmx_curanmtm
	sta	oam_tcount	; animation Timer
	a16
	km_jsr	set_kawaobj
	a8
;**** planet name *****
	shorta
	lda	mmx_planetname
	cmp	#6
	km_bpl	.NotDisplayName
	a16
	km_loba
	km_multa16
	clc
	adc	#$16a
	sta	x1		;get name pointer

	a8
	lda	mmx_bigcurposY
	cmp	#$80
	bcs	.name_up
.name_down
	clc
	adc	#19
	bra	.skip_ypos
.name_up
	sec
	sbc	#19+4+2
.skip_ypos
	sta	kz_tpy

	lda	mmx_bigcurposX
	clc
	adc	#-28
	sta	kz_tpx

	ldx	#5
.loop
	lda	#8
	clc
	adc	kz_tpx
	sta	kz_tpx
	km_SetSpriteX	kz_tpx
	km_SetSpriteY	kz_tpy
	a16
	km_SetSpriteChrVar	x1,0,colpal1,pri2,noflip,mm_obj_offset
	inc	x1
	a8
	dex
	bne	.loop
.NotDisplayName
;============================================================================
.skipcursor
	shorta
	lda	mmx_curanmtm
	inc	a
	and	#$f
	sta	mmx_curanmtm
.notdisplay_cursor
;============================================================================
.SOSarrivetime
	ifne	ksosskill
	a16
	km_bitcheckflag16	mmx_cursorflag,curf_hitenemy
	km_beq	.notdispSOStm
	ldx	kx_enarrivetmptr
	km_loblda.w	mmx_enskill,x	;mmx_enstackptr,x	;
	sta	kwork
	a8
	lda.w	mmx_enposx+1,x
	sta	kwork+2
	lda.w	mmx_enposy+1,x
	sta	kwork+3
	a16
	lda	#2
	sta	kwork+4
	km_jsr	mm_SetSprScoreMeter
	a8
	ENDC

	IFEQ	1
;-----------------------------------------------------------
	ldx	kx_enarrivetmptr
	lda.w	mmx_enposx,x
	sta	kz_x1
	lda.w	mmx_enposy,x
	sta	kz_y1
	km_lobswaplda.w	mmx_endestx,x
	sta	kz_x2
	km_lobswaplda.w	mmx_endesty,x
	sta	kz_y2

	lda	kz_x2
	sec
	sbc	kz_x1
	bpl	.plasx
	km_nega
.plasx
	sec
	sbc	#$0400
	sta	kz_tpx

	lda	kz_y2
	sec
	sbc	kz_y1
	bpl	.plasy
	km_nega
.plasy
	sec
	sbc	#$0400
	sta	kz_tpy
;-----------------------------------------------------------
	lda	kz_tpx
	cmp	kz_tpy
	bmi	.biggerY
.biggerX
	lda	kz_tpx
	sta	kz_wkdividend_H
	lda.w	mmx_envelx_l,x
	bpl	.plas_velx
	km_nega
.plas_velx
	bra	.division
.biggerY
	lda	kz_tpy
	sta	kz_wkdividend_H
	lda.w	mmx_envely_l,x
	bpl	.plas_vely
	km_nega
.plas_vely
.division
	sta	kz_wkdivisor
	PHY		;>>>	PUSH Enemy List Pointer
	jsl	KDivide_u32u16_l
	PLY		;<<<	PUSH Enemy List Pointer 

	lda	kz_wkdividend_L
	km_divu8
	sta	kwork
	a8
	lda.w	mmx_enposx+1,x
	sta	kwork+2
	lda.w	mmx_enposy+1,x
	sta	kwork+3
	a16
	lda	#3
	sta	kwork+4
	km_jsr	mm_SetSprScoreMeter
	ENDC
;============================================================================
.notdispSOStm
	a8
;---------------------------------------------------------------------
;* destination *
	km_bitcheckflag16	mmx_cursorflag,curf_destdisp
	km_beq	.NotdestDisplay

	dec	mmx_destmarktm
	bne	.nochangepattern

	lda	mmx_destmarkptr
	eor	#1
	sta	mmx_destmarkptr
	km_setval	mmx_destmarktm,4
.nochangepattern

	km_mmsetspritesizedouble
	a16
	km_SetSpriteC4XY	mmx_arwingdestposX,mmx_arwingdestposY

	lda	mmx_destmarkptr
	km_SetSpriteCol		$4c,pri2,noflip,mm_obj_offset

;;	lda.l	destmarkanmtbl,x
;;	km_loba
;;;	km_setspriteChrA	$40,colpal0,pri2,noflip,mm_obj_offset
	a8
.NotdestDisplay
;---------------------------------------------------------------------
;********** Player Display *********
.ArwingDisplay
	lda	mmx_arwinganmptr
	sec
	sbc	#5
	cmp	#7
	bcs	.pri_jet
.pri_arwing
	km_jsr	mm_disparwing
	km_jsr	mm_dispjet
	bra	.skip_arwing
.pri_jet
	km_jsr	mm_dispjet
	km_jsr	mm_disparwing
.skip_arwing
;---------------------------------------------------------------------
;****** mother ship ******
	a8
;* mother Left (UP)*
	km_mmsetspritesizedouble
	lda	kx_mshipx
	sec
	sbc	#16
	km_SetSpriteX
	lda	kx_mshipy
	sec
	sbc	#16	;8
	km_SetSpriteY
	a16
	lda	#0
 	km_setspritechrA	spr_mshipL,colpal0,pri2,noflip,mm_obj_offset
	a8

;* mother Right (UP)*
	km_mmsetspritesizedouble
	lda	kx_mshipx
	km_SetSpriteX
	lda	kx_mshipy
	sec
	sbc	#16	;8
	km_SetSpriteY
	a16
	lda	#0
	km_setspritechrA	spr_mshipL,colpal0,pri2,xflip,mm_obj_offset
	a8

;* mother Left (Down)*
	km_mmsetspritesizedouble
	lda	kx_mshipx
	sec
	sbc	#16
	km_SetSpriteX
	lda	kx_mshipy
;;	sec
;;	sbc	#8
	km_SetSpriteY
	a16
	lda	#0
 	km_setspritechrA	spr_mshipR,colpal0,pri2,noflip,mm_obj_offset
	a8

;* mother Right (Down)*
	km_mmsetspritesizedouble
	lda	kx_mshipx
	km_SetSpriteX
	lda	kx_mshipy
;;	sec
;;	sbc	#8
	km_SetSpriteY
	a16
	lda	#0
	km_setspritechrA	spr_mshipR,colpal0,pri2,xflip,mm_obj_offset
	a8
;---------------------------------------------------------------------
;**** planet skill ******
	a16
	IFNE	kplanetskill
	km_bitcheckflag16	mmx_cursorflag,curf_hitplanet
	beq	.nodisp_skill
	ldx	kx_tmpplanetptr	;Planet List Pointer
	lda.w	mmx_planetcx,x
	sec
	sbc	#$0400
	sta	kwork+2

	km_loblda.w	mmx_planetskill,x	;mmx_plstackptr,x	;
	cmp	#step_Neutral
	beq	.nodisp_skill
	sta	kwork+0
	km_setval	kwork+4,3
	km_jsr	mm_SetSprScoreMeter

.nodisp_skill
	ENDC
;---------------------------------------------------------------------
.demosprite
;---------------------------------------------------------------------
;* enemy *
	longa
	km_jsr	mm_Setsprenemy
	shorta
;---------------------------------------------------------------------
;* Planet dokuro *
	a16
	km_bitcheckmismapflag	battleplayer
	bne	.skip2
	km_jsr	enemyplanet
.skip2
;---------------------------------------------------------------------
;* meteor *
	a8
	LDX	kx_MeteorPtr
	beq	.NoMeteor

	lda	mmx_meteoranmptr
	inc	a
	and	#$3f
	sta	mmx_meteoranmptr

	lda.w	mmx_planetcx,x
	sta	oam_centerX	; <- position X
	lda.w	mmx_planetcy,x
	sta	oam_centerY	; <- position Y
	lda	#cd_objanime_meteor
	sta	oam_animeNo	; animation No
	lda	mmx_meteoranmptr
	sta	oam_tcount	; animation Timer
	a16
	km_jsr	set_kawaobj
	a8
.NoMeteor
	bra	.end
;---------------------------------------------------------------------
.end
	sty	sprpointer
	rts

;=====================================================================
;*								*
;*		Display Sprite Arwing				*
;*								*
;=====================================================================
mm_disparwing
;* arwing *
;* (kz_x1,kz_x2) <<<<< (X,Y) Postion 
	a8
	lda	mmx_arwingposx+1
	sta	kz_tpx
	lda	mmx_arwingposy+1
	sta	kz_tpy

;* X flip check *
;mmx_arwinganmptr = kuru kru pattern (16) pointer :0 ~ 15
	ldx	#0
	stx	kz_tpa

	lda	mmx_arwinganmptr
	bit	#8		;pattern 8 ~ 15 check
	bne	.noflip1
	inx
.noflip1
	lda	p1_pilotNo
	and	#1
	asl	a		;0/1 ... Blue / Red Arwing 
;Xreg =0/1 ... noflip / flip
	dex
	bne	.noflip2
	clc
	adc	#obj_xflip_h
.noflip2
	sta	kz_tpa+1
	km_jsr	mm_setSprite_4
	rts

;=====================================================================
;*		Display Sprite Arwing Jet			*
;=====================================================================
mm_dispjet
	shorta
	longi
	km_bitcheckflag16	 mmx_arwingflag,mmf_go
	beq	.end

	lda	mmx_2frameTm
	bne	.NoChangeJet
	lda	mmx_jetanmptr
	inc	a
	cmp	#3
	bne	.skip
	lda	#0
.skip
	sta	mmx_jetanmptr
.NoChangeJet
	lda	mmx_jetanmptr
	beq	.end

	a16
	km_loba
	asl	a
	clc
	adc	#obj_colpal2+$122
	sta	kz_tpa
	a8

	ldx	mmx_arwinganmptr
	lda.l	arjettbl_x,x
	clc
	adc	mmx_arwingposx+1
	sta	kz_tpx

	lda.l	arjettbl_y,x
	clc
	adc	mmx_arwingposy+1
	sta	kz_tpy

	km_jsr	mm_setSprite_4
.end
	rts

;=====================================================================
;*		Set Sprite (X,Y),Char,Att			*
;* Input	:kz_tpx :x zahyou					*
;*	:kz_tpy :y zahyou					*
;*	:kz_tpa :char&Att					*
;* data bank 7e 							*
;=====================================================================
mm_setSprite_4
	shorta
	longi
	km_mmsetspritesizedouble
	lda	kz_tpx
	sec
	sbc	#8
	km_SetSpriteX

	lda	kz_tpy
	sec
	sbc	#8
	km_SetSpriteY

	a16
	lda	kz_tpa
	km_SetSpriteChrA	0,colpal0,pri2,noflip,mm_obj_offset
	a8
	rts

;=====================================================================
;*		Enemy Sprite Set				*
;* Xreg :Enemy List Pointer						*
;* Yreg :Sprite Pointer						*
;=====================================================================

mm_Setsprenemy
	a16
	longi
	ldx	kx_enlistptr	;no enemy
	km_beq	.noenemy

.loop
	longa
	km_bitcheckflag.w	mmx_enflags,enfl_demo,x
	bne	.anime_demo
;* (X,Y) postion *
	a8
	lda.w	mmx_enposx+1,x
	sta	kz_tpx
	lda.w	mmx_enposy+1,x
	sta	kz_tpy
;* x flip check *
	a16
	lda.w	mmx_enangY+1,x
	clc
	adc	#8
	km_loba
	km_divu32
	sta	kz_x1		;angle	(0~7)

	km_loblda.w	mmx_entype,x	;sos type
	lsr	a
	phx
	tax
	km_loblda.l	enemychrtbl,x
	plx
	clc
	adc	#spr_enoffset
	sta	kz_x2		;charcter base No
	km_jsr	kurukuru_enemy
	bra	.nextenemy
;---------------------------------
;* demo animation (yajima's) *
.anime_demo
	longa
	lda.w	mmx_enanmpatt,x
	beq	.skip_anime
;;;;	km_jsr	SOSEnemyAnimation
	lda	#1
	jsl	kspeedupA_l
	clc
	adc.w	mmx_enanmtm,x
	sta.w	mmx_enanmtm,x
	km_jsr	mapanime_set
.skip_anime
;---------------------------------
;* next enmy set *
.nextenemy
	longa
	longi
	lda.w	mmx_ennext,x
	beq	.loopend
	tax
	brl	.loop
.loopend
;* Corneria Explosion (yajima's) *
	km_jsr	corneria_crash
.noenemy
	a8
	rts

;=====================================================================
;*			 Dokuro Display				*
;=====================================================================
dokuro_enemy
	longa
	longi
	km_SetSpriteXY
	km_mmsetspritesizedouble
	lda	mmx_DokuroMark
	km_SetSpriteChrA	$a0,colpal0,pri2,noflip,mm_obj_offset
	rts

;=====================================================================
;*			Enemy Kurukru Rotation			*
;* Init:								*
;*     : kz_tpx :center X zahyo					*
;*     : kz_tpy :center Y zahyo					*
;*     : kz_x1 :rotation angle (0~8)					*
;*     : kz_y1 :base charcter					*
;=====================================================================
kurukuru_enemy
	longa
	longi
	km_SetSpriteC4XY	kz_tpx,kz_tpy

	phx
	ldx	kz_x1
	km_loblda.l	kurukurutbl,x
	clc
	adc.w	kz_x2		;mmx_enchrbase,x
	bit	#$10
	beq	.skip2
	clc
	adc	#$10
.skip2
	sta	kz_x3

	lda	kz_x1
	cmp	#4
	bmi	.skip1
	km_addstaval	kz_x3,obj_xflip
.skip1
;* character set *
	km_MMSetSpriteSizeDouble
	lda	kz_x3
	km_setspriteChrA	0,colpal0,pri2,noflip,mm_obj_offset
	plx
	rts



;=====================================================================
;*		Set Spites Size		[double buffer]		*
;=====================================================================
mm_SetSprSize_double_sub
	php
	phx
	phy

	ai16
	tya
	cmp	#(128*4)+(128/4)
	bmi	.buf1		;if < (128*4+128/4) THEN write buffer 1
.buf2
	sec
	sbc	#(128*4)+(128/4)
	km_shiftRUA2		;oam (*0,*4,*8,*c)---->(*0,*1,*2,*3)
	pha
	and	#$0003
	tax			;loop counter

	pla
	km_shiftRUA2	;oam (*0,*16,*32,*48)---->(*0,*1,*2,*3)
	clc
	adc	#(128*4)+(128/4)
	tay			;set sprite sub pointer
	bra	.SET
.buf1
	km_shiftRUA2	;oam (*0,*4,*8,*c)---->(*0,*1,*2,*3)
	pha
	and	#3
	tax
	pla
	km_shiftRUA2	;oam (*0,*16,*32,*48)---->(*0,*1,*2,*3)
	tay		;sprites sub pointer (0,1,2,3,..,31)
.SET
	a16
	txa
	clc
	adc	mmx_sprsizeaddr
	tax
	a8
	lda.w	heap,x
	ora	sprites_sub,y
	sta	sprites_sub,y

	ply
	plx
	plp
	rts

;=====================================================================
;*								*
;*			SCORE Meter	[MISSION]		*
;* Mem16 idx16							*
;* Data Bank:7e							*
;* Yreg:Sprites Pointer						*
;* kwork  :Game Score						*
;* kwork+2:(X,Y) Postion (ichiban ushiro no kazu)			*
;* kwork+4:keta suu							*
;=====================================================================
mm_SetSprScoreMeter
	php
	ai16
	PHX
;* 1 no kurai *
	lda	kwork
	km_cpudivu16uf8_work	10
	lda	kamari
	ora	#obj_colpal1
	sta	tpa			;Character
	km_setvar	kz_x1,kwork+2	;(X,Y)
	km_jsr	mm_SetSprSmallNumber

;* 10~10000 no kurai *
	ldx	kwork+4
.loop
	dex
	beq	.end

	phx
	km_jsr	mm_SetSprScoreMeter_sub
	plx
	bra	.loop
.end
	PLX
	plp
	rts
;--------------------------------------------------
mm_SetSprScoreMeter_sub
	longa
	longi
	a8
	km_substaval	kwork+2,8
	a16
	lda	ksyou
	km_cpudivu16uf8_work	10
	lda	kamari
	ora	#obj_colpal1
	sta	tpa			;Character
	km_setvar	kz_x1,kwork+2	;(X,Y)
	km_jsr	mm_SetSprSmallNumber
	rts

;*********************************************************************
;*			Small Number Display			*
;*Init :a16i16							*
;* kz_x1	:(x,y) zahyou (2byte)					*
;* kz_tpa	:chracterNo (2 byte)					*
;*********************************************************************
mm_SetSprSmallNumber
	php
	a16
	longi
	phx
	km_SetSpriteXY	kz_x1
	km_lldx	tpa
	lda.l	mm_objnumbertbl,x
	km_loba
	km_SetSpriteChrA	0,colpal0,pri3,noflip,mm_obj_offset
	plx
	plp
	rts

	incfile	mapanime.asm
;---------------------------------------------------------------------
;*** PORGRAM END ****
heap_runmarioEnd_l
;---------------------------------------------------------------------
heap_proglen	equ	heap_runmarioEnd_l-heap_runmariostart_l


;****************************************************************************
;****************************************************************************
;
;			Not Using Area
;****************************************************************************
;****************************************************************************

;**************************************************************************
;**************************************************************************
;* 			Not Use					*
;**************************************************************************
;**************************************************************************
;**************************************************************************


;=====================================================================
;*		Step Up Enemy Appear Scroll			*
;* data bank 7e							*
;=====================================================================
	IFEQ	1
mm_StepUpScroll
	shorta
	longi
	lda	kx_stepupdemoptr
	cmp	#stupdm_open
	beq	.openscroll
	cmp	#stupdm_close
	beq	.closescroll
	cmp	#stupdm_demo1
	beq	.demowait
	bra	.end
.demowait
	a16
	dec	kx_stepupdemowait
	a8
	bne	.end

	lda	#stupdm_close
	sta	kx_stepupdemoptr
	bra	.end
.openscroll
	lda	khscrollp1
	cmp	#$90
	beq	.openend
	clc
	adc	#$10
	sta	khscrollp1

	ldx	#64
	stx	kx_stepupdemowait
	bra	.end
.openend
	lda	#stupdm_demo1
	sta	kx_stepupdemoptr
	bra	.end
;----------------------------------------------------------------
.closescroll
	lda	khscrollp1
	cmp	#0
	beq	.closeend
	sec
	sbc	#$10
	sta	khscrollp1
	bra	.end
.closeend
	lda	#stupdm_demoend
	sta	kx_stepupdemoptr
	bra	.end
;----------------------------------------------------------------
.end
	rts

	ENDC

;=========================================================================



	IFEQ	1
;* BIG cursor animation check *
	km_addgesmaxtomin	mmx_curanmtm,1,4,0
	bne	.nochange_curanm
	km_addgesmaxtomin	mmx_curanmptr,1,4,0
.nochange_curanm

	km_lldx	mmx_curanmptr
	lda	mmx_curanmpat,x
	sta	kz_z1

	lda	mmx_bigcurposX
	sec
	sbc	kz_z1
	sta	kz_x1

	lda	mmx_bigcurposX
	clc
	adc	kz_z1
	sta	kz_x2

	lda	mmx_bigcurposY
	sec
	sbc	kz_z1
	sta	kz_y1

	lda	mmx_bigcurposY
	clc
	adc	kz_z1
	sta	kz_y2

	km_SetSpriteXY_ImOff	kz_x1,kz_y1,-17,-17
	km_SetSpriteChrVal	$8,colpal0,pri2,noflip,mm_obj_offset
	km_SetSpriteXY_ImOff	kz_x2,kz_y1,9,-17
	km_SetSpriteChrVal	$8,colpal0,pri2,xflip,mm_obj_offset
	km_SetSpriteXY_ImOff	kz_x1,kz_y2,-17,9
	km_SetSpriteChrVal	$8,colpal0,pri2,yflip,mm_obj_offset
	km_SetSpriteXY_ImOff	kz_x2,kz_y2,9,9
	km_SetSpriteChrVal	$8,colpal0,pri2,xyflip,mm_obj_offset
	ENDC

	IFEQ	1
	a16
	lda	mmx_stationanmptr
	and	#$ff
	clc
	adc	mmx_sprstationaddr
	tax

	km_mmsetspritesizedouble
	km_SetSpriteImXY	$0e*8,$9*8
	lda.w	heap,x
	km_SetSprite
	inx
	inx

	km_mmsetspritesizedouble
	km_SetSpriteImXY	$10*8,$9*8
	lda.w	heap,x
	km_SetSprite
	inx
	inx

	km_mmsetspritesizedouble
	km_SetSpriteImXY	$0e*8,$b*8
	lda.w	heap,x
	km_SetSprite
	inx
	inx

	km_mmsetspritesizedouble
	km_SetSpriteImXY	$10*8,$b*8
	lda.w	heap,x
	km_SetSprite
	inx
	inx
	a8

	ENDC
	ifeq	1
;---------------------------------------------------------------------
;**** Total Add Timer ****
	brl	.notdemo

	km_bitcheckmismapstflag	replay
	km_beq	.notdemo
;* time *
	a16
	km_setvar	kwork+0,kw_Gametimer
	km_setval	kwork+2,($b*8+(2*8+7)<<8)
	km_setval	kwork+4,2
	km_jsr	mm_SetSprScoreMeter
;* s *
	SetSprXYChr_Im	$c*8,2*8+7,$7,colpal0,pri2,noflip,mm_obj_offset

;* Timer waku *
	km_SetSpriteImXY	$8*8-1,$2*8+3
	km_mmsetspritesizedouble
	km_SetSpriteChrVal	$9,colpal1,pri2,noflip,mm_obj_offset

	km_SetSpriteImXY	$a*8-1,$2*8+3
	km_mmsetspritesizedouble
	km_SetSpriteChrVal	$a,colpal1,pri2,noflip,mm_obj_offset

	km_SetSpriteImXY	$c*8-1,$2*8+3
	km_mmsetspritesizedouble
	km_SetSpriteChrVal	$9,colpal1,pri2,xflip,mm_obj_offset

;* Add Yajirushi *
	km_bitcheckgameflag	keydisable
	bne	.notdemo

	a16
	lda	Winctimer
	km_andcmpval	3
	bne	.skip1
	lda	mmx_TMSendAnmPtr
	inc	a
	and	#3
	sta	mmx_TMSendAnmPtr
.skip1
	ldx	mmx_TMSendAnmPtr
	km_loblda.l	sendmarktbl,x
	sta	kz_x1

	km_SetSpriteImXY	$e*8-2,$2*8+3
	km_setspriteChrVar	kz_x1,$0,colpal1,pri2,noflip,mm_obj_offset

	km_SetSpriteImXY	$f*8-2,$2*8+3
	km_setspriteChrVar	kz_x1,$0,colpal1,pri2,noflip,mm_obj_offset

	km_SetSpriteImXY	$e*8-2,$3*8+3
	km_setspriteChrVar	kz_x1,$0,colpal1,pri2,yflip,mm_obj_offset

	km_SetSpriteImXY	$f*8-2,$3*8+3
	km_setspriteChrVar	kz_x1,$0,colpal1,pri2,yflip,mm_obj_offset
	a8
.notdemo
	endc
;---------------------------------------------------------------------
;---------------------------------------------------------------------
;---------------------------------------------------------------------
;* ball *
	ifeq	1
	a8
	ldx	mmx_sprballaddr
.LOOP_BALL
	lda.w	mmx_ballsx,x
	km_SetSpriteX

	lda.w	mmx_ballsy,x
	km_SetSpriteY

	km_SetSpriteChrVal	9,colpal0,pri2,noflip,mm_obj_offset

	a16
	txa
	clc
	adc	#mmx_balllen
	tax
	sec
	sbc	mmx_sprballaddr
	a8
	cmp	#mmx_balllen*3
	km_bne	.LOOP_BALL
	endc
;=====================================================================
;*								*
;*			Enemy Animation				*
;*								*
;=====================================================================
	IFEQ	1
SOSEnemyAnimation
;* character Anmation *
	SHORTA
	LONGI


	PHX
	PHY

	TXY
	lda.w	mmx_enanmtm,y
	dec	a
	sta.w	mmx_enanmtm,y
	bne	.nochangeanm

	lda.w	mmx_enanmptr,y
	inc	a
	inc	a
	cmp.w	mmx_enanmmaxptr,y
	bne	.notmax
	lda	#0
.notmax
	sta.w	mmx_
enanmptr,y
	a16
	and	#$ff
	clc
	adc.w	mmx_enanmpatt,y
	tax
	a8
	lda.l	mm_sprenpattdata+1,x
	clc
	adc.w	mmx_enchrbase,y
	sta.w	mmx_enchranm,y		;anime pattern max pointer
	lda.l	mm_sprenpattdata+2,x
	sta.w	mmx_enanmtm,y
.nochangeanm
	PLY
	PLX
	rts
	ENDC
;============================================================================
;============================================================================
;============================================================================
;*** Arwing Move Calc ***
	IFEQ	1
;* calc DX *
	a16
	lda	mmx_arwingposx
	and	#$ff
	sta	kz_x1

	lda	mmx_destposX
	and	#$ff
	sec
	sbc	kz_x1
	sta	mmx_arwingdx
	bmi	.decx
.incx
	km_setval	mmx_arwingmovx,1
	bra	.skip_dx
.decx
	km_setval	mmx_arwingmovx,-1
.skip_dx

;* calc DY *
	lda	mmx_arwingposy
	and	#$ff
	sta	kz_x1

	lda	mmx_destposY
	and	#$ff
	sec
	sbc	kz_x1
	sta	mmx_arwingdy
	eor	mmx_arwingdx
	bmi	.minusdydx
.plasdydx
	lda	mmx_arwingmovx
	bmi	.minusmovy
.plasmovy
	km_setval	mmx_arwingmovy,1
	bra	.skip2
.minusmovy
	km_setval	mmx_arwingmovy,-1

	bra	.skip2
.minusdydx
	lda	mmx_arwingmovx
	bmi	.plasmovy
	bra	.minusmovy
.skip2
	km_absstavar	mmx_arwingdx
	km_absstavar	mmx_arwingdy
	stz	mmx_arwingH
;---------------------------------------------------
.playermove
	lda	mmx_arwingdx
	sec
	sbc	mmx_arwingdy
	bmi	.addy
;-----------------------------------------
;dx > dy
.addx
	km_addstavar	mmx_arwingposx,mmx_arwingmovX
	lda	mmx_arwingH
	clc
	adc	mmx_arwingdy
	cmp	mmx_arwingdx
	bmi	.noaddy

	pha
	km_addstavar	mmx_arwingposy,mmx_arwingmovy
	pla

	sec
	sbc	mmx_arwingdx
.noaddy
	sta	mmx_arwingH
	bra	.endcheck
;-----------------------------------------
;dy > dx
.addy
	km_addstavar	mmx_arwingposy,mmx_arwingmovY
	lda	mmx_arwingH
	clc
	adc	mmx_arwingdx
	cmp	mmx_arwingdy
	bmi	.noaddx

	pha
	km_addstavar	mmx_arwingposx,mmx_arwingmovx
	pla

	sec
	sbc	mmx_arwingdy
.noaddx
	sta	mmx_arwingH
;-----------------------------------------
.endcheck
	a8
	lda	mmx_arwingposx
	cmp	mmx_destposX
	bne	.end
	lda	mmx_arwingposy
	cmp	mmx_destposY
	bne	.end
	km_setflag16	mmw_ok,7
;-----------------------------------------
	ENDC

;---------------------------------------------------------
;* kawaguchi ga tukutta enmy List free area get program  *
;---------------------------------------------------------
	ifeq	1
	ldx	kw_enlistptr
	bne	.lastcheck
;* fast enemy *
	ldx	#kx_enemylist&WM
	stx	kw_enlistptr
	brl	.setparams

;* enemy list last pointer search *
.lastcheck
	lda.w	mmx_ennext,x
	beq	.foundlast
	tax
	bra	.lastcheck
.foundlast
	txy
	inc	a
	sta.w	mmx_ennext,x

;* blank list search *
	ldx	kw_enlistptr
.checkblank
	lda.w	mmx_ennext,x
	beq	.foundblank
	txa
	clc
	adc	#mmx_len
	tax
	bra	.checkblank
.foundblank
	txa
	sta.w	mmx_ennext,y
	endc

;----------------------------------------------
;* kawaguchi ga tukutta enmy free program *
;----------------------------------------------
	ifeq	1
	ldy	kw_enlistptr
	ldx	kx_SOSEnemyptr
	cpy	kx_SOSEnemyptr
	beq	.loop

	lda.w	mmx_ennext,y
	bne	.check1
	stz	kw_enlistptr
	bra	.end
.check1
	lda.w	mmx_ennext,x
	sta	kw_enlistptr
	bra	.end
;----------------------------------------------
.loop
	lda.w	mmx_ennext,y
	cmp	kx_SOSEnemyptr
	beq	.found
	tay
	bra	.loop
.found
	lda.w	mmx_ennext,x
	sta.w	mmx_ennext,y
;----------------------------------------------
	endc

	IFEQ	1
;----------------------------------------------------------------------------
;* Calculate Object Angle *
;* db = $7e
;* a16 i16
;* In   :source = (x1,y1),dest = (x2,y2)
;* Exit :Acc = Angle (16 bit) :0 to 359 degrees is $0000 to $ffff
;----------------------------------------------------------------------------
calobjangle
	php
	a16
	longi
;* zahyou set *
	km_substavar	x1,x2
	km_substavar	y1,y2

;* area check  (amari kyori ga chikasugiru to angle ga motomerarenai!!)*
;* dakra kyori ga chikasugiru tokino angle wa motomenai *
	IFEQ	1
	lda	x1
	bpl	.plasX1
	nega
.plasX1
	cmp	#16
	bpl	.calc_angle

	lda	y1
	bpl	.plasY1
	nega
.plasY1
	cmp	#16
	bmi	.chikasugi
	ENDC
;---------------------------------
;* angle wo motome ru *
.calc_angle
	km_jsl	arctan16_l
;---------------------------------
.chikasugi
	plp
	rts
	ENDC

;=====================================================================
;*								*
;*			Check Pause				*
;*								*
;=====================================================================
	IFEQ	1
mm_pausecheck
	LONGA
	LONGI
	km_bitcheckmismapstflag	gmframesyori
	beq	.end

;* Scroll Wait Finish Check *
	lda	mmx_scrollwaittm
	beq	.nowait			;wait timer = 0
	dec	a
	sta	mmx_scrollwaittm
	bne	.ClearKeyStates			;waiting
	lda	mmx_pausescroll
	cmp	#scrl_openscrollwait
	beq	.openscroll
	cmp	#scrl_closescrollwait
	beq	.closescroll
	cmp	#scrl_pausekeywait
	beq	.pauseenable
	jml	mim_blink
;---------------------------------------------------------------------
.pauseenable
	lda	#scrl_pause
	sta	mmx_pausescroll
	bra	.ClearKeyStates
.openscroll
	lda	#scrl_openscroll
	sta	mmx_pausescroll
	bra	.ClearKeyStates
.closescroll
	lda	#scrl_closescroll
	sta	mmx_pausescroll
	bra	.ClearKeyStates
.closefinish
	lda	#scrl_normal
	sta	mmx_pausescroll
	km_clrgameflag		pause		;[pause off]
	km_clrmismapstflag	timestop	;[timer start]
;---------------------------------------------------------------------
.ClearKeyStates
	km_clrgmjoypad
	km_clrgmkeydown
.end
;* 1 Game Frame Key Read *
	km_setgmjoypad
	km_setgmkeydown
	rts
;---------------------------------------------------------------------
.nowait
;* Pause Key Enable Check *
	lda	mmx_pausescroll
	beq	.pausekeycheck
	cmp	#scrl_pause
	beq	.pausekeycheck
	cmp	#scrl_closefinish
	beq	.closefinish
	bra	.ClearKeyStates
;---------------------------------------------------------------------
;* pause check *
.pausekeycheck
	km_testgmjoypad	Pause
	beq	.ClearKeyStates

	km_eorflag16	mmx_cursorflag,curf_pausecheck

	km_bitcheckflag16	mmx_cursorflag,curf_pausecheck
	beq	.pauseoff
.pauseon
	km_setgameflag	pause		;[pause on]
	km_setmismapstflag	timestop
	km_setval	mmx_pausescroll,scrl_openscrollwait
	km_setval	mmx_scrollwaittm,3
	ksound	pauseon
	bra	.ClearKeyStates
.pauseoff
	km_setval	mmx_pausescroll,scrl_closescrollwait
	km_setval	mmx_scrollwaittm,5
	stz	faceshutter_count
	ksound	pauseoff
	brl	.ClearKeyStates
	ENDC


