;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: gamover.asm				*
;* 	Description	: Gameover SEQ				*
;*	Date		: 1994.7.15				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;
;---------------------------------------------------------------------
	INCPUB  gameover
;---------------------------------------------------------------------
;
;
;
;
;
;------------------------------------------------------------
message_attr	equ	3100h+obj_p0
;------------------------------------------------------------

;*******************************************************************
;	gameover
;*******************************************************************
	longi
	shorta
;------------------------------------------------------------
gameover_l
	php
	phb
	phk
	plb
;-------------------------------------------
	ai16
	jsr	init_gameover
	jsr	InitScreen	; screen initialize
;-------------------------------------------
.loop	a8
	lda	#iv_titleirq
	sta	trans_flag
	km_waittrans

	jsl	do_sprites_l

	ai16
	jsr	main_gameover
	lda	trig0
	and	#button_start+button_A+button_B
	beq	.loop
;-------------------------------------------
	a8
	lda	kw_continue1
	bne	.continue
	km_setgamemode	title
	bra	.exit	
.continue	km_setgamemode	missioncontinue
;-------------------------------------------
.exit	km_screenoff
	plb
	plp
	rtl
;*******************************************************************
	longi
	longa
;*******************************************************************
;	initialize
;*******************************************************************
init_gameover

	ldy	#testdata&0ffffh
	jsl	Init_OBJ
	rts

;*******************************************************************
;	main
;*******************************************************************
main_gameover

	stz	sprite_register
	stz	sprite_start

	jsl	Main_OBJ

	Mmessage 60h,90h
	db	_g,_a,_m,_e,_o,_v,_e,_r,ed


	rts

;***********************************************************************
;	Object Test Program
;***********************************************************************
testdata
;----------------------------------------------------------
	dl		SEQ_d2_2
	M2dOBJdata	prog_root,0h,080h,020h,00h,100h,0
	Mdataend
;----------------------------------------------------------
prog_root
	phk
	plb
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	ldy	#1500h	; max speed
	lda	#0050h	; accel
	jsr	gravityY
	jsr	moveXY
			; rebound parameter
	lda	#0050h	; limit Y position
	jsr	groundY
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	jsl	SetOAM
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	rtl
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;======================================================================


;----------------------------------------------------------------------
groundY	ldx	register
	cmp	_axisY,x
	bpl	.exit
	sta	_axisY,x
	lda	_velocityY,x
	Mnegative
 	Masr1
	sta	_velocityY,x
.exit	rts
;----------------------------------------------------------------------
gravityY	sty	Xwork0
	ldx	register
	clc
	adc	_velocityY,x
	bmi	.set
	cmp	Xwork0
	bcs	.exit
.set	sta	_velocityY,x	
.exit	rts
;----------------------------------------------------------------------

moveXY	
	ldx	register	; index register

	clc
	lda	_velocityX,x
	bpl	.skipX
	dey
.skipX	adc	_positionX+1,x
	sta	_positionX+1,x
	a8
	tya
	adc	_positionX+3,x
	sta	_positionX+3,x
	a16

	clc
	lda	_velocityY,x
	bpl	.skipY
	dey
.skipY	adc	_positionY+1,x
	sta	_positionY+1,x
	a8
	tya
	adc	_positionY+3,x
	sta	_positionY+3,x
	a16

	rts
;----------------------------------------------------------------------

	






;======================================================================
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;=========	SELECT SCREEN COMMON INITIALIZE ===========================
;=========	SELECT SCREEN COMMON INITIALIZE ===========================
;=========	SELECT SCREEN COMMON INITIALIZE ===========================
;=========	SELECT SCREEN COMMON INITIALIZE ===========================
;=========	SELECT SCREEN COMMON INITIALIZE ===========================
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;*******************************************************************
;	Initialize Screen
;*******************************************************************
InitScreen
	a8

	km_screenoff

	Mset	212ch,010h
	Mset	2105h,1
	Mset	2101h,0

	decrunch_palettes
	dmacgram	0,0,b14_pac,$200
	jsr	MessagePalette

	decram	e2_ccr,0
	ldx	#0
	km_dmaXromVRAM	0,($700000+dec_base),0,$100*$20

	km_dmacgx4VRAM	0,kawaguti_cgx,$1000,$30

	km_setspritemode	nosprite

	km_IRQenable titleirq,226
	jsl	init_sprites_l
	km_screenon

	ai16
	rts

;***********************************************************************
;
;***********************************************************************
MessagePalette
	php
	ai8
	lda	#81h
	sta	2121h
	ldy	#15
	ldx	#0	
.loop	lda	mycgdata&0ffffh,x
	sta	2122h
	inx
	lda	mycgdata&0ffffh,x
	sta	2122h
	inx
	dey
	bne	.loop
	plp
	rts
;----------------------------------------------------------------------
mycgdata	dw	0ffffh	; color 1
	dw	0ffffh	; color 2
	dw	0ffffh	; color 3
	dw	0ffffh	; color 4
	dw	0ffffh	; color 5
	dw	0ffffh	; color 6
	dw	0ffffh	; color 7
	dw	0ffffh	; color 8
	dw	0	; color 9
	dw	0	; color 10
	dw	0	; color 11
	dw	0	; color 12
	dw	0	; color 13
	dw	0	; color 14
	dw	0	; color 15
;----------------------------------------------------------------------
	longa
	longi
;======================================================================
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;=========	2D SPRITE SYSTEM ==========================================
;=========	2D SPRITE SYSTEM ==========================================
;=========	2D SPRITE SYSTEM ==========================================
;=========	2D SPRITE SYSTEM ==========================================
;=========	2D SPRITE SYSTEM ==========================================
;=========	2D SPRITE SYSTEM ==========================================
;=========	2D SPRITE SYSTEM ==========================================
;=========	2D SPRITE SYSTEM ==========================================
;=========	2D SPRITE SYSTEM ==========================================
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;***********************************************************************
;;
;;	2D SPRITE SET SYSTEM
;;
;***********************************************************************

temp	equ	Xaddr	; 4byte
work	equ	Xadd	; 2byte
;---------------------------------------------------------------------
sameloop	equ	Xwork0
centerH	equ	Xwork1	; ******** VVVVVVVV.
centerV	equ	Xwork2	; ******** HHHHHHHH.
displayHV	equ	Xwork3	; VVVVVVVV HHHHHHHH
pos_pointer	equ	Xwork4
char_pointer	equ	Xwork5
obj_counter	equ	Xwork6
objmask	equ	Xwork7
oamtmp	equ	Xwork8
objadd	equ	Xwork9
;---------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;
;
;***********************************************************************
;	Sprite Object Program <<<< MAIN >>>>>
;***********************************************************************
Main_OBJ
	phb
	phk
	plb
;----------------------------------------------------
	ldx	#220h
	cpx	sprite_register
	beq	.skip
	bcc	.skip
	ldx	#0
.skip	stx	sprite_offset	;(double buffer)
;----------------------------------------------------
	lda	#word_root
	sta	Xlinklist_root
;----------------------------------------------------
	ldx	Xlinklist_root
;----------------------------------------------------
.loop	lda	_forward,x
.loopskip	cmp	Xlinklist_root
	beq	.exit
	sta	register
;- - - - - - - - - - - - - - - - - - 
	clc
	adc	#_program
	sta	work
	ldx	#0 
	phk
	jsr	(work,x)
;- - - - - - - - - - - - - - - - - - 
	ldx	register
	lda	_program,x	; data kill ?
	bne	.loop
;- - - - - - - - - - - - - - - - - - 
	jsl	KillLinklist
	bra	.loopskip	; Areg = next register
;----------------------------------------------------

.exit
	plb
	rtl
;-----------------------------------------------------------------------
;***********************************************************************
;	Sprite Object Program <<<< INITIAL >>>>>
;***********************************************************************
;
; index Y register
;
;======================================================================

Init_OBJ

	phy

	lda	#word_free		; address
	sta	Xlinklist_free
	lda	#word_root
	sta	Xlinklist_root

	lda	#word_object_size	; size
	ldy	#word_object_total	; counter
	jsl	InitLinklist

	ply
	jsr	InitObject

	rtl

;***********************************************************************
;	Object Initial
;***********************************************************************
InitObject

;---------------------------

	lda.w	0,y
	tax
	inc	a
	inc	a
	sta.l	SEQaddr+0	; address

	a8
	lda.w	2,y
	sta.l	SEQaddr+2	; bank
	sta	temp+2		; bank
	phb			; >
	pha			;  >
	plb			;  
	a16
	lda.w	0,x
	sta.l	OBJaddr+0	; address
	plb			; 

	iny
	iny
	iny

;---------------------------- ; memeory connect


.initloop
;- - - - - - - - - - - - - - - - - - - - - - - 
	lda.w	0,y
	and	#00ffh
	beq	.exit
	cmp	#2
	beq	set_SEQbank
	jsl	KeepLinklist	; IX = register
	bcs	.exit
	jsl	ConnectLinklist	; IX = register
;- - - - - - - - - - - - - - - - - - - - - - - 
	stx	register
	lda.w	0,y
	and	#00ffh
	asl	a
	tax
	jsr	(set_select,x)
;- - - - - - - - - - - - - - - - - - - - - - - 
	bra	.initloop
;- - - - - - - - - - - - - - - - - - - - - - - 	

.exit	
	rts

;------------------------------------------------------------------------
set_SEQbank	iny
	bra	InitObject
;=======================================================================
set_select
	dwcode	0		; 0
	dwcode	set_PC		; 1
	dwcode	0		; 2

;***********************************************************************
;	set program & character
;***********************************************************************
;- - - - - - - - - - - - - - - - - - - - - - - 
set_PC
	ldx	register
	lda.w	1,y
	sta	_program+1,x
	a8			
	lda	#5ch		; long jump ( = JMP >addr )
	sta	_program+0,x
	phb			; NOW databank = program bank
	pla
	sta	_program+3,x	; data bank
	a16
;- - - - - - - - - - - - - - - - - - - - - - - 
	lda.l	SEQaddr+0
	sta	_SEQaddress+0,x 	; low,high
	lda.l	SEQaddr+1
	sta	_SEQaddress+1,x 	; high bank
	lda.l	OBJaddr
	sta	_OBJaddress,x
;- - - - - - - - - - - - - - - - - - - - - - - 
	lda.w	3,y			;
	and	#00ffh
	sta	_animeNO,x
	asl	a
	adc.l	SEQaddr+0
	sta	temp+0
;- - - - - - - - - - - - - - - - - - - - - - - 
	lda	[temp]			; set initial pointer
	sta	_anime_pointer,x
	sta	temp
	lda	[temp]
	and	#0ff00h
	xba
	asl	a
	adc.l	OBJaddr
	sta	temp
	lda	[temp]
	sta	_obj_pointer,x	
;- - - - - - - - - - - - - - - - - - - - - - - 	
	lda.w	4,y			; start position sprite
	stz	_positionX,x
	sta	_axisX,x
	lda.w	6,y
	stz	_positionY,x
	sta	_axisY,x
;- - - - - - - - - - - - - - - - - - - - - - - 
	lda.w	8,y			; start sprite 
	sta	_velocityX,x
	lda.w	10,y
	sta	_velocityY,x
;- - - - - - - - - - - - - - - - - - - - - - - 
	lda.w	12,y
	and	#00ffh
	sta	_anime_counter,x
;- - - - - - - - - - - - - - - - - - - - - - - 
	lda	#00ffffh
	sta	_charmask,x
	stz	_charadd,x
	stz	_gameframeanime,x
;- - - - - - - - - - - - - - - - - - - - - - - 
	Mady	13
	rts
;=======================================================================



;***********************************************************************
;	LinkList library
;***********************************************************************
;	Areg	structure size
;	Yreg	structure counter
;=======================================================================
InitLinklist
;---------------------------- ; free link
	sta	work
	ldx	Xlinklist_free
	lda	#word_object
.loop	sta	_forward,x
	tax
	clc
	adc	work
	dey
	bne	.loop
	stz	_forward,x
;---------------------------- ; root reset
	ldx	Xlinklist_root
	txa
	sta	_backward,x
	sta	_forward,x
	rtl
;=======================================================================
ConnectLinklist
	phy			; <
	ldy	Xlinklist_root
	sty	_backward,x	; *->prev
	txa
	ldx	_forward,y
	sta	_backward,x	; (root->next)->prev
	sta.w	_forward,y	; root->next
	txy
	tax
	sty	_forward,x	; *->next
	ply			; >>
	rtl
;=======================================================================
KeepLinklist
	phy			; >>
	ldy	Xlinklist_free
	lda.w	_forward,y
	bne	.exit
	sec
	ply			; <
	rtl
;- - - - - - - - - - - - - - - - - - - - - - - -
.exit	tax
	lda	_forward,x
	sta.w	_forward,y
	clc
	ply			; <
	rtl
;=======================================================================
;;;; IN  X = old register
;;;; OUT A = new register
;-----------------------------------------------------------------------
KillLinklist

	ldy	_backward,x
	lda	_forward,x
	sta.w	_forward,y
	tax
	sty	_backward,x
	pha			; >>

	ldx	register
	ldy	Xlinklist_free
	lda.w	_forward,y	; IY = free root
	sta	_forward,x	; IX = kill object
	stx	_forward,y	; IY = free root

	pla			; <<<<< new regidter >>>>>
	rtl
;-----------------------------------------------------------------------




;=======================================================================

;**********************************************************
;	OAMSET MAIN 
;**********************************************************
;
;Xregister = OBJ address
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

SetOAM

	phb


	jsr	OAMSkip		; < high speed >> 4char skip

	ldx	register

	a8
	lda	_SEQaddress+2,x
	pha
	plb
	a16

	jsr	Set_Anime	; animation set

	ldx	register	; X = pointer

	
	ldy	_obj_pointer,x
	beq	.exit

;- - - - - - - - - - - - - - - - - - - - - - 
.nextset	lda	#0
	a8
	lda.w	0,y		; program NO
	asl	a
	tax
	a16
	bcc	.nomal
.skip	phy			; >>
	phx			;   >>
	jsr	(OAM_progselect,x)
	plx			;   <<
	pla			; <<
	clc
	adc	OAM_progcode&0ffffh,x
	tay
	bra	.nextset
;- - - - - - - - - - - - - - - - - - - - - - 
.nomal	jsr	(OAM_progselect,x)
	jsr	OAMSkip		; < high speed >> 4char skip
;- - - - - - - - - - - - - - - - - - - - - - 
.exit	plb
	rtl

;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;***********************************************************************
;
;	OBJ animetion program
;
;***********************************************************************
;;
;; IX = register
;;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Set_Anime
	lda	_anime_counter,x
	beq	.entry
	dec	a
	sta	_anime_counter,x
	rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
.entry				; animation entry
	ldy	_anime_pointer,x
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
	a8
	lda.w	0,y
	bpl	.nomal
	asl	a
	bmi	.longtime
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
.code				; datacode
				; 00 - 3f
	a16
	and	#01111110b
	tax
	jsr	(code_select,x)
	bcs	.entry		; < ēxf[^Zbg >>
	rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
.longtime			; long wait time
	a16
	and	#007fh
	asl	a		; max 3fh * 16 ( 17 b )
	asl	a
	asl	a
	bra	.set
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
.nomal				; nomal wait time
	a16
	and	#00ffh
.set	bit	_gameframeanime,x
	bpl	.set2
	lsr	a		; if gameframe then spped * 4
	lsr	a
.set2	dec	a
	sta	_anime_counter,x
	lda.w	1,y
	and	#00ffh
	cmp	#00ffh		; clear character ?
	bne	.skip
	lda	#0
	bra	.pointercls
.skip	asl	a
	adc	_OBJaddress,x	; object address
	tax
	lda.w	0,x
.pointercls	ldx	register
	sta	_obj_pointer,x	; object pointer
	iny
	iny
	sty	_anime_pointer,x ; next pointer
	rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
code_select
	dwcode	data_next	;(0)	start 
	dwcode	data_reset	;(1)	0 anime set
	dwcode	data_end	;(2)	end
	dwcode	data_change	;(3)	change
	dwcode	data_repeat	;(4)	same repeat
	dwcode	data_kill	;(5)	list kill
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
data_next
	ldx	register
	lda	_animeNO,x
	inc	a		; debug
	sta	_animeNO,x	; debug
	asl	a
	adc	_SEQaddress,x
	tay
	lda.w	0,y
	sta	_anime_pointer,x
	sec
	rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
data_reset
	ldx	register
	stz	_animeNO,x	; debug	 = lda <_animeNO
	lda	#0		; debug 
	asl	a
	adc	_SEQaddress,x
	tay
	lda.w	0,y
	sta	_anime_pointer,x
	sec
	rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
data_end
	clc
	rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
data_change
	ldx	register
	lda.w	1,y
	and	#00ffh
	sta	_animeNO,x
	asl	a
	adc	_SEQaddress,x
	tay
	lda.w	0,y
	sta	_anime_pointer,x
	sec
	rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
data_repeat
	ldx	register
	lda	_animeNO,x
	asl	a
	adc	_SEQaddress,x
	tay
	lda.w	0,y
	sta	_anime_pointer,x
	sec
	rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
data_kill	ldx	register
	stz	_program,x
	clc
	rts


;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================
;=======================================================================

;***********************************************************************
;
;
;***********************************************************************

;***********************************************************************
;
;	OAM program select
;
;***********************************************************************
OAM_progselect
            	dwcode	SetOAMbig	 ;(0)
	dwcode	SetOAMsmall	 ;(1)
	dwcode	SetOAMbig_clip	 ;(2)
	dwcode	SetOAMsmall_clip ;(3)
	dwcode	SetOAM_sub	 ;(4)
	dwcode	SetOAM_sub_clip	 ;(5) full spec
	dwcode	SetOAM_message	 ;(6)
	dwcode	SetOAM_stagestart ;(7)

OAM_progcode	dw	6
	dw	6
	dw	6
	dw	6
	dw	6
	dw	6
	dw	6
	dw	6

;**********************************************************
;	byte object draw
;**********************************************************
;**********************************************************
;	(H)8x(V)16 object draw
;**********************************************************
; total 7 byte code
;--------------------------------
; 0 ... oamset code
; 1 ... object position
; 3 ... select address
; 5 ... character start address
;----------------------------------------------------------

SetOAM_stagestart

	lda	#2		; data count
	sta	sameloop

	lda.w	1,y		; offset position
	clc
	adc	displayHV
	pha			; >>

	ldx.w	3,y		; select address
	lda	0,x
	inc	a
	and	#0007h
	asl	a		; keydata * 4
	asl	a
 	adc.w	5,y
	tay			; character start address

	pla			; <<

	clc

	ldx	sprite_register
.loop	sta.l	sprites+0,x
	adc	#0800h
	pha
	lda.w	0,y
	sta.l	sprites+2,x
	pla
	inx
	inx
	inx
	inx
	iny
	iny
	dec	sameloop
	bne	.loop
	stx	sprite_register

	rts

;----------------------------------------------------------
SetOAM_message

	jsr	Setformat1

	ldx	sprite_register

	lda	centerV
	and	#00ffh
	xba
	ora	centerH	
	sta	displayHV

.loop1
	ldy	pos_pointer
	lda.w	0,y
	and	#00ffh
	beq	.exit
	sta	sameloop
	iny
	lda.w	0,y		; position
	clc
	adc	displayHV
	iny
	iny
	sty	pos_pointer


	ldy	char_pointer
.loop2
	sta.l	sprites+0,x	; H,V position
	adc	#0008h
	pha			; >>
	lda.w	0,y
	beq	.clear
	sta.l	sprites+2,x	; Char,Attribute
	inx
	inx
	inx
	inx
.clear	pla			; <<
	iny
	iny	
	dec	sameloop
	bne	.loop2
	sty	char_pointer
	bra	.loop1

;----------------------------------------------------------

.exit	stx	sprite_register
;----------------------------------------------------------
	rts


;**********************************************************
;
;**********************************************************

Setformat1	ldx	register

	lda	_charmask,x
	sta	objmask
	lda	_charadd,x
	sta	objadd
	lda	_axisX,x
	sta	centerH
	lda	_axisY,x
	sta	centerV
	lda.w	1,y		; character total
	and	#00ffh
	sta	obj_counter
	lda.w	2,y		; position address
	sta	pos_pointer
	lda.w	4,y		; character address
	sta	char_pointer

	rts

;**********************************************************
;	OAM Set Program
;		H,V position
;		Sub data set
;		H-Clipping
;**********************************************************
SetOAM_sub_clip
;**********************************************************
;	OAM Set Program
;		H,V position
;		Sub data set
;**********************************************************
SetOAM_sub
;**********************************************************
;	OAM Set Program
;		H,V position
;		Sub data constant
;		H-Clipping
;**********************************************************
SetOAMbig_clip
SetOAMsmall_clip
;**********************************************************
;	OAM Set Program
;		H,V position
;		Sub data constant
;**********************************************************
SetOAMsmall
	jsr	Setformat1
	bra	set_common
;----------------------------------
SetOAMbig
;----------------------------------
	jsr	Setformat1
;----------------------------------
	lda	obj_counter
	dec	a
	lsr	a
	lsr	a
	sta	oamtmp
;----------------------------------
	lda	sprite_register
	sec
	sbc	sprite_offset
	lsr	a
	lsr	a
	lsr	a
	lsr	a
	clc
	adc	sprite_offset
	tax
;----------------------------------
	a8
.loop	lda.w	6,y
	sta.l	sprites+200h,x	; Set OAM-SUB
	iny
	inx
	dec	oamtmp	
	bpl	.loop
	a16
;----------------------------------
set_common
	ldx	sprite_register
.loop
	a8

	ldy	pos_pointer
	clc
	lda.w	1,y
	adc	centerV
	xba
	clc
	lda.w	0,y
	adc	centerH
	a16
	sta.l	sprites+0,x	; H,V position
	iny
	iny
	sty	pos_pointer

	ldy	char_pointer
	lda.w	0,y
	and	objmask
	clc
	adc	objadd
	sta.l	sprites+2,x	; Char,Attribute
	iny
	iny
	sty	char_pointer

	inx
	inx
	inx
	inx

	dec	obj_counter
	bne	.loop
;----------------------------------------------------------
	stx	sprite_register
;----------------------------------------------------------
	rts

;***********************************************************************
;	OAM Skip program
;***********************************************************************

OAMSkip

;-------------------------------------------
	lda	sprite_register
;- - - - - - - - - - - - - - - - - - - - - -
	ldy	#0e0e0h
.loop	bit	#01111b
	beq	.skip
	tax
	tya
	sta.l	sprites,x
	txa
	inc	a
	inc	a
	inc	a
	inc	a
	bra	.loop
;- - - - - - - - - - - - - - - - - - - - - -
.skip	sta	sprite_register
	rts

;============================================================
;************************************************************
;	Print Display Object
;************************************************************
number_data	db	0,1,2,3,4,5,6,7,8,9,0ah,0bh,0ch,0dh,0eh,0fh
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;;
;;
;;
;;
;;
;; Xregister  position
;;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

;============================================================
pos_work	equ	Xwork7
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
OBJ_print
	ply			; <
	stx	pos_work
	ldx	sprite_register
.loop	lda.w	1,y
	iny
	and	#00ffh
	cmp	#ed		;
	beq	.exit
	ora	#message_attr
	sta.l	sprites+2,x	;
	lda	pos_work
	sta.l	sprites+0,x	;
	clc
	adc	#0008h
	sta	pos_work
	inx
	inx
	inx
	inx
	bra	.loop
.exit	stx	sprite_register
	ldx	pos_work	; next position
	phy			; 
	rtl

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Yregister	position
; Aregister  hex-data (0000-ffff)
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
OBJ_three	pha
	xba
	jsl	OBJ_digit
	pla
	bra	OBJ_byte
OBJ_word	pha			;>>
	xba
	jsl	OBJ_byte
	pla			;<
OBJ_byte	pha			;>>
	lsr	A		;W
	lsr	A		;W
	lsr	A		;W
	lsr	A		;W
	jsl	OBJ_digit
	pla			;<
OBJ_digit	and	#000FH
	tax
	lda	number_data,x
	and	#00ffh	
OBJ_set	ldx	sprite_register
	ora	#message_attr	; 
	sta.l	sprites+2,x	;
	tya
	sta.l	sprites+0,x	;
	clc
	adc	#0008h
	inx
	inx
	inx
	inx
	stx	sprite_register ; <<
	tay			;
	rtl
;=============================================================

	end

