;**
;*
;*  Module:       ed_files.m
;*  Version:      1.0
;*  Description:  like "edit_file",  but allows wild-cards
;*                try autoloading this file in your initials macro
;*                and (assign_to_key "<Alt-e>" "edit_files") - then
;*                forget it.  it behaves exactly the same as the 
;*                standard command,  except that it allows wildcards
;*                and has a default ("*.*")
;*  Author:       Paul Roub
;*                690 Anderson Court
;*                Satellite Beach, FL 32937
;*                Compuserve: 71131, 157
;*
;*  Revision History:
;*     7-21-88: created
;*     8-17-88: touched up error messages
;*
;**

;**;
(macro edit_files
  (
    (string     pathbuf               ;*  path part of search string
                namebuf               ;*  name returned by (find_file)
                file_mask             ;*  our search mask (parameter 0)
                first_one             ;*  name of first file found
                editname              ;*  full name of file to edit
                mbuf                  ;*  message buffer
    )
    (int        found_any             ;*  non-zero if any files found
                slpos                 ;*  position of /, \, or : in mask
                attrib                ;*  attribute of found file
    )


    (= found_any 0)

    (if (get_parm 0 file_mask "Files: " 66 "*.*")
      (
        ;*
        ;*  find drive/path part of mask,  and save it
        ;*
        (= slpos (rindex file_mask "\\"))

        (if (== slpos 0)
          (= slpos (rindex file_mask "/"))
        )

        (if (== slpos 0)
          (= slpos (index file_mask ":"))
        )

        (= pathbuf (substr file_mask 1 slpos))

        (file_pattern file_mask)

        ;*
        ;*  see what we can see
        ;*
        (while (find_file namebuf NULL NULL NULL attrib)
          (
            ;*
            ;*  append it to path - find_file returns name.exe only
            ;*

            (if (! (& attrib 16))
              (
                (= editname (lower (+ pathbuf namebuf)))
    
                (if (== found_any 0)
                  (
                    (= found_any 1)
                    (= first_one editname)
                  )
                )
              )
            )

            (edit_file editname)
          )
        )


        ;*
        ;*  if we found any files,  go to the first one found
        ;*  otherwise,  if the string has wildcards we can't do
        ;*  anything - if it doesn't, try to open it as a new file
        ;*  and mimic edit_file message
        ;*
        (if (== found_any 0)
          (
            (if (&& (! (index file_mask "*")) (! (index file_mask "?")))
              (
                (edit_file file_mask)     ;*  try it as ONE new file
                (= file_mask (lower file_mask))
                (sprintf mbuf "New file (unable to open %s)." file_mask)
                (message mbuf)
              )
             ;else
              (message "no matches found")
            )
          )
          ;else
            (edit_file first_one)     ;*  go to the first match
        )
      )
    )
  )
)

