;**************************************************************************
;*                                                                        *
;*  I downloaded this from the Brief BBS on 1/20/89.                      *
;*                                                                        *
;*  I added a minor enhancement that allows the marking of a block in     *
;*  the LIST window.  The marked block may then be printed or written to  *
;*  disk with a new name.                                                 *
;*                                                                        *
;*  David Wick      1/23/89                                               *
;*                                                                        *
;**************************************************************************

;**************************************************************************
;*                                                                        *
;*    I downloaded this from the Brief BBS around 12/20/88.               *
;*                                                                        *
;*    The macro worked fine the 1st time invoked, but:                    *
;*                                                                        *
;*    1)    It would not allow you to type parameters on subsequent       *
;*          invocations.                                                  *
;*                                                                        *
;*    2)    It would not let you escape out without taking                *
;*          parameters (from user) and then running.                      *
;*                                                                        *
;*    3)    Would not correctly print out its replacement                 *
;*          results.                                                      *
;*                                                                        *
;*    4)    Would infinately loop if the 1st string was contained         *
;*          in the second string.                                         *
;*                                                                        *
;*    It appeared to me that it was written prior to BRIEF 2.0.           *
;*                                                                        *
;*    I fixed the above 3 problems resulting in this version.             *
;*                                                                        *
;*       ******************  PLEASE NOTE  *********************           *
;*                                                                        *
;*       In order to handle multiple substitutions on a line correctly,   *
;*       this macros uses BRIEF Bookmark #10 (without regard as to        *
;*       whether it is in use).                                           *
;*                                                                        *
;*    Larry DeMar      12/23/88                                           *
;*                                                                        *
;**************************************************************************
;
;**
;**   Search and Replace multiple buffers
;**
;**   use macro with <F10> "regrep"
;
(macro regrep
	(
       (extern _reg_exp
               _s_pat
               _t_pat
               _r_pat
       )

		(int	msg_level
				ret_code
				line_at
				end_col
				old_buffer		;** number of the original buffer
				list_buffer		;** number of the list buffer
				num_buffer		;** number of total buffers
				cur_buffer		;** the number of the current buffer
            sub_col        ;** column beyond substitution
		)

      (string default_pat)    ;** for SEARCH.M fetcher


;		(string buf pattern rep_pattern prompt line_no)
		(string buf pattern prompt line_no)         ;LED
		(global old_buffer list_buffer)

;		(color 1 8 8 12 12)

		;** Initialize for grep.
		(= old_buffer (inq_buffer))
		(save_position)					;** save the current position

		(while (!= old_buffer cur_buffer)
			(
			(if (! cur_buffer)
			  	(= cur_buffer old_buffer)
			)
			(++ num_buffer)
		 	(= cur_buffer (next_buffer))
			(set_buffer cur_buffer)
			)
		)
;**************************************************************************
;*                                                                        *
;*       The following code section was taken from                        *
;*       the translate macro replacement in                               *
;*       Brief's SEARCH.M.  It does a more intelligent                    *
;*       parameter fetch than the original REGREP (which                  *
;*       looks like it was written before BRIEF 2.1).                     *
;*                                                                        *
;*       I added a provision to allow you to escape from                  *
;*       the prompts (which did not work properly under                   *
;*       BRIEF 2.1.)    Larry DeMar    12/23/88                           *
;*                                                                        *
;**************************************************************************
		;**
		;**		It's nice to be able to see the setting of the regular
		;**	expression toggle in the search string.  We check to see
		;**	what it is, and change the translate prompt accordingly.
		;**

		(sprintf prompt "Regrep Pattern%s: " (if _reg_exp "" " (RE off)"))

		;**
		;**		If there haven't been any previous translate patterns,
		;**	we use the last search pattern as the default response to
		;**	the Pattern: prompt.  Otherwise, we use the previous
		;**	translate pattern.
		;**
		(if (! (strlen _t_pat))
			(= default_pat _s_pat)
		;else
			(= default_pat _t_pat)
		)
		(if (get_parm 0 pattern prompt NULL default_pat)
			(
				(if (get_parm 1 _r_pat "Replacement: " NULL _r_pat)
					(
						(= _t_pat pattern)
						(= ret_code 1)
					)
				;else
					(= ret_code 0)
				)
			)
		;else
			(= ret_code 0)
		)

      (if   (! ret_code)
            (
               (message "Regrep Cancelled.")
               (return)
            )
      )
;**************************************************************************
;*                                                                        *
;*    This was the regrep parameter getting code:                         *
;*                                                                        *
;**************************************************************************
;		(if _reg_exp
;			(= prompt "Replace (all files): ")
;		;else
;			(= prompt "Replace (RE off, all files): ")
;		)
;
;		(if (strlen _s_pat)
;			(= ret_code (get_parm 0 pattern (_sprompt prompt _s_pat)))
;			;else
;			(= ret_code (get_parm 0 pattern prompt)))
;		
;		
;		(if _reg_exp
;			(= prompt "Replace with (all files): ")
;		;else
;			(= prompt "Replace with (RE off, all files): ")
;		)
;		(get_parm 0 rep_pattern prompt)

		(= list_buffer (create_buffer "list" "$$$$grep.$b$" 1))

;		(if ret_code
;			(
;				(if (&& (strlen _s_pat) (strlen pattern))
;					(
;						(push_back (atoi pattern 0))
;						(= ret_code (get_parm 0 pattern prompt))
;					)
;				)
;				(if ret_code
;					(if (strlen pattern)
;					(= _s_pat pattern))
;				)
;			)
;		)
		(while (> num_buffer 0)
			(
			(message "Replacing... %d files" num_buffer)
			(-- num_buffer)
; LED			(top_of_buffer)				 ;** start at the top
			(inq_names NULL NULL buf)
   	  	(set_buffer list_buffer)
	     	(sprintf buf "\nFile %d: %s\n\n Line #\n\n" (+ num_buffer 1) (upper buf))
			(insert buf)
			(set_buffer old_buffer)
;			(while (translate _s_pat rep_pattern 1) ;** use the new provided search
         (save_position)                            ;** LED
         (top_of_buffer)                            ;** LED replace entire buffer
;**************************************************************************
;*                                                                        *
;*          search first to make the error log work correctly  LED        *
;*                                                                        *
;**************************************************************************
			(while (search_fwd _t_pat _reg_exp)        ;** LED
            (  (save_position)                      ;translate will be done from here ** LED
               (search_fwd (+ _t_pat "\\c") _reg_exp)  ;position cursor after sub str.** LED

;**************************************************************************
;*                                                                        *
;*    Since the replacement string can be of varying length based         *
;*    on \0 type substitution, embedded newlines etc, the safest way      *
;*    to get back to the end of the string is to use a Brief Bookmark.    *
;*                                                                        *
;*    It appears that the Bookmarks track line insertions, but not        *
;*    column insertions.....Therefore....A newline is inserted            *
;*    first, and all substitution (including new lines generated)         *
;*    will occur above the new line.  This will be deleted after          *
;*    the insertion.)                                                     *
;*                                                                        *
;*    THIS MACRO USES (and smashes) BOOKMARK 10 FOR THIS PURPOSE          *
;*                                                                        *
;**************************************************************************
               (insert "\n")                            ;insert a carriage return ** LED
               (drop_bookmark 10 "y")                   ;this will get us back here for next sub ** LED
               (restore_position)                      ;now we're ready to xlate ** LED
               (translate _t_pat _r_pat 0 _reg_exp) ;** LED

					(goto_bookmark 10)       ;go to spot just beyond this substitution. ** LED
               ;** 
               ;** now we need to remove the "cr" we inserted"
               ;**
               (up)                     ;it "ends" the previous line ** LED
               (end_of_line)            ;we're on it ** LED
               (delete_char)            ;its gone, and we're positioned for next time around ** LED

               (save_position)          ;next search starts here. ** LED

					(beginning_of_line)
					(inq_position line_at NULL)
					(end_of_line)
					(inq_position NULL end_col)
					
					;** switch to list buffer
					(set_buffer list_buffer)  
					
					;** put in the line number
					(sprintf line_no "%5d  " line_at)
					(insert line_no)

					;** copy in the line
					(transfer old_buffer line_at 1 line_at end_col)	
					;** return to buffer listing
					(set_buffer old_buffer)			
               (restore_position)         ;setup for next search ** LED
			  	)
			)
         (restore_position)         ;LED   leave pos in buffer where it was.
			(= old_buffer (next_buffer))
			(set_buffer old_buffer)
			)
		)
		
		;** Now that we've read all of the buffers in memory, let's display
		;** the fruits of our labor.

	  	(_show_list)
		(delete_buffer list_buffer)		;** get rid of the list buffer
		(restore_position 1)					;** restore the position
	     ;	(tyx)
	)						 
)


(macro _show_list
	(
;		(color 2 11 12 12 12)
		(set_buffer list_buffer)				;** switch to list buffer
		(attach_buffer list_buffer)			;** let's see our handiwork
		(top_of_buffer)
		(refresh)
		;** (message "Use PgUp, PgDn, or press Esc to exit")
		(message "PgUp, PgDn, Write or Print Blocks, Esc to exit")
		(keyboard_push)							;** allow only certain keys

        (assign_to_key  "<Alt-l>" "mark 3")
        (assign_to_key  "<Alt-c>" "mark 2")
        (assign_to_key  "<Alt-a>" "mark 4")
        (assign_to_key  "<Alt-m>" "mark")
        (assign_to_key  "<Alt-p>" "print")
        (assign_to_key  "<Alt-w>" "write_block")
        (assign_to_key  "<Home>" "_home")
        (assign_to_key  "<End>" "_end")

		(assign_to_key	"%#73" "page_up") 	;** PgUp
		(assign_to_key	"%#81" "page_down")	;** PgDn
		(assign_to_key	"#27" "exit")			;** Esc
		(assign_to_key "%#72" "up")			;** Up
		(assign_to_key "%#80" "down")			;** Down
		(assign_to_key "%#77" "right")		;** Right
		(assign_to_key "%#75" "left")			;** Left
		(process)
		(keyboard_pop)
		(set_buffer old_buffer)				;** return to buffer listing
		(attach_buffer old_buffer)			;** get back to normal
      (refresh)
		(message "Regrep completed.")
	)
)
;**
;**		_sprompt:
;**
;**		This routine ensures that the prompt created by the previous pattern
;**	search code isn't too large for the display area.
;**
;
;(macro _sprompt
;	(
;		(string		part_1
;						part_2
;		)
;		(int			len)
;
;		(get_parm 0 part_1)
;		(get_parm 1 part_2)
;
;		(if (> (= len (strlen (+ part_1 part_2))) 47)
;			(= part_2 (substr part_2 (- len 46)))
;		)
;		(returns (+ part_1 part_2))
;	)
;)





