;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: hell.asm				*
;* 	Description	: BG screen demo program		*
;*			; heaven <-> hell switch demo		*
;*			; boss entry demo			*
;*	Date		: 1994.7.25				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;;
;;
;;
;;
;---------------------------------------------------------------------
	INCPUB  hell
;---------------------------------------------------------------------
;;
;---------------------------------------------------------------------
this_bank	=	*&$ff0000
;---------------------------------------------------------------------
	longa
	longi
;*********************************************************************
; 	heaven <-> hell switch demo initial
;*********************************************************************

init_hell_l
hell_l
irq_hell_l		rtl

;=======================================================================
;
;
;
;
;
;
;
;
;
;
;
;
;
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;=========	DEMO CONTROL SYSTEM =======================================
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;***********************************************************************
;;	Game Demo Control System
;***********************************************************************

;---------------------------------------------------------------------

Minc_dccounter	macro
	inc	_dccounter,x
	bne	.\@p1
	dec	_dccounter,x
.\@p1	
	endm

;---------------------------------------------------------------------

dc_select	ldx	dcregister
	lda	_dcinput,x	; input trigger
	beq	.exit
	bmi	.entry
	sta	_dcselect,x	; work initialize
	ora	#8000h		; set flag

	sta	_dcinput,x
	stz	_dcprocess,x	
	stz	_dccounter,x	; timer reset
	stz	_dctimer,x

.entry	sec
	pla
	adc	_dcselect,x
	adc	_dcselect,x
	txy
	tax
	jmp	(0,x)
.exit	pla			
	rts

;---------------------------------------------------------------------

dc_process	pla			
	tyx			; Y = dcregister
	sec
	adc	_dcprocess,x
	adc	_dcprocess,x
	tax
	jmp	(0,x)		; Y = dcregister

;---------------------------------------------------------------------

dc_wait	ldx	dcregister
	ldy	_dctimer,x
	beq	dc_next
	dec	_dctimer,x
	Minc_dccounter
	rts

;---------------------------------------------------------------------

dc_next	ldx	dcregister
	sta	_dctimer,x	; set next timer
	stz	_dccounter,x	; reset next counter
	inc	_dcprocess,x
	rts

;---------------------------------------------------------------------

dc_reset	ldx	dcregister
	stz	_dccounter,x
	stz	_dctimer,x

 	rts

;---------------------------------------------------------------------

dc_init	stx	dcregister	; branking initialize
	bra	dc_initset	
dc_fullreset	
	ldx	dcregister	; endof dc_process
	lda	#0
dc_initset
	sta	_dcinput,x
	stz	_dcselect,x
	stz	_dcprocess,x
	rts

;---------------------------------------------------------------------
; dwwait
;
;
;---------------------------------------------------------------------

dc_program	ldx	dcregister
	txy
	stz	_dcflag,x	; flag reset
	pla
	sec
	adc	_dcprocess,x	; *3 code/address
	adc	_dcprocess,x
	adc	_dcprocess,x
	tax
	lda.l	this_bank+0,x
	and	#00ffh
	beq	.end
	pha			; >>
	lda.l	this_bank+3,x	; 	Y = next timer
	and	#007fh
	pha			;   >>
	jsr	(1,x)		;	 
	ply			;   <<
	pla			; <<
	bit	#80h
	bne	.code

;-------------------------------------

.wait	tya			; next timer
	jmp	dc_wait		; timer wait

;-------------------------------------

.code	and	#0fh
	asl	a
	tax
	jmp	(.process,x)

.process	dwcode	.next		; 80 --> next process
	dwcode	.stop		; 81 --> stop process
	dwcode	.flag		; 82 --> flag process

;-------------------------------------

.end	jmp	dc_fullreset	; --> end  process

;-------------------------------------

.next	tya
	jmp	dc_next	

;-------------------------------------

.stop	ldx	dcregister
	Minc_dccounter
	rts			; --> stop loop

;-------------------------------------

.flag	ldx	dcregister
	Minc_dccounter
	lda	_dcflag,x
	beq	.exit
	tya
	jmp	dc_next

;-------------------------------------

.exit	rts

;---------------------------------------------------------------


;====================================================================
;====================================================================
;END END END END END END END END END END END END END END END END END 
;====================================================================
;====================================================================


