/************************************************************************/
/**                                                                    **/
/**    Starfox Cad Tools - (c) 1994 Dylan Cuthbert (Argonaut Software) **/
/**                                                                    **/
/************************************************************************/

#define _SFC_

#include "sfc.h"

//-----------------------------------------------------------------------
Window *mw,*tw;


int currentmode=-1;
int maxx;

int *selected;
int numselected;


//-----------------------------------------------------------------------

void CloseMode(int mode);
void OpenMode(int mode);
void DoMode(int mode);

//-----------------------------------------------------------------------

int FindMaxGadgetWidth(struct g *gad)
	{
	int n,max=0;

	for (n=0;gad[n].name; n++)
		if (GADGETSIZEX(mw,gad[n].name) > max) max = GADGETSIZEX(mw,gad[n].name);
	
	return max;
	}


//-----------------------------------------------------------------------
// Load a file into ram (returns NULL if fails)

char *LoadFile(char *name)
	{
	char *d=NULL;
	int total=1024;
	FILE *fp;

	if (fp = fopen(name,"rb"))
		{
		while (!feof(fp))
			{
			if (!(d = (char *)realloc(d,total))) break;
			fread(d+total-1024,1024,1,fp);
			total+= 1024;
			}
		fclose(fp);
		}

	return d;
	}

//-----------------------------------------------------------------------
// Frees the ram allocated by LoadFile

void FreeFile(char *file)
	{
	free(file);
	}

//-----------------------------------------------------------------------
int FindSelected(int n)
	{
	int m;

	for (m=0;m<numselected;m++)
		{
		if (selected[m] == n) return m;
		}
	return -1;
	}


//-----------------------------------------------------------------------
void AddSelected(int n)
	{
	selected = (int *)realloc(selected,(numselected+1)*sizeof(int));
	selected[numselected++] = n;

	}
//-----------------------------------------------------------------------
void DelSelected(int n)
	{
	int m;

	for (m=0;m<numselected;m++)
		{
		if (selected[m] == n)
			{
			memcpy(&(selected[m]),&(selected[m+1]),numselected*sizeof(int)-(m+1)*sizeof(int));
			numselected--;
			return;
			}
		}
	}
//-----------------------------------------------------------------------

main(int argc, char *argv[])
	{
	struct g gadgets[] =
		{
		"Font Conversion", MODE_TEXT, 0,
		"Starfox Messages", MODE_MESSAGES, 0,
		"CGX Tweaking", MODE_CGX, 0,
		"Slope Data", MODE_SLOPES, 0,
		"Quit", MODE_QUIT, KB_ALTQ,
		NULL
		};
	int n;

	Initialise_Windows();

	mw = new Window(0,0,GrScreenX(),GrScreenY(),LIGHTGRAY,"Starfox CAD Tool v0.9 - (c) 1994 Dylan Cuthbert",W_MOTIFBORDER|W_INCLUDEBORDER|W_INCLUDETITLE);

	mw->setfont(nicefont);
	mw->FGcolor(BLACK);

	maxx = FindMaxGadgetWidth(&gadgets[0]);
	for (n=0; gadgets[n].name; n++)
	new Gadget(mw,mw->MaxX()-maxx, GADGETSIZEY(mw)*n,mw->MaxX(),0,gadgets[n].name,gadgets[n].id, G_TEXTHIGHLIGHT|G_OVERONLY|G_EXCLUSIVE|G_BOXTEXT|G_BOXHIGHLIGHT,gadgets[n].key);

	mw->Select(currentmode);

	mw->Direct();

	OpenMode(currentmode);

	while (1)
		{
		Update_Mouse();

		DoMode(currentmode);

		if (mw->mouse())
			if ((mw->input.flags & M_KEYPRESS) && (mw->input.key == ''))
				break;

			if ((mw->input.gflags&GF_SELECTED))
				{
				if (mw->input.gadget == MODE_QUIT) break;
				CloseMode(currentmode);
				OpenMode(currentmode = mw->input.gadget);
				}

		}

	CloseMode(currentmode);
	delete mw;

	Closedown_Windows();
	}

//----------------------------------------------------
void DoMode(int mode)
	{
	int n,redraw=0;

	switch(mode)
		{
		case MODE_TEXT:
			DoFonts();
			break;
		case MODE_SLOPES:
			DoSlopes();
			break;
		case MODE_MESSAGES:
			DoMessages();
			break;
		default:
			break;
		}
	}


//----------------------------------------------------
void OpenMode(int mode)
	{
	FILE *fp;
	char temp[80];
	int n,num,m,c,r,fra;

	numselected = 0;
	if (selected) free(selected);
	selected = NULL;

	switch(mode)
		{
		case MODE_TEXT:
			OpenFonts();
			break;

// Slope editing:

		case MODE_SLOPES:
			OpenSlopes();
			break;

// Messages editing:

		case MODE_MESSAGES:
			OpenMessages();
			break;

		default:
			break;
		}
	}

//----------------------------------------------------
void CloseMode(int mode)
	{
	int n;

	switch(mode)
		{
		case MODE_TEXT:
			CloseFonts();
			break;
		case MODE_SLOPES:
			CloseSlopes();
			break;
		case MODE_MESSAGES:
			CloseMessages();
			break;
		default:
			break;
		}
	}

