;
	include		mn_hp_smram.asm
;
         ORG      058000H
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;        1991.12.03         V.1.0  Super Mario-CD
;                                  File  name : SMSUB0
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;=========================================================== SMSUB0 ==
		GLB	BG2PTR
		EXT	MARIOW
;
;=========================================================== SMSUB1 ==
		GLB	GRAUNT
		EXT	HDMAON
;=====================================================================
; 
		EXTEND
		IDX8
		MEM8
;=====================================================================
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;
BG2PTR	EQU	$
		STZ	WDWFLG
;
		PHB
		LDA	#BANK BG2DT
		PHA
		PLB			; (DBR) set
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; SVRAM CLEAR!!
		LDX	#0000H
		LDA	#0000H
BG2010		EQU	$
		STA	BG2UNT+0000H,X
		STA	BG2UNT+0100H,X
		STA	BG2UNT+0200H,X
		STA	BG2UNT+0300H,X
		STA	BG2UNT+0400H,X
		STA	BG2UNT+0500H,X
		STA	BG2UNT+0600H,X
		STA	BG2UNT+0700H,X
		STA	BG2UNT+0800H,X
		STA	BG2UNT+0900H,X
		STA	BG2UNT+0A00H,X
		STA	BG2UNT+0B00H,X
		STA	BG2UNT+0C00H,X
		INX
		INX
		CPX	#0100H
		BNE	BG2010
;
		PLB			; (DBR) reset
;
	PHB
	PHK
	PLB
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; PAGE CLEAR
	STZ	PAGECT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; READ DATA ADDRESS
	LDA	CGCFLG
	AND	#00FFH
	BEQ	RDA010
	STA	<BG2COS
RDA010	EQU	$
	LDA	<BG2COS
	AND	#00FFH
	ASL	A
	TAX
	LDA	B2CSDT,X
	STA	<WORK2		;READ DATA INDEX
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
;
SHIRO	EQU	$
	MEM16
	IDX16
	REP	#30H
;
	LDX	<WORK2
	LDA	BG2DAT,X
	STA	<WORK4		;READ DATA
	INC	<WORK2
	INC	<WORK2
;
	AND	#03F0H
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	STA	<WORKC		;UNIT NO
;
	LDA	<WORK4
	AND	#000FH
	STA	<WORKE		;KAZU
;
	LDA	<WORK4
	AND	#0E000H
	STA	<WORKA
	LDA	<WORK4
	LSR	A
	AND	#0E00H
	ORA	<WORKA
	XBA
	STA	<WORKA		;Y,X (YYYY-XXXX)
;
	AND	#00F0H
	CMP	#00E0H
	BNE	CSK010
	LDA	<WORKC
	CMP	#3FH
	BNE	CSK005
	INC	PAGECT
	INC	PAGECT
	LDA	PAGECT
	XBA
	TAX
	LDA	#0FFFFH
	STA	>BG2UNT,X
	JMP	BG2RET
CSK005	EQU	$
	JSR	OPTNUT
	BRA	SHIRO
CSK010	EQU	$
	LDA	PAGECT
	XBA
	CLC
	ADC	<WORKA
	STA	<WORK8		;UNIT SAVE INDEX
;
	LDA	<WORKC
	CMP	#10H
	BCC	CSK020
	JSR	UNPT22
	JMP	SHIRO
CSK020	EQU	$
	ASL	A
	TAX
	LDA	<BG2COS
	ASL	A
	TAY
	LDA	CORSUN,Y
	STA	<WORK4
	LDA	#5
	STA	<WORK6
;
	TXY
	LDA	[WORK4],Y
	STA	<WORK
	JMP	(WORK)
;
CORSUN	EQU	$
	WORD	WTSPUT	;00
	WORD	WTSPUT	;01
	WORD	SHWPUT	;02
	WORD	GRSPUT	;03
	WORD	S83PUT	;04
	WORD	GRSPUT	;05
	WORD	GRSPUT	;06
	WORD	GRSPUT	;07
	WORD	GRSPUT	;08
	WORD	TAKPUT	;09
	WORD	SNDPUT	;0A
	WORD	GRSPT2	;0B
	WORD	GRSPUT	;0C
	WORD	GRSPT2	;0D
	WORD	GRSPUT	;0E
	WORD	MSASPT	;0F
	WORD	GRSPUT	;10
	WORD	GRSPUT	;11
	WORD	MSASPT	;12
	WORD	GRSPUT	;13
	WORD	GRSPT2	;14
	WORD	GRSPT2	;15
	WORD	GRSPT2	;16
	WORD	GRSPUT	;17
	WORD	GRSPUT	;18
	WORD	CHSPUT	;19
	WORD	CHSPUT	;1A
	WORD	GRSPUT	;1B
	WORD	SHSPUT	;1C
	WORD	SHSPUT	;1D
	WORD	SHSPUT	;1E
	WORD	SHSPUT	;1F
	WORD	SHSPUT	;20
	WORD	SH2PUT	;21
;
SNDPUT	EQU	$
	WORD	KPLB05	;00
	WORD	KPLB07	;01
	WORD	KPLSML	;02
;
SHWPUT	EQU	$
	WORD	SHWPT0	;00
;
S83PUT	EQU	$
	WORD	SHISET	;00
	WORD	UN83AA	;01
	WORD	UN83BB	;02
	WORD	UN83CC	;03
	WORD	UN83DD	;04
	WORD	UN83AA	;01
	WORD	UN83AA	;01
	WORD	UN83DD	;01
	WORD	UN83BB	;01
	WORD	UN83AA	;01
;
WTSPUT	EQU	$
	WORD	KOBU01
	WORD	KOBU11
	WORD	KOBU02
	WORD	KOBU12
;
GRSPUT	EQU	$
	WORD	MROBIG	;00
	WORD	STARST	;01
	WORD	STARST	;02
	WORD	STARST	;03
	WORD	YAMAW1	;04
	WORD	YAMAW2	;05
	WORD	YAMAW3	;06
	WORD	YAMAW4	;07
	WORD	YMWD01	;08
	WORD	YMWD02	;09
	WORD	YMWD03	;0A
	WORD	YMWD04	;0B
	WORD	YMWD05	;0C
	WORD	YMWD06	;0D
	WORD	YMWD07	;0E
	WORD	MORIWT	;0F
;
CHSPUT	EQU	$
	WORD	BOYOKO
	WORD	BOTAT1
	WORD	BOTAT2
;
SH2PUT	EQU	$
	WORD	UNPTAA	;00
	WORD	UNPTBB	;01
	WORD	UNPTAA	;02
	WORD	UNPTBB	;03
	WORD	UNPTAA	;04
	WORD	UNPTBB	;05
	WORD	UNPTAA	;06
	WORD	UNPTBB	;07
	WORD	UNPTAA	;08
	WORD	UNPTBB	;09
	WORD	UNPTAA	;0A
	WORD	UNPTBB	;0B
	WORD	UNPTAA	;0C
	WORD	UNPTBB	;0D
	WORD	UNPTAA	;0E
	WORD	UNPTBB	;0F
;
SHSPUT	EQU	$
	WORD	POLE01	;0
	WORD	POLE01	;1
	WORD	POLE02	;2
	WORD	POLE03	;3
	WORD	POLE04	;4
	WORD	KPPAPK	;5
	WORD	SHDOOR	;6
	WORD	POLE05	;7
	WORD	MADO01	;8
	WORD	SHKZ01	;9
	WORD	SHKZ02	;A
	WORD	PLTU01	;B
;
GRSPT2	EQU	$
	WORD	TYAMA1	;00
	WORD	TYAMA1	;01
	WORD	TYAMA1	;02
	WORD	TYAMA1	;03
	WORD	TYAMA1	;04
	WORD	TYAMA1	;05
	WORD	TYAMA1	;06
	WORD	TYAMA1	;07
	WORD	TYAMA1	;08
	WORD	TYAMA1	;09
	WORD	TYAMA1	;0A
	WORD	TYAMA1	;0B
	WORD	TYAMA1	;0C
	WORD	TYAMA1	;0D
	WORD	TYAMA1	;0E
	WORD	TYAMA1	;0F
;
MSASPT	EQU	$
	WORD	MSPL01	;00
	WORD	MSPL02	;01
	WORD	MSPL03	;02
	WORD	MSPL04	;03
	WORD	MSPL11	;04
	WORD	MSPL12	;05
	WORD	MSPL13	;06
	WORD	MSPL14	;07
	WORD	MSYK01	;08
	WORD	MSYK02	;09
	WORD	MSYK03	;0A
	WORD	MSYK04	;0B
;
TAKPUT	EQU	$
	WORD	TAKIPT	;00
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
KPLDSM	EQU	$
	HEX	07,0A,0B,12,19	;0
	HEX	29,2A,33,34,30	;5
	HEX	00,07,0A,1D,19	;A
	HEX	00,29,2A,2D,30	;F
KPLSML	EQU	$
	LDY	<WORKE
	LDX	<WORK8
	MEM8
	SEP	#20H
	LDA	KPLDSM,Y
	STA	>BG2UNT,X
	LDA	KPLDSM+1,Y
	STA	>BG2UNT+10H,X
	LDA	KPLDSM+2,Y
	STA	>BG2UNT+20H,X
	LDA	KPLDSM+3,Y
	STA	>BG2UNT+30H,X
	LDA	KPLDSM+4,Y
	STA	>BG2UNT+40H,X
	MEM16
	REP	#20H
	JMP	SHIRO
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
KPBD07	EQU	$
	HEX	01,02,03,04
	HEX	08,09,05,06
	HEX	10,11,17,18,1B,1C
;
	HEX	1F,20,21,22
	HEX	25,26,23,24
	HEX	2B,2C,2E,2F,31,32
;
KPLB05	EQU	$
	LDY	#0EH
	BRA	KPLBIG
KPLB07	EQU	$
	LDY	#0
KPLBIG	EQU	$
	LDX	<WORK8
	INX
;
	MEM8
	SEP	#20H
	LDA	KPBD07,Y
	STA	>BG2UNT,X
	LDA	KPBD07+1,Y
	STA	>BG2UNT+1,X
	LDA	KPBD07+2,Y
	STA	>BG2UNT+10H,X
	LDA	KPBD07+3,Y
	STA	>BG2UNT+11H,X
	LDA	KPBD07+6,Y
	STA	>BG2UNT+20H,X
	LDA	KPBD07+7,Y
	STA	>BG2UNT+21H,X
;
	LDA	#30H
	STA	<YWORK
	STZ	<YWORK1
KPLB10	EQU	$
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	<YWORK
	TAX
	MEM8
	SEP	#20H
	CMP	#0D0H
	BCS	KPLBFN
;
	LDA	KPBD07+4,Y
	STA	>BG2UNT,X
	LDA	KPBD07+5,Y
	STA	>BG2UNT+1,X
	LDA	KPBD07+6,Y
	STA	>BG2UNT+10H,X
	LDA	KPBD07+7,Y
	STA	>BG2UNT+11H,X
	LDA	#20H
	STA	<YWORK
	STZ	<YWORK1
	BRA	KPLB10
;
KPLBFN	EQU	$
	LDA	KPBD07+8,Y
	STA	>BG2UNT,X
	LDA	KPBD07+9,Y
	STA	>BG2UNT+1,X
	LDA	KPBD07+10,Y
	STA	>BG2UNT+10H,X
	LDA	KPBD07+11,Y
	STA	>BG2UNT+11H,X
	LDA	KPBD07+12,Y
	STA	>BG2UNT+20H,X
	LDA	KPBD07+13,Y
	STA	>BG2UNT+21H,X
;
	MEM16
	REP	#20H
	JMP	SHIRO
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SHDTSP	EQU	$
	WORD	SHWDT0-SHWDAT
	WORD	SHWDT1-SHWDAT
	WORD	SHWDT2-SHWDAT
;
SHWPT0	EQU	$
	LDA	<WORKE
	ASL	A
	TAY
	LDA	SHDTSP,Y
	TAY
;
	LDA	<WORK8
	CLC
	ADC	#10H
	TAX
	MEM8
	SEP	#20H
SHW010	EQU	$
	LDA	SHWDAT,Y
	CMP	#0FFH
	BEQ	SHW020
	STA	>BG2UNT,X
	INY
	INX
	BRA	SHW010
SHW020	EQU	$
	MEM16
	REP	#20H
	JMP	SHIRO
;
TAKIPT	EQU	$
	LDX	<WORK8
;;;	STX	<YWORK0
	LDA	<WORKE
	STA	<YWORK2
	MEM8
	SEP	#20H
	STZ	<YWORK4
TAKILP	EQU	$
	LDA	#09H
	STA	>BG2UNT,X
	LDA	#0EH
	STA	>BG2UNT+10H,X
	STA	>BG2UNT+30H,X
	STA	>BG2UNT+50H,X
	LDA	#12H
	STA	>BG2UNT+20H,X
	STA	>BG2UNT+40H,X
	INX
;
	MEM16
	REP	#20H
	TXA
	AND	#0FH
	BNE	TSK010
	TXA
	CLC
	ADC	#0F0H
	TAX
	INC	<YWORK4
TSK010	EQU	$
	MEM8
	SEP	#20H
;
	DEC	<YWORK2
	LDA	<YWORK2
	BMI	TAKIEN
;
	LDA	#09H
	STA	>BG2UNT,X
	LDA	#0FH
	STA	>BG2UNT+10H,X
	STA	>BG2UNT+30H,X
	STA	>BG2UNT+50H,X
	LDA	#13H
	STA	>BG2UNT+20H,X
	STA	>BG2UNT+40H,X
	INX
;
	MEM16
	REP	#20H
	TXA
	AND	#0FH
	BNE	TSK020
	TXA
	CLC
	ADC	#0F0H
	TAX
	INC	<YWORK4
TSK020	EQU	$
	MEM8
	SEP	#20H
;
	DEC	<YWORK2
	LDA	<YWORK2
	BPL	TAKILP
TAKIEN	EQU	$
	LDX	<WORK8
	LDA	<WORKE
	CMP	#4
	BCC	TSK030
	LDA	#04
TSK030	EQU	$
	TAY
	LDA	TADT01,Y
	STA	>BG2UNT-1,X
	MEM16
	REP	#20H
	LDA	<YWORK4
	BEQ	TSK040
	TXA
	CLC
	ADC	#0F0H
	TAX
TSK040	EQU	$
	TXA
	CLC
	ADC	<WORKE
	TAX
	MEM8
	SEP	#20H
	LDA	TADT02,Y
	STA	>BG2UNT+1,X
;
	MEM16
	REP	#20H
	JMP	SHIRO
;
TADT01	EQU	$
	HEX	08,08,04,04,08
TADT02	EQU	$
	HEX	0A,06,0A,06,0A
;
;;;
MSYKD1	EQU	$
	HEX	01,02,03,02,04
	HEX	01,02,02,03,02,02,04
	HEX	07,08,09
	HEX	07,0E,08,0E,09
	HEX	01,03,04
MSYKKZ	EQU	$
	HEX	04,06,02,04,02
MSYKNO	EQU	$
	HEX	00,05,0C,0F,14
;
MSYK04	EQU	$
	INC	<WORK8
MSYK03	EQU	$
	LDA	<WORK8
	CLC
	ADC	#10H
	STA	<WORK8
	BRA	MSYK01
MSYK02	EQU	$
	INC	<WORK8
MSYK01	EQU	$
	LDX	<WORK8
	LDA	<WORKE
	TAY
	LDA	MSYKKZ,Y
	AND	#00FFH
	STA	<WORKE
	LDA	MSYKNO,Y
	AND	#00FFH
	TAY
	MEM8
	SEP	#20H
MSYK10	EQU	$
	LDA	MSYKD1,Y
	STA	>BG2UNT,X
	INX
	INY
	TXA
	AND	#0FH
	BNE	MSYK20
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#0F0H
	TAX
	MEM8
	SEP	#20H
MSYK20	EQU	$
	DEC	<WORKE
	BPL	MSYK10
	MEM16
	REP	#20H
	JMP	SHIRO
;
MSPLD1	EQU	$
	HEX	05,0A
MSPLD2	EQU	$
	HEX	06,0C
;
MSPL14	EQU	$
	INC	<WORK8
MSPL13	EQU	$
	LDA	<WORK8
	CLC
	ADC	#10H
	STA	<WORK8
	BRA	MSPL11
MSPL12	EQU	$
	INC	<WORK8
MSPL11	EQU	$
	LDY	#1
	BRA	MSPOLE
;
MSPL04	EQU	$
	INC	<WORK8
MSPL03	EQU	$
	LDA	<WORK8
	CLC
	ADC	#10H
	STA	<WORK8
	BRA	MSPL01
MSPL02	EQU	$
	INC	<WORK8
MSPL01	EQU	$
	LDY	#0
MSPOLE	EQU	$
	LDX	<WORK8
	MEM8
	SEP	#20H
	LDA	MSPLD1,Y
	STA	>BG2UNT,X
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#10H
	TAX
	MEM8
	SEP	#20H
	DEC	<WORKE
;
MSPLL1	EQU	$
	LDA	>BG2UNT,X
	CMP	#0EH
	BNE	MSP010
	LDA	#0DH
	BRA	MSP020
MSP010	EQU	$
	CMP	#02H
	BNE	MSP015
	LDA	#0BH
	BRA	MSP020
MSP015	EQU	$
	LDA	MSPLD2,Y
MSP020	EQU	$
	STA	>BG2UNT,X
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#10H
	TAX
	MEM8
	SEP	#20H
	DEC	<WORKE
	BPL	MSPLL1
	MEM16
	REP	#20H
	JMP	SHIRO
;
MORIWT	EQU	$
	LDA	<WORK8
	CLC
	ADC	#10H
	TAX
	MEM8
	SEP	#20H
	LDA	#4EH
	STA	>BG2UNT+30H,X
	LDA	>BG2UNT,X
	BEQ	MRUN99
	LDA	#038H	;
	BRA	MREN99
MRUN99	EQU	$
	LDA	#034H	;
MREN99	EQU	$
	STA	>BG2UNT,X
	LDA	>BG2UNT+10H,X
	BEQ	MRUNDB
	CMP	#12H	;
	BEQ	MRUNDB
	LDA	#044H	;
	BRA	MRUNE1
MRUNDB	EQU	$
	LDA	#040H	;
MRUNE1	EQU	$
	STA	>BG2UNT+10H,X
;
	LDA	>BG2UNT+20H,X
	BEQ	MOR100
	CMP	#12H
	BEQ	MOR100
	LDA	#4DH
	BRA	MOR150
MOR100	EQU	$
	LDA	#4CH
MOR150	EQU	$
	STA	>BG2UNT+20H,X
;
	INX
	LDA	>BG2UNT,X
	BEQ	MRUN96
	CMP	#12H	;
	BEQ	MRUN96
	CMP	#18H	;
	BEQ	MRUN9E
	CMP	#07H	;
	BEQ	MRUN9E
	CMP	#17H
	BEQ	MRUN3D
	LDA	#039H	;
	BRA	MREN96
MRUN3D	EQU	$
	LDA	#03DH	;
	BRA	MREN96
MRUN9E	EQU	$
	LDA	#036H	;
	BRA	MREN96
MRUN96	EQU	$
	LDA	#035H
MREN96	EQU	$
	STA	>BG2UNT,X
	LDA	#041H	;
	STA	>BG2UNT+10H,X
	LDA	#048H	;
	STA	>BG2UNT+20H,X
	LDA	#04EH	;
	STA	>BG2UNT+30H,X
	INX
;
MORIL1	EQU	$
	DEC	<WORKE
	LDA	<WORKE
	BNE	MOR000
	JMP	MRIFIN
MOR000	EQU	$
;
	LDA	>BG2UNT,X
	BNE	MRUNA3
	LDA	#036H	;
	STA	>BG2UNT,X
	LDA	#035H	;
	STA	>BG2UNT+1,X
	LDA	#042H	;
	STA	>BG2UNT+10H,X
	LDA	#041H	;
	STA	>BG2UNT+11H,X
	BRA	MRENA3
MRUNA3	EQU	$
	CMP	#18H
	BEQ	MRUN18
	LDA	#03AH	;
	STA	>BG2UNT,X
	LDA	#039H	;
	STA	>BG2UNT+1,X
	LDA	#042H	;
	STA	>BG2UNT+10H,X
	LDA	#041H	;
	STA	>BG2UNT+11H,X
	BRA	MRENA3
MRUN18	EQU	$
	LDA	#036H	;
	STA	>BG2UNT,X
	LDA	#035H	;
	STA	>BG2UNT+1,X
	LDA	#042H	;
	STA	>BG2UNT+10H,X
	LDA	#041H	;
	STA	>BG2UNT+11H,X
MRENA3	EQU	$
	LDA	#047H	;
	STA	>BG2UNT+20H,X
	LDA	#048H	;
	STA	>BG2UNT+21H,X
	LDA	#04EH	;
	STA	>BG2UNT+30H,X
	STA	>BG2UNT+31H,X
;
	INX
	INX
	TXA
	AND	#0FH
	BNE	MORIL1
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#0F0H
	TAX
	MEM8
	SEP	#20H
	JMP	MORIL1
;
MRIFIN	EQU	$
	LDA	#042H
	STA	>BG2UNT+10H,X
	LDA	#047H
	STA	>BG2UNT+20H,X
	LDA	#04EH
	STA	>BG2UNT+30H,X
	STA	>BG2UNT+31H,X
;
	LDA	>BG2UNT,X
	BNE	MRUN9A
	LDA	#036H
	STA	>BG2UNT,X
	LDA	#037H
	STA	>BG2UNT+1,X
	LDA	#043H
	STA	>BG2UNT+11H,X
	LDA	#049H
	STA	>BG2UNT+21H,X
	BRA	MRIRET
MRUN9A	EQU	$
	LDA	#03AH
	STA	>BG2UNT,X
	LDA	#03BH
	STA	>BG2UNT+1,X
	LDA	#045H
	STA	>BG2UNT+11H,X
	LDA	#04AH
	STA	>BG2UNT+21H,X
;;
MRIRET	EQU	$	
	MEM16
	REP	#20H
	JMP	SHIRO	
;
UNPTBB	EQU	$
	INC	<WORK8
UNPTAA	EQU	$
	LDX	<WORK8
	STX	<TWORK6
	LDA	<WORKC
	ASL	A
	TAY
;;				;;MROBIG
	LDA	S2DUNT,Y
	TAY
	MEM8
	SEP	#20H
S2LOOP	EQU	$
	LDA	SH2DAT,Y
	BEQ	S2W030
	CMP	#0FFH
	BEQ	S2WFIN
	CMP	#0FEH
	BEQ	S2WKAI
;
	LDA	SH2DAT,Y
	STA	>BG2UNT,X
S2W030	EQU	$
	INY
	INX
	MEM16
	REP	#20H
	TXA
	AND	#0FH
	BNE	S2W040
	TXA
	CLC
	ADC	#0F0H
	TAX
S2W040	EQU	$
	MEM8
	SEP	#20H
	BRA	S2LOOP
;
S2WKAI	EQU	$
	MEM16
	REP	#20H
	LDA	<TWORK6
	CLC
	ADC	#10H
	STA	<TWORK6
	TAX
	MEM8
	SEP	#20H
	INY
	BRA	S2LOOP
S2WFIN	EQU	$
	MEM16
	REP	#20H
	JMP	SHIRO
;
UN83DD	EQU	$
	LDA	<WORK8
	CLC
	ADC	#10H
	TAX
	INX
	BRA	UN8300
UN83CC	EQU	$
	LDA	<WORK8
	CLC
	ADC	#10H
	TAX
	BRA	UN8300
UN83BB	EQU	$
	INC	<WORK8
UN83AA	EQU	$
	LDX	<WORK8
UN8300	EQU	$
	STX	<TWORK6
	LDA	<WORKC
	ASL	A
	TAY
	LDA	S8DUNT,Y
	TAY
	MEM8
	SEP	#20H
S8LOOP	EQU	$
	LDA	S83DAT,Y
	BEQ	S8W030
	CMP	#0FFH
	BEQ	S8WFIN
	CMP	#0FEH
	BEQ	S8WKAI
;
	LDA	S83DAT,Y
	STA	>BG2UNT,X
S8W030	EQU	$
	INY
	INX
	MEM16
	REP	#20H
	TXA
	AND	#0FH
	BNE	S8W040
	TXA
	CLC
	ADC	#0F0H
	TAX
S8W040	EQU	$
	MEM8
	SEP	#20H
	BRA	S8LOOP
;
S8WKAI	EQU	$
	MEM16
	REP	#20H
	LDA	<TWORK6
	CLC
	ADC	#10H
	STA	<TWORK6
	TAX
	MEM8
	SEP	#20H
	INY
	BRA	S8LOOP
S8WFIN	EQU	$
	MEM16
	REP	#20H
	JMP	SHIRO
;
TYAMA1	EQU	$
	LDX	<WORK8
	STX	<TWORK6
	LDA	<WORKC
	ASL	A
	TAY
;
	LDA	GRDUN2,Y
	TAY
	MEM8
	SEP	#20H
TYLOOP	EQU	$
	LDA	GRNDDT,Y
	BEQ	TYW030
	CMP	#0FFH
	BEQ	TYWFIN
	CMP	#0FEH
	BEQ	TYWKAI
	STA	>BG2UNT,X
TYW030	EQU	$
	INY
	INX
	MEM16
	REP	#20H
	TXA
	AND	#0FH
	BNE	TYW040
	TXA
	CLC
	ADC	#0F0H
	TAX
TYW040	EQU	$
	MEM8
	SEP	#20H
	BRA	TYLOOP
;
TYWKAI	EQU	$
	MEM16
	REP	#20H
	LDA	<TWORK6
	CLC
	ADC	#10H
	STA	<TWORK6
	TAX
	AND	#00F0H
	CMP	#0F0H
	BEQ	TYWFIN
	MEM8
	SEP	#20H
	INY
	BRA	TYLOOP
TYWFIN	EQU	$
	MEM16
	REP	#20H
	JMP	SHIRO
;
STARST	EQU	$
	DEC	<WORKC
	LDA	<WORKC
	AND	#00000011B
	ASL	A
	ASL	A
	ASL	A
	ASL	A
	ORA	<WORKE
	ASL	A
	ASL	A
	TAY
	LDX	<WORK8
	MEM8
	SEP	#20H
	LDA	STARDT,Y
	STA	>BG2UNT,X
	LDA	STARDT+1,Y
	STA	>BG2UNT+01H,X
	LDA	STARDT+2,Y
	STA	>BG2UNT+10H,X
	LDA	STARDT+3,Y
	STA	>BG2UNT+11H,X
	MEM16
	REP	#20H
	JMP	SHIRO
;
KBDT01	EQU	$
	HEX	04,05,0B,0C,0B,0C
KOBU01	EQU	$
	INC	<WORK8
KOBU11	EQU	$
	LDA	<WORK8
	CLC
	ADC	#20H
	TAX
	MEM8
	SEP	#20H
;
	LDA	KBDT01
	STA	>BG2UNT,X
	LDA	KBDT01+1
	STA	>BG2UNT+1,X
	LDA	KBDT01+2
	STA	>BG2UNT+10H,X
	LDA	KBDT01+3
	STA	>BG2UNT+11H,X
	LDA	KBDT01+4
	STA	>BG2UNT+20H,X
	LDA	KBDT01+5
	STA	>BG2UNT+21H,X
;
	MEM16
	REP	#20H
	JMP	SHIRO	
;
KOBU02	EQU	$
	INC	<WORK8
KOBU12	EQU	$
	LDA	<WORK8
	CLC
	ADC	#20H
	TAX
	MEM8
	SEP	#20H
;
	LDA	KBDT01
	STA	>BG2UNT+10H,X
	LDA	KBDT01+1
	STA	>BG2UNT+11H,X
	LDA	KBDT01+2
	STA	>BG2UNT+20H,X
	LDA	KBDT01+3
	STA	>BG2UNT+21H,X
;
	MEM16
	REP	#20H
	JMP	SHIRO	
;
S2DUNT	EQU	$
	WORD	S2UNT0-SH2DAT
	WORD	S2UNT0-SH2DAT
	WORD	S2UNT2-SH2DAT
	WORD	S2UNT2-SH2DAT
	WORD	S2UNT4-SH2DAT
	WORD	S2UNT4-SH2DAT
	WORD	S2UNT6-SH2DAT
	WORD	S2UNT6-SH2DAT
	WORD	S2UNT8-SH2DAT
	WORD	S2UNT8-SH2DAT
	WORD	S2UNTA-SH2DAT
	WORD	S2UNT0-SH2DAT
	WORD	S2UNTC-SH2DAT
	WORD	S2UNTC-SH2DAT
	WORD	S2UNT0-SH2DAT
	WORD	S2UNT0-SH2DAT
;
S8DUNT	EQU	$
	WORD	S8UNT0-S83DAT
	WORD	S8UNT0-S83DAT
	WORD	S8UNT0-S83DAT
	WORD	S8UNT0-S83DAT
	WORD	S8UNT0-S83DAT
	WORD	S8UNT5-S83DAT
	WORD	S8UNT6-S83DAT
	WORD	S8UNT7-S83DAT
	WORD	S8UNT8-S83DAT
	WORD	S8UNT9-S83DAT
;
GRDUN2	EQU	$
	WORD	TYMDT1-GRNDDT
	WORD	TYMDT2-GRNDDT
	WORD	TYMDT3-GRNDDT
	WORD	TYMDT4-GRNDDT
	WORD	TYMDT5-GRNDDT
	WORD	TYMDT6-GRNDDT
	WORD	TYMDT7-GRNDDT
	WORD	TYMDT8-GRNDDT
	WORD	TYMDT9-GRNDDT
	WORD	TYMDTA-GRNDDT
	WORD	TYMDTB-GRNDDT
	WORD	TYMDTC-GRNDDT
	WORD	TYMDTD-GRNDDT
	WORD	TYMDTE-GRNDDT
	WORD	TYMDTF-GRNDDT
;
YAMAWD	EQU	$
	WORD	YWDDT1-YAMA
	WORD	YWDDT2-YAMA
	WORD	YWDDT3-YAMA
	WORD	YWDDT4-YAMA
	WORD	YWDDT5-YAMA
	WORD	YWDDT6-YAMA
	WORD	YWDDT7-YAMA
;
YMWD01	EQU	$
	LDY	YAMAWD
	LDA	<WORK8
	TAX
	INX
	INX
	BRA	YMWDWT
;
YMWD02	EQU	$
	LDY	YAMAWD+2
	LDA	<WORK8
	CLC
	ADC	#12H
	TAX
	BRA	YMWDWT
;
YMWD03	EQU	$
	LDY	YAMAWD+4
	LDA	<WORK8
	CLC
	ADC	#01H
	TAX	
	BRA	YMWDWT
;
YMWD04	EQU	$
	LDY	YAMAWD+6
	LDA	<WORK8
	CLC
	ADC	#11H
	TAX
	BRA	YMWDWT
;
YMWD05	EQU	$
	LDY	YAMAWD+8
	LDA	<WORK8
	CLC
	ADC	#20H
	TAX	
	BRA	YMWDWT
;
YMWD06	EQU	$
	LDY	YAMAWD+10
	LDX	<WORK8
	INX
	BRA	YMWDWT
;
YMWD07	EQU	$
	LDY	YAMAWD+12
	LDA	<WORK8
	CLC
	ADC	#12H
	TAX	
	BRA	YMWDWT
;
YAMAW4	EQU	$
	INC	<WORK8
YAMAW3	EQU	$
	LDA	<WORK8
	CLC
	ADC	#10H
	TAX
	BRA	YMSTAT
YAMAW2	EQU	$
	INC	<WORK8
YAMAW1	EQU	$
	LDX	<WORK8
YMSTAT	EQU	$
	LDY	#0
YMWDWT	EQU	$
	STX	<TWORK6
	MEM8
	SEP	#20H
YMALOP	EQU	$
	LDA	YAMA,Y
	CMP	#0FFH
	BEQ	YAMAFN
	CMP	#0FEH
	BEQ	YMKPAG
;
	JSR	YAMAYS
;		
	STA	>BG2UNT,X
	INY
	INX
	MEM16
	REP	#20H
	TXA
	AND	#0FH
	BNE	YMA010
	TXA
	CLC
	ADC	#0F0H
	TAX
YMA010	EQU	$
	MEM8
	SEP	#20H
	BRA	YMALOP
;
	MEM8
	IDX16
YAMAYS	EQU	$
	STA	<YWORK
	CMP	#12H
	BNE	YMS010
	JMP	YMYS23
YMS010	EQU	$
	CMP	#03H
	BNE	YMS020
	JMP	YMYS20
YMS020	EQU	$
	CMP	#04H
	BNE	YMS030
	JMP	YMYS21
YMS030	EQU	$
	CMP	#05H
	BNE	YMS040
	JMP	YMYS22
YMS040	EQU	$
	CMP	#18H
	BNE	YMS050
	JMP	YMYS26
YMS050	EQU	$
	CMP	#07H
	BNE	YMYS60
	JMP	YMYS6C
YMYS60	EQU	$
	RTS
;
YMKPAG	EQU	$
	INY
	MEM16
	REP	#20H
	LDA	<TWORK6
	CLC
	ADC	#10H
	TAX
	AND	#00F0H
	BEQ	YAMAFN
	DEX
	TXA
	AND	#0FH
	CMP	#0FH
	BNE	YMK010
	TXA
	SEC
	SBC	#0F0H
	TAX
YMK010	EQU	$
	STX	<TWORK6
	MEM8
	SEP	#20H
	BRA	YMALOP
;
YAMAFN	EQU	$
	MEM16
	REP	#20H
;
	JMP	SHIRO
;
	MEM8
	IDX16
YMYS23	EQU	$
	LDA	>BG2UNT,X
	BEQ	YMS23Z
	CMP	#18H
	BNE	YMS23A
	LDA	#02H
	BRA	YM23FF
YMS23A	EQU	$
	CMP	#06H
	BNE	YMS23B
	LDA	#11H
	BRA	YM23FF
YMS23B	EQU	$
	CMP	#16H
	BNE	YMS23C
	LDA	#01H
	BRA	YM23FF
YMS23C	EQU	$
	CMP	#05H
	BNE	YMS23D
	LDA	#62H
	BRA	YM23FF
YMS23D	EQU	$
	LDA	#10H
	BRA	YM23FF
YMS23Z	EQU	$
	LDA	<YWORK
YM23FF	EQU	$
	RTS
;
	MEM8
	IDX16
YMYS20	EQU	$
	LDA	>BG2UNT,X
	BEQ	YM20FF
	LDA	#36H
	BRA	YM20EN
YM20FF	EQU	$
	LDA	<YWORK
YM20EN	EQU	$
	RTS
;
	MEM8
	IDX16
YMYS21	EQU	$
	LDA	>BG2UNT,X
	BEQ	YM21FF
	CMP	#12H
	BNE	YMS21A
	LDA	#14H
	BRA	YM21EN
YMS21A	EQU	$
	LDA	#37H
	BRA	YM21EN
YM21FF	EQU	$
	LDA	<YWORK
YM21EN	EQU	$
	RTS
;
	MEM8
	IDX16
YMYS22	EQU	$
	LDA	>BG2UNT,X
	BEQ	YM22FF
	CMP	#13H
	BNE	YMS22A
	LDA	#15H
	BRA	YM22EN
YMS22A	EQU	$
	LDA	#38H
	BRA	YM22EN
YM22FF	EQU	$
	LDA	<YWORK
YM22EN	EQU	$
	RTS
;
	MEM8
	IDX16
YMYS26	EQU	$
	LDA	>BG2UNT,X
	BEQ	YM26FF
	CMP	#16H
	BNE	YMS26A
	LDA	#1EH
	BRA	YM26EN
YMS26A	EQU	$
	CMP	#13H
	BNE	YMS26B
	LDA	#1EH
	BRA	YM26EN
YMS26B	EQU	$
	LDA	#1DH
	BRA	YM26EN
YM26FF	EQU	$
	LDA	<YWORK
YM26EN	EQU	$
	RTS
;
	MEM8
	IDX16
YMYS6C	EQU	$
	LDA	>BG2UNT,X
	BEQ	YMS6CZ
	CMP	#16H
	BNE	YMS6CA
	LDA	#0EH
	BRA	YM6CFF
YMS6CA	EQU	$
	CMP	#04H
	BNE	YMS6CB
	LDA	#70H
	BRA	YM6CFF
YMS6CB	EQU	$
	CMP	#0BH
	BNE	YMS6CC
	LDA	#90H
	BRA	YM6CFF
YMS6CC	EQU	$
	LDA	#49H
	BRA	YM6CFF
YMS6CZ	EQU	$
	LDA	<YWORK
YM6CFF	EQU	$
	RTS
;
MRODAT	EQU	$
	HEX	00,00,90,91,92,93
	HEX	00,00,94,95,96,97
	HEX	00,00,98,99,9A,9B
	HEX	00,9C,9D,9E,9F,A0
	HEX	00,A1,A2,A3,A4,A5
	HEX	00,A6,A7,A8,A9,AA
;
MROBIG	EQU	$
	MEM8
	SEP	#20H
	LDX	<WORK8
	LDY	#0
MRO010	EQU	$
	LDA	MRODAT,Y
	STA	>BG2UNT+20H,X
	LDA	MRODAT+1,Y
	STA	>BG2UNT+21H,X
	LDA	MRODAT+2,Y
	STA	>BG2UNT+22H,X
	LDA	MRODAT+3,Y
	STA	>BG2UNT+23H,X
	LDA	MRODAT+4,Y
	STA	>BG2UNT+24H,X
	LDA	MRODAT+5,Y
	STA	>BG2UNT+25H,X
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#10H
	TAX
	MEM8
	SEP	#20H
	INY
	INY
	INY
	INY
	INY
	INY
	CPY	#24H
	BNE	MRO010
	MEM16
	REP	#20H
	JMP	SHIRO
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	CHIKA KABE SET SUBROUTINE
BOYOKO	EQU	$
	LDX	<WORK8
	MEM8
	SEP	#20H
BOY010	EQU	$
	LDA	#09H
	STA	>BG2UNT+20H,X
	LDA	#0BH
	STA	>BG2UNT+21H,X
	INX
	INX
	DEC	<WORKE
	LDA	<WORKE
	BPL	BOY010
	MEM16
	REP	#20H
	JMP	SHIRO
;
BOTAT1	EQU	$
	LDX	<WORK8
	MEM8
	SEP	#20H
BOT010	EQU	$
	LDA	>BG2UNT+20H,X
	CMP	#09H
	BNE	BOT020
	LDA	#0AH
	BRA	BOT030
BOT020	EQU	$
	LDA	#04H
BOT030	EQU	$
	STA	>BG2UNT+20H,X
	LDA	#01H
	STA	>BG2UNT+30H,X
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#20H
	TAX
	MEM8
	SEP	#20H
	DEC	<WORKE
	LDA	<WORKE
	BPL	BOT010
	MEM16
	REP	#20H
	JMP	SHIRO
;
BOTAT2	EQU	$
	LDX	<WORK8
	MEM8
	SEP	#20H
BOT110	EQU	$
	LDA	>BG2UNT+21H,X
	CMP	#0BH
	BNE	BOT120
	LDA	#0AH
	BRA	BOT130
BOT120	EQU	$
	LDA	#04H
BOT130	EQU	$
	STA	>BG2UNT+21H,X
	LDA	#01H
	STA	>BG2UNT+31H,X
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#20H
	TAX
	MEM8
	SEP	#20H
	DEC	<WORKE
	LDA	<WORKE
	BPL	BOT110
	MEM16
	REP	#20H
	JMP	SHIRO
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	POLE SET SUBROUTINE
;
PLDT05	EQU	$
	HEX	7A,7B,61,62,8C,8D,90,91,92
POLE05	EQU	$
	LDX	<WORK8
	LDA	#6
	STA	<WORKE
	MEM8
	SEP	#20H
	LDA	PLDT05
	STA	>BG2UNT+20H,X
	LDA	PLDT05+1
	STA	>BG2UNT+21H,X
;
PL0510	EQU	$
	LDA	PLDT05+2
	STA	>BG2UNT+30H,X
	LDA	PLDT05+3
	STA	>BG2UNT+31H,X
;
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#10H
	TAX
	MEM8
	SEP	#20H
	DEC	<WORKE
	LDA	<WORKE
	BNE	PL0510
	LDA	PLDT05+4
	STA	>BG2UNT+30H,X
	LDA	PLDT05+5
	STA	>BG2UNT+31H,X
	LDA	PLDT05+6
	STA	>BG2UNT+40H,X
	LDA	PLDT05+7
	STA	>BG2UNT+41H,X
	LDA	PLDT05+8
	STA	>BG2UNT+42H,X
;
	MEM16
	REP	#20H
	JMP	SHIRO
;
MADODT	EQU	$
	HEX	70,71,72,73
	HEX	74,75,76,77
	HEX	78,79,7A,7B
	HEX	00,7C,7D,00
;
MADO01	EQU	$
	LDX	<WORK8
	INX
	MEM8
	SEP	#20H
	STZ	<YWORK1
	LDY	#0
MAD010	EQU	$
	LDA	MADODT,Y
	STA	>BG2UNT,X
	LDA	MADODT+1,Y
	STA	>BG2UNT+1,X
	LDA	MADODT+2,Y
	STA	>BG2UNT+2,X
	LDA	MADODT+3,Y
	STA	>BG2UNT+3,X
;
	INY
	INY
	INY
	INY
	INX
	INX
	INX
	INX
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#0CH
	TAX
	MEM8
	SEP	#20H
	INC	<YWORK1
	LDA	<YWORK1
	CMP	#4
	BNE	MAD010
	MEM16
	REP	#20H
	JMP	SHIRO
;
DORDAT	EQU	$
	HEX	2F,30,31,32,35,36,3A,3B
SHDOOR	EQU	$
	MEM8
	SEP	#20H
	LDY	#0
	LDX	<WORK8
SHD010	EQU	$
	LDA	DORDAT,Y
	STA	>BG2UNT+20H,X
	LDA	DORDAT+1,Y
	STA	>BG2UNT+21H,X
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#10H
	TAX
	MEM8
	SEP	#20H
	INY
	INY
	CPY	#8
	BNE	SHD010
	MEM16
	REP	#20H
        JMP     SHIRO
;
POL210	EQU	$
	HEX	01,1F
POL211	EQU	$
	HEX	02,20
;
POLE01	EQU	$
	MEM8
	SEP	#20H
;
	LDX	<WORK8
	LDY	<WORKC
PL1L10	EQU	$
	LDA	POL210,Y
	STA	>BG2UNT+20H,X
	LDA	POL211,Y
	STA	>BG2UNT+21H,X
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#10H
	TAX
	MEM8
	SEP	#20H
	DEC	<WORKE
	LDA	<WORKE
	BPL	PL1L10
;
	MEM16
	REP	#20H
	JMP	SHIRO
;
POL220	EQU	$
	HEX	08,09,05,06,07,05
POL221	EQU	$
	HEX	03,04,05
POL222	EQU	$
	HEX	0F,10,11,16,17,12,1D,09,1E,06,07,05
;
POLE02	EQU	$
	MEM8
	SEP	#20H
;
	LDX	<WORK8
PL2L10	EQU	$
	TXA
	AND	#0F0H
	BEQ	PL2L20
;
	LDA	>BG2UNT+20H,X
	CMP	#0CH
	BEQ	PL2L40
	LDA	POL220
	STA	>BG2UNT+20H,X
	LDA	POL220+1
	STA	>BG2UNT+21H,X
	LDA	POL220+2
	STA	>BG2UNT+22H,X
	BRA	PL2L30
PL2L20	EQU	$
	LDA	POL221
	STA	>BG2UNT+20H,X
	LDA	POL221+1
	STA	>BG2UNT+21H,X
	LDA	POL221+2
	STA	>BG2UNT+22H,X
PL2L30	EQU	$
	LDA	POL220+3
	STA	>BG2UNT+30H,X
	LDA	POL220+4
	STA	>BG2UNT+31H,X
	LDA	POL220+5
	STA	>BG2UNT+32H,X
	BRA	PL2L50
PL2L40	EQU	$

	LDA	POL222
	STA	>BG2UNT+20H,X
	LDA	POL222+1
	STA	>BG2UNT+21H,X
	LDA	POL222+2
	STA	>BG2UNT+22H,X
	LDA	POL222+3
	STA	>BG2UNT+30H,X
	LDA	POL222+4
	STA	>BG2UNT+31H,X
	LDA	POL222+5
	STA	>BG2UNT+32H,X
	LDA	POL222+6
	STA	>BG2UNT+40H,X
	LDA	POL222+7
	STA	>BG2UNT+41H,X
	LDA	POL222+8
	STA	>BG2UNT+42H,X
	LDA	POL222+9
	STA	>BG2UNT+50H,X
	LDA	POL222+10
	STA	>BG2UNT+51H,X
	LDA	POL222+11
	STA	>BG2UNT+52H,X
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#20H
	TAX
	MEM8
	SEP	#20H
	DEC	<WORKE
PL2L50	EQU	$
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#20H
	TAX
	MEM8
	SEP	#20H
	DEC	<WORKE
	LDA	<WORKE
	BMI	PL2L60
	JMP	PL2L10
PL2L60	EQU	$
;
	MEM16
	REP	#20H
	JMP	SHIRO
;
POL120	EQU	$
	HEX	0C,18,19
POL121	EQU	$
	HEX	0A,0B,0D,0E,13,14,1A,1B
POLE03	EQU	$
	MEM8
	SEP	#20H
;
	LDX	<WORK8
PL3L10	EQU	$
	LDA	>BG2UNT+20H,X
	CMP	#1FH
	BNE	PL3L20
;
	LDA	POL121
	STA	>BG2UNT+10H,X
	LDA	POL121+1
	STA	>BG2UNT+11H,X
	LDA	POL121+2
	STA	>BG2UNT+20H,X
	LDA	POL121+3
	STA	>BG2UNT+21H,X
	LDA	POL121+4
	STA	>BG2UNT+30H,X
	LDA	POL121+5
	STA	>BG2UNT+31H,X
	LDA	POL121+6
	STA	>BG2UNT+40H,X
	LDA	POL121+7
	STA	>BG2UNT+41H,X
	INX
	DEC	<WORKE
	BRA	PL3L30	
PL3L20	EQU	$
	LDA	POL120
	STA	>BG2UNT+20H,X
	LDA	POL120+1
	STA	>BG2UNT+30H,X
	LDA	POL120+2
	STA	>BG2UNT+40H,X
PL3L30	EQU	$
	INX
	DEC	<WORKE
	LDA	<WORKE
	BPL	PL3L10
;
	MEM16
	REP	#20H
	JMP	SHIRO
;
PLLCRS	EQU	$
	HEX	33,34,0D,37,13,3C,1A,1B
PLRCRS	EQU	$
	HEX	33,34,38,39,3D,3E,40,1B
;
POLE04	EQU	$
	LDX	<WORK8
	MEM8
	SEP	#20H
	LDA	>BG2UNT+20H,X
	CMP	#0CH
	BEQ	LFTCRS
;
	LDA	PLRCRS
	STA	>BG2UNT+10H,X
	LDA	PLRCRS+1
	STA	>BG2UNT+11H,X
	LDA	PLRCRS+2
	STA	>BG2UNT+20H,X
	LDA	PLRCRS+3
	STA	>BG2UNT+21H,X
	LDA	PLRCRS+4
	STA	>BG2UNT+30H,X
	LDA	PLRCRS+5
	STA	>BG2UNT+31H,X
	LDA	PLRCRS+6
	STA	>BG2UNT+40H,X
	LDA	PLRCRS+7
	STA	>BG2UNT+41H,X
	BRA	PL4010
LFTCRS	EQU	$
	LDA	PLLCRS
	STA	>BG2UNT+10H,X
	LDA	PLLCRS+1
	STA	>BG2UNT+11H,X
	LDA	PLLCRS+2
	STA	>BG2UNT+20H,X
	LDA	PLLCRS+3
	STA	>BG2UNT+21H,X
	LDA	PLLCRS+4
	STA	>BG2UNT+30H,X
	LDA	PLLCRS+5
	STA	>BG2UNT+31H,X
	LDA	PLLCRS+6
	STA	>BG2UNT+40H,X
	LDA	PLLCRS+7
	STA	>BG2UNT+41H,X
PL4010	EQU	$
	MEM16
	REP	#20H
	DEC	<WORKE
	DEC	<WORKE
	DEC	<WORKE
	LDA	<WORK8
	CLC
	ADC	#30H
	STA	<WORK8
	LDA	#1
	STA	<WORKC
;
	JMP	POLE01
;
KPPKDT	EQU	$
	HEX	41,42,43,44
	HEX	45,46,47,48
	HEX	49,4A,4B,4C
	HEX	4D,4E,4F,50
	HEX	51,52,53,54
KPPAPK	EQU	$
	MEM8
	SEP	#20H
	LDX	<WORK8
	LDY	#0
KPP010	EQU	$
	LDA	KPPKDT,Y
	STA	>BG2UNT+20H,X
	LDA	KPPKDT+1,Y
	STA	>BG2UNT+21H,X
	LDA	KPPKDT+2,Y
	STA	>BG2UNT+22H,X
	LDA	KPPKDT+3,Y
	STA	>BG2UNT+23H,X
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#10H
	TAX
	MEM8
	SEP	#20H
	INY
	INY
	INY
	INY
	CPY	#14H
	BNE	KPP010
	MEM16
	REP	#20H
	JMP	SHIRO
;
PLTU01	EQU	$
	LDX	<WORK8
	LDA	#1B1AH
	STA	>BG2UNT,X
	JMP	SHIRO
;
SHKZ02	EQU	$
	INC	<WORK8
SHKZ01	EQU	$
	LDA	<WORK8
	CLC
	ADC	#10H
	TAX
	MEM8
	SEP	#20H
	LDA	#67H
	STA	>BG2UNT,X
	LDA	#69H
	STA	>BG2UNT+1,X
	LDA	#68H
	STA	>BG2UNT+10H,X
	LDA	#6AH
	STA	>BG2UNT+11H,X
	MEM16
	REP	#20H
	JMP	SHIRO
;
UNDT22	EQU	$
	WORD	WATR22
	WORD	GRND22
	WORD	CHID22
	WORD	SHIR22
;
WATR22	EQU	$
	HEX	08,09,0D,0E
	HEX	08,23,0D,25
	HEX	24,23,26,25
	HEX	24,09,26,0E
	HEX	00,08,00,0D
	HEX	23,24,25,26
	HEX	0F,10,32,33
	HEX	11,12,32,33
	HEX	13,00,3C,3B
	HEX	30,31,32,33
	HEX	30,10,32,33
	HEX	00,36,38,37
	HEX	0F,31,32,33
	HEX	35,10,39,33
	HEX	0F,10,32,33
	HEX	35,12,32,33
	HEX	23,24,25,26
	HEX	11,12,32,33
;
GRND22	EQU	$
	HEX	21,22,25,26
	HEX	23,24,27,28
	HEX	00,00,26,00
;
CHID22	EQU	$
	HEX	06,05,07,02
	HEX	0E,05,11,12
	HEX	0E,05,07,08
	HEX	06,05,07,08
	HEX	03,05,0C,0D	;LUMP
	HEX	0F,10,1D,02
	HEX	03,05,1D,15	;GURD
	HEX	03,18,1B,1B
	HEX	03,05,16,15
	HEX	19,18,1B,1B
	HEX	03,05,16,17
	HEX	19,1A,1B,1B
;
SHIR22	EQU	$
;
UNPT22	EQU	$	
	LDA	<ENVRFG
	AND	#00FFH
	ASL	A
	TAX
	LDA	#500H
	STA	<DATAWK+1
	LDA	UNDT22,X
	STA	<DATAWK
;
	LDA	<ENVRFG
	AND	#00FFH
	CMP	#02
	BCS	UNSP10
	LDA	<WORK8
	CLC
	ADC	#10H
	TAX
	BRA	UN22LP
UNSP10	EQU	$
	LDX	<WORK8
UN22LP	EQU	$
	LDA	<WORKC
	SEC
	SBC	#10H
	ASL	A
	ASL	A
	TAY
;
	MEM8
	SEP	#20H
	LDA	[DATAWK],Y
	STA	>BG2UNT+20H,X
	INY
	LDA	[DATAWK],Y
	STA	>BG2UNT+21H,X
	INY
	LDA	[DATAWK],Y
	STA	>BG2UNT+30H,X
	INY
	LDA	[DATAWK],Y
	STA	>BG2UNT+31H,X
	MEM16
	REP	#20H
	INX
	INX
	DEC	<WORKE
	LDA	<WORKE
	BPL	UN22LP

	RTS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
UNSTSB	EQU	$
	STA	>BG2UNT,X
	STA	>BG2UNT+0100H,X
	STA	>BG2UNT+0200H,X
	STA	>BG2UNT+0300H,X
	STA	>BG2UNT+0400H,X
	STA	>BG2UNT+0500H,X
	STA	>BG2UNT+0600H,X
	STA	>BG2UNT+0700H,X
	STA	>BG2UNT+0800H,X
	STA	>BG2UNT+0900H,X
	STA	>BG2UNT+0A00H,X
	STA	>BG2UNT+0B00H,X
	STA	>BG2UNT+0C00H,X
	STA	>BG2UNT+0D00H,X
	STA	>BG2UNT+0E00H,X
	RTS
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	OPTION UNIT SUBROUTINE
;
	MEM16
	IDX16
OPTNUT	EQU	$
	LDA	<WORKC
	ASL	A
	TAX
	LDA	OPCMND,X
	STA	<WORK
	JMP	(WORK)
;
OPCMND	EQU	$
	WORD	PAGCNG	;0	;PAGE CHANGE
	WORD	GRADST	;1	;GRADUATION SET (0=HIRU 1=YORU 2=OFF)
	WORD	WATRST	;2	;WATER SET
	WORD	YUKAST	;3	;YUKA SET
	WORD	BGFGST	;4	;BG CHR CHENG NO
	WORD	SCNUKI	;5	;SCORE BUBUN NUKI
	WORD	CHBETA	;6	;CHIKA KABE KIHON BG SET
	WORD	WARSET	;7	;WATAR SCORE BUBUN BETA
	WORD	SHISET	;8	;8-3 SHIRO KABE SET
	WORD	BG3FLG	;9	;BG3 CLOUD ON(1) OFF(0)
	WORD	IWABET	;A	;IWA BETA PUT
	WORD	BGFGS2	;B	;BG CHR CHENG NO+10H
	WORD	SUNABT	;C	;2-3 SUNA BETA
;
SUNADT	EQU	$
	HEX	0C,0D,0E,0F,0C,0D,0E,0F,0C,0D,0E,0F,0C,0D,0E,0F
	HEX	13,14,15,16,13,14,15,16,13,14,15,16,13,14,15,16
	HEX	1A,1A,1A,1A,1A,1A,1A,1A,1A,1A,1A,1A,1A,1A,1A,1A
;
SUNABT	EQU	$
	LDX	#00D0H
	LDY	#0
	MEM8
	SEP	#20H
SNLP10	EQU	$
	LDA	SUNADT,Y
	JSR	UNSTSB
	INX
	INY
	CPY	#30H
	BNE	SNLP10
	MEM16
	REP	#20H
	RTS
;
IWADT1	EQU	$
	HEX	01,02,03,07,01,02,03,07,01,02,03,07,01,02,03,07
;
IWABET	EQU	$
	STZ	<YWORK
IWALP2	EQU	$
	LDA	<YWORK
	AND	#00FFH
	XBA
	CLC
	ADC	#0A0H
	TAX
	LDY	#0
	MEM8
	SEP	#20H
IWALOP	EQU	$
	LDA	IWADT1,Y
	STA	>BG2UNT,X
	TXA
	AND	#1
	BNE	IWAKSU
	LDA	#0CH
	STA	>BG2UNT+10H,X
	STA	>BG2UNT+30H,X
	STA	>BG2UNT+50H,X
	LDA	#10H
	STA	>BG2UNT+20H,X
	STA	>BG2UNT+40H,X
	BRA	IWAGEN
IWAKSU	EQU	$
	LDA	#0DH
	STA	>BG2UNT+10H,X
	STA	>BG2UNT+30H,X
	STA	>BG2UNT+50H,X
	LDA	#11H
	STA	>BG2UNT+20H,X
	STA	>BG2UNT+40H,X
IWAGEN	EQU	$
	INX
	INY
	TYA
	AND	#0FH
	BNE	IWALOP
;
	MEM16
	REP	#20H
	INC	<YWORK
	LDA	<YWORK
	CMP	#06
	BNE	IWALP2
	RTS
;;;

BG3FLG	EQU	$
	MEM8
	SEP	#20H
	LDA	<WORKE
	STA	WDWFLG
	MEM16
	REP	#20H
	RTS
;
;
	MEM16
	IDX16
SHISET	EQU	$
	LDX	#80H
OPSL10	EQU	$
	LDA	#0403H
	STA	>BG2UNT,X
	LDA	#0909H
	STA	>BG2UNT+10H,X
	STA	>BG2UNT+20H,X
	STA	>BG2UNT+30H,X
	STA	>BG2UNT+40H,X
	STA	>BG2UNT+50H,X
	STA	>BG2UNT+60H,X
	INX
	INX
	TXA
	AND	#0FH
	BNE	OPSL10
	TXA
	CLC
	ADC	#0F0H
	TAX
	CPX	#1000H
	BCC	OPSL10
	RTS
;
WARSET	EQU	$
	LDX	#0H
	LDA	#0202H
WTS010	EQU	$
	JSR	UNSTSB
	INX
	INX
	CPX	#20H
	BNE	WTS010
	LDA	#0101H
WTS020	EQU	$
	JSR	UNSTSB
	INX
	INX
	CPX	#30H
	BNE	WTS020
	RTS
;
CHBDAT	EQU	$
	HEX	03,05,1D,02
CHBETA	EQU	$
	LDX	#0H
	MEM8
	SEP	#20H
CHB010	EQU	$
	LDA	CHBDAT
	STA	>BG2UNT,X
	LDA	CHBDAT+1
	STA	>BG2UNT+1,X
	LDA	CHBDAT+2
	STA	>BG2UNT+10H,X
	LDA	CHBDAT+3
	STA	>BG2UNT+11H,X
	INX
	INX
	TXA
	AND	#0FH
	BNE	CHB010
	MEM16
	REP	#20H
	TXA
	CLC
	ADC	#10H
	TAX
	MEM8
	SEP	#20H
	CPX	#0800H
	BNE	CHB010
	MEM16
	REP	#20H
	RTS
;
SCNUKI	EQU	$
	MEM8
	SEP	#20H
	LDA	<ENVRFG
	CMP	#2
	BEQ	SCN020
	LDA	#5FH
	BRA	SCN030
SCN020	EQU	$
	LDA	#00H
SCN030	EQU	$
	LDX	#0
SCN010	EQU	$
	JSR	UNSTSB
	INX
	CPX	#20H
	BNE	SCN010
	MEM16
	REP	#20H
	RTS
;
PAGCNG	EQU	$
	INC	PAGECT
	RTS
;
GRADST	EQU	$
	MEM8
	IDX8
	SEP	#30H
	LDA	<WORKE
	CMP	#2
	BNE	GST010
	LDA	#0FFH
GST010	EQU	$	
        CMP     #01H
        BNE     GST015
        STA     !BBSCHL
GST015  EQU     $
	JSL	>HDMAON
	MEM16
	IDX16
	REP	#30H
	RTS
;
WATRST	EQU	$
	MEM8
	IDX8
	SEP	#30H
	LDA	#2
	JSL	>HDMAON
	MEM16
	IDX16
	REP	#30H
	RTS
;
YKDAT1	EQU	$
;;;		 Y  N  C  8
	HEX	0F,20,1B,37,58,C9
YKDAT2	EQU	$
	HEX	1F,29,1C,38,57,CA
YUKAST	EQU	$
	LDX	#0D0H
	LDY	<WORKE
	LDA	YKDAT1,Y
YKAL10	EQU	$
	JSR	UNSTSB
	INX
	CPX	#0E0H
	BNE	YKAL10
;
	LDA	YKDAT2,Y
YKAL20	EQU	$
	JSR	UNSTSB
	INX
	CPX	#00F0H
	BNE	YKAL20
	LDA	#0050H
	JSR     UNSTSB
	RTS
;
BGFGST	EQU	$
	LDA	<WORKE
	STA	<BGWFLG
	JSL	>MARIOW
	RTS
;
BGFGS2	EQU	$
	LDA	<WORKE
	ORA	#10H
	STA	<BGWFLG
	JSL	>MARIOW
	RTS
;
COSDAT	EQU	$
	WORD	0000H,0000H,0009H,0004H	;0
	WORD	0006H,0001H,0004H,0004H	;4
	WORD	0001H,0008H,000AH,0001H	;8
	WORD	0001H,0001H,0001H,0007H	;C
	WORD	0004H,0004H,0007H,0001H	;10
	WORD	0001H,0001H,0001H,0001H	;14
	WORD	0004H,0002H,0002H,0001H	;18
	WORD	0003H,0003H,0003H,0003H	;1C
	WORD	0003H,0005H
;
;********************************************************
;*	BG2RET		(BG2UNT => BG2DT)		*
;*		DATA BUFF TENKAI			*
;********************************************************
;
BG2RET	EQU	$
	LDA	<BG2COS
	ASL	A
	TAX
	LDA	COSDAT,X
	ASL	A
	TAX
;
	LDA	COSUNT,X
	STA	<WORK		;DATA READ ADDRESS
	LDA	#5
	STA	<WORK2		;DATA READ BANK
;
	LDX	#0
	LDY	#0
;
B2R010	EQU	$
	STX	<YWORK
	TYX
	LDA	>BG2UNT,X
	CMP	#0FFFFH
	BEQ	BG2END
	PHY
	LDX	<YWORK
	AND	#00FFH
	ASL	A
	ASL	A
	ASL	A
	TAY
	LDA	[WORK],Y	;UNIT L_U DATA
	STA	>BG2DT,X
	INY
	INY
	LDA	[WORK],Y	;UNIT R_U DATA
	STA	>BG2DT+2,X
	INY
	INY
	LDA	[WORK],Y	;UNIT L_D DATA
	STA	>BG2DT+40H,X
	INY
	INY
	LDA	[WORK],Y	;UNIT R_D DATA
	STA	>BG2DT+42H,X
;
	PLY
	INY
	TYA
	AND	#000FH		; KAIGYO ? 
	BNE	B2R020		; !NO (B2R020)
	TXA
	CLC
	ADC	#40H		; KAIGYO
	TAX
B2R020	EQU	$
	INX
	INX
	INX
	INX
	CPY	#1000H		; TENKAI END ?
	BNE	B2R010		; !NO (B2R010)
;
BG2END	EQU	$
	MEM8
	IDX8
	SEP	#30H
	PLB
	RTL
;
COSUNT	EQU	$
	WORD	WTRUNT	;00	;WATER BG
	WORD	GRAUNT	;01	;GRAND YAMA
	WORD	CHIUNT	;02	;CHIKA BG
	WORD	SHIUNT	;03	;SHIRO BG
	WORD	NIGUNT	;04	;NIGHT BG
	WORD	SH2UNT	;05	;8-4 SHIRO
	WORD	S83UNT	;06	;8-3 SHIRO
	WORD	MSAUNT	;07	;Kinoko asletick
	WORD	TAKUNT	;08	;Taki bg
	WORD	SHWUNT	;09	;8-4 Water
	WORD	HSIUNT	;0A 	;2-3 SAND
;
STARDT	EQU	$
	HEX	00,00,00,11	;10
	HEX	00,00,00,1F	;10
	HEX	00,00,00,0C	;10
	HEX	00,12,00,00	;10
	HEX	08,00,00,00	;10
	HEX	00,00,04,00	;10
	HEX	10,00,00,00	;10
	HEX	0D,00,00,00	;10
	HEX	00,00,0A,00	;10
	HEX	1E,00,00,00	;10
	HEX	00,00,1F,00	;10
	HEX	17,00,00,00	;10
	HEX	00,00,00,19	;10
	HEX	12,0C,00,00	;10
	HEX	1B,00,00,00	;10
	HEX	00,12,00,00	;10
;
	HEX	00,00,00,09	;10
	HEX	00,2A,00,00	;10
	HEX	00,00,16,00	;10
	HEX	00,00,1B,00	;10
	HEX	00,00,00,16	;10
	HEX	08,00,00,00	;10
	HEX	00,17,00,00	;10
	HEX	00,19,00,00	;10
	HEX	00,00,0F,00	;10
	HEX	00,14,00,00	;10
	HEX	00,1B,00,00	;10
	HEX	11,00,00,00	;10
	HEX	00,06,00,00	;10
	HEX	0D,00,00,00	;10
	HEX	00,07,00,00	;10
	HEX	00,00,00,12	;10
;
	HEX	00,08,00,00	;10
	HEX	00,00,12,00	;10
	HEX	00,0C,00,00	;10
	HEX	16,00,00,00	;10
	HEX	00,12,00,00	;10
	HEX	00,00,00,04	;10
	HEX	00,13,00,00	;10
	HEX	19,00,00,00	;10
	HEX	00,17,00,00	;10
	HEX	00,00,1B,00	;10
	HEX	00,00,00,16	;10
	HEX	1C,00,00,00	;10
	HEX	00,00,1E,00	;10
	HEX	00,15,00,00	;10
	HEX	00,00,02,00	;10
	HEX	01,00,00,00	;10
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	unit data
HSIUNT	EQU	$
	WORD	0024H,0024H,0024H,0024H		;00	'2-3 7-3 HASHI DATA
	WORD	0024H,1DE0H,0024H,1DF0H		;01	'
        WORD    1DE1H,0024H,5DF0H,0024H		;02	'
        WORD    1DC2H,1DC3H,1DD2H,1DD3H		;03	'
        WORD    1DC4H,1DC5H,1DD4H,1DD5H		;04	'
        WORD    0024H,1DE3H,0024H,1DF3H		;05	'
        WORD    1DE4H,0024H,1DF4H,0024H		;06	'
        WORD    1DCAH,1DCBH,1DF1H,5DF1H		;07	'
        WORD    1DC0H,1DC1H,0024H,1DE2H		;08	'
        WORD    1DD0H,1DD1H,1DF2H,0024H		;09	'
        WORD	1DC6H,1DC7H,1DD6H,1DD7H		;0A	'
        WORD	1DE6H,1DE7H,1DF6H,1DF7H		;0B	'
        WORD	1DEBH,1DECH,1DFBH,1DFCH		;0C	'
        WORD	1DEDH,0024H,1DFDH,1DFEH		;0D	'
        WORD	0024H,0024H,1DFFH,1DF8H		;0E	'
        WORD	0024H,1DEAH,1DF9H,1DFAH		;0F	'
;
	WORD	1DC8H,1DC1H,1DFDH,1DE2H		;10	'
	WORD	1DD0H,1DD1H,1DF2H,1DF8H		;11	'
        WORD    1DE5H,1DF5H,1DD9H,1DDAH		;12	'
        WORD    1DCEH,1DCFH,1DEFH,1DEFH		;13	'
        WORD    1DDCH,1DDDH,1DEFH,1DEFH		;14	'
        WORD    1DDEH,1DDFH,1DEFH,1DEFH		;15	'
        WORD    1DCCH,1DCDH,1DEFH,1DEFH		;16	'
        WORD    1DDCH,1DE3H,1DEFH,1DF3H		;17	'
        WORD    1DE4H,1DDFH,1DF4H,1DEFH		;18	'
        WORD    1DE8H,1DE9H,1DDBH,1DEEH		;19	'
        WORD	1DEFH,1DEFH,1DEFH,1DEFH		;1A	'
        WORD	1DC9H,1DC1H,1DEFH,1DE2H		;1B	'
        WORD	1DD0H,1DD8H,1DF2H,1DEFH		;1C	'
        WORD	1DE6H,1DE7H,1DD9H,1DDAH		;1D	'
        WORD	0024H,0024H,0024H,0024H		;1E	'
        WORD	0024H,15E0H,0024H,15F0H		;1F	'
;
	WORD	15E1H,0024H,55F0H,0024H		;20	'
	WORD	15C2H,15C3H,15D2H,15D3H		;21	'
	WORD	15C4H,15C5H,15D4H,15D5H		;22	'
	WORD	0024H,15E3H,0024H,15F3H		;23	'
	WORD	15E4H,0024H,15F4H,0024H		;24	'
	WORD	15C0H,15C1H,0024H,15E2H		;25	'
	WORD	15D0H,15D1H,15F2H,0024H		;26	'
	WORD	15C2H,15C3H,0024H,15D3H		;27	'
	WORD	15C4H,15C5H,15D4H,0024H		;28	'
	WORD	15CAH,15CBH,15F1H,55F1H		;29	'
	WORD	15C6H,15C7H,15D6H,15D7H		;2A	'
	WORD	15C8H,15C1H,15FDH,15E2H		;2B	'
	WORD	15D0H,15D1H,15F2H,15F8H		;2C	'
	WORD	15E6H,15E7H,15D9H,15DAH		;2D	'
	WORD	15DCH,15E3H,15EFH,15F3H		;2E	'
	WORD	15E4H,15DFH,15F4H,15EFH		;2F	'
;
	WORD	15E8H,15E9H,15DBH,15EEH		;30	'
	WORD	15C9H,15C1H,15EFH,15E2H		;31	'
        WORD    15D0H,15D8H,15F2H,15EFH		;32	'
	WORD	15E6H,15E7H,15F6H,15F7H		;33	'
	WORD	15E5H,15F5H,15D9H,15DAH		;33	'
;
TAKUNT	EQU	$
	WORD	0024H,0024H,0024H,0024H		;00	'
	WORD	0024H,0024H,1DD0H,1DD1H		;01	'
        WORD    0024H,0024H,1DD2H,1DD3H		;02	'
        WORD    0024H,1DC5H,1DD4H,1DD5H		;03	'
        WORD    0024H,0024H,1DC1H,1DC2H		;04	'
        WORD    0024H,0024H,1DFEH,1DFFH		;05	'
        WORD    0024H,0024H,1DC0H,1DD1H		;06	'
        WORD    1DC6H,1DC7H,1DD6H,1DD7H		;07	'
        WORD    0024H,0024H,1DD2H,1DC3H		;08	'
        WORD    0024H,0024H,1CCAH,1CCBH		;09	'
        WORD	1DC6H,1DC7H,1DC4H,1DD7H		;0A	'
        WORD	0024H,0024H,1DFFH,1DFEH		;0B	'
        WORD	1DE8H,1DE9H,1DF8H,1DF9H		;0C	'
        WORD	1DEAH,1DEBH,1DFAH,1DFBH		;0D	'
        WORD	1DE0H,1DE1H,1DF0H,1DF1H		;0E	'
	WORD	1DE4H,1DE5H,1DF4H,1DF5H		;0F	Dummy
        WORD	1DC8H,1DC9H,1DD8H,1DD9H		;0C	'
        WORD	1DCAH,1DCBH,1DDAH,1DDBH		;0D	'
        WORD	1DE2H,1DE3H,1DF2H,1DF3H		;0E	'
	WORD	1DE6H,1DE7H,1DF6H,1DF7H		;0F	Dummy
;
MSAUNT	EQU	$
	WORD	0024H,0024H,0024H,0024H		;00	'
	WORD	1DC4H,1DC5H,1DD4H,1DD5H		;01	'
        WORD    1DC0H,1DC1H,1DD0H,1DD1H		;02	'
        WORD    1DC6H,1DC7H,1DD6H,1DD7H		;03	'
        WORD    1DC8H,1DC9H,1DD8H,1DD9H		;04	'
        WORD    1DD2H,1DD3H,1DC2H,1DC3H		;05	'
        WORD    1DC2H,1DC3H,1DC2H,1DC3H		;06	'
        WORD    1DCAH,1DCBH,1DDAH,1DDBH		;07	'
        WORD    1DCCH,1DCDH,1DDCH,1DDDH		;08	'
        WORD    1DCEH,1DCFH,1DDEH,1DDFH		;09	'
        WORD	1DF2H,1DF3H,1DE2H,1DE3H		;0A	'
        WORD	1DE4H,1DE5H,1DF4H,1DF5H		;0B	'
        WORD	1DE2H,1DE3H,1DE2H,1DE3H		;0C	'
        WORD	1DE6H,1DE7H,1DF6H,1DF7H		;0D	'
        WORD	1DE0H,1DE1H,1DF0H,1DF1H		;0E	'
;;;     WORD	1DE2H,1DE3H,1DD2H,1DD1H		;0F	Dummy
	
S83UNT	EQU	$
;
	WORD	0024H,0024H,0024H,0024H		;00	'8-3 SHIRO DATA
	WORD	1DC0H,1DC1H,1DCAH,1DD1H		;01	'
        WORD    1DC2H,1DC3H,1DD2H,1DCBH		;02	'
        WORD    1DC2H,1DC3H,1DD2H,1DD3H		;03	'
        WORD    1DC0H,1DC1H,1DD0H,1DD1H		;04	'
        WORD    1DDAH,1DE1H,1DD0H,1DD1H		;05	'
        WORD    1DE2H,1DDBH,1DD2H,1DD3H		;06	'
        WORD    1DDAH,1DE1H,1DCAH,1DD1H		;07	'
        WORD    1DE2H,1DE1H,1DE4H,1DE5H		;08	'
        WORD    1DE2H,1DE1H,1DD2H,1DD1H		;09	'
        WORD	1DE2H,1DDBH,1DD2H,1DCBH		;0A	'
        WORD	1DDAH,1DE1H,1DEAH,1DD1H		;0B	'
        WORD	1DF4H,1DF5H,1DD8H,1DE8H		;0C	'
        WORD	1DE2H,1DDBH,1DD2H,1DEBH		;0D	'
        WORD	1DC0H,1DC1H,1D92H,1DD1H		;0E	'
        WORD	1DE2H,1DE3H,1DD2H,1DD1H		;0F	'
;
	WORD	0024H,0024H,0024H,0024H		;10	'
	WORD	1DFAH,1DE1H,1DCCH,1DD1H		;11	'
        WORD    1DE2H,1DFBH,1DD2H,1DCDH		;12	'
        WORD    1DA2H,1DE1H,1DB2H,1DD1H		;13	'
        WORD    1DE2H,1DE1H,1DD2H,1DC6H		;14	'
        WORD    1DC4H,1DC5H,1DC7H,1DE7H		;15	'
        WORD    1DD4H,1DD5H,1DE7H,1DC8H		;16	'
        WORD    1DE2H,1DE3H,1DC9H,1DD1H		;17	'
        WORD    1DE2H,1DE1H,1DD2H,1D82H		;18	'
        WORD    1DE2H,1DE1H,1D83H,1D84H		;19	'
        WORD	1DE2H,1DE1H,1D85H,1D80H		;1A	'
        WORD	1DE2H,1DE1H,1D81H,1DD1H		;1B	'
        WORD	1DE2H,1DE1H,1DC9H,1DD1H		;1C	'
        WORD	1DE2H,1DD6H,1DD2H,1DE6H		;1D	'
        WORD	1DD7H,1DE7H,1DD7H,1DE7H		;1E	'
        WORD	1DE7H,5DD7H,1DE7H,5DD7H		;1F	'
;
	WORD	1DD9H,1DE3H,1DE9H,1DD1H		;20	'
	WORD	1DE2H,1DDCH,1DD2H,1DECH		;21	'
        WORD    1DDDH,1DDEH,1DEDH,1DEEH		;22	'
        WORD    1DDFH,1D90H,1DEFH,1DA0H		;23	'
        WORD    1D91H,1DE1H,1DA1H,1DD1H		;24	'
        WORD    1DA2H,1DE3H,1DB2H,1DD1H		;25	'
        WORD    1DD9H,1DE1H,1DE9H,1DD1H		;26	'
        WORD    1DE2H,1DE1H,1DF0H,1DF1H		;27	'
        WORD    1DE2H,1DE1H,1DF2H,1DF3H		;28	'
        WORD    1DE2H,1DF6H,1DF0H,1DF1H		;29	'
        WORD	1DF7H,1DCEH,1DF2H,1DF3H		;2A	'
        WORD	1DCFH,1DF8H,1DF0H,1DF1H		;2B	'
        WORD	1DF9H,1DE1H,1DF2H,1DF3H		;2C	'
        WORD	1DE2H,1DE3H,1DF0H,1DF1H		;2D	'
        WORD	1DFAH,1DE1H,1DF2H,1DF3H		;2E	'
        WORD	1DE2H,1DFCH,1DF0H,1DF1H		;2F	'
;
	WORD	1DFDH,1DFEH,1DF2H,1DF3H		;30	'
	WORD	1DFFH,1DB0H,1DF0H,1DF1H		;31	'
        WORD    1DB1H,1DE1H,1DF2H,1DF3H		;32	'
        WORD    1DE2H,1DFBH,1DF0H,1DF1H		;33	'
        WORD    1DA2H,1DE1H,1DF2H,1DF3H		;34	'
        WORD    1DE2H,1DCBH,1DD2H,1DD3H		;35	'
        WORD    1DCAH,1DE1H,1DD0H,1DD1H		;36	'
        WORD    1586H,1586H,1587H,1587H		;37	'
        WORD    1588H,1588H,1588H,1588H		;38	'
;
SH2UNT	EQU	$
	WORD	1534H,1534H,1534H,1534H		;00	'
	WORD	1534H,1536H,1534H,1536H		;01	'
	WORD	1537H,1538H,1537H,1528H		;02	'
	WORD	1534H,1D09H,1534H,1534H		;03	'
	WORD	1D09H,1D0AH,1D19H,1D1AH		;04	'
	WORD	1D0BH,1D0CH,1D1BH,1D1CH		;05	'
	WORD	5D0CH,5D0BH,5D1CH,5D1BH		;06	'
	WORD	5D0AH,5D09H,5D1AH,5D19H		;07	'
	WORD	1509H,150AH,1519H,151AH		;08	'
	WORD	150BH,150CH,151BH,151CH		;09	'
	WORD	550CH,550BH,551CH,551BH		;0A	'
	WORD	550AH,5509H,551AH,5519H		;0B	'
	WORD	1500H,1501H,1510H,1511H		;0C	'
	WORD	1DBBH,1DBCH,1D34H,1D88H		;0D	'
	WORD	1DBDH,1DBCH,1D89H,1D8CH		;0E	'
	WORD	1DBDH,1DBCH,1D8DH,5D89H		;0F	'
;
	WORD	1DBDH,1DBEH,1D88H,1D34H		;10	'
	WORD	1DB0H,1DB1H,1DB2H,1CE8H		;11	'
	WORD	1520H,1521H,1530H,1531H		;12	'
	WORD	1502H,1503H,1512H,1513H		;13	'
	WORD	5DB1H,5DB0H,1CE9H,5DB2H		;14	'
	WORD	1534H,1D34H,1534H,1D34H		;15	'
	WORD	1D34H,1D98H,1D34H,1DA8H		;16	'
	WORD	1D89H,1D8AH,1D99H,1D9AH		;17	'
	WORD	1D8BH,5D89H,1D9BH,5D99H		;18	'
	WORD	1D9CH,1D34H,1DACH,1D34H		;19	'
	WORD	1524H,1516H,1534H,1526H		;1A	'
	WORD	1517H,1518H,1527H,1528H		;1B	'
	WORD	1DB3H,1CEAH,1D34H,1D8EH		;1C	'
	WORD	1CEBH,5DB3H,1D8FH,1D34H		;1D	'
	WORD	1D34H,1DA8H,1D34H,1DA8H		;1E	'
	WORD	1DA9H,1D8AH,1DB9H,1DB9H		;1F	'
;
	WORD	1D8BH,5DA9H,1DB9H,1DBAH		;20	'
	WORD	1DACH,1D34H,1DACH,1D34H		;21	'
	WORD	1534H,1534H,1D0DH,1D0EH		;22	'
	WORD	1534H,1534H,1D0FH,1534H		;23	'
	WORD	1D1DH,1D1EH,1D2DH,1D2EH		;24	'
	WORD	1D1FH,1D29H,1D2FH,1D39H		;25	'
	WORD	1537H,1538H,1537H,1538H		;26	'
	WORD	1D34H,1DA8H,1D34H,1DB8H		;27	'
	WORD	1D8BH,5DA9H,1DB9H,1DB9H		;28	'
	WORD	1DACH,1D34H,1DBAH,1D34H		;29	'
	WORD	1D3DH,1D3EH,1534H,1D15H		;2A	'
	WORD	1D3FH,1D2AH,1D25H,1D3AH		;2B	'
	WORD	1534H,9526H,9524H,9516H		;2C	'
	WORD	9527H,1538H,9517H,9518H		;2D	'
	WORD	1D80H,1D81H,1D90H,1D91H		;2E	'
	WORD	1D82H,1D83H,1D92H,1D93H		;2F	'
;
	WORD	1532H,1522H,1510H,1511H		;30	'
	WORD	1522H,1523H,1510H,1511H		;31	'
	WORD	1533H,1500H,1510H,1511H		;32	'
	WORD	1DA0H,1DA1H,1510H,1511H		;33	'
	WORD	1DA2H,1DA3H,1510H,1511H		;34	'
	WORD	1533H,1534H,1510H,1511H		;35	'
	WORD	1585H,1587H,1595H,1597H		;36	'
	WORD	1584H,1586H,1594H,1596H		;37	'
	WORD	1585H,1586H,1595H,1596H		;38	'
	WORD	1584H,1587H,1594H,1597H		;39	'
	WORD	1584H,1585H,1594H,1595H		;3A	'
	WORD	1586H,1585H,1596H,1595H		;3B	'
	WORD	15A6H,15A7H,15B6H,15B7H		;3C	'
	WORD	1594H,15A6H,15B4H,15B6H		;3D	'
	WORD	15A6H,15A6H,15B6H,15B6H		;3E	'
	WORD	1594H,15A7H,15B4H,15B7H		;3F	'
;
	WORD	1599H,1516H,1534H,1526H		;40	'
	WORD	154CH,154DH,155CH,1540H		;41	'
        WORD    154DH,154DH,1541H,1542H		;42	'
        WORD    154DH,154DH,1543H,1544H		;43	'
        WORD    154DH,154EH,1545H,155DH		;44	'
        WORD    155CH,1550H,155CH,1560H		;45	'
        WORD    1551H,1552H,1561H,1562H		;46	'
        WORD    1553H,1554H,1563H,1564H		;47	'
        WORD    1555H,155DH,1565H,155DH		;48	'
        WORD    155CH,1570H,155CH,1546H		;49	'
        WORD	1571H,1572H,1547H,1548H		;4A	'
        WORD	1573H,1574H,1549H,154AH		;4B	'
        WORD	1575H,155DH,154BH,155DH		;4C	'
        WORD	155CH,1556H,155CH,1566H		;4D	'
        WORD	1557H,1558H,1567H,1568H		;4E	'
        WORD	1559H,155AH,1569H,156AH		;4F	'
;
        WORD	155BH,155DH,156BH,155DH		;50	'
        WORD	155CH,1576H,155EH,156CH		;51	'
	WORD	1577H,1578H,156CH,156CH		;52	'
	WORD	1579H,157AH,156CH,156CH		;53	'
	WORD	157BH,155DH,156CH,156DH		;54	'
	WORD	0024H,0024H,0024H,0024H		;55	Nuki
	WORD	0024H,0024H,0024H,0024H		;56	Nuki
	WORD	0024H,0024H,0024H,0024H		;57	Nuki
	WORD	0024H,0024H,0024H,0024H		;58	Nuki
	WORD	0024H,0024H,0024H,0024H		;59	Nuki
	WORD	0024H,0024H,0024H,0024H		;5A	Nuki
	WORD	0024H,0024H,0024H,0024H		;5B	Nuki
	WORD	0024H,0024H,0024H,0024H		;5C	Nuki
	WORD	0024H,0024H,0024H,0024H		;5D	Nuki
	WORD	0024H,0024H,0024H,0024H		;5E	Nuki
	WORD	0024H,0024H,0024H,0024H		;5F	Nuki
;
WTRUNT	EQU	$
	WORD	0024H,0024H,0024H,0024H		;00	Nuki
	WORD	10A4H,10A4H,0024H,0024H		;01
	WORD	10A4H,10A4H,10A4H,10A4H		;02
	WORD	1572H,1571H,155EH,155FH		;03	'
	WORD	0024H,0024H,0024H,1CF0H		;04	'
	WORD	0024H,0024H,1CF1H,0024H		;05	'
	WORD	1572H,1571H,155EH,155FH		;06	'
	WORD	1572H,1571H,155EH,155FH		;07	'
	WORD	1540H,1541H,1550H,1551H		;08	'
	WORD	1546H,1547H,1556H,1557H		;09	'
	WORD	1572H,1571H,155EH,155FH		;0A	'
	WORD	0024H,1CF2H,0024H,1CF4H		;0B	'
	WORD	1CF3H,0024H,1CF5H,0024H		;0C	'
	WORD	1560H,1561H,1570H,1571H		;0D	'
	WORD	1566H,1567H,1576H,1577H		;0E	'
	WORD	150AH,150BH,151AH,151BH		;0F	'
;
	WORD	150CH,150DH,151CH,151DH		;00	Nuki
	WORD	1528H,1529H,151AH,151BH		;01
	WORD	1538H,1539H,151CH,151DH		;02
	WORD	150EH,0024H,151EH,151FH		;03	'
	WORD	1572H,1571H,155EH,155FH		;04	'
	WORD	1572H,1571H,155EH,155FH		;05	'
	WORD	1572H,1571H,155EH,155FH		;06	'
	WORD	1572H,1571H,155EH,155FH		;07	'
	WORD	1520H,1521H,1530H,1531H		;08	'
	WORD	152AH,152BH,153AH,153BH		;09	'
	WORD	152CH,152DH,153CH,153DH		;0A	'
	WORD	152EH,152FH,153EH,153FH		;0B	'
	WORD	1572H,1571H,155EH,155FH		;0C	'
	WORD	1572H,1571H,155EH,155FH		;0D	'
	WORD	1522H,1523H,1532H,1533H		;0E	'
	WORD	1572H,1571H,155EH,155FH		;0F	'
;
	WORD	150CH,150DH,151CH,151DH		;00	Nuki
	WORD	1528H,1529H,151AH,151BH		;01
	WORD	1538H,1539H,151CH,151DH		;02
	WORD	1542H,1543H,1552H,1553H		;03	'
	WORD	1544H,1545H,1554H,1555H		;04	'
	WORD	1562H,1563H,1572H,1573H		;05	'
	WORD	1564H,1565H,1574H,1575H		;06	'
	WORD	0024H,0024H,0024H,0024H		;00	Nuki
	WORD	0024H,0024H,0024H,0024H		;00	Nuki
	WORD	0024H,0024H,0024H,0024H		;00	Nuki
	WORD	0024H,0024H,0024H,0024H		;00	Nuki
	WORD	0024H,0024H,0024H,0024H		;00	Nuki
	WORD	0024H,0024H,0024H,0024H		;00	Nuki
	WORD	0024H,0024H,0024H,0024H		;00	Nuki
	WORD	0024H,0024H,0024H,0024H		;00	Nuki
	WORD	0024H,0024H,0024H,0024H		;00	Nuki
;
	WORD	1534H,1535H,151AH,151BH		;00	Nuki
	WORD	1536H,1537H,151CH,151DH		;01
	WORD	152AH,152BH,1524H,1525H		;02
	WORD	152CH,152DH,1526H,1527H		;03	'
	WORD	15A4H,15A5H,15B4H,15B5H		;04	'
	WORD	1505H,150BH,1515H,1503H		;05	'
	WORD	0024H,1504H,0024H,1514H		;06	'
	WORD	1510H,1511H,1513H,1527H		;07	'
	WORD	0024H,0024H,0024H,1512H		;08	'
	WORD	1506H,152BH,1509H,1507H		;09	'
	WORD	152EH,152FH,153EH,1507H		;0A	'
	WORD	0024H,0024H,1508H,0024H		;0B	'
	WORD	152EH,152FH,1509H,1507H		;0C	'
	WORD	1572H,1571H,155EH,155FH		;0D	'
	WORD	1522H,1523H,1532H,1533H		;0E	'
	WORD	1572H,1571H,155EH,155FH		;0F	'
;
GRAUNT	EQU	$
	WORD	01024H,01024H,01024H,01024H	;00 yama enkei data
	WORD	0150AH,0154AH,0154AH,01516H	;01
	WORD	01507H,01506H,0155AH,01516H	;02
	WORD	01024H,01501H,01510H,01511H	;03
	WORD	01502H,01503H,0150AH,0150AH	;04
	WORD	01504H,01024H,01514H,01515H	;05
	WORD	0150AH,0150DH,0150AH,0151DH	;06
	WORD	01507H,01024H,0150EH,01507H	;07
	WORD	0150AH,0151DH,0150AH,0150AH	;08
	WORD	0151FH,01517H,0151EH,01555H	;09
	WORD	0151EH,01555H,0150AH,0150FH	;0A
	WORD	01555H,01517H,01555H,01555H	;0B
	WORD	01555H,01555H,0151FH,01555H	;0C
	WORD	01507H,01506H,0150EH,0155BH	;0D
	WORD	01518H,0150AH,0150EH,01518H	;0E
	WORD	0155EH,0155EH,0154FH,0154FH	;0F
;
	WORD	0150AH,0154BH,0154AH,01516H	;10
	WORD	01555H,0155AH,0155AH,01516H	;11
	WORD	01024H,01506H,01506H,01516H	;12
	WORD	01516H,0150AH,0150AH,0150AH	;13
	WORD	01502H,01508H,0150AH,0150AH	;14
	WORD	01509H,0150AH,01514H,0151AH	;15
	WORD	0550AH,0150AH,0150AH,0150AH	;16
	WORD	0151EH,01517H,0150AH,0150FH	;17
	WORD	01507H,01024H,01517H,01507H	;18
	WORD	0150AH,0150FH,0150AH,0151DH	;19
	WORD	01555H,01517H,0151FH,01555H	;1A
	WORD	0151FH,01555H,0151EH,01555H	;1B
	WORD	01555H,01555H,01555H,01555H	;1C
	WORD	01507H,01506H,01517H,0155BH	;1D
	WORD	01518H,0150AH,01517H,01518H	;1E
	WORD	0155FH,0155FH,0155FH,0155FH	;1F
;
	WORD	01545H,0150AH,0150AH,0150AH	;20
	WORD	0150AH,0150AH,0150AH,01519H	;21
	WORD	0150AH,01512H,0150AH,09512H	;22
	WORD	01513H,0150AH,09513H,0150AH	;23
	WORD	01519H,0550AH,0550AH,0D545H	;24
	WORD	01547H,05547H,09547H,0D547H	;25
	WORD	01557H,05557H,09557H,0D557H	;26
	WORD	01512H,0150AH,09512H,01519H	;27
	WORD	0150AH,0150AH,01547H,05547H	;28
	WORD	09547H,01554H,0150AH,09557H	;29
	WORD	05557H,0150AH,0D557H,0150AH	;2A
	WORD	0150BH,0150CH,0151BH,0151CH	;2B
	WORD	0150AH,0150AH,0150AH,0150BH	;2C
	WORD	0150AH,0150AH,0150CH,0150AH	;2D
	WORD	0150BH,0151BH,0151BH,0150AH	;2E
	WORD	0151CH,0150CH,0150AH,0151CH	;2F
;
	WORD	05555H,05556H,05555H,0D556H	;30
	WORD	05555H,05546H,05555H,0D546H	;31
	WORD	0155CH,01517H,05555H,05555H	;32
	WORD	05555H,01517H,05555H,0154CH	;33
	WORD	01526H,01521H,01536H,01531H	;34
	WORD	01522H,01523H,01532H,01533H	;35
	WORD	01520H,01521H,01530H,01531H	;36
	WORD	01522H,01524H,01532H,01534H	;37
	WORD	01527H,01551H,01537H,01531H	;38
	WORD	01552H,01553H,01532H,01533H	;39
	WORD	01550H,01551H,01530H,01531H	;3A
	WORD	01552H,01548H,01532H,01558H	;3B
	WORD	01527H,01541H,01537H,01531H	;3C
	WORD	01542H,01543H,01532H,01533H	;3D
	WORD	01540H,01541H,01530H,01531H	;3R
	WORD	01542H,01544H,01532H,01535H	;3F
;
	WORD	0152EH,01529H,0153EH,01539H	;40
	WORD	0152AH,0152BH,0153AH,0153BH	;41
	WORD	01528H,01529H,01538H,01539H	;42
	WORD	0152AH,0152CH,0153AH,0153CH	;43
	WORD	0152FH,01529H,0153FH,01539H	;44
	WORD	0152AH,01549H,0153AH,01559H	;45
	WORD	0152AH,0152DH,0153AH,0153DH	;46
;
	WORD	01560H,01561H,0155EH,0155FH	;47
	WORD	01562H,01563H,01567H,01568H	;48
	WORD	01562H,0154DH,01567H,0155DH	;49
	WORD	01562H,0154EH,01567H,0155DH	;4A
	WORD	01562H,0154FH,01567H,0155DH	;4B
	WORD	01564H,01561H,01569H,0155FH	;4C
	WORD	01565H,01561H,0156AH,0155FH	;4D
	WORD	01566H,01566H,01566H,01566H	;4E
;
        WORD	1586H,1586H,1587H,1587H		;4F	Yuka
        WORD	1588H,1588H,1588H,1588H		;50	'
;
        WORD	1512H,151FH,1512H,151FH		;51	Yama
;
	WORD	1507H,1506H,15B0H,1516H		;52	Yuka
        WORD    1545H,1571H,150EH,15A2H         ;53     Dummy
        WORD    1589H,158CH,159BH,159CH         ;54     Dummy
	WORD	159dH,159FH,159FH,1512H		;55	Dummy
        WORD    1589H,158CH,159BH,159CH         ;56     Dummy
	WORD	15FFH,15FFH,15FFH,15FFH		;57	Yuka 
	WORD	15EEH,15EEH,15FEH,15FEH		;58	Dummy
	WORD	0027H,0027H,0027H,0027H		;59	Dummy
	WORD	0027H,0027H,0027H,0027H		;5A	Dummy
	WORD	0027H,0027H,0027H,0027H		;5B	Dummy
	WORD	0027H,0027H,0027H,0027H		;5C	Dummy
	WORD	0027H,0027H,0027H,0027H		;5D	Dummy
	WORD	0027H,0027H,0027H,0027H		;5E	Dummy
	WORD	0027H,0027H,0027H,0027H		;5F	Dummy
;
	WORD	142EH,1596H,1567H,1591H		;60	Yama
	WORD	1597H,1503H,1512H,1513H		;61	'
        WORD    154EH,1506H,1554H,1516H		;62	'
        WORD    15A0H,15A1H,15B0H,1516H		;63	'
        WORD    1517H,15B0H,15B0H,1516H		;64	'
        WORD    1555H,1517H,1555H,9517H		;65	'
        WORD    1555H,1555H,1555H,9517H		;66	'
        WORD    1545H,1571H,1517H,15A2H		;67	'
        WORD    1557H,1581H,1590H,1591H		;68	'
        WORD    1582H,1583H,1592H,1593H		;69	'
        WORD	1584H,1557H,1594H,1595H		;6A	'
        WORD	1512H,150DH,1512H,151DH		;6B	'
        WORD	1507H,1424H,150EH,1507H		;6C	'
        WORD	151EH,1517H,1512H,150FH		;6D	'
        WORD	1512H,151DH,1512H,1512H		;6E	'
        WORD	151FH,1517H,151EH,1555H		;6F	'
;
	WORD	1507H,154BH,150EH,1545H		;70	?
	WORD	1518H,1519H,150EH,1518H		;71	?
        WORD    1512H,150FH,1512H,151DH		;72	'
        WORD    1555H,1517H,151FH,1555H		;73	'
        WORD    151EH,1555H,1512H,150FH		;74	'
        WORD    151FH,1555H,151EH,1555H		;75	'
        WORD    1555H,1555H,151FH,1555H		;76	'
        WORD    1545H,142EH,150EH,1545H		;77	'
        WORD    1512H,1512H,1512H,1589H		;78	'
        WORD    1512H,1512H,158CH,1512H		;79	'
        WORD	1589H,158AH,1599H,159AH		;7A	'
        WORD	158BH,158CH,159BH,159CH		;7B	'
        WORD	158DH,158EH,1512H,158FH		;7C	'
        WORD	159DH,159EH,159FH,1512H		;7D	'
        WORD	1589H,158CH,1599H,159AH		;7E	'
        WORD	1589H,158CH,159BH,159CH		;7F	'
;
	WORD	15B3H,15B2H,15B2H,1516H		;80	'
	WORD	15B3H,15A3H,15B2H,1516H		;81	'
        WORD    1512H,1599H,1512H,158FH		;82	'
        WORD    159DH,158EH,159FH,158FH		;83	'
        WORD    159CH,1512H,159FH,1512H		;84	'
        WORD    1512H,1512H,158CH,1589H		;85	'
        WORD    1589H,158CH,159BH,159AH		;86	'
        WORD    1512H,1512H,1589H,158CH		;87	'
        WORD    1599H,159CH,158FH,159FH		;88	'
        WORD    1512H,1599H,158CH,158FH		;89	'
        WORD	1516H,1512H,1589H,158CH		;8A	'
        WORD	1516H,1512H,1512H,1589H		;8B	'
        WORD	1516H,1512H,1589H,158CH		;8C	'
        WORD	1599H,159CH,158DH,15B1H		;8D	'
        WORD	1512H,151DH,158CH,1512H		;8E	'
        WORD	1512H,151DH,158CH,1512H		;8F	'
;
	WORD	01562H,01563H,01572H,01573H	;90
	WORD	01564H,01565H,01574H,01575H	;91
	WORD	01566H,01567H,01576H,01577H	;92
	WORD	01568H,01569H,01578H,01579H	;93
	WORD	00024H,00024H,01D00H,01D01H	;94
	WORD	00024H,00024H,01D02H,01D03H	;95
	WORD	00024H,00024H,01D04H,01D05H	;96
	WORD	00024H,00024H,01D06H,01D07H	;97
	WORD	01D10H,01D11H,01D20H,01D21H	;98
	WORD	01D12H,01D13H,01D22H,01D23H	;99
	WORD	01D14H,01D15H,01D24H,01D25H	;9A
	WORD	01D16H,01D17H,01D26H,01D27H	;9B
	WORD	00024H,00024H,01D40H,01D41H	;9C
	WORD	01D30H,01D31H,01D08H,01D09H	;9D
	WORD	01D32H,01D33H,01D0AH,01D0BH	;9E
	WORD	01D34H,01D35H,01D0CH,01D0DH	;9F

	WORD	01D36H,01D37H,01D0EH,01D0FH	;A0
	WORD	01D50H,01D51H,01D60H,01D61H	;A1
	WORD	01D18H,01D19H,01D28H,01D29H	;A2
	WORD	01D1AH,01D1BH,01D2AH,01D2BH	;A3
	WORD	01D1CH,01D1DH,01D2CH,01D2DH	;A4
	WORD	01D1EH,01D1FH,01D2EH,01D2FH	;A5
	WORD	01D70H,01D71H,00024H,00024H	;A6
	WORD	01D38H,01D39H,00024H,00024H	;A7
	WORD	01D3AH,01D3BH,00024H,00024H	;A8
	WORD	01D3CH,01D3DH,00024H,00024H	;A9
	WORD	01D3EH,01D3FH,00024H,00024H	;AA
	WORD	01D3EH,01D3FH,00024H,00024H	;AB;DUMMY
	WORD	01D3EH,01D3FH,00024H,00024H	;AC;
	WORD	01D3EH,01D3FH,00024H,00024H	;AD;
	WORD	01D3EH,01D3FH,00024H,00024H	;AE;
	WORD	01D3EH,01D3FH,00024H,00024H	;AF;
;
	WORD	1DC0H,1DC1H,1DD0H,1DD1H		;B0	'2-2 YAMA DATA
	WORD	1DC2H,1DC3H,1DD2H,1DD3H		;B1	'
        WORD    1DC4H,1DC5H,1DD4H,1DD5H		;B2	'
        WORD    1DC6H,1DC7H,1DD6H,1DD7H		;B3	'
        WORD    1DC8H,1DC9H,1DD8H,1DD9H		;B4	'
        WORD    1DCAH,0024H,1DDAH,1DDBH		;B5	'
        WORD    1DE8H,0024H,1DF8H,0024H		;B6	'
        WORD    1DE8H,1DE9H,1DF8H,1DF9H		;B7	'
        WORD    1DEAH,1DEBH,1DFAH,1DFBH		;B8	'
        WORD    0024H,1DE9H,0024H,1DF9H		;B9	'
        WORD	1DDFH,1DC3H,1DDCH,1DD3H		;BA	'
        WORD	1DE8H,1DE9H,1DF8H,1DF9H		;BB	'
        WORD	1DCCH,1DCDH,1DD0H,1DD1H		;BC	'
        WORD	1DCEH,1DCFH,1DD2H,1DD3H		;BD	'
        WORD	0024H,1DE5H,0024H,1DF5H		;BE	'
        WORD	0024H,1DDDH,0024H,1DDEH		;BF	'
;
	WORD	1DE0H,1DE1H,1DF0H,1DF1H		;C0	'2-2 YAMA DATA
	WORD	1DE2H,1DE3H,1DF2H,1DF3H		;C1	'
        WORD    1DE4H,1DE5H,1DF4H,1DF5H		;C2	'
        WORD    1DE6H,1DE7H,1DF6H,1DF7H		;C3	'
        WORD    1DE2H,1DF8H,1DF2H,1DF3H		;C4	'
        WORD    1DE2H,1DE3H,1DF2H,1DF3H		;C5	'
        WORD    1DE4H,0024H,1DF4H,0024H		;C6	'
        WORD    0024H,0024H,1DECH,1DEDH		;C7	'
        WORD    1DE2H,1DF8H,1DF2H,1DF3H		;C8	'
        WORD    15EEH,15EEH,15FEH,15FEH		;C9	F
        WORD	15FFH,15FFH,15FFH,15FFH		;CA	'
        WORD	1D16H,1D12H,1D12H,1D89H		;CB	'
        WORD	1D16H,1D12H,1D89H,1D8CH		;CC	'
        WORD	1D99H,1D9CH,1D8DH,1DB1H		;CD	'
        WORD	1D12H,1D1DH,1D8CH,1D12H		;CE	'
        WORD	1D12H,1D1DH,1D8CH,1D12H		;CF	'
;
	WORD	01562H,01563H,01572H,01573H	;D0
	WORD	01564H,01565H,01574H,01575H	;D1
	WORD	01566H,01567H,01576H,01577H	;D2
	WORD	01568H,01569H,01578H,01579H	;D3
;
	WORD	01507H,01506H,015B0H,01516H	;D4
	WORD	01520H,01521H,01530H,01531H	;D5
	WORD	01522H,01523H,01532H,01533H	;D6
	WORD	01528H,01529H,01538H,01539H	;D7
	WORD	0152AH,0152BH,0153AH,0153BH	;D8
	WORD	01526H,01521H,01536H,01531H	;D9
	WORD	01522H,01524H,01532H,01534H	;DA
	WORD	0152EH,01529H,0153EH,01539H	;DB
	WORD	0152AH,0152CH,0153AH,0153CH	;DC
	WORD	01540H,01541H,01530H,01531H	;DD
	WORD	01542H,01543H,01532H,01533H	;DE
	WORD	01527H,01541H,01537H,01531H	;DF
;
	WORD	01522H,01524H,01532H,01534H	;E0
	WORD	0152FH,01529H,0153FH,01539H	;E1
	WORD	0152AH,0152DH,0153AH,0153DH	;E2
	WORD	01550H,01551H,01530H,01531H	;E3
	WORD	01552H,01553H,01532H,01533H	;E4
	WORD	01552H,01548H,01532H,01558H	;E5
	WORD	0152AH,01549H,0153AH,01559H	;E6
;
NIGUNT	EQU	$
;
	WORD	00024H,00024H,00024H,00024H	;00 hoshizora enkei data
	WORD	01CC1H,00024H,00024H,00024H	;01
	WORD	01CC2H,00024H,00024H,00024H	;02
	WORD	01CC3H,00024H,00024H,00024H	;03
	WORD	00024H,00024H,01CC0H,00024H	;04
	WORD	00024H,00024H,01CC1H,00024H	;05
	WORD	00024H,00024H,01CC2H,00024H	;06
	WORD	00024H,00024H,01CC3H,00024H	;07
	WORD	01CC4H,00024H,00024H,00024H	;08
	WORD	01CC5H,00024H,00024H,00024H	;09
	WORD	01CC6H,00024H,00024H,00024H	;0A
	WORD	01CC7H,00024H,00024H,00024H	;0B
	WORD	00024H,00024H,01CC4H,00024H	;0C
	WORD	00024H,00024H,01CC5H,00024H	;0D
	WORD	00024H,00024H,01CC6H,00024H	;0E
	WORD	00024H,00024H,01CC7H,00024H	;0F
;
	WORD	00024H,01CC0H,00024H,00024H	;10
	WORD	00024H,01CC1H,00024H,00024H	;11
	WORD	00024H,01CC2H,00024H,00024H	;12
	WORD	00024H,01CC3H,00024H,00024H	;13
	WORD	00024H,00024H,00024H,01CC0H	;14
	WORD	00024H,00024H,00024H,01CC1H	;15
	WORD	00024H,00024H,00024H,01CC2H	;16
	WORD	00024H,00024H,00024H,01CC3H	;17
	WORD	00024H,01CC4H,00024H,00024H	;18
	WORD	00024H,01CC5H,00024H,00024H	;19
	WORD	00024H,01CC6H,00024H,00024H	;1A
	WORD	00024H,01CC7H,00024H,00024H	;1B
	WORD	00024H,00024H,00024H,01CC4H	;1C
	WORD	00024H,00024H,00024H,01CC5H	;1D
	WORD	00024H,00024H,00024H,01CC6H	;1E
	WORD	00024H,00024H,00024H,01CC7H	;1F
;
	WORD	015E0H,015E0H,015E1H,015E1H	;20
	WORD	015C6H,015C7H,015D6H,015D7H	;21
	WORD	015C8H,015C9H,015D8H,015D9H	;22
	WORD	015CAH,015CBH,015DAH,015DBH	;23
	WORD	015CCH,015CDH,015DCH,015DDH	;24
	WORD	015E6H,015E7H,015F6H,015F7H	;25
	WORD	015E8H,015E9H,015F8H,015F9H	;26
	WORD	015EAH,015EBH,015FAH,015FBH	;27
	WORD	015ECH,015EDH,015FCH,015FDH	;28
	WORD	015E2H,015E2H,015E2H,015E2H	;29
	WORD	01CC0H,00024H,00024H,00024H	;2A
	WORD	01CC0H,00024H,00024H,00024H	;2B
;
;;;;;;;;;;;;;;;	SHIRO DATA
SHWUNT	EQU	$
	WORD	0024H,0024H,0024H,0024H		;00	'
	WORD	1504H,1505H,1516H,1517H		;01	'
	WORD	1506H,1507H,1520H,1521H		;02	'
	WORD	1504H,1505H,1522H,1523H		;03	'
	WORD	1506H,1507H,1514H,1515H		;04	'
	WORD	150CH,150DH,151CH,151DH		;05	'
	WORD	0024H,0024H,151EH,0024H		;06	'
	WORD	0024H,152CH,0024H,153CH		;07	'
	WORD	150CH,152AH,1516H,153AH		;08	'
	WORD	152BH,1507H,153BH,1521H		;09	'
	WORD	1526H,1527H,1536H,1537H		;0A	'
	WORD	1530H,1531H,1508H,0024H		;0B	'
	WORD	1532H,1533H,0024H,150BH		;0C	'
	WORD	1524H,1525H,1534H,1535H		;0D	'
	WORD	1526H,151BH,1536H,1537H		;0E	'
	WORD	150FH,0024H,1508H,0024H		;0F	'
;
	WORD	0024H,0024H,0024H,153EH		;10	'
	WORD	152EH,152FH,153FH,1535H		;11	'
	WORD	1518H,0024H,154AH,154BH		;12	'
	WORD	0024H,1519H,155AH,155BH		;13	'
	WORD	0024H,1519H,155CH,1548H		;14	'
	WORD	1524H,1525H,1544H,1545H		;15	'
	WORD	1526H,1527H,1546H,1547H		;16	'
	WORD	0024H,0024H,155CH,1551H		;17	'
	WORD	0024H,0024H,1552H,1553H		;18	'
	WORD	0024H,1519H,1550H,1548H		;19	'
	WORD	1500H,1501H,1511H,1500H		;1A	'
	WORD	1568H,1569H,1578H,1579H		;1B	'
	WORD	156AH,156BH,157AH,157BH		;1C	'
	WORD	1510H,1511H,1501H,1510H		;1D	'
	WORD	156CH,1561H,157CH,1571H		;1E	'
	WORD	1554H,1555H,1572H,1573H		;1F	'
;
	WORD	1556H,1557H,1574H,1575H		;20	'
	WORD	154CH,154DH,1576H,1577H		;21	'
	WORD	1562H,1563H,1572H,1573H		;22	'
	WORD	1564H,1565H,1574H,1575H		;23	'
	WORD	1566H,1567H,1576H,1577H		;24	'
	WORD	1560H,1561H,157CH,1571H		;25	'
	WORD	1554H,1558H,1572H,1559H		;26	'
	WORD	1516H,1517H,1518H,1519H		;27	'
	WORD	1519H,1518H,1518H,1519H		;28	'
	WORD	1506H,1506H,1514H,1515H		;29	'
;
;;;;;;;;;;;;;;;	SHIRO DATA
SHIUNT	EQU	$
	WORD	1534H,1534H,1534H,1534H		;00	'
	WORD	1534H,1504H,1534H,1504H		;01	'
	WORD	1505H,1506H,1505H,1506H		;02	'
	WORD	1529H,152AH,1519H,151AH		;03	'
	WORD	152BH,152CH,151BH,151CH		;04	'
	WORD	1538H,1534H,1538H,1534H		;05	'
	WORD	1519H,151AH,1519H,151AH		;06	'
	WORD	151BH,151CH,151BH,151CH		;07	'
	WORD	1509H,150AH,1519H,151AH		;08	'
	WORD	150BH,150CH,151BH,151CH		;09	'
	WORD	1534H,1504H,1534H,1514H		;0A	'
	WORD	1505H,1506H,1515H,1506H		;0B	'
	WORD	1500H,1501H,1510H,1511H		;0C	'
	WORD	1500H,1502H,1510H,1512H		;0D	'
	WORD	1503H,1501H,1513H,1511H		;0E	'
	WORD	150DH,150AH,151DH,151AH		;0F	'
;
	WORD	150BH,150EH,151BH,151EH		;10	'
        WORD	150FH,1501H,151FH,1511H		;11	'
        WORD    1520H,1521H,1530H,1531H		;12	'
        WORD    1520H,1522H,1530H,1532H		;13	'
        WORD    1523H,1521H,1533H,1531H		;14	'
        WORD    1520H,1521H,1530H,1530H		;15	'
        WORD    152DH,151AH,153DH,151AH		;16	'
        WORD    151BH,152EH,151BH,153EH		;17	'
        WORD    152FH,1521H,153FH,1531H		;18	'
        WORD    1535H,1535H,1534H,1534H		;19	'
        WORD	1524H,1516H,1534H,1526H		;1A	'
        WORD	1517H,1518H,1527H,1528H		;1B	'
        WORD	1525H,1535H,1534H,1534H		;1C	'
        WORD	1539H,150AH,1519H,151AH		;1D	'
        WORD	153AH,1535H,1538H,1534H		;1E	'
        WORD	1534H,1536H,1534H,1536H		;1F	'
;
	WORD	1537H,1528H,1537H,1528H		;20	'
	WORD	1502H,1503H,1512H,1505H		;21	'
        WORD    1504H,1524H,1514H,1515H		;22	'
        WORD    1524H,1506H,1506H,1516H		;23	'
        WORD    1512H,1512H,1512H,1512H		;24	'
        WORD    150EH,1517H,150FH,1555H		;25	'
        WORD    1507H,1524H,1517H,1507H		;26	'
        WORD    1516H,151BH,150BH,151BH		;27	'
        WORD    150CH,1512H,151CH,150CH		;28	'
        WORD    151DH,1555H,151EH,1555H		;29	'
        WORD	1555H,1517H,1555H,1555H		;2A	'
        WORD	1516H,150BH,1512H,1512H		;2B	'
        WORD	151BH,1512H,1512H,1512H		;2C	'
        WORD	151EH,1555H,1512H,1555H		;2D	'
        WORD	1555H,1555H,1555H,1555H		;2E	'
        WORD	1D80H,1D81H,1D90H,1D91H		;2F	'
;
	WORD	5D81H,5D80H,1D92H,5D90H		;30	'
	WORD	1DA0H,1DA1H,1DB0H,1D82H		;31	'
        WORD    1DA2H,1DB1H,5D82H,1DB2H		;32	'
        WORD    1534H,157CH,1534H,157DH		;33	'
        WORD    1587H,1588H,1597H,1598H		;34	'
        WORD    1D83H,1D84H,1D93H,1D94H		;35	'
        WORD    1D85H,1D86H,1D95H,1D96H		;36	'
        WORD    15A7H,15A8H,15B7H,15B8H		;37	'
        WORD    1534H,158AH,1534H,159AH		;38	'
        WORD    1589H,158BH,1513H,159BH		;39	'
        WORD	1DA3H,1DA4H,1530H,1530H		;3A	'
        WORD	1DA5H,1DA6H,1530H,1530H		;3B	'
        WORD	15B3H,15B4H,15B5H,15B6H		;3C	'
        WORD	15A9H,15AAH,15B9H,1532H		;3D	'
        WORD	1523H,15ABH,1533H,1531H		;3E	'
        WORD	1535H,1516H,1534H,1526H		;3F	'
;
	WORD	1599H,1516H,1534H,1526H		;40	'
	WORD	154CH,154DH,155CH,1540H		;41	'
        WORD    154DH,154DH,1541H,1542H		;42	'
        WORD    154DH,154DH,1543H,1544H		;43	'
        WORD    154DH,154EH,1545H,155DH		;44	'
        WORD    155CH,1550H,155CH,1560H		;45	'
        WORD    1551H,1552H,1561H,1562H		;46	'
        WORD    1553H,1554H,1563H,1564H		;47	'
        WORD    1555H,155DH,1565H,155DH		;48	'
        WORD    155CH,1570H,155CH,1546H		;49	'
        WORD	1571H,1572H,1547H,1548H		;4A	'
        WORD	1573H,1574H,1549H,154AH		;4B	'
        WORD	1575H,155DH,154BH,155DH		;4C	'
        WORD	155CH,1556H,155CH,1566H		;4D	'
        WORD	1557H,1558H,1567H,1568H		;4E	'
        WORD	1559H,155AH,1569H,156AH		;4F	'
;
        WORD	155BH,155DH,156BH,155DH		;50	'
        WORD	155CH,1576H,155EH,156CH		;51	'
	WORD	1577H,1578H,156CH,156CH		;52	'
	WORD	1579H,157AH,156CH,156CH		;53	'
	WORD	157BH,155DH,156CH,156DH		;54	'
	WORD	1504H,1505H,1504H,1505H		;55	'
	WORD	1506H,1534H,1506H,1534H		;56	'
	WORD	1534H,1529H,1534H,1519H		;57	'
	WORD	152AH,152BH,151AH,151BH		;58	'
	WORD	152CH,1538H,151CH,1538H		;59	'
	WORD	1534H,1519H,1534H,1519H		;5A	'
	WORD	151AH,151BH,151AH,151BH		;5B	'
	WORD	151CH,1538H,151CH,1538H		;5C	'
	WORD	1534H,1509H,1534H,1519H		;5D	'
	WORD	150AH,150BH,151AH,151BH		;5E	'
	WORD	0024H,0024H,0024H,0024H
;	WORD	150CH,1538H,151CH,1538H		;5F	'
;
	WORD	01534H,01534H,01534H,01534H	;00
	WORD	01534H,01536H,01534H,01536H	;01
	WORD	01537H,01538H,01537H,01528H	;02
	WORD	01534H,01D09H,01534H,01534H	;03
	WORD	01D09H,01D0AH,01D19H,01D1AH	;04
	WORD	01D0BH,01D0CH,01D1BH,01D1CH	;05
	WORD	05D0CH,05D0BH,05D1CH,05D1BH	;06
	WORD	01534H,01D8DH,01D9CH,01D9DH	;07
	WORD	01DACH,01DADH,01DBCH,01DBDH	;08
	WORD	01D8CH,01D8EH,01DBBH,01D9EH	;09
	WORD	05DADH,05DACH,05DBDH,05DBCH	;0A
	WORD	0550AH,05509H,0551AH,05519H	;0B
	WORD	01500H,01501H,01510H,01511H	;0C
	WORD	01DBBH,01DBCH,01D34H,01D88H	;0D
	WORD	01DBDH,01DBCH,01D89H,01D8CH	;0E
	WORD	01DBDH,01DBCH,01D8DH,05D89H	;0F
;
	WORD	01534H,01534H,01534H,015CEH	;70
	WORD	015ECH,015EDH,015FCH,015FDH	;71
	WORD	015EEH,015EFH,015FEH,015FFH	;72
	WORD	01534H,01534H,015CFH,01534H	;73
	WORD	015CEH,015CFH,01534H,015DEH	;74
	WORD	015D8H,015D9H,015C9H,015FDH	;75
	WORD	015C1H,015C2H,015FEH,015DFH	;76
	WORD	015CEH,015CFH,015DEH,01534H	;77
	WORD	015CEH,015CFH,01534H,015DEH	;78
	WORD	015D8H,015D9H,0156EH,015FDH	;79
	WORD	015C1H,015C2H,015FEH,0156FH	;7A
	WORD	015CEH,015CFH,015DEH,01534H	;7B
	WORD	015CEH,015CFH,01534H,01534H	;7C
	WORD	015CEH,015CFH,01534H,01534H	;7D
	WORD	01D34H,01DA8H,01D34H,01DA8H	;
	WORD	01DA9H,01D8AH,01DB9H,01DB9H	;
;
	WORD	01534H,015DEH,015CEH,015CFH	;20
	WORD	015C9H,015FDH,015D8H,015D9H	;21
	WORD	015FEH,015DFH,015C1H,015C2H	;22
	WORD	015DEH,01534H,015CEH,015CFH	;23
	WORD	01D1DH,01D1EH,01D2DH,01D2EH	;
	WORD	01D1FH,01D29H,01D2FH,01D39H	;
	WORD	01537H,01538H,01537H,01538H	;
	WORD	01534H,015DEH,01534H,01534H	;27
	WORD	0156EH,015FDH,01534H,01534H	;28
	WORD	015FEH,0156FH,01534H,01534H	;29
	WORD	015DEH,01534H,01534H,01534H	;2A
	WORD	01D3FH,01D2AH,01D25H,01D3AH	;
	WORD	01534H,09526H,09524H,09516H	;
	WORD	09527H,01538H,09517H,09518H	;
	WORD	01D80H,01D81H,01D90H,01D91H	;
	WORD	01D82H,01D83H,01D92H,01D93H	;
;
;
	WORD	01DBDH,01DBEH,01D88H,01D34H	;10
	WORD	01DB0H,01DB1H,01DB2H,01D2BH	;11
	WORD	01520H,01521H,01530H,01531H	;12
	WORD	01502H,01503H,01512H,01513H	;13
	WORD	05DB1H,05DB0H,01D2CH,05DB2H	;14
	WORD	01534H,01D34H,01534H,01D34H	;15
	WORD	01D34H,01D98H,01D34H,01DA8H	;16
	WORD	01D89H,01D8AH,01D99H,01D9AH	;17
	WORD	01D8BH,05D89H,01D9BH,05D99H	;18
	WORD	01D9CH,01D34H,01DACH,01D34H	;19
	WORD	01524H,01516H,01534H,01526H	;1A
	WORD	01517H,01518H,01527H,01528H	;1B
	WORD	01DB3H,01D3BH,01D34H,01D8EH	;1C
	WORD	01D3CH,05DB3H,01D8FH,01D34H	;1D
	WORD	01D34H,01DA8H,01D34H,01DA8H	;1E
	WORD	01DA9H,01D8AH,01DB9H,01DB9H	;1F
;
	WORD	01D8BH,05DA9H,01DB9H,01DBAH	;20
	WORD	01DACH,01D34H,01DACH,01D34H	;21
	WORD	01534H,01534H,01D0DH,01D0EH	;22
	WORD	01534H,01534H,01D0FH,01534H	;23
	WORD	01D1DH,01D1EH,01D2DH,01D2EH	;24
	WORD	01D1FH,01D29H,01D2FH,01D39H	;25
	WORD	01537H,01538H,01537H,01538H	;26
	WORD	01D34H,01DA8H,01D34H,01DB8H	;27
	WORD	01D8BH,05DA9H,01DB9H,01DB9H	;28
	WORD	01DACH,01D34H,01DBAH,01D34H	;29
	WORD	01D3DH,01D3EH,01534H,01D15H	;2A
	WORD	01D3FH,01D2AH,01D25H,01D3AH	;2B
	WORD	01534H,09526H,09524H,09516H	;2C
	WORD	09527H,01538H,09517H,09518H	;2D
	WORD	01D80H,01D81H,01D90H,01D91H	;2E
	WORD	01D82H,01D83H,01D92H,01D93H	;2F
;
	WORD	01532H,01522H,01510H,01511H	;30
	WORD	01522H,01523H,01510H,01511H	;31
	WORD	01533H,01500H,01510H,01511H	;32
	WORD	01DA0H,01DA1H,01510H,01511H	;33
	WORD	01DA2H,01DA3H,01510H,01511H	;34
	WORD	01533H,01534H,01510H,01511H	;35
	WORD	01585H,01587H,01595H,01597H	;36
	WORD	01584H,01586H,01594H,01596H	;37
	WORD	01585H,01586H,01595H,01596H	;38
	WORD	01584H,01587H,01594H,01597H	;39
	WORD	01584H,01585H,01594H,01595H	;3A
	WORD	01586H,01585H,01596H,01595H	;3B
	WORD	015A6H,015A7H,015B6H,015B7H	;3C
	WORD	01594H,015A6H,015B4H,015B6H	;3D
	WORD	015A6H,015A6H,015B6H,015B6H	;3E
	WORD	01594H,015A7H,015B4H,015B7H	;3F
;
CHIUNT	EQU	$
	WORD	01024H,01024H,01024H,01024H	;1D
	WORD	0150EH,0150FH,0151EH,0151FH	;01
	WORD	01D02H,01D03H,01D12H,01D13H	;02
	WORD	01D20H,01D21H,01D30H,01D31H	;03
	WORD	0152EH,0152FH,0153EH,0153FH	;04
	WORD	01D22H,01D23H,01D32H,01D33H	;05
	WORD	01D20H,01D21H,0151CH,0151DH	;06
	WORD	01528H,01529H,01D10H,01D11H	;07
	WORD	0152AH,0152BH,01D12H,01D13H	;08
	WORD	0156CH,0156DH,0157CH,0157DH	;09
	WORD	0154EH,0154FH,0155EH,0155FH	;0A
	WORD	0156EH,0156FH,0157EH,0157FH	;0B
	WORD	01D48H,01D49H,01D58H,01D59H	;0C
	WORD	01D4AH,01D4BH,01D5AH,01D5BH	;0D
	WORD	0150CH,0150DH,0151CH,0151DH	;0E
	WORD	01D68H,01D69H,01D78H,01D79H	;0F
;
	WORD	01D6AH,01D6BH,01D7AH,01D7BH	;10
	WORD	01528H,01529H,01538H,01539H	;11
	WORD	0152AH,0152BH,0153AH,0153BH	;12
	WORD	01508H,01509H,01518H,01519H	;13
	WORD	0150AH,0150BH,0151AH,0151BH	;14
	WORD	01D06H,01D07H,01D16H,01517H	;15
	WORD	01504H,01D05H,01D14H,01D15H	;16
	WORD	01D06H,01D03H,01D16H,01D13H	;17
	WORD	01D26H,01D27H,01D36H,01D37H	;18
	WORD	01D24H,01D25H,01D34H,01D35H	;19
	WORD	01D26H,01D23H,01D36H,01D33H	;1A
	WORD	0152CH,0152DH,0153CH,0153DH	;1B
	WORD	0153DH,0153CH,0153CH,0153DH	;1C
	WORD	01D00H,01D01H,01D10H,01D11H	;00
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
B2CSDT	EQU	$
	WORD	CORS00-BG2DAT	;5-2W,6-2W
	WORD	CORS01-BG2DAT	;2-2W,7-2W
	WORD	CORS02-BG2DAT	;8-4W
	WORD	CORS03-BG2DAT	;3-3
	WORD	CORS04-BG2DAT	;8-3
	WORD	CORS05-BG2DAT	;4-1
	WORD	CORS06-BG2DAT	;6-2
	WORD	CORS07-BG2DAT	;3-1
	WORD	CORS08-BG2DAT	;1-1
	WORD	CORS09-BG2DAT	;1-3,5-3
	WORD	CORS0A-BG2DAT	;2-3
	WORD	CORS0B-BG2DAT	;2-1
	WORD	CORS0C-BG2DAT	;DUMMY
	WORD	CORS0D-BG2DAT	;5-1
	WORD	CORS0E-BG2DAT	;2-1S,5-2S
	WORD	CORS0F-BG2DAT	;4-3
	WORD	CORS10-BG2DAT	;6-3
	WORD	CORS11-BG2DAT	;6-1
	WORD	CORS12-BG2DAT	;4-2S
	WORD	CORS13-BG2DAT	;8-1
	WORD	CORS14-BG2DAT	;5-2
	WORD	CORS15-BG2DAT	;8-2
	WORD	CORS16-BG2DAT	;7-1
	WORD	CORS17-BG2DAT	;3-1S,6-2S
	WORD	CORS18-BG2DAT	;2-2
	WORD	CORS19-BG2DAT	;1-2
	WORD	CORS1A-BG2DAT	;4-2
	WORD	CORS1B-BG2DAT	;BONUS
	WORD	CORS1C-BG2DAT	;1-4,6-4
	WORD	CORS1D-BG2DAT	;4-4
	WORD	CORS1E-BG2DAT	;2-4,5-4
	WORD	CORS1F-BG2DAT	;3-4
	WORD	CORS20-BG2DAT	;7-4
	WORD	CORS21-BG2DAT	;8-4
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
GRNDDT	EQU	$
TYMDT1	EQU	$
	HEX	FE
	HEX	00,B9,B8,B6,FE
	HEX	00,BE,C3,C6,FE
	HEX	B4,B1,BC,BD,B0,B5,FE
	HEX	C0,C1,C0,C1,C0,C4,FE
	HEX	B2,B3,B2,B3,B2,B3,B6,FE
	HEX	C2,C3,C2,C3,C2,C3,C6,FE
	HEX	C2,C3,C2,C3,C2,C3,C6,FF
;
TYMDT2	EQU	$
	HEX	FE,B9,B8,FE,BE,C3,FE,BE,C3,FF
;
TYMDT3	EQU	$
	HEX	FE
	HEX	00,00,BA,B0,B5,FE
	HEX	00,BF,C1,C0,C4,FE
	HEX	00,B9,B3,B2,B3,B6,FE
	HEX	00,BE,C3,C2,C3,C6,FE
	HEX	00,BA,BC,BD,BC,BD,B0,B5,FE
	HEX	BF,C1,C0,C1,C0,C1,C0,C4,FE
	HEX	B9,B3,B2,B3,B2,B3,B2,B3,FE
	HEX	BE,C3,C2,C3,C2,C3,C2,C3,FE
	HEX	BE,C3,C2,C3,C2,C3,C2,C3,FF
;
TYMDT4	EQU	$
	HEX	FE
	HEX	00,00,00,00,C7,FE
	HEX	00,00,00,BF,C4,FE
	HEX	00,00,00,B9,B3,B6,00,B9,B8,BB,B8,B6,FE
	HEX	00,00,00,BE,C3,C6,00,BE,C3,C2,C3,C6,FE
	HEX	00,00,B4,B1,BC,BD,B0,B1,BC,BD,BC,BD,B0,B5,FE
	HEX	00,00,C0,C1,C0,C1,C0,C1,C0,C1,C0,C1,C0,C4,FE
	HEX	B9,B8,B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,FE
	HEX	BE,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,FE
	HEX	BE,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,FF
;
TYMDT5	EQU	$
	HEX	FE
	HEX	00,00,00,00,C7,FE
	HEX	00,00,00,BF,C4,FE
	HEX	00,B9,B8,BB,B3,BB,B8,B6,FE
	HEX	00,BE,C3,C2,C3,C2,C3,C6,FE
	HEX	B4,B1,BC,BD,BC,BD,BC,BD,B0,B5,FE
	HEX	C0,C1,C0,C1,C0,C1,C0,C1,C0,C4,FE
	HEX	B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,FE
	HEX	C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,FE
	HEX	C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,FF
;
TYMDT6	EQU	$
	HEX	FE,B6,FE,C6,FE,C6,FF
;
TYMDT7	EQU	$
	HEX	FE,B4,B1,FE,C0,C1,FE,B2,B3,FE,C2,C3,FE,C2,C3,FF
;
TYMDT8	EQU	$
	HEX	FE
	HEX	00,00,00,00,00,B9,B8,B6,FE
	HEX	00,00,00,00,00,BE,C3,C6,FE
	HEX	00,00,00,00,B4,B1,BC,BD,B0,B5,FE
	HEX	00,00,00,00,C0,C1,C0,C1,C0,C4,FE
	HEX	B9,B8,BB,B8,B2,B3,B2,B3,B2,B3,FE
	HEX	BE,C3,C2,C3,C2,C3,C2,C3,C2,C3,FE
	HEX	BE,C3,C2,C3,C2,C3,C2,C3,C2,C3,FF
;
TYMDT9	EQU	$
	HEX	FE
	HEX	00,00,00,00,C7,00,C7,FE
	HEX	00,00,00,BF,C4,BF,C4,FE
	HEX	00,B9,B8,BB,B3,BB,B3,B6,FE
	HEX	00,BE,C3,C2,C3,C2,C3,C6,FE
	HEX	B4,B1,BC,BD,BC,BD,BC,BD,B0,B5,FE
	HEX	C0,C1,C0,C1,C0,C1,C0,C1,C0,C4,FE
	HEX	B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,FE
	HEX	C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,FE
	HEX	C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,FF
;
TYMDTA	EQU	$
	HEX	FE
	HEX	00,00,BA,B0,B5,00,00,00,C7,FE
	HEX	00,BF,C1,C0,C4,00,00,BF,C4,FE
	HEX	00,B9,B3,B2,B3,B6,00,B9,B3,BB,B8,B6,FE
	HEX	00,BE,C3,C2,C3,C6,00,BE,C3,C2,C3,C6,FE
	HEX	B4,B1,BC,BD,BC,BD,B0,B1,BC,BD,BC,BD,B0,B1,B0,B5,FE
	HEX	C0,C1,C0,C1,C0,C1,C0,C1,C0,C1,C0,C1,C0,C1,C0,C4,FE
	HEX	B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,B6,FE
	HEX	C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C6,FE
	HEX	C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C6,FF
;
TYMDTB	EQU	$
	HEX	FE
	HEX	00,00,00,00,C7,FE
	HEX	00,00,00,BF,C4,FE
	HEX	00,B9,B8,BB,B3,B6,FE
	HEX	00,BE,C3,C2,C3,C6,FE
	HEX	B4,B1,BC,BD,BC,BD,B0,B5,FE
	HEX	C0,C1,C0,C1,C0,C1,C0,C4,FE
	HEX	B2,B3,B2,B3,B2,B3,B2,B3,FE
	HEX	C2,C3,C2,C3,C2,C3,C2,C3,FE
	HEX	C2,C3,C2,C3,C2,C3,C2,C3,FF
;
TYMDTC	EQU	$
	HEX	FE
	HEX	B4,B1,B0,B5,FE
	HEX	C0,C1,C0,C8,FE
	HEX	B2,B3,B2,B3,B6,FE
	HEX	C2,C3,C2,C3,C6,FE
	HEX	C2,C3,C2,C3,C6,FF
;
TYMDTD	EQU	$
	HEX	FE
	HEX	00,00,00,00,00,B4,B5,00,C7,B4,B5,FE
	HEX	00,00,00,00,00,C0,C8,BF,C8,C0,C8,FE
	HEX	00,00,00,B9,B8,B2,B3,BB,B3,B2,B3,B6,FE
	HEX	00,00,00,BE,C3,C2,C3,C2,C3,C2,C3,C6,FE
	HEX	00,BA,B0,B1,BC,BD,BC,BD,BC,BD,BC,BD,B0,B5,FE
	HEX	BF,C1,C0,C1,C0,C1,C0,C1,C0,C1,C0,C1,C0,C4,FE
	HEX	B9,B3,B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,BB,B8,B6,FE
	HEX	BE,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C6,FE
	HEX	BE,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C6,FF
;
TYMDTE	EQU	$
	HEX	FE
	HEX	00,00,B4,B1,B0,B5,FE
	HEX	00,00,C0,C1,C0,C4,FE
	HEX	BB,B8,B2,B3,B2,B3,B6,FE
	HEX	C2,C3,C2,C3,C2,C3,C6,FE
	HEX	C2,C3,C2,C3,C2,C3,C6,FF
;
TYMDTF	EQU	$
        HEX     FE
        HEX     00,00,00,00,00,00,00,C7,FE
        HEX     00,00,00,00,00,00,BF,C4,FE
        HEX     00,00,B9,B8,B6,00,B9,B3,BB,B8,B6,FE
        HEX     00,00,BE,C3,C6,00,BE,C3,C2,C3,C6,FE
        HEX     00,00,BA,BC,BD,B0,B1,BC,BD,BC,BD,B0,B5,FE
        HEX     00,BF,C1,C0,C1,C0,C1,C0,C1,C0,C1,C0,C4,FE
        HEX     00,B9,B3,B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,B6,FE
        HEX     00,BE,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C6,FE
        HEX     B4,B1,BC,BD,BC,BD,BC,BD,BC,BD,BC,BD,BC,BD,B0,B5,FE
        HEX     C0,C1,C0,C1,C0,C1,C0,C1,C0,C1,C0,C1,C0,C1,C0,C4,FE
        HEX     B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,B2,B3,B6,FE
        HEX     C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C6,FE
        HEX     C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C2,C3,C6,FF
;
YAMA	EQU	$
	HEX	03,04,05,FE
	HEX	12,13,16,06,07,FE
	HEX	12,13,16,16,16,17,18,FE
	HEX	12,13,16,16,16,16,08,09,18,FE
	HEX	12,13,16,16,16,16,16,16,19,1A,18,FE
	HEX	12,13,16,16,16,16,16,16,16,16,0A,1C,18,FE
	HEX	12,13,16,16,16,16,16,16,16,16,16,08,1B,1C,18,FE
	HEX	12,13,16,16,16,16,16,16,16,16,16,16,16,19,0C,0B,18,FE
	HEX	12,13,16,16,16,16,16,16,16,16,16,16,16,16,16,0A,1C,0B,18,FE
	HEX	12,13,16,16,16,16,16,16,16,16,16,16,16,16,16,16,08,1B,1C,0B,18,FE
	HEX	12,13,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,19,1C,1C,0B,18,FF
;
YWDDT1	EQU	$
	HEX	FE
	HEX	13,24,FE
	HEX	FE
	HEX	13,23,16,16,16,16,32,FF
;
YWDDT2	EQU	$
	HEX	FE
	HEX	13,27,FE
	HEX	13,2C,2D,26,FE
	HEX	13,20,2E,2F,FE
	HEX	13,16,16,16,16,16,24,FE
	HEX	13,16,16,16,16,16,16,16,16,0A,32,FF
;
YWDDT3	EQU	$
	HEX	FE
	HEX	13,23,FE
	HEX	13,20,FF
;
YWDDT4	EQU	$
	HEX	FE
	HEX	13,24,FE
	HEX	FE
	HEX	13,27,16,16,26,FE
	HEX	FF
;
YWDDT5	EQU	$
	HEX	FE,FE
	HEX	13,24,FE
	HEX	13,16,16,16,2B,FE
	HEX	FE
	HEX	13,16,16,16,25,16,16,16,26,FE
	HEX	13,16,23,16,24,16,16,16,24,FE
	HEX	13,16,20,16,16,16,16,16,27,FF
;
YWDDT6	EQU	$
	HEX	FE
	HEX	13,24,FE
	HEX	13,16,16,25,FE
	HEX	13,26,FE
	HEX	13,16,16,16,24,16,27,FE
	HEX	13,16,16,16,16,16,2C,2D,16,0A,32,FF
;
YWDDT7	EQU	$
	HEX	FE,FE
	HEX	13,16,16,25,FE
	HEX	13,16,16,27,FE
	HEX	13,16,16,16,16,2C,2D,FE
	HEX	13,24,23,16,16,16,2E,2F,16,0A,32,FE
	HEX	13,16,16,16,16,16,16,16,16,16,08,1B,33,FE
	HEX	13,16,16,16,16,28,20,22,FE
	HEX	13,16,16,16,16,16,29,2A,16,16,16,16,26,21,0A,30,FE
	HEX	13,16,16,16,16,16,16,16,16,16,16,16,16,16,20,FF
;
SH2DAT	EQU	$
S2UNT0	EQU	$
	HEX	1A,1B,FE,01,02,FE,01,02,FE,01,02,FE,01,02,FE
	HEX	01,02,FE,01,02,FE,01,26,FE,2C,2D,FE,30,31,32,FF
;
S2UNT2	EQU	$
	HEX	04,05,06,07,FE
	HEX	0D,0E,0F,10,FE
	HEX	16,17,18,19,FE
	HEX	1E,1F,20,21,FE
	HEX	1E,17,18,21,FE
	HEX	27,1F,28,29,FF
;
S2UNT4	EQU	$
	HEX	FE,11,14,FE,1C,1D,FF
;
S2UNT6	EQU	$
	HEX	FE,22,23,FE,24,25,FE,2A,2B,FE,2E,2F,FE,33,34,FF
;
S2UNT8	EQU	$
	HEX	FE
	HEX	41,42,43,44,FE
	HEX	45,46,47,48,FE
	HEX	49,4A,4B,4C,FE
	HEX	4D,4E,4F,50,FE
	HEX	51,52,53,54,FF
;
S2UNTA	EQU	$
	HEX	FE
	HEX	0C,0C,0C,0C,0C,0C,0C,0C,0C,0C,0C,0C,0C,0C,0C,0C,FE
	HEX	12,13,12,13,12,13,12,13,12,13,12,13,12,13,12,13,FE
	HEX	36,37,38,36,39,3A,3B,3B,36,3A,3B,3B,3B,36,3A,38,FE
	HEX	3C,3D,3E,3C,3F,3D,3E,3E,3C,3D,3E,3E,3E,3C,3D,3E,FF
;
S2UNTC	EQU	$
	HEX	22,23,FE,24,25,FE,2A,2B,FE,33,34,FF
;;;;
S83DAT	EQU	$
S8UNT0	EQU	$
	HEX	08,FE
	HEX	0C,FF
;
S8UNT5	EQU	$
	HEX	14,15,16,17,FE
	HEX	1D,1E,1F,20,FE
	HEX	1D,1E,1F,20,FE
	HEX	1D,2A,2B,20,FF
;
S8UNT6	EQU	$
	HEX	18,19,1A,1B,FE
	HEX	21,22,23,24,FE
	HEX	21,22,23,24,FE
	HEX	21,22,23,24,FF
;
S8UNT7	EQU	$
	HEX	00,00,00,00,01,02,FE
	HEX	00,00,01,03,05,06,04,02,FE
	HEX	01,03,05,09,09,09,09,06,04,02,FE
	HEX	05,09,09,09,09,09,09,09,09,06,FF
;
S8UNT8	EQU	$
	HEX	01,03,04,03,04,02,FE
	HEX	07,08,09,09,08,0A,FE
	HEX	0B,0C,09,09,0C,0D,0E,FE
	HEX	11,09,09,09,09,12,13,FE
	HEX	11,18,19,1A,1B,12,13,FE
	HEX	11,21,22,23,24,12,13,FE
	HEX	11,21,22,23,24,12,13,FE
	HEX	11,21,22,23,24,12,13,FF
;
S8UNT9	EQU	$
	HEX	02,10,10,10,10,10,10,10,10,10,10,10,10,10,10,01,FE
	HEX	35,04,03,04,03,04,03,04,03,04,03,04,03,04,03,36,FF
;
SHWDAT	EQU	$
SHWDT0	EQU	$
	HEX	00,00,00,00,00,00,00,07,01,02,03,04,01,02,03,04
	HEX	00,00,00,00,00,00,10,11,0A,0B,0C,0D,0A,0B,0C,0D
	HEX	00,00,17,18,00,00,19,15,16,12,14,15,16,12,14,15
	HEX	23,24,25,22,23,24,25,1F,20,21,1E,1F,20,21,1E,1F,FF
;
SHWDT1	EQU	$
	HEX	08,09,03,04,05,06,00,00,00,00,00,07,08,09,03,04
	HEX	0A,0B,0C,0D,0E,0F,00,00,00,00,10,11,0A,0B,0C,0D
	HEX	16,12,14,15,16,12,17,18,00,00,19,15,16,12,14,15
	HEX	20,21,1E,1F,20,21,1E,22,23,24,25,1F,20,21,1E,26,FF
;
SHWDT2	EQU	$
	HEX	01,02,03,04,08,09,03,04,05,06,00,07,08,09,03,29
	HEX	0A,0B,0C,0D,0A,0B,0C,0D,0E,0F,10,11,0A,0B,0C,0D
	HEX	0A,12,13,0D,0A,12,14,15,16,12,14,15,16,12,14,15
	HEX	1A,1B,1C,1D,1A,1B,1E,1F,20,21,1E,1F,20,21,1E,1F,FF
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
BG2DAT	EQU	$
;
;********************************
;*	CORS00	5-2W 6-2W	*
;********************************
CORS00	EQU	$
	WORD	0E091H		;NAMI ON
	WORD	0E070H		;WATER BETA SET
	WORD	0E048H		;CHR 8
	WORD	0E020H		;WATER SET
;				;00
	WORD	06900H,08163H,08970H,09180H,09510H,09920H,09D30H,0A193H,0B1A0H,0B572H
;				;01
	WORD	0E000H
	WORD	081B0H,085D0H,08962H,09580H,0A1C0H,0A593H,0B5A0H,0B961H,06830H,07010H,09830H
;
	WORD	0E3F0H		;END CODE
;
;********************************
;*	CORS01	2-2W 7-2W	*
;********************************
CORS01	EQU	$
	WORD	0E091H		;NAMI ON
	WORD	0E070H		;WATER BETA SET
	WORD	0E048H		;CHR 8
	WORD	0E020H		;WATER SET
;				;00
	WORD	06900H,08163H,08970H,09180H,09510H,09920H,09D30H,0A193H,0B1A0H,0B572H
;				;01
	WORD	0E000H
	WORD	081B0H,085D0H,08962H,09580H,0A1C0H,0A593H,0B5A0H,0B961H,06830H,07010H,09830H
;				;01
	WORD	0E000H
	WORD	06910H,06D21H,07530H,079B0H,07DD0H,081B0H,085D0H,08973H,099C0H,09D90H
	WORD	0A1C0H,0A596H,05C30H
;				;01
	WORD	0E000H
	WORD	06160H,06580H,06910H,06D22H,07930H,08190H,085A0H,08974H,09D60H
	WORD	0A197H,04010H
;				;01
	WORD	0E000H
	WORD	08160H,08580H,09940H,09D50H,0A190H,0A5A0H,0A980H,0B5B0H,0B9F0H,0BD70H
	WORD	06010H,0AC10H
;				;01
	WORD	0E000H
	WORD	08207H,0A177H
;				;01
	WORD	0E000H
	WORD	08207H,0A177H
;
	WORD	0E3F0H		;END CODE
;
;********************************
;*	CORS02	8-4W		*
;********************************
CORS02	EQU	$
	WORD	0E091H		;NAMI ON
	WORD	0E04FH		;BGWFLG F
	WORD	0E020H		;WATER SET
;
	WORD	08000H
;
	WORD	0E000H
	WORD	08001H
;
	WORD	0E000H
	WORD	08002H
	WORD	0E3F0H
;
;********************************
;*	CORS03	3-3		*
;********************************
CORS03	EQU	$
	WORD	0E04BH
	WORD	0E011H	;NIGHT GRADUATION
;						;00
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
;						;01
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
;						;02
	WORD	0E000H
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
;						;03
	WORD	0E000H
	WORD	0030H,1831H,2020H,2432H,2C1BH,3023H,3833H,4034H,4835H,5436H,5837H,5C38H
	WORD	6439H,683AH,6C3BH,703CH,743DH,783EH,943FH
;						;04
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
;						;05
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
;
	WORD	0E3F0H
;
;********************************
;*	CORS04	8-3		*
;********************************
CORS04	EQU	$
	WORD	0E091H
	WORD	0E010H		;HIRU GRADUATION
	WORD	0E04CH		;BGWFLG C
;
	WORD	0E080H		;SHIRO KABE SET
	WORD	0A010H,0A420H,0B010H,0B420H,0BC10H,0A850H
;
	WORD	0E000H
	WORD	0A020H,0A810H,0AC20H,0B810H,0BC20H
	WORD	0B050H,04870H
;
	WORD	0E000H
	WORD	0A020H,0A810H,0AC20H,0B410H,0B820H
	WORD	07C80H
;
	WORD	0E000H
	WORD	0AC10H,0B020H,0B810H,0BC20H
;
	WORD	0E000H
	WORD	0A410H,0A820H,0B010H,0B420H
	WORD	0BC50H,09090H
;
	WORD	0E000H
	WORD	0A810H,0AC20H,0B410H,0B820H
;
	WORD	0E000H
	WORD	0A010H,0A420H,0B010H,0B420H,0BC10H
	WORD	0A860H
;
	WORD	0E000H
	WORD	0A020H,0AC10H,0B020H,0B810H,0BC20H
	WORD	0A460H
;
	WORD	0E3F0H
;
;********************************
;*	CORS05	4-1		*
;********************************
CORS05	EQU	$
	WORD	0E091H
	WORD	0E042H		;CHR 2
	WORD	0E010H		;GRADUATION ON
;				;00
	WORD	0B050H,0B080H
;				;01
	WORD	0E000H
	WORD	06C70H,06C90H,0A0F3H
;				;02
	WORD	0E000H
	WORD	07460H,074B0H,0AC40H,0ACA0H
;				;03
	WORD	0E000H
	WORD	08060H,080B0H,0A4F9H
;				;04
	WORD	0E000H
;				;05
	WORD	0E000H
	WORD	09060H,04060H,040C0H,0B4F2H
;				;06
	WORD	0E000H
	WORD	03870H,038E0H,0A4F4H  
;
;not;	WORD	0E030H		;GRAND ON
;
	WORD	0E3F0H		;END CODE
;
;********************************
;*	CORS06	6-2		*
;********************************
CORS06	EQU	$
	WORD	0E011H	;NIGHT GRADUATION
	WORD	0E04BH	;BGWFLG B
	WORD	0E031H
;						;00
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;01
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;02
	WORD	0E000H
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;03
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;04
	WORD	0E000H
	WORD	0030H,1831H,2020H,2432H,2C1BH,3023H,3833H,4034H,4835H,5436H,5837H,5C38H
	WORD	6439H,683AH,6C3BH,703CH,743DH,783EH,943FH
	WORD	8107H,8911H,9910H
;						;05
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;06
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;07
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;08
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;09
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;
	WORD	0E3F0H
;
;********************************
;*	CORS07	3-1		*
;********************************
CORS07	EQU	$
	WORD	0E011H	;NIGHT GRADUATION
	WORD	0E047H	;BGWFLG 7
	WORD	0E031H
;						;00
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;01
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;02
	WORD	0E000H
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;03
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;04
	WORD	0E000H
	WORD	0030H,1831H,2020H,2432H,2C1BH,3023H,3833H,4034H,4835H,5436H,5837H,5C38H
	WORD	6439H,683AH,6C3BH,703CH,743DH,783EH,943FH
	WORD	8107H,8911H,9910H
;						;05
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;06
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;07
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;08
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;09
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;
	WORD	0E3F0H
;
;********************************
;*	CORS08	1-1		*
;********************************
CORS08	EQU	$
	WORD	0E091H
	WORD	0E042H
	WORD	0E010H
;				;00
	WORD	0A850H,0A880H
	WORD	0E000H
	WORD	8C60H,08CB0H
;				;01
	WORD	0E000H
	WORD	0A850H,0A880H
;				;02
	WORD	0E000H
	WORD	7070H,7090H,0A850H,0A8B0H,9C70H
;				;03
	WORD	0E000H
;				;04
	WORD	0E000H
	WORD	0A840H,0A8A0H
;				;05
	WORD	0E000H
	WORD	2470H,24E0H
;
;not;	WORD	0E030H
;
	WORD	0E3F0H		;END CODE
;
;********************************
;*	CORS09	1-3 5-3		*
;********************************
CORS09	EQU	$
	WORD	0E091H	;KUMO ON
	WORD	0E04EH	;BGWFLG E
	WORD	0E010H	;GRA HIRU
	WORD	0E0A0H	;IWA BETA
	WORD	0A803H,0BC00H
;
	WORD	0E000H
	WORD	0A802H
;
	WORD	0E000H
	WORD	0A400H,0AC01H
;
	WORD	0E000H
	WORD	0A803H
;
	WORD	0E000H
	WORD	0A401H,0AC01H,0BC08H
;
	WORD	0E000H
;
	WORD	0E3F0H
;
;********************************
;*	CORS0A	2-3		*
;********************************
CORS0A	EQU	$
	WORD	0E091H	;KUNO ON
	WORD	0E010H	;GRA ON
	WORD	0E0B0H	;BGWFLG	10
	WORD	0E0C0H	;SUNA BETA
;
	WORD	09010H
;
	WORD	0E000H
	WORD	08800H,0B010H,0A425H
;
	WORD	0E000H
	WORD	06810H,0B420H,0BC2FH
;
	WORD	0E000H
	WORD	08810H,0B800H
;
	WORD	0E000H
	WORD	0A800H,09810H,0A420H
;
	WORD	0E000H
	WORD	06800H,0A420H,0B420H,0BC2FH
;
	WORD	0E000H
	WORD	06810H,0BC20H
;
	WORD	0E000H
;
	WORD	0E3F0H
;
;********************************
;*	CORS0B	2-1		*
;********************************
CORS0B	EQU	$
	WORD	0E091H
	WORD	0E010H	;GRADUATION HIRU
	WORD	0E045H	;BGWFLG 5
;					;00
	WORD	0A410H,6800H,5C20H
;					;01
	WORD	0E000H
	WORD	6C00H
;					;02
	WORD	0E000H
	WORD	4030H,5C40H
;					;03
	WORD	0E000H
	WORD	5020H,9060H
;					;04
	WORD	0E000H
	WORD	0A050H,8420H,7870H
;					;05
	WORD	0E000H
	WORD	4C80H
;					;06
	WORD	0E000H
	WORD	4090H
;
;not;	WORD	0E034H	;YUKA ON
	WORD	0E3F0H
;
;********************************
;*	CORS0C	DEMO(1-2 2-2)  	*
;********************************
CORS0C	EQU	$
	WORD	0E091H
	WORD	0E042H
	WORD	0E010H
;
	WORD	2470H,24E0H
;
;not;	WORD	0E030H
;
	WORD	0E3F0H
;
;********************************
;*	CORS0D	5-1		*
;********************************
CORS0D	EQU	$
	WORD	0E091H
	WORD	0E045H		;BGWFLG 5
	WORD	0E010H		;HIRU GRADUATION
;				;00
	WORD	08820H,0B810H,07C00H
;				;01
	WORD	0E000H
	WORD	05890H,048A0H
;				;02
	WORD	0E000H
	WORD	098B0H
;				;03
	WORD	0E000H
	WORD	0A410H,06800H,05CC0H
;				;04
	WORD	0E000H
;				05
	WORD	0E000H
	WORD	0A010H
	WORD	06400H,090D0H
	WORD	0E000H
	WORD	08820H,0B810H,07C00H
;not;	WORD	0E035H		;YUKA ON
	WORD	0E3F0H
;
;********************************
;*	CORS0E	2-1S 5-2S	*
;********************************
CORS0E	EQU	$
	WORD	0E010H		;GR OFF
	WORD	0E041H		;CHR 1
	WORD	2800H
	WORD	0E000H
	WORD	0E000H
	WORD	2800H
	WORD	0E3F0H
;
;********************************
;*	CORS0F	4-3		*
;********************************
CORS0F	EQU	$
	WORD	0E091H
	WORD	0E042H
	WORD	0E013H
	WORD	0E04DH	;BGWFLG D
;						;00
	WORD	0A880H,0AC24H,0ACB2H,0D043H,09090H,09436H,0D890H,0DC32H,0BC92H
;						;01
	WORD	0E000H
	WORD	0A064H,0ACA0H,0D003H,094A1H,0B815H
;						;02
	WORD	0E000H
	WORD	0C093H,0C472H,0B081H,0B434H,09082H,09076H
;						;03
	WORD	0E000H
	WORD	0C084H,0C032H,08890H,0ACA3H,0D043H,08C36H
;						;04
	WORD	0E000H
	WORD	080A0H,0A405H,0ACB2H,0D043H,098A3H,0BC45H,07490H,07838H
;						;05
	WORD	0E000H
	WORD	0C480H,0C822H,0B0A0H,0D403H,09482H,09476H
	WORD	0E3F0H
;
;********************************
;*	CORS10	6-3		*
;********************************
CORS10	EQU	$
	WORD	0E04BH
	WORD	0E011H	;NIGHT GRADUATION
;						;00
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
;						;01
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
;						;02
	WORD	0E000H
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
;						;03
	WORD	0E000H
	WORD	0030H,1831H,2020H,2432H,2C1BH,3023H,3833H,4034H,4835H,5436H,5837H,5C38H
	WORD	6439H,683AH,6C3BH,703CH,743DH,783EH,943FH
;						;04
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
;						;05
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
;
	WORD	0E3F0H
;
;********************************
;*	CORS11	6-1		*
;********************************
CORS11	EQU	$
	WORD	0E011H	;NIGHT GRADUATION
	WORD	0E04BH	;BGWFLG B
	WORD	0E031H
;						;00
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;01
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;02
	WORD	0E000H
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;03
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;04
	WORD	0E000H
	WORD	0030H,1831H,2020H,2432H,2C1BH,3023H,3833H,4034H,4835H,5436H,5837H,5C38H
	WORD	6439H,683AH,6C3BH,703CH,743DH,783EH,943FH
	WORD	8107H,8911H,9910H
;						;05
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;06
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;07
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;08
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;09
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;
	WORD	0E3F0H
;
;********************************
;*	CORS12	4-2S		*
;********************************
CORS12	EQU	$
	WORD	0E091H
	WORD	0E013H
	WORD	0E042H
	WORD	0E04DH	;BGWFLG D
;						;00
	WORD	0C080H,0C422H,0B0A0H,0D403H,09482H,09476H
;
        WORD    0E000H
        WORD    080A0H,0A405H;,0ACB2H,0D043H,098A3H,0BC45H,07490H,07838H
;
	WORD	0E3F0H
;
;********************************
;*	CORS13	8-1		*
;********************************
CORS13	EQU	$
	WORD	0E091H
	WORD	0E042H
	WORD	0E010H
;				;00
	WORD	06C70H,06C90H
;				;01
	WORD	0E000H
	WORD	08C60H,08CB0H
;				;02
	WORD	0E000H
	WORD	07470H,07490H,0AC50H,0AC80H
;				;03
	WORD	0E000H
	WORD	08070H,080E0H
;				;04
	WORD	0E000H
	WORD	06070H,060E0H
;				;05
	WORD	0E000H
	WORD	08840H,088D0H,0A060H,0A0B0H
;				;06
	WORD	0E000H
	WORD	05470H,074A0H
;				;07
	WORD	0E000H
	WORD	06070H,060E0H
;				;08
	WORD	0E000H
	WORD	08870H,08890H
;				;09
	WORD	0E000H
	WORD	05070H,05090H
;				;0A
	WORD	0E000H
;				;0B
	WORD	0E000H
	WORD	02870H,028E0H
;				;END
;not;	WORD	0E030H
	WORD	0E3F0H
;
;********************************
;*	CORS14	5-2		*
;********************************
CORS14	EQU	$
	WORD	0E091H
	WORD	0E045H		;BGWFLG 5
	WORD	0E010H		;HIRU GRADUATION
;				;00
	WORD	08820H,0B810H,07C00H
;				;01
	WORD	0E000H
	WORD	05890H,048A0H
;				;02
	WORD	0E000H
	WORD	098B0H
;				;03
	WORD	0E000H
	WORD	0A410H,06800H,05CC0H
;				;04
	WORD	0E000H
;				05
	WORD	0E000H
	WORD	0A010H
	WORD	06400H,090D0H
;
	WORD	0E000H
	WORD	08820H,0B810H,07C00H
;not;	WORD	0E035H		;YUKA ON
	WORD	0E3F0H
;
;********************************
;*	CORS15	8-2		*
;********************************
CORS15	EQU	$
	WORD	0E091H
	WORD	0E010H	;GRADUATION HIRU
	WORD	0E045H	;BGWFLG 5
;				;00
	WORD	08420H,07470H
;				;01
	WORD	0E000H
	WORD	04880H
;				;02
	WORD	05C90H
;				;03
	WORD	0E000H
;				;04
	WORD	0E000H
	WORD	040C0H
;				;05
	WORD	0E000H
	WORD	04090H
;				;06
	WORD	0E000H
	WORD	04830H
	WORD	0E000H,004E0H
;
;not;	WORD	0E035H		;GRAND ON
	WORD	0E3F0H
;
;********************************
;*	CORS16	7-1		*
;********************************
CORS16	EQU	$
	WORD	0E091H
	WORD	0E045H		;BGWFLG 5
	WORD	0E010H		;HIRU GRADUATION
;				;00
	WORD	08820H,0B810H,07C00H
;				;01
	WORD	0E000H
	WORD	05890H,048A0H
;				;02
	WORD	0E000H
	WORD	098B0H
;				;03
	WORD	0E000H
	WORD	0A410H,06800H,05CC0H
;				;04
	WORD	0E000H
;				;05
	WORD	0E000H
	WORD	0A010H
	WORD	06400H,090D0H
;				;06
	WORD	0E000H
	WORD	08820H,0B810H,07C00H
;not;	WORD	0E035H		;YUKA ON
	WORD	0E3F0H
;
;********************************
;*	CORS17	3-1S 6-2S	*
;********************************
CORS17	EQU	$
	WORD	0E011H		;GR OFF
	WORD	0E041H		;CHR 1
	WORD	2800H		;MARIO
	WORD	0E000H
	WORD	2C00H
	WORD	0E3F0H
;
;********************************
;*	CORS18	3-2		*
;********************************
CORS18	EQU	$
	WORD	0E011H	;NIGHT GRADUATION
	WORD	0E047H	;BGWFLG 7
	WORD	0E031H
;						;00
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;01
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;02
	WORD	0E000H
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;03
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;04
	WORD	0E000H
	WORD	0030H,1831H,2020H,2432H,2C1BH,3023H,3833H,4034H,4835H,5436H,5837H,5C38H
	WORD	6439H,683AH,6C3BH,703CH,743DH,783EH,943FH
	WORD	8107H,8911H,9910H
;						;05
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;06
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;07
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;						;08
	WORD	0010H,0C11H,1012H,1C13H,2414H,2815H,3016H,4C16H,5417H,5C18H
	WORD	6019H,641AH,681BH,6C1CH,7816H,801DH,901EH
	WORD	8107H,8510H,9911H
;						;09
	WORD	0E000H
	WORD	181FH,2020H,2421H,2C22H,3023H,3820H,4024H,5025H,5826H,5C27H
	WORD	6428H,6C29H,742AH,782BH,882CH,902DH,982FH
	WORD	8107H,8510H,9910H
;
	WORD	0E3F0H
;
;********************************
;*	CORS19	1-2		*
;********************************
CORS19	EQU	$
	WORD	0E012H
	WORD	0E060H
	WORD	0E050H
	WORD	0E043H
;
	WORD	4510H,6D10H,6100H,1530H,5520H,2900H	;KUSA
	WORD	0A960H,0C970H,0AD82H,0CD92H,0B9A0H,0D9B0H	;GURD
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,1530H,5520H,2900H	;KUSA
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,6100H,1530H,5520H,2900H	;KUSA
	WORD	0A960H,0C970H,0AD82H,0CD92H,0B9A0H,0D9B0H	;GURD
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,1530H,5520H,2900H	;KUSA
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,6100H,1530H,5520H,2900H	;KUSA
	WORD	0A960H,0C970H,0AD82H,0CD92H,0B9A0H,0D9B0H	;GURD
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,1530H,5520H,2900H	;KUSA
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,6100H,1530H,5520H,2900H	;KUSA
	WORD	0A960H,0C970H,0AD82H,0CD92H,0B9A0H,0D9B0H	;GURD
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,1530H,5520H,2900H	;KUSA
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
;not;	WORD	0E032H
	WORD	0E3F0H
;
;********************************
;*	CORS1A	4-2		*
;********************************
CORS1A	EQU	$
	WORD	0E012H
	WORD	0E060H
	WORD	0E050H
	WORD	0E043H
;
	WORD	4510H,6D10H,6100H,1530H,5520H,2900H	;KUSA
	WORD	0A960H,0C970H,0AD82H,0CD92H,0B9A0H,0D9B0H	;GURD
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,1530H,5520H,2900H	;KUSA
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,6100H,1530H,5520H,2900H	;KUSA
	WORD	0A960H,0C970H,0AD82H,0CD92H,0B9A0H,0D9B0H	;GURD
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,1530H,5520H,2900H	;KUSA
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,6100H,1530H,5520H,2900H	;KUSA
	WORD	0A960H,0C970H,0AD82H,0CD92H,0B9A0H,0D9B0H	;GURD
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,1530H,5520H,2900H	;KUSA
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,6100H,1530H,5520H,2900H	;KUSA
	WORD	0A960H,0C970H,0AD82H,0CD92H,0B9A0H,0D9B0H	;GURD
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
	WORD	0E000H			;KAI PAGE
	WORD	4510H,6D10H,1530H,5520H,2900H	;KUSA
	WORD	2D40H,4D50H
	WORD	2007H,0025H,1C15H	;PLOE
;
;not;	WORD	0E032H
	WORD	0E3F0H
;
;********************************
;*	CORS1B	BONUS		*
;********************************
CORS1B	EQU	$
	WORD	0E041H
	WORD	0E012H
;			Bonus 1
	WORD	2800H
	WORD	0E000H
;			Bonus 2
	WORD	2800H
	WORD	0E000H
;			Bonus 3
	WORD	2800H
	WORD	0E000H
;			Bonus 4
	WORD	2800H
	WORD	0E000H
;			Bonus 5
	WORD	2800H
;
	WORD	0E3F0H
;
;********************************
;*	CORS1C	1-4 6-4		*
;********************************
CORS1C	EQU	$
	WORD	0E046H	
	WORD	0E050H						;01
	WORD	0003H,1003H,4019H,5019H,403FH,0826H,1826H
	WORD	0E000H						;03
	WORD	0C03H,4C19H,1C03H,5C19H,403FH,0426H,1426H
	WORD	0E000H						;04
	WORD	0803H,4819H,403AH,0026H,5449H,9C45H,3060H
	WORD	0E000H						;05
	WORD	0C07H,8C13H,1807H,9813H,803FH,0426H,3050H,6060H
	WORD	0E000H						;06
	WORD	2850H,0007H,8013H,1007H,9013H,803FH,5480H
	WORD	0E000H						;06
	WORD	0007H,8013H,1407H,9413H,803FH,4480H
	WORD	0E3F0H
;
;********************************
;*	CORS1D	4-4		*
;********************************
CORS1D	EQU	$
	WORD	0E046H
	WORD	0E050H
;								;01
	WORD	00007H,01007H,06017H,07017H,0603FH,00826H,0B890H
;
	WORD	0E000H						;02
	WORD	00005H,01005H,06017H,07017H,0603FH,00826H,0B4A0H
;
	WORD	0E000H						;03
	WORD	00005H,06017H,06039H,07047H,04860H,0A890H,03850H
;
	WORD	0E000H						;04
	WORD	01005H,07017H,0683BH,06447H,05860H
;
	WORD	0E000H						;05
	WORD	00005H,06017H,01005H,07017H,0603FH,00826H,05860H,0B890H
;
	WORD	0E000H						;06
	WORD	00005H,06017H,01005H,07017H,0603FH,00826H,05480H
;
	WORD	0E000H						;07
	WORD	0603FH,04480H,05080H
;
	WORD	0E3F0H
;
;********************************
;*	CORS1E	2-4 5-4		*
;********************************
CORS1E	EQU	$
	WORD	0E046H	
	WORD	0E050H						;01
	WORD	0003H,1003H,4019H,5019H,403FH,0826H,1826H
	WORD	0E000H						;03
	WORD	0C03H,4C19H,1C03H,5C19H,403FH,0426H,1426H
	WORD	0E000H						;04
	WORD	0803H,4819H,403AH,0026H,5449H,9C45H,3060H
	WORD	0E000H						;05
	WORD	0C07H,8C13H,1807H,9813H,803FH,0426H,3050H,6060H
	WORD	0E000H						;06
	WORD	2850H,0007H,8013H,1007H,9013H,803FH,5480H
	WORD	0E000H						;06
	WORD	0007H,8013H,1407H,9413H,803FH,4480H
	WORD	0E3F0H
;
;********************************
;*	CORS1F	3-4		*
;********************************
CORS1F	EQU	$
	WORD	0E046H	
	WORD	0E050H						;01
	WORD	0003H,1003H,4019H,5019H,403FH,0826H,1826H
	WORD	0E000H						;03
	WORD	0C03H,4C19H,1C03H,5C19H,403FH,0426H,1426H
	WORD	0E000H						;04
	WORD	0803H,4819H,403AH,0026H,5449H,9C45H,3060H
	WORD	0E000H						;05
	WORD	0C07H,8C13H,1807H,9813H,803FH,0426H,3050H,6060H
	WORD	0E000H						;06
	WORD	2850H,0007H,8013H,1007H,9013H,803FH,5480H
	WORD	0E000H						;06
	WORD	0007H,8013H,1407H,9413H,803FH,4480H
	WORD	0E3F0H
;
;********************************
;*	CORS20	7-4		*
;********************************
CORS20	EQU	$
	WORD	0E050H
	WORD	0E046H
;
	WORD	00005H,01405H,06017H,07417H,0603FH,00826H,05C60H
;
	WORD	0E000H
	WORD	00807H,01C07H,06817H,07C17H,0603FH,01026H
;
	WORD	0E000H
	WORD	01007H,07017H,0603FH,07C47H,00426H
;
	WORD	0E000H
	WORD	00426H,07435H,07047H,05860H,0B890H
;
	WORD	0E000H
	WORD	00C07H,01C07H,06C17H,07C17H,0603FH,00426H,05080H,0B490H
;
	WORD	0E000H
	WORD	0603FH,07C47H,00426H,04C80H
;
	WORD	0E000H
	WORD	07435H,07047H,02450H,05480H
;
	WORD	0E000H
	WORD	07017H,08017H,0603FH,04090H,05090H,04480H,05480H,0A0B0H
;
	WORD	0E3F0H
;
;********************************
;*	CORS21	8-4		*
;********************************
CORS21	EQU	$
	WORD	0E012H
	WORD	0E050H
	WORD	0E044H
;				;00
	WORD	0A0A0H,02010H,02800H,04C30H,05830H
;				;01
	WORD	0E000H
	WORD	0A0A0H,04430H,03010H,03800H,05C30H
;				;02
	WORD	0E000H
	WORD	0A0A0H,04830H,05430H
;				;03
	WORD	0E000H
	WORD	0A0A0H,02010H,02800H,05020H,05850H
;				;04
	WORD	0E000H
	WORD	0A0A0H,04820H,05050H,05820H
;				;05
	WORD	0E000H
	WORD	0A0A0H,04450H,002C00H,094D0H
;				;06
	WORD	0E000H
	WORD	0A0A0H,02000H,04840H,05440H,03C00H
;				;07
	WORD	0E000H
	WORD	0A0A0H,02010H,04830H,07470H,05C20H
;				;08
	WORD	0E000H
	WORD	0A0A0H,02410H,08CC0H,03010H,05820H
;				;09
	WORD	0E000H
	WORD	0A0A0H,04050H,05050H,04880H,05820H
;				;0A
	WORD	0E000H
	WORD	0A0A0H,02400H,04C20H,05820H
;
	WORD	0E3F0H
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	END SUB0
	END
