;
	include		mn_hp_smram.asm
;
	 ORG	  0FD000H
;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;	 1991.12.03	    V.1.0  Super Mario-CD
;				   File	 name : SMSUB0
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		GLB	KEYCNG
		GLB	LDINIT
;=========================================================== SMSUB0 ==
		GLB	TILBGDT,TITLST,PLPECE,FWATCK
		GLB	COBINT,BKFSET,FTMOST,GFCSET
		GLB	OSBSET,KPADIE,TLFLSH
		GLB	WDCSET,PASSUB,OMFIND,HMCSET,SETSMK
		GLB	FENPCV,PLBLCT,CHRCHNG
		GLB	COCSET,CFLASH,KMLFST
		GLB	MARIOW,BOMBPT,BOMBST
		GLB	MENSEL,BGMSET,KAMECK,KINPST
		GLB	KAZECHK,KAZCSET,KAZEON,KAZEOFF
		GLB	ENINIT
;
;=====================================================================
	GLB	BGDTA0,BD00,BD10,BD50,BD90,BDA0,BDB0,SNOW0,SNOW1
	GLB	MSBGCL,THKM,ERRMS,CGRST,GOVBG,TCOSL,W9MS1,W9MS2
	GLB	BGDTA1,CLGN0,BGTIL,BGGEM,BGD02,BKCG00,SN0,SN1,MSCL
	GLB	DEFA,ERPT,CGRS,TLSL,GVBG,W9M1,W9M2
	GLB	NXTDT1,NXTDT2,NXTDT3,NXTDT4,NXTDT5,NXTDT6
	GLB	NXTDT7,NXTDT8,NXTDT9,NXTDTA,NXTDTB,ERMSGDT,CGRSDT
	GLB	GVBGDT,WLD9DT1,WLD9DT2
	GLB	CG0,CG1,CG2,CG3,SNOWD0,SNOWD1,MSCLDT,BKCGDT
	GLB	BKCGDT,THKDTM,THKDTL,CASDTA
	GLB	SLCRST,BKM0ST,CLFDOT
;
;=====================================================================
	GLB	DMACT,RAMCL0,RAMCL1,FRLPTD,NUTSSP
	GLB	JPTRST,ENOPDT,ENOPD2,PAUSE
	GLB	CSIDDT
;
;=====================================================================
	EXT	CLSET2,FICMD2,M2SAVE,PS_RESET,OMCLPS
;=====================================================================
		EXT	PLCNT_SET
;=====================================================================
;
		EXTEND
		IDX8
		MEM8
;=====================================================================
;
;*********************************************************************
;*	 KEY input [4016H] [4017H]		   (KEYAB)	     *
;*********************************************************************KEYCNG	EQU	 $
KEYCNG		EQU	$
		PHB
		PHK
		PLB
;
	LDA	>KEYMOD		; FAMICOM MODE
	BNE	KTYPEB		; NO!
;
	LDA	KEYA1L
	AND	#11000000B
	TSB	KEYA1
	LDA	KEYA2L
	AND	#11000000B
	TSB	KEYA2
	BRA	KEYFIN
;
KTYPEB	EQU	$
	LDA	KEYA1
	AND	#10000000B
	LSR	A
	TSB	KEYA1
	LDA	KEYA1L
	AND	#11000000B
	STA	<WORK
	LDA	KEYA1
	AND	#01111111B
	ORA	<WORK
	STA	KEYA1
;
	LDA	KEYA2
	AND	#10000000B
	LSR	A
	TSB	KEYA2
	LDA	KEYA2L
	AND	#11000000B
	STA	<WORK
	LDA	KEYA2
	AND	#01111111B
	ORA	<WORK
	STA	KEYA2
;
KEYFIN	EQU	$
;\\\\\\\\\\\\\\\	 RTS
;
	PLB
	RTL
;

;;;;;;;;;;;;	LOAD DATA INITIAL SET	;;;;;;;;;;;;;;
;
LDINIT		EQU	$
		LDA	RTRYFG
		BNE	LDINIT2			;
;						;
LDINIT1		EQU	$
		LDA	>SAVEBF+(m2_world-SAVEBF)
		STA	!CORSNO
		STA	!WCRSNO
		LDA	>SAVEBF+(m2_world+1-SAVEBF)
		STA	!GOALCT
		STA	!WGOLCT
		LDA	>SAVEBF+(m2_world+2-SAVEBF)
		BPL	LDIT10
		INC	A
LDIT10		EQU	$
		STA	!CORSID
		STA	!WCRSID
		LDA	>SAVEBF+(m2_plcnt-SAVEBF)
		STA	!PLCNT
		LDA	>SAVEBF+(m2_warp-SAVEBF)
		STA	!WARPCT
;
LDINIT3		EQU	$
		PHX
;
		LDX	#0
LDI010		EQU	$
;;;;;;;;;;;;;;;;;;		  LDA	  >SAVEBF+(m2_top-SAVEBF),X
		LDA	>MR2_TOP,X
		STA	TOPSCR,X
		INX
		CPX	#6
		BNE	LDI010
;
		PLX
;
		RTL
;
LDINIT2		EQU	$
		LDA	>CORSRM
		STA	CORSID
		LDA	GOALRM
		STA	GOALCT
		LDA	#2
		STA	PLCNT
		STZ	ENCOCT1
;
		STZ	WARPCT
;
		PHX
;
		LDX	#0
LDI040		EQU	$
		STZ	PLYSC1,X
		INX
		CPX	#6
		BNE	LDI040
;
		PLX
		RTL
;
;#####################################################################
;#	 JSL	  BRCSET    [ Shiro obj bridge	]		     #
;#####################################################################
;
BRCSET	EQU	$
	PHX
	PHY
	LDA	BKBCLFG
	BEQ	BRKPSK
	LDY	OAMEN,X
	LDX	#00H
BRKPST	EQU	$
	LDA	OAM2,Y
	STA	OAM,X
;
	TYA
	AND	#00000011B
	CMP	#01H		; YPOS ?
	BNE	BRLP05
	LDA	OAM,X
	CMP	#0F0H
	BCC	BRLP05
	LDA	#0F0H
	STA	OAM,X
	LDA	#0
	STA	OAMSB2,Y
BRLP05	EQU	$
;
	LDA	OAMSB2,Y
	STA	OAMSB,X
	LDA	#0
	STA	OAMSB2,Y
	LDA	#0F0H
	STA	OAM2,Y
	INY
	INX
	CPX	#20H
	BNE	BRKPST
;
BRKPSK	EQU	$
	LDX	#0
	STZ	<YWORK3
BRLP10	EQU	$
	LDA	BRSTAT,X
	BEQ	BRCSJP
	JSR	BRCS10
	LDA	<YWORK3
	CLC
	ADC	#20H
	STA	<YWORK3		; OAM INDEX
BRCSJP	EQU	$
	INX
	CPX	#13
	BCC	BRLP10
;
	PLY
	PLX
	RTS
;
BRCS10	EQU	$
	LDA	<INDEX
	INC	A
	STA	KPSTFG
	PHX
	LDY	BRCNT,X
	STY	<YWORK2
	LDA	BRYCLC,Y
	CLC
	ADC	#0A0H
	STA	<YWORK		;LEFT CHR YPOS
	LDA	BRYCLC+1,Y
	CLC
	ADC	#0A0H
	STA	<YWORK1		;RIGHT CHR YPOS
;
	LDY	<YWORK3
	LDA	BRXPOS,X
	JSR	BRXP24
	LDA	BRXPOS,X
	CLC
	ADC	#8
	JSR	BRXP24
;
	LDY	<YWORK3
	LDA	<YWORK
	JSR	BRYP24
	TYA
	CLC
	ADC	#10H
	TAY
	LDA	<YWORK1
	JSR	BRYP24
;
	LDX	<YWORK2
	CPX	#04H
	BCS	BRC020
	LDA	#22H
	BRA	BRC030
BRC020	EQU	$
	LDA	#23H
BRC030	EQU	$
	LDY	<YWORK3
	INY
	INY
	INY
	PHA
	JSR	BRXP24
	PLA
	JSR	BRXP24
;
	LDY	<YWORK3
	TXA
	ASL	A
	ASL	A
	ASL	A
	TAX
	LDA	#8
	STA	<YWORK4
BRC040	EQU	$
	LDA	BRCDAT,X
	STA	OAM2+02,Y
	INY
	INY
	INY
	INY
	INX
	DEC	<YWORK4
	BNE	BRC040
;
	PLX
	DEC	BRWAIT,X
	LDA	BRWAIT,X
	BNE	BRC050
	LDA	#3
	STA	BRWAIT,X
	INC	BRCNT,X
	LDA	BRCNT,X
	AND	#0FH
	CMP	#09H
	BNE	BRC050
	STZ	BRSTAT,X
BRC050	EQU	$
;
	RTS
;
BRYP24	EQU	$
	STA	OAM2+01,Y
	CLC
	ADC	#8
	STA	OAM2+05,Y
	CLC
	ADC	#8
	STA	OAM2+09,Y
	CLC
	ADC	#8
	STA	OAM2+13,Y
	RTS
;
BRXP24	EQU	$
	STA	OAM2+00,Y
	STA	OAM2+04,Y
	STA	OAM2+08,Y
	STA	OAM2+12,Y
	TYA
	CLC
	ADC	#10H
	TAY
	RTS
;
BRCDAT	EQU	$
	HEX	10,20,FC,FC,11,21,FC,FC
	HEX	10,20,FC,FC,11,21,FC,FC
	HEX	12,22,FC,FC,13,23,FC,FC
	HEX	14,24,16,FC,15,25,17,FC
	HEX	4C,5C,4E,5E,4D,5D,4F,5F
	HEX	8C,9C,8E,9E,8D,9D,8F,9F
	HEX	AC,BC,AE,BE,AD,BD,AF,BF
	HEX	AC,BC,AE,BE,AD,BD,AF,BF
	HEX	AC,BC,AE,BE,AD,BD,AF,BF
;
BRYCLC	EQU	$
	HEX	00,00,01,03,06,0A,0F,14,1C,24,3C
;
;#####################################################################
;#	 JSL	  FTMOST    [ killer chr set	]		     #
;#####################################################################
;
FTMODT	EQU	$
	HEX	0E,0E,0E,66,66,64,64,64,66,66
;
FTMOST	EQU	$
	PHB
	PHK
	PLB
	PHY
;
	LDA	OAMEN,X
	CLC
	ADC	#4
	TAY
	LDA	<ENMMKI,X
	CMP	#2
	BNE	FTM010
	LDA	#41H
FTM010	EQU	$
	EOR	#2BH
	STA	OAM2+03,Y
	LDA	<ENMYNO,X
	CMP	#08H
	BEQ	FTM013
	LDA	KSMKCT,X
	CMP	#0AH
	BCS	FTM013
	LDA	OAM2+03,Y
	EOR	#20H
	STA	OAM2+03,Y
;
FTM013	EQU	$
	LDA	FTMCNT,X
	LSR	A
	LSR	A
	AND	#00001111B
	STA	<YWORK
	LDA	<ENSTAT,X
	AND	#20H
	BNE	FTM014
	LDA	<YWORK
	CMP	#09H
	BCC	FTM015
FTM014	EQU	$
	STZ	FTMCNT,X
FTM015	EQU	$
	LDA	<PLCMOD
	CMP	#09H
	BCS	FTM017
	LDA	ENCLFG
	BNE	FTM017
	INC	FTMCNT,X
FTM017	EQU	$
	LDX	<YWORK
;
	LDA	ENOBJX
	STA	OAM2+00,Y
	LDA	ENOBJY
	CLC
	ADC	#8
	STA	OAM2+01,Y
	LDA	FTMODT,X
	STA	OAM2+02,Y
	LDA	#2
	STA	OAMSB2,Y
	LDX	<INDEX
	LDA	ENXPS1,X
	STA	<YWORK
	LDA	<ENXPS0,X
	STA	<YWORK1
	MEM16
	REP	#20H
	LDA	<YWORK
	SEC
	SBC	<SCCH1
	STA	<YWORK
	MEM8
	SEP	#20H
	LDA	<YWORK1
	BEQ	FTM090
	LDA	#3
	STA	OAMSB2,Y
FTM090	EQU	$
	LDA	ENOBJY
	CMP	#0E0H
	BCS	FTM093
	LDA	<ENYPS0,X
	CMP	#1
	BEQ	FTM095
FTM093	EQU	$
	LDA	#0F0H
	STA	OAM2+01,Y
FTM095	EQU	$
;
	PLY
	PLB
	RTL
;
;#####################################################################
;#	 JSL	  PLPECE    [ player clear pose ]		     #
;#####################################################################
;
PLPECE	EQU	$
	LDA	PESTFG
	BEQ	PLPC007
	LDA	PLXPS1
	STA	<YWORK
	LDA	PLXPS0
	STA	<YWORK1
	STZ	PLMVXP+1
	MEM16
	REP	#20H
	LDA	PLMVXP
	CLC
	ADC	PEXPS1
	CMP	<YWORK
	BCC	PLPC005
	MEM8
	SEP	#20H
	LDA	#1
;;	LDA	#0DH		;;;#0BH
;;	STA	PLXSD1
;;	STA	<PLXSD0
	RTL
;
PLPC005 EQU	$
	MEM8
	SEP	#20H
	STZ	PESTFG
	LDA	#034H		;;;#0FFH
	STA	BLCLFG
	STA	PECECT
PLPC007 EQU	$
	LDA	PECECT
	BEQ	PLPC40
	CMP	#28H		;;;#80H
	BCC	PLPC10
	LDA	#0F8H
	BRA	PLPC20
PLPC10	EQU	$
	LDA	#0F0H
PLPC20	EQU	$
	STA	PECECH
	LDA	PLSIZE
	BEQ	PLPC30
	LDA	PECECH
	SEC
	SBC	#10H
	STA	PECECH
PLPC30	EQU	$
	DEC	PECECT
	LDA	PECECT
	BNE	PLPC35
;;;	LDA	#11H
;;;	STA	!SOUND2
PLPC35	EQU	$
	STZ	<XSPED0
	STZ	XSPED1
	LDA	#0
	RTL
PLPC40	EQU	$
	LDA	#1
	STA	SRSTFG
	STA	PLCLFD
	JSR	PLFDOT
	STZ	PECECH
	LDA	PLFDMV
	BEQ	PLPC50
	DEC	PLFDMV
	LDA	#01
	RTL
;
PLPC50	EQU	$
	LDA	CSINFG
	CMP	#1
	BCS	PLPC60
	INC	CSINFG
PLPC60	EQU	$
	LDA	#0
	RTL
;
PLFDOT	EQU	$	;PLAYER FADE OUT
	LDX	#0H
	MEM16
	REP	#20H
MRFD00	EQU	$
	LDA	MRPLCL,X
	STA	<YWORK
	AND	#0111110000000000B	;RED
	BEQ	MRFD10
	LDA	<YWORK
	SEC
	SBC	#0400H
	STA	<YWORK
;
MRFD10	EQU	$
	LDA	<YWORK
	AND	#0000001111100000B	;GREEN
	BEQ	MRFD20
	LDA	<YWORK
	SEC
	SBC	#0020H
	STA	<YWORK
;
MRFD20	EQU	$
	LDA	<YWORK
	AND	#0000000000011111B	;BLUE
	BEQ	MRFD30
	DEC	<YWORK
;
MRFD30	EQU	$
	LDA	<YWORK
	STA	MRPLCL,X
	INX
	INX
	CPX	#20H
	BNE	MRFD00
	MEM8
	SEP	#20H
	INC	!CGVMAF
	RTS
;
;#####################################################################
;#	 JSL	  BKFINT    [ kuppa fire ]			     #
;#####################################################################
;
BKFYPD	EQU	 $	     ;y-pos. data
	 HEX	  90,80,70,90
BKFYMD	EQU	 $	     ;y-pos. move dot data
	 HEX	  FF,01
;
BKFINT	EQU	$
	PHX
	PHY
	LDY	BKMIDX
	LDX	BKIXWK
	 LDA	  ENXPS1,Y
	 SEC
	 SBC	  #0EH
	 STA	  ENXPS1,X
	 LDA	  ENXPS0,Y
	 STA	  <ENXPS0,X    ;x-pos. set
;
	 LDA	  ENYPS1,Y
	 CLC
	 ADC	  #08H
	 STA	  ENYPS1,X
;
	 LDA	  RDM,X
	 AND	  #03H
	 STA	  BKFFG1,X  ;y-pos. data pointer set
	 TAY
	 LDA	  BKFYPD,Y
	 LDY	  #00H
	 CMP	  ENYPS1,X
	 BCC	  BKFES50     ;up move ?
;			      ;no
	 INY
BKFES50	 EQU	  $
	 LDA	  BKFYMD,Y
	 STA	  BKFFG2,X  ;y-pos. move data set
;
	 STZ	  ENFALFG     ;flag clear
;;;	    LDA	     #00H
;;;	    STA	     ENFALFG	 ;flag clear
;
BKFES60	 EQU	  $
	 LDA	  #FICMD2
	 STA	  ENCSMD,X    ;OBJ cross size set
;
	 LDA	  #01H
	 STA	  <ENYPS0,X    ;y-pos. set
	 STA	  <ENCMOD,X
;
	 LSR	  A	      ; A <-- #0
	 STA	  ENXPS2,X
	 STA	  <ENSTAT,X
BKFES100 EQU	  $
	PLY
	PLX
	 RTS
;
;#####################################################################
;#	 JSL	  BKFSET    [ Kuppa fire set ]			     #
;#####################################################################
;
BKFSET	EQU	$
	PHB
	PHK
	PLB
;
	LDY	OAMEN,X
	LDA	ENOBJX
	STA	OAM2+00,Y
	CLC
	ADC	#8
	STA	OAM2+04,Y
	LDA	ENOBJY
	STA	OAM2+01,Y
	STA	OAM2+05,Y
	LDA	#21H
	STA	OAM2+03,Y
	STA	OAM2+07,Y
	LDA	BKFCNT,X
	LSR	A
	LSR	A
	LSR	A
	CMP	#03H
	BNE	BKF010
;
	STZ	BKFZFG,X
;	LDA	RND0
;	ORA	<FMCNT
;	AND	#00000010B
;	BNE	BKF040
	LDA	#1
	STA	BKFZFG,X
	LDA	ENXPS1,X
	CLC
	ADC	#10H
	STA	KFXPS1,X
	LDA	<ENXPS0,X
	ADC	#0
	STA	KFXPS0,X
	LDA	ENOBJY
	STA	KFYPOS,X
BKF040	EQU	$
	LDA	#0
	STA	BKFCNT,X
BKF010	EQU	$
	TAX
	LDA	BKFDT1,X
	STA	OAM2+02,Y
	INC	A
	STA	OAM2+06,Y
	STX	<YWORK
	LDX	<INDEX
	LDA	ENXPS1,X
	STA	<YWORK1
	LDA	<ENXPS0,X
	STA	<YWORK2
	MEM16
	REP	#20H
	LDA	<YWORK1
	SEC
	SBC	<SCCH1
	STA	<YWORK1
	CLC
	ADC	#8
	STA	<YWORK3
	MEM8
	SEP	#20H
	LDA	#2
	STA	<YWORK5
	LDA	<YWORK2
	BEQ	BKF020
	LDA	#1
BKF020	EQU	$
	ORA	<YWORK5
	STA	OAMSB2+00,Y
	LDA	<YWORK4
	BEQ	BKF030
	LDA	#1
BKF030	EQU	$
	ORA	<YWORK5
	STA	OAMSB2+04,Y
;
	LDA	BKFZFG,X
	BEQ	BKF999
	LDA	KFXPS1,X
	STA	<YWORK1
	LDA	KFXPS0,X
	STA	<YWORK2
	MEM16
	REP	#20H
	LDA	<YWORK1
	SEC
	SBC	<SCCH1
	STA	<YWORK1
	MEM8
	SEP	#20H
;
	LDA	<YWORK1
	STA	OAM2+08,Y
	LDA	BKFCNT,X	;;;;;
	LSR	A
	CLC
	ADC	#4
	CLC
	ADC	KFYPOS,X
	STA	OAM2+09,Y
	LDX	<YWORK
	LDA	BKFDT2,X
	STA	OAM2+10,Y
	LDA	#28H
	STA	OAM2+11,Y
;
	STZ	<YWORK5
	LDA	<YWORK2
	BEQ	BKF050
	LDA	#1
BKF050	EQU	$
	ORA	<YWORK5
	STA	OAMSB2+08,Y
BKF999	EQU	$
;
	LDX	<INDEX
	INC	BKFCNT,X
;
	PLB
	 RTL
;
BKFDT1	EQU	$
	HEX	86,A6,89
BKFDT2	EQU	$
	HEX	30,31,32
BKFDT3	EQU	$
	HEX	06,0A,0E
;
;
;#####################################################################
;#	 JSL	  KMLFST    [ kumo  set ]			     #
;#####################################################################
;
KMLFST	EQU	$
	PHB
	PHK
	PLB
;
	LDY	#04H
	STY	KMONFG
	LDA	ENOBJX
	SEC
	SBC	#8
	STA	<YWORK
	LDX	#0
KML010	EQU	$
	LDA	KMXDAT,X
	CLC
	ADC	<YWORK
	STA	OAM+00,Y
	LDA	ENOBJY
	SEC
	SBC	#4
	STA	OAM+01,Y
	PHX
	LDA	<FMCNT
	AND	#00011000B
	STX	<YWORK1
	CLC
	ADC	<YWORK1
	TAX
	LDA	KMADAT,X
	STA	OAM+03,Y
	LDA	KMCDAT,X
	STA	OAM+02,Y
	PLX
	INY
	INY
	INY
	INY
	INX
	CPX	#05H
	BNE	KML010
;
	LDX	<INDEX
	LDA	ENXPS1,X
	STA	<YWORK1
	LDA	<ENXPS0,X
	STA	<YWORK2
	MEM16
	REP	#20H
	LDA	<YWORK1
	SEC
	SBC	#08H
	SEC
	SBC	<SCCH1
	STA	<YWORK5
	CLC
	ADC	#10H
	STA	<YWORK4
	CLC
	ADC	#04H
	STA	<TWORK3
	CLC
	ADC	#08H
	STA	<TWORK1
	CLC
	ADC	#4H
	STA	<YWORK3
	CLC
	ADC	#10H
	STA	<YWORK2
	SEC
	SBC	#10H
	STA	<YWORK1
	MEM8
	SEP	#20H
;
	LDA	#2
	STA	<YWORK
	LDY	#4
	LDX	#5
KML020	EQU	$
	LDA	<YWORK+1,X
	BEQ	KML030
	LDA	#1
KML030	EQU	$
	ORA	<YWORK
	STA	OAMSB+00,Y
	INY
	INY
	INY
	INY
	DEX
	BNE	KML020
;
	STZ	<YWORK
	LDA	ENLVFG
	BNE	KML060
	LDA	#0F0H
	STA	OAM+15H
	LDA	<TWORK2
	BEQ	KML040
	LDA	#1
KML040	EQU	$
	ORA	<YWORK
	STA	OAMSB
	LDA	<TWORK1
	STA	OAM+00
	BRA	KML070
KML060	EQU	$
	LDA	#0F0H
	STA	OAM+0DH
	STA	OAM+11H
	LDA	<TWORK4
	BEQ	KML065
	LDA	#1
KML065	EQU	$
	ORA	<YWORK
	STA	OAMSB
	LDA	<TWORK3
	STA	OAM+00
KML070	EQU	$
	LDA	<FMCNT
	AND	#00010000B
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	CLC
	ADC	ENOBJY
	STA	OAM+01
	LDA	#0E7H
	STA	OAM+02
	LDA	#2CH
	STA	OAM+03
;
	LDX	<INDEX
;
	PLB
	RTL
;
KMCDAT	EQU	$
	HEX	40,41,41,42,42,00,00,00
	HEX	60,61,61,62,62,00,00,00
	HEX	42,41,41,40,40,00,00,00
	HEX	62,61,61,60,60,00,00,00
;
KMADAT	EQU	$
	HEX	2A,6A,6A,2A,2A,00,00,00
	HEX	2A,6A,6A,2A,2A,00,00,00
	HEX	6A,2A,2A,6A,6A,00,00,00
	HEX	6A,2A,2A,6A,6A,00,00,00
;
KMXDAT	EQU	$
	HEX	00,10,20,30,20
;
;#####################################################################
;#	 JSL	  BKM0ST    [ kuppa set ]			     #
;#####################################################################
;
KPCHR00 EQU	$
	HEX	C0,E0,C4,C2,E2,C5
KPCHR01 EQU	$
	HEX	C6,E6,D4,C8,E8,D5
KPCHR02 EQU	$
	HEX	CA,EA,E4,C8,EC,E5
KPCHR03 EQU	$
	HEX	CC,E0,F4,CE,E2,F5
KPCHR04 EQU	$
	HEX	C0,E0,C4,EE,E2,C5
KPCHR05 EQU	$
	HEX	CC,E0,94,A4,E2,95
KPCHR06 EQU	$
	HEX	80,A0,84,82,A2,85
;
KPCHRFP EQU	$
	HEX	C2,E2,C5,C0,E0,C4
	HEX	C8,E8,D5,C6,E6,D4
	HEX	C8,EC,E5,CA,EA,E4
	HEX	CE,E2,F5,CC,E0,F4
	HEX	EE,E2,C5,C0,E0,C4
	HEX	A4,E2,95,CC,E0,94
	HEX	82,A2,85,80,A0,84
;
KPCHDT	EQU	$
	HEX	00,01,01,00,02,02,03,04,05,06
KPPYCH	EQU	$
	HEX	08,09
;
PIXPS1	EQU	$
	HEX	EE,EE,EE,00,F6,F6,F6,00,EC,EC,EC,00,00
PIXPS2	EQU	$
	HEX	00,00,E8,E8,E8,00,F2,F2,F2,00,FA,FA,FA
PIYPS1	EQU	$
	HEX	EA,EA,EA,00,E5,E5,E5,00,E4,E4,E4,00,00
PIYPS2	EQU	$
	HEX	00,00,E8,E8,E8,00,ED,ED,ED,00,E5,E5,E5
PICHR1	EQU	$
	HEX	A9,B9,E8,00,A9,B9,E8,00,A9,B9,E8,00,00
PICHR2	EQU	$
	HEX	00,00,A9,B9,E8,00,A9,B9,E8,00,A9,B9,E8
PIATB1	EQU	$
	HEX	27,27,26,27,27,27,26,27,27,27,26,27,27
PIATB2	EQU	$
	HEX	27,27,27,27,26,27,27,27,26,27,27,27,26
;
PIYOKP	EQU	$
	PHX
	INC	PIYOCT
	LDA	PIYOCT
	CMP	#34H
	BCS	PIYOFN
	LSR	A
	LSR	A
	TAX
	LDA	PIXPS1,X
	CLC
	ADC	ENOBJX
	CLC
	ADC	#18H
	STA	OAM+0F8H
	LDA	PIXPS2,X
	CLC
	ADC	ENOBJX
	CLC
	ADC	#18H
	STA	OAM+0FCH
;
	LDA	PIYPS1,X
	BNE	PIYO10
	LDA	#0F0H
	BRA	PIYO20
PIYO10	EQU	$
	CLC
	ADC	ENOBJY
	CLC
	ADC	#10H
PIYO20	EQU	$
	STA	OAM+0F9H
	LDA	PIYPS2,X
	BNE	PIYO30
	LDA	#0F0H
	BRA	PIYO40
PIYO30	EQU	$
	CLC
	ADC	#10H
	CLC
	ADC	ENOBJY
PIYO40	EQU	$
	STA	OAM+0FDH
	LDA	PICHR1,X
	STA	OAM+0FAH
	LDA	PICHR2,X
	STA	OAM+0FEH
	LDA	PIATB1,X
	STA	OAM+0FBH
	LDA	PIATB2,X
	STA	OAM+0FFH
	BRA	PIYORT
;
PIYOFN	EQU	$
	STZ	PIYOFG
PIYORT	EQU	$
	PLX
	RTS
;
BKM0ST	EQU	$
	PHB
	PHK
	PLB
;
	LDA	PIYOFG
	BEQ	BKS000
	JSR	PIYOKP
BKS000	EQU	$
	LDA	KPCHCT
	BEQ	BKS001
	LDY	KPCHID
	CPY	#8
	BNE	BKS004
	LDA	KPCHCT
	LSR	A
	LSR	A
	AND	#1
	TAY
	LDA	KPPYCH,Y
	TAY
	BRA	BKS004
BKS001	EQU	$
	LDA	ETMS01,X
	BNE	BKS003
	STZ	KPCHID
BKS003	EQU	$
	LDA	KPCHID
	LSR	A
	LSR	A
	LSR	A
	TAY
BKS004	EQU	$
	LDA	KPCHDT,Y
	STA	KPCHMD
;				;OAM <= XPOS SET
	LDA	OAMEN,X
	TAY
	LDA	ENOBJX
	STA	OAM2+00,Y
	STA	OAM2+04,Y
	CLC
	ADC	#08H
	STA	OAM2+08,Y
	CLC
	ADC	#08H
	STA	OAM2+12,Y
	STA	OAM2+16,Y
	STA	OAM2+20,Y
;				;OAM <= YPOS SET
	LDA	ENOBJY
	STA	OAM2+01,Y
	STA	OAM2+13,Y
	CLC
	ADC	#10H
	STA	OAM2+05,Y
	STA	OAM2+17,Y
	SEC
	SBC	#18H
	STA	OAM2+09,Y
	STA	OAM2+21,Y
;				;OAM <= ATB SET
	LDA	<ENMMKI,X
	STA	<TWORK2
	CMP	#1
	BEQ	BKS005
	LDA	#61H
	BRA	BKS007
BKS005	EQU	$
	LDA	#21H
BKS007	EQU	$
	STA	OAM2+03,Y
	STA	OAM2+07,Y
	STA	OAM2+11,Y
	STA	OAM2+15,Y
	STA	OAM2+19,Y
	STA	OAM2+23,Y
;
	STX	<INDEX
	LDA	KPCHMD
	ASL	A
	STA	<TWORK1
	ASL	A
	CLC
	ADC	<TWORK1
	TAX
	CLC
	ADC	#6
	STA	<TWORK1
	LDA	<TWORK2
	CMP	#1
	BEQ	BKS010
	LDA	<TWORK1
	CLC
	ADC	#42
	STA	<TWORK1
	SEC
	SBC	#6
	TAX
BKS010	EQU	$
	LDA	KPCHR00,X
	STA	OAM2+02,Y	;OAM <= CHR SET
	LDA	#2
	STA	OAMSB2,Y	;OAMSB <= 2 SET
	INY
	INY
	INY
	INY
	INX
	CPX	<TWORK1
	BNE	BKS010
;
	LDA	#0
	STA	OAMSB2-4,Y
	STA	OAMSB2-16,Y
	LDX	<INDEX
;				;FLAME CHECK
	LDA	ENXPS1,X
	STA	<YWORK
	LDA	<ENXPS0,X
	STA	<YWORK1
	MEM16
	REP	#20H
	LDA	<YWORK
	SEC
	SBC	<SCCH1
	STA	<YWORK
	CLC
	ADC	#8
	STA	<YWORK2
	CLC
	ADC	#8
	STA	<YWORK4
	CLC
	ADC	#30H
	STA	<TWORK6
	MEM8
	SEP	#20H
	LDA	OAMEN,X
	TAY
	LDA	<TWORK7
	CMP	#0FFH
	BNE	BKS025
	STZ	<ENCMOD,X
	STZ	<ENSTAT,X
	STZ	<ENMYNO,X
;;;;;;; BRA	BKS040
BKS025	EQU	$
	LDA	<YWORK1
	BEQ	BKS020
	LDA	#3
	STA	OAMSB2+00,Y
	STA	OAMSB2+04,Y
BKS020	EQU	$
	LDA	<YWORK3
	BEQ	BKS030
	LDA	#1
	STA	OAMSB2+08,Y
BKS030	EQU	$
	LDA	<YWORK5
	BEQ	BKS040
	LDA	#1
	STA	OAMSB2+12,Y
	STA	OAMSB2+16,Y
	STA	OAMSB2+20,Y
BKS040	EQU	$
;
	LDA	KPCHCT
	BNE	BKS050
	STZ	KPCHCT
	INC	KPCHID
	LDA	KPCHID
	CMP	#30H
	BCC	BKS060
	STZ	KPCHID
	BRA	BKS060
BKS050	EQU	$
	DEC	KPCHCT
	LDA	KPCHCT
	BNE	BKS060
	LDA	KPCHID
	CMP	#6
	BNE	BKS055
	INC	KPCHID
	LDA	#28H
	STA	KPCHCT
	LDA	#3AH
	STA	!SOUND0
	JSR	BKFINT
	BRA	BKS060
BKS055	EQU	$
	STZ	KPCHID
BKS060	EQU	$
	LDA	FIBSCT
	BNE	BKS099
;
	LDX	<INDEX
	LDY	OAMEN,X
	LDX	#6
BKS070	EQU	$
	LDA	OAM2+03,Y
	ORA	#80H
	STA	OAM2+03,Y
	INY
	INY
	INY
	INY
	DEX
	BNE	BKS070
	LDX	<INDEX
	LDY	OAMEN,X
	LDA	OAM2+01,Y
	CLC
	ADC	#8
	STA	OAM2+01,Y
	STA	OAM2+13,Y
	LDA	OAM2+05,Y
	SEC
	SBC	#18H
	STA	OAM2+05,Y
	STA	OAM2+17,Y
	LDA	OAM2+09,Y
	CLC
	ADC	#20H
	STA	OAM2+09,Y
	STA	OAM2+21,Y
;
BKS099	EQU	$
	JSR	BRCSET
;
	PLB
	RTL
;
;#####################################################################
;#	 JSR	  BGMSET    [ BGM set ]				     #
;#####################################################################
BGMFGD	EQU	$			; Sound BGM flag data !
	HEX	03			; Underwater
	HEX	02			; Ground
	HEX	06			; Undergrond
	HEX	08			; Castle
BNBGM	HEX	01			; Sky &
NXFN	HEX	13			; Fanfare ( ground --! U-ground,U-water )
;
BGMSET	EQU	$
	PHB
	PHK
	PLB
;
	PHX
	LDA	SYMODE
	BEQ	BGMS90			; IF title to demo ? ( YES ; BGMS90 )
;
	LDA	CHEVFG
	CMP	#2
	BEQ	BGMS30
;
	LDY	#NXFN-BGMFGD
	LDA	PLFPFG
	CMP	#6
	BEQ	BGMS50			; IF next underwater ?	( YES ; BGMS50 )
;
	CMP	#7
	BEQ	BGMS50			; IF next underground ? ( YES ; BGMS50 )
;
BGMS30	EQU	$
	LDY	<KDVRFG
	LDA	SKYFLG
	BEQ	BGMS50			; IF  sky ?		( NO ; BGMS50 )
;
	LDY	#BNBGM-BGMFGD
;
BGMS50	EQU	$
	LDA	<PLCMOD
	CMP	#4
	BEQ	BGMS75
	CMP	#5
	BEQ	BGMS75
;;
	LDA	<BG2COS
	CMP	#39H
	BEQ	BGMS60
	CMP	#3BH
	BEQ	BGMS60
	CMP	#3DH
	BEQ	BGMS60
	LDA	BGMFGD,Y
	BRA	BGMS70
BGMS60	EQU	$
	LDA	#01H
BGMS70	EQU	$
	LDX	SONDFG
	BNE	BGMS75
	STA	!SOUND2			; Sound BGM set @@@@@@@@@
BGMS75	EQU	$
	LDX	<BG2COS
	CPX	#7H
	BNE	BGMS90
	STA	SONDFG
;
BGMS90	EQU	$
;
	PLX
	PLB
	RTL
;
;#####################################################################
;#	 JSR	  PAUSE	    [ Pause check ]			     #
;#####################################################################
PAUSE	 EQU	  $		  ;< Pouse check >
	PHB
	PHK
	PLB
;
	 LDA	  SYMODE
	 CMP	  #2
	 BEQ	  PUSE25	  ;*- IF  system mode = GMSCCL ?  ( YES : PUSE20 )
;
	 CMP	  #1
	 BNE	  PUSE90	  ;*- IF  system mode = GMPROS ?  ( NO : PUSE90 )
;
	 LDA	  GMMODE
	 CMP	  #3
	 BNE	  PUSE90	  ;*- IF  game mode = GMPLAY ?	  ( NO : PUSE90 )
;
	LDA	!ENCLFG
	BNE	PUSE90
	LDA	!PASCFG
	CMP	#0FH
	BNE	PUSE90
PUSE20	 EQU	  $
	 LDA	  PASCNT
	 BEQ	  PUSE40
;
	 DEC	  PASCNT
;
PUSE25	 EQU	  $
	PLB
	 RTL
;
PUSE40	 EQU	  $
	LDA	<PLCMOD
	CMP	#02H
	BEQ	PUSE90
	CMP	#03H
	BEQ	PUSE90
	LDA	PLATFG
	BNE	PUSE90
	LDA	!WINDMD
	CMP	#2
	BCS	PUSE90
	LDA	!PSWAIT
	BEQ	PUSE45
	DEC	!PSWAIT
	BRA	PUSE90
PUSE45	EQU	$
		LDA	!WINDMD
		BNE	PUSE70			; pause init. ?
;						; yes
	 LDA	  KEYA2
	 AND	  #10H
	 BEQ	  PUSE70	  ; Start button ?
;				  ; On !
	 LDA	  #11H
	 STA	  PASCNT
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	     LDA     PASFLG
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	     AND     #01H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	     CLC
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	     ADC     #0F1H
	LDA	#0F1H
	STA	!SOUND2		;<S!
	LDA	#043H
	STA	!SOUND0
;
		JSL	>PASSUB
PUSE70	 EQU	  $
;;	JSL	>OMFIND
PUSE90	 EQU	  $
	PLB
	 RTL
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; pause window
;
PASCON	EQU	$
	INC	PASTEN			; PAUSE TRANS ON
	LDA	#38H
	STA	TSABNK
	MEM16
	REP	#20H
	LDA	#0B000H
	STA	TSAADR
	LDA	#0800H
	STA	TENKAZ
	LDA	#7C00H
	STA	TMOADR
	MEM8
	SEP	#20H
	RTS
;
PASCOF	EQU	$
	INC	PASTEN			; PAUSE TRANS OFF
	LDA	#07H
	STA	TSABNK
	MEM16
	REP	#20H
	LDA	#0B800H
	STA	TSAADR
	LDA	#0800H
	STA	TENKAZ
	LDA	#7C00H
	STA	TMOADR
	MEM8
	SEP	#20H
	RTS
;
;****************************************************************
;*	JSL	>ENINIT						*
;*								*
;****************************************************************
ENINIT		EQU	$
		PHX
		PHY
		JSR	WDBFCLR		; window buff clear
		JSR	WDINIT		; window initial routine
		LDA	#022H
		STA	!WD2123
		LDA	#002H
		STA	!WD2124
		LDA	#015H
		STA	!WD212E
		LDA	#002H
		STA	!WD212F
		PLY
		PLX
		RTL
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;****************************************************************
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  JSR	  PASSUB		  ;;T;;			  *
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;****************************************************************
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PASSUB  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PHX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PHY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  !SOUND2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CMP	  #0F2H		  ; pause fin?
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BEQ	  PSL500	  ; yes!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  JSR	  WDBFCLR	  ; window buff clear
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  JSR	  WDINIT	  ; window initial routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  JSR	  WDRMST	  ; window ram initial set
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  JSR	  PASCON	  ; pause chr transfer
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !WINDMD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !PASFLG
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STZ	  PASCUR
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STZ	  PASTIM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STZ	  SAVEFG
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STZ	  !PSWAIT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BRA	  PSLFIN	  ; goto fin
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSL500  EQU	  $		  ; pause kaijyo shori
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  !PASCUR
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BEQ	  PSL530
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #20H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !PSWAIT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !WINDMD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #03BH
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !SOUND0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  !PASCUR
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CMP	  #2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BNE	  PSLFIN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #0F3H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !SOUND2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BRA	  PSLFIN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSL530  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #10H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  WINDCT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #3
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !WINDMD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSLFIN  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PLY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PLX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  RTL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;************************************************************************
;;*		Pause initial			(PASSUB)		*
;************************************************************************
PASSUB		EQU	$
		JSR	WDBFCLR		; window buff clear
		JSR	WDINIT		; window initial routine
		JSR	WDRMST		; window ram initial set
		JSR	PASCON		; pause chr transfer
		LDA	#1
		STA	!PASFLG
		STZ	PASCUR
		STZ	PASTIM
		STZ	!PSWAIT
		RTL
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;WAITTM  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  DEC	  !PSWAIT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BNE	  WTM100
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INC	  !WINDMD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #10H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !PSWAIT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !WINDCT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INC	  !SAVEFG
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;WTM100  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #00010000B
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !KEYA2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !KEYB2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  JMP	  PSOMST
;
OMFIND		EQU	$
		PHB
		PHK
		PLB				; (DBR) set
;
		PHX				; (X) push
		PHY				; (Y) push
;
		LDA	!WINDMD
		ASL	A
		TAX
		JSR	(WNDMOD,X)
;
		PLY				; (Y) pull
		PLX				; (X) pull
		PLB				; (DBR) reset
		RTL
;
;
WNDMOD		EQU	$
		WORD	WINDON
		WORD	PSOMST
		WORD	WAITTM
		WORD	WINDOFF
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;OMFIND  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PHB
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PHK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PLB
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PHX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PHY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  !WINDMD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  ASL	  A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  TAX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  WNDMOD,X
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  <WORK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  WNDMOD+1,X
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  <WORK1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  JMP	  (WORK)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;WNDMOD  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  WORD	  WINDON
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  WORD	  PSOMST
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  WORD	  WAITTM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  WORD	  WINDOFF
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
WDRMST		EQU	$
		MEM16
		REP	#20H
;
		LDA	#10H
		STA	WINDCT
		LDA	#064H
		STA	WINDWL
		LDA	#0A4H		; #0A4H <--> #09EH
		STA	WINDWR
		LDA	#0C4H
		STA	WINDWU
		LDA	#0D0H
		STA	WINDWD
;
		MEM8
		SEP	#20H
;
		RTS
;
;************************************************************************
;*		Window oam set						*
;************************************************************************
;
PSOMST	EQU	$
		JSR	W_OAMSET		; window oam set
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  IDX16
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  REP	  #10H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDY	  #10H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDX	  #0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #48H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  <WORK1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSO320  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #58H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  <WORK		  ; XPOS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSO350  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  LDA	  !WNDMSG
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  BEQ	  PSO360		  ; ending ?
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;						  ; yes
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  AND	  #010H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  CMP	  #010H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  BEQ	  PSO360
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  LDA	  PSMSGDS,X
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  BPL	  PSO400
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  INX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  INC	  A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  BEQ	  PSO900
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  BRA	  PSO370
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSO360	  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  PSMSGDT,X
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BPL	  PSO400
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INC	  A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BEQ	  PSO900
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSO370  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  <WORK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CLC
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  ADC	  #8
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  <WORK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CMP	  #0C0H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BCC	  PSO350
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  <WORK1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CLC
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  ADC	  #8
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  <WORK1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BRA	  PSO320
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSO400  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CLC
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  ADC	  #0C0H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !OAM+02,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  <WORK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !OAM+00,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  <WORK1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !OAM+01,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #21H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !OAM+03,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !OAMSB,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BRA	  PSO370
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSO900  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #40H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  <WORK1	  ; YPOS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSO100  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #40H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  <WORK		  ; XPOS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSO200  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  <WORK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !OAM+00,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CLC
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  ADC	  #10H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  <WORK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  <WORK1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !OAM+01,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #0CDH
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !OAM+02,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #21H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !OAM+03,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !OAMSB,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  INY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  <WORK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CMP	  #0C0H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BCC	  PSO200
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  <WORK1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CMP	  #80H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BCS	  PSO300
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CLC
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  ADC	  #10H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  <WORK1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BRA	  PSO100
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSO300  EQU	  $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  IDX8
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  SEP	  #10H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDY	  #0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  !WINDMD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CMP	  #03H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BNE	  PSO301
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  JMP	  PSO700
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PSO301  EQU	  $
	LDA	KEYA2
	STA	<WORKF
	AND	#00101100B
	BEQ	PSO700
;
		LDA	!WNDMSG
		BEQ	PSO500			; ending ?
;						; yes
		AND	#010H
		CMP	#010H
		BEQ	PSO500
;
		LDA	<WORKF
		AND	#00100000B
		BEQ	PSO_E020		; select ?
;						; yes
		LDA	!PASCUR
		EOR	#00000010B
PSO_E010	EQU	$
		STA	!PASCUR
		BRA	PSO510
;
PSO_E020	EQU	$
		LDA	<WORKF
		AND	#00000100B
		LSR	A
		CMP	!PASCUR
		BNE	PSO_E010		; cursol change ?
;						; no
		BRA	PSO700
;
PSO500		EQU	$
		LDA	<WORKF
	AND	#00100000B
	BNE	PSO650
	LDA	<WORKF
	AND	#00001000B
	BNE	PSO600
	INC	PASCUR
	LDA	PASCUR
	CMP	#03
	BCC	PSO510
	DEC	PASCUR
	BRA	PSO700
PSO510	EQU	$
	LDA	#1
	STA	!SOUND3
	STZ	PASTIM
	BRA	PSO700
;
PSO600	EQU	$
	DEC	PASCUR
	LDA	PASCUR
	BPL	PSO610
	INC	PASCUR
	BRA	PSO700
PSO610	EQU	$
	LDA	#1
	STA	!SOUND3
	STZ	PASTIM
	BRA	PSO700
;
PSO650	EQU	$
	INC	PASCUR
	LDA	PASCUR
	CMP	#03H
	BCC	PSO660
	STZ	PASCUR
PSO660	EQU	$
	LDA	#1
	STA	!SOUND3
	STZ	PASTIM
PSO700	EQU	$
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #4CH
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  OAM+00,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDX	  PASCUR
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  PASYPS,X
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  OAM+01,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  PASTIM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  AND	  #00010000B
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LSR	  A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LSR	  A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LSR	  A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LSR	  A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  TAX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  PASCRDT,X
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  OAM+02,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #21H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  !OAM+03,Y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  #0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  STA	  OAMSB,Y
	LDA	#4CH
	STA	OAM+00
	LDX	PASCUR
	LDA	PASYPS,X
	STA	OAM+01
	LDA	PASTIM
	AND	#00010000B
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	TAX
	LDA	PASCRDT,X
	STA	OAM+02
	LDA	#21H
	STA	!OAM+03
	LDA	#0
	STA	OAMSB
;
;
	INC	PASTIM
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  LDA	  !WNDMSG	  ; ending window mode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  BNE	  EDWID00
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  SAVEFG
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BEQ	  NOTSAVE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;EDWID00	  EQU	  $
;
	LDA	<WORKF
	AND	#00010000B
	BEQ	NOTSAVE
;
		LDA	#0F2H
		STA	!SOUND2
		STZ	!PASTIM
		LDA	!PASCUR
		BEQ	PSL530			; save ?
;						; yes
		LDA	#30H
		STA	!PSWAIT
		LDA	#2
		STA	!WINDMD
		LDA	#03BH
		STA	!SOUND0
		LDA	!PASCUR
		CMP	#2
		BNE	PSLFIN			; save & quit ?
;						; yes
		LDA	#0F3H
		STA	!SOUND2
		BRA	PSLFIN
;
PSL530		EQU	$
		LDA	#10H
		STA	!PSWAIT
		LDA	#10H
		STA	WINDCT
		LDA	#2
		STA	!WINDMD
		LDA	#043H
		STA	!SOUND0
PSLFIN		EQU	$
		LDA	!WNDMSG		; ending window mode
		CMP	#010H
		BNE	EDWID10
;
		LDA	!PASCUR
		CMP	#002H
		BEQ	EDWID10			; save & quit ?
;						; no
		STZ	!PASFLG
		LDA	#00EH
		STA	!GMMODE
		LDX	!PASCUR
		BEQ	EDWID02			; save ?
;						; yes
		JSL	>M2SAVE
EDWID02		EQU	$
		RTS
;
;
EDWID10		EQU	$
		LDA	#20H
		STA	!PSWAIT
		LDA	!PASCUR
		BEQ	NOTSAVE
;
		JSL	>M2SAVE
NOTSAVE		EQU	$
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  LDA	  !PASCUR
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  CMP	  #01H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  BEQ	  NOTSAVE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  JMP	  >PS_RESET
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PLY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PLX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  PLB
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	  RTL
		RTS
;
PASYPS	EQU	$
	HEX	50,60,70
PASCRDT EQU	$
	HEX	D0,DE
;
PSMSGDT EQU	$
		HEX	AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA
		HEX	14,15,16,17,18,19,1A,1B,AA,AA,AA,AA,AA
		HEX	AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA
		HEX	28,29,2A,2B,1C,14,15,16,17,18,19,1A,1B
		HEX	AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA
		HEX	28,29,2A,2B,1C,24,25,26,27,AA,AA,AA,AA
		HEX	FF
;
PSMSGDS EQU	$
		HEX	AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA
		HEX	24,25,26,27,AA,AA,AA,AA,AA,AA,AA,AA,AA
		HEX	AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA
		HEX	AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA
		HEX	AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA,AA
		HEX	28,29,2A,2B,1C,24,25,26,27,AA,AA,AA,AA
		HEX	FF
;
;
;************************************************************************
;*		Window OAM set				(W_OAMSET)	*
;************************************************************************
W_OAMSET	EQU	$
	IDX16
	REP	#10H
;
	LDY	#10H
	LDX	#0
	LDA	#48H
	STA	<WORK1
PSO320	EQU	$
	LDA	#58H
	STA	<WORK		; XPOS
;
PSO350	EQU	$
		LDA	!WNDMSG
		BEQ	PSO360			; ending ?
;						; yes
		AND	#010H
		CMP	#010H
		BEQ	PSO360
;
		LDA	PSMSGDS,X
		BPL	PSO400
		INX
		INC	A
		BEQ	PSO900
		BRA	PSO370
;
PSO360		EQU	$
	LDA	PSMSGDT,X
	BPL	PSO400
	INX
	INC	A
	BEQ	PSO900
PSO370	EQU	$
	LDA	<WORK
	CLC
	ADC	#8
	STA	<WORK
	CMP	#0C0H
	BCC	PSO350
	LDA	<WORK1
	CLC
	ADC	#8
	STA	<WORK1
	BRA	PSO320
PSO400	EQU	$
	CLC
	ADC	#0C0H
	STA	!OAM+02,Y
	LDA	<WORK
	STA	!OAM+00,Y
	LDA	<WORK1
	STA	!OAM+01,Y
	LDA	#21H
	STA	!OAM+03,Y
	LDA	#0
	STA	!OAMSB,Y
	INX
	INY
	INY
	INY
	INY
	BRA	PSO370
;
PSO900	EQU	$
	LDA	#40H
	STA	<WORK1		; YPOS
PSO100	EQU	$
	LDA	#40H
	STA	<WORK		; XPOS
PSO200	EQU	$
	LDA	<WORK
	STA	!OAM+00,Y
	CLC
	ADC	#10H
	STA	<WORK
;
	LDA	<WORK1
	STA	!OAM+01,Y
;
	LDA	#0CDH
	STA	!OAM+02,Y
;
	LDA	#21H
	STA	!OAM+03,Y
;
	LDA	#2
	STA	!OAMSB,Y
;
	INY
	INY
	INY
	INY
;
	LDA	<WORK
	CMP	#0C0H
	BCC	PSO200
;
	LDA	<WORK1
	CMP	#80H
	BCS	PSO300
	CLC
	ADC	#10H
	STA	<WORK1
	BRA	PSO100
;
PSO300	EQU	$
		IDX8
		SEP	#00010000B		; index 8bit mode
	LDA	#4CH
	STA	OAM+00
	LDX	PASCUR
	LDA	PASYPS,X
	STA	OAM+01
	LDA	PASTIM
	AND	#00010000B
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	TAX
	LDA	PASCRDT,X
	STA	OAM+02
	LDA	#21H
	STA	!OAM+03
	LDA	#0
	STA	OAMSB
		RTS
;
;
;************************************************************************
;*		Window on						*
;************************************************************************
;
WINDON		EQU	$
;
		LDA	WINDCT
		BEQ	SLC200
		BMI	SLC200
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		DEC	WINDCT
		DEC	WINDWL
		DEC	WINDWL
		INC	WINDWR
		INC	WINDWR
		DEC	WINDWU
		DEC	WINDWU
		DEC	WINDWU
		DEC	WINDWU
		INC	WINDWD
		INC	WINDWD
		INC	WINDWD
		INC	WINDWD
;
		LDX	#00200H/4-2
		LDA	#000FFH
SLC120		EQU	$
		STA	>HDMABW+000H,X
		STA	>HDMABW+080H,X
		STA	>HDMABW+100H,X
		STA	>HDMABW+180H,X
		DEX
		DEX
		BPL	SLC120			; window buffer clear end ?
;						; yes
		LDA	WINDWR
		XBA
		ORA	WINDWL
		LDX	WINDWU
SLC140		EQU	$
		STA	>HDMABW+000H,X
		INX
		INX
		CPX	WINDWD
		BNE	SLC140			; window set end ?
;						; yes
		MEM8
		IDX8
		SEP	#30H
		BRA	SLC210
;
SLC200		EQU	$
		INC	!WINDMD
SLC210		EQU	$
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  JMP	  PSOMST
		JSR	W_OAMSET		; window oam set
		RTS
;
;************************************************************************
;*		Windon off routine					*
;************************************************************************
;
WINDOFF		EQU	$
;
		LDA	WINDCT
		BEQ	SLC400
		BMI	SLC400
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		INC	WINDWL
		INC	WINDWL
		DEC	WINDWR
		DEC	WINDWR
		INC	WINDWU
		INC	WINDWU
		INC	WINDWU
		INC	WINDWU
		DEC	WINDWD
		DEC	WINDWD
		DEC	WINDWD
		DEC	WINDWD
		DEC	WINDCT
;
		LDX	#00200H/4-2
		LDA	#000FFH
SLC320		EQU	$
		STA	>HDMABW+000H,X
		STA	>HDMABW+080H,X
		STA	>HDMABW+100H,X
		STA	>HDMABW+180H,X
		DEX
		DEX
		BPL	SLC320			; window buffer clear end ?
;						; yes
		LDA	WINDWR
		XBA
		ORA	WINDWL
		LDX	WINDWU
SLC340		EQU	$
		STA	>HDMABW+000H,X
		INX
		INX
		CPX	WINDWD
		BNE	SLC340			; window set end ?
;						; yes
		MEM8
		IDX8
		SEP	#30H
		BRA	SLC410
;
SLC400		EQU	$
		STZ	!WINDMD
		LDA	#0FH
		STA	!PASCFG
		STZ	PASFLG
;;;;;
		LDA	WD2125
		EOR	#00000011B
		STA	WD2125
		LDA	WD212E
		EOR	#00010000B
		STA	WD212E
;
		JSR	PASCOF
		JSL	>OMCLPS
;
SLC415		EQU	$
;;;;;
		LDA	WD420C
		AND	#0F7H
		STA	WD420C
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  PLY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  PLX
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  PLB
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  RTL
		RTS
;
SLC410		EQU	$
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		  JMP	  PSOMST
		JSR	W_OAMSET		; window oam set
		RTS
;
;
WAITTM		EQU	$
		DEC	!PSWAIT
		BNE	WTM100			; wait end ?
;						; yes
		INC	!WINDMD
		LDA	#10H
		STA	!WINDCT
		STA	!PSWAIT
;
		LDA	!WNDMSG
		CMP	#001H
		BEQ	WTM050			; wd-4 ?
;						; no
		LDA	!PASCUR
		CMP	#002H
		BNE	WTM100
;
WTM050		EQU	$
		JMP	>PS_RESET
;
WTM100		EQU	$
		JSR	W_OAMSET		; window oam set
		RTS
;
;
;************************************************************************
;*		Message window set			(MSG_WINDOW)	*
;************************************************************************
WDINIT		EQU	$
		PHB
		LDA	#BANK HDMABW
		PHA
		PLB
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDX	#00200H/4-2
		LDA	#00000H
MSG_W120	EQU	$
		STA	HDMABW+000H,X
		STA	HDMABW+080H,X
		STA	HDMABW+100H,X
		STA	HDMABW+180H,X
		DEX
		DEX
		BPL	MSG_W120		; window buffer clear end ?
;						; yes
		PLB
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
;;;;		STZ	WD420C			; H-DMA ch "off"
;
		LDX	#02641H
		STX	04330H			; inc. mode & B-bus address set

		LDX	#HDMADRP
		STX	04332H			; A-bus address (L,H)
		LDA	#BANK HDMADRP
		STA	04334H			;		(B)
;
		LDA	#BANK HDMABW
		STA	04337H			; data bank
;
		LDA	#00000000B
		STA	WD2123			; window mask (BG.2 , BG.1)
		STZ	WD2124			;	      (BG.4 , BG.3)
		LDA	WD2125
		ORA	#00000011B	;C0
		STA	WD2125			;	      (Col  , Obj )
;;;;		LDA	#00000011B
		LDA	WD212E
		ORA	#00010000B
		STA	WD212E			; window main
		STZ	WD212F			;	 sub
;
		IDX8
		SEP	#00010000B		; index 8bit mode
;
		LDA	WD420C
		ORA	#00001000B
		STA	WD420C			; window on
;
		RTS
;
;
;======================= H-DMA data =====================================
HDMADRP		EQU	$
		BYTE	0F8H
		WORD	HDMABW
		BYTE	0F8H
		WORD	HDMABW+78H*2
		BYTE	00
;
;
;********************************************************************
;*		hishigata WINDOW off sub			    *
;********************************************************************
WDBFCLR		EQU	$
		PHB
		LDA	#BANK HDMABW
		PHA
		PLB
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	#01A0H
WDCL100		EQU	$
		LDA	#00FFH
		STA	!HDMABW+00H,X
		STA	!HDMABW+02H,X
		STA	!HDMABW+04H,X
		STA	!HDMABW+06H,X
		STA	!HDMABW+08H,X
		STA	!HDMABW+0AH,X
		STA	!HDMABW+0CH,X
		STA	!HDMABW+0EH,X
		STA	!HDMABW+010H,X
		STA	!HDMABW+012H,X
		STA	!HDMABW+014H,X
		STA	!HDMABW+016H,X
		STA	!HDMABW+018H,X
		STA	!HDMABW+01AH,X
		STA	!HDMABW+01CH,X
		STA	!HDMABW+01EH,X
		STA	!HDMABW3+00H,X
		STA	!HDMABW3+02H,X
		STA	!HDMABW3+04H,X
		STA	!HDMABW3+06H,X
		STA	!HDMABW3+08H,X
		STA	!HDMABW3+0AH,X
		STA	!HDMABW3+0CH,X
		STA	!HDMABW3+0EH,X
		STA	!HDMABW3+010H,X
		STA	!HDMABW3+012H,X
		STA	!HDMABW3+014H,X
		STA	!HDMABW3+016H,X
		STA	!HDMABW3+018H,X
		STA	!HDMABW3+01AH,X
		STA	!HDMABW3+01CH,X
		STA	!HDMABW3+01EH,X
		TXA
		SEC
		SBC	#020H
		TAX
		BPL	WDCL100
;
		MEM8
		IDX8
		SEP	#00110000B
;
		PLB
;
		RTS
;
;;;;;;;;;;;;;;;;;;;;;;;;	DEBUG MODE (MUTEKI & MEN SELECT)
;
NUTSSP	EQU	$
	PHB
	PHK
	PLB
;
	PHX
	LDX	MLFLG2
	LDA	KEYA2L,X
	PLX
	AND	#0C0H
	BEQ	EBSK10
	AND	#080H
	BEQ	EBSK05
	STZ	PLSIZE
	LDA	#1
	STA	POWLEV
	BRA	EBSK10
EBSK05	EQU	$
	STZ	PLSIZE
	LDA	#2
	STA	POWLEV
EBSK10	EQU	$
;	LDA	KEYA1L
;	AND	#80H
;	BEQ	EBSK20
;	STA	MTKFLG
EBSK20	EQU	$
	 LDA	  KEYA2
	 AND	  #00100000B
	 BEQ	  EBIJ3
	 EOR	  NUTS
	 STA	  NUTS
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 LSR	  A
	 STA	  BGCROF
EBIJ3	 EQU	  $
	 LDA	  NUTS
	 BNE	  PLP049
	 JMP	  NUTSFIN
;
PLP049	 EQU	  $
	 LDA	  #10H
	 STA	  SPMTIM
;
;;TQ	PHX
;;	LDX	MRLGFG
;;	 LDA	  KEYA1L,X
;;	PLX
	 LDA	  KEYA1L
	 AND	  #00010000B
	 BEQ	  NUTSFIN3
	 LDA	  <FMCNT
	 AND	  #07H
	 BNE	  NUTSFIN3
NUTSFIN4 EQU	  $
	 LDA	  KEYA1
	 LSR	  A
	 BCS	  TIMMAX
	 LSR	  A
	 BCS	  TIMMIN
	 LSR	  A
	 BCS	  PLYDEC
	 LSR	  A
	 BCS	  PLYINC
	 JMP	  NUTSFIN2
TIMMAX	 EQU	  $
	 LDA	  #09H
	 STA	  PLYTM0
	 STA	  PLYTM0+1
	 STA	  PLYTM0-1
	 JMP	  NUTSFIN2
TIMMIN	 EQU	  $
	 STZ	  PLYTM0
	 STZ	  PLYTM0+1
	 STZ	  PLYTM0-1
	 STZ	  NUTS
	 JMP	  NUTSFIN2
PLYINC	 EQU	  $
;;;;;;;;	 INC	  PLCNT
		JSL	>PLCNT_SET		; player count set
	 JMP	  NUTSFIN2
PLYDEC	 EQU	  $
;	 DEC	  PLCNT
;
	 JMP	  NUTSFIN2
NUTSFIN3 EQU	  $
	 LDA	  <FMCNT
	 AND	  #07H
	 BNE	  NUTSFIN5
	 LDA	  KEYA2
	 AND	  #10000000B
	 BEQ	  NUTSFIN5
	 LDA	  PLSIZE
	 EOR	  #01H
	 STA	  PLSIZE
	 LDA	  POWLEV
	 EOR	  #02H
	 STA	  POWLEV
	 JSL	  >CLSET2
;
NUTSFIN5 EQU	  $
	 LDA	  KEYA1
	 AND	  #03H
	 BEQ	  NOTLR
	 TAY
	LDA	<KEYLR
	STA	PLCMKI
	 LDA	  PLXPS1
	 CLC
	 ADC	  NUTSL-1,Y
	 STA	  PLXPS1
	 LDA	  <PLXPS0
	 ADC	  NUTSH-1,Y
	 STA	  <PLXPS0
;
NOTLR	 EQU	  $
;
	 LDA	  KEYA1
	 AND	  #0CH
	 BEQ	  NUTSFIN2
	 LSR	  A
	 LSR	  A
	 TAY
	 LDA	  PLYPS1
	 CLC
	 ADC	  NUTSL-1,Y
	 STA	  PLYPS1
	 LDA	  <PLYPS0
	 ADC	  NUTSH-1,Y
	 STA	  <PLYPS0
	 BRA	  NUTSFIN2
;
NUTSFIN	 EQU	  $		;Normal mode play
;
	SEC
	PLB
	RTL
;
NUTSFIN2 EQU	  $
	CLC
	PLB
	RTL
;
;
NUTSL	 EQU	  $
	 HEX	  03,FD
NUTSH	 EQU	  $
	 HEX	  00,FF
;
;
MENSEL	EQU	$
	PHA
	PHB
	PHK
	PLB
;
	LDA	DEMOTM
	BEQ	MEN040
	LDA	KEYA1
	STA	<YWORK
	AND	#11000000B
	BEQ	MEN040
	LDA	<FMCNT
	AND	#00000111B
	BNE	MEN040
	LDA	<YWORK
	CMP	#01000000B
	BNE	MEN010
	LDA	#17H
	STA	DEMOTM
	INC	CORSNO
	LDA	CORSNO
	CMP	#0DH
	BCC	MEN010
	STZ	CORSNO
MEN010	EQU	$
	LDA	<YWORK
	CMP	#10000000B
	BNE	MEN020
	LDA	#17H
	STA	DEMOTM
	INC	GOALCT
	LDA	GOALCT
	CMP	#04H
	BCC	MEN020
	STZ	GOALCT
MEN020	EQU	$
	LDX	#0
MEN030	EQU	$
	LDA	MENSDT,X
	STA	>VRAMD+2,X
	INX
	CPX	#0BH
	BCC	MEN030
	LDA	CORSNO
	CLC
	ADC	#01H
	STA	>VRAMD+6
	LDA	GOALCT
	CLC
	ADC	#01H
	STA	>VRAMD+10
	LDA	CORSNO
	ASL	A
	ASL	A
	ORA	GOALCT
	TAX
	LDA	CSIDDT,X
	STA	CORSID
MEN040	EQU	$
;
	PLB
	PLA
	RTL
;
CSIDDT	EQU	$
	HEX	00,02,03,04	;1
	HEX	00,01,02,03	;2
	HEX	00,02,03,04	;3
	HEX	00,01,02,03	;4
	HEX	00,02,03,04	;5
	HEX	00,02,03,04	;6
	HEX	00,01,02,03	;7
	HEX	00,01,02,03	;8
	HEX	00,01,02,03	;9
	HEX	00,02,03,04	;A
	HEX	00,02,03,04	;B
	HEX	00,01,02,03	;C
	HEX	00,01,02,03	;D
;
MENSDT	EQU	$
	HEX	58,73,00,05
	HEX	24,20,24,20,24,20,FF
;
;#####################################################################
;#		     (X) -- ENMY  index				     #
;#	 JSR	  BOMBST	  [ ENMY BAKUHATU KOUKA INIT ]	     #
;#	 JSR	  BOMBPT	  [ ENMY BAKUHATU KOUKA PUT  ]	     #
;#####################################################################
;
BOMBST	EQU	$
	PHY
	LDY	#0
BOM010	EQU	$
	LDA	BMSTAT,Y
	BEQ	BOM020
	INY
	CPY	#05H
	BNE	BOM010
	LDY	#0
BOM020	EQU	$
	LDA	#1
	STA	BMSTAT,Y
	LDA	<ENXSD0,X
	BPL	BOM030
	LDA	<ENXPS0,X
	XBA
	LDA	ENXPS1,X
	MEM16
	REP	#20H
	SEC
	SBC	#8H
	MEM8
	SEP	#20H
	STA	BMXPS1,Y
	XBA
	STA	BMXPS0,Y
	BRA	BOM040
BOM030	EQU	$
	LDA	<ENXPS0,X
	XBA
	LDA	ENXPS1,X
	MEM16
	REP	#20H
	CLC
	ADC	#8H
	MEM8
	SEP	#20H
	STA	BMXPS1,Y
	XBA
	STA	BMXPS0,Y
BOM040	EQU	$
	LDA	ENOBJY
	CLC
	ADC	#0CH
	STA	BMYPS1,Y
	PLY
	RTL
;
BOMBPT	EQU	$
	PHB
	PHK
	PLB
;
	PHX
	PHY
	LDX	#0
BMPT50	EQU	$
	LDA	OMBMDT,X
	TAY
	LDA	BMSTAT,X
	BEQ	BMPT10
	AND	#00001100B
	STA	<YWORK
	BNE	BMPT20
	JSR	BMPT00
	BRA	BMPT10
BMPT20	EQU	$
	CMP	#04H
	BNE	BMPT30
	JSR	BMPT01
	BRA	BMPT10
BMPT30	EQU	$
	CMP	#08H
	BNE	BMPT40
	JSR	BMPT02
	BRA	BMPT10
BMPT40	EQU	$
	STZ	BMSTAT,X
BMPT10	EQU	$
	INX
	CPX	#05H
	BNE	BMPT50
	PLY
	PLX
	PLB
	RTL
;
BMPT00	EQU	$
	JSR	BMWKAD
	LDA	BMYWK1
	CLC
	ADC	#4
	STA	OAM+01,Y
	LDA	#26H
	STA	OAM+02,Y
	LDA	#25H
	STA	OAM+03,Y
	MEM16
	REP	#20H
	LDA	BMXWK1
	CLC
	ADC	#4
	SEC
	SBC	<SCCH1
	STA	BMXWK1
	MEM8
	SEP	#20H
	LDA	BMXWK1
	STA	OAM+00,Y
	LDA	BMXWK0
	BEQ	BM0010
	LDA	#1
BM0010	EQU	$
	STA	OAMSB,Y
	INC	BMSTAT,X
	RTS
;
BMPT01	EQU	$
	JSR	BMWKAD
	LDA	BMYWK1
	STA	OAM+01,Y
	LDA	#60H
	STA	OAM+02,Y
	LDA	#25H
	STA	OAM+03,Y
	MEM16
	REP	#20H
	LDA	BMXWK1
	SEC
	SBC	<SCCH1
	STA	BMXWK1
	MEM8
	SEP	#20H
	LDA	BMXWK1
	STA	OAM+00,Y
	LDA	BMXWK0
	BEQ	BM0110
	LDA	#3
	BRA	BM0120
BM0110	EQU	$
	LDA	#2
BM0120	EQU	$
	STA	OAMSB,Y
	INC	BMSTAT,X
	RTS
;
YUPDAT	EQU	$
	HEX	FF,FE,FC,F9
YDWDAT	EQU	$
	HEX	01,02,04,07
;
BMPT02	EQU	$
	STX	<WORKE
	JSR	BMWKAD
	LDA	BMSTAT,X
	AND	#3H
	TAX
	LDA	BMYWK1
	CLC
	ADC	YUPDAT,X
	STA	OAM+01,Y
	STA	OAM+05,Y
;
	LDA	BMYWK1
	CLC
	ADC	YDWDAT,X
	CLC
	ADC	#8
	STA	OAM+09,Y
	STA	OAM+13,Y
;
	LDA	#39H
	STA	OAM+02,Y
	STA	OAM+06,Y
	STA	OAM+10,Y
	STA	OAM+14,Y
	LDA	#25H
	STA	OAM+03,Y
	STA	OAM+07,Y
	STA	OAM+11,Y
	STA	OAM+15,Y
	LDA	YUPDAT,X
	STA	<WORKC
	LDA	#0FFH
	STA	<WORKD
	MEM16
	REP	#20H
	LDA	BMXWK1
	SEC
	SBC	<SCCH1
	CLC
	ADC	<WORKC
	STA	<WORKA
	MEM8
	SEP	#20H
	LDA	<WORKA
	STA	OAM+00,Y
	STA	OAM+08,Y
	LDA	<WORKB
	BEQ	BM0211
	LDA	#1
BM0211	EQU	$
	STA	OAMSB,Y
	STA	OAMSB+8,Y
;
	LDA	YDWDAT,X
	STA	<WORKC
	STZ	<WORKD
	MEM16
	REP	#20H
	LDA	BMXWK1
	CLC
	ADC	#08H
	SEC
	SBC	<SCCH1
	CLC
	ADC	<WORKC
	STA	<WORKA
	MEM8
	SEP	#20H
	LDA	<WORKA
	STA	OAM+04,Y
	STA	OAM+12,Y
;
	LDA	<WORKB
	BEQ	BM0210
	LDA	#1
BM0210	EQU	$
	STA	OAMSB+4,Y
	STA	OAMSB+12,Y
	LDX	<WORKE
	INC	BMSTAT,X
	RTS
;
BMWKAD	EQU	$
	LDA	BMYPS1,X
	STA	BMYWK1
	LDA	BMXPS0,X
	XBA
	LDA	BMXPS1,X
	MEM16
	REP	#20H
	STA	BMXWK1
	MEM8
	SEP	#20H
	RTS
;
OMBMDT	EQU	$
	HEX	00,10,20,40,50
;
;#####################################################################
;#		     (X) -- Fire  index				     #
;#	 JSR	  KPADIE	  [ Kuppa yougan shibuki ]	     #
;#####################################################################
KPADIE	EQU	$
	PHB
	PHK
	PLB
;
	LDA	KPACNT
	CMP	#01H
	BEQ	KPDFIN
	LDA	CORSNO
	CMP	#08H
	BEQ	KPDFIN
	LDA	<KDVRFG
	CMP	#03H
	BNE	KPDFIN
	LDA	<KPAFLG
	BNE	KPD099
	LDA	KPSTFG
	BEQ	KPDFIN
	LDX	#8
KPD010	EQU	$
	LDA	<ENMYNO,X
	CMP	#2DH
	BEQ	KPD020
KPD015	EQU	$
	DEX
	BPL	KPD010
	BRA	KPMINI
KPD020	EQU	$
	LDA	ENYPS1,X
	CMP	#0B8H
	BCC	KPDFIN
	LDA	<ENCMOD,X
	AND	#80H
	BNE	KPD015
	LDA	ENXPS1,X
	CLC
	ADC	#10H
	STA	KPZXP1
	LDA	<ENXPS0,X
	ADC	#0
	STA	KPZXP0
	LDA	#8
	STA	<KPAFLG
	BRA	KPD090
KPMINI	EQU	$
	LDX	KPSTFG
	DEX
	LDA	ENYPS1,X
	CMP	#0B8H
	BCC	KPDFIN
	LDA	ENXPS1,X
	CLC
	ADC	#04H
	STA	KPZXP1
	LDA	<ENXPS0,X
	ADC	#0
	STA	KPZXP0
	LDA	#4
	STA	<KPAFLG
KPD090	EQU	$
	LDA	#25H			; Kuppa die sound!
	STA	!SOUND0
	LDA	#20H
	STA	!SOUND3			;<S!
;
KPD099	EQU	$
	JSR	KPDSUB
;
KPDFIN	EQU	$
	JMP	CFLASH
	RTL
;
KPDSUB	EQU	$
	LDA	<KPAFLG
	STA	<YWORK
	INC	KZNCNT
	LDA	KZNCNT
	LSR	A
	LSR	A
	CMP	#6
	BCS	KPZCLR
	STA	<TWORK1
	ASL	A
	ASL	A
	ASL	A
	TAX			;CHR INDEX
	LDY	#20H		;OAM INDEX
	STZ	<YWORK5		;OAMSB <= 0
KSB010	EQU	$
	TXA
	AND	#1
	CLC
	ADC	#0FFH
	STA	<YWORK4
;
	LDA	KPXPDT,X
	STA	<YWORK3
	MEM16
	REP	#20H
	LDA	<YWORK3
	CLC
	ADC	KPZXP1
	SEC
	SBC	<SCCH1
	STA	<YWORK3
	MEM8
	SEP	#20H
	LDA	<YWORK3
	STA	OAM+00,Y
	LDA	<YWORK4
	BEQ	KSB020
	LDA	#0
KSB020	EQU	$
	ORA	<YWORK5
	STA	OAMSB,Y
	LDA	KPYPDT,X
	CLC
	ADC	#0D8H
	STA	OAM+01,Y
	PHX
	LDX	<TWORK1
	LDA	KPCRDT,X
	STA	OAM+02,Y
	LDX	<YWORK
	LDA	KPATDT,X
	STA	OAM+03,Y
	PLX
	INY
	INY
	INY
	INY
	INX
	DEC	<YWORK
	BNE	KSB010
;
	RTS
;
KPZCLR	EQU	$
	STZ	KPSTFG
	STZ	<KPAFLG
	RTS
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
KPXPDT	EQU	$
	HEX	F6,02,F1,07,F2,06,ED,0B
	HEX	F3,05,EE,0A,EF,09,EA,0E
	HEX	F1,07,EC,0C,ED,0B,E8,10
	HEX	F0,08,EB,0D,EC,0C,E7,11
	HEX	EF,09,EA,0E,EB,0D,E6,12
;
KPYPDT	EQU	$
	HEX	F5,F5,F8,F8,F1,F1,F4,F4
	HEX	F4,F4,F7,F7,F0,F0,F3,F3
	HEX	F2,F2,F5,F5,EE,EE,F1,F1
	HEX	F1,F1,F4,F4,ED,ED,F0,F0
	HEX	F0,F0,F3,F3,EC,EC,EF,EF
;
KPATDT	EQU	$
	HEX	28,68,28,68,28,68,28,68,28
;
KPCRDT	EQU	$
	HEX	33,33,34,35,36,37
;
;#####################################################################
;#		     (X) -- Fire  index				     #
;#	 JSR	  FENPCV    [ Fire enmy posision convert ]	     #
;#####################################################################
FEXPOS	EQU	$
	WORD	0FFF1H,0FFF6H,0002H,0007H
	WORD	0FFEEH,0FFF3H,0005H,000AH
	WORD	0FFECH,0FFF1H,0007H,000CH
	WORD	0FFEBH,0FFF0H,0008H,000DH
	WORD	0FFEAH,0FFEFH,0009H,000EH
	WORD	0FFEAH,0FFEFH,0009H,000EH	;TS
FEYPOS	EQU	$
	HEX	F8,F5,F5,F8
	HEX	F7,F4,F4,F7
	HEX	F5,F2,F2,F5
	HEX	F4,F1,F1,F4
	HEX	F3,F0,F0,F3
	HEX	F3,F0,F0,F3			;TS
FENCHR	EQU	$
	HEX	33,33,34,35,36,37		;TS
FENATB	EQU	$
	HEX	28,28,68,68
;;;
;
FENPCV	EQU	$
	PHB
	PHK
	PLB
;;
	PHX
	PHY
;
	LDA	FIREUS,X
	CMP	#02H
	BEQ	PCVFE2
	LSR	A
	BCC	PCVFIN
	LDA	FIRECT,X
	LSR	A
	LSR	A
	CMP	#06H
	BEQ	FENCLR
	TAY
	LDA	FENCHR,Y
	STA	<WORKA		;C
	LDA	ENXPS1,X
	STA	<WORK
	LDA	<ENXPS0,X
	STA	<WORK1
	MEM16
	REP	#20H
	LDA	<WORK
	CLC
	ADC	#08H
	SEC
	SBC	<SCCH1
	STA	<WORK		;X L&H
	MEM8
	SEP	#20H
	LDA	OAMEN,X		;TEST
	CLC			;TEST
	ADC	#4		;TEST
	STA	<WORKF
	JSR	FENPUT
;;
	BRA	PCVFIN
PCVFE2	EQU	$
	BRA	FENPT2
FENCLR	EQU	$
	INC	FIREUS,X
	STZ	FIRECT,X
	LDA	FIREUS,X
	CMP	#2
	BNE	PCVFIN
	LDA	ENYPS1,X
	STA	ZANYPS,X
PCVFIN	EQU	$
	PLY
	PLX
	PLB
	RTL
;
ZANXP1	EQU	$
	WORD	0FFFFH,0FFFAH,0FFFAH,0FFFAH,0FFFFH
ZANXP2	EQU	$
	WORD	0000H,0000H,0000H,0FFFEH,0FFFEH
ZANYP1	EQU	$
	HEX	FF,00,00,00,FF
ZANYP2	EQU	$
	HEX	12,12,12,10,10
ZANCH1	EQU	$
	HEX	FC,30,31,32,FC
ZANCH2	EQU	$
	HEX	30,31,32,FC,FC
ZANMV1	EQU	$
	HEX	FF,FF,FF,00,00
;;
FENPT2	EQU	$
	LDA	FIRECT,X
	LSR	A
	LSR	A
	LSR	A
	CMP	#05
	BCC	PSKIP1
	LDA	#30H
	STA	FIRECT,X
	JMP	PT2FIN
PSKIP1	EQU	$
	STA	<WORK8
;
	ASL	A
	TAY
;
	LDA	ENXPS1,X
	STA	<WORK
	LDA	<ENXPS0,X
	STA	<WORK1
	MEM16
	REP	#20H
	LDA	<WORK
	CLC
	ADC	#08H
	SEC
	SBC	<SCCH1
	PHA
	CLC
	ADC	ZANXP1,Y
	STA	<WORK		;X L&H
	PLA
	CLC
	ADC	ZANXP2,Y
	STA	<WORK2
	MEM8
	SEP	#20H
;
	LDY	<WORK8
	LDA	ZANMV1,Y
	CLC
	ADC	ZANYPS,X
	STA	ZANYPS,X
	LDA	ZANYP1,Y
	CLC
	ADC	ZANYPS,X
	STA	<WORK4
	LDA	ZANYP2,Y
	CLC
	ADC	ZANYPS,X
	STA	<WORKA
;
	LDA	OAMEN,X ;TEST
	TAY
	INY		;TEST
	INY		;
	INY		;
	INY		;TEST
	LDX	<WORK8
;
	LDA	<WORK
	STA	OAM2,Y
	LDA	<WORK2
	STA	OAM2+4,Y
	LDA	<WORK4
	STA	OAM2+1,Y
	LDA	<WORKA
	STA	OAM2+5,Y
;
	LDA	ZANCH1,X
	STA	OAM2+2,Y
	LDA	ZANCH2,X
	STA	OAM2+6,Y
;
	LDA	#28H
	STA	OAM2+3,Y
	STA	OAM2+7,Y
;
	LDA	<WORK1
	BEQ	PT2SKP
	LDA	#01
	STA	OAMSB2,Y
PT2SKP	EQU	$
	LDA	<WORK3
	BEQ	PT2FIN
	LDA	#1
	STA	OAMSB2+4,Y
PT2FIN	EQU	$
;;
	JMP	PCVFIN
;;
;
FENPUT	EQU	$
	STY	<WORK9
	LDX	#0
;
FEP010	EQU	$
	LDA	<WORK9
	ASL	A
	ASL	A
	STA	<WORK8
	TXA
	CLC
	ADC	<WORK8
	TAY
;
	LDA	#0D8H
	CLC
	ADC	FEYPOS,Y
	STA	<WORKB		;Y
	LDA	<ENVRFG
	BNE	FEP011
	LDA	#0F0H
	STA	<WORKB		; 9-4
FEP011	EQU	$
	LDA	FENATB,X
	STA	<WORKC		;A
;
	TYA
	ASL	A
	TAY
	MEM16
	REP	#20H
	LDA	FEXPOS,Y
	CLC
	ADC	<WORK
	STA	<WORKD
	MEM8
	SEP	#20H
;
	TXA
	ASL	A
	ASL	A
	CLC
	ADC	<WORKF
	TAY
;
	LDA	<WORKD
	STA	OAM2,Y
	LDA	<WORKB
	STA	OAM2+1,Y
	LDA	<WORKA
	STA	OAM2+2,Y
	LDA	<WORKC
	STA	OAM2+3,Y
;
	LDA	<WORKE
	BEQ	FESB10
	LDA	#1
	STA	OAMSB2,Y
FESB10	EQU	$
	INX
	CPX	#04
	BNE	FEP010
;
	RTS
;
;#####################################################################
;#		     (X) -- Smoke index				     #
;#	 JSR	  SETSMK    [ Player slip smoke	 chara set ]	     #
;#####################################################################
SMKXPS	EQU	$
	HEX	1C,0E,06,08
SMKYPS	EQU	$
	HEX	18,16,1A,14
SMKCHR	EQU	$
	HEX	D0,E0,E1,FC
SMKCDT	EQU	$
	HEX	00,FC,F8,F4
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	Smoke data
SETSMK	EQU	$
	PHB
	PHK
	PLB
	PHX
	PHY
	LDA	SMKFLG
	BNE	SMKJ10
	JSR	SMKINT
SMKJ10	EQU	$
	JSR	SMKOBJ
	LDA	SMKCNT
	AND	#00100000B
	BEQ	SMKJ30
	STZ	SMKFLG
	STZ	SMKFLG2
SMKJ30	EQU	$
	PLY
	PLX
	PLB
	RTL
;
SMKINT	EQU	$
	LDX	#03H
SMILOP	EQU	$
	LDA	SMKCDT,X
	STA	SMKCNT,X
	DEX
	BPL	SMILOP
	INC	SMKFLG
	RTS
;
SMKOBJ	EQU	$
	LDX	#03H
	LDY	#30H
SMKL10	EQU	$
	LDA	SMKCNT,X
	BMI	SMKJ20
	BNE	SMKJ60
	JSR	SMXPCV
SMKJ60	EQU	$
	LSR	A
	LSR	A
	CMP	#03H
	BCS	SMKJ20
	PHX
	TAX
	LDA	SMKCHR,X
	STA	OAM+02,Y
	LDA	#38H
	STA	OAM+03,Y
	PLX
	LDA	SMOXPS,X
	SEC
	SBC	DSXP01
	STA	OAM+00,Y
	LDA	SMOYPS,X
	STA	OAM+01,Y
	BRA	SMKJ40
SMKJ20	EQU	$
	LDA	#0F8H
	STA	OAM+01,Y
SMKJ40	EQU	$
	INY
	INY
	INY
	INY
	INC	SMKCNT,X
	DEX
	BPL	SMKL10
	RTS
;
SMXPCV	EQU	$
	LDA	PLCMKI
	LSR	A
	BCC	XPLS02
;	LDA	PLOBJX
	LDA	XPOS1
	CLC
	ADC	#06H
	BRA	XPLSEN
XPLS02	EQU	$
;	LDA	PLOBJX
	LDA	XPOS1
	CLC
	ADC	#02H
XPLSEN	EQU	$
	STA	SMOXPS,X
	LDA	CHNOID
	CMP	#18H
	BEQ	PLC011
	CMP	#78H
	BNE	PLC0AA
PLC011	EQU	$
	LDA	RND0
	AND	#04H
	SEC
	SBC	#02H
	CLC
	ADC	PLOBJY
	ADC	SMKYPS
	STA	SMOYPS,X
	RTS
;
PLC0AA	EQU	$
	LDA	#0F8H
	STA	SMOYPS,X
	RTS
;
;
;*********************************************************************
;*	TITLE BG DATA					(TILBGDT)    *
;*********************************************************************
;
TILBGDT EQU	$
	HEX	00,A5,40,2A		;;;;WAKU(YOKO)
	WORD	3982H
	HEX	00,D0,40,14		;;;;BLANK
	WORD	3984H
	HEX	00,F0,40,14		;;;;BLANK
	WORD	3984H
	HEX	01,10,40,14		;;;;BLANK
	WORD	3984H
	HEX	00,C4,C0,10		;;;;WAKU(TATE)
	WORD	3983H
	HEX	00,C5,C0,10		;;;;BLANK
	WORD	3984H
;
	HEX	00,C6,00,13					;;;;
	WORD	3985H,3986H,3987H,3987H,3988H,3989H,398AH,398BH	   ;
	WORD	3988H,3989H					   ;
	HEX	00,E6,00,13					   ;
	WORD	398CH,398DH,398EH,398FH,3990H,3991H,3992H,3993H	   ;SUPER
	WORD	3990H,3994H					   ;
	HEX	01,06,00,13					   ;
	WORD	3995H,3996H,3995H,3996H,3997H,3984H,3995H,3998H	   ;
	WORD	3997H,3999H					;;;;
;
	HEX	01,26,00,29					;;;;
	WORD	398AH,399AH,798AH,398AH,798AH,3988H,798AH,399BH	   ;
	WORD	398AH,798AH,3984H,3988H,798AH,3988H,798AH,398AH	   ;
	WORD	798AH,398AH,798AH,3984H,3984H			   ;
	HEX	01,46,00,29					   ;
	WORD	399CH,399DH,399DH,399CH,399DH,399CH,399EH,399CH	   ;
	WORD	399CH,399DH,3984H,399CH,39C7H,399CH,39C7H,399CH	   ;
	WORD	399DH,39C8H,39C9H,3984H,3984H			   ;MARIO BROS
	HEX	01,66,00,29					   ;
	WORD	399FH,399FH,399FH,39A0H,39A1H,399FH,39A2H,399FH	   ;
	WORD	399FH,399FH,3984H,399FH,39A2H,399FH,39A2H,399FH	   ;
	WORD	399FH,39CAH,39CBH,3984H,3984H			   ;
	HEX	001,019,000,003					   ;
	WORD		039E4H,039E5H				   ;
	HEX	01,86,00,29					   ;
	WORD	39A3H,39A3H,39A3H,39A4H,39A5H,39A3H,39A3H,39A3H	   ;
	WORD	39A6H,39A7H,3984H,39A3H,39CCH,39A3H,39A3H,39A6H	   ;
	WORD	39A7H,39A6H,39A7H,39CDH,3984H			;;;;
;
	HEX	01,A6,00,29					;;;;
	WORD	39A8H,39A9H,39AAH,39ABH,39ACH,39ADH,39AEH,39AFH	   ;
	WORD	39B0H,39B1H,39CEH,39ACH,39CFH,39ADH,39D0H,39D1H	   ;
	WORD	39D2H,39D3H,39D4H,39D5H,3984H			   ;
	HEX	01,C6,00,29					   ;THE LOST ....
	WORD	39B2H,39B3H,39B4H,39B5H,3984H,39B6H,39B7H,39B8H	   ;
	WORD	39B9H,39BAH,39D6H,3984H,39D7H,39D8H,39D9H,39DAH	   ;
	WORD	39DBH,39DCH,39DDH,39DEH,3984H			;;;;
;
	HEX	00,DB,C0,10		;;;;WAKU(TATE)
	WORD	39C6H
;
	HEX	01,E4,00,2F		;;;;WAKU(YOKO)
	WORD	39BBH,39BCH,39BDH,39BEH,39BFH,39C0H,39BCH,39C1H
	WORD	39C2H,39C3H,39C4H,79C4H,39BFH,39BCH,39DFH,39E0H
	WORD	39C2H,79BFH,39E1H,79E1H,39E2H,39E3H,39BCH,3980H
	HEX	00,A4,00,01		;;;;KADO
	WORD	3981H
	HEX	00,BB,00,01		;;;;KADO
	WORD	39C5H
;
	HEX	02,0A,00,25		;;;;1986....
	WORD	062FH,0401H,0409H,0408H,0406H,0424H
	WORD	0401H,0409H,0409H,0403H,0424H,0417H,0412H	;;;
	WORD	0417H,041DH,040EH,0417H,040DH,0418H
	HEX	02,4E,00,15		;;;;MARIO GAME
	WORD	0816H,080AH,081BH,0812H,0818H,0824H
	WORD	0810H,080AH,0816H,080EH,0824H
	HEX	02,8E,00,15		;;;;LUIGI GAME
	WORD	0815H,081EH,0812H,0810H,0812H,0824H
	WORD	0810H,080AH,0816H,080EH,0824H
	HEX	02,EB,00,07		;;;;TOP....
	WORD	081DH,0818H,0819H,0828H
	HEX	02,F5,00,01
	WORD	0800H
;
	WORD	0FFFFH			; end code
;
TITLST	EQU	$
;
		PHB
		PHK
		PLB
;
		LDA	#001H
		STA	!MZRTFG
;
		MEM16
		IDX16
		REP	#00110000B	; memory , index 16bit mode
;
		LDX	VRAMD
		LDY	#0000H
BGTS50		EQU	$
		LDA	TILBGDT,Y
		STA	VRAMD+2,X
		INC	A
		BEQ	BGTS55
		INX
		INX
		INY
		INY
		BRA	BGTS50
;
BGTS55		EQU	$
;;;		LDA	STARCT
;;;		AND	#000FH
;;;		BEQ	BGTS60
;;;		CMP	#8
;;;		BCC	BGTS57
;;;		LDA	#8
;;;BGTS57		EQU	$
;;;		ASL	A
;;;		DEC	A
;;;		DEC	A
;;;		ORA	#4000H
;;;		XBA
;;;		STA	VRAMD+4,X
;;;		LDA	#0F100H
;;;		STA	VRAMD+2,X
;;;		LDA	#0829H
;;;		STA	VRAMD+6,X
;;;		LDA	#0FFFFH
;;;		STA	VRAMD+8,X
;;;		INX
;;;		INX
;;;		INX
;;;		INX
;;;		INX
;;;		INX
;;;BGTS60		EQU	$
		STX	VRAMD
;
		MEM8
		IDX8
		SEP	#00110000B	; memory , index 8bit mode
;
		STZ	WARPCT
		PLB
		RTL
;
;
;#####################################################################
;#		      Yr -- Wood Number				     #
;#	 JSR	  WDCSET    [ Wood chara set   ]		     #
;#####################################################################
;--- Cset ------
WDDATA	 EQU	  $
	 HEX	  00,30
;
WDCSET	 EQU	  $
	PHB
	PHK
	PLB
	 STY	  <WORK
;
	 LDA	  ENOBJY
;
	 LDX	  WDUSED,Y
	 LDY	  OAMEN,X	  : Oam index
	 STY	  <WORK+2	   : <M>
;
	DEC	A
	 JSR	  OMST1		  : <M>
;
	 LDA	  ENOBJX
	 STA	  OAM2+00,Y
	 STA	  OAM2+08,Y
	 STA	  OAM2+16,Y
	 STA	  OAM2+04,Y
	 STA	  OAM2+12,Y
	 STA	  OAM2+20,Y
	 STA	  OAM2+24,Y
	 STA	  OAM2+28,Y
	 STA	  OAM2+32,Y
;
;---- Flip --------
	 LDA	  #00011011B	  : BG>Obj , Color = 1
	 STA	  OAM2+03,Y
	 STA	  OAM2+11,Y
	 STA	  OAM2+19,Y
;
	 STA	  OAM2+07,Y
	 STA	  OAM2+15,Y
	 STA	  OAM2+23,Y
	 STA	  OAM2+27,Y
	 STA	  OAM2+31,Y
	 STA	  OAM2+35,Y
;
;--- Character No. ----------
	 LDX	  #8
WDC010	 EQU	  $
	 LDA	  #02CH
	 STA	  OAM2+02,Y
	 INY
	 INY
	 INY
	 INY
	 DEX
	 BPL	  WDC010
;
	 LDY	  <WORK+2
;
	 LDA	  WORK
	 BNE	  WDC015
	 LDA	  #02AH		  : Top of wood No.
	 STA	  OAM2+02,Y
WDC015	 EQU	  $
;
	LDA	WDLONG
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	INC	A
	TAX
	ASL	A
	ASL	A
	CLC
	ADC	<WORK2
	TAY
WDC020	 EQU	  $
	CPX	#9
	BCS	WDC040
	 LDA	  #0F0H	    : Yes ! (Clear)
	 STA	  OAM2+01,Y
WDC030	 EQU	  $
	 INY
	 INY
	 INY
	 INY
;
	 INX
;
	BRA	WDC020
;
WDC040	EQU	$
	 LDY	  WORK
	PLB
	 RTL
;
OMST1	 EQU	  $
	 LDX	  #9
OMST120	 EQU	  $
	 STA	  OAM2+01,Y
	PHA
;
	LDA	MSXPS1
	STA	<YWORK
	LDA	<MSXPS0
	STA	<YWORK1
	MEM16
	REP	#20H
	LDA	<YWORK
	SEC
	SBC	<SCCH1
	STA	<YWORK
	MEM8
	SEP	#20H
;
	LDA	#2		;XPOS CHECK
	STA	<TWORK1
	LDA	<YWORK1
	BEQ	OMST130
	LDA	#1
OMST130 EQU	$
	ORA	<TWORK1
	STA	OAMSB+100H,Y
;
	LDA	WDSTFG		;YPOS CHECK
	BNE	OMST140
	LDA	OAM2+01,Y
	BPL	OMST140
	CMP	#0F0H
	BCS	OMST140
	LDA	#0F0H
	STA	OAM2+01,Y
OMST140 EQU	$
	PLA
OMST150 EQU	$
	 CLC
	 ADC	  #10H
	 INY
	 INY
	 INY
	 INY
	 DEX
	 BNE	  OMST120
;
	 LDY	  <WORK+2
	 RTS
;
;
;#####################################################################
;#		      Xr -- Index				     #
;#	 JSR	  COSCST    [ Coin  score chara set   ]		     #
;#####################################################################
;;;;COSCST	 EQU	  $
;;;;	LDY	OAMBL
;;;;	MEM16
;;;;	REP	#20H
;;;;	LDA	CLXPOS
;;;;	SEC
;;;;	SBC	<SCCH1
;;;;	STA	BKXPOS
;;;;	MEM8
;;;;	SEP	#20H
;;;;	LDA	COSTFG
;;;;	BNE	COINBK
;;;;	LDA	BKYPOS
;;;;	STA	OAM+01,Y
;;;;	LDA	BKXPOS
;;;;	JSR	FMCKSB
;;;;	STA	OAM+00,Y
;;;;	LDA	#26H
;;;;	STA	OAM+02,Y
;;;;	LDA	#29H
;;;;	STA	OAM+03,Y
;;;;	DEC	COBKCT
;;;;	BEQ	COJP20
;;;;	JMP	COINFN
;;;;COJP20	EQU	$
;;;;	LDA	#06
;;;;	STA	COBKCT
;;;;	INC	COSTFG
;;;;	BRA	COINFN
;;;;COINBK	EQU	$
;;;;	LDA	COSTFG
;;;;	CMP	#06
;;;;	BCS	COINFN
;;;;	PHX
;;;;	LDX	COSTFG
;;;;	LDA	COXDT1,X
;;;;	CLC
;;;;	ADC	BKXPOS
;;;;	STA	OAM+00,Y
;;;;	STA	OAM+04,Y
;;;;	JSR	FMCKSB
;;;;	LDA	COYDT1,X
;;;;	CLC
;;;;	ADC	BKYPOS
;;;;	STA	OAM+01,Y
;;;;	CLC
;;;;	ADC	#08H
;;;;	STA	OAM+05,Y
;;;;;
;;;;	LDA	COXDT2,X
;;;;	CLC
;;;;	ADC	BKXPOS
;;;;	STA	OAM+08,Y
;;;;	STA	OAM+12,Y
;;;;	JSR	FMCKSB
;;;;	LDA	COYDT1,X
;;;;	CLC
;;;;	ADC	BKYPOS
;;;;	STA	OAM+09,Y
;;;;	CLC
;;;;	ADC	#08H
;;;;	STA	OAM+13,Y
;;;;;
;;;;	LDX	COSTFG
;;;;	DEX
;;;;	TXA
;;;;	ASL	A
;;;;	ASL	A
;;;;	TAX
;;;;	LDA	#03
;;;;	STA	<WORK4
;;;;COLP10	EQU	$
;;;;	LDA	BKCHR0,X
;;;;	STA	OAM+02,Y
;;;;	LDA	BKATB0,X
;;;;	STA	OAM+03,Y
;;;;	INY
;;;;	INY
;;;;	INY
;;;;	INY
;;;;	INX
;;;;	DEC	<WORK4
;;;;	BPL	COLP10
;;;;	DEC	COBKCT
;;;;	BNE	COJP10
;;;;	LDA	#06
;;;;	STA	COBKCT
;;;;	INC	COSTFG
;;;;COJP10	EQU	$
;;;;	PLX
;;;;COINFN	EQU	$
;;;;	 JMP	  COCSCK
;;;;;;;
;;;;COJP70	EQU	$
;;;;	 LDA	  <FMCNT	   ; Score fly up
;;;;	 LSR	  A
;;;;	 BCS	  G1
;;;;	 DEC	  COYPS1,X
;;;;G1	 EQU	  $
;;;;	 LDA	  COYPS1,X
;;;;	STA	OAM+1,Y
;;;;;
;;;;	 LDA	  COOBJX
;;;;	 STA	  OAM+00,Y	;X
;;;;	LDA	#02H
;;;;	STA	OAMSB,Y
;;;;	CMP	#0F8H
;;;;	BCC	COSJ10
;;;;	LDA	#03H
;;;;	STA	OAMSB,Y
;;;;COSJ10	EQU	$
;;;;	 LDA	  #23H		    ; Color
;;;;	 STA	  OAM+03,Y	;A
;;;;;
;;;;	 LDA	  #2EH		 ; "100" Points
;;;;	 STA	  OAM+02,Y	;C
;;;;	JMP	COSCST
;;;;;;;;
;
;************************ bug (Ver.up)/H5.7.8/ (up) ************************
COSCST	 EQU	  $
	LDY	OAMBL
	MEM16
	REP	#20H
	LDA	CLXPOS
	SEC
	SBC	<SCCH1
	STA	BKXPOS
	MEM8
	SEP	#20H
	LDA	COSTFG
	BNE	COINBK
	LDA	BKYPOS
	STA	OAM+01,Y
	LDA	BKXPOS
	JSR	FMCKSB
	STA	OAM+00,Y
	LDA	#26H
	STA	OAM+02,Y
	LDA	#29H
	STA	OAM+03,Y
	DEC	COBKCT
	BEQ	COJP20
	JMP	COINFN
COJP20	EQU	$
	LDA	#06
	STA	COBKCT
	INC	COSTFG
	BRA	COINFN
COINBK	EQU	$
	LDA	COSTFG
	CMP	#06
	BCS	COINFN
	PHX
;
	JSR	COOMST
;
	LDX	COSTFG
	DEX
	TXA
	ASL	A
	ASL	A
	TAX
	LDA	#03
	STA	<WORK4
COLP10	EQU	$
	LDA	BKCHR0,X
	STA	OAM+02,Y
	LDA	BKATB0,X
	STA	OAM+03,Y
	INY
	INY
	INY
	INY
	INX
	DEC	<WORK4
	BPL	COLP10
	DEC	COBKCT
	BNE	COJP10
	LDA	#06
	STA	COBKCT
	INC	COSTFG
COJP10	EQU	$
	PLX
COINFN	EQU	$
	 JMP	  COCSCK
;;;
COJP70	EQU	$
	 LDA	  <FMCNT	   ; Score fly up
	 LSR	  A
	 BCS	  G1
	 DEC	  COYPS1,X
G1	 EQU	  $
	 LDA	  COYPS1,X
	STA	OAM+1,Y
;
	 LDA	  COOBJX
	 STA	  OAM+00,Y	;X
	LDA	#02H
	STA	OAMSB,Y
	CMP	#0F8H
	BCC	COSJ10
	LDA	#03H
	STA	OAMSB,Y
COSJ10	EQU	$
	 LDA	  #23H		    ; Color
	 STA	  OAM+03,Y	;A
;
	 LDA	  #2EH		 ; "100" Points
	 STA	  OAM+02,Y	;C
	JMP	COSCST
;;;;
;
COOMST	EQU	$
	LDX	COSTFG
		MEM16
		REP	#20H
	LDA	COXDT1,X
		AND	#00FFH
		ORA	#0FF00H
	CLC
	ADC	BKXPOS
		MEM8
		SEP	#20H
	STA	OAM+00,Y
	STA	OAM+04,Y
	JSR	FMCKSB
		XBA
		BEQ	COXC10
		LDA	#1
		STA	!OAMSB,Y
		STA	!OAMSB+4,Y
COXC10		EQU	$
	LDA	COYDT1,X
	CLC
	ADC	BKYPOS
	STA	OAM+01,Y
	CLC
	ADC	#08H
	STA	OAM+05,Y
		CMP	#0F8H
		BCS	COYC10
		CMP	#0B0H
		BCC	COYC10
		LDA	#0F0H
		STA	!OAM+01,Y
		STA	!OAM+05,Y
COYC10		EQU	$
;
		MEM16
		REP	#20H
	LDA	COXDT2,X
		AND	#00FFH
	CLC
	ADC	BKXPOS
		MEM8
		SEP	#20H
	STA	OAM+08,Y
	STA	OAM+12,Y
	JSR	FMCKSB
		XBA
		BEQ	COXC20
		LDA	#1
		STA	!OAMSB+8,Y
		STA	!OAMSB+12,Y
COXC20		EQU	$
	LDA	COYDT1,X
	CLC
	ADC	BKYPOS
	STA	OAM+09,Y
	CLC
	ADC	#08H
	STA	OAM+13,Y
		CMP	#0F8H
		BCS	COYC20
		CMP	#0B0H
		BCC	COYC20
		LDA	#0F0H
		STA	!OAM+09,Y
		STA	!OAM+13,Y
COYC20		EQU	$
		RTS
;
;************************ bug (Ver.up)/H5.7.8/ (down) ************************
;;;;;;;
COXDT1	EQU	$
	HEX	00,FC,FB,FA,FA,FA
COXDT2	EQU	$
	HEX	00,04,05,06,06,06
COYDT1	EQU	$
	HEX	00,FC,FC,FE,FE,FF
BKCHR0	EQU	$
	HEX	27,27,28,28
	HEX	36,37,36,37
	HEX	36,37,36,37
	HEX	38,29,38,29
	HEX	38,29,38,29
BKATB0	EQU	$
	HEX	29,A9,29,A9
	HEX	29,29,69,69
	HEX	29,29,69,69
	HEX	29,29,69,69
	HEX	29,29,69,69
;
FMCKSB	EQU	$
	PHA
	CMP	#0F8H
	BCC	FMCKFN
	LDA	#01
	STA	OAMSB,Y
	STA	OAMSB+4,Y
FMCKFN	EQU	$
	PLA
	RTS
;
COBINT	EQU	$
	LDA	COYPS1,X
	CLC
	ADC	#04H
	STA	BKYPOS
	LDA	COXPS1,X
	STA	CLXPOS
	LDA	COXPS0,X
	STA	CLXPOS+1
	LDA	#06H
	STA	COBKCT
	STZ	COSTFG
	RTL
;
;#####################################################################
;#		      Xr -- Index				     #
;#	 JSR	  COCSET    [ Coin  chara set	]		     #
;#####################################################################
COICDT	EQU	 $
	HEX	 28,2A,2C,2E
;
COCSET	EQU	 $
	PHB
	PHK
	PLB
	LDY	 !OAMCO,X
;
	LDA	 <COSTAT,X
	CMP	 #2
	BCC	COST10
	JMP	COJP70
COST10	EQU	$
	LDA	<COYCL0,X
	BMI	COC05
	JMP	COSCST
COC05	EQU	$
;
	LDA	 COYPS1,X
	CMP     #0B0H		;bug (Ver.up)/H5.7.8/
	BCC     COC06		;bug (Ver.up)/H5.7.8/
	LDA     #0F0H		;bug (Ver.up)/H5.7.8/
COC06   EQU     $		;bug (Ver.up)/H5.7.8/
	STA	 OAM+01,Y	;Y
;
	LDA	 COOBJX
	SEC
	SBC	#4
	STA	<YWORK
	CMP	#0F0H
	BCS	COC10
	LDA	#02H
	BRA	COC20
COC10	EQU	$
	LDA	#03H
COC20	EQU	$
	STA	OAMSB,Y
	LDA	<YWORK
	STA	 OAM+00,Y	;X
;
	LDA	 <FMCNT
	LSR	 A
	AND	 #3
	TAX
;
	LDA	 COICDT,X
	STA	OAM+2,Y
;
	LDA	 #28H
	STA	 OAM+03,Y	;A
;
	LDX	 <INDEX
;
COCSCK	EQU	 $
CPCS80	EQU	 $
	PLB
	RTL
;
;;
;#####################################################################
;#		      (X)-- Index				     #
;#	 JSR	  HMCSET    [ Hammer	 set   ]		     #
;#####################################################################
HMDTX1	 EQU	  $
	 HEX	  04,00,04,00
HMDTY1	 EQU	  $
	 HEX	  00,04,00,04
HMDTX2	 EQU	  $
	 HEX	  00,08,00,08
HMDTY2	 EQU	  $
	 HEX	  08,00,08,00
HMDTC1	 EQU	  $
	 HEX	  44,46,44,46
HMDTC2	 EQU	  $
	 HEX	  81,83,80,82
HMDTAT	 EQU	  $
	 HEX	  2A,2A,AA,6A
;
HMCSET	 EQU	  $
	PHB
	PHK
	PLB
	 LDY	  !OAMHM,X
;
	 LDA	  GMSTTM
	 BNE	  HMSTOP
;
	 LDA	  <HMSTAT,X
	 AND	  #01111111B
	 CMP	  #1
	 BEQ	  HMSPIN
;
HMSTOP	 EQU	  $
	 LDX	  #0
	 BEQ	  HMC001
;
HMSPIN	 EQU	  $
	 LDA	  <FMCNT
	 LSR	  A
	 LSR	  A
	 AND	  #3
	 TAX
;
HMC001	 EQU	  $
	 LDA	  COOBJY
	 CLC
	 ADC	  HMDTY1,X
	 STA	  OAM+01,Y	;Y
;
;;	   CLC
;;	   ADC	    HMDTY2,X
;;	   STA	    OAM+05,Y	;Y
;
	MEM16
	REP	#20H
	LDA	HMDTX1,X
	AND	#00FFH
	CLC
	ADC	 BKOX16
	SEC
	SBC	#08H
	STA	<YWORK
	MEM8
	SEP	#20H
;
	LDA	<YWORK
	STA	 OAM+00,Y	;X
	LDA	#2
	STA	OAMSB,Y
	LDA	<YWORK+1
	BEQ	HMC010
	LDA	#3
	STA	OAMSB,Y
HMC010	EQU	$
;
;;	MEM16
;;	REP	#20H
;;	LDA	HMDTX2,X
;;	AND	#00FFH
;;	CLC
;;	ADC	 <YWORK
;;	STA	<YWORK
;;	MEM8
;;	SEP	#20H
;;	LDA	<YWORK
;;	  STA	   OAM+04,Y	;X
;;	LDA	<YWORK+1
;;	BEQ	HMC020
;;	LDA	#1
;;	STA	OAMSB+4,Y
HMC020	EQU	$
;
	 LDA	  HMDTC1,X
	 STA	  OAM+02,Y	;C
;;	   LDA	    HMDTC2,X
;;	   STA	    OAM+06,Y	;C
;
	 LDA	  HMDTAT,X
	 STA	  OAM+03,Y	;A
;;	   STA	    OAM+07,Y	;A
;
	 LDA	  COFMSD
	AND	#00001111B
	CMP	#0FH
	BEQ	HMCS03
	LDA	COFMSD
	 AND	  #11110000B
	 BEQ	  HMCS10
HMCS03	 EQU	  $
	 LDX	  <INDEX
	STZ	<HMSTAT,X
HMCS10	 EQU	  $
	 LDX	  <INDEX
	PLB
	 RTL
;
;*********************************************************************
;*	 OAMSB	HENKAN ROUTINE		(OSBSET)	;;T;;	     *
;*********************************************************************
OSBSET		EQU	$
		PHD			; (D) push
		LDA	#HIGH OAMSB
		XBA
		LDA	#000H
		TCD			; (D) <-- OAMSB
;
		IDX16
		REP	#10H
;
		LDX	#00000H
		TXY
OSBL10		EQU	$
		LDA	<OAMSB+12,X
		LSR	A
		ROR	A
		ROR	A
		STA	<XWORK0
		LDA	<OAMSB+8,X
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TSB	<XWORK0
		LDA	<OAMSB+4,X
		ASL	A
		ASL	A
		TSB	<XWORK0
		LDA	<OAMSB,X
		ORA	<XWORK0
		STA	OAMSUB,Y
		INY
;
		LDA	<OAMSB+12+10H,X
		LSR	A
		ROR	A
		ROR	A
		STA	<XWORK0
		LDA	<OAMSB+8+10H,X
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TSB	<XWORK0
		LDA	<OAMSB+4+10H,X
		ASL	A
		ASL	A
		TSB	<XWORK0
		LDA	<OAMSB+10H,X
		ORA	<XWORK0
		STA	OAMSUB,Y
		INY
;
		MEM16
		REP	#20H
		TXA
		CLC
		ADC	#0020H
		TAX
		MEM8
		SEP	#20H
;
		CPX	#0200H
		BCC	OSBL10
;
		IDX8
		SEP	#10H
;
		PLD			; (D) pull
		RTL
;
;
;#####################################################################
;#		     (X) -- Bubble index			     #
;#	 JSR	  PLBLCT    [ Player bubble chara set ]		     #
;#####################################################################
PLBLCT	 EQU	  $
	LDA	BLCLFG
	BNE	PLBC90
	 LDY	  <PLYPS0
	 DEY
	 BNE	  PLBC90	  ;- IF	 player in display frame ?  ( NO ; PLBC90 )
;
	 LDA	  BLFMSD
	 AND	  #00001000B
	 BNE	  PLBC90	  ;- IF	 bubble in display frame ?  ( NO ; PLBC90 )
;
	 LDY	  !OAMBL,X	  ;< Bubble chara set >
	 LDA	  BLOBJX
	 STA	  OAM+00,Y	;X     ; (x) pos set
;
	 LDA	  BLOBJY
	 STA	  OAM+01,Y	;Y     ; (y) pos set
;
	 LDA	  #9FH
	 STA	  OAM+02,Y	;C     ; Chara No. set
;
	LDA	<PLCMOD
	CMP	#07
	BNE	PLBC85
	LDA	#00001010B
	BRA	PLBC87
PLBC85	EQU	$
	 LDA	  #00101010B
PLBC87	EQU	$
	 STA	  OAM+03,Y	;A     ; Color set
;
PLBC90	 EQU	  $
;
	 RTL
;
;#####################################################################
;#	 JSR	  CFLASH    [ Coin & Block Flash ]		     #
;#####################################################################
;
CFDAT	EQU	$	;COIN DATA
	WORD	1BDFH,027FH,0139H,0000H
	WORD	4BFFH,1F5FH,0D9CH,0000H
	WORD	7FFFH,4BFFH,19FFH,0000H
BFDAT	 EQU	  $	;BLOCK DATA
	 HEX	  DA,1A,F3,0D,0D,05,00,00
	 HEX	  5E,2B,77,1E,70,11,00,00
	 HEX	  DF,3B,FB,2E,D3,1D,00,00
OFDAT	 EQU	  $	;ONO DATA
	 HEX	  7F,47,98,32,B1,15,00,00
	 HEX	  1B,67,34,4A,4D,2D,00,00
	 HEX	  97,7E,B0,6D,EA,54,00,00
MCDAT	 EQU	  $	;SCORE COIN DATA
	 HEX	  5F,03,59,02,00,38,00,00
	 HEX	  FF,03,BC,02,16,00,00,00
	 HEX	  FF,7F,FF,47,DF,00,00,00
CHDAT	 EQU	  $	;CHIKA	DATA
	WORD	2CC5H,3D89H,3DCDH,4E51H,2EF8H,1E74H,1C41H,28A3H
	WORD	28A4H,3548H,3D8BH,4A0FH,32D6H,1E31H,1C41H,28A3H
	WORD	2062H,2CC6H,3927H,418BH,3250H,21ABH,1C41H,28A3H
	WORD	2483H,3107H,3949H,45CDH,3293H,1DEEH,1C41H,28A3H
	WORD	2062H,2CC6H,3927H,418BH,3250H,21ABH,1C41H,28A3H
	WORD	2483H,3107H,3949H,45CDH,3293H,1DEEH,1C41H,28A3H
	WORD	28A4H,3548H,3D8BH,4A0FH,32D6H,1E31H,1C41H,28A3H
	WORD	2CC5H,3D89H,3DCDH,4E51H,2EF8H,1E74H,1C41H,28A3H
;;;;
CFLASH	 EQU	  $
	LDA	CLRFLG
	BEQ	CFL003
	PLB
	RTL
;
CFL003	EQU	$
	INC	FLCNT
	LDA	FLCNT
	AND	#07		; 8 FLAME ?
	BEQ	CFL005
	JMP	ONOFLS		; NO
CFL005	EQU	$
	INC	CFWORK
	LDA	CFWORK
	CMP	#03H
	BNE	CFL010
	STZ	CFWORK
	LDA	#0
CFL010	EQU	$
	ASL	A
	ASL	A
	ASL	A
	TAX
	MEM16
	REP	#20H
	LDA	CFDAT,X
	STA	!CGWORK+26H
	LDA	MCDAT,X
	STA	!CGWORK+0AH
	LDA	BFDAT,X
	STA	!CGWORK+2CH
	LDA	CFDAT+2,X
	STA	!CGWORK+28H
	LDA	MCDAT+2,X
	STA	!CGWORK+0CH
	LDA	BFDAT+2,X
	STA	!CGWORK+2EH
	LDA	CFDAT+4,X
	STA	!CGWORK+2AH
	LDA	MCDAT+4,X
	STA	!CGWORK+0EH
	LDA	BFDAT+4,X
	STA	!CGWORK+30H
	MEM8
	SEP	#20H
;
CFL030	EQU	$
	LDA	FLSHFG
	BEQ	CFL040
	DEC	A
	ASL	A
	TAX
	LDA	FLASHDT,X
	STA	<YWORK
	LDA	FLASHDT+1,X
	STA	<YWORK1
	LDA	#5
	STA	<YWORK2
	JMP	(YWORK)
;
FLASHDT EQU	$
	WORD	TAKICL
	WORD	NIGHCL
	WORD	CHIKCL
	WORD	WNDFLS
;
NIGHCL	EQU	$
CFL040	EQU	$
	LDA	#1		; CGSET FLAG ON
	STA	!CGVMAF
ONOFLS	EQU	$		;ONO FLASH
	LDA	FLCNT
	AND	#03H
	BNE	CFLRTL
	INC	CBWORK
	LDA	CBWORK
	CMP	#03H
	BNE	CFL020
	STZ	CBWORK
	LDA	#0
CFL020	EQU	$
	ASL	A
	ASL	A
	ASL	A
	TAX
	MEM16
	REP	#20H
	LDA	OFDAT,X
	STA	!CGWORK+32H
	LDA	OFDAT+2,X
	STA	!CGWORK+34H
	LDA	OFDAT+4,X
	STA	!CGWORK+36H
	MEM8
	SEP	#20H
	LDA	#1
	STA	!CGVMAF
;
CFLRTL	EQU	$
	PLB
	RTL
;
TAKICL	EQU	$		; TAKI COLER
	LDA	FLCNT
	AND	#38H
	LSR	A
	LSR	A
	TAX
	MEM16
	REP	#20H
	LDA	TKCDT3,X
	STA	CGWORK+0E6H
	LDA	TKCDT4,X
	STA	CGWORK+0E8H
	LDA	TKCDTD,X
	STA	CGWORK+0FAH
	LDA	TKCDTE,X
	STA	CGWORK+0FCH
	LDA	TKCDTF,X
	STA	CGWORK+0FEH
	MEM8
	SEP	#20H
	JMP	CFL040
;
CHIKCL	EQU	$		; CHIKA COLER
	LDA	FLCNT
	AND	#38H
	ASL	A
	TAX
	MEM16
	REP	#20H
	LDA	CHDAT,X
	STA	!CGWORK+0E6H
	LDA	CHDAT+2,X
	STA	!CGWORK+0E8H
	LDA	CHDAT+4,X
	STA	!CGWORK+0EAH
	LDA	CHDAT+6,X
	STA	!CGWORK+0ECH
	LDA	CHDAT+8,X
	STA	!CGWORK+0EEH
	LDA	CHDAT+10,X
	STA	!CGWORK+0F0H
	MEM8
	SEP	#20H
	JMP	CFL040
;
TKCDT3	EQU	$		;TAKI DATA
	WORD	7FBFH,7F38H,76B4H,7230H,7FBFH,7F38H,76B4H,7230H
TKCDT4	EQU	$
	WORD	7F38H,76B4H,7230H,7FBFH,7F38H,76B4H,7230H,7FBFH
TKCDTD	EQU	$
	WORD	76B4H,7230H,7FBFH,7F38H,76B4H,7230H,7FBFH,7F38H
TKCDTE	EQU	$
	WORD	69C9H,6187H,5945H,5103H,69C9H,69C9H,69C9H,5946H
TKCDTF	EQU	$
	WORD	7230H,7FBFH,7F38H,76B4H,7230H,7FBFH,7F38H,76B4H
;
WNDDT1	EQU	$
	WORD	0C63H,1CE5H,2927H,2506H
	WORD	0C63H,1D07H,252AH,2109H
	WORD	0C63H,1929H,212CH,1D2BH
	WORD	0C63H,1D07H,252AH,2109H
	WORD	0C63H,1CE5H,2927H,2506H
	WORD	0C63H,1D07H,252AH,2109H
	WORD	0C63H,1929H,212CH,1D2BH
	WORD	0C63H,1D07H,252AH,2109H
;
WNDDT2	EQU	$
	WORD	0077H,017AH
	WORD	0098H,019BH
	WORD	00B9H,01BCH
	WORD	00FBH,01FEH
	WORD	00DAH,01DDH
	WORD	00B9H,01BCH
	WORD	0098H,019BH
	WORD	0077H,017AH
;
WNDFLS	EQU	$
	LDA	FLCNT
	AND	#038H
	TAX
	LSR	A
	TAY
	MEM16
	REP	#20H
	LDA	WNDDT1,X
	STA	CGWORK+0E2H
	LDA	WNDDT1+2,X
	STA	CGWORK+0E4H
	LDA	WNDDT1+4,X
	STA	CGWORK+0E6H
	LDA	WNDDT1+6,X
	STA	CGWORK+0E8H
	LDA	WNDDT2,Y
	STA	CGWORK+0FCH
	LDA	WNDDT2+2,Y
	STA	CGWORK+0FEH
	MEM8
	SEP	#20H
;;TT;;
	LDA	<ENMYNO
	CMP	#35H
	BEQ	SNDSKP
;;TT;;
	LDA	SNDRCT
	BNE	SNDNIN
	LDA	RND0
	AND	#0FH
	BNE	SNDSKP
;
	LDA	<PLCMOD
	CMP	#8
	BNE	SNDR10
	LDA	#18H
	STA	!SOUND3
;
SNDR10	EQU	$
	LDA	#11H
	STA	COLERR
	LDA	#1FH
	STA	COLERG
	STA	COLERB
	INC	SNDRCT
	BRA	SNDRST
SNDNIN	EQU	$
	DEC	COLERR
	DEC	COLERG
	DEC	COLERG
	DEC	COLERB
	DEC	COLERB
	DEC	COLERR
	DEC	COLERG
	DEC	COLERG
	DEC	COLERB
	DEC	COLERB
	LDA	COLERR
	CMP	#3
	BNE	SNDRST
	STZ	SNDRCT
SNDRST	EQU	$
	MEM16
	REP	#20H
	LDA	COLERR
	AND	#00FFH
	XBA
	ASL	A
	ASL	A
	STA	<YWORK
	LDA	COLERG
	AND	#00FFH
	XBA
	LSR	A
	LSR	A
	LSR	A
	ORA	<YWORK
	ORA	COLERB
	STA	<YWORK
	STA	CGWORK+0E2H
	MEM8
	SEP	#20H
SNDSKP	EQU	$
WNDFIN	EQU	$
	JMP	CFL040
;
CHRCHNG EQU	$
	STZ	WRTFLG
	LDA	<FMCNT
	AND	#00000111B
	BNE	CHNRETX
	LDA	<FMCNT
	AND	#00111000B
	LSR	A
	LSR	A
	LSR	A
	STA	<WORK4
	LDA	#10H
	STA	TSABNK
	MEM16
	REP	#20H
	LDA	#08000H
	LDY	<WORK4
CHNLP10 EQU	$
	DEY
	BMI	CHNJP10
	CLC
	ADC	#0800H
	BRA	CHNLP10
CHNJP10 EQU	$
	CLC
	ADC	#04000H
	STA	TSAADR
	LDA	#01C00H			;Tenso saki adress
	STA	TMOADR
	LDA	#0600H			;Tenso byte suu
	STA	TENKAZ
	MEM8
	SEP	#20H
	INC	WRTFLG
	BRA	CHNRETZ
CHNRETX EQU	$
	LDA	<FMCNT
	CLC
	ADC	#4
	STA	TSAADR
	AND	#00000111B
	BNE	CHNRETZ
	LDA	#0CH
	STA	TSABNK
	MEM16
	REP	#20H
	LDA	TSAADR
	AND	#00111000B
	ASL	A
	ASL	A
	ASL	A
	CLC
	ADC	#0FB00H
	STA	TSAADR
	LDA	#05160H
	STA	TMOADR
	LDA	#40H
	STA	TENKAZ
	MEM8
	SEP	#20H
	INC	WRTFLG
CHNRETZ EQU	$
	RTL
;
MRBNCH	EQU	$
	HEX	01,18
;
MARIOW	EQU	$
	MEM8
	IDX8
	SEP	#30H
;
	PHB
	PHK
	PLB
;
	LDA	<BGWFLG
	CMP	#1
	BNE	MCH010
	STA	BGWKSB
	LDX	MRLGFG
	LDA	MRBNCH,X
	STA	<BGWFLG
MCH010	EQU	$
	JSR	CHRBST
	LDA	<BGWFLG
	ASL	A
	TAX
	LDA	BGWDAT,X
	STA	<WORK
	LDA	BGWDAT+1,X
	STA	<WORK1
	JMP	(WORK)
;
BGWDAT	EQU	$
	WORD	GRND00	;0
	WORD	GRND11	;1
	WORD	GRND10	;2
	WORD	GRND11	;3
	WORD	GRND13	;4
	WORD	GRND10	;5
	WORD	GRND00	;6
	WORD	GRND12	;7
	WORD	GRND0X	;8
	WORD	GRND12	;9
	WORD	GRND15	;A
	WORD	GRND10	;B
	WORD	GRND10	;C
	WORD	GRND00	;D
	WORD	GRND10	;E
	WORD	GRND00	;F
	WORD	GRND10	;10
	WORD	GRND00	;11
	WORD	GRND00	;12
	WORD	GRND00	;13
	WORD	GRND00	;14
	WORD	GRND00	;15
	WORD	GRND00	;16
	WORD	GRND00	;17
	WORD	GRND11	;18
	WORD	GRND00	;19
	WORD	GRND00	;1A
	WORD	GRND00	;1B
	WORD	GRND00	;1C
	WORD	GRND00	;1D
	WORD	GRND00	;1E
	WORD	GRND00	;1F
;
GRND0X	EQU	$
	LDA	CORSNO
	CMP	#08
	BNE	GRND00
	LDA	#11H
	STA	BGWFLG
	JSR	CHRBST
GRND00	EQU	$
	STZ	<BGWFLG
	PLB
;
	STZ	WRTFLG
	LDA	#1
	STA	BGWFG2
	RTL
;
GRND10	EQU	$
	LDA	<BG2COS
	CMP	#13H		;3-1?	;yuki chr
	BEQ	GRND12X
	CMP	#19H
	BEQ	GRND12X
	CMP	#2FH
	BEQ	GRND12X
	LDA	#17H
	JSR	CHRBST
	BRA	GRND00
;
GRND11	EQU	$
	LDA	#11H
	JSR	CHRBST
	BRA	GRND00
;
GRND12	EQU	$
	LDA	#16H
	JSR	CHRBST
GRND12X EQU	$
	LDA	#12H
	JSR	CHRBST
	BRA	GRND00
;
GRND13	EQU	$
	LDA	#13H
	JSR	CHRBST
	LDA	#14H
	JSR	CHRBST
	BRA	GRND00
;
GRND15	EQU	$
	LDA	#15H
	JSR	CHRBST
	BRA	GRND00
;
TBANK	EQU	$   0	  1	2     3	    4	  5	6     7
	HEX	00,00,08,00,10,00,09,00,09,00,08,00,09,00,10,00
	HEX	08,00,10,00,08,00,09,00,08,00,08,00,08,00,09,00
	HEX	08,00,09,00,08,00,09,00,09,00,09,00,09,00,09,00
	HEX	08,00
TSADAT	EQU	$    0	    1	   2	  3	 4	5      6      7
	WORD	00000H,0E000H,0A000H,08000H,0A000H,09800H,0A000H,0A000H
	WORD	08000H,0A000H,0D000H,0E000H,0A000H,09000H,0B000H,09000H
	WORD	0B800H,0D000H,0C000H,0E800H,0F000H,0F800H,0E000H,0C000H
	WORD	0F000H
TMODAT	EQU	$    0	    1	   2	  3	 4	5      6      7
	WORD	00000H,02000H,02000H,02000H,02000H,02C00H,02000H,02000H
	WORD	02000H,02000H,03400H,02C00H,02800H,02C00H,02C00H,02000H
	WORD	02C00H,03000H,03000H,02000H,02800H,02C00H,02C00H,03000H
	WORD	02000H
TENDAT	EQU	$    0	    1	   2	  3	 4	5      6      7
	WORD	01000H,01000H,02000H,01000H,02000H,00800H,02000H,01000H
	WORD	01000H,02000H,02000H,00800H,01000H,00800H,00800H,01000H
	WORD	01000H,01000H,01000H,00800H,00800H,00800H,00800H,01000H
	WORD	01000H
;
CHRBST	EQU	$
	ASL	A
	TAX
	LDA	TBANK,X
	STA	TSABNK
	MEM16
	REP	#20H
	LDA	TSADAT,X
	STA	TSAADR
	LDA	TMODAT,X		;Tenso saki adress
	STA	TMOADR
	LDA	TENDAT,X		;Tenso byte suu
	STA	TENKAZ
	MEM8
	SEP	#20H
	JSR	BGCHCN
	RTS
;
BGCHCN	EQU	$
;
	LDA	#10000000B		;inc mode
	STA	2115H
;
	MEM16
	REP	#20H
;
	LDA	TMOADR
	STA	2116H			;VRAM address set
	LDA	#00000001B+(18H*100H)	;parameter & B bus address
	STA	4300H
	LDA	TSAADR			;A bus address
	STA	4302H
	LDX	TSABNK
	STX	4304H
	LDA	TENKAZ			;number of byte
	STA	4305H
	LDX	#00000001B		;DMA "ON"
	STX	420BH
	MEM8
	SEP	#20H
;
	RTS
;
;*********************************************************************
;*	 Kaze player check			   (KAZECHK)	     *
;*********************************************************************
KAZECHK	 EQU	  $
;
	 LDA	  KAZEFG
	 BEQ	  KAZCK80	  ;kaze flag on ?
;				  ;yes
	 LDA	  <ENVRFG
	 CMP	  #01H
	 BNE	  KAZCK80	  ;ground ?
;				  ;yes
	 LDY	  #00000001B
	 LDA	  FMCNT
	 ASL	  A
	 BCS	  KAZCK40	  ;kaze - 1 ?
;				  ;no
	 LDY	  #00000011B
KAZCK40	 EQU	  $
	 STY	  WORK
;
	 LDA	  FMCNT
	 AND	  WORK
	 BNE	  KAZCK80	  ;x-pos. replace ?
;				  ;yes
	 LDA	  XPOS1
	 CLC
	 ADC	  #01H
	 STA	  XPOS1
	 LDA	  XPOS0
	 ADC	  #00H
	 STA	  XPOS0		  ;player x-pos. replace
;
	 INC	  PLXMVL	  ;scroll calc.
KAZCK80	 EQU	  $
	RTL
;
;
;*********************************************************************
;*	 Kaze move & character set		   (KAZCSET)	     *
;*********************************************************************
;KZCNO	  BYTE	   07AH		   ;kaze character no.
KZATB	 EQU	  02AH		   ;	 attribute
;
KZYDAT	 EQU	  $
	 HEX	  30,70,B8,50,98,30,70,B8,50,98,30,70
KZXDAT	 EQU	  $
	 HEX	  30,30,30,60,60,A0,A0,A0,D0,D0,D0,60
KZCNO	 EQU	  $
	 HEX	  91,91,91,91,92,92,91,91,91,92,91,92
;
KXCDT	 EQU	  $
KAZCSET	 EQU	  $
;
	PHB
	PHK
	PLB
;
	LDA	ENCLFG
	BNE	KZCST80
	 LDA	  KAZEFG
	 BEQ	  KZCST80	  ;kaze flag on ?
;				  ;yes
	 JSR	  KZCALC	  ;keze move
;
	 LDX	  #00H
	 LDY	  #0H	;OAMEN+6
KZCST20	 EQU	  $
	LDA	OAM2+01,Y
	CMP	#0F0H
	BEQ	KZCST30
	INY
	INY
	INY
	INY
	TYA
	AND	#00FFH
	BEQ	KZCST80
	BRA	KZCST20
KZCST30 EQU	$
	 LDA	  KZYPOS,X
	 STA	  OAM2+01,Y	      ;y-pos. set
;
	 LDA	  KZCNO,X
	 STA	  OAM2+02,Y	    ;character no. set
;
	 LDA	  #KZATB
	 STA	  OAM2+03,Y	    ;attribute set
;
	 LDA	  KZXPOS,X
	 STA	  OAM2+00,Y	    ;x-pos. set
;
	LDA	#0
	STA	!OAMSB2+00,Y
;
	 INY
	 INY
	 INY
	 INY
	 INX
KZCST40	 EQU	  $
	 CPX	  #12
	 BNE	  KZCST20	  ;set end ?
;				  ;yes
KZCST80	 EQU	  $
	PLB
	RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	 KZCALC		    Kaze Calc				     x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KZYAD	 EQU	  $
;;	  INDEX	   0  1	 2  3  4  5  6	7  8  9	 A  B
	 HEX	  57,57,56,56,58,58,56,56,57,58,57,58
KZXAD	 EQU	  $
	 HEX	  59,59,58,58,5A,5A,58,58,59,5A,59,5A
;
KZCALC	 EQU	  $
	 LDX	  #0BH
;
KAZES0	 EQU	  $
	 LDA	  KZXPOS,X
	 CLC
	 ADC	  KZYAD,X
	 ADC	  KZYAD,X
	 STA	  KZXPOS,X
;
	 LDA	  KZYPOS,X
	 CLC
	 ADC	  KZYAD,X
	 STA	  KZYPOS,X
	 DEX
	 BPL	  KAZES0
;
	 RTS
;
;
;*********************************************************************
;*	 Kaze start				   (KAZEON)	     *
;*********************************************************************
KAZEON	 EQU	  $
	PHB
	PHK
	PLB
;
	PHX
	LDX	#0BH
KZO010	EQU	$
	LDA	KZXDAT,X
	STA	KZXPOS,X
	LDA	KZYDAT,X
	STA	KZYPOS,X
	DEX
	BPL	KZO010
	PLX
	PLB
	 LDA	  #10H
	 STA	  KZSAND	    ;SOUND (kaze)
	TSB	!SOUND1
	 LDA	  #01H
	 BNE	  KZOF40
;
;*********************************************************************
;*	 Kaze stop				   (KAZEOFF)	     *
;*********************************************************************
KAZEOFF	 EQU	  $
	STZ	KZSAND
	LDA	#20H
	TSB	!SOUND1
	 LDA	  #00H
KZOF40	 EQU	  $
	 STA	  KAZEFG	  ;kaze flag set
	 RTL
;
;
;
;#####################################################################
;#	 JSR	  SLCRST    [ Select cursor set ]		     #
;#####################################################################
SLCRSD		EQU	$		; Select cursor display data !
		HEX	0C,00
		HEX	02,4C,80,05
		HEX		2E,12,24,10,24,10
SLCD		HEX	FF
;
SLCRST		EQU	$
		PHB
		PHK
		PLB
;
		LDY	#SLCD-SLCRSD
;
SLCS30		EQU	$
		LDA	SLCRSD,Y
		STA	VRAMD,Y
		DEY
		BPL	SLCS30
;
		LDA	PLAYSW
		BEQ	SLCS90
;
		LDA	#24H
		STA	VRAMD+6
		LDA	#10H
		STA	VRAMD+7
;
		LDA	#02EH
		STA	VRAMD+10
		LDA	#012H
		STA	VRAMD+11
;
SLCS90		EQU	$
;
		PLB
		RTL
;
;
;#####################################################################
;#	 BG Data address table					     #
;#####################################################################
;				  < VRFLG used area address >
BGDTA0		EQU	$
BD00		BYTE	(VRAMD+2)&0FFH		; 00  V-RAM Write data buffer
;
BD10		BYTE	(CG0)&0FFH		; 01  Underwater color ganerater
		BYTE	(CG1)&0FFH		; 02  Ground
		BYTE	(CG2)&0FFH		; 03  Underground
		BYTE	(CG3)&0FFH		; 04  Castle
;
BD50		BYTE	(VRAMD+2)&0FFH		; 05  Title	  BG
;
BD90		BYTE	(BGDSBF)&0FFH		; 06  Base  BG & area color
BDA0		BYTE	(BGDSBF)&0FFH		; 07  Erase BG block
;
BDB0		BYTE	(BKCGDT)&0FFH		; 08  Big kame C.G. data
SNOW0		BYTE	(SNOWD0)&0FFH		; 09  Back snow afternoon
SNOW1		BYTE	(SNOWD1)&0FFH		; 0A  Big kame night
MSBGCL		BYTE	(MSCLDT)&0FFH		; 0B  Mushroom BG. color
THKM		BYTE	(THKDTM)&0FFH		; 0C  Thank you Mario data
		BYTE	(CASDTA)&0FFH		; 0D  But our princess data
		BYTE	(NXTDT1)&0FFH		; 0E  Next new quest 1 data
		BYTE	(NXTDT2)&0FFH		; 0F  Next new quest 2 data
		BYTE	(NXTDT3)&0FFH		; 10  Next new quest 3 data
		BYTE	(NXTDT4)&0FFH		; 11  Next new quest 4 data
		BYTE	(NXTDT5)&0FFH		; 12  Next new quest 4 data
		BYTE	(NXTDT6)&0FFH		; 13  Next new quest 4 data
		BYTE	(NXTDT7)&0FFH		; 14  Next new quest 4 data
		BYTE	(NXTDT8)&0FFH		; 15  Next new quest 4 data
		BYTE	(NXTDT9)&0FFH		; 16  Next new quest 4 data
		BYTE	(NXTDTA)&0FFH		; 17  Next new quest 4 data
		BYTE	(NXTDTB)&0FFH		; 18  Next new quest 4 data
ERRMS		BYTE	(ERMSGDT)&0FFH		; 19  Error message
CGRST		BYTE	(CGRSDT)&0FFH		; 1A  C.G. reset
GOVBG		BYTE	(GVBGDT)&0FFH		; 1B  Game over BG.
TCOSL		BYTE	(SLCRSD)&0FFH		; 1C  Titol select cursol
W9MS1		BYTE	(WLD9DT1)&0FFH		; 1D  World-9 infromation message
W9MS2		BYTE	(WLD9DT2)&0FFH		; 1E  World-9 game over message
		BYTE	(THKDTL)&0FFH		; 0C  Thank you Mario data
		BYTE	(NXTDT3L)&0FFH		; 10  Next new quest 3 data
		BYTE	(NXTDT6L)&0FFH		; 10  Next new quest 3 data
;
;
BGDTA1		EQU	$
		BYTE	(VRAMD+2)/100H
;
		BYTE	(CG0)/100H
		BYTE	(CG1)/100H
		BYTE	(CG2)/100H
		BYTE	(CG3)/100H
;
		BYTE	(VRAMD+2)/100H
;
		BYTE	(BGDSBF)/100H		; (BGDSBF+1)
		BYTE	(BGDSBF)/100H		; (BGDSBF+1)
;
		BYTE	(BKCGDT)/100H
		BYTE	(SNOWD0)/100H
		BYTE	(SNOWD1)/100H
		BYTE	(MSCLDT)/100H
		BYTE	(THKDTM)/100H
		BYTE	(CASDTA)/100H
		BYTE	(NXTDT1)/100H
		BYTE	(NXTDT2)/100H
		BYTE	(NXTDT3)/100H
		BYTE	(NXTDT4)/100H
		BYTE	(NXTDT5)/100H
		BYTE	(NXTDT6)/100H
		BYTE	(NXTDT7)/100H
		BYTE	(NXTDT8)/100H
		BYTE	(NXTDT9)/100H
		BYTE	(NXTDTA)/100H
		BYTE	(NXTDTB)/100H
		BYTE	(ERMSGDT)/100H
		BYTE	(CGRSDT)/100H
		BYTE	(GVBGDT)/100H
		BYTE	(SLCRSD)/100H
		BYTE	(WLD9DT1)/100H
		BYTE	(WLD9DT2)/100H
		BYTE	(THKDTL)/100H
		BYTE	(NXTDT3L)/100H
		BYTE	(NXTDT6L)/100H
;				  < VRFLG No. data >
CLGN0		EQU	BD10-BGDTA0	      ; Color generator
BGTIL		EQU	BD50-BGDTA0	      ; Title BG
BGGEM		EQU	BD90-BGDTA0	      ; Base BG
BGD02		EQU	BD90-BGDTA0	      ; Erase BG block buffer
;
BKCG00		EQU	BDB0-BGDTA0	      ; Big kame C.G. data
SN0		EQU	SNOW0-BGDTA0	      ; Back snow afternoon
SN1		EQU	SNOW1-BGDTA0	      ; Back snow night
MSCL		EQU	MSBGCL-BGDTA0	      ; Mushroom BG. color
;
DEFA		EQU	THKM-BGDTA0	      ; Thank you BG. data
;
ERPT	  EQU	   ERRMS-BGDTA0	      ; Error message data
CGRS	  EQU	   CGRST-BGDTA0	      ; C.G. reset data
;
GVBG	  EQU	   GOVBG-BGDTA0	      ; Game over BG.
;
TLSL	  EQU	   TCOSL-BGDTA0	      ; Title select cursol
;
W9M1	  EQU	   W9MS1-BGDTA0	      ; World-9 information message
W9M2	  EQU	   W9MS2-BGDTA0	      ; World-9 game over message
;
;
;*********************************************************************
;*	 W-8 ending message data				     *
;*********************************************************************
NXTDT1	 EQU	  $
	 HEX	  FF
NXTDT2	 EQU	  $
	 HEX	  FF
NXTDT3	 EQU	  $
	 HEX	  04,E8,00,1F
	 WORD	  081DH,0811H,080AH,0817H,0814H
	 WORD	  0824H,0822H,0818H,081EH,0824H		; "THANK YOU "
	 WORD	   0816H,080AH,081BH,0812H,0818H,082BH	; "MARIO!"
	 HEX	  FF
;
NXTDT3L	 EQU	  $
	 HEX	  04,E8,00,1F
	 WORD	  081DH,0811H,080AH,0817H,0814H
	 WORD	  0824H,0822H,0818H,081EH,0824H		; "THANK YOU "
	 WORD	   0815H,081EH,0812H,0810H,0812H,082BH	; "MARIO!"
	 HEX	  FF
;
NXTDT4	 EQU	  $
	 HEX	  05,09,00,1B
	 WORD	  0819H,080EH,080AH,080CH,080EH
	 WORD	  0824H,0812H,081CH,0824H		; "PEACE IS "
	 WORD	  0819H,080AH,081FH,080EH,080DH		; "PAVED"
	 HEX	  FF
;
NXTDT5	 EQU	  $
	 HEX	  05,47,00,23
	 WORD	  0820H,0812H,081DH,0811H,0824H,0814H
	 WORD	  0812H,0817H,0810H,080DH,0818H,0816H	; "WITH KINGDOM"
	 WORD	  0824H,081CH,080AH,081FH,080EH,080DH	: " SAVED"
	 HEX	  FF
;
NXTDT6	 EQU	  $
	 HEX	  05,89,00,1F
	 WORD	  0811H,081EH,081BH,081BH,080AH
	 WORD	  0811H,0824H,081DH,0818H,0824H,0824H	; "HURRAH TO  "
	 WORD	  0816H,080AH,081BH,0812H,0818H		; "MARIO"
	 HEX	  FF
;
NXTDT6L	  EQU	   $
	 HEX	  05,89,00,1F
	 WORD	  0811H,081EH,081BH,081BH,080AH
	 WORD	  0811H,0824H,081DH,0818H,0824H,0824H	; "HURRAH TO  "
	 WORD	   0815H,081EH,0812H,0810H,0812H	; "LUIGI"
	 HEX	  FF
;
NXTDT7	 EQU	  $
	 HEX	  05,CA,00,19
	 WORD	  0818H,081EH,081BH,0824H,0818H,0817H
	 WORD	  0815H,0822H,0824H			; "OUR ONLY "
	 WORD	  0811H,080EH,081BH,0818H		; "HERO"
	 HEX	  FF
;
NXTDT8	 EQU	  $
	 HEX	  06,07,00,25
	 WORD	  081DH,0811H,0812H,081CH,0824H,080EH
	 WORD	  0817H,080DH,081CH,0824H		; "THIS ENDS "
	 WORD	  0822H,0818H,081EH,081BH,0824H,081DH
	 WORD	  081BH,0812H,0819H			; "YOUR TRIP"
	 HEX	  FF
;
NXTDT9	 EQU	  $
	 HEX	  06,46,00,27
	 WORD	  0818H,080FH,0824H,080AH,0824H,0815H
	 WORD	  0818H,0817H,0810H,0824H		; "OF A LONG "
	 WORD	  080FH,081BH,0812H,080EH,0817H,080DH
	 WORD	  081CH,0811H,0812H,0819H		; "FRIENDSHIP"
	 HEX	  FF
;
NXTDTA	 EQU	  $
	 HEX	  06,88,00,1F
	 WORD	  0401H,0400H,0400H,0400H,0400H,0400H
	 WORD	  0424H,0419H,041DH,041CH,04AFH		; "100000 PTS."
	 WORD	  040AH,040DH,040DH,040EH,040DH		; "ADTET"
	 HEX	  FF
;
NXTDTB	 EQU	  $
	 HEX	  06,A6,00,29
	 WORD	  040FH,0418H,041BH,0424H,040EH,040AH
	 WORD	  040CH,0411H,0424H			; "FOR EACH "
	 WORD	  0419H,0415H,040AH,0422H,040EH,041BH
	 WORD	  0424H,0415H,040EH,040FH,041DH,04AFH	; "PLAYER LEFT"
	 HEX	  FF
;
ERMSGDT EQU	$
CGRSDT	EQU	$
	 HEX	  3F,00,00,07
	 WORD	  080FH,0830H,0830H,080FH
	 HEX	  FF
;
GVBGDT	EQU	$
WLD9DT1 EQU	$
	 HEX	  06,24,00,2F
	 WORD	  0820H,080EH,0824H,0819H,081BH,080EH
	 WORD	  081CH,080EH,0817H,081DH,0824H,080FH
	 WORD	  080AH,0817H,081DH,080AH,081CH,0822H
	 WORD	  0824H,0820H,0818H,081BH,0815H,080DH
;
	 HEX	  06,66,00,25
	 WORD	  0815H,080EH,081DH,08F2H,081CH,0824H
	 WORD	  081DH,081BH,0822H,0824H,0876H,0809H
	 WORD	  0824H,0820H,0818H,081BH,0815H,080DH,0875H
;
	 HEX	  06,A9,00,1B
	 WORD	  0820H,0812H,081DH,0811H,0824H,0818H
	 WORD	  0817H,080EH,0824H,0810H,080AH,0816H
	 WORD	  080EH,08AFH
;
	 HEX	  FF
;
WLD9DT2 EQU	$
;
	 HEX	  06,25,00,2B
	 WORD	  0822H,0818H,081EH,08F2H,081BH,080EH
	 WORD	  0824H,080AH,0824H,081CH,081EH,0819H
	 WORD	  080EH,081BH,0824H,0819H,0815H,080AH
	 WORD	  0822H,080EH,081BH,082BH
;
	 HEX	  06,69,00,19
	 WORD	  0820H,080EH,0824H,0811H,0818H,0819H
	 WORD	  080EH,0824H,0820H,080EH,08F2H,0815H
	 WORD	  0815H
;
	 HEX	  06,A9,00,1B
	 WORD	  081CH,080EH,080EH,0824H,0822H,0818H
	 WORD	  081EH,0824H,080AH,0810H,080AH,0812H
	 WORD	  1087H,08AFH
;
	 HEX	  06,E8,00,1F
	 WORD	  0816H,080AH,081BH,0812H,0818H,0824H
	 WORD	  080AH,0817H,080DH,0824H,081CH,081DH
	 WORD	  080AH,080FH,080FH,08AFH
;
	 HEX	  FF
;
;####################################################################
;#	 CG0	  Color generate data				     #
;#####################################################################
CG0	 EQU	  $	    ;-------------------------------------< Underwater >
;
;
CG1	 EQU	  $	    ;-------------------------------------< Ground >
;				  < BG >
;
CG2	 EQU	  $	    ;-------------------------------------< Underground >
;				  < BG >
;
CG3	 EQU	  $	    ;-------------------------------------< Castle >
;				  < BG >
;
;#####################################################################
;#	 Back smow afternoon					     #
;#####################################################################
SNOWD0	 EQU	  $
;
;#####################################################################
;#	 Back smow night					     #
;#####################################################################
SNOWD1	 EQU	  $
;
;#####################################################################
;#	 Mushroom BG. color					     #
;#####################################################################
MSCLDT	 EQU	  $
;
;*********************************************************************
;*	 Big kame C.G. data			   (BKCGDT)	     *
;*********************************************************************
BKCGDT	 EQU	  $
	 HEX	  FF
;
;#####################################################################
;#	 Message of one wold clear				     #
;#####################################################################
THKDTM	 EQU	  $
	 HEX	  05,48,00,1F
	 WORD		081DH,0811H,080AH,0817H,0814H		     ; "THANK"
	 WORD		0024H,0822H,0818H,081EH,0024H		     ; " YOU "
	 WORD		0816H,080AH,081BH,0812H,0818H,082BH	     ; "MARIO!"
	 HEX	  FF						     ; End of data
;
THKDTL	 EQU	  $
	 HEX	  05,48,00,1F
	 WORD		081DH,0811H,080AH,0817H,0814H		     ; "THANK"
	 WORD		0024H,0822H,0818H,081EH,0024H		     ; " YOU "
	 WORD		0815H,081EH,0812H,0810H,0812H,082BH	     ; "LUIGI!"
	 HEX	  FF						     ; End of data
;
CASDTA	 EQU	  $
	 HEX	  05,C5,00,2B
	 WORD		080BH,081EH,081DH,0024H			     ; "BUT "
	 WORD		0818H,081EH,081BH,0024H			     ; "OUR "
	 WORD	     0819H,081BH,0812H,0817H,080CH,080EH,081CH,081CH ; "PRINCESS "
	 WORD		0024H,0812H,081CH,0024H,0812H,0817H	     ; "IS IN"
	 HEX	  06,05,00,1D
	 WORD		080AH,0817H,0818H,081DH,0811H,080EH,081BH    ; "ANOTHER"
	 WORD	     0024H,080CH,080AH,081CH,081DH,0815H,080EH,082BH ; " CASTLE!"
	 HEX	  FF						     ; End of data
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;#####################################################################
;#	 Demo data area						     #
;#####################################################################
DMKYD0	 EQU	  $-1
;		   0  1	 2  3  4  5  6	7  8  9	 A  B  C  D  E	F
	 HEX	  01,81,01,81,01,81,02,01,81,00,81,00,80,01,81,01
	 HEX	  00
;
DMTMD0	 EQU	  $-1
;		   0  1	 2  3  4  5  6	7  8  9	 A  B  C  D  E	F
	 HEX	  B0,10,10,10,28,10,28,06,10,10,0C,80,10,28,08,90
	 HEX	  FF,00
;
;#####################################################################
;#	 JSR	  DMACT	    [ Demo action pros ]		     #
;#####################################################################
DMACT	 EQU	  $
;#####################################################################
;#	 JSR	  RDDMDT      [ Read of demo data ]		     #
;#		     <C> -- 0 : Demo				     #
;#			    1 : End demo			     #
;#####################################################################
RDDMDT	 EQU	  $
	PHB
	PHK
	PLB
;
	 LDX	  DEMDPT
	 LDA	  DMKYCT
	 BNE	  RDDM70
;
	 INX			  ; INC	 Demo data pointer
	 INC	  DEMDPT
;
	 SEC
	 LDA	  DMTMD0,X
	 STA	  DMKYCT
	 BEQ	  RDD100	  ;- IF	 end demo data ?  ( YES ; RDD100 )
;
RDDM70	 EQU	  $
	 LDA	  DMKYD0,X	       ; Read demo key data
	 STA	  KEYA1
;
	 DEC	  DMKYCT
;
RDDM90	 EQU	  $
	 CLC
;
RDD100	 EQU	  $
;
	PLB
	 RTL
;
;#####################################################################
;#		     (Y) -- Clear start RAM (L)adderss ; 7 page	     #	   #
;#	 JSR	  RAMCL0    [ RAM clear No.0 ]			     #
;#		     (A) -- 00H					     #
;#####################################################################
;RMCLSB EQU	$
;	  LDA	   #0
;	  STA	   <WORK+6
;	  STX	   <WORK+7
;
;LMCL30	  EQU	   $
;	  STA	   (<WORK+6),Y
;
;	  DEY
;	  CPY	   #0FFH
;	  BNE	   LMCL30
;
;	RTS
;
RAMCL0	 EQU	  $
;	PHY
;	LDY	#0
;	LDX	#0DH
;	JSR	RMCLSB
;	LDX	#0EH
;	JSR	RMCLSB
;	PLY
	 LDX	  #7
;
;#####################################################################
;#		     (X) -- Clear start RAM (H)adderss		     #	   #
;#		     (Y) --		    (L)			     #	   #
;#	 JSR	  RAMCL1    [ RAM clear No.1 ]			     #
;#		     (A) -- 00H					     #
;#####################################################################
RAMCL1	 EQU	  $
	 LDA	  #0
	 STA	  <WORK+6
;
RMCL20	 EQU	  $
	 STX	  <WORK+7
;
RMCL30	 EQU	  $
	 CPX	  #1		     ; Used  RAM 1 page
	 BNE	  RMCL40	     ;
;				     ;
	 CPY	  #050H		     ; Stack area ram clear ok ?
	 BCS	  RMCL50	     ; yes
;				     ;
RMCL40	 EQU	  $		     ;
	 STA	  (<WORK+6),Y
;
RMCL50	 EQU	  $
	 DEY
	 CPY	  #0FFH
	 BNE	  RMCL30
;
RMCL80	 EQU	  $
	 DEX
;;;;;;	 CPX	  #1
;;;;;;	 BEQ	  RMCL80
;
;;;;;;;; CPX	  #0
	 BPL	  RMCL20
;
		LDA	#0FFH
		STA	!VRAMD+2
		INC	A
	STZ	BMSTAT
	STZ	BMSTAT+1
	STZ	BMSTAT+2
	STZ	BMSTAT+3
	STZ	BMSTAT+4
;
	LDX	#40H		; ram 0F40H - 0FFFH clear
RMCL90	EQU	$
	STZ	CORSPT,X
	INX
	BNE	RMCL90
;
	LDA	ENDING
	BEQ	RMCL95
	DEC	A
	STA	ENDING
	BNE	RMCL95
;
RMCL93	EQU	$
		JSL	>LDINIT3
;
RMCL95	EQU	$
	 RTL
;
;#####################################################################
;#	 Frame block line data					     #
;#####################################################################
;
FRLPTD	 EQU	  $		     ; GAMEN DATA
	 HEX	  93,00,00,11	     ; 10
	 HEX	  12,12,13,00
	 HEX	  00,51,52,53
	 HEX	  00,00,00,00
;
	 HEX	  00,00,01,02	     ; 20      ( Sky )
	 HEX	  02,03,00,00
	 HEX	  00,00,00,00
	 HEX	  91,92,93,00
;
	 HEX	  00,00,00,51	     ; 00      ( Sky )
	 HEX	  52,53,41,42
	 HEX	  43,00,00,00
	 HEX	  00,00,91,92
;
;
;
	 HEX	  97,87,88,89	     ; 20   ( Ground )
	 HEX	  99,00,00,00
	 HEX	  11,12,13,A4
	 HEX	  A5,A5,A5,A6
;
	 HEX	  97,98,99,01	     ; 00    ( Ground )
	 HEX	  02,03,00,A4
	 HEX	  A5,A6,00,11
	 HEX	  12,12,12,13
;
	 HEX	  00,00,00,00	     ; 10
	 HEX	  01,02,02,03
	 HEX	  00,A4,A5,A5
	 HEX	  A6,00,00,00
;
;
	 HEX	  11,12,12,13	     ; 20  ( Ground 2) Wood and fence
	 HEX	  00,00,00,00
	 HEX	  00,00,00,9C
	 HEX	  00,8B,AA,AA
;
	 HEX	  AA,AA,11,12	     ; 00   ( Ground 2 )  Wood and Fence
	 HEX	  13,8B,00,9C
	 HEX	  9C,00,00,01
	 HEX	  02,03,11,12
;
	 HEX	  12,13,00,00	     ; 10
	 HEX	  00,00,AA,AA
	 HEX	  9C,AA,00,8B
	 HEX	  00,01,02,03
;
;;;;;;;;;;;;;;;;;;;;	SUBGAMEN OBJ DATA
;
ENOPDT	EQU	$
	HEX	FF,FF,FF,FF,FF
;01
	HEX	06,00,FF,01,0E
	HEX	06,00,FF,02,0E
	HEX	FF,01,07,0F,FF
	HEX	FF,FF,FF,FF,16
;02
	HEX	FF,06,FF,0E,FF	;D
	HEX	06,00,FF,0E,01
	HEX	00,0E,14,0F,01
	HEX	FF,FF,FF,FF,16
;03
	HEX	01,0F,05,0E,00	;D
	HEX	0A,0B,07,00,01
	HEX	00,0E,FF,0F,01
	HEX	FF,FF,FF,FF,16
;04
	HEX	FF,06,FF,12,FF
	HEX	00,08,12,05,01
	HEX	FF,03,08,0F,FF
	HEX	FF,FF,FF,FF,16
;05
	HEX	06,08,00,0F,02	;D
	HEX	FF,02,01,06,FF	;D
	HEX	FF,0E,07,0F,08
	HEX	FF,FF,FF,FF,16
;06
	HEX	02,0E,05,08,06	;D
	HEX	01,0A,07,0B,0E	;D
	HEX	01,0E,14,0F,FF
	HEX	FF,FF,FF,FF,16
;07
	HEX	02,0E,14,08,05	;D
	HEX	01,0E,12,0F,FF
	HEX	FF,0E,FF,0F,FF
	HEX	FF,FF,FF,FF,16
;08
	HEX	00,02,0F,05,06	;D
	HEX	02,05,0F,00,FF	;D
	HEX	01,0E,12,0F,05	;D
	HEX	FF,FF,FF,FF,16
ENOPD2	EQU	$
;09
	HEX	02,07,12,0E,05	;D
	HEX	FF,FF,12,FF,FF	;D
	HEX	FF,FF,FF,FF,16
	HEX	02,06,0E,07,05	;D
;0A
	HEX	00,0E,FF,0F,01	;D
	HEX	FF,05,FF,08,FF	;D
	HEX	07,0E,0F,14,FF
	HEX	FF,FF,FF,FF,16
;0B
	HEX	FF,00,0E,02,FF	;D
	HEX	0A,00,07,0E,0B
	HEX	01,0E,08,0F,FF
	HEX	FF,FF,FF,FF,16
;0C
	HEX	02,0E,05,0F,FF	;D
	HEX	01,0E,14,08,07	;D
	HEX	FF,0E,12,0F,FF	;D
	HEX	FF,FF,FF,FF,16
;0D
	HEX	00,05,0F,08,02	;D
	HEX	01,0E,02,0F,00	;D
	HEX	01,0E,05,08,00	;D
	HEX	FF,FF,FF,FF,16
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
JPTRST	EQU	$
	LDA	OAMEN,X
	TAY
	LDA	ENOBJX
	STA	OAM2+00,Y
	LDA	<ENYPS0,X
	CMP	#2
	BCS	JPSAAA
	LDA	ENOBJY
	CMP	#0E8H
	BCC	JPS000
JPSAAA	EQU	$
	LDA	#0F0H
JPS000	EQU	$
	STA	OAM2+01,Y
	LDA	<ENYSD0,X
	BMI	JPS030
	LDA	#0A9H
	BRA	JPS040
JPS030	EQU	$
	LDA	#29H
JPS040	EQU	$
	STA	OAM2+03,Y
	LDA	BBLCNT
	AND	#00011000B
	LSR	A
	LSR	A
	CLC
	ADC	#62H
	STA	OAM2+02,Y
	LDA	ENXPS1,X
	STA	<YWORK
	LDA	<ENXPS0,X
	STA	<YWORK1
	MEM16
	REP	#20H
	LDA	<YWORK
	SEC
	SBC	<SCCH1
	STA	<YWORK2
	MEM8
	SEP	#20H
	LDA	#2
	STA	OAMSB2,Y
	LDA	<YWORK3
	BEQ	JPS010
	LDA	#3
	STA	OAMSB2,Y
JPS010	EQU	$
	RTL
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
KAMECK	EQU	$
	PHB
	PHK
	PLB
;
	STZ	KAMEFG
	PHX
	LDX	<INDEX
	LDA	<ENMYNO,X
	CMP	#04H
	BCS	KAMERT
	LDA	<ENSTAT,X
	BMI	KAME03
	AND	#00000110B
	BEQ	KAME03
KAMERT	EQU	$
	PLX
	PLB
	CLC
	RTL
;
KAME03	EQU	$
	LDA	ENSTAT,X
	STA	<TWORK4
	CMP	#2
	BEQ	KAME05
	CMP	#3
	BEQ	KAME05
	CMP	#04
	BNE	KAME07
KAME05	EQU	$
	STZ	KAMECT,X
	BRA	KAME09
KAME07	EQU	$
	AND	#10000000B
	BEQ	KAMERT
	LDA	<PLCMOD
	CMP	#0AH
	BCS	KAME09
	INC	KAMECT,X
KAME09	EQU	$
	LDA	KAMECT,X
	AND	#00001100B
	STA	<YWORK
	LDA	<ENMYNO,X
	LDX	<YWORK
	CMP	#02H
	BNE	KAME10
	TXA
	CLC
	ADC	#10H
	TAX
KAME10	EQU	$
	LDA	<TWORK4
	AND	#0FH
	CMP	#04H
	BNE	KAME15
	TXA
	CLC
	ADC	#20H
	TAX
	LDA	#80H
	TSB	<WORK4
KAME15	EQU	$
	TYA
	CLC
	ADC	#8
	TAY
	LDA	ENOBJY
	CLC
	ADC	#08H
	CMP	#0F0H
	BCC	KAME20
	LDA	#0F0H
KAME20	EQU	$
	PHA
	LDA	<WORK4
	BPL	KAME30
	PLA
	CLC
	ADC	#2
	BRA	KAME40
KAME30	EQU	$
	PLA
KAME40	EQU	$
	JSR	KMCSET
	LDA	<WORK4
	BPL	KAME50
	LDA	ENOBJY
	CLC
	ADC	#12H
	BRA	KAME60
KAME50	EQU	$
	LDA	ENOBJY
	CLC
	ADC	#10H
KAME60	EQU	$
	JSR	KMCSET
;
	LDX	<YWORK
	LDA	KAMEAT,X
	ORA	<WORK4
	STA	OAM2+03-10H,Y
	LDA	KAMEAT+1,X
	ORA	<WORK4
	STA	OAM2+07-10H,Y
	LDA	KAMEAT+2,X
	ORA	<WORK4
	STA	OAM2+11-10H,Y
	LDA	KAMEAT+3,X
	ORA	<WORK4
	STA	OAM2+15-10H,Y
;
	INC	KAMEFG
	PLX
	PLB
	SEC
	RTL
;
KINPCL	EQU	$
;		 0  1  2  3  4	5  6  7	 8  9  A  B  C	D  E  F
	HEX	00,FC,F9,F7,F5,F4,F3,F2,F2,F2,F3,F4,F5,F7,F9,FC
	HEX	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
;
KINPST	EQU	$
	PHB
	PHK
	PLB
;
	PHX
	LDX	<INDEX
	LDA	<ENMYNO,X
	CMP	#35H
	BNE	KAMER2
	LDA	FINAL
	BNE	KAMER2
	LDA	KINPCT
	AND	#1FH
	LDY	OAMEN,X
	PHY
	TAX
	LDA	KINPCL,X
	STA	<TWORK1
	JSR	KINPYP
	JSR	KINPYP
	JSR	KINPYP
	JSR	KINPYP
	JSR	KINPYP
	JSR	KINPYP
	PLY
	CPX	#10H
	BCS	KINPRT
	LDA	#0FFH
	STA	OAM2+02,Y
	STA	OAM2+06,Y
	LDA	#0D7H
	STA	OAM2+10,Y
	STA	OAM2+14,Y
	LDA	#0EEH
	STA	OAM2+18,Y
	STA	OAM2+22,Y
KINPRT	EQU	$
	INC	KINPCT
KAMER2	EQU	$
	PLX
	PLB
	RTL
;
KINPYP	EQU	$
	LDA	OAM2+01,Y
	CLC
	ADC	<TWORK1
	STA	OAM2+01,Y
	INY
	INY
	INY
	INY
	RTS
;
KMCSET	EQU	$
	STA	OAM2+01,Y
	STA	OAM2+05,Y
	LDA	ENOBJX
	STA	OAM2+00,Y
	CLC
	ADC	#08H
	STA	OAM2+04,Y
	LDA	KAMEDT,X
	STA	OAM2+02,Y
	LDA	KAMEDT+1,X
	STA	OAM2+06,Y
	INY
	INY
	INY
	INY
	INY
	INY
	INY
	INY
	INX
	INX
	RTS
;
KAMEDT	EQU	$
	HEX	6E,6E
	HEX	6F,6F
;
	HEX	C2,C4
	HEX	C3,C5
;
	HEX	C0,C0
	HEX	C1,C1
;
	HEX	C4,C2
	HEX	C5,C3
;
	HEX	F5,F5
	HEX	F4,F4
;
	HEX	80,82
	HEX	81,83
;
	HEX	68,68
	HEX	90,90
;
	HEX	82,80
	HEX	83,81
;			;FRIP
	HEX	6F,6F
	HEX	6E,6E
;
	HEX	C3,C5
	HEX	C2,C4
;
	HEX	C1,C1
	HEX	C0,C0
;
	HEX	C5,C3
	HEX	C4,C2
;
	HEX	F4,F4
	HEX	F5,F5
;
	HEX	81,83
	HEX	80,82
;
	HEX	90,90
	HEX	68,68
;
	HEX	83,81
	HEX	82,80
;
KAMEAT	EQU	$
	HEX	00,40
	HEX	00,40
;
	HEX	00,00
	HEX	00,00
;
	HEX	00,40
	HEX	00,40
;
	HEX	40,40
	HEX	40,40
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
TLFLD1	EQU	$
	WORD	27BFH,7FFFH,3F1FH,4A5FH
TLFLD2	EQU	$
	WORD	033EH,77FFH,2A7FH,315FH
TLFLD3	EQU	$
	WORD	029EH,6FBFH,15DFH,001DH
TLFLD4	EQU	$
	WORD	53FFH,677FH,4F9FH,677FH
TLFLSH	EQU	$
	PHB
	PHK
	PLB
;
	LDA	<FMCNT
	AND	#00011000B	;3C > 1E
	LSR	A		;4A > EA
	LSR	A
	TAX
	MEM16
	REP	#20H
	LDA	TLFLD1,X
	STA	CGWORK+0CCH
	LDA	TLFLD2,X
	STA	CGWORK+0CEH
	LDA	TLFLD3,X
	STA	CGWORK+0D0H
	LDA	TLFLD4,X
	STA	CGWORK+0DAH
	MEM8
	SEP	#20H
;
	INC	CGVMAF
;
	PLB
	RTL
;
CLFDOT	EQU	$
	MEM16
	IDX16
	REP	#30H
	LDX	#0
	STZ	<YWORK2
MRF005	EQU	$
	LDA	CGWORK,X
	STA	<YWORK
	AND	#0111110000000000B	;RED
	BEQ	MRF010
	LDA	<YWORK
	SEC
	SBC	#0400H
	STA	<YWORK
;
MRF010	EQU	$
	LDA	<YWORK
	AND	#0000001111100000B	;GREEN
	BEQ	MRF020
	LDA	<YWORK
	SEC
	SBC	#0020H
	STA	<YWORK
;
MRF020	EQU	$
	LDA	<YWORK
	AND	#0000000000011111B	;BLUE
	BEQ	MRF030
	DEC	<YWORK
;
MRF030	EQU	$
	LDA	<YWORK
	STA	CGWORK,X
	ORA	<YWORK2
	STA	<YWORK2
	INX
	INX
	CPX	#0200H
	BCC	MRF005
	LDA	<YWORK2
	BEQ	MRF040
	MEM8
	IDX8
	SEP	#30H
	STA	COLERR
	STA	CLRFLG
	LDA	#1
	STA	!CGVMAF
	CLC
	RTL
MRF040	EQU	$
	MEM8
	IDX8
	SEP	#30H
	STZ	COLERR
	STZ	CLRFLG
	SEC
	RTL
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
FWATCK	EQU	$
	LDA	<FWRFLG1,X
	BMI	FWA010
	LDA	<WORK
	SEC
	SBC	#18H
	STA	<YWORK
	BRA	FWA020
FWA010	EQU	$
	LDA	<WORK
	STA	<YWORK
FWA020	EQU	$
	LDA	ENYPS1,X
	SEC
	SBC	<YWORK
	STA	<YWORK
	PHY
	LDY	OAMEN,X
	CMP	#18H
	BCC	FWA030
	LDA	OAM2+19,Y
	ORA	#20H
	STA	OAM2+19,Y
	LDA	OAM2+23,Y
	ORA	#20H
	STA	OAM2+23,Y
FWA030	EQU	$
	LDA	<YWORK
	CMP	#10H
	BCC	FWA040
	LDA	OAM2+11,Y
	ORA	#20H
	STA	OAM2+11,Y
	LDA	OAM2+15,Y
	ORA	#20H
	STA	OAM2+15,Y
FWA040	EQU	$
	LDA	<YWORK
	CMP	#08H
	BCC	FWA050
	LDA	OAM2+03,Y
	ORA	#20H
	STA	OAM2+03,Y
	LDA	OAM2+07,Y
	ORA	#20H
	STA	OAM2+07,Y
FWA050	EQU	$
	PLY
	RTL
;
;#####################################################################
;#		      (X)-- Index				     #
;#	 JSR	  GFCSET    [ Goul Flag	 set   ]		     #
;#####################################################################
GFSCDT	 EQU	  $	    ;  score
	 HEX	  F9,0E	    ;  5000    ; 0
	 HEX	  F7,0E	    ;  2000    ; 1
	 HEX	  FA,FB	    ;  800     ; 2
	 HEX	  F8,FB	    ;  400     ; 3
	 HEX	  F6,FB	    ;  100     ; 4
	 HEX	  FD,FE	    ;  1UP     : 5
;
GFLDAT1 HEX	20,22,24
;
GFCSET	 EQU	  $
	PHB
	PHK
	PLB
;
	 LDY	  #0F0H		;!OAMEN,X
;
	LDA	ENXPS1,X
	STA	<YWORK
	LDA	<ENXPS0,X
	STA	<YWORK1
	MEM16
	REP	#20H
	LDA	<YWORK
	SEC
	SBC	<SCCH1
	STA	<YWORK
	CLC
	ADC	#4
	STA	<YWORK2
	CLC
	ADC	#8
	STA	<YWORK4
	BPL	GGJ100
	CMP	#0FF80H
	BCS	GGJ100
	MEM8
	IDX8
	SEP	#30H
	PLB
	RTL
;
GGJ100	EQU	$
	MEM8
	SEP	#20H
	LDA	<YWORK
	 STA	  OAM+00,Y	;X
	 LDA	  ENYPS1,X
	 STA	  OAM+01,Y	;Y
;
	 LDA	  #2BH
	 STA	  OAM+03,Y	;A
;
	LDA	<FMCNT
	AND	#00011000B
	LSR	A
	LSR	A
	LSR	A
	PHX
	TAX
	CPX	#03H
	BNE	GFC005
	LDX	#01
GFC005	EQU	$
	LDA	GFLDAT1,X
	 STA	  OAM+02,Y	;C
	PLX
;
	 LDA	  GLPTYP
	 BEQ	  GFC010
;
	 LDA	  GLSCRE
	 ASL	  A
	 TAX
	LDA	<YWORK2
	STA	OAM+04,Y	;X
	LDA	<YWORK4
	STA	OAM+08,Y
;
	LDA	GLSCY1
	STA	OAM+05,Y	;Y
	STA	OAM+09,Y
;
	 LDA	  GFSCDT,X
	STA	OAM+06,Y	;C
	 LDA	  GFSCDT+1,X
	STA	OAM+10,Y
;
	LDA	#22H
	STA	OAM+07,Y	;A
	STA	OAM+11,Y
;
	CPX	#04H
	BCS	GFC010
	LDA	#23H
	STA	OAM+11,Y
;
GFC010	 EQU	  $
	LDA	#2
	STA	<TWORK1
	LDA	<YWORK1
	BEQ	GFC020
	LDA	#1
GFC020	EQU	$
	ORA	<TWORK1
	STA	OAMSB+00,Y
;
	STZ	<TWORK1
	LDA	<YWORK3
	BEQ	GFC030
	LDA	#1
GFC030	EQU	$
	ORA	<TWORK1
	STA	OAMSB+04,Y
;
	CPX	#4
	BCS	GFC035
	LDA	#2
	STA	<TWORK1
GFC035	EQU	$
	LDA	<YWORK5
	BEQ	GFC040
	LDA	#1
GFC040	EQU	$
	ORA	<TWORK1
	STA	OAMSB+08,Y
;
GFC050	EQU	$
	PLB
	RTL
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	END
