;
		INCLUDE mn_hp_mr3ram.asm
		INCLUDE mn_hp_mr3macro.asm
;
;<MR3MAIN>===================================================================
;
;<MR3ASCR>===================================================================
;
;<MR3EXST>===================================================================
		EXT	PLNMPT
;
;<MR3BGD2>===================================================================
		EXT	CKBC0,SUIC0,SUIC1
		EXT	YM001,YM002,YM008,YM009,YM00A,YM00B,YM00C
		EXT	YM100,YM101,YM102,YM103,YM106,YM107,YM108
		EXT	YM10E
		EXT	YM110,YM111,YM112,YM113,YM115
		EXT	YM200,YM201,YM202,YM20E,YM20F,YM210,YM212
		EXT	YM300,YM301,YM302,YM303,YM304,YM305,YM306
		EXT	YM307,YM308,YM309,YM30A,YM30B,YM30C,YM30D
		EXT	YM30E
;
		EXT	RODI1,RODI2,RODI3,RODI4,BLOK2
		EXT	ENYM0,ENYM1,ENYM2,ENYM3,ENYM4,ENYM5,ENYM6,ENYM7
		EXT	ENWK0,ENWK1,ENWK2,ENWK3,ENWK4,ENWK5,ENWK6,ENWK7
		EXT	ENHL0,ENHL1,ENHL2,ENHL3,ENHL4,ENHL5,ENHL6,ENHL7
		EXT	ENHL8,ENHL9,ENHLA,ENHLB,ENHLC,ENHLD,ENHLE,ENHLF
		EXT	ENKM0,ENKM1,BBET0,ENSB0,ENSB1,ENSB2,ENSB3,ENSB4
		EXT	ENSB5,HLSD0,HLSD1,HLSD2,HLSD3
		EXT	BLGM,ALGM,SBGM,KMGM,ICGM,YMGM,Y1GM
;
;<MR3BGD3>===================================================================
		EXT	IHIL1
;
;<MR3BGD4>===================================================================
		EXT	MISE0,MISE1,MISE2,MISE3,MISE4,MISE5,MISE6,MISE7
		EXT	MISE8,MISE9,SHSP0
;
;<MR3BGD4>===================================================================
		EXT	BGYK0,BGYK1,BGYK2,BGYK3
;
;<MR3BGD6>===================================================================
		EXT	ISI00,ISI01,ISI02,ISI06,ISI07,ISI08
;
;<MR3BGD7>===================================================================
		EXT	BLOC0
;
;<MR3BGD8>===================================================================
		EXT	BDK3D3,BDK4D3
		EXT	MART0,TRDK0,TRDK1
;
;<MR3DATA0>==================================================================
;
		EXT	SUIC0
; -----------------------------------------------------------------------DATA
		EXT	PLMNDT,PLMNDTZZ,MUKIDAT,INTSCLD,SCRLHDT
; --------------------------------------------------------------JSR    UNTNORD
		EXT	RAMADR,BGADDT1,BGADDT2
;
		EXT	DOKAN
;<MR3BGD1>===================================================================
		EXT	BNS0D,BNS0E,BNS0F
;
;<MR3BGD2>===================================================================
		EXT	BNS00,BNS01,BNS02,BNS03,BNS04,BNS05,BNS06,BNS07,BNS08
		EXT	BNS09,BNS0A,BNS0B,BNS0C
;
;<MR3SUB0>===================================================================
		EXT	VRAMSET,VRAMST1,VRAMTR
;
		EXT	B2VRMST,TCHDTPOP,B2VMST1
;
;<MR3BG2ST>==================================================================
		GLB	B2UNTST,B2TETWRT,B2DTINT
		GLB	BG2BFST,B2WKST,SKUCNGR,SKUCGLD
		GLB	BFHICLR,KDSNST,RTKBST,RTUPST,LFUPST
		GLB	RULDST,JMNDST,LURDSST,LFKBST
		GLB	BONASST,MISESET,BIGYKST,B2EDST,AIS5SET
		GLB	HOLESID,ICEYUK,SAKAKD,HKSENST,TKRDKN
		GLB	YURYUR,HDMADR
		GLB	SLOTB2,SLTCH,SLTFLH
;
		GLB	BKMGST
; --------------------------------------------------------------JSR    MOYOUST
		GLB	MOYOUD,MOYOD1,MOYOD2,MOYOD3,MOYOAD,GAMEND
		GLB	MYSTD3,MOYADH,SIRORO
;
		EXT	YPINCST
;--------------------------------------------------------------- BGD1
		GLB	BILYMSP
		EXT	BLBC0,BYM00,BYM01,BYM02,BYM03,BYM04,BYM05
		EXT	BYM06,BYM0E,BYM10,BYM11
;
;<MR3B2UT>===================================================================
		EXT	INWTER
		EXT	WCIW0,WCIW1,WCIW2,WCIW3,WCIW4,WCIW5,WCIW6,WCIW7
		EXT	WCIW8,WCIW9,WCIWA,WCIWB,WCIWC,WGIW0,WGIW1,WGIW2
		EXT	WAOK0,WAOK1,WGIW3,WGIW4,WGIW5,WAOK2,WAOK3,WGIW6
		EXT	WAOK4,WAOK5,WGIW7,WAOK6,WAOK7,WFLR0,WFLR1,WGIW8
		EXT	WGIW9,WGIWA,WGIWB,WAKK0,WAKK1,WAKK2,WCIWE,WGIWD
;
		EXT	SENKAN
		EXT	SKBET,SKKM0,SKKM1,SKKM2,SKKM3,SKKM4,SKKM5,SKKM6
		EXT	SKKM7,SKKM8,SKKM9,SKKMA,SKKMB,SKKMC,SKKMD,SKKME
		EXT	SKKMF,SKSD0,SKSD1,SKSD2,SKSD3,SKSD4,SKSD5,SKSD6
		EXT	SKSD7,SKSD8,SKSD9
;
		EXT	KKUPPA
		EXT	KPBET,KPA00,KPA01,KPA02,KPA03,KPA04,KPA05,KPA06
		EXT	KPA07,KPA08,KPA09,KPA0A,KPA0B,KPA0C,KPA0D,KPA0E
		EXT	KPA0F,KPA10,KPA11,KPA12,KPA13,KPA14,KPA15,KPA16
		EXT	KPA17,KPA18,KPA19,KPA1A,KPA1B,KPA1C,KPA1D,KPA1E
		EXT	KPA1F,KPA20,KPA21,KPA22,KPA23
;
		EXT	CJBILL
		EXT	CJB00,CJB01,CJB02,CJB03,CJB04,CJB05,CJB06,CJB07
		EXT	CJB08,CJB09,CJB0A,CJB0B,CJB0C,CJB0D,CJB0E,CJB0F
		EXT	CJB10,CJB11,CJB12,CJB13,CJB14,CJB15,CJB16,CJB17
		EXT	CJB18,CJB19,CJB1A,CJB1B,CJB1C,CJB1D,CJB1E,CJB1F
		EXT	CJB20,CJB21,CJB22,CJB23,CJB24,CJB25,CJB26,CJB27
		EXT	CJB28,CJB29,CJB2A,CJB2B,CJB2C,CJB2D,CJB2E,CJB2F
		EXT	CJB30,CJB31,CJB32,CJB33,CJB34,CJB35,CJB36,CJB37
		EXT	CJB38,CJB39,CJB3A
;
		EXT	DCHIKA
		EXT	DCK00,DCK01,DCK02,DCK03,DCK04,DCK05,DCK06,DCK07
		EXT	DCK08,DCK09,DCK0A,DCK0B,DCK0C,DCK0D,DCK0E,DCK0F
		EXT	DCK10,DCK11,DCK12,DCK13,DCK14,DCK15,DCK16,DCK17
		EXT	DCK18,DCK19,DCK1A,DCK1B,DCK1C,DCK1D,DCK1E,DCK1F
		EXT	DCK20,DCK21,DCK22,DCK23,DCK24,DCK25,DCK26,DCK27
		EXT	DCK28,DCK29,DCK2A,DCK2B,DCK2C,DCK2D,DCK2E,DCK2F
		EXT	DCK30,DCK31,DCK32,DCK33,DCK34,DCK35,DCK36,DCK37
		EXT	DCK38,DCK39,DCK3A,DCK3B,DCK3C
;
		EXT	SIROUT
		EXT	SIR00,SIR01,SIR02,SIR03,SIR04,SIR05,SIR06,SIR07
		EXT	SIR08,SIR09,SIR0A,SIR0B,SIR0C,SIR0D,SIR0E,SIR0F
		EXT	SIR10,SIR11,SIR12,SIR13,SIR14,SIR15,SIR16,SIR17
		EXT	SIR18,SIR19,SIR1A,SIR1B,SIR1C,SIR1D,SIR1E,SIR1F
		EXT	SIR20,SIR21,SIR22,SIR23,SIR24,SIR25,SIR26,SIR27
		EXT	SIR28,SIR29,SIR2A,SIR2B,SIR2C,SIR2D,SIR2E,SIR2F
		EXT	SIR30,SIR31,SIR32,SIR33,SIR34,SIR35,SIR36,SIR37
		EXT	SIR38
;
		EXT	SENOUT
		EXT	SEN00,SEN01,SEN02,SEN03,SEN04,SEN05,SEN06,SEN07
		EXT	SEN08,SEN09,SEN0A,SEN0B,SEN0C,SEN0D,SEN0E,SEN0F
		EXT	SEN10,SEN11,SEN12,SEN13,SEN14,SEN15,SEN16,SEN17
		EXT	SEN18,SEN19,SEN1A,SEN1B,SEN1C,SEN1D,SEN1E,SEN1F
		EXT	SEN20,SEN21,SEN22
;
		EXT	ICEOUT
		EXT	ICE00,ICE01,ICE02,ICE03,ICE04,ICE05,ICE06,ICE07
		EXT	ICE08,ICE09,ICE0A,ICE0B,ICE0C,ICE0D,ICE0E,ICE0F
		EXT	ICE10,ICE11,ICE12,ICE13,ICE14,ICE15,ICE16,ICE17
		EXT	ICE18,ICE19,ICE1A,ICE1B,ICE1C,ICE1D,ICE1E,ICE1F
		EXT	ICE20,ICE21,ICE22,ICE23,ICE24,ICE25,ICE26,ICE27
		EXT	ICE28,ICE29,ICE2A,ICE2B,ICE2C,ICE2D,ICE2E,ICE2F
		EXT	ICE30
;
		EXT	TATEUT
		EXT	TAT00,TAT01,TAT02,TAT03,TAT04,TAT05,TAT06,TAT07
		EXT	TAT08,TAT09,TAT0A,TAT0B,TAT0C,TAT0D,TAT0E,TAT0F
		EXT	TAT10,TAT11,TAT12,TAT13,TAT14,TAT15,TAT16,TAT17
		EXT	TAT18,TAT19,TAT1A,TAT1B,TAT1C,TAT1D,TAT1E,TAT1F
		EXT	TAT20,TAT21,TAT22,TAT23,TAT24,TAT25,TAT26,TAT27
		EXT	TAT28,TAT29,TAT2A,TAT2B,TAT2C,TAT2D,TAT2E,TAT2F
		EXT	TAT30,TAT31,TAT32,TAT33,TAT34,TAT35
;
		EXT	SAKAUT
		EXT	SAK00,SAK01,SAK02,SAK03,SAK04,SAK05,SAK06,SAK07
		EXT	SAK08,SAK09,SAK0A,SAK0B,SAK0C,SAK0D,SAK0E,SAK0F
		EXT	SAK10,SAK11,SAK12,SAK13,SAK14,SAK15,SAK16,SAK17
		EXT	SAK18,SAK19,SAK1A,SAK1B,SAK1C,SAK1D,SAK1E,SAK1F
		EXT	SAK20,SAK21,SAK22,SAK23,SAK24,SAK25,SAK26,SAK27
		EXT	SAK28,SAK29,SAK2A,SAK2B,SAK2C,SAK2D,SAK2E,SAK2F
		EXT	SAK30,SAK31,SAK32,SAK33,SAK34,SAK35,SAK36,SAK37
		EXT	SAK38,SAK39,SAK3A,SAK3B,SAK3C,SAK3D,SAK3E,SAK3F
		EXT	SAK40,SAK41,SAK42,SAK43,SAK44,SAK45,SAK46,SAK47
		EXT	SAK48,SAK49,SAK4A,SAK4B,SAK4C,SAK4D,SAK4E,SAK4F
		EXT	SAK50,SAK51,SAK52,SAK53,SAK54,SAK55,SAK56
;
		EXT	CHIKUT
		EXT	CHK00,CHK01,CHK02,CHK03,CHK04,CHK05
;
		EXT	SGENUT
		EXT	SGN00,SGN01,SGN02,SGN03,SGN04,SGN05,SGN06,SGN07
		EXT	SGN08,SGN09,SGN0A,SGN0B,SGN0C,SGN0D,SGN0E,SGN0F
		EXT	SGN10,SGN11,SGN12,SGN13,SGN14,SGN15,SGN16,SGN17
		EXT	SGN18,SGN19,SGN1A,SGN1B,SGN1C,SGN1D,SGN1E,SGN1F
		EXT	SGN20,SGN21,SGN22,SGN23,SGN24,SGN25,SGN26,SGN27
		EXT	SGN28,SGN29,SGN2A,SGN2B,SGN2C,SGN2D,SGN2E,SGN2F
		EXT	SGN30,SGN31,SGN32,SGN33,SGN34,SGN35,SGN36,SGN37
		EXT	SGN38,SGN39,SGN3A,SGN3B,SGN3C,SGN3D,SGN3E,SGN3F
		EXT	SGN40,SGN41,SGN42,SGN43,SGN44,SGN45
;
		EXT	SABKUT
		EXT	SBK00,SBK01,SBK02,SBK03,SBK04,SBK05,SBK06,SBK07
		EXT	SBK08,SBK09,SBK0A,SBK0B,SBK0C,SBK0D,SBK0E,SBK0F
		EXT	SBK10,SBK11,SBK12,SBK13,SBK14,SBK15,SBK16,SBK17
		EXT	SBK18,SBK19,SBK1A,SBK1B,SBK1C,SBK1D,SBK1E,SBK1F
		EXT	SBK20,SBK21,SBK22,SBK23,SBK24,SBK25,SBK26,SBK27
		EXT	SBK28,SBK29,SBK2A,SBK2B,SBK2C,SBK2D,SBK2E,SBK2F
		EXT	SBK30,SBK31,SBK32,SBK33,SBK34,SBK35,SBK36,SBK37
		EXT	SBK38,SBK39,SBK3A,SBK3B,SBK3C,SBK3D,SBK3E,SBK3F
		EXT	SBK40,SBK41,SBK42,SBK43
;
		EXT	ASTCUT
		EXT	ASC00,ASC01,ASC02,ASC03,ASC04,ASC05,ASC06,ASC07
		EXT	ASC08,ASC09,ASC0A,ASC0B,ASC0C,ASC0D,ASC0E,ASC0F
		EXT	ASC10,ASC11,ASC12,ASC13,ASC14,ASC15,ASC16,ASC17
		EXT	ASC18,ASC19,ASC1A,ASC1B,ASC1C,ASC1D,ASC1E,ASC1F
		EXT	ASC20,ASC21,ASC22,ASC23,ASC24,ASC25,ASC26,ASC27
		EXT	ASC28,ASC29,ASC2A,ASC2B,ASC2C,ASC2D,ASC2E,ASC2F
		EXT	ASC30,ASC31,ASC32
;
		EXT	SBKTRD
		EXT	STD00,STD01,STD02,STD03,STD04,STD05,STD06,STD07
		EXT	STD08,STD09,STD0A,STD0B,STD0C,STD0D,STD0E,STD0F
		EXT	STD10,STD11,STD12,STD13,STD14,STD15,STD16,STD17
		EXT	STD18,STD19,STD1A,STD1B,STD1C,STD1D,STD1E,STD1F
		EXT	STD20,STD21,STD22,STD23,STD24,STD25,STD26,STD27
;
		EXT	FUNEUT
		EXT	FNE00,FNE01,FNE02,FNE03,FNE04,FNE05,FNE06,FNE07
		EXT	FNE08,FNE09,FNE0A,FNE0B,FNE0C,FNE0D,FNE0E,FNE0F
		EXT	FNE10,FNE11,FNE12,FNE13,FNE14,FNE15,FNE16,FNE17
		EXT	FNE18,FNE19,FNE1A,FNE1B,FNE1C,FNE1D,FNE1E,FNE1F
		EXT	FNE20,FNE21,FNE22,FNE23,FNE24,FNE25,FNE26,FNE27
		EXT	FNE28,FNE29,FNE2A,FNE2B,FNE2C,FNE2D,FNE2E,FNE2F
		EXT	FNE30,FNE31,FNE32,FNE33,FNE34,FNE35,FNE36,FNE37
		EXT	FNE38,FNE39,FNE3A,FNE3B
;
		EXT	SYKMUT
;
		EXT	BONSUT
		EXT	BONS0,BONS1,BONS2,BONS3,BONS4,BONS5,BONS6,BONS7
		EXT	BONS8,BONS9,BONSA,BONSB,BONSC,BONSD,BONSE,BONSF
;
		EXT	ICETIK
		EXT	ITK00,ITK01,ITK02,ITK03,ITK04,ITK05,ITK06,ITK07
		EXT	ITK08,ITK09,ITK0A,ITK0B,ITK0C,ITK0D,ITK0E,ITK0F
;
		EXT	WTRASR
		EXT	WAS00,WAS01,WAS02,WAS03,WAS04,WAS05,WAS06,WAS07
		EXT	WAS08,WAS09,WAS0A,WAS0B,WAS0C,WAS0D,WAS0E,WAS0F
		EXT	WAS10,WAS11,WAS12,WAS13,WAS14,WAS15,WAS16,WAS17
		EXT	WAS18,WAS19,WAS1A,WAS1B,WAS1C,WAS1D,WAS1E,WAS1F
		EXT	WAS20,WAS21,WAS22,WAS23,WAS24,WAS25,WAS26,WAS27
		EXT	WAS28,WAS29,WAS2A,WAS2B,WAS2C,WAS2D,WAS2E
;
		EXT	KSHPUT
		EXT	KSP00,KSP01,KSP02,KSP03,KSP04,KSP05,KSP06,KSP07
		EXT	KSP08,KSP09,KSP0A,KSP0B,KSP0C,KSP0D,KSP0E,KSP0F
		EXT	KSP10,KSP11,KSP12,KSP13,KSP14,KSP15,KSP16,KSP17
		EXT	KSP18
;
		EXT	KPSRUT
		EXT	KPS00,KPS01,KPS02,KPS03,KPS04,KPS05,KPS06,KPS07
		EXT	KPS08,KPS09,KPS0A,KPS0B,KPS0C,KPS0D,KPS0E,KPS0F
		EXT	KPS10,KPS11,KPS12,KPS13,KPS14,KPS15,KPS16,KPS17
		EXT	KPS18,KPS19,KPS1A,KPS1B,KPS1C,KPS1D,KPS1E,KPS1F
		EXT	KPS20,KPS21,KPS22,KPS23,KPS24,KPS25,KPS26,KPS27
		EXT	KPS28,KPS29,KPS2A,KPS2B,KPS2C,KPS2D,KPS2E,KPS2F
		EXT	KPS30,KPS31,KPS32,KPS33,KPS34,KPS35,KPS36,KPS37
		EXT	KPS38,KPS39,KPS3A,KPS3B,KPS3C,KPS3D,KPS3E,KPS3F
		EXT	KPS40,KPS41,KPS42,KPS43,KPS44,KPS45,KPS46,KPS47
		EXT	KPS48,KPS49,KPS4A,KPS4B,KPS4C,KPS4D,KPS4E,KPS4F
		EXT	KPS50,KPS51,KPS52,KPS53,KPS54
;
		EXT	W81UNT
		EXT	W8100,W8101,W8102,W8103,W8104,W8105,W8106,W8107
		EXT	W8108,W8109,W810A,W810B,W810C,W810D,W810E,W810F
		EXT	W8110,W8111,W8112,W8113,W8114,W8115,W8116,W8117
		EXT	W8118,W8119,W811A,W811B,W811C,W811D,W811E,W811F
		EXT	W8120,W8121,W8122,W8123,W8124,W8125,W8126,W8127
		EXT	W8128,W8129,W812A,W812B,W812C,W812D
;
		EXT	PLY2UT
		EXT	PLY20,PLY21
;
;<MR3B2COMN>=================================================================
		EXT	B2KMST,B3KMST,OAMCLR
;
;<MR3B2CS>===================================================================
		EXT	INWTRDT,SENKNDT,SMKUPDT,DOUKTDT,BILCSDT
		EXT	SIRCSDT,SENDMDT,ICECSDT,TATCSDT,SAKCSDT
		EXT	CHIKADT,SOGENDT,SABK1DT,SABK2DT,ASRTCDT
		EXT	SKTRDDT,FUNEDAT,SKYKMDT,B2BNSDT,ICETKDT
		EXT	WTRASDT,KINMISE,KUPSRDT,W81CSDT,W82CSDT
		EXT	W8HIKDT,PLY2DAT,INWTRD1,PICHIDT,INWTRD2
;
;<MR3WIND>===================================================================
		EXT	WDPRAT
;
;---------------------------------------------------------------------
;
		ORG	02A8000H
		EXTEND
		IDX8
		MEM8
;
;---------------------------------------------------------------------
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL SLTFLH					x
;x							x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLTFLH		EQU	$
		LDA	!RGMMOD
		CMP	#004H
		BCC	STFH99
		PHB
		PHK
		PLB
		PHX
		INC	!STFLSH
		LDA	!STFHST
		ASL	A
		TAX
		JSR	(STFHAD,X)
		PLX
		PLB
STFH99		EQU	$
		RTL
;
STFHAD		EQU	$
		WORD	STFH00,STFH50
;
;
;
STFH00		EQU	$
		LDA	!STFLSH
		AND	#007H
		BNE	STFH40
;
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	!STFLSH
		AND	#00018H
		ASL	A
		STA	<WORK0
		LDA	!SCRPNT
		AND	#0000FH
		ASL	A
		ORA	<WORK0
		TAX
		LDA	STFHD0,X
		STA	<WORK0
		INC	A
		STA	<WORK4
		LDA	STFHD0+008H,X
		STA	<WORK2
		INC	A
		STA	<WORK6
		JSR	STCHNG			; character change
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
STFH40		EQU	$
		LDA	!STFLSH
		CMP	#018H
		BNE	STFH45
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	!SCRPNT
		AND	#000FH
		ASL	A
		TAX
		LDA	SLTB2AD,X
		STA	<WORKA
		LDA	#000FCH			; character NO. set
		STA	<WORK0			;
		STA	<WORK4			;
		LDA	#000FCH			;
		STA	<WORK2			;
		STA	<WORK6			;
		LDA	STFHCT,X
		STA	<WORK8
		JSR	SLTB2ST
		MEM8
		SEP	#00100000B		; memory 8bit mode
		STZ	!STFLSH
		INC	!STFHST
;
STFH45		EQU	$
		RTS
;
;
STFH50		EQU	$
		LDA	!STFLSH
		AND	#007H
		BNE	STFH90
		LDA	!STFLSH
		AND	#018H
		ASL	A
		STA	<WORK0
		LDA	!SCRPNT
		ASL	A
		ADC	<WORK0
		TAY
		LDA	!STFLSH
		AND	#060H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
;
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	SLTB2AD,X		; address set
		STA	<WORKA
		LDA	STFHD0+000H,Y		; character NO. set
		STA	<WORK0			;
		INC	A			;
		STA	<WORK4			;
		LDA	STFHD0+008H,Y		;
		STA	<WORK2			;
		INC	A			;
		STA	<WORK6			;
;
		LDA	STFHCT,X		; count set
		STA	<WORK8			;
		JSR	SLTB2ST
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
STFH90		EQU	$
		RTS
;
;
STFHD0		EQU	$
		WORD	000FCH,000FCH,000FCH,000FCH
		WORD	000FCH,000FCH,000FCH,000FCH
;
STFHD1		EQU	$
		WORD	00997H,00599H,00997H,009A3H
		WORD	04997H,04599H,04997H,049A3H
;
STFHD2		EQU	$
		WORD	0099AH,0059CH,0099AH,0099EH
		WORD	0499AH,0459CH,0499AH,0499EH
;
STFHD3		EQU	$
		WORD	009A5H,005A7H,009A5H,009A9H
		WORD	049A5H,045A7H,049A5H,049A9H
;
STFHCT		EQU	$
		WORD	(SLTAD2-SLTAD1)/2
		WORD	(SLTAD3-SLTAD2)/2
		WORD	(SLTAD2-SLTAD1)/2
		WORD	(SLTAD4-SLTAD3)/2
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL SLTCH					x
;x			(slot character change)		x
;x							x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLTCH		EQU	$
		PHB
		PHK
		PLB
		PHX
		PHY
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDX	#10000000B		; inc mode
		STX	2115H
;
		LDA	#000FCH			; character NO. set
		STA	<WORK0			;
		STA	<WORK4			;
		LDA	#000FCH			;
		STA	<WORK2			;
		STA	<WORK6			;
		JSR	STCHNG			; character change
;
		LDA	!SCRPNT			; set item
		AND	#0000FH
		ASL	A
		TAX
		LDA	SLTCH2,X
		STA	<WORK0
;
		LDY	#000H			; 2,3,5 UP set
CHUP235		EQU	$
		LDA	UP235AD,Y
		STA	2116H
		LDA	<WORK0
		STA	2118H
		INY
		INY
		CPY	#UP235DD-UP235AD
		BNE	CHUP235
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PLY
		PLX
		PLB
		STZ	!STFLSH
		STZ	!STFHST
		RTL
;
;
SLTCH2		EQU	$
		WORD	009ABH,009ACH,009ABH,009ADH
;
SLTCHAD		EQU	$
		WORD	SLTAD2,SLTAD3		; set ki-no-ko
		WORD	SLTAD1,SLTAD3		; set ha-na
		WORD	SLTAD2,SLTAD3		; set ki-no-ko
		WORD	SLTAD1,SLTAD2		; set ho-si
;
;
SLTCT0		EQU	$
		WORD	(SLTAD3-SLTAD2)/2	; set ki-no-ko
		WORD	(SLTAD2-SLTAD1)/2	; set ha-na
		WORD	(SLTAD3-SLTAD2)/2	; set ki-no-ko
		WORD	(SLTAD2-SLTAD1)/2	; set ho-si
;
SLTCT1		EQU	$
		WORD	(SLTAD4-SLTAD3)/2	; set ki-no-ko
		WORD	(SLTAD4-SLTAD3)/2	; set ha-na
		WORD	(SLTAD4-SLTAD3)/2	; set ki-no-ko
		WORD	(SLTAD3-SLTAD2)/2	; set ho-si
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x						x
;x	character change			x
;x						x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
		MEM16
STCHNG		EQU	$
		LDA	!SCRPNT			; set item
		AND	#0000FH
		ASL	A
		TAY
		ASL	A
		TAX
		LDA	SLTCHAD,X		; address data set
		STA	<WORKA
		LDA	SLTCT0,Y		; count set
		STA	<WORK8			;
		PHY
		JSR	SLTB2ST
		PLY
;
		LDA	SLTCHAD+2,X		; address data set
		STA	<WORKA
		LDA	SLTCT1,Y		; count set
		STA	<WORK8			;
		JSR	SLTB2ST
		RTS
		MEM8
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	SLOTB2					x
;x			( slot BG2 set )		x
;x							x
;x				work 0,1--		x
;x				     2,3 +-> chara NO.	x
;x				     8,9 -> count	x
;x							x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SLOTB2		EQU	$
		PHB
		PHK
		PLB
		STZ	2115H
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	#000FCH
		STA	<WORK0
		LDA	#01000H
		STA	2116H			; Vram address
		LDA	#01808H
		STA	4300H			; B-bus address & DMA control paramater set
		LDA	#WORK0
		STA	4302H			; (L,H)
		STZ	4304H			; A-bus address (B)
		LDA	#01000H
		STA	4305H			; data count
		LDY	#00000001B
		STY	420BH			; DMA ch "ON"
;
		LDX	#080H
		STX	2115H
		STA	4305H			; data count
		LDA	#01000H
		STA	2116H			; Vram address
		LDA	#01908H
		STA	4300H			; B-bus address & DMA control paramater set
		LDA	#WORK1
		STA	4302H			; (L,H)
		STY	420BH			; DMA ch "ON"
;
		LDA	SLTB2AD			; ki-no-ko
		STA	<WORKA
		LDA	#009A5H
		STA	<WORK0
		INC	A
		STA	<WORK4
		LDA	#049A5H
		STA	<WORK2
		INC	A
		STA	<WORK6
		LDA	#(SLTAD2-SLTAD1)/2
		STA	<WORK8
		JSR	SLTB2ST
;
		LDA	SLTB2AD+2		; ha-na
		STA	<WORKA
		LDA	#005A7H
		STA	<WORK0
		INC	A
		STA	<WORK4
		LDA	#045A7H
		STA	<WORK2
		INC	A
		STA	<WORK6
		LDA	#(SLTAD3-SLTAD2)/2
		STA	<WORK8
		JSR	SLTB2ST
;
		LDA	SLTB2AD+6		; ho-si
		STA	<WORKA
		LDA	#009A9H
		STA	<WORK0
		INC	A
		STA	<WORK4
		LDA	#049A9H
		STA	<WORK2
		INC	A
		STA	<WORK6
		LDA	#(SLTAD4-SLTAD3)/2
		STA	<WORK8
		JSR	SLTB2ST
;
		LDA	#009AEH			; 2,3,5 up set
		STA	<WORK2
		LDA	#009AFH
		STA	<WORK4
		LDY	#000H
UP235ST		EQU	$
		LDA	#009ABH
		STA	<WORK0
UP235LP		EQU	$
		LDA	UP235AD,Y
		STA	2116H
		LDA	<WORK0
		STA	2118H
		LDA	<WORK2
		STA	2118H
		LDA	<WORK4
		STA	2118H
		INY
		INY
		CPY	#UP235DD-UP235AD
		BEQ	UP235ED
		TYA
		AND	#00002H
		BNE	UP235LP
		INC	<WORK0
		LDA	<WORK0
		CMP	#009AEH
		BNE	UP235LP
		BRA	UP235ST
;
UP235ED		EQU	$
		MEM8
		SEP	#00100000B		; memory 8bit mode
		PLB
		RTL
;
;
		MEM16
SLTB2ST		EQU	$
;
		LDY	#000H
SLTB2LP		EQU	$
		LDA	(<WORKA),Y		; up harf set
		STA	2116H
		LDA	<WORK0
		STA	2118H
		LDA	<WORK2
		STA	2118H
;
		LDA	(<WORKA),Y		; down harf set
		CLC
		ADC	#00020H
		STA	2116H
		LDA	<WORK4
		STA	2118H
		LDA	<WORK6
		STA	2118H
;
		INY
		INY
		DEC	<WORK8			; count DEC.
		BNE	SLTB2LP
		RTS
		MEM8
;
;
SLTB2AD		EQU	$
		WORD	SLTAD1,SLTAD2,SLTAD1,SLTAD3
;
UP235AD		EQU	$
		WORD	01076H,01283H,0122BH,01294H,01146H,01177H
		WORD	01476H,01683H,0162BH,01694H,01546H,01577H
		WORD	01876H,01A83H,01A2BH,01A94H,01946H,01977H
		WORD	01C76H,01E83H,01E2BH,01E94H,01D46H,01D77H
UP235DD		EQU	$
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	BKMGST					x
;x			( blanking messege set )	x
;x							x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BKMGST		EQU	$
		LDA	#10000000B		; inc mode
		STA	2115H
;
		MEM16
		REP	#00100000B		; memory 16bit mode
;
		LDA	#06800H
		STA	2116H			; VRAM address set
		LDA	#00000001B+(18H*100H)	; parameter & B bus address
		STA	4300H
		LDA	#0F000H			; adress
		STA	4302H
;;;;K;;;;		LDX	#037H			; bank
		LDX	#047H			; bank
		STX	4304H
		LDA	#01000H
		STA	4305H
		LDX	#00000001B		; DMA "ON"
		STX	420BH
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#00FH
		STA	<BGBKFG
;
		LDA	!MNPLNO			; flag set
		STA	!PLNMNO			;	MARIO ---> 0
		LDA	!TWOFLG			;	LUIGE ---> 1
		AND	#002H			; 2 play battle -> 2
		BEQ	BKMG00			;
;						;
		LDX	<UNITNO			;
		CPX	#DOKAN			;
		BEQ	BKMG00			; dokan ?
;						; no
		STA	!PLNMNO			;
;
BKMG00		EQU	$
		JSL	>OAMCLR
		JSL	>PLNMPT
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	TKRDKN					x
;x			(ta-ka-ra bu-ne sa-ka-sa dokan) x
;x							x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
TKRDKN		EQU	$
		LDA	!UNITFG
		AND	#00FH
		STA	<WORK2
;
TKR000		EQU	$
		LDY	!XYPSFG
;
		LDA	#BDK3D3
		STA	[<BUFFNO],Y
		JSL	>BFHICLR	; buffer HI clear
		INY
		LDA	#BDK4D3
		STA	[<BUFFNO],Y
		JSL	>BFHICLR	; buffer HI clear
;
		LDA	!XYPSFG
		CLC
		ADC	#010H
		STA	!XYPSFG
		LDA	<BUFFNO+1
		ADC	#000H
		STA	<BUFFNO+1
;
		DEC	<WORK2
		BNE	TKR000
;
		M16			; memory 16bit mode
		LDA	<BUFFNO
		STA	<ENMWK0
		M8			; memory 8bit mode
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
;
		LDY	!XYPSFG
		LDA	#TRDK0
		STA	[<ENMWK0],Y
		JSR	HISET		; buffer HI set
		INY
		LDA	<ENMWK0+1
		SEC
		SBC	#020H
		STA	<ENMWK0+1
		LDA	#TRDK1
		STA	[<ENMWK0],Y
		JSR	HISET
;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	HKSENST					x
;x			( hi-ko-u-se-n ki ha-si )	x
;x							x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
HKSENST		EQU	$
		LDY	!XYPSFG
;
		LDA	#MART0
		STA	[<BUFFNO],Y
;
		RTL
;
;VBILYM
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	BILYMSP					x
;x			( bill ya-ma special )		x
;x							x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BILYMSP		EQU	$
		PHB
		PHK
		PLB
;
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
		M16		; memory 16bit mode
		LDA	<BUFFNO
		CLC
		ADC	#02000H
		STA	<ENMWK0
		M8		; memory 8bit mode
		LDA	!XYPSFG
		STA	<WORK3
		LDX	#000H
;
BLYM000		EQU	$
		LDY	<WORK3
;
		LDA	BLYMDT,X
		CMP	#BLBC0
		BEQ	BLYM010
		CMP	#0FFH
		BEQ	BLYM090
		STA	[<BUFFNO],Y
		AND	#0F0H
		BNE	BLYM010
		LDA	#001H
		STA	[<ENMWK0],Y
;
BLYM010		EQU	$
		INX
		INC	<WORK3
		LDA	<WORK3
		AND	#007H
		BNE	BLYM000
		LDA	<WORK3
		AND	#0F0H
		CLC
		ADC	#010H
		STA	<WORK3
		BRA	BLYM000
;
BLYM090		EQU	$
		PLB
		RTL
;
BLYMDT	EQU	$
	BYTE	BLBC0,BLBC0,BLBC0,BYM00,BYM02,BLBC0,BLBC0,BLBC0
	BYTE	BLBC0,BLBC0,BLBC0,BYM01,BYM04,BYM02,BLBC0,BLBC0
	BYTE	BLBC0,BLBC0,BLBC0,BYM01,BYM11,BYM03,BLBC0,BLBC0
	BYTE	BLBC0,BLBC0,BYM00,BYM06,BYM11,BYM03,BLBC0,BLBC0
	BYTE	BLBC0,BYM00,BYM06,BYM0E,BYM11,BYM03,BLBC0,BLBC0
	BYTE	BYM00,BYM06,BYM0E,BYM04,BYM06,BYM04,BYM02,BLBC0
	BYTE	BYM01,BYM04,BYM10,BYM11,BYM0E,BYM11,BYM04,BYM02
	BYTE	BYM01,BYM11,BYM0E,BYM11,BYM04,BYM06,BYM11,BYM03
	BYTE	0FFH
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	YURYUR					x
;x			water yu-ra yu-ra set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
YURYUR		EQU	$
;
		RTL
;
		PHB
		LDA	#BANK HDMABF1
		PHA
		PLB			; DBR <-- #BANK HDMABF1
;
		LDA	>B2SCL
		AND	#0FEH
		TAX
		LDY	#000H
		M16			; memory 16bit mode
		LDA	#0001FH
		STA	<WORK0
		LDA	>SCCH2
		STA	<WORK2
;
YRYRLOP		EQU	$
		LDA	>YRYRDT,X
		CLC
		ADC	<WORK2
		STA	!HDMABF1+000H,Y
		STA	!HDMABF1+040H,Y
		STA	!HDMABF1+080H,Y
		STA	!HDMABF1+0C0H,Y
		STA	!HDMABF1+100H,Y
		STA	!HDMABF1+140H,Y
		STA	!HDMABF1+180H,Y
		STA	!HDMABF1+1C0H,Y
		INX
		INX
		INY
		INY
		DEC	<WORK0		; 1 sa-i-ku-ru end ?
		BPL	YRYRLOP		;	NO -> YRYRLOP
;
		M8			; memory 8bit mode
		PLB			; pull (B)
;
		LDA	<FRCNT
		AND	#003H
		BNE	YRYR80
		INC	!B2SCL
		INC	!B2SCL
;
YRYR80		EQU	$
		LDA	!WD420C
		ORA	#080H
		STA	!WD420C
;
		RTL
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	AIS5SET					x
;x			ataru ishi 5 data set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
AIS5DAT		EQU	$
		BYTE	ISI00,ISI01,ISI01,ISI01,ISI01,ISI02
		BYTE	ISI06,ISI07,ISI07,ISI07,ISI07,ISI08
;
AIS5SET		EQU	$
		PHB
		PHK
		PLB
;
		LDX	#000H
		LDY	!XYPSFG
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
AIS500		EQU	$
		M16			; memory 16bit mode
		LDA	<BUFFNO
		CLC
		ADC	#0010H
		STA	<ENMWK0
		M8			; memory 8bit mode
;
		LDA	AIS5DAT+00H,X
		STA	[<BUFFNO],Y
		LDA	AIS5DAT+06H,X
		STA	[<ENMWK0],Y
		JSR	>YPINCST
		INX
		CPX	#006H
		BNE	AIS500
;
		PLB
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	B2EDST					x
;x				 ending BG2 set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
B2EDST		EQU	$
		LDA	!BG2COS
		BEQ	B2ED90
		STZ	!B2SCL
		LDA	#0B0H
		STA	!B2RMPT
		LDA	#1AH
		STA	!WRITCT
		STZ	<ENMWK0
		STZ	<ENMWK0+1
;
B2ED00		EQU	$
		JSR	B2EDUT
;
		INC	!B2SCL
		LDA	!B2SCL
		AND	#001H
		BNE	B2ED50
;
		LDA	!B2RMPT
		CLC
		ADC	#010H
		STA	!B2RMPT
;
		AND	#0F0H
		BNE	B2ED50
		INC	!B2RMPT
;
B2ED50		EQU	$
		DEC	!WRITCT
		BNE	B2ED00
		BRA	B2ED99
;
B2ED90		EQU	$
		M16			; memory 16bit mode
		LDX	#000H
		LDA	#00FFH
B2ED95		EQU	$
		STA	>B2ADRSH+000H,X
		STA	>B2ADRSH+100H,X
		STA	>B2ADRSH+200H,X
		STA	>B2ADRSH+300H,X
		STA	>B2ADRSH+400H,X
		STA	>B2ADRSH+500H,X
		STA	>B2ADRSH+600H,X
		DEX
		DEX
		BNE	B2ED95
		M8			; memory 8bit mode
;
B2ED99		EQU	$
		STZ	<ENMWK0
		STZ	<ENMWK0+1
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	B2EDUT					x
;x				 ending BG2 set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
B2EDUT		EQU	$
;
		PHB
		PHK
		PLB
;
		LDA	!B2SCL
		AND	#001H
		STA	<BGUTFG
;
		LDA	!BG2COS		; character
		ASL	A		;	unit adress point
		CLC			;	-->
		ADC	!BG2COS		;	   WORK6 (L)
		TAY			;	   WORK7 (H)
		LDA	CHRUNT+2,Y	;	   WORK8 (B)
		STA	<WORK8		;
		M16			; memory 16bit mode
		LDA	CHRUNT,Y	;
		STA	<WORK6		;
		M8			; memory 8bit mode
;
		LDA	#BANK B2RMBF0
		STA	<WORKF
		M16			; memory 16bit mode
		STZ	<WORKD		; ram adress point
;
		LDA	#0010H
		STA	<WORK0
		LDA	!B2RMPT
		AND	#00F0H
		STA	<WORK9
		I16			; index 16bit mode
;
		LDA	!B2RMPT
		AND	#001H
		BEQ	B2ED050
		LDA	<WORKD
		CLC
		ADC	#0100H
		STA	<WORKD
;
B2ED050		EQU	$
		LDX	<ENMWK0
		LDY	<WORK9
		LDA	[<WORKD],Y
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		TAY
		LDA	<BGUTFG
		AND	#00FFH
		BEQ	B2ED055
		INY
		INY
;
B2ED055		EQU	$
		LDA	[<WORK6],Y
		STA	>B2ADRSH,X
		INY
		INY
		INY
		INY
		LDA	[<WORK6],Y
		STA	>B2ADRSH+2,X
;
		INC	<WORK9
;
B2ED150		EQU	$
		INC	<ENMWK0
		INC	<ENMWK0
		INC	<ENMWK0
		INC	<ENMWK0
		DEC	<WORK0
		BNE	B2ED050
;
		MI8			; memory , index 8bit mode
;
		PLB
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	BIGYKST					x
;x				( world 4  )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
BIGYKST		EQU	$
		PHB
		PHK
		PLB
;
		M16			; memory 16bit mode
		LDA	<BUFFNO
		STA	<ENMWK0
		LDA	#0010H
		STA	<ENMWK3
		M8			; memory 8bit mode
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
;
		LDA	!UNITFG
		AND	#00FH
		TAX
;
		LDY	!XYPSFG
;
		LDA	BIGDAT,X
		STA	[<ENMWK0],Y
		JSR	HISET
		JSR	INC10
;
		INX
		LDA	BIGDAT,X
		STA	[<ENMWK0],Y
		JSR	HISET
;
		PLB
		RTL
;
;
BIGDAT		EQU	$
		BYTE	BGYK0,BGYK1
		BYTE	BGYK2,BGYK3
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	MISESET					x
;x				( shop	)		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
MISESET		EQU	$
		PHB
		PHK
		PLB
;
		LDA	[<DATANO]
		TAX
		M16			; memory 16bit mode
		INC	<DATANO
		LDA	<BUFFNO
		STA	<ENMWK0
		LDA	#0001H
		STA	<ENMWK3
		M8			; memory 8bit mode
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
;
		LDA	!UNITFG
		AND	#00001111B
		STA	<WORK3
;
		LDY	!XYPSFG
;
		TXA
		BEQ	MISE050
		CPX	#004H
		BNE	MISE010
		M16			; memory 16bit mode
		DEC	<ENMWK0
		DEC	<ENMWK0
		M8			; memory 8bit mode
		LDA	#SHSP0
		STA	[<ENMWK0],Y
		M16			; memory 16bit mode
		INC	<ENMWK0
		M8			; memory 8bit mode
		LDA	#SHSP0
		STA	[<ENMWK0],Y
		M16			; memory 16bit mode
		INC	<ENMWK0
		M8			; memory 8bit mode
;
MISE010		EQU	$
		LDA	MISED1,X
		STA	[<ENMWK0],Y
		JSR	HISET
		JSR	INC10
		DEC	<WORK3
;
		LDA	#MISE0
		STA	<WORK2
		JSR	MISE030
;
		LDA	MISED2,X
		STA	[<ENMWK0],Y
		JSR	HISET
		JSR	INC10
;
		CPX	#004H
		BNE	MISE100
		LDA	#SHSP0
		STA	[<ENMWK0],Y
		M16			; memory 16bit mode
		INC	<ENMWK0
		M8			; memory 8bit mode
		LDA	#SHSP0
		STA	[<ENMWK0],Y
		BRA	MISE100
;
MISE050		EQU	$
		LDA	#010H
		STA	<ENMWK3
		LDA	#MISE5
		STA	<WORK2
		JSR	MISE030
;
MISE100		EQU	$
		PLB
		RTL
;
;
MISE030		EQU	$
		LDA	<WORK3
		BEQ	MISE040
		LDA	<WORK2
		STA	[<ENMWK0],Y
		JSR	HISET
		JSR	INC10
		DEC	<WORK3
		BRA	MISE030
MISE040		EQU	$
		RTS
;
;
MISED1		EQU	$-1
		BYTE	MISE1,MISE1,MISE4,MISE6,MISE9,MISE6
;
MISED2		EQU	$-1
		BYTE	MISE2,MISE3,MISE2,MISE7,MISE7,MISE8
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	BONASST					x
;x			( si-ro ro-u-so-ku )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
BONASST		EQU	$
		PHB
		PHK
		PLB
		LDA	[<DATANO]
		STA	<WORK3
		STA	<ENMWK5
;
		M16			; memory 16bit mode
		INC	<DATANO
		LDA	<BUFFNO
		STA	<ENMWK0
		M8			; memory 8bit mode
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
;
		LDA	!UNITFG		; index set
		AND	#00001111B	;
		TAX			;
		LDA	BNSSTCT,X
		STA	<ENMWK3
		STZ	<ENMWK4
;
		STZ	<WORK2
		TXA
		BNE	BNSST25
		LDA	[<DATANO]
		STA	<WORK2
		M16			; memory 16bit mode
		INC	<DATANO
		M8			; memory 8bit mode
;
BNSST25		EQU	$
		LDY	!XYPSFG
;
BNSST20		EQU	$
		LDA	BNSSTDT,X
		STA	[<ENMWK0],Y
		JSR	HISET
		JSR	INC10
		DEC	<WORK3
		BNE	BNSST20
;
		LDA	<WORK2
		BEQ	BNSST50
		DEC	<WORK2
		M16			; memory 16bit mode
		LDA	<BUFFNO
		CLC
		ADC	#0010H
		STA	<BUFFNO
		STA	<ENMWK0
		M8			; memory 8bit mode
		LDA	<ENMWK5
		STA	<WORK3
		BRA	BNSST20
;
BNSST50		EQU	$
		PLB
		RTL
;
BNSSTCT		EQU	$
		BYTE	001H,00FH,001H,011H
		BYTE	010H,010H,011H,001H
		BYTE	00FH,00FH,011H,011H
		BYTE	00FH,001H,001H,001H
;
BNSSTDT		EQU	$
		BYTE	BNS00,BNS01,BNS02,BNS03
		BYTE	BNS04,BNS05,BNS06,BNS07
		BYTE	BNS08,BNS09,BNS0A,BNS0B
		BYTE	BNS0C,BNS0D,BNS0E,BNS0F
;
INC10		EQU	$
		M16			; memory 16bit mode
		LDA	<ENMWK0
		SEC
		SBC	#02000H
		CLC
		ADC	<ENMWK3
		STA	<ENMWK0
		M8			; memory 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	SIRORO					x
;x			( si-ro ro-u-so-ku )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SIRORO		EQU	$
		PHB
		PHK
		PLB
		LDA	<WORK0
		PHA
		LDA	<WORK1
		PHA
		PHX
;
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
		STA	<ENMWK3+2
		MEM16
		REP	#00100000B	; memory 16bit mode
		LDA	<BUFFNO
		STA	<ENMWK0
		CLC
		ADC	#02000H
		STA	<ENMWK3
;;K;;		LDA	<BUFFNO
;;K;;		SEC
;;K;;		SBC	#02000H
;;K;;		STA	<WORK0
ROST10		EQU	$
;;K;;		SEC
;;K;;		SBC	#01B0H
;;K;;		BMI	ROST20
;;K;;		AND	#0FFF0H
;;K;;		STA	<WORK0
;;K;;		BRA	ROST10
ROST20		EQU	$
;;K;;		LSR	<WORK0
;;K;;		LSR	<WORK0
;;K;;		LSR	<WORK0
;;K;;		LSR	<WORK0
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDX	#000H
ROST40		EQU	$
		JSR	RMDEC
		LDA	[<ENMWK0],Y
		CMP	#BLOC0
		BEQ	ROST90
		CMP	#BLOK2
		BEQ	ROST90
		LDA	RODAT,X
		STA	[<ENMWK0],Y
;;K;;		DEC	<WORK0
;;K;;		BEQ	ROST90
		CPX	#002H
		BEQ	ROST50
		INX
		BRA	ROST40
;
ROST50		EQU	$
		JSR	RMDEC
		LDA	[<ENMWK0],Y
		CMP	#BLOC0
		BEQ	ROST90
		CMP	#BLOK2
		BEQ	ROST90
		LDA	#RODI4
		STA	[<ENMWK0],Y
		LDA	#001H
		STA	[<ENMWK3],Y
		BRA	ROST50
;;K;;		DEC	<WORK0
;;K;;		BNE	ROST50
;
ROST90		EQU	$
		PLX
		PLA
		STA	<WORK1
		PLA
		STA	<WORK0
		PLB
		RTL
;
;
RODAT		EQU	$
		BYTE	RODI1,RODI2,RODI3
;
;
RMDEC		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
		LDA	<ENMWK0
		SEC
		SBC	#0010H
		STA	<ENMWK0
		LDA	<ENMWK3
		SEC
		SBC	#0010H
		STA	<ENMWK3
		MEM8
		SEP	#00100000B	; memory 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	LURDSST				      X
;x	( sa-ka unit change )			      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
LURDSST		EQU	$
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	<BUFFNO
		SEC
		SBC	#0010H
		STA	<ENMWK0
		MEM8
		SEP	#00100000B		; memory 8bit mode
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
		LDA	[<ENMWK0],Y
		CMP	#YM113
		BNE	LURDEND
		LDA	#YM30A
		STA	[<ENMWK0],Y
		JSR	HISET
LURDEND		EQU	$
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	JMNDST				      X
;x	( sa-ka unit change )			      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
JMNDST		EQU	$
		M16			; memroy 16bit mode
		LDA	<BUFFNO
		CLC
		ADC	#0010H
		STA	<ENMWK0
		M8			; memory 8bit mode
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
		LDA	[<ENMWK0],Y
		CMP	#YM101
		BNE	JMNDEND
;
		LDA	#YM30C
		STA	[<ENMWK0],Y
		JSR	HISET
;
JMNDEND		EQU	$
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	RULDST				      X
;x	( sa-ka unit change )			      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
RULDST		EQU	$
		PHY
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
		M16				; memory 16bit mode
		LDA	<BUFFNO
		CLC
		ADC	#000FH
		STA	<ENMWK0
		TYA
		AND	#00FFH
		BNE	RULD010
		LDA	<ENMWK0
		SEC
		SBC	#01A0H
		STA	<ENMWK0
RULD010		EQU	$
		M8				; memory 8bit mode
		LDA	[<ENMWK0],Y
		CMP	#YM112
		BNE	RULD020
		LDA	<ENMWK0
		SEC
		SBC	#010H
		STA	<ENMWK0
		LDA	#YM305
		STA	[<ENMWK0],Y
		JSR	HISET
;
RULD020		EQU	$
		M16				; memory 16bit mode
		LDA	<BUFFNO
		SEC
		SBC	#0010H
		STA	<ENMWK0
		M8				; memory 8bit mode
		INY
		TYA
		AND	#00FH
		BNE	RULD030
		M16				; memory 16bit mode
		LDA	<ENMWK0
		CLC
		ADC	#01A0H
		STA	<ENMWK0
		M8				; memory 8bit mode
RULD030		EQU	$
		LDA	[<ENMWK0],Y
		CMP	#YM110
		BNE	RULD050
		M16				; memory 16bit mode
		LDA	<ENMWK0
		CLC
		ADC	#0010H
		STA	<ENMWK0
		M8				; memory 8bit mode
		LDA	#YM301
		STA	[<ENMWK0],Y
		JSR	HISET
RULD050		EQU	$
		PLY
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	LFUPST				      X
;x	( sa-ka unit change )			      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
LFUPST		EQU	$
		PHY
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	<BUFFNO
		SEC
		SBC	#0010H
		STA	<ENMWK0
		MEM8
		SEP	#00100000B		; memory 8bit mode
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
;
		LDA	[<ENMWK0],Y
		CMP	#YM110
		BEQ	S2T055
		CMP	#YM009
		BEQ	S2T055
		LDA	#YM304
		STA	[<ENMWK0],Y
		JSR	HISET
S2T055		EQU	$
		PLY
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	RTUPST				      X
;x	( sa-ka unit change )			      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
RTUPDT		EQU	$
		BYTE	YM305,YM30B
;
RTUPST		EQU	$
		PHB
		PHK
		PLB
		PHX
		PHY
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
		MEM16
		REP	#00100000B		; memory 16bit mode
		LDA	<BUFFNO
		SEC
		SBC	#0010H
		STA	<ENMWK0
		MEM8
		SEP	#00100000B		; memory 8bit mode
		LDA	[<ENMWK0],Y
		CMP	#YM112
		BEQ	S3T165
		CMP	#YM111
		BEQ	S3T165
		LDA	RTUPDT,X
		STA	[<ENMWK0],Y
		JSR	HISET
;
S3T165		EQU	$
		PLY
		PLX
		PLB
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	LFKBST				      X
;x	( sa-ka unit change )			      x
;x				left ka-be	      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
LFKBST		EQU	$
		PHX
		PHY
;
		LDA	[<BUFFNO],Y
		CMP	#YM10E
		BNE	LFKBSTF
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
		M16				; memory 16bit mode
		LDA	<BUFFNO
		PHA
		CLC
		ADC	#0011H
		STA	<ENMWK0
		PLA
		CLC
		ADC	#000FH
		STA	<ENMWK3
		TYA
		AND	#000FH
		BNE	LFKBST0
		LDA	<ENMWK0
		CLC
		ADC	#01A0H
		STA	<ENMWK0
		LDA	<ENMWK3
		CLC
		ADC	#01A0H
		STA	<ENMWK3
LFKBST0		EQU	$
		M8				; memory 8bit mode
		LDA	[<ENMWK0],Y
		CMP	#YM110
		BNE	LFKBSTF
		M16				; memory 16bit mode
		LDA	<ENMWK0
		SEC
		SBC	#0010H
		STA	<ENMWK0
		M8				; memory 8bit mode
		LDA	#YM304
		STA	[<ENMWK0],Y
		JSR	HISET
		BRA	LFKBST8
;
;
LFKBSTF		EQU	$
		M16				; memory 16bit mode
		LDA	<ENMWK3
		STA	<ENMWK0
		M8				; memory 8bit mode
		LDA	[<ENMWK0],Y
		CMP	#YM112
		BEQ	LFKBST1
		CMP	#YM115
		BNE	LFKBST8
LFKBST1		EQU	$
		M16				; memory 16bit mode
		LDA	<ENMWK0
		SEC
		SBC	#0010H
		STA	<ENMWK0
		M8				; memory 8bit mode
		LDA	#YM305
		STA	[<ENMWK0],Y
		JSR	HISET
;
LFKBST8		EQU	$
		PLY
		PLX
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	RTKBST				      X
;x	( sa-ka unit change )			      x
;x				right ka-be	      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
RTKBST		EQU	$
		PHY
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
		M16				; memory 16bit mode
		LDA	<BUFFNO
		STA	<ENMWK0
		M8				; memory 8bit mode
;
		TYA
		CLC
		ADC	#00FH
		TAY
		AND	#0F0H
		BNE	RTKB10
		INC	<ENMWK0+1
;
RTKB10		EQU	$
		LDA	[<ENMWK0],Y
		CMP	#YM101
		BEQ	RTKB20
		CMP	#YM100
		BEQ	RTKB20
		CMP	#YM201
		BNE	RTKB30
;
RTKB20		EQU	$
		INY
		TYA
		AND	#00FH
		BNE	RTKB25
		M16				; memory 16bit mode
		LDA	<ENMWK0
		CLC
		ADC	#01A0H
		STA	<ENMWK0
		M8				; memory 8bit mode
RTKB25		EQU	$
		LDA	#YM301
		STA	[<ENMWK0],Y
		JSR	HISET
;
RTKB30		EQU	$
		PLY
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	KDSNST				      X
;x	( sa-ka unit change )			      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KDSNDT		EQU	$
		BYTE	YM309,YM303,YM307
;
KDSNST		EQU	$
		PHB
		PHK
		PLB
		PHY
		PHX
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
		STA	<ENMWK3+2
		M16				; memory 16bit mode
		LDA	<BUFFNO
		STA	<ENMWK0
;
		SEC				; right up adress
		SBC	#000FH
		STA	<ENMWK3
;
		TYA
		AND	#000FH
		BNE	KDSN10
		LDA	<ENMWK0			; left up adress
		SEC
		SBC	#01A0H
		STA	<ENMWK0
;
KDSN10		EQU	$
		LDA	<ENMWK0
		SEC
		SBC	#0011H
		STA	<ENMWK0
		M8				; memory 8bit mode
;
		LDX	#00H
		LDA	[<ENMWK0],Y
		CMP	#YM106
		BEQ	KDSN15
		CMP	#YM002
		BEQ	KDSN30
		CMP	#YM00A
		BEQ	KDSN30
		CMP	#YM00B
		BEQ	KDSN30
		CMP	#YM202
		BEQ	KDSN20
		CMP	#YM212
		BEQ	KDSN20
		CMP	#YM102
		BEQ	KDSN20
		CMP	#YM112
		BEQ	KDSN20
		BRA	KDSN50
;
KDSN15		EQU	$
		INX
KDSN20		EQU	$
		INX
KDSN30		EQU	$			; back unit NO. set
		M16				; memory 16bit mode
		LDA	<ENMWK0
		CLC
		ADC	#0010H
		STA	<ENMWK0
		M8				; memory 8bit mode
		LDA	KDSNDT,X
		STA	[<ENMWK0],Y
		JSR	HISET
;
KDSN50		EQU	$
		LDA	[<ENMWK3],Y
		CMP	#YM110
		BEQ	KDSN60
		CMP	#YM210
		BNE	KDSN70
;
KDSN60		EQU	$
		M16				; memory 16bit mode
		LDA	<ENMWK3
		CLC
		ADC	#0010H
		STA	<ENMWK3
		M8				; memory 8bit mode
		LDA	#YM301
		STA	[<ENMWK3],Y
		LDA	<ENMWK3+1
		CLC
		ADC	#020H
		STA	<ENMWK3+1
		LDA	#01H
		STA	[<ENMWK3],Y
;
KDSN70		EQU	$
		TYA
		CLC
		ADC	#0010H
		TAY
		LDA	[<BUFFNO],Y
		CMP	#YM301
		BEQ	KDSN75
		CMP	#YM303
		BNE	KDSN90
KDSN75		EQU	$
		JSL	>BFHICLR
		LDA	#YM113
		STA	[<BUFFNO],Y
KDSN90		EQU	$
		PLX
		PLY
		PLB
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	SKUCNGR				      X
;x	( sa-ka unit change )			      x
;x			left up -> right dwon	      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
HIUTLD		EQU	$
		BYTE	YM309,YM303,YM303,YM307,YM309
;			chijou,chika,water,chika,chijou
;			45		  |  22.5
SKUCGLD		EQU	$
		PHB
		PHK
		PLB
		PHX
		PHY
;
		M16			; memory 16bit mode
		LDA	<BUFFNO
		STA	<ENMWK0
		M8			; memory 8bit mode
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
;
		M16			; memory 16bit mode
		INY
		TYA
		AND	#000FH
		BNE	SKLFD10
		LDA	<ENMWK0
		CLC
		ADC	#01A0H
		STA	<ENMWK0
;
;;K;;		TYA
;;K;;		AND	#00FFH
;;K;;		CLC
;;K;;		ADC	#01A0H
;;K;;		TAY
;
SKLFD10		EQU	$
		M8			; memory 8bit mode
;
		LDA	[<ENMWK0],Y
		CMP	#SUIC0		; su-i-me-n ?
		BNE	SKLFD20		; no -> SKLFD20
		DEY
		LDA	#YM302
		STA	[<ENMWK0],Y
		JSR	HISET
;
SKLFD20		EQU	$
		PLY
		PLX
		PHX
		PHY
		LDA	[<BUFFNO],Y
		CMP	#YM106
		BEQ	SKLFD60
		M16			; memory 16bit mode
		LDA	<BUFFNO
		STA	<ENMWK0
		M8			; memory 8bit mode
		TYA
		AND	#00FH
		BNE	SKLFD50
		M16			; memory 16bit mode
		LDA	<ENMWK0
		SEC
		SBC	#01A0H
		STA	<ENMWK0
		M8			; memory 8bit mode
SKLFD50		EQU	$
		DEY
;
		LDA	[<ENMWK0],Y
		CMP	#YM001
		BEQ	SKLFD60
		CMP	#YM008
		BEQ	SKLFD60
		CMP	#YM101
		BEQ	SKLFD60
		CMP	#YM201
		BEQ	SKLFD60
		CMP	#YM30C
		BEQ	SKLFD60
;
		LDA	HIUTLD,X
		STA	[<ENMWK0],Y
		JSR	HISET
;
SKLFD60		EQU	$
		PLY
		PHY
		LDA	[<BUFFNO],Y
		CMP	#YM102
		BEQ	SKLFD75
		CMP	#YM202
		BEQ	SKLFD75
		CMP	#YM106
SKLFD75		EQU	$
		BNE	SKLFD90
		M16			; memory 16bit mode
		LDA	<BUFFNO
		CLC
		ADC	#0010H
		STA	<ENMWK0
		M8			; memory 8bit mode
		INY
		TYA
		AND	#00FH
		BNE	SKLFD70
		M16			; memory 16bit mode
		LDA	<ENMWK0
		CLC
		ADC	#01A0H
		STA	<ENMWK0
		M8			; memory 8bit mode
SKLFD70		EQU	$
		LDX	#003H
		LDA	[<ENMWK0],Y
		CMP	#YM201
		BEQ	SKLFD85
		CMP	#YM101
		BNE	SKLFD90
		TYA
		AND	#00FH
		BNE	SKLFD80
		M16			; memory 16bit mode
		LDA	<ENMWK0
		SEC
		SBC	#01A0H
		STA	<ENMWK0
		M8			; memory 8bit mode
SKLFD80		EQU	$
		BRA	SKLFD88
SKLFD85		EQU	$
		LDX	#002H
SKLFD88		EQU	$
		DEY
		LDA	HIUTLD,X
		STA	[<ENMWK0],Y
		JSR	HISET
;
SKLFD90		EQU	$
		TYA
		AND	#00FH
		BNE	SKLFD93
		M16			; memory 16bit mode
		LDA	<ENMWK0
		SEC
		SBC	#01A0H
		STA	<ENMWK0
		M8			; memory 8bit mode
SKLFD93		EQU	$
		DEY
		LDA	[<BUFFNO],Y
		CMP	#YM106
		BNE	SKLFD95
		LDA	[<ENMWK0],Y
		CMP	#CKBC0
		BNE	SKLFD95
		LDA	HIUTLD+3
		STA	[<ENMWK0],Y
		JSR	HISET
SKLFD95		EQU	$
		PLY
		PLX
		PLB
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	HISET					x
;x		ram buffer high set			x
;x							x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
HISET		EQU	$
		LDA	<ENMWK0+1
		CLC
		ADC	#020H
		STA	<ENMWK0+1
		LDA	#001H
		STA	[<ENMWK0],Y
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSL	SKUCNGR				      X
;x	( sa-ka unit change )			      x
;x			right up -> left  dwon	      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
HIUTRD		EQU	$
		BYTE	YM308,YM301,YM301,YM306
;			chijou,chika,water
;
SKUCNGR		EQU	$
		PHB
		PHK
		PLB
		PHX
		PHY
;
		M16			; memory 16bit mode
		LDA	<BUFFNO
		STA	<ENMWK0
		STA	<ENMWK3
		M8			; memory 8bit mode
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
		STA	<ENMWK3+2
;
		TYA
		CLC
		ADC	#010H
		TAY
		AND	#0F0H
		BNE	SKRFD10
		INC	<ENMWK0+1
;
SKRFD10		EQU	$
		LDA	[<ENMWK0],Y
		CMP	#YM101
		BEQ	SKRFD50
		CMP	#YM110
		BEQ	SKRFD50
		CMP	#YM210
		BEQ	SKRFD50
		LDA	HIUTRD,X
		STA	[<ENMWK0],Y
		JSR	HISET
;
SKRFD50		EQU	$
		PLY
		PHY
		TYA
		AND	#00FH
		BNE	SKRFD60
		M16			; memory 16bit mode
		LDA	<ENMWK3
		SEC
		SBC	#01A0H
		STA	<ENMWK3
		M8			; memory 8bit mode
SKRFD60		EQU	$
		DEY
		LDA	[<ENMWK3],Y
		CMP	#SUIC0
		BNE	SKRFD90
		PLY
		PHY
		LDA	#YM300
		STA	[<BUFFNO],Y
		MI16			; memory , index 16bit mode
		TYA
		ORA	#02000H
		TAY
		M8			; memory 8bit mode
		LDA	#001H
		STA	[<BUFFNO],Y
		I8			; index 8bit mode
SKRFD90		EQU	$
		PLY
		PLX
		PLB
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	 JSL	  B2WKST			      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
B2WKST		EQU	$
;
; yo-ko line set
;
		M16			; memory 16bit mode
		LDA	#01000H
		XBA
		STA	!VRAMD+2
		LDA	#040BEH
		XBA
		STA	!VRAMD+4
		LDA	#30FBH		; ku-ro be-ta set
		STA	!VRAMD+6
		LDA	#0FFFFH
		STA	!VRAMD+8
		M8			; memory 8bit mode
		JSR	WKVRMST
;
		M16			; memory 16bit mode
		LDA	#01300H
		XBA
		STA	!VRAMD+2
		LDA	#0403EH
		XBA
		STA	!VRAMD+4
		M8			; memory 8bit mode
		JSR	WKVRMST
;
		M16			; memory 16bit mode
		LDA	#01060H
		XBA
		STA	!VRAMD+2
;
		LDA	#0003FH
		XBA
		STA	!VRAMD+4
;
		LDX	#40H		; UP yo-ko line
		LDA	#04D9H		;	data set
WAKU020		EQU	$		;
		STA	!VRAMD+6,X	;
		DEX			;
		DEX			;
		BPL	WAKU020		;
		LDA	#04E7H		;
		STA	!VRAMD+6+01EH	;
		LDA	#04E8H		;
		STA	!VRAMD+6+020H	;
;
		LDA	#0FFFFH
		STA	!VRAMD+6+040H
		M8			; memory 8bit mode
;
		JSR	WKVRMST
;
		M16			; memory 16bit mode
		LDA	#012E0H		;
		XBA			;
		STA	!VRAMD+2	;
;
		LDX	#40H		; DOWN yo-ko line
		LDA	#04E5H		;	data set
WAKU040		EQU	$		;
		STA	!VRAMD+6,X	;
		DEX			;
		DEX			;
		BPL	WAKU040		;
		LDA	#04E9H		;
		STA	!VRAMD+6+01EH	;
		LDA	#04EAH		;
		STA	!VRAMD+6+020H	;
;
		LDA	#0FFFFH
		STA	!VRAMD+6+040H
		M8			; memory 8bit mode
;
		JSR	WKVRMST
;
; ta-te line set
;
		M16			; memory 16bit mode
		LDA	#01000H
		XBA
		STA	!VRAMD+2
		LDA	#0C02EH
		XBA
		STA	!VRAMD+4
		LDA	#30FBH		; ku-ro be-ta set
		STA	!VRAMD+6
		LDA	#0FFFFH
		STA	!VRAMD+8
		M8			; memory 8bit mode
;
		JSR	WKVRMST
;
		LDA	#10H
		STA	!VRAMD+2
		LDA	#1FH
		STA	!VRAMD+3
;
		JSR	WKVRMST
;
		M16			; memory 16bit mode
;
		LDA	#01061H		; Left side line set
		XBA			;
		STA	!VRAMD+2	;
		LDA	#08029H		;
		XBA			;
		STA	!VRAMD+4	;
;
		LDA	#24D8H		;
		STA	!VRAMD+6	;
;
		LDA	#24DBH		;
		LDX	#24H		;
WAKU010		EQU	$		;
		STA	!VRAMD+8,X	;
		DEX			;
		DEX			;
		BPL	WAKU010		;
		LDA	#24EBH		;
		STA	!VRAMD+18H	;
		LDA	#24ECH		;
		STA	!VRAMD+1AH	;
		LDA	#24EDH		;
		STA	!VRAMD+1CH	;
		LDA	#24E4H		;
		STA	!VRAMD+2EH	;
		LDA	#0FFFFH
		STA	!VRAMD+30H
;
		M8			; memory 8bit mode
;
		JSR	WKVRMST
;
		M16			; memory 16bit mode
;
		LDA	#0107EH		; Right side line set
		XBA			;
		STA	!VRAMD+2	;
;
		LDA	#24DAH		;
		STA	!VRAMD+6	;
		LDA	#24E3H		;
		LDX	#24H		;
WAKU030		EQU	$		;
		STA	!VRAMD+8,X	;
		DEX			;
		DEX			;
		BPL	WAKU030		;
		LDA	#24EEH		;
		STA	!VRAMD+18H	;
		LDA	#24F0H		;
		STA	!VRAMD+1AH	;
		LDA	#24F1H		;
		STA	!VRAMD+1CH	;
		LDA	#24E6H		;
		STA	!VRAMD+2EH	;
;
		M8			; memory 8bit mode
;
		JSR	WKVRMST
;
		STZ	!VRAMD
		STZ	!VRAMD+1
		LDA	#0FFH
		STA	!VRAMD+2
		STA	!VRAMD+3
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	 JSR	  WKVRMST			      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
WKVRMST		EQU	$
		M16			; memory 16bit mode
		LDA	#VRAMD+2
		STA	<TRNADR
		LDX	#BANK VRAMD
		STX	<TRNADR+2
		M8			; memory 8bit mode
		JSL	>VRAMTR
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	BG2CLR					x
;x			BG2 rambuff clear		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
BG2CLR		EQU	$
		PHB
		LDA	#BANK B2RMBF0
		PHA
		PLB
		MI16			; memory , index 16bit mode
;
		LDX	#01AEH
B2CRLOP		EQU	$
		STZ	B2RMBF0,X
		STZ	B2RMBF1,X
		STZ	B2RMBF2,X
		STZ	B2RMBF3,X
		STZ	B2RMBF4,X
		STZ	B2RMBF5,X
		STZ	B2RMBF6,X
		STZ	B2RMBF7,X
		STZ	B2RMBF8,X
		DEX
		DEX
		BPL	B2CRLOP
;
		MI8			; memory , index 8bit mode
		PLB
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	BG2SET0					x
;x			BG2 rambuff kyo-u-tu-u set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
		IDX16
BG2SET0		EQU	$
		STA	>B2RMBF0,X
		STA	>B2RMBF2,X
		STA	>B2RMBF4,X
		STA	>B2RMBF6,X
		STA	>B2RMBF8,X
;
		RTS
		IDX8
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	BG2SET2					x
;x			BG2 rambuff kyo-u-tu-u set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
		IDX16
BG2SET2		EQU	$
		STA	>B2RMBF0+10H,X
		STA	>B2RMBF2+10H,X
		STA	>B2RMBF4+10H,X
		STA	>B2RMBF6+10H,X
		STA	>B2RMBF8+10H,X
;
		RTS
		IDX8
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	BG2SET3					x
;x			BG2 rambuff kyo-u-tu-u set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
BG2SET3		EQU	$
		PHB
		LDY	#BANK B2RMBF0
		PHY
		PLB
;
		STA	B2RMBF0,X
		STA	B2RMBF1,X
		STA	B2RMBF2,X
		STA	B2RMBF3,X
		STA	B2RMBF4,X
		STA	B2RMBF5,X
		STA	B2RMBF6,X
		STA	B2RMBF7,X
		STA	B2RMBF8,X
;
		PLB
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	BG2SET1					x
;x			BG2 rambuff kyo-u-tu-u set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
BG2SET1		EQU	$
		PHB
		LDY	#BANK B2RMBF0
		PHY
		PLB
;
		STA	B2RMBF0+0100H,X
		STA	B2RMBF1+0100H,X
		STA	B2RMBF2+0100H,X
		STA	B2RMBF3+0100H,X
		STA	B2RMBF4+0100H,X
		STA	B2RMBF5+0100H,X
		STA	B2RMBF6+0100H,X
		STA	B2RMBF7+0100H,X
		STA	B2RMBF8+0100H,X
;
		PLB
		RTS
;
;
B2CSADR		EQU	$-3
		LWORD	INWTRDT		; 01 in water
		LWORD	SENKNDT		; 02 se-n-ka-n
		LWORD	SMKUPDT		; 03 ko-ku-pa
		LWORD	DOUKTDT		; 04 do-u-ku-tu chika1
		LWORD	BILCSDT		; 05 bill
		LWORD	SIRCSDT		; 06 to-ri-de
		LWORD	SENDMDT		; 07 demo
		LWORD	ICECSDT		; 08 ice
		LWORD	TATCSDT		; 09 ta-te
		LWORD	SAKCSDT		; 0A sa-ka
		LWORD	CHIKADT		; 0B chi-ka2
		LWORD	SOGENDT		; 0C so-ge-n
		LWORD	SABK1DT		; 0D sa-ba-ku 1
		LWORD	SABK2DT		; 0E sa-ba-ku 2
		LWORD	ASRTCDT		; 0F a-su-re-ti-ku
		LWORD	SKTRDDT		; 10 sa-ba-ku to-ri-de
		LWORD	FUNEDAT		; 11 fu-ne (8world)
		LWORD	SKYKMDT		; 12 sky ku-mo
		LWORD	B2BNSDT		; 13 BG2 bonas
		LWORD	ICETKDT		; 14 ice chi-ka
		LWORD	CHIKADT		; 15 chi-ka (special)
		LWORD	WTRASDT		; 16 water a-su-re-ti-ku (ta-ki)
		LWORD	KINMISE		; 17 ki-no-pi-o shop
		LWORD	ASRTCDT		; 18 a-su-re-ti-ku (yu-ki)
		LWORD	SABK2DT		; 19 sa-ba-ku 2 (pi-ra-mi-do up set)
		LWORD	BILCSDT		; 1A bill (special) 5-3
		LWORD	KUPSRDT		; 1B ku-pa si-ro
		LWORD	W81CSDT		; 1C world 8 - 1
		LWORD	W82CSDT		; 1D world 8 - 2
		LWORD	WTRASDT		; 1E water a-su-re-ti-ku (ta-ki) 2 chara up
		LWORD	W8HIKDT		; 1F world 8 ha-i-ko-u
		LWORD	PLY2DAT		; 20 2 play battle
		LWORD	INWTRD1		; 21 in water (up na-si)
		LWORD	PICHIDT		; 22 pi-i-chi room set
		LWORD	SENKNDT		; 23 ta-ka-ra hu-ne
		LWORD	SMKUPDT		; 24 small ku-pa ( sander na-si )
		LWORD	INWTRD2		; 25 in water set (up & mid na-si)
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	 JSL	  BG2BFST				x
;x							x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
BG2BFST		EQU	$
		PHB
		PHK
		PLB
;
		LDA	!BG2COS
		CMP	#017H
		BEQ	ONSND2
;
ONSND2		EQU	$
		JSR	BG2CLR
;
		STZ	!WD420C
		STZ	420CH
		LDA	!BG2COS		; BG2 course data adress set
		ASL	A
		CLC
		ADC	!BG2COS
		TAX
		LDA	B2CSADR+2,X
		STA	<DATANO+2
		M16			; memory 16bit mode
		LDA	B2CSADR,X
		STA	<DATANO
		M8			; memory 8bit mode
		LDY	#00H
		LDA	[<DATANO],Y	; BG2 color NO. set
		STA	!BG2CLRF	;
;
		INY			; BG2 special ram used flag set
		LDA	[<DATANO],Y	;  0 = Reset
		STA	!B2SPFG		;  1 = Set
;
		MI16			; memory , index 16bit mode
		LDA	<DATANO
		CLC
		ADC	#0002H
		STA	<DATANO
;
		LDA	!BG2COS
		AND	#00FFH
		ASL	A
		TAX
		M8			; memory 8bit mode
		JMP	(BETAST,X)
;
;
BTRTS		EQU	$
		I8			; index 8bit mode
		PLB
		RTL
;
;
BETAST		EQU	$
		WORD	BTRTS		; 00 Dumy
		WORD	WTRST		; 01 in water set
		WORD	SENKN		; 02 se-n-ka-n
		WORD	SKUPA		; 03 small ku-pa
		WORD	DOUKT		; 04 do-u-ku-tsu chi-ka
		WORD	BILST		; 05 bill
		WORD	SIRST		; 06 si-ro
		WORD	SENST		; 07 se-n-sha , se-n-ka-n demo
		WORD	ICEST		; 08 ice
		WORD	TATST		; 09 ta-te
		WORD	SAKST		; 0A sa-ka
		WORD	CHIKA		; 0B chi-ka
		WORD	SOGEN		; 0C so-u-ge-n
		WORD	SABK1		; 0D sa-ba-ku 1
		WORD	SABK2		; 0E sa-ba-ku 2
		WORD	ASRTC		; 0F a-su-re-ti-ku
		WORD	SBTRD		; 10 sa-ba-ku to-ri-de
		WORD	FNEST		; 11 fu-ne (8world)
		WORD	BTRTS		; 12 Dumy
		WORD	B2BNS		; 13 BG2 bonas
		WORD	B2BNS		; 14 ice chi-ka
		WORD	CHIKA		; 15 chi-ka (special)
		WORD	WASST		; 16 water a-su-re-ti-ku (ta-ki)
		WORD	KNMIS		; 17 ki-no-pi-o shop
		WORD	ASRTC		; 18 a-su-re-ti-ku (yu-ki)
		WORD	SABK2		; 19 sa-ba-ku 2 (pi-ra-mi-do up set)
		WORD	BILST		; 1A bill (special) 5-3
		WORD	KPSET		; 1B ku-pa si-ro
		WORD	W81ST		; 1C world 8 - 1
		WORD	ASRTC		; 1D world 8 - 2 (a-su-re-ti-ku)
		WORD	WASST		; 1E water a-su-re-ti-ku (ta-ki) 2 chara up
		WORD	W8HST		; 1F world 8 ha-i-ko-u
		WORD	PL2ST		; 20 2 play battle
		WORD	WTRST		; 21 in water set (up na-si)
		WORD	PICHI		; 22 pi-i-chi room set
		WORD	SENKN		; 23 ta-ka-ra hu-ne
		WORD	SKUPA		; 24 small ku-pa ( sander na-si )
		WORD	WTRST		; 25 in water set (up & mid na-si)
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	DATFLG						x
;x				buffer adress	--> WORK0,1	x
;x				 ko-su-u	--> ENMWK0,1	x
;x				special		--> ENMWK2,3	x
;x					data set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
DATFLG		EQU	$
		PHA
		ROL	A
		ROL	A
		ROL	A
		ROL	A
		AND	#007H
		STA	<WORK4
		PLA			; ram buffer adress set
		AND	#01FH		;
		XBA			;
		INY			;
		LDA	[<DATANO],Y	;
		M16			; memory 16bit mode
		LSR	A		;
		LSR	A		;
		LSR	A		;
		LSR	A		;
		STA	<WORK0		;
		M8			; memory 8bit mode
		LDA	[<DATANO],Y	;
		AND	#00FH		;
		BEQ	DAT020		;
		STA	<WORK2		;
		STZ	<WORK3		;
		M16			; memory 16bit mode
DAT010		EQU	$		;
		LDA	<WORK0		;
		CLC			;
		ADC	#01B0H		;
		STA	<WORK0		;
		DEC	<WORK2		;
		BNE	DAT010		;
		M8			; memory 8bit mode
;
DAT020		EQU	$
		INY
		LDA	[<DATANO],Y
		AND	#00FH
		STA	<ENMWK0
		STZ	<ENMWK1
;
		LDA	[<DATANO],Y
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		TAX
;
		STZ	<ENMWK2
		STZ	<ENMWK3
		LDA	<WORK4
		BEQ	DAT030
		INY
		LDA	[<DATANO],Y
		STA	<ENMWK2
;
DAT030		EQU	$		; next data point inc
		M16			; memory 16bit mode
		LDA	<WORK4
		AND	#00FFH
		BEQ	DAT040
		INC	<DATANO
;
DAT040		EQU	$
		INC	<DATANO
		INC	<DATANO
		INC	<DATANO
		M8			; memory 8bit mode
		RTS
;
;
;-------------- < BG2 water character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	WTRST					x
;x			water be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
WTRST		EQU	$
		I8			; idex 8bit mode
		LDY	#00H
;
		LDX	#070H
WTR010		EQU	$		; 170h line set
		LDA	#WGIW5
		JSR	BG2SET1
		INX
		TXA
		AND	#00FH
		BNE	WTR010
;
WTR020		EQU	$		; 180h line set
		LDA	#WGIW5
		JSR	BG2SET1
		INX
		TXA
		AND	#00FH
		BNE	WTR020
;
		I16			; idex 16bit mode
		LDX	#0170H
		LDA	#WGIW8
		JSR	BG2SET0
;
		INX
		LDA	#WGIWB
		JSR	BG2SET0
		INX
		JSR	BG2SET0
		INX
		JSR	BG2SET0
		INX
		JSR	BG2SET0
;
		INX
		LDA	#WGIW9
		JSR	BG2SET0
;
		INX
		LDA	#WGIW1
		JSR	BG2SET0
;
		LDX	#0174H+01B0H
		JSR	BG2SET0
		I8			; idex 8bit mode
;
WTRSET		EQU	$
		LDY	#00H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	WTREND
;
		JSR	DATFLG		; data set
;
		JSR	(WTRUT,X)
;
		BRA	WTRSET
;
WTREND		EQU	$
		PLB
;
		RTL
;
;
WTRUT		EQU	$
		WORD	AOKUSA
		WORD	AKASNG
		WORD	NEZIWA
;
HDMADR		EQU	$
;;;;K;;;;		BYTE	0F8H
;;;;K;;;;		WORD	HDMABF
;;;;K;;;;		BYTE	0F8H
;;;;K;;;;		WORD	HDMABF+78H*2
;;;;K;;;;		BYTE	00
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	AOKUSA					x
;x			water a-o ku-sa set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
AOKUSA		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	#WAOK0
		JSR	BG2SET0
		LDA	#WAOK2
		JSR	BG2SET2
;
		LDA	<ENMWK0
		BEQ	AOKS50
;
AOKS30		EQU	$
		INX
		LDA	#WAOK4
		JSR	BG2SET0
		LDA	#WAOK6
		JSR	BG2SET2
		INX
		LDA	#WAOK5
		JSR	BG2SET0
		LDA	#WAOK7
		JSR	BG2SET2
		DEC	<ENMWK0
		BNE	AOKS30
;
AOKS50		EQU	$
		INX
		LDA	#WAOK1
		JSR	BG2SET0
		LDA	#WAOK3
		JSR	BG2SET2
		I8			; index 8bit mode
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	AKASNG					x
;x			water a-ka sa-n-go set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
AKASNG		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	#WAKK0
		JSR	BG2SET0
		LDA	<ENMWK0
		BEQ	AKSG30
;
AKSG10		EQU	$
		INX
		LDA	#WAKK1
		JSR	BG2SET0
		DEC	<ENMWK0
		BNE	AKSG10
;
AKSG30		EQU	$
		INX
		LDA	#WAKK2
		JSR	BG2SET0
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	NEZIWA					x
;x			water ne-zu-mi i-wa set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
NEZIWA		EQU	$
		LDA	#BANK IWADT
		STA	<WORK8
		STA	<WORKB
		STA	<WORKE
		MI16			; memory , index 16bit mode
		LDX	<ENMWK0
		LDA	IWADT,X
		STA	<WORK6
		LDA	IWAAD,X
		STA	<WORK9
		LDA	IWACT,X
		STA	<WORKC
		M8			; memory 8bit mode
		LDA	IWAGY,X
		STA	<WORKF
		LDX	<WORK0
		LDY	#0000H
		LDA	[<WORKC]
		STA	<WORK2
		STZ	<WORK4
		STZ	<WORK5
;
NZIWLP		EQU	$		; unit NO. set
		LDA	[<WORK6],Y	;
		JSR	BG2SET0		;
		INY			;
		INX			;
		TXA			;
		AND	#00FH		;
		BNE	NZIW15		;
		M16			; memory 16bit mode
		TXA			; next page pu-ra-su
		CLC			;
		ADC	#01A0H		;
		TAX			;
		M8			; memory 8bit mode
NZIW15		EQU	$		;
		DEC	<WORK2		;
		BNE	NZIWLP		;
;
NZIW10		EQU	$
		DEC	<WORKF
		BEQ	NZIW50
		PHY
		M16			; memory 16bit mode
		LDA	<WORK4		; ka-i-gi-yo-u
		ASL	A		;
		TAY			;
		LDA	<WORK0		;
		CLC			;
		ADC	[<WORK9],Y	;
		STA	<WORK0		;
		M8			; memory 8bit mode
		INC	<WORK4
		LDY	<WORK4
		LDA	[<WORKC],Y
		STA	<WORK2
		LDX	<WORK0
		PLY
		BRA	NZIWLP
;
NZIW50		EQU	$
		I8			; index 8bit mode
		RTS
;
;
IWAGY	EQU	$
	WORD	0005H,0004H,0002H,0002H,0005H,0005H,0006H
;
IWADT	EQU	$
	WORD	IWADT0,IWADT1,IWADT2,IWADT3,IWADT4,IWADT5,IWADT6
;
IWAAD	EQU	$
	WORD	IWAAD0,IWAAD1,IWAAD2,IWAAD3,IWAAD4,IWAAD5,IWAAD6
;
IWACT	EQU	$
	WORD	IWACT0,IWACT1,IWACT2,IWACT3,IWACT4,IWACT5,IWACT6
;
;---------------- unit ba-ta data
IWADT0	EQU	$
	BYTE	WGIW0,WGIW1,WGIW1,WGIW2
	BYTE	WGIW3,WGIW4,WGIW5,WGIW5,WGIW1,WGIW2
	BYTE	WGIW0,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW4,WGIW2
	BYTE	WGIW0,WGIW8,WGIW9,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW7
	BYTE	WGIW0,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW2
;
IWADT1	EQU	$
	BYTE	WGIW0,WGIW1,WGIW2
	BYTE	WGIW0,WGIW5,WGIW5,WGIW6
	BYTE	WGIWA,WGIWB,WGIWB,WGIWB,WGIWB,WGIW9,WGIW5,WGIW5,WGIW5,WGIW4,WGIW2
	BYTE	WGIW3,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW5,WGIW6
;
IWADT2	EQU	$
	BYTE	WCIW0,WCIW1,WCIW2
	BYTE	WCIWC,WCIW6,WCIW9
;
IWADT3	EQU	$
	BYTE	WCIW0,WCIW1,WCIW1,WCIW2
	BYTE	WCIWC,WCIW6,WCIW5,WCIW9
;
IWADT4	EQU	$
	BYTE	000H,000H,WCIW0,WCIW2
	BYTE	WCIW0,WCIW1,WCIW3,WCIW3,WCIW2,WCIW0,WCIWE,WCIWE,WCIW2
	BYTE	WCIW0,WCIW1,WCIW1,WCIW3,WCIW3,WCIW3,WCIW8,WCIW6,WCIW5,WCIW6,WCIW5,WCIW7,WCIW2
	BYTE	WCIWC,WCIW6,WCIW7,WCIW8,WCIW6,WCIW5,WCIW5,WCIWA,000H,000H,WCIWB,WCIW6,WCIW9
	BYTE	WCIWB,WCIW6,WCIW5,WCIWA
;
IWADT5	EQU	$
	BYTE	WCIW0,WCIW1,WCIW2
	BYTE	WCIW0,WCIW1,WCIW3,WCIW3,WCIW3,WCIW1,WCIWE,WCIW2
	BYTE	WCIW2,00H,WCIW0,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3,WCIW1,WCIW2
	BYTE	WCIW3,WCIW4,WCIW5,WCIW6,WCIW6,WCIW5,WCIW7,WCIW8,WCIW6,WCIW6,WCIW5,WCIW6,WCIW9
	BYTE	WCIW5,WCIW5,WCIWA,000H,000H,WCIWB,WCIW6,WCIW5,WCIWA
;
IWADT6	EQU	$
	BYTE	WCIW0,WCIW1,WCIWE,WCIW1,WCIW2
	BYTE	WCIW0,WCIW1,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3,WCIW1
	BYTE	WCIW0,WCIW1,WCIW1,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3
	BYTE	WCIW0,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3,WCIW3,WCIW6,WCIW6,WCIW5,WCIW6
	BYTE	WCIWC,WCIW5,WCIW6,WGIWD,WCIW6,WCIW5,WCIW6,WCIW5,WCIWA
	BYTE	WCIWB,WCIW5,WCIWA
;
;---------------- ram buffer adress inc
IWAAD0	EQU	$
	WORD	0010H,000FH,000DH,000FH
;
IWAAD1	EQU	$
	WORD	000FH,000AH,0010H
;
IWAAD2	EQU	$
	WORD	0010H
;
IWAAD3	EQU	$
	WORD	0010H
;
IWAAD4	EQU	$
	WORD	0010H,000DH,0010H,0011H
;
IWAAD5	EQU	$
	WORD	000EH,000DH,0010H,0010H
;
IWAAD6	EQU	$
	WORD	000EH,000DH,000FH,0010H,0012H
;
;---------------- yo-ko unit count
IWACT0	EQU	$
	BYTE	04H,06H,08H,0BH,0DH
;
IWACT1	EQU	$
	BYTE	03H,04H,0BH,0BH
;
IWACT2	EQU	$
	BYTE	03H,03H
;
IWACT3	EQU	$
	BYTE	04H,04H
;
IWACT4	EQU	$
	BYTE	04H,09H,0DH,0DH,04H
;
IWACT5	EQU	$
	BYTE	03H,08H,0DH,0DH,09H
;
IWACT6	EQU	$
	BYTE	05H,08H,0BH,0CH,09H,03H
;
;
;-------------- < BG2 se-n-ka-n character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SENKN					x
;x			se-n-ka-n set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SENKN		EQU	$
		I8			; index 8bit mode
;
		STZ	!NOPAUSE
		LDA	!BG2COS
		CMP	#023H
		BNE	PASSET
		LDA	#001H		; no pause set
		STA	!NOPAUSE
;
PASSET		EQU	$
		LDX	#0A0H
		LDA	#040H
		STA	<WORK0
		LDA	#SKKM5
SNKNLP0		EQU	$		; ku-ro ku-mo ba-ta set
		JSR	BG2SET3
		INX
		DEC	<WORK0
		BNE	SNKNLP0
;
		LDA	#SKKMB
		STA	<WORK2
		LDA	#SKKMC
		STA	<WORK3
		LDA	#002H
		STA	<WORK1
SNKNBT1		EQU	$
		LDA	#008H
		STA	<WORK0
SNKNLP1		EQU	$		; ne-zu-mi ku-mo set
		LDA	<WORK2
		JSR	BG2SET3
		INX
		LDA	<WORK3
		JSR	BG2SET3
		INX
		DEC	<WORK0
		BNE	SNKNLP1
		INC	<WORK2
		INC	<WORK2
		INC	<WORK3
		INC	<WORK3
		DEC	<WORK1
		BNE	SNKNBT1
;
		LDA	#004H
		STA	<WORK1
SNKNBT2		EQU	$
		LDA	#008H
		STA	<WORK0
SNKNLP2		EQU	$
		LDA	#SKKMF
		JSR	BG2SET1
		INX
		LDA	#SKKMF
		JSR	BG2SET1
		INX
		DEC	<WORK0
		BNE	SNKNLP2
		DEC	<WORK1
		BNE	SNKNBT2
;
SNKNLP		EQU	$
		LDY	#00H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	SNKNEND
;
		JSR	DATFLG		; data set
;
		JSR	(SNKNUT,X)
;
		BRA	SNKNLP
;
SNKNEND		EQU	$
		PLB
		RTL
;
SNKNUT		EQU	$
		WORD	SANDER
		WORD	SENKKM
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SANDER					x
;x			se-n-ka-n set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SANDER		EQU	$
		LDA	!BG2COS
		CMP	#023H
		BEQ	SNDRPS
		I16			; index16bit mode
		LDX	<WORK0
		LDA	#008H
		STA	<WORK2
		STZ	<WORK3
		LDA	#SKSD0
		STA	<WORK4
SNDLP1		EQU	$
		LDY	<ENMWK0
SNDLP2		EQU	$
		LDA	<WORK4
		JSR	BG2SET0
		INC	<WORK4
		INX
		TXA
		AND	#00FH
		BNE	SNDLP3
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#01A0H
		TAX
		M8			; memory 8bit mode
SNDLP3		EQU	$
		DEY
		BNE	SNDLP2
		LDY	<WORK2
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	SNDAD,Y
		STA	<WORK0
		TAX
		M8			; memory 8bit mode
		DEC	<WORK2
		DEC	<WORK2
		BPL	SNDLP1
;
		LDA	#SKSD6
		JSR	BG2SET0
		LDA	#SKSD7
		INX
		JSR	BG2SET0
;
		I8			; index 8bit mode
SNDRPS		EQU	$
		RTS
;
SNDAD		EQU	$
		WORD	0010H,000FH,0010H,0010H,0010H
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SENKKM					x
;x			se-n-ka-n set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SENKKM		EQU	$
		LDA	#BANK SNKGY
		STA	<WORK8
		STA	<WORKB
		STA	<WORKE
		MI16			; memory , index 16bit mode
		LDX	<ENMWK0
		LDA	SNKKM,X
		STA	<WORK6
		LDA	SNKAD,X
		STA	<WORK9
		LDA	SNKCT,X
		STA	<WORKC
		STZ	<WORK4
		M8			; memory 8bit mode
		LDA	SNKGY,X
		STA	<WORKF
		LDX	<WORK0
		LDY	#0000H
		LDA	[<WORKC]
		STA	<WORK2
;
		JSR	NZIWLP
;
		RTS
;
SNKGY	EQU	$
	WORD	0005H,0006H,0005H,0006H,0004H
;
SNKKM	EQU	$
	WORD	SNKKM0,SNKKM1,SNKKM2,SNKKM3,SNKKM4
;
SNKAD	EQU	$
	WORD	SNKAD0,SNKAD1,SNKAD2,SNKAD3,SNKAD4
;
SNKCT	EQU	$
	WORD	SNKCT0,SNKCT1,SNKCT2,SNKCT3,SNKCT4
;
;---------------- unit ba-ta data
SNKKM0	EQU	$
	BYTE	SKKM0,SKKM1
	BYTE	SKKM0,SKKM2,SKKM3,SKKM4,SKKM2,SKKM1
	BYTE	SKKM0,SKKM3,SKKM5,SKKM5,SKKM5,SKKM5,SKKM6,SKKM1
	BYTE	SKKM7,SKKM8,SKKM5,SKKM6,SKKM8,SKKM6,SKKM3,SKKM4
	BYTE	SKKM5,SKKM4,SKKM7,SKKM3,SKKM4,SKKM3,SKKM5,SKKM5
;
SNKKM1	EQU	$
	BYTE	SKKM2,SKKM2,SKKM1
	BYTE	SKKM5,SKKM5,SKKM4,SKKM1,SKKM0,SKKM1
	BYTE	SKKM6,SKKM7,SKKM8,SKKM6,SKKM3,SKKM4,SKKM1,SKBET
	BYTE	SKKM6,SKKM7,SKKM3,SKKM5,SKKM4,SKKM3,SKKM5,SKKM5,SKKM4,SKKM2
	BYTE	SKKM6,SKKM3
	BYTE	SKKM4,SKKM3
;
SNKKM2	EQU	$
	BYTE	SKKM0,SKKM2,SKKM1
	BYTE	SKKM0,SKKM1,SKBET,SKKM0,SKKM3,SKKM5,SKKM4,SKKM2,SKKM1
	BYTE	SKKM0,SKKM9,SKKM4,SKKM2,SKKM3,SKKM5,SKKM5,SKKM5,SKKM5,SKKM5
	BYTE	SKKM8,SKKM5,SKKMA,SKKM5,SKKM5,SKKM5,SKKM5,SKKM5,SKKM5,SKKM5
	BYTE	SKKM4,SKKM7,SKKM3
;
SNKKM3	EQU	$
	BYTE	SKKM0,SKKM1
	BYTE	SKKM0,SKKM2,SKKM3,SKKM4
	BYTE	SKKM0,SKKM2,SKKM3
	BYTE	SKKM8
	BYTE	SKKM4,SKKM7,SKKM8
	BYTE	SKKM4,SKKM3
;
SNKKM4	EQU	$
	BYTE	SKKM6,SKKM8
	BYTE	SKKM6,SKKM7,SKKM8,SKKM5,SKKM6,SKKM7,SKKM3,SKKM4,SKKM3
	BYTE	SKKM6,SKKM3,SKKM5,SKKM4,SKKM7,SKKM3
	BYTE	SKKM4,SKKM3
;
;---------------- ram buffer adress inc
SNKAD0	EQU	$
	WORD	000EH,000FH,0010H,0010H
;
SNKAD1	EQU	$
	WORD	0010H,0010H,000EH,000FH,000FH
;
SNKAD2	EQU	$
	WORD	000CH,000FH,0010H,0010H
;
SNKAD3	EQU	$
	WORD	000EH,000EH,0010H,0010H,0012H
;
SNKAD4	EQU	$
	WORD	000AH,000FH,000FH
;
;---------------- yo-ko unit count
SNKCT0	EQU	$
	BYTE	02H,06H,08H,08H,08H
;
SNKCT1	EQU	$
	BYTE	03H,06H,08H,0AH,02H,02H
;
SNKCT2	EQU	$
	BYTE	03H,09H,0AH,0AH,03H
;
SNKCT3	EQU	$
	BYTE	02H,04H,03H,01H,03H,02H
;
SNKCT4	EQU	$
	BYTE	02H,09H,06H,02H
;
;
;-------------- < BG2 small ku-pa character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SKUPA					x
;x			small ku-pa set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SKUPA		EQU	$
		I8			; index 8bit mode
		LDX	#000H
SKPLP0		EQU	$
		LDA	#KPA01
		STA	>B2RMBF0,X
		INX
		CPX	#030H
		BNE	SKPLP0
;
SKPLP1		EQU	$
		LDA	#KPA03
		STA	>B2RMBF0,X
		INX
		LDA	#KPA06
		STA	>B2RMBF0,X
		INX
		CPX	#040H
		BNE	SKPLP1
;
		LDX	#050H
		LDA	#090H
		STA	<WORK0
		LDA	#KPA0F
SKPLP2		EQU	$
		STA	>B2RMBF0,X
		INX
		DEC	<WORK0
		BNE	SKPLP2
;
SKPLP3		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	SKPEND
;
		JSR	DATFLG
;
		JSR	(SKPUT,X)
		BRA	SKPLP3
;
SKPEND		EQU	$
		PLB
		RTL
;
;
SKPUT		EQU	$
		WORD	SKPHSR,YKKAGE,KUPMAD,TATEKG,MRTTNG,SKPOIT
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SKPHSR					x
;x			small ku-pa set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SKPHSR		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
HSR010		EQU	$
		LDA	#KPA00
		STA	>B2RMBF0,X
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0010H
		TAX
		M8			; memory 8bit mode
		LDA	>B2RMBF0,X
		CMP	#KPA06
		BEQ	HSR020
		LDA	#KPA02
		STA	>B2RMBF0,X
HSR015		EQU	$
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0010H
		TAX
		M8			; memory 8bit mode
		DEC	<ENMWK0
		DEC	<ENMWK0
		BPL	HSR010
		BRA	HSREND
;
HSR020		EQU	$
		LDA	#KPA04
		STA	>B2RMBF0,X
		LDA	#KPA05
		STA	>B2RMBF0+1,X
		BRA	HSR015
;
HSREND		EQU	$
		I8			; index 8bit mode
		RTS
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	YKKAGE					x
;x			small ku-pa set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
YKKAGE		EQU	$
		LDY	#000H
		LDX	<WORK0
;
YKKGLP		EQU	$
		LDA	>B2RMBF0,X
		BNE	YKKGPS
		LDA	YKGDAT,Y
		STA	>B2RMBF0,X
		INY
YKKGPS		EQU	$
		INX
		DEC	<ENMWK0
		BPL	YKKGLP
;
		RTS
;
;
YKGDAT		EQU	$
		BYTE	KPA07,KPA08,KPA09,KPA09,KPA09,KPA0A,KPA0B
		BYTE	KPA07,KPA07,KPA07,KPA0C,KPA0D,KPA0E,KPA07
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	KUPMAD					x
;x			small ku-pa set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
KUPMAD		EQU	$
		LDY	#000H
		LDX	<WORK0
		LDA	!BGNOBK
		CMP	#024H
		BEQ	KUPMD10
;
KUPMDLP		EQU	$
		LDA	KPMDDT,Y
		STA	>B2RMBF0,X
		LDA	KPMDDT+03H,Y
		STA	>B2RMBF0+010H,X
		LDA	KPMDDT+06H,Y
		STA	>B2RMBF0+020H,X
		INX
		INY
		DEC	<ENMWK0
		BPL	KUPMDLP
		BRA	KUPMD20
;
KUPMD10		EQU	$
		LDA	KPMDDT1,Y
		STA	>B2RMBF0,X
		LDA	KPMDDT1+03H,Y
		STA	>B2RMBF0+010H,X
		LDA	KPMDDT1+06H,Y
		STA	>B2RMBF0+020H,X
		INX
		INY
		DEC	<ENMWK0
		BPL	KUPMD10
;
KUPMD20		EQU	$
		RTS
;
;
KPMDDT		EQU	$
		BYTE	KPA11,KPA12,KPA13
		BYTE	KPA15,KPA16,KPA13
		BYTE	KPA17,KPA18,KPA19
;
;
KPMDDT1		EQU	$
		BYTE	KPA20,KPA21,KPA13
		BYTE	KPA22,KPA23,KPA13
		BYTE	KPA17,KPA18,KPA19
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	TATEKG					x
;x			small ku-pa set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
TATEKG		EQU	$
		LDX	<WORK0
;
TTKGLP		EQU	$
		LDA	#KPA10
		STA	>B2RMBF0,X
		TXA
		CLC
		ADC	#010H
		TAX
		DEC	<ENMWK0
		BPL	TTKGLP
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	MRTTNG					x
;x			small ku-pa set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
MRTTNG		EQU	$
		LDX	<WORK0
		LDA	>B2RMBF0,X
		CMP	#KPA10
		BEQ	MRT010
		LDA	#KPA1A
		BRA	MRT020
MRT010		EQU	$
		LDA	#KPA1C
;
MRT020		EQU	$
		STA	>B2RMBF0,X
		LDA	#KPA1B
		STA	>B2RMBF0+1,X
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SKPOIT					x
;x			small ku-pa set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SKPOIT		EQU	$
		LDX	<WORK0
		LDY	<ENMWK0
		LDA	POSDAT,Y
		STA	>B2RMBF0,X
		RTS
;
;
POSDAT		EQU	$
		BYTE	KPA14,KPA1D
;
;
;-------------- < BG2 do-u-ku-tsu chi-ka character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	DOUKT					x
;x			do-u-ku-tsu chi-ka set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
DOUKT		EQU	$
		I8			; index 8bit mode
		LDX	#060H
		LDA	#DCK00
DOUKT10		EQU	$
		JSR	BG2SET3
		INX
		CPX	#070H
		BNE	DOUKT10
;
		LDA	#DCK01
DOUKT15		EQU	$
		JSR	BG2SET3
		INX
		CPX	#080H
		BNE	DOUKT15
;
		LDA	#DCK02
		STA	<WORK0
		LDA	#DCK03
		STA	<WORK1
		LDA	#008H
		STA	<WORK2
		LDA	#004H
		STA	<WORK3
DOUKT20		EQU	$
		LDA	<WORK0
		JSR	BG2SET3
		INX
		LDA	<WORK1
		JSR	BG2SET3
		INX
		DEC	<WORK2
		BNE	DOUKT20
		LDA	#008H
		STA	<WORK2
		INC	<WORK0
		INC	<WORK0
		INC	<WORK1
		INC	<WORK1
		DEC	<WORK3
		BNE	DOUKT20
;
		LDA	#010H
		STA	<WORK2
		LDA	#DCK0A
DOUKT30		EQU	$
		JSR	BG2SET3
		INX
		DEC	<WORK2
		BNE	DOUKT30
;
		LDA	#004
		STA	<WORK4
		LDA	#DCK0B
		STA	<WORK0
		INC	A
		STA	<WORK1
		INC	A
		STA	<WORK2
		INC	A
		STA	<WORK3
		JSR	DOUKT40
;
		LDA	#004H
		STA	<WORK4
		LDA	#DCK0F
		STA	<WORK0
		INC	A
		STA	<WORK1
		INC	A
		STA	<WORK2
		INC	A
		STA	<WORK3
		JSR	DOUKT40
;
		LDA	#004H
		STA	<WORK4
		LDA	#DCK13
		STA	<WORK0
		LDA	#DCK14
		STA	<WORK1
		LDA	#DCK19
		STA	<WORK2
		LDA	#DCK1A
		STA	<WORK3
		JSR	DOUKT40
;
		LDX	#070H
		LDA	#004H
		STA	<WORK4
		LDA	#DCK2D
		STA	<WORK0
		LDA	#DCK2E
		STA	<WORK1
		LDA	#DCK33
		STA	<WORK2
		LDA	#DCK34
		STA	<WORK3
		JSR	BILLP60
;
		LDA	#004H
		STA	<WORK4
		LDA	#DCK35
		STA	<WORK0
		INC	A
		STA	<WORK1
		INC	A
		STA	<WORK2
		INC	A
		STA	<WORK3
		JSR	BILLP60
;
		LDA	#004H
		STA	<WORK4
		LDA	#DCK39
		STA	<WORK0
		INC	A
		STA	<WORK1
		INC	A
		STA	<WORK2
		INC	A
		STA	<WORK3
		JSR	BILLP60
;
DOUKT45		EQU	$
		LDA	#DCK0A
		JSR	BG2SET1
		INX
		CPX	#0B0H
		BNE	DOUKT45
;
DOUKT50		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	DOUKT90
;
		JSR	DATFLG
;
DOUKT55		EQU	$
		STZ	<WORK2		; ha-si-ra set
DOUKT60		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0
		STA	<WORK4
		M8			; memroy 8bit mode
		LDA	#009H
		STA	<WORK3
DOUKT65		EQU	$
		LDX	<WORK2
		LDA	DUKTDAT,X
		I16			; index 16bit mode
		LDX	<WORK4
		JSR	BG2SET0		; unit set
		M16			; memory 16bit mode
		LDA	<WORK4
		CLC
		ADC	#0010H
		STA	<WORK4
		MI8			; memroy , index 8bit mode
		INC	<WORK2
		DEC	<WORK3
		BNE	DOUKT65
		INC	<WORK0
		LDA	<WORK2
		CMP	#DUKTEND-DUKTDAT
		BNE	DOUKT60
;
		LDA	<ENMWK0
		BEQ	DOUKT80
		DEC	<ENMWK0
		BRA	DOUKT55
;
DOUKT80		EQU	$
		BRA	DOUKT50
;
DOUKT90		EQU	$
		PLB
		RTL
;
;
;
DOUKT40		EQU	$
		LDA	<WORK0
		JSR	BG2SET3
		INX
		LDA	<WORK1
		JSR	BG2SET3
		INX
		LDA	<WORK2
		JSR	BG2SET3
		INX
		LDA	<WORK3
		JSR	BG2SET3
		INX
		DEC	<WORK4
		BNE	DOUKT40
		RTS
;
;
DUKTDAT		EQU	$
		BYTE	DCK15,DCK1B,000H,000H,000H,000H,000H,DCK29,DCK2F
		BYTE	DCK16,DCK1C,DCK1F,DCK21,DCK23,DCK25,DCK27,DCK2A,DCK30
		BYTE	DCK17,DCK1D,DCK20,DCK22,DCK24,DCK26,DCK28,DCK2B,DCK31
		BYTE	DCK18,DCK1E,000H,000H,000H,000H,000H,DCK2C,DCK32
DUKTEND		EQU	$
;
;-------------- < BG2 bill character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	BILST					x
;x			bill set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
BILST		EQU	$
		I8			; index 8bit mode
		LDA	#CJB3A		; sky set
		STA	<WORK0
		LDA	#CJB01
		STA	<WORK1
		LDA	#008H
		STA	<WORK4
		LDX	#0E0H
		JSR	BILLP10
;
		LDA	#CJB02
		STA	<WORK0
		LDA	#CJB03
		STA	<WORK1
		LDA	#008H
		STA	<WORK4
		JSR	BILLP10
;
		LDA	#CJB04
		STA	<WORK0
		LDA	#CJB05
		STA	<WORK1
		LDA	#008H
		STA	<WORK4
		JSR	BILLP20
;
		LDA	#CJB0B
		STA	<WORK0
		LDA	#CJB0C
		STA	<WORK1
		LDA	#008H
		STA	<WORK4
		JSR	BILLP20
;
		LDA	#020H
		STA	<WORK4
BILLP40		EQU	$
		LDA	#CJB13
		JSR	BG2SET1
		INX
		DEC	<WORK4
		BNE	BILLP40
;
		LDX	#030H
		LDA	#010H
		STA	<WORK4
		LDA	#CJB13
BILLP50		EQU	$
		JSR	BG2SET1
		INX
		DEC	<WORK4
		BNE	BILLP50
;
		JSR	BILYKST
;
		JSR	BIL080
;
BILEND		EQU	$
		LDA	!BG2COS
		CMP	#01AH
		BNE	BILED
		LDA	#000H
		XBA
		INC	!B2SPFG
		I16			; index 16bit mode
		LDY	#B2RMBF3
		LDX	#B2RMBF3+0B0H
		LDA	#0CFH
		MVN	#BANK B2RMBF3,#BANK B2RMBF3
		LDA	#000H
		XBA
		LDY	#B2RMBF4
		LDX	#B2RMBF4+0B0H
		LDA	#0CFH
		MVN	#BANK B2RMBF4,#BANK B2RMBF4
		I8			; index 8bit mode
		LDX	#0E0H
		LDA	#CJB13
BILEDLP		EQU	$
		STA	>B2RMBF3+0D0H,X
		STA	>B2RMBF4+0D0H,X
		DEX
		BNE	BILEDLP
;
		LDX	#070H
		JSR	BILYKST
;
		PHB
		LDA	#BANK BILDT
		PHA
		PLB
		M16			; memory 16bit mode
		INC	<DATANO
		M8			; memory 8bit mode
		JSR	BIL080
		PLB
;
BILED		EQU	$
		PLB
		RTL
;
;
BIL080		EQU	$
		LDY	#00H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	BIL085
;;K;;		BEQ	BILEND
;
		JSR	DATFLG		; data set
;
		LDA	#BANK BILGY
		STA	<WORK8
		STA	<WORKB
		STA	<WORKE
		MI16			; memory , index 16bit mode
		LDX	<ENMWK0
		LDA	BILDT,X
		STA	<WORK6
		LDA	BILAD,X
		STA	<WORK9
		LDA	BILCT,X
		STA	<WORKC
		STZ	<WORK4
		M8			; memory 8bit mode
		LDA	BILGY,X
		STA	<WORKF
		LDX	<WORK0
		LDY	#0000H
		LDA	[<WORKC]
		STA	<WORK2
;
		JSR	NZIWLP
		I8			; index 8bit mode
		BRA	BIL080
BIL085		EQU	$
		RTS
;
;
BILYKST		EQU	$
		LDA	#CJB18		; ha-ya-si set
		STA	<WORK0
		LDA	#CJB19
		STA	<WORK1
		LDA	#CJB1E
		STA	<WORK2
		LDA	#CJB1B
		STA	<WORK3
		LDA	#004H
		STA	<WORK4
		JSR	BILLP60
;
		LDA	#CJB21		; ha-ya-si set
		STA	<WORK0
		LDA	#CJB22
		STA	<WORK1
		LDA	#CJB26
		STA	<WORK2
		LDA	#CJB24
		STA	<WORK3
		LDA	#004H
		STA	<WORK4
		JSR	BILLP60
;
		LDA	#CJB28		; ji-me-n set
		STA	<WORK0
		LDA	#CJB29
		STA	<WORK1
		LDA	#008H
		STA	<WORK4
		JSR	BILLP70
;
		LDA	#CJB38		; ji-me-n set
		STA	<WORK0
		LDA	#CJB39
		STA	<WORK1
		LDA	#008H
		STA	<WORK4
		JSR	BILLP70
		RTS
;
;
BILLP10		EQU	$
		LDA	<WORK0
		JSR	BG2SET3
		INX
		LDA	<WORK1
		JSR	BG2SET3
		INX
		DEC	<WORK4
		BNE	BILLP10
		RTS
;
BILLP20		EQU	$
		LDA	<WORK0
		JSR	BG2SET1
		INX
		LDA	<WORK1
		JSR	BG2SET1
		INX
		DEC	<WORK4
		BNE	BILLP20
		RTS
;
BILLP60		EQU	$
		LDA	<WORK0
		JSR	BG2SET1
		INX
		LDA	<WORK1
		JSR	BG2SET1
		INX
		LDA	<WORK2
		JSR	BG2SET1
		INX
		LDA	<WORK3
		JSR	BG2SET1
		INX
		DEC	<WORK4
		BNE	BILLP60
		RTS
;
BILLP70		EQU	$
		LDA	<WORK0
		JSR	BG2SET1
		INX
		LDA	<WORK1
		JSR	BG2SET1
		INX
		DEC	<WORK4
		BNE	BILLP70
		RTS
;
BILGY		EQU	$
		WORD	0006H,0004H,0006H,0006H,0009H,0006H
;
BILDT		EQU	$
		WORD	BILDT0,BILDT1,BILDT2,BILDT3,BILDT4,BILDT5
;
BILAD		EQU	$
		WORD	BILAD0,BILAD1,BILAD2,BILAD3,BILAD4,BILAD5
;
BILCT		EQU	$
		WORD	BILCT0,BILCT1,BILCT2,BILCT3,BILCT4,BILCT5
;
;---------------- unit ba-ta data
BILDT0		EQU	$
		BYTE	CJB06,CJB07,CJB08
		BYTE	CJB0D,CJB0E,CJB0F,CJB10
		BYTE	CJB0D,CJB0E,CJB14,CJB15
		BYTE	CJB09,CJB16,CJB16,CJB1A,CJB15
		BYTE	CJB11,CJB1C,CJB1C,CJB23,CJB15
		BYTE	CJB2A,CJB2B,CJB2C,CJB2D,CJB2E
;
BILDT1		EQU	$
		BYTE	CJB09,CJB16,CJB0A
		BYTE	CJB11,CJB1C,CJB12,CJB1D,CJB10
		BYTE	CJB11,CJB1C,CJB12,CJB25,CJB15
		BYTE	CJB2F,CJB2C,CJB30,CJB31,CJB32
;
BILDT2		EQU	$
		BYTE	CJB09,CJB16,CJB0A
		BYTE	CJB11,CJB1C,CJB12
		BYTE	CJB11,CJB1C,CJB12,CJB17
		BYTE	CJB06,CJB07,CJB1F,CJB12,CJB20
		BYTE	CJB0D,CJB0E,CJB27,CJB12,CJB20
		BYTE	CJB33,CJB34,CJB35,CJB36,CJB37
;
BILDT3		EQU	$
		BYTE	CJB09,CJB16,CJB0A
		BYTE	CJB11,CJB1C,CJB12
		BYTE	CJB06,CJB07,CJB07,CJB1F,CJB12,CJB17
		BYTE	CJB0D,CJB0E,CJB0E,CJB27,CJB12,CJB20
		BYTE	CJB0D,CJB0E,CJB0E,CJB27,CJB12,CJB20
		BYTE	CJB33,CJB34,CJB34,CJB35,CJB36,CJB37
;
BILDT4		EQU	$
		BYTE	CJB09,CJB16,CJB16
		BYTE	CJB11,CJB1C,CJB1C
		BYTE	CJB11,CJB1C,CJB1C
		BYTE	CJB2A,CJB2B,CJB2C
		BYTE	CJB0F,CJB10
		BYTE	CJB1A,CJB15
		BYTE	CJB23,CJB15
		BYTE	CJB23,CJB15
		BYTE	CJB2D,CJB2E
;
BILDT5		EQU	$
		BYTE	CJB09,CJB16,CJB0A
		BYTE	CJB11,CJB1C,CJB12
		BYTE	CJB11,CJB1C,CJB12,CJB17
		BYTE	CJB06,CJB07,CJB07,CJB07,CJB1F,CJB12,CJB20
		BYTE	CJB0D,CJB0E,CJB0E,CJB0E,CJB27,CJB12,CJB20
		BYTE	CJB33,CJB34,CJB34,CJB34,CJB35,CJB36,CJB37
;
;---------------- ram buffer adress inc
BILAD0		EQU	$
		WORD	0010H,0010H,000FH,0010H,0010H
;
BILAD1		EQU	$
		WORD	0010H,0010H,0010H
;
BILAD2		EQU	$
		WORD	0010H,0010H,000FH,0010H,0010H
;
BILAD3		EQU	$
		WORD	0010H,000EH,0010H,0010H,0010H
;
BILAD4		EQU	$
		WORD	0010H,0010H,0010H,0163H,0010H,0010H,0010H,0010H
;
BILAD5		EQU	$
		WORD	0010H,0010H,000DH,0010H,0010H
;
;---------------- yo-ko unit count
BILCT0		EQU	$
		BYTE	03H,04H,04H,05H,05H,05H
;
BILCT1		EQU	$
		BYTE	03H,05H,05H,05H
;
BILCT2		EQU	$
		BYTE	03H,03H,04H,05H,05H,05H
;
BILCT3		EQU	$
		BYTE	03H,03H,06H,06H,06H,06H
;
BILCT4		EQU	$
		BYTE	03H,03H,03H,03H,02H,02H,02H,02H,02H
;
BILCT5		EQU	$
		BYTE	03H,03H,04H,07H,07H,07H
;
;
;
;-------------- < BG2 si-ro character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SIRST					x
;x			si-ro set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SIRST		EQU	$
;
		I8			; index 8bit mode
;
		LDX	#010H
		LDA	#SIR01
		STA	<WORK0
		JSR	SIRLP1
;
		LDX	#0A0H
		LDA	#SIR14
		STA	<WORK0
		JSR	SIRLP1
;
SIR050		EQU	$
		INX
		LDA	#SIR18
		JSR	BG2SET3
		INX
		TXA
		AND	#00FH
		BNE	SIR050
;
SIR060		EQU	$
		LDA	#SIR1C
		JSR	BG2SET3
		INX
		LDA	#SIR1D
		JSR	BG2SET3
		INX
		TXA
		AND	#00FH
		BNE	SIR060
;
		LDA	#SIR21
		STA	<WORK0
		JSR	SIRLP1
;
		LDA	#SIR22
		STA	<WORK0
		JSR	SIRLP1
;
		LDA	#SIR29
		STA	<WORK0
		JSR	SIRLP1
;
		LDA	#SIR2A		; ku-ro be-ta set
		STA	<WORK0		;
SIR070		EQU	$		;
		JSR	SIRLP2		;
		CPX	#0B0H		;
		BNE	SIR070		;
;
SIR100		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	SIR190
;
		JSR	DATFLG
;
		JSR	(SRUTST,X)
;
		BRA	SIR100
;
SIR190		EQU	$
		PLB
		RTL
;
;
SRUTST		EQU	$
		WORD	DEPARI		; ka-be de-pa-ri
		WORD	SRMADO		; ma-do
		WORD	SRLANP		; la-n-pu
		WORD	TSRHSR		; te-su-ri ha-si-ra
		WORD	NOMLHS		; hu-tu-u ha-si-ra
		WORD	KRIBHS		; ku-ri-bu-u ha-si-ra
;
;
;
SIRLP1		EQU	$		; 0 --> ffh
		LDA	<WORK0		;    ram buffer set
		JSR	BG2SET3		;	( 1 line set )
		INX			;
		TXA			;
		AND	#00FH		;
		BNE	SIRLP1		;
		RTS			;
;
SIRLP2		EQU	$		; 100 --> 1afh
		LDA	<WORK0		;      ram buffer set
		JSR	BG2SET1		;	( 1 line set )
		INX			;
		TXA			;
		AND	#00FH		;
		BNE	SIRLP2		;
		RTS
;
;
SIRYUK		EQU	$
		BYTE	SIR34,SIR35,SIR34,SIR36,SIR34,SIR36,SIR34,SIR35
		BYTE	SIR34,SIR36,SIR37,SIR34,SIR38,SIR35,SIR37,SIR37
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	DEPARI					x
;x			ka-be de-pa-ri			x
;x			si-ro set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
DEPARI		EQU	$
		I16			; index 16bit mode
DEPR00		EQU	$
		LDX	<WORK0
		LDA	>B2RMBF0,X
		CMP	#SIR14
		BEQ	DEPR10
		LDA	#SIR02
		JSR	BG2SET0
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#010H
		STA	<WORK0
		M8			; memory 8bit mode
		BRA	DEPR00
;
DEPR10		EQU	$
		LDA	#SIR17
		JSR	BG2SET0
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#010H
		TAX
		M8			; memory 8bit mode
		LDA	#SIR1B
		JSR	BG2SET0
		LDA	#SIR20
		JSR	BG2SET2
;
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SRMADO					x
;x			ma-do				x
;x			si-ro set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SRMADO		EQU	$
		I16			; index 16bit mode
		LDY	#0000H
SRMD00		EQU	$
		LDX	<WORK0
SRMD10		EQU	$
		LDA	SRMDDT,Y
		JSR	BG2SET0
		INY
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0010H
		TAX
		M8			; memory 8bit mode
		CPY	#000AH
		BEQ	SRMD90
		CPY	#0005H
		BNE	SRMD10
		INC	<WORK0
		BRA	SRMD00
;
SRMD90		EQU	$
		I8			; index 8bit mode
		RTS
;
SRMDDT		EQU	$
		BYTE	SIR03,SIR08,SIR0D,SIR10,SIR12
		BYTE	SIR04,SIR09,SIR0E,SIR11,SIR13
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SRLANP					x
;x			la-n-pu				x
;x			si-ro set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SRLANP		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	#SIR05
		JSR	SRLMP
;
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0010H
		STA	<WORK0
		TAX
		M8			; memory 8bit mode
		LDA	#SIR0A
		JSR	SRLMP
;
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0011H
		TAX
		M8			; memory 8bit mode
		LDA	#SIR0F
		JSR	BG2SET0
;
		I8			; index 8bit mode
		RTS
;
;
SRLMP		EQU	$
		JSR	BG2SET0
		INX
		INC	A
		JSR	BG2SET0
		INX
		INC	A
		JSR	BG2SET0
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	TSRHSR					x
;x			te-su-ri ha-si-ra		x
;x			si-ro set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
TSRHSR		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	#SIR15
		JSR	TSRLOP
;
		LDA	#SIR19
		JSR	TSRLOP
;
		LDA	#SIR1E
		JSR	TSRLOP
;
		I8			; index 8bit mode
		RTS
;
;
TSRLOP		EQU	$
		JSR	BG2SET0
		INX
		INC	A
		JSR	BG2SET0
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0010H
		STA	<WORK0
		TAX
		M8			; memory 8bit mode
		RTS
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	NOMLHS					x
;x			hu-tu-u ha-si-ra		x
;x			si-ro set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
NOMLHS		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDY	#0000H
NOMLST		EQU	$
		LDA	NOMLDT,Y
		JSR	BG2SET0
		INX
		INY
		CPY	#0005H
		BNE	NOMLST
		BRA	HSRST
;
;
;
NOMLDT		EQU	$
		BYTE	SIR23,SIR24,SIR28,SIR26,SIR27
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	KRIBHS					x
;x			ku-ri-bu-u ha-si-ra		x
;x			si-ro set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
KRIBHS		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	#SIR23
KRIBST		EQU	$
		JSR	BG2SET0
		INX
		INC	A
		CMP	#SIR28
		BNE	KRIBST
;
HSRST		EQU	$		; ha-si-ra set
		LDY	#0000H
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0011H
		TAX
		M8			; memory 8bit mode
HSRLOP		EQU	$
		LDA	HSRDT1,Y
		JSR	BG2SET0
		LDA	HSRDT2,Y
		JSR	BG2SET2
		INX
		INY
		CPY	#0003H
		BNE	HSRLOP
;
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0032H
		TAX
		M8			; memory 8bit mode
HSR00		EQU	$
		LDA	>B2RMBF0,X
		CMP	#SIR2A
		BNE	HSR10
		LDA	#SIR30
		JSR	BG2SET0
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0010H
		TAX
		M8			; memory 8bit mode
		BRA	HSR00
;
HSR10		EQU	$
		M16			; memory 16bit mode
		TXA
		SEC
		SBC	#0011H
		TAX
		M8			; memory 8bit mode
		LDA	#SIR31
		JSR	BG2SET0
		INC	A
		INX
		JSR	BG2SET0
		INC	A
		INX
		JSR	BG2SET0
;
		I8			; index 8bit mode
		RTS
;
;
HSRDT1		EQU	$
		BYTE	SIR2B,SIR28,SIR2C
HSRDT2		EQU	$
		BYTE	SIR2D,SIR2E,SIR2F
;
;
;-------------- < BG2 se-n-sha , se-n-ka-n demo character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SENST					x
;x		se-n-sha , se-n-ka-n demo set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SENST		EQU	$
		I8			; index 8bit mode
;
		LDA	!MAPCOS
		CMP	#007H
		BEQ	PPAASS
		LDA	#001H		; no pause set
		STA	!NOPAUSE
;
PPAASS		EQU	$
		LDX	#010H		; 110h line set
		LDA	#SEN01
		STA	<WORK0
		JSR	SIRLP2
;
		LDA	#SEN05		; 120h line set
		STA	<WORK0
		JSR	SIRLP2
;
		LDA	#SEN09		; 130h , 140h , 150h
		STA	<WORK0		;	line set
		JSR	SIRLP2
		JSR	SIRLP2
		JSR	SIRLP2
;
		LDA	#SEN11		; 160h line set
		STA	<WORK0
		JSR	SIRLP2
;
		LDA	#SEN19		; 170h line set
		STA	<WORK0
		JSR	SIRLP2
;
		LDA	#SEN22		; 180h line set
		STA	<WORK0		; sa-ku set
		JSR	SIRLP2
;
SENSET		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	SEN090
;
		JSR	DATFLG
;
		JSR	(SENDTST,X)
;
		BRA	SENSET
;
SEN090		EQU	$
		PLB
		RTL
;
;
SENDTST		EQU	$
		WORD	SENWOD1
		WORD	SENWOD2
		WORD	SENWOD3
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SENWOD1					x
;x		se-n-sha , se-n-ka-n demo be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SENWOD1		EQU	$
		LDX	<WORK0
		STX	<WORK1
;
		LDA	#003H
		STA	<ENMWK0
		LDA	#SEN02
		JSR	SNWD100
;
		LDA	#003H
		STA	<ENMWK0
		LDA	#SEN06
		JSR	SNWD100
;
		LDA	#003H
		STA	<ENMWK0
		LDA	#SEN0A
		JSR	SNWD100
;
		STZ	<ENMWK0
SNWD101		EQU	$
		LDA	#SEN0D
		JSR	BG2SET1
		INX
		LDA	#SEN0B
		JSR	BG2SET1
		INX
		LDA	#SEN0E
		JSR	BG2SET1
		LDA	<WORK0
		CLC
		ADC	#010H
		STA	<WORK0
		TAX
		LDA	<ENMWK0
		BNE	SNWD102
		INC	<ENMWK0
		BRA	SNWD101
;
SNWD102		EQU	$
		LDA	#003H
		STA	<ENMWK0
		LDA	#SEN12
		JSR	SNWD100
;
		RTS
;
SNWD100		EQU	$
		JSR	BG2SET1
		INC	A
		INX
		DEC	<ENMWK0
		BNE	SNWD100
		LDA	<WORK0
		CLC
		ADC	#010H
		STA	<WORK0
		TAX
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SENWOD2					x
;x		se-n-sha , se-n-ka-n demo be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SENWOD2		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	#SEN18
		JSR	BG2SET0
		LDA	#SEN21
		JSR	BG2SET2
		INX
		LDA	#SEN18
		JSR	BG2SET0
		LDA	#SEN21
		JSR	BG2SET2
;
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SENWOD3					x
;x		se-n-sha , se-n-ka-n demo be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SENWOD3		EQU	$
		I16			; index 16bit mode
		LDY	#0000H
SNWD301		EQU	$
		LDX	<WORK0
SNWD300		EQU	$
		LDA	SENWD3D,Y
		JSR	BG2SET0
		INY
		INX
		TXA
		AND	#00FH
		CMP	#009H
		BNE	SNWD300
;
		LDA	<WORK0
		CLC
		ADC	#010H
		STA	<WORK0
		CMP	#040H
		BNE	SNWD301
;
		I8			; index 8bit mode
		RTS
;
SENWD3D		EQU	$
		BYTE	SEN0F,SEN09,SEN09,SEN09,SEN0D,SEN0B,SEN0E,SEN09,SEN10
		BYTE	SEN15,SEN16,SEN16,SEN09,SEN0D,SEN0B,SEN0E,SEN09,SEN17
		BYTE	SEN1A,SEN1B,SEN1B,SEN1C,SEN1D,SEN1E,SEN1F,SEN1C,SEN20
;
;
;-------------- < BG2 ice character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ICEST					x
;x			ice be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ICEST		EQU	$
		I8			; index 8bit mode
		LDX	#0C0H
		LDA	#ICE30
		STA	<WORK0
		JSR	SIRLP1
;
		LDA	#ICE01
		STA	<WORK0
;
ICE010		EQU	$
		JSR	SIRLP1
		INC	<WORK0
		LDA	<WORK0
		AND	#003H
		BNE	ICE010
;
		JSR	SIRLP2
		JSR	SIRLP2
;
		LDX	#070H
		LDA	#ICE2F
		STA	<WORK0
		JSR	SIRLP2
;
ICESET		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	ICE090
;
		JSR	DATFLG
;
		JSR	(ICEDAT,X)
;
		BRA	ICESET
;
ICE090		EQU	$
		PLB
		RTL
;
ICEDAT		EQU	$
		WORD	ICEBIG	; ice big wood set
		WORD	ICEMID	; ice mid wood set
		WORD	ICESML	; ice small wood set
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ICEBIG					x
;x			ice big wood set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ICEBIG		EQU	$
		MI16			; memory , index 16bit mode
		LDA	#ICEBG
		STA	<WORK2
		LDA	#(ICEMD-ICEBG)/4
		STA	<WORK5
		BRA	ICEWDST
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ICEMID					x
;x			ice mid wood set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ICEMID		EQU	$
		MI16			; memory , index 16bit mode
		LDA	#ICEMD
		STA	<WORK2
		LDA	#(ICESL-ICEMD)/4
		STA	<WORK5
		BRA	ICEWDST
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ICESML					x
;x			ice small wood set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ICESML		EQU	$
		MI16			; memory , index 16bit mode
		LDA	#ICESL
		STA	<WORK2
		LDA	#(ICEEND-ICESL)/4
		STA	<WORK5
;
ICEWDST		EQU	$
		M8			; memory 8bit mode
ICELP10		EQU	$
		LDA	#004H
		STA	<WORK4
		LDX	<WORK0
ICELP00		EQU	$
		LDA	(<WORK2)
		JSR	BG2SET0
		INX
		M16			; memory16bit mode
		INC	<WORK2
		M8			; memory 8bit mode
		DEC	<WORK4
		BNE	ICELP00
		M16			; memory16bit mode
		LDA	<WORK0
		CLC
		ADC	#0010H
		STA	<WORK0
		M8			; memory 8bit mode
		DEC	<WORK5
		BNE	ICELP10
;
		I8			; index 8bit mode
		RTS
;
;------------ ICE WOOD DATA -----------
ICEBG		EQU	$
		BYTE	ICE04,ICE05,ICE06,ICE04,ICE07,ICE08,ICE09,ICE0A
		BYTE	ICE0B,ICE0C,ICE0D,ICE0E,ICE13,ICE14,ICE15,ICE16
		BYTE	ICE1B,ICE1C,ICE1D,ICE1E,ICE23,ICE24,ICE25,ICE26
		BYTE	ICE29,ICE2A,ICE2B,ICE2C
;
ICEMD		EQU	$
		BYTE	ICE0F,ICE12,ICE0F,ICE12,ICE17,ICE1A,ICE17,ICE1A
		BYTE	ICE1F,ICE22,ICE1F,ICE22,ICE23,ICE26,ICE23,ICE26
		BYTE	ICE29,ICE2C,ICE29,ICE2C
;
ICESL		EQU	$
		BYTE	ICE0F,ICE10,ICE11,ICE12,ICE17,ICE18,ICE19,ICE1A
		BYTE	ICE1F,ICE20,ICE21,ICE22,ICE23,ICE27,ICE28,ICE26
		BYTE	ICE29,ICE2D,ICE2E,ICE2C
ICEEND		EQU	$
;
;
;-------------- < BG2 ta-te character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	TATST					x
;x			ta-te be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
TATST		EQU	$
		I8			; index 8bit mode
TATLOP		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	TATEND
;
		JSR	DATFLG
;
		JSR	(TATSET,X)
;
		BRA	TATLOP
;
TATEND		EQU	$
		LDA	#000H
		XBA
		I16			; index 16bit mode
		LDY	#B2RMBF0+0100H
		LDX	#B2RMBF1
		LDA	#0AFH
		MVN	#BANK B2RMBF0,#BANK B2RMBF1
		I8			; index 8bit mode
;
		PLB
		RTL
;
;
TATSET		EQU	$
		WORD	TATSL0
		WORD	YOKSL0
		WORD	TATBG0
		WORD	YOKBG0
		WORD	SMLPS0
		WORD	BIGPS0
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	TATSL0					x
;x			ta-te be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
TATSL0		EQU	$
		MI16			; memory , index 16bit mode
		LDA	<ENMWK2
		ASL	A
		TAY
		LDA	TSDAT,Y
		STA	<WORK2
		M8			; memory 8bit mode
;
		JSR	TATESB
		RTS
;
;
TSDAT	EQU	$
	WORD	TSDAT0,TSDAT1,TSDAT2,TSDAT3,TSDAT4
;
TSDAT0	EQU	$
	BYTE	TAT02,TAT06,TAT1F,TAT02,TAT06,TAT06,TAT1F,TAT03
	BYTE	TAT03,TAT02,TAT03,TAT03,TAT10,TAT17,TAT03,TAT03
;
TSDAT1	EQU	$
	BYTE	TAT03,TAT06,TAT1F,TAT02,TAT06,TAT09,TAT1F,TAT03
	BYTE	TAT03,TAT02,TAT03,TAT03,TAT10,TAT17,TAT03,TAT03
;
TSDAT2	EQU	$
	BYTE	TAT02,TAT03,TAT10,TAT17,TAT1D,TAT1F,TAT10,TAT17
	BYTE	TAT02,TAT06,TAT1F,TAT02,TAT31,TAT1F,TAT10,TAT17
;
TSDAT3	EQU	$
	BYTE	TAT02,TAT09,TAT10,TAT17,TAT1E,TAT1F,TAT10,TAT17
	BYTE	TAT02,TAT1E,TAT1F,TAT02,TAT09,TAT1F,TAT10,TAT17
;
TSDAT4	EQU	$
	BYTE	TAT00,TAT00,TAT00,TAT00,TAT00,TAT06,TAT1F,TAT03
	BYTE	TAT03,TAT02,TAT03,TAT03,TAT10,TAT17,TAT03,TAT03
;
;
		IDX16
TATESB		EQU	$
		LDX	<WORK0
		LDY	#000H
TATE10		EQU	$		; unit set loop
		LDA	(<WORK2),Y
		JSR	BG2SET0
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0010H
		TAX
		M8			; memory 8bit mode
		INY
		CPY	#0010H
		BNE	TATE10
;
		LDA	<ENMWK0
		BEQ	TATE20
		DEC	<ENMWK0
		INC	<WORK0
		BRA	TATESB
;
TATE20		EQU	$
		I8			; index 8bit mode
		RTS
		IDX8
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	YOKSL0					x
;x			ta-te be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
YOKSL0		EQU	$
		MI16			; memory , index 16bit mode
		LDA	<ENMWK2
		ASL	A
		TAX
		LDA	YSDAT,X
		STA	<WORK2
		M8			; memory 8bit mode
		LDX	<WORK0
		JSR	YOK000
;
		RTS
;
YSDAT	EQU	$
	WORD	YSDAT0,YSDAT1,YSDAT2,YSDAT3,YSDAT4,YSDAT5
;
YSDAT0	EQU	$
	BYTE	TAT07,TAT08,TAT07,TAT08,TAT1A,TAT07,TAT08,TAT1A
;
YSDAT1	EQU	$
	BYTE	TAT1A,TAT08,TAT1A,TAT07,TAT00
;
YSDAT2	EQU	$
	BYTE	TAT1A,TAT1A,TAT08,TAT1A,TAT1A,TAT1B,TAT1C,TAT07
;
YSDAT3	EQU	$
	BYTE	TAT08,TAT1A,TAT08,TAT08,TAT1A,TAT2C,TAT08,TAT1A
;
YSDAT4	EQU	$
	BYTE	TAT1A,TAT08,TAT06,TAT1A,TAT00
;
YSDAT5	EQU	$
	BYTE	TAT07,TAT08,TAT06,TAT00
;
;
YOK000		EQU	$
		LDA	>B2RMBF0,X
		BNE	YOK010
		LDA	(<WORK2)
		JSR	BG2SET0
		M16			; memory 16bit mode
		INC	<WORK2
		M8			; memory 8bit mode
YOK010		EQU	$
		INX
		TXA
		AND	#00FH
		BNE	YOK000
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	TATBG0					x
;x			ta-te be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
TATBG0		EQU	$
		MI16			; memory , index 16bit mode
;
		LDA	<ENMWK2
		ASL	A
		TAX
		LDA	TBDAT,X
		STA	<WORK2
		M8			; memowy 8bit mode
		JSR	TATESB
;
		MI16			; memory , index 16bit mode
		TYA
		AND	#00FFH
		CLC
		ADC	<WORK2
		STA	<WORK2
		INC	<WORK0
		M8			; memory 8bit mode
		JSR	TATESB
;
		RTS
;
TBDAT	EQU	$
	WORD	TBDAT0,TBDAT1,TBDAT2,TBDAT3
;
TBDAT0	EQU	$
	BYTE	TAT04,TAT1B,TAT20,TAT33,TAT1B,TAT20,TAT35,TAT04
	BYTE	TAT20,TAT20,TAT35,TAT04,TAT2E,TAT30,TAT35,TAT04
	BYTE	TAT05,TAT1C,TAT21,TAT34,TAT1C,TAT21,TAT01,TAT05
	BYTE	TAT2D,TAT2F,TAT01,TAT05,TAT2D,TAT2F,TAT01,TAT05
;
TBDAT1	EQU	$
	BYTE	TAT04,TAT1B,TAT20,TAT33,TAT1B,TAT1B,TAT35,TAT04
	BYTE	TAT2E,TAT30,TAT20,TAT35,TAT22,TAT27,TAT04,TAT20
	BYTE	TAT05,TAT1C,TAT21,TAT34,TAT1C,TAT1C,TAT01,TAT05
	BYTE	TAT21,TAT21,TAT21,TAT01,TAT23,TAT28,TAT05,TAT21
;
TBDAT2	EQU	$
	BYTE	TAT35,TAT04,TAT0B,TAT12,TAT1B,TAT35,TAT22,TAT27
	BYTE	TAT04,TAT1B,TAT20,TAT20,TAT20,TAT35,TAT22,TAT27
	BYTE	TAT01,TAT05,TAT0C,TAT13,TAT1C,TAT01,TAT23,TAT28
	BYTE	TAT05,TAT1C,TAT21,TAT2D,TAT2F,TAT01,TAT23,TAT28
;
TBDAT3	EQU	$
	BYTE	TAT35,TAT04,TAT0B,TAT12,TAT1B,TAT35,TAT22,TAT27
	BYTE	TAT04,TAT1B,TAT20,TAT2E,TAT30,TAT35,TAT22,TAT27
	BYTE	TAT01,TAT05,TAT0C,TAT13,TAT1C,TAT01,TAT23,TAT28
	BYTE	TAT05,TAT1C,TAT21,TAT21,TAT21,TAT01,TAT23,TAT28
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	YOKBG0					x
;x			ta-te be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
YOKBG0		EQU	$
		MI16			; memory , index 16bit mode
		LDA	<ENMWK2
		ASL	A
		TAX
		LDA	YBDAT,X
		STA	<WORK2
		M8			; memory 8bit mode
		LDX	<WORK0
		JSR	YOK000
		MI16			; memory , index 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0010H
		TAX
		M8			; memory 8bit mode
		JSR	YOK000
;
		RTS
;
;
YBDAT	EQU	$
	WORD	YBDAT0,YBDAT1,YBDAT2,YBDAT3
;
YBDAT0	EQU	$
	BYTE	TAT0A,TAT0A,TAT0D,TAT0E,TAT0D,TAT0E,TAT0A
	BYTE	TAT11,TAT2A,TAT14,TAT15,TAT14,TAT15,TAT11
;
YBDAT1	EQU	$
	BYTE	TAT0A,TAT0D,TAT0E,TAT0F,TAT0F,TAT0A,TAT0A,TAT0F
	BYTE	TAT11,TAT14,TAT15,TAT16,TAT16,TAT18,TAT19,TAT16
;
YBDAT2	EQU	$
	BYTE	TAT0D,TAT0E,TAT0D,TAT0E,TAT0F,TAT24,TAT25,TAT0F
	BYTE	TAT26,TAT29,TAT26,TAT15,TAT16,TAT11,TAT2A,TAT16
;
YBDAT3	EQU	$
	BYTE	TAT0D,TAT0E,TAT0D,TAT0E,TAT0F,TAT10,TAT0A,TAT0F
	BYTE	TAT26,TAT29,TAT26,TAT15,TAT16,TAT17,TAT11,TAT16
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SMLPS0					x
;x			ta-te be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SMLPS0		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDY	<ENMWK2
		LDA	SLPSDAT,Y
		JSR	BG2SET0
;
		I8			; index8bit mode
		RTS
;
SLPSDAT		EQU	$
		BYTE	TAT02,TAT32,TAT03,TAT06,TAT1F,TAT20,TAT21
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	BIGPS0					x
;x			ta-te be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
BIGPS0		EQU	$
		MI16			; memory , index 16bit mode
		LDA	<ENMWK2
		ASL	A
		TAX
		LDA	BGPSDT,X
		STA	<WORK2
		M8			; memory 8bit mode
		LDY	#0002
		LDA	(<WORK2)
		LDX	<WORK0
		JSR	BG2SET0
		LDA	(<WORK2),Y
		JSR	BG2SET2
		M16			; memory16bit mode
		INC	<WORK2
		INC	<WORK0
		M8			; memory 8bit mode
		LDA	(<WORK2)
		LDX	<WORK0
		JSR	BG2SET0
		LDA	(<WORK2),Y
		JSR	BG2SET2
;
		I8			; index8bit mode
		RTS
;
BGPSDT		EQU	$
		WORD	BGPSDT0,BGPSDT1,BGPSDT2
;
BGPSDT0		EQU	$
		BYTE	TAT0D,TAT0E
		BYTE	TAT14,TAT15
;
BGPSDT1		EQU	$
		BYTE	TAT0A,TAT0D
		BYTE	TAT2A,TAT14
;
BGPSDT2		EQU	$
		BYTE	TAT0A,TAT0A
		BYTE	TAT11,TAT11
;
;
;-------------- < BG2 sa-ka character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SAKST					x
;x			sa-ka be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SAKST		EQU	$
		I8			; ondex 8bit mode
;
		LDA	!MAPCOS
		CMP	#001H
		BNE	PASS01
		LDA	#018H
		STA	!BG2CLRF
;
PASS01		EQU	$
		LDX	#0D0H
		LDA	#SAK46		; 0D0H line
		STA	<WORK0
		JSR	SIRLP1
;
		LDA	#SAK47		; 0E0H line
		STA	<WORK0
		JSR	SIRLP1
;
		LDA	#SAK01
		STA	<WORK0
		JSR	SIRLP1		; 0F0H line
		JSR	SIRLP2		; 100H line
		JSR	SIRLP2		; 110H line
		JSR	SIRLP2		; 120H line
;
SAK050		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	SAKEND
;
		JSR	DATFLG
;
		JSR	(SAKSET,X)
		BRA	SAK050
;
SAKEND		EQU	$
		PLB
		RTL
;
;
SAKSET		EQU	$
		WORD	SAKYM1,SAKYM2,SAKYM3,SAKYM4
		WORD	SAKYM5,SAKYM6,SAKYM7
		WORD	SAKYMK
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SAKYM1					x
;x			sa-ka be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SAKYM1		EQU	$
		I16				; index 16bit mode
		LDY	#(SKYMD1-SKYMD1)
		BRA	SAKYM
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SAKYM2					x
;x			sa-ka be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SAKYM2		EQU	$
		I16				; index 16bit mode
		LDY	#(SKYMD2-SKYMD1)
		BRA	SAKYM
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SAKYM3					x
;x			sa-ka be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SAKYM3		EQU	$
		I16				; index 16bit mode
		LDY	#(SKYMD3-SKYMD1)
		BRA	SAKYM
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SAKYM4					x
;x			sa-ka be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SAKYM4		EQU	$
		I16				; index 16bit mode
		LDY	#(SKYMD4-SKYMD1)
		BRA	SAKYM
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SAKYM5					x
;x			sa-ka be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SAKYM5		EQU	$
		I16				; index 16bit mode
		LDY	#(SKYMD5-SKYMD1)
		BRA	SAKYM
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SAKYM6					x
;x			sa-ka be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SAKYM6		EQU	$
		I16				; index 16bit mode
		LDY	#(SKYMD6-SKYMD1)
		BRA	SAKYM
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SAKYM7					x
;x			sa-ka be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SAKYM7		EQU	$
		I16				; index 16bit mode
		LDY	#(SKYMD7-SKYMD1)
;
SAKYM		EQU	$
		LDA	#001H
		STA	<WORK2
;
SAKYMST		EQU	$
		LDX	<WORK0
		LDA	#004H
		STA	<WORK4
SAKLOP		EQU	$
		LDA	SKYMD1,Y
		JSR	BG2SET0
		INX
		JSR	SAKINC
		INY
		DEC	<WORK4
		BNE	SAKLOP
		M16				; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0010H
		STA	<WORK0
		M8				; memory 8bit mode
		DEC	<WORK2
		BEQ	SAKYMST
;
		LDY	#00000H
SKYMST1		EQU	$
		LDA	#004H
		STA	<WORK4
		LDX	<WORK0
SAKLP1		EQU	$
		LDA	SKYMD8,Y
		JSR	BG2SET0
		INX
		JSR	SAKINC
		INY
		M16				; memory 16bit mode
		TYA
		AND	#00007H
		TAY
		M8				; memory 8bit mode
		DEC	<WORK4
		BNE	SAKLP1
		M16				; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0010H
		STA	<WORK0
		M8				; memory 8bit mode
		DEC	<ENMWK0
		BNE	SKYMST1
;
		I8				; index 8bit mode
		RTS
;
;
		IDX16
SAKINC		EQU	$
		M16				; memory 16bit mode
		TXA
		AND	#0000FH
		BNE	SAKPAS
		LDA	<ENMWK2
		BNE	SAKDEC
		TXA
		CLC
		ADC	#001A0H
		TAX
		BRA	SAKPAS
;
SAKDEC		EQU	$
		TXA
		SEC
		SBC	#001C0H
		TAX
SAKPAS		EQU	$
		M8				; memory 8bit mode
		RTS
		IDX8
;
;
SKYMD1		EQU	$
		BYTE	SAK40,SAK41,SAK42,SAK43
		BYTE	SAK44,SAK13,SAK14,SAK45
;
SKYMD2		EQU	$
		BYTE	SAK4C,SAK0B,SAK1E,SAK1F
		BYTE	SAK12,SAK13,SAK14,SAK29
;
SKYMD3		EQU	$
		BYTE	SAK2E,SAK2F,SAK0C,SAK4D
		BYTE	SAK36,SAK13,SAK14,SAK15
;
SKYMD4		EQU	$
		BYTE	SAK56,SAK33,SAK30,SAK55
		BYTE	SAK38,SAK13,SAK14,SAK37
;
SKYMD5		EQU	$
		BYTE	SAK2E,SAK2F,SAK1E,SAK1F
		BYTE	SAK36,SAK13,SAK14,SAK29
;
SKYMD6		EQU	$
		BYTE	SAK2E,SAK2F,SAK30,SAK55
		BYTE	SAK36,SAK13,SAK14,SAK37
;
SKYMD7		EQU	$
		BYTE	SAK4C,SAK0B,SAK0C,SAK4D
		BYTE	SAK12,SAK13,SAK14,SAK15
;
SKYMD8		EQU	$
		BYTE	SAK2C,SAK2D,SAK20,SAK21
		BYTE	SAK34,SAK35,SAK2A,SAK2B
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SAKYMK					x
;x			sa-ka be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SAKYMK		EQU	$
		I16				; index 16bit mode
		LDY	#00000H
;
SKYMK0		EQU	$
		LDX	<WORK0
		LDA	#004H
		STA	<WORK2
SKYMK3		EQU	$
		LDA	>B2RMBF0,X
		CMP	#SAK01
		BNE	SKYMK5
		LDA	SKYMDK,Y
		JSR	BG2SET0
SKYMK5		EQU	$
		INX
		INY
		CPY	#(SKYMDE-SKYMDK)
		BCS	SKYMK8
		DEC	<WORK2
		BNE	SKYMK3
		M16				; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#00010H
		STA	<WORK0
		M8				; memory 8bit mode
		BRA	SKYMK0
;
SKYMK8		EQU	$
		I8				; index 8bit mode
		RTS
;
SKYMDK		EQU	$
		BYTE	SAK48,SAK49,SAK4A,SAK4B
		BYTE	SAK4E,SAK4F,SAK50,SAK51
		BYTE	SAK52,SAK52,SAK53,SAK54
SKYMDE		EQU	$
;
;
;-------------- < BG2 chi-ka character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	CHIKA					x
;x			chi-ka be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
CHIKA		EQU	$
		I8		; index 8bit mode
;
		LDX	#000H
		LDA	#CHK02
		STA	<WORK0
		LDA	#CHK03
		STA	<WORK1
;
		STZ	<WORK2
		LDA	#CHK01
		STA	<WORK3
;
CHKA10		EQU	$
		LDA	<WORK0
		JSR	BG2SET3
		INX
		LDA	<WORK1
		JSR	BG2SET3
		INX
		TXA
		AND	#00FH
		BNE	CHKA10
;
CHKA20		EQU	$
		LDA	<WORK2
		JSR	BG2SET3
		INX
		LDA	<WORK3
		JSR	BG2SET3
		INX
		TXA
		AND	#00FH
		BNE	CHKA20
		TXA
		BNE	CHKA10
;
CHKA30		EQU	$
		LDA	<WORK0
		JSR	BG2SET1
		INX
		LDA	<WORK1
		JSR	BG2SET1
		INX
		TXA
		AND	#00FH
		BNE	CHKA30
		CPX	#0B0H
		BCS	CHKA50
;
CHKA40		EQU	$
		LDA	<WORK2
		JSR	BG2SET1
		INX
		LDA	<WORK3
		JSR	BG2SET1
		INX
		TXA
		AND	#00FH
		BNE	CHKA40
		BRA	CHKA30
;
CHKA50		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	CHKAEND
;
		JSR	DATFLG
;
		JSR	(CHKADAT,X)
		BRA	CHKA50
;
CHKAEND		EQU	$
		PLB
		RTL
;
;;K;;		LDA	!BG2COS
;;K;;		CMP	#015H
;;K;;		BNE	CHKA060
;;K;;		LDA	#CHK05
;;K;;		PHB
;;K;;		LDY	#BANK B2RMBF0
;;K;;		PHY
;;K;;		PLB
;;K;;		I16			; index 16bit mode
;;K;;		LDX	#0000H
CHKA065		EQU	$
;;K;;		STA	B2RMBF0,X
;;K;;		STA	B2RMBF1,X
;;K;;		STA	B2RMBF2,X
;;K;;		STA	B2RMBF3,X
;;K;;		INX
;;K;;		CPX	#01B0H
;;K;;		BNE	CHKA065
;;K;;		I8			; index 8bit mdoe
;;K;;		PLB
;
CHKA060		EQU	$
;;K;;		PLB
;;K;;		RTL
;
;
CHKADAT		EQU	$
		WORD	CHKSP3
		WORD	CHKSP2
		WORD	CHKSP1
		WORD	CHKSP4
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	CHKSP3					x
;x			chi-ka be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
CHKSP3		EQU	$
		JSR	CHKSP2
		I16			; index 16bit mode
;
		LDA	<ENMWK2
		BEQ	CKSP30
		STA	<ENMWK0
CKSP30		EQU	$
		JSR	INCSBR
;
		LDA	#CHK04
		JSR	BG2SET0
;
		I8			; index 8bit mode
		RTS
;
INCSBR		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	<ENMWK0
		STA	<WORK0
		TAX
		M8			; memory 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	CHKSP2					x
;x			chi-ka be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
CHKSP2		EQU	$
		JSR	CHKSP1
		I16			; index 16bit mode
		JSR	INCSBR
;
		LDA	#CHK04
		JSR	BG2SET0
;
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	CHKSP1					x
;x			chi-ka be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
CHKSP1		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	#CHK04
		JSR	BG2SET0
;
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	CHKSP4					x
;x			chi-ka be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
CHKSP4		EQU	$
		I16			; index 16bit mode
		JSR	CHKSP1
		JSR	INCSBR
;
		JSR	CHKSP1
		JSR	INCSBR
;
		JSR	CHKSP1
;
		LDA	<ENMWK2
		BEQ	CKSP40
		STA	<ENMWK0
CKSP40		EQU	$
		JSR	INCSBR
		LDA	#CHK04
		JSR	BG2SET0
;
		I8			; index 8bit mode
		RTS
;
;
;-------------- < BG2 so-u-ge-n character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SOGEN					x
;x			so-u-ge-n be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SOGEN		EQU	$
		I8			; index 8bit mode
;
		LDX	#040H		; 140H
		LDA	#SGN3C
		STA	<WORK0
		LDA	#SGN40
		STA	<WORK1
		LDA	#008H
		STA	<WORK4
		JSR	BILLP20
;
		LDA	#SGN41		; 150H
		STA	<WORK0
		LDA	#SGN42
		STA	<WORK1
		LDA	#008H
		STA	<WORK4
		JSR	BILLP20
;
		LDA	#SGN43		; 160H
		STA	<WORK0
		JSR	SIRLP2
;
		INC	<WORK0		; 170H , 180H
		JSR	SIRLP2
		JSR	SIRLP2
;
SOGSET		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	SOGEND
;
		JSR	DATFLG
;
		JSR	(SOGDT,X)
		BRA	SOGSET
;
SOGEND		EQU	$
		LDA	!BGNOBK
		CMP	#00BH
		BEQ	SOG050
		CMP	#02FH
		BNE	SOGEND0
SOG050		EQU	$
		LDA	#000H
		XBA
		I16				; index 16bit mode
		LDY	#B2RMBF0+0C0H
		LDX	#B2RMBF0+0D0H
		LDA	#0AFH
		MVN	#BANK B2RMBF0,#BANK B2RMBF0
;
		LDA	#000H
		XBA
		LDY	#B2RMBF1+0C0H
		LDX	#B2RMBF1+0D0H
		LDA	#0AFH
		MVN	#BANK B2RMBF1,#BANK B2RMBF1
;
		LDA	#000H
		XBA
		LDY	#B2RMBF2+0C0H
		LDX	#B2RMBF2+0D0H
		LDA	#0AFH
		MVN	#BANK B2RMBF2,#BANK B2RMBF2
;
		LDA	#000H
		XBA
		LDY	#B2RMBF3+0C0H
		LDX	#B2RMBF3+0D0H
		LDA	#0AFH
		MVN	#BANK B2RMBF3,#BANK B2RMBF3
;
		LDA	#000H
		XBA
		LDY	#B2RMBF4+0C0H
		LDX	#B2RMBF4+0D0H
		LDA	#0AFH
		MVN	#BANK B2RMBF4,#BANK B2RMBF4
		I8				; index 8bit mode
;
SOGEND0		EQU	$
		PLB
		RTL
;
;
SOGDT		EQU	$
		WORD	SGNY1,SGNY2,SGNY3,SGNY4
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SGNY1					x
;x			so-u-ge-n be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SGNY1		EQU	$
		LDY	#000H
		BRA	SGNYMT
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SGNY2					x
;x			so-u-ge-n be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SGNY2		EQU	$
		LDY	#002H
		BRA	SGNYMT
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SGNY3					x
;x			so-u-ge-n be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SGNY3		EQU	$
		LDY	#004H
		BRA	SGNYMT
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SGNY4					x
;x			so-u-ge-n be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SGNY4		EQU	$
		LDY	#006H
;
SGNYMT		EQU	$
		LDA	#BANK SGNYMD
		STA	<WORK8
		STA	<WORKB
		STA	<WORKE
		MI16			; memory , index 16bit mode
		LDA	SGNYMD,Y
		STA	<WORK6
		LDA	SGNADR,Y
		STA	<WORK9
		LDA	SGNCNT,Y
		STA	<WORKC
		STZ	<WORK4
		M8			; memory 8bit mode
		LDA	SGNYMG,Y
		STA	<WORKF
		LDX	<WORK0
		LDY	#0000H
		LDA	[<WORKC]
		STA	<WORK2
;
		JSR	NZIWLP
		I8			; index 8bit mode
		RTS
;
;
SGNYMG	EQU	$
	WORD	0007H,0006H,0004H,0005H
;
SGNYMD	EQU	$
	WORD	SGNYM1,SGNYM2,SGNYM3,SGNYM4
;
SGNADR	EQU	$
	WORD	SGNAD1,SGNAD2,SGNAD3,SGNAD4
;
SGNCNT	EQU	$
	WORD	SGNCT1,SGNCT2,SGNCT3,SGNCT4
;
;---------------- unit ba-ta data
SGNYM1	EQU	$
	BYTE	SGN45,SGN01,SGN02
	BYTE	SGN03,SGN04,SGN05,SGN06,SGN07
	BYTE	SGN03,SGN0A,SGN0B,SGN0C,SGN0D,SGN0E,SGN0F
	BYTE	SGN03,SGN0A,SGN16,SGN17,SGN18,SGN16,SGN19,SGN1A,SGN1B
	BYTE	SGN03,SGN0A,SGN20,SGN21,SGN16,SGN16,SGN16,SGN22,SGN23,SGN24,SGN1B
	BYTE	SGN03,SGN29,SGN2A,SGN16,SGN16,SGN16,SGN16,SGN2B,SGN2C,SGN2D,SGN2E,SGN2F,SGN1B
	BYTE	SGN35,SGN36,SGN35,SGN36,SGN35,SGN36,SGN35,SGN36,SGN35,SGN36,SGN37,SGN38,SGN37
;
SGNYM2	EQU	$
	BYTE	SGN08,SGN09
	BYTE	SGN10,SGN11,SGN12
	BYTE	SGN1C,SGN1D,SGN12
	BYTE	SGN25,SGN26,SGN12
	BYTE	SGN30,SGN26,SGN12
	BYTE	SGN39,SGN3A,SGN3B
;
SGNYM3	EQU	$
	BYTE	SGN45,SGN01,SGN02
	BYTE	SGN03,SGN04,SGN05,SGN06,SGN0F
	BYTE	SGN03,SGN31,SGN0B,SGN0C,SGN32,SGN33,SGN1B
	BYTE	SGN36,SGN35,SGN36,SGN35,SGN36,SGN37,SGN38
;
SGNYM4	EQU	$
	BYTE	SGN13,SGN14,SGN15
	BYTE	SGN1E,SGN10,SGN1C,SGN1F,SGN12
	BYTE	SGN10,SGN1C,SGN1C,SGN27,SGN28,SGN12
	BYTE	SGN1C,SGN1C,SGN1C,SGN34,SGN26,SGN12
	BYTE	SGN3D,SGN3E,SGN3D,SGN3E,SGN3A,SGN3B,SGN3F
;
;---------------- ram buffer adress inc
SGNAD1	EQU	$
	WORD	000FH,000FH,000FH,000FH,000FH,0010H
;
SGNAD2	EQU	$
	WORD	0010H,0011H,0011H,0011H,0010H
;
SGNAD3	EQU	$
	WORD	000FH,000FH,0010H
;
SGNAD4	EQU	$
	WORD	000FH,0010H,0011H,0010H
;
;---------------- yo-ko unit count
SGNCT1	EQU	$
	BYTE	03H,05H,07H,09H,0BH,0DH,0DH
;
SGNCT2	EQU	$
	BYTE	02H,03H,03H,03H,03H,03H
;
SGNCT3	EQU	$
	BYTE	03H,05H,07H,07H
;
SGNCT4	EQU	$
	BYTE	03H,05H,06H,06H,07H
;
;
;-------------- < BG2 sa-ba-ku 1 character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SABK1					x
;x			sa-ba-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SABK1		EQU	$
		I8			; index 8bit mode
;
		JSR	SBKBTST
		LDX	#040H
		LDA	#SBK05
		STA	<WORK0
SABK100		EQU	$
		LDA	<WORK0
		JSR	BG2SET1
SABK110		EQU	$
		INC	A
		INX
		JSR	BG2SET1
		CMP	#00CH
		BNE	SABK110
		INX
		TXA
		AND	#00FH
		BNE	SABK100
;
		I16			; index 16bit mode
		LDX	#0146H
		LDA	#SBK07
		STA	<WORK0
		JSR	BG2SET0
		INC	A
		INX
		JSR	BG2SET0
		INC	A
		INX
		JSR	BG2SET0
		INC	A
		INX
		JSR	BG2SET0
		I8			; index 8bit mode
;
SABK1ST		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	SABK1ED
;
		JSR	DATFLG
;
		JSR	(SBK1DST,X)
		BRA	SABK1ST
;
SABK1ED		EQU	$
		PLB
		RTL
;
;
SBK1DST		EQU	$
		WORD	SBK1KM
		WORD	SBK2KM
;
;
SBKBTST		EQU	$
		LDX	#0B0H
		LDA	#SBK41		; 0B0H line set
		STA	<WORK0
		JSR	SIRLP1
;
		LDA	#SBK01		; 0C0H line set
		STA	<WORK0
		JSR	SIRLP1
;
		INC	<WORK0		; 0D0H line set
		JSR	SIRLP1
;
		INC	<WORK0		; 0E0H line set
		JSR	SIRLP1
;
		INC	<WORK0		; 0F0H line set
		JSR	SIRLP1
;
SBK010		EQU	$
		JSR	SIRLP2		; 0100h -->0140h set
		CPX	#050H
		BNE	SBK010
;
		LDX	#050H
		LDA	#SBK0D		; 0150h line set
		STA	<WORK0
		LDA	#SBK0E
		STA	<WORK1
		LDA	#SBK0F
		STA	<WORK2
		LDA	#SBK10
		STA	<WORK3
		LDA	#0004
		STA	<WORK4
		JSR	BILLP60
;
		LDA	#SBK11		; 0160h line set
		STA	<WORK0
		LDA	#SBK12
		STA	<WORK1
		LDA	#008H
		STA	<WORK4
		JSR	BILLP20
;
		LDA	#SBK14		; 0170H line set
		STA	<WORK0
		JSR	SIRLP2
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBK1KM					x
;x			sa-ba-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBK1KM		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	#SBK3B
		JSR	BG2SET0
		LDA	#SBK3E
		JSR	BG2SET2
;
SBK1KM0		EQU	$
		DEC	<ENMWK0
		BEQ	SBK1KM1
		INX
		LDA	#SBK3C
		JSR	BG2SET0
		LDA	#SBK3F
		JSR	BG2SET2
		BRA	SBK1KM0
;
SBK1KM1		EQU	$
		INX
		LDA	#SBK3D
		JSR	BG2SET0
		LDA	#SBK40
		JSR	BG2SET2
;
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBK2KM					x
;x			sa-ba-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBK2KM		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	#SBK35
		JSR	BG2SET0
		LDA	#SBK38
		JSR	BG2SET2
;
SBK2KM0		EQU	$
		DEC	<ENMWK0
		BEQ	SBK2KM2
		INX
		TXA
		AND	#00FH
		BNE	SBK2KM1
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#01A0H
		TAX
		M8			; memoru 8bit mode
SBK2KM1		EQU	$
		LDA	#SBK36
		JSR	BG2SET0
		LDA	#SBK39
		JSR	BG2SET2
		BRA	SBK2KM0
;
SBK2KM2		EQU	$
		INX
		LDA	#SBK37
		JSR	BG2SET0
		LDA	#SBK3A
		JSR	BG2SET2
;
		I8			; index 8bit mode
		RTS
;
;
;-------------- < BG2 sa-ba-ku 2 character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SABK2					x
;x			sa-ba-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SABK2		EQU	$
		I8			; index 8bit mode
		JSR	SBKBTST
;
		LDX	#050H		; 0150H line set
		LDA	#SBK0F
		STA	<WORK0
		LDA	#SBK10
		STA	<WORK1
		LDA	#SBK0D
		STA	<WORK2
		LDA	#SBK0E
		STA	<WORK3
		LDA	#0004H
		STA	<WORK4
		JSR	BILLP60
;
SABK2ST		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	SABK2ED
;
		JSR	DATFLG
;
		JSR	(SBK2DST,X)
		BRA	SABK2ST
;
SABK2ED		EQU	$
		LDA	!BG2COS
		CMP	#019H
		BNE	SABK200
		LDA	#000H
		XBA
		INC	!B2SPFG
		I16			; index 16bit mode
		LDY	#B2RMBF0
		LDX	#B2RMBF0+0B0H
		LDA	#0CFH
		MVN	#BANK B2RMBF0,#BANK B2RMBF0
		LDA	#000H
		XBA
		LDY	#B2RMBF1
		LDX	#B2RMBF1+0B0H
		LDA	#0CFH
		MVN	#BANK B2RMBF1,#BANK B2RMBF1
		I8			; index 8bit mode
;
		LDA	#SBK42
		STA	<WORK0
		LDA	#SBK43
		STA	<WORK1
		M16			; memory 16bit mode
		PHB
		LDY	#BANK B2RMBF0
		PHY
		PLB
		LDY	#000H
		LDX	#000H
SABK205		EQU	$
		LDA	<WORK0
		STA	!B2RMBF0+0D0H,X
		STA	!B2RMBF0+0F0H,X
		STA	!B2RMBF0+110H,X
		STA	!B2RMBF0+130H,X
		STA	!B2RMBF0+150H,X
		STA	!B2RMBF0+170H,X
		STA	!B2RMBF0+190H,X
		STA	!B2RMBF1+0D0H,X
		STA	!B2RMBF1+0F0H,X
		STA	!B2RMBF1+110H,X
		STA	!B2RMBF1+130H,X
		STA	!B2RMBF1+150H,X
		STA	!B2RMBF1+170H,X
		STA	!B2RMBF1+190H,X
		INX
		INX
		TXA
		AND	#00FH
		BNE	SABK205
;
		TYA
		BNE	SABK208
		INY
		LDA	<WORK0
		XBA
		STA	<WORK0
		BRA	SABK205
;
SABK208		EQU	$
		PLB
		M8			; memory 8bit mode
;
SABK200		EQU	$
		PLB
		RTL
;
;
SBK2DST		EQU	$
		WORD	SBK1KM,SBK2KM,SBKPRMD,SBKYAMA,SBKPMD1,SBKPMD2
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBKPRMD					x
;x			sa-ba-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBKPRMD		EQU	$
		I16			; index 16bit mode
		STZ	<WORK2
;
PRMD00		EQU	$
		LDX	<WORK0
		LDA	>B2RMBF0,X
		CMP	#SBK04
		BNE	PRMD50
		LDA	<WORK2
		STA	<WORK3
		LDA	#SBK16		; left set
		JSR	BG2SET0
;
		LDA	<WORK3
		BEQ	PRMD20
		INX
		LDA	#SBK18
		JSR	BG2SET0
PRMD10		EQU	$
		DEC	<WORK3
		BEQ	PRMD20
		INX
		LDA	#SBK1A
		JSR	BG2SET0
		BRA	PRMD10
;
PRMD20		EQU	$
		LDA	<WORK2
		STA	<WORK3
PRMD25		EQU	$
		LDA	<WORK3
		BEQ	PRMD30
		DEC	<WORK3
		BEQ	PRMD28
		INX
		LDA	#SBK1B
		JSR	BG2SET0
		BRA	PRMD25
;
PRMD28		EQU	$
		INX
		LDA	#SBK19
		JSR	BG2SET0
;
PRMD30		EQU	$
		INX
		LDA	#SBK17		; right set
		JSR	BG2SET0
		INC	<WORK2
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#000FH
		STA	<WORK0
		M8			; memory 8bit mode
		BRA	PRMD00
;
PRMD50		EQU	$
		INX
PRMD53		EQU	$
		LDA	#SBK2D
		STA	<WORK2
PRMD55		EQU	$
		LDA	>B2RMBF0-10H,X
		CMP	#SBK1B
		BEQ	PRMD60
		LDA	<WORK2
		JSR	BG2SET0
		INX
		INC	<WORK2
		LDA	<WORK2
		CMP	#SBK31
		BEQ	PRMD53
		BRA	PRMD55
;
PRMD60		EQU	$
		LDA	<WORK2
		CLC
		ADC	#0006H
		CMP	#035H
		BNE	PRMD63
		LDA	#SBK31
PRMD63		EQU	$
		STA	<WORK2
PRMD65		EQU	$
		LDA	>B2RMBF0-10H,X
		CMP	#SBK04
		BEQ	PRMD90
		LDA	<WORK2
		JSR	BG2SET0
		INX
		INC	<WORK2
		LDA	<WORK2
		CMP	#SBK35
		BNE	PRMD65
		LDA	#SBK31
		STA	<WORK2
		BRA	PRMD65
;
PRMD90		EQU	$
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBKYAMA					x
;x			sa-ba-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBKYAMA		EQU	$
		I16			; index 16bit mode
;
		M16			; memory 16bit mode
		LDA	<ENMWK2
		ASL	A
		TAY
		LDA	SBKYD,Y
		STA	<WORK2
		M8			; memory 8bit mode
;
		LDX	<WORK0
SBKYM00		EQU	$
		LDA	(<WORK2)
		BMI	SBKYM90
		JSR	BG2SET0
		M16			; memory 16bit mode
		INC	<WORK2
		M8			; memory 8bit mode
		INX
		TXA
		AND	#00FH
		BNE	SBKYM00
		LDA	<ENMWK2
		BNE	SBKYM20
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#01A0H
		TAX
		M8			; memory 8bit mode
		BRA	SBKYM00
;
SBKYM20		EQU	$
		M16			; memory 16bit mode
		TXA
		SEC
		SBC	#01C0H
		TAX
		M8			; memory 8bit mode
		BRA	SBKYM00
;
SBKYM90		EQU	$
		I8			; index 8bit mode
		RTS
;
SBKYD	EQU	$
	WORD	SBKYD0,SBKYD1
;
SBKYD0	EQU	$
	BYTE	SBK26,SBK27,SBK2B,SBK2C,SBK09,SBK0A,SBK0B,SBK0C,0FFH
;
SBKYD1	EQU	$
	BYTE	SBK26,SBK27,SBK28,SBK29,0FFH
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBKPMD1					x
;x			sa-ba-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBKPMD1		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	#SBK1C
		JSR	BG2SET0
;
SBKPD13		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#000FH
		STA	<WORK0
		TAX
		M8			; memory 8bit mode
		LDA	>B2RMBF0,X
		CMP	#SBK19
		BEQ	SBKPD10
		LDA	#SBK1D
		JSR	BG2SET0
;
SBKPD12		EQU	$
		INX
		TXA
		AND	#00FH
		BNE	SBKPD15
		M16			; memory 16bit mode
		TXA
		SEC
		SBC	#01C0H
		TAX
		M8			; memory 8bit mode
SBKPD15		EQU	$
		LDA	>B2RMBF0-10H,X
		CMP	#SBK04
		BEQ	SBKPD11
		LDA	#SBK1E
		JSR	BG2SET0
		BRA	SBKPD12
;
SBKPD11		EQU	$
		LDA	>B2RMBF0,X
		CMP	#SBK04
		BNE	SBKPD13
		LDA	#SBK1F
		JSR	BG2SET0
		BRA	SBKPD13
;
SBKPD10		EQU	$
		INX
		LDA	#SBK25
		JSR	BG2SET0
;
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBKPMD2					x
;x			sa-ba-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBKPMD2		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	#SBK20
		JSR	BG2SET0
;
		INX
		LDA	#SBK21
		JSR	BG2SET0
;
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#000FH
		STA	<WORK0
		TAX
		M8			; memory 8bit mode
		LDA	#SBK22
		JSR	BG2SET0
;
		INX
		LDA	#SBK23
		JSR	BG2SET0
;
		INX
		LDA	#SBK24
		JSR	BG2SET0
;
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0011H
		TAX
		M8			; memory 8bit mode
		LDA	#SBK2A
		JSR	BG2SET0
;
		I8			; index 8bit mode
		RTS
;
;
;-------------- < BG2 a-su-re-ti-ku character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ASRTC					x
;x			a-su-re-ti-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ASRTC		EQU	$
		I8			; index 8bit mode
		LDA	!MAPCOS
		CMP	#005H
		BNE	ASRTC05
		LDA	#012H
		STA	!BG2CLRF
ASRTC05		EQU	$
		LDX	#040H
		LDA	#ASC28
		STA	<WORK0
ASRTC10		EQU	$
		JSR	SIRLP2
		CPX	#080H
		BNE	ASRTC10
;
ASRTC20		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	ASRTC90
;
		JSR	DATFLG
		JSR	(ASRTCST,X)
		BRA	ASRTC20
;
ASRTC90		EQU	$
		PLB
		RTL
;
;
ASRTCST		EQU	$
		WORD	ASRTCY1
		WORD	ASRTCY2
		WORD	ASRTCY3
		WORD	ASRTCY4
		WORD	ASRTCY5
		WORD	ASRTCY6
		WORD	ASRTCY7
		WORD	ASRTCY8
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ASRTCY1					x
;x			a-su-re-ti-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ASRTCY1		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	>B2RMBF0,X
		BNE	ASCY100
		LDA	#ASC05
		BRA	ASCY105
ASCY100		EQU	$
		LDA	#ASC0C
ASCY105		EQU	$
		JSR	BG2SET0
;
		INX
		TXA
		AND	#00FH
		BNE	ASCY108
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#01A0H
		TAX
		M8			; memory 8bit mode
ASCY108		EQU	$
		LDA	>B2RMBF0,X
		BNE	ASCY110
		LDA	#ASC2E
		BRA	ASCY115
ASCY110		EQU	$
		LDA	#ASC0B
ASCY115		EQU	$
		JSR	BG2SET0
;
ASCY120		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0010H
		STA	<WORK0
		TAX
		M8			; memory 8bit mode
		DEC	<ENMWK0
		BEQ	ASCY130
		LDA	#ASC19
		JSR	BG2SET0
		INX
		TXA
		AND	#00FH
		BNE	ASCY125
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#01A0H
		TAX
		M8			; memory 8bit mode
ASCY125		EQU	$
		LDA	#ASC06
		JSR	BG2SET0
		BRA	ASCY120
;
ASCY130		EQU	$
		LDA	<ENMWK2
		BEQ	ASCY140
		LDA	#ASC1E
		JSR	BG2SET0
		INX
		LDA	#ASC1F
		JSR	BG2SET0
		BRA	ASCY150
;
ASCY140		EQU	$
		LDA	#ASC26
		JSR	BG2SET0
		INX
		LDA	#ASC27
		JSR	BG2SET0
;
ASCY150		EQU	$
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ASRTCY2					x
;x			a-su-re-ti-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ASRTCY2		EQU	$
		I16			; index 16bit mode
		LDA	<ENMWK0
		STA	<ENMWK2
;
		LDX	<WORK0		; ta-te 1 line set (Left)
		LDY	#ASC01
		LDA	#ASC19
		STA	<WORK2
		JSR	ASCY200
		JSR	BG2SET0
		DEC	<ENMWK2
;
		JSR	XINC10
		LDY	#ASC07
		JSR	ASCY210
		JSR	BG2SET0
		DEC	<ENMWK2
;
		LDA	#ASC13
		STA	<WORK2
		JSR	ASCY250
;
		JSR	XINC10
		LDA	#ASC22
		JSR	BG2SET0
;
		LDA	<ENMWK0
		STA	<ENMWK2
		M16			; memory 16bit mode
		INC	<WORK0
		M8			; memory 8bit mode
		LDA	<WORK0
		AND	#00FH
		BNE	ASCY260
		M16			; memory 16bit mode
		LDA	<WORK0
		SEC
		SBC	#01C0H
		STA	<WORK0
		TAX
		M8			; memory 8bit mode
		LDA	#ASC0E
		BRA	ASCY265
ASCY260		EQU	$
		LDX	<WORK0
		LDA	#ASC06		; ta-te 1 line set (Center Left)
		STA	<WORK2
		LDY	#ASC02
		JSR	ASCY200
ASCY265		EQU	$
		JSR	BG2SET0
		DEC	<ENMWK2
;
		JSR	XINC10
		LDA	#ASC08
		JSR	BG2SET0
		DEC	<ENMWK2
;
		LDA	#ASC14
		STA	<WORK2
		JSR	ASCY250
;
		JSR	XINC10
		LDA	#ASC23
		JSR	BG2SET0
;
		M16			; memory 16bit mode
		INC	<WORK0
		M8			; memory 8bit mode
		LDX	<WORK0
		LDA	<ENMWK0
		STA	<ENMWK2
		LDA	#ASC13		; ta-te 1 line set (Center Right)
		STA	<WORK2
		LDY	#ASC03
		JSR	ASCY200
		JSR	BG2SET0
		DEC	<ENMWK2
;
		JSR	XINC10
		LDA	#ASC09
		JSR	BG2SET0
		DEC	<ENMWK2
;
		LDA	#ASC11
		STA	<WORK2
		JSR	ASCY250
;
		JSR	XINC10
		LDA	#ASC24
		JSR	BG2SET0
;
		M16			; memory 16bit mode
		INC	<WORK0
		M8			; memory 8bit mode
		LDX	<WORK0
		LDA	<ENMWK0
		STA	<ENMWK2
		LDA	#ASC14		; ta-te 1 line set (Right)
		STA	<WORK2
		LDY	#ASC04
		JSR	ASCY200
		JSR	BG2SET0
		DEC	<ENMWK2
;
		JSR	XINC10
		LDA	#ASC06
		STA	<WORK2
		LDY	#ASC0A
		JSR	ASCY210
		LDA	>B2RMBF0,X
		CMP	#ASC14
		BNE	ASCY270
		LDY	#ASC1B
ASCY270		EQU	$
		TYA
		JSR	BG2SET0
		DEC	<ENMWK2
;
		LDA	#ASC12
		STA	<WORK2
		JSR	ASCY250
;
		JSR	XINC10
		LDA	#ASC25
		JSR	BG2SET0
		INX
		LDA	>B2RMBF0,X
		CMP	#ASC2A
		BNE	ASCY290
		LDA	#ASC2C
		JSR	BG2SET0
;
ASCY290		EQU	$
		I8			; index 8bit mode
		RTS
;
;
ASCY250		EQU	$
		JSR	XINC10
		LDA	<WORK2
		JSR	BG2SET0
		DEC	<ENMWK2
		BNE	ASCY250
		RTS
;
;
XINC10		EQU	$
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0010H
		TAX
		M8			; memory 8bit mode
		RTS
;
;
ASCY200		EQU	$
		LDA	>B2RMBF0,X
		BEQ	ASCY208
		CMP	<WORK2
		BEQ	ASCY205
		TYA
		CLC
		ADC	#008H
		TAY
ASCY205		EQU	$
		TYA
		CLC
		ADC	#00CH
		TAY
ASCY208		EQU	$
		TYA
		RTS
;
;
ASCY210		EQU	$
		LDA	>B2RMBF0,X
		BEQ	ASCY218
		CMP	<WORK2
		BEQ	ASCY215
		TYA
		CLC
		ADC	#002H
		TAY
ASCY215		EQU	$
		TYA
		CLC
		ADC	#013H
		TAY
ASCY218		EQU	$
		TYA
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ASRTCY3					x
;x			a-su-re-ti-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ASRTCY3		EQU	$
		I16			; index 16bit mode
;
		LDX	<WORK0
		LDA	>B2RMBF0-01H,X
		CMP	#ASC25
		BEQ	ASCY300
		LDA	#ASC2A
		BRA	ASCY310
ASCY300		EQU	$
		LDA	#ASC2C
ASCY310		EQU	$
		JSR	BG2SET0
;
		INX
		LDA	#ASC2A
		JSR	BG2SET0
;
		INX
		LDA	>B2RMBF0+01H,X
		CMP	#ASC22
		BEQ	ASCY320
		LDA	#ASC2A
		BRA	ASCY330
ASCY320		EQU	$
		LDA	#ASC2B
ASCY330		EQU	$
		JSR	BG2SET0
;
ASCY350		EQU	$
		I8			; index 8bit mode
		RTS
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ASRTCY4					x
;x			a-su-re-ti-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ASRTCY4		EQU	$
		I16			; index 16bit mode
;
		LDX	<WORK0
		LDA	>B2RMBF0,X
		CMP	#ASC27
		BEQ	ASCY405
		CMP	#ASC28
		BNE	ASCY415
		LDA	#ASC21
		BRA	ASCY410
ASCY405		EQU	$
		LDA	#ASC29
ASCY410		EQU	$
		JSR	BG2SET0
ASCY415		EQU	$
		INX
		TXA
		AND	#00FH
		BNE	ASCY418
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#01A0H
		TAX
		M8			; memory 8bit mode
ASCY418		EQU	$
		LDA	<ENMWK0
		BEQ	ASCY450
		DEC	<ENMWK0
;
ASCY420		EQU	$
		LDA	>B2RMBF0,X
		CMP	#ASC28
		BNE	ASCY425
		LDA	#ASC2D
		JSR	BG2SET0
ASCY425		EQU	$
		INX
		DEC	<ENMWK0
		BNE	ASCY420
;
ASCY450		EQU	$
		LDA	>B2RMBF0,X
		CMP	#ASC28
		BNE	ASCY490
		LDA	#ASC20
		JSR	BG2SET0
;
ASCY490		EQU	$
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ASRTCY5					x
;x			a-su-re-ti-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ASRTCY5		EQU	$
		LDA	#ASC2F
		STA	<WORK2
		BRA	ASRTCY
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ASRTCY6					x
;x			a-su-re-ti-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ASRTCY6		EQU	$
		LDA	#ASC30
		STA	<WORK2
		BRA	ASRTCY
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ASRTCY7					x
;x			a-su-re-ti-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ASRTCY7		EQU	$
		LDA	#ASC31
		STA	<WORK2
		BRA	ASRTCY
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	ASRTCY8					x
;x			a-su-re-ti-ku be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
ASRTCY8		EQU	$
		LDA	#ASC32
		STA	<WORK2
;
ASRTCY		EQU	$
		I16			; index 16bit mode
;
		LDX	<WORK0
		LDA	<WORK2
		JSR	BG2SET0
;
		I8			; index 8bit mode
		RTS
;
;
;-------------- < BG2 sa-ba-ku to-ri-de character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBTRD					x
;x			sa-ba-ku to-ri-de be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBTRD		EQU	$
		I8			; index 8bit mode
;
SBTRD00		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	SBTRD90
;
		JSR	DATFLG
		JSR	(STRDST,X)
		BRA	SBTRD00
;
SBTRD90		EQU	$
		PLB
		RTL
;
STRDST		EQU	$
		WORD	SBTRD1
		WORD	SBTRD2
		WORD	SBTRD3
		WORD	SBTRD4
		WORD	SBTRD5
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBTRD1					x
;x			sa-ba-ku to-ri-de be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBTRD1		EQU	$
		MI16			; memory , index 16bit mode
		LDA	#SBTD1DT
		STA	<WORK2
		LDA	#SBTD1DT+04H
		STA	<WORK4
		M8			; memory 8bit mode
		JSR	SBTD
;
SBTD190		EQU	$
		I8			; index 8bit mode
		RTS
;
;
		IDX16
SBTD		EQU	$
		LDX	<WORK0
SBTD00		EQU	$
		LDY	#0000H
SBTD10		EQU	$
		LDA	(<WORK2),Y
		JSR	BG2SET0
;
		LDA	(<WORK4),Y
		JSR	BG2SET2
		INX
		TXA
		AND	#00FH
		BNE	SBTD20
		M16			; memory 16bit mode
		TXA
		CMP	#01B0H
		BCS	SBTD25
		CLC
		ADC	#01A0H
		BRA	SBTD28
SBTD25		EQU	$
		SEC
		SBC	#01C0H
SBTD28		EQU	$
		TAX
		M8			; memory 8bit mode
SBTD20		EQU	$
		INY
		TYA
		AND	#003H
		BNE	SBTD10
		DEC	<ENMWK0
		BNE	SBTD00
		RTS
		IDX8
;
;
SBTD1DT		EQU	$
		BYTE	STD04,STD05,STD06,STD07
		BYTE	STD02,STD03,STD00,STD01
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBTRD2					x
;x			sa-ba-ku to-ri-de be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBTRD2		EQU	$
		MI16			; memory , index 16bit mode
		LDA	#SBTD2DT
		STA	<WORK2
		LDA	#SBTD2DT+04H
		STA	<WORK4
		M8			; memory 8bit mode
;
		JSR	SBTDTT
;
		I8			; index 8bit mode
		RTS
;
		IDX16
SBTDTT		EQU	$
		LDY	#0000H
SBTD200		EQU	$
		LDX	<WORK0
		LDA	(<WORK2),Y
		JSR	BG2SET0
		INX
		LDA	(<WORK4),Y
		JSR	BG2SET0
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0010H
		STA	<WORK0
		M8			; memory 8bit mode
		INY
		TYA
		AND	#003H
		BNE	SBTD200
		RTS
		IDX8
;
;
SBTD2DT		EQU	$
		BYTE	STD04,STD08,STD08,STD02
		BYTE	STD07,STD09,STD09,STD01
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBTRD3					x
;x			sa-ba-ku to-ri-de be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBTRD3		EQU	$
		I16			; index 16bit mode
;
		LDX	<WORK0
		LDA	#STD04
		JSR	BG2SET0
		LDA	#STD02
		JSR	BG2SET2
		INX
		LDA	#STD07
		JSR	BG2SET0
		LDA	#STD01
		JSR	BG2SET2
;
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBTRD4					x
;x			sa-ba-ku to-ri-de be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBTRD4		EQU	$
		MI16			; memory , index 16bit mode
		LDA	<ENMWK0
		STA	<ENMWK2
		LDA	#SBTD4DT
		STA	<WORK2
		LDA	#SBTD4DT+04H
		STA	<WORK4
		M8			; memory 8bit mode
		JSR	SBTD
;
		M16			; memory 16bit mode
		LDA	<ENMWK2
		STA	<ENMWK0
		LDA	<WORK0
		CLC
		ADC	#0020H
		STA	<WORK0
		LDA	#SBTD4DT+08H
		STA	<WORK2
		LDA	#SBTD4DT+0CH
		STA	<WORK4
		M8			; memory 8bit mode
		JSR	SBTD
;
		I8			; index 8bit mode
		RTS
;
SBTD4DT		EQU	$
		BYTE	STD04,STD05,STD06,STD07
		BYTE	STD0E,STD0F,STD10,STD11
		BYTE	STD0E,STD0F,STD10,STD11
		BYTE	STD02,STD03,STD00,STD01
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBTRD5					x
;x			sa-ba-ku to-ri-de be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBTRD5		EQU	$
		MI16			; memory , index 16bit mode
		LDA	#SBTD5DT
		STA	<WORK2
		LDA	#SBTD5DT+04H
		STA	<WORK4
		LDA	<WORK0
		PHA
		M8			; memory 8bit mode
;
		JSR	SBTDTT
;
		M16			; memory 16bit mode
		PLA
		INC	A
		INC	A
		STA	<WORK0
		AND	#000FH
		BNE	SBTD500
		LDA	<WORK0
		CLC
		ADC	#01A0H
		STA	<WORK0
SBTD500		EQU	$
		M8			; memory 8bit mode
;
		JSR	SBTDTT
;
		I8			; index 8bit mode
		RTS
;
SBTD5DT		EQU	$
		BYTE	STD0A,STD0C,STD0D,STD0A
		BYTE	STD0B,STD0C,STD0D,STD0B
;
;
;-------------- < BG2 fu-ne character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	FNEST					x
;x			fu-ne be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
FNEST		EQU	$
		I8			; index 8bit mode
;
		LDX	#010H		; 110h line set
		LDA	#FNE1B
		STA	<WORK0
		JSR	SIRLP2
;
		LDA	#FNE1E		; 120h line set
		STA	<WORK0
		JSR	SIRLP2
;
		LDX	#050H		; 150h --> 190h line set
		LDA	#FNE3B
		STA	<WORK0
		JSR	SIRLP2
		JSR	SIRLP2
		JSR	SIRLP2
		JSR	SIRLP2
		JSR	SIRLP2
;
FNELOP		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	FNESTED
;
		JSR	DATFLG
		JSR	(FNESTDT,X)
		BRA	FNELOP
;
FNESTED		EQU	$
		PLB
		RTL
;
FNESTDT		EQU	$
		WORD	FNKM0
		WORD	FNSYM
		WORD	FNBYM
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	FNKM0					x
;x			fu-ne be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
FNKM0		EQU	$
;
		LDA	#BANK FNKM0GY
		STA	<WORK8
		STA	<WORKB
		STA	<WORKE
;
		MI16			; memory , index 16bit mode
		LDX	<ENMWK0
		LDA	FNKM0D,X
		STA	<WORK6
		LDA	FNKM0A,X
		STA	<WORK9
		LDA	FNKM0C,X
		STA	<WORKC
		STZ	<WORK4
		M8			; memory 8bit mode
		LDA	FNKM0GY,X
		STA	<WORKF
		LDX	<WORK0
		LDY	#0000H
		LDA	[<WORKC]
		STA	<WORK2
;
		JSR	NZIWLP
		I8			; index 8bit mode
		RTS
;
;
FNKM0GY EQU	$
	WORD	0004H,0002H,0002H,0002H,0002H,0003H
;
FNKM0D	EQU	$
	WORD	FNKM0D0,FNKM0D1,FNKM0D2,FNKM0D3,FNKM0D4,FNKM0D5
;
FNKM0A	EQU	$
	WORD	FNKM0A0,FNKM0A1,FNKM0A2,FNKM0A3,FNKM0A4,FNKM0A5
;
FNKM0C	EQU	$
	WORD	FNKM0C0,FNKM0C1,FNKM0C2,FNKM0C3,FNKM0C4,FNKM0C5
;
;---------------- unit ba-ta data
FNKM0D0 EQU	$
	BYTE	FNE03,FNE04
	BYTE	FNE0C,FNE0D,FNE0E
	BYTE	FNE0C,FNE12,FNE16,FNE10,FNE11,FNE17
	BYTE	FNE1C,FNE1A
;
FNKM0D1 EQU	$
	BYTE	FNE0F,FNE03,FNE04,FNE06
	BYTE	FNE18,FNE0C,FNE12,FNE13
;
FNKM0D2 EQU	$
	BYTE	FNE16,FNE06,FNE19,FNE03,FNE04,FNE06
	BYTE	FNE1C,FNE1D,FNE1A,FNE1B,FNE1C,FNE1D
;
FNKM0D3 EQU	$
	BYTE	FNE10,FNE11,FNE05
	BYTE	FNE1A
;
FNKM0D4 EQU	$
	BYTE	FNE02,FNE05,FNE03,FNE04,FNE06,FNE07
	BYTE	FNE0B,FNE0C,FNE0C,FNE12,FNE13,FNE14,FNE15
;
FNKM0D5 EQU	$
	BYTE	FNE01,FNE00,FNE02
	BYTE	FNE02,FNE05,FNE08,FNE09,FNE0A,FNE0B
	BYTE	FNE0B,FNE0C,FNE0C,FNE0C,FNE0C,FNE0C
;
;---------------- ram buffer adress inc
FNKM0A0 EQU	$
	WORD	0010H,0010H,0012H
;
FNKM0A1 EQU	$
FNKM0A2 EQU	$
FNKM0A3 EQU	$
FNKM0A4 EQU	$
	WORD	0010H
;
FNKM0A5 EQU	$
	WORD	000DH,0010H
;
;
;---------------- yo-ko unit count
FNKM0C0 EQU	$
	BYTE	02H,03H,06H,02H
;
FNKM0C1 EQU	$
	BYTE	04H,04H
;
FNKM0C2 EQU	$
	BYTE	06H,06H
;
FNKM0C3 EQU	$
	BYTE	03H,01H
;
FNKM0C4 EQU	$
	BYTE	06H,07H
;
FNKM0C5 EQU	$
	BYTE	03H,06H,06H
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	FNSYM					x
;x			fu-ne be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
FNSYM		EQU	$
		I16			; index 16bit mode
;
		LDX	<WORK0
		LDA	#FNE2B
		STA	<WORK2
		LDA	#FNE37
		STA	<WORK3
;
FNSYMLP		EQU	$
		LDA	<WORK2
		JSR	BG2SET0
		LDA	<WORK3
		JSR	BG2SET2
		CMP	#FNE3A
		BEQ	FNSYMED
		INX
		INC	<WORK2
		INC	<WORK3
		BRA	FNSYMLP
;
FNSYMED		EQU	$
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	FNBYM					x
;x			fu-ne be-te set			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
FNBYM		EQU	$
		I16			; index 16bit mode
;
		LDX	<WORK0
		LDY	#0004H
		LDA	#FNE1F
		STA	<WORK2
		JSR	FNBYMLP
;
		LDY	#0008H
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#000EH
		STA	<WORK0
		TAX
		M8			; memory 8bit mode
		JSR	FNBYMLP
;
		LDY	#0008H
		LDA	#FNE2F
		STA	<WORK2
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0010H
		TAX
		M8			; memory 8bit mode
		JSR	FNBYMLP
;
		I8			; index 8bit mode
		RTS
;
		IDX16
FNBYMLP		EQU	$
		LDA	<WORK2
		JSR	BG2SET0
		INC	<WORK2
		INX
		TXA
		AND	#00FH
		BNE	FNBYMPS
		M16			; memory 16bit mode
		TXA
		SEC
		SBC	#01C0H
		TAX
		M8			; memory 8bit mode
FNBYMPS		EQU	$
		DEY
		BNE	FNBYMLP
		RTS
		IDX8
;
;
;-------------- < BG2 BG2 bonas character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	B2BNS					x
;x			BG2 bonas be-te set		x
;x			ice chi-ka be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
B2BNS		EQU	$
		I8			; index 8bit mode
;
		LDA	#BONS0		; BONS0 --> BONS3
		STA	<WORK0		;
		INC	A		;
		STA	<WORK1		;
		INC	A		;
		STA	<WORK2		;
		INC	A		;
		STA	<WORK3		;
		LDX	#000H		; 000h 040h 080h 0C0h 100h 140h 180h
		JSR	BNSLP1		;    line set
;
		LDA	#BONS4		; BONS4 --> BONS7
		STA	<WORK0		;
		INC	A		;
		STA	<WORK1		;
		INC	A		;
		STA	<WORK2		;
		INC	A		;
		STA	<WORK3		;
		LDX	#010H		; 010h 050h 090h 0D0h 110h 150h 190h
		JSR	BNSLP1		;    line set
;
		LDA	#BONS8		; BONS8 --> BONSB
		STA	<WORK0		;
		INC	A		;
		STA	<WORK1		;
		INC	A		;
		STA	<WORK2		;
		INC	A		;
		STA	<WORK3		;
		LDX	#020H		; 020h 060h 0A0h 0E0h 120h 160h 1A0h
		JSR	BNSLP1		;    line set
;
		LDA	#BONSC		; BONSC --> BONSF
		STA	<WORK0		;
		INC	A		;
		STA	<WORK1		;
		INC	A		;
		STA	<WORK2		;
		INC	A		;
		STA	<WORK3		;
		LDX	#030H		; 030h 070h 0B0h 0F0h 130h 170h
		JSR	BNSLP1		;    line set
		TXA
		CLC
		ADC	#030H
		TAX
		JSR	BNSLP2
;
		PLB
		RTL
;
;
BNSLP1		EQU	$
		LDA	<WORK0
		JSR	BG2SET3
		JSR	BG2SET1
		INX
		LDA	<WORK1
		JSR	BG2SET3
		JSR	BG2SET1
		INX
		LDA	<WORK2
		JSR	BG2SET3
		JSR	BG2SET1
		INX
		LDA	<WORK3
		JSR	BG2SET3
		JSR	BG2SET1
		INX
		TXA
		AND	#00FH
		BNE	BNSLP1
		TXA
		CLC
		ADC	#030H
		TAX
		CPX	#0B0H
		BCC	BNSLP1
BNSLP2		EQU	$
		LDA	<WORK0
		JSR	BG2SET3
		INX
		LDA	<WORK1
		JSR	BG2SET3
		INX
		LDA	<WORK2
		JSR	BG2SET3
		INX
		LDA	<WORK3
		JSR	BG2SET3
		INX
		TXA
		AND	#00FH
		BNE	BNSLP2
		RTS
;
;
;-------------- < BG2 water a-su-re-ti-ku character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	WASST					x
;x			water a-su-re-ti-ku be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
WASST		EQU	$
		I8			; index 8bit mode
		LDX	#0D0H
		LDA	#WAS1B		; 0D0h --> 120h
		STA	<WORK0		;	line set
		JSR	SIRLP1
		JSR	SIRLP1
		JSR	SIRLP1
		JSR	SIRLP2
		JSR	SIRLP2
		JSR	SIRLP2
;
		I16			; index 16bit mode
		LDY	#0000H
		LDX	#00B0H
		M16			; memory 16bit mode
		LDA	#WASKMD0
		STA	<WORK0
		M8			; memory 8bit mode
		JSR	WASLOP0
;
		LDX	#00E1H
		LDA	#WAS19
		JSR	BG2SET0
		LDX	#00F8H
		JSR	BG2SET0
		INX
		JSR	BG2SET0
		LDX	#(00E6H+01B0H)
		JSR	BG2SET0
		LDX	#(00EAH+01B0H)
		JSR	BG2SET0
		INX
		JSR	BG2SET0
		LDX	#(00F2H+01B0H)
		JSR	BG2SET0
;
		LDY	#0000H
		LDX	#00E5H
WASLOP1		EQU	$
		LDA	WASKMD1,Y
		JSR	BG2SET0
		INX
		INY
		CPY	#0008H
		BNE	WASLOP1
;
		LDY	#0000H
		LDX	#(00B0H+01B0H)
		M16			; memory 16bit mode
		LDA	#WASKMD2
		STA	<WORK0
		M8			; memory 8bit mode
		JSR	WASLOP0
;
		LDY	#0000H
		LDX	#(00E1H+01B0H)
WASLOP2		EQU	$
		LDA	WASKMD3,Y
		JSR	BG2SET0
		INX
		INY
		CPY	#0004H
		BNE	WASLOP2
;
		I8			; index 8bit mode
		LDX	#030H
		LDA	#WAS24		; 130h , 140h , 150h
		STA	<WORK0		;	line set
		JSR	SIRLP2
		JSR	SIRLP2
		JSR	SIRLP2
;
		LDA	#WAS2E		; 160h
		STA	<WORK0		;	line set
		JSR	SIRLP2
;
		LDA	#WAS29		; 170h
		STA	<WORK0		;	line set
		JSR	SIRLP2
;
		LDA	#WAS26		; 180h
		STA	<WORK0		;	line set
		JSR	SIRLP2
;
WASLOP5		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	WASEND
;
		JSR	DATFLG
		JSR	WASSIMA
		BRA	WASLOP5
;
WASEND		EQU	$
		LDA	!BG2COS
		CMP	#01EH
		BNE	WASEND0
		LDA	#000H
		XBA
		I16				; index 16bit mode
		LDY	#B2RMBF0+110H
		LDX	#B2RMBF0+120H
		LDA	#0EFH
		MVN	#BANK B2RMBF0,#BANK B2RMBF0
;
		LDA	#000H
		XBA
		LDY	#B2RMBF1+110H
		LDX	#B2RMBF1+120H
		LDA	#0EFH
		MVN	#BANK B2RMBF1,#BANK B2RMBF1
		I8				; index 8bit mode
;
WASEND0		EQU	$
		PLB
		RTL
;
;
		IDX16
WASLOP0		EQU	$
		LDA	(<WORK0),Y
		JSR	BG2SET0
		INX
		INY
		CPY	#0030H
		BNE	WASLOP0
		RTS
		IDX8
;
;
WASKMD0 EQU	$
	BYTE	WAS08,WAS08,WAS09,WAS00,WAS04,WAS09,WAS00,WAS00
	BYTE	WAS00,WAS00,WAS04,WAS08,WAS09,WAS00,WAS04,WAS08
	BYTE	WAS0F,WAS10,WAS11,WAS01,WAS0B,WAS11,WAS12,WAS08
	BYTE	WAS03,WAS01,WAS0B,WAS10,WAS11,WAS01,WAS0B,WAS10
	BYTE	WAS17,WAS0E,WAS15,WAS1A,WAS13,WAS0E,WAS0D,WAS10
	BYTE	WAS06,WAS06,WAS06,WAS06,WAS0C,WAS15,WAS1A,WAS1A
;
WASKMD1 EQU	$
	BYTE	WAS19,WAS1D,WAS13,WAS0E,WAS0E,WAS15,WAS1A,WAS16
;
WASKMD2 EQU	$
	BYTE	WAS03,WAS01,WAS02,WAS00,WAS04,WAS03,WAS01,WAS05
	BYTE	WAS06,WAS06,WAS06,WAS06,WAS06,WAS06,WAS06,WAS07
	BYTE	WAS06,WAS06,WAS0A,WAS01,WAS0B,WAS06,WAS06,WAS06
	BYTE	WAS06,WAS06,WAS06,WAS06,WAS06,WAS06,WAS0C,WAS0E
	BYTE	WAS13,WAS0D,WAS06,WAS06,WAS14,WAS13,WAS0E,WAS15
	BYTE	WAS16,WAS17,WAS0E,WAS0E,WAS15,WAS13,WAS18,WAS19
;
WASKMD3 EQU	$
	BYTE	WAS17,WAS0E,WAS15,WAS1C
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	WASSIMA					x
;x			water a-su-re-ti-ku be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
WASSIMA		EQU	$
		I16			; index 16bit mode
;
;;K;;		LDX	<WORK0
;;K;;		LDA	#WAS20
;;K;;		JSR	BG2SET0
;
		INC	<WORK0
		LDX	<WORK0
;;K;;		M16			; memory 16bit mode
;;K;;		LDA	<WORK0
;;K;;		TAX
;;K;;		AND	#000FH
;;K;;		BNE	WASSM00
;;K;;		TXA
;;K;;		CLC
;;K;;		ADC	#01A0H
;;K;;		STA	<WORK0
;;K;;		TAX
;
WASSM00		EQU	$
;;K;;		M8			; memory 8bit mode
		LDY	#0000H
WASSM10		EQU	$
		LDA	WASSMD1,Y
		JSR	BG2SET0
		JSR	INX10
		CPY	#0005H
		BNE	WASSM10
		INC	<WORK0
		LDX	<WORK0
		DEC	<ENMWK0
;
WASSM25		EQU	$
		LDY	#0000H
WASSM20		EQU	$
		LDA	WASSMD2,Y
		JSR	BG2SET0
		JSR	INX10
		CPY	#0005H
		BNE	WASSM20
		INC	<WORK0
		LDA	<WORK0
		AND	#00FH
		BNE	WASSM23
		M16			; memory 16bit mode
		LDA	<WORK0
		SEC
		SBC	#01C0H
		STA	<WORK0
		M8			; memory 8bit mode
WASSM23		EQU	$
		M8			; memory 8bit mode
		LDX	<WORK0
		DEC	<ENMWK0
		BNE	WASSM25
;
		LDY	#0000H
WASSM30		EQU	$
		LDA	WASSMD3,Y
		JSR	BG2SET0
		JSR	INX10
		CPY	#0005H
		BNE	WASSM30
;
		INC	<WORK0
		LDX	<WORK0
;;K;;		M16			; memory 16bit mode
;;K;;		LDA	<WORK0
;;K;;		TAX
;;K;;		AND	#00FH
;;K;;		BNE	WASSM40
;;K;;		TXA
;;K;;		SEC
;;K;;		SBC	#01C0H
;;K;;		TAX
;
WASSM40		EQU	$
;;K;;		M8			; memory 8bit mode
;;K;;		LDA	#WAS1F
;;K;;		JSR	BG2SET0
;
		I8			; index 8bit mode
		RTS
;
WASSMD1		EQU	$
		BYTE	WAS1E,WAS21,WAS25,WAS28,WAS2C
;
WASSMD2		EQU	$
		BYTE	WAS1E,WAS22,WAS26,WAS29,WAS26
;
WASSMD3		EQU	$
		BYTE	WAS1E,WAS23,WAS27,WAS2A,WAS2D
;
;
		IDX16
INX10		EQU	$
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0010H
		TAX
		M8			; memory 8bit mode
		INY
		RTS
		IDX8
;
;
;-------------- < BG2 ki-no-pi-o shop character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	KNMIS					x
;x			ki-no-pi-o shop be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
KNMIS		EQU	$
		I8			; index 8bit mode
		LDA	#001H		; no pause set
		STA	!NOPAUSE
;
		LDX	#000H
		LDA	#KSP13		; 100h line set
		STA	<WORK0
		LDA	#KSP14
		STA	<WORK1
		LDA	#KSP15
		STA	<WORK2
		LDA	#KSP16
		STA	<WORK3
		LDA	#004H
		STA	<WORK4
		JSR	BILLP60
;
		LDX	#010H
		LDA	#KSP17		; 110h 130h 150h 170h 190h
		STA	<WORK0		;	line set
		LDA	#KSP18
		STA	<WORK1
KNMI010		EQU	$
		LDA	#008H
		STA	<WORK4
		JSR	BILLP70
		TXA
		CLC
		ADC	#010H
		TAX
		CPX	#0B0H
		BNE	KNMI010
;
		LDX	#020H
		LDA	#KSP13		; 120h 140h 160h 180h
		STA	<WORK0		;	line set
		LDA	#KSP16
		STA	<WORK1
KNMI020		EQU	$
		LDA	#008H
		STA	<WORK4
		JSR	BILLP70
		TXA
		CLC
		ADC	#010H
		TAX
		CPX	#0A0H
		BNE	KNMI020
;
KNMI100		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	KNMI200
;
		JSR	DATFLG
		JSR	(KNMIDAT,X)
		BRA	KNMI100
;
KNMI200		EQU	$
		PLB
		RTL
;
;
KNMIDAT		EQU	$
		WORD	KNMIDT1,KNMIDT2
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	KNMIDT1					x
;x			ki-no-pi-o shop be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
KNMIDT1		EQU	$
		LDX	<WORK0
		LDA	#KSP01
		JSR	BG2SET3
		INX
		LDA	#KSP02
		JSR	BG2SET3
;
		LDA	<WORK0
		CLC
		ADC	#00FH
		TAX
		STA	<WORK0
;
		STZ	<WORK1
KNMID00		EQU	$
		LDA	#004H
		STA	<WORK2
KNMID10		EQU	$
		LDY	<WORK1
		LDA	KNMID11,Y
		JSR	BG2SET3
		INX
		INC	<WORK1
		DEC	<WORK2
		BNE	KNMID10
;
		LDA	<WORK0
		CLC
		ADC	#010H
		TAX
		STA	<WORK0
		DEC	<ENMWK0
		BNE	KNMID00
;
		RTS
;
;
KNMID11		EQU	$
		BYTE	KSP05,KSP06,KSP07,KSP08
;
		BYTE	KSP0B,KSP0C,KSP0D,KSP0E
;
		BYTE	KSP0F,KSP10,KSP11,KSP12
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	KNMIDT2					x
;x			ki-no-pi-o shop be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
KNMIDT2		EQU	$
		LDX	<WORK0
		LDA	#KSP03
		JSR	BG2SET3
		INX
		LDA	#KSP04
		JSR	BG2SET3
;
		LDA	<WORK0
		CLC
		ADC	#010H
		TAX
;
		LDA	#KSP09
		JSR	BG2SET3
		INX
		LDA	#KSP0A
		JSR	BG2SET3
;
		RTS
;
;
;-------------- < BG2 ku-pa si-ro character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	KPSET					x
;x			ku-pa si-ro be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
KPSET		EQU	$
		I8			; index 8bit mode
;
		LDX	#007H
KPST010		EQU	$
		LDA	#KPS06
		JSR	BG2SET3
		TXA
		CLC
		ADC	#010H
		TAX
		CPX	#0E0H
		BCC	KPST010
;
		LDX	#00FH
KPST015		EQU	$
		LDA	#KPS06
		JSR	BG2SET3
		TXA
		CLC
		ADC	#010H
		TAX
		CPX	#0E0H
		BCC	KPST015
;
		LDX	#051H
		LDA	#KPS11
		STA	<WORK1
		JSR	KPST020
;
		LDX	#059H
		LDA	#KPS11
		STA	<WORK1
		JSR	KPST020
;
		LDX	#0D1H
		LDA	#KPS03
		STA	<WORK1
		JSR	KPST020
;
		LDX	#0D9H
		LDA	#KPS03
		STA	<WORK1
		JSR	KPST020
;
		LDX	#0E0H		; 0E0H line set
		LDA	#KPS11
		STA	<WORK0
		JSR	SIRLP1
;
		LDA	#KPS29		; 0F0H line set
		STA	<WORK0
		JSR	SIRLP1
;
		LDX	#000H		; 100H line set
		LDA	#KPS2A
		STA	<WORK0
		JSR	KPST030
		LDA	#KPS2A
		STA	<WORK0
		JSR	KPST030
;
		LDX	#010H		; 110H line set
		LDA	#KPS32
		STA	<WORK0
		JSR	KPST030
		LDA	#KPS32
		STA	<WORK0
		JSR	KPST030
;
		LDX	#090H		; 190H , 1A0H line set
		LDA	#KPS11
		STA	<WORK0
		JSR	SIRLP2
		JSR	SIRLP2
;
KPST100		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	KPST999
;
		JSR	DATFLG
		JSR	(KPSTDAT,X)
		BRA	KPST100
;
KPST999		EQU	$
		PLB
		RTL
;
;
KPSTDAT		EQU	$
		WORD	KPSTD1		; ka-ve
		WORD	KPSTD2		; ku-pa e
		WORD	KPSTD3		; ku-pa ma-do left
		WORD	KPSTD4		; ku-pa ma-do right
;
;
KPST020		EQU	$
		LDA	#006H
		STA	<WORK0
		LDA	<WORK1
KPST025		EQU	$
		JSR	BG2SET3
		INX
		DEC	<WORK0
		BNE	KPST025
		RTS
;
;
KPST030		EQU	$
		LDA	<WORK0
		JSR	BG2SET1
		INC	<WORK0
		INX
		TXA
		AND	#007H
		BNE	KPST030
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	KPSTD1					x
;x			ku-pa si-ro be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
KPSTD1		EQU	$
		LDX	<WORK0
		LDA	<ENMWK0
		STA	<WORK2
KPSTD10		EQU	$
		LDY	<ENMWK2
		LDA	KPSTD1D,Y
		CMP	#0FFH
		BEQ	KPSTD15
		JSR	BG2SET3
		INC	<ENMWK2
		INX
		DEC	<WORK2
		BNE	KPSTD10
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0010H
		STA	<WORK0
		M8			; memory 8bit mode
		BRA	KPSTD1
;
KPSTD15		EQU	$
		RTS
;
KPSTD1D		EQU	$
		BYTE	KPS03,KPS03,KPS03,KPS03,KPS12,KPS03
		BYTE	KPS0D,KPS13,KPS08,KPS05,KPS02,KPS14
;
		BYTE	KPS07,KPS05,KPS04,KPS07,KPS02,KPS01
		BYTE	KPS08,KPS09,KPS0A,KPS0B,KPS0C,KPS08
		BYTE	KPS0D,KPS04,KPS04,KPS0B,KPS0E,KPS01
		BYTE	KPS07,KPS0B,KPS0D,KPS04,KPS05,KPS04
		BYTE	KPS03,KPS0F,KPS02,KPS01,KPS10,KPS01
		BYTE	0FFH
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	KPSTD1					x
;x			ku-pa si-ro be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
KPSTD2		EQU	$
		LDA	#KPS15
		STA	<WORK2
;
KPSTD23		EQU	$
		LDA	<ENMWK0
		STA	<ENMWK1
		LDX	<WORK0
;
KPSTD20		EQU	$
		LDA	<WORK2
		JSR	BG2SET3
		INC	<WORK2
		INX
		DEC	<ENMWK1
		BNE	KPSTD20
		M16			; memory 16bit mode
		LDA	<WORK0
		CLC
		ADC	#0010H
		STA	<WORK0
		M8			; memory 8bit mode
		DEC	<ENMWK2
		BNE	KPSTD23
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	KPSTD3		(left)			x
;x			ku-pa si-ro be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
KPSTD3		EQU	$
;
		LDX	<WORK0
		LDA	#KPS3A
		JSR	BG2SET1
		INX
		INC	A
		JSR	BG2SET1
		INX
		INC	A
		JSR	BG2SET1
		INX
		LDA	#KPS54
		JSR	BG2SET1
;
		LDA	<WORK0
		CLC
		ADC	#010H
		STA	<WORK0
		TAX
;
		LDA	<ENMWK0
		STA	<ENMWK1
		LDA	#KPS40
		STA	<WORK2
		JSR	KPSTD5
;
		INC	<WORK0
		LDX	<WORK0
		LDA	<ENMWK0
		STA	<ENMWK1
		INC	<WORK2
		JSR	KPSTD5
;
		INC	<WORK0
		LDX	<WORK0
		LDA	<ENMWK0
		STA	<ENMWK1
		LDA	#KPS54
		STA	<WORK2
		JSR	KPSTD5
;
		INC	<WORK0
		LDX	<WORK0
		LDA	<ENMWK0
		STA	<ENMWK1
		JSR	KPSTD5
;
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	KPSTD4		(right)			x
;x			ku-pa si-ro be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
KPSTD4		EQU	$
;
		LDX	<WORK0
		LDA	#KPS54
		JSR	BG2SET1
		INX
		LDA	#KPS3D
		JSR	BG2SET1
		INX
		INC	A
		JSR	BG2SET1
		INX
		INC	A
		JSR	BG2SET1
;
		LDA	<WORK0
		CLC
		ADC	#010H
		STA	<WORK0
		TAX
;
		LDA	<ENMWK0
		STA	<ENMWK1
		LDA	#KPS54
		STA	<WORK2
		JSR	KPSTD5
;
		INC	<WORK0
		LDX	<WORK0
		LDA	<ENMWK0
		STA	<ENMWK1
		JSR	KPSTD5
;
		INC	<WORK0
		LDX	<WORK0
		LDA	<ENMWK0
		STA	<ENMWK1
		LDA	#KPS42
		STA	<WORK2
		JSR	KPSTD5
;
		INC	<WORK0
		LDX	<WORK0
		LDA	<ENMWK0
		STA	<ENMWK1
		INC	<WORK2
		JSR	KPSTD5
;
		RTS
;
;
KPSTD5		EQU	$
		LDA	WORK2
		JSR	BG2SET1
		TXA
		CLC
		ADC	#010H
		TAX
		DEC	<ENMWK1
		BNE	KPSTD5
		RTS
;
;
;-------------- < BG2 world 8 - 1 character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	W81ST					x
;x			world 8 - 1 be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
W81ST		EQU	$
		I8			; index 8bit mode
;
		LDX	#090H		; 090h line set
		LDA	#W8103
		STA	<WORK0
		JSR	W81S00
;
		LDA	#W8107		; 0A0h line set
		STA	<WORK0
		JSR	W81S00
;
		LDA	#W810B		; 0B0h line set
		STA	<WORK0
		JSR	W81S00
;
W81S10		EQU	$		; 0C0h line set
		LDA	#W8109
		JSR	BG2SET3
		INX
		LDA	#W810A
		JSR	BG2SET3
		INX
		LDA	#W8107
		JSR	BG2SET3
		INX
		LDA	#W8108
		JSR	BG2SET3
		INX
		TXA
		AND	#00FH
		BNE	W81S10
;
		LDA	#W810F		; 0D0h , 0E0h , 0F0h
		STA	<WORK0		;	line set
		JSR	SIRLP1
		JSR	SIRLP1
		JSR	SIRLP1
;
		JSR	SIRLP2		; 100h , 110h
		JSR	SIRLP2		;	line set
;
		LDA	#W8118		; 120h line set
		STA	<WORK0
		JSR	W81S30
;
		LDA	#W811C		; 130h line set
		STA	<WORK0
		JSR	W81S30
;
		LDA	#W8120		; 140h line set
		STA	<WORK0
		JSR	W81S30
;
		LDA	#W8124		; 150h line set
		STA	<WORK0
		JSR	W81S30
;
		LDA	#W8128		; 160h line set
		STA	<WORK0
		JSR	W81S30
;
W81S50		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	W81S99
;
		JSR	DATFLG
		JSR	(W81SDAT,X)
		BRA	W81S50
;
W81S99
		PLB
		RTL
;
;
W81S00		EQU	$
		LDA	<WORK0
		JSR	BG2SET3
		INC	A
		INX
		JSR	BG2SET3
		INC	A
		INX
		JSR	BG2SET3
		INC	A
		INX
		JSR	BG2SET3
		INX
		TXA
		AND	#00FH
		BNE	W81S00
		RTS
;
;
W81S30		EQU	$
		LDA	<WORK0
		JSR	BG2SET1
		INC	A
		INX
		JSR	BG2SET1
		INC	A
		INX
		JSR	BG2SET1
		INC	A
		INX
		JSR	BG2SET1
		INX
		TXA
		AND	#00FH
		BNE	W81S30
		RTS
;
;
W81SDAT		EQU	$
		WORD	W81STR1,W81STR2,W81HAH1,W81HAH2,W81STR3,W81STR4
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	W81STR1					x
;x			world 8 - 1 be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
W81STR1		EQU	$
		LDA	#W8101
		STA	<WORK3
		BRA	W81STR
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	W81STR2					x
;x			world 8 - 1 be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
W81STR2		EQU	$
		LDA	#W8102
		STA	<WORK3
		BRA	W81STR
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	W81STR3					x
;x			world 8 - 1 be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
W81STR3		EQU	$
		LDA	#W812C
		STA	<WORK3
		BRA	W81STR
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	W81STR4					x
;x			world 8 - 1 be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
W81STR4		EQU	$
		LDA	#W812D
		STA	<WORK3
;
W81STR		EQU	$
		I16			; index 16bit mode
		LDX	<WORK0
		LDA	<WORK3
		JSR	BG2SET0
;
		LDA	<ENMWK0
		BEQ	W81SED
		CLC
		ADC	<WORK0
		STA	<WORK0
		LDX	<WORK0
		LDA	<WORK3
		JSR	BG2SET0
;
		LDA	<ENMWK2
		BEQ	W81SED
		CLC
		ADC	<WORK0
		STA	<WORK0
		LDX	<WORK0
		LDA	<WORK3
		JSR	BG2SET0
;
W81SED		EQU	$
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	W81HAH1					x
;x			world 8 - 1 be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
W81HAH1		EQU	$
		M16			; memory 16bit mode
		LDA	#W81HDT1
		STA	<WORK3
		INC	A
		INC	A
		INC	A
		INC	A
		STA	<WORK5
		M8			; memory 8bit mode
		BRA	W81HAH
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	W81HAH2					x
;x			world 8 - 1 be-ta set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
W81HAH2		EQU	$
		M16			; memory 16bit mode
		LDA	#W81HDT2
		STA	<WORK3
		INC	A
		INC	A
		INC	A
		INC	A
		STA	<WORK5
		M8			; memory 8bit mode
;
W81HAH		EQU	$
		I16			; index 16bit mode
;
		LDY	#0000H
W81HAH5		EQU	$
		LDX	<WORK0
		LDA	(<WORK3),Y
		JSR	BG2SET0
		LDA	(<WORK5),Y
		JSR	BG2SET2
;
		INY
		CPY	#004H
		BEQ	W81HAH9
		INC	<WORK0
		LDA	<WORK0
		AND	#00FH
		BNE	W81HAH5		; next page ? no --> W81HAH5
;
		LDA	<ENMWK0
		BNE	W81HAH6
		M16			; memory 16bit mode
		LDA	<WORK0		; next page set
		CLC
		ADC	#01A0H
		STA	<WORK0
		M8			; memory 8bit mode
		BRA	W81HAH5
W81HAH6		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0		; back page set
		SEC
		SBC	#01C0H
		STA	<WORK0
		M8			; memory 8bit mode
		BRA	W81HAH5
;
W81HAH9		EQU	$
		I8			; index 8bit mode
		RTS
;
W81HDT1		EQU	$
		BYTE	W8110,W8111,W8112,W8113
		BYTE	W8114,W8115,W8116,W8117
;
W81HDT2		EQU	$
		BYTE	W810D,W810E,W810B,W810C
		BYTE	W8107,W8108,W8109,W810A
;
;
;-------------- < BG2 world 8 ha-i-ko-u character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	W8HST					x
;x			world 8 ha-i-ko-u be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
W8HST		EQU	$
		I8			; index 8bit mode
;
		LDX	#0F0H		; 0F0h line set
W8HST00		EQU	$
		LDA	#STD12
		JSR	BG2SET3
		INX
		LDA	#STD13
		JSR	BG2SET3
		INX
		LDA	#STD14
		JSR	BG2SET3
		INX
		LDA	#STD15
		JSR	BG2SET3
		INX
		TXA
		AND	#00FH
		BNE	W8HST00
;
		LDX	#000H		; 100h line set
W8HST10		EQU	$
		LDA	#STD16
		JSR	BG2SET1
		INX
		LDA	#STD17
		JSR	BG2SET1
		INX
		LDA	#STD18
		JSR	BG2SET1
		INX
		LDA	#STD19
		JSR	BG2SET1
		INX
		TXA
		AND	#00FH
		BNE	W8HST10
;
W8HST50		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	W8HST90
;
		JSR	DATFLG
		JSR	(W8HDT,X)
		BRA	W8HST50
;
W8HST90		EQU	$
		PLB
		RTL
;
;
W8HDT		EQU	$
		WORD	SBTRD1
		WORD	SBTRD3
		WORD	SBTRD4
		WORD	SBTRD5
		WORD	SBTRD6
		WORD	SBTRD7
		WORD	SBTRD8
		WORD	SBTRD9
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBTRD6					x
;x			world 8 ha-i-ko-u be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBTRD6		EQU	$
		MI16			; memory , index 16bit mode
		LDA	#SBTD6D1
		STA	<WORK2
		LDA	#SBTD6D1+04H
		STA	<WORK4
		M8			; memory 8bit mode
		JSR	SBTD
;
		I8			; index 8bit mode
		RTS
;
;
SBTD6D1		EQU	$
		BYTE	STD1A,STD1B,STD1C,STD1D
		BYTE	STD1E,STD1F,STD20,STD21
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBTRD7					x
;x			world 8 ha-i-ko-u be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBTRD7		EQU	$
		MI16			; memory , index 16bit mode
		LDA	#SBTD7D1
		STA	<WORK2
		LDA	#SBTD7D1+04H
		STA	<WORK4
		M8			; memory 8bit mode
		JSR	SBTDTT
;
		I8			; index 8bit mode
		RTS
;
;
SBTD7D1		EQU	$
		BYTE	STD1A,STD22,STD22,STD1E
		BYTE	STD1D,STD23,STD23,STD21
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBTRD8					x
;x			world 8 ha-i-ko-u be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBTRD8		EQU	$
		I16			; index 16bit mode
;
		LDX	<WORK0
		LDA	#STD1A
		JSR	BG2SET0
		LDA	#STD1E
		JSR	BG2SET2
		INX
		LDA	#STD1D
		JSR	BG2SET0
		LDA	#STD21
		JSR	BG2SET2
;
		I8			; index 8bit mode
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	SBTRD9					x
;x			world 8 ha-i-ko-u be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
SBTRD9		EQU	$
		MI16			; memory , index 16bit mode
		LDA	#SBTD9D1
		STA	<WORK2
		LDA	#SBTD9D1+04H
		STA	<WORK4
		LDA	<WORK0
		PHA
		M8			; memory 8bit mode
;
		JSR	SBTDTT
;
		M16			; memory 16bit mode
		PLA
		INC	A
		INC	A
		STA	<WORK0
		AND	#000FH
		BNE	SBTD900
		LDA	<WORK0
		CLC
		ADC	#01A0H
		STA	<WORK0
SBTD900		EQU	$
		M8			; memory 8bit mode
;
		JSR	SBTDTT
;
		I8			; index 8bit mode
		RTS
;
;
SBTD9D1		EQU	$
		BYTE	STD24,STD26,STD27,STD24
		BYTE	STD25,STD26,STD27,STD25
;
;-------------- < BG2 2 play battle character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	PL2ST					x
;x			2 play battle be-te set		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
PL2ST		EQU	$
		LDA	!SCCH2+1
		BEQ	PL2ST10
		LDA	#005H
		STA	!BG2COS
		I8			; index 8bit mode
		PLB
		JMP	BG2BFST
;
PL2ST10		EQU	$
		I16			; index 16bit mode
		LDA	#010H
		STA	<WORK0
		STZ	<WORK0+1
		LDA	#008H
		STA	<WORK2
		JSR	PL2ST00
;
		LDA	#001H
		STA	<WORK0
		STZ	<WORK0+1
		LDA	#008H
		STA	<WORK2
		JSR	PL2ST00
;
		LDY	#B2RMBF1
		LDX	#B2RMBF0
		LDA	#001H
		XBA
		LDA	#0AFH
		MVN	#BANK B2RMBF1,#BANK B2RMBF0
;
		I8			; index 8bit mode
		PLB
		RTL
;
		IDX16
PL2ST00		EQU	$
		LDX	<WORK0
PL2ST05		EQU	$
		LDA	#PLY21
		JSR	BG2SET0
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0020H
		TAX
		M8			; memory 8bit mode
		CPX	#01B0H
		BCC	PL2ST05
		INC	<WORK0
		INC	<WORK0
		DEC	<WORK2
		BNE	PL2ST00
		RTS
		IDX8
;
;
;-------------- < BG2 pi-i-chi room set character unit set > --------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	PICHI					x
;x			pi-i-chi room set be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
PICHI		EQU	$
;
		I8			; index 8bit mode
;
		LDX	#0F0H		; 0F0h line set
		LDA	#KPS29
		STA	<WORK0
		JSR	SIRLP1
;
		LDX	#000H		; 100h line set
		LDA	#KPS2A
		STA	<WORK0
		JSR	KPST030
		LDA	#KPS2A
		STA	<WORK0
		JSR	KPST030
;
		LDX	#010H		; 110h line set
		LDA	#KPS32
		STA	<WORK0
		JSR	KPST030
		LDA	#KPS32
		STA	<WORK0
		JSR	KPST030
;
PICHI50		EQU	$
		LDY	#000H
		LDA	[<DATANO],Y
		CMP	#0FFH
		BEQ	PICHI99
;
		JSR	DATFLG
		JSR	(PCHISET,X)
		BRA	PICHI50
;
PICHI99		EQU	$
		PLB
		RTL
;
PCHISET		EQU	$
		WORD	KPSTD3
		WORD	KPSTD4
		WORD	PCHMAD
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	JSR	PCHMAD					x
;x			pi-i-chi room set be-te set	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
PCHMAD		EQU	$
;
		LDX	<WORK0
		LDY	<ENMWK2
		LDA	PCH5D0,Y
		JSR	BG2SET3
		INX
;
PCHMAD0		EQU	$
		LDY	<ENMWK3
		LDA	PCH5D1,Y
		CMP	#0FFH
		BEQ	PCHMAD1
		JSR	BG2SET3
		INX
		INC	<ENMWK3
		BRA	PCHMAD0
;
PCHMAD1		EQU	$
		LDA	#KPS06
		JSR	BG2SET3
;
		LDA	<WORK0
		CLC
		ADC	#010H
		STA	<WORK0
		INC	<ENMWK2
		INC	<ENMWK3
		DEC	<ENMWK0
		BNE	PCHMAD
;
		RTS
;
PCH5D0		EQU	$
		BYTE	KPS01,KPS07,KPS08,KPS0D
PCH5D1		EQU	$
		BYTE	KPS44,KPS45,KPS46,KPS47,KPS05,0FFH
		BYTE	KPS48,KPS49,KPS4A,KPS4B,KPS01,0FFH
		BYTE	KPS4C,KPS4D,KPS4E,KPS4F,KPS08,0FFH
		BYTE	KPS50,KPS51,KPS52,KPS53,KPS01,0FFH
;
;
;
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	 JSL	  B2DTINT			      x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
B2DTINT		EQU	$
		LDA	!BG2COS
		BEQ	B2D100
		CMP	#012H
		BNE	B2D001
;
		JSL	>B2KMST
		JMP	B2D100
;
B2D001		EQU	$
		LDA	!HVSRFG
		BNE	TBG2INT
;
		LDA	!SCCH2
		STA	!B2SCL
;
		LDA	!SCCH2+1
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	!B2RMPT
;
B2D000		EQU	$
		JSL	>B2UNTST
;
		LDA	!BG2COS
		CMP	#002H
		BEQ	B2D010
		CMP	#023H
		BEQ	B2D010
;
		JSL	>B2VRMST
		BRA	B2D015
;
B2D010		EQU	$
		JSL	>B3KMST
;
B2D015		EQU	$
		LDA	!B2SCL
		CLC
		ADC	INTSCLD
		STA	!B2SCL
;
		LDA	!B2SCL
		AND	#00001000B
		CMP	SCRLHDT
		BNE	B2D050
;
		INC	!B2RMPT
;
B2D050		EQU	$
		DEC	!WRITCT
		BNE	B2D000
;
		LDA	#0FFH
		STA	!B2SCL
;
		LDA	!BG2COS
		CMP	#002H
		BEQ	B2D060
		CMP	#023H
		BNE	B2D100
B2D060		EQU	$
		LDA	#51H
		STA	02109H
;
B2D100		EQU	$
		RTL
;
;*********************************************************************
;*	 TBG2INT   (tate bg inital write set )			     *
;*		  (Tate BG Inital Write Set			     *
;*********************************************************************
TBG2INT		EQU	$
;
		STZ	<MUKIFG		; inital set
;
		LDA	#070H
		STA	!SCCV2
		CLC
		ADC	#08H
		STA	!B2SCL
;
		STZ	!B2RMPT
;
TB2I000		EQU	$		; inital BG set
		JSR	B2TETWRT
;
		JSL	>B2VMST1
;
		LDA	!SCCV2
		CLC
		ADC	#08H
		STA	!SCCV2
		AND	#00001000B
		BNE	TB2I200
;
		LDA	!B2RMPT
		CLC
		ADC	#010H
		STA	!B2RMPT
		AND	#0F0H
		BNE	TB2I200
;
		INC	!B2RMPT
		LDA	#0FH
		AND	!B2RMPT
		STA	!B2RMPT
TB2I200		EQU	$
;
		DEC	!WRITCT
		BNE	TB2I000
;
		STZ	!SCCV2
		STZ	!B2SCL
;
TB2I250		EQU	$
;
		RTL
;
;
;
;

;
CHRUNT		EQU	$-3
		LWORD	INWTER,SENKAN,KKUPPA,DCHIKA,CJBILL,SIROUT,SENOUT
;
		LWORD	ICEOUT,TATEUT,SAKAUT,CHIKUT,SGENUT,SABKUT,SABKUT,ASTCUT
;
		LWORD	SBKTRD,FUNEUT,SYKMUT,BONSUT,ICETIK,CHIKUT,WTRASR,KSHPUT
;
		LWORD	ASTCUT,SABKUT,CJBILL,KPSRUT,W81UNT,ASTCUT,WTRASR,SBKTRD
;
		LWORD	PLY2UT,INWTER,KPSRUT,SENKAN,KKUPPA,INWTER
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	B2UNTST				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
B2UNTST		EQU	$
;
		PHB
		PHK
		PLB
;
		LDA	!B2SCL
		AND	#00001000B
		LSR	A
		LSR	A
		LSR	A
		STA	<BGUTFG
;
		LDA	!BG2COS		; character
		ASL	A		;	unit adress point
		CLC			;	-->
		ADC	!BG2COS		;	   WORK6 (L)
		TAY			;	   WORK7 (H)
		LDA	CHRUNT+2,Y	;	   WORK8 (B)
		STA	<WORK8		;
		M16			; memory 16bit mode
		LDA	CHRUNT,Y	;
		STA	<WORK6		;
		M8			; memory 8bit mode
;
		LDX	<MUKIFG
		LDA	!B2RMPT
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		INC	A
		AND	#0FH
		TAY
		LDA	#BANK B2RMBF0
		STA	<WORKF
		M16			; memory 16bit mode
		STZ	<WORKD		; ram adress point
RMADLP		EQU	$		;	-->
		DEY			;	   WORKD (L)
		BEQ	RMADED		;	   WORKE (H)
		LDA	<WORKD		;	   WORKF (B)
		CLC			;
		ADC	#01B0H		;
		STA	<WORKD		;
		BRA	RMADLP		;
;
RMADED		EQU	$
		LDA	#001AH
		STA	<WORK0
		LDA	!B2RMPT
		AND	#00001111B
		STA	<WORK9
;
		I16			; index 16bit mode
		LDX	#0000H
;
B2NT050		EQU	$
		LDY	<WORK9
		LDA	[<WORKD],Y
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		TAY
		LDA	<BGUTFG
		AND	#00FFH
		BEQ	B2NT055
		INY
		INY
		INY
		INY
;
B2NT055		EQU	$
		LDA	[<WORK6],Y
		STA	>BG2DAT,X
		INY
		INY
		LDA	[<WORK6],Y
		STA	>BG2DAT+2,X
;
		LDA	<WORK9
		CLC
		ADC	#0010H
		STA	<WORK9
;
B2NT150		EQU	$
		INX
		INX
		INX
		INX
		DEC	<WORK0
		BPL	B2NT050
;
		MI8			; memory , index 8bit mode
;
		LDX	<MUKIFG
		LDA	!B2RMPT
		AND	#00001111B
		ASL	A
		ORA	<BGUTFG
		STA	>B2ADRSL
;
		LDA	!B2RMPT
		AND	#010H
		BEQ	B2NT200
;
		LDA	#04H
;
B2NT200		EQU	$
		ORA	#10H
		STA	>B2ADRSH
;
		LDA	!BG2COS
		CMP	#002H
		BEQ	B2NT250
		CMP	#023H
		BNE	B2NT300
;
B2NT250		EQU	$
		M16			; memory 16bit mode
;
		LDA	>B2ADRSH
		CLC
		ADC	#0040H
		STA	>B2ADRSH
;
		M8			; memory 8bit mode
;
B2NT300		EQU	$
		PLB
		RTL
;
;
;*********************************************************************
;*	 JSR	  B2TESTWRT					     *
;*********************************************************************
B2TETWRT	EQU	$
		M16			; memory 16bit mode
;
		LDA	!B2RMPT		; Adress
		AND	#00F0H		;     set
		ASL	A		;
		ASL	A		;
		CLC			;
		ADC	#1000H		;
		STA	>B2ADRSH	;
		XBA			;
		STA	>B2ADRSH	;
;
		M8			; memory 8bit mode
;
		LDA	!B2RMPT
		AND	#01H
		BEQ	B2WAC15
		LDA	>B2ADRSH
		EOR	#08H
		STA	>B2ADRSH
;
B2WAC15		EQU	$
		LDA	!SCCV2
		AND	#00001000B	; High Low ?
		BEQ	B2WAC10		; High
;
		LDA	>B2ADRSL	; Low
		CLC
		ADC	#020H
		STA	>B2ADRSL
;
B2WAC10		EQU	$
		PHB
		PHK
		PLB
;
		LDA	!BG2COS		; character
		ASL	A		;	unit adress point
		CLC			;	-->
		ADC	!BG2COS		;	   WORK6 (L)
		TAY			;	   WORK7 (H)
		LDA	CHRUNT+2,Y	;	   WORK8 (B)
		STA	<WORKE		;
		M16			; memory 16bit mode
		LDA	CHRUNT,Y	;
		STA	<WORKC		;
;
		STZ	<ENMWK0
		M8			; memory 8bit mode
		LDA	#BANK B2RMBF0
		STA	<ENMWK0+2
		LDA	!B2RMPT
		AND	#0FH
		TAY
		BEQ	TRMADED
;
TRMADLP		EQU	$
		M16			; memory 16bit mode
		LDA	<ENMWK0
		CLC
		ADC	#01B0H
		STA	<ENMWK0
		M8			; memory 8bit mode
		DEY
		BNE	TRMADLP
;
TRMADED		EQU	$
		M16			; memory 16bit mode
		LDA	!B2RMPT
		AND	#00F0H
		STA	<WORK6		; read ram buffu pointer
		STZ	<WORK8		; BGDATA index
;
		I16			; index 16bit mode
B2TES30		EQU	$
		LDY	<WORK6		; read ram buff pointer
		LDA	[<ENMWK0],Y
		STA	<WORKA		; unit no push
;
		INC	<WORK6		; read ram buffu pointer
;
		LDA	<WORKA
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		TAY
		LDX	<WORK8		; writ set ram buff pointer
		LDA	!SCCV2
		AND	#0008H		; High or Low ?
		BEQ	B2TES20		; High
;
		INY			; Low
		INY
B2TES20		EQU	$
		LDA	[<WORKC],Y
		STA	>BG2DAT,X
		INY
		INY
		INY
		INY
		LDA	[<WORKC],Y
		STA	>BG2DAT+2,X
		INX
		INX
		INX
		INX
		STX	<WORK8		; writ set ram buff pointer
		CPX	#0040H
		BCC	B2TES30
;
		MI8			; memory , index 8bit mode
		PLB
		RTS
;
;
;*********************************************************************
;*	 JSR	  BFHICLR	(BG buffer HI set sub)		     *
;*********************************************************************
BFHICLR		EQU	$
		PHA
		PHX
		PHY
		MEM16
		IDX16
		REP	#00110000B	;memory,index 16bit mode
;
		TYA
		AND	#00FFH
		ORA	#02000H		;HI address set
		TAY
;
		MEM8
		SEP	#00100000B	;memory 8bit mode
;
		LDA	#000H
		STA	[<BUFFNO],Y	;HI data set
;
		IDX8
		SEP	#00010000B	;index 8bit mode
;
		PLY
		PLX
		PLA
		RTL
;
;
;****************************************************************
;*	JSR	HOLESID		(hole side unit set)		*
;****************************************************************
HOLESID		EQU	$
		PHX
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
		M16			; memory 16bit mode
		LDA	<BUFFNO
		STA	<ENMWK0
		M8			; memory 8bit mode
;
		LDA	!UNITFG
		AND	#00FH
		TAX
		LDA	>HOLEDT,X	; hole data read
		STA	<WORK2
;
		LDY	!XYPSFG
;
		LDA	<WORK2		; hole data set
		STA	[<ENMWK0],Y
		JSR	HISET
;
		PLX
		RTL
;
;
HOLEDT		EQU	$
		BYTE	HLSD0,HLSD1,HLSD2,HLSD3
;
;
;****************************************************************
;*	JSL	ICEYUK		( ice yu-ka set )		*
;****************************************************************
ICEYUK		EQU	$
		LDY	!XYPSFG
		LDA	#IHIL1
		STA	[<BUFFNO],Y
		INY
		STA	[<BUFFNO],Y
		RTL
;
;
;****************************************************************
;*	JSL	SAKAKD		( sa-ka ka-doset )		*
;****************************************************************
SAKAKD		EQU	$
		PHB
		PHK
		PLB
;
		LDA	[<DATANO]
		STA	<WORK2
;
		M16			; memory 16bit mode
		STZ	<ENMWK3
		INC	DATANO
		LDA	<BUFFNO
		STA	<ENMWK0
		M8			; memory 8bit mode
		LDA	<BUFFNO+2
		STA	<ENMWK0+2
;
		LDA	!UNITFG
		AND	#00FH
		TAX
		CPX	#008H
		BEQ	SKKD050		; su-i-me-n ka-do ? (YES -> SKKD050)
;
		LDA	SKKDDT,X
		STA	<WORK3
		LDA	SKKDCT,X
		STA	<ENMWK3
		LDY	!XYPSFG
;
SKKD30		EQU	$
		LDA	<WORK3
		STA	[<ENMWK0],Y
		JSR	HISET
		DEC	<WORK2
		BMI	SKKD90		; set end ? (YES -> RTL)
		JSR	INC10
		BRA	SKKD30
;
SKKD050		EQU	$
		LDY	!XYPSFG
		LDA	#YM30D
		STA	[<BUFFNO],Y
		JSR	HISET
;
SKKD055		EQU	$
		JSL	>YPINCST
		LDA	[<BUFFNO],Y
		CMP	#SUIC0
		BEQ	SKKD055
		CMP	#YM20F
		BNE	SKKD90
;
		M16			; memory 16bit mode
		LDA	<BUFFNO
		STA	<ENMWK0
		M8			; memory 8bit mode
		LDA	#YM30E
		STA	[<BUFFNO],Y
		JSR	HISET
;
SKKD90		EQU	$
		PLB
		RTL
;
;
SKKDDT		EQU	$
		BYTE	YM301	; 0 left up    -
		BYTE	YM303	; 1 right up   | 45 do
		BYTE	YM304	; 2 left down  |
		BYTE	YM305	; 3 right down -
;
		BYTE	YM306	; 4 left up    -
		BYTE	YM307	; 5 right up   | 22.5 do
		BYTE	YM30A	; 6 left down  |
		BYTE	YM30B	; 7 right down -
;
		BYTE	000H	; 8
		BYTE	YM30C	; 9 ji-me-n
;
SKKDCT		EQU	$
		BYTE	00FH	; 0
		BYTE	011H	; 1
		BYTE	011H	; 2
		BYTE	00FH	; 3
		BYTE	00EH	; 4
		BYTE	012H	; 5
		BYTE	012H	; 6
		BYTE	00EH	; 7
		BYTE	000H	; 8
		BYTE	001H	; 9
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x	 JSR	  MOYOUST					     x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MOYOUD	 EQU	  $
	 BYTE	  BBET0,BBET0,ENYM0,ENYM1,BBET0,BBET0,BBET0,ENWK0
	 BYTE	  ENWK1,ENWK2,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,ENYM2,ENYM3,BBET0,BBET0,BBET0,ENWK3
	 BYTE	  BBET0,ENWK4,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,ENYM2,ENYM4,ENYM1,BBET0,BBET0,ENWK5
	 BYTE	  ENWK6,ENWK7,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,ENYM2,ENYM5,ENYM3,BBET0,BBET0,BBET0
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,ENYM0,ENYM1,BBET0
;
	 BYTE	  BBET0,BBET0,ENYM2,ENYM6,ENYM4,ENYM1,BBET0,BBET0
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,ENYM2,ENYM3,BBET0
;
	 BYTE	  BBET0,ENYM0,ENYM7,ENYM6,ENYM5,ENYM3,BBET0,BBET0
	 BYTE	  BBET0,BBET0,BBET0,BBET0,ENYM0,ENYM7,ENYM3,BBET0
;
MOYOD1	 EQU	  $
	 BYTE	  BBET0,ENHL0,ENHL1,ENHL1,ENHL2,BBET0,BBET0,ENWK0
	 BYTE	  ENWK1,ENWK2,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,ENHL3,ENHL4,ENHL4,ENHL5,BBET0,BBET0,ENWK3
	 BYTE	  BBET0,ENWK4,BBET0,BBET0,BBET0,ENHL0,ENHL1,ENHL2
;
	 BYTE	  BBET0,ENHL3,ENHL4,ENHL4,ENHL5,BBET0,BBET0,ENWK5
	 BYTE	  ENWK6,ENWK7,BBET0,BBET0,BBET0,ENHL3,ENHL4,ENHL5
;
	 BYTE	  BBET0,ENHL3,ENHL4,ENHL4,ENHL5,BBET0,BBET0,BBET0
	 BYTE	  BBET0,BBET0,BBET0,ENHL0,ENHL1,ENHL6,ENHL4,ENHL5
;
	 BYTE	  BBET0,ENHL3,ENHL4,ENHL7,ENHL1,ENHL1,ENHL2,BBET0
	 BYTE	  BBET0,BBET0,BBET0,ENHL3,ENHL4,ENHL5,ENHL4,ENHL5
;
	 BYTE	  BBET0,ENHL3,ENHL4,ENHL3,ENHL4,ENHL4,ENHL5,BBET0
	 BYTE	  BBET0,BBET0,BBET0,ENHL3,ENHL4,ENHL5,ENHL4,ENHL5
;
MOYOD2	 EQU	  $
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,ENWK0
	 BYTE	  ENWK1,ENWK2,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,ENWK3
	 BYTE	  BBET0,ENWK4,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,ENWK5
	 BYTE	  ENWK6,ENWK7,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,BBET0,BBET0,ENSB0,ENSB1,BBET0,BBET0
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,BBET0,ENSB0,ENSB2,ENSB3,ENSB5,ENSB0
	 BYTE	  ENSB1,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,ENSB0,ENSB2,ENSB2,ENSB3,ENSB4,ENSB2
	 BYTE	  ENSB3,ENSB5,BBET0,BBET0,ENSB0,ENSB1,BBET0,BBET0
;
MOYOD3	 EQU	  $
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,ENWK0
	 BYTE	  ENWK1,ENWK2,BBET0,BBET0,BBET0,ENKM0,ENKM1,BBET0
;
	 BYTE	  BBET0,BBET0,ENKM0,ENKM1,BBET0,BBET0,BBET0,ENWK3
	 BYTE	  BBET0,ENWK4,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,ENWK5
	 BYTE	  ENWK6,ENWK7,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
	 BYTE	  BBET0,BBET0,ENKM0,ENKM1,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
	 BYTE	  BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
MOYOD4	 EQU	  $
	 BYTE	  BBET0,ENHL8,ENHL9,ENHL9,ENHLA,BBET0,BBET0,ENWK0
	 BYTE	  ENWK1,ENWK2,BBET0,BBET0,BBET0,BBET0,BBET0,BBET0
;
	 BYTE	  BBET0,ENHLB,ENHLC,ENHLC,ENHLD,BBET0,BBET0,ENWK3
	 BYTE	  BBET0,ENWK4,BBET0,BBET0,BBET0,ENHL8,ENHL9,ENHLA
;
	 BYTE	  BBET0,ENHLB,ENHLC,ENHLC,ENHLD,BBET0,BBET0,ENWK5
	 BYTE	  ENWK6,ENWK7,BBET0,BBET0,BBET0,ENHLB,ENHLC,ENHLD
;
	 BYTE	  BBET0,ENHLB,ENHLC,ENHLC,ENHLD,BBET0,BBET0,BBET0
	 BYTE	  BBET0,BBET0,BBET0,ENHL8,ENHL9,ENHLE,ENHLC,ENHLD
;
	 BYTE	  BBET0,ENHLB,ENHLC,ENHLF,ENHL9,ENHL9,ENHLA,BBET0
	 BYTE	  BBET0,BBET0,BBET0,ENHLB,ENHLC,ENHLD,ENHLC,ENHLD
;
	 BYTE	  BBET0,ENHLB,ENHLC,ENHLB,ENHLC,ENHLC,ENHLD,BBET0
	 BYTE	  BBET0,BBET0,BBET0,ENHLB,ENHLC,ENHLD,ENHLC,ENHLD
;
;
MOYOAD	 EQU	  $
	 WORD	  MOYOUD
	 WORD	  MOYOD1
	 WORD	  MOYOD2
	 WORD	  MOYOD3
	 WORD	  MOYOD4
	 WORD	  MOYOUD
	 WORD	  MOYOUD
;
GAMEND	 EQU	  $
	 BYTE	  BLGM,ALGM,SBGM,KMGM,ICGM,YMGM,Y1GM
GAMEND1 EQU	$
;
MYSTD3	EQU	GAMEND1-GAMEND-1
;
MOYD0H	EQU	$
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,001H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,001H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,001H,001H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,001H,001H,001H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,001H,000H,000H
;
MOYD1H	EQU	$
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,001H,000H,000H
;
	BYTE	000H,000H,000H,001H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
MOYD2H	EQU	$
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,001H,001H,001H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,001H,001H,001H,001H,001H
	BYTE	001H,001H,000H,000H,000H,000H,000H,000H
;
MOYD3H	EQU	$
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
MOYD4H	EQU	$
	BYTE	000H,001H,001H,001H,001H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
	BYTE	000H,001H,001H,001H,001H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,001H,001H,001H
;
	BYTE	000H,001H,001H,001H,001H,000H,000H,000H
	BYTE	000H,000H,000H,000H,000H,001H,001H,001H
;
	BYTE	000H,001H,001H,001H,001H,000H,000H,000H
	BYTE	000H,000H,000H,001H,001H,001H,001H,001H
;
	BYTE	000H,001H,001H,001H,001H,001H,001H,000H
	BYTE	000H,000H,000H,001H,001H,001H,001H,001H
;
	BYTE	000H,001H,001H,001H,001H,001H,001H,000H
	BYTE	000H,000H,000H,001H,001H,001H,001H,001H
;
MOYADH	EQU	$
	WORD	MOYD0H
	WORD	MOYD1H
	WORD	MOYD2H
	WORD	MOYD3H
	WORD	MOYD4H
	WORD	MOYD0H
	WORD	MOYD0H
;
;
;
;****************************************************************
;*								*
;*	slot BG2 address data					*
;*								*
;****************************************************************
SLTAD1		EQU	$			; ki-no-ko
		WORD	01083H,010E0H,0110FH,011E5H,011FDH,0126FH
;
SLTAD2		EQU	$			; ha-na
		WORD	010C7H,010D5H,011B2H,01221H,0129AH
;
SLTAD3		EQU	$			; ho-si
		WORD	0108BH,0109AH,0113DH,01163H,0118BH,01237H,01268H
;
SLTAD4		EQU	$			; ki-no-ko na-si
;
;
;****************************************************************
;*		H-DMA  data					*
;****************************************************************
;
YRYRDT		EQU	$
		WORD	00008H,00007H,00007H,00006H,00006H,00006H,00006H,00006H
		WORD	00006H,00006H,00006H,00006H,00006H,00006H,00007H,00007H
		WORD	00008H,00008H,00008H,00009H,00009H,00009H,00009H,00009H
		WORD	00009H,00009H,00009H,00009H,00009H,00009H,00008H,00008H
;
		WORD	00008H,00007H,00007H,00006H,00006H,00006H,00006H,00006H
		WORD	00006H,00006H,00006H,00006H,00006H,00006H,00007H,00007H
		WORD	00008H,00008H,00008H,00009H,00009H,00009H,00009H,00009H
		WORD	00009H,00009H,00009H,00009H,00009H,00009H,00008H,00008H
;
		WORD	00008H,00007H,00007H,00006H,00006H,00006H,00006H,00006H
		WORD	00006H,00006H,00006H,00006H,00006H,00006H,00007H,00007H
		WORD	00008H,00008H,00008H,00009H,00009H,00009H,00009H,00009H
		WORD	00009H,00009H,00009H,00009H,00009H,00009H,00008H,00008H
;
		WORD	00008H,00007H,00007H,00006H,00006H,00006H,00006H,00006H
		WORD	00006H,00006H,00006H,00006H,00006H,00006H,00007H,00007H
		WORD	00008H,00008H,00008H,00009H,00009H,00009H,00009H,00009H
		WORD	00009H,00009H,00009H,00009H,00009H,00009H,00008H,00008H
;
;
;
		END
;
;
