;
		INCLUDE	zel_ram.asm
;
;-----------------------------------------------------------------------
;
;		mdrQydkc`|R		1991.11.14(THU)
;
;------------------------------------------------------------------------
;
		ORG	0ED460H
;
;=============================================== (zel_char) =============
		GLB	GCGCHNG,DJNCGDT
;
		GLB	NKCGSET,NKCGST0,NKCGST1,RGBRSET
;=============================================== (zel_char) =============
		EXT	GDCGST,GDCGST1,GDCGST2,KOUKAST,MSCGST1,MSCGST2
;
		EXT	CORGENE,CGLPT3,CGLPT4,CGLPT8,PLAYCG,KENOBJ,TATEOBJ
;========================================================================
;
		EXTEND
		MEM8
		IDX8
;
;
;
;
;************************************************************************
;*		Danjyon change color data				*
;************************************************************************
DJNCGDT		EQU	$		; danjyon basic color data
;			 dj  bo  e1  e2
		BYTE	00*2,00,03H,01H		; 0 : normal shiro
		BYTE	01*2,00,03H,01H		; 1 : shiro chika
		BYTE	02*2,00,0AH,01H		; 2 : normal minka
		BYTE	03*2,00,01H,07H		; 3 : shinden (boss)
		BYTE	05*2,02,02H,07H		; 4 : sabaku-shinden (boss)
		BYTE	02*2,04,03H,0AH		; 5 : kusuri-baba mise
		BYTE	06*2,05,08H,14H		; 6 : yama no tou
		BYTE	07*2,00,03H,0AH		; 7 : doukutsu
		BYTE	01*2,00,0FH,14H		; 8 : hokora (boss)
		BYTE	05*2,02,00H,07H		; 9 : sabaku-shinden
		BYTE	01*2,00,0FH,0CH		; A : ura-hokora-mizu
		BYTE	03*2,00,06H,07H		; B : shinden
		BYTE	00*2,00,0EH,12H		; C : shisai-room
		BYTE	09*2,05,05H,0BH		; D : ura-mori danjyon
		BYTE	09*2,00,02H,0CH		; E :                  (boss)
		BYTE	08*2,05,0AH,07H		; F : ura-shinden
		BYTE	08*2,00,10H,0CH		;10 : ura-shinden(boss)
		BYTE	11*2,07,02H,07H		;11 : ura-numa danjyon
		BYTE	11*2,00,07H,0FH		;12 :                  (boss)
		BYTE	04*2,00,04H,0CH		;13 : ura-ice danjyon
		BYTE	04*2,00,04H,09H		;14 :                 (boss)
		BYTE	02*2,00,03H,01H		;15 : link-house
		BYTE	10*2,00,04H,04H		;16 : ura-machi
		BYTE	10*2,00,14H,0CH		;17 :           (boss)
		BYTE	12*2,05,07H,0BH		;18 : ura-kame-iwa
		BYTE	12*2,06,10H,0CH		;19 :              (boss)
		BYTE	13*2,05,08H,14H		;1A : ura-tower
		BYTE	13*2,02,00H,07H		;1B :           (boss)
		BYTE	03*2,00,03H,0AH		;1C : shinden-yoko ojiji
		BYTE	14*2,00,03H,01H		;1D : chapel
		BYTE	15*2,00,0BH,11H		;1E : ura-minka (kaji-ya)
		BYTE	02*2,00,0BH,11H		;1F : bomb-ya
		BYTE	07*2,00,00H,02H		;20 : devil-room
		BYTE	16*2,08,13H,0DH		;21 : ganon
		BYTE	05*2,00,03H,0AH		;22 : piramido megami
		BYTE	10*2,00,04H,04H		;23 : ura-machi (nezumi)
		BYTE	13*2,02,02H,07H		;24 : ura-yama-tower (4F)
		BYTE	13*2,10,00H,00H		;25 :                (5F)
		BYTE	00*2,00,03H,02H		;26 : shiro(2F)
		BYTE	07*2,00,03H,07H		;27 : mane-mane
		BYTE	13*2,05,05H,0BH		;28 : ura-yama-tower (B1)
;
;
;
;
; 
;************************************************************************
;*		Ground CG. change			(GCGCHNG)	*
;*		[in]	(A)	<-- set pointer				*
;************************************************************************
CGCGDT 		EQU	$
		HEX	000,0FF,007,0FF		; 0
;
		HEX	000,001,007,0FF		; 1
		HEX	000,002,007,0FF		; 2
		HEX	000,003,007,0FF		; 3
		HEX	000,004,007,0FF		; 4
		HEX	000,005,007,0FF		; 5
		HEX	000,006,007,0FF		; 6
		HEX	007,006,005,0FF		; 7
		HEX	000,008,007,0FF		; 8
		HEX	000,009,007,0FF		; 9
		HEX	000,00A,007,0FF		: A
;
		HEX	000,00B,007,0FF		: B
		HEX	000,0FF,007,0FF		: C
		HEX	000,0FF,007,0FF		: D
		HEX	003,004,007,0FF		: E
		HEX	004,004,003,0FF		: F
;
;
		HEX	010,0FF,006,0FF		;10
;
		HEX	010,001,006,0FF		;11
		HEX	010,011,006,0FF		;12
		HEX	010,003,006,0FF		;13
		HEX	010,004,006,0FF		;14
		HEX	010,005,006,0FF		;15
		HEX	010,006,006,0FF		;16
		HEX	012,013,004,0FF		;17
		HEX	012,005,004,0FF		;18
		HEX	010,009,006,0FF		;19
		HEX	010,00B,006,0FF		;1A
		HEX	010,00C,006,0FF		;1B
		HEX	010,00D,006,0FF		;1C
		HEX	010,00E,006,0FF		;1D
		HEX	010,00F,006,0FF		;1E
;
;
CGCGD1 		EQU	$
		HEX	0FF,0FF			; 0
;
		HEX	003,00A			; 1
		HEX	003,006			; 2
		HEX	003,001			; 3
		HEX	000,002			; 4
		HEX	003,00E			; 5
		HEX	003,002			; 6
		HEX	013,001			; 7
		HEX	00B,00C			; 8
		HEX	011,001			; 9
		HEX	007,005			; A
		HEX	011,000			; B
		HEX	009,00B			; C
		HEX	00F,005			; D
		HEX	003,005			; E
		HEX	003,007			; F
		HEX	00F,002			;10
		HEX	00A,002			;11
		HEX	005,001			;12
		HEX	00C,00E			;13
;
;
GCGCHNG		EQU	$
		ASL	A
		ASL	A
		TAX
		STZ	!CGSTPT+1
;
		LDA	>CGCGDT+0,X
		BMI	CGCG10		; set ok ?
;					; yes
		STA	!GNDBGC1
CGCG10		EQU	$
		LDA	>CGCGDT+1,X
		BMI	CGCG20		; set ok ?
;					; yes
		STA	!GNDBGC2
CGCG20		EQU	$
		LDA	>CGCGDT+2,X
		BMI	CGCG30		; set ok ?
;					; yes
		STA	!KOKBGC
CGCG30		EQU	$
		LDA	<WORK0
		ASL	A
		TAX
		LDA	>CGCGD1+0,X
		BMI	CGCG40		; set ok ?
;					; yes
		STA	!EYOJC0
CGCG40		EQU	$
		LDA	>CGCGD1+1,X
		BMI	CGCG50		; set ok ?
;					; yes
		STA	!EYOJC1
CGCG50		EQU	$
		JSL	>GDCGST1
		JSL	>GDCGST2
		JSL	>KOUKAST
;
		JSL	>MSCGST1
		JSL	>MSCGST2
		RTL
;
;
;
;
;
;*********************************************************************
;*	 siro & nuki color set sub				     *
;*	 X -----  0:nuki  1:siro				     *
;*********************************************************************
NKCGSET		EQU	$
		MEM16
	 	REP	#00100000B
;
	 	LDA	#00000H
NKCST40		EQU	$
		STA	>CGWORK+000H
;// 03.06.05 //		STA	>CGWORK+020H
		STA	>CGWORK+040H
;// 03.06.05 //		STA	>CGWORK+060H
;// 03.06.05 //		STA	>CGWORK+080H
;// 03.06.05 //		STA	>CGWORK+0A0H
;// 03.06.05 //		STA	>CGWORK+0C0H
;// 03.06.05 //		STA	>CGWORK+0E0H
;// 03.06.05 //		STA	>CGWORK+100H
;// 03.06.05 //		STA	>CGWORK+120H
;// 03.06.05 //		STA	>CGWORK+140H
;// 03.06.05 //		STA	>CGWORK+160H
;// 03.06.05 //		STA	>CGWORK+180H
;// 03.06.05 //		STA	>CGWORK+1A0H
;// 03.06.05 //		STA	>CGWORK+1C0H
;// 03.06.05 //		STA	>CGWORK+1E0H
NKCST80		EQU	$
		STA	>CGRAM+000H
;// 03.06.05 //		STA	>CGRAM+020H
		STA	>CGRAM+040H
;// 03.06.05 //		STA	>CGRAM+060H
;// 03.06.05 //		STA	>CGRAM+080H
;// 03.06.05 //		STA	>CGRAM+0A0H
;// 03.06.05 //		STA	>CGRAM+0C0H
;// 03.06.05 //		STA	>CGRAM+0E0H
;// 03.06.05 //		STA	>CGRAM+100H
;// 03.06.05 //		STA	>CGRAM+120H
;// 03.06.05 //		STA	>CGRAM+140H
;// 03.06.05 //		STA	>CGRAM+160H
;// 03.06.05 //		STA	>CGRAM+180H
;// 03.06.05 //		STA	>CGRAM+1A0H
;// 03.06.05 //		STA	>CGRAM+1C0H
;// 03.06.05 //		STA	>CGRAM+1E0H
;
		MEM8 
		IDX8 
		SEP	#00110000B
RGBRSET		EQU	$
		LDA	#00100000B
		STA	<WD2132R
		LDA	#01000000B
		STA	<WD2132G
		LDA	#10000000B
		STA	<WD2132B
		RTL
;
;
;
;*********************************************************************
;*	 Ground nuki color set sub				     *
;*	 X -----  0:nuki  1:siro				     *
;*********************************************************************
;// 03.10.24 //NKCGDTR		EQU	$
;// 03.10.24 //		BYTE	005H+020H,007H+020H,013H+020H
;// 03.10.24 //NKCGDTG		EQU	$
;// 03.10.24 //		BYTE	00FH+040H,014H+040H,00FH+040H
;// 03.10.24 //NKCGDTB		EQU	$
;// 03.10.24 //		BYTE	005H+080H,007H+080H,009H+080H
;
;
NKCGST0		EQU	$ 
;// 03.10.24 //		MEM16
;// 03.10.24 //		IDX16
;// 03.10.24 //		REP	#00110000B
;// 03.10.24 //;
;// 03.10.24 //		LDX	#02669H
;// 03.10.24 //		LDA	<MPDTNO
;// 03.10.24 //		CMP	#00080H
;// 03.10.24 //		BCC	NKCS020		; spot ?
;// 03.10.24 //;					; yes
;// 03.10.24 //		LDA	<RMXYCT
;// 03.10.24 //		CMP	#00183H
;// 03.10.24 //		BEQ	NKCS010		; taki boss ?
;// 03.10.24 //;					; no
;// 03.10.24 //		CMP	#00182H
;// 03.10.24 //		BEQ	NKCS010		; taki ?
;// 03.10.24 //;					; no
;// 03.10.24 //		CMP	#00180H
;// 03.10.24 //		BNE	NKCS040		; mori-spot ?
;// 03.10.24 //;					; no
;// 03.10.24 //NKCS010		EQU	$
;// 03.10.24 //		LDX	#019C6H
;// 03.10.24 //		BRA	NKCS040
;// 03.10.24 //;
;// 03.10.24 //NKCS020		EQU	$
;// 03.10.24 //		LDX	#02669H
;// 03.10.24 //		LDA	<MPDTNO
;// 03.10.24 //		AND	#00040H
;// 03.10.24 //		BEQ	NKCS040		; omote ?
;// 03.10.24 //;					; no
;// 03.10.24 //		LDX	#02A32H
;// 03.10.24 //NKCS040		EQU	$
;// 03.10.24 //		TXA
		JSR	NKCGGT		; nuki color get
		BRA	NKCST40
;
;// 03.05.16 //		STX	<WORK0
;// 03.05.16 //	 LDY	  #0000FH
;// 03.05.16 //	 LDX	  #00000H
;// 03.05.16 //NKCS080  EQU	  $ 
;// 03.05.16 //		LDA	<WORK0
;// 03.05.16 //;// 03.04.17 //		LDA	#00000H
;// 03.05.16 //	 STA	  >CGRAM+000H,X
;// 03.05.16 //	 STA	  >CGWORK+000H,X
;// 03.05.16 //	 TXA
;// 03.05.16 //	 CLC
;// 03.05.16 //	 ADC	  #020H 
;// 03.05.16 //	 TAX
;// 03.05.16 //	 DEY
;// 03.05.16 //	 BPL	  NKCS080 
;// 03.05.16 //; 
;// 03.05.16 //	 MEM8 
;// 03.05.16 //	 IDX8 
;// 03.05.16 //	 SEP	  #00110000B
;// 03.05.16 //;
;// 03.05.16 //		LDA	#00100000B
;// 03.05.16 //;// 03.04.17 //		LDX	<WORK0
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTR,X
;// 03.05.16 //		STA	<WD2132R
;// 03.05.16 //		LDA	#01000000B
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTG,X
;// 03.05.16 //		STA	<WD2132G
;// 03.05.16 //		LDA	#10000000B
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTB,X
;// 03.05.16 //		STA	<WD2132B
;// 03.05.16 //	 RTL
; 
;
;
; 
;*********************************************************************
;*	 Ground nuki color set sub				     *
;*	 X -----  0:nuki  1:siro				     *
;*********************************************************************
NKCGST1		EQU	  $ 
;// 03.10.24 //		MEM16
;// 03.10.24 //		IDX16
;// 03.10.24 //		REP	  #00110000B
;// 03.10.24 //;
;// 03.10.24 //		LDX	#02669H
;// 03.10.24 //		LDA	<MPDTNO
;// 03.10.24 //		CMP	#00080H
;// 03.10.24 //		BCC	NKCS120		; spot ?
;// 03.10.24 //;					; yes
;// 03.10.24 //		LDA	<RMXYCT
;// 03.10.24 //		CMP	#00183H
;// 03.10.24 //		BEQ	NKCS110		; taki boss ?
;// 03.10.24 //;					; no
;// 03.10.24 //		CMP	#00182H
;// 03.10.24 //		BEQ	NKCS110		; taki ?
;// 03.10.24 //;					; no
;// 03.10.24 //		CMP	#00180H
;// 03.10.24 //		BNE	NKCS140		; mori-spot ?
;// 03.10.24 //;					; no
;// 03.10.24 //NKCS110		EQU	$
;// 03.10.24 //		LDX	#019C6H
;// 03.10.24 //		BRA	NKCS140
;// 03.10.24 //;
;// 03.10.24 //NKCS120		EQU	$
;// 03.10.24 //		LDX	#02669H
;// 03.10.24 //		LDA	<MPDTNO
;// 03.10.24 //		AND	#00040H
;// 03.10.24 //		BEQ	NKCS140		; omote ?
;// 03.10.24 //;					; no
;// 03.10.24 //		LDX	#02A32H
;// 03.10.24 //NKCS140		EQU	$
;// 03.10.24 //		TXA
		JSR	NKCGGT		; nuki color get
;// 03.10.24 //		JMP	NKCST80
		BRA	NKCST80
;
;// 03.05.30 //		STA	>CGRAM+000H
;// 03.05.30 //		STA	>CGRAM+020H
;// 03.05.30 //		STA	>CGRAM+040H
;// 03.05.30 //		STA	>CGRAM+060H
;// 03.05.30 //		STA	>CGRAM+080H
;// 03.05.30 //		STA	>CGRAM+0A0H
;// 03.05.30 //		STA	>CGRAM+0C0H
;// 03.05.30 //		STA	>CGRAM+0E0H
;// 03.05.30 //		STA	>CGRAM+100H
;// 03.05.30 //		STA	>CGRAM+120H
;// 03.05.30 //		STA	>CGRAM+140H
;// 03.05.30 //		STA	>CGRAM+160H
;// 03.05.30 //		STA	>CGRAM+180H
;// 03.05.30 //		STA	>CGRAM+1A0H
;// 03.05.30 //		STA	>CGRAM+1C0H
;// 03.05.30 //		STA	>CGRAM+1E0H
;// 03.05.30 //; 
;// 03.05.30 //		MEM8
;// 03.05.30 //		IDX8
;// 03.05.30 //		SEP	#00110000B
;// 03.05.30 //;
;// 03.05.30 //		LDA	#00100000B
;// 03.05.30 //		STA	<WD2132R
;// 03.05.30 //		LDA	#01000000B
;// 03.05.30 //		STA	<WD2132G
;// 03.05.30 //		LDA	#10000000B
;// 03.05.30 //		STA	<WD2132B
;// 03.05.30 //		RTL
;
;
;// 03.05.16 //		STX	<WORK0
;// 03.05.16 //	 LDY	  #0000FH
;// 03.05.16 //	 LDX	  #00000H
;// 03.05.16 //NKCS180  EQU	  $ 
;// 03.05.16 //		LDA	<WORK0
;// 03.05.16 //;// 03.04.17 //		LDA	#00000H
;// 03.05.16 //	 STA	  >CGRAM+000H,X
;// 03.05.16 //	 TXA
;// 03.05.16 //	 CLC
;// 03.05.16 //	 ADC	  #020H 
;// 03.05.16 //	 TAX
;// 03.05.16 //	 DEY
;// 03.05.16 //	 BPL	  NKCS180 
;// 03.05.16 //; 
;// 03.05.16 //	 MEM8 
;// 03.05.16 //	 IDX8 
;// 03.05.16 //	 SEP	  #00110000B
;// 03.05.16 //;
;// 03.05.16 //		LDA	#00100000B
;// 03.05.16 //;// 03.04.17 //		LDX	<WORK0
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTR,X
;// 03.05.16 //		STA	<WD2132R
;// 03.05.16 //		LDA	#01000000B
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTG,X
;// 03.05.16 //		STA	<WD2132G
;// 03.05.16 //		LDA	#10000000B
;// 03.05.16 //;// 03.04.17 //		LDA	>NKCGDTB,X
;// 03.05.16 //		STA	<WD2132B
;// 03.05.16 //	 RTL
;
;
;
;
; 
;************************************************************************
;*	 Nuki color get					(NKCGGT)	*
;************************************************************************
NKCGGT		EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	#02669H
		LDA	<MPDTNO
		CMP	#00080H
		BCC	NKCGT20		; spot ?
;					; yes
		LDA	<RMXYCT
		CMP	#00183H
		BEQ	NKCGT10		; taki boss ?
;					; no
		CMP	#00182H
		BEQ	NKCGT10		; taki ?
;					; no
		CMP	#00180H
		BNE	NKCGT40		; mori-spot ?
;					; no
NKCGT10		EQU	$
		LDX	#019C6H
		BRA	NKCGT40
;
NKCGT20		EQU	$
		LDX	#02669H
		LDA	<MPDTNO
		AND	#00040H
		BEQ	NKCGT40		; omote ?
;					; no
		LDX	#02A32H
NKCGT40		EQU	$
		TXA
		RTS
;
;
;
; 
; 
;========================================================================
;========================================================================
;========================================================================
;=============================================== (zel_char) =============
		GLB	PWTRCGS0,PWTRCGS1,PLCGCN0,PLCGCN1,PLCGCN2
		GLB	PWTRCGS2,PWTRCGS3,THCGCN0,THCGCN1,THCGCN2
;=============================================== (zel_char) =============
		EXT	GDCGST,GDCGST1,GDCGST2,KOUKAST,MSCGST1,MSCGST2
;
		EXT	CORGENE,CGLPT3,CGLPT4,CGLPT8,PLAYCG,KENOBJ,TATEOBJ
;========================================================================
;========================================================================
;========================================================================
;
		MEM8
		IDX8
;
;
;
;
;
;
;************************************************************************
;*		Player water CG. set			(PWTRCGS0)	*
;************************************************************************
PWTRCGS0	EQU	$
		LDA	#00000001B
		STA	<PLBGCKF	; player BG.1 check
PWTRCGS2	EQU	$
		LDA	#00000001B
		STA	!PCGCKF
PWTRS00		EQU	$
		MEM16
		REP	#00100001B	; memory 16bit mode & CLC
;
		LDX	#000H
PWTRS40		EQU	$
		LDA	>CGRAM+100H,X
		PHA			; (A) push
		LDA	>CGRAM+1E0H,X
		STA	>CGRAM+100H,X
		STA	>CGWORK+100H,X
		PLA			; (A) pull
		STA	>CGRAM+1E0H,X
		STA	>CGWORK+1E0H,X
;
		LDA	>CGRAM+110H,X
		PHA			; (A) push
		LDA	>CGRAM+1F0H,X
		STA	>CGRAM+110H,X
		STA	>CGWORK+110H,X
		PLA			; (A) pull
		STA	>CGRAM+1F0H,X
		STA	>CGWORK+1F0H,X
;
		LDA	>CGRAM+1B0H,X
		PHA			; (A) push
		LDA	>CGRAM+170H,X
		STA	>CGRAM+1B0H,X
		STA	>CGWORK+1B0H,X
		PLA			; (A) pull
		STA	>CGRAM+170H,X
		STA	>CGWORK+170H,X
;
		INX
		INX
		CPX	#010H
		BNE	PWTRS40		; end ?
;					; yes
;// 02.10.30 //		LDA	#00200H
;// 02.10.30 //		STA	!CGSTPT		; (CGWORK) set
;// 02.10.30 //;
;// 02.10.30 //		LDX	PLYOJC
;// 02.10.30 //		LDA	>CGLPT7,X 
;// 02.10.30 //		AND	#000FFH
;// 02.10.30 //;///////		CLC
;// 02.10.30 //		ADC	#PLAYCG
;// 02.10.30 //		STA	<WORK0 
;// 02.10.30 //;
;// 02.10.30 //		IDX16
;// 02.10.30 //		REP	#00010000B	; index 16bit mode
;// 02.10.30 //;
;// 02.10.30 //		LDA	#00102H		;set point
;// 02.10.30 //		LDX	#00006H		;yoko kosu
;// 02.10.30 //		JSR	CHGSUB2 
;// 02.10.30 //;
;// 02.10.30 //		IDX8 
;// 02.10.30 //		SEP	#00010000B	; index 8bit mode
;// 02.10.30 //;
;// 02.10.30 //		LDX	PLYOJC1
;// 02.10.30 //		LDA	>CGLPT8,X 
;// 02.10.30 //		AND	#000FFH
;// 02.10.30 //		CLC
;// 02.10.30 //		ADC	#PLAYCG1
;// 02.10.30 //		STA	<WORK0 
;// 02.10.30 //;
;// 02.10.30 //		IDX16
;// 02.10.30 //		REP	#00010000B	; index 16bit mode
;// 02.10.30 //;
;// 02.10.30 //		LDA	#00110H		;set point
;// 02.10.30 //		LDX	#00007H		;yoko kosu
;// 02.10.30 //		JSR	CHGSUB2
;// 02.10.30 //;
;// 02.10.30 //		MEM8
;// 02.10.30 //		IDX8
;// 02.10.30 //		SEP	#00110000B	; memory,index 8bit mode
;// 02.10.30 //;
;// 02.10.30 //		LDX	!DJNNO
;// 02.10.30 //		LDA	>DJDTBL,X
;// 02.10.30 //		ORA	#00000001B
;// 02.10.30 //		STA	>DJDTBL,X	;
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		INC	<CGVMAF		; CG. write
		RTL
;
;
;
;************************************************************************
;*		Player water CG. reset			(PWTRCGS1)	*
;************************************************************************
PWTRCGS1	EQU	$
		STZ	<PLBGCKF	; player BG.2 check
PWTRCGS3	EQU	$
		STZ	!PCGCKF
		BRA	PWTRS00
;
;// 02.10.30 //		MEM16
;// 02.10.30 //		REP	#00100001B	; memory 16bit mode & CLC
;// 02.10.30 //;
;// 02.10.30 //		LDA	#00200H
;// 02.10.30 //		STA	!CGSTPT		; (CGWORK) set
;// 02.10.30 //;
;// 02.10.30 //		LDX	BOBOJC
;// 02.10.30 //		LDA	>CGLPT7,X 
;// 02.10.30 //		AND	#000FFH
;// 02.10.30 //;///////		CLC
;// 02.10.30 //		ADC	#DANJOBG
;// 02.10.30 //		STA	<WORK0 
;// 02.10.30 //;
;// 02.10.30 //		IDX16
;// 02.10.30 //		REP	#00010000B	; index 16bit mode
;// 02.10.30 //;
;// 02.10.30 //		LDA	#00102H
;// 02.10.30 //		LDX	#00006H
;// 02.10.30 //		JSR	CHGSUB2
;// 02.10.30 //;
;// 02.10.30 //		MEM8
;// 02.10.30 //		IDX8
;// 02.10.30 //		SEP	#00110000B	; memory,index 16bit mode
;// 02.10.30 //;
;// 02.10.30 //		STZ	<PLBGCKF	; player BG.2 check
;// 02.10.30 //;
;// 02.10.30 //		INC	<CGVMAF		; CG. write
;// 02.10.30 //		RTL
;
;
;
; 
;************************************************************************
;*		Player CG. change			(PLCGCN0)	*
;************************************************************************
PLCGCN0		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	>ITMTBL6
		STA	<WORKC
;
		LDA	>ITMTBL8
		AND	#000FFH
		BRA	PLCGC000
; 
;************************************************************************
;*		Player CG. change			(PLCGCN1)	*
;************************************************************************
PLCGCN1		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00202H
		STA	<WORKC
		LDA	#00404H
		BRA	PLCGC000
; 
;************************************************************************
;*		Player CG. change			(PLCGCN1)	*
;************************************************************************
PLCGCN2		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	>ITMTBL6
		STA	<WORKC
		LDA	#00303H
PLCGC000	EQU	$
		STA	<WORKE
;
		LDA	#BANK CORGENE
		STA	<WORK2
;
		LDX	<WORKC
		LDA	>CGLPT3,X
		AND	#000FFH
		CLC
		ADC	#KENOBJ
		IDX16
		REP	#00010000B	; index 16bit mode
		LDX	#001B2H		; set point
		LDY	#00002H		; yoko kosuu
		JSR	PLCG200		; ken CG. set
;
		IDX8
		SEP	#00010000B	; index 8bit mode
		LDX	<WORKD
		LDA	>CGLPT4,X
		AND	#000FFH
		CLC
		ADC	#TATEOBJ
		IDX16
		REP	#00010000B	; index 16bit mode
		LDX	#001B8H		; set point
		LDY	#00003H		; yoko kosuu
		JSR	PLCG200		; tate CG. set
;
		IDX8
		SEP	#00010000B	; index 8bit mode
		LDX	<WORKE
		LDA	>CGLPT8,X
		AND	#000FFH
		ASL	A
		CLC
		ADC	#PLAYCG
		IDX16
		REP	#00010000B	; index 16bit mode
		LDX	#001E2H		; set point
		LDY	#0000EH		; yoko kosuu
		JSR	PLCG200		; player CG. set - 0
;
		MEM8
		IDX8
		SEP	#00110000B	; memory 16bit mode
;
		INC	<CGVMAF		; CG. change
		RTL
;
;
		MEM16
		IDX16
PLCG200		EQU	$
		STA	<WORK0
PLCG220		EQU	$
		LDA	[<WORK0]
		STA	>CGRAM,X
		STA	>CGWORK,X
		INC	<WORK0
		INC	<WORK0
		INX
		INX
		DEY
		BPL	PLCG220		; set end ?
;					; yes
		RTS
;
; 
;
;
		MEM8
		IDX8
;************************************************************************
;*		Thunder CG. change			(THCGCN0)	*
;************************************************************************
THCGCN0		EQU	$
		MEM16
		REP	#00100000B	; index 16bit mode
;
		LDX	#000H
THCG020		EQU	$
		LDA	>CGRAM+040H,X
		JSR	THCG400
		STA	>CGWORK+040H,X
		LDA	>CGRAM+050H,X
		JSR	THCG400
		STA	>CGWORK+050H,X
		LDA	>CGRAM+060H,X
		JSR	THCG400
		STA	>CGWORK+060H,X
		LDA	>CGRAM+070H,X
		JSR	THCG400
		STA	>CGWORK+070H,X
		LDA	>CGRAM+080H,X
		JSR	THCG400
		STA	>CGWORK+080H,X
		LDA	>CGRAM+090H,X
		JSR	THCG400
		STA	>CGWORK+090H,X
		LDA	>CGRAM+0A0H,X
		JSR	THCG400
		STA	>CGWORK+0A0H,X
		LDA	>CGRAM+0B0H,X
		JSR	THCG400
		STA	>CGWORK+0B0H,X
		LDA	>CGRAM+0C0H,X
		JSR	THCG400
		STA	>CGWORK+0C0H,X
		LDA	>CGRAM+0D0H,X
		JSR	THCG400
		STA	>CGWORK+0D0H,X
		LDA	>CGRAM+0E0H,X
		JSR	THCG400
		STA	>CGWORK+0E0H,X
		LDA	>CGRAM+0F0H,X
		JSR	THCG400
		STA	>CGWORK+0F0H,X
;
;// 03.06.10 //		LDA	>CGRAM+160H,X
;// 03.06.10 //		STA	>CGWORK+160H,X
;// 03.06.10 //		LDA	>CGRAM+180H,X
;// 03.06.10 //		STA	>CGWORK+180H,X
;// 03.06.10 //		LDA	>CGRAM+1A0H,X
;// 03.06.10 //		STA	>CGWORK+1A0H,X
;// 03.06.10 //		LDA	>CGRAM+1F0H,X
;// 03.06.10 //		STA	>CGWORK+1F0H,X
		INX
		INX
		CPX	#010H
		BEQ	THCG040		; BG. CG. set end ?
;					; no
		JMP	THCG020
;
THCG040		EQU	$
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDA	>CGWORK+040H
		TAY
		LDA	>CGRAM+000H
		BNE	THCG050		;
;					;
		TAY
THCG050		EQU	$
		TYA
		STA	>CGWORK+000H
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 16bit mode
;
;// 03.10.01 //		LDA	<GMMODE
;// 03.10.01 //		BNE	THCG080		; ground ?
;// 03.10.01 //;					; yes
;// 03.10.01 //		MEM16
;// 03.10.01 //		IDX16
;// 03.10.01 //		REP	#00110000B	; memory,index 16bit mode
;// 03.10.01 //;
;// 03.10.01 //		LDA	#04020H
;// 03.10.01 //		STA	<WD2132R
;// 03.10.01 //		LDA	#08040H
;// 03.10.01 //		STA	<WD2132G
;// 03.10.01 //;
;// 03.10.01 //		LDX	#04F33H
;// 03.10.01 //		LDY	#0894FH
;// 03.10.01 //		LDA	<MPDTNO
;// 03.10.01 //		BEQ	THCG070		; mori ?
;// 03.10.01 //;					; no
;// 03.10.01 //		CMP	#00040H
;// 03.10.01 //		BEQ	THCG070		; ura-mori ?
;// 03.10.01 //;					; no
;// 03.10.01 //		CMP	#0005BH
;// 03.10.01 //		BEQ	THCG060		; piramido ?
;// 03.10.01 //;					; no
;// 03.10.01 //		LDX	#04C26H
;// 03.10.01 //		LDY	#08C4CH
;// 03.10.01 //		CMP	#00003H
;// 03.10.01 //		BEQ	THCG060		; yama ?
;// 03.10.01 //;					; no
;// 03.10.01 //		CMP	#00005H
;// 03.10.01 //		BEQ	THCG060		; yama ?
;// 03.10.01 //;					; no
;// 03.10.01 //		CMP	#00007H
;// 03.10.01 //		BEQ	THCG060		; yama ?
;// 03.10.01 //;					; no
;// 03.10.01 //		LDX	#04A26H
;// 03.10.01 //		LDY	#0874AH
;// 03.10.01 //		CMP	#00043H
;// 03.10.01 //		BEQ	THCG060		; yama ?
;// 03.10.01 //;					; no
;// 03.10.01 //		CMP	#00045H
;// 03.10.01 //		BEQ	THCG060		; yama ?
;// 03.10.01 //;					; no
;// 03.10.01 //		CMP	#00047H
;// 03.10.01 //		BNE	THCG070		; yama ?
;// 03.10.01 //;					; no
;// 03.10.01 //THCG060		EQU	$
;// 03.10.01 //		STX	<WD2132R
;// 03.10.01 //		STY	<WD2132G
;// 03.10.01 //THCG070		EQU	$
;// 03.10.01 //		MEM8
;// 03.10.01 //		IDX8
;// 03.10.01 //		SEP	#00110000B	; memory,index 8bit mode
;// 03.10.01 //;
;// 03.10.01 //		LDA	<WD2132R
;// 03.10.01 //		CLC
;// 03.10.01 //		ADC	#00001110B
;// 03.10.01 //		STA	<WD2132R
;// 03.10.01 //		LDA	<WD2132G
;// 03.10.01 //		CLC
;// 03.10.01 //		ADC	#00001110B
;// 03.10.01 //		STA	<WD2132G
;// 03.10.01 //		LDA	<WD2132B
;// 03.10.01 //		CLC
;// 03.10.01 //		ADC	#00001110B
;// 03.10.01 //		STA	<WD2132B
;// 03.10.01 //THCG080		EQU	$
		RTL
;
;
		MEM16
THCG400		EQU	$
		STA	<WORK0
		AND	#0000000000011111B
		CLC
		ADC	#0000000000001110B
		CMP	#0000000000011111B
		BCC	THCG420		;
;					;
		LDA	#0000000000011111B
THCG420		EQU	$
		STA	<WORK2
;
		LDA	<WORK0
		AND	#0000001111100000B
		CLC
		ADC	#0000000111000000B
		CMP	#0000001111100000B
		BCC	THCG440		;
;					;
		LDA	#0000001111100000B
THCG440		EQU	$
		STA	<WORK4
;
		LDA	<WORK0
		AND	#0111110000000000B
		CLC
		ADC	#0011100000000000B
		CMP	#0111110000000000B
		BCC	THCG460		;
;					;
		LDA	#0111110000000000B
THCG460		EQU	$
		ORA	<WORK2
		ORA	<WORK4
		RTS
;
;
;// 03.06.10 //		LDX	#00001H
;// 03.06.10 //		LDY	#00016H
;// 03.06.10 //		BRA	THCG000
;
;
		MEM8
		IDX8
;************************************************************************
;*		Thunder CG. change			(THCGCN1)	*
;************************************************************************
THCGCN1		EQU	$
		MEM16
		REP	#00100000B	; index 16bit mode
;
		LDX	#000H
THCG120		EQU	$
		LDA	>CGRAM+040H,X
		STA	>CGWORK+040H,X
		LDA	>CGRAM+050H,X
		STA	>CGWORK+050H,X
		LDA	>CGRAM+060H,X
		STA	>CGWORK+060H,X
		LDA	>CGRAM+070H,X
		STA	>CGWORK+070H,X
		LDA	>CGRAM+080H,X
		STA	>CGWORK+080H,X
		LDA	>CGRAM+090H,X
		STA	>CGWORK+090H,X
		LDA	>CGRAM+0A0H,X
		STA	>CGWORK+0A0H,X
		LDA	>CGRAM+0B0H,X
		STA	>CGWORK+0B0H,X
		LDA	>CGRAM+0C0H,X
		STA	>CGWORK+0C0H,X
		LDA	>CGRAM+0D0H,X
		STA	>CGWORK+0D0H,X
		LDA	>CGRAM+0E0H,X
		STA	>CGWORK+0E0H,X
		LDA	>CGRAM+0F0H,X
		STA	>CGWORK+0F0H,X
;
;// 03.06.10 //		LDA	>CGRAM+160H,X
;// 03.06.10 //		JSR	THCG400
;// 03.06.10 //		STA	>CGWORK+160H,X
;// 03.06.10 //		LDA	>CGRAM+180H,X
;// 03.06.10 //		JSR	THCG400
;// 03.06.10 //		STA	>CGWORK+180H,X
;// 03.06.10 //		LDA	>CGRAM+1A0H,X
;// 03.06.10 //		JSR	THCG400
;// 03.06.10 //		STA	>CGWORK+1A0H,X
;// 03.06.10 //		LDA	>CGRAM+1F0H,X
;// 03.06.10 //		JSR	THCG400
;// 03.06.10 //		STA	>CGWORK+1F0H,X
		INX
		INX
		CPX	#010H
		BNE	THCG120		; BG. CG. set end ?
;					; yes
;// 03.06.10 //		LDX	#00002H
;// 03.06.10 //		LDY	#00017H
;// 03.06.10 //THCG000		EQU	$
;// 03.06.10 //		PHY			; (Y) push
;// 03.06.10 //;
;// 03.06.10 //		LDA	>CGLPT3,X
;// 03.06.10 //		AND	#000FFH
;// 03.06.10 //		CLC
;// 03.06.10 //		ADC	#TOKUSYU
;// 03.06.10 //		STA	<WORK0
;// 03.06.10 //		PHA			; (A) push
;// 03.06.10 //;
;// 03.06.10 //		LDX	#00200H
;// 03.06.10 //		LDY	#00007H
;// 03.06.10 //THCG060		EQU	$
;// 03.06.10 //		LDA	[<WORK0]
;// 03.06.10 //		STA	>CHGRAM+040H,X
;// 03.06.10 //		STA	>CHGRAM+050H,X
;// 03.06.10 //		STA	>CHGRAM+060H,X
;// 03.06.10 //		STA	>CHGRAM+070H,X
;// 03.06.10 //		STA	>CHGRAM+080H,X
;// 03.06.10 //		STA	>CHGRAM+090H,X
;// 03.06.10 //		STA	>CHGRAM+0A0H,X
;// 03.06.10 //		STA	>CHGRAM+0B0H,X
;// 03.06.10 //		STA	>CHGRAM+0C0H,X
;// 03.06.10 //		STA	>CHGRAM+0D0H,X
;// 03.06.10 //		STA	>CHGRAM+0E0H,X
;// 03.06.10 //		STA	>CHGRAM+0F0H,X
;// 03.06.10 //		INC	<WORK0
;// 03.06.10 //		INC	<WORK0
;// 03.06.10 //		INX
;// 03.06.10 //		INX
;// 03.06.10 //		DEY
;// 03.06.10 //		BPL	THCG060		; BG. CG. set end ?
;// 03.06.10 //;					; yes
;// 03.06.10 //		PLA			; (A) pull
;// 03.06.10 //		CLC
;// 03.06.10 //		ADC	#00006H
;// 03.06.10 //		STA	<WORK0
;// 03.06.10 //		LDA	[<WORK0]
;// 03.06.10 //		STA	>CGWORK+000H
;// 03.06.10 //;
;// 03.06.10 //		PLY			; (Y) pull
;// 03.06.10 //		TYX			; (X) <-- (Y)
;// 03.06.10 //		LDA	>CGLPT71,X
;// 03.06.10 //		CLC
;// 03.06.10 //		ADC	#ENMYOBJ
;// 03.06.10 //		STA	<WORK0
;// 03.06.10 //;
;// 03.06.10 //		LDX	#00300H
;// 03.06.10 //		LDY	#00007H
;// 03.06.10 //THCG080		EQU	$
;// 03.06.10 //		LDA	[<WORK0]
;// 03.06.10 //		STA	>CHGRAM+060H,X
;// 03.06.10 //		STA	>CHGRAM+080H,X
;// 03.06.10 //		STA	>CHGRAM+0A0H,X
;// 03.06.10 //		STA	>CHGRAM+0F0H,X
;// 03.06.10 //		INC	<WORK0
;// 03.06.10 //		INC	<WORK0
;// 03.06.10 //		INX
;// 03.06.10 //		INX
;// 03.06.10 //		DEY
;// 03.06.10 //		BPL	THCG080		; BG. CG. set end ?
;// 03.06.10 //;					; yes
		LDA	>CGWORK+040H
		STA	>CGWORK+000H
;
;
		MEM8
		IDX8
		SEP	#00110000B	; memory 16bit mode
THCG160		EQU	$
		LDA	<GMMODE
		BNE	THCG180		; ground ?
;					; yes
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	#04020H
		STX	<WD2132R
		LDX	#08040H
		STX	<WD2132G
;
		LDX	#04F33H
		LDY	#0894FH
		LDA	<MPDTNO
		BEQ	THCG180		; mori ?
;					; no
		CMP	#040H
		BEQ	THCG180		; ura-mori ?
;					; no
		CMP	#05BH
		BEQ	THCG170		; piramido ?
;					; no
		LDX	#04C26H
		LDY	#08C4CH
		CMP	#003H
		BEQ	THCG170		; yama ?
;					; no
		CMP	#005H
		BEQ	THCG170		; yama ?
;					; no
		CMP	#007H
		BEQ	THCG170		; yama ?
;					; no
		LDX	#04A26H
		LDY	#0874AH
		CMP	#043H
		BEQ	THCG170		; yama ?
;					; no
		CMP	#045H
		BEQ	THCG170		; yama ?
;					; no
		CMP	#047H
		BNE	THCG180		; yama ?
;					; no
THCG170		EQU	$
		STX	<WD2132R
		STY	<WD2132G
THCG180		EQU	$
		IDX8
		SEP	#00010000B	; index 16bit mode
		RTL
;
;
; 
;************************************************************************
;*		Thunder CG. change			(THCGCN2)	*
;************************************************************************
THCGCN2		EQU	$
		MEM16
		REP	#00100000B	; index 16bit mode
;
		LDX	#07EH
THCG240		EQU	$
		LDA	>CGRAM+000H,X
		STA	>CGWORK+000H,X
		LDA	>CGRAM+080H,X
		STA	>CGWORK+080H,X
;// 03.06.10 //		LDA	>CGRAM+100H,X
;// 03.06.10 //		STA	>CGWORK+100H,X
;// 03.06.10 //		LDA	>CGRAM+180H,X
;// 03.06.10 //		STA	>CGWORK+180H,X
		DEX
		DEX
		BPL	THCG240		; reset end ?
;					; yes
		MEM8
		SEP	#00100000B	; memory 16bit mode
;
		INC	<CGVMAF		; CG. change
		JMP	THCG160
;
;
;
;
;
;
; 
; 
		END
		END
